const l=`{% block sw_select_selection_list %} <ul class="sw-select-selection-list"> {% block sw_select_selection_list_item %} <template v-if="!hideLabels"> <li v-for="(selection, index) in selections" :key="selection[valueProperty]" class="sw-select-selection-list__item-holder" :class="'sw-select-selection-list__item-holder--' + index" :data-id="selection[valueProperty]" > {% block sw_select_selection_list_item_inner %} <slot name="selected-option" v-bind="{ selection, defaultLabel: selection[labelProperty], disabled }" > <sw-label :dismissable="!isSelectionDisabled(selection)" :size="size" @dismiss="onClickDismiss(selection)" > {% block sw_select_selection_list_item_text %} <span class="sw-select-selection-list__item"> <slot name="label-property" v-bind="{ item: selection, index, labelProperty, valueProperty }" > {{ selection[labelProperty] }} </slot> </span> {% endblock %} </sw-label> </slot> {% endblock %} </li> </template> {% endblock %} {% block sw_select_selection_list_load_more %} <li v-if="invisibleCount > 0 && !hideLabels" class="sw-select-selection-list__load-more" > <slot name="invisible-count" v-bind="{ invisibleCount, onClickInvisibleCount }" > {% block sw_select_selection_list_load_more_item_button %} <mt-button class="sw-select-selection-list__load-more-button" variant="secondary" @click.stop="onClickInvisibleCount" > +{{ invisibleCount }} </mt-button> {% endblock %} </slot> </li> {% endblock %} {% block sw_select_selection_list_input %} <li class="sw-select-selection-list__input-wrapper"> <slot name="input" v-bind="{ placeholder, searchTerm, onSearchTermChange, onKeyDownDelete }" > <input ref="swSelectInput" class="sw-select-selection-list__input" type="text" role="combobox" :disabled="disabled" :readonly="!enableSearch" :placeholder="showPlaceholder" :value="searchTerm" :aria-label="inputLabel" @input="onSearchTermChange" @keydown.delete="onKeyDownDelete" @keydown.enter="onKeyDownEnter" > </slot> </li> {% endblock %} </ul> {% endblock %}`,t={template:l,inject:["feature"],emits:["total-count-click","search-term-change","last-item-delete","key-down-enter","item-remove"],props:{selections:{type:Array,required:!1,default:()=>[]},labelProperty:{type:String,required:!1,default:"label"},valueProperty:{type:String,required:!1,default:"value"},enableSearch:{type:Boolean,required:!1,default:!0},invisibleCount:{type:Number,required:!1,default:0},size:{type:String,required:!1,default:null},alwaysShowPlaceholder:{type:Boolean,required:!1,default:!1},placeholder:{type:String,required:!1,default:""},isLoading:{type:Boolean,required:!1,default:!1},searchTerm:{type:String,required:!1,default:""},disabled:{type:Boolean,required:!1,default:!1},selectionDisablingMethod:{type:Function,required:!1,default:()=>!1},hideLabels:{type:Boolean,required:!1,default:!1},inputLabel:{type:String,required:!1,default:void 0}},computed:{showPlaceholder(){return this.alwaysShowPlaceholder||this.selections.length===0||this.hideLabels?this.placeholder:""}},methods:{isSelectionDisabled(e){return this.disabled?!0:this.selectionDisablingMethod(e)},onClickInvisibleCount(){this.$emit("total-count-click")},onSearchTermChange(e){this.$emit("search-term-change",e.target.value,e)},onKeyDownDelete(){this.searchTerm.length<1&&this.$emit("last-item-delete")},onKeyDownEnter(){this.$emit("key-down-enter")},onClickDismiss(e){this.$emit("item-remove",e)},focus(){this.$refs.swSelectInput.focus()},blur(){this.$refs.swSelectInput.blur()},select(){this.$refs.swSelectInput.select()},getFocusEl(){return this.$refs.swSelectInput}}};export{t as default};
