const r=`{% block sw_settings_search_excluded_search_terms %} <mt-card :title="$tc('sw-settings-search.generalTab.labelExcludedSearchTerms')" class="sw-settings-search-excluded-search-terms" position-identifier="sw-settings-search-excluded-search-terms" > <template #grid> {% block sw_settings_search_excluded_search_terms_empty_state %} <sw-empty-state v-if="showEmptyState" :title="$tc('sw-settings-search.generalTab.textEmptyStateExcludedSearchTerms')" :show-description="false" :has-action-slot="true" :absolute="false" class="sw-empty-state" > <template #icon> {% block sw_settings_search_excluded_search_terms_empty_state_image %} <img :src="assetFilter('administration/administration/static/img/empty-states/settings-empty-state.svg')" :alt="$tc('sw-settings-search.generalTab.textEmptyStateExcludedSearchTerms')" > {% endblock %} </template> <template #actions> {% block sw_settings_search_excluded_search_terms_empty_state_action %} <mt-button class="sw-settings-search-excluded-search-terms__action-add" ghost size="small" :disabled="!acl.can('product_search_config.creator')" variant="secondary" @click="addExcludedSearchTerms" > {{ $tc('sw-settings-search.generalTab.buttonAddExcludedSearch') }} </mt-button> {% endblock %} </template> </sw-empty-state> {% endblock %} {% block sw_settings_search_excluded_search_terms_grid %} <div v-if="!showEmptyState"> {% block sw_settings_search_excluded_search_terms_header_bar %} <sw-container class="sw-settings-search-excluded-search-terms__header-bar" columns="1fr auto" gap="10px" align="center" > {% block sw_settings_search_excluded_search_terms_filter %} <sw-card-filter ref="itemFilter" :placeholder="$tc('sw-settings-search.generalTab.textPlaceholderTermsFilter')" @sw-card-filter-term-change="onSearchTermChange" /> {% endblock %} {% block sw_settings_search_excluded_search_terms_actions %} <div class="sw-settings-search-excluded-search-terms-group-actions"> {% block sw_settings_search_excluded_search_terms_add_button %} <mt-button class="sw-settings-search-excluded-search-terms__insert-button" ghost size="small" :disabled="!acl.can('product_search_config.creator')" variant="secondary" @click="onInsertTerm" > {{ $tc('sw-settings-search.generalTab.buttonAddExcludedSearchTerms') }} </mt-button> {% endblock %} {% block sw_settings_search_excluded_search_terms_reset_button %} <mt-button class="sw-settings-search-excluded-search-terms__reset-button" size="small" :disabled="!acl.can('product_search_config.creator')" :is-loading="isLoading" variant="secondary" @click="onResetExcludedSearchTermDefault" > {{ $tc('sw-settings-search.generalTab.buttonResetDefault') }} </mt-button> {% endblock %} </div> {% endblock %} </sw-container> {% endblock %} {% block sw_settings_search_excluded_search_terms_grid_list %} <sw-container> <sw-data-grid v-if="items.length !== 0" ref="dataGrid" :data-source="items" :allow-inline-edit="acl.can('product_search_config.editor')" :is-loading="isLoading || isExcludedTermsLoading" :columns="getSearchableGeneralColumns" class="sw-settings-search__grid sw-settings-search-excluded-search-terms_grid" @inline-edit-save="onSaveEdit" @inline-edit-cancel="onCancelEdit" @select-item="selectionChanged" > <template #bulk> <mt-button variant="critical" size="small" :disabled="!acl.can('product_search_config.deleter')" @click="onBulkDeleteExcludedTerm()" > {{ $tc('global.default.delete') }} </mt-button> </template> <template #actions="{ item }"> {% block sw_search_excluded_terms_column_actions %} <sw-context-menu-item variant="danger" :disabled="!acl.can('product_search_config.deleter')" @click="onDeleteExcludedTerm([item])" > {{ $tc('global.default.delete') }} </sw-context-menu-item> {% endblock %} </template> <template #pagination> {% block sw_search_excluded_terms_list_pagination %} <sw-pagination :page="page" :limit="limit" :total="total" :total-visible="7" @page-change="onPagePagination" /> {% endblock %} </template> </sw-data-grid> {% block sw_search_excliuded_terms_no_results %} <div v-if="items.length === 0"> <p class="sw-settings-search__no-data-results"> {{ $tc('sw-settings-search.generalTab.labelExcludedSearchTermsNoResults') }} </p> </div> {% endblock %} </sw-container> {% endblock %} </div> {% endblock %} </template> </mt-card> {% endblock %}`,{Mixin:n}=Shopware,c={template:r,inject:["excludedSearchTermService","repositoryFactory","acl"],emits:["edit-change","data-load"],mixins:[n.getByName("notification")],props:{searchConfigs:{type:Object,required:!1,default:null},isExcludedTermsLoading:{type:Boolean,required:!1,default:!1}},data(){return{items:[],originalItems:[],showEmptyState:!1,page:1,limit:10,total:0,searchTerm:"",isLoading:!1,isAddingItem:!1,responseMessage:""}},computed:{searchRepository(){return this.repositoryFactory.create("product_search_config")},getSearchableGeneralColumns(){return[{property:"value",label:"sw-settings-search.generalTab.textColumnSearchTerm",inlineEdit:"string",sortable:!1}]},assetFilter(){return Shopware.Filter.getByName("asset")}},watch:{searchConfigs(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){if(this.isLoading=!0,this.searchConfigs.excludedTerms===void 0||this.searchConfigs.excludedTerms===null||this.searchConfigs.excludedTerms.length<=0){this.resetData(),this.showEmptyState=!0,this.isLoading=!1;return}this.originalItems=this.searchConfigs.excludedTerms,this.renderComponent()},resetData(){this.originalItems=[],this.items=[],this.page=1,this.total=0},addExcludedSearchTerms(){this.showEmptyState=!1},onInsertTerm(){this.isAddingItem=!0,this.searchTerm="",this.$refs.itemFilter.term="",this.page=1,this.renderComponent(),this.items.unshift({id:null,value:""}),this.$refs.dataGrid.onDbClickCell(this.items[0]),this.$emit("edit-change",!0)},renderComponent(){if(this.originalItems.length<=0){this.isLoading=!1,this.items=[];return}const e=this.filterItems();if(this.total=e.length,this.total<=0){this.items=[],this.showEmptyState=!1,this.isLoading=!1;return}this.items=this.sliceItems(e),this.items.length<=0&&(this.page-=1,this.renderComponent()),this.showEmptyState=!1,this.isLoading=!1},filterItems(){return this.originalItems.filter(e=>e.search(this.searchTerm)>=0)},sliceItems(e){const t=(this.page-1)*this.limit;return e.slice(t,t+this.limit).map((s,i)=>({id:i,value:s}))},onPagePagination(e){this.page=e.page,this.limit=e.limit,this.isAddingItem=!1,this.renderComponent()},onDeleteExcludedTerm(e){this.responseMessage=this.$tc("sw-settings-search.notification.deleteExcludedTermSuccess"),this.isLoading=!0;const t=e.filter(s=>s.value!=="").map(s=>s.value);if(t.length<=0){this.renderComponent();return}this.originalItems=this.originalItems.filter(s=>!t.find(i=>i===s)),this.saveConfig()},onSearchTermChange(e){this.page=1,this.searchTerm=e,!(e===""&&this.isAddingItem)&&(this.isAddingItem=!1,this.renderComponent())},selectionChanged(e){this.selection=e},onSaveEdit(e){if(this.isLoading=!0,e.value===""){this.createNotificationError({message:this.$tc("sw-settings-search.notification.excludedTermRequired")}),this.renderComponent();return}const t=this.getOriginItem(e);if(this.originalItems.find(i=>i===e.value&&i!==t)){this.createNotificationError({message:this.$tc("sw-settings-search.notification.excludedTermAlreadyExists")}),this.renderComponent();return}if(this.isAddingItem){this.responseMessage=this.$tc("sw-settings-search.notification.createExcludedTermSuccess"),this.originalItems.unshift(e.value),this.saveConfig();return}this.responseMessage=this.$tc("sw-settings-search.notification.updateExcludedTermSuccess"),this.originalItems[e.id]=e.value,this.saveConfig()},getOriginItem(e){const t=this.filterItems(),i=this.sliceItems(t).find(a=>a.id===e.id);return i?i.value:null},onCancelEdit(){this.renderComponent(),this.$emit("edit-change",!1)},onBulkDeleteExcludedTerm(){this.onDeleteExcludedTerm(Object.values(this.selection))},saveConfig(){return this.searchConfigs.excludedTerms=this.originalItems,this.searchRepository.save(this.searchConfigs).then(()=>{this.createNotificationSuccess({message:this.responseMessage}),this.isAddingItem=!1,this.renderComponent(),this.$emit("edit-change",!1)}).catch(e=>{this.createNotificationError({message:e})}).finally(()=>{this.isLoading=!1})},onResetExcludedSearchTermDefault(){this.excludedSearchTermService.resetExcludedSearchTerm().then(()=>{this.createNotificationSuccess({message:this.$tc("sw-settings-search.notification.resetToDefaultExcludedTermSuccess")}),this.$emit("data-load")}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-search.notification.resetToDefaultExcludedTermError")})})}}};export{c as default};
