const c=`{% block sw_maintain_currencies_modal %} <sw-modal class="sw-maintain-currencies-modal" :title="$tc('sw-maintain-currencies-modal.title')" @modal-close="onCancel" > {% block sw_maintain_currencies_modal_grid %} <sw-data-grid :data-source="currencyCollection" :columns="maintainCurrencyColumns" :show-selection="false" :compact-mode="false" :show-actions="false" > {% block sw_maintain_currencies_modal_grid_column_name %} <template #column-name="{ item }" > {% block sw_maintain_currencies_modal_grid_column_name_inherit_field %} <sw-inheritance-switch v-if="!item.isSystemDefault" class="sw-price-form__inherited-icon" :is-inherited="isCurrencyInherited(item)" @inheritance-restore="onInheritanceRestore(item.id)" @inheritance-remove="onInheritanceRemove(item)" /> {% endblock %} {% block sw_maintain_currencies_modal_grid_column_name_item_name %} <p>{{ item.translated.name || item.name }}</p> {% endblock %} </template> {% endblock %} {% block sw_maintain_currencies_modal_grid_column_price %} <template #column-label-price> {% block sw_maintain_currencies_modal_grid_column_price_field_label %} <div class="sw-maintain-currencies-modal__price-label-wrapper"> <div class="sw-maintain-currencies-modal__price-label"> {{ $tc('sw-maintain-currencies-modal.columnPrice') }} </div> <div v-if="!hideListPrices" class="sw-maintain-currencies-modal__list-price-label" > {{ $tc('sw-maintain-currencies-modal.columnListPriceHeader') }} </div> <div v-if="!hideRegulationPrices" class="sw-maintain-currencies-modal__reference-price-label" > {{ $tc('sw-maintain-currencies-modal.columnReferencePriceHeader') }} </div> </div> {% endblock %} </template> <template #column-price="{ item }" > {% block sw_maintain_currencies_modal_grid_column_price_field %} <sw-list-price-field :price="prices" :default-price="defaultPrice" :tax-rate="taxRate" :label="false" :disable-suffix="true" :hide-list-prices="hideListPrices" :hide-regulation-prices="hideRegulationPrices" hide-purchase-prices :disabled="disabled" enable-inheritance :currency="item" /> {% endblock %} </template> {% endblock %} </sw-data-grid> {% endblock %} {% block sw_maintain_currencies_modal_footer %} <template #modal-footer> {% block sw_maintain_currencies_modal_footer_button_cancel %} <mt-button size="small" variant="secondary" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_maintain_currencies_modal_footer_button_apply %} <mt-button variant="primary" size="small" @click="onApply" > {{ $tc('global.default.apply') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %}`,{Criteria:n}=Shopware.Data,a={template:c,inject:["repositoryFactory"],emits:["update-prices","modal-close"],props:{currencies:{type:Array,default(){return[]},required:!1},prices:{type:Array,required:!0},defaultPrice:{type:Object,required:!0},taxRate:{type:Object,required:!0},hideListPrices:{required:!1,default:!1},hideRegulationPrices:{type:Boolean,required:!1,default:!1},disabled:{type:Boolean,required:!1,default:!1}},data(){return{currencyCollection:[],clonePrices:null}},computed:{maintainCurrencyColumns(){return[{property:"name",label:"",visible:!0,allowResize:!1,primary:!0,rawData:!1,width:"150px"},{property:"price",label:"sw-maintain-currencies-modal.columnPrice",visible:!0,allowResize:!1,primary:!0,rawData:!1}]}},watch:{currencies:function(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){this.currencies.length>0?this.updateCurrencyCollectionFromCurrencies():this.loadCurrencies(),this.clonePrices=Shopware.Utils.object.cloneDeep(this.prices)},loadCurrencies(){this.repositoryFactory.create("currency").search(new n(1,25)).then(e=>{this.currencyCollection=e,this.sortCurrencies()})},updateCurrencyCollectionFromCurrencies(){this.currencyCollection.length>0?this.currencies.every(i=>this.currencyCollection.some(r=>i.id===r.id))||(this.currencyCollection=this.currencies,this.sortCurrencies()):(this.currencyCollection=this.currencies,this.sortCurrencies())},sortCurrencies(){this.currencyCollection.sort((e,i)=>e.isSystemDefault?-1:i.isSystemDefault?1:e.translated.name<i.translated.name?-1:e.translated.name>i.translated.name?1:0)},convertPrice(e,i){const t=(e*i.factor).toFixed(i.decimalPrecision);return Number(t)},isCurrencyInherited(e){return!this.prices.find(r=>r.currencyId===e.id)},onInheritanceRestore(e){const i=this.prices.findIndex(r=>r.currencyId===e);this.$emit("update-prices",i),this.createdComponent()},onInheritanceRemove(e){const i={currencyId:e.id,gross:this.convertPrice(this.defaultPrice.gross,e),linked:this.defaultPrice.linked,net:this.convertPrice(this.defaultPrice.net,e),listPrice:null};this.defaultPrice.listPrice&&(i.listPrice={currencyId:e.id,gross:this.convertPrice(this.defaultPrice.listPrice.gross,e),linked:this.defaultPrice.listPrice.linked,net:this.convertPrice(this.defaultPrice.listPrice.net,e)}),this.prices[this.prices.length]=i,this.createdComponent()},onCancel(){this.$emit("modal-close",this.clonePrices)},onApply(){this.$emit("modal-close",this.prices)}}};export{a as default};
