const i=`{% block sw_settings_rule_detail_base %} <div class="sw-settings-rule-detail-base"> {% block sw_settings_rule_detail_base_content_card %} <mt-card position-identifier="sw-settings-rule-detail-base-content" :large="true" :is-loading="isLoading" :title="$tc('sw-settings-rule.detail.titleCard')" > <template v-if="rule"> <div style="display: grid; grid-template-columns: 2fr 1fr; grid-column-gap: 32px"> {% block sw_settings_rule_detail_base_content_card_field_name %} <mt-text-field v-model="rule.name" name="sw-field--rule-name" :label="$tc('sw-settings-rule.detail.labelName')" :placeholder="$tc('sw-settings-rule.detail.placeholderName')" :error="ruleNameError" :disabled="!acl.can('rule.editor') || undefined" required /> {% endblock %} {% block sw_settings_rule_detail_base_content_card_field_priority %} <mt-number-field v-model="rule.priority" name="sw-field--rule-priority" :label="$tc('sw-settings-rule.detail.labelPriority')" :placeholder="$tc('sw-settings-rule.detail.placeholderPriority')" :error="rulePriorityError" :disabled="!acl.can('rule.editor') || undefined" :step="1" :min="0" number-type="int" required /> {% endblock %} </div> {% block sw_settings_rule_detail_base_content_card_field_description %} <mt-textarea v-model="rule.description" name="sw-field--rule-description" :label="$tc('sw-settings-rule.detail.labelDescription')" :placeholder="$tc('sw-settings-rule.detail.placeholderDescription')" :disabled="!acl.can('rule.editor') || undefined" /> {% endblock %} <div style="display: grid; grid-template-columns: 1fr 1fr; grid-column-gap: 32px"> {% block sw_settings_rule_detail_base_content_card_field_type %} <sw-multi-select v-if="rule" v-model:value="moduleTypes" name="sw-field--moduleTypes" class="sw-settings-rule-detail__type-field" value-property="id" label-property="name" :label="$tc('sw-settings-rule.detail.labelType')" :disabled="!acl.can('rule.editor') || undefined" :options="availableModuleTypes" > <template #selection-label-property="{ item }"> {{ $tc(item.name) }} </template> <template #result-label-property="{ item }"> {{ $tc(item.name) }} </template> </sw-multi-select> {% endblock %} {% block sw_settings_rule_detail_base_content_card_field_tags %} <sw-entity-tag-select v-if="rule" v-model:entity-collection="rule.tags" name="sw-field--rule-tags" class="sw-settings-rule-detail__tags-field" :label="$tc('global.sw-tag-field.title')" :disabled="!acl.can('rule.editor') || undefined" :placeholder="$tc('sw-settings-rule.detail.placeholderTags')" /> {% endblock %} </div> </template> <sw-loader v-else /> </mt-card> {% endblock %} {% block sw_settings_rule_detail_base_conditions_card %} <mt-card class="sw-settings-rule-detail__condition_container" position-identifier="sw-settings-rule-detail-base-conditions" :large="true" :is-loading="isLoading" :title="$tc('sw-settings-rule.detail.ruleCard')" > <template #headerRight> <sw-extension-teaser-popover position-identifier="sw-settings-rule-preview-mode-switch" /> </template> <div v-if="showProductStreamIndexingWarning" class="sw-settings-rule-detail-base__product-stream-warning" > <mt-banner variant="attention" :title="$tc('sw-settings-rule.detail.productStreamIndexingWarning.title')" > <p> {{ $tc('sw-settings-rule.detail.productStreamIndexingWarning.message') }} </p> <mt-link type="external" as="a" href="https://developer.shopware.com/docs/guides/hosting/performance/performance-tweaks.html#disable-product-stream-indexer" target="_blank" > {{ $tc('sw-settings-rule.detail.productStreamIndexingWarning.action') }} </mt-link> </mt-banner> </div> <sw-condition-tree :initial-conditions="conditions" :condition-repository="conditionRepository" :condition-data-provider-service="ruleConditionDataProviderService" association-field="ruleId" :association-value="rule.id" :association-entity="rule" :root-condition="null" :disabled="!acl.can('rule.editor') || undefined" @conditions-changed="$emit('conditions-changed', $event)" @initial-loading-done="$emit('tree-finished-loading')" /> </mt-card> {% endblock %} {% block sw_settings_rule_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-rule-detail-base-custom-field-sets" :large="true" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="rule" :disabled="!acl.can('rule.editor') || undefined" :sets="customFieldSets" /> </mt-card> {% endblock %} </div> {% endblock %}`,l=["cartLineItemInProductStream"],r={template:i,inject:["ruleConditionDataProviderService","acl","customFieldDataProviderService"],emits:["conditions-changed","tree-finished-loading"],props:{rule:{type:Object,required:!0},conditions:{type:Array,required:!1,default:null},conditionRepository:{type:Object,required:!0},isLoading:{type:Boolean,required:!0},ruleNameError:{type:Object,required:!1,default:null},rulePriorityError:{type:Object,required:!1,default:null}},data(){return{currentConditions:null,customFieldSets:null}},computed:{availableModuleTypes(){return this.ruleConditionDataProviderService.getModuleTypes()},moduleTypes:{get(){var e,t;return((t=(e=this.rule)==null?void 0:e.moduleTypes)==null?void 0:t.types)??[]},set(e){if(e.length===0){this.rule.moduleTypes=null;return}this.rule.moduleTypes={types:e}}},showCustomFields(){return this.rule&&this.customFieldSets&&this.customFieldSets.length>0},productStreamIndexingEnabled(){return Shopware.Context.app.productStreamIndexingEnabled??!0},showProductStreamIndexingWarning(){return this.productStreamIndexingEnabled===!1&&this.conditions&&this.hasProductStreamConditions(this.conditions)}},created(){this.createdComponent()},methods:{createdComponent(){this.loadCustomFieldSets()},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("rule").then(e=>{this.customFieldSets=e})},hasProductStreamConditions(e){return e.some(t=>l.includes(t.type)?!0:t.children&&Array.isArray(t.children)&&this.hasProductStreamConditions(t.children))}}};export{r as default};
