const n=`{% block sw_settings_customer_group_detail %} <sw-page class="sw-settings-customer-group-detail"> {% block sw_settings_customer_group_detail_search_bar %} <template #search-bar></template> {% endblock %} {% block sw_settings_customer_group_detail_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_customer_group_detail_smart_bar_header_title %} <h2> {% block sw_settings_customer_group_detail_smart_bar_header_title_text %} {{ placeholder(customerGroup, 'name', $tc('sw-settings-customer-group.detail.placeholderNewCustomerGroup')) }} {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_customer_group_detail_language_switch %} <template #language-switch> <sw-language-switch :disabled="customerGroupId == null" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_customer_group_detail_actions %} <template #smart-bar-actions> {% block sw_settings_customer_group_detail_actions_cancel %} <mt-button v-tooltip.bottom="tooltipCancel" class="sw-settings-customer-group-detail__cancel" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_customer_group_detail_actions_save %} <sw-button-process v-model:process-success="isSaveSuccessful" v-tooltip.bottom="tooltipSave" class="sw-settings-customer-group-detail__save" variant="primary" :is-loading="isLoading" :disabled="!allowSave || undefined" @click="onSave" > {{ $tc('sw-settings-customer-group.general.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_customer_group_detail_cardview %} <template #content> <sw-card-view> <sw-skeleton v-if="isLoading" /> <template v-else> {% block sw_settings_customer_group_detail_content_language_info %} <sw-language-info :entity-description="entityDescription" /> {% endblock %} {% block sw_settings_customer_group_detail_content_card %} <mt-card :is-loading="isLoading" :title="$tc('sw-settings-customer-group.detail.cardTitle')" position-identifier="sw-settings-customer-group-detail-content" > <template v-if="!isLoading"> <sw-container columns="repeat(2, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_settings_customer_group_detail_content_card_name %} <mt-text-field v-model="customerGroup.name" name="sw-field--customerGroup-name" class="sw-settings-customer-group-detail__name" required validation="required" :label="$tc('sw-settings-customer-group.detail.fieldNameLabel')" :error="customerGroupNameError" :placeholder="placeholder(customerGroup, 'name', $tc('sw-settings-customer-group.detail.placeholderName'))" :disabled="!acl.can('customer_groups.editor') || undefined" /> {% endblock %} {% block sw_settings_customer_group_detail_content_card_display_gross %} <sw-boolean-radio-group v-model:value="customerGroup.displayGross" bordered :label="$tc('sw-settings-customer-group.detail.fieldDisplayGrossLabel')" :label-option-true="$tc('sw-settings-customer-group.detail.fieldDisplayGrossValues', {}, 1)" :label-option-false="$tc('sw-settings-customer-group.detail.fieldDisplayGrossValues', {}, 0)" :disabled="!acl.can('customer_groups.editor') || undefined" /> {% endblock %} {% block sw_settings_customer_group_detail_content_card_registration_form %} <mt-switch v-model="customerGroup.registrationActive" name="sw-field--customerGroup-registrationActive" class="sw-settings-customer-group-detail__registration-form-switch" :label="$tc('sw-settings-customer-group.detail.registrationForm')" :disabled="!acl.can('customer_groups.editor') || undefined" /> {% endblock %} </sw-container> </template> </mt-card> {% endblock %} {% block sw_settings_customer_group_detail_content_registration_card %} <mt-card v-if="customerGroup && customerGroup.registrationActive" position-identifier="sw-settings-customer-group-detail-content-registration-card" :is-loading="isLoading" :title="$tc('sw-settings-customer-group.registration.formTitle')" > <div class="sw-settings-customer-group-detail-content-registration-card__info-text"> {{ $tc('sw-settings-customer-group.registration.infoText') }} </div> {% block sw_settings_customer_group_detail_content_registration_card_title %} <mt-text-field v-model="customerGroup.registrationTitle" name="sw-field--customerGroup-registrationTitle" required validation="required" :label="$tc('sw-settings-customer-group.registration.title')" :placeholder="placeholder(customerGroup, 'registrationTitle', $tc('sw-settings-customer-group.registration.placeholderTitle'))" :error="registrationTitleError" :disabled="!acl.can('customer_groups.editor') || undefined" /> {% endblock %} {% block sw_settings_customer_group_detail_content_registration_card_introduction %} <sw-text-editor v-if="!feature.isActive('METEOR_TEXT_EDITOR')" v-model:value="customerGroup.registrationIntroduction" :label="$tc('sw-settings-customer-group.registration.introduction')" :placeholder="placeholder(customerGroup, 'registrationIntroduction', $tc('sw-settings-customer-group.registration.placeholderIntroduction'))" :disabled="!acl.can('customer_groups.editor') || undefined" sanitize-input sanitize-field-name="customer_group_translation.registrationIntroduction" /> <mt-text-editor v-else v-model="customerGroup.registrationIntroduction" :label="$tc('sw-settings-customer-group.registration.introduction')" :placeholder="placeholder(customerGroup, 'registrationIntroduction', $tc('sw-settings-customer-group.registration.placeholderIntroduction'))" :disabled="!acl.can('customer_groups.editor') || undefined" sanitize-input sanitize-field-name="customer_group_translation.registrationIntroduction" /> {% endblock %} {% block sw_settings_customer_group_detail_content_registration_card_seo_meta_description %} <mt-textarea v-model="customerGroup.registrationSeoMetaDescription" name="sw-field--customerGroup-registrationSeoMetaDescription" :label="$tc('sw-settings-customer-group.registration.seoMetaDescription')" :placeholder="placeholder(customerGroup, 'registrationSeoMetaDescription', $tc('sw-settings-customer-group.registration.placeholderSeoMetaDescription'))" :disabled="!acl.can('customer_groups.editor') || undefined" /> {% endblock %} {% block sw_settings_customer_group_detail_content_registration_card_only_companies_can_register %} <mt-switch v-model="customerGroup.registrationOnlyCompanyRegistration" name="sw-field--customerGroup-registrationOnlyCompanyRegistration" class="sw-settings-customer-group-detail__registration-only-companies-can-register" :label="$tc('sw-settings-customer-group.registration.onlyCompaniesCanRegister')" :help-text="$tc('sw-settings-customer-group.registration.onlyCompaniesCanRegisterHelpText')" :disabled="!acl.can('customer_groups.editor') || undefined" /> {% endblock %} </mt-card> {% endblock %} {% block sw_settings_customer_group_detail_content_registration_url_card %} <mt-card v-if="customerGroup && customerGroup.registrationActive" position-identifier="sw-settings-customer-group-detail-content-registration-url-card" :is-loading="isLoading" :title="$tc('sw-settings-customer-group.registration.linkUrlsTitle')" > {% block sw_settings_customer_group_detail_content_registration_url_card_sales_channel %} <sw-entity-multi-select v-model:entity-collection="customerGroup.registrationSalesChannels" name="sw-field--customerGroup-registrationSalesChannels" class="sw-settings-customer-group-detail__sales-channel" :label="$tc('sw-settings-customer-group.registration.availabilitySalesChannel')" :disabled="!acl.can('customer_groups.editor') || undefined" :criteria="registrationSalesChannelCriteria" /> {% endblock %} {% block sw_settings_customer_group_detail_content_registration_technical_urls %} <mt-text-field v-if="customerGroupId" v-model="technicalUrl" name="sw-field--technicalUrl" :label="$tc('sw-settings-customer-group.registration.technicalUrl')" :copyable="true" :disabled="true" :help-text="$tc('sw-settings-customer-group.registration.technicalUrlHelpText')" /> {% endblock %} <mt-banner v-if="customerGroup.registrationSalesChannels?.length > 0" variant="info" > {{ $t('sw-settings-customer-group.registration.domainBanner') }} </mt-banner> {% block sw_settings_customer_group_detail_content_registration_url_card_seo_url %} <template v-for="salesChannel in customerGroup.registrationSalesChannels"> <template v-for="domain in salesChannel.domains"> <template v-for="seoUrl in salesChannel.seoUrls"> <template v-if="domain.languageId === seoUrl.languageId"> {% block sw_settings_customer_group_detail_content_registration_url_card_seo_url_inner %} <mt-text-field :key="\`\${seoUrl.id}-\${domain.id}\`" :model-value="\`\${domain.url}/\${seoUrl.seoPathInfo}\`" :label="$tc('sw-settings-customer-group.registration.seoUrlLabel', { salesChannelName: salesChannel.translated.name, languageName: seoUrl.language.name })" :copyable="true" :disabled="true" /> {% endblock %} </template> </template> </template> </template> {% endblock %} </mt-card> {% endblock %} {% block sw_settings_customer_group_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-customer-group-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="customerGroup" :disabled="!acl.can('customer_groups.editor')" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:o}=Shopware,{Criteria:t}=Shopware.Data,{mapPropertyErrors:l}=Shopware.Component.getComponentHelper(),{ShopwareError:c}=Shopware.Classes,u=Shopware.Utils.types,d={template:n,inject:["repositoryFactory","acl","customFieldDataProviderService","feature"],mixins:[o.getByName("notification"),o.getByName("placeholder"),o.getByName("discard-detail-page-changes")("customerGroup")],props:{customerGroupId:{type:String,required:!1,default:null}},shortcuts:{"SYSTEMKEY+S":{active(){return this.allowSave},method:"onSave"},ESCAPE:"onCancel"},data(){return{isLoading:!1,customerGroup:null,isSaveSuccessful:!1,openSeoModal:!1,registrationTitleError:null,seoUrls:[],customFieldSets:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.placeholder(this.customerGroup,"name","")},customerGroupRepository(){return this.repositoryFactory.create("customer_group")},seoUrlRepository(){return this.repositoryFactory.create("seo_url")},customerGroupCriteria(){const e=new t(1,1);return e.addAssociation("registrationSalesChannels").getAssociation("registrationSalesChannels").addAssociation("domains").addAssociation("seoUrls"),e.getAssociation("registrationSalesChannels").getAssociation("seoUrls").addFilter(t.equals("pathInfo",`/customer-group-registration/${this.customerGroupId}`)).addFilter(t.equals("isCanonical",!0)).addAssociation("language"),e},registrationSalesChannelCriteria(){const e=new t(1,25);return e.addAssociation("domains").addAssociation("seoUrls").getAssociation("seoUrls").addFilter(t.equals("pathInfo",`/customer-group-registration/${this.customerGroupId}`)).addFilter(t.equals("isCanonical",!0)).addAssociation("language"),e},seoUrlCriteria(){var s,r,i;const e=new t(1,25);if((r=(s=this.customerGroup)==null?void 0:s.registrationSalesChannels)!=null&&r.length){const a=(i=this.customerGroup.registrationSalesChannels)==null?void 0:i.getIds();e.addFilter(t.equalsAny("salesChannelId",a))}return e.addFilter(t.equals("pathInfo",`/customer-group-registration/${this.customerGroupId}`)),e.addFilter(t.equals("languageId",Shopware.Context.api.languageId)),e.addFilter(t.equals("isCanonical",!0)),e.addAssociation("salesChannel.domains"),e.addGroupField("seoPathInfo"),e.addGroupField("salesChannelId"),e},entityDescription(){return this.placeholder(this.customerGroup,"name",this.$tc("sw-settings-customer-group.detail.placeholderNewCustomerGroup"))},tooltipSave(){return this.allowSave?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.allowSave,showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},hasRegistration:{get(){return this.customerGroup&&this.customerGroup.registration!==void 0},set(e){e?this.customerGroup.registration=this.customerGroupRegistrationRepository.create():this.customerGroup.registration=null}},technicalUrl(){return`<domain-url>/customer-group-registration/${this.customerGroupId}#`},...l("customerGroup",["name"]),allowSave(){return this.customerGroup&&this.customerGroup.isNew()?this.acl.can("customer_groups.creator"):this.acl.can("customer_groups.editor")},showCustomFields(){return this.customerGroup&&this.customFieldSets&&this.customFieldSets.length>0}},watch:{customerGroupId(){this.customerGroupId||this.createdComponent()},"customerGroup.registrationTitle"(){this.registrationTitleError=null}},created(){this.createdComponent()},methods:{createdComponent(){if(this.isLoading=!0,!this.customerGroupId){this.createNotificationError({message:this.$tc("global.notification.notificationLoadingDataErrorMessage")}),this.isLoading=!0;return}this.loadCustomFieldSets(),this.loadCustomerGroup()},async loadCustomerGroup(){this.isLoading=!0;try{this.customerGroup=await this.customerGroupRepository.get(this.customerGroupId,Shopware.Context.api,this.customerGroupCriteria)}finally{this.isLoading=!1}},async loadSeoUrls(){var e,s;if(!((s=(e=this.customerGroup)==null?void 0:e.registrationSalesChannels)!=null&&s.length)){this.seoUrls=[];return}this.seoUrls=await this.seoUrlRepository.search(this.seoUrlCriteria)},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("customer_group").then(e=>{this.customFieldSets=e})},onChangeLanguage(){this.createdComponent()},onCancel(){this.$router.push({name:"sw.settings.customer.group.index"})},getSeoUrl(e){let s="";return e.salesChannel.domains.forEach(r=>{r.languageId===e.languageId&&(s=r.url)}),`${s}/${e.seoPathInfo}`},validateSaveRequest(){return Shopware.Context.api.languageId===Shopware.Context.api.systemLanguageId&&this.customerGroup.registrationActive&&u.isEmpty(this.customerGroup.registrationTitle)?(this.createNotificationError({message:this.$tc("global.notification.notificationSaveErrorMessageRequiredFieldsInvalid")}),this.registrationTitleError=new c({code:"CUSTOMER_GROUP_REGISTERATION_MISSING_TITLE",detail:this.$tc("global.notification.notificationSaveErrorMessageRequiredFieldsInvalid")}),this.isLoading=!1,this.isSaveSuccessful=!1,!1):!0},async onSave(){if(this.isSaveSuccessful=!1,this.isLoading=!0,!!this.validateSaveRequest())try{await this.customerGroupRepository.save(this.customerGroup),this.isSaveSuccessful=!0}catch{this.createNotificationError({message:this.$tc("sw-settings-customer-group.detail.notificationErrorMessage")})}finally{this.isLoading=!1}}}};export{d as default};
