<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Cluster;

use OpenSearch\Common\Exceptions\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class PutDecommissionAwareness extends AbstractEndpoint
{
    protected $awareness_attribute_name;
    protected $awareness_attribute_value;

    public function getURI(): string
    {
        $awareness_attribute_name = $this->awareness_attribute_name ?? null;
        $awareness_attribute_value = $this->awareness_attribute_value ?? null;
        if (isset($awareness_attribute_name) && isset($awareness_attribute_value)) {
            return "/_cluster/decommission/awareness/$awareness_attribute_name/$awareness_attribute_value";
        }
        throw new RuntimeException('Missing parameter for the endpoint cluster.put_decommission_awareness');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setAwarenessAttributeName($awareness_attribute_name): PutDecommissionAwareness
    {
        if (isset($awareness_attribute_name) !== true) {
            return $this;
        }
        $this->awareness_attribute_name = $awareness_attribute_name;

        return $this;
    }

    public function setAwarenessAttributeValue($awareness_attribute_value): PutDecommissionAwareness
    {
        if (isset($awareness_attribute_value) !== true) {
            return $this;
        }
        $this->awareness_attribute_value = $awareness_attribute_value;

        return $this;
    }
}
