const n=`{% block sw_order_new_customer_modal %} <sw-modal :title="$tc('sw-order.createBase.detailsHeader.buttonAddNewCustomer')" @modal-close="onClose" > {% block sw_order_new_customer_modal_tabs %} <sw-tabs class="sw-order-new-customer-modal" position-identifier="sw-order-new-customer-modal" default-item="details" > <template #default="{ active }"> {% block sw_order_new_customer_modal_tabs_details %} <sw-tabs-item name="details" :active-tab="active" :has-error="swOrderNewCustomerDetailError" > {{ $tc('sw-order.newCustomerModal.labelDetails') }} </sw-tabs-item> {% endblock %} {% block sw_order_new_customer_modal_tabs_billing %} <sw-tabs-item name="billingAddress" :active-tab="active" :has-error="swOrderNewCustomerAddressError" > {{ $tc('sw-order.createBase.detailsBody.labelBillingAddress') }} </sw-tabs-item> {% endblock %} {% block sw_order_new_customer_modal_tabs_shipping %} <sw-tabs-item name="shippingAddress" :active-tab="active" :has-error="!isSameBilling && swOrderNewCustomerAddressError" > {{ $tc('sw-order.createBase.detailsBody.labelShippingAddress') }} </sw-tabs-item> {% endblock %} </template> <template #content="{ active }"> {% block sw_order_new_customer_modal_content_details %} <div v-if="active ==='details'"> {% block sw_order_new_customer_modal_content_details_guest %} <mt-switch v-model="customer.guest" remove-top-margin :label="$tc('sw-order.newCustomerModal.labelGuest')" /> {% endblock %} {% block sw_order_new_customer_modal_content_details_form %} <sw-customer-base-form :is-loading="isLoading" :customer="customer" @sales-channel-change="onChangeSalesChannel" /> {% endblock %} </div> {% endblock %} {% block sw_order_new_customer_modal_content_shipping %} <div v-if="active === 'shippingAddress'"> {% block sw_order_new_customer_modal_content_shipping_same_billing %} <mt-switch v-model="isSameBilling" remove-top-margin :label="$tc('sw-customer.addressForm.labelSameBillingAddress')" /> {% endblock %} {% block sw_order_new_customer_modal_content_shipping_form %} <sw-customer-address-form :customer="customer" :disabled="isSameBilling" :address="shippingAddress" /> {% endblock %} </div> {% endblock %} {% block sw_order_new_customer_modal_content_billing %} <div v-if="active ==='billingAddress'"> {% block sw_order_new_customer_modal_content_billing_form %} <sw-customer-address-form :customer="customer" :address="billingAddress" /> {% endblock %} </div> {% endblock %} </template> </sw-tabs> {% endblock %} {% block sw_order_new_customer_modal_actions %} <template #modal-footer> {% block sw_order_new_customer_modal_action_close %} <mt-button size="small" variant="secondary" data-analytics-id="sw-order-new-customer-modal.cancel" @click="onClose" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_order_new_customer_modal_actions_apply %} <mt-button size="small" variant="primary" :is-loading="isLoading" data-analytics-id="sw-order-new-customer-modal.save" @click="onSave" > {{ $tc('global.default.save') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %}`,{Mixin:l}=Shopware,{Criteria:o}=Shopware.Data,{mapPageErrors:c}=Shopware.Component.getComponentHelper(),{CUSTOMER:a}=Shopware.Constants,u={template:n,inject:["repositoryFactory","numberRangeService","systemConfigApiService","customerValidationService"],emits:["on-select-existing-customer","close"],mixins:[l.getByName("notification")],data(){return{customer:null,isLoading:!1,customerNumberPreview:"",defaultSalutationId:null}},computed:{...c({"sw.order.new.customer.detail":{customer:["firstName","lastName","email","salesChannelId","customerNumber","groupId"]},"sw.order.new.customer.address":{customer_address:["firstName","lastName","street","city","countryId"]}}),customerRepository(){return this.repositoryFactory.create("customer")},addressRepository(){return this.repositoryFactory.create("customer_address")},shippingAddress(){return this.isSameBilling?this.billingAddress:this.customer!==null?this.customer.addresses.get(this.customer.defaultShippingAddressId):null},billingAddress(){return this.customer!==null?this.customer.addresses.get(this.customer.defaultBillingAddressId):null},isSameBilling:{get(){return this.customer===null?!0:this.customer.defaultBillingAddressId===this.customer.defaultShippingAddressId},set(e){if(e===this.isSameBilling)return;if(e===!0){this.customer.defaultShippingAddressId=this.customer.defaultBillingAddressId,this.customer.isNew()&&(this.customer.addresses=this.customer.addresses.filter(t=>t.id===this.customer.defaultBillingAddressId));return}const s=this.addressRepository.create();s.salutationId=this.defaultSalutationId,this.customer.addresses.add(s),this.customer.defaultShippingAddressId=s.id}},validCompanyField(){var e,s,t;return((e=this.customer)==null?void 0:e.accountType)===a.ACCOUNT_TYPE_BUSINESS?(t=(s=this.customer)==null?void 0:s.company)==null?void 0:t.trim().length:!0},languageRepository(){return this.repositoryFactory.create("language")},languageCriteria(){var s;const e=new o;return e.setLimit(1),(s=this.customer)!=null&&s.salesChannelId&&e.addFilter(o.equals("salesChannelDefaultAssignments.id",this.customer.salesChannelId)),e},languageId(){return this.loadLanguage(this.customer.salesChannelId)},salutationRepository(){return this.repositoryFactory.create("salutation")},salutationCriteria(){const e=new o(1,1);return e.addFilter(o.equals("salutationKey","not_specified")),e}},watch:{"customer.salesChannelId"(e){this.systemConfigApiService.getValues("core.systemWideLoginRegistration").then(s=>{s["core.systemWideLoginRegistration.isCustomerBoundToSalesChannel"]&&(this.customer.boundSalesChannelId=e)})},"customer.accountType"(e){var s;e!==a.ACCOUNT_TYPE_BUSINESS&&Shopware.Store.get("error").removeApiError(`customer_address.${(s=this.billingAddress)==null?void 0:s.id}.company`)}},created(){this.createdComponent()},methods:{async createdComponent(){this.customer=this.customerRepository.create(),this.defaultSalutationId=await this.getDefaultSalutationId();const e=this.addressRepository.create();e.salutationId=this.defaultSalutationId,this.customer.addresses.add(e),this.customer.defaultShippingAddressId=e.id,this.customer.defaultBillingAddressId=e.id,this.customer.accountType=a.ACCOUNT_TYPE_PRIVATE,this.customer.vatIds=[],this.customer.salutationId=this.defaultSalutationId},async onSave(){let e=!1;const s=await this.validateEmail();if((!s||!s.isValid)&&(e=!0),this.validCompanyField||(this.createErrorMessageForCompanyField(),e=!0),this.customer.accountType===a.ACCOUNT_TYPE_PRIVATE&&(this.customer.vatIds=[]),e)return this.createNotificationError({message:this.$tc("sw-customer.detail.messageSaveError")}),this.isLoading=!1,!1;let t=Promise.resolve();return this.customerNumberPreview===this.customer.customerNumber&&(t=this.numberRangeService.reserve("customer",this.customer.salesChannelId).then(r=>{this.customerNumberPreview=r.number,this.customer.customerNumber=r.number})),t.then(()=>this.saveCustomer())},async saveCustomer(){const e=await this.languageId,s={...Shopware.Context.api,languageId:e};return this.customerRepository.save(this.customer,s).then(t=>(this.$emit("on-select-existing-customer",this.customer.id),this.isLoading=!1,this.onClose(),t)).catch(()=>{this.createNotificationError({message:this.$tc("sw-customer.detail.messageSaveError")}),this.isLoading=!1})},onChangeSalesChannel(e){this.customer.salesChannelId=e,this.numberRangeService.reserve("customer",e,!0).then(s=>{this.customerNumberPreview=s.number,this.customer.customerNumber=s.number})},onClose(){this.$emit("close")},createErrorMessageForCompanyField(){Shopware.Store.get("error").addApiError({expression:`customer_address.${this.billingAddress.id}.company`,error:new Shopware.Classes.ShopwareError({code:"c1051bb4-d103-4f74-8988-acbcafc7fdc3"})})},validateEmail(){const{id:e,email:s,boundSalesChannelId:t}=this.customer;return s?this.customerValidationService.checkCustomerEmail({id:e,email:s,boundSalesChannelId:t}).then(r=>r).catch(r=>{var i,d;r&&Shopware.Store.get("error").addApiError({expression:`customer.${this.customer.id}.email`,error:(d=(i=r==null?void 0:r.response)==null?void 0:i.data)==null?void 0:d.errors[0]})}):Promise.resolve({isValid:!0})},async loadLanguage(e){const s=Shopware.Context.api.languageId;if(!e)return s;const t=await this.languageRepository.searchIds(this.languageCriteria);return t!=null&&t.data?t.data[0]:s},async getDefaultSalutationId(){var s;return(s=(await this.salutationRepository.searchIds(this.salutationCriteria)).data)==null?void 0:s[0]}}};export{u as default};
