const c=`{% block sw_settings_shipping_price_matrix %} <mt-card :title="cardTitle" :is-loading="isLoading" class="sw-settings-shipping-price-matrix" position-identifier="sw-settings-shipping-price-matrix" > {% block sw_settings_shipping_price_matrix_topbar_alert %} <mt-banner v-if="priceGroup.isNew" class="sw-settings-shipping-price-matrix__new-matrix-alert" variant="attention" :title="$tc('global.default.warning')" :closable="false" > {{ $tc('sw-settings-shipping.priceMatrix.newMatrixAlertMessage') }} </mt-banner> {% endblock %} {% block sw_settings_shipping_price_matrix_topbar %} <sw-container columns="1fr auto 35px" gap="0px 24px" class="sw-settings-shipping-price-matrix__top-container" > {% block sw_settings_shipping_price_matrix_topbar_rule_select %} <sw-select-rule-create class="sw-settings-shipping-price-matrix__top-container-rule-select" :rule-id="priceGroup.ruleId" :rule-filter="ruleFilterCriteria" size="small" :disabled="disabled || undefined" :placeholder="mainRulePlaceholder" rule-aware-group-key="shippingMethodPrices" :restricted-rule-ids="restrictedRuleIds" :restricted-rule-ids-tooltip-label="$tc('sw-settings-shipping.priceMatrix.ruleAlreadyUsedOrRestricted')" @save-rule="onSaveMainRule" /> {% endblock %} {% block sw_settings_shipping_price_matrix_topbar_new_price %} <mt-button size="x-small" class="sw-settings-shipping-price-matrix__top-container-add-new-rule" variant="primary" :ghost="showDataGrid" :disabled="!showDataGrid || disabled" @click="onAddNewShippingPrice" > <template v-if="isRuleMatrix"> {{ $tc('sw-settings-shipping.priceMatrix.addNewRule') }} </template> <template v-else> {{ $tc('sw-settings-shipping.priceMatrix.addNewShippingPrice') }} </template> </mt-button> {% endblock %} {% block sw_settings_shipping_price_matrix_topbar_context_button %} <sw-context-button :disabled="!showDataGrid || disabled" class="sw-settings-shipping-price-matrix__price-group-context" > {% block sw_settings_shipping_price_matrix_topbar_context_button_duplicate %} <sw-context-menu-item v-tooltip="{ showDelay: 300, showOnDisabledElements: true, message: $tc('sw-settings-shipping.priceMatrix.newMatrixAlreadyExists'), disabled: !newPriceMatrixExists }" :disabled="newPriceMatrixExists" class="sw-settings-shipping-price-matrix__action-duplicate" @click="$emit('duplicate-price-matrix', priceGroup)" > {{ $tc('sw-settings-shipping.priceMatrix.duplicateMatrixContextLabel') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_shipping_price_matrix_topbar_context_button_delete %} <sw-context-menu-item class="sw-settings-shipping-price-matrix__action-delete" variant="danger" @click="onDeletePriceMatrix" > {{ $tc('sw-settings-shipping.priceMatrix.deleteMatrixContextLabel') }} </sw-context-menu-item> {% endblock %} </sw-context-button> {% endblock %} </sw-container> {% endblock %} <template #grid> {% block sw_settings_shipping_price_matrix_price_grid %} <sw-data-grid v-if="showDataGrid" :data-source="prices" :columns="ruleColumns" :show-selection="false" :show-settings="true" :compact-mode="true" > {% block sw_settings_shipping_price_matrix_price_grid_column_calculcation_rule %} <template #column-calculationRule="{ item, itemIndex, compact }" > <sw-select-rule-create class="sw-settings-shipping-price-matrix__column-calculation-rule-select" size="small" :disabled="disabled" :rule-id="item.calculationRuleId" :rule-filter="shippingRuleFilterCriteria" :placeholder="$tc('sw-settings-shipping.priceMatrix.chooseCustomRule')" rule-aware-group-key="shippingMethodPriceCalculations" :restricted-rule-ids="usedCalculationRules" :restricted-rule-ids-tooltip-label="$tc('sw-settings-shipping.priceMatrix.ruleAlreadyUsedInMatrix')" @save-rule="(ruleId) => onSaveCustomShippingRule(ruleId, item)" > <template #rule-modal="{ showRuleModal, onSaveRule, onCloseRuleModal }"> <sw-price-rule-modal v-if="showRuleModal" rule-aware-group-key="shippingMethodPriceCalculations" @save="onSaveRule" @modal-close="onCloseRuleModal" /> </template> </sw-select-rule-create> </template> {% endblock %} {% block sw_settings_shipping_price_matrix_price_grid_column_quantity_start %} <template #column-quantityStart="{ item, itemIndex, compact }" > <mt-number-field v-model="item.quantityStart" :disabled="disabled" :name="\`sw-field--\${item.id}-quantity-start\`" :number-type="numberFieldType" :size="compact ? 'small' : 'default'" :min="priceGroup.prices[itemIndex - 1] ? priceGroup.prices[itemIndex - 1].quantityEnd : 0" :max="item.quantityEnd ? item.quantityEnd : null" :digits="3" /> </template> {% endblock %} {% block sw_settings_shipping_price_matrix_price_grid_column_quantity_end %} <template #column-quantityEnd="{ item, itemIndex, compact }" > <mt-number-field v-model="item.quantityEnd" :disabled="disabled" :name="\`sw-field--\${item.id}-quantity-end\`" :number-type="numberFieldType" :size="compact ? 'small' : 'default'" :placeholder="$tc('sw-settings-shipping.priceMatrix.any')" :validation="item.quantityEnd === null || item.quantityEnd > item.quantityStart" :min="item.quantityStart" :digits="3" @update:model-value="onQuantityEndChange(item)" /> </template> {% endblock %} {% block sw_settings_shipping_price_matrix_price_grid_currencies_list %} <template v-for="currency in currencies" :key="currency.isoCode" #[\`column-price-\${currency.isoCode}\`]="{ item, column, compact }" > <sw-inherit-wrapper class="sw-settings-shipping-price-matrix__price" :value="getPrice(item, currency)" :has-parent="!currency.isSystemDefault" :inherited-value="currency.isSystemDefault ? null : convertDefaultPriceToCurrencyPrice(item, currency)" @update:value="setPrice(item, currency, $event)" > <template #content="props"> <sw-inheritance-switch v-if="!currency.isSystemDefault" class="sw-settings-shipping-price-matrix__price-inherit-icon" :is-inherited="props.isInherited" :disabled="disabled" @inheritance-restore="props.restoreInheritance" @inheritance-remove="props.removeInheritance" /> <mt-number-field v-model="props.currentValue.gross" :name="\`sw-field--\${item.id}-\${currency.id}-gross\`" :size="compact ? 'small' : 'default'" class="sw-settings-shipping-price-matrix__price-input" :digits="50" :disabled="props.isInherited || disabled" /> <mt-number-field v-model="props.currentValue.net" :name="\`sw-field--\${item.id}-\${currency.id}-net\`" :size="compact ? 'small' : 'default'" class="sw-settings-shipping-price-matrix__price-input" :digits="50" :disabled="props.isInherited || disabled" /> </template> </sw-inherit-wrapper> </template> {% endblock %} {% block sw_settings_shipping_price_matrix_price_grid_actions %} <template #actions="{ item }"> {% block sw_settings_shipping_price_matrix_price_grid_actions_delete %} <sw-context-menu-item :disabled="disableDeleteButton || disabled" variant="danger" @click="onDeleteShippingPrice(item)" > {{ $tc('sw-settings-shipping.priceMatrix.contextMenuDeletePrice') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} </sw-data-grid> <div v-if="showDataGrid && !showAllPrices" class="sw-settings-shipping-price-matrix__price-load-all" > <mt-button ghost size="small" class="sw-settings-shipping-price-matrix__price-load-all-button" variant="secondary" @click="updateShowAllPrices" > {{ $tc('sw-settings-shipping.priceMatrix.buttonLoadAllPrices') }} </mt-button> </div> {% endblock %} {% block sw_settings_shipping_price_matrix_empty %} <div v-if="!showDataGrid" class="sw-settings-shipping-price-matrix__empty" > {% block sw_settings_shipping_price_matrix_empty_text %} <p class="sw-settings-shipping-price-matrix__empty-text"> {{ $tc('sw-settings-shipping.priceMatrix.emptyText') }} </p> {% endblock %} <sw-container columns="1fr 10px 1fr" gap="0px 24px" > {% block sw_settings_shipping_price_matrix_empty_property_store %} <sw-single-select class="sw-settings-shipping-price-matrix__empty--select-property" :options="calculationTypes" :value="priceGroup.calculation" :disabled="disabled" size="small" show-clearable-button :placeholder="$tc('sw-settings-shipping.priceMatrix.selectProperty')" @update:value="onCalculationChange" /> {% endblock %} <p class="sw-settings-shipping-price-matrix__empty-text-or"> {{ $tc('sw-settings-shipping.priceMatrix.textOr') }} </p> {% block sw_settings_shipping_price_matrix_empty_rule_select %} <sw-select-rule-create size="small" :disabled="disabled" :rule-filter="shippingRuleFilterCriteria" :placeholder="$tc('sw-settings-shipping.priceMatrix.chooseCustomRule')" rule-aware-group-key="shippingMethodPriceCalculations" :restricted-rule-ids="usedCalculationRules" :restricted-rule-ids-tooltip-label="$tc('sw-settings-shipping.priceMatrix.ruleAlreadyUsedInMatrix')" @save-rule="(ruleId) => { onSaveCustomShippingRule(ruleId) }" > <template #rule-modal="{ showRuleModal, onSaveRule, onCloseRuleModal }"> <sw-price-rule-modal v-if="showRuleModal" rule-aware-group-key="shippingMethodPriceCalculations" @save="onSaveRule" @modal-close="onCloseRuleModal" /> </template> </sw-select-rule-create> {% endblock %} </sw-container> </div> {% endblock %} </template> {% block sw_settings_shipping_price_matrix_delete_modal %} <sw-modal v-if="showDeleteModal" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_settings_shipping_price_matrix_delete_modal_confirm_delete_text %} <p class="sw-settings-shipping-price-matrix__confirm-delete-text"> {{ confirmDeleteText }} </p> {% endblock %} {% block sw_settings_shipping_price_matrix_delete_modal_footer %} <template #modal-footer> {% block sw_settings_shipping_price_matrix_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_shipping_price_matrix_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmDeleteShippingPrice" > {{ $tc('sw-settings-shipping.priceMatrix.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </mt-card> {% endblock %}`,{Mixin:l,Context:n,Data:{Criteria:r}}=Shopware,{cloneDeep:p}=Shopware.Utils.object,o={template:c,inject:["repositoryFactory"],emits:["duplicate-price-matrix","delete-price-matrix"],mixins:[l.getByName("placeholder"),l.getByName("notification")],props:{priceGroup:{type:Object,required:!0},disabled:{type:Boolean,required:!1,default:!1}},data(){return{calculationTypes:[{label:this.$tc("sw-settings-shipping.priceMatrix.calculationLineItemCount"),value:1},{label:this.$tc("sw-settings-shipping.priceMatrix.calculationPrice"),value:2},{label:this.$tc("sw-settings-shipping.priceMatrix.calculationWeight"),value:3},{label:this.$tc("sw-settings-shipping.priceMatrix.calculationVolume"),value:4}],showDeleteModal:!1,isLoading:!1,ruleColumns:[],showAllPrices:!0}},computed:{shippingMethod(){return Shopware.Store.get("swShippingDetail").shippingMethod},currencies(){return Shopware.Store.get("swShippingDetail").currencies},restrictedRuleIds(){return Shopware.Store.get("swShippingDetail").restrictedRuleIds},unrestrictedPriceMatrixExists(){return Shopware.Store.get("swShippingDetail").unrestrictedPriceMatrixExists},newPriceMatrixExists(){return Shopware.Store.get("swShippingDetail").newPriceMatrixExists},defaultCurrency(){return Shopware.Store.get("swShippingDetail").defaultCurrency},ruleRepository(){return this.repositoryFactory.create("rule")},shippingPriceRepository(){return this.repositoryFactory.create("shipping_method_price")},labelQuantityStart(){return{1:"sw-settings-shipping.priceMatrix.columnQuantityStart",2:"sw-settings-shipping.priceMatrix.columnPriceStart",3:"sw-settings-shipping.priceMatrix.columnWeightStart",4:"sw-settings-shipping.priceMatrix.columnVolumeStart"}[this.priceGroup.calculation]||"sw-settings-shipping.priceMatrix.columnQuantityStart"},labelQuantityEnd(){return{1:"sw-settings-shipping.priceMatrix.columnQuantityEnd",2:"sw-settings-shipping.priceMatrix.columnPriceEnd",3:"sw-settings-shipping.priceMatrix.columnWeightEnd",4:"sw-settings-shipping.priceMatrix.columnVolumeEnd"}[this.priceGroup.calculation]||"sw-settings-shipping.priceMatrix.columnQuantityEnd"},numberFieldType(){return{1:"int",2:"float",3:"float",4:"float"}[this.priceGroup.calculation]||"float"},confirmDeleteText(){const e=this.priceGroup.rule?this.priceGroup.rule.name:"";return this.$tc("sw-settings-shipping.priceMatrix.textDeleteConfirm",{name:e},+!!this.priceGroup.rule)},currencyColumns(){return this.currencies.map((e,t)=>{let i=e.translated.name||e.name;return i=`${i} ${this.$tc("sw-settings-shipping.priceMatrix.labelGrossNet")}`,{property:`price-${e.isoCode}`,label:i,visible:t===0||e.salesChannels&&e.salesChannels.length>0,allowResize:!0,primary:!!e.isSystemDefault,rawData:!1,width:"200px"}})},showDataGrid(){return!!this.priceGroup.calculation||this.priceGroup.prices.some(e=>e.calculationRuleId)},disableDeleteButton(){return this.priceGroup.prices.length<=1},ruleFilterCriteria(){const e=new r(1,25);return e.addSorting(r.sort("name","ASC",!1)).addFilter(r.multi("OR",[r.contains("rule.moduleTypes.types","price"),r.equals("rule.moduleTypes",null)])),e},shippingRuleFilterCriteria(){if(Shopware.Feature.isActive("v6.8.0.0"))return this.ruleFilterCriteria;const e=new r(1,25);return e.addFilter(r.multi("OR",[r.contains("rule.moduleTypes.types","shipping"),r.contains("rule.moduleTypes.types","price"),r.equals("rule.moduleTypes",null)])),e},isRuleMatrix(){return!this.priceGroup.calculation},usedCalculationRules(){const e=[];return this.isRuleMatrix&&this.priceGroup.prices.forEach(t=>{t.calculationRuleId&&!e.includes(t.calculationRuleId)&&e.push(t.calculationRuleId)}),e},mainRulePlaceholder(){return this.priceGroup.isNew?this.$tc("sw-settings-shipping.priceMatrix.chooseOrCreateRule"):this.$tc("sw-settings-shipping.priceMatrix.noRestriction")},cardTitle(){return!this.priceGroup.rule&&!this.priceGroup.isNew?this.$tc("sw-settings-shipping.priceMatrix.noRestriction"):this.priceGroup.rule?this.priceGroup.rule.name:this.$tc("sw-settings-shipping.priceMatrix.titleCard")},prices(){return this.showAllPrices?this.priceGroup.prices:[this.priceGroup.prices[0]]}},watch:{isRuleMatrix(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){this.ruleColumns=[],this.showAllPrices=this.priceGroup.prices.length<=1,this.isRuleMatrix?this.ruleColumns.push({property:"calculationRule",label:"sw-settings-shipping.priceMatrix.columnCalculationRule",allowResize:!0,primary:!0,rawData:!0,width:"250px"}):(this.ruleColumns.push({property:"quantityStart",label:this.labelQuantityStart,allowResize:!0,primary:!0,rawData:!0,width:"130px"}),this.ruleColumns.push({property:"quantityEnd",label:this.labelQuantityEnd,allowResize:!0,rawData:!0,primary:!0,width:"130px"})),this.ruleColumns.push(...this.currencyColumns)},onAddNewShippingPrice(){this.updateShowAllPrices();const e=this.priceGroup.prices[this.priceGroup.prices.length-1],t=this.shippingPriceRepository.create(n.api);if(t.shippingMethodId=this.shippingMethod.id,t.ruleId=this.priceGroup.ruleId,t.currencyPrice=p(e.currencyPrice),e._inNewMatrix&&(t._inNewMatrix=!0),this.isRuleMatrix){this.shippingMethod.prices.push(t);return}e.quantityEnd||(e.quantityEnd=e.quantityStart),t.calculation=e.calculation,this.priceGroup.calculation===1?t.quantityStart=e.quantityEnd+1>1?e.quantityEnd+1:2:t.quantityStart=e.quantityEnd,t.quantityEnd=null,this.shippingMethod.prices.push(t)},onSaveMainRule(e){if(!e&&this.unrestrictedPriceMatrixExists&&this.priceGroup.ruleId!==e){this.createNotificationError({message:this.$tc("sw-settings-shipping.priceMatrix.unrestrictedRuleAlreadyExistsMessage")});return}this.ruleRepository.get(e,n.api).then(t=>{this.priceGroup.prices.forEach(i=>{i.ruleId=e,i.rule=t,i._inNewMatrix&&delete i._inNewMatrix})})},onSaveCustomShippingRule(e,t){t||(t=this.priceGroup.prices[0]),this.$nextTick(()=>{this.isLoading=!0}),this.ruleRepository.get(e,n.api).then(i=>{t.calculationRuleId=e,t.calculationRule=i,this.isLoading=!1})},onCalculationChange(e){this.priceGroup.prices.forEach(t=>{t.calculation=Number(e),t.ruleId=this.priceGroup.ruleId})},onDeletePriceMatrix(){this.showDeleteModal=!0},onConfirmDeleteShippingPrice(){this.showDeleteModal=!1,this.$nextTick(()=>{this.$emit("delete-price-matrix",this.priceGroup)})},onCloseDeleteModal(){this.showDeleteModal=!1},onDeleteShippingPrice(e){if(this.priceGroup.prices.length<=1){this.createNotificationInfo({message:this.$tc("sw-settings-shipping.priceMatrix.deletionNotPossibleMessage")});return}const t=this.priceGroup.prices.indexOf(e);if(typeof e.quantityEnd>"u"||e.quantityEnd===null){const i=this.priceGroup.prices[t-1];i.quantityEnd=null}else{const i=this.priceGroup.prices[t+1];i.quantityStart=e.quantityStart}this.shippingMethod.prices.remove(e.id)},convertDefaultPriceToCurrencyPrice(e,t){e.currencyPrice||this.initCurrencyPrice(e);const i=e.currencyPrice.find(s=>s.currencyId===this.defaultCurrency.id);return this.convertPrice(i,t)},initCurrencyPrice(e){e.currencyPrice=[{currencyId:this.defaultCurrency.id,gross:0,linked:!1,net:0}]},getPrice(e,t){const i=this.getPriceOfCurrency(e,t);return i||null},setPrice(e,t,i){if(!i){e.currencyPrice=e.currencyPrice.filter(a=>a.currencyId!==t.id);return}const s={currencyId:t.id,gross:i.gross,linked:!1,net:i.net};e.currencyPrice.push(s)},getPriceOfCurrency(e,t){return e.currencyPrice||this.initCurrencyPrice(e),e.currencyPrice.find(i=>i.currencyId===t.id)},convertPrice(e,t){return{net:e.net*t.factor,gross:e.gross*t.factor,currencyId:t.id,linked:!1}},onQuantityEndChange(e){this.priceGroup.prices.indexOf(e)+1===this.priceGroup.prices.length&&this.onAddNewShippingPrice()},updateShowAllPrices(){this.showAllPrices=!0}}};export{o as default};
