const h=`{% block sw_profile_index_search_preferences %} <div class="sw-profile-index-search-preferences"> <mt-card v-if="adminEsEnable" class="sw-card-elasticsearch-enabled" position-identifier="sw-card-elasticsearch-enabled" > <mt-banner class="sw-card-elasticsearch-enabled__alert" variant="info" :title="$tc('sw-profile.tabSearchPreferences.alert_elasticsearch.title')" > {{ $tc('sw-profile.tabSearchPreferences.alert_elasticsearch.text') }} </mt-banner> </mt-card> {% block sw_profile_index_search_preferences_search_behavior %} <mt-card class="sw-profile-index-search-preferences-search-behavior" position-identifier="sw-profile-index-search-preferences-search-behavior" :title="$tc('sw-profile.tabSearchPreferences.cardSearchBehavior.title')" :subtitle="$tc('sw-profile.tabSearchPreferences.cardSearchBehavior.subtitle')" :is-loading="isLoading" > <sw-container columns="1fr 1fr" gap="0 32px" > <mt-number-field v-model="minSearchTermLength" :label="$tc('sw-profile.tabSearchPreferences.cardSearchBehavior.labelMinSearchTermLength')" :min="1" :max="10" :step="1" :disabled="isLoading" /> </sw-container> </mt-card> {% endblock %} {% block sw_profile_index_search_preferences_searchable_elements %} <mt-card class="sw-profile-index-search-preferences-searchable-elements" position-identifier="sw-profile-index-search-preferences" :title="$tc('sw-profile.tabSearchPreferences.cardSearchContent.title')" :subtitle="$tc('sw-profile.tabSearchPreferences.cardSearchContent.subtitle')" :is-loading="isLoading" > {% block sw_profile_index_search_preferences_searchable_elements_content %} <sw-container v-if="searchPreferences.length > 0" rows="auto auto auto" gap="24px" > {% block sw_profile_index_search_preferences_searchable_elements_header %} <sw-container columns="auto auto auto 1fr" gap="8px" > {% block sw_profile_index_search_preferences_searchable_elements_button_select %} <mt-button class="sw-profile-index-search-preferences-searchable-elements__button-select-all" variant="secondary" @click="onSelect(true)" > {{ $tc('sw-profile.tabSearchPreferences.cardSearchContent.buttonSelect') }} </mt-button> {% endblock %} {% block sw_profile_index_search_preferences_searchable_elements_button_deselect %} <mt-button class="sw-profile-index-search-preferences-searchable-elements__button-deselect-all" variant="secondary" @click="onSelect(false)" > {{ $tc('sw-profile.tabSearchPreferences.cardSearchContent.buttonDeselect') }} </mt-button> {% endblock %} {% block sw_profile_index_search_preferences_searchable_elements_button_reset %} <mt-button class="sw-profile-index-search-preferences-searchable-elements__button-reset-to-default" variant="secondary" @click="onReset" > {{ $tc('sw-profile.tabSearchPreferences.cardSearchContent.buttonReset') }} </mt-button> {% endblock %} </sw-container> {% endblock %} {% block sw_profile_index_search_preferences_searchable_elements_body %} <div class="sw-profile-index-search-preferences-searchable-elements__entity-container"> <ul v-for="searchPreference in searchPreferences" :key="searchPreference.entityName" class="sw-profile-index-search-preferences-searchable-elements__entity" > <li class="sw-profile-index-search-preferences-searchable-elements__entity-field"> <mt-checkbox v-model:checked="searchPreference._searchable" :label="getModuleTitle(searchPreference.entityName)" @update:checked="onChangeSearchPreference(searchPreference)" name="sw-field--searchPreference-_searchable" /> <ul class="sw-profile-index-search-preferences-searchable-elements__entity"> <li v-for="field in searchPreference.fields" :key="field.fieldName" class="sw-profile-index-search-preferences-searchable-elements__entity-field" > <mt-checkbox v-model:checked="field._searchable" name="sw-field--field-_searchable" :label="$tc(\`sw-profile.tabSearchPreferences.modules.\${searchPreference.entityName}.\${field.fieldName}\`)" :disabled="adminEsEnable || !searchPreference._searchable" /> </li> </ul> </li> </ul> </div> {% endblock %} </sw-container> {% endblock %} </mt-card> {% endblock %} </div> {% endblock %}`,{Module:o,Store:t,Mixin:f}=Shopware,d={template:h,inject:["searchPreferencesService","searchRankingService"],mixins:[f.getByName("notification")],data(){return{isLoading:!1}},computed:{minSearchTermLength:{get(){return t.get("swProfile").minSearchTermLength},set(e){t.get("swProfile").setMinSearchTermLength(e)}},searchPreferences:{get(){return t.get("swProfile").searchPreferences},set(e){t.get("swProfile").searchPreferences=e}},userSearchPreferences:{get(){return t.get("swProfile").userSearchPreferences},set(e){t.get("swProfile").userSearchPreferences=e}},defaultSearchPreferences(){const e=this.searchPreferencesService.getDefaultSearchPreferences();if(this.userSearchPreferences===null)return e;const r=[];return e.forEach(s=>{const a=Object.keys(s)[0],n=this.userSearchPreferences.find(c=>Object.keys(c)[0]===a);if(!n){r.push(s);return}const i=n[a],l=s[a];Object.keys(l).forEach(c=>{i.hasOwnProperty(c)||(i[c]=l[c])}),Object.keys(i).forEach(c=>{l.hasOwnProperty(c)||delete i[c]}),r.push({[a]:i})}),r},adminEsEnable(){return Shopware.Context.app.adminEsEnable??!1}},created(){this.createdComponent()},beforeUnmount(){this.beforeDestroyComponent()},methods:{async createdComponent(){await Promise.all([this.getMinSearchTermLength(),this.getDataSource()]),this.updateDataSource(),this.addEventListeners()},beforeDestroyComponent(){this.removeEventListeners()},async getMinSearchTermLength(){this.isLoading=!0;try{const e=await this.searchRankingService.getMinSearchTermLength();Shopware.Store.get("swProfile").setMinSearchTermLength(e)}catch(e){this.createNotificationError({message:e.message})}finally{this.isLoading=!1}},async getDataSource(){this.isLoading=!0;try{this.userSearchPreferences=await this.searchPreferencesService.getUserSearchPreferences(),this.searchPreferences=this.searchPreferencesService.processSearchPreferences(this.defaultSearchPreferences)}catch(e){this.createNotificationError({message:e.message}),this.searchPreferences=[],this.userSearchPreferences=null}finally{this.isLoading=!1}},addEventListeners(){Shopware.Utils.EventBus.on("sw-search-preferences-modal-close",this.getDataSource)},removeEventListeners(){Shopware.Utils.EventBus.off("sw-search-preferences-modal-close",this.getDataSource)},updateDataSource(){this.adminEsEnable&&this.searchPreferences.forEach(e=>{e.fields.forEach(r=>{r._searchable=!0})})},getModuleTitle(e){const r=o.getModuleByEntityName(e);return this.$tc(r==null?void 0:r.manifest.title)},onChangeSearchPreference(e){e._searchable&&e.fields.every(r=>!r._searchable)&&e.fields.forEach(r=>{r._searchable=!0})},onSelect(e){this.searchPreferences.forEach(r=>{r._searchable=e,this.adminEsEnable||r.fields.forEach(s=>{s._searchable=e})})},onReset(){const e=this.searchPreferencesService.getDefaultSearchPreferences(),r=this.searchPreferencesService.processSearchPreferences(e);this.searchPreferences.forEach((s,a)=>{r.forEach(n=>{n.entityName===s.entityName&&this.resetSearchPreference(n,this.searchPreferences[a])})})},resetSearchPreference(e,r){r._searchable=e._searchable,this.adminEsEnable||(r.fields=r.fields.map(s=>e.fields.find(a=>a.fieldName===s.fieldName)||s))}}};export{d as default};
