const o=`{% block sw_cms_layout_modal %} <sw-modal class="sw-cms-layout-modal" variant="large" :title="$tc('sw-cms.components.cmsLayoutModal.modalTitle')" @modal-close="closeModal" > {% block sw_cms_layout_modal_header %} <div class="sw-cms-layout-modal__header"> {% block sw_cms_layout_modal_header_search %} <sw-simple-search-field v-model:value="term" class="sw-cms-layout-modal__header-search" :placeholder="$tc('sw-cms.general.placeholderSearchBar')" @search-term-change="onSearch" /> {% endblock %} {% block sw_cms_layout_modal_header_sorting_container %} <div class="sw-cms-layout-modal__actions-sorting"> {% block sw_cms_layout_modal_header_sorting_select %} <sw-sorting-select class="sw-cms-layout-modal__header-sorting-select" :sort-by="sortBy" :sort-direction="sortDirection" @sorting-changed="onSort" /> {% endblock %} {% block sw_cms_layout_modal_header_view_toggle %} <div class="sw-cms-layout-modal__actions-mode" role="button" tabindex="0" @click="toggleListMode" @keydown.enter="toggleListMode" > {% block sw_cms_layout_modal_header_view_toogle_grid %} <mt-icon v-if="listMode === 'grid'" name="regular-view-normal" size="16" /> {% endblock %} {% block sw_cms_layout_modal_header_view_toogle_list %} <mt-icon v-if="listMode === 'list'" name="regular-view-grid" size="16" /> {% endblock %} </div> {% endblock %} </div> {% endblock %} </div> {% endblock %} {% block sw_cms_layout_modal_content %} <div class="sw-cms-layout-modal__content"> {% block sw_cms_layout_modal_loader %} <sw-loader v-if="isLoading" /> {% endblock %} {% block sw_cms_layout_modal_content_container %} <div v-else-if="listMode === 'grid'"> <sw-container columns="repeat(auto-fill, minmax(250px, 1fr))" gap="24px" > {% block sw_cms_layout_modal_content_listing %} <div v-for="(cmsPage, index) in pages" :key="index" :class="gridItemClasses(cmsPage.id, index)" > {% block sw_cms_layout_modal_content_listing_item %} {% block sw_cms_layout_modal_content_listing_item_checkbox %} <mt-checkbox :checked="cmsPage.id === selectedPageObject?.id" class="sw-cms-layout-modal__content-checkbox" @update:checked="selectItem(cmsPage)" /> {% endblock %} {% block sw_cms_layout_modal_content_listing_item_inner %} <sw-cms-list-item :page="cmsPage" :is-default="[defaultProductId, defaultCategoryId].includes(cmsPage.id)" @element-click="selectItem(cmsPage)" @item-click="selectItem(cmsPage)" /> {% endblock %} {% endblock %} </div> </sw-container> {% block sw_cms_layout_modal_content_pagination %} <sw-pagination class="sw-cms-layout-modal__content-pagination" :page="page" :limit="limit" :total="total" :auto-hide="false" @page-change="onPageChange" /> {% endblock %} </div> {% endblock %} <sw-data-grid v-else-if="listMode === 'list'" class="sw-cms-list__list-data-grid" identifier="sw-cms-list" :is-loading="isLoading" :limit="limit" :data-source="pages" :columns="columnConfig" :skeleton-item-amount="limit" :sort-by="sortBy" :sort-direction="sortDirection" :allow-inline-edit="false" :allow-column-edit="false" :show-settings="false" :show-actions="false" :show-selection="true" :maximum-select-items="1" :pre-selection="gridPreSelection" @selection-change="selectInGrid" @column-sort="onSortColumn" > {% block sw_cms_list_listing_list_data_grid_column_name %} <template #column-name="{ item }"> <div role="button" tabindex="0" @click="selectItem(item)" @keydown.enter="selectItem(item)" > {{ item.translated.name }} </div> </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_type %} <template #column-type="{ item }"> {{ getPageType(item) }} </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_created %} <template #column-createdAt="{ item }"> <sw-time-ago :date="item.createdAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_updated %} <template #column-updatedAt="{ item }"> <sw-time-ago v-if="item.updatedAt" :date="item.updatedAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_pagination %} <template #pagination> <sw-pagination :page="page" :limit="limit" :total="total" :auto-hide="false" @page-change="onPageChange" /> </template> {% endblock %} </sw-data-grid> {% endblock %} </div> {% endblock %} {% block sw_cms_layout_modal_footer %} <template #modal-footer> <mt-button variant="secondary" @click="closeModal" > {{ $tc('global.default.cancel') }} </mt-button> <mt-button variant="primary" class="sw-cms-layout-modal__button-select-layout" @click="selectLayout" > {{ $tc('sw-cms.components.cmsLayoutModal.actionConfirm') }} </mt-button> </template> {% endblock %} </sw-modal> {% endblock %}`,{Mixin:c}=Shopware,{Criteria:a}=Shopware.Data,d={template:o,inject:["repositoryFactory","systemConfigApiService","acl","cmsPageTypeService"],emits:["modal-layout-select","modal-close"],mixins:[c.getByName("listing")],props:{headline:{type:String,required:!1,default:""},cmsPageTypes:{type:Array,required:!1,default(){return[]}},preSelection:{type:Object,required:!1,default:()=>{}}},data(){return{listMode:"grid",disableRouteParams:!0,sortBy:"createdAt",sortDirection:"DESC",limit:10,selectedPageObject:null,isLoading:!1,term:null,total:null,pages:[],defaultCategoryId:"",defaultProductId:""}},computed:{pageRepository(){return this.repositoryFactory.create("cms_page")},cmsPageCriteria(){const e=new a(this.page,this.limit);return e.addAssociation("previewMedia").addSorting(a.sort(this.sortBy,this.sortDirection)),this.cmsPageTypes.length&&e.addFilter(a.equalsAny("type",this.cmsPageTypes)),e.setTerm(this.term),e},columnConfig(){return[{property:"name",label:this.$tc("sw-cms.list.gridHeaderName"),inlineEdit:"string",primary:!0},{property:"type",label:this.$tc("sw-cms.list.gridHeaderType")},{property:"createdAt",label:this.$tc("sw-cms.list.gridHeaderCreated")},{property:"updatedAt",label:this.$tc("sw-cms.list.gridHeaderUpdated")}]},gridPreSelection(){var e;return(e=this.selectedPageObject)!=null&&e.id?{[this.selectedPageObject.id]:this.selectedPageObject}:{}},dateFilter(){return Shopware.Filter.getByName("date")}},watch:{preSelection:{handler:function(t){this.selectedPageObject=t},immediate:!0}},created(){this.createdComponent()},methods:{createdComponent(){this.acl.can("system_config:read")&&this.getDefaultLayouts()},getList(){return this.isLoading=!0,this.pageRepository.search(this.cmsPageCriteria).then(e=>{this.total=e.total,this.pages=e}).finally(()=>{this.isLoading=!1})},selectLayout(){var e;this.$emit("modal-layout-select",(e=this.selectedPageObject)==null?void 0:e.id,this.selectedPageObject),this.closeModal()},selectInGrid(e){const t=Object.values(e);if(t.length===0){this.selectedPageObject=null;return}this.selectedPageObject=t[0]},selectItem(e){this.selectedPageObject=e},onSearch(e){(!e.length||e.length<=0)&&(this.term=null),this.page=1,this.getList()},toggleListMode(){this.listMode=this.listMode==="grid"?"list":"grid"},gridItemClasses(e,t){var s;return[{"is--selected":e===((s=this.selectedPageObject)==null?void 0:s.id)},"sw-cms-layout-modal__content-item",`sw-cms-layout-modal__content-item--${t}`]},closeModal(){this.selectedPageObject=null,this.term=null,this.$emit("modal-close")},getPageType(e){var i;const t=[this.defaultProductId,this.defaultCategoryId].includes(e.id),s=this.$tc("sw-cms.components.cmsListItem.defaultLayout"),l=this.$tc((i=this.cmsPageTypeService.getType(e.type))==null?void 0:i.title);return t?`${s} - ${l}`:l},async getDefaultLayouts(){const e=await this.systemConfigApiService.getValues("core.cms");this.defaultCategoryId=e["core.cms.default_category_cms_page"],this.defaultProductId=e["core.cms.default_product_cms_page"]}}};export{d as default};
