const d=`{% block sw_settings_rule_detail %} <sw-page class="sw-settings-rule-detail"> {% block sw_settings_rule_detail_header %} <template #smart-bar-header> <h2 v-if="rule"> {{ rule.name }} </h2> <h2 v-else> {{ $tc('sw-settings-rule.detail.textHeadline') }} </h2> </template> {% endblock %} {% block sw_settings_rule_detail_actions %} <template #smart-bar-actions> {% block sw_settings_rule_detail_actions_cancel %} <mt-button v-tooltip.bottom="tooltipCancel" class="sw-settings-rule-detail__cancel-action" :disabled="isLoading" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} <sw-button-group v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('rule.editor'), showOnDisabledElements: true }" class="sw-settings-rule-detail__save-button-group" :split-button="true" > {% block sw_settings_rule_detail_actions_save %} <sw-button-process v-model:process-success="isSaveSuccessful" v-tooltip.bottom="tooltipSave" class="sw-settings-rule-detail__save-action" :is-loading="isLoading" variant="primary" :disabled="!acl.can('rule.editor')" @click="onSave" > {{ $tc('sw-settings-rule.detail.buttonSave') }} </sw-button-process> {% endblock %} {% block sw_settings_rule_detail_actions_save_context_menu %} <sw-context-button> <template #button> <mt-button class="sw-settings-rule-detail__button-context-menu" square variant="primary" :disabled="isLoading || !acl.can('rule.editor')" size="default" > <mt-icon name="regular-chevron-down-xs" size="16" /> </mt-button> </template> {% block sw_settings_rule_detail_actions_save_context_menu_actions %} {% block sw_settings_rule_detail_actions_duplicate %} <sw-context-menu-item class="sw-settings-rule-detail__save-duplicate-action" :disabled="!acl.can('rule.creator') || !acl.can('rule.editor')" @click="onDuplicate" > {{ $tc('sw-product.detail.buttonSaveDuplicate') }} </sw-context-menu-item> {% endblock %} {% endblock %} </sw-context-button> {% endblock %} </sw-button-group> </template> {% endblock %} <template #language-switch> <sw-language-switch :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" :disabled="!ruleId" @on-change="onChangeLanguage" /> </template> {% block sw_settings_rule_detail_content %} <template #content> {% block sw_settings_rule_detail_tabs_discard_changes_modal %} <sw-discard-changes-modal v-if="isDisplayingSaveChangesWarning" @keep-editing="onLeaveModalClose(nextRoute)" @discard-changes="onLeaveModalConfirm(nextRoute)" /> {% endblock %} <sw-card-view> {% block sw_settings_rule_detail_tabs %} <sw-tabs v-if="rule && !rule.isNew()" class="sw-settings-rule-detail__tabs" position-identifier="sw-settings-rule-detail" > {% block sw_settings_rule_detail_tab_items %} <sw-tabs-item v-for="tab in tabItems" :key="tab.route.name" :class="'sw-settings-rule-detail__tab-item sw-settings-rule-detail__tab-item-' + tab.cssClassSuffix" :route="tab.route" :title="tab.title" :has-error="tabHasError(tab)" > {{ tab.title }} </sw-tabs-item> {% endblock %} </sw-tabs> {% endblock %} {% block sw_settings_rule_detail_content_view %} <template v-if="isLoading"> <sw-skeleton variant="detail-bold" /> <sw-skeleton /> </template> <template v-else-if="rule !== null"> <router-view v-slot="{ Component }" :key="$route.path" > <component :is="Component" :rule="rule" :conditions="conditions" :condition-repository="conditionRepository" :is-loading="isLoading" :detail-page-loading="isLoading" :rule-name-error="ruleNameError" :rule-priority-error="rulePriorityError" @conditions-changed="conditionsChanged" @tree-finished-loading="setTreeFinishedLoading" /> </router-view> </template> {% endblock %} </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Component:u,Mixin:c,Context:n}=Shopware,{mapPropertyErrors:h}=u.getComponentHelper(),{Criteria:a,EntityCollection:g}=Shopware.Data,p={template:d,inject:["ruleConditionDataProviderService","ruleConditionsConfigApiService","repositoryFactory","acl"],mixins:[c.getByName("notification")],shortcuts:{"SYSTEMKEY+S":"onSave",ESCAPE:"onCancel"},props:{ruleId:{type:String,required:!1,default:null}},data(){return{rule:null,conditions:null,conditionTree:null,deletedIds:[],isLoading:!1,isSaveSuccessful:!1,conditionTreeFinishedLoading:!1,conditionsTreeContainsUserChanges:!1,nextRoute:null,isDisplayingSaveChangesWarning:!1,forceDiscardChanges:!1,entityCount:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.rule?this.rule.name:""},ruleRepository(){return this.repositoryFactory.create("rule")},ruleCriteria(){const e=new a;return e.addAssociation("tags"),e.addAssociation("flowSequences.flow"),["personaPromotions","orderPromotions","cartPromotions","promotionDiscounts","promotionSetGroups","shippingMethodPriceCalculations","shippingMethodPrices","productPrices","shippingMethods","paymentMethods"].forEach(i=>{e.addAggregation(a.terms(i,"id",null,null,a.count(i,`rule.${i}.id`)))}),e},appScriptConditionRepository(){return this.repositoryFactory.create("app_script_condition")},conditionRepository(){return this.repositoryFactory.create(this.rule.conditions.entity,this.rule.conditions.source)},tooltipSave(){return this.acl.can("rule.editor")?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("rule.editor"),showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},tabItems(){return[{title:this.$tc("sw-settings-rule.detail.tabGeneral"),route:{name:"sw.settings.rule.detail.base",params:{id:this.$route.params.id}},cssClassSuffix:"general"},{title:this.$tc("sw-settings-rule.detail.tabAssignments"),route:{name:"sw.settings.rule.detail.assignments",params:{id:this.$route.params.id}},cssClassSuffix:"assignments"}]},conditionTreeFlat(){const e=t=>t!=null&&t.length?t.reduce((i,s)=>{var r;return i.push(s),((r=s.children)==null?void 0:r.length)>0&&i.push(...e(s.children)),i},[]):[];return e(this.conditionTree)},...h("rule",["name","priority"])},watch:{ruleId:{immediate:!0,handler(){this.isLoading=!0,this.loadConditionData().then(e=>{if(this.ruleConditionDataProviderService.addScriptConditions(e),!this.ruleId){this.isLoading=!1,this.createRule();return}this.loadEntityData(this.ruleId).then(()=>{this.isLoading=!1}),this.setTreeFinishedLoading()})}},conditionTree:{deep:!0,handler(){this.conditionTreeFinishedLoading&&(this.conditionsTreeContainsUserChanges=!0)}},$route(e,t){e.name==="sw.settings.rule.detail.base"&&t.name==="sw.settings.rule.detail.assignments"&&(this.isLoading=!0,this.loadEntityData(this.ruleId).then(()=>{this.isLoading=!1,this.setTreeFinishedLoading()}))}},beforeRouteUpdate(e,t,i){this.unsavedDataLeaveHandler(e,t,i)},beforeRouteLeave(e,t,i){this.unsavedDataLeaveHandler(e,t,i)},methods:{loadConditionData(){const e={...n.api,languageId:Shopware.Store.get("session").languageId},t=new a;return Promise.all([this.appScriptConditionRepository.search(t,e),this.ruleConditionsConfigApiService.load()]).then(i=>i[0])},createRule(){this.rule=this.ruleRepository.create(n.api),this.conditions=this.rule.conditions},loadEntityData(e){return this.isLoading=!0,this.conditions=null,this.ruleCriteria.addFilter(a.equals("id",e)),this.ruleRepository.search(this.ruleCriteria).then(t=>(this.entityCount=this.extractEntityCount(t.aggregations),this.rule=t.first(),this.loadConditions()))},extractEntityCount(e){const t={};return Object.keys(e).forEach(i=>{t[i]=e[i].buckets.at(0)[i].count}),t},unsavedDataLeaveHandler(e,t,i){if(this.forceDiscardChanges){this.forceDiscardChanges=!1,i();return}if(e.name==="sw.settings.rule.detail.assignments"&&t.name==="sw.settings.rule.detail.base"||e.name==="sw.settings.rule.detail.base"||e.name==="sw.settings.rule.create.base"){this.conditionsTreeContainsUserChanges=!1,this.conditionTreeFinishedLoading=!1,i();return}this.checkUnsavedData({to:e,next:i})},checkUnsavedData({to:e,next:t}){this.conditionsTreeContainsUserChanges||this.ruleRepository.hasChanges(this.rule)?(this.isDisplayingSaveChangesWarning=!0,this.nextRoute=e,t(!1)):t()},setTreeFinishedLoading(){this.$nextTick(()=>{this.conditionsTreeContainsUserChanges=!1,this.conditionTreeFinishedLoading=!0})},onLeaveModalClose(){this.nextRoute=null,this.isDisplayingSaveChangesWarning=!1},async onLeaveModalConfirm(e){this.forceDiscardChanges=!0,this.isDisplayingSaveChangesWarning=!1,e.name==="sw.settings.rule.detail.assignments"&&await this.loadEntityData(this.ruleId).then(()=>{this.isLoading=!1}),this.$nextTick(()=>{this.$router.push({name:e.name,params:e.params})})},loadConditions(e=null){const t={...n.api,inheritance:!0};if(e===null)return this.conditionRepository.search(new a,t).then(s=>this.loadConditions(s));if(e.total<=e.length)return this.conditions=e,Promise.resolve();const i=new a(e.criteria.page+1,e.criteria.limit);return e.entity==="product"&&i.addAssociation("options.group"),this.conditionRepository.search(i,e.context).then(s=>(e.push(...s),e.criteria=s.criteria,e.total=s.total,this.loadConditions(e)))},conditionsChanged({conditions:e,deletedIds:t}){this.conditionTree=e,this.deletedIds=[...this.deletedIds,...t]},validateRuleAwareness(){const e=this.ruleConditionDataProviderService.getAwarenessKeysWithEqualsAnyConfig();if(e.length<=0||!this.entityCount)return!0;let t=!0;return e.forEach(i=>{if(this.entityCount[i]<=0)return;const s=[];this.conditionTree.forEach(o=>{if(s.push(o),o.children){const l=this.getChildrenConditions(o);s.push(...l)}});const r=this.ruleConditionDataProviderService.getRestrictionsByAssociation(new g(this.conditionRepository.route,this.conditionRepository.entityName,n.api,null,s),i);if(r.isRestricted){const o=this.$tc("sw-restricted-rules.restrictedAssignment.equalsAnyViolationTooltip",{conditions:this.ruleConditionDataProviderService.getTranslatedConditionViolationList(r.equalsAnyNotMatched,"sw-restricted-rules.or"),entityLabel:this.$tc(r.assignmentSnippet,2)},0);this.createNotificationError({message:o}),t=!1}}),t},getChildrenConditions(e){const t=[];return e.children.forEach(i=>{if(t.push(i),i.children){const s=this.getChildrenConditions(i);t.push(...s)}}),t},validateDateRange(){return this.conditionTreeFlat.filter(e=>e.type==="dateRange").every(({value:{fromDate:e,toDate:t}})=>e&&t&&new Date(e)<=new Date(t))},onSave(){return this.validateRuleAwareness()?this.validateDateRange()?(this.isSaveSuccessful=!1,this.isLoading=!0,this.rule.isNew()?(this.rule.conditions=this.conditionTree,this.saveRule().then(()=>{this.$router.push({name:"sw.settings.rule.detail",params:{id:this.rule.id}}),this.isSaveSuccessful=!0,this.conditionsTreeContainsUserChanges=!1}).catch(()=>{this.showErrorNotification()})):this.saveRule().then(this.syncConditions).then(()=>{this.isSaveSuccessful=!0,this.loadEntityData(this.rule.id).then(()=>{this.setTreeFinishedLoading()})}).then(()=>{this.isLoading=!1}).catch(()=>{this.isLoading=!1,this.showErrorNotification()})):(Shopware.Store.get("error").addApiError({expression:`rule_condition.${this.rule.id}.value`,error:new Shopware.Classes.ShopwareError({detail:this.$tc("sw-settings-rule.error-codes.INVALID_DATE_RANGE"),code:"INVALID_DATE_RANGE"})}),this.showErrorNotification(),Promise.resolve()):Promise.resolve()},abortOnLanguageChange(){return this.ruleRepository.hasChanges(this.rule)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(e){Shopware.Store.get("context").api.languageId=e,this.isLoading=!0,this.loadEntityData(this.ruleId).then(()=>{this.isLoading=!1,this.setTreeFinishedLoading()})},saveRule(){return this.ruleRepository.save(this.rule,n.api)},syncConditions(){return this.conditionRepository.sync(this.conditionTree,n.api).then(()=>this.deletedIds.length>0?this.conditionRepository.syncDeleted(this.deletedIds,n.api).then(()=>{this.deletedIds=[]}):Promise.resolve())},showErrorNotification(){this.createNotificationError({message:this.$tc("sw-settings-rule.detail.messageSaveError",{name:this.rule.name},0)}),this.isLoading=!1},tabHasError(e){return e.route.name!=="sw.settings.rule.detail.base"?!1:!!this.ruleNameError||!!this.rulePriorityError},onCancel(){this.$router.push({name:"sw.settings.rule.index"})},onDuplicate(){return this.onSave().then(()=>{const e={overwrites:{name:`${this.rule.name} ${this.$tc("global.default.copy")}`,createdAt:null}};return this.ruleRepository.clone(this.rule.id,e,Shopware.Context.api).then(t=>{this.$router.push({name:"sw.settings.rule.detail",params:{id:t.id}})})})}}};export{p as default};
