const a=`{% block sw_order_list %} <sw-page class="sw-order-list"> {% block sw_order_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="order" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_order_list_smart_bar_header %} <template #smart-bar-header> {% block sw_order_list_smart_bar_header_title %} <h2> {% block sw_order_list_smart_bar_header_title_text %} {{ $tc('sw-order.list.textOrders') }} {% endblock %} {% block sw_order_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_order_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_order_list_smart_bar_actions_slot %} {% block sw_order_list_smart_bar_actions_add %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.creator'), showOnDisabledElements: true }" class="sw-order-list__add-order" :disabled="!acl.can('order.creator') || undefined" variant="primary" size="default" data-analytics-id="sw-order-list.add-order" @click="$router.push({ name: 'sw.order.create' })" > {{ $tc('sw-order.list.buttonAddOrder') }} </mt-button> {% endblock %} {% endblock %} </template> {% endblock %} {% block sw_order_list_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_order_list_content %} <template #content> {% block sw_order_list_content_slot %} <div class="sw-order-list__content"> {% block sw_order_list_empty_state %} <mt-empty-state v-if="!isLoading && !total" class="mt-empty-state--center" :icon="$route.meta.$module.icon" :headline="filterCriteria.length || isValidTerm(term) ? $t('sw-empty-state.messageNoResultTitle') : $t('sw-order.list.messageEmpty')" :description="filterCriteria.length || isValidTerm(term) ? $t('sw-empty-state.messageNoResultSubline') : $t($route.meta.$module.description)" :link-text="filterCriteria.length || isValidTerm(term) ? $t('sw-empty-state.messageNoResultLink') : ''" :link-href="filterCriteria.length || isValidTerm(term) ? $router.resolve({ name: 'sw.profile.index.searchPreferences' }).href : ''" /> {% endblock %} {% block sw_order_list_grid %} <sw-data-grid v-else-if="entitySearchable" ref="orderGrid" :data-source="orders" :columns="orderColumns" :full-page="true" :show-settings="true" :show-selection="true" :sort-by="currentSortBy" :sort-direction="sortDirection" :is-loading="isLoading" :allow-column-edit="true" identifier="sw-order-list" :disable-data-fetching="true" :maximum-select-items="100" @column-sort="onSortColumn" @page-change="onPageChange" @selection-change="updateSelection" > {% block sw_order_list_grid_columns %} {% block sw_order_list_grid_columns_order_number %} <template #column-orderNumber="{ item }"> {% block sw_order_list_grid_order_number_link %} <router-link :to="{ name: 'sw.order.detail', params: { id: item.id } }"> {{ item.orderNumber }} </router-link> {% endblock %} {% block sw_order_list_grid_label_manual_order %} <sw-label v-if="item.createdById" appearance="pill" size="small" class="sw-order-list__manual-order-label" > {{ $tc('sw-order.list.labelManualOrder') }} </sw-label> {% endblock %} <mt-button v-if="item.customerComment" v-tooltip="{ message: item.customerComment }" class="sw-order-list__tooltip-order-comment" size="x-small" variant="secondary" > <mt-icon name="regular-comments" size="14px" /> </mt-button> </template> {% endblock %} {% block sw_order_list_grid_columns_customer_name %} <template #column-orderCustomer.firstName="{ item }"> <router-link v-if="item.orderCustomer && item.orderCustomer.customerId" :to="{ name: 'sw.customer.detail', params: { id: item.orderCustomer.customerId } }" > {{ item.orderCustomer.lastName }}, {{ item.orderCustomer.firstName }} </router-link> <template v-else-if="item.orderCustomer"> {{ item.orderCustomer.lastName }}, {{ item.orderCustomer.firstName }} </template> </template> {% endblock %} {% block sw_order_list_grid_columns_billing_address %} <template #column-billingAddressId="{ item }"> <span v-if="item.billingAddress.company">{{ item.billingAddress.company }}<span v-if="item.billingAddress.department"> - {{ item.billingAddress.department }}</span>,&nbsp;</span> {{ item.billingAddress.street }}, {{ item.billingAddress.zipcode }} {{ item.billingAddress.city }} </template> {% endblock %} {% block sw_order_list_grid_columns_delivery_address %} <template #column-primaryOrderDelivery.shippingOrderAddress.street="{ item }"> <template v-if="item.primaryOrderDelivery?.shippingOrderAddress"> <span v-if="item.primaryOrderDelivery.shippingOrderAddress.company">{{ item.primaryOrderDelivery.shippingOrderAddress.company }}<span v-if="item.primaryOrderDelivery.shippingOrderAddress.department"> - {{ item.primaryOrderDelivery.shippingOrderAddress.department }}</span>,</span> {{ item.primaryOrderDelivery.shippingOrderAddress.street }}, {{ item.primaryOrderDelivery.shippingOrderAddress.zipcode }} {{ item.primaryOrderDelivery.shippingOrderAddress.city }} </template> </template> {% endblock %} {% block sw_order_list_grid_columns_amount %} <template #column-amountTotal="{ item }"> {{ currencyFilter(item.amountTotal, item.currency.isoCode) }} </template> {% endblock %} {% block sw_order_list_grid_columns_state %} <template #column-stateMachineState.name="{ item }"> <div class="sw-order-list__state" > <sw-color-badge :color="getVariantFromOrderState(item)" rounded /> {{ item.stateMachineState.translated.name }} </div> </template> {% endblock %} {% block sw_order_list_grid_columns_transaction_state %} <template #column-primaryOrderTransaction.stateMachineState.name="{ item }"> <div v-if="item.primaryOrderTransaction?.stateMachineState" class="sw-order-list__state" > <sw-color-badge :color="getVariantFromPaymentState(item)" rounded /> {{ item.primaryOrderTransaction.stateMachineState.translated.name }} </div> </template> {% endblock %} {% block sw_order_list_grid_columns_delivery_state %} <template #column-primaryOrderDelivery.stateMachineState.name="{ item }"> <div v-if="item.primaryOrderDelivery?.stateMachineState" class="sw-order-list__state" > <sw-color-badge :color="getVariantFromDeliveryState(item)" rounded /> {{ item.primaryOrderDelivery.stateMachineState.translated.name }} </div> </template> {% endblock %} {% block sw_order_list_grid_columns_order_date %} <template #column-orderDateTime="{ item }"> <sw-time-ago :date="item.orderDateTime" /> </template> {% endblock %} {% endblock %} {% block sw_order_list_grid_columns_actions %} <template #actions="{ item }"> {% block sw_order_list_grid_columns_actions_view %} <sw-context-menu-item class="sw-order-list__order-view-action" :router-link="{ name: 'sw.order.detail', params: { id: item.id } }" > {{ $tc('sw-order.list.contextMenuView') }} </sw-context-menu-item> {% endblock %} {% block sw_order_list_grid_columns_actions_delete %} <sw-context-menu-item variant="danger" :disabled="disableDeletion(item)" data-analytics-id="sw-order-list.delete-order" @click="onDelete(item.id)" > {{ $tc('sw-order.list.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_order_list_grid_action_modals %} <template #action-modals="{ item }"> {% block sw_order_list_delete_modal %} <sw-modal v-if="showDeleteModal === item.id" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_order_list_delete_modal_confirm_delete_text %} <p class="sw-order-list__confirm-delete-text"> {{ $tc('sw-order.list.textDeleteConfirm', { orderNumber: \`\${item.orderNumber}\` }, 0) }} </p> {% endblock %} {% block sw_order_list_delete_modal_footer %} <template #modal-footer> {% block sw_order_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" data-analytics-id="sw-order-list.delete-modal-cancel" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_order_list_delete_modal_confirm %} <mt-button variant="critical" size="small" data-analytics-id="sw-order-list.delete-modal-confirm" @click="onConfirmDelete(item.id)" > {{ $tc('sw-order.list.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} <template #pagination> {% block sw_order_list_grid_pagination %} <sw-pagination :page="page" :limit="limit" :total="total" :total-visible="7" @page-change="onPageChange" /> {% endblock %} </template> {% block sw_order_list_bulk_selected_actions_content %} <template #bulk> {% block sw_order_list_bulk_selected_actions_content_bulk_edit %} <a v-if="acl.can('order.editor')" class="link link-primary" role="link" tabindex="0" @click="showBulkEditModal = true" @keydown.enter="showBulkEditModal = true" > {{ $tc('global.sw-bulk-edit-modal.bulkEdit') }} </a> {% endblock %} </template> {% endblock %} {% block sw_order_list_bulk_edit_modal %} <template #bulk-modals="{ selection }"> {% block sw_order_list_bulk_edit_modal_inner %} <sw-bulk-edit-modal v-if="showBulkEditModal" ref="bulkEditModal" class="sw-order-bulk-edit-modal" :selection="selection" :bulk-grid-edit-columns="orderColumns" @edit-items="onBulkEditItems" @modal-close="showBulkEditModal = false" > {% block sw_order_list_bulk_edit_grid_columns_order_number %} <template #column-orderNumber="{ item }"> {% block sw_order_list_bulk_edit_grid_order_number_link %} <router-link :to="{ name: 'sw.order.detail', params: { id: item.id } }" target="_blank" rel="noreferrer noopener" > {{ item.orderNumber }} </router-link> {% endblock %} {% block sw_order_list_bulk_edit_grid_label_manual_order %} <sw-label v-if="item.createdById" appearance="pill" size="small" class="sw-order-bulk_edit__manual-order-label" > {{ $tc('sw-order.list.labelManualOrder') }} </sw-label> {% endblock %} </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_customer_name %} <template #column-orderCustomer.firstName="{ item }"> <router-link v-if="item.orderCustomer" :to="{ name: 'sw.customer.detail', params: { id: item.orderCustomer.customerId } }" target="_blank" rel="noreferrer noopener" > {{ item.orderCustomer.lastName }}, {{ item.orderCustomer.firstName }} </router-link> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_billing_address %} <template #column-billingAddressId="{ item }"> {{ item.billingAddress.street }}, {{ item.billingAddress.zipcode }} {{ item.billingAddress.city }} </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_amount %} <template #column-amountTotal="{ item }"> {{ currencyFilter(item.amountTotal, item.currency.isoCode) }} </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_state %} <template #column-stateMachineState.name="{ item }"> <sw-label :variant="getVariantFromOrderState(item)" appearance="pill" > {{ item.stateMachineState.translated.name }} </sw-label> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_transaction_state %} <template #column-primaryOrderTransaction.stateMachineState.name="{ item }"> <sw-label v-if="item.primaryOrderTransaction?.stateMachineState" :variant="getVariantFromPaymentState(item)" appearance="pill" > {{ item.primaryOrderTransaction.stateMachineState.translated.name }} </sw-label> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_delivery_state %} <template #column-primaryOrderDelivery.stateMachineState.name="{ item }"> <sw-label v-if="item.primaryOrderDelivery?.stateMachineState" :variant="getVariantFromDeliveryState(item)" appearance="pill" > {{ item.primaryOrderDelivery.stateMachineState.translated.name }} </sw-label> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_order_date %} <template #column-orderDateTime="{ item }"> <sw-time-ago :date="item.orderDateTime" /> </template> {% endblock %} </sw-bulk-edit-modal> {% endblock %} </template> {% endblock %} </sw-data-grid> {% endblock %} </div> {% endblock %} </template> {% block sw_order_list_sidebar %} <template #sidebar> <sw-sidebar class="sw-order-list__sidebar"> {% block sw_order_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-order.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} {% block sw_order_list_sidebar_filter %} <sw-sidebar-filter-panel entity="order" :store-key="storeKey" :filters="listFilters" :defaults="defaultFilters" :active-filter-number="activeFilterNumber" @criteria-changed="updateCriteria" /> {% endblock %} </sw-sidebar> </template> {% endblock %} {% endblock %} </sw-page> {% endblock %}`,{Mixin:s}=Shopware,{Criteria:r}=Shopware.Data,o={template:a,inject:["repositoryFactory","stateStyleDataProviderService","acl","filterFactory","feature"],mixins:[s.getByName("listing")],data(){return{orders:[],sortBy:"orderDateTime",sortDirection:"DESC",isLoading:!1,filterLoading:!1,showDeleteModal:!1,filterCriteria:[],defaultFilters:["order-number-filter","customer-number-filter","affiliate-code-filter","campaign-code-filter","promotion-code-filter","document-filter","order-date-filter","order-value-filter","status-filter","payment-status-filter","delivery-status-filter","payment-method-filter","shipping-method-filter","sales-channel-filter","billing-country-filter","customer-group-filter","shipping-country-filter","customer-group-filter","tag-filter","line-item-filter"],storeKey:"grid.filter.order",activeFilterNumber:0,showBulkEditModal:!1,searchConfigEntity:"order"}},metaInfo(){return{title:this.$createTitle()}},computed:{orderRepository(){return this.repositoryFactory.create("order")},orderColumns(){return this.getOrderColumns()},orderCriteria(){const e=new r(this.page,this.limit);return e.setTerm(this.term),this.sortBy.split(",").forEach(t=>{e.addSorting(r.sort(t,this.sortDirection))}),this.filterCriteria.forEach(t=>{e.addFilter(t)}),e.addAssociation("billingAddress"),e.addAssociation("salesChannel"),e.addAssociation("orderCustomer"),e.addAssociation("currency"),e.addAssociation("documents"),e.addAssociation("stateMachineState"),e.addAssociation("primaryOrderTransaction.stateMachineState"),e.addAssociation("primaryOrderDelivery.stateMachineState"),e.addAssociation("primaryOrderDelivery.shippingOrderAddress"),Shopware.Feature.isActive("v6.8.0.0")||(e.addAssociation("addresses"),e.getAssociation("transactions").addAssociation("stateMachineState").addSorting(r.sort("createdAt")),e.addAssociation("primaryOrderTransaction.paymentMethod").addAssociation("primaryOrderDelivery.shippingMethod").addAssociation("primaryOrderDelivery.shippingOrderAddress.country"),e.getAssociation("deliveries").addAssociation("stateMachineState").addAssociation("shippingOrderAddress").addAssociation("shippingMethod")),e},salesChannelCriteria(){const e=new r(1,25);return e.addSorting(r.sort("name")),e},filterSelectCriteria(){const e=new r(1,1);return e.addAggregation(r.terms("affiliateCodes","affiliateCode",null,null,null)),e.addAggregation(r.terms("campaignCodes","campaignCode",null,null,null)),e.addAggregation(r.terms("promotionCodes","lineItems.payload.code",null,null,null)),e},listFilterOptions(){return{"order-number-filter":{property:"orderNumber",type:"string-filter",label:this.$tc("sw-order.filters.orderNumberFilter.label"),placeholder:this.$tc("sw-order.filters.orderNumberFilter.placeholder"),valueProperty:"key",labelProperty:"key",criteriaFilterType:"equalsAny"},"sales-channel-filter":{property:"salesChannel",label:this.$tc("sw-order.filters.salesChannelFilter.label"),placeholder:this.$tc("sw-order.filters.salesChannelFilter.placeholder"),criteria:this.salesChannelCriteria},"order-value-filter":{property:"amountTotal",type:"number-filter",label:this.$tc("sw-order.filters.orderValueFilter.label"),fromFieldLabel:null,toFieldLabel:null,fromPlaceholder:this.$tc("global.default.from"),toPlaceholder:this.$tc("global.default.to")},"payment-status-filter":{property:"primaryOrderTransaction.stateMachineState",criteria:this.getStatusCriteria("order_transaction.state"),label:this.$tc("sw-order.filters.paymentStatusFilter.label"),placeholder:this.$tc("sw-order.filters.paymentStatusFilter.placeholder")},"delivery-status-filter":{property:"primaryOrderDelivery.stateMachineState",criteria:this.getStatusCriteria("order_delivery.state"),label:this.$tc("sw-order.filters.deliveryStatusFilter.label"),placeholder:this.$tc("sw-order.filters.deliveryStatusFilter.placeholder")},"status-filter":{property:"stateMachineState",criteria:this.getStatusCriteria("order.state"),label:this.$tc("sw-order.filters.statusFilter.label"),placeholder:this.$tc("sw-order.filters.statusFilter.placeholder")},"order-date-filter":{property:"orderDateTime",label:this.$tc("sw-order.filters.orderDateFilter.label"),dateType:"date",fromFieldLabel:null,toFieldLabel:null,showTimeframe:!0},"customer-number-filter":{property:"orderCustomer.customer.customerNumber",type:"string-filter",label:this.$tc("sw-order.filters.customerNumberFilter.label"),placeholder:this.$tc("sw-order.filters.customerNumberFilter.placeholder"),valueProperty:"key",labelProperty:"key",criteriaFilterType:"equals"},"tag-filter":{property:"tags",label:this.$tc("sw-order.filters.tagFilter.label"),placeholder:this.$tc("sw-order.filters.tagFilter.placeholder")},"affiliate-code-filter":{property:"affiliateCode",type:"string-filter",label:this.$tc("sw-order.filters.affiliateCodeFilter.label"),placeholder:this.$tc("sw-order.filters.affiliateCodeFilter.placeholder"),valueProperty:"key",labelProperty:"key"},"campaign-code-filter":{property:"campaignCode",type:"string-filter",label:this.$tc("sw-order.filters.campaignCodeFilter.label"),placeholder:this.$tc("sw-order.filters.campaignCodeFilter.placeholder"),valueProperty:"key",labelProperty:"key"},"promotion-code-filter":{property:"lineItems.payload.code",type:"string-filter",label:this.$tc("sw-order.filters.promotionCodeFilter.label"),placeholder:this.$tc("sw-order.filters.promotionCodeFilter.placeholder"),valueProperty:"key",labelProperty:"key"},"document-filter":{property:"documents",label:this.$tc("sw-order.filters.documentFilter.label"),placeholder:this.$tc("sw-order.filters.documentFilter.placeholder"),optionHasCriteria:this.$tc("sw-order.filters.documentFilter.textHasCriteria"),optionNoCriteria:this.$tc("sw-order.filters.documentFilter.textNoCriteria")},"payment-method-filter":{property:"primaryOrderTransaction.paymentMethod",label:this.$tc("sw-order.filters.paymentMethodFilter.label"),placeholder:this.$tc("sw-order.filters.paymentMethodFilter.placeholder")},"shipping-method-filter":{property:"primaryOrderDelivery.shippingMethod",label:this.$tc("sw-order.filters.shippingMethodFilter.label"),placeholder:this.$tc("sw-order.filters.shippingMethodFilter.placeholder")},"billing-country-filter":{property:"billingAddress.country",label:this.$tc("sw-order.filters.billingCountryFilter.label"),placeholder:this.$tc("sw-order.filters.billingCountryFilter.placeholder")},"shipping-country-filter":{property:"primaryOrderDelivery.shippingOrderAddress.country",label:this.$tc("sw-order.filters.shippingCountryFilter.label"),placeholder:this.$tc("sw-order.filters.shippingCountryFilter.placeholder")},"customer-group-filter":{property:"orderCustomer.customer.group",label:this.$tc("sw-order.filters.customerGroupFilter.label"),placeholder:this.$tc("sw-order.filters.customerGroupFilter.placeholder")},"line-item-filter":{property:"lineItems.product",label:this.$tc("sw-order.filters.productFilter.label"),placeholder:this.$tc("sw-order.filters.productFilter.placeholder"),criteria:this.productCriteria,displayVariants:!0}}},listFilters(){return this.filterFactory.create("order",this.listFilterOptions)},productCriteria(){const e=new r(1,25);return e.addAssociation("options.group"),e},currencyFilter(){return Shopware.Filter.getByName("currency")},dateFilter(){return Shopware.Filter.getByName("date")},assetFilter(){return Shopware.Filter.getByName("asset")}},watch:{orderCriteria:{handler(){this.getList()},deep:!0}},created(){this.createdComponent()},methods:{createdComponent(){},deliveryTooltip(e){return e.map(t=>`${t.shippingOrderAddress.street},
                        ${t.shippingOrderAddress.zipcode}
                        ${t.shippingOrderAddress.city}`).join('<hr style="margin: 8px 0">')},onEdit(e){e!=null&&e.id&&this.$router.push({name:"sw.order.detail",params:{id:e.id}})},onInlineEditSave(e){e.save()},onChangeLanguage(){this.getList()},async getList(){this.isLoading=!0;let e=await Shopware.Service("filterService").mergeWithStoredFilters(this.storeKey,this.orderCriteria);if(e=await this.addQueryScores(this.term,e),this.activeFilterNumber=e.filters.length,!this.entitySearchable){this.isLoading=!1,this.total=0;return}this.freshSearchTerm&&e.resetSorting();try{const t=await this.orderRepository.search(e);this.total=t.total,this.orders=t,this.isLoading=!1}catch{this.isLoading=!1}},getBillingAddress(e){return e.addresses.find(t=>t.id===e.billingAddressId)},disableDeletion(e){return this.acl.can("order.deleter")?e.documents.length>0:!0},getOrderColumns(){return[{property:"orderNumber",label:"sw-order.list.columnOrderNumber",routerLink:"sw.order.detail",allowResize:!0,primary:!0},{property:"salesChannel.name",label:"sw-order.list.columnSalesChannel",allowResize:!0,visible:!1},{property:"orderCustomer.firstName",dataIndex:"orderCustomer.lastName,orderCustomer.firstName",label:"sw-order.list.columnCustomerName",allowResize:!0},{property:"orderCustomer.company",label:"sw-order.list.columnCustomerCompany",allowResize:!0,visible:!1},{property:"billingAddressId",dataIndex:"billingAddress.street",label:"sw-order.list.columnBillingAddress",allowResize:!0,visible:!1},{property:"primaryOrderDelivery.shippingOrderAddress.street",label:"sw-order.list.columnDeliveryAddress",allowResize:!0},{property:"amountTotal",label:"sw-order.list.columnAmount",align:"right",allowResize:!0},{property:"stateMachineState.name",label:"sw-order.list.columnState",allowResize:!0},{property:"primaryOrderTransaction.stateMachineState.name",label:"sw-order.list.columnTransactionState",allowResize:!0},{property:"primaryOrderDelivery.stateMachineState.name",label:"sw-order.list.columnDeliveryState",allowResize:!0},{property:"orderDateTime",label:"sw-order.list.orderDate",allowResize:!0},{property:"affiliateCode",inlineEdit:"string",label:"sw-order.list.columnAffiliateCode",allowResize:!0,visible:!1},{property:"campaignCode",inlineEdit:"string",label:"sw-order.list.columnCampaignCode",allowResize:!0,visible:!1}]},getVariantFromOrderState(e){return this.stateStyleDataProviderService.getStyle("order.state",e.stateMachineState.technicalName).colorCode},getVariantFromPaymentState(e){var i;let t=(i=e.primaryOrderTransaction)==null?void 0:i.stateMachineState.technicalName;if(!Shopware.Feature.isActive("v6.8.0.0")){t=e.transactions.last().stateMachineState.technicalName;for(let l=0;l<e.transactions.length;l+=1)if(!["cancelled","failed"].includes(e.transactions[l].stateMachineState.technicalName)){t=e.transactions[l].stateMachineState.technicalName;break}}return this.stateStyleDataProviderService.getStyle("order_transaction.state",t).colorCode},getVariantFromDeliveryState(e){var i;let t=(i=e.primaryOrderDelivery)==null?void 0:i.stateMachineState.technicalName;return Shopware.Feature.isActive("v6.8.0.0")||(t=this.getDelivery(e).stateMachineState.technicalName),this.stateStyleDataProviderService.getStyle("order_delivery.state",t).colorCode},onDelete(e){this.showDeleteModal=e},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(e){return this.showDeleteModal=!1,this.orderRepository.delete(e).then(()=>{this.$refs.orderGrid.resetSelection(),this.getList()})},updateCriteria(e){this.page=1,this.filterCriteria=e},getStatusCriteria(e){const t=new r(1,25);return t.addFilter(r.equals("stateMachine.technicalName",e)),t},async onBulkEditItems(){await this.$nextTick();const t=Object.values(this.$refs.orderGrid.selection).filter(i=>Shopware.Feature.isActive("v6.8.0.0")?!i.primaryOrderDelivery:!this.getDelivery(i)).length>0?"1":"0";this.$router.push({name:"sw.bulk.edit.order",params:{excludeDelivery:t}})},transaction(e){if(Shopware.Feature.isActive("v6.8.0.0"))return e.primaryOrderTransaction;for(let t=0;t<e.transactions.length;t+=1)if(!["cancelled","failed"].includes(e.transactions[t].stateMachineState.technicalName))return e.transactions[t];return e.transactions.last()},getDelivery(e){return Shopware.Feature.isActive("v6.8.0.0")?e.primaryOrderDelivery:e.deliveries[0]}}};export{o as default};
