const r=`{% block sw_product_stream_value %} <div class="sw-product-stream-value" :class="componentClasses" > <template v-if="!fieldDefinition"> {% block sw_product_stream_value_no_definition_placeholder %} <sw-container ref="product-stream-value-placeholder" class="sw-product-stream-value__placeholder" /> {% endblock %} </template> <template v-else-if="fieldType === 'boolean'"> {% block sw_product_stream_value_boolean_value %} <sw-single-select ref="product-stream-value-select-boolean" class="sw-product-stream-value__select" size="medium" :options="booleanOptions" :value="condition.value" :disabled="disabled" show-clearable-button @update:value="setBooleanValue" /> {% endblock %} </template> <template v-else-if="fieldType === 'empty'"> {% block sw_product_stream_value_empty_value %} <sw-single-select ref="product-stream-value-select-empty" v-model:value="emptyValue" name="sw-field--emptyValue" class="sw-product-stream-value__select" size="medium" :options="reversedEmptyOptions" :disabled="disabled" show-clearable-button /> {% endblock %} </template> <template v-else> {% block sw_product_stream_value_operator_select %} <sw-arrow-field ref="product-stream-value-operator-select" class="sw-product-stream-value__operator-select" :disabled="!acl.can('product_stream.editor')" > <sw-single-select v-model:value="filterType" name="sw-field--filterType" size="medium" :options="operators" :placeholder="$tc('sw-product-stream.filter.placeholderOperatorSelect')" :disabled="disabled" show-clearable-button /> </sw-arrow-field> {% endblock %} <template v-if="fieldType === 'product_state_list'"> <sw-single-select ref="product-stream-state-options" v-model:value="actualCondition.value" :options="productStateOptions" :disabled="disabled" /> </template> <template v-else-if="isEntityCustomField(fieldName)"> {% block sw_product_stream_value_entity_single_value_custom_field %} <sw-entity-single-select v-if="!isMultiSelectValue" ref="product-stream-value-select-custom-field" v-model:value="actualCondition.value" size="medium" :entity="getCustomFieldEntityName(fieldName)" :criteria="isProductEntity ? productCriteria : customFieldCriteria" :context="context" :disabled="disabled" :display-variants="isProductEntity" show-clearable-button @select-collapsed="onSelectCollapsed" @search-term-change="setSearchTerm" > <template #selection-label-property="{ item }"> <slot name="selection-label-property" v-bind="{ item }" > {{ item.translated?.name || item.name }} </slot> </template> </sw-entity-single-select> {% endblock %} {% block sw_product_stream_value_entity_multi_value_custom_field %} <sw-entity-multi-id-select v-else-if="isMultiSelectValue" ref="product-stream-value-select-entity-multi-id-select" v-model:value="multiValue" size="medium" :repository="entityCustomFieldRepository" :criteria="customFieldCriteria" :context="context" :disabled="disabled" @select-collapsed="onSelectCollapsed" @search-term-change="setSearchTerm" > <template #result-label-property="{ item, searchTerm, highlightSearchTerm }"> <slot name="result-label-property" v-bind="{ item, searchTerm, highlightSearchTerm }" > <sw-product-variant-info v-if="isProductEntity" highlighted :variations="item.variation" :search-term="searchTerm" > {{ item.translated?.name || item.name }} </sw-product-variant-info> <template v-else> {{ item.translated?.name || item.name }} </template> </slot> </template> </sw-entity-multi-id-select> {% endblock %} </template> <template v-else-if="fieldType === 'uuid'"> {% block sw_product_stream_value_entity_single_value %} <sw-entity-single-select v-if="definition.entity === 'product' && actualCondition.type === 'equals'" ref="product-stream-value-select-single-value" v-model:value="actualCondition.value" size="medium" show-clearable-button :entity="definition.entity" :criteria="productCriteria" :context="context" :disabled="disabled" advanced-selection-component="sw-advanced-selection-product" > <template #selection-label-property="{ item }"> <slot name="selection-label-property" v-bind="{ item }" > {% block sw_product_stream_value_results_variant_info %} <sw-product-variant-info :variations="item.variation" > {{ item.translated.name || item.name }} </sw-product-variant-info> {% endblock %} </slot> </template> <template #result-item="{ item, index }"> <slot name="result-item" v-bind="{ item, index }" > <sw-select-result v-bind="{ item, index }" > {% block sw_product_stream_value_results_list_result_label %} <span class="sw-select-result__result-item-text"> <sw-product-variant-info :variations="item.variation" > {{ item.translated.name || item.name }} </sw-product-variant-info> </span> {% endblock %} </sw-select-result> </slot> </template> </sw-entity-single-select> <sw-entity-single-select v-else-if="definition.entity === 'property_group_option' && actualCondition.type === 'equals'" ref="product-stream-value-select-group-option" v-model:value="actualCondition.value" size="medium" :entity="definition.entity" :criteria="propertyCriteria" :context="context" :disabled="disabled" show-clearable-button @select-collapsed="onSelectCollapsed" @search-term-change="setSearchTerm" > <template #selection-label-property="{ item }"> <slot name="selection-label-property" v-bind="{ item }" > {{ item.group.translated.name || item.group.name }}: {{ item.translated.name || item.name }} </slot> </template> <template #result-description-property="{ item }"> <slot name="result-description-property" v-bind="{ item }" > {{ item.group.translated.name || item.group.name }} </slot> </template> </sw-entity-single-select> {% block sw_product_stream_value_entity_single_value_visibilities %} <sw-entity-single-select v-else-if="definition.entity === 'product_visibility' && actualCondition.type === 'equals'" ref="product-stream-value-select-value-visibilities" v-model:value="actualCondition.value" size="medium" :entity="definition.entity" :criteria="visibilitiesCriteria" :label-callback="visibilitiesLabelCallback" :context="context" :disabled="disabled" show-clearable-button @search-term-change="setSearchTerm" /> {% endblock %} <sw-entity-single-select v-else-if="actualCondition.type === 'equals'" ref="product-stream-value-select-equals-uuid" v-model:value="actualCondition.value" size="medium" :entity="definition.entity" :context="context" :disabled="disabled" description-position="bottom" show-clearable-button > <template #result-description-property="{ item }"> {% block sw_product_stream_value_equals_result_label %} <slot v-if="definition.entity === 'category'" name="result-description-property" v-bind="{ item }" > {% block sw_product_stream_value_equals_result_label_default %} {{ getCategoryBreadcrumb(item) }} {% endblock %} </slot> {% endblock %} </template> </sw-entity-single-select> {% endblock %} {% block sw_product_stream_value_entity_multi_value %} <sw-entity-multi-id-select v-else-if="definition.entity === 'property_group_option' && (actualCondition.type === 'equalsAny' || actualCondition.type === 'equalsAll')" ref="product-stream-value-select-multi-value" v-model:value="multiValue" size="medium" :repository="repository" :criteria="propertyCriteria" :context="context" :disabled="disabled" @select-collapsed="onSelectCollapsed" @search-term-change="setSearchTerm" > <template #selection-label-property="{ item }"> <slot name="selection-label-property" v-bind="{ item }" > {{ item.group.translated.name || item.group.name }}: {{ item.translated.name || item.name }} </slot> </template> <template #result-label-property="{ item, searchTerm, highlightSearchTerm }"> <slot name="result-label-property" v-bind="{ item, searchTerm, highlightSearchTerm }" > {{ item.translated.name || item.name }} </slot> </template> <template #result-description-property="{ item, searchTerm, highlightSearchTerm }"> <slot name="result-description-property" v-bind="{ item, searchTerm, highlightSearchTerm }" > {{ item.group.translated.name || item.group.name }} </slot> </template> </sw-entity-multi-id-select> <sw-entity-multi-id-select v-else-if="definition.entity === 'product' && (actualCondition.type === 'equalsAny' || actualCondition.type === 'equalsAll')" ref="product-stream-value-select-multi-value-equals" v-model:value="multiValue" size="medium" :repository="repository" :criteria="productCriteria" :context="context" :disabled="disabled" advanced-selection-component="sw-advanced-selection-product" > <template #selection-label-property="{ item }"> <slot name="selection-label-property" v-bind="{ item }" > <sw-product-variant-info class="product-view" :variations="item.variation" > {{ item.translated.name || item.name }} </sw-product-variant-info> </slot> </template> <template #result-label-property="{ item, index }"> <slot name="result-label-property" v-bind="{ item, index }" > {% block sw_product_stream_value_results_list_result_label %} <span class="sw-select-result__result-item-text"> <sw-product-variant-info :variations="item.variation"> {{ item.translated.name || item.name }} </sw-product-variant-info> </span> {% endblock %} </slot> </template> </sw-entity-multi-id-select> {% block sw_product_stream_value_entity_multi_value_visibilities %} <sw-entity-multi-id-select v-else-if="definition.entity === 'product_visibility' && (actualCondition.type === 'equalsAny' || actualCondition.type === 'equalsAll')" ref="product-stream-value-select-multi-value-visibilities" v-model:value="multiValue" size="medium" :repository="repository" :criteria="visibilitiesCriteria" :context="context" :disabled="disabled" @search-term-change="setSearchTerm" > <template #selection-label-property="{ item }"> <slot name="selection-label-property" v-bind="{ item }" > {{ item.salesChannel.translated.name }}: {{ item.product.translated.name }} </slot> </template> <template #result-label-property="{ item, searchTerm, highlightSearchTerm }"> <slot name="result-label-property" v-bind="{ item, searchTerm, highlightSearchTerm }" > {{ item.salesChannel.translated.name }}: {{ item.product.translated.name }} </slot> </template> </sw-entity-multi-id-select> {% endblock %} <sw-entity-multi-id-select v-else-if="isMultiSelectValue" ref="product-stream-value-select-multi-id-select-value" v-model:value="multiValue" size="medium" description-position="bottom" :repository="repository" :context="context" :disabled="disabled" :advanced-selection-component="definition.entity === 'product' ? 'sw-advanced-selection-product' : ''" > <template #result-description-property="{ item }"> {% block sw_product_stream_value_multi_select_result_label %} <slot v-if="definition.entity === 'category'" name="result-description-property" v-bind="{ item }" > {% block sw_product_stream_value_multi_select_result_label_default %} {{ getCategoryBreadcrumb(item) }} {% endblock %} </slot> {% endblock %} </template> </sw-entity-multi-id-select> {% endblock %} {% block sw_product_stream_value_entity_no_operator_selected_placeholder %} <sw-container v-else ref="product-stream-value-selected-placeholder" class="sw-product-stream-value__placeholder" /> {% endblock %} </template> <template v-else-if="getConditionType(condition) === 'range'"> {% block sw_product_stream_value_range_value %} <template v-if="filterType === 'range'"> {% block sw_product_stream_value_range_from_value %} <sw-arrow-field ref="product-stream-value-range-from-arrow-field" :disabled="disabled" > <component :is="inputComponent" v-model:value="gte" size="medium" :disabled="disabled" :step="1" /> </sw-arrow-field> {% endblock %} {% block sw_product_stream_value_range_to_value %} <component :is="inputComponent" ref="product-stream-value-range-to-value-component" v-model:value="lte" size="medium" :disabled="disabled" :step="1" /> {% endblock %} </template> <template v-else> {% block sw_product_stream_value_range_one_limit %} <component :is="inputComponent" ref="product-stream-value-range-one-limit-component" v-model:value="currentParameter" size="medium" :disabled="disabled" :step="1" /> {% endblock %} </template> {% endblock %} </template> <template v-else-if="actualCondition.type === 'equalsAny'"> {% block sw_product_stream_value_multi_value %} <sw-tagged-field ref="product-stream-value-multi-value-tagged-field" v-model:value="multiValue" size="medium" /> {% endblock %} </template> <template v-else-if="filterType === 'since' || filterType === 'until'"> {% block sw_product_stream_value_relative_time_operator %} <sw-arrow-field ref="product-stream-value-relative-time-arrow-field" :disabled="disabled" > <sw-single-select v-model:value="operator" size="medium" :options="relativeTimeOperators" :placeholder="$tc('sw-product-stream.filter.placeholderOperatorSelect')" :disabled="disabled" /> </sw-arrow-field> {% endblock %} {% block sw_product_stream_value_relative_time_value %} <mt-number-field ref="product-stream-value-relative-time-number-field" v-model="stringValue" class="sw-product-stream-value__time-input" size="medium" number-type="int" :min="0" :step="1" :disabled="disabled" > <template #suffix> <span>{{ $tc('sw-product-stream.filter.timeUnits.days') }}</span> </template> </mt-number-field> {% endblock %} </template> <template v-else> {% block sw_product_stream_value_single_value %} <component :is="inputComponent" ref="product-stream-value-single-value-component" v-model:value="stringValue" size="medium" :disabled="disabled" :step="1" /> {% endblock %} </template> </template> </div> {% endblock %}`,{Criteria:a}=Shopware.Data,s={template:r,inject:["repositoryFactory","conditionDataProviderService","productCustomFields","acl","feature"],emits:["empty-change","type-change","boolean-change"],props:{condition:{type:Object,required:!0},fieldName:{type:String,required:!1,default:null},definition:{type:Object,required:!0},disabled:{type:Boolean,required:!1,default:!1}},data(){return{value:null,childComponentsCount:null,searchTerm:""}},computed:{repository(){return this.repositoryFactory.create(this.definition.entity)},entityCustomFieldRepository(){return this.repositoryFactory.create(this.getCustomFieldEntityName(this.fieldName))},componentClasses(){return[this.growthClass,this.disabledClass]},growthClass(){return`sw-product-stream-value--grow-${this.childComponentsCount}`},disabledClass(){return this.disabled?"is--disabled":null},actualCondition(){return this.condition.type==="not"?this.condition.queries[0]:this.condition},isMultiSelectValue(){return this.actualCondition.type==="equalsAny"||this.actualCondition.type==="equalsAll"||this.actualCondition.type==="notEqualsAll"},filterType:{get(){const e=this.getConditionType(this.condition);return e==="range"?this.getRangeType(this.actualCondition):e},set(e){if(this.conditionDataProviderService.isRangeType(e)){this.onChangeType("range",this.getParameters(e));return}if(this.conditionDataProviderService.isRelativeTimeType(e)){this.onChangeType(e,this.getParameters(e));return}this.onChangeType(e,null)}},fieldDefinition(){const e=this.definition.getField(this.fieldName);return!e&&this.definition.entity==="product"&&this.fieldName?this.conditionDataProviderService.allowedJsonAccessors.hasOwnProperty(this.fieldName)?this.conditionDataProviderService.allowedJsonAccessors[this.fieldName]:this.productCustomFields[this.fieldName.replace("customFields.","")]||null:e},operators(){return this.fieldType===null?[]:this.conditionDataProviderService.getOperatorSet(this.fieldType).map(e=>({label:this.$tc(e.label),value:e.identifier}))},relativeTimeOperators(){return this.conditionDataProviderService.getOperator(this.filterType).operators.map(t=>{const i=this.conditionDataProviderService.getOperator(t);return{label:this.$tc(i.label),value:i.identifier}})},productStateOptions(){return[{label:this.$tc("sw-product-stream.filter.values.productStates.physical"),value:"is-physical"},{label:this.$tc("sw-product-stream.filter.values.productStates.digital"),value:"is-download"}]},fieldType(){return this.fieldDefinition?this.fieldDefinition.type==="json_list"&&this.fieldName==="states"?"product_state_list":this.definition.isJsonField(this.fieldDefinition)?"object":this.fieldDefinition.type==="uuid"&&Object.keys(this.definition.filterProperties(t=>t.localField===this.fieldName&&t.relation==="many_to_one")).length>0?"empty":this.fieldDefinition.type:null},booleanOptions(){return[{label:this.$tc("global.default.yes"),value:"1"},{label:this.$tc("global.default.no"),value:"0"}]},reversedEmptyOptions(){return[{label:this.$tc("global.default.yes"),value:!1},{label:this.$tc("global.default.no"),value:!0}]},multiValue:{get(){return typeof this.actualCondition.value!="string"||this.actualCondition.value===""?[]:this.actualCondition.value.split("|")},set(e){this.actualCondition.value=e.join("|")}},inputComponent(){switch(this.fieldType){case"uuid":return"sw-entity-multi-id-select";case"float":case"int":return"sw-number-field";case"date":return"sw-datepicker";case"string":case"object":default:return"sw-text-field"}},currentParameter:{get(){return this.actualCondition.parameters?this.actualCondition.parameters[this.getParameterName(this.filterType)]:null},set(e){const t=this.getParameterName(this.filterType);this.actualCondition.parameters={[t]:e}}},gte:{get(){return this.actualCondition.parameters?this.actualCondition.parameters.gte:null},set(e){this.actualCondition.parameters.gte=e}},lte:{get(){return this.actualCondition.parameters?this.actualCondition.parameters.lte:null},set(e){this.actualCondition.parameters.lte=e}},operator:{get(){return this.actualCondition.parameters?this.getParameterType(this.actualCondition.parameters.operator):null},set(e){this.actualCondition.parameters.operator=this.getParameterName(e)}},emptyValue:{get(){return this.condition.type!==null?this.filterType==="equals":null},set(e){if(e==null){this.$emit("empty-change",{type:null});return}this.$emit("empty-change",{type:e?"equals":"notEquals"})}},stringValue:{get(){return["int","float"].includes(this.fieldType)?Number.parseFloat(this.actualCondition.value):typeof this.actualCondition.value!="string"?null:this.conditionDataProviderService.isRelativeTimeType(this.filterType)&&this.actualCondition.value?this.actualCondition.value.match(/\d+/)[0]:this.actualCondition.value},set(e){if(this.conditionDataProviderService.isRelativeTimeType(this.filterType)){this.actualCondition.value=`P${e}D`;return}this.actualCondition.value=e.toString()}},context(){return{...Shopware.Context.api,inheritance:!0}},productCriteria(){const e=new a(1,25);return e.addAssociation("options.group"),e},propertyCriteria(){const e=new a(1,25);return this.definition.entity==="property_group_option"&&(e.addAssociation("group"),typeof this.searchTerm=="string"&&this.searchTerm.length>0&&e.addQuery(a.contains("group.name",this.searchTerm),500)),e},visibilitiesCriteria(){const e=new a(1,25);return e.addAssociation("salesChannel"),e.addAssociation("product"),typeof this.searchTerm=="string"&&this.searchTerm.length>0&&(e.addQuery(a.contains("salesChannel.name",this.searchTerm),400),e.addQuery(a.contains("product.name",this.searchTerm),500)),e},resultCriteria(){const e=new a(1,25);return e.addAssociation("options.group"),e},customFieldCriteria(){if(this.isProductEntity)return this.productCriteria;const e=new a(1,25);return typeof this.searchTerm=="string"&&this.searchTerm.length>0&&e.addQuery(a.contains("name",this.searchTerm),500),e},visibilitiesLabelCallback(){return e=>e?!e.salesChannel||!e.product?e.id:`${e.salesChannel.translated.name}: ${e.product.translated.name}`:""},isProductEntity(){return this.getCustomFieldEntityName(this.fieldName)==="product"}},mounted(){setTimeout(()=>{this.childComponentsCount=Object.keys(this.$refs??{}).length})},methods:{onChangeType(e,t){this.$emit("type-change",{type:e,parameters:t})},getConditionType(e){if(this.condition.type==="not"){const t=e.queries[0].type;return this.conditionDataProviderService.negateOperator(t).identifier}return this.condition.type},getRangeType(e){if(e.parameters===null)return null;const t=e.parameters.hasOwnProperty("lte"),i=e.parameters.hasOwnProperty("gte");return i&&t?this.conditionDataProviderService.getOperator("range").identifier:i?this.conditionDataProviderService.getOperator("greaterThanEquals").identifier:t?this.conditionDataProviderService.getOperator("lessThanEquals").identifier:this.condition.parameters.hasOwnProperty("lt")?this.conditionDataProviderService.getOperator("lessThan").identifier:this.condition.parameters.hasOwnProperty("gt")?this.conditionDataProviderService.getOperator("greaterThan").identifier:null},getParameters(e){if(e==="range")return{lte:null,gte:null};if(e==="since"||e==="until")return{operator:null};const t=this.getParameterName(e);return t?{[t]:null}:null},getParameterName(e){switch(e){case"greaterThanEquals":return"gte";case"lessThanEquals":return"lte";case"lessThan":return"lt";case"greaterThan":return"gt";case"equals":return"eq";case"notEquals":return"neq";default:return null}},getParameterType(e){switch(e){case"gte":return"greaterThanEquals";case"lte":return"lessThanEquals";case"lt":return"lessThan";case"gt":return"greaterThan";case"eq":return"equals";case"neq":return"notEquals";default:return null}},setBooleanValue(e){this.$emit("boolean-change",{type:+e?"equals":"notEquals",value:e})},setSearchTerm(e){this.searchTerm=e},onSelectCollapsed(){this.searchTerm=""},getCategoryBreadcrumb(e){return!e.breadcrumb||Object.keys(e.breadcrumb).length===0?e.name:Object.values(e.breadcrumb).join(" / ")},isEntityCustomField(e){var l;const t=e==null?void 0:e.replace(/customFields\./,""),i=this.productCustomFields[t];return((l=i==null?void 0:i.config)==null?void 0:l.customFieldType)==="entity"},getCustomFieldEntityName(e){const t=e.replace(/customFields\./,"");return this.productCustomFields[t].config.entity}}};export{s as default};
