const o=`{% block sw_data_grid %} <div class="sw-data-grid" :class="classes" > {% block sw_data_grid_wrapper %} <div ref="wrapper" class="sw-data-grid__wrapper" > {% block sw_data_grid_bulk %} <div v-if="selectionCount > 0" class="sw-data-grid__bulk" > {% block sw_data_grid_bulk_selected_count %} <span class="sw-data-grid__bulk-selected sw-data-grid__bulk-selected-label">{{ $tc('global.sw-data-grid.labelSelectionCount') }}</span> <span class="sw-data-grid__bulk-selected sw-data-grid__bulk-selected-count">{{ selectionCount }}</span> <span v-if="reachMaximumSelectionExceed" class="sw-data-grid__bulk-selected sw-data-grid__bulk-max-selection" > {{ $tc('global.sw-data-grid.maximumSelectionExceed') }} </span> {% endblock %} {% block sw_data_grid_bulk_selected_actions %} <span class="sw-data-grid__bulk-selected bulk-link"> <a v-if="hasInvisibleSelection" class="link link-warning bulk-deselect-all" role="button" tabindex="0" @click="resetSelection" @keydown.enter="resetSelection" > {{ $tc('global.sw-data-grid.labelDeSelectAll') }} </a> <slot name="bulk"> {% block sw_data_grid_bulk_selected_actions_content %}{% endblock %} </slot> </span> {% endblock %} </div> {% endblock %} {% block sw_data_grid_bulk_modals %} <slot name="bulk-modals" v-bind="{ selection }" > {% block sw_data_grid_slot_bulk_modals %}{% endblock %} </slot> {% endblock %} {% block sw_data_grid_table %} <table ref="table" class="sw-data-grid__table" > {% block sw_data_grid_header %} <thead v-if="showHeader" class="sw-data-grid__header" > {% block sw_data_grid_header_row %} <tr class="sw-data-grid__row"> {% block sw_data_grid_header_cell_selection %} <th v-if="showSelection" class="sw-data-grid__cell sw-data-grid__cell--header sw-data-grid__cell--selection" > {% block sw_data_grid_header_cell_selection_content %} <div class="sw-data-grid__cell-content"> {% block sw_data_grid_select_all_checkbox %} <mt-checkbox v-if="records && records.length > 0" :aria-label="$tc(allSelectedChecked ? 'global.sw-data-grid.labelDeSelectAll' : 'global.sw-data-grid.labelSelectAll')" :disabled="isSelectAllDisabled" class="sw-data-grid__select-all" :checked="allSelectedChecked" @update:checked="selectAll" /> {% endblock %} </div> {% endblock %} </th> {% endblock %} {% block sw_data_grid_header_columns %} <th v-for="(column, columnIndex) in currentColumns" v-show="column.visible" :key="\`\${column.property}-\${columnIndex}\`" ref="column" class="sw-data-grid__cell sw-data-grid__cell--header sw-data-grid__cell--property" :class="getHeaderCellClasses(column, columnIndex)" :style="{ width: column.width, minWidth: column.width }" @click="onClickHeaderCell($event, column)" > {% block sw_data_grid_header_columns_content %} <div class="sw-data-grid__cell-content"> <slot :name="\`column-label-\${column.property}\`" v-bind="{ column, columnIndex }" > {% block sw_data_grid_header_columns_icon %} <mt-icon v-if="column.iconLabel && column.iconTooltip" v-tooltip="column.iconTooltip" :name="column.iconLabel" > {{ $te((column.label ?? 'undefined')) ? $tc(column.label) : column.label }} </mt-icon> <mt-icon v-else-if="column.iconLabel" :name="column.iconLabel" > {{ $te((column.label ?? 'undefined')) ? $tc(column.label) : column.label }} </mt-icon> {% endblock %} {% block sw_data_grid_header_columns_label %} <template v-else> {{ $te((column.label ?? 'undefined')) ? $tc(column.label) : column.label }} </template> {% endblock %} </slot> {% block sw_data_grid_column_actions %} <sw-context-button v-if="allowColumnEdit && !isInlineEditActive" class="sw-data-grid__action-edit-column" aria-label="global.sw-data-grid.columnsActions" > {% block sw_data_grid_column_actions_hide %} <sw-context-menu-item :disabled="column.primary" variant="danger" @click="hideColumn(columnIndex)" > {{ $tc('global.sw-data-grid.labelColumnHide') }} </sw-context-menu-item> {% endblock %} </sw-context-button> {% endblock %} {% block sw_data_grid_sort_indicator %} <span v-if="column.sortable && currentSortBy === column.dataIndex" class="sw-data-grid__sort-indicator" > {% block sw_data_grid_sort_indicator_transition %} <transition name="sort-indicator" mode="out-in" > {% block sw_data_grid_sort_indicator_icon_asc %} <mt-icon v-if="currentSortDirection === 'ASC'" key="ASC" name="regular-chevron-up-xxs" size="16px" /> {% endblock %} {% block sw_data_grid_sort_indicator_icon_desc %} <mt-icon v-else key="DESC" name="regular-chevron-down-xxs" size="16px" /> {% endblock %} </transition> {% endblock %} </span> {% endblock %} </div> {% endblock %} {% block sw_data_grid_header_columns_resize %} <span v-if="column.allowResize" class="sw-data-grid__cell-resize" @mousedown="onStartResize($event, column, columnIndex)" ></span> {% endblock %} </th> {% endblock %} {% block sw_data_grid_header_cell_spacer %} <th v-if="hasResizeColumns" aria-hidden="true" class="sw-data-grid__cell sw-data-grid__cell--header sw-data-grid__cell-spacer" > <div class="sw-data-grid__cell-content"></div> </th> {% endblock %} {% block sw_data_grid_header_cell_actions %} <th v-if="showActions" class="sw-data-grid__cell sw-data-grid__cell--header sw-data-grid__cell--actions sw-data-grid__cell-settings" :class="{ 'is--loading': loading }" > {% block sw_data_grid_header_cell_actions_content %} <div class="sw-data-grid__cell-content"> {% block sw_data_grid_settings %} <sw-data-grid-settings v-if="showSettings" :columns="currentColumns" :compact="compact" :previews="previews" :enable-previews="hasPreviewSlots" :disabled="isInlineEditActive" @change-compact-mode="onChangeCompactMode" @change-preview-images="onChangePreviews" @change-column-visibility="onChangeColumnVisibility" @change-column-order="onChangeColumnOrder" > {% block sw_data_grid_settings_additional_settings %} <template #additionalSettings> {% block sw_data_grid_settings_additional_settings_inner %} <slot name="additionalSettings"></slot> {% endblock %} </template> {% endblock %} </sw-data-grid-settings> {% block sw_data_grid_settings_custom_settings %} <slot name="customSettings"> {% block sw_data_grid_settings_custom_settings_slot %}{% endblock %} </slot> {% endblock %} {% endblock %} </div> {% endblock %} </th> {% endblock %} </tr> {% endblock %} </thead> {% endblock %} {% block sw_data_grid_body %} <tbody v-if="!loading" class="sw-data-grid__body" > {% block sw_data_grid_body_row %} <tr v-for="(item, itemIndex) in records" :key="item.id" class="sw-data-grid__row" :class="getRowClasses(item, itemIndex)" > {% block sw_data_grid_body_cell_selection %} <td v-if="showSelection" class="sw-data-grid__cell sw-data-grid__cell--selection" > <slot name="selection-content" v-bind="{ item, isSelected, isRecordSelectable, selectItem, itemIdentifierProperty }" > {% block sw_data_grid_body_cell_selection_content %} <div class="sw-data-grid__cell-content"> {% block sw_data_grid_select_item_checkbox %} <mt-checkbox :aria-label="$tc('global.sw-data-grid.labelSelected')" :disabled="!isRecordSelectable(item)" :checked="isSelected(item[itemIdentifierProperty])" @update:checked="selectItem($event, item)" /> {% endblock %} </div> {% endblock %} </slot> </td> {% endblock %} {% block sw_data_grid_body_columns %} <td v-for="(column, columnIndex) in currentVisibleColumns" :key="\`\${item.id}-\${columnIndex}\`" class="sw-data-grid__cell" :class="getCellClasses(column)" role="gridcell" @dblclick="onDbClickCell(item)" > <sw-provide :aria-label="column.label"> {% block sw_data_grid_body_columns_content %} <div class="sw-data-grid__cell-content"> {% block sw_data_grid_preview_slot %} <slot v-if="previews && !isInlineEdit(item)" :name="\`preview-\${column.property}\`" v-bind="{ item, column, compact }" ></slot> {% endblock %} {% block sw_data_grid_columns_slot %} <slot :name="\`column-\${column.property}\`" v-bind="{ item, itemIndex, column, columnIndex, compact, isInlineEdit: (isInlineEdit(item) && column.hasOwnProperty('inlineEdit')), selectItem }" > <template v-if="column.inlineEdit === 'boolean'"> {% block sw_data_grid_columns_boolean %} <sw-data-grid-column-boolean v-model:value="item[column.property]" :is-inline-edit="isInlineEdit(item) && column.hasOwnProperty('inlineEdit')" /> {% endblock %} </template> <template v-else> {% block sw_data_grid_columns_inline_edit %} <template v-if="isInlineEdit(item) && column.hasOwnProperty('inlineEdit')"> {% block sw_data_grid_columns_render_inline_edit %} <sw-data-grid-inline-edit v-model:value="item[column.property]" :column="column" :compact="compact" /> {% endblock %} </template> {% endblock %} {% block sw_data_grid_columns_value %} <template v-else> {% block sw_data_grid_columns_render_router_link %} <router-link v-if="column.routerLink" class="sw-data-grid__cell-value" :to="{ name: column.routerLink, params: { id: item.id } }" > {{ renderColumn(item, column) }} </router-link> {% endblock %} {% block sw_data_grid_columns_render_value %} <span v-else class="sw-data-grid__cell-value" > {{ renderColumn(item, column) }} </span> {% endblock %} </template> {% endblock %} </template> </slot> {% endblock %} </div> {% endblock %} </sw-provide> </td> {% endblock %} {% block sw_data_grid_body_cell_spacer %} <td v-if="hasResizeColumns" aria-hidden="true" class="sw-data-grid__cell sw-data-grid__cell-spacer" @dblclick="onDbClickCell(item)" > <div class="sw-data-grid__cell-content"></div> </td> {% endblock %} {% block sw_data_grid_body_cell_actions %} <td v-if="showActions" class="sw-data-grid__cell sw-data-grid__cell--actions" > {% block sw_data_grid_body_cell_actions_content %} <div class="sw-data-grid__cell-content"> {% block sw_data_grid_inline_edit_actions %} <template v-if="isInlineEditActive && currentInlineEditId === item[itemIdentifierProperty]"> {% block sw_data_grid_inline_edit_actions_cancel %} <mt-button class="sw-data-grid__inline-edit-cancel" size="x-small" :title="$tc('global.default.cancel')" :aria-label="$tc('global.default.cancel')" square variant="secondary" @click="onClickCancelInlineEdit(item)" > {% block sw_data_grid_inline_edit_actions_cancel_icon %} <mt-icon name="regular-times-xs" size="10px" /> {% endblock %} </mt-button> {% endblock %} {% block sw_data_grid_inline_edit_actions_save %} <mt-button class="sw-data-grid__inline-edit-save" variant="primary" size="x-small" :title="$tc('global.default.save')" :aria-label="$tc('global.default.save')" square @click="onClickSaveInlineEdit(item)" > {% block sw_data_grid_inline_edit_actions_save_icon %} <mt-icon name="regular-checkmark-xxs" size="10px" /> {% endblock %} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_data_grid_body_cell_actions_menu %} <sw-context-button v-else :menu-width="contextButtonMenuWidth" class="sw-data-grid__actions-menu" aria-label="global.sw-data-grid.actionsMenu" > <slot name="actions" :item="item" :item-index="itemIndex" > {% block sw_data_grid_slot_actions %}{% endblock %} </slot> </sw-context-button> {% endblock %} {% block sw_data_grid_body_cell_action_modals %} <slot name="action-modals" :item="item" > {% block sw_data_grid_slot_action_modals %}{% endblock %} </slot> {% endblock %} </div> {% endblock %} </td> {% endblock %} </tr> {% endblock %} </tbody> {% endblock %} {% block sw_data_grid_skeleton %} <sw-data-grid-skeleton v-else :show-selection="showSelection" :show-actions="showActions" :current-columns="currentColumns" :has-resize-columns="hasResizeColumns" :item-amount="skeletonItemAmount" class="sw-data-grid__body" /> {% endblock %} </table> {% endblock %} </div> {% endblock %} {% block sw_data_grid_pagination %} <div class="sw-data-grid__pagination"> {% block sw_data_grid_pagination_inner %} <slot name="pagination"> {% block sw_data_grid_slot_pagination %}{% endblock %} </slot> {% endblock %} </div> {% endblock %} </div> {% endblock %}`,{Criteria:n}=Shopware.Data,a=Shopware.Utils,r={template:o,inject:["acl","repositoryFactory","feature"],emits:["selection-change","select-all-items","select-item","inline-edit-assign","inline-edit-save","inline-edit-cancel","column-sort"],props:{dataSource:{type:Array,required:!0},columns:{type:Array,required:!0},identifier:{type:String,required:!1,default:""},showSelection:{type:Boolean,default:!0,required:!1},showActions:{type:Boolean,default:!0,required:!1},showHeader:{type:Boolean,default:!0,required:!1},showSettings:{type:Boolean,default:!1,required:!1},fullPage:{type:Boolean,default:!1,required:!1},allowInlineEdit:{type:Boolean,default:!1,required:!1},allowColumnEdit:{type:Boolean,default:!1,required:!1},isLoading:{type:Boolean,default:!1,required:!1},skeletonItemAmount:{type:Number,required:!1,default:7},sortBy:{type:String,required:!1,default:null},sortDirection:{type:String,required:!1,default:"ASC"},naturalSorting:{type:Boolean,required:!1,default:!1},compactMode:{type:Boolean,required:!1,default:!0},plainAppearance:{type:Boolean,required:!1,default:!1},showPreviews:{type:Boolean,required:!1,default:!0},isRecordEditable:{type:Function,required:!1,default(){return!0}},isRecordSelectable:{type:Function,required:!1,default(e){return!this.reachMaximumSelectionExceed||Object.keys(this.selection).includes(e[this.itemIdentifierProperty])}},itemIdentifierProperty:{type:String,required:!1,default:"id"},maximumSelectItems:{type:Number,required:!1,default:null},preSelection:{type:Object,required:!1,default:null},isRecordDisabled:{type:Function,required:!1,default(){return!1}},contextButtonMenuWidth:{type:Number,required:!1,default:220}},data(){return{records:this.dataSource,currentSortBy:this.sortBy,currentSortDirection:this.sortDirection,currentNaturalSorting:this.naturalSorting,loading:this.isLoading,currentSetting:{},currentColumns:[],columnIndex:null,selection:{...this.preSelection||{}},originalTarget:null,compact:this.compactMode,previews:this.showPreviews,isInlineEditActive:!1,currentInlineEditId:"",hasPreviewSlots:!1,hasResizeColumns:!1,_hasColumnsResize:!1,_isResizing:!1}},computed:{classes(){return{"is--compact":this.compact,"sw-data-grid--full-page":this.fullPage,"sw-data-grid--actions":this.showActions,"sw-data-grid--plain-appearance":this.plainAppearance}},selectionCount(){return Object.values(this.selection).length},reachMaximumSelectionExceed(){return this.maximumSelectItems?this.selectionCount>=this.maximumSelectItems:!1},isSelectAllDisabled(){if(!this.maximumSelectItems||!this.records)return!1;const e=this.records.map(t=>t.id);return this.reachMaximumSelectionExceed&&Object.keys(this.selection).every(t=>!e.includes(t))},allSelectedChecked(){if(this.isSelectAllDisabled)return!1;if(this.reachMaximumSelectionExceed)return!0;if(!this.records||this.records.length===0||this.selectionCount<this.records.length)return!1;const e=Object.values(this.selection);return this.records.every(t=>e.some(i=>i[this.itemIdentifierProperty]===t[this.itemIdentifierProperty]))},userConfigRepository(){return this.repositoryFactory.create("user_config")},currentUser(){return Shopware.Store.get("session").currentUser},userGridSettingCriteria(){const e=new n(1,25),t=`grid.setting.${this.identifier}`;return e.addFilter(n.equals("key",t)),e.addFilter(n.equals("userId",this.currentUser&&this.currentUser.id)),e},hasInvisibleSelection(){if(!this.records)return!1;const e=this.records.map(t=>t.id);return this.selectionCount>0&&Object.keys(this.selection).some(t=>!e.includes(t))},currentVisibleColumns(){return this.currentColumns.filter(e=>e.visible)}},watch:{columns(){this.initGridColumns()},sortBy(){this.currentSortBy=this.sortBy},sortDirection(){this.currentSortDirection=this.sortDirection},naturalSorting(){this.currentNaturalSorting=this.naturalSorting},isLoading(){this.loading=this.isLoading},dataSource(){this.records=this.dataSource},showSelection(){this.selection=this.showSelection?this.selection:{}},compactMode(){this.compact=this.compactMode},selection(){this.$emit("selection-change",this.selection,this.selectionCount)}},created(){this.createdComponent()},mounted(){this.mountedComponent()},methods:{createdComponent(){this.initGridColumns()},mountedComponent(){this.trackScrollX(),this.findPreviewSlots(),this.$device.onResize({listener:this.trackScrollX.bind(this),component:this})},initGridColumns(){this.currentColumns=this.getDefaultColumns(),this.findResizeColumns(),this.identifier&&this.findUserSetting()},findUserSetting(){return this.acl.can("user_config:read")?this.userConfigRepository.search(this.userGridSettingCriteria,Shopware.Context.api).then(e=>{if(!e.length)return;this.currentSetting=e[0];const t=e[0].value;this.applyUserSettings({columns:(t==null?void 0:t.columns)??t,compact:t==null?void 0:t.compact,previews:t==null?void 0:t.previews})}):Promise.resolve()},findUserSettingById(){return this.userConfigRepository.get(this.currentSetting.id,Shopware.Context.api).then(e=>{if(!e)return;this.currentSetting=e;const t=e.value;this.applyUserSettings({columns:(t==null?void 0:t.columns)??t,compact:t==null?void 0:t.compact,previews:t==null?void 0:t.previews})})},applyUserSettings(e){if(typeof e.compact=="boolean"&&(this.compact=e.compact),typeof e.previews=="boolean"&&(this.previews=e.previews),!e.columns)return;const t=Object.fromEntries(e.columns.map((i,s)=>[i.dataIndex,{width:i.width,allowResize:i.allowResize,sortable:i.sortable,visible:i.visible,align:i.align,naturalSorting:i.naturalSorting,position:s}]));this.currentColumns=this.currentColumns.map(i=>t[i.dataIndex]===void 0?i:a.object.mergeWith({},i,t[i.dataIndex],(s,l)=>l??s)).sort((i,s)=>i.position-s.position)},findResizeColumns(){this.hasResizeColumns=this.currentColumns.some(e=>e.allowResize)},findPreviewSlots(){let e=[];e=Object.keys(this.$slots),this.hasPreviewSlots=e.some(t=>t.includes("preview-"))},getDefaultColumns(){return this.columns.map(e=>{const t={width:"auto",allowResize:!1,sortable:!0,visible:!0,align:"left",naturalSorting:!1};if(!e.property)throw new Error(`[${this.$options.name}] Please specify a "property" to render a column.`);return e.dataIndex||(e.dataIndex=e.property),{...t,...e}})},createUserGridSetting(){const e=this.userConfigRepository.create(Shopware.Context.api);e.key=`grid.setting.${this.identifier}`,e.userId=this.currentUser&&this.currentUser.id,this.currentSetting=e},saveUserSettings(){!this.acl.can("user_config:create")||!this.acl.can("user_config:update")||this.identifier&&(this.currentSetting.id||this.createUserGridSetting(),this.currentSetting.value={columns:this.currentColumns,compact:this.compact,previews:this.previews},this.userConfigRepository.save(this.currentSetting,Shopware.Context.api).then(()=>{this.findUserSettingById()}))},getHeaderCellClasses(e,t){return[{"sw-data-grid__cell--sortable":e.sortable,"sw-data-grid__cell--icon-label":e.iconLabel},`sw-data-grid__cell--${t}`,`sw-data-grid__cell--align-${e.align}`]},getRowClasses(e,t){return[{"is--inline-edit":this.isInlineEdit(e),"is--selected":this.isSelected(e.id),"is--disabled":this.isRecordDisabled(e)},`sw-data-grid__row--${t}`]},getCellClasses(e){return[`sw-data-grid__cell--${e.property.replace(/\./g,"-")}`,`sw-data-grid__cell--align-${e.align}`,{"sw-data-grid__cell--multi-line":e.multiLine}]},onChangeCompactMode(e){this.compact=e,this.saveUserSettings()},onChangePreviews(e){this.previews=e,this.saveUserSettings()},onChangeColumnVisibility(e,t){this.currentColumns[t].visible=e,this.saveUserSettings()},onChangeColumnOrder(e,t){this.currentColumns=this.orderColumns(this.currentColumns,e,t),this.saveUserSettings()},orderColumns(e,t,i){return e.splice(i,0,e.splice(t,1)[0]),e},enableInlineEdit(){this.isInlineEditActive=this.hasColumnWithInlineEdit(),this.setAllColumnElementWidths()},hasColumnWithInlineEdit(){return this.currentColumns.some(e=>e.hasOwnProperty("inlineEdit"))},isInlineEdit(e){return this.isInlineEditActive&&this.currentInlineEditId===e[this.itemIdentifierProperty]},disableInlineEdit(){this.isInlineEditActive=!1,this.currentInlineEditId=""},hideColumn(e){this.currentColumns[e].visible=!1,this.saveUserSettings()},renderColumn(e,t){const i=t.property.split(".");let s=e;return i.forEach(l=>typeof s!="object"||s===null?(a.debug.warn(`[sw-data-grid] Can not resolve accessor: ${t.property}`),!1):(l.includes("()")&&(l=l.replace("()","")),typeof s[l]=="function"?s=s[l]():s.hasOwnProperty("translated")&&s.translated.hasOwnProperty(l)?s=s.translated[l]:s=a.get(s,l),!0)),s},selectAll(e){this.records.forEach(t=>{this.isSelected(t[this.itemIdentifierProperty])!==e&&this.selectItem(e,t)}),this.$emit("select-all-items",this.selection)},selectItem(e,t){if(e&&this.reachMaximumSelectionExceed||!this.isRecordSelectable(t))return;const i=t[this.itemIdentifierProperty];e?this.selection={...this.selection,[i]:t}:this.selection=Object.fromEntries(Object.entries(this.selection).filter(([s])=>s!==i)),this.$emit("select-item",this.selection,t,e)},isSelected(e){return typeof this.selection[e]<"u"},resetSelection(){this.selection={}},onClickSaveInlineEdit(e){this.$emit("inline-edit-assign",e),this.save(e),this.disableInlineEdit()},onClickCancelInlineEdit(e){this.revert(e),this.disableInlineEdit()},onDbClickCell(e){!this.allowInlineEdit||!this.isRecordEditable(e)||(this.enableInlineEdit(),this.currentInlineEditId=e[this.itemIdentifierProperty])},onClickHeaderCell(e,t){this._isResizing||t.sortable&&(e.target.closest(".sw-context-button")||e.target.closest(".sw-data-grid__cell-resize")||(this.setAllColumnElementWidths(),this.sort(t)))},onStartResize(e,t,i){this.resizeX=e.pageX,this.originalTarget=e.target,this.columnIndex=i,this._isResizing=!0,this._handleColumnResizeClasses("add"),this.enableResizeMode(),window.addEventListener("mousemove",this.onResize,!1),window.addEventListener("mouseup",this.onStopResize,!1)},onStopResize(){this.resizeX=null,this._handleColumnResizeClasses("remove"),this.currentColumns[this.columnIndex].width=`${this._currentColumnWidth}px`,this._currentColumnWidth=null,this.originalTarget=null,this.columnIndex=null,Shopware.Utils.debounce(()=>{this._isResizing=!1},50)(),window.removeEventListener("mouseup",this.onStopResize,!1),window.removeEventListener("mousemove",this.onResize,!1)},onResize(e){if(this.resizeX===null)return;const t=this.originalTarget.parentNode,i=e.pageX,s=i-this.resizeX,l=t.offsetWidth+s;this.resizeX=i,this.trackScrollX(),!(l<65)&&(t.style.width=`${l}px`,t.style.minWidth=`${l}px`,this._currentColumnWidth=l)},_handleColumnResizeClasses(e){const t=this.originalTarget,i=t.parentNode;this.$el.classList[e]("is--resizing"),t.classList[e]("is--column-resizing"),i.classList[e]("is--column-resizing"),i.nextElementSibling.classList[e]("is--column-resizing")},enableResizeMode(){this._hasColumnsResize||(this.setAllColumnElementWidths(),this.$refs.table.style.tableLayout="fixed",this._hasColumnsResize=!0)},setAllColumnElementWidths(){this.$refs.column.forEach(e=>{const t=`${e.offsetWidth}px`;e.offsetWidth&&(e.style.width=t,e.style.minWidth=t)})},trackScrollX(){const e=this.$el,t=this.$refs.wrapper;t&&(t.clientWidth<t.scrollWidth?e.classList.add("is--scroll-x"):e.classList.remove("is--scroll-x"))},save(e){this.$emit("inline-edit-save",e)},revert(e){this.$emit("inline-edit-cancel",e)},sort(e){this.$emit("column-sort",e)}}};export{r as default};
