# Saving mail straight into SeedDMS

Saving mail into SeedDMS is best done by using the `message/rfc822` format
(often called .eml file), because it keeps the whole mail unmodified
in one file, the format is well document and none proprietary.

For mutt users the following script and an entry in the file `.muttrc`
might be helpful. It takes an exiting mail from stdin and saves it
into a file in the directory passed to the script as the first
parameter. This file can than be uploaded to SeedDMS. The file name is
constructed from the mail date and the subject.

## Add an entry in your .muttrc

```
macro index,pager S "| ~/.local/bin/file_email /tmp<enter>"
```

## Bash script

Save this bash script into `~/.local/bin/file_email` and make it
executable.

```
#!/usr/bin/env bash
# Save piped email to "$1/YYMMDD SUBJECT.eml"

# Don't overwrite existing file
set -o noclobber

message=$(cat)

mail_date=$(<<<"$message" grep -oPm 1 '^Date: ?\K.*')
formatted_date=$(date -d"$mail_date" +%Y%m%d)
# Get the first line of the subject, and change / to ∕ so it's not a subdirectory
subject=$(<<<"$message" grep -oPm 1 '^Subject: ?\K.*' | sed 's,/,∕,g')

if [[ $formatted_date == '' ]]; then
	echo Error: no date parsed
	exit 1
elif [[ $subject == '' ]]; then
	echo Warning: no subject found
fi

echo "${message}" > "$1/$formatted_date-$subject.eml" && echo Email saved to "$1/$formatted_date-$subject.eml"
```
