/*!
FullCalendar Timeline Plugin v6.1.10
Docs & License: https://fullcalendar.io/docs/timeline-view-no-resources
(c) 2023 Adam Shaw
*/
FullCalendar.Timeline=function(e,t,n,i,o,r){"use strict";function l(e){return e&&e.__esModule?e:{default:e}}var s=l(n);i.config.MAX_TIMELINE_SLOTS=1e3;const a=[{years:1},{months:1},{days:1},{hours:1},{minutes:30},{minutes:15},{minutes:10},{minutes:5},{minutes:1},{seconds:30},{seconds:15},{seconds:10},{seconds:5},{seconds:1},{milliseconds:500},{milliseconds:100},{milliseconds:10},{milliseconds:1}];function c(e,t,n,o){let r={labelInterval:n.slotLabelInterval,slotDuration:n.slotDuration};!function(e,t,n){const{currentRange:o}=t;if(e.labelInterval){n.countDurationsBetween(o.start,o.end,e.labelInterval)>i.config.MAX_TIMELINE_SLOTS&&(console.warn("slotLabelInterval results in too many cells"),e.labelInterval=null)}if(e.slotDuration){n.countDurationsBetween(o.start,o.end,e.slotDuration)>i.config.MAX_TIMELINE_SLOTS&&(console.warn("slotDuration results in too many cells"),e.slotDuration=null)}if(e.labelInterval&&e.slotDuration){const t=i.wholeDivideDurations(e.labelInterval,e.slotDuration);(null===t||t<1)&&(console.warn("slotLabelInterval must be a multiple of slotDuration"),e.slotDuration=null)}}(r,e,t),u(r,e,t),function(e,t,n){const{currentRange:o}=t;let{slotDuration:r}=e;if(!r){const l=u(e,t,n);for(let e of a){const t=i.createDuration(e),n=i.wholeDivideDurations(l,t);if(null!==n&&n>1&&n<=6){r=t;break}}if(r){n.countDurationsBetween(o.start,o.end,r)>200&&(r=null)}r||(r=l),e.slotDuration=r}}(r,e,t);let l=n.slotLabelFormat,s=Array.isArray(l)?l:null!=l?[l]:function(e,t,n,o){let r,l;const{labelInterval:s}=e;let a=i.greatestDurationDenominator(s).unit;const c=o.weekNumbers;let d=r=l=null;"week"!==a||c||(a="day");switch(a){case"year":d={year:"numeric"};break;case"month":h("years",t,n)>1&&(d={year:"numeric"}),r={month:"short"};break;case"week":h("years",t,n)>1&&(d={year:"numeric"}),r={week:"narrow"};break;case"day":h("years",t,n)>1?d={year:"numeric",month:"long"}:h("months",t,n)>1&&(d={month:"long"}),c&&(r={week:"short"}),l={weekday:"narrow",day:"numeric"};break;case"hour":c&&(d={week:"short"}),h("days",t,n)>1&&(r={weekday:"short",day:"numeric",month:"numeric",omitCommas:!0}),l={hour:"numeric",minute:"2-digit",omitZeroMinute:!0,meridiem:"short"};break;case"minute":i.asRoughMinutes(s)/60>=6?(d={hour:"numeric",meridiem:"short"},r=e=>":"+i.padStart(e.date.minute,2)):d={hour:"numeric",minute:"numeric",meridiem:"short"};break;case"second":i.asRoughSeconds(s)/60>=6?(d={hour:"numeric",minute:"2-digit",meridiem:"lowercase"},r=e=>":"+i.padStart(e.date.second,2)):d={hour:"numeric",minute:"2-digit",second:"2-digit",meridiem:"lowercase"};break;case"millisecond":d={hour:"numeric",minute:"2-digit",second:"2-digit",meridiem:"lowercase"},r=e=>"."+i.padStart(e.millisecond,3)}return[].concat(d||[],r||[],l||[])}(r,e,t,n);r.headerFormats=s.map(e=>i.createFormatter(e)),r.isTimeScale=Boolean(r.slotDuration.milliseconds);let c=null;if(!r.isTimeScale){const e=i.greatestDurationDenominator(r.slotDuration).unit;/year|month|week/.test(e)&&(c=e)}r.largeUnit=c,r.emphasizeWeeks=1===i.asCleanDays(r.slotDuration)&&h("weeks",e,t)>=2&&!n.businessHours;let g,p,v=n.snapDuration;v&&(g=i.createDuration(v),p=i.wholeDivideDurations(r.slotDuration,g)),null==p&&(g=r.slotDuration,p=1),r.snapDuration=g,r.snapsPerSlot=p;let D=i.asRoughMs(e.slotMaxTime)-i.asRoughMs(e.slotMinTime),S=d(e.renderRange.start,r,t),b=d(e.renderRange.end,r,t);r.isTimeScale&&(S=t.add(S,e.slotMinTime),b=t.add(i.addDays(b,-1),e.slotMaxTime)),r.timeWindowMs=D,r.normalizedRange={start:S,end:b};let C=[],R=S;for(;R<b;)m(R,r,e,o)&&C.push(R),R=t.add(R,r.slotDuration);r.slotDates=C;let y=-1,w=0;const E=[],x=[];for(R=S;R<b;)m(R,r,e,o)?(y+=1,E.push(y),x.push(w)):E.push(y+.5),R=t.add(R,r.snapDuration),w+=1;return r.snapDiffToIndex=E,r.snapIndexToDiff=x,r.snapCnt=y+1,r.slotCnt=r.snapCnt/r.snapsPerSlot,r.isWeekStarts=function(e,t){let{slotDates:n,emphasizeWeeks:i}=e,o=null,r=[];for(let e of n){let n=t.computeWeekNumber(e),l=i&&null!==o&&o!==n;o=n,r.push(l)}return r}(r,t),r.cellRows=function(e,t){let n=e.slotDates,o=e.headerFormats,r=o.map(()=>[]),l=i.asCleanDays(e.slotDuration),s=7===l?"week":1===l?"day":null,a=o.map(e=>e.getLargestUnit?e.getLargestUnit():null);for(let l=0;l<n.length;l+=1){let c=n[l],d=e.isWeekStarts[l];for(let n=0;n<o.length;n+=1){let l=o[n],m=r[n],u=m[m.length-1],h=n===o.length-1,g=o.length>1&&!h,p=null,v=a[n]||(h?s:null);if(g){let e=t.format(c,l);u&&u.text===e?u.colspan+=1:p=f(c,e,v)}else if(!u||i.isInt(t.countDurationsBetween(e.normalizedRange.start,c,e.labelInterval))){let e=t.format(c,l);p=f(c,e,v)}else u.colspan+=1;p&&(p.weekStart=d,m.push(p))}}return r}(r,t),r.slotsPerLabel=i.wholeDivideDurations(r.labelInterval,r.slotDuration),r}function d(e,t,n){let o=e;return t.isTimeScale||(o=i.startOfDay(o),t.largeUnit&&(o=n.startOf(o,t.largeUnit))),o}function m(e,t,n,o){if(o.isHiddenDay(e))return!1;if(t.isTimeScale){let o=i.startOfDay(e),r=e.valueOf()-o.valueOf()-i.asRoughMs(n.slotMinTime);return r=(r%864e5+864e5)%864e5,r<t.timeWindowMs}return!0}function u(e,t,n){const{currentRange:o}=t;let{labelInterval:r}=e;if(!r){let t;if(e.slotDuration){for(t of a){const n=i.createDuration(t),o=i.wholeDivideDurations(n,e.slotDuration);if(null!==o&&o<=6){r=n;break}}r||(r=e.slotDuration)}else for(t of a){r=i.createDuration(t);if(n.countDurationsBetween(o.start,o.end,r)>=18)break}e.labelInterval=r}return r}function h(e,t,n){let o=t.currentRange,r=null;return"years"===e?r=n.diffWholeYears(o.start,o.end):"months"===e||"weeks"===e?r=n.diffWholeMonths(o.start,o.end):"days"===e&&(r=i.diffWholeDays(o.start,o.end)),r||0}function f(e,t,n){return{date:e,text:t,rowUnit:n,colspan:1,isWeekStart:!1}}class g extends i.BaseComponent{constructor(){super(...arguments),this.refineRenderProps=i.memoizeObjArg(D),this.buildCellNavLinkAttrs=i.memoize(p)}render(){let{props:e,context:t}=this,{dateEnv:n,options:r}=t,{cell:l,dateProfile:s,tDateProfile:a}=e,c=i.getDateMeta(l.date,e.todayRange,e.nowDate,s),d=this.refineRenderProps({level:e.rowLevel,dateMarker:l.date,text:l.text,dateEnv:t.dateEnv,viewApi:t.viewApi});return o.createElement(i.ContentContainer,{elTag:"th",elClasses:["fc-timeline-slot","fc-timeline-slot-label",l.isWeekStart&&"fc-timeline-slot-em",..."time"===l.rowUnit?i.getSlotClassNames(c,t.theme):i.getDayClassNames(c,t.theme)],elAttrs:{colSpan:l.colspan,"data-date":n.formatIso(l.date,{omitTime:!a.isTimeScale,omitTimeZoneOffset:!0})},renderProps:d,generatorName:"slotLabelContent",customGenerator:r.slotLabelContent,defaultGenerator:v,classNameGenerator:r.slotLabelClassNames,didMount:r.slotLabelDidMount,willUnmount:r.slotLabelWillUnmount},n=>o.createElement("div",{className:"fc-timeline-slot-frame",style:{height:e.rowInnerHeight}},o.createElement(n,{elTag:"a",elClasses:["fc-timeline-slot-cushion","fc-scrollgrid-sync-inner",e.isSticky&&"fc-sticky"],elAttrs:this.buildCellNavLinkAttrs(t,l.date,l.rowUnit)})))}}function p(e,t,n){return n&&"time"!==n?i.buildNavLinkAttrs(e,t,n):{}}function v(e){return e.text}function D(e){return{level:e.level,date:e.dateEnv.toDate(e.dateMarker),view:e.viewApi,text:e.text}}class S extends i.BaseComponent{render(){let{dateProfile:e,tDateProfile:t,rowInnerHeights:n,todayRange:i,nowDate:r}=this.props,{cellRows:l}=t;return o.createElement(o.Fragment,null,l.map((s,a)=>{let c=a===l.length-1,d=["fc-timeline-header-row",t.isTimeScale&&c?"fc-timeline-header-row-chrono":""];return o.createElement("tr",{key:a,className:d.join(" ")},s.map(l=>o.createElement(g,{key:l.date.toISOString(),cell:l,rowLevel:a,dateProfile:e,tDateProfile:t,todayRange:i,nowDate:r,rowInnerHeight:n&&n[a],isSticky:!c})))}))}}class b{constructor(e,t,n,o,r,l){this.slatRootEl=e,this.dateProfile=n,this.tDateProfile=o,this.dateEnv=r,this.isRtl=l,this.outerCoordCache=new i.PositionCache(e,t,!0,!1),this.innerCoordCache=new i.PositionCache(e,i.findDirectChildren(t,"div"),!0,!1)}isDateInRange(e){return i.rangeContainsMarker(this.dateProfile.currentRange,e)}dateToCoord(e){let{tDateProfile:t}=this,n=this.computeDateSnapCoverage(e)/t.snapsPerSlot,i=Math.floor(n);i=Math.min(i,t.slotCnt-1);let o=n-i,{innerCoordCache:r,outerCoordCache:l}=this;return this.isRtl?l.originClientRect.width-(l.rights[i]-r.getWidth(i)*o):l.lefts[i]+r.getWidth(i)*o}rangeToCoords(e){return{start:this.dateToCoord(e.start),end:this.dateToCoord(e.end)}}durationToCoord(e){let{dateProfile:t,tDateProfile:n,dateEnv:o,isRtl:r}=this,l=0;if(t){let s=o.add(t.activeRange.start,e);n.isTimeScale||(s=i.startOfDay(s)),l=this.dateToCoord(s),!r&&l&&(l+=1)}return l}coordFromLeft(e){return this.isRtl?this.outerCoordCache.originClientRect.width-e:e}computeDateSnapCoverage(e){return C(e,this.tDateProfile,this.dateEnv)}}function C(e,t,n){let o=n.countDurationsBetween(t.normalizedRange.start,e,t.snapDuration);if(o<0)return 0;if(o>=t.snapDiffToIndex.length)return t.snapCnt;let r=Math.floor(o),l=t.snapDiffToIndex[r];return i.isInt(l)?l+=o-r:l=Math.ceil(l),l}function R(e,t){return null===e?{left:"",right:""}:t?{right:e,left:""}:{left:e,right:""}}function y(e,t){return e?t?{right:e.start,left:-e.end}:{left:e.start,right:-e.end}:{left:"",right:""}}class w extends i.BaseComponent{constructor(){super(...arguments),this.rootElRef=o.createRef()}render(){let{props:e,context:t}=this,n=i.greatestDurationDenominator(e.tDateProfile.slotDuration).unit,r=e.slatCoords&&e.slatCoords.dateProfile===e.dateProfile?e.slatCoords:null;return o.createElement(i.NowTimer,{unit:n},(n,l)=>o.createElement("div",{className:"fc-timeline-header",ref:this.rootElRef},o.createElement("table",{"aria-hidden":!0,className:"fc-scrollgrid-sync-table",style:{minWidth:e.tableMinWidth,width:e.clientWidth}},e.tableColGroupNode,o.createElement("tbody",null,o.createElement(S,{dateProfile:e.dateProfile,tDateProfile:e.tDateProfile,nowDate:n,todayRange:l,rowInnerHeights:e.rowInnerHeights}))),t.options.nowIndicator&&o.createElement("div",{className:"fc-timeline-now-indicator-container"},r&&r.isDateInRange(n)&&o.createElement(i.NowIndicatorContainer,{elClasses:["fc-timeline-now-indicator-arrow"],elStyle:R(r.dateToCoord(n),t.isRtl),isAxis:!0,date:n}))))}componentDidMount(){this.updateSize()}componentDidUpdate(){this.updateSize()}updateSize(){this.props.onMaxCushionWidth&&this.props.onMaxCushionWidth(this.computeMaxCushionWidth())}computeMaxCushionWidth(){return Math.max(...i.findElements(this.rootElRef.current,".fc-timeline-header-row:last-child .fc-timeline-slot-cushion").map(e=>e.getBoundingClientRect().width))}}class E extends i.BaseComponent{render(){let{props:e,context:t}=this,{dateEnv:n,options:r,theme:l}=t,{date:s,tDateProfile:a,isEm:c}=e,d=i.getDateMeta(e.date,e.todayRange,e.nowDate,e.dateProfile),m=Object.assign(Object.assign({date:n.toDate(e.date)},d),{view:t.viewApi});return o.createElement(i.ContentContainer,{elTag:"td",elRef:e.elRef,elClasses:["fc-timeline-slot","fc-timeline-slot-lane",c&&"fc-timeline-slot-em",a.isTimeScale?i.isInt(n.countDurationsBetween(a.normalizedRange.start,e.date,a.labelInterval))?"fc-timeline-slot-major":"fc-timeline-slot-minor":"",...e.isDay?i.getDayClassNames(d,l):i.getSlotClassNames(d,l)],elAttrs:{"data-date":n.formatIso(s,{omitTimeZoneOffset:!0,omitTime:!a.isTimeScale})},renderProps:m,generatorName:"slotLaneContent",customGenerator:r.slotLaneContent,classNameGenerator:r.slotLaneClassNames,didMount:r.slotLaneDidMount,willUnmount:r.slotLaneWillUnmount},e=>o.createElement(e,{elTag:"div"}))}}class x extends i.BaseComponent{render(){let{props:e}=this,{tDateProfile:t,cellElRefs:n}=e,{slotDates:i,isWeekStarts:r}=t,l=!t.isTimeScale&&!t.largeUnit;return o.createElement("tbody",null,o.createElement("tr",null,i.map((i,s)=>{let a=i.toISOString();return o.createElement(E,{key:a,elRef:n.createRef(a),date:i,dateProfile:e.dateProfile,tDateProfile:t,nowDate:e.nowDate,todayRange:e.todayRange,isEm:r[s],isDay:l})})))}}class k extends i.BaseComponent{constructor(){super(...arguments),this.rootElRef=o.createRef(),this.cellElRefs=new i.RefMap,this.handleScrollRequest=e=>{let{onScrollLeftRequest:t}=this.props,{coords:n}=this;if(t&&n){if(e.time){t(n.coordFromLeft(n.durationToCoord(e.time)))}return!0}return null}}render(){let{props:e,context:t}=this;return o.createElement("div",{className:"fc-timeline-slots",ref:this.rootElRef},o.createElement("table",{"aria-hidden":!0,className:t.theme.getClass("table"),style:{minWidth:e.tableMinWidth,width:e.clientWidth}},e.tableColGroupNode,o.createElement(x,{cellElRefs:this.cellElRefs,dateProfile:e.dateProfile,tDateProfile:e.tDateProfile,nowDate:e.nowDate,todayRange:e.todayRange})))}componentDidMount(){this.updateSizing(),this.scrollResponder=this.context.createScrollResponder(this.handleScrollRequest)}componentDidUpdate(e){this.updateSizing(),this.scrollResponder.update(e.dateProfile!==this.props.dateProfile)}componentWillUnmount(){this.scrollResponder.detach(),this.props.onCoords&&this.props.onCoords(null)}updateSizing(){let{props:e,context:t}=this;if(null!==e.clientWidth&&this.scrollResponder){this.rootElRef.current.offsetWidth&&(this.coords=new b(this.rootElRef.current,(n=this.cellElRefs.currentMap,e.tDateProfile.slotDates.map(e=>{let t=e.toISOString();return n[t]})),e.dateProfile,e.tDateProfile,t.dateEnv,t.isRtl),e.onCoords&&e.onCoords(this.coords),this.scrollResponder.update(!1))}var n}positionToHit(e){let{outerCoordCache:t}=this.coords,{dateEnv:n,isRtl:o}=this.context,{tDateProfile:r}=this.props,l=t.leftToIndex(e);if(null!=l){let s=t.getWidth(l),a=o?(t.rights[l]-e)/s:(e-t.lefts[l])/s,c=Math.floor(a*r.snapsPerSlot),d=n.add(r.slotDates[l],i.multiplyDuration(r.snapDuration,c));return{dateSpan:{range:{start:d,end:n.add(d,r.snapDuration)},allDay:!this.props.tDateProfile.isTimeScale},dayEl:this.cellElRefs.currentMap[l],left:t.lefts[l],right:t.rights[l]}}return null}}function P(e,t,n){let i=[];if(n)for(let o of e){let e=n.rangeToCoords(o),r=Math.round(e.start),l=Math.round(e.end);l-r<t&&(l=r+t),i.push({start:r,end:l})}return i}class M extends i.BaseComponent{render(){let{props:e}=this,t=[].concat(e.eventResizeSegs,e.dateSelectionSegs);return e.timelineCoords&&o.createElement("div",{className:"fc-timeline-bg"},this.renderSegs(e.businessHourSegs||[],e.timelineCoords,"non-business"),this.renderSegs(e.bgEventSegs||[],e.timelineCoords,"bg-event"),this.renderSegs(t,e.timelineCoords,"highlight"))}renderSegs(e,t,n){let{todayRange:r,nowDate:l}=this.props,{isRtl:s}=this.context,a=P(e,0,t),c=e.map((e,t)=>{let c=y(a[t],s);return o.createElement("div",{key:i.buildEventRangeKey(e.eventRange),className:"fc-timeline-bg-harness",style:c},"bg-event"===n?o.createElement(i.BgEvent,Object.assign({seg:e},i.getSegMeta(e,r,l))):i.renderFill(n))});return o.createElement(o.Fragment,null,c)}}class T extends i.Slicer{sliceRange(e,t,n,o,r){let l=function(e,t,n){if(!t.isTimeScale&&(e=i.computeVisibleDayRange(e),t.largeUnit)){let i=e;((e={start:n.startOf(e.start,t.largeUnit),end:n.startOf(e.end,t.largeUnit)}).end.valueOf()!==i.end.valueOf()||e.end<=e.start)&&(e={start:e.start,end:n.add(e.end,t.slotDuration)})}return e}(e,o,r),s=[];if(C(l.start,o,r)<C(l.end,o,r)){let e=i.intersectRanges(l,o.normalizedRange);e&&s.push({start:e.start,end:e.end,isStart:e.start.valueOf()===l.start.valueOf()&&m(e.start,o,t,n),isEnd:e.end.valueOf()===l.end.valueOf()&&m(i.addMs(e.end,-1),o,t,n)})}return s}}const I=i.createFormatter({hour:"numeric",minute:"2-digit",omitZeroMinute:!0,meridiem:"narrow"});class W extends i.BaseComponent{render(){let{props:e}=this;return o.createElement(i.StandardEvent,Object.assign({},e,{elClasses:["fc-timeline-event","fc-h-event"],defaultTimeFormat:I,defaultDisplayEventTime:!e.isTimeScale}))}}class z extends i.BaseComponent{render(){let{props:e,context:t}=this,{hiddenSegs:n,placement:r,resourceId:l}=e,{top:s,hcoords:a}=r,c=a&&null!==s,d=y(a,t.isRtl),m=l?{resourceId:l}:{};return o.createElement(i.MoreLinkContainer,{elRef:e.elRef,elClasses:["fc-timeline-more-link"],elStyle:Object.assign({visibility:c?"":"hidden",top:s||0},d),allDayDate:null,moreCnt:n.length,allSegs:n,hiddenSegs:n,dateProfile:e.dateProfile,todayRange:e.todayRange,extraDateSpan:m,popoverContent:()=>o.createElement(o.Fragment,null,n.map(t=>{let n=t.eventRange.instance.instanceId;return o.createElement("div",{key:n,style:{visibility:e.isForcedInvisible[n]?"hidden":""}},o.createElement(W,Object.assign({isTimeScale:e.isTimeScale,seg:t,isDragging:!1,isResizing:!1,isDateSelecting:!1,isSelected:n===e.eventSelection},i.getSegMeta(t,e.todayRange,e.nowDate))))}))},e=>o.createElement(e,{elTag:"div",elClasses:["fc-timeline-more-link-inner","fc-sticky"]}))}}class L extends i.BaseComponent{constructor(){super(...arguments),this.slicer=new T,this.sortEventSegs=i.memoize(i.sortEventSegs),this.harnessElRefs=new i.RefMap,this.moreElRefs=new i.RefMap,this.innerElRef=o.createRef(),this.state={eventInstanceHeights:{},moreLinkHeights:{}},this.handleResize=e=>{e&&this.updateSize()}}render(){let{props:e,state:t,context:n}=this,{options:r}=n,{dateProfile:l,tDateProfile:s}=e,a=this.slicer.sliceProps(e,l,s.isTimeScale?null:e.nextDayThreshold,n,l,n.dateProfileGenerator,s,n.dateEnv),c=(a.eventDrag?a.eventDrag.segs:null)||(a.eventResize?a.eventResize.segs:null)||[],d=this.sortEventSegs(a.fgEventSegs,r.eventOrder),m=P(d,r.eventMinWidth,e.timelineCoords),[u,h]=function(e,t,n,o,r,l){let s=[],a=[];for(let i=0;i<e.length;i+=1){let o=e[i],r=n[o.eventRange.instance.instanceId],l=t[i];r&&l?s.push({index:i,span:l,thickness:r}):a.push({seg:o,hcoords:l,top:null})}let c=new i.SegHierarchy;null!=r&&(c.strictOrder=r),null!=l&&(c.maxStackCnt=l);let d=c.addSegs(s),m=d.map(t=>({seg:e[t.index],hcoords:t.span,top:null})),u=i.groupIntersectingEntries(d),h=[],f=[];const g=t=>e[t.index];for(let t=0;t<u.length;t+=1){let n=u[t],r=n.entries.map(g),l=o[i.buildIsoString(i.computeEarliestSegStart(r))];null!=l?h.push({index:e.length+t,thickness:l,span:n.span}):f.push({seg:r,hcoords:n.span,top:null})}c.maxStackCnt=-1,c.addSegs(h);let p=c.toRects(),v=[],D=0;for(let t of p){let n=t.index;v.push({seg:n<e.length?e[n]:u[n-e.length].entries.map(g),hcoords:t.span,top:t.levelCoord}),D=Math.max(D,t.levelCoord+t.thickness)}return[v.concat(a,m,f),D]}(d,m,t.eventInstanceHeights,t.moreLinkHeights,r.eventOrderStrict,r.eventMaxStack),f=(a.eventDrag?a.eventDrag.affectedInstances:null)||(a.eventResize?a.eventResize.affectedInstances:null)||{};return o.createElement(o.Fragment,null,o.createElement(M,{businessHourSegs:a.businessHourSegs,bgEventSegs:a.bgEventSegs,timelineCoords:e.timelineCoords,eventResizeSegs:a.eventResize?a.eventResize.segs:[],dateSelectionSegs:a.dateSelectionSegs,nowDate:e.nowDate,todayRange:e.todayRange}),o.createElement("div",{className:"fc-timeline-events fc-scrollgrid-sync-inner",ref:this.innerElRef,style:{height:h}},this.renderFgSegs(u,f,!1,!1,!1),this.renderFgSegs(function(e,t,n){if(!e.length||!t)return[];let i=function(e){let t={};for(let n of e){let{seg:e}=n;Array.isArray(e)||(t[e.eventRange.instance.instanceId]=n.top)}return t}(n);return e.map(e=>({seg:e,hcoords:t.rangeToCoords(e),top:i[e.eventRange.instance.instanceId]}))}(c,e.timelineCoords,u),{},Boolean(a.eventDrag),Boolean(a.eventResize),!1)))}componentDidMount(){this.updateSize(),this.context.addResizeHandler(this.handleResize)}componentDidUpdate(e,t){e.eventStore===this.props.eventStore&&e.timelineCoords===this.props.timelineCoords&&t.moreLinkHeights===this.state.moreLinkHeights||this.updateSize()}componentWillUnmount(){this.context.removeResizeHandler(this.handleResize)}updateSize(){let{props:e}=this,{timelineCoords:t}=e;const n=this.innerElRef.current;e.onHeightChange&&e.onHeightChange(n,!1),t&&this.setState({eventInstanceHeights:i.mapHash(this.harnessElRefs.currentMap,e=>Math.round(e.getBoundingClientRect().height)),moreLinkHeights:i.mapHash(this.moreElRefs.currentMap,e=>Math.round(e.getBoundingClientRect().height))},()=>{e.onHeightChange&&e.onHeightChange(n,!0)}),e.syncParentMinHeight&&(n.parentElement.style.minHeight=n.style.height)}renderFgSegs(e,t,n,r,l){let{harnessElRefs:s,moreElRefs:a,props:c,context:d}=this,m=n||r||l;return o.createElement(o.Fragment,null,e.map(e=>{let{seg:u,hcoords:h,top:f}=e;if(Array.isArray(u)){let n=i.buildIsoString(i.computeEarliestSegStart(u));return o.createElement(z,{key:"m:"+n,elRef:a.createRef(n),hiddenSegs:u,placement:e,dateProfile:c.dateProfile,nowDate:c.nowDate,todayRange:c.todayRange,isTimeScale:c.tDateProfile.isTimeScale,eventSelection:c.eventSelection,resourceId:c.resourceId,isForcedInvisible:t})}let g=u.eventRange.instance.instanceId,p=m||Boolean(!t[g]&&h&&null!==f),v=y(h,d.isRtl);return o.createElement("div",{key:"e:"+g,ref:m?null:s.createRef(g),className:"fc-timeline-event-harness",style:Object.assign({visibility:p?"":"hidden",top:f||0},v)},o.createElement(W,Object.assign({isTimeScale:c.tDateProfile.isTimeScale,seg:u,isDragging:n,isResizing:r,isDateSelecting:l,isSelected:g===c.eventSelection},i.getSegMeta(u,c.todayRange,c.nowDate))))}))}}L.addStateEquality({eventInstanceHeights:i.isPropsEqual,moreLinkHeights:i.isPropsEqual});class H extends i.DateComponent{constructor(){super(...arguments),this.slatsRef=o.createRef(),this.state={coords:null},this.handeEl=e=>{e?this.context.registerInteractiveComponent(this,{el:e}):this.context.unregisterInteractiveComponent(this)},this.handleCoords=e=>{this.setState({coords:e}),this.props.onSlatCoords&&this.props.onSlatCoords(e)}}render(){let{props:e,state:t,context:n}=this,{options:r}=n,{dateProfile:l,tDateProfile:s}=e,a=i.greatestDurationDenominator(s.slotDuration).unit;return o.createElement("div",{className:"fc-timeline-body",ref:this.handeEl,style:{minWidth:e.tableMinWidth,height:e.clientHeight,width:e.clientWidth}},o.createElement(i.NowTimer,{unit:a},(a,c)=>o.createElement(o.Fragment,null,o.createElement(k,{ref:this.slatsRef,dateProfile:l,tDateProfile:s,nowDate:a,todayRange:c,clientWidth:e.clientWidth,tableColGroupNode:e.tableColGroupNode,tableMinWidth:e.tableMinWidth,onCoords:this.handleCoords,onScrollLeftRequest:e.onScrollLeftRequest}),o.createElement(L,{dateProfile:l,tDateProfile:e.tDateProfile,nowDate:a,todayRange:c,nextDayThreshold:r.nextDayThreshold,businessHours:e.businessHours,eventStore:e.eventStore,eventUiBases:e.eventUiBases,dateSelection:e.dateSelection,eventSelection:e.eventSelection,eventDrag:e.eventDrag,eventResize:e.eventResize,timelineCoords:t.coords,syncParentMinHeight:!0}),r.nowIndicator&&t.coords&&t.coords.isDateInRange(a)&&o.createElement("div",{className:"fc-timeline-now-indicator-container"},o.createElement(i.NowIndicatorContainer,{elClasses:["fc-timeline-now-indicator-line"],elStyle:R(t.coords.dateToCoord(a),n.isRtl),isAxis:!1,date:a})))))}queryHit(e,t,n,i){let o=this.slatsRef.current.positionToHit(e);return o?{dateProfile:this.props.dateProfile,dateSpan:o.dateSpan,rect:{left:o.left,right:o.right,top:0,bottom:i},dayEl:o.dayEl,layer:0}:null}}class N extends i.DateComponent{constructor(){super(...arguments),this.buildTimelineDateProfile=i.memoize(c),this.scrollGridRef=o.createRef(),this.state={slatCoords:null,slotCushionMaxWidth:null},this.handleSlatCoords=e=>{this.setState({slatCoords:e})},this.handleScrollLeftRequest=e=>{this.scrollGridRef.current.forceScrollLeft(0,e)},this.handleMaxCushionWidth=e=>{this.setState({slotCushionMaxWidth:Math.ceil(e)})}}render(){let{props:e,state:t,context:n}=this,{options:l}=n,s=!e.forPrint&&i.getStickyHeaderDates(l),a=!e.forPrint&&i.getStickyFooterScrollbar(l),c=this.buildTimelineDateProfile(e.dateProfile,n.dateEnv,l,n.dateProfileGenerator),{slotMinWidth:d}=l,m=O(c,d||this.computeFallbackSlotMinWidth(c)),u=[{type:"header",key:"header",isSticky:s,chunks:[{key:"timeline",content:n=>o.createElement(w,{dateProfile:e.dateProfile,clientWidth:n.clientWidth,clientHeight:n.clientHeight,tableMinWidth:n.tableMinWidth,tableColGroupNode:n.tableColGroupNode,tDateProfile:c,slatCoords:t.slatCoords,onMaxCushionWidth:d?null:this.handleMaxCushionWidth})}]},{type:"body",key:"body",liquid:!0,chunks:[{key:"timeline",content:t=>o.createElement(H,Object.assign({},e,{clientWidth:t.clientWidth,clientHeight:t.clientHeight,tableMinWidth:t.tableMinWidth,tableColGroupNode:t.tableColGroupNode,tDateProfile:c,onSlatCoords:this.handleSlatCoords,onScrollLeftRequest:this.handleScrollLeftRequest}))}]}];return a&&u.push({type:"footer",key:"footer",isSticky:!0,chunks:[{key:"timeline",content:i.renderScrollShim}]}),o.createElement(i.ViewContainer,{elClasses:["fc-timeline",!1===l.eventOverlap?"fc-timeline-overlap-disabled":""],viewSpec:n.viewSpec},o.createElement(r.ScrollGrid,{ref:this.scrollGridRef,liquid:!e.isHeightAuto&&!e.forPrint,forPrint:e.forPrint,collapsibleWidth:!1,colGroups:[{cols:m}],sections:u}))}computeFallbackSlotMinWidth(e){return Math.max(30,(this.state.slotCushionMaxWidth||0)/e.slotsPerLabel)}}function O(e,t){return[{span:e.slotCnt,minWidth:t||1}]}i.injectStyles('.fc .fc-timeline-body{min-height:100%;position:relative;z-index:1}.fc .fc-timeline-slots{bottom:0;position:absolute;top:0;z-index:1}.fc .fc-timeline-slots>table{height:100%}.fc .fc-timeline-slot-minor{border-style:dotted}.fc .fc-timeline-slot-frame{align-items:center;display:flex;justify-content:center}.fc .fc-timeline-header-row-chrono .fc-timeline-slot-frame{justify-content:flex-start}.fc .fc-timeline-header-row:last-child .fc-timeline-slot-frame{overflow:hidden}.fc .fc-timeline-slot-cushion{padding:4px 5px;white-space:nowrap}.fc-direction-ltr .fc-timeline-slot{border-right:0!important}.fc-direction-rtl .fc-timeline-slot{border-left:0!important}.fc .fc-timeline-now-indicator-container{bottom:0;left:0;position:absolute;right:0;top:0;width:0;z-index:4}.fc .fc-timeline-now-indicator-arrow,.fc .fc-timeline-now-indicator-line{border-color:var(--fc-now-indicator-color);border-style:solid;position:absolute;top:0}.fc .fc-timeline-now-indicator-arrow{border-left-color:transparent;border-right-color:transparent;border-width:6px 5px 0;margin:0 -6px}.fc .fc-timeline-now-indicator-line{border-width:0 0 0 1px;bottom:0;margin:0 -1px}.fc .fc-timeline-events{position:relative;width:0;z-index:3}.fc .fc-timeline-event-harness,.fc .fc-timeline-more-link{position:absolute;top:0}.fc-timeline-event{z-index:1}.fc-timeline-event.fc-event-mirror{z-index:2}.fc-timeline-event{align-items:center;border-radius:0;display:flex;font-size:var(--fc-small-font-size);margin-bottom:1px;padding:2px 1px;position:relative}.fc-timeline-event .fc-event-main{flex-grow:1;flex-shrink:1;min-width:0}.fc-timeline-event .fc-event-time{font-weight:700}.fc-timeline-event .fc-event-time,.fc-timeline-event .fc-event-title{padding:0 2px;white-space:nowrap}.fc-direction-ltr .fc-timeline-event.fc-event-end,.fc-direction-ltr .fc-timeline-more-link{margin-right:1px}.fc-direction-rtl .fc-timeline-event.fc-event-end,.fc-direction-rtl .fc-timeline-more-link{margin-left:1px}.fc-timeline-overlap-disabled .fc-timeline-event{margin-bottom:0;padding-bottom:5px;padding-top:5px}.fc-timeline-event:not(.fc-event-end):after,.fc-timeline-event:not(.fc-event-start):before{border-color:transparent #000;border-style:solid;border-width:5px;content:"";flex-grow:0;flex-shrink:0;height:0;margin:0 1px;opacity:.5;width:0}.fc-direction-ltr .fc-timeline-event:not(.fc-event-start):before,.fc-direction-rtl .fc-timeline-event:not(.fc-event-end):after{border-left:0}.fc-direction-ltr .fc-timeline-event:not(.fc-event-end):after,.fc-direction-rtl .fc-timeline-event:not(.fc-event-start):before{border-right:0}.fc-timeline-more-link{background:var(--fc-more-link-bg-color);color:var(--fc-more-link-text-color);cursor:pointer;font-size:var(--fc-small-font-size);padding:1px}.fc-timeline-more-link-inner{display:inline-block;left:0;padding:2px;right:0}.fc .fc-timeline-bg{bottom:0;left:0;position:absolute;right:0;top:0;width:0;z-index:2}.fc .fc-timeline-bg .fc-non-business{z-index:1}.fc .fc-timeline-bg .fc-bg-event{z-index:2}.fc .fc-timeline-bg .fc-highlight{z-index:3}.fc .fc-timeline-bg-harness{bottom:0;position:absolute;top:0}');var F=t.createPlugin({name:"@fullcalendar/timeline",premiumReleaseDate:"2023-11-29",deps:[s.default],initialView:"timelineDay",views:{timeline:{component:N,usesMinMaxTime:!0,eventResizableFromStart:!0},timelineDay:{type:"timeline",duration:{days:1}},timelineWeek:{type:"timeline",duration:{weeks:1}},timelineMonth:{type:"timeline",duration:{months:1}},timelineYear:{type:"timeline",duration:{years:1}}}}),B={__proto__:null,TimelineView:N,buildSlatCols:O,TimelineLane:L,TimelineLaneBg:M,TimelineHeader:w,TimelineSlats:k,buildTimelineDateProfile:c,TimelineCoords:b,coordToCss:R,coordsToCss:y,TimelineLaneSlicer:T,TimelineHeaderRows:S};return t.globalPlugins.push(F),e.Internal=B,e.default=F,Object.defineProperty(e,"__esModule",{value:!0}),e}({},FullCalendar,FullCalendar.PremiumCommon,FullCalendar.Internal,FullCalendar.Preact,FullCalendar.ScrollGrid.Internal);