<?php
/**
 * Этот файл является частью программы "CRM Руководитель" - конструктор CRM систем для бизнеса
 * https://www.rukovoditel.net.ru/
 * 
 * CRM Руководитель - это свободное программное обеспечение, 
 * распространяемое на условиях GNU GPLv3 https://www.gnu.org/licenses/gpl-3.0.html
 * 
 * Автор и правообладатель программы: Харчишина Ольга Александровна (RU), Харчишин Сергей Васильевич (RU).
 * Государственная регистрация программы для ЭВМ: 2023664624
 * https://fips.ru/EGD/3b18c104-1db7-4f2d-83fb-2d38e1474ca3
 */
?>

<div id="email_verification_secion">
    <h3 class="form-title"><?php echo TEXT_EMAIL_VERIFICATION_EMAIL_SUBJECT ?></h3>
    
    <p><?php echo sprintf(TEXT_CODE_FROM_EMAIL_INFO, '<br><b>' . $app_user['email'] . '</b>') ?></p>
    
    
    <?php echo form_tag('email_verification_form', url_for('users/email_verification','action=check'),array('class'=>'login-form')) ?>
    
    <div class="form-group">	
    	<div class="input-icon">
    		<i class="fa fa-user"></i>
    		<input class="form-control placeholder-no-fix required" type="text" autocomplete="off" placeholder="<?php echo TEXT_CODE_FROM_EMAIL ?>" name="code"/>
    	</div>
    	<?php echo tooltip_text(TEXT_CHECK_SPAM_FOLDER)?>
    </div>
    
    <div class="form-actions">
    	
    	<button type="button" id="back-btn" class="btn btn-default" onClick="location.href='<?php echo url_for('users/login')?>'"><i class="fa fa-arrow-circle-left"></i> <?php echo TEXT_BUTTON_BACK ?></button>
    	
    	<button type="submit" class="btn btn-info pull-right"><?php echo TEXT_CONTINUE ?></button>
    </div>
    
    </form>
    
    <div class="forget-password">
    	<p><a href="<?php echo url_for('users/email_verification','action=resend') ?>"><?php echo TEXT_RESEND_CODE ?></a></p>
    </div>
    
    <div class="create-account">
    	<p><a href="#" onClick="show_change_email_form()"><?php echo TEXT_CHNAGE_EMAIL ?></a></p>
    </div>

</div>

<div id="update_email_secion" style="display:none;">
	<h3 class="form-title"><?php echo TEXT_CHNAGE_EMAIL ?></h3>
    
            
    <?php echo form_tag('email_update_form', url_for('users/email_verification','action=update_email'),array('class'=>'login-form')) ?>
    
    <div class="form-group">	
    	<div class="input-icon">
    		<i class="fa fa-envelope"></i>
    		<?php echo input_tag('email',$app_user['email'],['class'=>'form-control required','type'=>'email','autocomplete'=>'off'])?>    		
    	</div>    	
    </div>
    
    <div class="form-actions">
    	
    	<button type="button" id="back-btn" class="btn btn-default" onClick="back_to_email_verification_form()"><i class="fa fa-arrow-circle-left"></i> <?php echo TEXT_BUTTON_BACK ?></button>
    	
    	<button type="submit" class="btn btn-info pull-right"><?php echo TEXT_BUTTON_UPDATE ?></button>
    </div>
    
    </form>
</div>

<script>
  $(function() { 
    $('#email_verification_form').validate();                                                                            

    $('#email_update_form').validate();
  });  

  function show_change_email_form()
  {
	$('#email_verification_secion').hide();  
	$('#update_email_secion').show();
  } 

  function back_to_email_verification_form()
  {
	$('#email_verification_secion').show();  
	$('#update_email_secion').hide();
  } 
</script> 
