-- MariaDB dump 10.17  Distrib 10.4.8-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: admin_tmp
-- ------------------------------------------------------
-- Server version	10.4.8-MariaDB


--
-- Table structure for table `{dbPrefix}apartment`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment`;
CREATE TABLE `{dbPrefix}apartment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parse_from` varchar(20) NOT NULL DEFAULT '' COMMENT 'С какого сайта спарсено',
  `parse_internal_id` varchar(50) NOT NULL DEFAULT '0' COMMENT 'Внутренний ID с сайта-донора',
  `parse_internal_url` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Ссылка на объект на сайте-доноре',
  `parse_owner_info_name` varchar(100) NOT NULL DEFAULT '',
  `parse_owner_info_phone` varchar(20) NOT NULL DEFAULT '',
  `parse_owner_info_user_type` varchar(40) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `obj_type_id` int(11) unsigned NOT NULL DEFAULT 0,
  `loc_country` int(11) unsigned NOT NULL DEFAULT 0,
  `loc_region` int(11) unsigned NOT NULL DEFAULT 0,
  `loc_city` int(11) unsigned NOT NULL DEFAULT 0,
  `loc_district` int(11) unsigned NOT NULL DEFAULT 0,
  `city_id` int(11) unsigned NOT NULL DEFAULT 0,
  `visits` int(11) unsigned NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date_created` timestamp NULL DEFAULT NULL,
  `date_manual_updated` timestamp NULL DEFAULT NULL,
  `date_end_activity` timestamp NULL DEFAULT NULL,
  `activity_always` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `is_price_poa` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `price` bigint(11) unsigned NOT NULL DEFAULT 0,
  `price_to` bigint(11) unsigned NOT NULL DEFAULT 0,
  `num_of_rooms` tinyint(4) NOT NULL DEFAULT 0,
  `floor` tinyint(4) NOT NULL DEFAULT 0,
  `floor_total` tinyint(4) NOT NULL DEFAULT 0,
  `square` float NOT NULL DEFAULT 0,
  `land_square` float NOT NULL DEFAULT 0,
  `window_to` int(11) unsigned NOT NULL DEFAULT 0,
  `berths` varchar(100) NOT NULL DEFAULT '',
  `active` tinyint(4) NOT NULL DEFAULT 0,
  `lat` varchar(25) NOT NULL DEFAULT '0',
  `lng` varchar(25) NOT NULL DEFAULT '0',
  `rating` tinyint(4) NOT NULL DEFAULT 0,
  `date_up_search` timestamp NULL DEFAULT NULL,
  `is_special_offer` tinyint(4) NOT NULL DEFAULT 0,
  `is_free_to` timestamp NULL DEFAULT NULL,
  `price_type` tinyint(1) unsigned NOT NULL DEFAULT 5,
  `sorter` int(11) unsigned NOT NULL DEFAULT 0,
  `owner_active` tinyint(4) NOT NULL DEFAULT 0,
  `owner_id` int(11) unsigned NOT NULL DEFAULT 0,
  `description_near_en` text DEFAULT NULL,
  `address_en` varchar(255) NOT NULL DEFAULT '',
  `title_en` text DEFAULT NULL,
  `description_en` text DEFAULT NULL,
  `exchange_to_en` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `phone` varchar(20) NOT NULL DEFAULT '',
  `autoVKPostId` varchar(255) NOT NULL DEFAULT '',
  `autoFBPostId` varchar(255) NOT NULL DEFAULT '',
  `autoTwitterPostId` varchar(255) NOT NULL DEFAULT '',
  `autoTelegramPostId` varchar(255) NOT NULL DEFAULT '',
  `count_img` tinyint(3) NOT NULL DEFAULT 0,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  `parent_id` int(11) unsigned NOT NULL DEFAULT 0,
  `open_plan` int(11) unsigned NOT NULL DEFAULT 0,
  `room_type` int(11) unsigned NOT NULL DEFAULT 0,
  `balcony_type` int(11) unsigned NOT NULL DEFAULT 0,
  `wc_type` int(11) unsigned NOT NULL DEFAULT 0,
  `floor_coat` int(11) unsigned NOT NULL DEFAULT 0,
  `garage_type` int(11) unsigned NOT NULL DEFAULT 0,
  `build_year` varchar(50) NOT NULL DEFAULT '',
  `repair` int(11) unsigned NOT NULL DEFAULT 0,
  `object_state` int(11) unsigned NOT NULL DEFAULT 0,
  `building_type` int(11) unsigned NOT NULL DEFAULT 0,
  `plot_type` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`),
  KEY `obj_type_id` (`obj_type_id`),
  KEY `loc_country` (`loc_country`),
  KEY `loc_region` (`loc_region`),
  KEY `loc_city` (`loc_city`),
  KEY `city_id` (`city_id`),
  KEY `sorter` (`sorter`),
  KEY `fullActive` (`active`,`owner_active`),
  KEY `priceType_fullActive` (`price_type`,`active`,`owner_active`),
  KEY `type_fullActive` (`type`,`active`,`owner_active`),
  KEY `type_priceType_fullActive` (`type`,`price_type`,`active`,`owner_active`),
  KEY `country_type_priceType_fullActive` (`loc_country`,`type`,`price_type`,`active`,`owner_active`),
  KEY `halfActive` (`active`),
  KEY `priceType_halfActive` (`price_type`,`active`),
  KEY `type_halfActive` (`type`,`active`),
  KEY `type_priceType_halfActive` (`type`,`price_type`,`active`),
  KEY `country_type_priceType_halfActive` (`loc_country`,`type`,`price_type`,`active`),
  KEY `specialActiveDeleted` (`is_special_offer`,`active`,`deleted`),
  KEY `halfActiveLocCity` (`loc_city`,`active`),
  KEY `halfActiveCity` (`city_id`,`active`),
  KEY `fullActiveLocCity` (`loc_city`,`active`,`owner_active`),
  KEY `fullActiveCity` (`city_id`,`active`,`owner_active`),
  KEY `halfActiveObjTypeLocCity` (`obj_type_id`,`loc_city`,`active`),
  KEY `halfActiveObjTypeCity` (`obj_type_id`,`city_id`,`active`),
  KEY `fullActiveObjTypeLocCity` (`obj_type_id`,`loc_city`,`active`,`owner_active`),
  KEY `fullActiveObjTypeCity` (`obj_type_id`,`city_id`,`active`,`owner_active`),
  KEY `sorterActive` (`sorter`,`active`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment`
--

LOCK TABLES `{dbPrefix}apartment` WRITE;
INSERT INTO `{dbPrefix}apartment` VALUES (18,'','0','0','','','',1,1,225,5128638,5128581,0,8,0,'2020-03-16 08:14:58','2019-01-05 00:43:46',NULL,NULL,1,0,400,0,3,4,9,60,0,2,'',1,'55.748873','37.7184591',0,NULL,0,NULL,4,3,1,2,'Near metro station','Aviamotornay St., 22/12','2-Bedroom Apartment, Aviamotornaya St.','<p>2-Bedroom Apartment on Aviamotornaya St.</p>','','','','','','','',4,0,0,0,0,0,0,0,0,'',0,0,0,0),(19,'','0','0','','','',1,2,225,5128638,5128581,0,8,0,'2020-03-16 08:14:54','2019-01-05 00:43:46',NULL,NULL,1,0,1300,0,6,0,2,120,0,1,'3',1,'55.72885','37.5741798',0,NULL,0,NULL,5,4,1,2,'','Trubetskaya St.','House on Trubetskaya St.','<p>A cosy house on Trubetskaya St.</p>','','','','','','','',3,0,0,0,0,0,0,0,0,'',0,0,0,0),(20,'','0','0','','','',1,2,185,524894,524901,0,7,0,'2020-03-16 08:14:54','2019-01-05 00:43:46',NULL,NULL,1,0,250,0,5,2,2,170,0,2,'2',1,'55.9162225','37.5509652',0,NULL,0,NULL,3,5,1,2,'Moll \"Ashan\"','Chelobitevskoe Highway','Chelobitevskoe highway','<p>House on Chelobitevskoe Highway</p>','','','','','','','',3,0,0,0,0,0,0,0,0,'',0,0,0,0),(21,'','0','0','','','',1,1,185,524894,524901,0,7,0,'2020-03-16 08:14:55','2019-01-05 00:43:46',NULL,NULL,1,0,40,0,1,2,10,40,0,1,'1',1,'55.9034239','37.5502048',0,NULL,0,NULL,3,6,1,2,'','Pskovskaya St., 10К1','Apartment, Pskovskaya St.','<p>Apartment on Pskovskaya St.</p>','','','','','','','',3,0,0,0,0,0,0,0,0,'',0,0,0,0),(22,'','0','0','','','',1,2,185,524894,524901,0,7,0,'2020-03-16 08:14:58','2019-01-05 00:43:46',NULL,NULL,1,0,500,0,8,2,2,330,0,2,'4',1,'55.7469425','37.4174575',0,NULL,0,NULL,3,7,1,2,'Underground','on Rublevskoe highway','House on Rublevskoe highway','<p>House for rent on Rublevskoe highway, near Krylatskoe metro station</p>','','','','','','','',4,0,0,0,0,0,0,0,0,'',0,0,0,0),(23,'','0','0','','','',1,2,185,524894,524901,0,7,0,'2020-03-16 08:14:55','2019-01-05 00:43:46',NULL,NULL,1,0,180,0,4,1,2,350,0,2,'2',1,'55.248646837009005','37.49985183773765',5,NULL,1,'2018-09-27 03:00:00',3,8,1,1,'','Urban-type settlement Stolbovaya, Chekhovsky Region, Moscow Oblast, Russia','Сountry house in Stolbovaya settlement','<p>Сountry house in Stolbovaya settlement, Chekhovsky Region</p>','','','','','','','',3,0,0,0,0,0,0,0,0,'',0,0,0,0),(24,'','0','0','','','',1,2,185,524894,524901,0,7,1,'2020-03-16 08:14:55','2019-01-05 00:43:46',NULL,NULL,1,0,1500,0,4,0,2,150,0,2,'',1,'55.1514764778026','37.46829500000001',4,NULL,1,'2018-11-25 03:00:00',5,9,1,1,'','Badeevo, Chekhov, Chekhovsky Region, Moscow Oblast, Russia','Сountry house for monthly rent in Badeevo, Chekhov, Moscow Oblast','<p>Сountry house for monthly rent in Badeevo, Chekhov, Moscow Oblast</p>','','','','','','','',2,0,0,0,0,0,0,0,0,'',0,0,0,0),(25,'','0','0','','','',1,1,185,524894,524901,0,7,0,'2020-03-16 08:14:59','2019-01-05 00:43:46',NULL,NULL,1,0,50,0,1,12,24,40,0,1,'',1,'55.7530745','37.5858817',0,NULL,1,'2018-12-29 03:00:00',2,10,1,2,'Within 5 minutes to Smolenskaya metro station','Novy Arbat St., 26','Apartment on Novy Arbat St.','<p>A cosy apartment in the center of Moscow. Enjoy beautiful view of Russian capital.</p>','','','','','','','',4,0,0,0,0,0,0,0,0,'',0,0,0,0),(26,'','0','0','','','',1,1,185,524894,524901,0,7,0,'2020-03-16 08:14:59','2019-01-05 00:43:46',NULL,NULL,1,0,1200,0,1,7,14,35,0,1,'1',1,'55.735955','37.6186773',0,NULL,0,NULL,5,11,1,1,'Metro \"Polyanka\" is within 5 minutes walk.','Bolshaya Polyanka St., 28','Apartment, Bolshaya Polyanka St., 28','<p>This apartment with nice shades of blue and a beautiful bathroom will help you to relax after work.</p>','','','','','','','',3,0,0,0,0,0,0,0,0,'',0,0,0,0),(27,'','0','0','','','',1,1,185,524894,524901,0,7,0,'2020-03-16 08:14:59','2019-01-05 00:43:46',NULL,NULL,1,0,40,0,2,6,14,58,0,1,'2+1',1,'55.7789065','37.6310073',0,NULL,0,NULL,2,12,1,2,'Within 3 minutes walk form Prospekt Mira metro station','Gilyarovsky St., 20','1-Bedroom Apartment near Prospekt Mira metro station','<p>This apartment will inspire you for new achievements. There is a separate living room, where you can comfortably meet colleagues or relax with friends.</p>','','','','','','','',7,0,0,0,0,0,0,0,0,'',0,0,0,0),(28,'','0','0','','','',1,1,185,524894,524901,0,7,0,'2020-03-16 08:14:59','2019-01-05 00:43:46',NULL,NULL,1,0,25,0,1,9,14,36,0,2,'1+1',1,'55.7506831','37.5968604',0,NULL,0,NULL,2,13,1,2,'Underground','Bolshoy Afanasyevsky Lane, 10','Apartment near Arbatskaya metro station, Bolshoy Afanasyevsky Lane, 10','<p>Within 7 minutes walk from Arbatskaya metro station</p>','','','','','','','',5,0,0,0,0,0,0,0,0,'',0,0,0,0),(29,'','0','0','','','',2,1,185,524894,524901,0,7,1,'2020-03-16 08:14:57','2019-01-05 00:43:46',NULL,NULL,1,0,185000,0,3,11,12,80,0,1,'2+2+1',1,'55.7300745','37.6336848',0,NULL,1,'2019-01-30 03:00:00',1,16,1,2,'','Zatsepa St., 22','2-Bedroom Apartment within a minute walk from Paveletskaya metro station','<p>In this spacious and comfortable apartment you can enjoy the views of the capital of our country, and relax after a good day in a large bath.</p>','','','','','','','',4,0,0,0,0,0,0,0,0,'',0,0,0,0),(30,'','0','0','','','',1,6,225,5332921,5368361,0,0,15,'2020-03-16 08:14:57','2019-01-05 00:43:46','2019-01-05 01:43:46',NULL,1,1,0,0,0,0,0,0,0,0,'',1,'34.0935396','-118.381941',0,NULL,0,NULL,0,17,1,1,'','North Alta Loma Road','Sunset Hotel','<p>The Sunset Los Angeles is located in the heart of West Hollywood. This hotel is located in a leafy alley lined with trees, just a few steps from the famous Sunset Strip in West Hollywood. It features 2 outdoor pools and a restaurant.<br />\r\n<br />\r\nRooms include a dining area and a flat-screen TV. Some rooms have a fully equipped kitchen, some rooms offer views.</p>\r\n',NULL,'','','','','','',2,0,0,0,0,0,0,0,0,'',0,0,0,0),(31,'','0','0','','','',1,7,225,5332921,5368361,0,0,1,'2020-03-16 03:59:48','2019-01-05 00:43:46','2019-01-05 01:43:46',NULL,1,0,0,0,0,0,0,0,0,0,'',1,'34.0935396','-118.381941',0,NULL,0,NULL,5,14,1,1,'','','lux','',NULL,'','','','','','',1,0,30,0,0,0,0,0,0,'',0,0,0,0),(32,'','0','0','','','',1,7,225,5332921,5368361,0,0,1,'2020-03-16 08:13:51','2019-01-05 00:43:46','2019-01-05 01:43:46',NULL,1,1,0,0,0,0,0,0,0,0,'',1,'34.0935396','-118.381941',0,NULL,0,NULL,5,15,1,1,'','','Junior Suite','',NULL,'','','','','','',1,0,30,0,0,0,0,0,0,'',0,0,0,0),(33,'','0','0','','','',2,5,185,529352,466806,0,0,5,'2020-03-16 08:14:58','2019-01-05 00:43:46','2019-01-05 01:43:46',NULL,1,1,0,0,0,0,10,0,0,0,'',1,'56.637722','47.919306',0,NULL,0,NULL,1,18,1,1,'','Sports MCR','Residential complex of MCR. Sports','<p>The neighborhood \"Sportivny\" is a modern complex building, within the framework of which the construction of various brick buildings of variable number of floors is carried out.<br />\r\n<br />\r\nThe developer designed one-, two- and three-bedroom apartments. Finishing works are not carried out.<br />\r\n<br />\r\nLandscaping of the adjacent territory includes the organization of children\'s and sports grounds, recreation areas and landscaping. There are open guest parking spaces. The first floors of the buildings are allocated for the placement of public facilities, shops and offices. Within walking distance are kindergartens, schools, medical institutions, shops.</p>\r\n',NULL,'','','','','','',1,0,0,0,0,0,0,0,0,'',0,0,0,0),(34,'','0','0','','','',2,1,185,529352,466806,0,0,0,'2020-03-16 08:13:51','2019-01-05 00:43:46','2019-01-05 01:43:46',NULL,1,0,44122,0,2,2,10,66.2,0,1,'',1,'56.637722','47.919306',0,NULL,0,NULL,1,1,1,1,'','','2-room apartment','',NULL,'','','','','','',1,0,33,0,0,0,0,0,0,'',0,0,0,0),(35,'','0','0','','','',2,1,185,529352,466806,0,0,1,'2020-03-16 08:13:51','2019-01-05 00:43:46','2019-01-05 01:43:46',NULL,1,0,63436,0,3,7,10,95,0,2,'',1,'56.637722','47.919306',0,NULL,0,NULL,1,2,1,1,'','','3-room apartment','',NULL,'','','','','','',1,0,33,0,0,0,0,0,0,'',0,0,0,0);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_city`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_city`;
CREATE TABLE `{dbPrefix}apartment_city` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sorter` smallint(6) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `name_en` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_city`
--

LOCK TABLES `{dbPrefix}apartment_city` WRITE;
INSERT INTO `{dbPrefix}apartment_city` VALUES (7,1,1,'2020-03-16 03:59:49','Moscow'),(8,2,1,'2020-03-16 03:59:49','New-York');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_complain`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_complain`;
CREATE TABLE `{dbPrefix}apartment_complain` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `complain_id` int(11) unsigned NOT NULL DEFAULT 0,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `session_id` char(32) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `body` text DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `active` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_complain`
--

LOCK TABLES `{dbPrefix}apartment_complain` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_complain_reason`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_complain_reason`;
CREATE TABLE `{dbPrefix}apartment_complain_reason` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sorter` smallint(6) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `name_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_complain_reason`
--

LOCK TABLES `{dbPrefix}apartment_complain_reason` WRITE;
INSERT INTO `{dbPrefix}apartment_complain_reason` VALUES (1,1,0,'2020-03-16 08:33:53','Spam, a repeated listing or advertisement'),(2,2,0,'2020-03-16 08:33:55','Description or price is not true'),(3,3,0,'2020-03-16 08:33:56','The company that pretends to be as a private person'),(4,4,0,'2020-03-16 08:33:57','Other');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_document`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_document`;
CREATE TABLE `{dbPrefix}apartment_document` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `original_name` varchar(255) NOT NULL DEFAULT '',
  `modified_name` varchar(255) NOT NULL DEFAULT '',
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_document`
--

LOCK TABLES `{dbPrefix}apartment_document` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_obj_type`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_obj_type`;
CREATE TABLE `{dbPrefix}apartment_obj_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `icon_file` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `parent_id` int(11) unsigned NOT NULL DEFAULT 0,
  `ya_type` tinyint(1) NOT NULL DEFAULT 0,
  `ya_subtype` varchar(255) NOT NULL DEFAULT '',
  `with_obj` tinyint(1) NOT NULL DEFAULT 0,
  `show_in_search` tinyint(1) NOT NULL DEFAULT 1,
  `show_in_grid` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_obj_type`
--

LOCK TABLES `{dbPrefix}apartment_obj_type` WRITE;
INSERT INTO `{dbPrefix}apartment_obj_type` VALUES (1,'apartment.png',1,'2020-03-16 08:49:23','apartment',5,1,'квартира,flat',0,1,1),(2,'house.png',3,'2020-03-16 08:33:37','house',0,1,'дом,house,дом с участком,house with lot',0,1,1),(3,'commercial.png',2,'2020-03-16 08:49:58','commercial real estate',0,2,'office',0,1,1),(4,'',4,'2020-03-16 08:49:48','land plot',0,1,'участок,lot',0,1,1),(5,'',5,'2020-03-16 08:49:39','apartment house',0,0,'',1,1,1),(6,'',6,'2020-03-16 08:33:48','hotel',0,2,'hotel',1,1,1),(7,'',7,'2020-03-16 08:50:09','hotel room',6,0,'',0,0,0),(8,'',8,'2020-03-16 08:33:51','garage',0,1,'гараж,garage',0,1,1);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_panorama`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_panorama`;
CREATE TABLE `{dbPrefix}apartment_panorama` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `width` int(11) unsigned NOT NULL DEFAULT 0,
  `height` int(11) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_panorama`
--

LOCK TABLES `{dbPrefix}apartment_panorama` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_reference`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_reference`;
CREATE TABLE `{dbPrefix}apartment_reference` (
  `reference_id` int(11) unsigned NOT NULL DEFAULT 0,
  `reference_value_id` int(11) unsigned NOT NULL DEFAULT 0,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  KEY `apartment_id` (`apartment_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_value_id` (`reference_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_reference`
--

LOCK TABLES `{dbPrefix}apartment_reference` WRITE;
INSERT INTO `{dbPrefix}apartment_reference` VALUES (2,12,21),(2,14,21),(1,6,21),(1,7,21),(3,24,21),(3,26,21),(3,27,21),(4,29,21),(7,36,21),(7,39,21),(2,10,28),(2,11,28),(2,12,28),(2,13,28),(2,14,28),(5,32,28),(5,34,28),(1,1,28),(1,2,28),(1,3,28),(1,4,28),(1,6,28),(1,7,28),(3,18,28),(3,19,28),(3,20,28),(3,21,28),(3,24,28),(3,25,28),(3,26,28),(3,27,28),(4,29,28),(4,30,28),(4,31,28),(7,36,28),(7,37,28),(7,38,28),(7,39,28),(2,10,27),(2,11,27),(2,12,27),(2,13,27),(2,14,27),(2,15,27),(2,16,27),(2,17,27),(5,32,27),(5,33,27),(5,34,27),(1,1,27),(1,2,27),(1,3,27),(1,4,27),(1,5,27),(1,6,27),(1,7,27),(1,35,27),(3,19,27),(3,20,27),(3,21,27),(3,22,27),(3,23,27),(3,24,27),(3,25,27),(3,26,27),(3,27,27),(4,29,27),(4,30,27),(4,31,27),(7,37,27),(7,38,27),(7,39,27),(10,43,27),(10,44,27),(10,45,27),(9,40,27),(9,41,27),(9,42,27),(2,11,25),(2,12,25),(5,34,25),(1,2,25),(1,4,25),(1,35,25),(3,25,25),(3,26,25),(3,27,25),(10,45,25),(2,10,26),(2,11,26),(2,12,26),(2,13,26),(2,14,26),(2,15,26),(2,16,26),(2,17,26),(5,32,26),(5,33,26),(5,34,26),(1,1,26),(1,2,26),(1,3,26),(1,4,26),(1,5,26),(1,6,26),(1,7,26),(1,35,26),(3,19,26),(3,20,26),(3,21,26),(3,22,26),(3,23,26),(3,24,26),(3,25,26),(3,26,26),(3,27,26),(4,28,26),(4,29,26),(4,30,26),(4,31,26),(7,36,26),(7,37,26),(7,38,26),(7,39,26),(10,43,26),(10,44,26),(10,45,26),(9,40,26),(9,41,26),(9,42,26),(2,10,18),(2,11,18),(2,12,18),(2,14,18),(2,15,18),(5,32,18),(1,1,18),(1,2,18),(1,3,18),(1,4,18),(1,6,18),(1,7,18),(3,21,18),(3,22,18),(3,24,18),(3,26,18),(3,27,18),(4,29,18),(4,30,18),(4,31,18),(7,36,18),(7,39,18),(2,11,20),(2,12,20),(2,13,20),(2,14,20),(5,32,20),(5,33,20),(5,34,20),(1,2,20),(1,3,20),(1,4,20),(1,5,20),(1,6,20),(1,7,20),(1,35,20),(3,19,20),(3,20,20),(3,24,20),(3,25,20),(3,26,20),(3,27,20),(4,29,20),(4,30,20),(7,36,20),(7,39,20),(2,10,19),(2,11,19),(2,12,19),(2,13,19),(2,14,19),(5,32,19),(5,33,19),(1,1,19),(1,2,19),(1,3,19),(1,4,19),(1,6,19),(3,19,19),(3,20,19),(3,23,19),(3,24,19),(3,25,19),(3,26,19),(3,27,19),(4,30,19),(4,31,19),(7,38,19),(7,39,19),(2,12,24),(2,13,24),(2,14,24),(2,16,24),(2,17,24),(5,33,24),(1,2,24),(1,3,24),(1,4,24),(1,6,24),(1,7,24),(3,20,24),(3,23,24),(3,24,24),(3,25,24),(3,26,24),(3,27,24),(4,29,24),(4,30,24),(4,31,24),(7,37,24),(7,38,24),(7,39,24),(2,10,29),(2,11,29),(2,12,29),(2,13,29),(5,32,29),(5,33,29),(5,34,29),(1,2,29),(1,4,29),(1,5,29),(1,35,29),(3,25,29),(3,26,29),(3,27,29),(2,10,23),(2,11,23),(2,12,23),(2,13,23),(5,32,23),(5,33,23),(1,1,23),(1,2,23),(1,3,23),(1,4,23),(1,5,23),(1,6,23),(1,7,23),(3,19,23),(3,20,23),(3,21,23),(3,23,23),(3,24,23),(3,25,23),(3,26,23),(3,27,23),(4,29,23),(7,37,23),(7,38,23),(7,39,23),(2,10,22),(2,11,22),(2,12,22),(2,13,22),(5,32,22),(5,33,22),(5,34,22),(1,2,22),(1,4,22),(1,5,22),(1,35,22),(3,25,22),(3,26,22),(3,27,22);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_reference_categories`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_reference_categories`;
CREATE TABLE `{dbPrefix}apartment_reference_categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 1,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `style` enum('column1','column2','column3') NOT NULL DEFAULT 'column1',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_reference_categories`
--

LOCK TABLES `{dbPrefix}apartment_reference_categories` WRITE;
INSERT INTO `{dbPrefix}apartment_reference_categories` VALUES (1,1,'Comfort',2,'2019-03-16 08:14:59','column3','Konfor'),(2,1,'Bathroom',4,'2019-03-16 08:15:00','column3','Banyo'),(3,1,'Kitchen',3,'2019-03-16 08:15:00','column3','Mutfak'),(4,1,'Work',5,'2019-03-16 08:15:00','column3','İş'),(5,1,'Security',1,'2019-03-16 08:15:00','column3','Güvenlik'),(7,1,'Entertainment',6,'2019-03-16 08:15:00','column3','Eğlence'),(9,1,'On conditions',8,'2019-03-16 08:15:00','column1','Şartları '),(10,1,'Services',7,'2019-03-16 08:15:01','column1','Hizmetleri'),(11,2,'Open plan',9,'2019-03-16 08:15:01','column1','Açık plan'),(12,2,'Room type',10,'2019-03-16 08:15:01','column1','Oda tipi'),(13,2,'Type of balcony',11,'2019-03-16 08:15:01','column1','Balkon tipi '),(14,2,'Type of WC',12,'2019-03-16 08:15:01','column1','WC tipi '),(15,2,'Floor coating',13,'2019-03-16 08:15:02','column1','Zemin kaplama'),(16,2,'Garage type',14,'2019-03-16 08:15:02','column1','Garaj türü'),(17,2,'Repair',15,'2019-03-16 08:15:02','column1','Onarım'),(18,2,'State of the object',16,'2019-03-16 08:15:02','column1','Nesnenin durumu '),(19,2,'Building-type',17,'2019-03-16 08:15:03','column1','Bina tipi'),(20,2,'Plot type',18,'2019-03-16 08:15:03','column1','Arsa tipi'),(21,2,'Utilities',19,'2019-03-16 08:15:03','column1','Yardımcı Programlar');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_reference_values`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_reference_values`;
CREATE TABLE `{dbPrefix}apartment_reference_values` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reference_category_id` int(11) unsigned NOT NULL DEFAULT 0,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) unsigned NOT NULL DEFAULT 0,
  `for_rent` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `for_sale` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `buy` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `rent` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `exchange` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `reference_category_id` (`reference_category_id`),
  KEY `for_rent` (`for_rent`),
  KEY `for_sale` (`for_sale`),
  KEY `buy` (`buy`),
  KEY `rent` (`rent`),
  KEY `exchange` (`exchange`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_reference_values`
--

LOCK TABLES `{dbPrefix}apartment_reference_values` WRITE;
INSERT INTO `{dbPrefix}apartment_reference_values` VALUES (1,1,'dryer for linen',1,1,0,0,1,1,'2019-03-16 08:15:03'),(2,1,'plastic windows',2,1,1,1,1,1,'2019-03-16 08:15:03'),(3,1,'dense curtains for a comfortable dream',3,1,0,0,1,1,'2019-03-16 08:15:04'),(4,1,'splendid view',4,1,1,1,1,1,'2019-03-16 08:15:04'),(5,1,'quiet area',5,1,1,1,1,1,'2019-03-16 08:15:04'),(6,1,'iron',6,1,0,0,1,1,'2019-03-16 08:15:04'),(7,1,'ironing table',7,1,0,0,1,1,'2019-03-16 08:15:04'),(8,1,'slippers',8,1,0,0,1,1,'2019-03-16 08:15:05'),(9,1,'snack Pack at arrival (a water bottle, croissants, crackers etc.)',9,1,0,0,1,1,'2019-03-16 08:15:05'),(11,2,'washing machine',2,1,1,1,1,1,'2019-03-16 08:15:05'),(12,2,'bath',3,1,1,1,1,1,'2019-03-16 08:15:05'),(13,2,'water heater',4,1,1,1,1,1,'2019-03-16 08:15:05'),(14,2,'hairdryer',5,1,0,0,1,1,'2019-03-16 08:15:06'),(15,2,'soap',6,1,0,0,1,1,'2019-03-16 08:15:06'),(16,2,'shampoo',7,1,0,0,1,1,'2019-03-16 08:15:06'),(17,2,'shower gel',8,1,0,0,1,1,'2019-03-16 08:15:06'),(18,3,'everything for cooking',1,1,0,0,1,1,'2019-03-16 08:15:07'),(19,3,'water filter',2,1,0,0,1,1,'2019-03-16 08:15:07'),(20,3,'electric kettle',3,1,0,0,1,1,'2019-03-16 08:15:07'),(21,3,'everything for food intake',4,1,0,0,1,1,'2019-03-16 08:15:07'),(22,3,'tea, coffee, sugar',5,1,0,0,1,1,'2019-03-16 08:15:07'),(23,3,'3-person dining table',6,1,0,0,1,1,'2019-03-16 08:15:08'),(24,3,'microwave oven',7,1,0,0,1,1,'2019-03-16 08:15:08'),(25,3,'extract',8,1,1,1,1,1,'2019-03-16 08:15:08'),(26,3,'plate',9,1,1,1,1,1,'2019-03-16 08:15:08'),(27,3,'refrigerator',10,1,1,1,1,1,'2019-03-16 08:15:08'),(28,4,'long distance and international calls (up to $2 per day) are included in price',1,1,0,0,1,1,'2019-03-16 08:15:09'),(29,4,'phone',2,1,0,0,1,1,'2019-03-16 08:15:09'),(30,4,'unlimited high-speed Internet is included in price',3,1,0,0,1,1,'2019-03-16 08:15:09'),(31,4,'working table',4,1,0,0,1,1,'2019-03-16 08:15:09'),(32,5,'coded lock',1,1,1,1,1,1,'2019-03-16 08:15:10'),(33,5,'metal door to the vestibule',2,1,1,1,1,1,'2019-03-16 08:15:10'),(34,5,'metal front door',3,1,1,1,1,1,'2019-03-16 08:15:10'),(35,1,'intercom',10,1,1,1,1,1,'2019-03-16 08:15:10'),(36,7,'cable TV',1,1,0,0,1,1,'2019-03-16 08:15:10'),(37,7,'DVD player',2,1,0,0,1,1,'2019-03-16 03:59:49'),(38,7,'satellite TV',3,1,0,0,1,1,'2019-03-16 08:15:11'),(39,7,'TV',4,1,0,0,1,1,'2019-03-16 03:59:49'),(40,9,'Early checking in (till 2.00 p.m.) and late checking out (after 12.00 noon) are charged 50 % of daily rate.',1,1,0,0,1,1,'2019-03-16 08:15:11'),(41,9,'The minimum period of accommodation is two days.',2,1,0,0,1,1,'2019-03-16 08:15:11'),(42,9,'Accommodation for pets isn\'t allowed.',3,1,0,0,1,1,'2019-03-16 08:19:42'),(43,10,'Cleaning is included in price: Each working day, according to the timetable placed in the apartment.',1,1,0,0,1,1,'2019-03-16 08:20:22'),(44,10,'Change of linen and towels is included in price: Once in four days.',2,1,0,0,1,1,'2019-03-16 08:20:37'),(45,10,'The prices are specified in USD. You can find the current rate of a currency exchange on the site of the Central Bank of the Russian Federation.',3,1,1,1,1,1,'2019-03-16 08:20:53'),(46,1,'air conditioner',12,1,1,1,1,1,'2019-03-16 08:21:13'),(47,7,'internet',5,1,1,1,1,1,'2019-03-16 03:59:49'),(48,1,'furnished',13,1,1,1,1,1,'2019-03-16 08:21:21'),(49,3,'furnished kitchen',11,1,1,1,1,1,'2019-03-16 08:21:31'),(51,3,'built-in appliances',12,1,1,1,1,1,'2019-03-16 08:21:39'),(52,11,'Yes',1,1,1,1,1,1,'2019-03-16 08:21:48'),(53,11,'No',2,1,1,1,1,1,'2019-03-16 08:22:03'),(54,12,'Separate',1,1,1,1,1,1,'2019-03-16 08:28:45'),(55,12,'Walkthrough',2,1,1,1,1,1,'2019-03-16 08:28:52'),(56,13,'Balcony',1,1,1,1,1,1,'2019-03-16 08:28:58'),(57,13,'Loggia',2,1,1,1,1,1,'2019-03-16 08:29:17'),(58,13,'2 balconies',3,1,1,1,1,1,'2019-03-16 08:32:26'),(59,13,'2 loggias',4,1,1,1,1,1,'2019-03-16 03:59:49'),(60,14,'Combined',1,1,1,1,1,1,'2019-03-16 08:32:38'),(61,14,'Separate',2,1,1,1,1,1,'2019-03-16 08:32:48'),(62,14,'2 WC',3,1,1,1,1,1,'2019-03-16 03:59:49'),(63,15,'Fitted carpet',1,1,1,1,0,1,'2019-03-16 08:33:16'),(64,15,'Laminat',2,1,1,1,0,1,'2019-03-16 08:34:28'),(65,15,'Parquet',3,1,1,1,0,1,'2019-03-16 08:34:34'),(66,15,'Linoleum',4,1,1,1,0,1,'2019-03-16 08:34:40'),(67,16,'Garage',1,1,1,1,1,1,'2019-03-16 08:34:48'),(68,16,'Parking place',2,1,1,1,1,1,'2019-03-16 08:34:18'),(69,16,'Box',3,1,1,1,1,1,'2019-03-16 08:34:56'),(70,17,'Design',1,1,1,1,1,1,'2019-03-16 08:35:02'),(71,17,'Euro',2,1,1,1,1,1,'2019-03-16 08:35:12'),(72,17,'Finished exterior',3,1,1,1,1,1,'2019-03-16 08:35:18'),(73,17,'Need repair',4,1,1,1,1,1,'2019-03-16 08:35:23'),(74,17,'Good renovation',5,1,1,1,1,1,'2019-03-16 08:35:31'),(75,17,'Partial repaired',6,1,1,1,1,1,'2019-03-16 08:35:40'),(76,17,'Shell',7,1,1,1,1,1,'2019-03-16 08:35:47'),(77,18,'Excellent',1,1,1,1,1,1,'2019-03-16 08:35:55'),(78,18,'Good',2,1,1,1,1,1,'2019-03-16 08:36:02'),(79,18,'Normal',3,1,1,1,1,1,'2019-03-16 03:59:49'),(80,18,'Bad',4,1,1,1,1,1,'2019-03-16 08:37:45'),(81,19,'Block-building',1,1,1,1,1,1,'2019-03-16 08:37:52'),(82,19,'Wooden',2,1,1,1,1,1,'2019-03-16 08:37:59'),(83,19,'Brick',3,1,1,1,1,1,'2019-03-16 08:38:06'),(84,19,'Solid',4,1,1,1,1,1,'2019-03-16 08:38:12'),(85,19,'Pre-fab',5,1,1,1,1,1,'2019-03-16 08:38:18'),(86,20,'Private housing construction',1,1,1,1,1,1,'2019-03-16 08:38:25'),(87,20,'Garden plot',2,1,1,1,1,1,'2019-03-16 08:38:31'),(88,21,'Electricity',1,1,1,1,1,1,'2019-03-16 08:38:39'),(89,21,'Gas',2,1,1,1,1,1,'2019-03-16 08:38:46'),(90,21,'Running water',3,1,1,1,1,1,'2019-03-16 08:38:53'),(91,21,'Sewerage',4,1,1,1,1,1,'2019-03-16 08:39:00');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_statistics`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_statistics`;
CREATE TABLE `{dbPrefix}apartment_statistics` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `ip_address` varchar(30) NOT NULL DEFAULT '',
  `browser` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `date_created` (`date_created`),
  KEY `apId_date` (`apartment_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_statistics`
--

LOCK TABLES `{dbPrefix}apartment_statistics` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_times_in`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_times_in`;
CREATE TABLE `{dbPrefix}apartment_times_in` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_times_in`
--

LOCK TABLES `{dbPrefix}apartment_times_in` WRITE;
INSERT INTO `{dbPrefix}apartment_times_in` VALUES (1,'In the forenoon'),(2,'In the afternoon');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_times_out`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_times_out`;
CREATE TABLE `{dbPrefix}apartment_times_out` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_times_out`
--

LOCK TABLES `{dbPrefix}apartment_times_out` WRITE;
INSERT INTO `{dbPrefix}apartment_times_out` VALUES (1,'In the forenoon'),(2,'In the afternoon');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_video`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_video`;
CREATE TABLE `{dbPrefix}apartment_video` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `video_file` varchar(255) NOT NULL DEFAULT '',
  `video_html` text DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pid` (`apartment_id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_video`
--

LOCK TABLES `{dbPrefix}apartment_video` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}apartment_window_to`
--

DROP TABLE IF EXISTS `{dbPrefix}apartment_window_to`;
CREATE TABLE `{dbPrefix}apartment_window_to` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}apartment_window_to`
--

LOCK TABLES `{dbPrefix}apartment_window_to` WRITE;
INSERT INTO `{dbPrefix}apartment_window_to` VALUES (1,'2019-03-16 08:33:13','Street view'),(2,'2019-03-16 08:33:16','Courtyard view'),(3,'2019-03-16 08:33:17','Sea view'),(4,'2019-03-16 08:33:18','Lake view');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}articles`
--

DROP TABLE IF EXISTS `{dbPrefix}articles`;
CREATE TABLE `{dbPrefix}articles` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `active` tinyint(4) NOT NULL DEFAULT 1,
  `sorter` tinyint(4) NOT NULL DEFAULT 0,
  `page_title_en` varchar(255) NOT NULL DEFAULT '',
  `page_body_en` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}articles`
--

LOCK TABLES `{dbPrefix}articles` WRITE;
INSERT INTO `{dbPrefix}articles` VALUES (5,'2020-03-16 08:37:37',1,1,'Best Places for Singles','<p>\n	So you&#39;re tired of combing the streets and bars of your city in an attempt to find that special someone, or maybe you&#39;ve had enough bad first dates to keep you in on a Saturday night. Don&#39;t despair. The folks at Forbes&#39;s have compiled stats, looking at factors like &quot;coolness&quot;, number of singles, nightlife and job growth to come up with these top five dating cities.</p>\n<p>\n	1. New York<br />\n	2. Boston<br />\n	3. Chicago<br />\n	4. Seattle<br />\n	5. Washington D.C.</p>\n'),(6,'2020-03-16 08:37:39',1,2,'Best Places for Families','<p>\n	Child magazine conducted an extensive search of 100 cities throughout the US to find the best place to raise a family. Factors ranged from pediatric healthcare, schools, housing costs and air quality.</p>\n<p>\n	1. Denver, Colorado<br />\n	2. Norfolk/Virginia Beach/Newport News, Virginia<br />\n	3. Minneapolis/St.Paul, Minnesota<br />\n	4. Miami, Florida<br />\n	5. Orlando, Florida</p>\n');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}badwords`
--

DROP TABLE IF EXISTS `{dbPrefix}badwords`;
CREATE TABLE `{dbPrefix}badwords` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}badwords`
--

LOCK TABLES `{dbPrefix}badwords` WRITE;
INSERT INTO `{dbPrefix}badwords` VALUES (1,'Трус'),(2,'Балбес'),(3,'Fuck');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}block_ip`
--

DROP TABLE IF EXISTS `{dbPrefix}block_ip`;
CREATE TABLE `{dbPrefix}block_ip` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(60) NOT NULL DEFAULT '',
  `ip_long` varchar(60) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL COMMENT 'Дата создания',
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Дата обновления',
  PRIMARY KEY (`id`),
  KEY `ip_long` (`ip_long`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}block_ip`
--

LOCK TABLES `{dbPrefix}block_ip` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}booking_table`
--

DROP TABLE IF EXISTS `{dbPrefix}booking_table`;
CREATE TABLE `{dbPrefix}booking_table` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sender_id` int(11) unsigned NOT NULL DEFAULT 0,
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `active` smallint(6) unsigned NOT NULL DEFAULT 0,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `username` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `date_start` timestamp NULL DEFAULT NULL,
  `date_end` timestamp NULL DEFAULT NULL,
  `time_in` smallint(6) unsigned NOT NULL DEFAULT 0,
  `time_out` smallint(6) unsigned NOT NULL DEFAULT 0,
  `comment` text DEFAULT NULL,
  `comment_admin` text DEFAULT NULL,
  `details` text DEFAULT NULL,
  `amount` float NOT NULL DEFAULT 0,
  `num_guest` smallint(6) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `time_in` (`time_in`),
  KEY `time_out` (`time_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}booking_table`
--

LOCK TABLES `{dbPrefix}booking_table` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}carousel`
--

DROP TABLE IF EXISTS `{dbPrefix}carousel`;
CREATE TABLE `{dbPrefix}carousel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}carousel`
--

LOCK TABLES `{dbPrefix}carousel` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}carousel_images`
--

DROP TABLE IF EXISTS `{dbPrefix}carousel_images`;
CREATE TABLE `{dbPrefix}carousel_images` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `carousel_id` int(11) unsigned NOT NULL DEFAULT 0,
  `sorter` int(11) unsigned NOT NULL DEFAULT 0,
  `image` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `text_en` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}carousel_images`
--

LOCK TABLES `{dbPrefix}carousel_images` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}clients`
--

DROP TABLE IF EXISTS `{dbPrefix}clients`;
CREATE TABLE `{dbPrefix}clients` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `contract_number` varchar(255) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `second_name` varchar(255) NOT NULL DEFAULT '',
  `middle_name` varchar(255) NOT NULL DEFAULT '',
  `birthdate` varchar(255) NOT NULL DEFAULT '',
  `phone` varchar(255) NOT NULL DEFAULT '',
  `additional_phone` varchar(255) NOT NULL DEFAULT '',
  `acts` text DEFAULT NULL,
  `additional_info` text DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}clients`
--

LOCK TABLES `{dbPrefix}clients` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}comments`
--

DROP TABLE IF EXISTS `{dbPrefix}comments`;
CREATE TABLE `{dbPrefix}comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `parent_id` int(11) unsigned DEFAULT 0,
  `owner_id` int(11) unsigned NOT NULL DEFAULT 0,
  `model_name` varchar(64) NOT NULL DEFAULT '',
  `model_id` int(11) unsigned NOT NULL DEFAULT 0,
  `user_name` varchar(64) NOT NULL DEFAULT '',
  `user_email` varchar(64) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `body` text DEFAULT NULL,
  `rating` tinyint(4) NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}comments`
--

LOCK TABLES `{dbPrefix}comments` WRITE;
INSERT INTO `{dbPrefix}comments` VALUES (1,'127.0.0.1','2130706433',0,0,'Apartment',23,'test','test@test.com',1,'Test',5,'2020-03-16 09:55:00','2020-03-16 09:56:14'),(2,'127.0.0.1','2130706433',0,0,'Apartment',24,'test','test@test.com',1,'test',4,'2020-03-16 09:55:25','2020-03-16 09:56:11');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}comparison_list`
--

DROP TABLE IF EXISTS `{dbPrefix}comparison_list`;
CREATE TABLE `{dbPrefix}comparison_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT 0,
  `session_id` varchar(32) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `apartment_id` (`apartment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}comparison_list`
--

LOCK TABLES `{dbPrefix}comparison_list` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}configuration`
--

DROP TABLE IF EXISTS `{dbPrefix}configuration`;
CREATE TABLE `{dbPrefix}configuration` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('bool','text','enum','hidden') NOT NULL DEFAULT 'text',
  `section` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `allowEmpty` tinyint(1) NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}configuration`
--

LOCK TABLES `{dbPrefix}configuration` WRITE;
INSERT INTO `{dbPrefix}configuration` VALUES (1,'text','cache','cachingTime','600',0,'2011-11-26 13:01:21'),(2,'text','main','module_articles_itemsPerPage','10',0,'2016-08-15 07:30:25'),(3,'text','main','module_articles_truncateAfterWords','50',1,'2016-08-15 07:30:25'),(4,'text','main','module_usercpanel_bookingsPerPage','6',0,'2016-08-15 07:30:25'),(5,'text','mail','adminEmail','{adminEmail}',0,'2016-08-15 07:30:25'),(6,'text','main','adminPhone','',1,'2016-08-15 07:30:25'),(7,'text','main','adminSkype','monoray.studio',1,'2016-08-15 07:30:25'),(8,'text','main','adminICQ','616147066',1,'2016-08-15 07:30:25'),(9,'text','main','adminAddress','',1,'2016-08-15 07:30:25'),(10,'text','main','moduleEntries_entriesPerPage','10',0,'2016-08-15 07:30:25'),(11,'text','apartment','moduleApartments_maxRooms','8',0,'2016-08-15 07:30:25'),(12,'text','apartment','moduleApartments_maxFloor','30',0,'2016-08-15 07:30:25'),(13,'text','gmap','module_apartments_gmapsCenterX','37.620717508911184',0,'2016-08-15 07:30:25'),(14,'text','gmap','module_apartments_gmapsCenterY','55.75411314653655',0,'2016-08-15 07:30:25'),(15,'text','gmap','module_apartments_gmapsZoomApartment','15',0,'2016-08-15 07:30:25'),(16,'bool','gmap','useGoogleMap','0',0,'2016-08-15 07:30:25'),(17,'text','main','adminPaginationPageSize','20',0,'2016-08-15 07:30:25'),(18,'bool','notifier','module_notifier_adminNewBooking','1',0,'2016-08-15 07:30:25'),(19,'bool','notifier','module_notifier_userPaymentSuccess','1',0,'2016-08-15 07:30:25'),(20,'bool','notifier','module_notifier_userNewUser','1',0,'2016-08-15 07:30:25'),(21,'bool','notifier','module_notifier_adminNewUser','1',0,'2016-08-15 07:30:25'),(22,'bool','notifier','module_notifier_adminNewContactform','1',0,'2016-08-15 07:30:25'),(23,'bool','ymap','useYandexMap','0',0,'2016-08-15 07:30:25'),(24,'text','ymap','module_apartments_ymapsCenterX','37.620717508911184',0,'2016-08-15 07:30:25'),(25,'text','ymap','module_apartments_ymapsCenterY','55.75411314653655',0,'2016-08-15 07:30:25'),(26,'text','ymap','module_apartments_ymapsZoomApartment','15',0,'2016-08-15 07:30:25'),(27,'text','ymap','module_apartments_ymapsSpanX','0.552069',0,'2016-08-15 07:30:25'),(28,'text','ymap','module_apartments_ymapsSpanY','0.400552',0,'2016-08-15 07:30:25'),(29,'text','ymap','module_apartments_ymapApiKey','',1,'2019-04-01 13:17:32'),(30,'bool','search','usePriceSlider','0',0,'2016-08-15 07:30:25'),(31,'bool','search','useSquareSlider','0',0,'2016-08-15 07:30:25'),(32,'bool','search','useFloorSlider','0',0,'2016-08-15 07:30:25'),(33,'bool','search','useRoomSlider','0',0,'2016-08-15 07:30:25'),(34,'bool','apartment','usePrettyPrice','0',0,'2016-08-15 07:30:25'),(35,'bool','apartment','useUserads','1',0,'2016-08-15 07:30:25'),(36,'bool','apartment','useUseradsModeration','1',0,'2016-08-15 07:30:25'),(37,'bool','notifier','module_notifier_ownerNewBooking','1',0,'2012-05-26 05:00:00'),(38,'bool','apartment','useReferenceLinkInView','1',0,'2016-08-15 07:30:25'),(39,'text','main','defaultCity','New York',0,'2025-03-15 10:25:22'),(40,'bool','apartment','useShowUserInfo','1',0,'2012-04-27 15:01:21'),(41,'bool','apartment','useSliderSimilarAds','1',0,'2012-04-27 15:01:21'),(42,'text','main','round_price','0',0,'2012-08-31 10:11:36'),(43,'bool','mail','mailUseSMTP','0',0,'2012-07-08 12:27:22'),(44,'text','mail','mailSMTPHost','localhost',0,'2012-07-08 12:27:22'),(45,'text','mail','mailSMTPPort','25',0,'2012-07-08 12:27:22'),(46,'text','mail','mailSMTPLogin','login',1,'2012-07-08 12:27:22'),(47,'text','mail','mailSMTPPass','pass',1,'2012-07-08 12:27:22'),(48,'hidden','main','version_name','Open Real Estate FREE',0,'2025-03-15 10:25:22'),(49,'enum','apartment','mode_list_show','block',0,'2013-12-17 09:55:16'),(50,'bool','apartment','use_module_request_property','1',0,'2013-02-27 00:31:48'),(51,'hidden','images','useWatermark','0',0,'2016-08-15 07:30:25'),(52,'hidden','images','watermarkType','1',0,'2016-08-15 07:30:25'),(53,'hidden','images','watermarkContent','',0,'2016-08-15 07:30:25'),(54,'hidden','images','maxImageWidth','1024',0,'2016-08-15 07:30:25'),(55,'hidden','images','maxImageHeight','768',0,'2016-08-15 07:30:25'),(56,'hidden','images','watermarkTextColor','#367fa9',0,'2016-08-15 07:30:25'),(57,'hidden','images','watermarkTextOpacity','50',0,'2016-08-15 07:30:25'),(58,'hidden','images','watermarkPosition','5',0,'2013-02-27 04:34:48'),(59,'hidden','images','watermarkTextSize','20',0,'2013-02-27 04:34:48'),(60,'hidden','images','watermarkFile','',0,'2013-02-27 04:34:48'),(61,'bool','notifier','module_notifier_adminNewApartment','1',0,'2013-02-27 04:35:11'),(62,'bool','notifier','module_notifier_adminApartmentNeedModerate','1',0,'2013-02-27 04:35:11'),(63,'bool','notifier','module_notifier_adminNewComplain','1',0,'2013-02-27 04:35:28'),(65,'text','apartment','countListitngmap','12',0,'2013-05-27 11:13:20'),(66,'text','apartment','countListitngtable','20',0,'2013-05-27 11:13:30'),(67,'text','apartment','countListitngblock','10',0,'2025-03-15 10:25:23'),(68,'bool','search','change_search_ajax','1',0,'2013-05-27 11:13:30'),(69,'text','mail','mail_fromName','',1,'2013-08-23 09:15:16'),(70,'bool','search','useCompactInnerSearchForm','0',1,'2013-08-23 09:15:16'),(71,'bool','share','useYandexShare','0',0,'2013-12-06 07:01:35'),(72,'bool','share','useInternalShare','1',0,'2013-12-06 07:01:35'),(73,'text','share','intenalServices','vk,odnoklassniki,facebook,twitter,mix,linkedin,reddit',0,'2013-12-06 07:05:12'),(74,'text','share','yaShareServices','yazakladki,moikrug,linkedin,vkontakte,facebook,twitter,odnoklassniki',0,'2013-12-06 07:05:12'),(75,'enum','apartment','apartment_periodActivityDefault','always',0,'2013-12-17 09:46:42'),(76,'bool','main','commentNeedApproval','1',0,'2016-08-15 07:30:25'),(77,'bool','main','commentAllowForGuests','1',0,'2016-08-15 07:30:25'),(78,'bool','main','useCaptchaCommentsForRegistered','1',0,'2016-08-15 07:30:25'),(79,'bool','main','enableCommentsForApartments','1',0,'2016-08-15 07:30:25'),(80,'bool','main','enableCommentsForEntries','1',0,'2016-08-15 07:30:25'),(81,'bool','main','enableCommentsForPages','0',0,'2016-08-15 07:30:25'),(82,'bool','main','enableCommentsForFaq','1',0,'2025-03-15 10:25:09'),(83,'bool','osmap','useOSMMap','1',0,'2016-08-15 07:30:25'),(84,'text','osmap','module_apartments_osmapsCenterX','37.620717508911184',0,'2016-08-15 07:30:25'),(85,'text','osmap','module_apartments_osmapsCenterY','55.75411314653655',0,'2016-08-15 07:30:25'),(86,'text','osmap','module_apartments_osmapsZoomApartment','15',0,'2016-08-15 07:30:25'),(87,'hidden','main','module_enabled_apartmentsComplain','1',0,'2014-04-07 12:52:08'),(88,'hidden','main','module_enabled_similarads','1',0,'2014-04-07 12:52:09'),(89,'hidden','main','module_enabled_socialauth','1',0,'2014-04-07 12:52:10'),(90,'hidden','main','module_enabled_comparisonList','1',0,'2014-04-07 12:52:12'),(91,'hidden','main','module_enabled_rss','1',0,'2014-04-07 12:52:14'),(92,'hidden','main','module_enabled_seo','0',0,'2025-03-15 10:25:23'),(93,'hidden','main','module_enabled_sitemap','1',0,'2014-04-07 12:52:17'),(94,'hidden','main','module_enabled_socialposting','1',0,'2014-04-07 12:52:20'),(95,'hidden','main','module_enabled_iecsv','0',0,'2025-03-15 10:25:23'),(96,'hidden','main','module_enabled_location','0',0,'2025-03-15 10:25:23'),(97,'hidden','main','module_enabled_yandexRealty','0',0,'2025-03-15 10:25:23'),(98,'hidden','main','module_enabled_slider','0',0,'2025-03-15 10:25:23'),(99,'hidden','main','module_enabled_advertising','0',0,'2025-03-15 10:25:23'),(100,'hidden','main','module_enabled_bookingcalendar','0',0,'2025-03-15 10:25:23'),(101,'hidden','main','module_enabled_formeditor','1',0,'2014-04-07 12:52:23'),(102,'hidden','main','module_enabled_messages','0',0,'2025-03-15 10:25:23'),(103,'bool','main','useUserRegistration','1',0,'2014-09-04 06:30:25'),(104,'hidden','main','module_enabled_rbac','1',0,'2015-03-09 07:30:25'),(105,'bool','apartment','useTypeRentHour','1',0,'2016-08-15 07:30:25'),(106,'bool','apartment','useTypeRentDay','1',0,'2016-08-15 07:30:25'),(107,'bool','apartment','useTypeRentWeek','1',0,'2016-08-15 07:30:25'),(108,'bool','apartment','useTypeRentMonth','1',0,'2016-08-15 07:30:25'),(109,'bool','apartment','useTypeSale','1',0,'2016-08-15 07:30:25'),(110,'bool','apartment','useTypeRenting','0',0,'2016-08-15 07:30:25'),(111,'bool','apartment','useTypeBuy','0',0,'2016-08-15 07:30:25'),(112,'bool','apartment','useTypeChange','1',0,'2016-08-15 07:30:25'),(113,'enum','mail','mailSMTPSecure','',1,'2016-08-15 07:30:25'),(114,'hidden','blockip','delete_ip_after_days','5',0,'2014-04-07 12:52:23'),(115,'hidden','main','module_enabled_tariffPlans','0',0,'2025-03-15 10:25:23'),(116,'enum','main','user_registrationMode','without_confirm',0,'2015-05-13 12:30:52'),(117,'bool','apartment','enableUserAdsCopy','1',0,'2016-08-15 07:30:25'),(118,'bool','apartment','notDeleteListings','0',0,'2016-08-15 07:30:25'),(119,'bool','seo','allowUserSeo','1',0,'2016-08-15 07:30:25'),(120,'hidden','main','module_enabled_seasonalprices','0',0,'2025-03-15 10:25:23'),(121,'enum','apartment','defaultApartmentType','2',0,'2015-09-10 15:02:03'),(122,'hidden','main','module_enabled_metroStations','0',0,'2025-03-15 10:25:23'),(123,'hidden','main','module_enabled_historyChanges','0',0,'2025-03-15 10:25:23'),(124,'hidden','currency','currencySource','1',0,'2015-11-09 13:52:23'),(125,'bool','apartment','allowCustomCities','1',0,'2016-08-15 07:30:25'),(126,'bool','seo','useSchemaOrgMarkup','1',0,'2015-11-09 13:52:23'),(127,'text','geo','geo_time_cache','604800',0,'2016-08-15 07:30:25'),(128,'enum','geo','geo_in_search','1',0,'2016-01-28 07:00:03'),(129,'enum','geo','geo_in_index','1',0,'2016-01-28 06:59:54'),(130,'bool','geo','geo_in_index_flag','1',0,'2016-01-28 06:59:54'),(131,'enum','geo','geo_in_ad','3',0,'2016-01-28 07:00:19'),(132,'hidden','main','module_enabled_geo','0',0,'2025-03-15 10:25:23'),(133,'bool','main','useShowInfoUseCookie','1',0,'2016-01-27 14:00:04'),(134,'text','osmap','module_apartments_osmapsZoomManyApartments','11',0,'2016-04-15 07:30:25'),(135,'text','ymap','module_apartments_ymapsZoomManyApartments','11',0,'2016-04-15 07:30:25'),(136,'text','gmap','module_apartments_gmapsZoomManyApartments','11',0,'2016-04-15 07:30:25'),(137,'text','gmap','googleMapApiKey','',0,'2016-04-15 07:30:25'),(138,'bool','apartment','booking_half_day','1',1,'2016-04-15 07:30:25'),(139,'hidden','blockip','delete_history_changes_after_days','90',0,'2016-11-20 13:52:23'),(140,'bool','main','useReCaptcha','0',0,'2017-05-01 07:30:25'),(141,'text','main','reCaptchaKey','key',0,'2017-05-01 07:30:25'),(142,'text','main','reCaptchaSecret','secret',0,'2017-05-01 07:30:25'),(143,'bool','apartment','stepByStepAd','1',0,'2017-05-01 07:30:25'),(144,'bool','notifier','module_notifier_allow_replyToEmail','1',0,'2017-11-24 06:18:45'),(145,'bool','apartment','show_loan_calculator','1',0,'2018-10-10 07:30:25'),(146,'hidden','main','module_enabled_api','0',0,'2025-03-15 10:25:23'),(147,'hidden','main','module_enabled_articles','1',0,'2019-11-30 07:18:41'),(148,'hidden','main','module_enabled_reviews','1',0,'2019-11-30 07:18:46'),(149,'hidden','main','module_enabled_favorite','1',0,'2019-11-30 07:18:46'),(150,'hidden','images','thumbQuality','75',0,'2013-02-27 04:34:48'),(151,'bool','apartment','useTitleWithID','0',0,'2020-03-28 10:31:29'),(152,'bool','apartment','parentIdAll','0',0,'2020-03-28 11:30:56'),(153,'bool','main','shuffleSlider','0',0,'2020-03-29 11:50:19'),(154,'bool','apartment','descriptionUseEditor','1',0,'2020-03-29 11:50:19'),(155,'bool','main','convertYoutubeLink','1',0,'2020-05-30 12:46:22'),(156,'hidden','currency','currencySourceApiKey','',0,'2020-06-28 13:52:23'),(157,'bool','main','useLoginAdminSendEmailCode','0',0,'2021-01-09 15:25:23'),(158,'bool','seo','useSeoSearchConfigByLink','0',0,'2021-01-09 15:25:23'),(159,'bool','seo','useSeoSearchConfigBySearch','0',0,'2021-01-09 15:25:23'),(160,'bool','apartment','autoSaveEnableAdmin','1',0,'2021-01-09 15:25:23'),(161,'bool','apartment','autoSaveEnableUser','1',0,'2021-01-09 15:25:23'),(162,'bool','main','uLoginEnable','0',0,'2022-08-15 07:30:25'),(163,'text','apartment','autoSaveInterval','15',0,'2021-01-09 15:25:23'),(164,'text','main','siteCurrency','$',0,'2025-03-15 10:25:23'),(165,'text','seo','siteTitle','Open Real Estate FREE',0,'2025-03-15 10:25:23'),(166,'text','seo','siteKeywords','advertisements, listings, rent a property, rent an apartment, rent a house, buy a property, buy an apartment, buy a house',0,'2025-03-15 10:25:23'),(167,'text','seo','siteDescription','Site with advertisements of properties for sale and for rent',0,'2025-03-15 10:25:23');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}custom_html`
--

DROP TABLE IF EXISTS `{dbPrefix}custom_html`;
CREATE TABLE `{dbPrefix}custom_html` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `body_en` text DEFAULT NULL,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}custom_html`
--

LOCK TABLES `{dbPrefix}custom_html` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}entries`
--

DROP TABLE IF EXISTS `{dbPrefix}entries`;
CREATE TABLE `{dbPrefix}entries` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `category_id` int(11) unsigned NOT NULL DEFAULT 0,
  `tags` text DEFAULT NULL,
  `image_id` int(11) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `body_en` longtext DEFAULT NULL,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `announce_en` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`),
  KEY `category_id` (`category_id`),
  KEY `image_id` (`image_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}entries`
--

LOCK TABLES `{dbPrefix}entries` WRITE;
INSERT INTO `{dbPrefix}entries` VALUES (1,1,2,'статьи, articles',0,'2019-01-05 02:02:21','2020-03-16 08:34:24','<p>If you&#39;re moving to a new house or apartment, be advised: Some things are made to be broken.<br />\nWhen it comes to moving, you&#39;ve got to be careful.<br />\n<br />\nWhich items are among the most likely to get smashed and dashed at moving time?<br />\n<br />\n<strong>#1 - Electronics</strong><br />\nComputers, TVs, and home entertainment systems are among the most likely victims of breakage when it comes time to move. If you drop electronics, the sensitive and delicate components can suffer major damage.<br />\nA possible solution? Save the boxes and packing materials that originally came with the items. When the time comes to transport the gear to your next home, re-pack your gadgets in the boxes and materials the way you purchased them.<br />\n<br />\n<strong>#2 - Your Back</strong><br />\nBack pain, pulled muscles, and broken bones are among the physical injuries you can suffer by trying to move that refrigerator or piano without the right equipment or people power.<br />\nUse a cart for larger pieces and go over the moving route in advance.<br />\n<br />\n<strong>#3 - Mirrors</strong><br />\nSeven years of bad luck might be in your future if you try to move mirrors yourself. It is a fragile item.<br />\nMirrors also can be prone to breakage because the frames holding them can&#39;t withstand the force of being dropped or jostled. So don&#39;t sleep on your pillows when you&#39;re moving - use them as cushions for mirrors and other fragile times! You&#39;ve got to pack them anyway.<br />\n<br />\n<strong>#4 - The House</strong><br />\nDoor jambs, walls, and floors are prone to getting hit and scraped when moving larger items.<br />\nIf you&#39;re worried about leaving any scratches on your old or new abode, one smart option might be to hire some experienced movers.<br />\n<br />\n<strong>#5 - Glassware/China</strong><br />\nGlassware, China, and dishes are among the most easily broken items during a move. These pieces are extremely fragile and can shatter when they&#39;re packed together like sardines.<br />\nSo use paper and bubble wrap and leave space between them and the box.<br />\n<br />\n<strong>#6 - Framed Artwork</strong><br />\nPaintings and artwork are subject to various kinds of damage during moves if you drop them or pack them next to objects with sharp edges.<br />\nVery many times, frames are very ornate, expensive, and easy to crack. People try to pack things tight in a truck and they put boxes on top of paintings. If you do that, it&#39;s easy to put holes in them.</p>\n','Which items often get broken during a move?','<p>If you&#39;re moving to a new house or apartment, be advised: Some things are made to be broken.</p>\n'),(2,1,2,'articles, статьи',1,'2019-01-05 02:02:49','2020-03-16 08:34:26','<p>Finding the best places to live takes a little research. Many companies and organizations have done a lot of the legwork for you, having compiled data and conducted surveys for that purpose.<br />\n<br />\n<strong>World&#39;s Best Places to Live</strong><br />\nThe London-based Economist Intelligence Unit&#39;s (EIU) Liveability Ranking, conducted a worldwide search for the best places to live and visit.<br />\n<br />\nLooking at 40 different indicators arranged in five separate categories, including stability, healthcare, culture and environment, education and infrastructure, EIU published some interesting findings. Once more, Canadian cities ranked high, with three cities in the top five. Former #1, Vancouver, retains its top spot, stregthening its position with the success of the 2010 Olympics, which bolstered the city&#39;s cultural, environmental and infrastructure areas. In fact, the top 5 cities remain unchanged. The best ranked US city is Pittsburgh, coming in at 29th in the World.<br />\n1. Vancouver, Canada<br />\n2. Melbourne, Australia<br />\n3. Vienna, Austria<br />\n4. Toronto, Canada<br />\n5. Calgary, Canada</p>\n','Best Places to Live','<p>Finding the best places to live takes a little research. Many companies and organizations have done a lot of the legwork for you, having compiled data and conducted surveys for that purpose.</p>\n'),(3,1,1,'lego, news, новости',3,'2019-01-05 02:03:16','2020-03-16 08:34:29','<p>Usually when you&#39;re looking for a new home, you need to consider things like whether or not it has a built-in dishwasher or central air conditioning. But one apartment in Manhattan has a rather unique feature that helps it stand out from the rest &mdash; and it has nothing to do with creature comforts. The main staircase in the home is adorned with a colorful railing constructed entirely of Lego blocks.</p>\r\n\r\n<div align=\"center\"><img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n\r\n<p>Designed by one of New York&#39;s officially licensed Lego artists &mdash; yes, thats a real, actual profession &mdash; the railing extends from the main floor all the way to the second floor. It&#39;s been crafted using primarily white bricks, but features more colorful accents at both ends, including large open squares which give it a very abstract appearance.<br />\r\n<br />\r\nYou can, of course, build your own Lego home accents, given enough time and patience. However, we&#39;d advise against relying on plastic toy blocks for anything you plan on putting a good amount of weight on. In fact, it would take just one unfortunate trip to turn the Lego staircase above into a massive pile of crushed blocks and broken dreams.</p>\r\n','Manhattan apartment features staircase lined with 20,000 Lego bricks','<p>Usually when you&#39;re looking for a new home, you need to consider things like whether or not it has a built-in dishwasher or central air conditioning. But one apartment in Manhattan has a rather unique feature that helps it stand out from the rest &mdash; and it has nothing to do with creature comforts.</p>\n'),(5,1,1,'Lorem ipsum',0,'2019-01-04 23:00:22','2020-03-16 08:34:31','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n','Lorem ipsum','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n'),(6,1,1,'Sed ut, perspiciatis',4,'2019-01-04 23:01:42','2020-03-16 08:34:34','<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don&#39;t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn&#39;t anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>\r\n','Where can I get some?','<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don&#39;t look even slightly believable.</p>\r\n');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}entries_all_tags`
--

DROP TABLE IF EXISTS `{dbPrefix}entries_all_tags`;
CREATE TABLE `{dbPrefix}entries_all_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `frequency` int(11) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}entries_all_tags`
--

LOCK TABLES `{dbPrefix}entries_all_tags` WRITE;
INSERT INTO `{dbPrefix}entries_all_tags` VALUES (1,'lego',1),(2,'news',1),(3,'новости',1),(4,'articles',2),(5,'статьи',2),(6,'Lorem ipsum',1),(7,'Sed ut',1),(8,'perspiciatis',1);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}entries_category`
--

DROP TABLE IF EXISTS `{dbPrefix}entries_category`;
CREATE TABLE `{dbPrefix}entries_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sorter` smallint(6) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `name_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}entries_category`
--

LOCK TABLES `{dbPrefix}entries_category` WRITE;
INSERT INTO `{dbPrefix}entries_category` VALUES (1,1,0,'2020-03-16 08:55:50','News'),(2,2,0,'2020-03-16 08:55:53','Articles');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}entries_image`
--

DROP TABLE IF EXISTS `{dbPrefix}entries_image`;
CREATE TABLE `{dbPrefix}entries_image` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}entries_image`
--

LOCK TABLES `{dbPrefix}entries_image` WRITE;
INSERT INTO `{dbPrefix}entries_image` VALUES (1,'sunset-17665_640.jpg','2020-03-16 06:08:57'),(3,'Lego_Color_Bricks.jpg','2020-03-16 07:00:00'),(4,'aerial-view-architecture-bridges-681335.jpg','2020-03-16 08:03:05');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}favorite`
--

DROP TABLE IF EXISTS `{dbPrefix}favorite`;
CREATE TABLE `{dbPrefix}favorite` (
  `user_id` int(11) NOT NULL,
  `model_name` varchar(255) NOT NULL DEFAULT '',
  `model_id` int(11) NOT NULL,
  `date_created` datetime NOT NULL,
  KEY `user_id` (`user_id`),
  KEY `model_id` (`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `{dbPrefix}favorite`
--

LOCK TABLES `{dbPrefix}favorite` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}formdesigner`
--

DROP TABLE IF EXISTS `{dbPrefix}formdesigner`;
CREATE TABLE `{dbPrefix}formdesigner` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sorter` int(11) unsigned NOT NULL DEFAULT 0,
  `field` varchar(100) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL DEFAULT 2,
  `standard_type` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `compare_type` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `is_i18n` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `visible` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `tip_en` varchar(255) NOT NULL DEFAULT '',
  `label_en` varchar(255) NOT NULL DEFAULT '',
  `reference_id` int(11) unsigned NOT NULL DEFAULT 0,
  `rules` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `measure_unit` varchar(30) NOT NULL DEFAULT '',
  `view_in` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `not_hide` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `json_data` text DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `reference_id` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}formdesigner`
--

LOCK TABLES `{dbPrefix}formdesigner` WRITE;
INSERT INTO `{dbPrefix}formdesigner` VALUES (1,12,'num_of_rooms',2,2,0,0,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\"]}','2020-03-15 21:13:48','2020-03-15 21:13:48'),(2,13,'floor_all',2,2,0,0,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 18:52:52'),(4,14,'square',2,1,0,0,0,'Separators are \".\".','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 08:52:27'),(5,15,'window_to',2,2,0,0,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 18:52:52'),(6,17,'berths',2,2,0,0,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 18:52:52'),(7,6,'address',2,2,0,1,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2018-02-26 08:35:07'),(8,16,'description_near',3,2,0,1,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 18:33:35'),(9,11,'description',4,2,0,1,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 18:52:51'),(10,10,'references',2,2,0,0,0,'','',0,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-15 23:15:46'),(11,18,'note',3,1,0,0,2,'The note will be shown only to you and to the administrator','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 08:52:29'),(12,19,'phone',2,1,0,0,0,'If you do not specify your phone number here, the phone number from the profile will be shown on the listings page','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 08:52:33'),(13,20,'land_square',2,1,0,0,0,'Separators are \".\".','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 08:52:35'),(14,1,'type',0,2,0,0,0,'','Type',0,0,'',1,1,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-16 00:35:06','2020-03-16 08:52:37'),(15,8,'price',0,2,0,0,0,'','Price',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\"]}','2020-03-16 00:36:17','2020-03-16 08:52:39'),(16,4,'location',0,2,0,0,0,'','Location',0,0,'',1,1,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-15 21:13:48','2020-03-16 08:52:41'),(17,9,'title',2,1,0,1,0,'','',0,0,'',1,1,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-16 01:01:55','2020-03-16 18:52:51'),(18,2,'obj_type_id',0,2,0,0,0,'','Property type',0,0,'',1,1,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-16 18:27:27','2020-03-16 08:52:43'),(19,3,'parent_id',0,2,0,0,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-16 18:49:27','2018-03-11 09:55:45'),(20,5,'metroStations',2,2,0,0,0,'','',0,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}','2020-03-16 09:00:00','2015-10-31 23:00:01'),(21,21,'open_plan',1,0,0,0,0,'','Open plan',11,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:46'),(22,22,'room_type',1,0,0,0,0,'','Room type',12,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:49'),(23,23,'balcony_type',1,0,0,0,0,'','Type of balcony',13,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:51'),(24,24,'wc_type',1,0,0,0,0,'','Type of WC',14,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:53'),(25,25,'floor_coat',1,0,0,0,0,'','Floor coating',15,0,'',2,0,'{\"type\":[\"1\",\"2\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:54'),(26,7,'garage_type',1,0,0,0,0,'','Garage type',16,0,'',1,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:56'),(27,26,'build_year',2,0,2,0,0,'','Construction Year',0,3,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:52:57'),(28,27,'repair',1,0,0,0,0,'','Repair',17,0,'',2,0,'{\"type\":\"\"}',NULL,'2020-03-16 08:53:00'),(29,28,'object_state',1,0,0,0,0,'','State of the object',18,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:53:02'),(30,29,'building_type',1,0,0,0,0,'','Building-type',19,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:53:05'),(31,30,'plot_type',1,0,0,0,0,'','Plot type',20,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:53:07'),(32,31,'utilities',7,0,0,0,0,'','Utilities',21,0,'',2,0,'{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}',NULL,'2020-03-16 08:53:08');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}formdesigner_obj_type`
--

DROP TABLE IF EXISTS `{dbPrefix}formdesigner_obj_type`;
CREATE TABLE `{dbPrefix}formdesigner_obj_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `formdesigner_id` int(11) unsigned NOT NULL DEFAULT 0,
  `obj_type_id` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `formdesigner_id` (`formdesigner_id`),
  KEY `obj_type_id` (`obj_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}formdesigner_obj_type`
--

LOCK TABLES `{dbPrefix}formdesigner_obj_type` WRITE;
INSERT INTO `{dbPrefix}formdesigner_obj_type` VALUES (52,3,1),(53,3,2),(54,3,3),(111,2,1),(112,2,2),(113,2,3),(132,2,5),(144,2,6),(156,2,7),(167,1,1),(168,1,2),(169,1,7),(173,5,1),(174,5,2),(175,5,7),(176,6,1),(177,6,2),(178,6,7),(179,10,1),(180,10,2),(181,10,3),(182,10,7),(183,13,2),(184,13,4),(225,17,1),(226,17,2),(227,17,3),(228,17,4),(229,17,5),(230,17,6),(231,17,7),(233,14,1),(234,14,2),(235,14,3),(236,14,4),(237,14,5),(238,14,6),(239,14,7),(255,16,1),(256,16,2),(257,16,3),(258,16,4),(259,16,5),(260,16,6),(261,16,7),(270,18,1),(271,18,2),(272,18,3),(273,18,4),(274,18,5),(275,18,6),(276,18,7),(292,19,1),(293,19,7),(294,14,8),(295,18,8),(296,16,8),(297,26,8),(298,20,1),(299,20,2),(300,20,3),(301,20,4),(302,20,5),(303,20,6),(304,20,7),(305,20,8),(306,7,1),(307,7,2),(308,7,3),(309,7,4),(310,7,5),(311,7,6),(312,7,8),(313,15,1),(314,15,2),(315,15,3),(316,15,4),(317,15,5),(318,15,6),(319,15,7),(320,15,8),(321,17,8),(322,9,1),(323,9,2),(324,9,3),(325,9,4),(326,9,5),(327,9,6),(328,9,7),(329,9,8),(330,4,1),(331,4,2),(332,4,3),(333,4,8),(334,8,1),(335,8,2),(336,8,3),(337,8,4),(338,8,5),(339,8,6),(340,8,7),(341,8,8),(342,11,1),(343,11,2),(344,11,3),(345,11,4),(346,11,5),(347,11,6),(348,11,7),(349,11,8),(350,12,1),(351,12,2),(352,12,3),(353,12,4),(354,12,5),(355,12,6),(356,12,7),(357,12,8);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}images`
--

DROP TABLE IF EXISTS `{dbPrefix}images`;
CREATE TABLE `{dbPrefix}images` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_object` int(11) unsigned NOT NULL DEFAULT 0,
  `id_owner` int(11) unsigned NOT NULL DEFAULT 0,
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `file_name_modified` varchar(255) NOT NULL DEFAULT '',
  `sorter` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `is_main` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_object` (`id_object`),
  KEY `id_owner` (`id_owner`),
  KEY `date_updated` (`date_updated`),
  KEY `sorter` (`sorter`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}images`
--

LOCK TABLES `{dbPrefix}images` WRITE;
INSERT INTO `{dbPrefix}images` VALUES (1,20,2,'4642183425303f90b58a426431faffc8.jpg','492cf403cf4ad5bcbaf00de080f4b258.jpg',1,1,'2020-03-16 19:35:08','2016-08-14 19:35:08'),(2,20,2,'98978650a82789fea10647facc9ccb31.jpg','15c38a272f21f58acdeb19181f7b23f3.jpg',2,0,'2020-03-16 19:35:08','2016-08-14 19:35:08'),(3,20,2,'37666ee0212634e5440b3b10bbb03405.jpg','730288a4362c804ae5c06b224a468b2e.jpg',3,0,'2020-03-16 19:35:08','2016-08-14 19:35:08'),(4,21,2,'07f5903ea83f2b6dcafaa938d78f31b2.jpg','1ddadde47c843b49864bc3b9e65c9fc1.jpg',1,1,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(5,21,2,'b30ecde6703af338cf78351c31c244b6.jpg','f487cbc3c94b06192c73b98ab6adc8d0.jpg',2,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(6,21,2,'2799799413c546f8cec31f4dace1bd4c.jpg','aeeb83cdfe8b0058481de9155dccb155.jpg',3,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(7,22,2,'e0c4b12b29821bc21629e4c38ea9328e.jpg','dd021e21a832481dbbe475989db020e2.jpg',1,1,'2020-03-16 19:35:09','2018-05-15 09:04:27'),(8,22,2,'33fb6904072bda6867e983bbe6a4cca2.jpg','fb0f8f66b180aa5047d6208b1b9cf460.jpg',2,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(9,22,2,'2669632aee4e4f25ff4939965abc6df1.jpg','095592da7fd664a685d041b9721c8641.jpg',3,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(10,22,2,'76edb1c5af69ebb89c5451b638379194.jpg','1d1aaf1e5470b969a19dc0d3d6eb44b8.jpg',4,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(11,23,1,'72f897efe9967830aec0423a452bac26.jpg','ebf4e49795ffdf6890238e7891a139fa.jpg',1,1,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(12,23,1,'1062105f6f7775759509d6837ed6b71b.jpg','3eeb283f3ccca96b1840ab3fd2407c0c.jpg',2,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(13,23,1,'4802bffadc1c3a300deec201d641c275.jpg','6f8e1ff0ba19f57e4d052060763cf1a4.jpg',3,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(14,24,1,'434e6f58798e9d4a76b73f6d3f42bcdd.jpg','35771d6769806d963faa2709df768ab3.jpg',1,1,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(15,24,1,'939f629f4d329396f431c3324630acda.jpg','51b1229bb01aa0f49d75d3b9728ad5dc.jpg',2,0,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(16,25,2,'aa3b58ff0e2fc028e8d923c5e4913240.jpg','70afc13f2289863769e3c79fbd6af609.jpg',1,1,'2020-03-16 19:35:09','2016-08-14 19:35:08'),(17,25,2,'fbba2b5638379b56f07901cf811dec84.jpg','eea81eea19ea2e732d4f46e5db2cb692.jpg',2,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(18,25,2,'5995731714c8418f6b543a0a19d9b542.jpg','2c48c40aa5ed23c5e226078bcc6a651c.jpg',3,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(19,25,2,'4b32745ab9af98359d93f140df38b8d5.jpg','e0ebbf92a63ba4475a108a8430ebfd53.jpg',4,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(20,26,1,'532a06605273c3a78764aef82cc2898d.jpg','cc48b9a67c1e05e242f556105b8fe842.jpg',1,1,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(21,26,1,'56862e86309b7f453288fe2dedd65bee.jpg','925abcaf701ddf5e858de3d1029d9ea6.jpg',2,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(22,26,1,'22a6e736f74a03564c817e0c1fb6de4f.jpg','64d96740d5027df5c3647b43af88eeed.jpg',3,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(23,27,2,'a97f838a5870da7a2d43c75f1de90106.jpg','05381a9df5ad620559deb9cc79a04247.jpg',1,1,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(24,27,2,'680c7d6b0899714428e5a1da0bc30fec.jpg','986c8a7a3573aa17b428f1a6ab1a9731.jpg',2,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(25,27,2,'f95ee897b6b445cad179115eb087286d.jpg','a9ae1d8f4c72826350a73426e68b07aa.jpg',3,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(26,27,2,'7bfbb4d132ff8aa79d8bf01100dfcb0b.jpg','37a66e8ef865567d3a60b31b9b761eee.jpg',4,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(27,27,2,'902d83f68e6e9ec372df826018575f60.jpg','30e3c95ae319f9823f35ae838475e669.jpg',5,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(28,27,2,'97671ea692dd5e2c7dbd0390bb0c14a9.jpg','d14491c46e0e14f2e2b20309982a9d47.jpg',6,0,'2020-03-16 19:35:10','2016-08-14 19:35:08'),(29,27,2,'ab7d6d8cd9b9cc88c6c2f886ecfb0fe1.jpg','c8bc7b3f2970dd195e338602f0874ebf.jpg',7,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(30,28,2,'a82782685e0124929fc283d46f6401d2.jpg','5372cfe2f6db3f4c7de4fa2f54030223.jpg',1,1,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(31,28,2,'6f4efbcbc0092841792a0832a9f837f7.jpg','e3e068e1ef368a8c60666ac7708a5472.jpg',2,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(32,28,2,'a904431e0b549eb6ff5674e11fc3bb51.jpg','fca9b505abf952af7f2a052da7c27d84.jpg',3,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(33,28,2,'ff0465c930b907a1902b84a59fad9908.jpg','dcf2bf49b9466dc400a12b4d3855a3ea.jpg',4,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(34,28,2,'e14408748c45e0a3b99e86560994259b.jpg','a18e663a61f5d6930bb851b60c62e51d.jpg',5,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(35,29,2,'53629d7d842247d6809ae4656dcd485e.jpg','722e4e0d81b315fb1c63b55aab347e2e.jpg',1,1,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(36,29,2,'dd2ac23e94ec6135361688bb07717d53.jpg','08e1e3ce179f44fbfcecbf0d8837ba37.jpg',2,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(37,29,2,'169ff7438eb11fc8d550be79883c6ea8.jpg','ec4c29900bb7bc394359dab585d883fc.jpg',3,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(38,29,2,'d97fe2a7fcc6f6055c0238f054691856.jpg','7ce287f416affc4bbc2d768247079b9c.jpg',4,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(39,19,2,'109a589ef2fbedcf57ec6b1bb980c27f.jpg','05df26fd26854d78d365495dca2fd288.jpg',1,1,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(40,19,2,'0aaabd861398394fca7f6a2d88a441da.jpg','719584d4b4a236a3d07b28b7b0b65483.jpg',2,0,'2020-03-16 19:35:11','2016-08-14 19:35:08'),(41,19,2,'8f6f149af17438055fd873647ddb4b52.jpg','abb08d7926551bdcacef6e112d7c68e7.jpg',3,0,'2020-03-16 19:35:12','2016-08-14 19:35:08'),(42,18,2,'b00b91cbee4893b9efda6a83db24ed82.jpg','c5d10612afa120b285ccfb817e0a2303.jpg',1,1,'2020-03-16 19:35:12','2016-08-14 19:35:08'),(43,18,2,'7239026d4d0355a577047c699f4988a8.jpg','2eec995ba4a4a51736f9c8b70c4bb206.jpg',2,0,'2020-03-16 19:35:12','2016-08-14 19:35:08'),(44,18,2,'808ee1b66405fd7e2d376c0cfc4768d2.jpg','32edbdf4361baa92fbe8f9c6ca97f4ef.jpg',3,0,'2020-03-16 19:35:12','2016-08-14 19:35:08'),(45,18,2,'b5b4e28e37325ef9b4b20029aed4967a.jpg','3e903137e68b8c6a68c24f204febb899.jpg',4,0,'2020-03-16 19:35:12','2016-08-14 19:35:08'),(48,30,1,'5a9d8ca2e8677.jpeg','257c3796dbf0fbe331798de0dde6d694.jpeg',3,0,'2018-03-05 15:29:57','2018-03-05 15:30:28'),(49,30,1,'5a9d8ca3ba075.jpeg','bbc11d22d5a0525281e1e4a91bccef6c.jpeg',2,0,'2018-03-05 15:29:57','2018-03-05 15:30:28'),(50,30,1,'5a9d8cb539dad.jpeg','3d8dca2844651bc5d954bb3d338963fb.jpeg',0,1,'2018-03-05 15:30:13','2018-03-05 15:30:19'),(51,32,1,'5a9d8eb8685b0.jpeg','2971f4a618ffd704974dd1a17e773145.jpeg',1,1,'2018-03-05 15:38:50','2018-03-05 15:38:50'),(52,31,1,'5a9d8ef3d6ce0.jpeg','22031dc03968bc4df0a51a2ac3c3b3fe.jpeg',1,1,'2018-03-05 15:39:49','2018-03-05 15:39:49'),(55,33,1,'5aa4f830e2c4e.jpeg','c3b68fe7135120225902b07e30348aea.jpeg',0,1,'2018-03-11 06:34:41','2018-03-11 06:48:23'),(56,34,1,'5aa4fa469448b.jpg','b65be393742d08d6c7bd0b4a6a1aaa1f.jpg',1,1,'2018-03-11 06:43:34','2018-03-11 06:43:34'),(57,35,1,'5aa4fadc8355a.jpg','2fd9eaef4e6c59e51803816070707dff.jpg',1,1,'2018-03-11 06:46:04','2018-03-11 06:46:04');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}infopages`
--

DROP TABLE IF EXISTS `{dbPrefix}infopages`;
CREATE TABLE `{dbPrefix}infopages` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `widget` varchar(20) NOT NULL DEFAULT '',
  `widget_position` tinyint(1) NOT NULL DEFAULT 0,
  `widget_data` text DEFAULT NULL,
  `widget_titles` text DEFAULT NULL,
  `special` tinyint(4) NOT NULL DEFAULT 0,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `body_en` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}infopages`
--

LOCK TABLES `{dbPrefix}infopages` WRITE;
INSERT INTO `{dbPrefix}infopages` VALUES (1,1,'apartments',1,'{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"0\",\"obj_type_id\":\"0\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\",\"garage_type\":\"\",\"open_plan\":\"\",\"room_type\":\"\",\"balcony_type\":\"\",\"wc_type\":\"\",\"floor_coat\":\"\",\"build_year\":\"\",\"repair\":\"\",\"object_state\":\"\",\"building_type\":\"\",\"plot_type\":\"\"}','{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}',1,'Welcome!','2020-03-16 12:00:00','2020-03-16 08:53:29','<p><strong>Open Real Estate</strong> offers real estate agencies and realtors the technology they need to connect with today&rsquo;s real estate owners, prospective buyers and tenants and Internet surfers.<br />\r\n<br />\r\nAccording to your wish we can add, remove product&#39;s features and develop them in such a way that your web site captures the essence of Your Business.<br />\r\n<br />\r\nAt <a href=\"http://monoray.net\">MonoRay Studio</a> our goal is to produce websites that are search-engine friendly and refreshingly easy-to-use for admin and for users. It concerns not only а website for real estate agencies or for realtors, but any website. We build websites from the ground as well. Project managers work with you until you are satisfied with a site that meets your expectations the best way.<br />\r\n<br />\r\n<strong>Let Your Business Ideas Come True!</strong></p>\r\n'),(2,1,'viewallonmap',1,'','{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}',0,'Search on map','2020-03-16 12:00:00','2020-03-16 08:53:11',''),(3,1,'apartments',2,'{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"2\",\"obj_type_id\":\"0\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\"}','{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}',0,'Sale','2014-04-13 23:58:58','2020-03-16 08:53:14',''),(4,1,'',1,'',NULL,1,'User Agreement','2020-03-16 00:09:52','2020-03-16 08:53:33','<p>This Agreement defines the terms of use of the Site <a href=\"{site_domain}\">{site_title}</a> (hereinafter referred to as — «The Site») and its materials and services by the Users.</p>\n<p><strong>1.General Terms</strong></p>\n<p>1.1. Use of materials and services of the Site is governed by the applicable laws of the Russian Federation.</p>\n<p>1.2. This Agreement is a Public Offer. By getting an access to the Site materials the User is considered to have accepted the terms of the Agreement. </p>\n<p>1.3. The Site administration has the right to change the terms of the Agreement unilaterally at any time. Any modifications shall take effect 3 days after posting a new version of the Agreement on the Site. If the User doesn\'t agree to the terms he is obliged to abandon the access to the Site and to cease the use of the Site materials and services.</p>\n<p><strong>2. Responsibilities of the parties</strong></p>\n<p>2.1. The User agrees not to take any actions, which may be considered as violation of the Russian law or the rules of the international law in the field of the intellectual property, copyrights and / or related rights, as well as any action that results or may result in malfunction of the Site and  website services.</p>\n<p>2.2. Use of the Site materials without explicit permission of the copyright holders is prohibited (article 1270 Civil code of the RF). For the lawful use of the Site materials it is necessary to conclude a licensed agreement (get a license) with the copyright holders.</p>\n<p>2.3. When citing the Site materials including copyright works use of the link to the site is obligatory. (point 1 of the article 1274 Civil Code of the RF).</p>\n<p>2.4. Comments and other User\'s posts on the Site shall not contradict the rules of the Russian Law and generally accepted norms of morality and ethics.</p>\n<p>2.5. The User is warned that the Site administration is not liable for any visit and use of external resources, on the links which may be present on the Site.</p>\n<p>2.6. The User agrees that the Site administration is not responsible and has no direct or indirect liabilities to the User for any loss or damage of the Site contents, registration of the copyrights and information of such registration, goods and services, available or derived from external websites or resources or any other contacts arising from the use of the information posted on the Site or links to external resources. </p>\n<p>2.7. The User accepts that all the Site materials and services or any other part of it may be accompanied by advertising. The User agrees that the Site administration is not liable and doesn\'t have any obligations for such advertising</p>\n<p><strong>3. Other terms</strong></p>\n<p>3.1. All possible disputes arising from this Agreement  or related to it shall be settled in accordance with the current law of the Russian Federation.</p>\n<p>3.2. Nothing in the Agreement shall be understood as establishment of Agents relations, partnership relations, relations on joint activities, personal recruiting relations or any other type of relations between the User and the Site administration which are not directly stipulated by this Agreement.</p>\n<p>3.3. In case the Court treats any point of this Agreement invalid or unenforceable shall not entail invalidation of other statements  of the Agreement. </p>\n<p>3.4. Inaction of the Site administration in case of any violation of the Agreement statements by the Users does not preclude the Site administration to take appropriate actions later in defense of its interests and copyrights on the Site materials protected by the law.</p>\n<p><strong> The user confirms that he/she is aware of the terms and conditions of this Agreement and assumes them.</strong></p>'),(5,1,'',1,'',NULL,0,'Privacy Policy','2020-03-15 22:07:16','2020-03-16 08:53:37','<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and information security, is information that can be used on its own or with other information to identify, contact, or locate a single person, or to identify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally Identifiable Information in accordance with our website.</p>\n<p><strong>What personal information do we collect from the people that visit our blog, website or app?</strong></p>\n<p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p>\n<p><strong>When do we collect information?</strong></p>\n<p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p>\n<p><strong>How do we use your information? </strong></p>\n<p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p>\n<ol>\n    <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>\n    <li>To improve our website in order to better serve you.</li>\n	<li>To allow us to better service you in responding to your customer service requests.</li>\n	<li>To administer a contest, promotion, survey or other site feature.</li>\n	<li>Identify persons who may be viliating the law, the YOUR COMPANY SITE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SITE/NETWORK or its related properties;</li>\n	<li>To send periodic emails regarding your order or other products and services.</li>\n</ol>\n<p><strong>How do we protect visitor information?</strong></p>\n<p>We do not use vulnerability scanning and/or scanning to PCI standards.</p>\n<p>We do not use Malware Scanning.</p>\n<p>We do not use an SSL certificate.</p>\n<p><strong>Do we use \'cookies\'?</strong></p>\n<p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and site interaction so that we can offer better site experiences and tools in the future.</p>\n<p><strong>We use cookies to:</strong></p>\n<ol>\n    <li>Understand and save user\'s preferences for future visits.</li>\n    <li>Keep track of advertisements.</li>\n	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our behalf.</li>\n</ol>\n<p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (like Internet Explorer) settings. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p>\n<p><strong>If users disable cookies in their browser:</strong></p>\n<p>If you disable cookies off, some features will be disabled It will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p>\n<p><strong>Third-Party Disclosure</strong></p>\n<p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us in operating our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release information when it\'s release is appropriate to comply with the law, enforce our site policies, or protect ours or others\' rights, property, or safety. </p>\n<p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p>\n<p><strong>Third-party links</strong></p>\n<p>We do not include or offer third-party products or services on our website.</p>\n<p><strong>Google</strong></p>\n<p>Google\'s advertising requirements can be summed up by Google\'s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p>\n<p>We use Google AdSense Advertising on our website.</p>\n<p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google\'s use of the DART cookie enables it to serve ads to our users based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google Ad and Content Network privacy policy.</p>\n<p><strong>We have implemented the following:</strong></p>\n<ol>\n    <li>Remarketing with Google AdSense</li>\n    <li>Google Display Network Impression Reporting</li>\n	<li>Demographics and Interests Reporting</li>\n	<li>DoubleClick Platform Integration</li>\n</ol>\n<p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics cookies) and third-party cookies (such as the DoubleClick cookie) or other third-party identifiers together to compile data regarding user interactions with ad impressions and other ad service functions as they relate to our website. </p>\n<p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising initiative opt out page or permanently using the Google Analytics Opt Out Browser add on.</p>\n<p><strong>California Online Privacy Protection Act</strong></p>\n<p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) that operates websites collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the information being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p>\n<p><strong>According to CalOPPA we agree to the following:</strong></p>\n<p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p>\n<p><strong>How does our site handle do not track signals?</strong></p>\n<p>We honor do not track signals and do not track, plant cookies, or use advertising when a Do Not Track (DNT) browser mechanism is in place. </p>\n<p><strong>Does our site allow third-party behavioral tracking?</strong></p>\n<p>It\'s also important to note that we allow third-party behavioral tracking</p>\n<p><strong>COPPA (Children Online Privacy Protection Act)</strong></p>\n<p>When it comes to the collection of personal information from children under 13, the Children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p>\n<p><strong>Fair Information Practices</strong></p>\n<p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p>\n<p><strong>CAN SPAM Act</strong></p>\n<p>The CAN-SPAM Act is a law that sets the rules for commercial email, establishes requirements for commercial messages, gives recipients the right to have emails stopped from being sent to them, and spells out tough penalties for violations.</p>\n<p><strong>Contacting Us</strong></p>\n<p>If there are any questions regarding this privacy policy you may contact us using the information below.</p>\n<br /><br />\n<p>YOUSITEDOMAIN</p>\n<p>Last Edited on 2016-02-05</p>\n'),(6,1,'apartments',1,'{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"1\",\"obj_type_id\":\"0\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\"}','{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}',0,'Rent','2017-10-02 08:57:14','2020-03-16 08:53:21',''),(7,1,'apartments',2,'{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"0\",\"obj_type_id\":\"6\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\",\"garage_type\":\"\",\"open_plan\":\"\",\"room_type\":\"\",\"balcony_type\":\"\",\"wc_type\":\"\",\"floor_coat\":\"\",\"build_year\":\"\",\"repair\":\"\",\"object_state\":\"\",\"building_type\":\"\",\"plot_type\":\"\"}','{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}',0,'Hotels','2020-03-16 09:08:43','2020-03-16 08:53:39','<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n'),(8,1,'apartments',1,'{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"0\",\"obj_type_id\":\"5\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\",\"garage_type\":\"\",\"open_plan\":\"\",\"room_type\":\"\",\"balcony_type\":\"\",\"wc_type\":\"\",\"floor_coat\":\"\",\"build_year\":\"\",\"repair\":\"\",\"object_state\":\"\",\"building_type\":\"\",\"plot_type\":\"\"}','{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}',0,'New Buildings','2020-03-16 09:15:44','2020-03-16 08:53:40','<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vix, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis, est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ius, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vix decore corpora detracto at. Velit nusquam in qui. Eu eum tibique deserunt facilisis, ne vim denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque est id, etiam bonorum te sit. In vim saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, ei has augue semper electram, eu assum menandri contentiones vix.</p>\r\n');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}lang`
--

DROP TABLE IF EXISTS `{dbPrefix}lang`;
CREATE TABLE `{dbPrefix}lang` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `isRTL` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `currency_id` int(11) unsigned NOT NULL DEFAULT 0,
  `main` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `name_iso` varchar(20) NOT NULL DEFAULT '',
  `name_rfc3066` varchar(10) NOT NULL DEFAULT '',
  `name_ru` varchar(100) NOT NULL DEFAULT '',
  `active` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `sorter` smallint(6) unsigned NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `name_en` varchar(100) NOT NULL DEFAULT '',
  `admin_mail` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `flag_img` varchar(50) NOT NULL DEFAULT '',
  `name_de` varchar(100) NOT NULL DEFAULT '',
  `price_tpl_default` varchar(255) NOT NULL DEFAULT '',
  `price_tpl_from` varchar(255) NOT NULL DEFAULT '',
  `price_tpl_to` varchar(255) NOT NULL DEFAULT '',
  `dateFormat` varchar(30) NOT NULL DEFAULT 'd.m.Y H:i:s',
  `priceDecimalsPoint` varchar(1) NOT NULL DEFAULT ',',
  `priceThousandsSeparator` varchar(1) NOT NULL DEFAULT '',
  `name_es` varchar(100) NOT NULL DEFAULT '',
  `name_ar` varchar(100) NOT NULL DEFAULT '',
  `name_tr` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `active` (`active`),
  KEY `currency_id` (`currency_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}lang`
--

LOCK TABLES `{dbPrefix}lang` WRITE;
INSERT INTO `{dbPrefix}lang` VALUES (2,0,11,1,'en','en-US','Английский',1,1,'2014-08-05 12:15:49','English',1,'us.png','','<span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> {TYPE}','<span class=\"currency\">{CURRENCY}</span> <span class=\"number\">{TEXT_FROM}</span> {PRICE} ','<span class=\"currency\">{CURRENCY}</span> <span class=\"number\">{TEXT_TO}</span> {PRICE} ','d.m.Y H:i:s',',','','','','');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}lang_widget_opt`
--

DROP TABLE IF EXISTS `{dbPrefix}lang_widget_opt`;
CREATE TABLE `{dbPrefix}lang_widget_opt` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `model_name` char(100) NOT NULL DEFAULT '',
  `model_id` int(11) unsigned NOT NULL DEFAULT 0,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`),
  KEY `model_name` (`model_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}lang_widget_opt`
--

LOCK TABLES `{dbPrefix}lang_widget_opt` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}location_district`
--

DROP TABLE IF EXISTS `{dbPrefix}location_district`;
CREATE TABLE `{dbPrefix}location_district` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `region_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `city_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name_ru` varchar(100) NOT NULL DEFAULT '',
  `name_en` varchar(100) NOT NULL DEFAULT '',
  `name_de` varchar(100) NOT NULL DEFAULT '',
  `name_es` varchar(100) NOT NULL DEFAULT '',
  `name_ar` varchar(100) NOT NULL DEFAULT '',
  `name_tr` varchar(100) NOT NULL DEFAULT '',
  `active` tinyint(4) NOT NULL DEFAULT 1,
  `sorter` mediumint(8) NOT NULL DEFAULT 0,
  `date_updated` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `region_id` (`region_id`),
  KEY `city_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}location_district`
--

LOCK TABLES `{dbPrefix}location_district` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}menu`
--

DROP TABLE IF EXISTS `{dbPrefix}menu`;
CREATE TABLE `{dbPrefix}menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_list_id` int(11) unsigned NOT NULL DEFAULT 0,
  `parentId` int(11) unsigned NOT NULL DEFAULT 0,
  `number` int(11) unsigned NOT NULL DEFAULT 0,
  `pageId` int(11) unsigned NOT NULL DEFAULT 0,
  `is_blank` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `active` tinyint(4) unsigned NOT NULL DEFAULT 1,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `type` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `special` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `href_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `menu_list_id` (`menu_list_id`),
  KEY `parentId` (`parentId`),
  KEY `pageId` (`pageId`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}menu`
--

LOCK TABLES `{dbPrefix}menu` WRITE;
INSERT INTO `{dbPrefix}menu` VALUES (1,2,0,4,1,0,0,'2019-03-16 08:34:38',2,1,'Home','/site/index'),(2,2,0,7,0,0,1,'2020-02-16 16:00:25',1,1,'News','/news'),(3,2,0,5,0,0,1,'2019-03-16 08:53:33',1,1,'Special offers','/specialoffers/main/index'),(4,2,7,16,0,0,1,'2020-02-16 15:46:06',1,1,'Q&As','/articles/main/index'),(6,2,0,10,0,0,1,'2019-03-16 08:53:33',1,1,'Reviews','/reviews/main/index'),(7,2,0,11,0,0,1,'2019-03-16 08:34:52',0,0,'More',''),(8,2,13,1,2,0,1,'2019-03-16 08:34:54',2,0,'Search on map',''),(9,2,7,13,1,0,1,'2019-03-16 08:53:33',1,1,'Members','/users/main/search'),(10,1,0,1,1,0,1,'2019-03-16 08:55:10',1,0,'List your property','{baseUrl}/guestad/add'),(11,1,0,2,1,0,1,'2019-03-16 08:55:04',1,0,'Contact us','{baseUrl}/contact-us'),(12,2,0,7,0,0,1,'2019-03-16 08:53:33',1,1,'Articles','/articles'),(13,2,0,4,0,0,1,'2019-03-16 08:53:33',0,1,'Search','/quicksearch/main/mainsearch'),(14,2,13,2,3,0,1,'2019-03-16 08:35:09',2,0,'Sale',''),(15,2,13,4,6,0,1,'2019-03-16 08:35:12',2,0,'Rent',''),(16,2,13,6,7,0,1,'2019-03-16 08:35:13',2,0,'Hotels',''),(17,2,13,3,8,0,1,'2019-03-16 08:35:17',2,0,'New Buildings',''),(20,3,0,1,1,0,0,'2019-03-16 08:35:19',2,1,'Home','/site/index'),(21,3,0,3,1,0,1,'2019-03-16 08:54:55',1,0,'List your property','{baseUrl}/guestad/add'),(22,3,0,2,1,0,1,'2019-03-16 08:54:51',1,0,'Contact us','{baseUrl}/contact-us'),(23,4,0,6,0,0,1,'2019-03-16 08:53:33',1,1,'News','/news'),(24,4,0,5,0,0,1,'2019-03-16 08:53:33',1,1,'Special offers','/specialoffers/main/index'),(25,4,28,16,0,0,1,'2020-02-16 16:00:09',1,1,'Q&As','/articles/main/index'),(26,4,28,9,0,0,1,'2019-03-16 08:53:33',1,1,'Site map','/sitemap/main/index'),(27,4,0,10,0,0,1,'2019-03-16 08:53:33',1,1,'Reviews','/reviews/main/index'),(28,4,0,11,0,0,1,'2019-03-16 08:35:35',0,0,'More',''),(29,4,32,1,2,0,1,'2019-03-16 08:35:38',2,0,'Search on map',''),(30,4,28,13,1,0,1,'2019-03-16 08:53:33',1,1,'Members','/users/main/search'),(31,4,0,7,0,0,1,'2019-03-16 08:53:33',1,1,'Articles','/articles'),(32,4,0,4,0,0,1,'2019-03-16 08:53:33',0,0,'Search','/quicksearch/main/mainsearch'),(33,4,32,2,3,0,1,'2019-03-16 08:35:45',2,0,'Sale',''),(34,4,32,4,6,0,1,'2019-03-16 08:35:47',2,0,'Rent',''),(35,4,32,6,7,0,1,'2019-03-16 08:35:50',2,0,'Hotels',''),(36,4,32,3,8,0,1,'2019-03-16 08:35:53',2,0,'New Buildings',''),(38,5,0,6,2,0,1,'2019-03-16 08:53:33',1,1,'News','/news'),(39,5,0,1,1,0,0,'2019-03-16 08:35:59',2,1,'Home','/site/index'),(40,5,0,3,3,0,1,'2019-03-16 08:54:38',1,0,'List your property','{baseUrl}/guestad/add'),(41,5,0,2,4,0,1,'2019-03-16 08:54:42',1,0,'Contact us','{baseUrl}/contact-us'),(42,5,0,5,5,0,1,'2019-03-16 08:53:33',1,1,'Special offers','/specialoffers/main/index'),(43,5,0,8,6,0,1,'2019-03-16 08:53:33',1,1,'Q&As','/articles/main/index'),(44,5,0,9,7,0,1,'2019-03-16 08:53:33',1,1,'Site map','/sitemap/main/index'),(45,5,0,10,8,0,1,'2019-03-16 08:53:33',1,1,'Reviews','/reviews/main/index'),(46,3,0,14,1,0,0,'2019-03-16 08:54:14',1,1,'Booking a property','booking/main/mainform'),(47,2,7,14,5,0,1,'2019-03-16 08:36:12',2,0,'Privacy Policy',''),(48,4,28,14,5,0,1,'2019-03-16 08:36:16',2,0,'Privacy Policy',''),(49,4,28,15,4,0,1,'2019-03-16 08:36:19',2,0,'User Agreement',''),(50,2,7,15,4,0,1,'2019-03-16 08:36:21',2,0,'User Agreement',''),(51,2,0,7,8,0,1,'2020-02-16 16:01:26',1,1,'Favorites','/favorites'),(52,4,0,6,8,0,1,'2020-02-16 16:02:23',1,1,'Favorites','/favorites'),(53,1,0,16,1,0,1,'2019-03-16 08:54:14',1,1,'Request a call back','site/callback'),(54,3,0,16,1,0,0,'2019-03-16 08:54:14',1,1,'Request a call back','site/callback'),(55,5,0,17,1,0,1,'2019-03-16 08:54:14',1,1,'Request a call back','site/callback');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}menu_list`
--

DROP TABLE IF EXISTS `{dbPrefix}menu_list`;
CREATE TABLE `{dbPrefix}menu_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `is_system` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}menu_list`
--

LOCK TABLES `{dbPrefix}menu_list` WRITE;
INSERT INTO `{dbPrefix}menu_list` VALUES (1,1,'Header - Template: Atlas',1),(2,1,'Top - Template: Atlas',1),(3,1,'Header - Template: Basis and Dolphin',1),(4,1,'Top - Template: Basis and Dolphin',1),(5,1,'Footer - Template: Basis and Dolphin',1);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}news_product`
--

DROP TABLE IF EXISTS `{dbPrefix}news_product`;
CREATE TABLE `{dbPrefix}news_product` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text DEFAULT NULL,
  `link` varchar(255) NOT NULL DEFAULT '',
  `pubDate` timestamp NULL DEFAULT NULL,
  `author` varchar(150) NOT NULL DEFAULT '',
  `is_show` tinyint(1) NOT NULL DEFAULT 0,
  `lang` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}news_product`
--

LOCK TABLES `{dbPrefix}news_product` WRITE;
INSERT INTO `{dbPrefix}news_product` VALUES (13,'Open Real Estate 1.15.3','<p>\n	The new version of CMS&nbsp;<a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		Improvements and bug fixes.</li>\n</ul>\n','http://open-real-estate.info/en/blog/open-real-estate-1153','2016-01-31 12:26:30','open-real-estate.info',1,'en'),(14,'Settings and security tuning','<p>\n                Before you start installing Open Real Estate CMS, it\'s strongly recommended to change the default value of the variable, responsible for users\' passwords generating. <br />\n                This step is necessary to protect the passwords in case the script is hacked/exploited.\n            </p>','http://open-real-estate.info/en/blog/settings-and-security-tuning','2016-01-23 14:53:01','open-real-estate.info',1,'en'),(15,'Open Real Estate 1.15.2','<p>We have released an updated version of <a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>Developers have implemented some corrections and made some improvements to the product to make it even better than before!</p>','http://open-real-estate.info/en/blog/open-real-estate-1152','2016-01-13 09:42:11','open-real-estate.info',1,'en'),(16,'Restricting admin access to specific IP addresses','<p>\n	In the article we&#39;ll overview one of the options to protect admin panel of your property website, based on Open Real Estate software. Specifically, we&#39;ll see how to restrict authorization in the admin panel to specific IP addresses.</p>\n','http://open-real-estate.info/en/blog/restricting-admin-access-to-specific-ip-addresses','2016-01-11 08:01:31','open-real-estate.info',1,'en'),(17,'Machine (automated) translation in Open Real Estate CMS','<p>\n	Machine translation is used after &quot;Translate&quot; button is clicked</p>\n<p>\n	<a href=\"http://static.monoray.net/images/open-real-estate.info/blog_listing_add_en.jpg\" rel=\"prettyPhoto\"><img src=\"http://static.monoray.net/images/open-real-estate.info/blog_listing_add_en_small.jpg\" /> </a></p>\n<p>\n	After this button is clicked, script sends a request to Google Translate with cUrl, and thwn the translated line returns. High quality of this translation is not guaranteed.</p>\n<p>\n	Recently this functionlaity stopped working.</p>\n','http://open-real-estate.info/en/blog/mashinnyj-perevod-v-open-real-estate-cms','2015-12-22 04:45:12','open-real-estate.info',1,'en'),(18,'New Year discount for Pro and Ultimate versions!','<p>\n	Celebrating the 4th anniversary of our product and coming Christmas and New Year holidays, we offer 20% discount for <a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">PRO</a> and <a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Ultimate</a> versions of Open Real Estate software!</p>\n<p>\n	<strong>Hurry up! Our special offer is valid till December, 30.</strong></p>\n','http://open-real-estate.info/en/blog/new-year-2015-discount','2015-12-16 12:28:22','open-real-estate.info',1,'en'),(19,'Open Real Estate 1.15.1','<p>\n	The new version of CMS&nbsp;<a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		numerous improvements and bug fixes.</li>\n</ul>\n','http://open-real-estate.info/en/blog/open-real-estate-1151','2015-12-16 07:49:32','open-real-estate.info',1,'en'),(20,'Open Real Estate 1.15.0','<p>\n	The new version of CMS&nbsp;<a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		online booking payment (available only with modules &#39;Booking calendar&#39; and &#39;Payments and paid services&#39;);</li>\n	<li>\n		new paid add-on &#39;History of changes&#39;;</li>\n	<li>\n		new paid add-on &#39;Metro stations&#39;;</li>\n	<li>\n		new add-on &#39;Materials&#39;. Now you can create content categories of your own: news, article, blog and assign categories to newly created materials (news, articles, posts);</li>\n	<li>\n		new base of countries, regions and cities for module &#39;Location&#39; from SypexGeo (https://sypexgeo.net/ru/download/) ;</li>\n	<li>\n		property on a map in print version;</li>\n	<li>\n		framework Yii is updated up to the latest version (1.1.16);</li>\n	<li>\n		numerous improvements and bug fixes.</li>\n</ul>\n','http://open-real-estate.info/en/blog/open-real-estate-1150','2015-12-06 11:04:18','open-real-estate.info',1,'en'),(22,'Open Real Estate 1.15.3','<p>\n	Выпущена новая версия <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		Улучшения и исправления ошибок.</li>\n</ul>\n','http://open-real-estate.info/ru/blog/open-real-estate-1153','2016-01-31 12:26:30','open-real-estate.info',1,'ru'),(23,'Настройки и улучшение безопасности','<p>\n                Перед установкой скрипта недвижимости Open Real Estate CMS мы рекомендуем изменить стандартное значение переменной для генерации паролей пользователей. <br />\n                Данный шаг необходим для защиты самих паролей, на случай, если приложение будет взломано.\n            </p>','http://open-real-estate.info/ru/blog/settings-and-security-tuning','2016-01-23 14:53:01','open-real-estate.info',1,'ru'),(24,'Open Real Estate 1.15.2','<p>Мы выпустили новую версию <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>В новой версии разработчики внесли несколько исправлений и улучшений в наш продукт, сделав его ещё лучше!</p>','http://open-real-estate.info/ru/blog/open-real-estate-1152','2016-01-13 09:42:11','open-real-estate.info',1,'ru'),(25,'Ограничение входа в панель администратора по IP адресу','<p>\n	В этой статье рассмотрим один из вариантов &quot;защиты админки&quot; на вашем сайте недвижимости, работающем на Open Real Estate, а именно: авторизацию в &quot;админку&quot; только с определённых IP адресов.</p>\n','http://open-real-estate.info/ru/blog/restricting-admin-access-to-specific-ip-addresses','2016-01-11 08:01:31','open-real-estate.info',1,'ru'),(26,'Машинный перевод в Open Real Estate CMS','<p>\n	Машинный перевод в нашем скрипте используется при клике на кнопку &quot;Перевести&quot;</p>\n<p>\n	<a href=\"http://static.monoray.net/images/open-real-estate.info/blog_listing_add_ru.jpg\" rel=\"prettyPhoto\"><img src=\"http://static.monoray.net/images/open-real-estate.info/blog_listing_add_ru_small.jpg\" /> </a></p>\n<p>\n	При этом с помощью cUrl отправляется запрос в Google Translate и возвращается строка в переводом. Вопрос качества такого перевода рассматривать не будем.</p>\n<p>\n	С недавних пор такая функция перестала работать.</p>\n','http://open-real-estate.info/ru/blog/mashinnyj-perevod-v-open-real-estate-cms','2015-12-22 04:45:12','open-real-estate.info',1,'ru'),(27,'Новогодние скидки на Open Real Estate','<p>\n	К четырёхлетию продукта Open Real Estate CMS и Новому Году скидка при покупке <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate PRO</a> или <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate Ultimate</a> версии <strong><span style=\"color: #ff0000;\">составит 20%</span></strong>!</p>\n<p>\n	<strong>Спешите! Акция действует с 16 по 30 декабря 2015 года.</strong></p>\n','http://open-real-estate.info/ru/blog/new-year-2015-discount','2015-12-16 12:28:22','open-real-estate.info',1,'ru'),(28,'Open Real Estate 1.15.1','<p>\n	Выпущена новая версия <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		многочисленные улучшения и исправления ошибок.</li>\n</ul>\n','http://open-real-estate.info/ru/blog/open-real-estate-1151','2015-12-16 07:49:32','open-real-estate.info',1,'ru'),(29,'Open Real Estate 1.15.0','<p>\n	Выпущена новая версия <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		оплата за бронирование ( только при наличии модулей &quot;Календарь бронирования&quot; и &quot;Платные услуги&quot; );</li>\n	<li>\n		новый платный модуль &quot;История изменений&quot;;</li>\n	<li>\n		новый платный модуль &quot;Станции метро&quot;;</li>\n	<li>\n		новый модуль &quot;Материалы&quot;. Теперь можно создавать свои собственные категории: новости, статьи, блог и т.п. Добавлять в категории созданные категории материалы ( новость, статья, запись и т.п );</li>\n	<li>\n		новая база стран, регионов и городов для модуля &quot;Местоположение&quot; от SypexGeo ( https://sypexgeo.net/ru/download/ );</li>\n	<li>\n		вывод местоположения объекта на карте в версии для печати;</li>\n	<li>\n		фреймворк Yii обновлен до последней версии ( 1.1.16 );</li>\n	<li>\n		многочисленные улучшения и исправления ошибок.</li>\n</ul>\n','http://open-real-estate.info/ru/blog/open-real-estate-1150','2015-12-06 11:04:18','open-real-estate.info',1,'ru'),(30,'Open Business Card 1.4.0','<p>\n	Are you looking for a simple engine (script) to build a business card website? <br />\n	Try an updated version of our CMS - <a href=\"http://monoray.net/products/51-open-business-card\" target=\"_blank\">Open Business Card</a>. <br />\n	The updated version 1.4.0 offers multilanguage support, increased speedwork, a lot of minor improvements.  <br /> <br />\n\n	<strong>And all this is absolutely free!</strong>\n</p>','http://open-real-estate.info/en/blog/open-business-card-140','2016-02-05 05:15:11','open-real-estate.info',1,'en'),(31,'Open Business Card 1.4.0','<p>\n	Ищите простой движок ( скрипт ) для создания сайтов-визиток? <br />\n	Попробуйте обновлённую версию нашей CMS - <a href=\"http://monoray.ru/products/51-open-business-card\" target=\"_blank\">Open Business Card</a>. <br />\n	В новой версии, 1.4.0, мы добавили поддержку мультиязычности, увеличили быстродействие, внесли множество мелких улучшений. <br /> <br />\n\n	<strong>И всё это совершенно бесплатно!</strong>\n</p>','http://open-real-estate.info/ru/blog/open-business-card-140','2016-02-05 05:15:11','open-real-estate.info',1,'ru'),(32,'Open Real Estate 1.16.0','<p>\n	The new version of CMS&nbsp;<a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>New and very useful functions, trendy design changes and intuitive management - that\'s what we\'ve been working on while developing version 1.16.0. We recommend checking our demo <a href=\"http://re-pro.monoray.net/en\" target=\"_blank\">right now</a>!</p>','http://open-real-estate.info/en/blog/open-real-estate-1160','2016-03-22 09:11:40','open-real-estate.info',1,'en'),(33,'High time to buy Open Real Estate CMS!','<p>You\'ve been thinking about Open Real Estate CMS purchase for a long time, but couldn\'t make up your mind?</p>\n<p>It\'s high time for a VERY profitable purchase!</p>','http://open-real-estate.info/en/blog/best-time-to-buy','2016-03-14 07:44:34','open-real-estate.info',1,'en'),(34,'Open Real Estate 1.15.4','<p>\n	The new version of CMS&nbsp;<a href=\"http://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		Improvements and bug fixes.</li>\n</ul>','http://open-real-estate.info/en/blog/open-real-estate-1154','2016-02-29 05:59:23','open-real-estate.info',1,'en'),(35,'Open Real Estate 1.16.0','<p>\n	Выпущена новая версия <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>Новые и очень полезные функции, трендовые изменения в дизайне и интуитивное управление - то, над чем мы поработали в версии 1.16.0. Рекомендуем проверить <a href=\"http://re-pro.monoray.net/ru\" target=\"_blank\">прямо сейчас</a>!</p>\n','http://open-real-estate.info/ru/blog/open-real-estate-1160','2016-03-22 09:11:40','open-real-estate.info',1,'ru'),(36,'Самое время для покупки Open Real Estate','<p>Давно думаете о покупке Open Real Estate CMS, но никак не можете решиться?</p>\n<p>Сейчас самое время для ОЧЕНЬ выгодной покупки!</p>','http://open-real-estate.info/ru/blog/best-time-to-buy','2016-03-14 07:44:34','open-real-estate.info',1,'ru'),(37,'Open Real Estate 1.15.4','<p>\n	Выпущена новая версия <a href=\"http://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		Улучшения и исправления ошибок.</li>\n</ul>','http://open-real-estate.info/ru/blog/open-real-estate-1154','2016-02-29 05:59:23','open-real-estate.info',1,'ru'),(38,'Why do you need to buy \'Atlas\' theme in April?','<p>Search engines incessantly improve and modify search results algorithms.</p>\n<p>As it often happens, there\'s no enough energy and time to keep up with all innovations in SEO and edit the site content. </p>\n<br />\n<p>However, we\'re having a very good news for you!</p>\n<p>A fail-free possibility to rank your site higher in search results (at least in Google) is to buy our \'Atlas\' theme. </p>','https://open-real-estate.info/en/blog/why-need-buy-atlas-theme','2016-04-07 04:26:15','open-real-estate.info',1,'en'),(39,'Open Real Estate 1.16.1','	<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.\n</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n		<li>Option to rotate listing photos after the upload;</li>\n		<li>Option to edit seasonal prices;</li>\n		<li>Error in listing view form under PHP 7 is fixed;</li>\n		<li>Paid systems PayPal and PayMaster - validity verification of payments is added;</li>\n		<li>Other improvements and minor corrections.</li>\n	</ul>','https://open-real-estate.info/en/blog/open-real-estate-1161','2016-04-06 14:47:54','open-real-estate.info',1,'en'),(40,'Open Real Estate 1.16.0','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>New and very useful functions, trendy design changes and intuitive management - that\'s what we\'ve been working on while developing version 1.16.0. We recommend checking our demo <a href=\"http://re-pro.monoray.net/en\" target=\"_blank\">right now</a>!</p>','https://open-real-estate.info/en/blog/open-real-estate-1160','2016-03-22 09:11:40','open-real-estate.info',1,'en'),(41,'High time to buy Open Real Estate CMS!','<p>You\'ve been thinking about Open Real Estate CMS purchase for a long time, but couldn\'t make up your mind?</p>\n<p>It\'s high time for a VERY profitable purchase!</p>','https://open-real-estate.info/en/blog/best-time-to-buy','2016-03-14 07:44:34','open-real-estate.info',1,'en'),(42,'Open Real Estate 1.15.4','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		Improvements and bug fixes.</li>\n</ul>','https://open-real-estate.info/en/blog/open-real-estate-1154','2016-02-29 05:59:23','open-real-estate.info',1,'en'),(43,'Open Business Card 1.4.0','<p>\n	Are you looking for a simple engine (script) to build a business card website? <br />\n	Try an updated version of our CMS - <a href=\"https://monoray.net/products/51-open-business-card\" target=\"_blank\">Open Business Card</a>. <br />\n	The updated version 1.4.0 offers multilanguage support, increased speedwork, a lot of minor improvements.  <br /> <br />\n\n	<strong>And all this is absolutely free!</strong>\n</p>','https://open-real-estate.info/en/blog/open-business-card-140','2016-02-05 05:15:11','open-real-estate.info',1,'en'),(44,'Open Real Estate 1.15.3','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		Improvements and bug fixes.</li>\n</ul>\n','https://open-real-estate.info/en/blog/open-real-estate-1153','2016-01-31 12:26:30','open-real-estate.info',1,'en'),(45,'Settings and security tuning','<p>\n                Before you start installing Open Real Estate CMS, it\'s strongly recommended to change the default value of the variable, responsible for users\' passwords generating. <br />\n                This step is necessary to protect the passwords in case the script is hacked/exploited.\n            </p>','https://open-real-estate.info/en/blog/settings-and-security-tuning','2016-01-23 14:53:01','open-real-estate.info',1,'en'),(46,'Open Real Estate 1.15.2','<p>We have released an updated version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>Developers have implemented some corrections and made some improvements to the product to make it even better than before!</p>','https://open-real-estate.info/en/blog/open-real-estate-1152','2016-01-13 09:42:11','open-real-estate.info',1,'en'),(47,'Restricting admin access to specific IP addresses','<p>\n	In the article we&#39;ll overview one of the options to protect admin panel of your property website, based on Open Real Estate software. Specifically, we&#39;ll see how to restrict authorization in the admin panel to specific IP addresses.</p>\n','https://open-real-estate.info/en/blog/restricting-admin-access-to-specific-ip-addresses','2016-01-11 08:01:31','open-real-estate.info',1,'en'),(48,'Machine (automated) translation in Open Real Estate CMS','<p>\n	Machine translation is used after &quot;Translate&quot; button is clicked</p>\n<p>\n	<a href=\"https://open-real-estate.info/uploads/clause/blog_listing_add_en.jpg\" rel=\"prettyPhoto\"><img src=\"https://open-real-estate.info/uploads/clause/blog_listing_add_en_small.jpg\" /> </a></p>\n<p>\n	After this button is clicked, script sends a request to Google Translate with cUrl, and thwn the translated line returns. High quality of this translation is not guaranteed.</p>\n<p>\n	Recently this functionlaity stopped working.</p>\n','https://open-real-estate.info/en/blog/mashinnyj-perevod-v-open-real-estate-cms','2015-12-22 04:45:12','open-real-estate.info',1,'en'),(49,'New Year discount for Pro and Ultimate versions!','<p>\n	Celebrating the 4th anniversary of our product and coming Christmas and New Year holidays, we offer 20% discount for <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">PRO</a> and <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Ultimate</a> versions of Open Real Estate software!</p>\n<p>\n	<strong>Hurry up! Our special offer is valid till December, 30.</strong></p>\n','https://open-real-estate.info/en/blog/new-year-2015-discount','2015-12-16 12:28:22','open-real-estate.info',1,'en'),(50,'Open Real Estate 1.15.1','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		numerous improvements and bug fixes.</li>\n</ul>\n','https://open-real-estate.info/en/blog/open-real-estate-1151','2015-12-16 07:49:32','open-real-estate.info',1,'en'),(51,'Open Real Estate 1.15.0','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		online booking payment (available only with modules &#39;Booking calendar&#39; and &#39;Payments and paid services&#39;);</li>\n	<li>\n		new paid add-on &#39;History of changes&#39;;</li>\n	<li>\n		new paid add-on &#39;Metro stations&#39;;</li>\n	<li>\n		new add-on &#39;Materials&#39;. Now you can create content categories of your own: news, article, blog and assign categories to newly created materials (news, articles, posts);</li>\n	<li>\n		new base of countries, regions and cities for module &#39;Location&#39; from SypexGeo (https://sypexgeo.net/ru/download/) ;</li>\n	<li>\n		property on a map in print version;</li>\n	<li>\n		framework Yii is updated up to the latest version (1.1.16);</li>\n	<li>\n		numerous improvements and bug fixes.</li>\n</ul>\n','https://open-real-estate.info/en/blog/open-real-estate-1150','2015-12-06 11:04:18','open-real-estate.info',1,'en'),(52,'Для чего необходимо купить тему \"Atlas\" в апреле?','<p>Поисковые системы постоянно улучшают и меняют алгоритмы выдачи.</p>\n<p>Зачаcтую, чтобы угнаться за всеми новшествами в SEO-оптимизации и отредактировать контент сайта не остаётся ни сил, ни времени.</p>\n<br />\n<p>Однако, есть хорошая новость!</p>\n<p>Беспроигрышный вариант повысить свой сайт в выдаче, по крайней мере, в поисковой системе Google - это купить тему \"Atlas\".</p>','https://open-real-estate.info/ru/blog/why-need-buy-atlas-theme','2016-04-07 04:26:15','open-real-estate.info',1,'ru'),(53,'Open Real Estate 1.16.1','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n		<li>Возможность переворачивать изображения к объявлениям после загрузки;</li>\n		<li>Возможность редактирования сезонных цен;</li>\n		<li>Исправлена ошибка при просмотре объявления под PHP 7;</li>\n		<li>Платёжные системы PayPal и PayMaster - добавлены проверки валидности платежа;</li>\n		<li>Другие улучшения и незначительные исправления.</li>\n	</ul>','https://open-real-estate.info/ru/blog/open-real-estate-1161','2016-04-06 14:47:54','open-real-estate.info',1,'ru'),(54,'Open Real Estate 1.16.0','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>Новые и очень полезные функции, трендовые изменения в дизайне и интуитивное управление - то, над чем мы поработали в версии 1.16.0. Рекомендуем проверить <a href=\"http://re-pro.monoray.net/ru\" target=\"_blank\">прямо сейчас</a>!</p>\n','https://open-real-estate.info/ru/blog/open-real-estate-1160','2016-03-22 09:11:40','open-real-estate.info',1,'ru'),(55,'Самое время для покупки Open Real Estate','<p>Давно думаете о покупке Open Real Estate CMS, но никак не можете решиться?</p>\n<p>Сейчас самое время для ОЧЕНЬ выгодной покупки!</p>','https://open-real-estate.info/ru/blog/best-time-to-buy','2016-03-14 07:44:34','open-real-estate.info',1,'ru'),(56,'Open Real Estate 1.15.4','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		Улучшения и исправления ошибок.</li>\n</ul>','https://open-real-estate.info/ru/blog/open-real-estate-1154','2016-02-29 05:59:23','open-real-estate.info',1,'ru'),(57,'Open Business Card 1.4.0','<p>\n	Ищите простой движок ( скрипт ) для создания сайтов-визиток? <br />\n	Попробуйте обновлённую версию нашей CMS - <a href=\"https://monoray.ru/products/51-open-business-card\" target=\"_blank\">Open Business Card</a>. <br />\n	В новой версии, 1.4.0, мы добавили поддержку мультиязычности, увеличили быстродействие, внесли множество мелких улучшений. <br /> <br />\n\n	<strong>И всё это совершенно бесплатно!</strong>\n</p>','https://open-real-estate.info/ru/blog/open-business-card-140','2016-02-05 05:15:11','open-real-estate.info',1,'ru'),(58,'Open Real Estate 1.15.3','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		Улучшения и исправления ошибок.</li>\n</ul>\n','https://open-real-estate.info/ru/blog/open-real-estate-1153','2016-01-31 12:26:30','open-real-estate.info',1,'ru'),(59,'Настройки и улучшение безопасности','<p>\n                Перед установкой скрипта недвижимости Open Real Estate CMS мы рекомендуем изменить стандартное значение переменной для генерации паролей пользователей. <br />\n                Данный шаг необходим для защиты самих паролей, на случай, если приложение будет взломано.\n            </p>','https://open-real-estate.info/ru/blog/settings-and-security-tuning','2016-01-23 14:53:01','open-real-estate.info',1,'ru'),(60,'Open Real Estate 1.15.2','<p>Мы выпустили новую версию <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>В новой версии разработчики внесли несколько исправлений и улучшений в наш продукт, сделав его ещё лучше!</p>','https://open-real-estate.info/ru/blog/open-real-estate-1152','2016-01-13 09:42:11','open-real-estate.info',1,'ru'),(61,'Ограничение входа в панель администратора по IP адресу','<p>\n	В этой статье рассмотрим один из вариантов &quot;защиты админки&quot; на вашем сайте недвижимости, работающем на Open Real Estate, а именно: авторизацию в &quot;админку&quot; только с определённых IP адресов.</p>\n','https://open-real-estate.info/ru/blog/restricting-admin-access-to-specific-ip-addresses','2016-01-11 08:01:31','open-real-estate.info',1,'ru'),(62,'Машинный перевод в Open Real Estate CMS','<p>\n	Машинный перевод в нашем скрипте используется при клике на кнопку &quot;Перевести&quot;</p>\n<p>\n	<a href=\"https://open-real-estate.info/uploads/clause/blog_listing_add_ru.jpg\" rel=\"prettyPhoto\"><img src=\"https://open-real-estate.info/uploads/clause/blog_listing_add_ru_small.jpg\" /> </a></p>\n<p>\n	При этом с помощью cUrl отправляется запрос в Google Translate и возвращается строка в переводом. Вопрос качества такого перевода рассматривать не будем.</p>\n<p>\n	С недавних пор такая функция перестала работать.</p>\n','https://open-real-estate.info/ru/blog/mashinnyj-perevod-v-open-real-estate-cms','2015-12-22 04:45:12','open-real-estate.info',1,'ru'),(63,'Новогодние скидки на Open Real Estate','<p>\n	К четырёхлетию продукта Open Real Estate CMS и Новому Году скидка при покупке <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate PRO</a> или <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate Ultimate</a> версии <strong><span style=\"color: #ff0000;\">составит 20%</span></strong>!</p>\n<p>\n	<strong>Спешите! Акция действует с 16 по 30 декабря 2015 года.</strong></p>\n','https://open-real-estate.info/ru/blog/new-year-2015-discount','2015-12-16 12:28:22','open-real-estate.info',1,'ru'),(64,'Open Real Estate 1.15.1','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		многочисленные улучшения и исправления ошибок.</li>\n</ul>\n','https://open-real-estate.info/ru/blog/open-real-estate-1151','2015-12-16 07:49:32','open-real-estate.info',1,'ru'),(65,'Open Real Estate 1.15.0','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		оплата за бронирование ( только при наличии модулей &quot;Календарь бронирования&quot; и &quot;Платные услуги&quot; );</li>\n	<li>\n		новый платный модуль &quot;История изменений&quot;;</li>\n	<li>\n		новый платный модуль &quot;Станции метро&quot;;</li>\n	<li>\n		новый модуль &quot;Материалы&quot;. Теперь можно создавать свои собственные категории: новости, статьи, блог и т.п. Добавлять в категории созданные категории материалы ( новость, статья, запись и т.п );</li>\n	<li>\n		новая база стран, регионов и городов для модуля &quot;Местоположение&quot; от SypexGeo ( https://sypexgeo.net/ru/download/ );</li>\n	<li>\n		вывод местоположения объекта на карте в версии для печати;</li>\n	<li>\n		фреймворк Yii обновлен до последней версии ( 1.1.16 );</li>\n	<li>\n		многочисленные улучшения и исправления ошибок.</li>\n</ul>\n','https://open-real-estate.info/ru/blog/open-real-estate-1150','2015-12-06 11:04:18','open-real-estate.info',1,'ru'),(66,'More features in the BASIC version','<p>Good news!</p>\n<p>We have changed the package of our BASIC version.</p>\n<p>We added the most popular modules \"SEO\", \"Sitemap\", \"The extended form editor\".</p>','https://open-real-estate.info/en/blog/more-features-in-the-basic-version','2016-07-20 04:33:56','open-real-estate.info',1,'en'),(67,'Open Real Estate 1.17.1','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		Improvements and bug fixes.</li>\n</ul>','https://open-real-estate.info/en/blog/open-real-estate-1171','2016-07-10 04:44:50','open-real-estate.info',1,'en'),(68,'Google no longer supports keyless access ','<p>\nRecently there were some changes in the work of Google Maps. Google no longer supports keyless access - <a href=\"http://googlegeodevelopers.blogspot.ru/2016/06/building-for-scale-updates-to-google.html\" target=\"_blank\">http://googlegeodevelopers.blogspot.ru/2016/06/building-for-scale-updates-to-google.html</a>\n</p>\n\n<p>So, it\'s necessary to get API key for correct work of Google Maps - <a href=\"https://developers.google.com/maps/documentation/javascript/get-api-key\" target=\"_blank\">https://developers.google.com/maps/documentation/javascript/get-api-key</a></p> ','https://open-real-estate.info/en/blog/google-no-longer-supports-keyless-access','2016-07-01 07:21:38','open-real-estate.info',1,'en'),(69,'Open Real Estate 1.17.0','<p>We present you new <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate 1.17.0</a></p>\n<p>In a new version you can find improved perfomance, new features and many other useful options.</p>\n<p>What\'s new in version 1.17.0?</p>','https://open-real-estate.info/en/blog/open-real-estate-1170','2016-06-28 13:33:51','open-real-estate.info',1,'en'),(70,'Open Business Card CMS 1.5.0','<p>\n	The new version of CMS&nbsp;<a href=\"https://monoray.net/products/51-open-business-card\" target=\"_blank\">Open Business Card CMS</a>&nbsp;has been released.\n</p>\n<p>\n	<strong>What\'s new</strong>:\n</p>\n<ul>\n	<li>Brute force attack protection during the authorization process (display of captcha after third unsuccessful attempt);</li>\n	<li>Cookies warning;</li>\n	<li>PHPMailer is updated to the latest version (5.2.15);</li>\n	<li>Performance optimization; </li>\n	<li>Numerous improvements and bug fixes.</li>	\n</ul>','https://open-real-estate.info/en/blog/open-business-card-cms-150','2016-05-22 09:29:32','open-real-estate.info',1,'en'),(71,'Больше функций в BASIC-версии','<p>Отличные новости!</p>\n<p>Мы изменили сборку BASIC-версии Open Real Estate.</p>\n<p>В комплектацию добавлены самые популярные модули: \"SEO\", \"Карта сайта\" и \"Расширенный редактор форм\".</p>','https://open-real-estate.info/ru/blog/more-features-in-the-basic-version','2016-07-20 04:33:56','open-real-estate.info',1,'ru'),(72,'Open Real Estate 1.17.1','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		Улучшения и исправления ошибок.</li>\n</ul>','https://open-real-estate.info/ru/blog/open-real-estate-1171','2016-07-10 04:44:50','open-real-estate.info',1,'ru'),(73,'Изменения в картах от Google - необходимо указывать ключ','<p>С недавнего времени в Google картах произошли изменения - http://googlegeodevelopers.blogspot.ru/2016/06/building-for-scale-updates-to-google.html </p>\n\n<p>Для работы карт теперь необходимо получить ключ - https://developers.google.com/maps/documentation/javascript/get-api-key</p> ','https://open-real-estate.info/ru/blog/google-no-longer-supports-keyless-access','2016-07-01 07:21:38','open-real-estate.info',1,'ru'),(74,'Open Real Estate 1.17.0','<p>Представляем вашему вниманию <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate 1.17.0</a>.</p>\n<p>В новой версии улучшено быстродействие, добавлены новые функции и множество различных улучшений.</p><p>Что изменилось?</p>','https://open-real-estate.info/ru/blog/open-real-estate-1170','2016-06-28 13:33:51','open-real-estate.info',1,'ru'),(75,'Open Business Card CMS 1.5.0','<p>\n	Выпущена новая версия <a target=\"_blank\" href=\"https://monoray.ru/products/51-open-business-card\">Open Business Card CMS</a>.\n</p>\n<p>\n	<strong>Что нового</strong>:\n</p>\n<ul>\n	<li>Защита от перебора паролей к учётной записи при авторизации (отображение капчи после третьей неправильно попытки);</li>\n	<li>Предупреждение об использовании Cookie на сайте;</li>\n	<li>PHPMailer обновлён до последней версии (5.2.15);</li>\n	<li>Повышено быстродействие скрипта;</li>\n	<li>Многочисленные улучшения и исправления ошибок.</li>	\n</ul>','https://open-real-estate.info/ru/blog/open-business-card-cms-150','2016-05-22 09:29:32','open-real-estate.info',1,'ru'),(76,'Open Real Estate 1.17.2','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		bug fixes.</li>\n</ul>\n','https://open-real-estate.info/en/blog/open-real-estate-1172','2016-08-02 17:05:56','open-real-estate.info',1,'en'),(77,'Open Real Estate 1.17.2','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		исправления ошибок.</li>\n</ul>','https://open-real-estate.info/ru/blog/open-real-estate-1172','2016-08-02 17:05:56','open-real-estate.info',1,'ru'),(78,'Open Real Estate 1.18.0','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n                <li>RTL support (example: arabic, hebrew) in <a href=\"https://open-real-estate.info/en/open-real-estate-modules#atlas\" target=\"_blank\">\"Atlas\" theme</a> (<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">is only for paid BASIC / PRO / Ultimate versions</a> );</li>\n                <li>other minor improvements.</li>\n            </ul>','https://open-real-estate.info/en/blog/open-real-estate-1180','2016-09-18 05:27:07','open-real-estate.info',1,'en'),(79,'Open Real Estate 1.17.3','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		bug fixes.</li>\n</ul>','https://open-real-estate.info/en/blog/open-real-estate-1173','2016-09-12 04:14:32','open-real-estate.info',1,'en'),(80,'Templates for ready-to-go real estate CMS Open Real Estate','<p><strong>150+ design themes for you to choose from.</strong></p>\n<p>Select a new design for your real estate site and give it a completely new look and feel.</p>\n<p>Any template can be integrated to your website.</p>','https://open-real-estate.info/en/blog/templates-for-ready-to-go-real-estate-cms-open-real-estate','2016-08-20 05:01:29','open-real-estate.info',1,'en'),(81,'Open Real Estate 1.18.0','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n                <li>Поддержка RTL (например: арабский язык, иврит) в <a href=\"https://open-real-estate.info/ru/open-real-estate-modules#atlas\" target=\"_blank\">теме Atlas</a> (<a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">включено только для платных BASIC / PRO / Ultimate версий</a> );</li>\n                <li>небольшие улучшения.</li>\n            </ul>','https://open-real-estate.info/ru/blog/open-real-estate-1180','2016-09-18 05:27:07','open-real-estate.info',1,'ru'),(82,'Open Real Estate 1.17.3','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		исправления ошибок.</li>\n</ul>','https://open-real-estate.info/ru/blog/open-real-estate-1173','2016-09-12 04:14:32','open-real-estate.info',1,'ru'),(83,'Шаблоны для скрипта недвижимости Open Real Estate CMS','<p><strong>Более 150 шаблонов на ваш выбор.</strong></p>\n<p>Выберите новый дизайн для вашего сайта и придайте ему совершенно новый вид.</p>\n<p>Любой шаблон может быть интегрирован на ваш сайт.</p>','https://open-real-estate.info/ru/blog/templates-for-ready-to-go-real-estate-cms-open-real-estate','2016-08-20 05:01:29','open-real-estate.info',1,'ru'),(84,'Open Real Estate CMS 1.18.1','	<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.\n</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n		<li>updated  CKEditor;</li>\n		<li>optimization of  Yandex Realty module;</li>\n		<li>bugfix.</li>\n	</ul>','https://open-real-estate.info/en/blog/open-real-estate-1181','2016-09-29 13:31:58','open-real-estate.info',1,'en'),(85,'Open Real Estate CMS 1.18.1','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n		<li>обновлённый CKEditor;</li>\n		<li>оптимизация модуля Яндекс Недвижимость;</li>\n		<li>другие исправления.</li>\n	</ul>','https://open-real-estate.info/ru/blog/open-real-estate-1181','2016-09-29 13:31:58','open-real-estate.info',1,'ru'),(86,'Open Real Estate CMS 1.19.0: new administration panel theme and file manager','<p>Finally you have an opportunity to test a new version of Open Real Estate CMS – script that lets you create real estate websites, web portals and listings boards.</p>','https://open-real-estate.info/en/blog/news/open-real-estate-1190','2016-11-22 23:58:05','open-real-estate.info',1,'en'),(87,'Open Real Estate CMS 1.19.0: новая тема оформления панели администратора и файловый менеджер','<p>Встречайте обновление Open Real Estate CMS – скрипта для создания сайтов недвижимости, порталов и досок объявлений.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-1190','2016-11-22 20:58:05','open-real-estate.info',1,'ru'),(88,'Open Real Estate settings after the installation','<p>So you have <a href=\"https://open-real-estate.info/en/installation-guide\" target=\"_blank\">installed</a> our <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">real estate script</a>.</p>\n<p>What should you do at first? Add listings at once? Or create users? Or maybe you should  add some additional fields for listings in the <a href=\"https://open-real-estate.info/en/module-extended-form-editor\" target=\"_blank\">\"Extended form editor\"</a>?</p>\n<p>Don\'t jump the gun.</p>','https://open-real-estate.info/en/blog/articles/open-real-estate-settings-after-the-installation','2016-12-02 11:09:02','open-real-estate.info',1,'en'),(89,'Google News: Google to release separate mobile search index','<p>Recently in one of the largest conferences on digital marketing Pubcon 2016 a webmaster trends analyst with Google Gary Illyes has declared surprising news: in several months the organization is launching a separate search results for mobile users.</p>','https://open-real-estate.info/en/blog/news/google-release-separate-mobile-search-index','2016-11-29 05:18:27','open-real-estate.info',1,'en'),(90,'Настройка Open Real Estate после установки','<p>Итак, вы <a href=\"https://open-real-estate.info/ru/installation-guide\" target=\"_blank\">установили</a> наш <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">скрипт недвижимости</a>.</p>\n<p>Что же сделать в первую очередь? Сразу добавлять объявления? Или пользователей? А может создать дополнительные поля для объявлений с помощью модуля <a href=\"https://open-real-estate.info/ru/module-extended-form-editor\" target=\"_blank\">\"Расширенный редактор форм\"</a>?</p>\n<p>Не спешите.</p>','https://open-real-estate.info/ru/blog/articles/open-real-estate-settings-after-the-installation','2016-12-02 05:09:02','open-real-estate.info',1,'ru'),(91,'Новости от Google: ожидается запуск отдельной поисковой выдачи для мобильных устройств','<p>Недавно на одной из крупнейших конференций по digital-маркетингу Pubcon 2016 специалист отдела качества поиска Google Гэри Илш (Gary Illyes) огласил неожиданные новости – через несколько месяцев корпорация запускает отдельную поисковую выдачу для пользователей мобильных устройств.</p>','https://open-real-estate.info/ru/blog/news/google-release-separate-mobile-search-index','2016-11-28 23:18:27','open-real-estate.info',1,'ru'),(92,'Advantages of Open Real Estate. Part 1. Estate agent\'s website','<p>CMS Open Real Estate is a multi functional ready-to-use solution for creation real estate websites. Our system lets you create different types of websites according to the tasks and services of a project.</p>','https://open-real-estate.info/en/blog/articles/advantages-of-open-real-estate-part1-estate-agents-website','2016-12-06 11:41:08','open-real-estate.info',1,'en'),(93,'Возможности Open Real Estate. Часть 1. Сайт частного риелтора','<p>CMS Open Real Estate – это многофункциональное готовое решение для создания сайтов в сфере недвижимости. Движок позволяет создавать разные типы сайтов, в зависимости от задач проекта и предлагаемых услуг.</p>','https://open-real-estate.info/ru/blog/articles/advantages-of-open-real-estate-part1-estate-agents-website','2016-12-06 11:41:08','open-real-estate.info',1,'ru'),(94,'10 content ideas for a real estate agency','<p>The main thing on a website is content, as eventually a user visit any internet resource seeking for information (maybe except gaming). It can be just data about an organisation, for example, contact details, or product overview.</p>','https://open-real-estate.info/en/blog/articles/10-content-ideas-for-real-estate-agency','2016-12-14 13:46:07','open-real-estate.info',1,'en'),(95,'Open Real Estate CMS 1.19.1: practice makes perfect','<p>All the updaes of  Open Real Estate 1.19.1 are conneсted with usability improvements.</p>','https://open-real-estate.info/en/blog/news/open-real-estate-1191','2016-12-14 06:24:03','open-real-estate.info',1,'en'),(96,'New Year Sales 2017: create your real estate website with 17% discount','<p>Incredible offer which we have never made before! Only till the 30th of December MonoRay Studio gives you 17% off on ALL our products!</p>','https://open-real-estate.info/en/blog/news/new-year-sales-2017','2016-12-12 01:15:23','open-real-estate.info',1,'en'),(97,'10 идей контента для агентства недвижимости','<p>Самое главное на сайте – это контент, так как в конечном счете пользователь заходит практически на любой интернет-ресурс (за исключением, пожалуй, игровых) именно за информацией. Это могут быть элементарные данные фирмы, например, контакты, или сведения о продуктах компании.</p>','https://open-real-estate.info/ru/blog/articles/10-content-ideas-for-real-estate-agency','2016-12-14 13:46:07','open-real-estate.info',1,'ru'),(98,'Open Real Estate CMS 1.19.1: совершенствуем управление сайтом','<p>Все нововведения версии Open Real Estate 1.19.1 посвящены улучшению юзабилити.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-1191','2016-12-14 06:24:03','open-real-estate.info',1,'ru'),(99,'Новогодняя распродажа 2017: создайте сайт недвижимости со скидкой 17%','<p>Таких скидок у нас еще не было! В честь нового 2017 года студия MonoRay дарит скидку 17% абсолютно на ВСЕ наши продукты</p>','https://open-real-estate.info/ru/blog/news/new-year-sales-2017','2016-12-12 01:15:23','open-real-estate.info',1,'ru'),(100,'Open Real Estate CMS 5 year anniversary! A few words about us and 5 year summary','<p>Dear friend, we are happy to inform us that our real estate website management system Open Real Estate and our web-studio MonoRay celebrate their 5 year anniversary! In this article we would like to provide you with our 5 year summary and tell you about the results we achieved.</p>','https://open-real-estate.info/en/blog/news/our-real-estate-script-celebrates-its-5-year-anniversary','2016-12-29 05:12:00','open-real-estate.info',1,'en'),(101,'Responsive site, mobile version or application: what fits your project better?','<p>Yandex research <a href=\"https://yandex.ru/company/researches/2015/ya_internet_regions_2015#ispolzovanieinternetasmobilnyxustrojjstvsmartfonoviplanshetov\" rel=\"nofollow\" target=\"_blank\">shows</a>, that the number of people who use tablets and smartphones to surf the web is increasing. A good website, first of all, takes into account the users’ needs. If you take care of you customers, content supply should be as convenient as possible. So you cannot do without content adjustment for mobile devices.</p>','https://open-real-estate.info/en/blog/articles/responsive-site-mobile-version-or-application-what-fits-your-project-better','2016-12-21 09:43:48','open-real-estate.info',1,'en'),(102,'Open Real Estate CMS 5 лет! Немного истории и подведение итогов','<p>Друзья, мы рады вам сообщить, что системе управления сайтом недвижимости Open Real Estate и нашей веб-студии Monoray исполнилось 5 лет! В этой статье мы хотим подвести итоги работы и поделиться результатами.</p>','https://open-real-estate.info/ru/blog/news/our-real-estate-script-celebrates-its-5-year-anniversary','2016-12-29 02:12:00','open-real-estate.info',1,'ru'),(103,'Адаптивный сайт, мобильная версия или приложение – какой вариант подходит вашему проекту?','<p>Исследования Яндекса <a href=\"https://yandex.ru/company/researches/2015/ya_internet_regions_2015#ispolzovanieinternetasmobilnyxustrojjstvsmartfonoviplanshetov\" rel=\"nofollow\" target=\"_blank\">показывают</a> что людей, которые пользуются смартфонами и планшетами для серфинга по сети, становится все больше. Хороший сайт в первую очередь учитывает предпочтения пользователей. Если вы заботитесь о своих клиентах, подача контента должна быть максимально удобной. А значит, вам не обойтись без адаптации содержимого сайта под мобильные устройства.</p>','https://open-real-estate.info/ru/blog/articles/responsive-site-mobile-version-or-application-what-fits-your-project-better','2016-12-21 06:43:48','open-real-estate.info',1,'ru'),(104,'A real estate website: template or unique solution?','<p>\n	The discussions about the best design solution for a real estate website has been led for a long time and the issue hasn’t been solved yet. What is better: a ready-to-use template or a unique design is a big debate.\n	<br />\n	We recommend you to make a choice according to the tasks your website should solve.\n</p>','https://open-real-estate.info/en/blog/articles/real-estate-website-template-or-unique-solution','2017-01-13 09:04:44','open-real-estate.info',1,'en'),(105,'Open Real Estate CMS 1.19.2: security fix','<p>\n	The new version of CMS <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a> has been released.\n</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		PHPMailer security fix (The critical vulnerability (CVE-2016-10033) allows an attacker to remotely execute arbitrary code in the context of the web server and compromise the target web application) <br />\n	</li>\n</ul>','https://open-real-estate.info/en/blog/news/open-real-estate-1192-security-fix','2017-01-09 11:37:41','open-real-estate.info',1,'en'),(106,'Дизайн сайта недвижимости: шаблон или уникальность?','<p>\n	Дискуссии о том, какое решение использовать в дизайне сайта недвижимости – готовое шаблонное или уникальный макет, не прекращаются.\n	<br />\n	Мы рекомендуем вам делать выбор в зависимости от задач, которые должен решать сайт.\n</p>','https://open-real-estate.info/ru/blog/articles/real-estate-website-template-or-unique-solution','2017-01-13 09:04:44','open-real-estate.info',1,'ru'),(107,'Open Real Estate CMS 1.19.2: исправление безопасности','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a></p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n<li>\n		Исправление безопасности PHPMailer (Уязвимость позволяет удаленно выполнить код в контексте web-сервера и скомпрометировать web-приложение) <br />\n	</li>\n</ul>','https://open-real-estate.info/ru/blog/news/open-real-estate-1192-security-fix','2017-01-09 08:37:41','open-real-estate.info',1,'ru'),(108,'Main channels of a real estate website promotion','<p>In conditions of severe competition between real estate agencies it’s important to use as much channels for attracting clients in a site as possible. Let’s consider the most popular ones.</p>','https://open-real-estate.info/en/blog/articles/main-channels-of-a-real-estate-website-promotion','2017-03-11 05:39:57','open-real-estate.info',1,'en'),(109,'Why does a real estate agency need a website?','<p>When you create a real estate website or some other sites, first of all, you should take into account the aims which you want to achieve when you launch the project.  Not long ago not every agency needed its own resource, however, in the modern world if you don\'t have a website you loose a great deal of financially reliable customers.</p>','https://open-real-estate.info/en/blog/articles/why-does-real-estate-agency-need-website','2017-02-22 11:12:22','open-real-estate.info',1,'en'),(110,'Tips: how to improve objects search form in a real estate website','<p>One way or another, the main objective of a user in a real estate portal is to find a property to sell or rent, so the base of object exists in the most of real estate agency websites. To simplify the search for potential clients it\'s important to make this process convenient.</p>','https://open-real-estate.info/en/blog/articles/how-improve-objects-search-form-in-real-estate-website','2017-02-15 05:08:18','open-real-estate.info',1,'en'),(111,'Basic recommendation for a website promotion','<p>The work on the website is not only its creation. If you want to get income from a corporate portal you should constantly attract customers.</p>','https://open-real-estate.info/en/blog/articles/basic-recommendation-website-promotion','2017-02-08 05:20:45','open-real-estate.info',1,'en'),(112,'An unusual way of Open Real Estate script usage','<p>In this article you will find out how to create a ready to use site for selling wines from a real estate site based on Open Real Estate CMS.</p>\n<p>You can also try to make your own site on selling cars, yachts, mobiles etc in the similar way.</p>','https://open-real-estate.info/en/blog/articles/unusual-way-open-real-estate-script-usage','2017-02-02 20:43:59','open-real-estate.info',1,'en'),(113,'Open Real Estate 1.19.3','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>\n	<strong>What&#39;s new</strong>:</p>\n<ul>\n	<li>\n		bug fixes.</li>\n</ul>','https://open-real-estate.info/en/blog/news/open-real-estate-1193','2017-01-24 08:58:13','open-real-estate.info',1,'en'),(114,'Основные каналы продвижения сайта недвижимости','<p>В условиях довольно жесткой конкуренции между агентствами недвижимости важно использовать максимум каналов для привлечения аудитории на сайт. Рассмотрим подробнее самые популярные из них</p>','https://open-real-estate.info/ru/blog/articles/main-channels-of-a-real-estate-website-promotion','2017-03-11 05:39:57','open-real-estate.info',1,'ru'),(115,'Зачем сайт агентству недвижимости?','<p>При создании сайта недвижимости, как и любого другого, прежде всего, стоит руководствоваться теми целями, которых вы хотите достичь, запуская проект. Еще недавно далеко не каждое агентство испытывало необходимость в создании собственного ресурса, однако современные реалии таковы, что отсутствие сайта – это потеря огромной части активной платежеспособной аудитории.</p>','https://open-real-estate.info/ru/blog/articles/why-does-real-estate-agency-need-website','2017-02-22 11:12:22','open-real-estate.info',1,'ru'),(116,'Советы: реализация формы поиска объектов на сайте недвижимости','<p>Как ни крути, зачастую основная цель посетителя портала недвижимости – найти жилье для продажи или аренды, поэтому база объектов присутствует на сайтах большинства агентств. Чтобы потенциальные клиенты легко могли подобрать для себя подходящий вариант из каталога, важно организовать удобный поиск по сайту.</p>','https://open-real-estate.info/ru/blog/articles/how-improve-objects-search-form-in-real-estate-website','2017-02-15 05:08:18','open-real-estate.info',1,'ru'),(117,'Базовые рекомендации для продвижения сайта','<p>Работа над сайтом не заканчивается его созданием. Чтобы корпоративный ресурс приносил доход, необходимо активно заниматься привлечением трафика.</p>','https://open-real-estate.info/ru/blog/articles/basic-recommendation-website-promotion','2017-02-08 05:20:45','open-real-estate.info',1,'ru'),(118,'Необычный способ применения скрипта агентства недвижимости Open Real Estate','<p>Из этой статьи вы узнаете как из готового сайта недвижимости, на основе Open Real Estate CMS, сделать готовый сайт по продаже вина.</p>\n<p>По аналогии можно попробовать реализовать сайт по продаже автомобилей, яхт, телефонов и т.п.</p>','https://open-real-estate.info/ru/blog/articles/unusual-way-open-real-estate-script-usage','2017-02-02 20:43:59','open-real-estate.info',1,'ru'),(119,'Open Real Estate 1.19.3','<p>\n	Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>\n	<strong>Что нового</strong>:</p>\n<ul>\n	<li>\n		исправление ошибок.</li>\n</ul>','https://open-real-estate.info/ru/blog/news/open-real-estate-1193','2017-01-24 08:58:13','open-real-estate.info',1,'ru'),(120,'Baden-Baden: New Yandex algorithm of identifying text spam','<p><strong>The article will be interesting for people who are promoting their resource in Russia.</strong></p>\n\n<p>On the 23rd of March 2017 Yandex has announced the introduction of a new algorithm on identifying pages with the excessive use of key words. New algorithm is called Baden-Baden.</p>','https://open-real-estate.info/en/blog/news/baden-baden-algorithm-from-yandex','2017-04-14 07:35:09','open-real-estate.info',1,'en'),(121,'Instagram for real estate agencies: useful tips','<p>Instagram is becoming more popular year by year. It is used by celebrities, businessmen and a lot of successful people, a lot of users are stuck there for 24 hours a day. Taking into account this trend there are several advice on how to create and what to add in your real estate account in Instagram.</p>','https://open-real-estate.info/en/blog/articles/instagram-for-real-estate-agencies','2017-03-26 04:28:55','open-real-estate.info',1,'en'),(122,'An unusual way of Open Real Estate script usage','<p>In this article you will find out how to create a ready to use site for selling wines from a real estate site based on Open Real Estate CMS.</p>\n<p>You can also try to make your own site on selling cars, yachts, mobiles etc in the similar way.</p>','https://open-real-estate.info/en/blog/instructions/unusual-way-open-real-estate-script-usage','2017-02-02 20:43:59','open-real-estate.info',1,'en'),(123,'Open Real Estate settings after the installation','<p>So you have <a href=\"https://open-real-estate.info/en/installation-guide\" target=\"_blank\">installed</a> our <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">real estate script</a>.</p>\n<p>What should you do at first? Add listings at once? Or create users? Or maybe you should  add some additional fields for listings in the <a href=\"https://open-real-estate.info/en/module-extended-form-editor\" target=\"_blank\">\"Extended form editor\"</a>?</p>\n<p>Don\'t jump the gun.</p>','https://open-real-estate.info/en/blog/instructions/open-real-estate-settings-after-the-installation','2016-12-02 08:09:02','open-real-estate.info',1,'en'),(124,'Баден-Баден: новый алгоритм определения текстового спама Яндекса','<p>23 марта 2017 года Яндекс анонсировал введение нового алгоритма по определению страниц с переизбытком ключевых слов. Новый алгоритм называется Баден-Баден.<p>','https://open-real-estate.info/ru/blog/news/baden-baden-algorithm-from-yandex','2017-04-14 07:35:09','open-real-estate.info',1,'ru'),(125,'Instagram для агентства недвижимости: полезные советы','<p>Instagram набирает популярность с каждым годом. Им активно пользуются знаменитости, успешные бизнесмены, многие пользователи «не вылезают» оттуда круглые сутки. С учетом этой тенденции вот несколько советов о том, как оформить и вести аккаунт агентства недвижимости в Instagram.</p>','https://open-real-estate.info/ru/blog/articles/instagram-for-real-estate-agencies','2017-03-26 04:28:55','open-real-estate.info',1,'ru'),(126,'Необычный способ применения скрипта агентства недвижимости Open Real Estate','<p>Из этой статьи вы узнаете как из готового сайта недвижимости, на основе Open Real Estate CMS, сделать готовый сайт по продаже вина.</p>\n<p>По аналогии можно попробовать реализовать сайт по продаже автомобилей, яхт, телефонов и т.п.</p>','https://open-real-estate.info/ru/blog/instructions/unusual-way-open-real-estate-script-usage','2017-02-02 20:43:59','open-real-estate.info',1,'ru'),(127,'Настройка Open Real Estate после установки','<p>Итак, вы <a href=\"https://open-real-estate.info/ru/installation-guide\" target=\"_blank\">установили</a> наш <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">скрипт недвижимости</a>.</p>\n<p>Что же сделать в первую очередь? Сразу добавлять объявления? Или пользователей? А может создать дополнительные поля для объявлений с помощью модуля <a href=\"https://open-real-estate.info/ru/module-extended-form-editor\" target=\"_blank\">\"Расширенный редактор форм\"</a>?</p>\n<p>Не спешите.</p>','https://open-real-estate.info/ru/blog/instructions/open-real-estate-settings-after-the-installation','2016-12-02 08:09:02','open-real-estate.info',1,'ru'),(128,'How to keep a client on your real estate website if object search did not give any positive results','<p>If a client doesn\'t find in your agency database a property that has all the necessary parameters, they usually get to the page “No listings yet”, “The objects haven’t been found” or “The are no search results for…” In this article we will tell you the ways of keeping a user in a site, even if at the moment there are no objects they want..</p>','https://open-real-estate.info/en/blog/articles/how-to-keep-a-client','2017-04-25 00:17:33','open-real-estate.info',1,'en'),(129,'Как задержать клиента на сайте недвижимости, если поиск по объектам не дал результатов','<p>Если клиент не находит в базе вашего агентства недвижимости по нужным ему параметрам, он обычно попадает на страницу «Объектов не найдено», «Список объявлений пуст» или «Поиск не дал результатов». В этой статье мы рассмотрим несколько способов задержать посетителя на сайте, даже если нужного объекта на данный момент нет в базе агентства.</p>','https://open-real-estate.info/ru/blog/articles/how-to-keep-a-client','2017-04-24 21:17:33','open-real-estate.info',1,'ru'),(130,'Ways of monetization of a real estate website','','https://open-real-estate.info/en/blog/articles/ways-of-monetization','2017-05-21 05:50:40','open-real-estate.info',1,'en'),(131,'Open Real Estate Update 1.20.0','<p>A new version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a> was released.</p><p>Learn more about new functions following the link:</p>','https://open-real-estate.info/en/blog/news/open-real-estate-1200','2017-05-15 04:15:51','open-real-estate.info',1,'en'),(132,'Are landing pages useful in a real estate field?','<p>Real estate is a highly competitive field, that is why it is very important to use all the possible ways for promotion and advertisement to increase sales. No doubt, one of the ways for attracting clients is creating landing pages for different industry specific requests.</p>','https://open-real-estate.info/en/blog/articles/landing-pages-in-a-real-estate-field','2017-05-04 07:19:10','open-real-estate.info',1,'en'),(133,'Способы монетизации сайта недвижимости','<p>Конечная цель любого ресурса – прямые продажи или, что касается имиджевых сайтов и промо-страниц, влияние на их увеличение. Сайт, созданный с ориентацией на потребности и интересы пользователя, может приносить хороший доход. Однако для достижения долгосрочных результатов требуется время и усилия на раскрутку. Рассмотрим несколько способов монетизации портала недвижимости.</p>','https://open-real-estate.info/ru/blog/articles/ways-of-monetization','2017-05-21 05:50:40','open-real-estate.info',1,'ru'),(134,'Обновление Open Real Estate 1.20.0','<p>Выпущена новая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p><p>Узнайте о нововведениях по ссылке:</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-1200','2017-05-15 04:15:51','open-real-estate.info',1,'ru'),(135,'Полезны ли landing page в сфере недвижимости?','<p>Недвижимость – это высококонкурентная тематика, поэтому для увеличения продаж очень важно испробовать все возможные способы продвижения и рекламы. Безусловно, одним из способов привлечения клиентов является создание лендингов под различные тематические запросы.</p>','https://open-real-estate.info/ru/blog/articles/landing-pages-in-a-real-estate-field','2017-05-04 07:19:10','open-real-estate.info',1,'ru'),(136,'How building owners attract customers: a range of residential complex sites','<p>Let\'s get straight to the point without many words. In our today\'s article there are site samples with interesting details which can be taken home for your own project. Yes, get an idea and adjust it to the needs of your own project, not copy it. Let\'s start!</p>','https://open-real-estate.info/en/blog/articles/how-building-owners-attract-customers-a-range-of-residential-complex-sites','2017-08-29 00:29:57','open-real-estate.info',1,'en'),(137,'Building owner’s website','<p>Flat choice depends on a building owner and making a solution about purchase takes long time, which sometimes lasts up to 6 month. A lot of factors have an impact on a buyer’s opinion.</p>','https://open-real-estate.info/en/blog/articles/building-owners-website','2017-08-21 00:36:28','open-real-estate.info',1,'en'),(138,'The main principles of efficient homepage','<p>Potential customers often start getting acquainted with your business in your homepage. Just imagine, a user estimates the site in 1/20th of a second!</p>','https://open-real-estate.info/en/blog/articles/main-principles-of-efficient-homepage','2017-08-11 23:58:24','open-real-estate.info',1,'en'),(139,'Advantages of Open Real Estate. Part 2. Estate agency website','<p>In the series of articles about Open Real Estate advantages we’re describing the advantages of particular features of our software. This time we are going to tell you about the set of functions which will be useful for an agency website.</p>','https://open-real-estate.info/en/blog/articles/advantages-of-open-real-estate-part2-estate-agency-website','2017-08-03 06:25:46','open-real-estate.info',1,'en'),(140,'Create a Real Estate website with discounts up to 30%!','<p>We announce summer bargain week! Discount on all versions on Open Real Estate CMS only for 5 days!</p>','https://open-real-estate.info/en/blog/news/discounts-up-to-30','2017-07-25 02:40:07','open-real-estate.info',1,'en'),(141,'How to create a proper real estate listing','<p>Real estate listing is one of the most important elements in a real estate website. It includes a detailed description of the object, its peculiarities and characteristics. Let\'s see what elements and characteristics must be in a listing to provide a client detailed information about the property they would like to rent or purchase.</p>','https://open-real-estate.info/en/blog/articles/how-to-create-proper-real-estate-listing','2017-07-05 01:58:29','open-real-estate.info',1,'en'),(142,'Tips on preparing objects for a photoshoot','<p>Listings about buying, selling and renting real estate are much more efficient when there are attached photos of objects. According to statistics listings with photos are seen 60% more often, so an agency is more likely to find a potential buyer. However, photos must be high quality, otherwise you may have counterproductive results.</p>','https://open-real-estate.info/en/blog/articles/tips-on-preparing-objects','2017-06-23 02:13:17','open-real-estate.info',1,'en'),(143,'20 selling features for a real estate website','<p>There are a lot of tools of the trade you will use to increase the sales! Check, if you don’t use one of the ways described here – it high time to start using it as well. Test different solutions and make changes, implement something new and increase sales.</p>','https://open-real-estate.info/en/blog/articles/20-selling-features','2017-06-14 06:37:41','open-real-estate.info',1,'en'),(144,'Google news: warning about an increase in spammy links','<p>A search engine reminds that links purchase doesn’t longer work and makes a detrimental impact on the positions of your resource in search results.</p>','https://open-real-estate.info/en/blog/news/warning-about-spammy-inks','2017-06-07 02:04:13','open-real-estate.info',1,'en'),(145,'Open Real Estate 1.20.1','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-1201','2017-06-03 08:59:08','open-real-estate.info',1,'en'),(146,'Как застройщики привлекают клиентов: подборка сайтов жилых комплексов','<p>Без лишних слов – к делу. В сегодняшней статье – примеры сайтов с интересными деталями, которые можно взять на вооружение для собственного проекта. Да, взять на вооружение и адаптировать под свой проект – а не делать под копирку. Погнали!</p>','https://open-real-estate.info/ru/blog/articles/how-building-owners-attract-customers-a-range-of-residential-complex-sites','2017-08-29 00:29:57','open-real-estate.info',1,'ru'),(147,'Позиционирование сайта застройщика','<p>Выбор квартиры от застройщика и принятие решения о покупке занимает долгий срок, который иногда затягивается до 6 месяцев. На мнение покупателя влияет множество факторов, он пытается оценить свои риски, качество строительства, степень доверия к застройщику.</p>','https://open-real-estate.info/ru/blog/articles/building-owners-website','2017-08-21 00:36:28','open-real-estate.info',1,'ru'),(148,'Принципы эффективной главной страницы','<p>Потенциальные клиенты часто начинают знакомство с вашим бизнесом с главной страницы сайта. Только представьте – посетитель оценивает сайт и формирует о нем первое впечатление за 1/20 секунды!</p>','https://open-real-estate.info/ru/blog/articles/main-principles-of-efficient-homepage','2017-08-11 23:58:24','open-real-estate.info',1,'ru'),(149,'Возможности Open Real Estate. Часть 2. Сайт агентства недвижимости','<p>В серии материалов о возможностях Open Real Estate мы рассказываем об использовании определенного функционала нашего продукта в зависимости от целей и задач ресурса. На этот раз речь пойдет о популярном наборе опций, которые будут востребованы для сайта агентства.</p>','https://open-real-estate.info/ru/blog/articles/advantages-of-open-real-estate-part2-estate-agency-website','2017-08-03 06:25:46','open-real-estate.info',1,'ru'),(150,'Сайт недвижимости на Open Real Estate со скидкой до 30%! ','<p>Открываем неделю жарких летних скидок! Специальная цена на все версии Open Real Estate только в течение 5 дней!</p>','https://open-real-estate.info/ru/blog/news/discounts-up-to-30','2017-07-25 02:40:07','open-real-estate.info',1,'ru'),(151,'Создаем грамотную карточку объекта недвижимости','<p>Карточка объекта – один из самых важных элементов на сайте агентства недвижимости. Она содержит детальное описание объекта, его особенности и характеристики. Рассмотрим, какие элементы и характеристики должны быть в карточке, чтобы пользователь мог получить полную информацию об интересующем его жилье, которое он собирается снять или приобрести.</p>','https://open-real-estate.info/ru/blog/articles/how-to-create-proper-real-estate-listing','2017-07-05 01:58:29','open-real-estate.info',1,'ru'),(152,'Советы по подготовке фотографий для объектов недвижимости','<p>Объявления о купле-продаже или аренде недвижимости гораздо эффективнее, когда дополняются фотографиями объектов. По статистике, объявления с фото просматриваются на 60% чаще, соответственно, у агентства гораздо больше шансов найти своего покупателя. Однако снимки обязательно должны быть качественными, в ином случае вы рискуете получить противоположный результат.</p>','https://open-real-estate.info/ru/blog/articles/tips-on-preparing-objects','2017-06-23 02:13:17','open-real-estate.info',1,'ru'),(153,'20 продающих «фишек» для сайта недвижимости','<p>Каких только инструментов не испробуешь, чтобы увеличить продажи! Проверьте, если какого-то из описанных нами способов на вашем сайте еще нет – действуйте. Тестируйте различные решения и вносите изменения, внедряйте новое и повышайте продажи.</p>','https://open-real-estate.info/ru/blog/articles/20-selling-features','2017-06-14 06:37:41','open-real-estate.info',1,'ru'),(154,'Новости от Google: предупреждение о росте числа спамных ссылок','<p>Очередное напоминание от поисковых систем о том, что закупка ссылок больше не работает и негативно влияет на позиции вашего ресурса.</p>','https://open-real-estate.info/ru/blog/news/warning-about-spammy-inks','2017-06-07 02:04:13','open-real-estate.info',1,'ru'),(155,'Open Real Estate 1.20.1','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-1201','2017-06-03 05:59:08','open-real-estate.info',1,'ru'),(156,'Open Real Estate 1.21.0','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-1210','2017-09-05 06:38:28','open-real-estate.info',1,'en'),(157,'10 ways of finding a client on the Internet for a realtor','<p>E-trading platforms are changing standard are gradually changing standard ways of searching for customers in real estate field. Nowadays calls, advertisement in traditional mass media are going out of date and give way to new Internet opportunities.</p>','https://open-real-estate.info/en/blog/articles/10-ways-of-finding-a-client-on-the-internet-for-a-realtor','2017-09-05 06:00:15','open-real-estate.info',1,'en'),(158,'Open Real Estate 1.21.0','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-1210','2017-09-05 06:38:28','open-real-estate.info',1,'ru'),(159,'10 способов риелтору найти клиентов в интернете','<p>Электронные площадки постепенно приходят на смену стандартным способам поиска клиентов в сфере недвижимости. Обзвон, реклама в традиционных СМИ постепенно отходят на второй план и уступают место возможностям интернета.</p>','https://open-real-estate.info/ru/blog/articles/10-ways-of-finding-a-client-on-the-internet-for-a-realtor','2017-09-05 06:00:15','open-real-estate.info',1,'ru'),(160,'13 video formats for a realtor’s or agency’s Youtube channel','<p>We have already mentioned earlier that your own youtube channel will make you different from your rivals. Everybody makes photos of the objects, however, videos are shot not in every agency. That’s why it is insensible to lose such an opportunity to attract the audience’s attention, which according to the specialists’ predictions will become one of the most popular in 2018. We suggest using some video content formats which can be created for your own Youtube channel.</p>','https://open-real-estate.info/en/blog/articles/13-video-formats-for-a-realtor','2018-02-14 06:32:09','open-real-estate.info',1,'en'),(161,'Open Real Estate prices decrease! Open Real Estate PRO only for 0,029 BTC*!','<p>Cryptocurrecny drops, while our discounts are growing up!</p>','https://open-real-estate.info/en/blog/news/open-real-estate-prices-decrease','2018-01-19 08:59:39','open-real-estate.info',1,'en'),(162,'How to optimize the real estate website for search systems','<p>Real estate is highly competitive industry, that’s why to promote your business  online you need to use as many channels as possible, including organic results. In this article we will tell you about the peculiarities of site optimization and how to compete with popular aggregators.</p>','https://open-real-estate.info/en/blog/articles/how-to-optimize-real-estate-website','2018-01-11 06:17:11','open-real-estate.info',1,'en'),(163,'The team of developers of Open Real Estate congratulates you with Happy New year!','<p style=\"color: #ff0000;\"><strong>Dear friends!</strong></p><p>Only 3 days left until the New year, we are glad to join New Year greetings!</p>\n<p>We wish you success in all your beginnings, breakthroughs and new heights in business, love, health, balance and happiness!\nWe wish your projects development, increase of traffic, high conversions and more sales.</p>','https://open-real-estate.info/en/blog/news/happy-new-year-2018','2017-12-28 09:21:28','open-real-estate.info',1,'en'),(164,'New Year Sale 2018: ready CMS for real estate website with 18% discount','<p>MonoRay Studio wishes you Merry Christmas and a Happy new year and gives presents to everybody. Hurry up to purchase our software with an unbelievable 18% discount only from the 12th to the 27th of December 2017!</p>\n<table><tr><td class=\"ore-column-buttons\"><a class=\"download download-buy-offline\" href=\"https://open-real-estate.info/en/contact-us\" target=\"_blank\">Order</a></td><td class=\"ore-column-buttons\"><a class=\"download download-buy-online\" href=\"https://open-real-estate.info/en/buy-2\"  target=\"_blank\">Buy online</a></td></tr></table>','https://open-real-estate.info/en/blog/news/new-year-sale-2018','2017-12-12 07:54:29','open-real-estate.info',1,'en'),(165,'Open Real Estate 1.22.2','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1222','2017-11-21 10:24:27','open-real-estate.info',1,'en'),(166,'Open Real Estate 1.22.1','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1221','2017-11-03 09:55:45','open-real-estate.info',1,'en'),(167,'10 most important elements for a real estate website','<p>We will tell you about 10 essential elements which should be present in every modern real estate website.</p>','https://open-real-estate.info/en/blog/articles/10-elements-for-real-estate-website','2017-10-31 05:39:44','open-real-estate.info',1,'en'),(168,'How to promote landing pages','<p>Landing page is a target page, its main task is to inspire a user to complete a particular step: buy, subscribe, fill in an application form. Usually such pages are created to attract advertising traffic, when you promote a particular product or a service.</p>','https://open-real-estate.info/en/blog/articles/how-to-promote-landing-pages','2017-10-25 10:32:21','open-real-estate.info',1,'en'),(169,'Open Real Estate 1.22.0','<p>A new version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a> was released.</p>','https://open-real-estate.info/en/blog/news/open-real-estate-1220','2017-10-24 04:50:38','open-real-estate.info',1,'en'),(170,'How to sell property with video','<p>Video content has become a popular way for business promotion long ago, that’s why it will be a drawback not to use this channel for selling real estate. Moreover, video opportunities in this field are even greater comparing to photos and especially text description.</p>\n\n<p>So why does an agency need a video for selling objects?</p>','https://open-real-estate.info/en/blog/articles/how-to-sell-property-with-video','2017-10-12 05:15:22','open-real-estate.info',1,'en'),(171,'New Yandex algorithm “Korolev”','<p>Yandex presented new range algorithm “Korolev” on August 22, which is based on the neuronet principles.</p>','https://open-real-estate.info/en/blog/news/yandex-algorithm-korolev','2017-09-30 08:49:02','open-real-estate.info',1,'en'),(172,'Principles of efficient SMM in real estate','<p>Social networking services are so quickly developing nowadays as they can even become a replacement for a website. In any group or community it is possible to put your goods and services, place application form and write a private message</p>','https://open-real-estate.info/en/blog/articles/efficient-smm-in-real-estate','2017-09-28 03:17:51','open-real-estate.info',1,'en'),(173,'5 reasons to start sending newsletters for a real estate agency or a realtor','<p>High quality newsletters may become very efficient for both agents and private realtors. There are some reasons why</p>','https://open-real-estate.info/en/blog/articles/5-reasons-to-start-sending-newsletters','2017-09-18 10:24:01','open-real-estate.info',1,'en'),(174,'Open Real Estate CMS 1.21.1','<p>\n	The new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1211','2017-09-17 05:33:25','open-real-estate.info',1,'en'),(175,'13 форматов видео для Youtube-канала риелтора или агентства','<p>Мы уже писали о том, что наличие Youtube-канала выгодно выделит вас среди конкурентов. Фото своих объектов делают все, а видео снимают далеко не в каждом агентстве. Поэтому будет неразумно упустить из виду этот популярный канал для привлечения внимания аудитории, который по прогнозам специалистов по продвижению станет одним из самых популярных в 2018 году. Предлагаем несколько форматов видеоконтента, который можно создавать для собственного Youtube-канала.</p>','https://open-real-estate.info/ru/blog/articles/13-video-formats-for-a-realtor','2018-02-14 06:32:09','open-real-estate.info',1,'ru'),(176,'Обвал цен Open Real Estate! Open Real Estate PRO всего за 0,0257 BTC*!','<p>Криптовалюта падает в цене, а наши скидки только растут!</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-prices-decrease','2018-01-19 08:59:39','open-real-estate.info',1,'ru'),(177,'Как оптимизировать сайт недвижимости для поисковых систем','<p>Недвижимость – это высококонкурентная тематика, поэтому для продвижения своего бизнеса в сети нужно использовать максимум возможных каналов, в том числе привлекать трафик из органической выдачи поисковых систем. В этой статье мы расскажем об особенностях оптимизации сайтов недвижимости и о том, как можно конкурировать с популярными агрегаторами.</p>','https://open-real-estate.info/ru/blog/articles/how-to-optimize-real-estate-website','2018-01-11 06:17:11','open-real-estate.info',1,'ru'),(178,'Команда разработчиков Open Real Estate поздравляет с Новым годом! ','<p style=\"color: #ff0000;\"><strong>Дорогие друзья!</strong></p><p>Осталось всего 3 дня до Нового года, и мы рады присоединиться к веренице поздравлений!</p>\n<p>Желаем вам успехов в делах, карьерных взлетов, стремительных прорывов и новых высот в бизнесе, любви, здоровья, гармонии и безграничного счастья!</p>','https://open-real-estate.info/ru/blog/news/happy-new-year-2018','2017-12-28 09:21:28','open-real-estate.info',1,'ru'),(179,'Новогодняя распродажа 2018: готовый скрипт сайта недвижимости со скидкой 18%','<p>Студия MonoRay поздравляет Вас с наступающим 2018 годом и дарит всем Новогодние подарки, только с 12 по 27 декабря 2017 года успейте приобрести наш продукт Open Real Estate CMS с небывалой скидкой 18%!</p>\n<table><tr><td class=\"ore-column-buttons\"><a class=\"download download-buy-offline\" href=\"https://open-real-estate.info/ru/contact-us\" target=\"_blank\">Оставить заявку</a></td><td class=\"ore-column-buttons\"><a class=\"download download-buy-online\" href=\"https://open-real-estate.info/ru/buy-2\"  target=\"_blank\">Купить онлайн</a></td></tr></table>','https://open-real-estate.info/ru/blog/news/new-year-sale-2018','2017-12-12 07:54:29','open-real-estate.info',1,'ru'),(180,'Open Real Estate 1.22.2','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1222','2017-11-21 10:24:27','open-real-estate.info',1,'ru'),(181,'Open Real Estate 1.22.1','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1221','2017-11-03 09:55:45','open-real-estate.info',1,'ru'),(182,'10 важнейших элементов для сайта по продаже недвижимости','<p>В этой статье мы рассмотрим 10 важнейших элементов, которые должны присутствовать на любом современном сайте по продаже недвижимости.</p>','https://open-real-estate.info/ru/blog/articles/10-elements-for-real-estate-website','2017-10-31 05:39:44','open-real-estate.info',1,'ru'),(183,'Как продвигать лэндинги','<p>Landing page – это целевая страница, основная задача которой побудить пользователя совершить определенное действие – купить, подписаться, заполнить заявку. Обычно такие страницы создаются для привлечения рекламного трафика, когда вы продвигаете определенный продукт или услугу.</p> ','https://open-real-estate.info/ru/blog/articles/how-to-promote-landing-pages','2017-10-25 10:32:21','open-real-estate.info',1,'ru'),(184,'Open Real Estate 1.22.0','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-1220','2017-10-24 04:50:38','open-real-estate.info',1,'ru'),(185,'Как продавать недвижимость при помощи видео','<p>Видео-контент давно стал популярным способом продвижения бизнеса, поэтому не задействовать этот канал для продажи недвижимости будет упущением. Тем более, что возможности видео в этой сфере гораздо больше по сравнению с фотосъемкой и, тем более, текстовым описанием объектов.</p>\n\n<p>Итак, зачем агентству нужно видео для продажи объектов?</p>','https://open-real-estate.info/ru/blog/articles/how-to-sell-property-with-video','2017-10-12 05:15:22','open-real-estate.info',1,'ru'),(186,'Новый алгоритм Яндекса «Королёв»','<p>22 августа Яндекс представил новый алгоритм ранжирования «Королёв», который основывается на принципах нейросетей.</p>','https://open-real-estate.info/ru/blog/news/yandex-algorithm-korolev','2017-09-30 08:49:02','open-real-estate.info',1,'ru'),(187,'Принципы эффективного SMM в недвижимости','<p>Социальные сети настолько активно развиваются, что вполне могут служить даже заменой сайту. В любой группе можно разместить товары, форму заявки, возможность написать личные сообщения</p>','https://open-real-estate.info/ru/blog/articles/efficient-smm-in-real-estate','2017-09-28 03:17:51','open-real-estate.info',1,'ru'),(188,'5 причин для агентства или риелтора вести рассылку','<p>Качественная рассылка может оказаться очень действенной как для агентств, так и для частных риелторов. И вот почему</p>','https://open-real-estate.info/ru/blog/articles/5-reasons-to-start-sending-newsletters','2017-09-18 10:24:01','open-real-estate.info',1,'ru'),(189,'Open Real Estate CMS 1.21.1','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1211','2017-09-17 02:33:25','open-real-estate.info',1,'ru'),(190,'Open Real Estate 1.23.0','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1230','2018-03-13 05:03:28','open-real-estate.info',1,'en'),(191,'Help system configuring \"Property types\"','	<p>\nThe functionality of convenient addition of rooms in hotels has appeared in the new Open Real Estate version. An additional tab \"Rooms\" was developed in the editing form of hotels. The owner of an object can see all hotel rooms and add them as well in this tab in a tabular style.\n	</p>','https://open-real-estate.info/en/blog/instructions/configuring-property-types','2018-03-13 03:31:51','open-real-estate.info',1,'en'),(192,'Open Real Estate 1.23.0','<p>\n	Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1230','2018-03-13 05:03:28','open-real-estate.info',1,'ru'),(193,'Настройка справочника \"Тип недвижимости\"','	<p>\nВ новой версии Open Real Estate появилась возможность удобного добавления номеров в гостиницы. В форме редактирования гостиниц появилась дополнительная вкладка номера. В данной вкладке в табличном виде владелец объекта может видеть все номера гостиницы а также добавлять их.\n	</p>','https://open-real-estate.info/ru/blog/instructions/configuring-property-types','2018-03-13 00:31:51','open-real-estate.info',1,'ru'),(194,'Open Real Estate 1.23.1','<p>\nThe new version of CMS&nbsp;<a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>&nbsp;has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1231','2018-03-27 05:36:14','open-real-estate.info',1,'en'),(195,'Open Real Estate 1.23.1','<p>\nВыпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1231','2018-03-27 02:36:14','open-real-estate.info',1,'ru'),(196,'Series of popular questions about our web software','<p><strong>May I make changes in a product myself?</strong></p><p>Sure, Open Real Estate CMS has the open source code! If you have necessary skills in programming, you can customize the product at its own discretion.</p>','https://open-real-estate.info/en/blog/articles/series-of-popular-questions-about-our-web-software','2018-04-23 08:30:00','open-real-estate.info',1,'en'),(197,'Ready-to-use Real Estate CMS with discounts up to 20%!','<p>We announce spring bargain week! Discount on Open Real Estate CMS only for 7 days!</p>','https://open-real-estate.info/en/blog/news/ready-to-use-real-estate-cms-with-discounts-up-to-20','2018-04-17 05:56:26','open-real-estate.info',1,'en'),(198,'Work with real estate in social networks','<p>Social media for business is a mean of quick communication between a company and a customer, way of detecting the needs of potential buyers, increasing their knowledge about the company occupation and increasing loyalty to the brand.</p>','https://open-real-estate.info/en/blog/articles/work-with-real-estate-in-social-networks','2018-04-10 15:05:12','open-real-estate.info',1,'en'),(199,'Серия популярных вопросов о нашем движке','<p><strong>Могу ли я самостоятельно вносить изменения в продукт?</strong></p><p>Да, у Open Real Estate CMS открытый исходный код, и если вы обладаете необходимыми навыками в программировании, можете дорабатывать продукт на свое усмотрение.</p>','https://open-real-estate.info/ru/blog/articles/series-of-popular-questions-about-our-web-software','2018-04-23 08:30:00','open-real-estate.info',1,'ru'),(200,'Готовый скрипт недвижимости Open Real Estate CMS со скидкой до 20%!','<p>Открываем неделю жарких весенних скидок! Специальная цена на Open Real Estate только в течение 7 дней!</p>','https://open-real-estate.info/ru/blog/news/ready-to-use-real-estate-cms-with-discounts-up-to-20','2018-04-17 05:56:26','open-real-estate.info',1,'ru'),(201,'Работа с недвижимостью в социальных сетях','<p>Социальные медиа для бизнеса – это средство оперативной коммуникации между компанией и клиентом, способ выявления потребностей потенциальных покупателей, увеличения их осведомленности о деятельности фирмы и повышения лояльности к бренду.</p>','https://open-real-estate.info/ru/blog/articles/work-with-real-estate-in-social-networks','2018-04-10 12:05:12','open-real-estate.info',1,'ru'),(202,'Importing of listings on the website in Yandex.Realty xml format','<p>The module of listings importing in Yandex.Realty xml format on your website is available for the version 1.25.0 and higher.</p>','https://open-real-estate.info/en/blog/news/import-listings-on-website-in-yandex-realty-xml-format','2018-06-14 09:07:11','open-real-estate.info',1,'en'),(203,'Theme “Basis” and Open Real Estate 1.24.0','<p>The new version of CMS <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate</a> has been released. The main innovation of this version is theme <a href=\"https://demo-pro.open-real-estate.info?template=basis\" target=\"_blank\">“Basis”</a>. <a href=\"https://demo-pro.open-real-estate.info/?template=basis\" target=\"_blank\">“Basis”</a> has a design unique developed specially for our software.  It built using Bootstrap-3 front-end framework and answers to the modern demands.</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1240','2018-06-08 01:04:18','open-real-estate.info',1,'en'),(204,'XML-загрузка объявлений на сайт в формате Яндекс.Недвижимость','<p>Для версий 1.25.0 и выше доступен модуль загрузки объявлений в формате Яндекс.Недвижимости на ваш сайт.</p>','https://open-real-estate.info/ru/blog/news/import-listings-on-website-in-yandex-realty-xml-format','2018-06-14 09:07:11','open-real-estate.info',1,'ru'),(205,'Тема \"Basis\" и Open Real Estate 1.24.0','<p>Выпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>. Основным новшеством этой версии стала тема оформления <a href=\"https://demo-pro.open-real-estate.info/ru?template=basis\" target=\"_blank\">\"Basis\"</a>. <a href=\"https://demo-pro.open-real-estate.info/ru?template=basis\" target=\"_blank\">\"Basis\"</a> обладает уникальным дизайном, разработанным специально для нашего продукта, и построена с использованием frontend-фреймворка Bootstrap-3, благодаря чему удовлетворяет всем современным требованиям.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1240','2018-06-08 01:04:18','open-real-estate.info',1,'ru'),(206,'Open Real Estate 1.25.1','<p>\nThe new version of readymade php script Open Real Estate CMS has been released.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1251','2018-07-08 09:57:04','open-real-estate.info',1,'en'),(207,'Open Real Estate and the new bright theme Basis with a discount until 1 July!','<p>\nThe latest version Open Real Estate 1.25.0 has been released with a refresh template \"Basis\". This theme can truly be called as stylish, up-to-date and functional. Beyond that this version of the system includes new widgets on the main screen, listings importing in Yandex.Realty format. Here the software is now, hot out of the oven — is cheaper for the first buyers!\n</p>','https://open-real-estate.info/en/blog/news/summer-sale','2018-06-22 08:09:44','open-real-estate.info',1,'en'),(208,'Open Real Estate 1.25.1','<p>\nВыпущена новая версия движка для агентства недвижимости Open Real Estate CMS.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1251','2018-07-08 09:57:04','open-real-estate.info',1,'ru'),(209,'Open Real Estate и новая яркая тема Basis ― со скидкой до 1 июля!','<p>\nМы выпустили новую версию Open Real Estate 1.25 с адаптивным шаблоном \"Basis\" ― стильным, современным и функциональным. Помимо этого, последняя версия системы включает новые виджеты на главном экране, импорт объявлений в формате Яндекс недвижимость. Горячий «прямо из печки» движок — дешевле для первых покупателей!\n</p>','https://open-real-estate.info/ru/blog/news/summer-sale','2018-06-22 05:09:44','open-real-estate.info',1,'ru'),(210,'Open Real Estate 1.25.2','<p>\nThe new version of readymade php script Open Real Estate CMS has been released.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1252','2018-08-15 01:11:55','open-real-estate.info',1,'en'),(211,'Open Real Estate 1.25.2','<p>\nВыпущена новая версия движка для агентства недвижимости Open Real Estate CMS.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1252','2018-08-15 01:11:55','open-real-estate.info',1,'ru'),(212,'Open Real Estate 1.25.3','<p>\nThe new version of realty php script Open Real Estate CMS has been released.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1253','2018-08-24 11:50:09','open-real-estate.info',1,'en'),(213,'Open Real Estate 1.25.3','<p>\nВыпущена новая версия готового скрипта недвижимости Open Real Estate CMS.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1253','2018-08-24 08:50:09','open-real-estate.info',1,'ru'),(214,'Open Real Estate 1.25.4','<p>\nWe corrected minor errors and also error during the website work under PHP 7.2 in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1254','2018-09-13 03:41:08','open-real-estate.info',1,'en'),(215,'Open Real Estate 1.25.4','<p>\nВ новой версии мы исправили незначительные ошибки, а также ошибку при работе сайта под PHP 7.2.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1254','2018-09-13 00:41:08','open-real-estate.info',1,'ru'),(216,'Open Real Estate 1.25.6','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1256','2018-10-13 12:58:19','open-real-estate.info',1,'en'),(217,'Open Real Estate 1.25.5','<p>\nThe new version of realty php script Open Real Estate CMS has been released.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1255','2018-10-06 03:23:32','open-real-estate.info',1,'en'),(218,'Open Real Estate 1.25.6','<p>\nВ новой версии мы исправили незначительные ошибки\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1256','2018-10-13 09:58:19','open-real-estate.info',1,'ru'),(219,'Open Real Estate 1.25.5','<p>\nВыпущена новая версия готового скрипта недвижимости Open Real Estate CMS.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1255','2018-10-06 00:23:32','open-real-estate.info',1,'ru'),(220,'Customizing Themes \"Atlas\" and \"Basis\"','<ul>\n<li>How to change the name of the site;</li>\n<li>Change the logo in the Theme \"Atlas\";</li>\n<li>How to change links in the top menu for the Atlas template;</li>\n<li>How to change links in the top menu for the template Basis;</li>\n<li>Change the bottom of the site (footer) in the Atlas template;</li>\n<li>Change the bottom of the site (footer) in the Theme \"Basis\";</li>\n<li>View listing: how to remove the text \"Is it your listing? Would you like to rent out a property quicker? apply paid services\" in Atlas and Basis Themes.</li>\n</ul>','https://open-real-estate.info/en/blog/instructions/customizing-themes-atlas-basis-open-real-estate','2018-11-20 03:57:52','open-real-estate.info',1,'en'),(221,'Settings the Theme “Basis” ','<p>In this article we will consider how to change logo, customize marker on the contact map, remove the side menu, swap columns.</p>','https://open-real-estate.info/en/blog/instructions/setting-theme-basis','2018-10-25 01:03:15','open-real-estate.info',1,'en'),(222,'Настройка тем оформления Atlas и Basis','<ul>\n<li>Как поменять название сайта;</li>\n<li>Смена логотипа в теме Atlas;</li>\n<li>Как изменить ссылки в верхнем меню для шаблона Atlas;</li>\n<li>Как изменить ссылки в верхнем меню для шаблона Basis;</li>\n<li>Изменение нижней части сайта (футера) в шаблоне Atlas;</li>\n<li>Изменение нижней части сайта (футера) в теме оформления Basis;</li>\n<li>Просмотр объявления: как удалить текст \"Это Ваше объявление? Хотите продать быстрее? Попробуйте применить платные услуги\" в темах Atlas и Basis.</li>\n</ul>','https://open-real-estate.info/ru/blog/instructions/customizing-themes-atlas-basis-open-real-estate','2018-11-19 21:57:52','open-real-estate.info',1,'ru'),(223,'Настройки темы Basis','<p>В этой статье мы рассмотрим как изменить логотип, настроить метку на карте контактов, убрать боковое меню, поменять колонки местами.</p>','https://open-real-estate.info/ru/blog/instructions/setting-theme-basis','2018-10-24 22:03:15','open-real-estate.info',1,'ru'),(224,'The team of developers of Open Real Estate congratulates you with Happy New Year!','<p>The team of developers of Open Real Estate congratulates you with Happy New Year!The MonoRay team congratulates you with Happy New Year! </p>\n','https://open-real-estate.info/en/blog/news/happy-new-year-2019','2018-12-29 02:33:19','open-real-estate.info',1,'en'),(225,'Settings the Theme “Basis”, Part 2','<p>In this article we will consider the directory structure of the Theme Basis, settings of the home page and several widgets.</p>','https://open-real-estate.info/en/blog/instructions/setting-theme-basis-part2','2018-12-27 03:36:04','open-real-estate.info',1,'en'),(226,'Команда разработчиков Open Real Estate поздравляет с Новым годом!','<p>Команда разработчиков Open Real Estate поздравляет всех с наступающим Новым годом! \nКоллектив MonoRay поздравляет всех с наступающим Новым годом! </p>\n','https://open-real-estate.info/ru/blog/news/happy-new-year-2019','2018-12-29 02:33:19','open-real-estate.info',1,'ru'),(227,'Настройка темы Basis, часть 2','<p>В этой статье мы рассмотрим структуру директорий темы Basis, настройки главной страницы и нескольких виджетов.</p>','https://open-real-estate.info/ru/blog/instructions/setting-theme-basis-part2','2018-12-27 03:36:04','open-real-estate.info',1,'ru'),(228,'Ready-to-use Real Estate CMS with discounts up to 25%!','<p>Only from 9th-26th of January you can purchase Open Real Estate CMS with a great discount</p> \n','https://open-real-estate.info/en/blog/news/ready-to-use-real-estate-cms-with-discounts-up-to-25-january-2019','2019-01-09 06:02:45','open-real-estate.info',1,'en'),(229,'Open Real Estate 1.27.0','<p>\nThe new version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate CMS</a> has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1270','2019-01-07 05:01:22','open-real-estate.info',1,'en'),(230,'Готовый скрипт недвижимости Open Real Estate CMS со скидкой до 25%!','<p>Только с 9 до 26 января Open Real Estate CMS можно приобрести с хорошей скидкой</p>\n','https://open-real-estate.info/ru/blog/news/ready-to-use-real-estate-cms-with-discounts-up-to-25-january-2019','2019-01-09 03:02:45','open-real-estate.info',1,'ru'),(231,'Open Real Estate 1.27.0','<p>\nВыпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1270','2019-01-07 02:01:22','open-real-estate.info',1,'ru'),(232,'Open Real Estate 1.28.1','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1281','2019-01-20 03:04:06','open-real-estate.info',1,'en'),(233,'Open Real Estate 1.28.0','<p>\nThe new version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate CMS</a> has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1280','2019-01-16 12:27:47','open-real-estate.info',1,'en'),(234,'Open Real Estate 1.28.1','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1281','2019-01-20 00:04:06','open-real-estate.info',1,'ru'),(235,'Open Real Estate 1.28.0','<p>\nВыпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1280','2019-01-16 09:27:47','open-real-estate.info',1,'ru'),(236,'Open Real Estate 1.28.2','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1282','2019-01-31 05:06:51','open-real-estate.info',1,'en'),(237,'Open Real Estate 1.28.2','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1282','2019-01-31 02:06:51','open-real-estate.info',1,'ru'),(238,'Open Real Estate 1.28.3','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1283','2019-02-08 10:36:13','open-real-estate.info',1,'en'),(239,'Open Real Estate 1.28.3','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1283','2019-02-08 10:36:13','open-real-estate.info',1,'ru'),(240,'The preview of the new design for Open Real Estate','<p>In the near future we will release a new responsive design for CMS Open Real Estate.</p>','https://open-real-estate.info/en/blog/news/preview-of-the-new-design','2019-06-24 10:18:43','open-real-estate.info',1,'en'),(241,'Open Real Estate 1.29.2','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1292','2019-06-06 13:54:16','open-real-estate.info',1,'en'),(242,'Open Real Estate 1.29.1','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1291','2019-05-10 14:31:15','open-real-estate.info',1,'en'),(243,'Create a page and display the listing widget in Open Real Estate using the code Yii','<p>Today we’ll learn how easy to create a new page and add a listing widget with specific criteria. To do this, we need the Notepad ++ editor or any other code editor with utf-8 without bom encoding support. If you want to make all the improvements locally, then you will need a local web server, the Open Server is well suited for this - https://ospanel.io/\nIf you work with files on a hosting, then it is convenient to use FileZilla FTP client - https://filezilla-project.org/</p>\n','https://open-real-estate.info/en/blog/instructions/create-a-page-and-display-the-listing-widget-using-the-code-yii','2019-04-29 13:58:21','open-real-estate.info',1,'en'),(244,'Spring discounts Open Real Estate!','<p>From April 24 to 29 Open Real Estate CMS can be purchased with a discount <strong>30%</strong></p>','https://open-real-estate.info/en/blog/news/open-real-estate-spring-discounts','2019-04-24 04:13:18','open-real-estate.info',1,'en'),(245,'Open Real Estate 1.29.0','<p>\nThe new version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate CMS</a> has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1290','2019-03-17 04:29:20','open-real-estate.info',1,'en'),(246,'Анонс нового дизайна для Open Real Estate','<p>В ближайшее время выйдет новый адаптивный дизайн для CMS Open Real Estate.</p>\n','https://open-real-estate.info/ru/blog/news/preview-of-the-new-design','2019-06-24 10:18:43','open-real-estate.info',1,'ru'),(247,'Open Real Estate 1.29.2','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1292','2019-06-06 13:54:16','open-real-estate.info',1,'ru'),(248,'Open Real Estate 1.29.1','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1291','2019-05-10 14:31:15','open-real-estate.info',1,'ru'),(249,'Создание страницы и вывод виджета объявлений в Open Real Estate','<p>Сегодня мы узнаем, как просто создать новую страницу и добавить туда виджет объявлений с определенными критериями. Для этого нам потребуется редактор notepad++ или любой другой редактор кода с поддержкой кодировки \"UTF-8 без BOM\". Если вы хотите делать все доработки локально, то понадобится локальный веб-сервер, для этого хорошо подходит <a href=\"https://ospanel.io/ \">Open Server</a>.\nЕсли вы работаете с файлами на хостинге, то удобно использовать FTP клиент <a href=\"https://filezilla-project.org/\">FileZilla</a> </p>\n<p>Также вам понадобиться любая версия <a href=\"https://open-real-estate.info/ru/download-open-real-estate\">CMS Open Real Estate</a>\n</p>','https://open-real-estate.info/ru/blog/instructions/create-a-page-and-display-the-listing-widget-using-the-code-yii','2019-04-29 13:58:21','open-real-estate.info',1,'ru'),(250,'Весенние скидки на Open Real Estate!','<p>Только с 24 до 29 апреля Open Real Estate CMS можно приобрести со скидкой <strong>30%</strong></p>\n','https://open-real-estate.info/ru/blog/news/open-real-estate-spring-discounts','2019-04-24 04:13:18','open-real-estate.info',1,'ru'),(251,'Open Real Estate 1.29.0','<p>\nВыпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1290','2019-03-17 01:29:20','open-real-estate.info',1,'ru'),(252,'Dolphin theme setting','<p>A new design theme Dolphin for Open Real Estate CMS released in 2019. The theme based on the CSS framework Bootstrap 3. It is adaptive and looks good as on a smartphone so on a wide monitor. There is support for RTL languages. The theme stands out of other ones some functions and we will discuss it below.</p>','https://open-real-estate.info/en/blog/instructions/dolphin-theme-setting','2020-02-27 04:47:12','open-real-estate.info',1,'en'),(253,'Black Friday: discounts up to 50%','<p> Discounts on all editions:<br/>\n<br/>\nOpen Real Estate Basic  -50%<br/> \nOpen Real Estate PRO  -40% <br/>\nOpen Real Estate Ultimate  -30% </p>\n<p>Don\'t miss your chance — launch the website with Open Real Estate for half the price!</p>\n<p>Discounts aren\'t cumulative with other special offers.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-black-friday-2019-discounts','2019-11-29 05:59:24','open-real-estate.info',1,'en'),(254,'Open Real Estate 1.30.3','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1303','2019-11-08 11:40:30','open-real-estate.info',1,'en'),(255,'Open Real Estate 1.30.2 - Improvements for system security','<p>\nImprovements for system security made in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1302','2019-09-12 07:30:16','open-real-estate.info',1,'en'),(256,'Open Real Estate 1.30.1','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1301','2019-08-30 15:06:49','open-real-estate.info',1,'en'),(257,'The Dolphin theme in Open Real Estate Pro now!','<p>We are pleased to inform you that a new <a href=\"https://demo-pro.open-real-estate.info/en?template=dolphin\">Dolphin theme</a> is in the Pro version!\nBuying Open real Estate Pro, you can choose any designs of the 4 to use: Classic, Atlas, Basis or Dolphin!</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-pro-dolphin','2019-08-19 05:44:48','open-real-estate.info',1,'en'),(258,'Version 1.30.0 and the new theme “Dolphin”','<p>We are glad to announce a new unique design for CMS Open Real Estate – <a href=\"https://demo-pro.open-real-estate.info/ru?template=dolphin\" target=\"_blank\">this theme is “Dolphin”</a>. It looks great on modern widescreen monitors and mobile devices.</p>\n','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1300-dolphin','2019-08-07 07:38:26','open-real-estate.info',1,'en'),(259,'Open Real Estate 1.29.3','<p>\nThe new version of <a href=\"https://open-real-estate.info/en/download-open-real-estate\" target=\"_blank\">Open Real Estate CMS</a> has been released.</p>\n<p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1293','2019-07-26 16:23:32','open-real-estate.info',1,'en'),(260,'Настройка темы Dolphin','<p>В 2019 году вышла новая тема оформления для Open Real Estate CMS под названием Dolphin. Тема базируется на css framework Bootstrap 3. Она адаптивная, хорошо выглядит как на смартфоне, так и на широком мониторе. Присутствует поддержка RTL языков. Тема отличается некоторыми особенностями о которых мы поговорим ниже.</p>','https://open-real-estate.info/ru/blog/instructions/dolphin-theme-setting','2020-02-27 04:47:12','open-real-estate.info',1,'ru'),(261,'Чёрная Пятница: скидки до 50%','<p>Только 2 дня, 29-30 ноября 2019 г. Горящая распродажа Open Real Estate!</p>\n<p> Скидки на ВСЕ редакции:<br/>\n<br/>\nOpen Real Estate Basic  -50%<br/> \nOpen Real Estate PRO  -40% <br/>\nOpen Real Estate Ultimate  -30% </p>\n<p>Не упусти шанс — запусти сайт на Open Real Estate вдвое дешевле!</p>\n<p>Скидки не суммируются с другими акциями.</p>\n','https://open-real-estate.info/ru/blog/news/open-real-estate-black-friday-2019-discounts','2019-11-29 05:59:24','open-real-estate.info',1,'ru'),(262,'Open Real Estate 1.30.3','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1303','2019-11-08 11:40:30','open-real-estate.info',1,'ru'),(263,'Open Real Estate 1.30.2. Исправления для безопасности системы','<p>\nВ новой версии внесены исправления для безопасности системы.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1302','2019-09-12 07:30:16','open-real-estate.info',1,'ru'),(264,'Open Real Estate 1.30.1','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1301','2019-08-30 15:06:49','open-real-estate.info',1,'ru'),(265,'Тема оформления \"Dolphin\" теперь и в Open Real Estate Pro','<p>Мы включили нашу новую <a href=\"https://demo-pro.open-real-estate.info/ru?template=dolphin\">тему оформления \"Dolphin\"</a> в состав Pro-версии Open real Estate!\nПриобретая Open real Estate Pro, вы можете выбрать какой из 4 дизайнов сайта использовать: Classic, Atlas, Basis или Dolphin!</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-pro-dolphin','2019-08-19 05:44:48','open-real-estate.info',1,'ru'),(266,'Версия 1.30.0 и новая тема оформления “Dolphin”','<p>Рады сообщить Вам о выходе нового уникального дизайна для CMS Open Real Estate - <a href=\"https://demo-pro.open-real-estate.info/ru?template=dolphin\" target=\"_blank\">тема оформления “Dolphin”</a>. Тема отлично выглядит на современных широкоформатных мониторах и мобильных устройствах.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1300-dolphin','2019-08-07 07:38:26','open-real-estate.info',1,'ru'),(267,'Open Real Estate 1.29.3','<p>\nВыпущена новая версия готового сайта недвижимости <a href=\"https://open-real-estate.info/ru/download-open-real-estate\" target=\"_blank\">Open Real Estate</a>.</p>\n<p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1293','2019-07-26 13:23:32','open-real-estate.info',1,'ru'),(268,'Open Real Estate 1.32.0','<p>Now Atlas design theme is added in the Free version some improvements</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1320','2020-04-05 11:35:54','open-real-estate.info',1,'en'),(269,'Open Real Estate 1.32.0','<p>В новой версии мы добавили тема \"Атлас\" и несколько полезных изменений.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1320','2020-04-05 11:35:54','open-real-estate.info',1,'ru'),(270,'Open Real Estate 1.32.1','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1321','2020-04-17 03:49:11','open-real-estate.info',1,'en'),(271,'New features in Open Real Estate CMS','<p> In new version of Open Real Estate 1.32.0 appeared the additional settings and functions. </p>\n<ul>\n<li>changes with the display of listings ID;</li>\n<li>in the settings for \"Located in\" properties of the listings;</li>\n<li>URL search is changed;</li>\n<li>a new feature is the capability to make disable the visual editor for the \"Description\" field;</li>\n<li>the slider settings are modified.</li>\n</ul>\n<p>More details are in the full news version.</p>','https://open-real-estate.info/en/blog/news/new-features-in-open-real-estate-cms','2020-04-08 08:20:01','open-real-estate.info',1,'en'),(272,'Open Real Estate 1.32.1','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1321','2020-04-17 03:49:11','open-real-estate.info',1,'ru'),(273,'Новые функции в Open Real Estate CMS','<p>В новой версии Open Real Estate 1.32.0 появились дополнительные настройки и функции.</p>\n<ul>\n<li>изменения касающиеся вывода ID объявления;</li>\n<li>перемены в настройках свойств \"Находится в\" у объявлений;</li>\n<li>изменился также URL поиск;</li>\n<li>новая функция - возможность отключать визуальный редактор для поля \"Описание\";</li>\n<li>изменена настройка слайдера.</li>\n</ul>\n<p>Подробнее в полной новости.</p>','https://open-real-estate.info/ru/blog/news/new-features-in-open-real-estate-cms','2020-04-08 05:20:01','open-real-estate.info',1,'ru'),(274,'11.11 - 20.11  Great discount days','','https://open-real-estate.info/en/blog/news/open-real-estate-grea-discount-days-11-11-2020','2020-11-11 04:17:43','open-real-estate.info',1,'en'),(275,'Open Real Estate 1.33.0','<p> In new version of Open Real Estate 1.32.0 appeared the additional settings and functions. </p>\n<ul>\n<li>settings for the Best listings widget;</li>\n<li>the capability to download images appeared for \"Information Pages\" in Popular Destinations widget;</li>\n<li>on the video tab, it\'s enough to specify the youtube URL for video addition.</li>\n</ul>\n<p>More details are in the full news version.</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1330','2020-07-14 11:34:36','open-real-estate.info',1,'en'),(276,'Open Real Estate CMS 1.32.2','<p>\nWe corrected minor errors in the new version.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1322','2020-05-06 12:25:48','open-real-estate.info',1,'en'),(277,'Большие дни скидок 11.11 - 20.11','','https://open-real-estate.info/ru/blog/news/open-real-estate-grea-discount-days-11-11-2020','2020-11-11 04:17:43','open-real-estate.info',1,'ru'),(278,'Open Real Estate 1.33.0','<p>В новой версии Open Real Estate 1.33.0 появились дополнительные настройки и функции.</p>\n<ul>\n<li>настройки для виджета \"Лучшие варианты\";</li>\n<li>для виджета \"Популярные направления\" появилась возможность загрузки картинок для \"Информационных страниц\";</li>\n<li>на вкладке видео, достаточно указать url youtube видео для добавления.</li>\n</ul>\n<p>Подробнее в полной новости.</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1330','2020-07-14 11:34:36','open-real-estate.info',1,'ru'),(279,'Open Real Estate CMS 1.32.2','<p>\nВ новой версии мы исправили незначительные ошибки.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1322','2020-05-06 12:25:48','open-real-estate.info',1,'ru'),(280,'Happy Holidays!','<p>To our clients and friends, we at Monoray extend our best wishes for a joyous holiday season and a prosperous new year. </p>\n<p>Our team wishing you all the best! May all the dreams for the coming year be fulfilled. Happiness, Prosperity, and Success!</p>\n<p><strong>Merry Christmas and Happy New Year to everyone!</strong></p>','https://open-real-estate.info/en/blog/news/happy-new-year-2021','2020-12-24 07:17:46','open-real-estate.info',1,'en'),(281,'С наступающим Новым Годом и Рождеством!','<p>Наша команда поздравляет Вас с наступающими праздниками!</p>\n<p>Пусть этот Новый год откроет яркие перспективы, а усилия непременно приведут Вас к достижению поставленных целей. Счастья, процветания и успехов! </p>\n<p><strong>Наилучшие пожелания в Новом году!</strong></p>\n','https://open-real-estate.info/ru/blog/news/happy-new-year-2021','2020-12-24 07:17:46','open-real-estate.info',1,'ru'),(282,'Open Real Estate 1.35.0','<p>\nThe new version of Open Real Estate CMS has been released.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1350','2021-08-30 09:52:35','open-real-estate.info',1,'en'),(283,'Open Real Estate 1.34.0','<p>\nThe new version of Open Real Estate CMS has been released.\n</p>','https://open-real-estate.info/en/blog/news/open-real-estate-cms-1340','2021-01-12 08:55:56','open-real-estate.info',1,'en'),(284,'Open Real Estate 1.35.0','<p>\nВыпущена новая версия движка недвижимости Open Real Estate.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1350','2021-08-30 09:52:35','open-real-estate.info',1,'ru'),(285,'Open Real Estate 1.34.0','<p>\nВыпущена новая версия движка недвижимости Open Real Estate.\n</p>','https://open-real-estate.info/ru/blog/news/open-real-estate-cms-1340','2021-01-12 08:55:56','open-real-estate.info',1,'ru');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}notifier`
--

DROP TABLE IF EXISTS `{dbPrefix}notifier`;
CREATE TABLE `{dbPrefix}notifier` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `event` varchar(50) NOT NULL DEFAULT '',
  `onlyAdmin` tinyint(1) NOT NULL DEFAULT 0,
  `subject_en` varchar(255) NOT NULL DEFAULT '',
  `subject_admin_en` varchar(255) NOT NULL DEFAULT '',
  `body_en` text DEFAULT NULL,
  `body_admin_en` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event` (`event`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}notifier`
--

LOCK TABLES `{dbPrefix}notifier` WRITE;
INSERT INTO `{dbPrefix}notifier` VALUES (1,3,'onNewBooking',1,'New booking','New booking','<p>A new booking has been created.<br />\r\n<br />\r\nApartment ID: {apartment_id} (<a href=\"{fullhost}/property/{apartment_id}\">{fullhost}/property/{apartment_id}</a>).<br />\r\nUsername: {username}.<br />\r\nEmail: {useremail}.<br />\r\nPhone: {phone}.<br />\r\nDate start: {date_start}.<br />\r\nTimes in: {time_inVal}.<br />\r\nDate end: {date_end}.<br />\r\nTime out: {time_outVal}.<br />\r\nGuests: {num_guest}.<br />\r\nComment: {comment}</p>\r\n','<p>A new booking has been created.<br />\r\n<br />\r\nApartment ID: {apartment_id} (<a href=\"{fullhost}/property/{apartment_id}\">{fullhost}/property/{apartment_id}</a>).<br />\r\nEmail of the current owner of the listing: {ownerEmail}<br />\r\n<br />\r\nUsername: {username}.<br />\r\nEmail: {useremail}.<br />\r\nPhone: {phone}.<br />\r\nDate start: {date_start}.<br />\r\nTimes in: {time_inVal}.<br />\r\nDate end: {date_end}.<br />\r\nTime out: {time_outVal}.<br />\r\nGuests: {num_guest}.<br />\r\nComment: {comment}</p>\r\n'),(2,3,'onNewUser_with_confirm',0,'User registration','User registration','<p>\r\n	Welcome to {fullhost} !</p>\r\n<p>\r\n	Your login is: {email}<br />\r\n	Your password is: {password}</p>\r\n<p>\r\n	Before using the site<br />\r\n	You should activate your account<br />\r\n	Link for your account activation is {activateLink}</p>\r\n<p>\r\n	You can login to your control panel using the link: {fullhost}/site/login<br />\r\n	&nbsp;</p>\r\n','<p>\r\n	New user {username} {email} has been registered.</p>\r\n<p>\r\n	You can view and manage users via: {fullhost}/users/backend/main/admin</p>\r\n'),(3,3,'onNewUser_without_confirm',0,'User registration','User registration','<p>\r\n	Welcome to {fullhost} !</p>\r\n<p>\r\n	Your login is: {email}<br />\r\n	Your password is: {password}</p>\r\n\r\n<p>\r\n	You can login to your control panel using the link: {fullhost}/site/login<br />\r\n	&nbsp;</p>\r\n','<p>\r\n	New user {username} {email} has been registered.</p>\r\n<p>\r\n	You can view and manage users via: {fullhost}/users/backend/main/admin</p>\r\n'),(4,1,'onNewContactform',1,'New message (contact form)','New message (contact form)','','<p>\r\n	New message is sent for you from {name} ({email}, {phone}).</p>\r\n<p>\r\n	Message text: {body}</p>\r\n'),(5,1,'onOfflinePayment',1,'A new payment via a bank','A new payment via a bank','','<p>\r\n	A new payment via a bank of the amount of {amount} {currency_charcode}</p>\r\n'),(6,3,'onRequestProperty',0,'Request for property from','Request for property from','<p>\r\n	Hello, {ownerName}!</p>\r\n<p>\r\n	This message has been sent via a contact form on the site {fullhost}<br />\r\n	Sender: {senderName}<br />\r\n	About your listing {apartmentUrl}<br />\r\n	Sender email: {senderEmail}<br />\r\n	Sender phone number: {senderPhone}<br />\r\n	Message: {body}</p>\r\n','<p>\r\n	Hello, administrator!</p>\r\n<p>\r\n	This message has been sent via a contact form on the site {fullhost}<br />\r\n	Sender: {senderName}<br />\r\n	About listing: {apartmentUrl}<br />\r\n	Sender email: {senderEmail}<br />\r\n	Sender phone number: {senderPhone}<br />\r\n	Message: {body}</p>\r\n<p>\r\n	Owner name: {ownerName}<br />\r\n	Owner email: {ownerEmail}\r\n</p>\r\n'),(7,1,'onNewComment',1,'A new comment is added','A new comment is added','<p>\r\n	New comment was added to your listing {ad_url}. From {user_name} ({user_email}), rating: {rating}. Message: {body}</p>\r\n','<p>\r\n	New comment is added. From {user_name} ({user_email}), rating: {rating}. Message: {body}</p>\r\n'),(8,1,'onNewApartment',1,'New listing added','New listing added','','<p>\r\n	New listing was added. ( Apartment ID {id} ).</p>\r\n<p>\r\n	You can view it at {url}</p>\r\n'),(9,1,'onNewComplain',1,'New complain added','New complain added','','<p>\r\n	New complain was added. From {name} ({email}).</p>\r\n<p>\r\n	Complain text: {body}</p>\r\n'),(11,2,'onRecoveryPassword',0,'Recover password','','<p>\r\n	You&#39;ve got this mail because you (or someone, who was pretending to be you) asked to send new password to your account on the website {fullhost}.<br />\r\n	<br />\r\n	<br />\r\n	New password: {temprecoverpassword}<br />\r\n	<br />\r\n	Before using your new password, please activate it. Click the link: {recoverPasswordLink}<br />\r\n	<br />\r\n	<br />\r\n	<br />\r\n	You can login to your personal account via this link: {fullhost}</p>\r\n',''),(12,1,'onNewReview',1,'The new review was added.','Был добавлен новый отзыв.','','<p>The new review was added. </p> \r\n<p>From {name}. </p> \r\n<p>Body: {body}</p> \r\n<p>You can view it at {fullhost}/reviews/backend/main/admin</p>'),(13,2,'onNewAgent',0,'New agent','','<p>\r\n	User {username} ( email: {email}, phone: {phone} ) identifies himself as an agent of your agency. You can confirm or delete this user in the dashboard {fullhost}.</p>\r\n',''),(14,2,'onNewPrivateMessage',0,'New message','','<p>Hello {username}.</p>\r\n<p>You have got a new message.</p>\r\n<div>Message Text: {messageEmailSend}</div>\r\n<p>To answer it you need to access your account: {url}</p>',''),(15,1,'onNewSimpleBookingForRent',1,'New booking (Booking a property)','New booking','<p>\r\n	A new booking has been created.<br />Username: {username}.<br />Email: {useremail}.<br />Phone: {phone}.<br />Type: {type}.<br />Date start: {date_start}.<br />Times in {time_inVal}.<br />Date end:  {date_end}.<br />Time out {time_outVal}.<br />Comment: {comment}</p>\r\n','<p>\r\n	A new booking has been created.<br />Username: {username}.<br />Email: {useremail}.<br />Phone: {phone}.<br />Type: {type}.<br />Date start: {date_start}.<br />Times in {time_inVal}.<br />Date end:  {date_end}.<br />Time out {time_outVal}.<br />Comment: {comment}</p>\r\n'),(16,1,'onNewSimpleBookingForBuy',1,'New booking','New booking','<p>\r\n	A new booking has been created.<br />Username: {username}.<br />Email: {useremail}.<br />Phone: {phone}.<br />Type: {type}.<br />Comment: {comment}</p>\r\n','<p>\r\n	A new booking has been created.<br />Username: {username}.<br />Email: {useremail}.<br />Phone: {phone}.<br />Type: {type}.<br />Comment: {comment}</p>\r\n'),(17,2,'onBookingNeedPay',0,'You ought to pay for the booking','','<p>Hello, {username}!</p>\r\n\r\n<p>You&#39;ve submitted a booking request for property {apartmentUrl} from {date_start} until {date_end}. To book this period, you should pay {amount} {currency}.</p>\r\n\r\n{calcForMail}\r\n<p>{comment_admin}</p>\r\n\r\n<p>You can do it inside your account {fullhost}.</p>\r\n',''),(18,2,'onBookingChangeStatus',0,'Booking status is changed.','Изменился статус бронирования','<p>Booking status is changed {apartmentUrl}</p>\r\n',''),(19,2,'onBookingConfirm',0,'Booking request is confirmed','<p>Здравствуйте, {username}!</p> Ваша заявка на бронирование недвижимости {apartmentUrl} подтверждена','<p>Hello, {username}</p>\r\n\r\n<p>Booking request is confirmed {apartmentUrl}</p>\r\n',''),(20,1,'onNewCity',1,'New city is added','New city is added','','<p>Users added &#39;{name}&#39; city to the site.</p>\r\n\r\n<p>Please, activate it.</p>\r\n'),(21,1,'onApartmentNeedModerate',1,'New listing added','Listing edited','','<p>Creative changed (Creative ID {id}) and is awaiting moderation.</p>\r\n\r\n<p>You can look at {url}</p>\r\n'),(22,1,'onNewLoginFormCode',1,'','Admin panel login code',NULL,'<p>Code: {code}</p> '),(23,1,'onNewCallBackForm',1,'','Callback order',NULL,'<p>A callback was ordered.</p>\r\n<p>Phone {phone}.</p>\r\n<p>Name {name}.</p>');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}object_image`
--

DROP TABLE IF EXISTS `{dbPrefix}object_image`;
CREATE TABLE `{dbPrefix}object_image` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `model_id` int(11) unsigned NOT NULL DEFAULT 0,
  `model_name` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`),
  KEY `model_name` (`model_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}object_image`
--

LOCK TABLES `{dbPrefix}object_image` WRITE;
INSERT INTO `{dbPrefix}object_image` VALUES (5,'moscow-3550477-1280.jpg',524901,'City','2019-07-29 09:22:52'),(6,'yoshkar-ola-3636941-1280.jpg',466806,'City','2019-07-29 09:23:08'),(8,'empire-state-building-1081929-1280.jpg',5128581,'City','2019-07-29 09:25:33'),(10,'los-angeles-1598750-1280.jpg',5368361,'City','2019-07-29 09:37:25');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}reviews`
--

DROP TABLE IF EXISTS `{dbPrefix}reviews`;
CREATE TABLE `{dbPrefix}reviews` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `body` text DEFAULT NULL,
  `email` varchar(100) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `active` tinyint(4) unsigned NOT NULL DEFAULT 1,
  `sorter` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}reviews`
--

LOCK TABLES `{dbPrefix}reviews` WRITE;
INSERT INTO `{dbPrefix}reviews` VALUES (1,'','','Demo','You can always download the latest version of the script from this website - http://open-real-estate.info/en/download-open-real-estate','','2019-01-05 11:18:42','2019-01-05 12:21:34',1,1),(2,'','','Демо','Скачать последнюю версию скрипта Вы всегда можете с сайта - http://open-real-estate.info/ru/download-open-real-estate','','2019-01-05 11:40:48','2019-01-05 12:33:33',1,2);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}search_form`
--

DROP TABLE IF EXISTS `{dbPrefix}search_form`;
CREATE TABLE `{dbPrefix}search_form` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `page` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `compare_type` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `obj_type_id` int(11) unsigned NOT NULL DEFAULT 0,
  `field` varchar(100) NOT NULL DEFAULT '',
  `sorter` int(11) unsigned NOT NULL DEFAULT 0,
  `formdesigner_id` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `obj_type_id` (`obj_type_id`),
  KEY `formdesigner_id` (`formdesigner_id`)
) ENGINE=InnoDB AUTO_INCREMENT=245 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}search_form`
--

LOCK TABLES `{dbPrefix}search_form` WRITE;
INSERT INTO `{dbPrefix}search_form` VALUES (133,1,1,0,1,'location',3,0),(134,1,1,0,1,'ap_type',4,0),(135,1,1,0,1,'obj_type',5,0),(136,1,1,0,1,'price',6,0),(137,1,1,0,1,'square',7,0),(138,1,1,0,1,'rooms',8,0),(139,1,1,0,1,'floor',9,0),(140,1,1,0,1,'term',10,0),(141,1,1,0,1,'by_id',11,0),(142,1,1,0,1,'owner_type',12,0),(143,1,1,0,1,'with_photo',13,0),(144,1,1,0,2,'location',3,0),(145,1,1,0,2,'ap_type',4,0),(146,1,1,0,2,'obj_type',5,0),(147,1,1,0,2,'price',6,0),(148,1,1,0,2,'square',7,0),(149,1,1,0,2,'rooms',8,0),(150,1,1,0,2,'floor',9,0),(151,1,1,0,2,'term',10,0),(152,1,1,0,2,'by_id',11,0),(153,1,1,0,2,'owner_type',12,0),(154,1,1,0,2,'with_photo',13,0),(155,1,1,0,3,'location',3,0),(156,1,1,0,3,'ap_type',4,0),(157,1,1,0,3,'obj_type',5,0),(158,1,1,0,3,'price',6,0),(159,1,1,0,3,'square',7,0),(160,1,1,0,3,'floor',8,0),(161,1,1,0,3,'term',9,0),(162,1,1,0,3,'by_id',10,0),(163,1,1,0,3,'owner_type',11,0),(164,1,1,0,3,'with_photo',12,0),(165,1,1,0,4,'location',3,0),(166,1,1,0,4,'ap_type',4,0),(167,1,1,0,4,'obj_type',5,0),(168,1,1,0,4,'price',6,0),(169,1,1,0,4,'land_square',7,0),(170,1,1,0,4,'term',8,0),(171,1,1,0,4,'by_id',9,0),(172,1,1,0,4,'owner_type',10,0),(173,1,1,0,4,'with_photo',11,0),(174,1,1,0,5,'location',3,0),(175,1,1,0,5,'ap_type',4,0),(176,1,1,0,5,'obj_type',5,0),(177,1,1,0,5,'price',6,0),(178,1,1,0,5,'term',7,0),(179,1,1,0,5,'by_id',8,0),(180,1,1,0,5,'with_photo',9,0),(197,1,1,0,6,'location',3,0),(198,1,1,0,6,'ap_type',4,0),(199,1,1,0,6,'obj_type',5,0),(200,1,1,0,6,'price',6,0),(201,1,1,0,6,'term',7,0),(202,1,1,0,6,'by_id',8,0),(203,1,1,0,6,'with_photo',9,0),(204,1,1,0,7,'location',3,0),(205,1,1,0,7,'ap_type',4,0),(206,1,1,0,7,'obj_type',5,0),(207,1,1,0,7,'booking',6,0),(208,1,1,0,7,'price',7,0),(209,1,1,0,7,'square',8,0),(210,1,1,0,7,'term',9,0),(211,1,1,0,7,'by_id',10,0),(212,1,1,0,7,'with_photo',11,0),(213,1,1,0,8,'location',3,0),(214,1,1,0,8,'ap_type',4,0),(215,1,1,0,8,'obj_type',5,0),(217,1,1,0,8,'price',7,0),(218,1,1,0,8,'square',8,0),(219,1,1,0,8,'term',9,0),(220,1,1,0,8,'by_id',10,0),(221,1,1,0,8,'with_photo',11,0),(234,1,1,0,0,'location',3,0),(235,1,1,0,0,'ap_type',4,0),(236,1,1,0,0,'obj_type',5,0),(237,1,1,0,0,'price',6,0),(238,1,1,0,0,'square',7,0),(239,1,1,0,0,'rooms',8,0),(240,1,1,0,0,'floor',9,0),(241,1,1,0,0,'term',10,0),(242,1,1,0,0,'by_id',11,0),(243,1,1,0,0,'owner_type',12,0),(244,1,1,0,0,'with_photo',13,0);
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}search_form_field_param`
--

DROP TABLE IF EXISTS `{dbPrefix}search_form_field_param`;
CREATE TABLE `{dbPrefix}search_form_field_param` (
  `field` varchar(100) NOT NULL,
  `json_data` text NOT NULL,
  UNIQUE KEY `field` (`field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `{dbPrefix}search_form_field_param`
--

LOCK TABLES `{dbPrefix}search_form_field_param` WRITE;
INSERT INTO `{dbPrefix}search_form_field_param` VALUES ('booking','{\"type_deals\":[\"1\"]}'),('location','{\"type_deals\":[\"1\",\"2\",\"3\",\"4\",\"5\"],\"locationParams\":{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"district_id\":\"0\",\"country_show\":\"1\",\"region_show\":\"1\",\"city_show\":1,\"district_show\":\"0\"}}');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}seo_friendly_url_history`
--

DROP TABLE IF EXISTS `{dbPrefix}seo_friendly_url_history`;
CREATE TABLE `{dbPrefix}seo_friendly_url_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `model_name` varchar(30) NOT NULL DEFAULT '',
  `model_id` int(11) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `url_en` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`),
  KEY `model_name` (`model_name`),
  KEY `model_name_and_id` (`model_name`,`model_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}seo_friendly_url_history`
--

LOCK TABLES `{dbPrefix}seo_friendly_url_history` WRITE;
INSERT INTO `{dbPrefix}seo_friendly_url_history` VALUES (1,'Apartment',29,'2017-09-13 09:01:17','2019-03-16 03:59:51','2-bedroom-apartment-near-mpaveleckaja'),(2,'Apartment',28,'2017-09-13 09:01:17','2019-03-16 03:59:51','apartment-near-arbatskaya-metro-station-bolshoy-afanasyevsky-lane-10'),(3,'Apartment',27,'2017-09-13 09:01:17','2019-03-16 03:59:51','1-bedroom-apartment-near-prospekt-mira-metro-station'),(4,'Apartment',26,'2017-09-13 09:01:17','2019-03-16 03:59:51','apartment-bolshaya-polyanka-st-28'),(5,'Apartment',25,'2017-09-13 09:01:17','2019-03-16 03:59:51','apartment-on-novy-arbat-st'),(6,'Apartment',24,'2017-09-13 09:01:17','2019-03-16 03:59:51','sountry-house-for-monthly-rent-in-badeevo-chekhov-moscow-oblast'),(7,'Apartment',23,'2017-09-13 09:01:17','2019-03-16 03:59:51','sountry-house-in-stolbovaya-settlement'),(8,'Apartment',22,'2017-09-13 09:01:17','2019-03-16 03:59:51','house-on-rublevskoe-highway'),(9,'Apartment',21,'2017-09-13 09:01:17','2019-03-16 03:59:51','apartment-pskovskaya-st'),(10,'Apartment',20,'2017-09-13 09:01:17','2019-03-16 03:59:51','chelobitevskoe-highway'),(11,'Apartment',19,'2017-09-13 09:01:17','2019-03-16 03:59:51','house-on-trubetskaya-st'),(12,'Apartment',18,'2017-09-13 09:01:17','2019-03-16 03:59:51','2-bedroom-apartment-aviamotornaya-st'),(13,'Entries',3,'2017-09-13 09:01:17','2019-03-16 03:59:51','manhattan-apartment-features-staircase-lined-with-20000-lego-bricks'),(14,'Entries',2,'2017-09-13 09:01:17','2019-03-16 03:59:51','best-places-to-live'),(15,'Entries',1,'2017-09-13 09:01:17','2019-03-16 03:59:51','which-items-often-get-broken-during-a-move'),(16,'Article',5,'2017-09-13 09:01:17','2019-03-16 03:59:51','best-places-for-singles'),(17,'Article',6,'2017-09-13 09:01:17','2019-03-16 03:59:51','best-places-for-families'),(18,'InfoPages',3,'2017-09-13 09:01:17','2019-03-16 03:59:51','sell'),(19,'InfoPages',2,'2017-09-13 09:01:17','2019-03-16 03:59:51','search-on-map'),(20,'InfoPages',4,'2017-09-13 09:01:17','2019-03-16 03:59:51','user-agreement'),(21,'InfoPages',5,'2017-09-13 09:01:17','2019-03-16 03:59:51','privacy-policy'),(22,'InfoPages',6,'2017-10-02 11:59:28','2019-03-16 03:59:51','rent'),(23,'InfoPages',7,'2018-03-11 09:08:43','2019-03-16 03:59:51','hotels'),(24,'InfoPages',8,'2018-03-11 09:15:44','2019-03-16 03:59:51','new-buildings'),(25,'Apartment',30,'2018-03-11 09:15:44','2019-03-16 03:59:51','sunset_hotel'),(26,'Apartment',31,'2018-03-11 09:15:44','2019-03-16 03:59:51','junior_suite'),(27,'Apartment',32,'2018-03-11 09:15:44','2019-03-16 03:59:51','lyuks'),(28,'Apartment',33,'2018-03-11 09:15:44','2019-03-16 03:59:51','residential-complex-mcr-sports'),(29,'Apartment',34,'2018-03-11 09:15:44','2019-03-16 03:59:51','2-room-apartment'),(30,'Apartment',35,'2018-03-11 09:15:44','2019-03-16 03:59:51','3-room-apartment');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}seo_friendly_url_search`
--

DROP TABLE IF EXISTS `{dbPrefix}seo_friendly_url_search`;
CREATE TABLE `{dbPrefix}seo_friendly_url_search` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `url` varchar(255) NOT NULL DEFAULT '',
  `canonical_url` varchar(255) NOT NULL DEFAULT '',
  `is_noindex` tinyint(1) NOT NULL DEFAULT 0,
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  `title_uk` varchar(255) NOT NULL DEFAULT '',
  `description_ru` varchar(255) NOT NULL DEFAULT '',
  `description_en` varchar(255) NOT NULL DEFAULT '',
  `description_de` varchar(255) NOT NULL DEFAULT '',
  `description_es` varchar(255) NOT NULL DEFAULT '',
  `description_ar` varchar(255) NOT NULL DEFAULT '',
  `description_tr` varchar(255) NOT NULL DEFAULT '',
  `description_uk` varchar(255) NOT NULL DEFAULT '',
  `keywords_ru` varchar(255) NOT NULL DEFAULT '',
  `keywords_en` varchar(255) NOT NULL DEFAULT '',
  `keywords_de` varchar(255) NOT NULL DEFAULT '',
  `keywords_es` varchar(255) NOT NULL DEFAULT '',
  `keywords_ar` varchar(255) NOT NULL DEFAULT '',
  `keywords_tr` varchar(255) NOT NULL DEFAULT '',
  `keywords_uk` varchar(255) NOT NULL DEFAULT '',
  `h1_ru` varchar(255) NOT NULL DEFAULT '',
  `h1_uk` varchar(255) NOT NULL DEFAULT '',
  `h1_en` varchar(255) NOT NULL DEFAULT '',
  `h1_de` varchar(255) NOT NULL DEFAULT '',
  `h1_es` varchar(255) NOT NULL DEFAULT '',
  `h1_ar` varchar(255) NOT NULL DEFAULT '',
  `h1_tr` varchar(255) NOT NULL DEFAULT '',
  `body_ru` text DEFAULT NULL,
  `body_uk` text DEFAULT NULL,
  `body_en` text DEFAULT NULL,
  `body_de` text DEFAULT NULL,
  `body_es` text DEFAULT NULL,
  `body_ar` text DEFAULT NULL,
  `body_tr` text DEFAULT NULL,
  `json_data` text DEFAULT NULL,
  `geo_coverage` tinyint(2) NOT NULL DEFAULT 0,
  `ap_type` varchar(6) NOT NULL DEFAULT '0',
  `obj_type_id` int(4) NOT NULL DEFAULT 0,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date_created` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `{dbPrefix}seo_friendly_url_search`
--

LOCK TABLES `{dbPrefix}seo_friendly_url_search` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}service`
--

DROP TABLE IF EXISTS `{dbPrefix}service`;
CREATE TABLE `{dbPrefix}service` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `page` text DEFAULT NULL,
  `is_offline` tinyint(1) NOT NULL DEFAULT 0,
  `allow_ip` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}service`
--

LOCK TABLES `{dbPrefix}service` WRITE;
INSERT INTO `{dbPrefix}service` VALUES (1,'<p>Closed for maintenance</p>',0,'');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}sitemap_config`
--

DROP TABLE IF EXISTS `{dbPrefix}sitemap_config`;
CREATE TABLE `{dbPrefix}sitemap_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `body_ru` longtext DEFAULT NULL,
  `body_en` longtext DEFAULT NULL,
  `body_de` longtext DEFAULT NULL,
  `body_es` longtext DEFAULT NULL,
  `body_ar` longtext DEFAULT NULL,
  `body_tr` longtext DEFAULT NULL,
  `config_json` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}sitemap_config`
--

LOCK TABLES `{dbPrefix}sitemap_config` WRITE;
INSERT INTO `{dbPrefix}sitemap_config` VALUES (1,'','','','','','','{\"removed_urls\":[]}');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}socialauth`
--

DROP TABLE IF EXISTS `{dbPrefix}socialauth`;
CREATE TABLE `{dbPrefix}socialauth` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('bool','text') NOT NULL DEFAULT 'text',
  `section` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}socialauth`
--

LOCK TABLES `{dbPrefix}socialauth` WRITE;
INSERT INTO `{dbPrefix}socialauth` VALUES (1,'bool','google_oauth','useGoogleOauth','0','2012-06-30 16:31:28'),(2,'text','google_oauth','googleOauthClientId','','2012-06-30 16:31:28'),(3,'text','google_oauth','googleOauthClientSecret','','2012-06-30 16:31:28'),(4,'bool','twitter','useTwitter','0','2012-06-30 16:31:28'),(5,'text','twitter','twitterKey','','2012-06-30 16:31:28'),(6,'text','twitter','twitterSecret','','2012-06-30 16:31:28'),(7,'bool','facebook','useFacebook','0','2012-06-30 16:31:28'),(8,'text','facebook','facebookClientId','','2012-06-30 16:31:28'),(9,'text','facebook','facebookClientSecret','','2012-06-30 16:31:28'),(10,'bool','vkontakte','useVkontakte','0','2012-06-30 16:31:28'),(11,'text','vkontakte','vkontakteClientId','','2012-06-30 16:31:28'),(12,'text','vkontakte','vkontakteClientSecret','','2012-06-30 16:31:28'),(13,'bool','mailru','useMailruOAuth','0','2012-06-30 16:31:28'),(14,'text','mailru','mailruClientId','','2012-06-30 16:31:28'),(15,'text','mailru','mailruClientSecret','','2012-06-30 16:31:28');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}themes`
--

DROP TABLE IF EXISTS `{dbPrefix}themes`;
CREATE TABLE `{dbPrefix}themes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL DEFAULT '',
  `additional_view` tinyint(4) NOT NULL DEFAULT 0,
  `color_theme` varchar(100) NOT NULL DEFAULT '',
  `bg_image` varchar(100) NOT NULL DEFAULT '',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `json_data` longtext DEFAULT NULL,
  `dataModel` varchar(100) NOT NULL DEFAULT '',
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `is_default` (`is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}themes`
--

LOCK TABLES `{dbPrefix}themes` WRITE;
INSERT INTO `{dbPrefix}themes` VALUES (2,'atlas',1,'','',1,'','','2025-03-15 10:25:23');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}translate_message`
--

DROP TABLE IF EXISTS `{dbPrefix}translate_message`;
CREATE TABLE `{dbPrefix}translate_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(150) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `message` varchar(255) NOT NULL DEFAULT '',
  `translation_en` text DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `category` (`category`),
  KEY `message` (`message`)
) ENGINE=InnoDB AUTO_INCREMENT=2244 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}translate_message`
--

LOCK TABLES `{dbPrefix}translate_message` WRITE;
INSERT INTO `{dbPrefix}translate_message` VALUES (1,'common',0,'CMS Open Real Estate','Open Real Estate CMS ','2019-03-16 09:12:09'),(2,'common',0,'Fields with <span class=\"required\">*</span> are required.','The required fields are marked with an asterisk (<span class=\"required\">*</span>).','2019-03-16 09:12:14'),(3,'common',0,'Create','Create','2019-03-16 08:37:45'),(4,'common',0,'Save','Save','2019-03-16 08:37:46'),(5,'common',0,'Add','Add','2019-03-16 08:37:47'),(6,'common',0,'Send','Book','2019-03-16 09:12:28'),(7,'common',0,'The requested page does not exist.','The requested page does not exist.','2019-03-16 09:12:31'),(8,'common',0,'References','References','2019-03-16 09:12:33'),(9,'common',0,'Uploader','Add images','2019-03-16 09:12:38'),(10,'common',0,'Upload images','Choose images','2019-03-16 09:12:42'),(11,'common',0,'Load','Upload','2019-03-16 09:12:44'),(12,'common',0,'An image with this name has been already chosen.','An image with this name has been already chosen.','2019-03-16 09:12:48'),(13,'common',0,'Incorrect image type','Incorrect image type','2019-03-16 09:12:52'),(14,'common',0,'This gallery is empty.','This gallery is empty.','2019-03-16 09:12:55'),(15,'common',0,'E-mail','E-mail','2019-03-16 09:12:59'),(16,'common',0,'Russian','Russian','2019-03-16 09:13:02'),(17,'common',0,'English','English','2019-03-16 08:38:10'),(18,'common',0,'or','or','2019-03-16 08:38:11'),(19,'common',0,'Users','Users','2019-03-16 09:13:11'),(20,'common',0,'Content is loading ...','Content is loading ...','2019-03-16 09:13:13'),(21,'common',0,'Apartment search','Property search','2019-03-16 08:38:16'),(22,'common',0,'Search','Find','2019-03-16 08:38:19'),(23,'common',0,'Inactive','Inactive','2019-03-16 09:13:22'),(24,'common',0,'Active','Active','2019-03-16 08:38:22'),(25,'common',0,'Deactivate','Deactivate','2019-03-16 09:13:27'),(26,'common',0,'Activate','Activate','2019-03-16 08:38:28'),(27,'common',0,'Search on map by metro station','Search on map by metro station','2019-03-16 09:13:35'),(28,'common',0,'Home','Home','2019-03-16 09:13:39'),(29,'common',0,'Control panel','Dashboard','2019-03-16 09:13:43'),(30,'common',0,'Login','Login','2019-03-16 08:38:35'),(31,'common',0,'Logout','Log out','2019-03-16 09:13:51'),(32,'common',0,'Already used our services? Please fill out the following form with your login credentials','Have already used our services? Please fill out the following form with your login credentials.','2019-03-16 09:13:53'),(33,'common',0,'Remember me next time','Remember me next time','2019-03-16 09:13:56'),(34,'common',0,'Password','Password','2019-03-16 08:38:44'),(35,'common',0,'Administration','Administration','2019-03-16 08:38:45'),(36,'common',0,'Site language','Site language','2019-03-16 09:14:05'),(37,'common',0,'Status','Status','2019-03-16 08:38:48'),(38,'common',0,'Go to main page','Go to Home page','2019-03-16 09:14:09'),(39,'common',0,'select','select','2019-03-16 09:14:12'),(40,'common',0,'Number of rooms','Number of bedrooms','2019-03-16 09:14:14'),(41,'common',0,'All','All','2019-03-16 08:38:57'),(42,'common',0,'Price up to','Price up to','2019-03-16 09:14:22'),(43,'common',0,'From','from','2019-03-16 09:14:26'),(44,'common',0,'to','to','2019-03-16 09:14:30'),(45,'common',0,'Incorrect username or password.','Incorrect username or password.','2019-03-16 09:14:33'),(46,'common',0,'Reserve apartment','Booking a property','2019-03-16 09:14:35'),(47,'common',0,'Your phone number','Phone number','2019-03-16 08:39:08'),(48,'common',0,'Phone number','Phone number','2019-03-16 08:39:11'),(49,'common',0,'Special offers','Special offers','2019-03-16 08:39:13'),(50,'common',0,'Special offer!','Special offer!','2019-03-16 09:14:48'),(51,'common',0,'Is avaliable','Is avaliable','2019-03-16 09:14:51'),(52,'common',0,'Contact us','Contact us','2019-03-16 09:14:55'),(53,'common',0,'Special offer','Special offer','2019-03-16 09:14:59'),(54,'common',0,'Forgot password?','Have forgotten your password?','2019-03-16 09:15:02'),(55,'common',0,'Recover password','Password recovering','2019-03-16 08:39:25'),(56,'common',0,'Recover','Recover','2019-03-16 09:15:09'),(57,'common',0,'Email','Email','2019-03-16 08:39:31'),(58,'common',0,'User does not exist','User with such an email does not exist','2019-03-16 09:15:16'),(59,'common',0,'Reference \"Check-in\"','Reference \"Check-in\"','2019-03-16 09:15:20'),(60,'common',0,'Reference \"Check-out\"','Reference \"Check-out\"','2019-03-16 09:15:22'),(61,'common',0,'I want','I\'d like to','2019-03-16 09:15:26'),(62,'common',0,'rent apartment','rent a property','2019-03-16 09:15:29'),(63,'common',0,'buy apartment','buy a property','2019-03-16 09:15:34'),(64,'common',0,'Loading ...','Loading ...','2019-03-16 08:39:47'),(65,'common',0,'Floor','Floor','2019-03-16 09:15:40'),(66,'common',0,'Flat on floor','Flat on floor','2019-03-16 09:15:43'),(67,'common',0,'Apartment square to','Square up to','2019-03-16 09:15:46'),(68,'common',0,'Square range','Square range','2019-03-16 09:15:48'),(69,'common',0,'Floor range','Floor range','2019-03-16 09:15:52'),(70,'common',0,'Rooms range','Bedrooms range','2019-03-16 09:15:55'),(71,'common',0,'Price range','Price range','2019-03-16 08:39:58'),(72,'common',0,'More options','More options','2019-03-16 08:40:01'),(73,'common',0,'Less options','Less options','2019-03-16 09:16:06'),(74,'common',0,'Registration','Registration','2019-03-16 09:16:08'),(75,'common',0,'Join now','Sign up','2019-03-16 09:16:11'),(76,'common',0,'Login (email)','Login (email)','2019-03-16 09:16:14'),(77,'common',0,'Verify Code','Verify code','2019-03-16 08:40:14'),(78,'common',0,'Activate account','Account activation ','2019-03-16 09:16:19'),(79,'common',0,'Your status account already is active','Your account has been already activated','2019-03-16 09:16:22'),(80,'common',0,'User not exists','The user does not exist','2019-03-16 09:16:25'),(81,'common',0,'Your account successfully activated','Your account has been successfully activated','2019-03-16 09:16:28'),(82,'common',0,'You were successfully registered. The letter for account activation has been sent on {useremail}','You are successfully registered. To activate your account, please click the link in the activation email which has been sent to {useremail}.','2019-03-16 09:16:31'),(83,'common',0,'Error. Repeat attempt later','Error. Please try again later.','2019-03-16 09:16:36'),(84,'common',0,'Your account not active. The reasons: you not followed the link in the letter which has been sent at registration. Or administrator deactivate your account','Your account is not active. The reasons are that you have not followed the link in the activation email in your mailbox or the administrator has deactivated your account.','2019-03-16 09:16:40'),(85,'common',0,'rent by the day','rent by the day','2019-03-16 09:16:44'),(86,'common',0,'rent by the hour','rent by the hour','2019-03-16 09:16:46'),(87,'common',0,'rent by the month','rent by the month','2019-03-16 09:16:49'),(88,'common',0,'rent by the week','rent by the week','2019-03-16 09:16:52'),(89,'common',0,'sale','sale','2019-03-16 09:16:55'),(90,'common',0,'Payment to','Price up to','2019-03-16 09:16:59'),(91,'common',0,'Fee up to','Payment up to','2019-03-16 09:17:03'),(92,'common',0,'City','City','2019-03-16 09:17:08'),(93,'common',0,'With selected','With a tick','2019-03-16 09:17:10'),(94,'common',0,'Do','ОК','2019-03-16 09:17:12'),(95,'common',0,'Are you sure?','Are you sure?','2019-03-16 09:17:15'),(96,'common',0,'Property type','Property type','2019-03-16 09:17:18'),(97,'common',0,'Please select','Please, select','2019-03-16 09:17:20'),(98,'common',0,'Delete','Delete','2019-03-16 09:17:22'),(99,'common',0,'There are new product news','Read news about the product','2019-03-16 09:17:25'),(100,'common',0,'{n} news','{n} news','2019-03-16 09:17:27'),(101,'module_adminpass',0,'Change admin password','Change admin password','2019-03-16 09:17:32'),(102,'module_adminpass',0,'Current administrator password','Current admin password','2019-03-16 09:17:35'),(103,'module_adminpass',0,'Wrong admin password! Try again.','Wrong admin password! Please try again.','2019-03-16 09:17:38'),(104,'module_apartmentCity',0,'Manage apartment city','Reference \"City/Cities\"','2019-03-16 09:17:42'),(105,'module_apartmentCity',0,'Add city','Add a city','2019-03-16 09:17:44'),(106,'module_apartmentCity',0,'Edit city','Edit the city','2019-03-16 09:17:48'),(107,'module_apartmentCity',0,'Name','City name','2019-03-16 09:17:50'),(108,'module_apartmentObjType',0,'Manage apartment object types','Reference \"Property types\"','2019-03-16 09:17:54'),(109,'module_apartmentObjType',0,'Add object type','Add a property type','2019-03-16 09:17:58'),(110,'module_apartmentObjType',0,'Name','Name','2019-03-16 09:18:03'),(111,'module_apartmentObjType',0,'Edit object type','Edit the property type','2019-03-16 09:18:07'),(112,'module_apartmentObjType',0,'Apartment object types','Property types','2019-03-16 09:18:09'),(113,'module_apartments',0,'Apartments list','Listings','2019-03-16 09:18:12'),(114,'module_apartments',0,'{n} bedroom|{n} bedrooms|{n} bedrooms','{n} bedroom|{n} bedrooms|{n} bedrooms','2019-03-16 09:18:14'),(115,'module_apartments',0,'{n} floor of {total} total','{n} floor of {total} total','2019-03-16 09:18:18'),(116,'module_apartments',0,'Total square','Total square','2019-03-16 09:18:20'),(117,'module_apartments',0,'total square','total square','2019-03-16 09:18:24'),(118,'module_apartments',0,'Manage apartments','Listings','2019-03-16 09:18:28'),(119,'module_apartments',0,'Delete apartment','Delete the listing','2019-03-16 09:18:31'),(120,'module_apartments',0,'ID','ID','2019-03-16 09:18:33'),(121,'module_apartments',0,'Apartment title','Listing title','2019-03-16 09:18:36'),(122,'module_apartments',0,'Status','Status','2019-03-16 09:18:39'),(123,'module_apartments',0,'Deactivate','Deactivate','2019-03-16 09:18:43'),(124,'module_apartments',0,'Activate','Activate','2019-03-16 09:18:47'),(125,'module_apartments',0,'Price','Price','2019-03-16 09:18:49'),(126,'module_apartments',0,'Number of rooms','Number of bedrooms','2019-03-16 09:18:52'),(127,'module_apartments',0,'Number of berths','Number of beds','2019-03-16 09:18:56'),(128,'module_apartments',0,'Square','Square','2019-03-16 09:18:58'),(129,'module_apartments',0,'Floor','Floor','2019-03-16 09:19:00'),(130,'module_apartments',0,'Total number of floors','Total number of floors','2019-03-16 09:19:03'),(131,'module_apartments',0,'Window to','View','2019-03-16 09:19:08'),(132,'module_apartments',0,'Metro station','Metro station','2019-03-16 09:19:10'),(133,'module_apartments',0,'Update apartment','Edit the listing','2019-03-16 09:19:14'),(134,'module_apartments',0,'Active','Active','2019-03-16 09:19:18'),(135,'module_apartments',0,'Inactive','Inactive','2019-03-16 09:19:21'),(136,'module_apartments',0,'Special offer','Special offer','2019-03-16 09:19:23'),(137,'module_apartments',0,'Apartment ID','Listing ID','2019-03-16 09:19:28'),(138,'module_apartments',0,'Add apartment','List your property','2019-03-16 09:19:31'),(139,'module_apartments',0,'Apartments list is empty.','No listings yet.','2019-03-16 09:19:34'),(140,'module_apartments',0,'Price from','Price','2019-03-16 09:19:37'),(141,'module_apartments',0,'Description','Description','2019-03-16 09:19:41'),(142,'module_apartments',0,'Near','Near','2019-03-16 09:19:45'),(143,'module_apartments',0,'Metro','Metro','2019-03-16 09:19:48'),(144,'module_apartments',0,'Address','Address','2019-03-16 09:19:50'),(145,'module_apartments',0,'berths','berths','2019-03-16 09:19:53'),(146,'module_apartments',0,'Booking','Booking','2019-03-16 09:19:57'),(147,'module_apartments',0,'Is free from','is valid from','2019-03-16 09:20:00'),(148,'module_apartments',0,'to','until','2019-03-16 09:20:04'),(149,'module_apartments',0,'Type','Type','2019-03-16 09:20:07'),(150,'module_apartments',0,'All','All','2019-03-16 09:20:09'),(151,'module_apartments',0,'Sale price','Sale','2019-03-16 09:20:13'),(152,'module_apartments',0,'Price per hour','per hour','2019-03-16 09:20:16'),(153,'module_apartments',0,'Price per day','per day','2019-03-16 09:20:20'),(154,'module_apartments',0,'Price per week','per week','2019-03-16 09:20:24'),(155,'module_apartments',0,'Price per month','per month','2019-03-16 09:20:28'),(156,'module_apartments',0,'(press and hold SHIFT button for multiply select)','(press and hold the SHIFT key for multiple selection)','2019-03-16 09:20:31'),(157,'module_apartments',0,'Nearest metro stations','The nearest metro stations','2019-03-16 09:20:34'),(158,'module_apartments',0,'Object type','Property type','2019-03-16 09:20:36'),(159,'module_apartments',0,'All object','All property types','2019-03-16 09:20:38'),(160,'module_apartments',0,'type_view_1','is for rent','2019-03-16 09:20:41'),(161,'module_apartments',0,'type_view_2','for sale','2019-03-16 09:20:45'),(162,'module_apartments',0,'City','City','2019-03-16 09:20:50'),(163,'module_articles',0,'Q&As','Q&As','2019-03-16 09:20:52'),(164,'module_articles',0,'Title / Question','Title / Question','2019-03-16 09:20:56'),(165,'module_articles',0,'Body / Answer','Text / Answer','2019-03-16 09:20:59'),(166,'module_articles',0,'Last updated on','Last updated on','2019-03-16 09:21:02'),(167,'module_articles',0,'FAQ','Q&As','2019-03-16 09:21:05'),(168,'module_articles',0,'Ok','Ok','2019-03-16 09:21:07'),(169,'module_articles',0,'Add FAQ','Add an Q&A','2019-03-16 09:21:09'),(170,'module_articles',0,'Update FAQ','Edit the Q&A','2019-03-16 09:21:12'),(171,'module_articles',0,'Language','Language','2019-03-16 09:21:14'),(172,'module_articles',0,'Status','Status','2019-03-16 09:21:17'),(173,'module_articles',0,'Read more &raquo;','Read more &raquo;','2019-03-16 09:21:19'),(174,'module_articles',0,'Delete FAQ','Delete the Q&A','2019-03-16 09:21:21'),(175,'module_booking',0,'Check-in date','Check-In Date','2019-03-16 09:21:24'),(176,'module_booking',0,'Check-out date','Check-Out Date','2019-03-16 09:21:27'),(177,'module_booking',0,'Check-in time','Check-In Time','2019-03-16 09:21:30'),(178,'module_booking',0,'Check-out time','Check-Out Time','2019-03-16 09:21:33'),(179,'module_booking',0,'Comment','Comment','2019-03-16 09:21:36'),(180,'module_booking',0,'Your name','Your name','2019-03-16 09:21:40'),(181,'module_booking',0,'Wrong check-in date','Wrong Check-In Date','2019-03-16 09:21:44'),(182,'module_booking',0,'Wrong check-out date','Wrong Check-Out Date','2019-03-16 09:21:48'),(183,'module_booking',0,'User with such e-mail already registered. Please <a title=\"Login\" href=\"{n}\">login</a> and try again.','A user with such an e-mail is already registered. Please <a title=\"Login\" href=\"{n}\">login</a> and try again.','2019-03-16 13:36:48'),(184,'module_booking',0,'Status','Status','2019-03-16 09:21:54'),(185,'module_booking',0,'User e-mail','User e-mail','2019-03-16 09:21:56'),(186,'module_booking',0,'Creation date','Date of creation','2019-03-16 09:21:59'),(187,'module_booking',0,'Apartment ID','Listing ID','2019-03-16 09:22:03'),(188,'module_booking',0,'User name','User name','2019-03-16 09:22:06'),(189,'module_comments',0,'Comments','Comments','2019-03-16 09:22:10'),(190,'module_comments',0,'Comment','Comment','2019-03-16 09:22:12'),(191,'module_comments',0,'Rate','Rate','2019-03-16 09:22:15'),(192,'module_comments',0,'Status','Status','2019-03-16 09:22:19'),(193,'module_comments',0,'Creation date','Creation date','2019-03-16 09:22:21'),(194,'module_comments',0,'Name','Name','2019-03-16 09:22:23'),(195,'module_comments',0,'Email','Email','2019-03-16 09:22:27'),(196,'module_comments',0,'Apartment','Apartment','2019-03-16 09:22:30'),(197,'module_comments',0,'Apartment_id','Listing ID','2019-03-16 09:22:33'),(198,'module_comments',0,'says about','says about','2019-03-16 09:22:36'),(199,'module_comments',0,'Pending approval','Awaiting approval','2019-03-16 09:22:40'),(200,'module_comments',0,'Approve','Approve','2019-03-16 09:22:43'),(201,'module_comments',0,'Update','Update','2019-03-16 09:22:45'),(202,'module_comments',0,'Update Comment #{id}','Edit the comment #{id}','2019-03-16 09:22:49'),(203,'module_comments',0,'Leave a Comment','Leave a Comment','2019-03-16 09:22:52'),(204,'module_comments',0,'Thank you for your comment. Your comment will be posted once it is approved.','Thanks for your comment. All comments are moderated and will not appear until approved by the site adminstration.','2019-03-16 09:22:55'),(205,'module_comments',0,'There are no comments','There are no comments yet','2019-03-16 09:22:57'),(206,'module_configuration',0,'Settings','Settings','2019-03-16 09:22:59'),(207,'module_configuration',0,'Name','Name','2019-03-16 09:23:02'),(208,'module_configuration',0,'Value','Value','2019-03-16 09:23:05'),(209,'module_configuration',0,'Manage settings','Settings','2019-03-16 09:23:09'),(210,'module_configuration',0,'Update param \"{name}\"','Edit parameter \"{name}\"','2019-03-16 09:23:13'),(211,'module_configuration',0,'main','Home','2019-03-16 09:23:15'),(212,'module_configuration',0,'gmap','Google maps','2019-03-16 09:23:18'),(213,'module_configuration',0,'ymap','Yandex maps','2019-03-16 09:23:23'),(214,'module_configuration',0,'cache','Cache','2019-03-16 09:23:27'),(215,'module_configuration',0,'search','Search','2019-03-16 09:23:29'),(216,'module_configuration',0,'notifier','Notifier','2019-03-16 09:23:33'),(217,'module_configuration',0,'apartment','Listings','2019-03-16 09:23:36'),(218,'module_configuration',0,'slider','The \"sliders\" in the Search form','2019-03-16 09:23:41'),(219,'module_contactform',0,'Contact Us','Contact us!','2019-03-16 09:23:44'),(220,'module_contactform',0,'Name','Name','2019-03-16 09:23:47'),(221,'module_contactform',0,'Email','Email','2019-03-16 09:23:51'),(222,'module_contactform',0,'Subject','Subject','2019-03-16 09:23:56'),(223,'module_contactform',0,'Body','Message','2019-03-16 09:24:00'),(224,'module_contactform',0,'Verification Code','Verification Code','2019-03-16 09:24:03'),(225,'module_contactform',0,'Phone','Phone','2019-03-16 09:24:06'),(226,'module_contactform',0,'Address','Address','2019-03-16 09:24:08'),(227,'module_contactform',0,'Skype','Skype','2019-03-16 03:59:50'),(228,'module_contactform',0,'ICQ','ICQ','2019-03-16 03:59:50'),(229,'module_contactform',0,'You can fill out the form below to contact us.','You can fill out the form below to contact us.','2019-03-16 09:24:16'),(230,'module_contactform',0,'Send message','Send','2019-03-16 09:24:20'),(231,'module_payment',0,'Payment','Payment','2019-03-16 09:24:25'),(232,'module_payment',0,'Payment System Settings','Payment systems','2019-03-16 09:24:29'),(233,'module_payment',0,'Payments','Payments','2019-03-16 09:24:33'),(234,'module_payment',0,'Wait for payment','Waiting for payment','2019-03-16 09:24:36'),(235,'module_payment',0,'Payment complete','Payment is completed','2019-03-16 09:24:39'),(236,'module_payment',0,'Payment declined','Payment is declined','2019-03-16 09:24:44'),(237,'module_payment',0,'Amount','Amount','2019-03-16 09:24:47'),(238,'module_payment',0,'Payment date','Payment date','2019-03-16 09:24:50'),(239,'module_payment',0,'Booking #','Booking #','2019-03-16 09:24:52'),(240,'module_payment',0,'Login','Login','2019-03-16 09:24:54'),(241,'module_payment',0,'Password1','Password1','2019-03-16 03:59:50'),(242,'module_payment',0,'Password2','Password2','2019-03-16 09:25:00'),(243,'module_payment',0,'Currency','Currency','2019-03-16 09:25:02'),(244,'module_payment',0,'Mode','Mode','2019-03-16 09:25:04'),(245,'module_payment',0,'Status','Status','2019-03-16 09:25:09'),(246,'module_payment',0,'Pending','Pending','2019-03-16 09:25:13'),(247,'module_payment',0,'Active','Active','2019-03-16 09:25:15'),(248,'module_payment',0,'Inactive','Inactive','2019-03-16 09:25:17'),(249,'module_payment',0,'Real mode','Real mode','2019-03-16 09:25:22'),(250,'module_payment',0,'Test mode','Test mode','2019-03-16 09:25:25'),(251,'module_quicksearch',0,'Number of rooms','Number of bedrooms','2019-03-16 09:25:27'),(252,'module_quicksearch',0,'Sorting by price','Sort by price','2019-03-16 09:25:30'),(253,'module_referencecategories',0,'Manage reference categories','Categories of references','2019-03-16 09:25:35'),(254,'module_referencecategories',0,'Add reference category','Add a category','2019-03-16 09:25:39'),(255,'module_referencecategories',0,'Add category','Add a category','2019-03-16 09:25:42'),(256,'module_referencecategories',0,'Edit category:','Edit the category','2019-03-16 09:25:46'),(257,'module_referencecategories',0,'Delete category','Delete the category','2019-03-16 09:25:50'),(258,'module_referencecategories',0,'Category','Categories','2019-03-16 09:25:53'),(259,'module_referencecategories',0,'Display style','Display as','2019-03-16 09:25:57'),(260,'module_referencecategories',0,'1 column','1 column','2019-03-16 09:26:00'),(261,'module_referencecategories',0,'2 columns','2 columns','2019-03-16 09:26:04'),(262,'module_referencecategories',0,'3 columns','3 columns','2019-03-16 09:26:06'),(263,'module_referencecategories',0,'Categories of references','Categories of references','2019-03-16 09:26:08'),(264,'module_referencevalues',0,'Create reference value','Add a value','2019-03-16 09:26:12'),(265,'module_referencevalues',0,'Category','Category','2019-03-16 09:26:16'),(266,'module_referencevalues',0,'Manage reference values','Values of references','2019-03-16 09:26:21'),(267,'module_referencevalues',0,'Reference','Reference','2019-03-16 09:26:25'),(268,'module_referencevalues',0,'Update reference','Edit the value','2019-03-16 09:26:28'),(269,'module_referencevalues',0,'Delete reference value','Delete the value','2019-03-16 09:26:30'),(270,'module_referencevalues',0,'Reference category','Сategory of references','2019-03-16 09:26:34'),(271,'module_referencevalues',0,'Values of references','Values of references','2019-03-16 09:26:38'),(272,'module_referencevalues',0,'Create value','Add a value','2019-03-16 09:26:40'),(273,'module_referencevalues',0,'For sale','For sale','2019-03-16 09:26:44'),(274,'module_referencevalues',0,'For rent','For rent','2019-03-16 09:26:47'),(275,'module_similarads',0,'Similar ads','Similar listings','2019-03-16 09:26:52'),(276,'module_sitemap',0,'Site map','Site map','2019-03-16 09:26:54'),(277,'module_sitemap',0,'index_page','Home','2019-03-16 09:26:56'),(278,'module_sitemap',0,'contact_form','Contact us','2019-03-16 09:26:59'),(279,'module_sitemap',0,'booking_form','Booking a property','2019-03-16 09:27:02'),(280,'module_sitemap',0,'quick_search','Search','2019-03-16 09:27:07'),(281,'module_sitemap',0,'special_offers','Special offers','2019-03-16 09:27:10'),(282,'module_sitemap',0,'section_article','Q&A','2019-03-16 09:27:13'),(283,'module_sitemap',0,'section_news','News','2019-03-16 09:27:15'),(284,'module_sitemap',0,'section_infopage','More','2019-03-16 09:27:17'),(285,'module_slider',0,'Manage slider','Slide-show on the Home page','2019-03-16 09:27:22'),(286,'module_slider',0,'The file was larger than {size}MB. Please upload a smaller file.','File\'s size is larger than {size}MB. Please upload a file with smaller size.','2019-03-16 09:27:26'),(287,'module_slider',0,'Add image','Add an image','2019-03-16 09:27:29'),(288,'module_slider',0,'Image title','Image title','2019-03-16 09:27:32'),(289,'module_slider',0,'Image url','Image url','2019-03-16 09:27:36'),(290,'module_slider',0,'Date updated','Last updated on','2019-03-16 09:27:38'),(291,'module_slider',0,'Image succesfullty added to slider.','Image is succesfullty added to slide-show.','2019-03-16 09:27:40'),(292,'module_slider',0,'Supported file: {supportExt}.','Supported types of files: {supportExt}.','2019-03-16 09:27:43'),(293,'module_slider',0,'Image','Image','2019-03-16 09:27:45'),(294,'module_slider',0,'Use Philips Ambilight effect','Use \"Philips Ambilight\" effect','2019-03-16 09:27:48'),(295,'module_slider',0,'This option is only available if PHP is compiled with bundled support for GD library, becouse use imagefilter php function.','This option is available if PHP is compiled with bundled support for GD library, because imagefilter php function is needed.','2019-03-16 09:27:52'),(296,'module_specialoffers',0,'Special offer','Special offer','2019-03-16 09:27:56'),(297,'module_specialoffers',0,'Special offers','Special offers','2019-03-16 09:28:00'),(298,'module_usercpanel',0,'Control panel','Control panel','2019-03-16 09:28:03'),(299,'module_usercpanel',0,'Change','Change','2019-03-16 09:35:59'),(300,'module_usercpanel',0,'Your details successfully changed.','Your contact info has been successfully changed.','2019-03-16 09:36:00'),(301,'module_usercpanel',0,'Change your password','Change your password','2019-03-16 09:36:00'),(302,'module_usercpanel',0,'Your password successfully changed.','Your password is successfully changed.','2019-03-16 09:36:00'),(303,'module_usercpanel',0,'Enter new password','Enter new password','2019-03-16 09:36:00'),(304,'module_usercpanel',0,'Repeat password','Repeat password','2019-03-16 09:36:01'),(305,'module_usercpanel',0,'Your name','Your name','2019-03-16 09:36:01'),(306,'module_usercpanel',0,'Passwords are not equivalent! Try again.','Passwords are not the same! Try again.','2019-03-16 09:36:01'),(307,'module_usercpanel',0,'Password too short! Minimum allowed length is 6 chars.','Password is too short! Minimum 6 characters in length are required.','2019-03-16 09:36:01'),(308,'module_usercpanel',0,'Your e-mail','Your e-mail','2019-03-16 09:36:02'),(309,'module_users',0,'Add user','Add a user','2019-03-16 09:36:02'),(310,'module_users',0,'E-mail','E-mail','2019-03-16 09:36:02'),(311,'module_users',0,'User name','User name','2019-03-16 09:36:02'),(312,'module_users',0,'Password','Password','2019-03-16 09:36:02'),(313,'module_users',0,'Edit user','Edit the user','2019-03-16 09:36:03'),(314,'module_users',0,'Delete user','Delete the user','2019-03-16 09:36:03'),(315,'module_users',0,'Status','Status','2019-03-16 09:36:03'),(316,'module_users',0,'Active','Active','2019-03-16 09:36:03'),(317,'module_users',0,'Inactive','Inactive','2019-03-16 09:36:03'),(318,'module_windowto',0,'Manage reference (window to..)','Reference \"View:\"','2019-03-16 09:36:04'),(319,'module_windowto',0,'Manage reference','Reference \"Check-in\" and Reference \"Check-out\"','2019-03-16 09:36:04'),(320,'module_windowto',0,'Add value','Add a value','2019-03-16 09:36:04'),(321,'module_windowto',0,'Value','Value','2019-03-16 09:36:04'),(322,'module_windowto',0,'Update value','Edit the value','2019-03-16 09:36:04'),(323,'module_windowto',0,'Delete value','Delete the value','2019-03-16 09:36:05'),(324,'module_windowto',0,'Reference \"View:\"','Reference \"View:\"','2019-03-16 09:36:05'),(325,'module_apartments',0,'title','Title','2019-03-16 03:59:50'),(326,'module_translateMessage',0,'Manage lang messages','Translations','2019-03-16 09:36:05'),(327,'module_translateMessage',0,'Manage langs','Translations','2019-03-16 09:36:05'),(328,'module_translateMessage',0,'Edit lang message:','Edit the translation','2019-03-16 09:36:05'),(329,'module_translateMessage',0,'Add message','Add a translation','2019-03-16 09:36:06'),(330,'common',0,'Manage langs','Translations','2019-03-16 09:36:06'),(331,'module_apartments',0,'window to','View','2019-03-16 09:36:06'),(332,'common',0,'Manage news','News ','2019-03-16 09:36:06'),(333,'common',0,'Manage FAQ','Q&As','2019-03-16 09:36:07'),(334,'common',0,'Change admin password','Change admin password','2019-03-16 09:36:07'),(335,'common',0,'Settings','Settings','2019-03-16 09:36:07'),(336,'common',0,'Import / Export','Import / Export','2019-03-16 09:36:07'),(337,'common',0,'Manage slider','Slide-show','2019-03-16 09:36:08'),(338,'common',0,'News product','Product\'s news','2019-03-16 09:36:08'),(339,'common',0,'Add ad','List your property','2019-03-16 09:36:08'),(340,'common',0,'Search in section','Section','2019-03-16 09:36:08'),(341,'module_currency',0,'Manage currency','Currencies','2019-03-16 09:36:08'),(342,'module_currency',0,'AUD_translate','Australian Dollar','2019-03-16 09:36:09'),(343,'module_currency',0,'AZN_translate','Azerbaijani manat','2019-03-16 09:36:09'),(344,'module_currency',0,'GBP_translate','Pound sterling','2019-03-16 09:36:09'),(345,'module_currency',0,'AMD_translate','Armenian dram','2019-03-16 09:36:09'),(346,'module_currency',0,'BYR_translate','Belarusian ruble','2019-03-16 09:36:10'),(347,'module_currency',0,'BGN_translate','Bulgarian lev','2019-03-16 09:36:10'),(348,'module_currency',0,'BRL_translate','Brazilian real','2019-03-16 09:36:10'),(349,'module_currency',0,'HUF_translate','Hungarian forint','2019-03-16 09:36:10'),(350,'module_currency',0,'DKK_translate','Danish krone','2019-03-16 09:36:10'),(351,'module_currency',0,'USD_translate','$','2019-03-16 03:59:50'),(352,'module_currency',0,'EUR_translate','EUR','2019-03-16 09:36:11'),(353,'module_currency',0,'INR_translate','Indian Rupee','2019-03-16 09:36:11'),(354,'module_currency',0,'KZT_translate','Kazakhstani tenge','2019-03-16 09:36:11'),(355,'module_currency',0,'CAD_translate','Canadian dollar','2019-03-16 09:36:11'),(356,'module_currency',0,'KGS_translate','Kyrgyzstani som','2019-03-16 09:36:12'),(357,'module_currency',0,'CNY_translate','Chinese Yuan','2019-03-16 09:36:12'),(358,'module_currency',0,'LVL_translate','Latvian lat','2019-03-16 09:36:12'),(359,'module_currency',0,'LTL_translate','Lithuanian lita','2019-03-16 09:36:12'),(360,'module_currency',0,'MDL_translate','Moldovan leu','2019-03-16 09:36:12'),(361,'module_currency',0,'NOK_translate','Norwegian krone','2019-03-16 09:36:13'),(362,'module_currency',0,'PLN_translate','Polish zloty','2019-03-16 09:36:13'),(363,'module_currency',0,'RON_translate','New Romanian leu','2019-03-16 09:36:13'),(364,'module_currency',0,'XDR_translate','Special Drawing Rights (SDR)','2019-03-16 09:36:13'),(365,'module_currency',0,'SGD_translate','Singapore dollar','2019-03-16 09:36:13'),(366,'module_currency',0,'TJS_translate','Tajikistani ruble','2019-03-16 09:36:14'),(367,'module_currency',0,'TRY_translate','Turkish lira','2019-03-16 09:36:14'),(368,'module_currency',0,'TMT_translate','New Turkmenistan manat','2019-03-16 09:36:14'),(369,'module_currency',0,'UZS_translate','Uzbekistan sum','2019-03-16 09:36:14'),(370,'module_currency',0,'UAH_translate','Ukrainian hryvnia','2019-03-16 09:36:14'),(371,'module_currency',0,'CZK_translate','Czech koruna','2019-03-16 09:36:15'),(372,'module_currency',0,'SEK_translate','Swedish krona','2019-03-16 09:36:15'),(373,'module_currency',0,'CHF_translate','Swiss franc','2019-03-16 09:36:15'),(374,'module_currency',0,'ZAR_translate','South.African rand','2019-03-16 09:36:15'),(375,'module_currency',0,'KRW_translate','South Korean won','2019-03-16 09:36:15'),(376,'module_currency',0,'JPY_translate','Japanese yen','2019-03-16 09:36:16'),(377,'module_currency',0,'RUB_translate','RUB','2019-03-16 09:36:16'),(378,'module_lang',0,'Manage lang','Languages','2019-03-16 09:36:16'),(379,'module_lang',0,'Update lang','Edit the language','2019-03-16 09:36:16'),(380,'module_lang',0,'Create new lang','Add a new language','2019-03-16 09:36:17'),(381,'module_lang',0,'Name ISO','Language code ISO 639-1','2019-03-16 09:36:17'),(382,'common',0,'Currency','Currency','2019-03-16 09:36:17'),(383,'common',0,'Listings','Listings','2019-03-16 09:36:17'),(384,'common',0,'List your property','List your property','2019-03-16 09:36:18'),(385,'common',0,'Comments','Comments','2019-03-16 09:36:18'),(386,'common',0,'Categories of references','Categories of references','2019-03-16 09:36:18'),(387,'common',0,'Values of references','Values of references','2019-03-16 09:36:18'),(388,'common',0,'Reference (window to..)','Reference \"View:\"','2019-03-16 09:36:18'),(389,'common',0,'Payments','Payments','2019-03-16 09:36:19'),(390,'common',0,'Payment systems','Payment systems','2019-03-16 09:36:19'),(391,'common',0,'Content','Content','2019-03-16 09:36:19'),(392,'common',0,'News','News','2019-03-16 09:36:19'),(393,'common',0,'Top menu items','Menu items','2019-03-16 09:36:19'),(394,'common',0,'Modules','Modules','2019-03-16 09:36:20'),(395,'common',0,'Slide-show on the Home page','Slide-show on the Home page','2019-03-16 09:36:20'),(396,'common',0,'Translations','Translations','2019-03-16 09:36:20'),(397,'common',0,'Reference \"Property types\"','Reference \"Property types\"','2019-03-16 09:36:20'),(398,'common',0,'Reference \"City/Cities\"','Reference \"City/Cities\"','2019-03-16 09:36:20'),(399,'common',0,'Log out','Log out','2019-03-16 09:36:21'),(400,'common',0,'Sections','Sections','2019-03-16 09:36:21'),(401,'common',0,'Menu','Menu','2019-03-16 09:36:21'),(402,'common',0,'Change','Change','2019-03-16 09:36:21'),(403,'module_translateMessage',0,'category','Category','2019-03-16 09:36:21'),(404,'common',0,'Language','Language','2019-03-16 09:36:22'),(405,'common',0,'Last updated on','Last updated on','2019-03-16 09:36:22'),(406,'common',0,'Languages','Languages','2019-03-16 09:36:22'),(407,'common',0,'Languages and currency','Languages and currency','2019-03-16 09:36:22'),(408,'common',0,'Currencies','Currencies','2019-03-16 09:36:23'),(409,'module_booking',0,'Email','E-mail','2019-03-16 09:36:23'),(410,'common',0,'Awaiting moderation','Awaiting moderation','2019-03-16 09:36:23'),(411,'common',0,'administrator','Administrator','2019-03-16 09:36:23'),(412,'common',0,'Name','Name','2019-03-16 09:36:23'),(413,'module_menumanager',0,'Add menu item','Add a top menu item','2019-03-16 09:36:24'),(414,'module_menumanager',0,'Manage menu items','Top menu items','2019-03-16 09:36:24'),(415,'common',0,'Move an item down','Move an item down','2019-03-16 09:36:24'),(416,'common',0,'Move an item up','Move an item up','2019-03-16 09:36:24'),(417,'common',0,'Are you sure you want to delete this item?','Are you sure you want to delete this item?','2019-03-16 09:36:25'),(418,'common',0,'Close','Close','2019-03-16 09:36:25'),(419,'module_configuration',0,'Enter the required value','Enter the required value','2019-03-16 09:36:25'),(420,'common',0,'Other','Other','2019-03-16 09:36:25'),(421,'common',0,'News about Open Real Estate CMS','Open Real Estate news','2019-03-16 09:36:25'),(422,'common',0,'Seo settings','Seo settings','2019-03-16 09:36:26'),(423,'module_seo',0,'siteName','{siteName}','2019-03-16 03:59:50'),(424,'module_seo',0,'siteKeywords','{siteKeywords}','2019-03-16 03:59:50'),(425,'module_seo',0,'siteDescription','{siteDescription}','2019-03-16 03:59:50'),(426,'module_seo',0,'Update date','Last updated on','2019-03-16 09:36:26'),(427,'module_seo',0,'Name','Name','2019-03-16 09:36:27'),(428,'module_seo',0,'Value','Value','2019-03-16 09:36:27'),(429,'module_seo',0,'Manage SEO settings','SEO settings','2019-03-16 09:36:27'),(430,'module_seo',0,'Edit value','Edit the value','2019-03-16 09:36:27'),(431,'module_lang',0,'Manage langs','Languages','2019-03-16 09:36:27'),(432,'module_lang',0,'Add lang','Add a language','2019-03-16 09:36:28'),(433,'module_lang',0,'Name Iso','Language code ISO 639-1','2019-03-16 09:36:28'),(434,'module_lang',0,'Activity','Activity','2019-03-16 09:36:28'),(435,'module_lang',0,'Copy lang from','Copy data from','2019-03-16 09:36:28'),(436,'module_configuration',0,'Section','Section','2019-03-16 09:36:28'),(437,'module_configuration',0,'Setting','Setting','2019-03-16 09:36:29'),(438,'module_currency',0,'Nominal','Nominal','2019-03-16 09:36:29'),(439,'module_currency',0,'Value','Value','2019-03-16 09:36:29'),(440,'module_currency',0,'Is Default','By default','2019-03-16 09:36:29'),(441,'common',0,'Date updated','Last updated on','2019-03-16 09:36:29'),(442,'module_currency',0,'Set the default currency','Set the default currency','2019-03-16 09:36:30'),(443,'module_currency',0,'Enter the required value','Enter the required value','2019-03-16 09:36:30'),(444,'module_currency',0,'This is the default currency','This is the default currency','2019-03-16 09:36:30'),(445,'module_currency',0,'Convert the data in this currency?','Convert the currency','2019-03-16 09:36:30'),(446,'module_currency',0,'Set default','Set as default','2019-03-16 09:36:30'),(447,'common',0,'Currency','Currency','2019-03-16 09:36:31'),(448,'common',0,'Users','Users','2019-03-16 09:36:31'),(449,'module_booking',0,'Status','Status','2019-03-16 09:36:31'),(450,'common',0,'Additional info','Additional info','2019-03-16 09:36:31'),(451,'module_apartments',0,'What is near?','What is near?','2019-03-16 09:36:31'),(452,'common',0,'select city','Select a city','2019-03-16 09:36:32'),(453,'common',0,'check all','Сheck all','2019-03-16 09:36:32'),(454,'common',0,'# of # selected','# of # available','2019-03-16 09:39:40'),(455,'common',0,'4 and more','4 and more','2019-03-16 09:36:32'),(456,'module_apartments',0,'Status (owner)','Status (owner)','2019-03-16 09:36:32'),(457,'module_apartments',0,'Owner','Owner','2019-03-16 09:36:33'),(458,'module_menumanager',0,'Manage of the top menu','Top menu items','2019-03-16 09:36:33'),(459,'module_menumanager',0,'Add item','Add a top menu item','2019-03-16 09:36:33'),(460,'module_menumanager',0,'Update','Edit','2019-03-16 09:36:33'),(461,'module_menumanager',0,'Delete item','Delete the menu item','2019-03-16 09:36:33'),(462,'module_menumanager',0,'The page with the text in the drop-down list','The page with a text in the drop-down list','2019-03-16 09:36:34'),(463,'module_menumanager',0,'Reference in the drop-down list (set manually)','A link in the drop-down list (set manually)','2019-03-16 09:36:34'),(464,'module_menumanager',0,'The drop-down list','The drop-down list','2019-03-16 09:36:34'),(465,'module_menumanager',0,'A page with text','The page with a text','2019-03-16 09:36:34'),(466,'module_menumanager',0,'Simple link (set manually)','A simple link (set manually)','2019-03-16 09:36:35'),(467,'module_menumanager',0,'Display the bottom of the page','Display at the bottom of the page','2019-03-16 09:36:35'),(468,'module_menumanager',0,'The text on the page','The text on the page','2019-03-16 09:36:35'),(469,'module_menumanager',0,'Page Title','Page Title','2019-03-16 09:36:35'),(470,'module_menumanager',0,'The drop-down list to contain','The drop-down list to contain','2019-03-16 09:36:35'),(471,'module_menumanager',0,'Link','Link','2019-03-16 09:36:36'),(472,'module_menumanager',0,'Type of link','Type of link','2019-03-16 09:36:36'),(473,'module_menumanager',0,'Text links','Text links','2019-03-16 09:36:36'),(474,'module_menumanager',0,'Not selected','Not selected','2019-03-16 09:36:36'),(475,'common',0,'No','No','2019-03-16 09:36:36'),(476,'common',0,'Listing','Listing','2019-03-16 09:36:37'),(477,'common',0,'Search for listings on the map','Search for listings on the map','2019-03-16 09:36:37'),(478,'common',0,'The form of the section \"Contact Us\"','The form of the section \"Contact Us\"','2019-03-16 09:36:37'),(479,'module_menumanager',0,'Management section','Manage the section','2019-03-16 09:36:37'),(480,'common',0,'Translate','Translate','2019-03-16 09:36:37'),(481,'common',0,'Copy to all languages','Copy to all languages','2019-03-16 09:36:38'),(482,'module_apartments',0,'Price will be saved (converted) in the default currency on the site','The price will be saved (converted) in the default currency','2019-03-16 09:36:38'),(483,'module_userads',0,'Status (owner)','Status (owner)','2019-03-16 09:36:38'),(484,'module_userads',0,'Owner','Owner','2019-03-16 09:36:38'),(485,'module_configuration',0,'cachingTime','Objects cache time (in seconds)','2019-03-16 09:36:39'),(486,'module_configuration',0,'shortCashingTime','Cache time for difficult objects (in seconds)','2019-03-16 09:36:39'),(487,'module_configuration',0,'commentNeedApproval','Comments approval by the administrator','2019-03-16 09:36:39'),(488,'module_configuration',0,'module_articles_itemsPerPage','Number of Q&As per page in the section \"Q&As\"','2019-03-16 09:36:39'),(489,'module_configuration',0,'module_articles_truncateAfterWords','To cut off the text of article and to add the link \"Read more\" after ... words (0 - not to cut off)','2019-03-16 09:36:40'),(490,'module_configuration',0,'module_usercpanel_bookingsPerPage','Number of bookings per page in the user panel','2019-03-16 09:36:40'),(491,'module_configuration',0,'adminEmail','E-mail of the administrator','2019-03-16 09:36:40'),(492,'module_configuration',0,'adminPhone','Phone number','2019-03-16 09:36:40'),(493,'module_configuration',0,'adminSkype','Skype','2019-03-16 03:59:50'),(494,'module_configuration',0,'adminICQ','ICQ','2019-03-16 03:59:50'),(495,'module_configuration',0,'adminAddress','Address','2019-03-16 09:36:41'),(496,'module_configuration',0,'moduleEntries_entriesPerPage','Number of articles per page in the section \"Articles\"','2019-03-16 09:36:41'),(497,'module_configuration',0,'moduleApartments_maxRooms','The maximum number of bedrooms for the listing','2019-03-16 09:36:41'),(498,'module_configuration',0,'moduleApartments_maxFloor','The maximum number of floors for the listing','2019-03-16 09:36:41'),(499,'module_configuration',0,'module_apartments_gmapsCenterX','To center the Map by default, longitude (X)','2019-03-16 09:36:42'),(500,'module_configuration',0,'module_apartments_gmapsCenterY','To center the Map by default, latitude (Y)','2019-03-16 09:36:42'),(501,'module_configuration',0,'module_apartments_gmapsZoomCity','Zoom level for viewing a city map','2019-03-16 09:36:42'),(502,'module_configuration',0,'module_apartments_gmapsZoomApartment','Zoom level for viewing a listing','2019-03-16 09:36:42'),(503,'module_configuration',0,'module_apartment_gmapBounds','Coordinates for address search','2019-03-16 09:36:43'),(504,'module_configuration',0,'useGoogleMap','Use the module of the Google Maps on the site','2019-03-16 09:36:43'),(505,'module_configuration',0,'adminPaginationPageSize','Dashboard: quantity of elements for tabular display','2019-03-16 09:36:43'),(506,'module_configuration',0,'module_notifier_adminNewComment','Should the system send a letter to the administrator when new comments are written?','2019-03-16 09:36:43'),(507,'module_configuration',0,'module_notifier_adminNewBooking','Should the system send a letter to the administrator when new property items are booked by the users?','2019-03-16 09:36:43'),(508,'module_configuration',0,'module_notifier_userPaymentSuccess','Should the system send a letter to the user when his/her booking has been successfully paid?','2019-03-16 09:36:44'),(509,'module_configuration',0,'module_notifier_userNewUser','Should the system send a letter to the user after he/she has filled the registration form? (This setting will work only if registration confirmation is turned off)','2019-03-16 09:36:44'),(510,'module_configuration',0,'module_notifier_adminNewUser','Should the system send a letter to the administrator when new user has been registered?','2019-03-16 09:36:44'),(511,'module_configuration',0,'module_notifier_adminNewContactform','Should the system send a letter to the administrator when a message is sent from the feedback form?','2019-03-16 09:36:44'),(512,'module_configuration',0,'useYandexMap','Use the module of the Yandex Maps on the site','2019-03-16 09:36:44'),(513,'module_configuration',0,'module_apartments_ymapsCenterX','To center the Map by default, longitude (X)','2019-03-16 09:36:45'),(514,'module_configuration',0,'module_apartments_ymapsCenterY','To center the Map by default, latitude (Y)','2019-03-16 09:36:45'),(515,'module_configuration',0,'module_apartments_ymapsZoomCity','Zoom level for viewing a city map','2019-03-16 09:36:45'),(516,'module_configuration',0,'module_apartments_ymapsZoomApartment','Zoom level for viewing a listing','2019-03-16 09:36:45'),(517,'module_configuration',0,'module_apartments_ymapsKey','Яндекс.Maps API key','2019-03-16 09:36:46'),(518,'module_configuration',0,'module_apartments_ymapsSpanX','Area of address searching, longitude (X)','2019-03-16 09:36:46'),(519,'module_configuration',0,'module_apartments_ymapsSpanY','Area of address searching, latitude (Y)','2019-03-16 09:36:46'),(520,'module_configuration',0,'usePriceSlider','Use the \"slider\" for the field \"Price\" in the Search form','2019-03-16 09:36:46'),(521,'module_configuration',0,'useSquareSlider','Use the \"slider\" for the field \"Square\" in the Search form','2019-03-16 09:36:47'),(522,'module_configuration',0,'useFloorSlider','Use the \"slider\" for the field \"Floor\" in the Search form','2019-03-16 09:36:47'),(523,'module_configuration',0,'useRoomSlider','Use the \"slider\" for the field \"Number of bedrooms\" in the Search form','2019-03-16 09:36:47'),(524,'module_configuration',0,'usePrettyPrice','Use \"MLN\" and \"K\" instead of \"million\" and \"thousand\" for displaying of prices','2019-03-16 09:36:47'),(525,'module_configuration',0,'useUserads','Users\' ability to add listings','2019-03-16 09:36:48'),(526,'module_configuration',0,'useUseradsModeration','Moderation of users\' listing','2019-03-16 09:36:48'),(527,'module_configuration',0,'module_notifier_adminNewBooking','Should the system send a letter to the admin that the property is booked after being viewed on the listing\'s page?','2019-03-16 09:36:48'),(528,'module_configuration',0,'module_notifier_ownerNewBooking','Should the system send a letter to the owner that his/her property is booked after being viewed on the listing\'s page?','2019-03-16 09:36:48'),(529,'module_configuration',0,'useReferenceLinkInView','Links to reference while viewing listings','2019-03-16 09:36:48'),(530,'common',0,'Site service','Site maintenance','2019-03-16 09:36:49'),(531,'common',0,'{label} cannot be blank for {lang}.','{label} cannot be blank for {lang}.','2019-03-16 09:36:49'),(532,'module_configuration',0,'defaultCity','City by default, for positioning on the map','2019-03-16 09:36:49'),(533,'module_paysystem',0,'robokassa','Robokassa','2019-03-16 03:59:50'),(534,'module_paysystem',0,'offline','Payment via a bank','2019-03-16 09:36:50'),(535,'module_payment',0,'Password 1','Password 1','2019-03-16 09:36:50'),(536,'module_payment',0,'Password 2','Password 2','2019-03-16 09:36:50'),(537,'module_payment',0,'Description of the system','Description of the system','2019-03-16 09:36:50'),(538,'module_payment',0,'Available payment methods','The suggested currency of payment','2019-03-16 09:36:50'),(539,'module_payment',0,'Awaiting confirmation of receipt','Awaiting confirmation about receipt','2019-03-16 09:36:51'),(540,'module_payment',0,'Confirm payment','Confirm payment','2019-03-16 09:36:51'),(541,'module_payment',0,'Method of payment','Method of payment','2019-03-16 09:36:51'),(542,'module_paidservices',0,'Manage paid services','Paid services ','2019-03-16 09:36:51'),(543,'module_paidservices',0,'Price','Price','2019-03-16 09:36:51'),(544,'module_paidservices',0,'Duration of the day','Duration time in days','2019-03-16 09:36:52'),(545,'common',0,'Paid service','Paid service','2019-03-16 09:36:52'),(546,'common',0,'Will be used for listings','Will be used for listings','2019-03-16 09:36:52'),(547,'common',0,'The service will be active','The service will be active for','2019-03-16 09:36:52'),(548,'common',0,'Cost of service','Cost of service is','2019-03-16 09:36:53'),(549,'module_payment',0,'Thank you! Notification of your payment sent to the administrator.','Thank you! Notification about your payment is sent to the administrator.','2019-03-16 09:36:53'),(550,'common',0,'Paid Service','Paid Service','2019-03-16 09:36:53'),(551,'module_paysystem',0,'offline_description','To pay for the booking you need to transfer the amount above to the following banking details:\r\nCurrent account: ________, BIC: _____ OKATO______ ...\r\n\r\nAfter you send that amount according to the banking details, click \"Continue\".\r\nThe administrator will be notified of the payment and will confirm the booking after receiving the money.','2019-03-16 09:36:53'),(552,'module_paysystem',0,'robokassa_description','ROBOKASSA — is a service that allows sellers (on-line stores) to receive payments by plastic cards, in every e-currency, using mobile commerce services (MTS, Megafon, Beeline), E-invoicing via leading banks of Russia, through ATMs, through instant payment terminals, through Contact remittances, and with the iPhone application.','2019-03-16 09:36:54'),(553,'module_payment',0,'Payment is canceled','The payment has been canceled','2019-03-16 09:36:54'),(554,'module_payment',0,'Payment successfully held','The payment is successfully completed','2019-03-16 09:36:54'),(555,'module_paidservices',0,'Paid service special offer','Mark as special offer','2019-03-16 09:36:54'),(556,'common',0,'Pay with','Pay with','2019-03-16 09:36:55'),(557,'module_apartments',0,'Views','Views','2019-03-16 09:36:55'),(558,'module_apartments',0,'views_all','All views','2019-03-16 09:36:55'),(559,'module_apartments',0,'views_today','Today number of views','2019-03-16 09:36:55'),(563,'module_service',0,'Page','Page','2019-03-16 09:36:56'),(564,'module_service',0,'Closed_maintenance','Closed for maintenance','2019-03-16 09:36:56'),(565,'module_service',0,'Allow_ip','Allow from IP','2019-03-16 09:36:56'),(566,'module_service',0,'Through_comma','Separated by commas','2019-03-16 09:36:56'),(567,'common',0,'Proceed','Proceed','2019-03-16 09:36:56'),(568,'common',0,'User','User','2019-03-16 09:36:57'),(569,'module_paidservices',0,'Name','Name','2019-03-16 09:36:57'),(570,'common',0,'Yes','Yes','2019-03-16 09:36:57'),(571,'module_configuration',0,'useShowUserInfo','Use displaying of information about the user','2019-03-16 09:36:57'),(572,'module_configuration',0,'useSliderSimilarAds','Use displaying of similar listings','2019-03-16 09:36:57'),(573,'module_configuration',0,'Fill a field','Fill the field','2019-03-16 09:36:58'),(574,'module_apartments',0,'Owner phone','Owner phone','2019-03-16 09:36:58'),(575,'module_apartments',0,'Show','Show','2019-03-16 09:36:58'),(576,'common',0,'{label} is too short for {lang} (minimum is {min} characters).','{label} is too short for {lang} (minimum {min} characters).','2019-03-16 09:36:58'),(577,'common',0,'{label} is too long for {lang} (maximum is {max} characters).','{label} is too long for {lang} (maximum {max} characters).','2019-03-16 09:36:59'),(578,'common',0,'{label} is of the wrong length for {lang} (should be {length} characters).','{label} is of the wrong length for {lang} (should be {length} characters).','2019-03-16 09:36:59'),(579,'common',0,'Listing (random)','Listing (random)','2019-03-16 09:36:59'),(580,'common',0,'Cancel','Cancel','2019-03-16 09:36:59'),(581,'common',0,'Request for confirmation','Request for confirmation','2019-03-16 09:36:59'),(582,'module_referencecategories',0,'Reference name','Category name','2019-03-16 09:37:00'),(583,'module_referencevalues',0,'Reference value','Value','2019-03-16 09:37:03'),(584,'module_bookingcalendar',0,'The periods of booking apartment','The periods of bookings','2019-03-16 09:37:03'),(585,'module_bookingcalendar',0,'Fill fields','Fill the fields','2019-03-16 09:37:03'),(586,'module_bookingcalendar',0,'Edit','Edit','2019-03-16 09:37:03'),(587,'module_bookingcalendar',0,'From','From','2019-03-16 09:37:04'),(588,'module_bookingcalendar',0,'To','To','2019-03-16 09:37:04'),(589,'module_bookingcalendar',0,'Status','Status','2019-03-16 09:37:04'),(590,'module_bookingcalendar',0,'from','from','2019-03-16 09:37:04'),(591,'module_bookingcalendar',0,'to','to','2019-03-16 09:37:05'),(592,'module_bookingcalendar',0,'Reserved','Reserved','2019-03-16 09:37:05'),(593,'module_bookingcalendar',0,'Free','Free','2019-03-16 09:37:05'),(594,'module_bookingcalendar',0,'Access denied','Access is denied','2019-03-16 09:37:05'),(595,'module_bookingcalendar',0,'Delete error','While deleting, an error occurred','2019-03-16 09:37:05'),(598,'module_bookingcalendar',0,'Are you sure?','Are you sure?','2019-03-16 09:37:06'),(599,'module_bookingcalendar',0,'Periods of free / reserved apartment','Periods of free / reserved day','2019-03-16 09:37:06'),(600,'module_bookingcalendar',0,'You chose dates in the range of which there are busy days','The period, which you have chosen, has the reserved days','2019-03-16 09:37:06'),(601,'module_apartmentCity',0,'help_apartmentCity_backend_main_admin','The cities are available in the search form if there are listings of these cities.','2019-03-16 09:37:06'),(602,'common',0,'Default','Default','2019-03-16 09:37:06'),(603,'module_configuration',0,'dateFormat','Date format on the site','2019-03-16 09:37:07'),(604,'common',0,'Advertising banners','Advertising banners','2019-03-16 09:37:07'),(605,'common',0,'Name of Payment system','Name of Payment system','2019-03-16 09:37:07'),(606,'common',0,'Amount','Amount','2019-03-16 09:37:07'),(607,'common',0,'Date created','Date created','2019-03-16 09:37:08'),(608,'module_payment',0,'Name','Name','2019-03-16 09:37:08'),(609,'module_payment',0,'Description','Description','2019-03-16 09:37:08'),(610,'module_payment',0,'Payment System Settings saved successfully.','Payment System Settings are successfully saved.','2019-03-16 09:37:08'),(611,'module_lang',0,'Administrator e-mail','Administrator e-mail','2019-03-16 09:37:09'),(612,'module_socialauth',0,'Login with','Login with','2019-03-16 09:37:09'),(614,'module_socialauth',0,'During export account data may be generate random email and password. Please change it.','While creating account, your email and password may be randomly generated. Please change them.','2019-03-16 09:37:09'),(615,'module_socialauth',0,'Please change your email and password!','Please change your email and password!','2019-03-16 09:37:09'),(616,'module_socialauth',0,'Your account not active. Administrator deactivate your account.','Your account is not active. The administrator has deactivated it.','2019-03-16 09:37:13'),(617,'module_socialauth',0,'vkontakte_label','VK.com','2019-03-16 09:37:13'),(618,'module_socialauth',0,'google_label','Google','2019-03-16 03:59:50'),(619,'module_socialauth',0,'facebook_label','Facebook.com','2019-03-16 09:37:13'),(620,'module_socialauth',0,'linkedin_label','LinkedIn','2019-03-16 09:37:13'),(621,'module_socialauth',0,'twitter_label','Twitter.com','2019-03-16 09:37:14'),(622,'module_socialauth',0,'Undefined service name: {service}.','Undefined service name: {service}.','2019-03-16 09:37:14'),(623,'module_socialauth',0,'Invalid response http code: {code}.','Invalid response form http code: {code}.','2019-03-16 09:37:14'),(624,'module_socialauth',0,'Invalid response format.','Invalid response format.','2019-03-16 09:37:14'),(625,'module_socialauth',0,'Unable to complete the authentication because the required data was not received by {provider}.','Unable to complete the authentication, because the {provider} does not send the required data.','2019-03-16 09:37:14'),(626,'module_socialauth',0,'Unable to complete the request because the user was not authenticated.','Unable to complete the request because the user was not authenticated.','2019-03-16 09:37:15'),(627,'module_socialauth',0,'Client_id','Client ID','2019-03-16 09:37:15'),(628,'module_socialauth',0,'Client_secret','Client secret','2019-03-16 03:59:50'),(629,'module_socialauth',0,'Key','Key','2019-03-16 03:59:50'),(630,'module_socialauth',0,'Secret','Secret','2019-03-16 03:59:50'),(631,'module_socialauth',0,'Section','Section','2019-03-16 09:37:16'),(632,'module_socialauth',0,'Setting','Setting','2019-03-16 09:37:16'),(633,'module_socialauth',0,'Enter the required value','Enter the required value','2019-03-16 09:37:16'),(634,'module_socialauth',0,'Authentication services','Authentication services','2019-03-16 09:37:17'),(635,'module_socialauth',0,'Name','Name','2019-03-16 09:37:17'),(636,'module_socialauth',0,'Value','Value','2019-03-16 09:37:17'),(637,'module_socialauth',0,'Manage social settings','Authentication services','2019-03-16 09:37:17'),(638,'module_socialauth',0,'Update param \"{name}\"','Edit parameter \"{name}\"','2019-03-16 09:37:17'),(639,'module_socialauth',0,'google_oauth','Google','2019-03-16 03:59:50'),(640,'module_socialauth',0,'twitter','Twitter','2019-03-16 03:59:50'),(641,'module_socialauth',0,'facebook','Facebook','2019-03-16 03:59:50'),(642,'module_socialauth',0,'vkontakte','VK.com','2019-03-16 09:37:18'),(643,'module_socialauth',0,'useGoogleOauth','Use Google authorization','2019-03-16 09:37:18'),(644,'module_socialauth',0,'googleOauthClientId','Client ID','2019-03-16 09:37:19'),(645,'module_socialauth',0,'googleOauthClientSecret','Client secret','2019-03-16 03:59:50'),(646,'module_socialauth',0,'useTwitter','Use Twitter authorization','2019-03-16 09:37:19'),(647,'module_socialauth',0,'twitterKey','Key','2019-03-16 03:59:50'),(648,'module_socialauth',0,'twitterSecret','Secret','2019-03-16 03:59:50'),(649,'module_socialauth',0,'useFacebook','Use Facebook authorization','2019-03-16 09:37:20'),(650,'module_socialauth',0,'facebookClientId','Client ID','2019-03-16 09:37:20'),(651,'module_socialauth',0,'facebookClientSecret','Client secret','2019-03-16 03:59:50'),(652,'module_socialauth',0,'useVkontakte','Use VK.com authorization','2019-03-16 09:37:21'),(653,'module_socialauth',0,'vkontakteClientId','Client ID','2019-03-16 09:37:21'),(654,'module_socialauth',0,'vkontakteClientSecret','Client secret','2019-03-16 03:59:50'),(655,'common',0,'Social settings','Authentication services','2019-03-16 09:37:21'),(656,'module_socialauth',0,'Go to link for register Google application - {link}','To register Google application click the link  - {link}','2019-03-16 09:37:21'),(657,'module_socialauth',0,'Go to link for register Twitter application - {link}','To register Twitter application click the link  - {link}','2019-03-16 09:37:22'),(658,'module_socialauth',0,'Go to link for register Facebook application - {link}','To register Facebook application click the link  - {link}','2019-03-16 09:37:22'),(659,'module_socialauth',0,'Go to link for register VK.com application - {link}','To register VK.com application click the link  - {link}','2019-03-16 09:37:22'),(660,'module_slider',0,'Delete image','Delete the image','2019-03-16 09:37:22'),(661,'module_slider',0,'Edit image','Edit the image','2019-03-16 09:37:23'),(662,'common',0,'Note:','Note:','2019-03-16 09:37:23'),(663,'module_advertising',0,'Image','Image','2019-03-16 09:37:23'),(664,'module_advertising',0,'HTML code','HTML code','2019-03-16 09:37:23'),(665,'module_advertising',0,'Top-left','Top-left','2019-03-16 09:37:23'),(666,'module_advertising',0,'Top-right','Top-right','2019-03-16 09:37:24'),(667,'module_advertising',0,'Top-center','Top-center','2019-03-16 09:37:24'),(668,'module_advertising',0,'Bottom-left','Bottom-left','2019-03-16 09:37:24'),(669,'module_advertising',0,'Bottom-right','Bottom-right','2019-03-16 09:37:24'),(670,'module_advertising',0,'Bottom-center','Bottom-center','2019-03-16 09:37:24'),(671,'module_advertising',0,'(press and hold SHIFT button for multiply select)','(press and hold SHIFT button for multiply select)','2019-03-16 09:37:25'),(672,'module_advertising',0,'Supported file: {supportExt}.','Supported file types: {supportExt}.','2019-03-16 09:37:25'),(673,'module_advertising',0,'You really want to remove the chosen block?','Are you sure you want to remove the chosen block?','2019-03-16 09:37:25'),(674,'module_advertising',0,'Edit','Edit','2019-03-16 09:37:25'),(675,'module_advertising',0,'Management of advertizing blocks','Advertising banners','2019-03-16 09:37:25'),(676,'module_advertising',0,'Edit block','Edit a block','2019-03-16 09:37:26'),(677,'module_advertising',0,'Add block','Add a banner','2019-03-16 09:37:26'),(678,'module_advertising',0,'Main page','Home page','2019-03-16 09:37:26'),(679,'module_advertising',0,'View listing','Listing\'s Page','2019-03-16 09:37:26'),(680,'module_advertising',0,'Search results','Search results','2019-03-16 09:37:26'),(681,'module_advertising',0,'Contact us','Contact us','2019-03-16 09:37:27'),(682,'module_advertising',0,'Special offers','Special offers','2019-03-16 09:37:27'),(683,'module_advertising',0,'News','News','2019-03-16 09:37:27'),(684,'module_advertising',0,'News -> view','News -> view','2019-03-16 09:37:27'),(685,'module_advertising',0,'Articles','Q&As','2019-03-16 09:37:27'),(686,'module_advertising',0,'Articles -> view','Q&As -> view','2019-03-16 09:37:28'),(687,'module_advertising',0,'Login page','Page for login','2019-03-16 09:37:28'),(688,'module_advertising',0,'Registration page','Page for sign up','2019-03-16 09:37:28'),(689,'module_advertising',0,'Recovery password page','Page for password recovery ','2019-03-16 09:37:28'),(690,'module_advertising',0,'I want place','I want to place','2019-03-16 09:37:28'),(691,'module_advertising',0,'Position','Position','2019-03-16 09:37:29'),(692,'module_advertising',0,'Pages','Pages','2019-03-16 09:37:29'),(693,'module_advertising',0,'File','File','2019-03-16 09:37:29'),(694,'module_advertising',0,'Text/HTML code','Text/HTML code','2019-03-16 09:37:29'),(695,'module_advertising',0,'URL','URL','2019-03-16 09:37:29'),(696,'module_advertising',0,'Alternative text','Alternative text','2019-03-16 09:37:30'),(697,'module_advertising',0,'Active','Active','2019-03-16 09:37:30'),(698,'module_currency',0,'Exchange rate','Exchange rate','2019-03-16 09:37:30'),(699,'module_currency',0,'Short name','Short name','2019-03-16 09:37:30'),(700,'module_translateMessage',0,'String constant (defined in code)','String constant (defined in the code)','2019-03-16 09:37:30'),(701,'module_translateMessage',0,'Constant value (translation)','Constant\'s value (translation)','2019-03-16 09:37:31'),(702,'module_translateMessage',0,'Translated','Translated','2019-03-16 09:37:31'),(703,'module_translateMessage',0,'Not translated','Not translated','2019-03-16 09:37:31'),(704,'module_paidservices',0,'Description','Description','2019-03-16 09:37:31'),(705,'module_paidservices',0,'Update paid service','Edit the paid service','2019-03-16 09:37:31'),(706,'module_seo',0,'Management of compliance of URL, title, description and keywords','Manage the compliance of URL, title, description and keywords','2019-03-16 09:37:32'),(707,'module_seo',0,'Are you sure you want to delete this compliance?','Are you sure you want to delete this compliance?','2019-03-16 09:37:32'),(708,'module_seo',0,'Add compliance','Add a compliance','2019-03-16 09:37:32'),(709,'module_seo',0,'URL','URL','2019-03-16 03:59:50'),(710,'module_seo',0,'Title','Title','2019-03-16 09:37:32'),(711,'module_seo',0,'Description','Description','2019-03-16 09:37:33'),(712,'module_seo',0,'Keywords','Keywords','2019-03-16 09:37:33'),(713,'module_seo',0,'Date Updated','Last updated on','2019-03-16 09:37:33'),(714,'module_seo',0,'Edit compliance','Edit the compliance','2019-03-16 09:37:33'),(715,'module_seo',0,'help_seo_backend_main_admin','You should add an URL without a full site address (because it will be cut out in the code) and without the indication of a language prefix (en, ru) as well. In the beginning of the URL you should insert a back slash, for example \"/for news\" or \"/to news/12\", \"/to property/25\".','2019-03-16 09:37:34'),(716,'module_configuration',0,'round_price','Round-off the price accurate to N decimal places','2019-03-16 09:37:34'),(717,'module_contactform',0,'Thanks_for_message','Thanks for message! We will answer you as soon as possible.','2019-03-16 09:37:34'),(718,'module_contactform',0,'Error_send','The message is not sent! Please correct the mistakes and try again.','2019-03-16 09:37:34'),(719,'module_apartments',0,'apartments_main_index_propertyNotAvailable','The listing is not available','2019-03-16 09:37:35'),(720,'module_apartmentObjType',0,'backend_apartmentObjType_main_admin_NoDeleteLastElement','It is impossible to remove the last type because this field is required for each listing.','2019-03-16 09:37:35'),(721,'module_apartments',0,'validateFloorMoreTotal','The number of the current floor can not be more than total number of floors in the house.','2019-03-16 09:37:35'),(722,'module_apartments',0,'million','MLN','2019-03-16 09:37:35'),(723,'module_apartments',0,'thousand','K','2019-03-16 09:37:35'),(724,'module_menumanager',0,'backend_menumanager_main_admin_noDeleteSystemItem','This point of the menu is a system one, and it cannot be removed. But you can disable it in the column \"Is included\".','2019-03-16 09:37:36'),(725,'module_quicksearch',0,'Sorting by date created','Sort by date created','2019-03-16 09:37:36'),(726,'module_usercpanel',0,'Change contact info','Change the contact info','2019-03-16 09:37:36'),(727,'module_paidservices',0,'Sorting by date created','Sort by the creation date','2019-03-16 09:37:36'),(728,'common',0,'Error','Error','2019-03-16 09:37:37'),(729,'module_notifier',0,'message_not_send','The message is not sent','2019-03-16 09:37:37'),(730,'module_configuration',0,'mailUseSMTP','Use SMTP server to send mail','2019-03-16 09:37:37'),(731,'module_configuration',0,'mailSMTPHost','Address of SMTP server','2019-03-16 09:37:37'),(732,'module_configuration',0,'mailSMTPPort','Port of SMTP server','2019-03-16 09:37:37'),(733,'module_configuration',0,'mailSMTPLogin','SMTP user login','2019-03-16 09:37:37'),(734,'module_configuration',0,'mailSMTPPass','SMTP user password','2019-03-16 09:37:38'),(735,'module_configuration',0,'mail','E-mail','2019-03-16 09:37:38'),(736,'module_payment',0,'PayPal email','PayPal Email','2019-03-16 09:37:38'),(737,'module_payment',0,'Please_wait_payment','Please wait. The system is redirecting you to PayPal for payment.','2019-03-16 09:37:38'),(738,'module_usercpanel',0,'Additional info','Additional info','2019-03-16 09:37:38'),(739,'module_payment',0,'Pay Now','Pay now','2019-03-16 09:37:39'),(740,'module_payment',0,'Status (owner)','Status (owner)','2019-03-16 09:37:39'),(741,'module_payment',0,'Owner','Owner','2019-03-16 09:37:39'),(742,'module_payment',0,'Payment pending','Payment is pending','2019-03-16 09:37:39'),(743,'module_booking',0,'Booking price','Booking price','2019-03-16 09:37:39'),(744,'module_lang',0,'do_not_copy','Do not copy','2019-03-16 09:37:40'),(745,'common',0,'Allow javascript in your browser for comfortable use site.','Allow javascript in your browser for comfortable use site.','2019-03-16 09:37:40'),(746,'common',0,'Operations','Operations','2019-03-16 09:37:40'),(747,'bootstrap',0,'Next','Next','2019-03-16 09:37:40'),(748,'bootstrap',0,'Previous','Previous','2019-03-16 09:37:41'),(749,'bootstrap',0,'First','First','2019-03-16 09:37:41'),(750,'bootstrap',0,'Last','Last','2019-03-16 09:37:41'),(751,'module_lang',0,'Enter a value for this language','Enter a value for this language','2019-03-16 09:37:41'),(752,'module_lang',0,'Error translate','Error translate','2019-03-16 09:37:41'),(753,'module_lang',0,'Success translate','Successful translation','2019-03-16 09:37:42'),(754,'module_lang',0,'Success copy','Successfully copied','2019-03-16 09:37:42'),(755,'common',0,'Sorry, this action is not allowed on the demo server.','Sorry, this action is not allowed on the demo server.','2019-03-16 09:37:42'),(756,'module_configuration',0,'siteCurrency','Site currency','2019-03-16 09:37:42'),(757,'module_booking',0,'Already have site account? Please <a title=\"Login\" href=\"{n}\">login</a>','Already have site account? Please <a title=\"Login\" href=\"{n}\">log in</a>','2019-03-16 13:37:54'),(758,'common',0,'floors','Floors','2019-03-16 09:37:43'),(759,'module_apartments',0,'After pressing the button \"Create\", you will be able to load photos for the listing and to mark the property on the map.','After pressing the button \"Create\", you will be able to load photos for the listing and to mark the property on the map.','2019-03-16 09:37:43'),(760,'app',0,'Load default configuration for ','Load default configuration for ','2019-03-16 03:59:50'),(761,'app',0,'Do you load default configuration for <strong>xxxxx</strong>?<br />Actuall settings will be lost!','Do you load default configuration for <strong>xxxxx</strong>?<br />Actuall settings will be lost!','2019-03-16 09:37:43'),(762,'module_configuration',0,'Update {name}','Update {name}','2019-03-16 09:37:44'),(763,'module_payment',0,'Result URL: ','Result URL: ','2019-03-16 03:59:50'),(764,'module_payment',0,'Success URL: ','Success URL: ','2019-03-16 03:59:50'),(765,'module_payment',0,'Fail URL: ','Fail URL: ','2019-03-16 03:59:50'),(766,'module_lang',0,'Such a language already exists.','Such a language already exists.','2019-03-16 09:37:44'),(767,'module_socialauth',0,'Update {name}','Update {name}','2019-03-16 09:37:45'),(768,'common',0,'floor','floor','2019-03-16 09:37:45'),(769,'common',0,'Ok','Ok','2019-03-16 09:37:45'),(770,'module_apartments',0,'After pressing the button \"Create\", you will be able to load photos for the listing and to mark the property on the map.','After pressing the button \"Create\", you will be able to load photos for the listing and to mark the property on the map.','2019-03-16 09:37:45'),(771,'module_lang',0,'Flag icon','Flag','2019-03-16 09:37:46'),(772,'module_lang',0,'help upload icon','You can download your flag icons into the directory flag_dir, so they will be able to be chosen.','2019-03-16 09:37:46'),(773,'common',0,'from','from','2019-03-16 09:37:46'),(774,'module_paidservices',0,'To apply a paid service for the listing, it should be active.','To apply a paid service to the listing, it should be active.','2019-03-16 09:37:46'),(775,'common',0,'Hidden in demo mode','Hidden in demo mode','2019-03-16 09:37:46'),(776,'common',0,'site_square','m<sup>2</sup>','2019-03-16 09:37:47'),(777,'module_booking',0,'Operation successfully complete. Your order will be reviewed by administrator.','Operation successfully complete. Your order will be reviewed by administrator.','2019-03-16 09:37:47'),(778,'common',0,'Log in as user','Log in as user','2019-03-16 09:37:47'),(779,'common',0,'or','or','2019-03-16 09:37:47'),(780,'common',0,'log in as administrator','log in as administrator','2019-03-16 09:37:48'),(781,'module_apartments',0,'{n} rooms','{n} bedrooms','2019-03-16 09:37:48'),(782,'module_configuration',0,'mode_list_show','Conclusion default ad','2019-03-16 09:37:48'),(783,'module_rss',0,'rss_subscribe','RSS subscribe','2019-03-16 09:37:48'),(784,'module_rss',0,'listings_from','Listings from ','2019-03-16 09:40:29'),(785,'module_rss',0,'description_rss_from','New listings are found that match your search criteria','2019-03-16 09:40:29'),(786,'module_apartmentObjType',0,'The file was larger than {size}MB. Please upload a smaller file.','File\'s size is larger than {size}MB. Please upload a file with smaller size.','2019-03-16 09:40:29'),(787,'module_apartmentObjType',0,'Supported file: {supportExt}.','Supported types of files: {supportExt}.','2019-03-16 09:40:29'),(788,'module_apartmentObjType',0,'icon_file_maps','Icon for Google Maps and Yandex Maps','2019-03-16 09:40:29'),(789,'module_apartmentObjType',0,'current_icon','Current icon','2019-03-16 09:40:30'),(790,'common',0,'Filter','Filter','2019-03-16 09:40:30'),(791,'module_apartments',0,'request_for_property','Send message','2019-03-16 09:40:30'),(792,'module_apartments',0,'send_request','Send','2019-03-16 09:40:31'),(793,'module_apartments',0,'user_request_name','Name','2019-03-16 09:40:31'),(794,'module_apartments',0,'user_request_email','Email','2019-03-16 11:00:59'),(795,'module_apartments',0,'user_request_phone','Phone','2019-03-16 11:01:00'),(796,'module_apartments',0,'user_request_message','Message','2019-03-16 11:01:00'),(797,'module_apartments',0,'user_request_ver_code','Verification Code','2019-03-16 11:01:00'),(798,'module_apartments',0,'Error_send_request','The request is not sent! Please correct the mistakes and try again.','2019-03-16 11:01:00'),(799,'module_apartments',0,'Thanks_for_request','Thanks for request! Owner of listing will answer you as soon as possible.','2019-03-16 11:01:01'),(800,'module_notifier',0,'copy_request_for_property_from','Copy of message to the listing\'s owner from','2019-03-16 11:01:01'),(801,'module_notifier',0,'request_for_property_from','Request for property from','2019-03-16 11:01:01'),(802,'module_notifier',0,'additional_info_for_user','The user who has sent you a letter will not get to know your email address untill you answer this message. We do not guarantee that the user has written his/her email address. phone number and name correctly.','2019-03-16 11:01:01'),(803,'module_configuration',0,'use_module_request_property','A user can email to listing owner email from listing page','2019-03-16 11:01:02'),(804,'module_payment',0,'Paid service #{id} ({name}) with the price {price}','Paid service #{id} ({name}) with the price {price}','2019-03-16 13:38:15'),(805,'module_comments',0,'Remove the rate','Remove the rate','2019-03-16 11:01:02'),(806,'module_contactform',0,'My status','My status','2019-03-16 11:01:02'),(807,'common',0,'Page not found.','Page not found.','2019-03-16 11:01:03'),(808,'module_slider',0,'Link','Link','2019-03-16 11:01:03'),(809,'common',0,'Print version','Print version','2019-03-16 11:01:03'),(810,'module_notifier',0,'Activating a new password','Активация нового пароля','2019-03-16 11:01:03'),(811,'module_notifier',0,'recover_pass_first_help','You are receiving this email because you (or someone pretending to be you) asked to send a new password to your account at ::fullhost.','2019-03-16 11:01:04'),(812,'common',0,'recover_pass_form_help','Enter your e-mail, which will be sent the information to reset your password','2019-03-16 11:01:04'),(813,'common',0,'recover_pass_temp_send','A new password has been created, check the mailbox to find out how to activate it','2019-03-16 11:01:04'),(814,'common',0,'Password successfully changed','Password successfully changed.','2019-03-16 11:01:04'),(815,'common',0,'Images','Images','2019-03-16 11:01:05'),(816,'common',0,'useWatermark','Use watermark for object\'s photos','2019-03-16 11:01:05'),(817,'common',0,'maxImageWidth','Maximum width for object\'s photos','2019-03-16 11:01:05'),(818,'common',0,'maxImageHeight','Maximum height for object\'s photos','2019-03-16 11:01:06'),(819,'common',0,'Image','Image','2019-03-16 11:01:06'),(820,'common',0,'Text','Text','2019-03-16 11:01:06'),(821,'common',0,'watermarkType','Type of watermark','2019-03-16 11:01:06'),(822,'common',0,'Preview','Preview','2019-03-16 11:01:07'),(823,'common',0,'watermarkFile','File of watermark','2019-03-16 11:01:07'),(824,'common',0,'watermarkContent','Text for watermark','2019-03-16 11:01:07'),(825,'common',0,'watermarkTextColor','Text color','2019-03-16 11:01:07'),(826,'common',0,'watermarkTextOpacity','Opacity','2019-03-16 11:01:07'),(827,'common',0,'watermarkTextSize','Font size','2019-03-16 11:01:08'),(828,'common',0,'watermarkPosition','Position of watermark','2019-03-16 11:01:08'),(829,'common',0,'Invalid format of text color','Invalid format of text color','2019-03-16 11:01:08'),(830,'module_users',0,'admin_change_pass_user_help','If you would like to change the password type a new one. Otherwise leave this blank.','2019-03-16 11:01:08'),(831,'module_configuration',0,'module_notifier_adminNewApartment','Should the system send a letter to the administrator when new user has been added a listing? (if option \"Moderation of users\' listing\" enabled)','2019-03-16 11:01:09'),(832,'common',0,'Complains','Complaints','2019-03-16 11:02:47'),(833,'module_apartmentsComplain',0,'Complains','Complaints','2019-03-16 11:02:48'),(834,'module_apartmentsComplain',0,'Reasons of complain','Reasons of complaints','2019-03-16 11:02:49'),(835,'module_apartmentsComplain',0,'Add reasons of complain','Add reasons of complaint','2019-03-16 11:02:51'),(836,'module_apartmentsComplain',0,'Name','Name','2019-03-16 11:02:53'),(837,'module_apartmentsComplain',0,'Edit reasons of complain','Edit reasons of complaint','2019-03-16 11:02:54'),(838,'module_apartmentsComplain',0,'do_complain','Complain','2019-03-16 11:02:56'),(839,'module_apartmentsComplain',0,'Send complain','Send a complaint','2019-03-16 11:02:59'),(840,'module_apartmentsComplain',0,'Cause of complaint','Cause of complaint','2019-03-16 11:03:01'),(841,'module_apartmentsComplain',0,'Body','Reason','2019-03-16 11:03:03'),(842,'module_apartmentsComplain',0,'Creation date','Creation date','2019-03-16 11:03:05'),(843,'module_apartmentsComplain',0,'Thanks_for_complain','Thanks for complaint','2019-03-16 11:03:07'),(844,'module_configuration',0,'module_notifier_adminNewComplain','Should the system send a letter to the administrator when user has been added a complaint?','2019-03-16 11:03:10'),(845,'module_apartmentsComplain',0,'your_already_post_complain','You have already complained about this listing.','2019-03-16 11:03:12'),(846,'module_apartmentsComplain',0,'Email','Email','2019-03-16 11:03:14'),(847,'module_apartmentsComplain',0,'Apartment_id','Listing ID','2019-03-16 11:03:16'),(848,'module_apartmentsComplain',0,'Verification Code','Verification Code','2019-03-16 11:03:18'),(849,'common',0,'Upload files','Upload files','2019-03-16 11:03:19'),(850,'common',0,'Drop files here to upload','Drop files here to upload','2019-03-16 11:03:21'),(852,'module_apartments',0,'is_price_poa','Price on asking','2019-03-16 11:03:22'),(853,'common',0,'{label} cannot be blank.','{label} cannot be blank.','2019-03-16 11:03:24'),(854,'common',0,'price_from','from','2019-03-16 11:03:25'),(855,'common',0,'price_to','up to','2019-03-16 11:03:27'),(856,'common',0,'Activity','Activity','2019-03-16 11:03:28'),(857,'common',0,'Loading content...','Content is loading ...','2019-03-16 11:03:31'),(858,'common',0,'Owner additional info','Additional info','2019-03-16 11:03:32'),(859,'module_userads',0,'Awaiting moderation','Awaiting moderation','2019-03-16 11:03:34'),(860,'module_userads',0,'Active','Active','2019-03-16 11:03:35'),(861,'common',0,'Q&As','Q&As','2019-03-16 11:03:36'),(862,'common',0,'Authentication services','Authentication services','2019-03-16 11:03:38'),(863,'common',0,'Manage payments','Payments','2019-03-16 11:03:39'),(864,'common',0,'User managment','Users','2019-03-16 11:03:40'),(865,'common',0,'Manage settings','Settings','2019-03-16 11:03:42'),(866,'module_socialauth',0,'Social settings','Authentication services','2019-03-16 11:03:44'),(867,'common',0,'Any','Any','2019-03-16 11:03:46'),(868,'common',0,'uncheck all','Uncheck all','2019-03-16 11:03:47'),(869,'common',0,'quick search','Quick search','2019-03-16 11:03:50'),(870,'common',0,'enter initial letters','Enter initial letters','2019-03-16 11:03:51'),(871,'common',0,'Paid services','Paid services','2019-03-16 11:03:52'),(872,'module_apartments',0,'Rent a','Rent property from somebody','2019-03-16 11:03:54'),(873,'module_apartments',0,'Buy a','Buy','2019-03-16 11:03:56'),(874,'module_apartments',0,'Exchange','Exchange','2019-03-16 11:03:57'),(875,'common',0,'{n} day','{n} day|{n} days','2019-03-16 11:03:58'),(876,'module_apartments',0,'Exchange to','Exchange for','2019-03-16 11:03:59'),(877,'module_payment',0,'Manage payments','Payments','2019-03-16 11:04:02'),(878,'module_configuration',0,'images','Images','2019-03-16 11:04:03'),(879,'module_configuration',0,'seo','SEO','2019-03-16 03:59:50'),(880,'module_apartments',0,'Are you sure you want to delete this apartment?','Are you sure you want to permanently delete this listing?','2019-03-16 11:04:06'),(881,'module_apartments',0,'all_member_listings','All listings','2019-03-16 11:04:07'),(882,'module_apartments',0,'member_listings','View all listings of the user','2019-03-16 11:04:09'),(883,'module_apartments',0,'all_by_filter','All listings sorted by the filter','2019-03-16 11:04:10'),(884,'module_configuration',0,'urlExtension','Friendly URL extension \".html\"','2019-03-16 11:04:11'),(886,'module_apartments',0,'Rent','Rent out a property','2019-03-16 11:04:13'),(887,'module_apartments',0,'Sale','Sell','2019-03-16 11:04:15'),(888,'module_booking',0,'Booking apartment','Booking a property','2019-03-16 11:04:17'),(889,'common',0,'Update param \"{name}\"','Edit parameter \"{name}\"','2019-03-16 11:04:19'),(890,'module_apartments',0,'Want rent property to smb','Rent out a property','2019-03-16 11:04:20'),(891,'module_apartments',0,'Want sale','Sell','2019-03-16 11:04:22'),(892,'module_apartments',0,'Want rent property form smb','Rent a property','2019-03-16 11:04:25'),(893,'module_apartments',0,'Want buy','Buy','2019-03-16 11:04:27'),(894,'module_apartments',0,'Want exchange','Exchange','2019-03-16 11:04:29'),(895,'module_booking',0,'Operation successfully complete. Your order will be reviewed by owner.','Operation successfully complete. Your order will be reviewed by owner.','2019-03-16 11:04:31'),(896,'common',0,'Watermark file can\'t be empty.','Watermark file can\'t be empty.','2019-03-16 11:04:34'),(897,'common',0,'Photo gallery is empty.','Photo gallery is empty.','2019-03-16 11:04:36'),(898,'common',0,'Photos for listing','Photos for listing','2019-03-16 11:04:37'),(899,'common',0,'Characters left','Characters left','2019-03-16 11:04:38'),(900,'common',0,'Main photo','Main photo','2019-03-16 11:04:41'),(901,'common',0,'Set as main photo','Set as main photo','2019-03-16 11:04:42'),(902,'common',0,'{file} has invalid extension. Only {extensions} are allowed.','{file} has invalid extension. Only {extensions} are allowed.','2019-03-16 11:04:44'),(903,'common',0,'{file} is too large, maximum file size is {sizeLimit}.','{file} is too large, maximum file size is {sizeLimit}.','2019-03-16 11:04:45'),(904,'common',0,'{file} is too small, minimum file size is {minSizeLimit}.','{file} is too small, minimum file size is {minSizeLimit}.','2019-03-16 11:04:46'),(905,'common',0,'{file} is empty, please select files again without it.','{file} is empty, please select files again without it.','2019-03-16 11:04:48'),(906,'common',0,'The files are being uploaded, if you leave now the upload will be cancelled.','The files are being uploaded, if you leave now the upload will be cancelled.','2019-03-16 11:20:10'),(907,'module_images',0,'Comment','Comment','2019-03-16 11:20:17'),(908,'common',0,'General','General','2019-03-16 11:20:22'),(909,'common',0,'Addition','Addition','2019-03-16 11:20:27'),(910,'common',0,'Map','Map','2019-03-16 11:20:29'),(911,'common',0,'You can change the order of photos, holding and dragging the left area of the block.','You can change the order of photos, holding and dragging the left area of the block.','2019-03-16 11:20:31'),(912,'common',0,'Click on the map to set the location of an object or move an existing marker.','Click on the map to set the location of an object or move an existing marker.','2019-03-16 11:20:33'),(913,'common',0,'Edit','Edit','2019-03-16 11:20:39'),(914,'module_configuration',0,'priceThousandsSeparator','Separator in price to thousandths','2019-03-16 11:20:40'),(915,'module_configuration',0,'priceDecimalsPoint','Decimals point to price','2019-03-16 11:20:41'),(916,'common',0,'balance','Balance','2019-03-16 11:20:45'),(917,'common',0,'Add funds to account','Add funds to account','2019-03-16 11:20:49'),(918,'common',0,'Add amount of','Add amount of','2019-03-16 11:20:54'),(919,'common',0,'Please specify the amount of the payment','Please specify the amount of the payment','2019-03-16 11:20:58'),(920,'module_paidservices',0,'Error! You must upload the image for the ad.','Error! You must upload the image for the ad.','2019-03-16 11:21:02'),(921,'common',0,'Apply a paid service to the listing','Apply a paid service to the listing.','2019-03-16 11:21:06'),(922,'common',0,'Reference \"View:\"','Reference \"View:\"','2019-03-16 11:21:12'),(923,'common',0,'Current paid services','Current paid services','2019-03-16 11:21:14'),(924,'common',0,'Friendly URL and SEO settings','Edit Friendly URLs and SEO','2019-03-16 11:21:17'),(925,'common',0,'It is allowed to use the characters \"-a-zA-Z0-9_+.\" without spaces','It is allowed to use the characters \"-a-zA-Z0-9_+.\" without spaces','2019-03-16 11:21:19'),(926,'common',0,'is valid till','is valid till','2019-03-16 11:21:27'),(927,'common',0,'Apply','Apply','2019-03-16 11:21:30'),(928,'common',0,'Paid service successfully added','Paid service successfully added','2019-03-16 11:21:37'),(929,'module_lang',0,'Active','Activity','2019-03-16 11:21:44'),(930,'module_articles',0,'Manage FAQ','Manage Q&As','2019-03-16 11:21:48'),(931,'module_paidservices',0,'Add a paid service','Add a paid service','2019-03-16 11:21:52'),(932,'common',0,'Set a marker by address','Set a marker by address','2019-03-16 11:21:56'),(933,'common',0,'Please enter address','Please enter the address','2019-03-16 11:22:03'),(934,'module_iecsv',0,'selectedImportUser','Choose a user (whose name will be used as a name of the listings\' owner)','2019-03-16 11:22:05'),(935,'module_iecsv',0,'Please select user (owner listings).','Please, choose a user whose name will be used as a name of the listings\' owner.','2019-03-16 11:22:06'),(936,'module_iecsv',0,'Import / Export','Import / Export','2019-03-16 11:22:10'),(937,'module_iecsv',0,'Export','Export','2019-03-16 11:22:14'),(938,'module_iecsv',0,'You can export your listings into a .csv file. Exported fields are listed below.','You can export your listings into a file with a .csv format. The required for export fields are listed below.','2019-03-16 11:22:16'),(939,'module_iecsv',0,'Help / Documentation of use this option','Help / documentation how to use this option','2019-03-16 11:22:19'),(940,'module_iecsv',0,'Import','Import','2019-03-16 11:22:26'),(941,'module_iecsv',0,'Fields_import_export','Listing\'s type | Price\'s type | Property type | Price | Location | Number of bedrooms | Floor | Total number of floors | Square | Number of berths | Listing title | Description | What is near? | Address | Bathroom | Security | Comfort | Kitchen | Work | Entertainment | Services | On conditions | Image | Latitude | Longitude','2019-03-16 11:22:31'),(942,'module_iecsv',0,'2 variants of listings export are available.','2 variants of listings export are available. The first variant exports the data into a .csv file and the photos are exported by inserting links to the photos into a csv file. The second one creates a .zip archive containing .csv file with listings info and photo names. Photos will be exported into the same archive. This variant allows getting a stand-alone copy of selected listings with photos. This, however, may take long to export listings using the second variant (the speed depends on the number of photos).','2019-03-16 11:22:35'),(943,'module_iecsv',0,'You can populate your database importing a csv file with properties. You can also import listings with photos: create an archive of .zip structure described for ‘Export‘ operation.','You can populate your database importing a csv file with properties. You can also import listings with photos: create an archive of .zip structure described for ‘Export‘ operation.','2019-03-16 11:22:38'),(944,'module_iecsv',0,'Import from *.csv, *.zip:','Import from *. сsv, * zip:','2019-03-16 11:22:43'),(945,'module_iecsv',0,'Supported file *.csv encoding is UTF-8 without BOM.','Supported file *.csv encoding is UTF-8 without BOM.','2019-03-16 11:22:44'),(946,'module_iecsv',0,'The file is exported to the UTP-8 without BOM charset.','The file is exported to the UTP-8 without BOM charset.','2019-03-16 11:22:48'),(947,'module_iecsv',0,'Separators are \";\".','Separators are \";\".','2019-03-16 11:22:53'),(948,'module_iecsv',0,'Select','Select','2019-03-16 11:22:59'),(949,'module_iecsv',0,'ID','ID','2019-03-16 11:23:00'),(950,'module_iecsv',0,'Export to .zip file with photos included','Export to .zip file with photos included','2019-03-16 11:23:05'),(951,'module_iecsv',0,'Please select ads for export.','Please select ads for export.','2019-03-16 11:23:10'),(952,'module_iecsv',0,'title','Title','2019-03-16 11:23:17'),(953,'module_iecsv',0,'The file was larger than {size}. Please upload a smaller file.','The file was larger than {size}. Please upload a smaller file.','2019-03-16 11:23:20'),(954,'module_iecsv',0,'Please select a *.csv or *.zip file for import. Max size of file is {size}.','Please select a *.csv or *.zip file for import. Max size of file is {size}.','2019-03-16 11:23:24'),(955,'module_iecsv',0,'Listings are imported. You can edit and activate.','Listings are imported. You can edit and activate.','2019-03-16 11:23:25'),(956,'module_iecsv',0,'Please select ads for import.','Please, select listings for importing.','2019-03-16 11:23:28'),(957,'module_iecsv',0,'Error parsing csv file. Please try again later.','Error parsing csv file. Please try again later.','2019-03-16 11:23:34'),(958,'module_apartments',0,'video_file','Video file','2019-03-16 11:23:40'),(959,'module_apartments',0,'video_html','Code from Youtube','2019-03-16 11:23:42'),(960,'common',0,'Videos for listing','Video','2019-03-16 03:59:50'),(961,'common',0,'You can upload a video or code.','You can load the video file or put its Youtube code.','2019-03-16 11:23:49'),(962,'module_apartments',0,'Supported file: {supportExt}.','Supported file types: {supportExt}.','2019-03-16 11:23:57'),(963,'module_apartments',0,'videoMaxSite: {size}.','The maximum size of video file is {size}.','2019-03-16 11:23:59'),(964,'module_apartments',0,'incorrect_youtube_code','Invalid code from Youtube.','2019-03-16 11:24:06'),(965,'module_apartments',0,'not_create_folder_to_save','A folder for Save was not created.','2019-03-16 11:24:09'),(966,'common',0,'The forms designer','Forms Editor','2019-03-16 11:24:11'),(967,'module_formdesigner',0,'Field','Field','2019-03-16 11:24:13'),(968,'module_formdesigner',0,'Visibility','Visibility','2019-03-16 11:24:18'),(969,'common',0,'Configure','Set','2019-03-16 11:24:22'),(970,'module_configuration',0,'countListitngmap','Number of listings in \"Map\" mod','2019-03-16 11:24:25'),(971,'module_configuration',0,'countListitngtable','Number of listings in \"Table\" mode','2019-03-16 11:24:33'),(972,'module_configuration',0,'countListitngblock','Number of listings in \"Blocks\"mode','2019-03-16 11:24:36'),(973,'common',0,'Not specified_f','Not specified','2019-03-16 11:24:38'),(974,'common',0,'Not specified_m','Not specified','2019-03-16 11:24:43'),(975,'common',0,'City','City','2019-03-16 11:24:47'),(976,'common',0,'Country','Country','2019-03-16 11:24:49'),(977,'common',0,'Region','Region','2019-03-16 11:24:50'),(978,'common',0,'Name','Name','2019-03-16 11:24:53'),(979,'common',0,'select country','Select a country','2019-03-16 11:24:57'),(980,'common',0,'select region','Select a region','2019-03-16 11:24:58'),(981,'common',0,'Location module','Location module','2019-03-16 11:25:01'),(982,'common',0,'Cities','Cities','2019-03-16 11:25:06'),(983,'common',0,'Countries','Countries','2019-03-16 11:25:12'),(984,'common',0,'Regions','Regions','2019-03-16 11:25:18'),(985,'module_location',0,'Manage countries','Manage countries','2019-03-16 11:25:23'),(986,'module_location',0,'Manage regions','Manage regions','2019-03-16 11:25:29'),(987,'module_location',0,'Manage cities','Manage cities','2019-03-16 11:25:31'),(988,'module_location',0,'Add country','Add country','2019-03-16 11:25:38'),(989,'module_location',0,'Add region','Add region','2019-03-16 11:25:43'),(990,'module_location',0,'Add city','Add city','2019-03-16 11:25:45'),(991,'module_location',0,'Edit country','Edit country','2019-03-16 11:25:46'),(992,'module_location',0,'Edit region','Edit region','2019-03-16 11:25:48'),(993,'module_location',0,'Edit city','Edit city','2019-03-16 11:25:50'),(994,'common',0,'Go back to search results','Go back to search results','2019-03-16 11:25:55'),(995,'common',0,'{n} listings','{n} listing|{n} listings|{n} listings','2019-03-16 11:26:00'),(996,'module_configuration',0,'change_search_ajax','Change Search button \'Find\' when selecting parameters','2019-03-16 11:26:03'),(997,'common',0,'Move to the beginning of the list','Move to the beginning of the list','2019-03-16 11:26:04'),(998,'common',0,'Move to end of list','Move to end of list','2019-03-16 11:26:07'),(999,'module_apartments',0,'Note','Note','2019-03-16 11:26:12'),(1000,'module_apartments',0,'total square: {n}','total square: {n}','2019-03-16 11:26:13'),(1001,'module_socialauth',0,'You can not add listings till you specify your valid email.','You can not add listings till you specify your valid email.','2019-03-16 11:26:19'),(1002,'module_socialauth',0,'You can not add listings till you specify your phone number.','You can not add listings till you specify your phone number.','2019-03-16 11:26:20'),(1003,'module_apartments',0,'ownerUsername','Owner name','2019-03-16 11:26:23'),(1004,'module_configuration',0,'mail_fromName','Owner email, Owner name, Send emails from the name of (if it is not set, so an email is sent from the name of the administrator )','2019-03-16 11:26:29'),(1005,'module_apartments',0,'Owner email','Owner email','2019-03-16 11:26:36'),(1006,'module_formdesigner',0,'Tip','Hint','2019-03-16 11:26:37'),(1007,'module_formdesigner',0,'Settings for the field','Settings for the field','2019-03-16 11:26:39'),(1008,'module_formdesigner',0,'Show for property types','Show for property types','2019-03-16 11:26:42'),(1009,'module_apartments',0,'The file was larger than {size}MB. Please upload a smaller file.','File\'s size is larger than {size}MB. Please upload a file with smaller size.','2019-03-16 11:26:44'),(1010,'common',0,'Panorama','Panorama','2019-03-16 03:59:50'),(1011,'common',0,'A wide angle panorama-image or a ready SWF file of the panorama','A wide angle panorama-image or a ready SWF file of the panorama','2019-03-16 11:26:52'),(1012,'module_configuration',0,'useCompactInnerSearchForm','Use a compact search form on inner pages of the site','2019-03-16 11:26:55'),(1013,'common',0,'Apartment ID','Listing ID','2019-03-16 11:27:02'),(1014,'module_advertising',0,'Views','Views','2019-03-16 11:27:05'),(1015,'module_advertising',0,'Clicks','Hits','2019-03-16 11:27:08'),(1016,'module_apartments',0,'Land square','Land square','2019-03-16 11:27:10'),(1017,'module_apartments',0,'land square','land square','2019-03-16 11:27:15'),(1018,'module_apartments',0,'land square: {n}','land square: {n}','2019-03-16 11:27:21'),(1019,'common',0,'site_land_square','ares','2019-03-16 03:59:50'),(1020,'module_configuration',0,'useTypeSale','Possibility to add listings of the type \"Sell\"','2019-03-16 11:27:25'),(1021,'module_configuration',0,'useTypeRenting','Possibility to add listings of the type \"Rent a property\"','2019-03-16 11:27:29'),(1022,'module_configuration',0,'useTypeBuy','Possibility to add listings of the type \"Buy\"','2019-03-16 11:27:35'),(1023,'module_configuration',0,'useTypeChange','Possibility to add listings of the type \"Exchange\"','2019-03-16 11:27:41'),(1024,'module_socialauth',0,'useMailruOAuth','Use Mail.ru authorization','2019-03-16 11:27:42'),(1025,'module_socialauth',0,'mailruClientId','ID','2019-03-16 11:27:44'),(1026,'module_socialauth',0,'mailruClientSecret','Client secret','2019-03-16 03:59:50'),(1027,'module_socialauth',0,'mailru_label','Mail.ru','2019-03-16 11:27:51'),(1028,'module_socialauth',0,'mailru','Mail.ru','2019-03-16 11:27:52'),(1029,'module_comparisonList',0,'Add to a comparison list ','Add to a comparison list ','2019-03-16 11:27:56'),(1030,'module_comparisonList',0,'In the comparison list','In the comparison list','2019-03-16 11:28:00'),(1031,'module_comparisonList',0,'max_limit','Maximum {n} listings','2019-03-16 11:28:01'),(1032,'module_comparisonList',0,'Comparison list','Comparison list','2019-03-16 11:28:04'),(1033,'module_currency',0,'moduleAdminHelp','You can not deactivate the currency which is set as default for an active language.\nYou can deactivate the language in the section {link}','2019-03-16 11:28:10'),(1034,'module_lang',0,'moduleAdminHelp','You can not activate the language which has an inactive currency as default. You can activate the currency in the section {link}','2019-03-16 11:28:15'),(1035,'module_configuration',0,'share','Share','2019-03-16 11:28:17'),(1036,'module_configuration',0,'useYandexShare','Use the service \"Yandex.Share\"','2019-03-16 11:28:24'),(1037,'module_configuration',0,'useInternalShare','Use a built-in function of the website','2019-03-16 11:28:25'),(1038,'module_configuration',0,'intenalServices','Buttons of a built-in function of the website (the services should be separated by commas with no spaces)','2019-03-16 11:28:31'),(1039,'module_configuration',0,'yaShareServices','Buttons of the service \"Yandex.Share\" (the services should be separated by commas with no spaces)','2019-03-16 11:28:35'),(1040,'common',0,'Collapse search','Minimize the search','2019-03-16 11:28:37'),(1041,'common',0,'Type','Type','2019-03-16 11:28:39'),(1042,'module_formeditor',0,'Add field','Add a field','2019-03-16 11:28:40'),(1043,'module_formeditor',0,'Edit search form','Edit the search form','2019-03-16 11:28:45'),(1044,'module_formdesigner',0,'Measure unit','Unit of measurement ','2019-03-16 11:28:51'),(1045,'module_formeditor',0,'type reference','Reference','2019-03-16 11:28:55'),(1046,'module_formeditor',0,'type text','Textbox','2019-03-16 11:29:01'),(1047,'module_formeditor',0,'type text area','A large textbox','2019-03-16 11:29:03'),(1048,'module_formeditor',0,'type INT','A numeric field','2019-03-16 11:29:05'),(1049,'module_formeditor',0,'value no required','The value is not required','2019-03-16 11:29:06'),(1050,'module_formeditor',0,'value required','The value is required ','2019-03-16 11:29:13'),(1051,'module_formeditor',0,'value required and must be numerical','The value is required and should be a number','2019-03-16 11:29:20'),(1052,'module_formeditor',0,'value must be numerical','The value should be a number','2019-03-16 11:29:21'),(1053,'module_formeditor',0,'Display in general.','Display in the \'General\' Tab','2019-03-16 11:29:27'),(1054,'module_formeditor',0,'Display in extended.','Display in the \'Addition\' Tab','2019-03-16 11:29:33'),(1055,'module_formeditor',0,'For search','For the search','2019-03-16 11:29:39'),(1056,'module_formeditor',0,'category','Category','2019-03-16 11:29:45'),(1057,'module_formeditor',0,'compare equal','The field must be equal to','2019-03-16 11:29:51'),(1058,'module_formeditor',0,'compare like','The field must contain a part','2019-03-16 11:29:52'),(1059,'module_formeditor',0,'compare from','The field must be greater than or equal to','2019-03-16 11:29:54'),(1060,'module_formeditor',0,'compare to','The field must be less than or equal to','2019-03-16 11:29:55'),(1061,'common',0,'Search by chislo1','Number of','2019-03-16 11:29:57'),(1062,'module_formeditor',0,'The new field is successfully created.','A new field has been successfully created.','2019-03-16 11:30:01'),(1063,'module_formeditor',0,'Such comparison is possible only for numeric fields','Such a comparison is possible only for a numeric field','2019-03-16 11:30:06'),(1064,'common',0,'Search by spravochnik1','directory','2019-03-16 11:30:11'),(1065,'common',0,'Default search','A default search (form)','2019-03-16 11:30:14'),(1066,'module_formeditor',0,'Edit search form help','Choose a property type. Use your mouse to drag the fields which you would like to search by from the right column to the left one. You can also drag the fields that the search form for this property type should not have from the left column to the right one. Then click \"Save\".','2019-03-16 11:30:20'),(1067,'common',0,'Success','Data has been saved successfully','2019-03-16 11:30:26'),(1069,'module_formeditor',0,'Update field','Edit the field','2019-03-16 11:30:32'),(1071,'common',0,'The listing is succesfullty added and is awaiting moderation','The listing is succesfullty added and is awaiting moderation','2019-03-16 11:30:36'),(1072,'common',0,'The listing is succesfullty added','The listing is succesfullty added','2019-03-16 11:30:37'),(1073,'module_formeditor',0,'Category for the \"Forms Editor\"','Category for the \"Forms Editor\"','2019-03-16 11:30:44'),(1074,'module_formeditor',0,'Usual category','Usual category','2019-03-16 11:30:47'),(1075,'module_formdesigner',0,'Type','Type','2019-03-16 11:30:49'),(1076,'module_formdesigner',0,'Reference','Reference','2019-03-16 11:30:55'),(1077,'module_formdesigner',0,'Validation rules for a field','Validation rules for a field','2019-03-16 11:30:57'),(1078,'module_formdesigner',0,'Display in','Display','2019-03-16 11:31:00'),(1079,'module_formdesigner',0,'Comparison in the search','Comparison in the search','2019-03-16 11:31:01'),(1080,'module_formdesigner',0,'Label','Label','2019-03-16 11:31:04'),(1081,'module_formeditor',0,'Add field help','The new fields which were added are not involved in the Import/Export of listings.','2019-03-16 11:31:10'),(1083,'module_apartments',0,'Period of listing\'s activity','Period of listing\'s activity','2019-03-16 11:31:16'),(1084,'module_apartments',0,'a week','a week','2019-03-16 11:31:23'),(1085,'module_apartments',0,'a month','a month','2019-03-16 11:31:27'),(1086,'module_apartments',0,'3 months','3 months','2019-03-16 11:31:35'),(1087,'module_apartments',0,'6 months','6 months','2019-03-16 11:31:40'),(1088,'module_apartments',0,'a year','a year','2019-03-16 11:31:45'),(1089,'module_apartments',0,'always','always','2019-03-16 11:31:50'),(1090,'common',0,'The listing will be active till {DATE}','The listing will be active till {DATE}','2019-03-16 11:31:52'),(1091,'module_configuration',0,'apartment_periodActivityDefault','The default period of listing\'s activity','2019-03-16 11:31:59'),(1092,'module_apartments',0,'Display block','Display units','2019-03-16 11:32:02'),(1093,'module_apartments',0,'Display table','See table','2019-03-16 11:32:03'),(1094,'module_apartments',0,'Display with a map','See a map','2019-03-16 11:32:08'),(1095,'module_formeditor',0,'The name of a field in a table','Field name in the table','2019-03-16 11:32:16'),(1096,'module_comments',0,'Thank you for your comment.','Thanks for your comment.','2019-03-16 11:32:22'),(1097,'module_comments',0,'commentNotFound','The comment is not found, or you are not allowed to remove it.','2019-03-16 11:32:24'),(1098,'module_comments',0,'Reply','Reply','2019-03-16 11:32:25'),(1099,'module_configuration',0,'commentAllowForGuests','Should the system allow unregistered users to add comments?','2019-03-16 11:32:31'),(1100,'module_configuration',0,'useCaptchaCommentsForRegistered','Should the system use the captcha, when a registered user adds a comment?','2019-03-16 11:32:37'),(1101,'module_configuration',0,'enableCommentsForApartments','Should the system allow to add comments to the listings?','2019-03-16 11:32:40'),(1102,'module_configuration',0,'enableCommentsForEntries','Should the system allow to add comments to the \"Articles\"?','2019-03-16 11:32:42'),(1103,'module_configuration',0,'enableCommentsForPages','Should the system allow to add comments to the pages of the site?','2019-03-16 11:32:43'),(1104,'module_configuration',0,'enableCommentsForFaq','Should the system allow to add comments to \"Q&As\"?','2019-03-16 11:32:49'),(1105,'module_configuration',0,'osmap','OpenStreetMap','2019-03-16 03:59:50'),(1106,'module_configuration',0,'useOSMMap','Use the module of the OpenStreetMap on the site','2019-03-16 11:32:55'),(1107,'module_configuration',0,'module_apartments_osmapsCenterX','To center the Map by default, longitude (X)','2019-03-16 11:32:59'),(1108,'module_configuration',0,'module_apartments_osmapsCenterY','To center the Map by default, latitude (Y)','2019-03-16 11:33:04'),(1109,'module_configuration',0,'module_apartments_osmapsZoomCity','Zoom level for viewing a city map','2019-03-16 11:33:08'),(1110,'module_configuration',0,'module_apartments_osmapsZoomApartment','Zoom level for viewing a listing','2019-03-16 11:33:14'),(1111,'common',0,'Info pages','Info pages','2019-03-16 11:33:20'),(1112,'module_infopages',0,'Manage infopages','Infopages managment','2019-03-16 11:33:25'),(1113,'module_infopages',0,'Add infopage','Add a page','2019-03-16 11:33:31'),(1114,'module_infopages',0,'Page title','Headline','2019-03-16 11:33:33'),(1115,'module_infopages',0,'Page body','Page content','2019-03-16 11:33:37'),(1116,'module_infopages',0,'Creation date','Creation date','2019-03-16 11:33:38'),(1117,'module_infopages',0,'Edit infopage','Edit the page','2019-03-16 11:33:42'),(1118,'module_infopages',0,'Delete infopage','Delete the page','2019-03-16 11:33:43'),(1119,'module_menumanager',0,'Parent element','Parent\'s element','2019-03-16 11:33:51'),(1120,'module_menumanager',0,'Position','Position','2019-03-16 11:33:53'),(1121,'module_menumanager',0,'pageId','Page','2019-03-16 11:33:57'),(1122,'module_menumanager',0,'Nothing','Nothing','2019-03-16 11:33:58'),(1123,'module_menumanager',0,'Info pages','Info pages','2019-03-16 11:34:00'),(1124,'module_menumanager',0,'Editing of this section is not allowed','Editing of this section is not allowed','2019-03-16 11:34:02'),(1125,'module_menumanager',0,'The parent node wasn\'t created. Please try again later.','The parent node wasn\'t created. Please try again later.','2019-03-16 11:34:05'),(1126,'module_menumanager',0,'Enter the name of the menu item','Enter the name of the menu item','2019-03-16 11:34:07'),(1127,'module_menumanager',0,'Dou you really want to rename menu item','Dou you really want to rename menu item','2019-03-16 11:34:08'),(1128,'module_menumanager',0,'in','in','2019-03-16 11:34:16'),(1129,'module_menumanager',0,'Rename menu item','Rename menu item','2019-03-16 11:34:23'),(1130,'module_menumanager',0,'Do you really want to remove the menu item','Do you really want to remove the menu item','2019-03-16 11:34:25'),(1131,'module_menumanager',0,'and all its descendants?','and all its descendants?','2019-03-16 11:34:28'),(1132,'module_menumanager',0,'Delete a menu item','Delete a menu item','2019-03-16 11:34:34'),(1133,'module_menumanager',0,'Create inside','Create inside','2019-03-16 11:34:39'),(1134,'common',0,'Rename','Rename','2019-03-16 11:34:46'),(1135,'module_menumanager',0,'Delete','Delete','2019-03-16 11:34:51'),(1136,'module_menumanager',0,'Edit','Edit','2019-03-16 11:34:53'),(1137,'module_menumanager',0,'Move around menu items is not allowed','Move around menu items is not allowed','2019-03-16 11:34:59'),(1138,'module_infopages',0,'help_infopages_backend_main_admin','In this section you can add pages that you can put either in the menu or indicate links in the content of another pages.','2019-03-16 11:35:03'),(1139,'module_menumanager',0,'help_menumanager_backend_main_admin','If you right-click on the name of the menu item, you can see the context menu with available actions. You can add max. 3 levels. There is also an opportunity to hold the left mouse button and move the menu items up and down.','2019-03-16 11:35:07'),(1140,'module_menumanager',0,'Main menu','Main menu','2019-03-16 11:35:10'),(1141,'common',0,'Search by description or address','Search by description or address','2019-03-16 11:35:17'),(1142,'common',0,'Minimum {min} characters.','Minimum {min} characters.','2019-03-16 11:35:20'),(1143,'common',0,'Search by term','Search by keywords','2019-03-16 11:35:26'),(1144,'module_socialauth',0,'Go to link for register Mail.ru application - {link}','Go to link for register Mail.ru application - {link}','2019-03-16 11:35:32'),(1145,'module_socialposting',0,'Configure the services of automatic posting','Configure the services of automatic posting','2019-03-16 11:35:36'),(1146,'module_socialposting',0,'Allow the application to post notes - {link}','Allow the application to post notes - {link}','2019-03-16 11:35:39'),(1147,'module_socialposting',0,'Go to link for register VK.com application - {link}','To register VK.com application click the link  - {link}','2019-03-16 11:35:43'),(1148,'module_socialposting',0,'Get a Token for VK.com - {link}','Get a Token for VK.com - {link}','2019-03-16 11:35:48'),(1149,'module_socialposting',0,'Section','Section','2019-03-16 11:35:50'),(1150,'module_socialposting',0,'twitter','Twitter','2019-03-16 03:59:50'),(1151,'module_socialposting',0,'vkontakte','VK.com','2019-03-16 11:35:57'),(1152,'module_socialposting',0,'Setting','Setting','2019-03-16 11:35:59'),(1153,'module_socialposting',0,'Value','Value','2019-03-16 11:36:01'),(1154,'module_socialposting',0,'useTwitter','Use Twitter autoposting','2019-03-16 11:36:04'),(1155,'module_socialposting',0,'twitterApiKey','API key','2019-03-16 03:59:50'),(1156,'module_socialposting',0,'twitterApiSecret','API secret','2019-03-16 03:59:50'),(1157,'module_socialposting',0,'twitterTokenKey','Access token','2019-03-16 03:59:50'),(1158,'module_socialposting',0,'twitterTokenSecret','Access token secret','2019-03-16 03:59:50'),(1159,'module_socialposting',0,'useVkontakte','Use VK.com autoposting','2019-03-16 11:36:25'),(1160,'module_socialposting',0,'vkontakteApplicationId','Application\'s id','2019-03-16 11:36:31'),(1161,'module_socialposting',0,'vkontakteToken','Token','2019-03-16 03:59:50'),(1162,'module_socialposting',0,'vkontakteUserId','User\'s ID','2019-03-16 11:36:37'),(1163,'module_socialposting',0,'Enter the required value','Enter the required value','2019-03-16 11:36:38'),(1164,'module_socialposting',0,'Services of automatic posting','Services of automatic posting','2019-03-16 11:36:45'),(1165,'module_socialposting',0,'Go to link for register Twitter application - {link}','To register Twitter application click the link  - {link}','2019-03-16 11:36:50'),(1166,'module_socialposting',0,'Update {name}','Update {name}','2019-03-16 11:36:57'),(1167,'module_socialposting',0,'Update param \"{name}\"','Edit parameter \"{name}\"','2019-03-16 11:37:04'),(1168,'module_socialposting',0,'Update param \"{name}\"','Edit parameter \"{name}\"','2019-03-16 11:37:09'),(1169,'common',0,'Listing provided by','Listing was posted by','2019-03-16 11:37:13'),(1170,'common',0,'Show phone','Phone number','2019-03-16 11:37:16'),(1171,'module_reviews',0,'Reviews','Reviews','2019-03-16 11:37:18'),(1172,'module_reviews',0,'Reviews_management','Reviews management','2019-03-16 11:37:22'),(1173,'module_reviews',0,'Add_feedback','Add a review','2019-03-16 11:37:25'),(1174,'module_reviews',0,'Name','Name','2019-03-16 11:37:29'),(1175,'module_reviews',0,'Body','Body','2019-03-16 11:37:33'),(1176,'module_reviews',0,'Date created','Date created','2019-03-16 11:37:39'),(1177,'module_reviews',0,'Last updated on','Last updated on','2019-03-16 11:37:40'),(1178,'module_reviews',0,'Edit_review','Edit a review','2019-03-16 11:37:44'),(1179,'module_reviews',0,'Delete_review','Delete review','2019-03-16 11:37:49'),(1180,'module_reviews',0,'View_review','Watch review','2019-03-16 11:37:53'),(1181,'module_reviews',0,'Review list is empty','Review list is empty','2019-03-16 11:37:55'),(1182,'module_reviews',0,'success_send','The review was successfully sent and will be available after moderation.','2019-03-16 11:37:58'),(1183,'module_reviews',0,'failed_send','The review wasn\'t sent! Please correct the errors and try again.','2019-03-16 11:38:05'),(1184,'module_reviews',0,'success_send_not_moderation','The review was successfully sent.','2019-03-16 11:38:06'),(1185,'common',0,'Mail editor','Mail editor','2019-03-16 11:38:11'),(1186,'module_notifier',0,'Mail template for users','Mail template for users','2019-03-16 11:38:17'),(1187,'common',0,'Subject','Subject','2019-03-16 11:38:19'),(1188,'common',0,'Body','Body','2019-03-16 11:38:24'),(1189,'module_notifier',0,'Mail template for admin','Mail template for admin','2019-03-16 11:38:30'),(1190,'common',0,'Private person','Private person','2019-03-16 11:38:31'),(1191,'common',0,'Company','Agency','2019-03-16 11:38:33'),(1192,'common',0,'Agent','Agent','2019-03-16 11:38:40'),(1193,'module_usercpanel',0,'Booking','Booking','2019-03-16 11:38:45'),(1194,'module_booking',0,'Status confirm','Confirmed','2019-03-16 11:38:51'),(1195,'module_booking',0,'Status not confirm','Unconfirmed','2019-03-16 11:38:57'),(1196,'module_booking',0,'Status new','New','2019-03-16 11:39:04'),(1197,'module_booking',0,'Status view','Viewed','2019-03-16 11:39:12'),(1198,'module_booking',0,'booking_table_to_calendar','While changing the status to \"Confirmed\" the selected booking dates will be listed automatically in the \"Calendar for booking a property\".','2019-03-16 11:39:14'),(1199,'common',0,'Upload file','Upload file','2019-03-16 11:39:19'),(1200,'common',0,'My listings','My listings','2019-03-16 11:39:25'),(1201,'common',0,'by username','by username','2019-03-16 11:39:32'),(1202,'common',0,'by date of registration','by date of registration','2019-03-16 11:39:34'),(1203,'common',0,'Private persons','Private persons','2019-03-16 11:39:36'),(1204,'common',0,'Agents','Agents','2019-03-16 11:39:39'),(1205,'common',0,'Agency','Real Estate Agencies','2019-03-16 11:39:44'),(1206,'common',0,'My data','My data','2019-03-16 11:39:45'),(1207,'module_usercpanel',0,'My payments','My payments','2019-03-16 11:39:47'),(1208,'common',0,'My balance','My balance','2019-03-16 11:39:48'),(1209,'module_usercpanel',0,'Booking applications','Booking applications','2019-03-16 11:39:54'),(1210,'common',0,'On the balance','On the balance','2019-03-16 11:40:00'),(1211,'module_usercpanel',0,'Replenish the balance','Replenish the balance','2019-03-16 11:40:01'),(1212,'common',0,'Please refill the balance','Please refill the balance','2019-03-16 11:40:02'),(1213,'common',0,'No information','No information','2019-03-16 11:40:04'),(1214,'common',0,'Manage modules','Modules management','2019-03-16 11:40:11'),(1215,'common',0,'Module is disabled','The module is disabled','2019-03-16 11:40:15'),(1216,'common',0,'Enable','Enable','2019-03-16 11:40:16'),(1217,'common',0,'Disable','Disable','2019-03-16 11:40:19'),(1218,'common',0,'module_name_apartmentsComplain','Module \"Complaints\"','2019-03-16 11:40:22'),(1219,'common',0,'module_description_apartmentsComplain','With the help of this module you can receive complaints about listings (repeats, spam, false information, etc.) from users','2019-03-16 11:40:27'),(1220,'common',0,'module_name_similarads','Module \"Similar listings\"','2019-03-16 11:40:34'),(1221,'common',0,'module_description_similarads','You can observe several similar objects (if they exist) on this page by viewing one real estate object.','2019-03-16 11:40:38'),(1222,'common',0,'module_name_socialauth','Module \"Authorization through social networks\"','2019-03-16 11:40:40'),(1223,'common',0,'module_description_socialauth','It allows you to enter the site without registration, using only your profiles in social networks.','2019-03-16 11:40:41'),(1224,'common',0,'module_name_comparisonList','Module \"List of comparison\"','2019-03-16 11:40:47'),(1225,'common',0,'module_description_comparisonList','You can add objects into the list of comparison for further detailed analysis of listings differences.','2019-03-16 11:40:53'),(1226,'common',0,'module_name_rss','Module \"RSS feed\"','2019-03-16 11:40:58'),(1227,'common',0,'module_description_rss','This module allows you to track all listings, which were specified by search criteria.','2019-03-16 11:41:02'),(1228,'common',0,'module_name_seo','Module \"SEO\"','2019-03-16 11:41:05'),(1229,'common',0,'module_description_seo','This module offers you extended functions on search engine optimization of your website. Ability to set: url, meta title, meta keywords, meta description for listings, news, other website sections.','2019-03-16 11:41:09'),(1230,'common',0,'module_name_sitemap','Module \"Site map\"','2019-03-16 11:41:17'),(1231,'common',0,'module_description_sitemap','This module allows you to:<br/>\r\n- display links to all sections of your website within one page,<br/>\r\n- create xml-version for search robots','2019-03-16 11:41:24'),(1232,'common',0,'module_name_socialposting','Module \"Posting of listings to social networks\"','2019-03-16 11:41:25'),(1233,'common',0,'module_description_socialposting','This module allows you to duplicate automatically all new listings to social networks.','2019-03-16 11:41:31'),(1234,'common',0,'module_name_iecsv','Module \"Import / Export of listings\"','2019-03-16 11:41:37'),(1235,'common',0,'module_description_iecsv','With the help of this module you will be able to:<br/>\r\n- load listings in the format of a csv file,<br/>\r\n- download listings in the format of a csv file.<br/>\r\nIt allows to:<br/>\r\n- interact with different realty databases,<br/>\r\n- make a backup copy of listings base.','2019-03-16 11:41:40'),(1236,'common',0,'module_name_location','Module \"Location\"','2019-03-16 11:41:44'),(1237,'common',0,'module_description_location','It will let you specify not only the city where the property is, but its region and its country as well. Therefore, the search form will be changed according to it, so that the listings can be found easier and more quickly.','2019-03-16 11:41:47'),(1238,'common',0,'Module is not installed','This module is not installed','2019-03-16 11:41:53'),(1239,'common',0,'Buy module','Buy this module','2019-03-16 11:42:00'),(1240,'common',0,'module_name_yandexRealty','Module \"Yandex.Realty\"','2019-03-16 11:42:04'),(1241,'common',0,'module_description_yandexRealty','This extension will allow you to transfer the listings from the site to one of the largest and frequently visited realty databases in Russia.','2019-03-16 11:42:10'),(1242,'common',0,'module_name_slider','Module \"Slide-show management\"','2019-03-16 11:42:18'),(1243,'common',0,'module_description_slider','It allows you to manage the slide-show on the home page with just a few clicks of your mouse. With the help of this module you can:<br/>\r\n- manage images from the admin panel,<br/>\r\n- set titles for images,<br/>\r\n- set links for images.','2019-03-16 11:42:22'),(1244,'common',0,'module_name_advertising','Module \"Advertising banners\"','2019-03-16 11:42:26'),(1245,'common',0,'module_description_advertising','This module allows you to place different banners on site pages. For every banner you can choose: setting a position, pages for its displaying.','2019-03-16 11:42:31'),(1246,'common',0,'module_name_bookingcalendar','Module \"Сalendar for booking a property\"','2019-03-16 11:42:38'),(1247,'common',0,'module_description_bookingcalendar','It allows to:<br/>\r\n- mark the periods when the property is free or reserved,<br/>\r\n- display a calendar with visual information about it (free and reserved days are highlighted with different colors) on the listing\'s page.','2019-03-16 11:42:43'),(1248,'common',0,'module_name_formeditor','Module \"The extended form editor\"','2019-03-16 11:42:45'),(1249,'common',0,'module_description_formeditor','With the help of it you will be able to:<br/>\r\n- add new fields,<br/>\r\n- edit fields,<br/>\r\n- add them into the search.','2019-03-16 11:42:49'),(1250,'common',0,'Module is enabled','The module is enabled','2019-03-16 11:42:53'),(1251,'module_usercpanel',0,'My agents','My agents','2019-03-16 11:42:58'),(1252,'module_usercpanel',0,'Register as','Register as','2019-03-16 11:42:59'),(1253,'module_usercpanel',0,'Registered','Registered','2019-03-16 11:43:01'),(1254,'common',0,'No user','No useres','2019-03-16 11:43:05'),(1255,'common',0,'Agency name','Agency','2019-03-16 11:43:12'),(1256,'common',0,'This user \"{name}\" is not your agent anymore','This user \"{name}\" is not your agent anymore.','2019-03-16 11:43:16'),(1257,'module_notifier',0,'The variables are available in this template','The variables are available in this template','2019-03-16 11:43:23'),(1258,'module_infopages',0,'Bottom','Bottom','2019-03-16 11:43:28'),(1259,'module_infopages',0,'Top','Top','2019-03-16 11:43:31'),(1260,'module_infopages',0,'Widget','Widget','2019-03-16 03:59:50'),(1261,'module_infopages',0,'Widget\'s position','Widget\'s position','2019-03-16 11:43:38'),(1262,'module_infopages',0,'Filter for listings\' list','Filter for listings\' list','2019-03-16 11:43:41'),(1263,'module_users',0,'Waiting for acknowledge','Waiting for acknowledge','2019-03-16 11:43:46'),(1264,'module_users',0,'Confirmed','Confirmed','2019-03-16 11:43:53'),(1265,'common',0,'of','of','2019-03-16 11:43:55'),(1266,'module_seo',0,'Direct url','Direct url','2019-03-16 11:44:01'),(1267,'common',0,'It is allowed to use the characters \"-a-zA-Z0-9_+\" without spaces','It is allowed to use the characters \"-a-zA-Z0-9_+\" without spaces','2019-03-16 11:44:07'),(1268,'module_seo',0,'This url already exists','This url already exists','2019-03-16 11:44:09'),(1269,'module_seo',0,'The same URL for different languages','The same URL for different languages','2019-03-16 11:44:14'),(1270,'module_notifier',0,'New message (contact form)','New message (contact form)','2019-03-16 11:44:15'),(1271,'module_notifier',0,'New message from ::name (::email ::phone). Message text: ::body','New message is sent for you from ::name (::email ::phone). Message text: ::body','2019-03-16 11:44:21'),(1272,'module_notifier',0,'New payment through a bank.','A new payment via a bank.','2019-03-16 11:44:27'),(1273,'module_notifier',0,'New payment through a bank in the amount of ::amount ::currency_charcode','A new payment via a bank of the amount of ::amount ::currency_charcode','2019-03-16 11:44:29'),(1274,'module_notifier',0,'New complain added.','New complaint was added.','2019-03-16 11:44:33'),(1275,'module_notifier',0,'New complain was added. From ::name (::email). Complain text: ::body','New complaint was added. From ::name (::email). Complaint text: ::body','2019-03-16 11:44:40'),(1276,'module_notifier',0,'You can view it at','You can view it at','2019-03-16 11:44:46'),(1277,'module_notifier',0,'Message for the listing\'s owner №','Message for the listing\'s owner №','2019-03-16 11:44:49'),(1278,'module_apartments',0,'Booking apartment','Booking a property','2019-03-16 11:44:50'),(1279,'module_menumanager',0,'is_blank','Open in a new browser window','2019-03-16 11:44:51'),(1280,'common',0,'Manage themes','Themes management','2019-03-16 11:44:56'),(1281,'module_themes',0,'Manage themes','Themes management','2019-03-16 11:44:58'),(1282,'module_themes',0,'title','Title theme','2019-03-16 11:45:00'),(1283,'module_themes',0,'Is Default','By default','2019-03-16 11:45:01'),(1284,'common',0,'Go up','Go up','2019-03-16 11:45:03'),(1285,'common',0,'Type of listing','Type of listing','2019-03-16 11:45:07'),(1286,'common',0,'Cookies are disabled','Cookies are disabled','2019-03-16 11:45:11'),(1287,'common',0,'Please, enable cookies in your browser','Please, enable cookies in your browser','2019-03-16 11:45:17'),(1288,'module_payment',0,'The payment is successfully completed. The paid service has been activated.','The payment is successfully completed. The paid service has been activated.','2019-03-16 11:45:20'),(1289,'module_configuration',0,'useUserRegistration','Allow user registration','2019-03-16 11:45:27'),(1290,'common',0,'Please tell the seller that you have found this listing here {n}','Please tell the seller that you have found this listing here {n}','2019-03-16 11:45:29'),(1291,'module_messages',0,'Messages','Messages','2019-03-16 11:45:30'),(1292,'module_messages',0,'Mailing messages','Newsletter','2019-03-16 11:45:31'),(1293,'common',0,'module_name_messages','Module \"On site mailbox\"','2019-03-16 11:45:33'),(1294,'common',0,'module_description_messages','You can use this module to send messages to your site users. Besides they can maintain an inner correspondence with each other,','2019-03-16 11:45:39'),(1295,'module_messages',0,'My mailbox','My mailbox','2019-03-16 11:45:45'),(1296,'module_messages',0,'no_messages','No messages','2019-03-16 11:45:47'),(1297,'common',0,'Mailing messages','Newsletter','2019-03-16 11:45:53'),(1298,'module_messages',0,'ID','ID','2019-03-16 11:45:57'),(1299,'module_messages',0,'Sender ID','Sender','2019-03-16 11:45:58'),(1300,'module_messages',0,'Recipient ID','Recipient','2019-03-16 11:46:01'),(1301,'module_messages',0,'Message','Message','2019-03-16 11:46:06'),(1302,'module_messages',0,'Read','Read','2019-03-16 11:46:13'),(1303,'module_messages',0,'Sending date','Send date','2019-03-16 11:46:17'),(1304,'module_messages',0,'Reading date','Date of reading','2019-03-16 11:46:23'),(1305,'module_messages',0,'Attach file','Attach file','2019-03-16 11:46:27'),(1306,'module_messages',0,'Status','Status','2019-03-16 11:46:32'),(1307,'module_messages',0,'Files','Files','2019-03-16 11:46:38'),(1308,'module_messages',0,'fromListingId','Listing ID','2019-03-16 11:46:42'),(1309,'module_messages',0,'Supported file: {supportExt}.','Supported types of files: {supportExt}','2019-03-16 11:46:43'),(1310,'module_messages',0,'Max file size: {fileMaxSize}.','The maximum size of file is {fileMaxSize}.','2019-03-16 11:46:48'),(1311,'module_messages',0,'The selected file has already been added!','The choosen file is already attached','2019-03-16 11:46:56'),(1312,'module_messages',0,'Unsupported file type!','Unsupported file type','2019-03-16 11:46:58'),(1313,'module_messages',0,'You have {n} unread messages','You have {n} unread messages','2019-03-16 11:47:05'),(1314,'module_messages',0,'userType','Type','2019-03-16 11:47:09'),(1315,'module_messages',0,'withListings','With ads','2019-03-16 11:47:11'),(1316,'module_messages',0,'countryListing','Ads in the country','2019-03-16 11:47:15'),(1317,'module_messages',0,'regionListing','Ads in the region','2019-03-16 11:47:16'),(1318,'module_messages',0,'cityListing','Ads in the city','2019-03-16 11:47:19'),(1319,'module_messages',0,'Message sent to the users','The message was sent','2019-03-16 11:47:21'),(1320,'module_messages',0,'User','User','2019-03-16 11:47:28'),(1321,'module_messages',0,'Administrator','Administrator','2019-03-16 11:47:33'),(1322,'module_messages',0,'View','View','2019-03-16 11:47:34'),(1323,'module_messages',0,'Delete','Delete','2019-03-16 11:47:38'),(1324,'module_messages',0,'Are you sure?','Are you sure?','2019-03-16 11:47:44'),(1325,'module_messages',0,'new_message','New message','2019-03-16 11:47:45'),(1326,'module_messages',0,'All messages','All messages','2019-03-16 11:47:49'),(1327,'module_messages',0,'History messages with user','Message history with','2019-03-16 11:47:53'),(1328,'module_messages',0,'mes','Message','2019-03-16 11:47:58'),(1329,'module_messages',0,'Send','Send','2019-03-16 11:47:59'),(1330,'module_messages',0,'New message','New message','2019-03-16 11:48:06'),(1331,'module_messages',0,'Message sent to the user','The message was sent','2019-03-16 11:48:13'),(1332,'module_messages',0,'I am','I','2019-03-16 11:48:19'),(1333,'module_messages',0,'user_phone','Phone number','2019-03-16 11:48:26'),(1334,'module_messages',0,'Send message','Send message','2019-03-16 11:48:27'),(1335,'module_messages',0,'max_newsletter_limit','Maximum {n} users','2019-03-16 11:48:28'),(1336,'module_messages',0,'Hello {username}','Hello {username}','2019-03-16 11:48:31'),(1337,'module_messages',0,'message_macros_help','Use macros {username}  in order to insert a user name','2019-03-16 11:48:37'),(1338,'module_messages',0,'check_users_send','Choose a user','2019-03-16 11:48:41'),(1339,'module_clients',0,'Clients','Clients','2019-03-16 11:48:42'),(1340,'module_clients',0,'Manage clients','Manage clients','2019-03-16 11:48:43'),(1341,'module_clients',0,'Add client','Add a client','2019-03-16 11:48:50'),(1342,'module_clients',0,'Live with our help','Checked in with our help','2019-03-16 11:48:57'),(1343,'module_clients',0,'Accommodating','We register in hotel','2019-03-16 11:49:02'),(1344,'module_clients',0,'Independently','Checked in alone','2019-03-16 11:49:08'),(1345,'module_clients',0,'Ignore','Ignored','2019-03-16 11:49:13'),(1346,'module_clients',0,'Fio','Name and Surname','2019-03-16 11:49:20'),(1347,'module_clients',0,'ID','ID','2019-03-16 11:49:28'),(1348,'module_clients',0,'State','Status','2019-03-16 11:49:33'),(1349,'module_clients',0,'Contract_number','Contract number','2019-03-16 11:49:40'),(1350,'module_clients',0,'Phone','Phone number','2019-03-16 11:49:45'),(1351,'module_clients',0,'Additional_phone','Additional phone number,','2019-03-16 11:49:47'),(1352,'module_clients',0,'Acts','Documents','2019-03-16 11:49:54'),(1353,'module_clients',0,'Additional_info','Additional information','2019-03-16 11:49:58'),(1354,'module_clients',0,'View client','View client\'s data,','2019-03-16 11:50:01'),(1355,'module_clients',0,'Delete client','Delete a client','2019-03-16 11:50:05'),(1356,'module_clients',0,'Update client','Edit client\'s data','2019-03-16 11:50:13'),(1357,'module_clients',0,'Client ID','Client ID','2019-03-16 11:50:14'),(1358,'module_clients',0,'Second_name','Surname','2019-03-16 11:50:19'),(1359,'module_clients',0,'Middle_name','Middle name','2019-03-16 11:50:24'),(1360,'module_clients',0,'First_name','Name','2019-03-16 11:50:27'),(1361,'module_clients',0,'Birthdate','Birthdate','2019-03-16 11:50:34'),(1362,'common',0,'Only with photo','Only with photos','2019-03-16 11:50:36'),(1363,'common',0,'Listing from','Listing from','2019-03-16 11:50:37'),(1364,'module_payment',0,'MERCHANT_ID','Identifier of site in the payment system','2019-03-16 11:50:44'),(1365,'module_configuration',0,'useJQuerySimpleCaptcha','Use JQuerySimpleCaptcha captcha','2019-03-16 11:50:47'),(1366,'common',0,'jquerySimpleCaptchaIntroText','Please click on the <strong class=\"captchaText\"></strong>','2019-03-16 11:50:50'),(1367,'module_users',0,'RoleAdmin','Administrator','2019-03-16 11:50:56'),(1368,'module_users',0,'RoleModerator','Moderator','2019-03-16 11:51:03'),(1369,'module_users',0,'RoleRegistered','Registered user','2019-03-16 11:51:07'),(1370,'module_users',0,'Role','Role','2019-03-16 11:51:12'),(1371,'module_users',0,'Incorrect user role','Incorrect role','2019-03-16 11:51:16'),(1372,'module_users',0,'Select role','Select a role','2019-03-16 11:51:17'),(1373,'common',0,'log in as moderator','log in as moderator','2019-03-16 11:51:24'),(1374,'common',0,'module_name_rbac','Module \"Role-Based Access Control\"','2019-03-16 11:51:26'),(1375,'common',0,'module_description_rbac','Provides a simple yet powerful centralized access control.\r\n\r\nThe module allows you to add moderators.','2019-03-16 11:51:32'),(1376,'module_configuration',0,'useTypeRentHour','Possibility to add listings of the type \"Rent out a property\" -> \"per hour\"','2019-03-16 11:51:38'),(1377,'module_configuration',0,'useTypeRentDay','Possibility to add listings of the type \"Rent out a property\" -> \"per day\"','2019-03-16 11:51:40'),(1378,'module_configuration',0,'useTypeRentWeek','Possibility to add listings of the type \"Rent out a property\" -> \"per week\"','2019-03-16 11:51:47'),(1379,'module_configuration',0,'useTypeRentMonth','Possibility to add listings of the type \"Rent out a property\" -> \"per month\"','2019-03-16 11:51:49'),(1380,'common',0,'module_name_tariffPlans','Module \"Tariff Plans\"','2019-03-16 11:51:56'),(1381,'common',0,'module_description_tariffPlans','The module allows to add the price for listing a property and to view contact details of the owners with limited duration or without it.\r\n\r\nWhen the module is by default  all the users are assigned to the tariff plan \"Free\"','2019-03-16 11:52:02'),(1382,'common',0,'Tariff Plans','Tariff Plans','2019-03-16 11:52:03'),(1383,'module_tariffPlans',0,'Manage tariff plans','Management of tariff plans','2019-03-16 11:52:08'),(1384,'module_tariffPlans',0,'Add tariff plan','Add a tariff plan','2019-03-16 11:52:11'),(1385,'module_tariffPlans',0,'Price','Price','2019-03-16 11:52:15'),(1386,'module_tariffPlans',0,'Duration','Duration period','2019-03-16 11:52:19'),(1387,'module_tariffPlans',0,'days','days','2019-03-16 11:52:26'),(1388,'module_tariffPlans',0,'Are you sure you want to delete this item? All user tariffs will also be deleted!','Are you sure you want to delete the chosen tariff plan? All the listings of the users of this plan will be inactived.','2019-03-16 11:52:27'),(1389,'module_tariffPlans',0,'Name','Title of the tariff plan','2019-03-16 11:52:34'),(1390,'module_tariffPlans',0,'Description','Description of the tariff plan','2019-03-16 11:52:39'),(1391,'module_tariffPlans',0,'Limit_objects','Maximum number of listings','2019-03-16 11:52:40'),(1392,'module_tariffPlans',0,'Limit_photos','Maximum number of pictures to the listing','2019-03-16 11:52:45'),(1393,'module_tariffPlans',0,'Status','Status','2019-03-16 11:52:48'),(1394,'module_tariffPlans',0,'If null or 0 then unlimited','Unlimited, if the value is \"empty\" or \"0\"','2019-03-16 11:52:54'),(1395,'module_tariffPlans',0,'If null or 0 then free','Free if the value is \"empty\" or \"0\"','2019-03-16 11:53:02'),(1396,'module_tariffPlans',0,'Show_address','Display  the field \"address\" in listings','2019-03-16 11:53:07'),(1397,'module_tariffPlans',0,'Show_phones','Display phone numbers of owners of the listings','2019-03-16 11:53:08'),(1398,'module_tariffPlans',0,'Browse ads','Listings view','2019-03-16 11:53:10'),(1399,'module_tariffPlans',0,'Adding ads','Add a new listing','2019-03-16 11:53:17'),(1400,'module_tariffPlans',0,'Price is free','Free','2019-03-16 11:53:21'),(1401,'module_tariffPlans',0,'Unlimited','No limit','2019-03-16 11:53:23'),(1402,'module_tariffPlans',0,'Edit tariff plan','Edit tariff plan ','2019-03-16 11:53:24'),(1403,'module_tariffPlans',0,'Duration and price','Valid it period and price','2019-03-16 11:53:26'),(1404,'module_tariffPlans',0,'Apply a tariff plan to the user','Add a tarif plan to the user','2019-03-16 11:53:33'),(1405,'common',0,'Tariff plan successfully added','The tarif plan is successfully added','2019-03-16 11:53:35'),(1406,'module_tariffPlans',0,'Tariff_id','Tariff plan','2019-03-16 11:53:42'),(1407,'common',0,'unlimited','unlimited','2019-03-16 11:53:45'),(1408,'module_tariffPlans',0,'Your current tariff plan','Your current tariff plan is','2019-03-16 11:53:51'),(1409,'common',0,'Date of completion','Valid until','2019-03-16 11:53:52'),(1410,'common',0,'Change tariff plan','Change tariff plan','2019-03-16 11:53:57'),(1411,'module_tariffPlans',0,'Exhausted the limit of {limit} active ads, deactivate other ads or <a href=\"{link}\">change tariff plan</a>','The limit of {limit} active listings is reached, deactivate other listings or <a href=\"{link}\">change your tariff plan</a>','2019-03-16 11:54:04'),(1412,'module_tariffPlans',0,'You are trying to download more than {num} pictures ( your tariff limit )','You try to upload more than {num} pictures (the limit of your tariff plan)','2019-03-16 11:54:12'),(1413,'module_tariffPlans',0,'Please <a href=\"{n}\">change the tariff plan</a> to view','Please, <a href=\"{n}\">change your tariff plan</a> to view the information','2019-03-16 11:54:17'),(1414,'module_tariffPlans',0,'Please <a href=\"{n}\">login</a> to view','Please, <a href=\"{n}\">log in the system</a> to view the information','2019-03-16 11:54:24'),(1415,'module_tariffPlans',0,'Are you sure you want to change the tariff plan?','Are you sure you want to change the tariff plan?','2019-03-16 11:54:30'),(1416,'module_tariffPlans',0,'help_buy_tariff_plan','If you change the tariff plan the remained days of the current plan won\'t be saved.','2019-03-16 11:54:34'),(1417,'module_tariffPlans',0,'help_buy_tariff_plan2','The funds for the remaining days of the tariff plan won\'t be refunded.','2019-03-16 11:54:42'),(1418,'module_paidservices',0,'Amount','Price','2019-03-16 11:54:47'),(1419,'module_paidservices',0,'Status','Status','2019-03-16 11:54:50'),(1420,'module_paidservices',0,'Payment date','Payment date','2019-03-16 11:54:55'),(1421,'module_paidservices',0,'Booking #','Booking #','2019-03-16 11:55:02'),(1422,'module_paidservices',0,'Method of payment','Payment method','2019-03-16 11:55:08'),(1423,'module_tariffPlans',0,'Selected tariff plan is free. Please contact the site administrator for transit to this tariff.','The chosen tariff plan is free. Please contact the website administrator to change the tariff.','2019-03-16 11:55:12'),(1424,'module_tariffPlans',0,'Purchase tariff plan','Purchase of tariff plan','2019-03-16 11:55:19'),(1425,'module_configuration',0,'mailSMTPSecure','Encryption method SMTP','2019-03-16 11:55:20'),(1426,'module_socialposting',0,'vkontakteFromGroup','The publication of the name of the group','2019-03-16 11:55:25'),(1427,'module_advertising',0,'Javascript code','Javascript code','2019-03-16 11:55:28'),(1428,'module_blockIp',0,'Add the IP address to the list of blocked','Add to IP Blacklist','2019-03-16 11:55:31'),(1429,'module_blockIp',0,'Ip was success added','IP is successfully added','2019-03-16 11:55:34'),(1430,'module_blockIp',0,'Ip was already exists','This IP is already in the Blacklist','2019-03-16 11:55:37'),(1432,'module_blockIp',0,'Enter Ip','Enter the IP','2019-03-16 11:55:42'),(1433,'module_blockIp',0,'User IP','IP','2019-03-16 03:59:50'),(1434,'common',0,'Blockip','IP Blacklist','2019-03-16 11:55:54'),(1435,'module_blockIp',0,'Add blockIp','Add to IP Blacklist','2019-03-16 11:56:01'),(1436,'module_blockIp',0,'Manage blockIp','Management of IP Blacklist','2019-03-16 11:56:03'),(1437,'module_blockIp',0,'IP','IP','2019-03-16 03:59:50'),(1438,'module_blockIp',0,'Ip_long','Ip ( long )','2019-03-16 03:59:50'),(1439,'module_blockIp',0,'Update blockIp','Update','2019-03-16 11:56:19'),(1440,'module_blockIp',0,'Delete blockIp','Delete','2019-03-16 11:56:24'),(1441,'module_blockIp',0,'help_admin','Visitors whose IP address is blacklisted can not register, book, make complaints or send messageges via \"Contact us\" form, they can not post reviews and comments on the website either. ','2019-03-16 11:56:31'),(1442,'module_blockIp',0,'Added IP are automatically deleted','Added IP are automatically deleted in','2019-03-16 11:56:33'),(1443,'module_blockIp',0,'days','days','2019-03-16 11:56:36'),(1444,'module_users',0,'Restore password for {email}?','Restore password for {email}?','2019-03-16 11:56:37'),(1445,'module_notifier',0,'A new password has been created and sent to {email}.','A new password has been created and sent to {email}.','2019-03-16 11:56:38'),(1446,'common',0,'Registration date','Registration date','2019-03-16 11:56:40'),(1447,'common',0,'The last date the user logged in to the system','The last date the user logged in to the system','2019-03-16 11:56:46'),(1448,'common',0,'Last IP address','Last IP address','2019-03-16 11:56:50'),(1449,'common',0,'Change the owner of the listings','Change the owner of the listings','2019-03-16 11:56:55'),(1450,'module_apartments',0,'futureOwner','Future owner of the listing','2019-03-16 11:57:00'),(1451,'module_apartments',0,'futureApartments','Listing/listings','2019-03-16 11:57:05'),(1452,'module_apartments',0,'Choose a user','Choose a user','2019-03-16 11:57:09'),(1453,'module_partments',0,'Choose a apartments','Select a listing/listings','2019-03-16 11:57:13'),(1454,'module_configuration',0,'user_registrationMode','Users registration','2019-03-16 11:57:20'),(1455,'module_users',0,'With confirmation by email','with email confirmation','2019-03-16 11:57:28'),(1456,'module_users',0,'Without confirmation by email','without email confirmation','2019-03-16 11:57:35'),(1457,'common',0,'You were successfully registered.','You are successfully registered.','2019-03-16 11:57:39'),(1458,'module_usercpanel',0,'Password','Password','2019-03-16 11:57:40'),(1459,'module_apartments',0,'Set the owner of the listing','Set the owner of the listing','2019-03-16 11:57:46'),(1460,'module_themes',0,'Edit theme','Edit theme','2019-03-16 12:32:59'),(1461,'module_themes',0,'Color theme','Color theme','2019-03-16 12:33:06'),(1462,'module_themes',0,'The file was less than {size}MB. Please upload a larger file.','The file was less than {size}MB. Please upload a larger file.','2019-03-16 12:33:11'),(1463,'module_themes',0,'Image successfully added','Image successfully added','2019-03-16 12:33:13'),(1464,'module_themes',0,'Image successfully deleted','Image successfully deleted','2019-03-16 12:33:19'),(1465,'module_themes',0,'Background image','Background image','2019-03-16 12:33:23'),(1466,'common',0,'Enter agency name','Enter the name of the agency','2019-03-16 12:33:31'),(1467,'module_formeditor',0,'type text area with wysiwyg','A large textbox with wyswig','2019-03-16 12:33:34'),(1468,'module_currency',0,'Add currency','Add currency','2019-03-16 12:33:38'),(1469,'common',0,'It is allowed to use the characters \"A-Z\" without spaces','It is allowed to use the characters \"A-Z\" without spaces','2019-03-16 12:33:43'),(1470,'common',0,'The field should correspond {link}','The field should correspond {link}','2019-03-16 12:33:46'),(1471,'module_currency',0,'Not parse','Do not parse','2019-03-16 12:33:48'),(1472,'module_currency',0,'Update currency','Update currency','2019-03-16 12:33:54'),(1473,'module_currency',0,'Delete currency','Remove currency','2019-03-16 12:33:59'),(1474,'module_currency',0,'You can not delete an active currency!','You can not delete an active currency!','2019-03-16 12:34:01'),(1475,'common',0,'I agree with','Signing up on the Site I agree to the terms of the','2019-03-16 12:34:04'),(1476,'common',0,'You must agree','You are to confirm your acceptance of the terms and conditions of the','2019-03-16 12:34:10'),(1477,'common',0,'with User agreement','Users agreement','2019-03-16 12:34:13'),(1478,'common',0,'Clone','Clone','2019-03-16 03:59:50'),(1479,'module_configuration',0,'enableUserAdsCopy','Ability to clone listings by users','2019-03-16 12:34:26'),(1480,'common',0,'Copy of','Copy of','2019-03-16 12:34:30'),(1481,'module_configuration',0,'notDeleteListings','Do not remove listings','2019-03-16 12:34:35'),(1482,'module_apartments',0,'Restore','Restore','2019-03-16 12:34:36'),(1483,'module_apartments',0,'Listing is deleted','The listing in not actual','2019-03-16 12:34:38'),(1484,'common',0,'Deleted','Deleted','2019-03-16 12:34:44'),(1485,'module_apartments',0,'Status (deleted)','Status (deleted)','2019-03-16 12:34:45'),(1486,'module_payment',0,'Please_wait_payment_W1','Please wait. The system is redirecting you to W1 for payment.','2019-03-16 12:34:49'),(1487,'common',0,'Booking','Booking','2019-03-16 12:34:52'),(1488,'common',0,'Booking from','Booking from','2019-03-16 12:34:56'),(1489,'module_payment',0,'Please_wait_payment_Liqpay','Please wait. The system is redirecting you to Liqpay for payment.','2019-03-16 12:35:01'),(1490,'module_apartments',0,'trillion','T','2019-03-16 12:35:04'),(1491,'module_apartments',0,'billion','B','2019-03-16 12:35:07'),(1492,'module_formeditor',0,'type multyselect','Multiple choice field','2019-03-16 12:35:14'),(1493,'Chosen.main',0,'No results match','No results match','2019-03-16 12:35:16'),(1494,'module_location',0,'Add multiple cities help','Add a list of citites, every city in a different line. If Russian is pre-set, all the texts will be translitted. Don\'t forget to edit the translation after the list is added.','2019-03-16 12:35:21'),(1495,'module_apartmentCity',0,'Add multiple cities','Add multiple cities','2019-03-16 12:35:24'),(1496,'module_apartmentCity',0,'Add multiple cities help','Add a list of citites, every city in a different line. If Russian is pre-set, all the texts will be translitted. Don\'t forget to edit the translation after the list is added.','2019-03-16 12:35:27'),(1497,'module_location',0,'Add multiple cities','Add multiple cities','2019-03-16 12:35:30'),(1498,'module_referencevalues',0,'Create multiple reference values','Add multiple values','2019-03-16 12:35:31'),(1499,'module_referencevalues',0,'Add multiple reference values help','Add a list of reference values, every value in a different line. If Russian is pre-set, all the texts will be translitted. Don\'t forget to edit the translation after the list is added.','2019-03-16 12:35:34'),(1500,'module_configuration',0,'allowUserSeo','Allow users to use SEO settings for listings','2019-03-16 12:35:38'),(1501,'common',0,'module_name_seasonalprices','\"Seasonal Prices\" module','2019-03-16 12:35:40'),(1502,'common',0,'module_description_seasonalprices','This module allows to set different prices for different seasons. You can also define the season length or set individual pricing to every month.','2019-03-16 12:35:45'),(1503,'module_seasonalprices',0,'seasonalprices_help_full','You can set different prices for every season (e.g. for low, high and peak seasons).','2019-03-16 12:35:52'),(1504,'module_seasonalprices',0,'Name','Season name','2019-03-16 12:35:57'),(1505,'module_seasonalprices',0,'Price','Price','2019-03-16 12:36:01'),(1506,'module_seasonalprices',0,'From','From','2019-03-16 12:36:04'),(1507,'module_seasonalprices',0,'To','To','2019-03-16 12:36:10'),(1508,'module_seasonalprices',0,'Min_rental_period','Minimum rental term','2019-03-16 12:36:15'),(1509,'module_seasonalprices',0,'Fill fields','Fill out all required fields','2019-03-16 12:36:18'),(1510,'module_seasonalprices',0,'No_prices','Prices are not set','2019-03-16 12:36:24'),(1511,'module_apartments',0,'a hour','a hour','2019-03-16 12:36:31'),(1512,'module_apartments',0,'a day','a day','2019-03-16 12:36:34'),(1514,'module_seasonalprices',0,'Access denied','Access is denied','2019-03-16 12:36:39'),(1516,'module_seasonalprices',0,'Price_type','Price per  (month, hour, week, night)','2019-03-16 12:36:44'),(1517,'module_seasonalprices',0,'Wrong format of field {attribute}','Incorrect field format {attribute}','2019-03-16 12:36:49'),(1518,'module_iecsv',0,'prices_from_season_module.','Prices in \"Seasonal prices\" module can\'t be exported and imported. ','2019-03-16 12:36:55'),(1519,'module_stats',0,'View statistics','View statistics','2019-03-16 12:36:59'),(1520,'common',0,'Statistics','Statistics','2019-03-16 12:37:00'),(1521,'module_stats',0,'Date','Date','2019-03-16 12:37:01'),(1522,'module_stats',0,'Added listings','Listings posted','2019-03-16 12:37:09'),(1523,'module_stats',0,'Registered users','Users registered','2019-03-16 12:37:13'),(1524,'module_stats',0,'Added comments','Comments posted','2019-03-16 12:37:20'),(1525,'module_stats',0,'Done payments','Payments completed','2019-03-16 12:37:25'),(1526,'module_stats',0,'Statistics','Statistics','2019-03-16 12:37:32'),(1527,'module_stats',0,'Statistics of last {n} days','Statistics for last {n} days','2019-03-16 12:37:37'),(1528,'module_stats',0,'Generated_data','In demo mode data is randomly generated','2019-03-16 12:37:38'),(1529,'module_stats',0,'Added reviews','Reviews posted','2019-03-16 12:37:44'),(1530,'module_formeditor',0,'Visible to all','Visible to all','2019-03-16 12:37:50'),(1531,'module_formeditor',0,'Visible for registered','Visible for registered','2019-03-16 12:37:58'),(1532,'module_formeditor',0,'Visible for owner or admin','One can see the owner and administrator','2019-03-16 12:38:03'),(1533,'module_formeditor',0,'Visible for admin','It can be seen administrator','2019-03-16 12:38:06'),(1534,'module_formdesigner',0,'Visibility','Visibility','2019-03-16 12:38:12'),(1535,'module_apartments',0,'Location','Location','2019-03-16 12:38:18'),(1536,'module_apartments',0,'Is located','Linked to','2019-03-16 12:38:25'),(1537,'module_apartments',0,'offers','offers','2019-03-16 12:38:27'),(1538,'module_seasonalprices',0,'week','w','2019-03-16 12:38:29'),(1539,'module_seasonalprices',0,'month','m','2019-03-16 12:38:30'),(1540,'module_seasonalprices',0,'hour','h','2019-03-16 12:38:36'),(1541,'module_seasonalprices',0,'day','d','2019-03-16 12:38:37'),(1542,'module_service',0,'Clear assets','Clear folder \"assets\"','2019-03-16 12:38:39'),(1543,'module_service',0,'Clear runtime','Clear folder \"runtime\"','2019-03-16 12:38:40'),(1544,'module_service',0,'Are you sure you want to empty the cache?','Are you sure you want to empty the cache?','2019-03-16 12:38:45'),(1545,'module_service',0,'Cache files in the folder {folder} have been successfully removed','Cache files in folder {folder} were successfully deleted.','2019-03-16 12:38:53'),(1546,'module_configuration',0,'defaultApartmentType','Type of listing by default','2019-03-16 12:38:56'),(1547,'module_advertising',0,'Reviews','Reviews','2019-03-16 12:39:01'),(1548,'module_advertising',0,'Reviews -> add','Reviews -> add','2019-03-16 12:39:05'),(1549,'module_advertising',0,'Guestad -> add','List your property ( module \'guestad\' )','2019-03-16 12:39:08'),(1550,'module_advertising',0,'Infopages -> view','Infopages -> view','2019-03-16 12:39:15'),(1551,'module_advertising',0,'All pages','All pages','2019-03-16 12:39:21'),(1552,'module_advertising',0,'Apart from the pages that open in a modal window (e.g. in fancybox and others)','Apart from the pages that open in a modal window (e.g. in fancybox and others)','2019-03-16 12:39:27'),(1553,'module_entries',0,'Manage entries','Article manager','2019-03-16 12:39:34'),(1554,'module_entries',0,'Add entry','Add article','2019-03-16 12:39:36'),(1555,'module_entries',0,'Entry title','Title of article','2019-03-16 12:39:43'),(1556,'module_entries',0,'Entry body','Text of article','2019-03-16 12:39:49'),(1557,'module_entries',0,'Creation date','Creation date','2019-03-16 12:39:56'),(1558,'module_entries',0,'Announce','Announce','2019-03-16 12:40:00'),(1559,'module_entries',0,'Image for entry','Image for article','2019-03-16 12:40:04'),(1560,'module_entries',0,'Entries','Articles','2019-03-16 12:40:06'),(1561,'module_entries',0,'Categories of entries','Articles сategories','2019-03-16 12:40:13'),(1562,'module_entries',0,'Category','Category','2019-03-16 12:40:15'),(1563,'module_entries',0,'Edit entry','Edit article','2019-03-16 12:40:23'),(1564,'module_entries',0,'Delete entry','Delete this article','2019-03-16 12:40:30'),(1565,'module_entries',0,'Add category','Add category','2019-03-16 12:40:33'),(1566,'module_entries',0,'Edit category','Edit category','2019-03-16 12:40:37'),(1567,'module_entries',0,'News','News','2019-03-16 12:40:39'),(1568,'module_entries',0,'Read more &raquo;','Read more &raquo;','2019-03-16 12:40:46'),(1569,'module_entries',0,'Entries list is empty.','Articles list is empty.','2019-03-16 12:40:51'),(1570,'module_entries',0,'All materials for this category will be deleted. Are you sure?','All articles for this category will be deleted. Are you sure?','2019-03-16 12:40:52'),(1571,'module_entries',0,'Articles filter','Articles filter','2019-03-16 12:40:56'),(1572,'module_entries',0,'Id','Id','2019-03-16 12:41:02'),(1573,'module_entries',0,'Frequency','Frequency','2019-03-16 12:41:09'),(1574,'module_entries',0,'Tags can only contain word characters.','Tags can only contain word characters.','2019-03-16 12:41:15'),(1575,'module_entries',0,'Tags','Tags','2019-03-16 12:41:19'),(1576,'module_entries',0,'Please separate different tags with commas.','Please separate different tags with commas.','2019-03-16 12:41:25'),(1577,'module_entries',0,'by tag','by tag','2019-03-16 12:41:30'),(1578,'module_entries',0,'Created on','Date created','2019-03-16 12:41:35'),(1579,'module_advertising',0,'Entries','Articles','2019-03-16 12:41:38'),(1580,'module_advertising',0,'Entries -> view','Articles -> view','2019-03-16 12:41:41'),(1581,'common',0,'1 menu','1 menu','2019-03-16 12:41:42'),(1582,'common',0,'2 menu','2 menu','2019-03-16 12:41:49'),(1583,'common',0,'not defined','not defined','2019-03-16 12:41:56'),(1584,'common',0,'{0} Selected','{0} Selected','2019-03-16 12:41:57'),(1585,'module_metroStations',0,'Manage subway stations','Subway stations management','2019-03-16 12:42:03'),(1586,'module_metroStations',0,'Add station','Add a subway station','2019-03-16 12:42:06'),(1587,'common',0,'Reference \"Subway stations\"','Reference \"Subway stations\"','2019-03-16 12:42:11'),(1588,'common',0,'Subway stations','Subway stations','2019-03-16 12:42:15'),(1589,'module_metroStations',0,'Add multiple stations','Add multiple subway stations','2019-03-16 12:42:22'),(1590,'module_metroStations',0,'Edit station','Edit subway station','2019-03-16 12:42:23'),(1591,'common',0,'module_name_metroStations','Module \"Subway stations\"','2019-03-16 12:42:29'),(1592,'common',0,'module_description_metroStations','Module allows to attribute an object to a subway station. The search form changes accordingly, what enables an easier and quicker search.','2019-03-16 12:42:31'),(1593,'module_metroStations',0,'Add multiple stations help','Enter a list of subway stations, one per line. If Russian language is installed, for other languages the names of stations will be translitted. Don\'t forget to edit translations after the stations are added. ','2019-03-16 12:42:32'),(1594,'common',0,'{attribute} cannot be blank.','{attribute} cannot be blank.','2019-03-16 12:42:39'),(1595,'module_metroStations',0,'Select metro stations','Select a subway station','2019-03-16 12:42:47'),(1596,'module_metroStations',0,'Not selected','Not selected','2019-03-16 12:42:54'),(1597,'module_booking',0,'It is necessary to pay','You ought to pay for the booking.','2019-03-16 12:43:01'),(1598,'module_bookingtable',0,'Change status','Change status','2019-03-16 12:43:04'),(1599,'module_bookingtable',0,'Success change status','Status is changed','2019-03-16 12:43:07'),(1600,'module_booking',0,'Advance payment','Advance payment','2019-03-16 12:43:14'),(1601,'module_booking',0,'The user will receive an email with a request to pay the booking.','The user will receive an email with a request to pay the booking.','2019-03-16 12:43:19'),(1602,'module_booking',0,'The percentage of advance payment for booking','Advance payment (%)','2019-03-16 12:43:26'),(1603,'module_bookingtable',0,'Error change status','Error in status change ','2019-03-16 12:43:32'),(1604,'module_usercpanel',0,'My bookings','My requests','2019-03-16 12:43:39'),(1605,'module_booking',0,'Pay for booking','Booking payment','2019-03-16 12:43:43'),(1606,'module_payment',0,'Pay now','Pay now','2019-03-16 12:43:44'),(1607,'module_booking',0,'Purchase booking','Booking payment','2019-03-16 12:43:49'),(1608,'module_apartments',0,'Is it your listing?','Is it your listing?','2019-03-16 12:43:56'),(1609,'module_apartments',0,'Would you like to','Would you like to','2019-03-16 12:43:58'),(1610,'module_apartments',0,'quicker?','quicker?','2019-03-16 12:44:03'),(1611,'module_apartments',0,'Try to','Try to','2019-03-16 12:44:06'),(1612,'module_apartments',0,'apply paid services','apply paid services','2019-03-16 12:44:13'),(1613,'common',0,'module_name_historyChanges','Module \"History of changes\"','2019-03-16 12:44:18'),(1614,'common',0,'module_description_historyChanges','With this module you can monitor changes, done by users or moderators (with module \'Moderators\' installed). All modifications are logged in the following areas: \'Listings\', \'Comments\', \'Complaints\', \'Booking\', \'Users\', \'Reviews\'. \'Clients\', \'Articles\'.','2019-03-16 12:44:20'),(1615,'module_historyChanges',0,'History changes','History of changes','2019-03-16 12:44:23'),(1616,'module_historyChanges',0,'Description','Description','2019-03-16 12:44:28'),(1617,'module_historyChanges',0,'Action','Action','2019-03-16 12:44:35'),(1618,'module_historyChanges',0,'Model name','Model name','2019-03-16 12:44:42'),(1619,'module_historyChanges',0,'Model ID','Model ID','2019-03-16 12:44:43'),(1620,'module_historyChanges',0,'Database field','Database field','2019-03-16 12:44:48'),(1621,'module_historyChanges',0,'User','User','2019-03-16 12:44:56'),(1622,'module_historyChanges',0,'Old value','Old value','2019-03-16 12:45:02'),(1623,'module_historyChanges',0,'New value','New value','2019-03-16 12:45:06'),(1624,'module_historyChanges',0,'User added','added','2019-03-16 12:45:10'),(1625,'module_historyChanges',0,'User modified','modified','2019-03-16 12:45:18'),(1626,'module_historyChanges',0,'User deleted','deleted','2019-03-16 12:45:20'),(1627,'module_historyChanges',0,'System','System','2019-03-16 12:45:24'),(1628,'module_historyChanges',0,'video','video','2019-03-16 03:59:50'),(1629,'module_historyChanges',0,'image','image','2019-03-16 12:45:27'),(1630,'module_historyChanges',0,'panorama','panorama','2019-03-16 03:59:50'),(1631,'module_historyChanges',0,'main photo','main photo','2019-03-16 12:45:38'),(1632,'module_historyChanges',0,'references','references','2019-03-16 12:45:42'),(1633,'module_historyChanges',0,'metro_stations','subway stations','2019-03-16 12:45:43'),(1634,'module_currency',0,'Currency rate update error','Currency rate update error','2019-03-16 12:45:49'),(1635,'module_currency',0,'Currency rate update complete','Currency rates are successfully updated','2019-03-16 12:45:53'),(1636,'module_currency',0,'Yahoo Currency Service','Yahoo currency converter','2019-03-16 12:45:58'),(1637,'module_currency',0,'Europe Central Bank','European Central Bank','2019-03-16 12:46:04'),(1638,'module_currency',0,'Central Bank of Russia','The Central Bank of Russia','2019-03-16 12:46:09'),(1639,'module_currency',0,'Curency source','Currency rates source','2019-03-16 12:46:14'),(1640,'module_currency',0,'Update currency now','Update currency rates','2019-03-16 12:46:20'),(1641,'module_currency',0,'Currency rate help','Set the cost of a unit of the currency in default currency','2019-03-16 12:46:25'),(1642,'module_apartments',0,'Disabled type','Disabled type','2019-03-16 12:46:30'),(1643,'common',0,'Event (name in code)','Event (event name in the code)','2019-03-16 12:46:35'),(1644,'module_apartments',0,'Custom city','Another city','2019-03-16 12:46:37'),(1645,'module_apartments',0,'City from list','Select from the list','2019-03-16 12:46:43'),(1646,'module_apartments',0,'City waiting for admin apporove','City will be displayed in the listing after administrator\'s confirmation','2019-03-16 12:46:50'),(1647,'module_configuration',0,'allowCustomCities','Allow to add extra cities in the listings','2019-03-16 12:46:54'),(1648,'module_configuration',0,'useSchemaOrgMarkup','Use Schema.org markup (JSON-LD) for Articles and Listings','2019-03-16 12:46:59'),(1649,'module_configuration',0,'geo','GEO module','2019-03-16 12:47:04'),(1650,'module_configuration',0,'geo_time_cache','Time geo caching data','2019-03-16 12:47:09'),(1651,'module_configuration',0,'geo_in_search','Substitute geo data in the search form','2019-03-16 12:47:11'),(1652,'module_configuration',0,'geo_in_index','Filter ads on the front page of geo data','2019-03-16 12:47:14'),(1653,'module_configuration',0,'geo_in_ad','Substitute geo data when adding the listing','2019-03-16 12:47:20'),(1654,'module_configuration',0,'geo_in_index_flag','Filter listings on index page by geo data, only if the country concerned has listings ','2019-03-16 12:47:28'),(1655,'common',0,'module_name_geo','GEO module','2019-03-16 12:47:30'),(1656,'common',0,'module_description_geo','Marketing module allows you to identify the country, region and city by IP','2019-03-16 12:47:34'),(1657,'module_geo',0,'not to expose','No','2019-03-16 12:47:38'),(1658,'module_geo',0,'only the country','Only the country','2019-03-16 12:47:45'),(1659,'module_geo',0,'country and region','Country and region','2019-03-16 12:47:51'),(1660,'module_geo',0,'country, region and city','Country, region and city','2019-03-16 12:47:53'),(1661,'module_formdesigner',0,'Show for type of listing','Show for type of listing','2019-03-16 12:47:54'),(1662,'module_paidservices',0,'Payment immediately','Immediate payment','2019-03-16 12:48:00'),(1663,'module_paidservices',0,'Note for payment immediately','If \'Immediate payment\' option is chosen, users will be asked to pay the booking fee right on the spot. The funds will come to admin\'s account.\r\n\'Immediate payment\' is working only for rent-per-day listings.','2019-03-16 12:48:02'),(1664,'module_paidservices',0,'You must disable the module \"Seasonal prices\"','You must disable the module \"Seasonal prices\"','2019-03-16 12:48:07'),(1665,'common',0,'uses cookie','uses cookie','2019-03-16 12:48:10'),(1666,'module_configuration',0,'useShowInfoUseCookie','Display cookies warning message','2019-03-16 12:48:16'),(1667,'module_themes',0,'Use_full_width_slider_homepage','Use full width slider on the homepage','2019-03-16 12:48:18'),(1668,'module_seo',0,'Listing','Listing','2019-03-16 12:48:23'),(1669,'module_seo',0,'Entries','Articles','2019-03-16 12:48:27'),(1670,'module_seo',0,'Menu','Menu','2019-03-16 12:48:28'),(1671,'module_seo',0,'Article','Q&As','2019-03-16 12:48:35'),(1672,'module_seo',0,'InfoPages','Info pages','2019-03-16 12:48:37'),(1673,'module_seo',0,'EntriesCategory','Articles сategories','2019-03-16 12:48:45'),(1674,'module_seo',0,'Settings','Other Settings','2019-03-16 12:48:51'),(1675,'module_seo',0,'siteName_label','Site name','2019-03-16 12:48:52'),(1676,'module_seo',0,'siteKeywords_label','Site keywords','2019-03-16 12:48:57'),(1677,'module_seo',0,'siteDescription_label','Site description','2019-03-16 12:49:03'),(1679,'module_seo',0,'Model Name','Section','2019-03-16 12:49:04'),(1680,'module_seo',0,'Model Id','ID','2019-03-16 12:49:06'),(1681,'common',0,'Manage SEO settings','Manage SEO settings','2019-03-16 12:49:08'),(1682,'module_seo',0,'Generation SEO','Url and metadata generation','2019-03-16 12:49:11'),(1683,'module_seo',0,'Generate','Generation','2019-03-16 12:49:18'),(1684,'module_seo',0,'Successful SEO Generation','Successful data generation.','2019-03-16 12:49:23'),(1685,'module_seo',0,'For sections','For sections','2019-03-16 12:49:26'),(1686,'module_seo',0,'Please, indicate the section(s)','Please, indicate the section(s)','2019-03-16 12:49:31'),(1687,'module_seo',0,'Delete old urls and metadata','Delete old urls and metadata','2019-03-16 12:49:36'),(1688,'module_referencecategories',0,'Save and add values','Save category and add values','2019-03-16 12:49:38'),(1689,'common',0,'Add and continue','Add and continue','2019-03-16 12:49:44'),(1690,'module_location',0,'Save and add cities','Save region and add cities','2019-03-16 12:49:51'),(1691,'module_apartmentCity',0,'The new city is successfully created.','New city is successfully created.','2019-03-16 12:49:52'),(1692,'module_location',0,'The new region is successfully created.','New region is successfully created.','2019-03-16 12:49:58'),(1693,'module_location',0,'Please add cities to the region now.','Please add cities to the region now.','2019-03-16 12:50:06'),(1694,'module_formeditor',0,'Create new category','Create new category','2019-03-16 12:50:07'),(1695,'module_formeditor',0,'Reference name','Reference name','2019-03-16 12:50:11'),(1696,'module_formeditor',0,'Display style','Display style','2019-03-16 12:50:13'),(1697,'module_formeditor',0,'Please add values to the field now.','Please add values to the category now.','2019-03-16 12:50:20'),(1698,'module_referencevalues',0,'The new reference value is successfully created.','New value is successfully created.','2019-03-16 12:50:22'),(1699,'module_referencecategories',0,'The new category is successfully created.','New category is successfully created.','2019-03-16 12:50:26'),(1700,'module_referencecategories',0,'Please add values to the category now.','Please add values to the category now.','2019-03-16 12:50:27'),(1701,'common',0,'Save and continue','Save and continue','2019-03-16 12:50:32'),(1702,'module_location',0,'The new city is successfully created.','New city is successfully created.','2019-03-16 12:50:35'),(1703,'common',0,'Search form','Search','2019-03-16 12:50:39'),(1704,'common',0,'The Agency with the same name already registered','The Agency with the same name already registered','2019-03-16 12:50:42'),(1705,'common',0,'Enter agency name','Enter agency name','2019-03-16 12:50:46'),(1706,'module_news',0,'Are you sure you want to delete this item?','Are you sure you want to delete this item?','2019-03-16 12:50:49'),(1707,'common',0,'The total cost of the booking: {cost}{currency}','Total booking fee: {cost}{currency}','2019-03-16 12:50:56'),(1708,'common',0,'You must pay {percent}% : {cost}{currency}','You should pay {percent}%: {cost}{currency}','2019-03-16 12:50:59'),(1709,'module_bookingtable',0,'Amount of days * Price per day','Amount of days * Price per day','2019-03-16 12:51:04'),(1710,'module_booking',0,'Booking admin comment help','If you put here another amount, add to the comments the calculation of the booking fee','2019-03-16 12:51:05'),(1711,'YiiMailer',0,'You need an HTML capable viewer to read this message.','You need an HTML capable viewer to read this message.','2019-03-16 12:51:09'),(1712,'YiiMailer',0,'SMTP Error: Could not authenticate.','SMTP Error: Could not authenticate.','2019-03-16 03:59:50'),(1713,'YiiMailer',0,'SMTP Error: Could not connect to SMTP host.','SMTP Error: Could not connect to SMTP host.','2019-03-16 03:59:50'),(1714,'YiiMailer',0,'SMTP Error: Data not accepted.','SMTP Error: Data not accepted.','2019-03-16 03:59:50'),(1715,'YiiMailer',0,'Message body empty','Message body empty','2019-03-16 03:59:50'),(1716,'YiiMailer',0,'Unknown encoding: ','Unknown encoding: ','2019-03-16 03:59:50'),(1717,'YiiMailer',0,'Could not execute: ','Could not execute: ','2019-03-16 03:59:50'),(1718,'YiiMailer',0,'Could not access file: ','Could not access file: ','2019-03-16 03:59:50'),(1719,'YiiMailer',0,'File Error: Could not open file: ','File Error: Could not open file: ','2019-03-16 03:59:50'),(1720,'YiiMailer',0,'The following From address failed: ','The following From address failed: ','2019-03-16 03:59:50'),(1721,'YiiMailer',0,'Could not instantiate mail function.','Could not instantiate mail function.','2019-03-16 12:51:58'),(1722,'YiiMailer',0,'Invalid address','Invalid address','2019-03-16 12:52:02'),(1723,'YiiMailer',0,' mailer is not supported.',' mailer is not supported.','2019-03-16 03:59:50'),(1724,'YiiMailer',0,'You must provide at least one recipient email address.','You must provide at least one recipient email address.','2019-03-16 03:59:50'),(1725,'YiiMailer',0,'SMTP Error: The following recipients failed: ','SMTP Error: The following recipients failed: ','2019-03-16 03:59:50'),(1726,'YiiMailer',0,'Signing Error: ','Signing Error: ','2019-03-16 03:59:50'),(1727,'YiiMailer',0,'SMTP Connect() failed.','SMTP Connect() failed.','2019-03-16 03:59:50'),(1728,'YiiMailer',0,'SMTP server error: ','SMTP server error: ','2019-03-16 03:59:50'),(1729,'YiiMailer',0,'Cannot set or reset variable: ','Cannot set or reset variable: ','2019-03-16 03:59:50'),(1730,'common',0,'Сalendar for booking a property','Сalendar for booking a property','2019-03-16 12:52:36'),(1731,'module_booking',0,'Admin comment','Admin comment','2019-03-16 12:52:42'),(1732,'module_booking',0,'The client wants to book','The client wants to book','2019-03-16 12:52:46'),(1733,'module_booking',0,'day|days|days','day|days|days','2019-03-16 12:52:50'),(1734,'module_booking',0,'Discount if there are more than 1 guest(%)','Discount if there are more than 1 guest(%)','2019-03-16 12:52:53'),(1735,'module_paidservices',0,'Calculate by minimum seasonal price','Calculate by minimum seasonal price','2019-03-16 12:52:56'),(1736,'module_paidservices',0,'Calculate by maximum seasonal price','Calculate by maximum seasonal price','2019-03-16 12:53:03'),(1737,'module_paidservices',0,'No calculation, price will be set by admin. Payment is immediately cancelled.','No calculation, price will be set by admin. Payment is immediately cancelled.','2019-03-16 12:53:09'),(1738,'module_paidservices',0,'Fee calculation for non-season days','Fee calculation for non-season days','2019-03-16 12:53:10'),(1739,'module_booking',0,'Number of guests','Guests','2019-03-16 12:53:14'),(1740,'module_themes',0,'Use_full_width_map_homepage','Use full width map on the homepage','2019-03-16 12:53:19'),(1741,'module_themes',0,'additional_map_help','The map shows listings in \'Special offer\' area and listings with paid services: Mark as special offer, Lift up in search and Add to the main slider.','2019-03-16 12:53:24'),(1742,'module_bookingtable',0,'Discount','Discount','2019-03-16 12:53:30'),(1743,'module_booking',0,'In total','In total','2019-03-16 12:53:35'),(1744,'module_bookingtable',0,'Taking account of number of guests the fee is','Taking account of number of guests the fee is','2019-03-16 12:53:38'),(1745,'module_paidservices',0,'Taking account of number of guests while calculating the booking fee','Taking account of number of guests while calculating the booking fee','2019-03-16 12:53:40'),(1746,'module_paidservices',0,'Once the option is on, the fee is calculating by multiplying the number of guests by the calculated booking fee','Once the option is on, the fee is calculating by multiplying the number of guests by the calculated booking fee.','2019-03-16 12:53:42'),(1747,'module_paidservices',0,'Pay now','Pay now','2019-03-16 12:53:45'),(1748,'module_booking',0,'Details','Details','2019-03-16 12:53:50'),(1749,'module_booking',0,'Booking details','Booking details','2019-03-16 12:53:55'),(1750,'common',0,'Owner','Owner','2019-03-16 12:54:01'),(1751,'common',0,'Add balance','Refill account','2019-03-16 12:54:06'),(1752,'common',0,'Agent name','Agent name','2019-03-16 12:54:12'),(1753,'common',0,'Price from','Price from','2019-03-16 12:54:17'),(1754,'common',0,'Price to','Price to','2019-03-16 12:54:22'),(1755,'common',0,'Price','Price','2019-03-16 12:54:26'),(1756,'module_apartments',0,'priceToValidatorText','Incorrect price','2019-03-16 12:54:27'),(1757,'common',0,'Rotate','Rotate','2019-03-16 12:54:30'),(1758,'module_seasonalprices',0,'For these days, the season has already exhibited price','For these days, the season has already exhibited price','2019-03-16 12:54:31'),(1759,'module_seasonalprices',0,'Update seasonal price','Update season','2019-03-16 12:54:37'),(1760,'module_stats',0,'Booking requests','Booking requests','2019-03-16 12:54:38'),(1761,'module_timezones',0,'Time zone is not set','Time zone is not set (server timezone)','2019-03-16 12:54:42'),(1762,'module_configuration',0,'site_timezone','Site’s Time Zone','2019-03-16 12:54:48'),(1763,'common',0,'Square','Square','2019-03-16 12:54:50'),(1764,'common',0,'Square from','Square from','2019-03-16 12:54:57'),(1765,'common',0,'Square to','Square to','2019-03-16 12:54:59'),(1766,'common',0,'Rooms','Bedrooms','2019-03-16 12:55:01'),(1767,'common',0,'Floor from','Floor from','2019-03-16 12:55:07'),(1768,'common',0,'Floor to','Floor to','2019-03-16 12:55:12'),(1769,'module_payment',0,'Secret key','Secret key','2019-03-16 03:59:50'),(1770,'module_tariffPlans',0,'No active tariff plans','No active tariff plans','2019-03-16 12:55:15'),(1771,'common',0,'Enter the required value','Enter the required value','2019-03-16 12:55:18'),(1772,'module_configuration',0,'Testing settings','Testing settings','2019-03-16 12:55:21'),(1773,'module_configuration',0,'To email','To email','2019-03-16 12:55:28'),(1774,'module_configuration',0,'Success_send','The email was successfully sent','2019-03-16 12:55:29'),(1775,'common',0,'Image SEO: alt tag','Image SEO: alt tag','2019-03-16 12:55:34'),(1776,'module_seo',0,'Body text','Text of page','2019-03-16 12:55:39'),(1777,'module_seo',0,'Entries images','Image for article','2019-03-16 12:55:40'),(1778,'module_seo',0,'Listing images','Image for listing','2019-03-16 12:55:43'),(1779,'module_seo',0,'ALT','ALT','2019-03-16 03:59:50'),(1780,'common',0,'ID','ID','2019-03-16 12:55:56'),(1781,'module_seo',0,'City','City','2019-03-16 12:56:02'),(1782,'common',0,'Summary info page','Summary information page','2019-03-16 12:56:03'),(1783,'common',0,'All listings','All listings','2019-03-16 12:56:05'),(1784,'common',0,'in','in','2019-03-16 12:56:09'),(1785,'common',0,'city_short','','2019-03-16 12:56:16'),(1786,'common',0,'Property','Property','2019-03-16 12:56:23'),(1787,'module_seo',0,'ApartmentObjType','Property type','2019-03-16 12:56:30'),(1788,'common',0,'Listings by categories','Listings by categories','2019-03-16 12:56:37'),(1789,'common',0,'Summary_infopage_listing','Summary information page + apartments list','2019-03-16 12:56:44'),(1790,'common',0,'km','km','2019-03-16 03:59:50'),(1791,'common',0,'Distance from','Distance from','2019-03-16 12:56:56'),(1792,'common',0,'meter','m','2019-03-16 12:56:59'),(1793,'common',0,'Please zoom in.','We found too many listings and displayed on part of them. Please increase the zoom level in the map.','2019-03-16 12:57:04'),(1794,'module_configuration',0,'module_apartments_gmapsZoomManyApartments','Zoom level for viewing many listings on the map','2019-03-16 12:57:06'),(1795,'module_configuration',0,'module_apartments_osmapsZoomManyApartments','Zoom level for viewing many listings on the map','2019-03-16 12:57:07'),(1796,'module_configuration',0,'module_apartments_ymapsZoomManyApartments','Zoom level for viewing many listings on the map','2019-03-16 12:57:13'),(1797,'common',0,'Hide filter','Hide filter','2019-03-16 12:57:16'),(1798,'common',0,'Comments for my listings','Comments for my listings','2019-03-16 12:57:18'),(1799,'common',0,'My comments','My comments','2019-03-16 12:57:22'),(1800,'module_apartments',0,'views_past_week','Statistics - views in the past week','2019-03-16 12:57:27'),(1801,'common',0,'{n} views','{n} view|{n} views','2019-03-16 12:57:34'),(1802,'common',0,'No statistics available','No statistics available','2019-03-16 12:57:36'),(1803,'common',0,'With photo','With photo','2019-03-16 12:57:43'),(1804,'common',0,'Without photo','Without photo','2019-03-16 12:57:48'),(1805,'common',0,'Photo','Photo','2019-03-16 12:57:49'),(1806,'common',0,'Clear all filter','Clear all filter','2019-03-16 12:57:53'),(1807,'module_payment',0,'Help image','Check the picture','2019-03-16 12:57:59'),(1808,'module_payment',0,'Go to your Paypal profile','Go to your Paypal profile','2019-03-16 12:58:06'),(1809,'module_payment',0,'Click My selling tools in the sidebar','Click My selling tools in the sidebar','2019-03-16 12:58:13'),(1810,'module_payment',0,'Scroll to the bottom and click PayPal button language encoding','Scroll to the bottom and click PayPal button language encoding','2019-03-16 12:58:19'),(1811,'module_payment',0,'Click More options and set the encoding to UTF-8','Click More options and set the encoding to UTF-8','2019-03-16 12:58:27'),(1812,'module_configuration',0,'googleMapApiKey','API KEY','2019-03-16 03:59:50'),(1813,'common',0,'Upload more photos from your account','Upload more photos from your account','2019-03-16 12:58:36'),(1814,'common',0,'Error loading. Try again later.','Error loading. Try again later.','2019-03-16 12:58:42'),(1815,'module_images',0,'You are trying to download more than {num} pictures','You try to upload more than {num} pictures','2019-03-16 12:58:47'),(1816,'module_configuration',0,'booking_half_day','Нalf day booking','2019-03-16 12:58:54'),(1817,'module_booking',0,'In the forenoon','In the forenoon','2019-03-16 12:58:56'),(1818,'module_booking',0,'In the afternoon','In the afternoon','2019-03-16 12:59:02'),(1819,'module_bookingcalendar',0,'Available Check-Out Time for this date is only in the forenoon','Available Check-Out Time for this date is only in the forenoon','2019-03-16 12:59:05'),(1820,'module_bookingcalendar',0,'Available Check-in Time for this date is only in the afternoon','Available Check-in Time for this date is only in the afternoon','2019-03-16 12:59:07'),(1821,'module_bookingcalendar',0,'Dates you have chosen are unavailable','Dates you have chosen are unavailable','2019-03-16 12:59:09'),(1822,'module_bookingcalendar',0,'Date you have chosen is unavailable','Date you have chosen is unavailable','2019-03-16 12:59:12'),(1829,'module_currency',0,'SAR_translate','SAR','2019-03-16 03:59:50'),(1830,'module_currency',0,'BYN_translate','BYN','2019-03-16 12:59:21'),(1831,'common',0,'RTL','RTL','2019-03-16 03:59:50'),(1832,'common',0,'Overview','Overview','2019-03-16 12:59:33'),(1833,'common',0,'Listings awaiting confirmation','Listings awaiting confirmation','2019-03-16 12:59:37'),(1834,'common',0,'New private messages','New private messages','2019-03-16 12:59:44'),(1835,'common',0,'Comments awaiting confirmation','Comments awaiting confirmation','2019-03-16 12:59:47'),(1836,'common',0,'New bookings','New bookings','2019-03-16 12:59:50'),(1837,'common',0,'Cities awaiting moderation','Cities awaiting moderation','2019-03-16 12:59:54'),(1838,'common',0,'New payments','New payments','2019-03-16 12:59:56'),(1839,'common',0,'Collapse','Collapse','2019-03-16 13:00:02'),(1840,'common',0,'Coordinates found','Coordinates found','2019-03-16 13:00:06'),(1841,'common',0,'Coordinates not found','Coordinates not found','2019-03-16 13:00:10'),(1842,'common',0,'Control','Control','2019-03-16 13:00:13'),(1843,'common',0,'Message deleted by user','Message deleted by user','2019-03-16 13:00:20'),(1844,'module_bookingcalendar',0,'Created by booking request','Created by booking request','2019-03-16 13:00:26'),(1845,'module_historyChanges',0,'Clear history older than','Clear history older than','2019-03-16 13:00:32'),(1846,'common',0,'Actions','Actions','2019-03-16 13:00:36'),(1847,'common',0,'Manage','Manage','2019-03-16 13:00:38'),(1848,'common',0,'View','View','2019-03-16 13:00:43'),(1849,'common',0,'Update','Update','2019-03-16 13:00:46'),(1850,'module_userads',0,'Change','Change','2019-03-16 13:00:51'),(1851,'module_booking',0,'Booking status change','Booking status change','2019-03-16 13:00:57'),(1852,'module_formeditor',0,'compare from to','The field must be in a range from... to...','2019-03-16 13:01:02'),(1853,'module_formeditor',0,'type range','Range field','2019-03-16 13:01:08'),(1854,'common',0,'field_to','to','2019-03-16 13:01:13'),(1855,'common',0,'field_from','from','2019-03-16 13:01:19'),(1856,'module_formeditor',0,'both values are required and must be numerical','Both values are required and should be numbers','2019-03-16 13:01:22'),(1857,'module_configuration',0,'useReCaptcha','Use reCAPTCHA V2','2019-03-16 13:01:26'),(1858,'module_configuration',0,'reCaptchaKey','reCAPTCHA V2 Key','2019-03-16 13:01:33'),(1859,'module_configuration',0,'reCaptchaSecret','reCAPTCHA V2 Secret Key','2019-03-16 13:01:38'),(1860,'common',0,'Previous','Previous','2019-03-16 13:01:44'),(1861,'common',0,'Next','Next','2019-03-16 13:01:47'),(1862,'module_configuration',0,'stepByStepAd','Step-by-step adding listings','2019-03-16 13:01:54'),(1863,'module_formeditor',0,'Main page','Home page','2019-03-16 13:01:58'),(1864,'module_formeditor',0,'Inner pages','Inner pages','2019-03-16 13:02:04'),(1865,'common',0,'From listing page','From listing page','2019-03-16 13:02:09'),(1866,'common',0,'Documents','Files','2019-03-16 13:02:16'),(1867,'common',0,'Documents_upload_help','Max number of files - 5. The document shouldnt exceed 5 Mb.','2019-03-16 13:02:23'),(1868,'module_apartments',0,'document_file','File','2019-03-16 13:02:29'),(1869,'module_apartments',0,'You are trying to download more than {num} documents','You are trying to download more than {num} files','2019-03-16 13:02:32'),(1870,'module_apartments',0,'No_documents','No files','2019-03-16 13:02:35'),(1871,'module_apartments',0,'Original_document_name','File name','2019-03-16 13:02:37'),(1872,'module_apartments',0,'document_original_name','File name','2019-03-16 13:02:39'),(1873,'module_apartments',0,'document_modified_name','File storage name','2019-03-16 13:02:42'),(1874,'module_historyChanges',0,'document','File','2019-03-16 13:02:44'),(1876,'common',0,'Manage carousel','Carousel Controls','2019-03-16 13:02:48'),(1877,'module_slider',0,'Manage carousel','Carousel Controls','2019-03-16 13:02:51'),(1878,'module_slider',0,'Add carousel','Add your carousel','2019-03-16 13:02:53'),(1879,'module_slider',0,'Delete carousel','Delete your carousel','2019-03-16 13:02:58'),(1880,'module_slider',0,'Edit carousel','Edit Carousel','2019-03-16 13:03:00'),(1881,'common',0,'Photos for carousel','Photo for carousel','2019-03-16 13:03:07'),(1882,'common',0,'Image data','Picture Data','2019-03-16 13:03:09'),(1883,'module_slider',0,'Code','The code to insert in the materials','2019-03-16 13:03:16'),(1884,'module_payment',0,'Use ATOL','Use ATOL','2019-03-16 13:03:21'),(1885,'module_payment',0,'ATOL CMS Login','ATOL CMS Login','2019-03-16 13:03:26'),(1886,'module_payment',0,'ATOL CMS Password','ATOL CMS Password','2019-03-16 13:03:33'),(1887,'module_payment',0,'Organization code','Organization code','2019-03-16 13:03:40'),(1888,'module_payment',0,'Organization INN','Organization INN','2019-03-16 13:03:42'),(1889,'module_payment',0,'Organization address','Organization address','2019-03-16 13:03:50'),(1890,'module_payment',0,'Use_ATOL_help','Только для Российской Федерации и платежах в рублях.<br /><br />15.07.2016 вступила в силу новая редакция 54-ФЗ  «О применении кассовой техники».<br />В ней говорится о поэтапном переходе бизнеса на применение контрольно-кассовой техники с доступом в интернет (онлайн-ККТ).<br />Теперь данные о каждой вашей продаже должны передаваться по интернету оператору фискальных данных (он же ОФД).<br />А от него они уже будут поступать в налоговую инспекцию.','2019-03-16 13:03:53'),(1891,'module_customHtml',0,'Manage custom html','Custom HTML','2019-03-16 13:03:59'),(1892,'module_customHtml',0,'Add custom html','Add custom html','2019-03-16 13:04:05'),(1893,'module_customHtml',0,'Code','The code to insert in the materials','2019-03-16 13:04:08'),(1894,'module_customHtml',0,'Custom HTML','Custom HTML','2019-03-16 13:04:12'),(1895,'module_customHtml',0,'Update custom html','Update custom html','2019-03-16 13:04:18'),(1896,'module_customHtml',0,'Delete custom html','Delete custom html','2019-03-16 13:04:25'),(1897,'module_customHtml',0,'Name','Name','2019-03-16 13:04:29'),(1898,'module_customHtml',0,'Code for view tempalte','The code to insert into a template','2019-03-16 13:04:34'),(1899,'module_payment',0,'Tax system','Taxation system','2019-03-16 13:04:40'),(1900,'module_payment',0,'Tax number','Tax number','2019-03-16 13:04:47'),(1901,'module_payment',0,'Common system','Common system of taxation','2019-03-16 13:04:51'),(1902,'module_payment',0,'Simplified system (income)','The simplified system of taxation (income)','2019-03-16 13:04:55'),(1903,'module_payment',0,'Simplified system (income minus charges)','The simplified system of taxation (income minus expenses)','2019-03-16 13:05:01'),(1904,'module_payment',0,'A single tax on imputed income','The uniform tax on vmenennyj the income','2019-03-16 13:05:04'),(1905,'module_payment',0,'Unified agricultural tax','A single agricultural tax','2019-03-16 13:05:10'),(1906,'module_payment',0,'Patent system','Patent tax system','2019-03-16 13:05:15'),(1907,'module_payment',0,'Without VAT','excl. VAT','2019-03-16 13:05:21'),(1908,'module_payment',0,'VAT 0%','VAT at the rate of 0%','2019-03-16 13:05:26'),(1909,'module_payment',0,'VAT 10%','VAT cheque at a rate of 10%','2019-03-16 13:05:33'),(1910,'module_payment',0,'VAT 18%','VAT cheque at the rate of 18%','2019-03-16 13:05:39'),(1911,'module_payment',0,'VAT 10/110','VAT cheque clearing rate 10/110','2019-03-16 13:05:41'),(1912,'module_payment',0,'VAT 18/118','VAT cheque clearing rate 18/118','2019-03-16 13:05:43'),(1913,'common',0,'Save and close','Save and close','2019-03-16 13:05:50'),(1914,'common',0,'By clicking \"{buttonName}\", you agree to our <a href=\"{licenceUrl}\" target=\"_blank\">User agreement</a>','By clicking \"{buttonName}\", you agree to our <a href=\"{licenceUrl}\" target=\"_blank\">User agreement</a>','2019-03-16 13:05:57'),(1915,'module_referencevalues',0,'Rent','Rent property from somebody','2019-03-16 13:06:00'),(1916,'module_referencevalues',0,'Buy','Buy','2019-03-16 13:06:04'),(1917,'module_referencevalues',0,'Exchange','Exchange','2019-03-16 13:06:11'),(1918,'common',0,'Loan calculator','Financing Calculator','2019-03-16 13:06:18'),(1919,'module_loanCalculator',0,'Amount of credit','Credit amount','2019-03-16 13:06:23'),(1920,'module_loanCalculator',0,'Amount of credit (month)','Loan term (months)','2019-03-16 13:06:25'),(1921,'module_loanCalculator',0,'Interest rate','Interest rate','2019-03-16 13:06:30'),(1922,'module_loanCalculator',0,'Getting payments','Start payments','2019-03-16 13:06:34'),(1923,'module_loanCalculator',0,'Calculate','Calculate','2019-03-16 13:06:41'),(1924,'module_loanCalculator',0,'Monthly payment','Monthly payment','2019-03-16 13:06:48'),(1925,'module_loanCalculator',0,'Overpayment','Overpayment','2019-03-16 13:06:55'),(1926,'module_loanCalculator',0,'January','January','2019-03-16 13:07:02'),(1927,'module_loanCalculator',0,'February','February','2019-03-16 13:07:09'),(1928,'module_loanCalculator',0,'March','March','2019-03-16 13:07:16'),(1929,'module_loanCalculator',0,'April','April','2019-03-16 13:07:18'),(1930,'module_loanCalculator',0,'may','May','2019-03-16 13:07:22'),(1931,'module_loanCalculator',0,'June','June','2019-03-16 13:07:27'),(1932,'module_loanCalculator',0,'July','July','2019-03-16 13:07:32'),(1933,'module_loanCalculator',0,'August','August','2019-03-16 13:07:37'),(1934,'module_loanCalculator',0,'September','September','2019-03-16 13:07:42'),(1935,'module_loanCalculator',0,'October','October','2019-03-16 13:07:46'),(1936,'module_loanCalculator',0,'November','November','2019-03-16 13:07:47'),(1937,'module_loanCalculator',0,'December','December','2019-03-16 13:07:53'),(1938,'module_loanCalculator',0,'Payment date','Date of payment','2019-03-16 13:08:01'),(1939,'module_loanCalculator',0,'The balance of debt','Oustanding balance','2019-03-16 13:08:05'),(1940,'module_loanCalculator',0,'Interest payments','Payment of interest','2019-03-16 13:08:12'),(1941,'module_loanCalculator',0,'Loan payment','Loan payment','2019-03-16 13:08:14'),(1942,'module_loanCalculator',0,'Annuity payment','Annuity payment','2019-03-16 13:08:22'),(1943,'module_loanCalculator',0,'Loan calculator','Loan calculator','2019-03-16 13:08:27'),(1944,'common',0,'{n} review|{n} reviews','{n} review|{n} reviews','2019-03-16 13:08:29'),(1945,'module_quicksearch',0,'Sorting by rating','Sort by rating','2019-03-16 13:08:33'),(1946,'common',0,'Summary_infopage','Summary information page','2019-03-16 13:08:39'),(1947,'module_infopages',0,'Filter for summary infopage','Filter for summary information page','2019-03-16 13:08:42'),(1948,'common',0,'Title for the apartments list','Title for the apartments list','2019-03-16 13:08:43'),(1949,'common',0,'Title for the listings by categories','Title for the listings by categories','2019-03-16 13:08:46'),(1950,'common',0,'Title for the articles list','Title for the articles list','2019-03-16 13:08:53'),(1951,'common',0,'Title for the contact form','Title for the contact form','2019-03-16 13:08:56'),(1952,'module_service',0,'The change of the variable  \"max_execution_time\" is forbidden by your hosting provider. The backup feature is unavailable.','The change of the variable  \"max_execution_time\" is forbidden by your hosting provider. The backup feature is unavailable.','2019-03-16 13:09:01'),(1953,'module_service',0,'There are more than {listingsCount} listings in your site, the size of the folder uploads is {uploadFolderSize}','There are more than {listingsCount} listings in your site, the size of the folder uploads is {uploadFolderSize}','2019-03-16 13:09:04'),(1954,'module_service',0,'You\'d rather use hosting features to create a backup.','You\'d rather use hosting features to create a backup.','2019-03-16 13:09:09'),(1955,'module_service',0,'We don\'t recommend you to use the backup feature with the help of CMS to avoid long uploading and buzzing of the site, and also because this process may take a long time.','We don\'t recommend you to use the backup feature with the help of CMS to avoid long uploading and buzzing of the site, and also because this process may take a long time.','2019-03-16 13:09:17'),(1956,'module_service',0,'The backup process and the site restoring can be done much faster in the Cpanel of the hosting provider.','The backup process and the site restoring can be done much faster in the Cpanel of the hosting provider.','2019-03-16 13:09:20'),(1957,'module_service',0,'You can also set the backup timetable, if your hosting provider has such a feature.','You can also set the backup timetable, if your hosting provider has such a feature.','2019-03-16 13:09:26'),(1958,'module_service',0,'We recommend you to use our partners\' hosting: {hostingPartnerUrl}','We recommend you to use our partners\' hosting: {hostingPartnerUrl}','2019-03-16 13:09:32'),(1959,'module_service',0,'Create backup','Create backup','2019-03-16 13:09:33'),(1960,'module_service',0,'Name','Name','2019-03-16 13:09:38'),(1961,'module_service',0,'Size','Size','2019-03-16 13:09:43'),(1962,'module_service',0,'Create date','Create date','2019-03-16 13:09:46'),(1963,'common',0,'Download','Download','2019-03-16 13:09:52'),(1964,'common',0,'Restore','Restore','2019-03-16 13:09:53'),(1965,'module_service',0,'Are you sure restore backup? This process may fail and the website will become unavailable!','Are you sure restore backup? This process may fail and the website will become unavailable!','2019-03-16 13:09:55'),(1966,'module_service',0,'Successfully Create the backup file: {backup}','Successfully Create the backup file: {backup}','2019-03-16 13:09:58'),(1967,'module_service',0,'The size of the folder uploads is {uploadFolderSize}','The size of the folder uploads is {uploadFolderSize}','2019-03-16 13:10:01'),(1968,'module_service',0,'Warning: This is an experimental function. For any questions or suggestions don\'t hesitate to contact us: <a href=\'{contact_us_link}\' target=\'_blank\'>{contact_us_link}</a>','Warning: This is an experimental function. For any questions or suggestions don\'t hesitate to contact us: <a href=\'{contact_us_link}\' target=\'_blank\'>{contact_us_link}</a>','2019-03-16 13:10:03'),(1969,'module_service',0,'Unable to restore backup correctly: {backup}','Unable to restore backup correctly: {backup}','2019-03-16 13:10:09'),(1970,'common',0,'Please wait until the process is complete.','Please wait until the process is complete.','2019-03-16 13:10:11'),(1971,'module_service',0,'Successfully restored the backup file: {backup}','Successfully restored the backup file: {backup}','2019-03-16 13:10:16'),(1972,'module_customHtml',0,'Body','Text','2019-03-16 13:10:18'),(1973,'slider',0,'Title','Title','2019-03-16 13:10:21'),(1974,'slider',0,'Text','Text','2019-03-16 13:10:28'),(1975,'module_configuration',0,'module_notifier_allow_replyToEmail','Allow reply to a user\'s email','2019-03-16 13:10:31'),(1976,'module_themes',0,'Use_search_without_slider_homepage','Use search form without a slider on the homepage','2019-03-16 13:10:33'),(1977,'common',0,'Search by open_plan','Open plan','2019-03-16 13:10:41'),(1978,'common',0,'Search by room_type','Room type','2019-03-16 13:10:48'),(1979,'common',0,'Search by balcony_type','Type of balcony','2019-03-16 13:10:52'),(1980,'common',0,'Search by wc_type','Type of WC','2019-03-16 13:10:56'),(1981,'common',0,'Search by floor_coat','Floor coating','2019-03-16 13:11:03'),(1982,'common',0,'Search by garage_type','Garage type','2019-03-16 13:11:05'),(1983,'common',0,'Search by build_year','Construction Year','2019-03-16 13:11:07'),(1984,'common',0,'Search by repair','Repair','2019-03-16 13:11:08'),(1985,'common',0,'Search by object_state','State of the object','2019-03-16 13:11:11'),(1986,'common',0,'Search by building_type','Building-type','2019-03-16 13:11:14'),(1987,'common',0,'Search by plot_type','Plot type','2019-03-16 13:11:21'),(1988,'common',0,'Search by utilities','Utilities','2019-03-16 13:11:23'),(1989,'module_socialauth',1,'Sign up with','Sign up with','2019-03-16 13:11:29'),(1990,'module_apartments',0,'Show in search','Show in search','2019-03-16 13:11:35'),(1991,'module_apartments',0,'Show in grid','Show in common table','2019-03-16 13:11:37'),(1992,'module_apartments',0,'Contains objects','Contains objects','2019-03-16 13:11:42'),(1993,'common',0,'child_section_6','Rooms','2019-03-16 13:11:49'),(1994,'common',0,'child_add_6','Add room','2019-03-16 13:11:52'),(1995,'common',0,'child_success_add_6','The room was successfully added','2019-03-16 13:11:56'),(1996,'module_apartmentObjType',0,'Section','Section','2019-03-16 13:12:03'),(1997,'module_apartmentObjType',0,'The caption on the add button','The caption on the add button','2019-03-16 13:12:09'),(1998,'module_apartmentObjType',0,'The message about the successful addition','Success message','2019-03-16 13:12:15'),(1999,'module_yandexRealty',0,'Type','Type','2019-03-16 13:12:18'),(2000,'module_yandexRealty',0,'Subtype','Subtype','2019-03-16 13:12:20'),(2001,'common',0,'Getting started','Getting started','2019-03-16 13:12:23'),(2002,'common',0,'Go to','Go to','2019-03-16 13:12:30'),(2003,'common',0,'Add web counter','Add web counter','2019-03-16 13:12:35'),(2004,'common',0,'Change the site logo','Change the site logo','2019-03-16 13:12:42'),(2005,'common',0,'Set up sending letters from the site','Set up sending letters from the site','2019-03-16 13:12:44'),(2006,'common',0,'Add property types','Add property types','2019-03-16 13:12:47'),(2007,'common',0,'Add apartment properties','Add apartment properties','2019-03-16 13:12:48'),(2008,'common',0,'Set up watermark in objects photo','Set up watermark in objects photo','2019-03-16 13:12:56'),(2009,'common',0,'Add listings','Add listings','2019-03-16 13:12:59'),(2010,'common',0,'Post news about website startup','Post news about website startup','2019-03-16 13:13:02'),(2011,'module_blockIp',0,'Error. Repeat attempt later','Error. Repeat attempt later','2019-03-16 13:13:07'),(2012,'common',0,'child_section_5','Apartments','2019-03-16 13:13:13'),(2013,'common',0,'child_add_5','Add new apartment','2019-03-16 13:13:20'),(2014,'common',0,'child_success_add_5','Apartment successfully saved','2019-03-16 13:13:24'),(2015,'common',0,'An unusual way of Open Real Estate script usage','An unusual way of Open Real Estate usage','2019-03-16 13:13:31'),(2016,'common',0,'Upload failed. To upload image please increase the amount of RAM in your hosting.','Upload failed. To upload image please increase the amount of RAM in your hosting.','2019-03-16 13:13:32'),(2017,'module_basis_theme',0,'Popular Destinations','Popular Destinations','2019-03-16 13:13:37'),(2018,'common',0,'Best listings','Best listings','2019-03-16 13:13:42'),(2019,'common',0,'photo|photos|photos','photo|photos|photos','2019-03-16 13:13:48'),(2020,'module_theme_basis',0,'You receive the full-fledged website to a flow of new clients','You receive the full-fledged website to a flow of new clients','2019-03-16 13:13:50'),(2021,'module_theme_basis',0,'Free of charge','Free of charge','2019-03-16 13:13:53'),(2022,'module_theme_basis',0,'download the script','download the script','2019-03-16 13:13:59'),(2023,'module_theme_basis',0,'The free version','The free version','2019-03-16 13:14:03'),(2024,'module_theme_basis',0,'with an open source','with an open source','2019-03-16 13:14:10'),(2025,'module_theme_basis',0,'Just download','Just download','2019-03-16 13:14:15'),(2026,'module_theme_basis',0,'Open Real Estate archive and install on a hosting','Open Real Estate archive and install on a hosting','2019-03-16 13:14:19'),(2027,'module_theme_basis',0,'Fill','Fill','2019-03-16 13:14:24'),(2028,'module_theme_basis',0,'the website','the website','2019-03-16 13:14:31'),(2029,'module_theme_basis',0,'The website is ready!','The website is ready!','2019-03-16 13:14:37'),(2030,'module_theme_basis',0,'You just have to fill the base of listings','You just have to fill the base of listings','2019-03-16 13:14:43'),(2031,'module_theme_basis',0,'Receive','Receive','2019-03-16 13:14:50'),(2032,'module_theme_basis',0,'new clients','new clients','2019-03-16 13:14:53'),(2033,'module_theme_basis',0,'With our help, ','With our help, ','2019-03-16 13:14:58'),(2034,'module_theme_basis',0,'more than 1000 real estate','more than 1000 real estate','2019-03-16 13:15:03'),(2035,'module_theme_basis',0,'agencies and private realtors already derive an income from the website','agencies and private realtors already derive an income from the website','2019-03-16 13:15:10'),(2036,'module_theme_basis',0,'To try free of charge','To try free of charge','2019-03-16 13:15:14'),(2037,'module_entries',0,'Last news','Last news','2019-03-16 13:15:17'),(2038,'common',0,'All news','All news','2019-03-16 13:15:18'),(2039,'common',0,'Add news','Add news','2019-03-16 13:15:26'),(2040,'common',0,'{n} in the comparison list','{n} in the comparison list','2019-03-16 13:15:28'),(2041,'module_theme_basis',0,'About us','About us','2019-03-16 13:15:35'),(2042,'module_theme_basis',0,'index_email','support@monoray.net','2019-03-16 03:59:50'),(2043,'module_theme_basis',0,'index_skype','monoray.studio','2019-03-16 03:59:50'),(2044,'module_theme_basis',0,'index_phone','+7 (8362) 38-18-28','2019-03-16 03:59:50'),(2045,'module_theme_basis',0,'index_about_text','Open Real Estate CMS is a ready-to-use business solution. It can increase the profits of the real estate agency and the real estate agents as well. ','2019-03-16 13:15:57'),(2046,'module_theme_basis',0,'Helpful information','Helpful information','2019-03-16 13:15:58'),(2047,'module_theme_basis',0,'We are in social networks','We are in social networks','2019-03-16 13:16:02'),(2048,'module_theme_basis',0,'General information','General information','2019-03-16 13:16:05'),(2049,'module_quicksearch',0,'Sorting by default','Sorting by default','2019-03-16 13:16:06'),(2050,'module_themes',0,'Index page','Index page','2019-03-16 13:16:12'),(2051,'module_themes',0,'Cities','Cities','2019-03-16 13:16:18'),(2052,'module_themes',0,'Display widget \"slider\" and \"popular directions\"','Display widget \"slider\" and \"popular directions\"','2019-03-16 13:16:21'),(2053,'module_themes',0,'Display widget \"Best listings\"','Display widget \"Best listings\"','2019-03-16 13:16:22'),(2054,'module_themes',0,'Display widget \"Feature\"','Display widget \"Feature\"','2019-03-16 13:16:27'),(2055,'module_themes',0,'Display widget \"Contact\"','Display widget \"Contact us\"','2019-03-16 13:16:33'),(2056,'module_themes',0,'Display widget \"Last news\"','Display widget \"Last news\"','2019-03-16 13:16:39'),(2057,'module_themes',0,'Show specified cities','Show specified cities','2019-03-16 13:16:43'),(2058,'module_themes',0,'Widget \"Popular destinations\"','Widget \"Popular destinations\"','2019-03-16 13:16:50'),(2059,'module_themes',0,'Edit city','Edit city','2019-03-16 13:16:54'),(2060,'module_themes',0,'Delete row','Delete row','2019-03-16 13:16:57'),(2061,'module_themes',0,'Add city','Add city','2019-03-16 13:17:01'),(2062,'common',0,'WYSIWYG_apply','Apply','2019-03-16 13:17:06'),(2063,'common',0,'WYSIWYG_destroy','Destroy','2019-03-16 13:17:13'),(2064,'module_menumanager',0,'Add menu','Add menu','2019-03-16 13:17:14'),(2065,'module_menumanager',0,'Manage menu','Manage menu','2019-03-16 13:17:18'),(2066,'common',0,'Title','Title','2019-03-16 13:17:22'),(2067,'module_currency',0,'HKD_translate','HKD','2019-03-16 03:59:50'),(2068,'module_themes',0,'Link to group in vk','Link to group in vk.com','2019-03-16 13:17:35'),(2069,'module_themes',0,'Link to group in facebook','Link to group in facebook','2019-03-16 13:17:36'),(2070,'module_themes',0,'Link to group in twitter','Link to group in twitter','2019-03-16 13:17:42'),(2071,'module_themes',0,'Coordinates of the marker contacts, latitude','Coordinates of the marker contacts, latitude','2019-03-16 13:17:50'),(2072,'module_themes',0,'Coordinates of the marker contacts, longitude','Coordinates of the marker contacts, longitude','2019-03-16 13:17:52'),(2073,'module_themes',0,'Zoom for contact map','Zoom for contact map','2019-03-16 13:17:54'),(2074,'module_apartmentObjType',0,'Type live','Residential properties','2019-03-16 13:17:55'),(2075,'module_apartmentObjType',0,'Type commercial','Commercial property','2019-03-16 13:17:57'),(2076,'module_apartmentObjType',0,'Type new','New building','2019-03-16 13:17:59'),(2077,'common',0,'Setup recaptcha (spam protection)','Setup recaptcha (spam protection)','2019-03-16 13:18:01'),(2078,'common',0,'<a target=\"_blank\" href=\"https://open-real-estate.info/en/system-requirements\">System requirements</a>','<a target=\"_blank\" href=\"https://open-real-estate.info/en/system-requirements\">System requirements</a>','2019-03-16 13:18:02'),(2079,'common',0,'<a target=\"_blank\" href=\"https://open-real-estate.info/en/license\">License agreement</a>','<a target=\"_blank\" href=\"https://open-real-estate.info/en/license\">License agreement</a>','2019-03-16 13:18:09'),(2080,'common',0,'<a target=\"_blank\" href=\"https://open-real-estate.info/en/technical-support-rules\">Support terms</a>','<a target=\"_blank\" href=\"https://open-real-estate.info/en/technical-support-rules\">Support terms</a>','2019-03-16 13:18:14'),(2081,'common',0,'<a target=\"_blank\" href=\"https://open-real-estate.info/en/download-open-real-estate\">Get a new version of Open Real Estate CMS</a>','<a target=\"_blank\" href=\"https://open-real-estate.info/en/download-open-real-estate\">Get a new version of Open Real Estate CMS</a>','2019-03-16 13:18:20'),(2082,'common',0,'<a target=\"_blank\" href=\"https://monoray.net/forum/\">Our forum</a>','<a target=\"_blank\" href=\"https://monoray.net/forum/\">Our forum</a>','2019-03-16 13:18:27'),(2083,'common',0,'<a target=\"_blank\" href=\"https://open-real-estate.info/en/faq\">FAQ</a>','<a target=\"_blank\" href=\"https://open-real-estate.info/en/faq\">FAQ</a>','2019-03-16 13:18:34'),(2084,'common',0,'Information','Information','2019-03-16 13:18:41'),(2085,'module_configuration',0,'Price format “to”','Price format “to”','2019-03-16 13:18:43'),(2086,'module_configuration',0,'Price format “from”','Price format “from”','2019-03-16 13:18:44'),(2087,'module_configuration',0,'Price format by default','Price format by default','2019-03-16 13:18:46'),(2088,'module_currency',0,'free.currencyconverterapi.com','free.currencyconverterapi.com','2019-03-16 03:59:50'),(2089,'module_currency',0,'HRK_translate','HRK','2019-03-16 03:59:50'),(2090,'module_currency',0,'IDR_translate','IDR','2019-03-16 03:59:50'),(2091,'module_currency',0,'ILS_translate','ILS','2019-03-16 03:59:50'),(2092,'module_currency',0,'ISK_translate','ISK','2019-03-16 03:59:50'),(2093,'module_currency',0,'MXN_translate','MXN','2019-03-16 03:59:50'),(2094,'module_currency',0,'MYR_translate','MYR','2019-03-16 03:59:50'),(2095,'module_currency',0,'NZD_translate','NZD','2019-03-16 03:59:50'),(2096,'module_currency',0,'PHP_translate','PHP','2019-03-16 03:59:50'),(2097,'module_currency',0,'THB_translate','THB','2019-03-16 03:59:50'),(2098,'module_configuration',0,'show_loan_calculator','Show loan calculator','2019-03-16 13:19:14'),(2099,'module_users',0,'Use API','Use REST API','2019-03-16 13:19:21'),(2100,'module_users',0,'API token','REST API TOKEN','2019-03-16 03:59:50'),(2101,'common',0,'Regenerate','Regenerate','2019-03-16 13:19:28'),(2102,'common',0,'module_name_api','Module \"REST API\"','2019-03-16 13:19:31'),(2103,'common',0,'module_description_api','This plugin provides an easy to use REST API, available via HTTP. Grab your site’s listings in simple JSON format. Retrieving or updating data is as simple as sending a HTTP request.','2019-03-16 13:19:33'),(2105,'common',0,'Undefined auth user. Please send PHP_AUTH_USER_TOKEN','Undefined auth user. Please send PHP_AUTH_USER_TOKEN','2019-03-16 03:59:50'),(2106,'module_users',0,'API user','REST API user','2019-03-16 03:59:50'),(2107,'module_users',0,'API password','REST API password','2019-03-16 03:59:50'),(2108,'common',0,'Invalid data parameters','Invalid data parameters','2019-03-16 13:19:50'),(2109,'module_theme_basis',0,'Toggle navigation','Toggle navigation','2019-03-16 03:59:50'),(2110,'common',0,'child_section_1','Section apartment','2019-03-16 13:19:59'),(2111,'common',0,'child_add_1','Add apartment','2019-03-16 13:20:00'),(2112,'common',0,'child_success_add_1','Success added apartment','2019-03-16 13:20:07'),(2113,'module_translateCsv',0,'Translate Csv','Translations in CSV format','2019-03-16 13:20:14'),(2114,'module_translateCsv',0,'Export CSV','Export CSV','2019-03-16 13:20:19'),(2115,'module_translateCsv',0,'Export','Export','2019-03-16 13:20:22'),(2116,'module_translateCsv',0,'Import CSV','Import CSV','2019-03-16 13:20:26'),(2117,'module_translateCsv',0,'Import','Import','2019-03-16 13:20:33'),(2121,'module_translateCsv',0,'The File is invalid for use as the following: delimiter must be: {delimiter}. Enclosure must be: \".','The File is invalid for use as the following: delimiter must be: {delimiter}. Enclosure must be: \".','2019-03-16 13:20:41'),(2122,'module_translateCsv',0,'fields imported','records were imported','2019-03-16 13:20:42'),(2123,'module_payment',0,'VAT 20%','VAT cheque at the rate of 20%','2019-03-16 13:20:45'),(2124,'module_payment',0,'VAT 20/120','VAT cheque clearing rate 20/120','2019-03-16 13:20:46'),(2125,'module_translateCsv',0,'Example CSV file','Example CSV file','2019-03-16 13:20:47'),(2126,'module_tariffPlans',0,'Paid tariff plans','Paid tariff plans','2019-03-16 13:20:55'),(2127,'module_tariffPlans',0,'No tariff plan','No tariff plan','2019-03-16 13:20:59'),(2128,'module_configuration',0,'module_apartments_ymapApiKey','API key','2019-04-01 13:25:11'),(2129,'common',0,'Get API Key','Get API Key','2019-04-02 06:36:50'),(2133,'module_themes',0,'Display widget \"Popular directions\"','Display widget \"Popular directions\"','2019-07-29 11:06:25'),(2134,'module_themes',0,'Upload listings','Loading listings...','2019-07-29 11:02:52'),(2135,'module_themes',0,'Edit item','Edit item','2019-07-29 10:51:02'),(2136,'module_themes',0,'Not load','Not load','2019-07-29 11:01:53'),(2137,'module_themes',0,'Load by criteria','Load by criteria','2019-07-29 11:00:37'),(2138,'module_themes',0,'Load all','Load all','2019-07-29 11:00:24'),(2139,'common',0,'The item is deleted','The item is deleted','2019-07-29 10:57:19'),(2141,'module_themes',0,'Objects for the widget','Objects for the widget','2019-07-29 10:57:43'),(2142,'common',0,'module_name_articles','Module \"Q & A\"','2019-11-30 07:11:53'),(2143,'common',0,'module_description_articles','-','2019-11-30 07:12:13'),(2144,'common',0,'module_name_reviews','Module \"Reviews\"','2019-11-30 07:12:48'),(2145,'common',0,'module_description_reviews','-','2019-11-30 07:12:57'),(2146,'module_favorite',0,'Favorites','Favorites','2020-02-16 16:06:30'),(2147,'module_favorite',0,'Remove from favorites','Remove from favorites','2020-02-16 16:06:13'),(2148,'module_favorite',0,'Add as favorite','Add as favorite','2020-02-16 16:05:46'),(2149,'common',0,'thumbQuality','Thumbnail quality (1 - 100)','2020-01-28 13:15:27'),(2150,'common',0,'module_name_favorite','Module \"Favorite\"','2020-02-28 15:58:08'),(2151,'common',0,'module_description_favorite','-','2020-02-28 15:58:10'),(2152,'module_configuration',0,'useTitleWithID','Display ad id before title','2020-03-28 10:33:58'),(2153,'module_configuration',0,'parentIdAll','\"Located in\" selection of all suitable objects','2020-03-28 11:34:07'),(2154,'module_configuration',0,'descriptionUseEditor','Visual editor for the Description field','2020-03-29 12:00:31'),(2155,'module_configuration',0,'shuffleSlider','Shuffle photo order in slider','2020-03-29 12:15:40'),(2156,'module_tariffPlans',0,'For user type','User type','2020-05-04 03:35:34'),(2157,'module_configuration',0,'module_notifier_adminApartmentNeedModerate','Send an email to the administrator when the listing changes?','2020-05-28 17:55:54'),(2158,'module_themes',0,'Widget \"Best listings\"','Widget \"Best listings\"','2020-05-30 08:38:01'),(2159,'module_apartments',0,'Limit object','Number of Ads','2020-05-30 08:36:48'),(2160,'module_themes',0,'Widgets','Widgets','2020-05-30 08:35:36'),(2161,'module_configuration',0,'module_notifier_adminNewApartment','Should the system send a letter to the administrator when new user has been added a listing?','2020-06-09 09:14:40'),(2162,'module_configuration',0,'module_notifier_adminApartmentNeedModerate','Send a message to the administrator about the need to moderate the ad (if the option \'Moderate ads from users\' is enabled)?','2020-06-09 12:41:38'),(2163,'module_messages',0,'Read by user','Read','2020-06-29 14:35:23'),(2164,'module_messages',0,'Unread','Unread','2020-06-29 14:35:09'),(2165,'module_configuration',0,'convertYoutubeLink','Convert Youtube Links','2020-07-14 06:53:59'),(2166,'module_currency',0,'nbg.ge','nbg.ge','2020-07-14 06:52:13'),(2167,'module_currency',0,'API Key','API Key','2020-07-14 06:53:08'),(2168,'common',0,'Saved as draft','Saved as draft','2020-10-11 08:17:53'),(2169,'common',0,'Drafts','Drafts','2020-10-11 08:48:55'),(2170,'module_apartments',0,'Drafts','Drafts','2020-10-11 09:17:46'),(2171,'common',0,'Autosave is done','Autosave is done','2020-10-11 10:57:41'),(2172,'module_apartments',0,'Drafts are automatically deleted once a day','Drafts are automatically deleted once a day','2020-10-11 11:03:50'),(2173,'common',0,'My drafts','My drafts','2020-10-11 11:30:07'),(2174,'module_apartments',0,'Manage drafts','Manage drafts','2020-10-11 11:30:07'),(2175,'common',0,'Manage SEO search','Setting SEO for search','2020-10-28 18:09:56'),(2176,'module_seo',0,'By URL','By URL','2020-10-28 18:10:14'),(2177,'module_seo',0,'By search','By search','2020-10-28 18:10:53'),(2178,'module_seo',0,'meta Title','meta Title','2020-10-28 18:11:09'),(2179,'module_seo',0,'meta Description','meta Description','2020-10-28 18:12:27'),(2180,'module_seo',0,'meta Keywords','meta Keywords','2020-10-28 18:12:41'),(2181,'module_seo',0,'meta robots noindex','meta robots noindex','2020-10-28 18:12:54'),(2182,'module_seo',0,'H1','H1','2020-10-28 18:13:05'),(2183,'common',0,'Yandex feed setting','Yandex XML setting','2020-10-28 18:16:01'),(2184,'common',0,'Geographical coverage','Location','2020-10-28 18:17:22'),(2185,'module_yandexRealty',0,'Yandex feed add','Add Yandex XML','2020-10-28 18:18:54'),(2186,'module_seo',0,'Type','Type','2020-10-28 18:20:37'),(2187,'module_seo',0,'Search / Url','Search / Url','2020-10-28 18:21:24'),(2188,'module_seo',0,'Text','Text','2020-10-28 18:21:43'),(2189,'module_seo',0,'URL required','URL required','2020-10-28 18:22:42'),(2190,'common',0,'Sitemap setup','Sitemap setup','2020-12-28 13:12:06'),(2191,'module_sitemap',0,'Specify the url you want to hide.','Specify the url you want to hide.','2020-12-28 13:12:06'),(2192,'module_badwords',0,'Add word to the blacklist','Add word to the blacklist','2020-12-28 13:12:06'),(2193,'module_badwords',0,'Manage blacklist','Manage blacklist','2020-12-28 13:12:06'),(2194,'EditableSaver.editable',0,'Empty','Empty','2020-12-28 13:12:06'),(2195,'common',0,'Badwords','Badwords','2020-12-28 13:12:06'),(2196,'module_badwords',0,'Delete a word','Delete a word','2020-12-28 13:12:06'),(2197,'module_badwords',0,'Edit a word','Edit a word','2020-12-28 13:12:06'),(2198,'common',0,'A code has been sent to your E-mail. Please enter it in the field below. The code is valid for {n} minutes.','A code has been sent to your E-mail. Please enter it in the field below. The code is valid for {n} minutes.','2020-12-28 13:12:06'),(2199,'common',0,'Code','Code','2020-12-28 13:12:06'),(2200,'common',0,'The confirmation code was not sent to Email. Please try again later.','The confirmation code was not sent to Email. Please try again later.','2020-12-28 13:12:06'),(2201,'common',0,'The code has expired. Enter your username and password again on the authorization page.','The code has expired. Enter your username and password again on the authorization page.','2020-12-28 13:12:06'),(2202,'common',0,'Incorrect code','Incorrect code','2020-12-28 13:12:06'),(2203,'module_configuration',0,'useLoginAdminSendEmailCode','Send confirmation code to e-mail for authorization in the admin panel','2021-01-09 15:25:06'),(2204,'module_configuration',0,'useSeoSearchConfigByLink','Enable  section \"Setting SEO for search\" by url','2021-01-12 07:45:55'),(2205,'module_configuration',0,'useSeoSearchConfigBySearch','Enable section \"Setting SEO for search\" by search','2021-01-12 07:45:05'),(2206,'module_seo',0,'Example','Example','2021-01-12 09:02:34'),(2207,'module_seo',0,'URL should start with \"search\", example - search?apType=1&objType=1','URL should start with \"search\", example - search?apType=1&objType=1','2021-01-12 08:58:31'),(2208,'module_seo',0,'Matching has already been added for this search','Matching has already been added for this search','2021-01-12 09:00:03'),(2209,'common',0,'{label} contains forbidden words: {badwords}. You need to remove them.','{label} contains forbidden words: {badwords}. You need to remove them.','2021-01-12 09:02:34'),(2210,'common',0,'{label} for {lang} contains forbidden words: {badwords}. You need to remove them.','{label} for {lang} contains forbidden words: {badwords}. You need to remove them.','2021-01-12 09:02:34'),(2211,'module_configuration',0,'autoSaveEnableAdmin','Auto save ads to admin. panels','2021-04-29 17:43:46'),(2212,'module_configuration',0,'autoSaveEnableUser','Auto save ads for user','2021-04-29 17:44:18'),(2213,'module_configuration',0,'autoSaveInterval','Ad auto-save interval in seconds','2021-04-29 17:46:34'),(2214,'common',0,'Request a call back','Request a call back','2021-09-12 12:40:19'),(2215,'common',0,'Fill out the form below and our specialists will contact you','Fill out the form below and our specialists will contact you','2021-09-12 12:43:05'),(2220,'common',0,'Thanks! Our staff will call you back as soon as possible','Thanks! Our staff will call you back as soon as possible','2021-09-12 12:42:51'),(2221,'module_socialposting',0,'telegram','Telegram','2022-09-28 05:17:58'),(2222,'module_socialposting',0,'useTelegram','Use Telegram autoposting','2022-09-28 05:22:34'),(2223,'module_socialposting',0,'telegramBotToken','Bot token','2022-09-28 05:23:10'),(2224,'module_socialposting',0,'telegramChatId','Chat ID','2022-09-28 05:23:27'),(2225,'common',0,'Select district','Select a district','2023-09-20 06:50:42'),(2226,'common',0,'Districts','Districts','2023-09-20 06:49:35'),(2227,'module_location',0,'Add district','Add a district','2023-09-20 06:50:13'),(2228,'module_location',0,'Manage districts','District management','2023-09-20 06:51:38'),(2230,'module_location',0,'Add multiple districts','Add multiple districts','2023-09-20 06:53:05'),(2231,'common',0,'Remove marker','Remove marker','2023-09-20 07:28:50'),(2232,'common',0,'District','District','2023-09-20 06:53:29'),(2233,'common',0,'Clear','Clear','2023-09-20 07:29:06'),(2234,'module_formeditor',0,'Country default','Default country','2023-09-20 06:54:11'),(2235,'module_formeditor',0,'Region default','Default region','2023-09-20 06:54:41'),(2236,'module_formeditor',0,'City default','Default city','2023-09-20 06:55:12'),(2237,'module_formeditor',0,'District default','Default district','2023-09-20 06:55:40'),(2238,'module_formeditor',0,'Show Country','Show country','2023-09-20 06:57:22'),(2239,'module_formeditor',0,'Show Region','Show region','2023-09-20 06:57:32'),(2240,'module_formeditor',0,'Show City','Show city','2023-09-20 06:57:54'),(2241,'module_formeditor',0,'Show District','Show district','2023-09-20 06:58:21'),(2242,'common',0,'Required parameter','Required parameter','2023-09-20 06:59:00'),(2243,'module_configuration',0,'uLoginEnable','Authorization via uLogin.ru','2023-11-22 13:48:03');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}users`
--

DROP TABLE IF EXISTS `{dbPrefix}users`;
CREATE TABLE `{dbPrefix}users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `role` enum('admin','moderator','registered') NOT NULL DEFAULT 'registered',
  `type` int(11) unsigned NOT NULL DEFAULT 0,
  `username` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(50) NOT NULL DEFAULT '',
  `temprecoverpassword` varchar(50) NOT NULL DEFAULT '',
  `salt` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `ava` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `agency_name` varchar(100) NOT NULL DEFAULT '',
  `agent_status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `additional_info_en` text DEFAULT NULL,
  `activatekey` varchar(50) NOT NULL DEFAULT '',
  `recoverPasswordKey` varchar(50) NOT NULL DEFAULT '',
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `is_use_api` tinyint(1) NOT NULL DEFAULT 0,
  `api_token` varchar(50) NOT NULL DEFAULT '',
  `login_code` varchar(40) DEFAULT NULL,
  `login_code_expired` timestamp NULL DEFAULT NULL,
  `balance` int(11) unsigned NOT NULL DEFAULT 0,
  `agency_user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `last_login_date` timestamp NULL DEFAULT NULL,
  `last_ip_addr` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}users`
--

LOCK TABLES `{dbPrefix}users` WRITE;
INSERT INTO `{dbPrefix}users` VALUES (1,'admin',1,'{adminName}','{adminPass}','','{adminSalt}','{adminEmail}','1565108046_1.jpg','+7 000 111 1111','',0,'','','',1,1,'{adminRestAPIToken}',NULL,NULL,0,0,'2013-11-15 23:12:12','2020-03-16 12:32:52','2020-03-16 12:32:52','127.0.0.1'),(2,'registered',1,'demo','b7300769e471d88d5d0c8fa7e77f8c3e','','4ed36e64356867.12929158','demore@monoray.net','1565108065_2.jpg','+7 000 111 2222','',0,'Low priced property without any intermediaries!','','',1,0,'',NULL,NULL,2493,0,'2013-11-15 23:12:12','2020-03-16 08:52:23','2016-05-07 19:46:47','');
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}users_sessions`
--

DROP TABLE IF EXISTS `{dbPrefix}users_sessions`;
CREATE TABLE `{dbPrefix}users_sessions` (
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `id` char(32) NOT NULL DEFAULT '',
  `expire` int(11) NOT NULL DEFAULT 0,
  `data` longblob DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx-session_expire` (`expire`),
  KEY `idx-session-user_id` (`user_id`),
  KEY `idx-session-id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}users_sessions`
--

LOCK TABLES `{dbPrefix}users_sessions` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}users_social`
--

DROP TABLE IF EXISTS `{dbPrefix}users_social`;
CREATE TABLE `{dbPrefix}users_social` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `uid` varchar(255) NOT NULL DEFAULT '',
  `service` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}users_social`
--

LOCK TABLES `{dbPrefix}users_social` WRITE;
UNLOCK TABLES;

--
-- Table structure for table `{dbPrefix}yandex_list`
--

DROP TABLE IF EXISTS `{dbPrefix}yandex_list`;
CREATE TABLE `{dbPrefix}yandex_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `itemsSelected` longtext NOT NULL DEFAULT '',
  `count_ap` int(11) NOT NULL DEFAULT 0,
  `json_data` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `{dbPrefix}yandex_list`
--

LOCK TABLES `{dbPrefix}yandex_list` WRITE;
UNLOCK TABLES;


-- Dump completed on 2025-03-15 13:25:23
