{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{if $roomsDetails}
    <table class="bordered-table" width="100%" cellpadding="4" cellspacing="0">
		<thead>
            <tr>
				<th colspan="5" class="header">{l s='Room Bookings Detail' pdf='true'}</th>
			</tr>
			<tr>
				<th class="product header">{l s='Room Type / Reference' pdf='true'}</th>
                <th class="product header">{l s='Hotel' pdf='true'}</th>
				<th class="product header">{l s='Duration' pdf='true'}</th>
				<th class="product header">{l s='Num rooms' pdf='true'}</th>
				<th class="product header-right">{l s='Total Price' pdf='true'}<br />{if $tax_excluded_display}{l s='(Tax Excl.)' pdf='true'}{else}{l s='(Tax Incl.)' pdf='true'}{/if}</th>
			</tr>
		</thead>
		<tbody>
			{if !isset($roomsDetails) || count($roomsDetails) == 0}
				<tr class="product" colspan="4">
					<td class="product center">
						{l s='No details' pdf='true'}
					</td>
				</tr>
			{else}
				{foreach $roomsDetails as $order_detail}
					{cycle values=["color_line_even", "color_line_odd"] assign=bgcolor_class}
					<tr class="product {$bgcolor_class}">
						<td class="product left">
							{$order_detail.product_name}
						</td>
                        <td class="product center">
                            {$order_detail.hotel_name}
                        </td>
						<td class="product center">
							{$order_detail.date_from|date_format:"%d-%m-%Y"} {l s='To' pdf='true'} {$order_detail.date_to|date_format:"%d-%m-%Y"}
						</td>
						<td class="product center">
							{$order_detail.num_rooms}
						</td>
						{* <td class="product right">
							{if $tax_excluded_display}
								- {displayPrice currency=$order->id_currency price=$order_detail.unit_price_tax_excl}
							{else}
								- {displayPrice currency=$order->id_currency price=$order_detail.unit_price_tax_incl}
							{/if}
						</td> *}
						<td class="product right">
							{if $tax_excluded_display}
								- {displayPrice currency=$order->id_currency price=$order_detail.total_price_tax_excl}
							{else}
								- {displayPrice currency=$order->id_currency price=$order_detail.total_price_tax_incl}
							{/if}
						</td>
					</tr>

					{foreach $order_detail.customizedDatas as $customizationPerAddress}
						{foreach $customizationPerAddress as $customizationId => $customization}
							<tr class="customization_data {$bgcolor_class}">
								<td>
									<table style="width: 100%;"><tr><td>
										{foreach $customization.datas as $customization_types}
											{if isset($customization.datas[Product::CUSTOMIZE_TEXTFIELD]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
												{foreach $customization.datas[Product::CUSTOMIZE_TEXTFIELD] as $customization_infos}
													{$customization_infos.name}: {$customization_infos.value}
													{if !$smarty.foreach.custo_foreach.last}<br />{/if}
												{/foreach}
											{/if}

											{if isset($customization.datas[Product::CUSTOMIZE_FILE]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
												{count($customization.datas[Product::CUSTOMIZE_FILE])} {l s='image(s)' pdf='true'}
											{/if}

										{/foreach}
									</td></tr></table>
								</td>

								<td class="center">({$customization.quantity})</td>
								<td class="product"></td>
								<td class="product"></td>
							</tr>
						{/foreach}
					{/foreach}
				{/foreach}
			{/if}

			{assign var=total_cart_rule value=0}
			{if is_array($cart_rules) && count($cart_rules)}
				{foreach $cart_rules as $cart_rule}
					<tr class="discount">
						<td class="white left" colspan="3">{$cart_rule.name}</td>
						<td class="white right">
							{if $tax_excluded_display}
								{$total_cart_rule = $total_cart_rule + $cart_rule.value_tax_excl}
								+ {$cart_rule.value_tax_excl}
							{else}
								{$total_cart_rule = $total_cart_rule + $cart_rule.value}
								+ {$cart_rule.value}
							{/if}
						</td>
					</tr>
				{/foreach}
			{/if}

		</tbody>
    </table>
{/if}

{if $productsDetails}
<br><br>
    <table class="bordered-table" width="100%" cellpadding="4" cellspacing="0">
        <thead>
            <tr>
				<th colspan="3" class="header">{l s='Service Products Detail' pdf='true'}</th>
			</tr>
            <tr>
                <th class="product header">{l s='Name / Reference' pdf='true'}</th>
                <th class="product header">{l s='Quantity' pdf='true'}</th>
                <th class="product header-right">{l s='Total Price' pdf='true'}<br />{if $tax_excluded_display}{l s='(Tax Excl.)' pdf='true'}{else}{l s='(Tax Incl.)' pdf='true'}{/if}</th>
            </tr>
        </thead>
        <tbody>
            {if !isset($productsDetails) || count($productsDetails) == 0}
                <tr class="product" colspan="3">
                    <td class="product center">
                        {l s='No details' pdf='true'}
                    </td>
                </tr>
            {else}
                {foreach $productsDetails as $order_detail}
                    {cycle values=["color_line_even", "color_line_odd"] assign=bgcolor_class}
                    <tr class="product {$bgcolor_class}">
                        <td class="product center">
                            {$order_detail.product_name}
                        </td>
                        <td class="product center">
                            {$order_detail.product_quantity}
                        </td>
                        <td class="product right">
                            {if $tax_excluded_display}
                                - {displayPrice currency=$order->id_currency price=$order_detail.total_price_tax_excl}
                            {else}
                                - {displayPrice currency=$order->id_currency price=$order_detail.total_price_tax_incl}
                            {/if}
                        </td>
                    </tr>

                    {foreach $order_detail.customizedDatas as $customizationPerAddress}
                        {foreach $customizationPerAddress as $customizationId => $customization}
                            <tr class="customization_data {$bgcolor_class}">
                                <td>
                                    <table style="width: 100%;"><tr><td>
                                        {foreach $customization.datas as $customization_types}
                                            {if isset($customization.datas[Product::CUSTOMIZE_TEXTFIELD]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
                                                {foreach $customization.datas[Product::CUSTOMIZE_TEXTFIELD] as $customization_infos}
                                                    {$customization_infos.name}: {$customization_infos.value}
                                                    {if !$smarty.foreach.custo_foreach.last}<br />{/if}
                                                {/foreach}
                                            {/if}

                                            {if isset($customization.datas[Product::CUSTOMIZE_FILE]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
                                                {count($customization.datas[Product::CUSTOMIZE_FILE])} {l s='image(s)' pdf='true'}
                                            {/if}

                                        {/foreach}
                                    </td></tr></table>
                                </td>

                                <td class="center">({$customization.quantity})</td>
                                <td class="product"></td>
                                <td class="product"></td>
                            </tr>
                        {/foreach}
                    {/foreach}
                {/foreach}
            {/if}

            {assign var=total_cart_rule value=0}
            {if is_array($cart_rules) && count($cart_rules)}
                {foreach $cart_rules as $cart_rule}
                    <tr class="discount">
                        <td class="white left" colspan="3">{$cart_rule.name}</td>
                        <td class="white right">
                            {if $tax_excluded_display}
                                {$total_cart_rule = $total_cart_rule + $cart_rule.value_tax_excl}
                                + {$cart_rule.value_tax_excl}
                            {else}
                                {$total_cart_rule = $total_cart_rule + $cart_rule.value}
                                + {$cart_rule.value}
                            {/if}
                        </td>
                    </tr>
                {/foreach}
            {/if}

        </tbody>
    </table>
{/if}
