
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `projeqtor1232`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]acceptance`
--

CREATE TABLE `[[dbprefix]]acceptance` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `externalReference` varchar(100) DEFAULT NULL,
  `idAcceptanceType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `result` mediumtext,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `acceptanceDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDateTime` datetime DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDateTime` datetime DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDateTime` datetime DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `idProject` int(10) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `acceptanceAcceptanceTypeIdx` (`idAcceptanceType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]accessprofile`
--

CREATE TABLE `[[dbprefix]]accessprofile` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idAccessScopeRead` int(12) DEFAULT NULL COMMENT '12',
  `idAccessScopeCreate` int(12) DEFAULT NULL COMMENT '12',
  `idAccessScopeUpdate` int(12) DEFAULT NULL COMMENT '12',
  `idAccessScopeDelete` int(12) DEFAULT NULL COMMENT '12',
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isNonProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isExtended` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1000006 ;

--
-- Dumping data for table `[[dbprefix]]accessprofile`
--

INSERT INTO `[[dbprefix]]accessprofile` VALUES
(1, 'accessProfileRestrictedReader', 'Read only his projects', 3, 1, 1, 1, 100, 0, 0, 0),
(2, 'accessProfileGlobalReader', 'Read all projects', 4, 1, 1, 1, 150, 0, 0, 0),
(3, 'accessProfileRestrictedUpdater', 'Read and Update only his projects', 3, 1, 3, 1, 200, 0, 0, 0),
(4, 'accessProfileGlobalUpdater', 'Read and Update all projects', 4, 1, 4, 1, 250, 0, 0, 0),
(5, 'accessProfileRestrictedCreator', 'Read only his projects\nCan create\nUpdate and delete his own elements', 3, 3, 2, 2, 300, 0, 0, 0),
(6, 'accessProfileGlobalCreator', 'Read all projects\nCan create\nUpdate and delete his own elements', 4, 4, 2, 2, 350, 0, 0, 0),
(7, 'accessProfileRestrictedManager', 'Read only his projects\nCan create\nUpdate and delete his projects', 3, 3, 3, 3, 400, 0, 0, 0),
(8, 'accessProfileGlobalManager', 'Read all projects\nCan create\nUpdate and delete his projects', 4, 4, 4, 4, 450, 0, 0, 0),
(9, 'accessProfileNoAccess', 'no access allowed', 1, 1, 1, 1, 999, 0, 0, 0),
(10, 'accessReadOwnOnly', NULL, 2, 1, 1, 1, 900, 0, 0, 0),
(1000001, 'accessProfileRestrictedManager', 'Create all, update all, delete all', 4, 4, 4, 4, 200, 0, 1, 0),
(1000002, 'accessProfileRestrictedReader', 'Create none, update none, delete none', 4, 1, 1, 1, 100, 0, 1, 0),
(1000003, 'accessProfileRestrictedUpdater', 'Create none, update all, delete none', 4, 1, 4, 1, 300, 0, 1, 0),
(1000004, 'accessProfileResponsible', 'Create none, update responsible, delete none', 4, 1, 5, 1, 400, 0, 1, 1),
(1000005, 'accessProfileRestrictedCreator', 'Create all, update own, delete own', 4, 4, 2, 2, 500, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]accessright`
--

CREATE TABLE `[[dbprefix]]accessright` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAccessProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `accessrightProfile` (`idProfile`),
  KEY `accessrightMenu` (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1380 ;

--
-- Dumping data for table `[[dbprefix]]accessright`
--

INSERT INTO `[[dbprefix]]accessright` VALUES
(1, 1, 3, 8),
(2, 2, 3, 2),
(3, 3, 3, 7),
(4, 4, 3, 1),
(5, 6, 3, 1),
(6, 7, 3, 1),
(7, 5, 3, 1),
(8, 1, 4, 8),
(9, 2, 4, 4),
(10, 3, 4, 7),
(11, 4, 4, 3),
(12, 6, 4, 3),
(13, 7, 4, 1),
(14, 5, 4, 1),
(15, 1, 5, 8),
(16, 2, 5, 2),
(17, 3, 5, 7),
(18, 4, 5, 1),
(19, 6, 5, 1),
(20, 7, 5, 1),
(21, 5, 5, 1),
(22, 1, 50, 8),
(23, 2, 50, 2),
(24, 3, 50, 7),
(25, 4, 50, 1),
(26, 6, 50, 9),
(27, 7, 50, 9),
(28, 5, 50, 9),
(29, 1, 22, 8),
(30, 2, 22, 2),
(31, 3, 22, 7),
(32, 4, 22, 7),
(33, 6, 22, 7),
(34, 7, 22, 5),
(35, 5, 22, 1),
(36, 1, 51, 1000001),
(37, 2, 51, 1000002),
(38, 3, 51, 1000001),
(39, 4, 51, 1000002),
(40, 6, 51, 1000002),
(41, 7, 51, 1000002),
(42, 5, 51, 1000002),
(43, 1, 25, 8),
(44, 2, 25, 2),
(45, 3, 25, 7),
(46, 4, 25, 3),
(47, 6, 25, 1),
(48, 7, 25, 1),
(49, 5, 25, 1),
(50, 1, 26, 8),
(51, 2, 26, 2),
(52, 3, 26, 7),
(53, 4, 26, 3),
(54, 6, 26, 1),
(55, 7, 26, 1),
(56, 5, 26, 1),
(57, 1, 16, 8),
(58, 2, 16, 2),
(59, 3, 16, 7),
(60, 4, 16, 9),
(61, 6, 16, 9),
(62, 7, 16, 9),
(63, 5, 16, 9),
(64, 1, 62, 8),
(65, 2, 62, 2),
(66, 3, 62, 7),
(67, 4, 62, 1),
(68, 6, 62, 1),
(69, 7, 62, 1),
(70, 5, 62, 1),
(71, 1, 63, 8),
(72, 2, 63, 2),
(73, 3, 63, 7),
(74, 4, 63, 1),
(75, 6, 63, 1),
(76, 7, 63, 1),
(77, 5, 63, 1),
(78, 1, 64, 8),
(79, 2, 64, 2),
(80, 3, 64, 7),
(81, 4, 64, 1),
(82, 6, 64, 1),
(83, 7, 64, 1),
(84, 5, 64, 1),
(85, 1, 69, 2),
(86, 2, 69, 9),
(87, 3, 69, 1),
(88, 4, 69, 1),
(89, 6, 69, 9),
(90, 7, 69, 9),
(91, 5, 69, 9),
(92, 1, 75, 8),
(93, 2, 75, 2),
(94, 3, 75, 7),
(95, 4, 75, 5),
(96, 6, 75, 9),
(97, 7, 75, 9),
(98, 5, 75, 9),
(99, 1, 76, 8),
(100, 2, 76, 2),
(101, 3, 76, 7),
(102, 4, 76, 9),
(103, 6, 76, 9),
(104, 7, 76, 9),
(105, 5, 76, 9),
(106, 1, 77, 8),
(107, 2, 77, 2),
(108, 3, 77, 7),
(109, 4, 77, 9),
(110, 6, 77, 9),
(111, 7, 77, 9),
(112, 5, 77, 9),
(113, 1, 78, 8),
(114, 2, 78, 2),
(115, 3, 78, 7),
(116, 4, 78, 9),
(117, 6, 78, 9),
(118, 7, 78, 9),
(119, 5, 78, 9),
(120, 1, 89, 1000001),
(121, 2, 89, 1000002),
(122, 3, 89, 1000002),
(123, 1, 90, 1000001),
(124, 2, 90, 1000002),
(125, 3, 90, 1000002),
(126, 1, 91, 2),
(127, 2, 91, 1),
(128, 3, 91, 1),
(129, 4, 91, 10),
(130, 6, 91, 10),
(131, 7, 91, 10),
(132, 5, 91, 10),
(133, 1, 94, 8),
(134, 2, 94, 2),
(135, 3, 94, 7),
(136, 1, 95, 1000001),
(137, 1, 96, 8),
(138, 2, 96, 2),
(139, 3, 96, 7),
(140, 1, 97, 8),
(141, 2, 97, 2),
(142, 3, 97, 7),
(143, 1, 98, 8),
(144, 1, 99, 8),
(145, 1, 100, 1000001),
(146, 1, 102, 8),
(147, 2, 102, 2),
(148, 3, 102, 7),
(149, 4, 102, 7),
(150, 6, 102, 1),
(151, 7, 102, 1),
(152, 5, 102, 9),
(153, 1, 111, 8),
(154, 2, 111, 2),
(155, 3, 111, 7),
(156, 4, 111, 7),
(157, 6, 111, 1),
(158, 7, 111, 1),
(159, 5, 111, 9),
(160, 1, 112, 8),
(161, 2, 112, 2),
(162, 3, 112, 7),
(163, 4, 112, 7),
(164, 6, 112, 1),
(165, 7, 112, 1),
(166, 5, 112, 9),
(167, 1, 113, 8),
(168, 2, 113, 2),
(169, 3, 113, 7),
(170, 4, 113, 7),
(171, 6, 113, 1),
(172, 7, 113, 1),
(173, 5, 113, 9),
(174, 1, 118, 8),
(175, 2, 118, 2),
(176, 3, 118, 7),
(177, 4, 118, 7),
(178, 6, 118, 7),
(179, 7, 118, 5),
(180, 5, 118, 1),
(181, 1, 119, 8),
(182, 2, 119, 2),
(183, 3, 119, 7),
(184, 4, 119, 1),
(185, 6, 119, 1),
(186, 7, 119, 1),
(187, 5, 119, 1),
(188, 1, 124, 8),
(189, 2, 124, 2),
(190, 3, 124, 7),
(191, 4, 124, 1),
(192, 6, 124, 1),
(193, 7, 124, 1),
(194, 5, 124, 1),
(195, 1, 125, 8),
(196, 2, 125, 2),
(197, 3, 125, 7),
(198, 1, 126, 1000001),
(199, 1, 131, 8),
(200, 2, 131, 2),
(201, 3, 131, 7),
(202, 1, 132, 1000001),
(203, 1, 153, 8),
(204, 2, 153, 2),
(205, 3, 153, 7),
(206, 1, 154, 8),
(207, 2, 154, 2),
(208, 3, 154, 7),
(209, 1, 158, 1000001),
(210, 2, 158, 1000002),
(212, 3, 158, 1000002),
(213, 4, 158, 1000002),
(214, 5, 158, 1000002),
(215, 6, 158, 1000002),
(216, 7, 158, 1000002),
(218, 1, 167, 8),
(219, 2, 167, 2),
(220, 3, 167, 7),
(221, 4, 167, 9),
(222, 6, 167, 9),
(223, 7, 167, 9),
(224, 5, 167, 9),
(225, 1, 168, 8),
(226, 2, 168, 2),
(227, 3, 168, 7),
(228, 4, 168, 9),
(229, 6, 168, 9),
(230, 7, 168, 9),
(231, 5, 168, 9),
(232, 1, 176, 8),
(233, 2, 176, 2),
(234, 3, 176, 7),
(235, 1, 180, 8),
(236, 2, 180, 2),
(237, 3, 180, 7),
(238, 1, 181, 8),
(239, 2, 181, 2),
(240, 3, 181, 7),
(241, 1, 182, 8),
(242, 2, 182, 2),
(243, 3, 182, 7),
(244, 1, 185, 1000001),
(245, 2, 185, 1000003),
(246, 3, 185, 1000003),
(247, 4, 185, 1000003),
(248, 5, 185, 1000003),
(249, 6, 185, 1000003),
(250, 7, 185, 1000003),
(251, 1, 186, 1000001),
(252, 2, 186, 1000002),
(253, 3, 186, 1000002),
(254, 4, 186, 1000002),
(255, 5, 186, 1000002),
(256, 6, 186, 1000002),
(257, 7, 186, 1000002),
(258, 1, 188, 1000001),
(259, 3, 188, 1000001),
(260, 1, 190, 1000001),
(261, 1, 191, 8),
(262, 2, 191, 2),
(263, 3, 191, 7),
(264, 1, 193, 1000001),
(265, 1, 194, 8),
(266, 2, 194, 2),
(267, 3, 194, 7),
(268, 1, 195, 8),
(269, 2, 195, 2),
(270, 3, 195, 7),
(271, 1, 201, 8),
(272, 2, 201, 2),
(273, 3, 201, 7),
(274, 1, 202, 1000001),
(275, 1, 192, 8),
(276, 2, 192, 2),
(277, 3, 192, 7),
(278, 4, 192, 7),
(279, 1, 196, 8),
(280, 2, 196, 2),
(281, 3, 196, 7),
(282, 4, 196, 7),
(283, 1, 203, 8),
(284, 1, 204, 8),
(285, 2, 204, 2),
(286, 1, 223, 1000001),
(289, 1, 224, 8),
(290, 1, 225, 8),
(291, 2, 225, 2),
(292, 3, 225, 7),
(293, 1, 226, 1000001),
(294, 1, 227, 8),
(295, 2, 227, 2),
(296, 3, 227, 7),
(297, 1, 228, 8),
(298, 2, 228, 2),
(299, 1, 229, 1000001),
(300, 1, 232, 8),
(301, 2, 232, 2),
(302, 1, 233, 8),
(303, 2, 233, 2),
(304, 1, 234, 8),
(305, 2, 234, 2),
(306, 1, 235, 8),
(307, 2, 235, 2),
(308, 1, 236, 1000001),
(309, 1, 244, 8),
(310, 2, 244, 2),
(311, 3, 244, 7),
(312, 1, 245, 8),
(313, 2, 245, 2),
(314, 3, 245, 7),
(315, 1, 246, 8),
(316, 2, 246, 2),
(317, 3, 246, 7),
(318, 1, 247, 8),
(319, 2, 247, 2),
(320, 3, 247, 7),
(321, 1, 237, 1000001),
(322, 1, 238, 1000001),
(323, 1, 239, 1000001),
(324, 1, 240, 1000001),
(325, 1, 241, 1000001),
(326, 1, 243, 1000001),
(327, 2, 237, 1000002),
(328, 2, 238, 1000002),
(329, 2, 239, 1000002),
(330, 2, 240, 1000002),
(331, 2, 241, 1000002),
(332, 2, 243, 1000002),
(333, 3, 237, 1000001),
(334, 1, 250, 8),
(346, 1, 255, 8),
(347, 2, 255, 2),
(348, 3, 255, 7),
(352, 1, 259, 8),
(353, 2, 259, 2),
(354, 3, 259, 7),
(355, 1, 260, 4),
(356, 2, 260, 3),
(357, 3, 260, 3),
(358, 4, 260, 3),
(359, 5, 260, 3),
(360, 6, 260, 3),
(361, 7, 260, 3),
(362, 1, 268, 1000001),
(363, 1, 269, 1000001),
(364, 1, 262, 1000001),
(365, 1, 263, 1000001),
(366, 1, 264, 1000001),
(367, 2, 262, 1000002),
(368, 2, 263, 1000002),
(369, 2, 264, 1000002),
(370, 3, 262, 1000001),
(371, 3, 263, 1000001),
(372, 4, 262, 1000001),
(373, 4, 263, 1000001),
(374, 1, 265, 1000001),
(375, 4, 259, 9),
(376, 5, 259, 9),
(377, 6, 259, 9),
(378, 7, 259, 9),
(379, 1, 270, 8),
(380, 2, 270, 8),
(381, 3, 270, 7),
(382, 1, 271, 8),
(383, 2, 271, 8),
(384, 3, 271, 7),
(385, 1, 272, 1000001),
(386, 2, 272, 1000001),
(387, 3, 272, 1000001),
(388, 1, 273, 1000001),
(389, 2, 273, 1000001),
(390, 3, 273, 1000001),
(391, 1, 274, 8),
(392, 2, 274, 8),
(393, 3, 274, 7),
(394, 1, 15, 1000001),
(395, 1, 17, 1000001),
(396, 1, 34, 1000001),
(397, 1, 38, 1000001),
(398, 1, 39, 1000001),
(399, 1, 40, 1000001),
(400, 1, 41, 1000001),
(401, 1, 42, 1000001),
(402, 1, 44, 1000001),
(403, 1, 45, 1000001),
(404, 1, 46, 1000001),
(405, 1, 52, 1000001),
(406, 1, 53, 1000001),
(407, 1, 55, 1000001),
(408, 1, 56, 1000001),
(409, 1, 57, 1000001),
(410, 1, 59, 1000001),
(411, 1, 60, 1000001),
(412, 1, 65, 1000001),
(413, 1, 66, 1000001),
(414, 1, 67, 1000001),
(415, 1, 68, 1000001),
(416, 1, 72, 1000001),
(417, 1, 73, 1000001),
(418, 1, 80, 1000001),
(419, 1, 81, 1000001),
(420, 1, 82, 1000001),
(421, 1, 83, 1000001),
(422, 1, 84, 1000001),
(423, 1, 85, 1000001),
(424, 1, 86, 1000001),
(425, 1, 87, 1000001),
(426, 1, 93, 1000001),
(427, 1, 101, 1000001),
(428, 1, 103, 1000001),
(429, 1, 105, 1000001),
(430, 1, 107, 1000001),
(431, 1, 108, 1000001),
(432, 1, 109, 1000001),
(433, 1, 114, 1000001),
(434, 1, 115, 1000001),
(435, 1, 116, 1000001),
(436, 1, 117, 1000001),
(437, 1, 120, 1000001),
(438, 1, 121, 1000001),
(439, 1, 127, 1000001),
(440, 1, 128, 1000001),
(441, 1, 129, 1000001),
(442, 1, 130, 1000001),
(443, 1, 134, 1000001),
(444, 1, 137, 1000001),
(445, 1, 138, 1000001),
(446, 1, 139, 1000001),
(447, 1, 140, 1000001),
(448, 1, 141, 1000001),
(449, 1, 142, 1000001),
(450, 1, 144, 1000001),
(451, 1, 145, 1000001),
(452, 1, 147, 1000001),
(453, 1, 148, 1000001),
(454, 1, 149, 1000001),
(455, 1, 155, 1000001),
(456, 1, 156, 1000001),
(457, 1, 159, 1000001),
(458, 1, 160, 1000001),
(459, 1, 161, 1000001),
(460, 1, 162, 1000001),
(461, 1, 163, 1000001),
(462, 1, 164, 1000001),
(463, 1, 165, 1000001),
(464, 1, 166, 1000001),
(465, 1, 169, 1000001),
(466, 1, 170, 1000001),
(467, 1, 171, 1000001),
(468, 1, 172, 1000001),
(469, 1, 174, 1000001),
(470, 1, 175, 1000001),
(471, 1, 178, 1000001),
(472, 1, 183, 1000001),
(473, 1, 184, 1000001),
(474, 1, 197, 1000001),
(475, 1, 198, 1000001),
(476, 1, 199, 1000001),
(477, 1, 200, 1000001),
(478, 1, 231, 1000001),
(479, 1, 248, 1000001),
(480, 1, 249, 1000001),
(481, 1, 251, 1000001),
(482, 1, 266, 1000001),
(483, 1, 267, 1000001),
(521, 2, 15, 1000002),
(522, 2, 17, 1000002),
(523, 2, 34, 1000002),
(524, 2, 38, 1000002),
(525, 2, 39, 1000002),
(526, 2, 40, 1000002),
(527, 2, 41, 1000002),
(528, 2, 42, 1000002),
(529, 2, 44, 1000002),
(530, 2, 45, 1000002),
(531, 2, 46, 1000002),
(532, 2, 52, 1000002),
(533, 2, 53, 1000002),
(534, 2, 55, 1000002),
(535, 2, 56, 1000002),
(536, 2, 57, 1000002),
(537, 2, 59, 1000002),
(538, 2, 60, 1000002),
(539, 2, 65, 1000002),
(540, 2, 66, 1000002),
(541, 2, 67, 1000002),
(542, 2, 68, 1000002),
(543, 2, 72, 1000002),
(544, 2, 73, 1000002),
(545, 2, 80, 1000002),
(546, 2, 81, 1000002),
(547, 2, 82, 1000002),
(548, 2, 83, 1000002),
(549, 2, 84, 1000002),
(550, 2, 85, 1000002),
(551, 2, 86, 1000002),
(552, 2, 87, 1000002),
(553, 2, 93, 1000002),
(554, 2, 95, 1000002),
(555, 2, 100, 1000002),
(556, 2, 101, 1000002),
(557, 2, 103, 1000002),
(558, 2, 105, 1000002),
(559, 2, 107, 1000002),
(560, 2, 108, 1000002),
(561, 2, 109, 1000002),
(562, 2, 114, 1000002),
(563, 2, 115, 1000002),
(564, 2, 116, 1000002),
(565, 2, 117, 1000002),
(566, 2, 120, 1000002),
(567, 2, 121, 1000002),
(568, 2, 126, 1000002),
(569, 2, 127, 1000002),
(570, 2, 128, 1000002),
(571, 2, 129, 1000002),
(572, 2, 130, 1000002),
(573, 2, 132, 1000002),
(574, 2, 134, 1000002),
(575, 2, 137, 1000002),
(576, 2, 138, 1000002),
(577, 2, 139, 1000002),
(578, 2, 140, 1000002),
(579, 2, 141, 1000002),
(580, 2, 142, 1000002),
(581, 2, 144, 1000002),
(582, 2, 145, 1000002),
(583, 2, 147, 1000002),
(584, 2, 148, 1000002),
(585, 2, 149, 1000002),
(586, 2, 155, 1000002),
(587, 2, 156, 1000002),
(588, 2, 159, 1000002),
(589, 2, 160, 1000002),
(590, 2, 161, 1000002),
(591, 2, 162, 1000002),
(592, 2, 163, 1000002),
(593, 2, 164, 1000002),
(594, 2, 165, 1000002),
(595, 2, 166, 1000002),
(596, 2, 169, 1000002),
(597, 2, 170, 1000002),
(598, 2, 171, 1000002),
(599, 2, 172, 1000002),
(600, 2, 174, 1000002),
(601, 2, 175, 1000002),
(602, 2, 178, 1000002),
(603, 2, 183, 1000002),
(604, 2, 184, 1000002),
(605, 2, 188, 1000002),
(606, 2, 190, 1000002),
(607, 2, 193, 1000002),
(608, 2, 197, 1000002),
(609, 2, 198, 1000002),
(610, 2, 199, 1000002),
(611, 2, 200, 1000002),
(612, 2, 202, 1000002),
(613, 2, 223, 1000002),
(614, 2, 226, 1000002),
(615, 2, 229, 1000002),
(616, 2, 231, 1000002),
(617, 2, 236, 1000002),
(618, 2, 248, 1000002),
(619, 2, 249, 1000002),
(620, 2, 251, 1000002),
(621, 2, 265, 1000002),
(622, 2, 266, 1000002),
(623, 2, 267, 1000002),
(624, 2, 268, 1000002),
(625, 2, 269, 1000002),
(648, 3, 44, 1000001),
(649, 3, 57, 1000001),
(650, 3, 86, 1000001),
(651, 3, 87, 1000001),
(652, 3, 103, 1000001),
(653, 3, 141, 1000001),
(654, 3, 142, 1000001),
(655, 3, 15, 1000002),
(656, 3, 17, 1000002),
(657, 3, 34, 1000002),
(658, 3, 38, 1000002),
(659, 3, 39, 1000002),
(660, 3, 40, 1000002),
(661, 3, 41, 1000002),
(662, 3, 42, 1000002),
(663, 3, 45, 1000002),
(664, 3, 46, 1000002),
(665, 3, 52, 1000002),
(666, 3, 53, 1000002),
(667, 3, 55, 1000002),
(668, 3, 56, 1000002),
(669, 3, 59, 1000002),
(670, 3, 60, 1000002),
(671, 3, 65, 1000002),
(672, 3, 66, 1000002),
(673, 3, 67, 1000002),
(674, 3, 68, 1000002),
(675, 3, 72, 1000002),
(676, 3, 73, 1000002),
(677, 3, 80, 1000002),
(678, 3, 81, 1000002),
(679, 3, 82, 1000002),
(680, 3, 83, 1000002),
(681, 3, 84, 1000002),
(682, 3, 85, 1000002),
(683, 3, 93, 1000002),
(684, 3, 95, 1000002),
(685, 3, 100, 1000002),
(686, 3, 101, 1000002),
(687, 3, 105, 1000002),
(688, 3, 107, 1000002),
(689, 3, 108, 1000002),
(690, 3, 109, 1000002),
(691, 3, 114, 1000002),
(692, 3, 115, 1000002),
(693, 3, 116, 1000002),
(694, 3, 117, 1000002),
(695, 3, 120, 1000002),
(696, 3, 121, 1000002),
(697, 3, 126, 1000002),
(698, 3, 127, 1000002),
(699, 3, 128, 1000002),
(700, 3, 129, 1000002),
(701, 3, 130, 1000002),
(702, 3, 132, 1000002),
(703, 3, 134, 1000002),
(704, 3, 137, 1000002),
(705, 3, 138, 1000002),
(706, 3, 139, 1000002),
(707, 3, 140, 1000002),
(708, 3, 144, 1000002),
(709, 3, 145, 1000002),
(710, 3, 147, 1000002),
(711, 3, 148, 1000002),
(712, 3, 149, 1000002),
(713, 3, 155, 1000002),
(714, 3, 156, 1000002),
(715, 3, 159, 1000002),
(716, 3, 160, 1000002),
(717, 3, 161, 1000002),
(718, 3, 162, 1000002),
(719, 3, 163, 1000002),
(720, 3, 164, 1000002),
(721, 3, 165, 1000002),
(722, 3, 166, 1000002),
(723, 3, 169, 1000002),
(724, 3, 170, 1000002),
(725, 3, 171, 1000002),
(726, 3, 172, 1000002),
(727, 3, 174, 1000002),
(728, 3, 175, 1000002),
(729, 3, 178, 1000002),
(730, 3, 183, 1000002),
(731, 3, 184, 1000002),
(732, 3, 190, 1000002),
(733, 3, 193, 1000002),
(734, 3, 197, 1000002),
(735, 3, 198, 1000002),
(736, 3, 199, 1000002),
(737, 3, 200, 1000002),
(738, 3, 202, 1000002),
(739, 3, 223, 1000002),
(740, 3, 226, 1000002),
(741, 3, 229, 1000002),
(742, 3, 231, 1000002),
(743, 3, 236, 1000002),
(744, 3, 238, 1000002),
(745, 3, 239, 1000002),
(746, 3, 240, 1000002),
(747, 3, 241, 1000002),
(748, 3, 248, 1000002),
(749, 3, 249, 1000002),
(750, 3, 251, 1000002),
(751, 3, 264, 1000002),
(752, 3, 265, 1000002),
(753, 3, 266, 1000002),
(754, 3, 267, 1000002),
(755, 3, 268, 1000002),
(756, 3, 269, 1000002),
(782, 4, 15, 1000002),
(783, 4, 17, 1000002),
(784, 4, 34, 1000002),
(785, 4, 38, 1000002),
(786, 4, 39, 1000002),
(787, 4, 40, 1000002),
(788, 4, 41, 1000002),
(789, 4, 42, 1000002),
(790, 4, 44, 1000002),
(791, 4, 45, 1000002),
(792, 4, 46, 1000002),
(793, 4, 52, 1000002),
(794, 4, 53, 1000002),
(795, 4, 55, 1000002),
(796, 4, 56, 1000002),
(797, 4, 57, 1000002),
(798, 4, 59, 1000002),
(799, 4, 60, 1000002),
(800, 4, 65, 1000002),
(801, 4, 66, 1000002),
(802, 4, 67, 1000002),
(803, 4, 68, 1000002),
(804, 4, 72, 1000002),
(805, 4, 73, 1000002),
(806, 4, 80, 1000002),
(807, 4, 81, 1000002),
(808, 4, 82, 1000002),
(809, 4, 83, 1000002),
(810, 4, 84, 1000002),
(811, 4, 85, 1000002),
(812, 4, 86, 1000002),
(813, 4, 87, 1000002),
(814, 4, 89, 1000002),
(815, 4, 90, 1000002),
(816, 4, 93, 1000002),
(817, 4, 95, 1000002),
(818, 4, 100, 1000002),
(819, 4, 101, 1000002),
(820, 4, 103, 1000002),
(821, 4, 105, 1000002),
(822, 4, 107, 1000002),
(823, 4, 108, 1000002),
(824, 4, 109, 1000002),
(825, 4, 114, 1000002),
(826, 4, 115, 1000002),
(827, 4, 116, 1000002),
(828, 4, 117, 1000002),
(829, 4, 120, 1000002),
(830, 4, 121, 1000002),
(831, 4, 126, 1000002),
(832, 4, 127, 1000002),
(833, 4, 128, 1000002),
(834, 4, 129, 1000002),
(835, 4, 130, 1000002),
(836, 4, 132, 1000002),
(837, 4, 134, 1000002),
(838, 4, 137, 1000002),
(839, 4, 138, 1000002),
(840, 4, 139, 1000002),
(841, 4, 140, 1000002),
(842, 4, 141, 1000002),
(843, 4, 142, 1000002),
(844, 4, 144, 1000002),
(845, 4, 145, 1000002),
(846, 4, 147, 1000002),
(847, 4, 148, 1000002),
(848, 4, 149, 1000002),
(849, 4, 155, 1000002),
(850, 4, 156, 1000002),
(851, 4, 159, 1000002),
(852, 4, 160, 1000002),
(853, 4, 161, 1000002),
(854, 4, 162, 1000002),
(855, 4, 163, 1000002),
(856, 4, 164, 1000002),
(857, 4, 165, 1000002),
(858, 4, 166, 1000002),
(859, 4, 169, 1000002),
(860, 4, 170, 1000002),
(861, 4, 171, 1000002),
(862, 4, 172, 1000002),
(863, 4, 174, 1000002),
(864, 4, 175, 1000002),
(865, 4, 178, 1000002),
(866, 4, 183, 1000002),
(867, 4, 184, 1000002),
(868, 4, 188, 1000002),
(869, 4, 190, 1000002),
(870, 4, 193, 1000002),
(871, 4, 197, 1000002),
(872, 4, 198, 1000002),
(873, 4, 199, 1000002),
(874, 4, 200, 1000002),
(875, 4, 202, 1000002),
(876, 4, 223, 1000002),
(877, 4, 226, 1000002),
(878, 4, 229, 1000002),
(879, 4, 231, 1000002),
(880, 4, 236, 1000002),
(881, 4, 237, 1000002),
(882, 4, 238, 1000002),
(883, 4, 239, 1000002),
(884, 4, 240, 1000002),
(885, 4, 241, 1000002),
(886, 4, 248, 1000002),
(887, 4, 249, 1000002),
(888, 4, 251, 1000002),
(889, 4, 264, 1000002),
(890, 4, 265, 1000002),
(891, 4, 266, 1000002),
(892, 4, 267, 1000002),
(893, 4, 268, 1000002),
(894, 4, 269, 1000002),
(895, 4, 272, 1000002),
(896, 4, 273, 1000002),
(909, 5, 15, 1000002),
(910, 5, 17, 1000002),
(911, 5, 34, 1000002),
(912, 5, 38, 1000002),
(913, 5, 39, 1000002),
(914, 5, 40, 1000002),
(915, 5, 41, 1000002),
(916, 5, 42, 1000002),
(917, 5, 44, 1000002),
(918, 5, 45, 1000002),
(919, 5, 46, 1000002),
(920, 5, 52, 1000002),
(921, 5, 53, 1000002),
(922, 5, 55, 1000002),
(923, 5, 56, 1000002),
(924, 5, 57, 1000002),
(925, 5, 59, 1000002),
(926, 5, 60, 1000002),
(927, 5, 65, 1000002),
(928, 5, 66, 1000002),
(929, 5, 67, 1000002),
(930, 5, 68, 1000002),
(931, 5, 72, 1000002),
(932, 5, 73, 1000002),
(933, 5, 80, 1000002),
(934, 5, 81, 1000002),
(935, 5, 82, 1000002),
(936, 5, 83, 1000002),
(937, 5, 84, 1000002),
(938, 5, 85, 1000002),
(939, 5, 86, 1000002),
(940, 5, 87, 1000002),
(941, 5, 89, 1000002),
(942, 5, 90, 1000002),
(943, 5, 93, 1000002),
(944, 5, 95, 1000002),
(945, 5, 100, 1000002),
(946, 5, 101, 1000002),
(947, 5, 103, 1000002),
(948, 5, 105, 1000002),
(949, 5, 107, 1000002),
(950, 5, 108, 1000002),
(951, 5, 109, 1000002),
(952, 5, 114, 1000002),
(953, 5, 115, 1000002),
(954, 5, 116, 1000002),
(955, 5, 117, 1000002),
(956, 5, 120, 1000002),
(957, 5, 121, 1000002),
(958, 5, 126, 1000002),
(959, 5, 127, 1000002),
(960, 5, 128, 1000002),
(961, 5, 129, 1000002),
(962, 5, 130, 1000002),
(963, 5, 132, 1000002),
(964, 5, 134, 1000002),
(965, 5, 137, 1000002),
(966, 5, 138, 1000002),
(967, 5, 139, 1000002),
(968, 5, 140, 1000002),
(969, 5, 141, 1000002),
(970, 5, 142, 1000002),
(971, 5, 144, 1000002),
(972, 5, 145, 1000002),
(973, 5, 147, 1000002),
(974, 5, 148, 1000002),
(975, 5, 149, 1000002),
(976, 5, 155, 1000002),
(977, 5, 156, 1000002),
(978, 5, 159, 1000002),
(979, 5, 160, 1000002),
(980, 5, 161, 1000002),
(981, 5, 162, 1000002),
(982, 5, 163, 1000002),
(983, 5, 164, 1000002),
(984, 5, 165, 1000002),
(985, 5, 166, 1000002),
(986, 5, 169, 1000002),
(987, 5, 170, 1000002),
(988, 5, 171, 1000002),
(989, 5, 172, 1000002),
(990, 5, 174, 1000002),
(991, 5, 175, 1000002),
(992, 5, 178, 1000002),
(993, 5, 183, 1000002),
(994, 5, 184, 1000002),
(995, 5, 188, 1000002),
(996, 5, 190, 1000002),
(997, 5, 193, 1000002),
(998, 5, 197, 1000002),
(999, 5, 198, 1000002),
(1000, 5, 199, 1000002),
(1001, 5, 200, 1000002),
(1002, 5, 202, 1000002),
(1003, 5, 223, 1000002),
(1004, 5, 226, 1000002),
(1005, 5, 229, 1000002),
(1006, 5, 231, 1000002),
(1007, 5, 236, 1000002),
(1008, 5, 237, 1000002),
(1009, 5, 238, 1000002),
(1010, 5, 239, 1000002),
(1011, 5, 240, 1000002),
(1012, 5, 241, 1000002),
(1013, 5, 248, 1000002),
(1014, 5, 249, 1000002),
(1015, 5, 251, 1000002),
(1016, 5, 262, 1000002),
(1017, 5, 263, 1000002),
(1018, 5, 264, 1000002),
(1019, 5, 265, 1000002),
(1020, 5, 266, 1000002),
(1021, 5, 267, 1000002),
(1022, 5, 268, 1000002),
(1023, 5, 269, 1000002),
(1024, 5, 272, 1000002),
(1025, 5, 273, 1000002),
(1036, 6, 15, 1000002),
(1037, 6, 17, 1000002),
(1038, 6, 34, 1000002),
(1039, 6, 38, 1000002),
(1040, 6, 39, 1000002),
(1041, 6, 40, 1000002),
(1042, 6, 41, 1000002),
(1043, 6, 42, 1000002),
(1044, 6, 44, 1000002),
(1045, 6, 45, 1000002),
(1046, 6, 46, 1000002),
(1047, 6, 52, 1000002),
(1048, 6, 53, 1000002),
(1049, 6, 55, 1000002),
(1050, 6, 56, 1000002),
(1051, 6, 57, 1000002),
(1052, 6, 59, 1000002),
(1053, 6, 60, 1000002),
(1054, 6, 65, 1000002),
(1055, 6, 66, 1000002),
(1056, 6, 67, 1000002),
(1057, 6, 68, 1000002),
(1058, 6, 72, 1000002),
(1059, 6, 73, 1000002),
(1060, 6, 80, 1000002),
(1061, 6, 81, 1000002),
(1062, 6, 82, 1000002),
(1063, 6, 83, 1000002),
(1064, 6, 84, 1000002),
(1065, 6, 85, 1000002),
(1066, 6, 86, 1000002),
(1067, 6, 87, 1000002),
(1068, 6, 89, 1000002),
(1069, 6, 90, 1000002),
(1070, 6, 93, 1000002),
(1071, 6, 95, 1000002),
(1072, 6, 100, 1000002),
(1073, 6, 101, 1000002),
(1074, 6, 103, 1000002),
(1075, 6, 105, 1000002),
(1076, 6, 107, 1000002),
(1077, 6, 108, 1000002),
(1078, 6, 109, 1000002),
(1079, 6, 114, 1000002),
(1080, 6, 115, 1000002),
(1081, 6, 116, 1000002),
(1082, 6, 117, 1000002),
(1083, 6, 120, 1000002),
(1084, 6, 121, 1000002),
(1085, 6, 126, 1000002),
(1086, 6, 127, 1000002),
(1087, 6, 128, 1000002),
(1088, 6, 129, 1000002),
(1089, 6, 130, 1000002),
(1090, 6, 132, 1000002),
(1091, 6, 134, 1000002),
(1092, 6, 137, 1000002),
(1093, 6, 138, 1000002),
(1094, 6, 139, 1000002),
(1095, 6, 140, 1000002),
(1096, 6, 141, 1000002),
(1097, 6, 142, 1000002),
(1098, 6, 144, 1000002),
(1099, 6, 145, 1000002),
(1100, 6, 147, 1000002),
(1101, 6, 148, 1000002),
(1102, 6, 149, 1000002),
(1103, 6, 155, 1000002),
(1104, 6, 156, 1000002),
(1105, 6, 159, 1000002),
(1106, 6, 160, 1000002),
(1107, 6, 161, 1000002),
(1108, 6, 162, 1000002),
(1109, 6, 163, 1000002),
(1110, 6, 164, 1000002),
(1111, 6, 165, 1000002),
(1112, 6, 166, 1000002),
(1113, 6, 169, 1000002),
(1114, 6, 170, 1000002),
(1115, 6, 171, 1000002),
(1116, 6, 172, 1000002),
(1117, 6, 174, 1000002),
(1118, 6, 175, 1000002),
(1119, 6, 178, 1000002),
(1120, 6, 183, 1000002),
(1121, 6, 184, 1000002),
(1122, 6, 188, 1000002),
(1123, 6, 190, 1000002),
(1124, 6, 193, 1000002),
(1125, 6, 197, 1000002),
(1126, 6, 198, 1000002),
(1127, 6, 199, 1000002),
(1128, 6, 200, 1000002),
(1129, 6, 202, 1000002),
(1130, 6, 223, 1000002),
(1131, 6, 226, 1000002),
(1132, 6, 229, 1000002),
(1133, 6, 231, 1000002),
(1134, 6, 236, 1000002),
(1135, 6, 237, 1000002),
(1136, 6, 238, 1000002),
(1137, 6, 239, 1000002),
(1138, 6, 240, 1000002),
(1139, 6, 241, 1000002),
(1140, 6, 248, 1000002),
(1141, 6, 249, 1000002),
(1142, 6, 251, 1000002),
(1143, 6, 262, 1000002),
(1144, 6, 263, 1000002),
(1145, 6, 264, 1000002),
(1146, 6, 265, 1000002),
(1147, 6, 266, 1000002),
(1148, 6, 267, 1000002),
(1149, 6, 268, 1000002),
(1150, 6, 269, 1000002),
(1151, 6, 272, 1000002),
(1152, 6, 273, 1000002),
(1163, 7, 15, 1000002),
(1164, 7, 17, 1000002),
(1165, 7, 34, 1000002),
(1166, 7, 38, 1000002),
(1167, 7, 39, 1000002),
(1168, 7, 40, 1000002),
(1169, 7, 41, 1000002),
(1170, 7, 42, 1000002),
(1171, 7, 44, 1000002),
(1172, 7, 45, 1000002),
(1173, 7, 46, 1000002),
(1174, 7, 52, 1000002),
(1175, 7, 53, 1000002),
(1176, 7, 55, 1000002),
(1177, 7, 56, 1000002),
(1178, 7, 57, 1000002),
(1179, 7, 59, 1000002),
(1180, 7, 60, 1000002),
(1181, 7, 65, 1000002),
(1182, 7, 66, 1000002),
(1183, 7, 67, 1000002),
(1184, 7, 68, 1000002),
(1185, 7, 72, 1000002),
(1186, 7, 73, 1000002),
(1187, 7, 80, 1000002),
(1188, 7, 81, 1000002),
(1189, 7, 82, 1000002),
(1190, 7, 83, 1000002),
(1191, 7, 84, 1000002),
(1192, 7, 85, 1000002),
(1193, 7, 86, 1000002),
(1194, 7, 87, 1000002),
(1195, 7, 89, 1000002),
(1196, 7, 90, 1000002),
(1197, 7, 93, 1000002),
(1198, 7, 95, 1000002),
(1199, 7, 100, 1000002),
(1200, 7, 101, 1000002),
(1201, 7, 103, 1000002),
(1202, 7, 105, 1000002),
(1203, 7, 107, 1000002),
(1204, 7, 108, 1000002),
(1205, 7, 109, 1000002),
(1206, 7, 114, 1000002),
(1207, 7, 115, 1000002),
(1208, 7, 116, 1000002),
(1209, 7, 117, 1000002),
(1210, 7, 120, 1000002),
(1211, 7, 121, 1000002),
(1212, 7, 126, 1000002),
(1213, 7, 127, 1000002),
(1214, 7, 128, 1000002),
(1215, 7, 129, 1000002),
(1216, 7, 130, 1000002),
(1217, 7, 132, 1000002),
(1218, 7, 134, 1000002),
(1219, 7, 137, 1000002),
(1220, 7, 138, 1000002),
(1221, 7, 139, 1000002),
(1222, 7, 140, 1000002),
(1223, 7, 141, 1000002),
(1224, 7, 142, 1000002),
(1225, 7, 144, 1000002),
(1226, 7, 145, 1000002),
(1227, 7, 147, 1000002),
(1228, 7, 148, 1000002),
(1229, 7, 149, 1000002),
(1230, 7, 155, 1000002),
(1231, 7, 156, 1000002),
(1232, 7, 159, 1000002),
(1233, 7, 160, 1000002),
(1234, 7, 161, 1000002),
(1235, 7, 162, 1000002),
(1236, 7, 163, 1000002),
(1237, 7, 164, 1000002),
(1238, 7, 165, 1000002),
(1239, 7, 166, 1000002),
(1240, 7, 169, 1000002),
(1241, 7, 170, 1000002),
(1242, 7, 171, 1000002),
(1243, 7, 172, 1000002),
(1244, 7, 174, 1000002),
(1245, 7, 175, 1000002),
(1246, 7, 178, 1000002),
(1247, 7, 183, 1000002),
(1248, 7, 184, 1000002),
(1249, 7, 188, 1000002),
(1250, 7, 190, 1000002),
(1251, 7, 193, 1000002),
(1252, 7, 197, 1000002),
(1253, 7, 198, 1000002),
(1254, 7, 199, 1000002),
(1255, 7, 200, 1000002),
(1256, 7, 202, 1000002),
(1257, 7, 223, 1000002),
(1258, 7, 226, 1000002),
(1259, 7, 229, 1000002),
(1260, 7, 231, 1000002),
(1261, 7, 236, 1000002),
(1262, 7, 237, 1000002),
(1263, 7, 238, 1000002),
(1264, 7, 239, 1000002),
(1265, 7, 240, 1000002),
(1266, 7, 241, 1000002),
(1267, 7, 248, 1000002),
(1268, 7, 249, 1000002),
(1269, 7, 251, 1000002),
(1270, 7, 262, 1000002),
(1271, 7, 263, 1000002),
(1272, 7, 264, 1000002),
(1273, 7, 265, 1000002),
(1274, 7, 266, 1000002),
(1275, 7, 267, 1000002),
(1276, 7, 268, 1000002),
(1277, 7, 269, 1000002),
(1278, 7, 272, 1000002),
(1279, 7, 273, 1000002),
(1290, 1, 275, 1000001),
(1291, 2, 275, 1000001),
(1292, 3, 275, 1000001),
(1293, 1, 276, 1000001),
(1294, 2, 276, 1000002),
(1295, 3, 276, 1000002),
(1302, 1, 278, 1000001),
(1303, 1, 279, 1000001),
(1304, 1, 280, 8),
(1305, 3, 280, 8),
(1312, 1, 285, 1000001),
(1313, 3, 285, 1000001),
(1314, 1, 286, 8),
(1315, 3, 286, 7),
(1316, 1, 287, 8),
(1317, 3, 287, 7),
(1318, 1, 288, 1000001),
(1319, 3, 288, 1000002),
(1320, 2, 287, 2),
(1321, 4, 287, 9),
(1322, 5, 287, 9),
(1323, 6, 287, 9),
(1324, 7, 287, 9),
(1325, 1, 290, 8),
(1326, 2, 290, 2),
(1327, 3, 290, 7),
(1328, 4, 290, 1),
(1329, 1, 291, 1000001),
(1330, 1, 292, 8),
(1331, 2, 292, 2),
(1332, 3, 292, 7),
(1333, 4, 292, 1),
(1334, 1, 293, 1000001),
(1335, 1, 294, 8),
(1336, 2, 294, 2),
(1337, 3, 294, 7),
(1338, 4, 294, 1),
(1339, 1, 295, 1000001),
(1340, 1, 301, 1000001),
(1341, 2, 301, 1000002),
(1342, 3, 301, 1000002),
(1343, 4, 301, 1000002),
(1344, 1, 302, 1000001),
(1345, 1, 303, 1000001),
(1346, 2, 303, 1000002),
(1347, 3, 303, 1000002),
(1348, 4, 303, 1000002),
(1349, 1, 304, 1000001),
(1350, 2, 304, 1000002),
(1351, 3, 304, 1000002),
(1352, 4, 304, 1000002),
(1353, 1, 305, 1000001),
(1354, 2, 305, 1000002),
(1355, 3, 305, 1000002),
(1356, 4, 305, 1000002),
(1357, 1, 306, 1000001),
(1358, 2, 306, 1000002),
(1359, 3, 306, 1000002),
(1360, 4, 306, 1000002),
(1361, 1, 307, 1000001),
(1362, 2, 307, 1000002),
(1363, 3, 307, 1000002),
(1364, 4, 307, 1000002),
(1365, 1, 308, 1000001),
(1366, 1, 309, 1000001),
(1367, 1, 311, 8),
(1368, 2, 311, 2),
(1369, 3, 311, 7),
(1370, 1, 312, 1000001),
(1371, 1, 310, 8),
(1372, 2, 310, 2),
(1373, 3, 310, 7),
(1374, 1, 315, 8),
(1375, 2, 315, 2),
(1376, 3, 315, 7),
(1377, 1, 316, 8),
(1378, 2, 316, 8),
(1379, 3, 316, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]accessscope`
--

CREATE TABLE `[[dbprefix]]accessscope` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `accessCode` varchar(3) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isSpecific` int(1) unsigned DEFAULT '1' COMMENT '1',
  `nameSpecific` varchar(100) DEFAULT NULL,
  `isNonProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isYesNo` int(1) unsigned DEFAULT '0' COMMENT '1',
  `nameNonProject` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]accessscope`
--

INSERT INTO `[[dbprefix]]accessscope` VALUES
(1, 'accessScopeNo', 'NO', 100, 0, 1, 'accessScopeSpecificNo', 1, 1, 'accessScopeNoProjectNo'),
(2, 'accessScopeOwn', 'OWN', 200, 0, 1, 'accessScopeSpecificOwn', 1, 0, 'accessScopeOwn'),
(3, 'accessScopeProject', 'PRO', 300, 0, 1, 'accessScopeSpecificProject', 0, 0, NULL),
(4, 'accessScopeAll', 'ALL', 400, 0, 1, 'accessScopeSpecificAll', 1, 1, 'accessScopeNoProjectYes'),
(5, 'accessScopeResp', 'RES', 250, 0, 0, NULL, 1, 0, 'accessScopeResp');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]accessscopespecific`
--

CREATE TABLE `[[dbprefix]]accessscopespecific` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `accessCode` varchar(5) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]accessscopespecific`
--

INSERT INTO `[[dbprefix]]accessscopespecific` VALUES
(1, 'accessScopeSpecificNo', 'NO', 100, 0),
(2, 'accessScopeSpecificOwn', 'OWN', 200, 0),
(3, 'accessScopeSpecificProject', 'PRO', 300, 0),
(4, 'accessScopeSpecificAll', 'ALL', 400, 0),
(6, 'accessScopeSpecificTeam', 'TEAM', 350, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]action`
--

CREATE TABLE `[[dbprefix]]action` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialDueDate` date DEFAULT NULL,
  `actualDueDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idActionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idEfficiency` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isPrivate` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `actionProject` (`idProject`),
  KEY `actionUser` (`idUser`),
  KEY `actionResource` (`idResource`),
  KEY `actionStatus` (`idStatus`),
  KEY `actionType` (`idActionType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activity`
--

CREATE TABLE `[[dbprefix]]activity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivityType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idComponent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isPlanningActivity` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lastUpdateDateTime` datetime DEFAULT NULL,
  `idComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  `fixPlanning` int(1) unsigned DEFAULT '0' COMMENT '1',
  `paused` int(1) unsigned DEFAULT '0' COMMENT '1',
  `workOnRealTime` int(1) unsigned DEFAULT '0' COMMENT '1',
  `tags` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activityProject` (`idProject`),
  KEY `activityUser` (`idUser`),
  KEY `activityResource` (`idResource`),
  KEY `activityStatus` (`idStatus`),
  KEY `activityType` (`idActivityType`),
  KEY `activityActivity` (`idActivity`),
  KEY `activityReference` (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activityprice`
--

CREATE TABLE `[[dbprefix]]activityprice` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivityType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `priceCost` decimal(10,2) DEFAULT '0.00',
  `subcontractor` int(1) DEFAULT NULL COMMENT '1',
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `subcontractorCost` decimal(10,2) DEFAULT NULL,
  `idTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  `commissionCost` decimal(10,2) DEFAULT NULL,
  `isRef` int(1) DEFAULT '0' COMMENT '1',
  `pct` int(3) DEFAULT NULL COMMENT '3',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `commissionCostLocal` decimal(10,2) DEFAULT NULL,
  `priceCostLocal` decimal(10,2) DEFAULT NULL,
  `subcontractorCostLocal` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activitypriceProject` (`idProject`),
  KEY `activitypriceActivityType` (`idActivityType`),
  KEY `activitypriceTeam` (`idTeam`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activityskill`
--

CREATE TABLE `[[dbprefix]]activityskill` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSkill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSkillLevel` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activityworkunit`
--

CREATE TABLE `[[dbprefix]]activityworkunit` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComplexity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `quantity` decimal(8,3) unsigned DEFAULT NULL,
  `idWorkCommand` int(12) DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affectation`
--

CREATE TABLE `[[dbprefix]]affectation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `rate` int(3) unsigned DEFAULT NULL COMMENT '3',
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idRole` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResourceSelect` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `hideAffectation` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idResourceTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `affectationProject` (`idProject`),
  KEY `affectationResource` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]alert`
--

CREATE TABLE `[[dbprefix]]alert` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idIndicatorValue` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `alertType` varchar(10) DEFAULT NULL,
  `alertInitialDateTime` datetime DEFAULT NULL,
  `alertDateTime` datetime DEFAULT NULL,
  `alertReadDateTime` datetime DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `message` varchar(4000) DEFAULT NULL,
  `readFlag` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]approvalstatus`
--

CREATE TABLE `[[dbprefix]]approvalstatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]approvalstatus`
--

INSERT INTO `[[dbprefix]]approvalstatus` VALUES
(1, 'noApprobationDoc'),
(2, 'rejectDoc'),
(3, 'waitApprobDoc'),
(4, 'approvedDoc');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]approver`
--

CREATE TABLE `[[dbprefix]]approver` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `approved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `approvedDate` datetime DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `disapproved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `disapprovedDate` datetime DEFAULT NULL,
  `disapprovedComment` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `approverRef` (`refType`,`refId`),
  KEY `approverAffectable` (`idAffectable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]asset`
--

CREATE TABLE `[[dbprefix]]asset` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idAssetType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `installationDate` date DEFAULT NULL,
  `decommissioningDate` date DEFAULT NULL,
  `serialNumber` varchar(100) DEFAULT NULL,
  `inventoryNumber` varchar(100) DEFAULT NULL,
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAsset` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLocation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `complement` varchar(200) DEFAULT NULL,
  `idBrand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idModel` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssetCategory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `warantyDurationM` int(12) unsigned DEFAULT NULL COMMENT '12',
  `warantyEndDate` date DEFAULT NULL,
  `depreciationDurationY` int(4) unsigned DEFAULT NULL COMMENT '4',
  `needInsurance` int(1) unsigned DEFAULT '0' COMMENT '1',
  `purchaseValueHTAmount` decimal(11,2) DEFAULT NULL,
  `purchaseValueTTCAmount` decimal(11,2) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `lastUpdateDateTime` datetime DEFAULT NULL,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `assetType` (`idAssetType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assetcategory`
--

CREATE TABLE `[[dbprefix]]assetcategory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]assetcategory`
--

INSERT INTO `[[dbprefix]]assetcategory` VALUES
(1, 'Individual', 10, 0),
(2, 'Collective', 20, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment`
--

CREATE TABLE `[[dbprefix]]assignment` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `rate` int(3) unsigned DEFAULT '100' COMMENT '3',
  `assignedWork` decimal(12,5) unsigned DEFAULT NULL,
  `realWork` decimal(12,5) unsigned DEFAULT NULL,
  `leftWork` decimal(12,5) unsigned DEFAULT NULL,
  `plannedWork` decimal(12,5) unsigned DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `realStartDate` date DEFAULT NULL,
  `realEndDate` date DEFAULT NULL,
  `comment` varchar(4000) DEFAULT NULL,
  `plannedStartDate` date DEFAULT NULL,
  `plannedEndDate` date DEFAULT NULL,
  `idRole` int(12) unsigned DEFAULT NULL COMMENT '12',
  `dailyCost` decimal(11,2) unsigned DEFAULT NULL,
  `newDailyCost` decimal(11,2) unsigned DEFAULT NULL,
  `assignedCost` decimal(11,2) DEFAULT NULL,
  `realCost` decimal(11,2) DEFAULT NULL,
  `leftCost` decimal(11,2) DEFAULT NULL,
  `plannedCost` decimal(11,2) DEFAULT NULL,
  `billedWork` decimal(10,2) NOT NULL DEFAULT '0.00',
  `notPlannedWork` decimal(12,5) unsigned DEFAULT '0.00000',
  `plannedStartFraction` decimal(6,5) DEFAULT '0.00000',
  `plannedEndFraction` decimal(6,5) DEFAULT '1.00000',
  `isNotImputable` int(1) unsigned DEFAULT '0' COMMENT '1',
  `optional` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isResourceTeam` int(1) unsigned DEFAULT '0' COMMENT '1',
  `capacity` decimal(5,2) unsigned DEFAULT NULL,
  `surbooked` int(1) DEFAULT '0' COMMENT '1',
  `uniqueResource` int(1) unsigned DEFAULT '0' COMMENT '1',
  `supportedAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `supportedResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `hasSupport` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isManual` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isMaterial` int(1) unsigned DEFAULT '0' COMMENT '1',
  `assignedCostLocal` decimal(11,2) DEFAULT NULL,
  `dailyCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `leftCostLocal` decimal(11,2) DEFAULT NULL,
  `newDailyCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `plannedCostLocal` decimal(11,2) DEFAULT NULL,
  `realCostLocal` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assignmentProject` (`idProject`),
  KEY `assignmentResource` (`idResource`),
  KEY `assignmentRef` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignmentrecurring`
--

CREATE TABLE `[[dbprefix]]assignmentrecurring` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `type` varchar(10) DEFAULT NULL,
  `day` int(3) DEFAULT NULL COMMENT '3',
  `value` decimal(12,5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idAssignmentAssignmentRecurring` (`idAssignment`),
  KEY `referenceAssignmentRecurring` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignmentselection`
--

CREATE TABLE `[[dbprefix]]assignmentselection` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `userSelected` int(1) unsigned DEFAULT '0' COMMENT '1',
  `selected` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assumption`
--

CREATE TABLE `[[dbprefix]]assumption` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssumptionType` int(12) unsigned NOT NULL COMMENT '12',
  `description` mediumtext,
  `idStatus` int(12) unsigned NOT NULL COMMENT '12',
  `idSeverity` int(12) unsigned NOT NULL COMMENT '12',
  `idLikelihood` int(12) unsigned NOT NULL COMMENT '12',
  `impact` mediumtext,
  `actionPlan` mediumtext,
  `result` mediumtext,
  `isFalseAssumption` int(1) unsigned NOT NULL COMMENT '1',
  `isFalseDateAssumption` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `assumptionproject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachment`
--

CREATE TABLE `[[dbprefix]]attachment` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` datetime DEFAULT NULL,
  `fileName` varchar(1024) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `subDirectory` varchar(100) DEFAULT NULL,
  `mimeType` varchar(100) DEFAULT NULL,
  `fileSize` bigint(12) unsigned DEFAULT NULL,
  `link` varchar(1024) DEFAULT NULL,
  `type` varchar(10) DEFAULT 'file',
  `idPrivacy` int(12) unsigned DEFAULT '1' COMMENT '12',
  `idTeam` int(12) unsigned DEFAULT '1' COMMENT '12',
  `isProfilePic` int(12) unsigned DEFAULT '0' COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `attachementUser` (`idUser`),
  KEY `attachementRef` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]audit`
--

CREATE TABLE `[[dbprefix]]audit` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `sessionId` varchar(100) DEFAULT NULL,
  `auditDay` varchar(8) DEFAULT NULL,
  `connectionDateTime` datetime DEFAULT NULL,
  `disconnectionDateTime` datetime DEFAULT NULL,
  `lastAccessDateTime` datetime DEFAULT NULL,
  `duration` time DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `userName` varchar(100) DEFAULT NULL,
  `userAgent` varchar(400) DEFAULT NULL,
  `platform` varchar(100) DEFAULT NULL,
  `browser` varchar(100) DEFAULT NULL,
  `browserVersion` varchar(100) DEFAULT NULL,
  `requestRefreshParam` int(1) DEFAULT '0' COMMENT '1',
  `requestDisconnection` int(1) DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `requestRefreshProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `durationSeconds` int(10) unsigned DEFAULT '0' COMMENT '10',
  `durationDisplay` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auditSessionId` (`sessionId`),
  KEY `auditUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auditsummary`
--

CREATE TABLE `[[dbprefix]]auditsummary` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `auditDay` varchar(8) DEFAULT NULL,
  `firstConnection` datetime DEFAULT NULL,
  `lastConnection` datetime DEFAULT NULL,
  `numberSessions` int(10) DEFAULT NULL COMMENT '10',
  `minDuration` time DEFAULT NULL,
  `maxDuration` time DEFAULT NULL,
  `meanDuration` time DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `auditsummaryAuditDay` (`auditDay`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]baseline`
--

CREATE TABLE `[[dbprefix]]baseline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `baselineNumber` int(3) unsigned DEFAULT NULL COMMENT '3',
  `name` varchar(100) DEFAULT NULL,
  `baselineDate` date DEFAULT NULL,
  `creationDateTime` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPrivacy` int(12) unsigned DEFAULT '1' COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `baselineProject` (`idProject`),
  KEY `baselineUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bill`
--

CREATE TABLE `[[dbprefix]]bill` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idBillType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `billingType` varchar(10) DEFAULT NULL,
  `description` mediumtext,
  `date` date DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `billId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `tax` decimal(5,2) DEFAULT NULL,
  `untaxedAmount` decimal(12,2) DEFAULT NULL,
  `fullAmount` decimal(12,2) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idActivityType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `paymentDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `paymentDate` date DEFAULT NULL,
  `paymentAmount` decimal(11,2) unsigned DEFAULT NULL,
  `idPaymentDelay` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDueDate` date DEFAULT NULL,
  `idDeliveryMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `paymentsCount` int(3) DEFAULT '0' COMMENT '3',
  `commandAmountPct` int(3) unsigned DEFAULT '100' COMMENT '3',
  `sendDate` date DEFAULT NULL,
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `fullAmountLocal` decimal(12,2) DEFAULT NULL,
  `paymentAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `untaxedAmountLocal` decimal(12,2) DEFAULT NULL,
  `taxAmountLocal` decimal(12,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `billBillType` (`idBillType`),
  KEY `billProject` (`idProject`),
  KEY `billClient` (`idClient`),
  KEY `billRecipient` (`idRecipient`),
  KEY `billStatus` (`idStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billline`
--

CREATE TABLE `[[dbprefix]]billline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `line` int(3) unsigned DEFAULT NULL COMMENT '3',
  `quantity` decimal(9,2) unsigned DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `detail` varchar(4000) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTerm` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivityPrice` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `idMeasureUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `extra` int(1) unsigned DEFAULT '0' COMMENT '1',
  `billingType` varchar(10) DEFAULT NULL,
  `idCatalog` int(12) unsigned DEFAULT NULL COMMENT '12',
  `numberDays` decimal(9,2) unsigned DEFAULT NULL,
  `idBillLine` int(12) DEFAULT NULL COMMENT '12',
  `rate` decimal(5,2) DEFAULT NULL,
  `priceLocal` decimal(12,2) DEFAULT NULL,
  `amountLocal` decimal(12,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `billlineReference` (`refType`,`refId`),
  KEY `billlineTerm` (`idTerm`),
  KEY `billlineResource` (`idResource`),
  KEY `billlineActivityPrice` (`idActivityPrice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]brand`
--

CREATE TABLE `[[dbprefix]]brand` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]budget`
--

CREATE TABLE `[[dbprefix]]budget` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idBudgetType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idBudgetOrientation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idBudgetCategory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` datetime DEFAULT NULL,
  `lastUpdateDateTime` datetime DEFAULT NULL,
  `articleNumber` varchar(100) DEFAULT NULL,
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `clientCode` varchar(100) DEFAULT NULL,
  `idBudget` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSponsor` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `color` varchar(7) DEFAULT NULL,
  `description` mediumtext,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isUnderConstruction` int(1) unsigned DEFAULT '1' COMMENT '1',
  `handled` int(1) unsigned DEFAULT '1' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `bbs` varchar(1000) DEFAULT NULL,
  `bbsSortable` varchar(4000) DEFAULT NULL,
  `budgetStartDate` date DEFAULT NULL,
  `budgetEndDate` date DEFAULT NULL,
  `plannedAmount` decimal(14,2) unsigned DEFAULT NULL,
  `initialAmount` decimal(14,2) unsigned DEFAULT NULL,
  `update1Amount` decimal(14,2) DEFAULT NULL,
  `update2Amount` decimal(14,2) DEFAULT NULL,
  `update3Amount` decimal(14,2) DEFAULT NULL,
  `update4Amount` decimal(14,2) DEFAULT NULL,
  `actualAmount` decimal(14,2) DEFAULT NULL,
  `actualSubAmount` decimal(14,2) DEFAULT NULL,
  `usedAmount` decimal(14,2) unsigned DEFAULT NULL,
  `availableAmount` decimal(14,2) DEFAULT NULL,
  `billedAmount` decimal(14,2) unsigned DEFAULT NULL,
  `leftAmount` decimal(14,2) DEFAULT NULL,
  `plannedFullAmount` decimal(14,2) unsigned DEFAULT NULL,
  `initialFullAmount` decimal(14,2) unsigned DEFAULT NULL,
  `update1FullAmount` decimal(14,2) DEFAULT NULL,
  `update2FullAmount` decimal(14,2) DEFAULT NULL,
  `update3FullAmount` decimal(14,2) DEFAULT NULL,
  `update4FullAmount` decimal(14,2) DEFAULT NULL,
  `actualFullAmount` decimal(14,2) DEFAULT NULL,
  `actualSubFullAmount` decimal(14,2) DEFAULT NULL,
  `usedFullAmount` decimal(14,2) unsigned DEFAULT NULL,
  `availableFullAmount` decimal(14,2) DEFAULT NULL,
  `billedFullAmount` decimal(14,2) unsigned DEFAULT NULL,
  `leftFullAmount` decimal(14,2) DEFAULT NULL,
  `elementary` int(1) unsigned DEFAULT '1' COMMENT '1',
  `targetAmount` decimal(14,2) unsigned DEFAULT NULL,
  `targetFullAmount` decimal(14,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `budgetBudgetType` (`idBudgetType`),
  KEY `budgetBudget` (`idBudget`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]budgetcategory`
--

CREATE TABLE `[[dbprefix]]budgetcategory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]budgetcategory`
--

INSERT INTO `[[dbprefix]]budgetcategory` VALUES
(1, 'Information Technology', 10, 0),
(2, 'Human Resources', 20, 0),
(3, 'Financials', 30, 0),
(4, 'Management', 40, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]budgetelement`
--

CREATE TABLE `[[dbprefix]]budgetelement` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `year` int(4) unsigned DEFAULT NULL COMMENT '4',
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refName` varchar(100) DEFAULT NULL,
  `budgetWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `validatedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `assignedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `realWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `leftWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `plannedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `topId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `topRefType` varchar(100) DEFAULT NULL,
  `topRefId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT NULL COMMENT '1',
  `elementary` int(1) unsigned DEFAULT NULL COMMENT '1',
  `budgetCost` decimal(14,2) DEFAULT NULL,
  `validatedCost` decimal(14,2) DEFAULT NULL,
  `assignedCost` decimal(14,2) DEFAULT NULL,
  `realCost` decimal(14,2) DEFAULT NULL,
  `leftCost` decimal(14,2) DEFAULT NULL,
  `plannedCost` decimal(14,2) DEFAULT NULL,
  `progress` int(3) unsigned DEFAULT '0' COMMENT '3',
  `expenseBudgetAmount` decimal(14,2) DEFAULT NULL,
  `expenseAssignedAmount` decimal(14,2) DEFAULT NULL,
  `expensePlannedAmount` decimal(14,2) DEFAULT NULL,
  `expenseRealAmount` decimal(14,2) DEFAULT NULL,
  `expenseLeftAmount` decimal(14,2) DEFAULT NULL,
  `expenseValidatedAmount` decimal(14,2) DEFAULT NULL,
  `totalBudgetCost` decimal(14,2) DEFAULT NULL,
  `totalAssignedCost` decimal(14,2) DEFAULT NULL,
  `totalPlannedCost` decimal(14,2) DEFAULT NULL,
  `totalRealCost` decimal(14,2) DEFAULT NULL,
  `totalLeftCost` decimal(14,2) DEFAULT NULL,
  `totalValidatedCost` decimal(14,2) DEFAULT NULL,
  `reserveAmount` decimal(14,2) DEFAULT NULL,
  `idleDateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `budgetelementRef` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]budgetorientation`
--

CREATE TABLE `[[dbprefix]]budgetorientation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]budgetorientation`
--

INSERT INTO `[[dbprefix]]budgetorientation` VALUES
(1, 'Operation', 10, 0),
(2, 'Transformation', 20, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]businessfeature`
--

CREATE TABLE `[[dbprefix]]businessfeature` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `idProduct` int(12) DEFAULT NULL COMMENT '12',
  `creationDate` date NOT NULL,
  `idUser` int(12) DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]calendar`
--

CREATE TABLE `[[dbprefix]]calendar` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `isOffDay` int(1) unsigned DEFAULT '0' COMMENT '1',
  `calendarDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idCalendarDefinition` int(12) unsigned DEFAULT '1' COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `calendarDay` (`day`),
  KEY `calendarWeek` (`week`),
  KEY `calendarMonth` (`month`),
  KEY `calendarYear` (`year`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]calendarbankoffdays`
--

CREATE TABLE `[[dbprefix]]calendarbankoffdays` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idCalendarDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `month` int(2) DEFAULT NULL COMMENT '2',
  `day` int(2) DEFAULT NULL COMMENT '2',
  `easterDay` int(2) DEFAULT NULL COMMENT '2',
  PRIMARY KEY (`id`),
  KEY `calendarbankoffdaysCalendar` (`idCalendarDefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]calendardefinition`
--

CREATE TABLE `[[dbprefix]]calendardefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek0` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek1` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek2` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek3` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek4` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek5` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dayOfWeek6` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]calendardefinition`
--

INSERT INTO `[[dbprefix]]calendardefinition` VALUES
(1, 'default', 10, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]callfortender`
--

CREATE TABLE `[[dbprefix]]callfortender` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idCallForTenderType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `technicalRequirements` mediumtext,
  `businessRequirements` mediumtext,
  `otherRequirements` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendDateTime` datetime DEFAULT NULL,
  `expectedTenderDateTime` datetime DEFAULT NULL,
  `maxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `deliveryDate` date DEFAULT NULL,
  `evaluationMaxValue` decimal(7,2) DEFAULT NULL,
  `fixValue` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `result` mediumtext,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `maxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `callfortenderProject` (`idProject`),
  KEY `callfortenderType` (`idCallForTenderType`),
  KEY `callfortenderStatus` (`idStatus`),
  KEY `callfortenderResource` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog`
--

CREATE TABLE `[[dbprefix]]catalog` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idCatalogType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` varchar(400) DEFAULT NULL,
  `detail` varchar(400) DEFAULT NULL,
  `nomenclature` varchar(100) DEFAULT NULL,
  `specification` mediumtext,
  `unitCost` decimal(10,2) DEFAULT NULL,
  `idMeasureUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `quantity` decimal(5,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cataloguo`
--

CREATE TABLE `[[dbprefix]]cataloguo` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `nomemclature` varchar(200) DEFAULT NULL,
  `numberComplexities` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cataloguoProject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]category`
--

CREATE TABLE `[[dbprefix]]category` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]category`
--

INSERT INTO `[[dbprefix]]category` VALUES
(1, 'Build', NULL, 0),
(2, 'Run', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]changerequest`
--

CREATE TABLE `[[dbprefix]]changerequest` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idBusinessFeature` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idChangeRequestType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRunStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `result` mediumtext,
  `reason` mediumtext,
  `potentialBenefit` mediumtext,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `idTargetProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTargetComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `plannedCost` decimal(12,2) unsigned DEFAULT '0.00',
  `analysis` mediumtext,
  `idUrgency` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCriticality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idFeasibility` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRiskLevel` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialDueDate` date DEFAULT NULL,
  `actualDueDate` date DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `approved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `approvedDate` date DEFAULT NULL,
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedCostLocal` decimal(12,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `changerequestProject` (`idProject`),
  KEY `changerequestProduct` (`idProduct`),
  KEY `changerequestVersion` (`idVersion`),
  KEY `changerequestType` (`idChangeRequestType`),
  KEY `changerequestUser` (`idUser`),
  KEY `changerequestStatus` (`idStatus`),
  KEY `changerequestResource` (`idResource`),
  KEY `changerequestTargetVersion` (`idTargetProductVersion`),
  KEY `changerequestUrgency` (`idUrgency`),
  KEY `changerequestCriticality` (`idCriticality`),
  KEY `changerequestFeasibility` (`idFeasibility`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checklist`
--

CREATE TABLE `[[dbprefix]]checklist` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idChecklistDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `checkCount` int(3) DEFAULT '0' COMMENT '3',
  `comment` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checklistReference` (`refType`,`refId`),
  KEY `checklistChecklistDefinition` (`idChecklistDefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checklistable`
--

CREATE TABLE `[[dbprefix]]checklistable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=50 ;

--
-- Dumping data for table `[[dbprefix]]checklistable`
--

INSERT INTO `[[dbprefix]]checklistable` VALUES
(1, 'Ticket', 0),
(2, 'Activity', 0),
(3, 'Milestone', 0),
(4, 'Risk', 0),
(5, 'Action', 0),
(6, 'Issue', 0),
(7, 'Meeting', 0),
(8, 'Decision', 0),
(9, 'Question', 0),
(10, 'Document', 0),
(11, 'Requirement', 0),
(12, 'TestCase', 0),
(13, 'TestSession', 0),
(14, 'Command', 0),
(15, 'Opportunity', 0),
(16, 'Project', 0),
(17, 'ProductVersion', 0),
(18, 'ComponentVersion', 0),
(19, 'Product', 0),
(20, 'Component', 0),
(21, 'Incoming', 0),
(22, 'Deliverable', 0),
(23, 'Delivery', 0),
(24, 'Bill', 0),
(25, 'CallForTender', 0),
(26, 'Client', 0),
(27, 'Contact', 0),
(28, 'IndividualExpense', 0),
(29, 'Payment', 0),
(30, 'ProjectExpense', 0),
(31, 'Provider', 0),
(32, 'Quotation', 0),
(33, 'Tender', 0),
(34, 'ChangeRequest', 0),
(35, 'SupplierContract', 0),
(36, 'ClientContract', 0),
(37, 'Asset', 0),
(38, 'IncomingMail', 0),
(39, 'OutgoingMail', 0),
(40, 'ActivityExpense', 0),
(41, 'LessonLearned', 0),
(42, 'Assumption', 0),
(43, 'Constraint', 0),
(44, 'Prospect', 0),
(45, 'DomainProspect', 0),
(46, 'PositionProspect', 0),
(47, 'DecisionMakerProspect', 0),
(48, 'ProspectOrigin', 0),
(49, 'ProspectEvent', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checklistdefinition`
--

CREATE TABLE `[[dbprefix]]checklistdefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idChecklistable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `nameChecklistable` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lineCount` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `checklistdefinitionChecklistable` (`idChecklistable`),
  KEY `checklistdefinitionNameChecklistable` (`nameChecklistable`),
  KEY `checklistdefinitionType` (`idType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checklistdefinitionline`
--

CREATE TABLE `[[dbprefix]]checklistdefinitionline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idChecklistDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `title` varchar(1000) DEFAULT NULL,
  `check01` varchar(100) DEFAULT NULL,
  `check02` varchar(100) DEFAULT NULL,
  `check03` varchar(100) DEFAULT NULL,
  `check04` varchar(100) DEFAULT NULL,
  `check05` varchar(100) DEFAULT NULL,
  `title01` varchar(1000) DEFAULT NULL,
  `title02` varchar(1000) DEFAULT NULL,
  `title03` varchar(1000) DEFAULT NULL,
  `title04` varchar(1000) DEFAULT NULL,
  `title05` varchar(1000) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `exclusive` int(1) unsigned DEFAULT '0' COMMENT '1',
  `required` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `checklistdefinitionlineChecklistDefinition` (`idChecklistDefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checklistline`
--

CREATE TABLE `[[dbprefix]]checklistline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idChecklist` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idChecklistDefinitionLine` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value01` int(1) unsigned DEFAULT '0' COMMENT '1',
  `value02` int(1) unsigned DEFAULT '0' COMMENT '1',
  `value03` int(1) unsigned DEFAULT '0' COMMENT '1',
  `value04` int(1) unsigned DEFAULT '0' COMMENT '1',
  `value05` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `checkTime` datetime DEFAULT NULL,
  `comment` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checklistlineChecklist` (`idChecklist`),
  KEY `checklistlineChecklistDefinitionLine` (`idChecklistDefinitionLine`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]client`
--

CREATE TABLE `[[dbprefix]]client` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` mediumtext,
  `clientCode` varchar(25) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `paymentDelay` int(3) DEFAULT NULL COMMENT '3',
  `tax` decimal(5,2) DEFAULT NULL,
  `designation` varchar(100) DEFAULT NULL,
  `street` varchar(100) DEFAULT NULL,
  `complement` varchar(100) DEFAULT NULL,
  `zip` varchar(50) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `idClientType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDelayEndOfMonth` int(1) unsigned DEFAULT '0' COMMENT '1',
  `numTax` varchar(100) DEFAULT NULL,
  `idPaymentDelay` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `clientClientType` (`idClientType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]clientcontract`
--

CREATE TABLE `[[dbprefix]]clientcontract` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `number` varchar(100) DEFAULT NULL,
  `idClientContractType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `tenderReference` varchar(100) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `initialContractTerm` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idUnitDurationContract` int(12) unsigned DEFAULT '2' COMMENT '12',
  `endDate` date DEFAULT NULL,
  `noticePeriod` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idUnitDurationNotice` int(12) unsigned DEFAULT '2' COMMENT '12',
  `noticeDate` date DEFAULT NULL,
  `deadlineDate` date DEFAULT NULL,
  `periodicityContract` int(5) unsigned DEFAULT '0' COMMENT '5',
  `periodicityBill` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idRenewal` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContactContract` int(12) unsigned DEFAULT NULL COMMENT '12',
  `phoneNumber` varchar(20) DEFAULT NULL,
  `weekPeriod` time DEFAULT NULL,
  `saturdayPeriod` time DEFAULT NULL,
  `sundayAndOffDayPeriod` time DEFAULT NULL,
  `weekPeriodEnd` time DEFAULT NULL,
  `saturdayPeriodEnd` time DEFAULT NULL,
  `sundayAndOffDayPeriodEnd` time DEFAULT NULL,
  `sla` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `tokenOrdered` decimal(5,2) unsigned DEFAULT NULL,
  `tokenUsed` decimal(5,2) unsigned DEFAULT NULL,
  `tokenLeft` decimal(5,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]collapsed`
--

CREATE TABLE `[[dbprefix]]collapsed` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(200) NOT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `collapsedUser` (`idUser`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=32 ;

--
-- Dumping data for table `[[dbprefix]]collapsed`
--

INSERT INTO `[[dbprefix]]collapsed` VALUES
(1, 'Ticket_history', 1),
(2, 'Ticket_history', 2),
(3, 'Activity_history', 1),
(4, 'Activity_history', 2),
(5, 'Milestone_history', 1),
(6, 'Milestone_history', 2),
(7, 'IndividualExpense_history', 1),
(8, 'IndividualExpense_history', 2),
(9, 'ProjectExpense_history', 1),
(10, 'ProjectExpense_history', 2),
(11, 'Risk_history', 1),
(12, 'Risk_history', 2),
(13, 'Action_history', 1),
(14, 'Action_history', 2),
(15, 'Issue_history', 1),
(16, 'Issue_history', 2),
(17, 'Meeting_history', 1),
(18, 'Meeting_history', 2),
(19, 'Decision_history', 1),
(20, 'Decision_history', 2),
(21, 'Question_history', 1),
(22, 'Question_history', 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]columnselector`
--

CREATE TABLE `[[dbprefix]]columnselector` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(10) DEFAULT NULL,
  `objectClass` varchar(50) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `field` varchar(100) DEFAULT NULL,
  `attribute` varchar(100) DEFAULT NULL,
  `hidden` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  `widthPct` int(3) DEFAULT NULL COMMENT '3',
  `name` varchar(100) DEFAULT NULL,
  `subItem` varchar(100) DEFAULT NULL,
  `formatter` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scopeColumnSelector` (`scope`,`objectClass`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]command`
--

CREATE TABLE `[[dbprefix]]command` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCommandType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `additionalInfo` mediumtext,
  `externalReference` varchar(100) DEFAULT NULL,
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialStartDate` date DEFAULT NULL,
  `initialEndDate` date DEFAULT NULL,
  `validatedEndDate` date DEFAULT NULL,
  `initialWork` decimal(14,5) unsigned DEFAULT NULL,
  `initialPricePerDayAmount` decimal(12,2) DEFAULT '0.00',
  `untaxedAmount` decimal(12,2) DEFAULT NULL,
  `addWork` decimal(14,5) unsigned DEFAULT NULL,
  `addPricePerDayAmount` decimal(12,2) DEFAULT '0.00',
  `addUntaxedAmount` decimal(12,2) DEFAULT NULL,
  `validatedWork` decimal(14,5) unsigned DEFAULT NULL,
  `validatedPricePerDayAmount` decimal(12,2) DEFAULT '0.00',
  `totalUntaxedAmount` decimal(12,2) DEFAULT NULL,
  `comment` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `validatedStartDate` date DEFAULT NULL,
  `idActivityType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPaymentDelay` int(12) unsigned DEFAULT NULL COMMENT '12',
  `tax` decimal(5,2) DEFAULT NULL,
  `fullAmount` decimal(12,2) DEFAULT NULL,
  `addFullAmount` decimal(12,2) DEFAULT NULL,
  `totalFullAmount` decimal(12,2) DEFAULT NULL,
  `idDeliveryMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `receptionDate` date DEFAULT NULL,
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `addFullAmountLocal` decimal(12,2) DEFAULT NULL,
  `addPricePerDayAmountLocal` decimal(12,2) DEFAULT NULL,
  `addUntaxedAmountLocal` decimal(12,2) DEFAULT NULL,
  `fullAmountLocal` decimal(12,2) DEFAULT NULL,
  `initialPricePerDayAmountLocal` decimal(12,2) DEFAULT NULL,
  `totalFullAmountLocal` decimal(12,2) DEFAULT NULL,
  `totalUntaxedAmountLocal` decimal(12,2) DEFAULT NULL,
  `untaxedAmountLocal` decimal(12,2) DEFAULT NULL,
  `validatedPricePerDayAmountLocal` decimal(12,2) DEFAULT NULL,
  `taxAmountLocal` decimal(12,2) DEFAULT NULL,
  `addTaxAmountLocal` decimal(12,2) DEFAULT NULL,
  `totalTaxAmountLocal` decimal(12,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `commandProject` (`idProject`),
  KEY `commandUser` (`idUser`),
  KEY `commandResource` (`idResource`),
  KEY `commandStatus` (`idStatus`),
  KEY `commandType` (`idCommandType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]complexity`
--

CREATE TABLE `[[dbprefix]]complexity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCatalogUO` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `idZone` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]complexityvalues`
--

CREATE TABLE `[[dbprefix]]complexityvalues` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCatalogUO` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComplexity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `charge` decimal(14,5) DEFAULT NULL,
  `price` decimal(11,2) DEFAULT NULL,
  `duration` int(5) unsigned DEFAULT NULL COMMENT '5',
  `priceLocal` decimal(12,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]consolidationvalidation`
--

CREATE TABLE `[[dbprefix]]consolidationvalidation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idProject` int(12) DEFAULT NULL COMMENT '12',
  `idResource` int(12) DEFAULT NULL COMMENT '12',
  `revenue` decimal(11,2) unsigned DEFAULT NULL,
  `validatedWork` decimal(14,5) unsigned DEFAULT NULL,
  `realWork` decimal(14,5) unsigned DEFAULT NULL,
  `realWorkConsumed` decimal(14,5) unsigned DEFAULT NULL,
  `leftWork` decimal(14,5) unsigned DEFAULT NULL,
  `plannedWork` decimal(14,5) unsigned DEFAULT NULL,
  `margin` decimal(14,5) DEFAULT NULL,
  `validationDate` date DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `monthlyRevenue` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]constrainttable`
--

CREATE TABLE `[[dbprefix]]constrainttable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idConstraintType` int(12) unsigned NOT NULL COMMENT '12',
  `description` mediumtext,
  `idStatus` int(12) unsigned NOT NULL COMMENT '12',
  `idSeverity` int(12) unsigned NOT NULL COMMENT '12',
  `idLikelihood` int(12) unsigned NOT NULL COMMENT '12',
  `impact` mediumtext,
  `actionPlan` mediumtext,
  `result` mediumtext,
  `isFalseConstraint` int(1) unsigned NOT NULL COMMENT '1',
  `isFalseDateConstraint` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `constraintproject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context`
--

CREATE TABLE `[[dbprefix]]context` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idContextType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `contextContextType` (`idContextType`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]context`
--

INSERT INTO `[[dbprefix]]context` VALUES
(1, 1, 'Production', 100, 0),
(2, 1, 'Validation', 200, 0),
(3, 2, 'Windows 7', 100, 0),
(4, 2, 'Windows Vista', 110, 0),
(5, 2, 'Windows XP', 120, 0),
(6, 2, 'Mac OS X', 200, 0),
(7, 2, 'Mac OS <=9', 210, 0),
(8, 2, 'Linux', 210, 0),
(9, 3, 'IE 9', 100, 0),
(10, 3, 'IE 8', 110, 0),
(11, 3, 'IE 7', 120, 0),
(12, 3, 'IE <= 6', 130, 0),
(13, 3, 'FireFox >= 5', 200, 0),
(14, 3, 'FireFox <= 4', 210, 0),
(15, 3, 'Chrome', 300, 0),
(16, 3, 'Safari', 400, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contexttype`
--

CREATE TABLE `[[dbprefix]]contexttype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]contexttype`
--

INSERT INTO `[[dbprefix]]contexttype` VALUES
(1, 'environment', 0, NULL),
(2, 'OS', 0, NULL),
(3, 'browser', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]copyable`
--

CREATE TABLE `[[dbprefix]]copyable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idDefaultCopyable` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=38 ;

--
-- Dumping data for table `[[dbprefix]]copyable`
--

INSERT INTO `[[dbprefix]]copyable` VALUES
(1, 'Ticket', 0, 10, NULL),
(2, 'Activity', 0, 20, NULL),
(3, 'Milestone', 0, 30, NULL),
(4, 'IndividualExpense', 0, 40, NULL),
(5, 'ProjectExpense', 0, 50, NULL),
(6, 'Risk', 0, 60, 8),
(7, 'Action', 0, 32, NULL),
(8, 'Issue', 0, 80, NULL),
(9, 'Meeting', 0, 90, NULL),
(10, 'Decision', 0, 100, NULL),
(11, 'Question', 0, 110, NULL),
(12, 'Requirement', 0, 35, NULL),
(13, 'Command', 0, 36, 15),
(14, 'Quotation', 0, 37, 13),
(15, 'Bill', 0, 38, NULL),
(16, 'Tender', 0, 120, 23),
(17, 'TestCase', 0, 900, NULL),
(18, 'TestSession', 0, 910, NULL),
(19, 'Opportunity', 0, 900, NULL),
(20, 'Delivery', 0, 800, 34),
(21, 'Deliverable', 0, 800, NULL),
(22, 'Incoming', 0, 800, NULL),
(23, 'ProviderOrder', 0, 121, 24),
(24, 'ProviderBill', 0, 122, 26),
(25, 'ProviderTerm', 1, 123, 26),
(26, 'ProviderPayment', 0, 124, NULL),
(27, 'ChangeRequest', 0, 127, NULL),
(28, 'SupplierContract', 0, 128, NULL),
(29, 'ClientContract', 0, 129, NULL),
(30, 'Asset', 0, 130, NULL),
(31, 'CatalogUO', 0, 131, 31),
(32, 'SubTask', 1, 920, 1),
(33, 'IndividualExpense', 0, 55, NULL),
(34, 'Acceptance', 0, 930, 15),
(35, 'LessonLearned', 0, 940, NULL),
(36, 'Assumption', 0, 941, NULL),
(37, 'Constraint', 0, 942, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]criticality`
--

CREATE TABLE `[[dbprefix]]criticality` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]criticality`
--

INSERT INTO `[[dbprefix]]criticality` VALUES
(1, 'Low', 1, '#32cd32', 10, 0),
(2, 'Medium', 2, '#ffd700', 20, 0),
(3, 'High', 4, '#ff0000', 30, 0),
(4, 'Critical', 8, '#000000', 40, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]criticalresourcescenario`
--

CREATE TABLE `[[dbprefix]]criticalresourcescenario` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `lastUpdateDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]criticalresourcescenariopool`
--

CREATE TABLE `[[dbprefix]]criticalresourcescenariopool` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idScenario` int(12) unsigned DEFAULT NULL COMMENT '12',
  `extracapacity` decimal(5,2) DEFAULT NULL,
  `givenDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `criticalresourcescenariopooluserresource` (`idUser`,`idResource`),
  KEY `criticalresourcescenariopooluserscenario` (`idUser`,`idScenario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]criticalresourcescenarioproject`
--

CREATE TABLE `[[dbprefix]]criticalresourcescenarioproject` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idScenario` int(12) unsigned DEFAULT NULL COMMENT '12',
  `proposale` int(1) unsigned DEFAULT NULL COMMENT '1',
  `monthDelay` int(3) DEFAULT NULL COMMENT '3',
  PRIMARY KEY (`id`),
  KEY `criticalresourcescenarioprojectuserproject` (`idUser`,`idProject`),
  KEY `criticalresourcescenarioprojectuserscenario` (`idUser`,`idScenario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cronautosendreport`
--

CREATE TABLE `[[dbprefix]]cronautosendreport` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idReceiver` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT NULL COMMENT '1',
  `sendFrequency` varchar(100) DEFAULT NULL,
  `otherReceiver` varchar(500) DEFAULT NULL,
  `cron` varchar(100) DEFAULT NULL,
  `nextTime` varchar(100) DEFAULT NULL,
  `reportParameter` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cronexecution`
--

CREATE TABLE `[[dbprefix]]cronexecution` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `cron` varchar(100) DEFAULT NULL,
  `fileExecuted` varchar(500) DEFAULT NULL,
  `idle` int(1) DEFAULT NULL COMMENT '1',
  `fonctionName` varchar(256) DEFAULT NULL,
  `nextTime` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]cronexecution`
--

INSERT INTO `[[dbprefix]]cronexecution` VALUES
(1, '0 * * * *', '../tool/cronExecutionStandard.php', 1, 'cronPlanningDifferential', NULL),
(2, '0 2 * * *', '../tool/cronExecutionStandard.php', 1, 'cronPlanningComplete', NULL),
(3, '0 0 1 * *', '../tool/generateImputationAlert.php', 0, 'cronImputationAlertCronResource', NULL),
(4, '0 0 1 * *', '../tool/generateImputationAlert.php', 0, 'cronImputationAlertCronProjectLeader', NULL),
(5, '0 0 1 * *', '../tool/generateImputationAlert.php', 0, 'cronImputationAlertCronTeamManager', NULL),
(6, '0 0 1 * *', '../tool/generateImputationAlert.php', 1, 'cronImputationAlertCronOrganismManager', NULL),
(7, '*/5 * * * *', '../tool/cronExecutionStandard.php', 0, 'dataCloningCheckRequest', NULL),
(8, '30 18 * * *', '../tool/cronExecutionStandard.php', 0, 'archiveHistory', NULL),
(9, '01 * * * *', '../tool/cronExecutionStandard.php', 0, 'kpiCalculate', NULL),
(10, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronCloseMails', NULL),
(11, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronDeleteMails', NULL),
(12, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronCloseAlerts', NULL),
(13, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronDeleteAlerts', NULL),
(14, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronDeleteNotifications', NULL),
(15, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronDeleteAudit', NULL),
(16, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronDeleteLogfile', NULL),
(17, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronDisconnectAll', NULL),
(18, '30 * * * *', '../tool/cronExecutionStandard.php', 0, 'purgeGhostSessions', NULL),
(19, '0 * * * *', '../tool/cronExecutionStandard.php 	', 1, 'cronBaseline', NULL),
(20, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronRunConsistencyFix', NULL),
(21, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronRunConsistencyCheck', NULL),
(22, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronSubscriptionUpdateRevision', NULL),
(23, '0 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronReorderWBS', NULL),
(24, '30 1 * * *', '../tool/cronExecutionStandard.php', 1, 'cronSkillsAlertCron', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customearnedrulesofemploymentcontracttype`
--

CREATE TABLE `[[dbprefix]]customearnedrulesofemploymentcontracttype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `name` varchar(100) DEFAULT NULL,
  `rule` varchar(4000) DEFAULT NULL,
  `whereClause` varchar(4000) DEFAULT NULL,
  `idEmploymentContractType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLeaveType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `quantity` decimal(4,1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]datacloning`
--

CREATE TABLE `[[dbprefix]]datacloning` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `nameDir` varchar(100) DEFAULT NULL,
  `idRequestor` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOrigin` int(12) unsigned DEFAULT NULL COMMENT '12',
  `versionCode` varchar(100) DEFAULT NULL,
  `requestedDate` datetime DEFAULT NULL,
  `plannedDate` varchar(100) DEFAULT NULL,
  `deletedDate` datetime DEFAULT NULL,
  `requestedDeletedDate` datetime DEFAULT NULL,
  `isRequestedDelete` int(1) unsigned DEFAULT '0' COMMENT '1',
  `codeError` varchar(100) DEFAULT NULL,
  `isActive` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]decision`
--

CREATE TABLE `[[dbprefix]]decision` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDecisionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `decisionDate` date DEFAULT NULL,
  `origin` varchar(100) DEFAULT NULL,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `decisionProject` (`idProject`),
  KEY `decisionType` (`idDecisionType`),
  KEY `decisionUser` (`idUser`),
  KEY `decisionResource` (`idResource`),
  KEY `decisionStatus` (`idStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]decisionmakerprospect`
--

CREATE TABLE `[[dbprefix]]decisionmakerprospect` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(12) unsigned NOT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]decisionmakerprospect`
--

INSERT INTO `[[dbprefix]]decisionmakerprospect` VALUES
(1, 1, 'Main decision maker', 10, 0),
(2, 1, 'Collective decision maker', 20, 0),
(3, 1, 'Prescriber', 30, 0),
(4, 1, 'Non-decision maker', 90, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]delay`
--

CREATE TABLE `[[dbprefix]]delay` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUrgency` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value` decimal(6,3) DEFAULT NULL,
  `idDelayUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) DEFAULT NULL COMMENT '12',
  `isProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idMacroStatus` int(12) unsigned DEFAULT '2' COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]delay`
--

INSERT INTO `[[dbprefix]]delay` VALUES
(1, 'Ticket', 16, 1, '2.000', 2, 0, NULL, 0, 2),
(2, 'Ticket', 16, 2, '1.000', 4, 0, NULL, 0, 2),
(3, 'Ticket', 17, 1, '1.000', 4, 0, NULL, 0, 2),
(4, 'Ticket', 17, 2, '4.000', 4, 0, NULL, 0, 2),
(5, 'Ticket', 18, 1, '4.000', 2, 0, NULL, 0, 2),
(6, 'Ticket', 18, 2, '2.000', 4, 0, NULL, 0, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]delayunit`
--

CREATE TABLE `[[dbprefix]]delayunit` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(10) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]delayunit`
--

INSERT INTO `[[dbprefix]]delayunit` VALUES
(1, 'HH', 'hours', 'delay', 100, 0),
(2, 'OH', 'openHours', 'delay', 200, 0),
(3, 'DD', 'days', 'delay', 300, 0),
(4, 'OD', 'openDays', 'delay', 400, 0),
(5, 'PCT', 'percent', 'percent', 500, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]deliverable`
--

CREATE TABLE `[[dbprefix]]deliverable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `scope` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idDeliverableType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `result` mediumtext,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedDate` date DEFAULT NULL,
  `realDate` date DEFAULT NULL,
  `validationDate` date DEFAULT NULL,
  `impactWork` decimal(12,5) DEFAULT NULL,
  `impactDuration` int(5) DEFAULT NULL COMMENT '5',
  `impactCost` decimal(9,0) DEFAULT NULL,
  `idDeliverableWeight` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDeliverableStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialDate` date DEFAULT NULL,
  `impactCostLocal` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deliverableType` (`idDeliverableType`),
  KEY `deliverableStatusIdx` (`idDeliverableStatus`),
  KEY `deliverableProject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]deliverablestatus`
--

CREATE TABLE `[[dbprefix]]deliverablestatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) DEFAULT '0' COMMENT '3',
  `color` varchar(7) DEFAULT '#FFFFFF',
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]deliverablestatus`
--

INSERT INTO `[[dbprefix]]deliverablestatus` VALUES
(1, 'Deliverable', 'not done', 0, '#ff0000', 10, 0),
(2, 'Deliverable', 'delivery refused (major reservations)', 1, '#ff8c00', 20, 0),
(3, 'Deliverable', 'accepted with minor reservations', 2, '#ffff00', 30, 0),
(4, 'Deliverable', 'accepted without reservations', 3, '#7fff00', 40, 0),
(5, 'Incoming', 'not provided', 0, '#ff0000', 10, 0),
(6, 'Incoming', 'not conform', 1, '#ff8c00', 20, 0),
(7, 'Incoming', 'accepted with minor reservations', 2, '#ffff00', 30, 0),
(8, 'Incoming', 'accepted without reservations', 3, '#7fff00', 40, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]deliverableweight`
--

CREATE TABLE `[[dbprefix]]deliverableweight` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `color` varchar(7) DEFAULT '#FFFFFF',
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]deliverableweight`
--

INSERT INTO `[[dbprefix]]deliverableweight` VALUES
(1, 'Deliverable', 'low', 0, '#d3d3d3', 10, 0),
(2, 'Deliverable', 'medium', 0, '#d3d3d3', 20, 0),
(3, 'Deliverable', 'high', 1, '#ffc0cb', 30, 0),
(4, 'Incoming', 'low', 0, '#d3d3d3', 10, 0),
(5, 'Incoming', 'medium', 0, '#d3d3d3', 20, 0),
(6, 'Incoming', 'high', 1, '#ffc0cb', 30, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]delivery`
--

CREATE TABLE `[[dbprefix]]delivery` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idDeliveryType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `result` mediumtext,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedDate` date DEFAULT NULL,
  `realDate` date DEFAULT NULL,
  `validationDate` date DEFAULT NULL,
  `impactWork` decimal(5,0) DEFAULT NULL,
  `impactDuration` int(5) DEFAULT NULL COMMENT '5',
  `impactCost` decimal(9,0) DEFAULT NULL,
  `idDeliverableWeight` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDeliverableStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDateTime` datetime DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDateTime` datetime DEFAULT NULL,
  `idleDateTime` datetime DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialDate` date DEFAULT NULL,
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `impactCostLocal` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deliveryDeliverableTypeIdx` (`idDeliveryType`),
  KEY `deliveryDeliverableStatusIdx` (`idDeliverableStatus`),
  KEY `deliveryProjectIdx` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]deliverymode`
--

CREATE TABLE `[[dbprefix]]deliverymode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]deliverymode`
--

INSERT INTO `[[dbprefix]]deliverymode` VALUES
(1, 'email', 10, 0),
(2, 'postal mail', 20, 0),
(3, 'hand delivered', 30, 0),
(4, 'digital deposit', 40, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dependable`
--

CREATE TABLE `[[dbprefix]]dependable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `scope` varchar(10) DEFAULT 'PE',
  `idDefaultDependable` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=18 ;

--
-- Dumping data for table `[[dbprefix]]dependable`
--

INSERT INTO `[[dbprefix]]dependable` VALUES
(1, 'Activity', 0, 'PE', 1),
(2, 'Milestone', 0, 'PE', 1),
(3, 'Project', 0, 'PE', 3),
(4, 'Requirement', 0, 'R', 4),
(5, 'TestCase', 0, 'TC', 5),
(6, 'TestSession', 0, 'PE', 6),
(7, 'Meeting', 0, 'PE', 1),
(8, 'Ticket', 0, 'T', 1),
(9, 'Action', 0, 'ST', 1),
(10, 'Decision', 0, 'ST', 1),
(11, 'Incoming', 0, 'ST', 1),
(12, 'Deliverable', 0, 'ST', 1),
(13, 'Delivery', 0, 'ST', 1),
(14, 'Opportunity', 0, 'ST', 1),
(15, 'Issue', 0, 'ST', 1),
(16, 'Question', 0, 'ST', 1),
(17, 'Risk', 0, 'ST', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dependency`
--

CREATE TABLE `[[dbprefix]]dependency` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `predecessorId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `predecessorRefType` varchar(100) DEFAULT NULL,
  `predecessorRefId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `successorId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `successorRefType` varchar(100) DEFAULT NULL,
  `successorRefId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `dependencyType` varchar(12) DEFAULT NULL,
  `dependencyDelay` int(3) DEFAULT '0' COMMENT '3',
  `comment` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dependencyPredecessorRef` (`predecessorRefType`,`predecessorRefId`),
  KEY `dependencyPredecessorId` (`predecessorId`),
  KEY `dependencySuccessorRef` (`successorRefType`,`successorRefId`),
  KEY `dependencySuccessorId` (`successorId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]document`
--

CREATE TABLE `[[dbprefix]]document` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDocumentType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDocumentDirectory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersioningType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `version` int(3) DEFAULT NULL COMMENT '3',
  `revision` int(3) DEFAULT NULL COMMENT '3',
  `draft` int(3) DEFAULT NULL COMMENT '3',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDocumentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDocumentVersionRef` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAuthor` int(12) unsigned DEFAULT NULL COMMENT '12',
  `locked` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idLocker` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lockedDate` datetime DEFAULT NULL,
  `fileName` varchar(100) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `documentReference` varchar(400) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `tags` varchar(4000) DEFAULT NULL,
  `idApprovalStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `documentProject` (`idProject`),
  KEY `documentProduct` (`idProduct`),
  KEY `documentDocumentType` (`idDocumentType`),
  KEY `documentDocumentDirectory` (`idDocumentDirectory`),
  KEY `documentVersionType` (`idVersioningType`),
  KEY `documentStatus` (`idStatus`),
  KEY `documentDocumentVersion` (`idDocumentVersion`),
  KEY `documentDocumentVersionRef` (`idDocumentVersionRef`),
  KEY `documentAuthor` (`idAuthor`),
  KEY `documentLocker` (`idLocker`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]documentdirectory`
--

CREATE TABLE `[[dbprefix]]documentdirectory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `location` varchar(4000) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDocumentDirectory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDocumentType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `documentdirectoryProject` (`idProject`),
  KEY `documentdirectoryProduct` (`idProduct`),
  KEY `documentdirectoryDocumentDirectory` (`idDocumentDirectory`),
  KEY `documentdirectoryDocumentType` (`idDocumentType`),
  KEY `documentdirectoryResource` (`idResource`),
  KEY `documentdirectoryUser` (`idUser`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]documentdirectory`
--

INSERT INTO `[[dbprefix]]documentdirectory` VALUES
(1, NULL, 'Project', '/Project', NULL, NULL, NULL, NULL, 0, NULL, 1),
(2, NULL, 'Product', '/Product', NULL, NULL, NULL, NULL, 0, NULL, 1),
(3, NULL, 'Need', '/Product/Need', NULL, NULL, 2, NULL, 0, NULL, 1),
(4, NULL, 'Specification', '/Product/Specification', NULL, NULL, 2, NULL, 0, NULL, 1),
(5, NULL, 'Conception', '/Product/Conception', NULL, NULL, 2, NULL, 0, NULL, 1),
(7, NULL, 'Testing', '/Product/Testing', NULL, NULL, 2, NULL, 0, NULL, 1),
(8, NULL, 'Deployment', '/Product/Deployment', NULL, NULL, 2, NULL, 0, NULL, 1),
(9, NULL, 'Exploitation', '/Product/Exploitation', NULL, NULL, 2, NULL, 0, NULL, 1),
(10, NULL, 'Contract', '/Project/Contract', NULL, NULL, 1, NULL, 0, NULL, 1),
(11, NULL, 'Management', '/Project/Management', NULL, NULL, 1, NULL, 0, NULL, 1),
(12, NULL, 'Reviews', '/Project/Reviews', NULL, NULL, 1, NULL, 0, NULL, 1),
(13, NULL, 'Follow-up', '/Project/Follow-up', NULL, NULL, 1, NULL, 0, NULL, 1),
(14, NULL, 'Financial', '/Project/Financial', NULL, NULL, 1, NULL, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]documentright`
--

CREATE TABLE `[[dbprefix]]documentright` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idDocumentDirectory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAccessMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=128 ;

--
-- Dumping data for table `[[dbprefix]]documentright`
--

INSERT INTO `[[dbprefix]]documentright` VALUES
(1, 1, 1, 8),
(2, 1, 2, 2),
(3, 1, 3, 7),
(4, 1, 4, 7),
(5, 1, 6, 1),
(6, 1, 7, 1),
(7, 1, 5, 9),
(8, 2, 1, 8),
(9, 2, 2, 2),
(10, 2, 3, 7),
(11, 2, 4, 7),
(12, 2, 6, 1),
(13, 2, 7, 1),
(14, 2, 5, 9),
(15, 3, 1, 8),
(16, 3, 2, 2),
(17, 3, 3, 7),
(18, 3, 4, 7),
(19, 3, 6, 1),
(20, 3, 7, 1),
(21, 3, 5, 9),
(22, 4, 1, 8),
(23, 4, 2, 2),
(24, 4, 3, 7),
(25, 4, 4, 7),
(26, 4, 6, 1),
(27, 4, 7, 1),
(28, 4, 5, 9),
(29, 5, 1, 8),
(30, 5, 2, 2),
(31, 5, 3, 7),
(32, 5, 4, 7),
(33, 5, 6, 1),
(34, 5, 7, 1),
(35, 5, 5, 9),
(36, 7, 1, 8),
(37, 7, 2, 2),
(38, 7, 3, 7),
(39, 7, 4, 7),
(40, 7, 6, 1),
(41, 7, 7, 1),
(42, 7, 5, 9),
(43, 8, 1, 8),
(44, 8, 2, 2),
(45, 8, 3, 7),
(46, 8, 4, 7),
(47, 8, 6, 1),
(48, 8, 7, 1),
(49, 8, 5, 9),
(50, 9, 1, 8),
(51, 9, 2, 2),
(52, 9, 3, 7),
(53, 9, 4, 7),
(54, 9, 6, 1),
(55, 9, 7, 1),
(56, 9, 5, 9),
(57, 10, 1, 8),
(58, 10, 2, 2),
(59, 10, 3, 7),
(60, 10, 4, 7),
(61, 10, 6, 1),
(62, 10, 7, 1),
(63, 10, 5, 9),
(64, 11, 1, 8),
(65, 11, 2, 2),
(66, 11, 3, 7),
(67, 11, 4, 7),
(68, 11, 6, 1),
(69, 11, 7, 1),
(70, 11, 5, 9),
(71, 12, 1, 8),
(72, 12, 2, 2),
(73, 12, 3, 7),
(74, 12, 4, 7),
(75, 12, 6, 1),
(76, 12, 7, 1),
(77, 12, 5, 9),
(78, 13, 1, 8),
(79, 13, 2, 2),
(80, 13, 3, 7),
(81, 13, 4, 7),
(82, 13, 6, 1),
(83, 13, 7, 1),
(84, 13, 5, 9),
(85, 14, 1, 8),
(86, 14, 2, 2),
(87, 14, 3, 7),
(88, 14, 4, 7),
(89, 14, 6, 1),
(90, 14, 7, 1),
(91, 14, 5, 9);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]documentversion`
--

CREATE TABLE `[[dbprefix]]documentversion` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `fullName` varchar(200) DEFAULT NULL,
  `version` int(3) DEFAULT NULL COMMENT '3',
  `revision` int(3) DEFAULT NULL COMMENT '3',
  `draft` int(3) DEFAULT NULL COMMENT '3',
  `fileName` varchar(400) DEFAULT NULL,
  `mimeType` varchar(100) DEFAULT NULL,
  `fileSize` bigint(12) unsigned DEFAULT NULL,
  `link` varchar(400) DEFAULT NULL,
  `versionDate` date DEFAULT NULL,
  `createDateTime` datetime DEFAULT NULL,
  `updateDateTime` datetime DEFAULT NULL,
  `extension` varchar(100) DEFAULT NULL,
  `idDocument` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAuthor` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` varchar(2000) DEFAULT NULL,
  `isRef` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `approved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `disapproved` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `documentversionDocument` (`idDocument`),
  KEY `documentversionAuthor` (`idAuthor`),
  KEY `documentversionStatus` (`idStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]domainprospect`
--

CREATE TABLE `[[dbprefix]]domainprospect` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(12) unsigned NOT NULL COMMENT '12',
  `isPublic` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]domainprospect`
--

INSERT INTO `[[dbprefix]]domainprospect` VALUES
(1, NULL, 'Agri-food', 110, 0, 0),
(2, NULL, 'Finance', 120, 0, 0),
(3, NULL, 'Industry', 130, 0, 0),
(4, NULL, 'Construction', 140, 0, 0),
(5, NULL, 'Chemistry', 150, 0, 0),
(6, NULL, 'Trade', 160, 0, 0),
(7, NULL, 'Transportation', 170, 0, 0),
(8, NULL, 'Communication', 180, 0, 0),
(9, NULL, 'Information Technology', 190, 0, 0),
(10, NULL, 'Services', 200, 0, 0),
(11, NULL, 'Education', 910, 0, 0),
(12, NULL, 'Ministry', 920, 0, 0),
(13, NULL, 'Local public establishment', 930, 0, 0),
(14, NULL, 'Public establishment other', 940, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]efficiency`
--

CREATE TABLE `[[dbprefix]]efficiency` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]efficiency`
--

INSERT INTO `[[dbprefix]]efficiency` VALUES
(1, 'fully efficient', '#99FF99', 100, 0),
(2, 'partially efficient', '#87ceeb', 200, 0),
(3, 'not efficient', '#FF0000', 300, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]emailtemplate`
--

CREATE TABLE `[[dbprefix]]emailtemplate` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `title` varchar(500) DEFAULT NULL,
  `template` mediumtext,
  `idMailable` int(12) DEFAULT NULL COMMENT '12',
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `emailtemplateMailable` (`idMailable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]employeeleaveearned`
--

CREATE TABLE `[[dbprefix]]employeeleaveearned` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEmployee` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLeaveType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `lastUpdateDate` date DEFAULT NULL,
  `quantity` decimal(4,1) unsigned DEFAULT NULL,
  `leftQuantity` decimal(4,1) DEFAULT NULL,
  `leftQuantityBeforeClose` decimal(4,1) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `poseWithoutRights` int(1) unsigned DEFAULT '0' COMMENT '1',
  `acquisitionStartDate` date DEFAULT NULL,
  `acquisitionEndDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employeeleaveearnedEmployee` (`idEmployee`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]employeeleaveperiod`
--

CREATE TABLE `[[dbprefix]]employeeleaveperiod` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `comment` varchar(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `startAMPM` varchar(2) DEFAULT 'AM',
  `endDate` date DEFAULT NULL,
  `endAMPM` varchar(2) DEFAULT 'PM',
  `idLeaveType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEmployee` int(12) unsigned DEFAULT NULL COMMENT '12',
  `requestDateTime` datetime DEFAULT NULL,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `processingDateTime` datetime DEFAULT NULL,
  `nbDays` decimal(4,1) unsigned DEFAULT NULL,
  `submitted` int(1) unsigned DEFAULT '0' COMMENT '1',
  `rejected` int(1) unsigned DEFAULT '0' COMMENT '1',
  `accepted` int(1) unsigned DEFAULT '0' COMMENT '1',
  `statusOutOfWorkflow` int(1) unsigned DEFAULT '0' COMMENT '1',
  `statusSetLeaveChange` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `employeeleaveperiodEmployee` (`idEmployee`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]employeesmanaged`
--

CREATE TABLE `[[dbprefix]]employeesmanaged` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idEmployeeManager` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEmployee` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `employeesManagedEmployee` (`idEmployee`),
  KEY `employeesManagedEmployeeManager` (`idEmployeeManager`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]employmentcontract`
--

CREATE TABLE `[[dbprefix]]employmentcontract` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `mission` longtext,
  `idEmployee` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEmploymentContractType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEmploymentContractEndReason` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `employmentcontractEmployee` (`idEmployee`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]employmentcontractendreason`
--

CREATE TABLE `[[dbprefix]]employmentcontractendreason` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `final` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]employmentcontracttype`
--

CREATE TABLE `[[dbprefix]]employmentcontracttype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `name` varchar(100) NOT NULL,
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkflow` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idManagementType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isDefault` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]eventformail`
--

CREATE TABLE `[[dbprefix]]eventformail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]eventformail`
--

INSERT INTO `[[dbprefix]]eventformail` VALUES
(1, 'responsibleChange', 0, 60),
(2, 'noteAdd', 0, 20),
(3, 'attachmentAdd', 0, 10),
(4, 'noteChange', 0, 30),
(5, 'descriptionChange', 0, 70),
(6, 'resultChange', 0, 80),
(7, 'assignmentAdd', 0, 40),
(8, 'assignmentChange', 0, 50),
(9, 'anyChange', 0, 90),
(10, 'affectationAdd', 0, 51),
(11, 'affectationChange', 0, 52),
(12, 'linkAdd', 0, 53),
(13, 'linkDelete', 0, 54),
(14, 'statusChange', 0, 100),
(15, 'priorityChanged', 0, 105),
(16, 'newUserCreated', 0, 110);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]expense`
--

CREATE TABLE `[[dbprefix]]expense` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idExpenseType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `expensePlannedDate` date DEFAULT NULL,
  `expenseRealDate` date DEFAULT NULL,
  `plannedAmount` decimal(11,2) DEFAULT NULL,
  `realAmount` decimal(11,2) DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idDocument` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendDate` date DEFAULT NULL,
  `idDeliveryMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `deliveryDelay` varchar(100) DEFAULT NULL,
  `deliveryDate` date DEFAULT NULL,
  `paymentCondition` varchar(100) DEFAULT NULL,
  `receptionDate` date DEFAULT NULL,
  `result` mediumtext,
  `taxPct` decimal(5,2) DEFAULT NULL,
  `plannedFullAmount` decimal(11,2) DEFAULT '0.00',
  `realFullAmount` decimal(11,2) DEFAULT '0.00',
  `idleDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idResponsible` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedTaxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `isCalculated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `realTaxAmount` decimal(14,5) DEFAULT NULL,
  `idBudgetItem` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) DEFAULT NULL,
  `plannedAmountLocal` decimal(11,2) DEFAULT NULL,
  `plannedFullAmountLocal` decimal(11,2) DEFAULT NULL,
  `plannedTaxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `realAmountLocal` decimal(11,2) DEFAULT NULL,
  `realFullAmountLocal` decimal(11,2) DEFAULT NULL,
  `realTaxAmountLocal` decimal(14,5) DEFAULT NULL,
  `idPaymentDateMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `expenseProject` (`idProject`),
  KEY `expenseType` (`idExpenseType`),
  KEY `expenseUser` (`idUser`),
  KEY `expenseResource` (`idResource`),
  KEY `expenseStatus` (`idStatus`),
  KEY `expenseDay` (`day`),
  KEY `expenseWeek` (`week`),
  KEY `expenseMonth` (`month`),
  KEY `expenseYear` (`year`),
  KEY `expenseProvider` (`idProvider`),
  KEY `expenseResponsible` (`idResponsible`),
  KEY `expenseBudget` (`idBudgetItem`),
  KEY `expenseActivity` (`idActivity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]expensedetail`
--

CREATE TABLE `[[dbprefix]]expensedetail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `expenseDate` date DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idExpenseDetailType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value01` decimal(11,5) unsigned DEFAULT NULL,
  `value02` decimal(11,5) unsigned DEFAULT NULL,
  `value03` decimal(11,5) unsigned DEFAULT NULL,
  `unit01` varchar(20) DEFAULT NULL,
  `unit02` varchar(20) DEFAULT NULL,
  `unit03` varchar(20) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `amount` decimal(11,2) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `externalReference` varchar(100) DEFAULT NULL,
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `amountLocal` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expensedetailProject` (`idProject`),
  KEY `expensedetailExpenseDetailType` (`idExpenseDetailType`),
  KEY `expensedetailExpense` (`idExpense`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]expensedetailtype`
--

CREATE TABLE `[[dbprefix]]expensedetailtype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `value01` decimal(11,5) unsigned DEFAULT NULL,
  `value02` decimal(11,5) unsigned DEFAULT NULL,
  `value03` decimal(11,5) unsigned DEFAULT NULL,
  `unit01` varchar(20) DEFAULT NULL,
  `unit02` varchar(20) DEFAULT NULL,
  `unit03` varchar(20) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `description` mediumtext,
  `individual` int(1) unsigned DEFAULT '0' COMMENT '1',
  `project` int(1) unsigned DEFAULT '0' COMMENT '1',
  `activity` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]expensedetailtype`
--

INSERT INTO `[[dbprefix]]expensedetailtype` VALUES
(1, 'travel by car', 10, NULL, '0.54000', NULL, 'km', 'â‚¬/km', NULL, 0, NULL, 1, 0, 0),
(2, 'regular mission car travel', 20, NULL, NULL, '0.54000', 'days', 'km/day', 'â‚¬/km', 0, NULL, 1, 0, 0),
(3, 'lunch for guests', 30, NULL, NULL, NULL, 'guests', 'â‚¬/guest', NULL, 0, NULL, 1, 0, 0),
(4, 'justified expense', 40, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 1, 0, 0),
(5, 'detail', 50, NULL, NULL, NULL, 'units', 'â‚¬ per unit', NULL, 0, NULL, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extrahiddenfield`
--

CREATE TABLE `[[dbprefix]]extrahiddenfield` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `field` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extrareadonlyfield`
--

CREATE TABLE `[[dbprefix]]extrareadonlyfield` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `field` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extrarequiredfield`
--

CREATE TABLE `[[dbprefix]]extrarequiredfield` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `field` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorite`
--

CREATE TABLE `[[dbprefix]]favorite` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `favoriteUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favoriteparameter`
--

CREATE TABLE `[[dbprefix]]favoriteparameter` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idFavorite` int(12) unsigned DEFAULT NULL COMMENT '12',
  `parameterName` varchar(100) DEFAULT NULL,
  `parameterValue` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `favoriteParameterUser` (`idUser`),
  KEY `favoriteParameterReport` (`idReport`),
  KEY `favoriteParameterToday` (`idFavorite`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favoriteprojectitem`
--

CREATE TABLE `[[dbprefix]]favoriteprojectitem` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idFavoriteProjectList` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favoriteprojectlist`
--

CREATE TABLE `[[dbprefix]]favoriteprojectlist` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idFilter` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feasibility`
--

CREATE TABLE `[[dbprefix]]feasibility` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]feasibility`
--

INSERT INTO `[[dbprefix]]feasibility` VALUES
(1, 'Yes', '#00FF00', 100, 0),
(2, 'Investigate', '#AAAA00', 200, 0),
(3, 'No', '#FF0000', 300, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter`
--

CREATE TABLE `[[dbprefix]]filter` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isShared` int(1) unsigned DEFAULT NULL COMMENT '1',
  `isDynamic` int(1) DEFAULT '0' COMMENT '1',
  `sortOrder` int(12) DEFAULT NULL COMMENT '12',
  `idLayout` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isFavoriteProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isCommon` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `filterUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filtercriteria`
--

CREATE TABLE `[[dbprefix]]filtercriteria` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idFilter` int(12) unsigned DEFAULT NULL COMMENT '12',
  `dispAttribute` varchar(100) DEFAULT NULL,
  `dispOperator` varchar(100) DEFAULT NULL,
  `dispValue` varchar(4000) DEFAULT NULL,
  `sqlAttribute` varchar(100) DEFAULT NULL,
  `sqlOperator` varchar(100) DEFAULT NULL,
  `sqlValue` varchar(4000) DEFAULT NULL,
  `isDynamic` int(1) DEFAULT '0' COMMENT '1',
  `orOperator` int(1) DEFAULT '0' COMMENT '1',
  `isReportList` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isGroup` int(1) unsigned DEFAULT '0' COMMENT '1',
  `indentLevel` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `filtercriteriaFilter` (`idFilter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]globalview`
--

CREATE TABLE `[[dbprefix]]globalview` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `objectClass` varchar(100) DEFAULT NULL,
  `objectId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `result` mediumtext,
  `reference` varchar(100) DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `validatedEndDate` date DEFAULT NULL,
  `plannedEndDate` date DEFAULT NULL,
  `realEndDate` date DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]habilitation`
--

CREATE TABLE `[[dbprefix]]habilitation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `allowAccess` int(1) unsigned DEFAULT NULL COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `habilitationProfile` (`idProfile`),
  KEY `habilitationMenu` (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2256 ;

--
-- Dumping data for table `[[dbprefix]]habilitation`
--

INSERT INTO `[[dbprefix]]habilitation` VALUES
(1, 1, 14, 1),
(2, 1, 13, 1),
(3, 1, 21, 1),
(4, 1, 17, 1),
(5, 2, 20, 1),
(6, 1, 1, 1),
(7, 2, 1, 1),
(8, 3, 1, 1),
(9, 4, 1, 1),
(10, 6, 1, 1),
(11, 7, 1, 1),
(12, 5, 1, 1),
(13, 1, 2, 1),
(14, 2, 2, 1),
(15, 3, 2, 1),
(16, 4, 2, 1),
(17, 6, 2, 1),
(18, 7, 2, 1),
(19, 5, 2, 1),
(20, 1, 3, 1),
(21, 2, 3, 1),
(22, 3, 3, 1),
(23, 4, 3, 0),
(24, 6, 3, 1),
(25, 7, 3, 0),
(26, 5, 3, 0),
(27, 1, 4, 1),
(28, 2, 4, 1),
(29, 3, 4, 1),
(30, 4, 4, 1),
(31, 6, 4, 1),
(32, 7, 4, 1),
(33, 5, 4, 1),
(34, 1, 5, 1),
(35, 2, 5, 1),
(36, 3, 5, 1),
(37, 4, 5, 0),
(38, 6, 5, 0),
(39, 7, 5, 0),
(40, 5, 5, 0),
(41, 1, 6, 1),
(42, 2, 6, 1),
(43, 3, 6, 1),
(44, 4, 6, 1),
(45, 6, 6, 1),
(46, 7, 6, 1),
(47, 5, 6, 1),
(48, 1, 7, 1),
(49, 2, 7, 1),
(50, 3, 7, 1),
(51, 4, 7, 1),
(52, 6, 7, 1),
(53, 7, 7, 1),
(54, 5, 7, 1),
(55, 1, 8, 1),
(56, 2, 8, 1),
(57, 3, 8, 1),
(58, 4, 8, 1),
(59, 6, 8, 0),
(60, 7, 8, 0),
(61, 5, 8, 0),
(62, 1, 9, 1),
(63, 2, 9, 1),
(64, 3, 9, 1),
(65, 4, 9, 1),
(66, 6, 9, 1),
(67, 7, 9, 1),
(68, 5, 9, 1),
(76, 1, 11, 1),
(77, 2, 11, 1),
(78, 3, 11, 1),
(79, 4, 11, 1),
(80, 6, 11, 1),
(81, 7, 11, 1),
(82, 5, 11, 1),
(83, 1, 12, 0),
(84, 2, 12, 0),
(85, 3, 12, 0),
(86, 4, 12, 0),
(87, 6, 12, 0),
(88, 7, 12, 0),
(89, 5, 12, 0),
(90, 2, 13, 1),
(91, 3, 13, 1),
(92, 4, 13, 1),
(93, 6, 13, 1),
(94, 7, 13, 1),
(95, 5, 13, 1),
(96, 2, 14, 0),
(97, 3, 14, 1),
(98, 4, 14, 0),
(99, 6, 14, 0),
(100, 7, 14, 0),
(101, 5, 14, 0),
(102, 1, 15, 1),
(103, 2, 15, 0),
(104, 3, 15, 0),
(105, 4, 15, 0),
(106, 6, 15, 0),
(107, 7, 15, 0),
(108, 5, 15, 0),
(109, 1, 16, 1),
(110, 2, 16, 1),
(111, 3, 16, 1),
(112, 4, 16, 0),
(113, 6, 16, 0),
(114, 7, 16, 0),
(115, 5, 16, 0),
(116, 2, 17, 0),
(117, 3, 17, 0),
(118, 4, 17, 0),
(119, 6, 17, 0),
(120, 7, 17, 0),
(121, 5, 17, 0),
(122, 2, 21, 0),
(123, 3, 21, 0),
(124, 4, 21, 0),
(125, 6, 21, 0),
(126, 7, 21, 0),
(127, 5, 21, 0),
(128, 1, 18, 1),
(129, 2, 18, 0),
(130, 3, 18, 0),
(131, 4, 18, 0),
(132, 6, 18, 0),
(133, 7, 18, 0),
(134, 5, 18, 0),
(135, 1, 19, 0),
(136, 2, 19, 0),
(137, 3, 19, 0),
(138, 4, 19, 0),
(139, 6, 19, 0),
(140, 7, 19, 0),
(141, 5, 19, 0),
(142, 1, 20, 1),
(143, 3, 20, 1),
(144, 4, 20, 1),
(145, 6, 20, 1),
(146, 7, 20, 1),
(147, 5, 20, 1),
(148, 1, 22, 1),
(149, 2, 22, 1),
(150, 3, 22, 1),
(151, 4, 22, 1),
(152, 6, 22, 0),
(153, 7, 22, 0),
(154, 5, 22, 0),
(155, 1, 23, 0),
(156, 2, 23, 0),
(157, 3, 23, 0),
(158, 4, 23, 0),
(159, 6, 23, 0),
(160, 7, 23, 0),
(161, 5, 23, 0),
(162, 1, 24, 0),
(163, 2, 24, 0),
(164, 3, 24, 0),
(165, 4, 24, 0),
(166, 6, 24, 0),
(167, 7, 24, 0),
(168, 5, 24, 0),
(169, 1, 25, 1),
(170, 2, 25, 1),
(171, 3, 25, 1),
(172, 4, 25, 1),
(173, 6, 25, 1),
(174, 7, 25, 1),
(175, 5, 25, 0),
(176, 1, 26, 1),
(177, 2, 26, 1),
(178, 3, 26, 1),
(179, 4, 26, 1),
(180, 6, 26, 1),
(181, 7, 26, 1),
(182, 5, 26, 0),
(183, 1, 32, 0),
(184, 2, 32, 0),
(185, 3, 32, 0),
(186, 4, 32, 0),
(187, 6, 32, 0),
(188, 7, 32, 0),
(189, 5, 32, 0),
(190, 1, 33, 0),
(191, 2, 33, 0),
(192, 3, 33, 0),
(193, 4, 33, 0),
(194, 6, 33, 0),
(195, 7, 33, 0),
(196, 5, 33, 0),
(197, 1, 34, 1),
(198, 2, 34, 0),
(199, 3, 34, 0),
(200, 4, 34, 0),
(201, 6, 34, 0),
(202, 7, 34, 0),
(203, 5, 34, 0),
(204, 1, 36, 1),
(205, 2, 36, 0),
(206, 3, 36, 0),
(207, 4, 36, 0),
(208, 6, 36, 0),
(209, 7, 36, 0),
(210, 5, 36, 0),
(211, 1, 37, 1),
(212, 2, 37, 1),
(213, 3, 37, 1),
(214, 4, 37, 0),
(215, 6, 37, 0),
(216, 7, 37, 0),
(217, 5, 37, 0),
(218, 1, 38, 1),
(219, 2, 38, 0),
(220, 3, 38, 0),
(221, 4, 38, 0),
(222, 6, 38, 0),
(223, 7, 38, 0),
(224, 5, 38, 0),
(225, 1, 39, 1),
(226, 2, 39, 0),
(227, 3, 39, 0),
(228, 4, 39, 0),
(229, 6, 39, 0),
(230, 7, 39, 0),
(231, 5, 39, 0),
(232, 1, 40, 1),
(233, 2, 40, 0),
(234, 3, 40, 0),
(235, 4, 40, 0),
(236, 6, 40, 0),
(237, 7, 40, 0),
(238, 5, 40, 0),
(239, 1, 42, 1),
(240, 2, 42, 0),
(241, 3, 42, 0),
(242, 4, 42, 0),
(243, 6, 42, 0),
(244, 7, 42, 0),
(245, 5, 42, 0),
(246, 1, 41, 1),
(247, 2, 41, 0),
(248, 3, 41, 0),
(249, 4, 41, 0),
(250, 6, 41, 0),
(251, 7, 41, 0),
(252, 5, 41, 0),
(253, 1, 43, 1),
(254, 2, 43, 1),
(255, 3, 43, 1),
(256, 4, 43, 0),
(257, 6, 43, 1),
(258, 7, 43, 0),
(259, 5, 43, 0),
(260, 1, 44, 1),
(261, 2, 44, 0),
(262, 3, 44, 1),
(263, 4, 44, 0),
(264, 6, 44, 0),
(265, 7, 44, 0),
(266, 5, 44, 0),
(267, 1, 45, 1),
(268, 2, 45, 0),
(269, 3, 45, 0),
(270, 4, 45, 0),
(271, 6, 45, 0),
(272, 7, 45, 0),
(273, 5, 45, 0),
(274, 1, 46, 1),
(275, 2, 46, 0),
(276, 3, 46, 0),
(277, 4, 46, 0),
(278, 6, 46, 0),
(279, 7, 46, 0),
(280, 5, 46, 0),
(281, 1, 50, 1),
(282, 2, 50, 0),
(283, 3, 50, 1),
(284, 4, 50, 0),
(285, 6, 50, 0),
(286, 7, 50, 0),
(287, 5, 50, 0),
(288, 1, 49, 1),
(289, 2, 49, 0),
(290, 3, 49, 0),
(291, 4, 49, 0),
(292, 6, 49, 0),
(293, 7, 49, 0),
(294, 5, 49, 0),
(295, 1, 47, 1),
(296, 2, 47, 0),
(297, 3, 47, 0),
(298, 4, 47, 0),
(299, 6, 47, 0),
(300, 7, 47, 0),
(301, 5, 47, 0),
(302, 1, 48, 1),
(303, 2, 48, 0),
(304, 3, 48, 0),
(305, 4, 48, 0),
(306, 6, 48, 0),
(307, 7, 48, 0),
(308, 5, 48, 0),
(309, 1, 51, 1),
(310, 2, 51, 0),
(311, 3, 51, 1),
(312, 4, 51, 0),
(313, 6, 51, 0),
(314, 7, 51, 0),
(315, 5, 51, 0),
(316, 1, 52, 1),
(317, 2, 52, 0),
(318, 3, 52, 0),
(319, 4, 52, 0),
(320, 6, 52, 0),
(321, 7, 52, 0),
(322, 5, 52, 0),
(323, 1, 53, 1),
(324, 2, 53, 0),
(325, 3, 53, 0),
(326, 4, 53, 0),
(327, 6, 53, 0),
(328, 7, 53, 0),
(329, 5, 53, 0),
(330, 1, 55, 1),
(331, 2, 55, 0),
(332, 3, 55, 0),
(333, 4, 55, 0),
(334, 6, 55, 0),
(335, 7, 55, 0),
(336, 5, 55, 0),
(337, 1, 56, 1),
(338, 2, 56, 0),
(339, 3, 56, 0),
(340, 4, 56, 0),
(341, 6, 56, 0),
(342, 7, 56, 0),
(343, 5, 56, 0),
(344, 1, 57, 1),
(345, 2, 57, 0),
(346, 3, 57, 1),
(347, 4, 57, 0),
(348, 6, 57, 0),
(349, 7, 57, 0),
(350, 5, 57, 0),
(351, 1, 58, 1),
(352, 2, 58, 0),
(353, 3, 58, 0),
(354, 4, 58, 0),
(355, 5, 58, 0),
(356, 6, 58, 0),
(357, 7, 58, 0),
(358, 1, 59, 1),
(359, 1, 60, 1),
(360, 1, 61, 1),
(361, 2, 61, 1),
(362, 3, 61, 1),
(363, 1, 62, 1),
(364, 2, 62, 1),
(365, 3, 62, 1),
(366, 4, 62, 1),
(367, 6, 62, 1),
(368, 7, 62, 1),
(369, 5, 62, 1),
(370, 1, 63, 1),
(371, 2, 63, 1),
(372, 3, 63, 1),
(373, 4, 63, 1),
(374, 6, 63, 1),
(375, 7, 63, 1),
(376, 5, 63, 1),
(377, 1, 64, 1),
(378, 2, 64, 1),
(379, 3, 64, 1),
(380, 4, 64, 1),
(381, 6, 64, 1),
(382, 7, 64, 1),
(383, 5, 64, 1),
(384, 1, 65, 1),
(385, 2, 65, 0),
(386, 3, 65, 0),
(387, 4, 65, 0),
(388, 6, 65, 0),
(389, 7, 65, 0),
(390, 5, 65, 0),
(391, 1, 66, 1),
(392, 2, 66, 0),
(393, 3, 66, 0),
(394, 4, 66, 0),
(395, 6, 66, 0),
(396, 7, 66, 0),
(397, 5, 66, 0),
(398, 1, 67, 1),
(399, 2, 67, 0),
(400, 3, 67, 0),
(401, 4, 67, 0),
(402, 6, 67, 0),
(403, 7, 67, 0),
(404, 5, 67, 0),
(405, 1, 68, 1),
(406, 2, 68, 0),
(407, 3, 68, 0),
(408, 4, 68, 0),
(409, 6, 68, 0),
(410, 7, 68, 0),
(411, 5, 68, 0),
(412, 1, 69, 1),
(413, 2, 69, 0),
(414, 3, 69, 1),
(415, 4, 69, 1),
(416, 6, 69, 0),
(417, 7, 69, 0),
(418, 5, 69, 0),
(419, 1, 70, 1),
(420, 2, 70, 0),
(421, 3, 70, 0),
(422, 4, 70, 0),
(423, 6, 70, 0),
(424, 7, 70, 0),
(425, 1, 71, 1),
(426, 2, 71, 0),
(427, 3, 71, 0),
(428, 4, 71, 0),
(429, 6, 71, 0),
(430, 7, 71, 0),
(431, 1, 72, 1),
(432, 1, 73, 1),
(433, 1, 74, 1),
(434, 2, 74, 1),
(435, 3, 74, 1),
(436, 1, 75, 1),
(437, 2, 75, 1),
(438, 3, 75, 1),
(439, 4, 75, 1),
(440, 1, 76, 1),
(441, 2, 76, 1),
(442, 3, 76, 1),
(443, 1, 77, 0),
(444, 2, 77, 0),
(445, 3, 77, 0),
(449, 1, 79, 1),
(450, 2, 79, 1),
(451, 3, 79, 0),
(452, 1, 80, 1),
(453, 1, 81, 1),
(454, 1, 82, 0),
(455, 2, 82, 0),
(458, 1, 84, 1),
(459, 1, 85, 1),
(460, 2, 85, 0),
(461, 3, 85, 1),
(462, 1, 86, 1),
(463, 2, 86, 1),
(464, 3, 86, 1),
(465, 1, 87, 1),
(466, 2, 87, 1),
(467, 3, 87, 1),
(468, 1, 88, 1),
(469, 2, 88, 1),
(470, 3, 88, 1),
(471, 1, 89, 1),
(472, 2, 89, 1),
(473, 3, 89, 1),
(474, 1, 90, 1),
(475, 2, 90, 1),
(476, 3, 90, 1),
(477, 1, 91, 1),
(478, 2, 91, 1),
(479, 3, 91, 1),
(480, 4, 91, 1),
(481, 5, 91, 1),
(482, 6, 91, 1),
(483, 7, 91, 1),
(485, 1, 92, 1),
(486, 1, 93, 1),
(487, 1, 94, 1),
(488, 2, 94, 1),
(489, 3, 94, 1),
(490, 1, 95, 1),
(491, 1, 96, 1),
(492, 2, 96, 1),
(493, 3, 96, 1),
(494, 1, 97, 1),
(495, 2, 97, 1),
(496, 3, 97, 1),
(497, 1, 98, 1),
(498, 1, 99, 1),
(499, 1, 100, 1),
(500, 1, 101, 1),
(501, 1, 102, 1),
(502, 2, 102, 1),
(503, 3, 102, 1),
(504, 4, 102, 1),
(505, 6, 102, 1),
(506, 7, 102, 1),
(507, 1, 103, 1),
(508, 3, 103, 1),
(509, 1, 104, 1),
(511, 1, 105, 1),
(512, 1, 106, 1),
(513, 2, 106, 1),
(514, 3, 106, 1),
(515, 4, 106, 1),
(516, 5, 106, 1),
(517, 6, 106, 1),
(518, 7, 106, 1),
(519, 1, 107, 1),
(520, 2, 107, 0),
(521, 3, 107, 0),
(522, 4, 107, 0),
(523, 5, 107, 0),
(524, 6, 107, 0),
(525, 7, 107, 0),
(526, 1, 108, 1),
(527, 2, 108, 0),
(528, 3, 108, 0),
(529, 4, 108, 0),
(530, 5, 108, 0),
(531, 6, 108, 0),
(532, 7, 108, 0),
(533, 1, 109, 1),
(534, 2, 109, 0),
(535, 3, 109, 0),
(536, 4, 109, 0),
(537, 5, 109, 0),
(538, 6, 109, 0),
(539, 7, 109, 0),
(540, 1, 111, 1),
(541, 2, 111, 1),
(542, 3, 111, 1),
(543, 4, 111, 1),
(544, 5, 111, 1),
(545, 6, 111, 1),
(546, 7, 111, 1),
(547, 1, 112, 1),
(548, 2, 112, 1),
(549, 3, 112, 1),
(550, 4, 112, 1),
(551, 5, 112, 1),
(552, 6, 112, 1),
(553, 7, 112, 1),
(554, 1, 113, 1),
(555, 2, 113, 1),
(556, 3, 113, 1),
(557, 4, 113, 1),
(558, 5, 113, 1),
(559, 6, 113, 1),
(560, 7, 113, 1),
(561, 1, 114, 1),
(562, 2, 114, 0),
(563, 3, 114, 0),
(564, 4, 114, 0),
(565, 5, 114, 0),
(566, 6, 114, 0),
(567, 7, 114, 0),
(568, 1, 115, 1),
(569, 2, 115, 0),
(570, 3, 115, 0),
(571, 4, 115, 0),
(572, 5, 115, 0),
(573, 6, 115, 0),
(574, 7, 115, 0),
(575, 1, 116, 1),
(576, 2, 116, 0),
(577, 3, 116, 0),
(578, 4, 116, 0),
(579, 5, 116, 0),
(580, 6, 116, 0),
(581, 7, 116, 0),
(582, 1, 117, 1),
(583, 2, 117, 0),
(584, 3, 117, 0),
(585, 4, 117, 0),
(586, 5, 117, 0),
(587, 6, 117, 0),
(588, 7, 117, 0),
(589, 1, 118, 0),
(590, 2, 118, 0),
(591, 3, 118, 0),
(592, 4, 118, 0),
(593, 5, 118, 1),
(594, 6, 118, 1),
(595, 7, 118, 1),
(596, 1, 119, 1),
(597, 2, 119, 1),
(598, 3, 119, 1),
(599, 4, 119, 0),
(600, 6, 119, 1),
(601, 7, 119, 0),
(602, 5, 119, 0),
(603, 1, 120, 1),
(604, 2, 120, 0),
(605, 3, 120, 0),
(606, 4, 120, 0),
(607, 6, 120, 0),
(608, 7, 120, 0),
(609, 5, 120, 0),
(610, 1, 121, 1),
(611, 2, 121, 0),
(612, 3, 121, 0),
(613, 4, 121, 0),
(614, 5, 121, 0),
(615, 6, 121, 0),
(616, 7, 121, 0),
(617, 1, 122, 1),
(618, 2, 122, 0),
(619, 3, 122, 0),
(620, 4, 122, 0),
(621, 5, 122, 0),
(622, 6, 122, 0),
(623, 7, 122, 0),
(624, 1, 123, 1),
(625, 2, 123, 1),
(626, 3, 123, 1),
(627, 4, 123, 0),
(628, 5, 123, 0),
(629, 6, 123, 0),
(630, 7, 123, 0),
(631, 1, 124, 1),
(632, 2, 124, 1),
(633, 3, 124, 1),
(634, 4, 124, 1),
(635, 6, 124, 1),
(636, 7, 124, 1),
(637, 5, 124, 1),
(638, 1, 125, 1),
(639, 2, 125, 1),
(640, 3, 125, 1),
(641, 4, 125, 0),
(642, 5, 125, 0),
(643, 6, 125, 0),
(644, 7, 125, 0),
(645, 1, 126, 1),
(646, 2, 126, 0),
(647, 3, 126, 0),
(648, 4, 126, 0),
(649, 5, 126, 0),
(650, 6, 126, 0),
(651, 7, 126, 0),
(652, 1, 127, 1),
(653, 2, 127, 0),
(654, 3, 127, 0),
(655, 4, 127, 0),
(656, 5, 127, 0),
(657, 6, 127, 0),
(658, 7, 127, 0),
(659, 1, 128, 1),
(660, 2, 128, 0),
(661, 3, 128, 0),
(662, 4, 128, 0),
(663, 5, 128, 0),
(664, 6, 128, 0),
(665, 7, 128, 0),
(666, 1, 129, 1),
(667, 2, 129, 0),
(668, 3, 129, 0),
(669, 4, 129, 0),
(670, 5, 129, 0),
(671, 6, 129, 0),
(672, 7, 129, 0),
(673, 1, 130, 1),
(674, 2, 130, 0),
(675, 3, 130, 0),
(676, 4, 130, 0),
(677, 5, 130, 0),
(678, 6, 130, 0),
(679, 7, 130, 0),
(680, 1, 131, 1),
(681, 2, 131, 1),
(682, 3, 131, 1),
(683, 4, 131, 0),
(684, 5, 131, 0),
(685, 6, 131, 0),
(686, 7, 131, 0),
(687, 1, 132, 1),
(688, 2, 132, 0),
(689, 3, 132, 0),
(690, 4, 132, 0),
(691, 5, 132, 0),
(692, 6, 132, 0),
(693, 7, 132, 0),
(694, 1, 133, 1),
(695, 2, 133, 1),
(696, 3, 133, 1),
(697, 4, 133, 1),
(698, 5, 133, 0),
(699, 6, 133, 0),
(700, 7, 133, 0),
(701, 1, 134, 1),
(702, 2, 134, 0),
(703, 3, 134, 0),
(704, 4, 134, 0),
(705, 5, 134, 0),
(706, 6, 134, 0),
(707, 7, 134, 0),
(708, 1, 135, 1),
(709, 2, 135, 0),
(710, 3, 135, 0),
(711, 4, 135, 0),
(712, 5, 135, 0),
(713, 6, 135, 0),
(714, 7, 135, 0),
(715, 1, 136, 1),
(716, 2, 136, 0),
(717, 3, 136, 0),
(718, 4, 136, 0),
(719, 5, 136, 0),
(720, 6, 136, 0),
(721, 7, 136, 0),
(722, 1, 137, 1),
(723, 2, 137, 0),
(724, 3, 137, 0),
(725, 4, 137, 0),
(726, 5, 137, 0),
(727, 6, 137, 0),
(728, 7, 137, 0),
(729, 1, 138, 1),
(730, 2, 138, 0),
(731, 3, 138, 0),
(732, 4, 138, 0),
(733, 5, 138, 0),
(734, 6, 138, 0),
(735, 7, 138, 0),
(736, 1, 139, 1),
(737, 2, 139, 0),
(738, 3, 139, 0),
(739, 4, 139, 0),
(740, 5, 139, 0),
(741, 6, 139, 0),
(742, 7, 139, 0),
(743, 1, 140, 1),
(744, 2, 140, 0),
(745, 3, 140, 0),
(746, 4, 140, 0),
(747, 5, 140, 0),
(748, 6, 140, 0),
(749, 7, 140, 0),
(750, 1, 78, 1),
(751, 2, 78, 1),
(752, 3, 78, 1),
(753, 4, 78, 0),
(754, 5, 78, 0),
(755, 6, 78, 0),
(756, 7, 78, 0),
(757, 1, 83, 1),
(758, 2, 83, 0),
(759, 3, 83, 0),
(760, 4, 83, 0),
(761, 5, 83, 0),
(762, 6, 83, 0),
(763, 7, 83, 0),
(764, 1, 141, 1),
(765, 2, 141, 1),
(766, 3, 141, 1),
(767, 4, 141, 0),
(768, 5, 141, 0),
(769, 6, 141, 0),
(770, 7, 141, 0),
(771, 1, 142, 1),
(772, 2, 142, 1),
(773, 3, 142, 1),
(774, 4, 142, 0),
(775, 5, 142, 0),
(776, 6, 142, 0),
(777, 7, 142, 0),
(778, 1, 143, 1),
(779, 2, 143, 0),
(780, 3, 143, 0),
(781, 4, 143, 0),
(782, 5, 143, 0),
(783, 6, 143, 0),
(784, 7, 143, 0),
(785, 1, 144, 1),
(786, 2, 144, 0),
(787, 3, 144, 0),
(788, 4, 144, 0),
(789, 5, 144, 0),
(790, 6, 144, 0),
(791, 7, 144, 0),
(792, 1, 145, 1),
(793, 2, 145, 0),
(794, 3, 145, 0),
(795, 4, 145, 0),
(796, 5, 145, 0),
(797, 6, 145, 0),
(798, 7, 145, 0),
(799, 1, 146, 1),
(800, 2, 146, 1),
(801, 3, 146, 1),
(802, 4, 146, 0),
(803, 5, 146, 0),
(804, 6, 146, 0),
(805, 7, 146, 0),
(806, 1, 150, 1),
(807, 2, 150, 1),
(808, 3, 150, 1),
(809, 4, 150, 1),
(810, 5, 150, 0),
(811, 6, 150, 0),
(812, 7, 150, 0),
(813, 1, 147, 1),
(814, 2, 147, 0),
(815, 3, 147, 0),
(816, 4, 147, 0),
(817, 5, 147, 0),
(818, 6, 147, 0),
(819, 7, 147, 0),
(820, 1, 148, 1),
(821, 2, 148, 0),
(822, 3, 148, 0),
(823, 4, 148, 0),
(824, 5, 148, 0),
(825, 6, 148, 0),
(826, 7, 148, 0),
(827, 1, 149, 1),
(828, 2, 149, 0),
(829, 3, 149, 0),
(830, 4, 149, 0),
(831, 5, 149, 0),
(832, 6, 149, 0),
(833, 7, 149, 0),
(834, 1, 153, 1),
(835, 2, 153, 1),
(836, 3, 153, 1),
(837, 4, 153, 0),
(838, 5, 153, 0),
(839, 6, 153, 0),
(840, 7, 153, 0),
(841, 1, 154, 1),
(842, 2, 154, 1),
(843, 3, 154, 1),
(844, 4, 154, 0),
(845, 5, 154, 0),
(846, 6, 154, 0),
(847, 7, 154, 0),
(848, 1, 155, 1),
(849, 2, 155, 0),
(850, 3, 155, 0),
(851, 4, 155, 0),
(852, 5, 155, 0),
(853, 6, 155, 0),
(854, 7, 155, 0),
(855, 1, 156, 1),
(856, 2, 156, 0),
(857, 3, 156, 0),
(858, 4, 156, 0),
(859, 5, 156, 0),
(860, 6, 156, 0),
(861, 7, 156, 0),
(862, 1, 157, 1),
(863, 2, 157, 0),
(864, 3, 157, 0),
(865, 4, 157, 0),
(866, 6, 157, 0),
(867, 7, 157, 0),
(868, 5, 157, 0),
(869, 1, 158, 1),
(870, 2, 158, 1),
(871, 1, 159, 1),
(872, 1, 160, 1),
(873, 1, 161, 1),
(874, 1, 162, 1),
(875, 1, 163, 1),
(876, 1, 164, 1),
(877, 1, 165, 1),
(878, 1, 166, 1),
(879, 1, 167, 1),
(880, 2, 167, 1),
(881, 3, 167, 1),
(882, 1, 168, 1),
(883, 2, 168, 2),
(884, 3, 168, 3),
(885, 1, 169, 1),
(886, 1, 171, 1),
(887, 1, 172, 1),
(888, 1, 170, 1),
(889, 1, 174, 1),
(890, 2, 174, 1),
(891, 1, 175, 1),
(892, 2, 175, 0),
(893, 3, 175, 0),
(894, 4, 175, 0),
(895, 5, 175, 0),
(896, 6, 175, 0),
(897, 7, 175, 0),
(898, 1, 176, 1),
(899, 2, 176, 1),
(900, 3, 176, 1),
(901, 1, 177, 1),
(902, 2, 177, 1),
(903, 3, 177, 1),
(904, 4, 177, 1),
(905, 5, 177, 0),
(906, 6, 177, 0),
(907, 7, 177, 0),
(908, 1, 178, 1),
(909, 1, 179, 1),
(910, 2, 179, 1),
(911, 3, 179, 1),
(912, 1, 180, 1),
(913, 2, 180, 0),
(914, 3, 180, 0),
(915, 4, 180, 0),
(916, 5, 180, 0),
(917, 6, 180, 0),
(918, 7, 180, 0),
(919, 8, 180, 0),
(920, 1, 181, 1),
(921, 2, 181, 1),
(922, 3, 181, 1),
(923, 4, 181, 0),
(924, 5, 181, 0),
(925, 6, 181, 0),
(926, 7, 181, 0),
(927, 8, 181, 0),
(928, 1, 182, 1),
(929, 2, 182, 1),
(930, 3, 182, 1),
(931, 4, 182, 0),
(932, 5, 182, 0),
(933, 6, 182, 0),
(934, 7, 182, 0),
(935, 8, 182, 0),
(936, 1, 183, 1),
(937, 1, 184, 1),
(938, 1, 185, 1),
(939, 1, 186, 1),
(940, 2, 185, 1),
(941, 3, 185, 1),
(942, 4, 185, 1),
(943, 5, 185, 1),
(944, 6, 185, 1),
(945, 7, 185, 1),
(946, 1, 187, 1),
(947, 1, 188, 1),
(948, 3, 188, 1),
(949, 1, 189, 1),
(950, 2, 189, 1),
(951, 3, 189, 1),
(952, 1, 190, 1),
(953, 1, 191, 1),
(954, 2, 191, 1),
(955, 3, 191, 1),
(956, 1, 193, 1),
(957, 1, 194, 1),
(958, 2, 194, 1),
(959, 3, 194, 1),
(960, 1, 195, 1),
(961, 2, 195, 1),
(962, 3, 195, 1),
(963, 1, 201, 1),
(964, 2, 201, 1),
(965, 3, 201, 1),
(966, 1, 202, 1),
(967, 1, 197, 1),
(968, 2, 197, 1),
(969, 1, 198, 1),
(970, 1, 199, 1),
(971, 1, 200, 1),
(972, 1, 192, 1),
(973, 2, 192, 1),
(974, 3, 192, 1),
(975, 4, 192, 1),
(976, 1, 196, 1),
(977, 2, 196, 1),
(978, 3, 196, 1),
(979, 4, 196, 1),
(980, 1, 203, 1),
(981, 2, 203, 1),
(982, 3, 203, 1),
(983, 4, 203, 1),
(984, 1, 204, 1),
(985, 2, 204, 1),
(986, 3, 204, 1),
(987, 1, 205, 1),
(988, 2, 205, 1),
(989, 3, 205, 1),
(990, 4, 205, 1),
(991, 5, 205, 1),
(992, 6, 205, 1),
(993, 7, 205, 1),
(994, 1, 221, 1),
(995, 1, 223, 1),
(996, 1, 222, 1),
(997, 2, 222, 1),
(998, 3, 222, 1),
(999, 4, 222, 0),
(1000, 5, 222, 0),
(1001, 6, 222, 0),
(1002, 7, 222, 0),
(1003, 1, 224, 1),
(1004, 1, 225, 1),
(1005, 2, 225, 1),
(1006, 3, 225, 1),
(1007, 1, 226, 1),
(1008, 1, 227, 1),
(1009, 2, 227, 1),
(1010, 3, 227, 1),
(1011, 1, 228, 1),
(1012, 2, 228, 1),
(1013, 1, 229, 1),
(1014, 1, 231, 1),
(1015, 1, 232, 1),
(1016, 2, 232, 1),
(1017, 1, 233, 1),
(1018, 2, 233, 1),
(1019, 1, 234, 1),
(1020, 2, 234, 1),
(1021, 1, 235, 1),
(1022, 2, 235, 1),
(1023, 1, 236, 1),
(1024, 1, 244, 1),
(1025, 2, 244, 1),
(1026, 3, 244, 1),
(1027, 1, 245, 1),
(1028, 2, 245, 1),
(1029, 3, 245, 1),
(1030, 1, 246, 1),
(1031, 2, 246, 1),
(1032, 3, 246, 1),
(1033, 1, 247, 1),
(1034, 2, 247, 1),
(1035, 3, 247, 1),
(1036, 1, 249, 1),
(1037, 1, 243, 1),
(1038, 1, 237, 1),
(1039, 1, 238, 1),
(1040, 1, 239, 1),
(1041, 1, 240, 1),
(1042, 1, 248, 1),
(1043, 1, 241, 1),
(1044, 2, 243, 1),
(1045, 2, 237, 1),
(1046, 2, 238, 1),
(1047, 2, 239, 1),
(1048, 2, 240, 1),
(1049, 2, 248, 1),
(1050, 2, 241, 1),
(1051, 3, 237, 1),
(1052, 1, 250, 1),
(1053, 1, 251, 1),
(1054, 1, 252, 1),
(1055, 2, 252, 1),
(1056, 3, 252, 1),
(1057, 1, 253, 1),
(1058, 2, 253, 1),
(1059, 3, 253, 1),
(1060, 4, 253, 1),
(1061, 1, 254, 1),
(1062, 2, 254, 1),
(1063, 3, 254, 1),
(1064, 1, 255, 1),
(1065, 2, 255, 1),
(1066, 3, 255, 1),
(1067, 1, 256, 1),
(1068, 1, 257, 1),
(1069, 2, 257, 1),
(1070, 3, 257, 1),
(1071, 1, 258, 1),
(1072, 2, 258, 1),
(1073, 3, 258, 1),
(1074, 1, 259, 1),
(1075, 2, 259, 1),
(1076, 3, 259, 1),
(1077, 1, 268, 1),
(1078, 2, 268, 0),
(1079, 3, 268, 0),
(1080, 1, 269, 1),
(1081, 2, 269, 0),
(1082, 3, 269, 0),
(1083, 1, 260, 1),
(1084, 2, 260, 1),
(1085, 3, 260, 1),
(1086, 4, 260, 1),
(1087, 5, 260, 1),
(1088, 6, 260, 1),
(1089, 7, 260, 1),
(1090, 1, 261, 1),
(1091, 1, 262, 1),
(1092, 1, 263, 1),
(1093, 1, 264, 1),
(1094, 2, 261, 1),
(1095, 2, 262, 1),
(1096, 2, 263, 1),
(1097, 2, 264, 1),
(1098, 3, 261, 1),
(1099, 3, 262, 1),
(1100, 3, 263, 1),
(1101, 3, 264, 1),
(1102, 4, 261, 1),
(1103, 4, 262, 1),
(1104, 4, 263, 1),
(1105, 4, 264, 0),
(1106, 1, 265, 1),
(1107, 1, 266, 1),
(1108, 1, 267, 1),
(1109, 1, 270, 1),
(1110, 2, 270, 1),
(1111, 3, 270, 1),
(1112, 1, 271, 1),
(1113, 2, 271, 1),
(1114, 3, 271, 1),
(1115, 1, 272, 1),
(1116, 1, 273, 1),
(1117, 1, 274, 1),
(1118, 2, 274, 1),
(1119, 3, 274, 1),
(1120, 1, 275, 1),
(1121, 2, 275, 1),
(1122, 3, 275, 1),
(1123, 1, 276, 1),
(1124, 2, 276, 1),
(1125, 3, 276, 1),
(1126, 1, 277, 1),
(1127, 2, 277, 1),
(1128, 3, 277, 1),
(1129, 1, 281, 1),
(1130, 2, 281, 1),
(1131, 3, 281, 1),
(1132, 1, 278, 1),
(1133, 1, 279, 1),
(1134, 1, 280, 1),
(1135, 1, 282, 1),
(1136, 2, 282, 1),
(1137, 3, 282, 1),
(1138, 1, 283, 1),
(1139, 2, 283, 1),
(1140, 3, 283, 1),
(1141, 1, 284, 1),
(1142, 2, 284, 1),
(1143, 3, 284, 1),
(1144, 4, 284, 1),
(1145, 5, 284, 1),
(1146, 6, 284, 1),
(1147, 7, 284, 1),
(1148, 1, 285, 1),
(1149, 3, 285, 1),
(1150, 1, 286, 1),
(1151, 3, 286, 1),
(1152, 1, 287, 1),
(1153, 3, 287, 1),
(1154, 1, 288, 1),
(1155, 3, 288, 0),
(1156, 2, 287, 1),
(1157, 2, 288, 1),
(1158, 1, 289, 1),
(1159, 1, 290, 1),
(1160, 2, 290, 1),
(1161, 3, 290, 1),
(1162, 4, 290, 1),
(1163, 1, 291, 1),
(1164, 1, 292, 1),
(1165, 2, 292, 1),
(1166, 3, 292, 1),
(1167, 4, 292, 1),
(1168, 1, 293, 1),
(1169, 1, 294, 1),
(1170, 2, 294, 1),
(1171, 3, 294, 1),
(1172, 4, 294, 1),
(1173, 1, 295, 1),
(1174, 1, 300, 1),
(1175, 1, 301, 1),
(1176, 2, 301, 1),
(1177, 3, 301, 1),
(1178, 4, 301, 1),
(1179, 1, 302, 1),
(1180, 1, 303, 1),
(1181, 2, 303, 1),
(1182, 3, 303, 1),
(1183, 4, 303, 1),
(1184, 1, 304, 1),
(1185, 2, 304, 1),
(1186, 3, 304, 1),
(1187, 4, 304, 1),
(1188, 1, 305, 1),
(1189, 2, 305, 1),
(1190, 3, 305, 1),
(1191, 4, 305, 1),
(1192, 1, 306, 1),
(1193, 2, 306, 1),
(1194, 3, 306, 1),
(1195, 4, 306, 1),
(1196, 1, 307, 1),
(1197, 2, 307, 1),
(1198, 3, 307, 1),
(1199, 4, 307, 1),
(1200, 1, 308, 1),
(1201, 1, 309, 1),
(1202, 1, 311, 1),
(1203, 2, 311, 1),
(1204, 3, 311, 1),
(1205, 1, 312, 1),
(1206, 1, 310, 1),
(1207, 2, 310, 1),
(1208, 3, 310, 1),
(1209, 1, 313, 1),
(1210, 2, 313, 1),
(1211, 3, 313, 1),
(1212, 4, 313, 1),
(1213, 5, 313, 1),
(1214, 6, 313, 1),
(1215, 7, 313, 1),
(1216, 1, 314, 1),
(1217, 2, 314, 1),
(1218, 3, 314, 1),
(1219, 4, 314, 1),
(1220, 6, 314, 1),
(1221, 7, 314, 1),
(1222, 5, 314, 1),
(1223, 1, 315, 1),
(1224, 2, 315, 1),
(1225, 3, 315, 1),
(1226, 1, 316, 1),
(1227, 2, 316, 1),
(1228, 3, 316, 1),
(1229, 1, 100006001, 1),
(1230, 2, 100006001, 1),
(1231, 3, 100006001, 1),
(1232, 4, 100006001, 1),
(1233, 4, 74, 1),
(1234, 5, 74, 0),
(1235, 6, 74, 0),
(1236, 7, 74, 0),
(1237, 4, 88, 0),
(1238, 5, 88, 0),
(1239, 6, 88, 0),
(1240, 7, 88, 0),
(1241, 2, 92, 0),
(1242, 3, 92, 0),
(1243, 4, 92, 0),
(1244, 5, 92, 0),
(1245, 6, 92, 0),
(1246, 7, 92, 0),
(1247, 5, 102, 0),
(1248, 1, 110, 1),
(1249, 2, 110, 1),
(1250, 3, 110, 1),
(1251, 4, 110, 1),
(1252, 5, 110, 1),
(1253, 6, 110, 1),
(1254, 7, 110, 1),
(1255, 3, 158, 0),
(1256, 4, 158, 0),
(1257, 5, 158, 0),
(1258, 6, 158, 0),
(1259, 7, 158, 0),
(1260, 1, 173, 1),
(1261, 2, 173, 1),
(1262, 3, 173, 1),
(1263, 4, 173, 0),
(1264, 5, 173, 0),
(1265, 6, 173, 0),
(1266, 7, 173, 0),
(1267, 1, 208, 1),
(1268, 2, 208, 1),
(1269, 3, 208, 1),
(1270, 4, 208, 0),
(1271, 5, 208, 0),
(1272, 6, 208, 0),
(1273, 7, 208, 0),
(1274, 3, 243, 1),
(1275, 4, 243, 0),
(1276, 5, 243, 0),
(1277, 6, 243, 0),
(1278, 7, 243, 0),
(1279, 5, 261, 0),
(1280, 6, 261, 0),
(1281, 7, 261, 0),
(1282, 2, 289, 0),
(1283, 3, 289, 0),
(1284, 4, 289, 0),
(1285, 5, 289, 0),
(1286, 6, 289, 0),
(1287, 7, 289, 0),
(1288, 2, 300, 0),
(1289, 3, 300, 0),
(1290, 4, 300, 0),
(1291, 5, 300, 0),
(1292, 6, 300, 0),
(1293, 7, 300, 0),
(1294, 5, 100006001, 0),
(1295, 6, 100006001, 0),
(1296, 7, 100006001, 0),
(1297, 5, 192, 0),
(1298, 6, 192, 0),
(1299, 7, 192, 0),
(1300, 4, 167, 0),
(1301, 5, 167, 0),
(1302, 6, 167, 0),
(1303, 7, 167, 0),
(1304, 4, 168, 0),
(1305, 5, 168, 0),
(1306, 6, 168, 0),
(1307, 7, 168, 0),
(1308, 4, 176, 0),
(1309, 5, 176, 0),
(1310, 6, 176, 0),
(1311, 7, 176, 0),
(1312, 4, 225, 0),
(1313, 5, 225, 0),
(1314, 6, 225, 0),
(1315, 7, 225, 0),
(1316, 4, 270, 0),
(1317, 5, 270, 0),
(1318, 6, 270, 0),
(1319, 7, 270, 0),
(1320, 4, 271, 0),
(1321, 5, 271, 0),
(1322, 6, 271, 0),
(1323, 7, 271, 0),
(1324, 4, 311, 0),
(1325, 5, 311, 0),
(1326, 6, 311, 0),
(1327, 7, 311, 0),
(1328, 4, 61, 0),
(1329, 5, 61, 0),
(1330, 6, 61, 0),
(1331, 7, 61, 0),
(1332, 5, 196, 0),
(1333, 6, 196, 0),
(1334, 7, 196, 0),
(1335, 5, 203, 0),
(1336, 6, 203, 0),
(1337, 7, 203, 0),
(1338, 4, 204, 0),
(1339, 5, 204, 0),
(1340, 6, 204, 0),
(1341, 7, 204, 0),
(1342, 4, 252, 0),
(1343, 5, 252, 0),
(1344, 6, 252, 0),
(1345, 7, 252, 0),
(1346, 5, 253, 0),
(1347, 6, 253, 0),
(1348, 7, 253, 0),
(1349, 4, 254, 0),
(1350, 5, 254, 0),
(1351, 6, 254, 0),
(1352, 7, 254, 0),
(1353, 4, 257, 0),
(1354, 5, 257, 0),
(1355, 6, 257, 0),
(1356, 7, 257, 0),
(1357, 4, 259, 0),
(1358, 5, 259, 0),
(1359, 6, 259, 0),
(1360, 7, 259, 0),
(1361, 2, 278, 0),
(1362, 3, 278, 0),
(1363, 4, 278, 0),
(1364, 5, 278, 0),
(1365, 6, 278, 0),
(1366, 7, 278, 0),
(1367, 2, 279, 0),
(1368, 3, 279, 0),
(1369, 4, 279, 0),
(1370, 5, 279, 0),
(1371, 6, 279, 0),
(1372, 7, 279, 0),
(1373, 2, 280, 0),
(1374, 3, 280, 0),
(1375, 4, 280, 0),
(1376, 5, 280, 0),
(1377, 6, 280, 0),
(1378, 7, 280, 0),
(1379, 4, 282, 0),
(1380, 5, 282, 0),
(1381, 6, 282, 0),
(1382, 7, 282, 0),
(1383, 4, 283, 0),
(1384, 5, 283, 0),
(1385, 6, 283, 0),
(1386, 7, 283, 0),
(1387, 5, 290, 0),
(1388, 6, 290, 0),
(1389, 7, 290, 0),
(1390, 5, 292, 0),
(1391, 6, 292, 0),
(1392, 7, 292, 0),
(1393, 5, 294, 0),
(1394, 6, 294, 0),
(1395, 7, 294, 0),
(1396, 5, 301, 0),
(1397, 6, 301, 0),
(1398, 7, 301, 0),
(1399, 5, 303, 0),
(1400, 6, 303, 0),
(1401, 7, 303, 0),
(1402, 5, 304, 0),
(1403, 6, 304, 0),
(1404, 7, 304, 0),
(1405, 5, 305, 0),
(1406, 6, 305, 0),
(1407, 7, 305, 0),
(1408, 5, 306, 0),
(1409, 6, 306, 0),
(1410, 7, 306, 0),
(1411, 5, 307, 0),
(1412, 6, 307, 0),
(1413, 7, 307, 0),
(1414, 2, 187, 0),
(1415, 3, 187, 0),
(1416, 4, 187, 0),
(1417, 5, 187, 0),
(1418, 6, 187, 0),
(1419, 7, 187, 0),
(1420, 2, 223, 0),
(1421, 3, 223, 0),
(1422, 4, 223, 0),
(1423, 5, 223, 0),
(1424, 6, 223, 0),
(1425, 7, 223, 0),
(1426, 4, 79, 0),
(1427, 5, 79, 0),
(1428, 6, 79, 0),
(1429, 7, 79, 0),
(1430, 1, 216, 0),
(1431, 2, 216, 0),
(1432, 3, 216, 0),
(1433, 4, 216, 0),
(1434, 5, 216, 0),
(1435, 6, 216, 0),
(1436, 7, 216, 0),
(1437, 2, 224, 0),
(1438, 3, 224, 0),
(1439, 4, 224, 0),
(1440, 5, 224, 0),
(1441, 6, 224, 0),
(1442, 7, 224, 0),
(1443, 2, 72, 0),
(1444, 3, 72, 0),
(1445, 4, 72, 0),
(1446, 5, 72, 0),
(1447, 6, 72, 0),
(1448, 7, 72, 0),
(1449, 4, 85, 0),
(1450, 5, 85, 0),
(1451, 6, 85, 0),
(1452, 7, 85, 0),
(1453, 2, 95, 0),
(1454, 3, 95, 0),
(1455, 4, 95, 0),
(1456, 5, 95, 0),
(1457, 6, 95, 0),
(1458, 7, 95, 0),
(1459, 2, 103, 0),
(1460, 4, 103, 0),
(1461, 5, 103, 0),
(1462, 6, 103, 0),
(1463, 7, 103, 0),
(1464, 2, 104, 0),
(1465, 3, 104, 0),
(1466, 4, 104, 0),
(1467, 5, 104, 0),
(1468, 6, 104, 0),
(1469, 7, 104, 0),
(1470, 2, 188, 0),
(1471, 4, 188, 0),
(1472, 5, 188, 0),
(1473, 6, 188, 0),
(1474, 7, 188, 0),
(1475, 1, 212, 0),
(1476, 2, 212, 0),
(1477, 3, 212, 0),
(1478, 4, 212, 0),
(1479, 5, 212, 0),
(1480, 6, 212, 0),
(1481, 7, 212, 0),
(1482, 2, 285, 0),
(1483, 4, 285, 0),
(1484, 5, 285, 0),
(1485, 6, 285, 0),
(1486, 7, 285, 0),
(1487, 2, 286, 0),
(1488, 4, 286, 0),
(1489, 5, 286, 0),
(1490, 6, 286, 0),
(1491, 7, 286, 0),
(1492, 2, 73, 0),
(1493, 3, 73, 0),
(1494, 4, 73, 0),
(1495, 5, 73, 0),
(1496, 6, 73, 0),
(1497, 7, 73, 0),
(1498, 2, 163, 0),
(1499, 3, 163, 0),
(1500, 4, 163, 0),
(1501, 5, 163, 0),
(1502, 6, 163, 0),
(1503, 7, 163, 0),
(1504, 2, 164, 0),
(1505, 3, 164, 0),
(1506, 4, 164, 0),
(1507, 5, 164, 0),
(1508, 6, 164, 0),
(1509, 7, 164, 0),
(1510, 2, 170, 0),
(1511, 3, 170, 0),
(1512, 4, 170, 0),
(1513, 5, 170, 0),
(1514, 6, 170, 0),
(1515, 7, 170, 0),
(1516, 2, 171, 0),
(1517, 3, 171, 0),
(1518, 4, 171, 0),
(1519, 5, 171, 0),
(1520, 6, 171, 0),
(1521, 7, 171, 0),
(1522, 2, 172, 0),
(1523, 3, 172, 0),
(1524, 4, 172, 0),
(1525, 5, 172, 0),
(1526, 6, 172, 0),
(1527, 7, 172, 0),
(1528, 2, 178, 0),
(1529, 3, 178, 0),
(1530, 4, 178, 0),
(1531, 5, 178, 0),
(1532, 6, 178, 0),
(1533, 7, 178, 0),
(1534, 2, 199, 0),
(1535, 3, 199, 0),
(1536, 4, 199, 0),
(1537, 5, 199, 0),
(1538, 6, 199, 0),
(1539, 7, 199, 0),
(1540, 2, 200, 0),
(1541, 3, 200, 0),
(1542, 4, 200, 0),
(1543, 5, 200, 0),
(1544, 6, 200, 0),
(1545, 7, 200, 0),
(1546, 2, 231, 0),
(1547, 3, 231, 0),
(1548, 4, 231, 0),
(1549, 5, 231, 0),
(1550, 6, 231, 0),
(1551, 7, 231, 0),
(1552, 2, 249, 0),
(1553, 3, 249, 0),
(1554, 4, 249, 0),
(1555, 5, 249, 0),
(1556, 6, 249, 0),
(1557, 7, 249, 0),
(1558, 2, 251, 0),
(1559, 3, 251, 0),
(1560, 4, 251, 0),
(1561, 5, 251, 0),
(1562, 6, 251, 0),
(1563, 7, 251, 0),
(1564, 2, 265, 0),
(1565, 3, 265, 0),
(1566, 4, 265, 0),
(1567, 5, 265, 0),
(1568, 6, 265, 0),
(1569, 7, 265, 0),
(1570, 4, 269, 0),
(1571, 5, 269, 0),
(1572, 6, 269, 0),
(1573, 7, 269, 0),
(1574, 2, 309, 0),
(1575, 3, 309, 0),
(1576, 4, 309, 0),
(1577, 5, 309, 0),
(1578, 6, 309, 0),
(1579, 7, 309, 0),
(1580, 5, 70, 0),
(1581, 5, 71, 0),
(1582, 2, 221, 0),
(1583, 3, 221, 0),
(1584, 4, 221, 0),
(1585, 5, 221, 0),
(1586, 6, 221, 0),
(1587, 7, 221, 0),
(1588, 2, 256, 0),
(1589, 3, 256, 0),
(1590, 4, 256, 0),
(1591, 5, 256, 0),
(1592, 6, 256, 0),
(1593, 7, 256, 0),
(1594, 4, 258, 0),
(1595, 5, 258, 0),
(1596, 6, 258, 0),
(1597, 7, 258, 0),
(1598, 1, 151, 1),
(1599, 2, 151, 1),
(1600, 3, 151, 1),
(1601, 4, 151, 1),
(1602, 5, 151, 0),
(1603, 6, 151, 0),
(1604, 7, 151, 0),
(1605, 1, 152, 1),
(1606, 2, 152, 1),
(1607, 3, 152, 1),
(1608, 4, 152, 0),
(1609, 5, 152, 0),
(1610, 6, 152, 0),
(1611, 7, 152, 0),
(1612, 4, 244, 0),
(1613, 5, 244, 0),
(1614, 6, 244, 0),
(1615, 7, 244, 0),
(1616, 2, 60, 0),
(1617, 3, 60, 0),
(1618, 4, 60, 0),
(1619, 5, 60, 0),
(1620, 6, 60, 0),
(1621, 7, 60, 0),
(1622, 2, 80, 0),
(1623, 3, 80, 0),
(1624, 4, 80, 0),
(1625, 5, 80, 0),
(1626, 6, 80, 0),
(1627, 7, 80, 0),
(1628, 2, 81, 0),
(1629, 3, 81, 0),
(1630, 4, 81, 0),
(1631, 5, 81, 0),
(1632, 6, 81, 0),
(1633, 7, 81, 0),
(1634, 3, 82, 0),
(1635, 4, 82, 0),
(1636, 5, 82, 0),
(1637, 6, 82, 0),
(1638, 7, 82, 0),
(1639, 2, 84, 0),
(1640, 3, 84, 0),
(1641, 4, 84, 0),
(1642, 5, 84, 0),
(1643, 6, 84, 0),
(1644, 7, 84, 0),
(1645, 2, 93, 0),
(1646, 3, 93, 0),
(1647, 4, 93, 0),
(1648, 5, 93, 0),
(1649, 6, 93, 0),
(1650, 7, 93, 0),
(1651, 2, 100, 0),
(1652, 3, 100, 0),
(1653, 4, 100, 0),
(1654, 5, 100, 0),
(1655, 6, 100, 0),
(1656, 7, 100, 0),
(1657, 2, 101, 0),
(1658, 3, 101, 0),
(1659, 4, 101, 0),
(1660, 5, 101, 0),
(1661, 6, 101, 0),
(1662, 7, 101, 0),
(1663, 2, 105, 0),
(1664, 3, 105, 0),
(1665, 4, 105, 0),
(1666, 5, 105, 0),
(1667, 6, 105, 0),
(1668, 7, 105, 0),
(1669, 2, 159, 0),
(1670, 3, 159, 0),
(1671, 4, 159, 0),
(1672, 5, 159, 0),
(1673, 6, 159, 0),
(1674, 7, 159, 0),
(1675, 2, 160, 0),
(1676, 3, 160, 0),
(1677, 4, 160, 0),
(1678, 5, 160, 0),
(1679, 6, 160, 0),
(1680, 7, 160, 0),
(1681, 2, 161, 0),
(1682, 3, 161, 0),
(1683, 4, 161, 0),
(1684, 5, 161, 0),
(1685, 6, 161, 0),
(1686, 7, 161, 0),
(1687, 2, 165, 0),
(1688, 3, 165, 0),
(1689, 4, 165, 0),
(1690, 5, 165, 0),
(1691, 6, 165, 0),
(1692, 7, 165, 0),
(1693, 2, 166, 0),
(1694, 3, 166, 0),
(1695, 4, 166, 0),
(1696, 5, 166, 0),
(1697, 6, 166, 0),
(1698, 7, 166, 0),
(1699, 2, 183, 0),
(1700, 3, 183, 0),
(1701, 4, 183, 0),
(1702, 5, 183, 0),
(1703, 6, 183, 0),
(1704, 7, 183, 0),
(1705, 2, 190, 0),
(1706, 3, 190, 0),
(1707, 4, 190, 0),
(1708, 5, 190, 0),
(1709, 6, 190, 0),
(1710, 7, 190, 0),
(1711, 2, 193, 0),
(1712, 3, 193, 0),
(1713, 4, 193, 0),
(1714, 5, 193, 0),
(1715, 6, 193, 0),
(1716, 7, 193, 0),
(1717, 2, 198, 0),
(1718, 3, 198, 0),
(1719, 4, 198, 0),
(1720, 5, 198, 0),
(1721, 6, 198, 0),
(1722, 7, 198, 0),
(1723, 2, 202, 0),
(1724, 3, 202, 0),
(1725, 4, 202, 0),
(1726, 5, 202, 0),
(1727, 6, 202, 0),
(1728, 7, 202, 0),
(1729, 2, 226, 0),
(1730, 3, 226, 0),
(1731, 4, 226, 0),
(1732, 5, 226, 0),
(1733, 6, 226, 0),
(1734, 7, 226, 0),
(1735, 2, 229, 0),
(1736, 3, 229, 0),
(1737, 4, 229, 0),
(1738, 5, 229, 0),
(1739, 6, 229, 0),
(1740, 7, 229, 0),
(1741, 2, 236, 0),
(1742, 3, 236, 0),
(1743, 4, 236, 0),
(1744, 5, 236, 0),
(1745, 6, 236, 0),
(1746, 7, 236, 0),
(1747, 2, 266, 0),
(1748, 3, 266, 0),
(1749, 4, 266, 0),
(1750, 5, 266, 0),
(1751, 6, 266, 0),
(1752, 7, 266, 0),
(1753, 2, 267, 0),
(1754, 3, 267, 0),
(1755, 4, 267, 0),
(1756, 5, 267, 0),
(1757, 6, 267, 0),
(1758, 7, 267, 0),
(1759, 4, 268, 0),
(1760, 5, 268, 0),
(1761, 6, 268, 0),
(1762, 7, 268, 0),
(1763, 2, 272, 0),
(1764, 3, 272, 0),
(1765, 4, 272, 0),
(1766, 5, 272, 0),
(1767, 6, 272, 0),
(1768, 7, 272, 0),
(1769, 2, 273, 0),
(1770, 3, 273, 0),
(1771, 4, 273, 0),
(1772, 5, 273, 0),
(1773, 6, 273, 0),
(1774, 7, 273, 0),
(1775, 4, 288, 0),
(1776, 5, 288, 0),
(1777, 6, 288, 0),
(1778, 7, 288, 0),
(1779, 2, 291, 0),
(1780, 3, 291, 0),
(1781, 4, 291, 0),
(1782, 5, 291, 0),
(1783, 6, 291, 0),
(1784, 7, 291, 0),
(1785, 2, 293, 0),
(1786, 3, 293, 0),
(1787, 4, 293, 0),
(1788, 5, 293, 0),
(1789, 6, 293, 0),
(1790, 7, 293, 0),
(1791, 2, 295, 0),
(1792, 3, 295, 0),
(1793, 4, 295, 0),
(1794, 5, 295, 0),
(1795, 6, 295, 0),
(1796, 7, 295, 0),
(1797, 2, 302, 0),
(1798, 3, 302, 0),
(1799, 4, 302, 0),
(1800, 5, 302, 0),
(1801, 6, 302, 0),
(1802, 7, 302, 0),
(1803, 2, 308, 0),
(1804, 3, 308, 0),
(1805, 4, 308, 0),
(1806, 5, 308, 0),
(1807, 6, 308, 0),
(1808, 7, 308, 0),
(1809, 2, 312, 0),
(1810, 3, 312, 0),
(1811, 4, 312, 0),
(1812, 5, 312, 0),
(1813, 6, 312, 0),
(1814, 7, 312, 0),
(1815, 2, 59, 0),
(1816, 3, 59, 0),
(1817, 4, 59, 0),
(1818, 5, 59, 0),
(1819, 6, 59, 0),
(1820, 7, 59, 0),
(1821, 4, 89, 0),
(1822, 5, 89, 0),
(1823, 6, 89, 0),
(1824, 7, 89, 0),
(1825, 4, 90, 0),
(1826, 5, 90, 0),
(1827, 6, 90, 0),
(1828, 7, 90, 0),
(1829, 2, 162, 0),
(1830, 3, 162, 0),
(1831, 4, 162, 0),
(1832, 5, 162, 0),
(1833, 6, 162, 0),
(1834, 7, 162, 0),
(1835, 2, 169, 0),
(1836, 3, 169, 0),
(1837, 4, 169, 0),
(1838, 5, 169, 0),
(1839, 6, 169, 0),
(1840, 7, 169, 0),
(1841, 2, 184, 0),
(1842, 3, 184, 0),
(1843, 4, 184, 0),
(1844, 5, 184, 0),
(1845, 6, 184, 0),
(1846, 7, 184, 0),
(1847, 2, 186, 0),
(1848, 3, 186, 0),
(1849, 4, 186, 0),
(1850, 5, 186, 0),
(1851, 6, 186, 0),
(1852, 7, 186, 0),
(1853, 2, 250, 0),
(1854, 3, 250, 0),
(1855, 4, 250, 0),
(1856, 5, 250, 0),
(1857, 6, 250, 0),
(1858, 7, 250, 0),
(1859, 4, 315, 0),
(1860, 5, 315, 0),
(1861, 6, 315, 0),
(1862, 7, 315, 0),
(1863, 4, 189, 0),
(1864, 5, 189, 0),
(1865, 6, 189, 0),
(1866, 7, 189, 0),
(1867, 5, 75, 0),
(1868, 6, 75, 0),
(1869, 7, 75, 0),
(1870, 4, 76, 0),
(1871, 5, 76, 0),
(1872, 6, 76, 0),
(1873, 7, 76, 0),
(1874, 4, 191, 0),
(1875, 5, 191, 0),
(1876, 6, 191, 0),
(1877, 7, 191, 0),
(1878, 4, 194, 0),
(1879, 5, 194, 0),
(1880, 6, 194, 0),
(1881, 7, 194, 0),
(1882, 4, 195, 0),
(1883, 5, 195, 0),
(1884, 6, 195, 0),
(1885, 7, 195, 0),
(1886, 3, 197, 0),
(1887, 4, 197, 0),
(1888, 5, 197, 0),
(1889, 6, 197, 0),
(1890, 7, 197, 0),
(1891, 4, 201, 0),
(1892, 5, 201, 0),
(1893, 6, 201, 0),
(1894, 7, 201, 0),
(1895, 3, 228, 0),
(1896, 4, 228, 0),
(1897, 5, 228, 0),
(1898, 6, 228, 0),
(1899, 7, 228, 0),
(1900, 3, 232, 0),
(1901, 4, 232, 0),
(1902, 5, 232, 0),
(1903, 6, 232, 0),
(1904, 7, 232, 0),
(1905, 3, 233, 0),
(1906, 4, 233, 0),
(1907, 5, 233, 0),
(1908, 6, 233, 0),
(1909, 7, 233, 0),
(1910, 4, 287, 0),
(1911, 5, 287, 0),
(1912, 6, 287, 0),
(1913, 7, 287, 0),
(1914, 4, 94, 0),
(1915, 5, 94, 0),
(1916, 6, 94, 0),
(1917, 7, 94, 0),
(1918, 4, 96, 0),
(1919, 5, 96, 0),
(1920, 6, 96, 0),
(1921, 7, 96, 0),
(1922, 4, 97, 0),
(1923, 5, 97, 0),
(1924, 6, 97, 0),
(1925, 7, 97, 0),
(1926, 3, 174, 0),
(1927, 4, 174, 0),
(1928, 5, 174, 0),
(1929, 6, 174, 0),
(1930, 7, 174, 0),
(1931, 3, 234, 0),
(1932, 4, 234, 0),
(1933, 5, 234, 0),
(1934, 6, 234, 0),
(1935, 7, 234, 0),
(1936, 3, 235, 0),
(1937, 4, 235, 0),
(1938, 5, 235, 0),
(1939, 6, 235, 0),
(1940, 7, 235, 0),
(1941, 4, 255, 0),
(1942, 5, 255, 0),
(1943, 6, 255, 0),
(1944, 7, 255, 0),
(1945, 4, 274, 0),
(1946, 5, 274, 0),
(1947, 6, 274, 0),
(1948, 7, 274, 0),
(1949, 4, 310, 0),
(1950, 5, 310, 0),
(1951, 6, 310, 0),
(1952, 7, 310, 0),
(1953, 4, 86, 0),
(1954, 5, 86, 0),
(1955, 6, 86, 0),
(1956, 7, 86, 0),
(1957, 4, 87, 0),
(1958, 5, 87, 0),
(1959, 6, 87, 0),
(1960, 7, 87, 0),
(1961, 4, 179, 0),
(1962, 5, 179, 0),
(1963, 6, 179, 0),
(1964, 7, 179, 0),
(1965, 4, 227, 0),
(1966, 5, 227, 0),
(1967, 6, 227, 0),
(1968, 7, 227, 0),
(1969, 1, 209, 0),
(1970, 2, 209, 0),
(1971, 3, 209, 0),
(1972, 4, 209, 0),
(1973, 5, 209, 0),
(1974, 6, 209, 0),
(1975, 7, 209, 0),
(1976, 1, 210, 0),
(1977, 2, 210, 0),
(1978, 3, 210, 0),
(1979, 4, 210, 0),
(1980, 5, 210, 0),
(1981, 6, 210, 0),
(1982, 7, 210, 0),
(1983, 1, 211, 0),
(1984, 2, 211, 0),
(1985, 3, 211, 0),
(1986, 4, 211, 0),
(1987, 5, 211, 0),
(1988, 6, 211, 0),
(1989, 7, 211, 0),
(1990, 1, 213, 0),
(1991, 2, 213, 0),
(1992, 3, 213, 0),
(1993, 4, 213, 0),
(1994, 5, 213, 0),
(1995, 6, 213, 0),
(1996, 7, 213, 0),
(1997, 1, 214, 0),
(1998, 2, 214, 0),
(1999, 3, 214, 0),
(2000, 4, 214, 0),
(2001, 5, 214, 0),
(2002, 6, 214, 0),
(2003, 7, 214, 0),
(2004, 1, 215, 0),
(2005, 2, 215, 0),
(2006, 3, 215, 0),
(2007, 4, 215, 0),
(2008, 5, 215, 0),
(2009, 6, 215, 0),
(2010, 7, 215, 0),
(2011, 4, 275, 0),
(2012, 5, 275, 0),
(2013, 6, 275, 0),
(2014, 7, 275, 0),
(2015, 4, 276, 0),
(2016, 5, 276, 0),
(2017, 6, 276, 0),
(2018, 7, 276, 0),
(2019, 4, 277, 0),
(2020, 5, 277, 0),
(2021, 6, 277, 0),
(2022, 7, 277, 0),
(2023, 4, 281, 0),
(2024, 5, 281, 0),
(2025, 6, 281, 0),
(2026, 7, 281, 0),
(2027, 4, 316, 0),
(2028, 5, 316, 0),
(2029, 6, 316, 0),
(2030, 7, 316, 0),
(2031, 1, 217, 0),
(2032, 2, 217, 0),
(2033, 3, 217, 0),
(2034, 4, 217, 0),
(2035, 5, 217, 0),
(2036, 6, 217, 0),
(2037, 7, 217, 0),
(2038, 1, 218, 0),
(2039, 2, 218, 0),
(2040, 3, 218, 0),
(2041, 4, 218, 0),
(2042, 5, 218, 0),
(2043, 6, 218, 0),
(2044, 7, 218, 0),
(2045, 1, 219, 0),
(2046, 2, 219, 0),
(2047, 3, 219, 0),
(2048, 4, 219, 0),
(2049, 5, 219, 0),
(2050, 6, 219, 0),
(2051, 7, 219, 0),
(2052, 1, 220, 0),
(2053, 2, 220, 0),
(2054, 3, 220, 0),
(2055, 4, 220, 0),
(2056, 5, 220, 0),
(2057, 6, 220, 0),
(2058, 7, 220, 0),
(2059, 4, 237, 0),
(2060, 5, 237, 0),
(2061, 6, 237, 0),
(2062, 7, 237, 0),
(2063, 3, 238, 0),
(2064, 4, 238, 0),
(2065, 5, 238, 0),
(2066, 6, 238, 0),
(2067, 7, 238, 0),
(2068, 3, 239, 0),
(2069, 4, 239, 0),
(2070, 5, 239, 0),
(2071, 6, 239, 0),
(2072, 7, 239, 0),
(2073, 3, 240, 0),
(2074, 4, 240, 0),
(2075, 5, 240, 0),
(2076, 6, 240, 0),
(2077, 7, 240, 0),
(2078, 3, 241, 0),
(2079, 4, 241, 0),
(2080, 5, 241, 0),
(2081, 6, 241, 0),
(2082, 7, 241, 0),
(2083, 3, 248, 0),
(2084, 4, 248, 0),
(2085, 5, 248, 0),
(2086, 6, 248, 0),
(2087, 7, 248, 0),
(2088, 4, 245, 0),
(2089, 5, 245, 0),
(2090, 6, 245, 0),
(2091, 7, 245, 0),
(2092, 4, 246, 0),
(2093, 5, 246, 0),
(2094, 6, 246, 0),
(2095, 7, 246, 0),
(2096, 4, 247, 0),
(2097, 5, 247, 0),
(2098, 6, 247, 0),
(2099, 7, 247, 0),
(2100, 5, 262, 0),
(2101, 6, 262, 0),
(2102, 7, 262, 0),
(2103, 5, 263, 0),
(2104, 6, 263, 0),
(2105, 7, 263, 0),
(2106, 5, 264, 0),
(2107, 6, 264, 0),
(2108, 7, 264, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]habilitationother`
--

CREATE TABLE `[[dbprefix]]habilitationother` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(20) DEFAULT NULL,
  `rightAccess` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `habilitationotherProfile` (`idProfile`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=290 ;

--
-- Dumping data for table `[[dbprefix]]habilitationother`
--

INSERT INTO `[[dbprefix]]habilitationother` VALUES
(1, 1, 'imputation', '4'),
(2, 2, 'imputation', '2'),
(3, 3, 'imputation', '3'),
(4, 4, 'imputation', '2'),
(5, 6, 'imputation', '1'),
(6, 7, 'imputation', '1'),
(7, 5, 'imputation', '1'),
(8, 1, 'work', '4'),
(9, 2, 'work', '4'),
(10, 3, 'work', '4'),
(11, 4, 'work', '4'),
(12, 6, 'work', '2'),
(13, 7, 'work', '1'),
(14, 5, 'work', '1'),
(15, 1, 'cost', '4'),
(16, 2, 'cost', '4'),
(17, 3, 'cost', '4'),
(18, 4, 'cost', '1'),
(19, 6, 'cost', '2'),
(20, 7, 'cost', '1'),
(21, 5, 'cost', '1'),
(22, 1, 'combo', '1'),
(23, 2, 'combo', '2'),
(24, 3, 'combo', '1'),
(25, 4, 'combo', '2'),
(26, 6, 'combo', '2'),
(27, 7, 'combo', '2'),
(28, 5, 'combo', '2'),
(29, 1, 'planning', '1'),
(30, 2, 'planning', '2'),
(31, 3, 'planning', '1'),
(32, 4, 'planning', '2'),
(33, 6, 'planning', '2'),
(34, 7, 'planning', '2'),
(35, 5, 'planning', '2'),
(36, 1, 'document', '1'),
(37, 2, 'document', '2'),
(38, 3, 'document', '1'),
(39, 4, 'document', '2'),
(40, 6, 'document', '2'),
(41, 7, 'document', '2'),
(42, 5, 'document', '2'),
(43, 1, 'requirement', '1'),
(44, 2, 'requirement', '2'),
(45, 3, 'requirement', '1'),
(46, 4, 'requirement', '2'),
(47, 6, 'requirement', '2'),
(48, 7, 'requirement', '2'),
(49, 5, 'requirement', '2'),
(50, 1, 'workValid', '4'),
(51, 2, 'workValid', '2'),
(52, 3, 'workValid', '3'),
(53, 4, 'workValid', '1'),
(54, 6, 'workValid', '1'),
(55, 7, 'workValid', '1'),
(56, 5, 'workValid', '1'),
(57, 1, 'checklist', '1'),
(58, 2, 'checklist', '1'),
(59, 3, 'checklist', '1'),
(60, 4, 'checklist', '1'),
(61, 6, 'checklist', '2'),
(62, 7, 'checklist', '2'),
(63, 5, 'checklist', '2'),
(64, 1, 'assignmentView', '1'),
(65, 2, 'assignmentView', '1'),
(66, 3, 'assignmentView', '1'),
(67, 4, 'assignmentView', '1'),
(68, 6, 'assignmentView', '2'),
(69, 7, 'assignmentView', '2'),
(70, 5, 'assignmentView', '2'),
(71, 1, 'assignmentEdit', '1'),
(72, 2, 'assignmentEdit', '2'),
(73, 3, 'assignmentEdit', '1'),
(74, 4, 'assignmentEdit', '2'),
(75, 6, 'assignmentEdit', '2'),
(76, 7, 'assignmentEdit', '2'),
(77, 5, 'assignmentEdit', '2'),
(78, 1, 'diary', '4'),
(79, 2, 'diary', '2'),
(80, 3, 'diary', '3'),
(81, 4, 'diary', '2'),
(82, 6, 'diary', '1'),
(83, 7, 'diary', '1'),
(84, 5, 'diary', '1'),
(85, 1, 'resourcePlanning', '1'),
(86, 2, 'resourcePlanning', '1'),
(87, 3, 'resourcePlanning', '1'),
(88, 4, 'resourcePlanning', '2'),
(89, 6, 'resourcePlanning', '2'),
(90, 7, 'resourcePlanning', '2'),
(91, 5, 'resourcePlanning', '2'),
(92, 1, 'reportResourceAll', '1'),
(93, 2, 'reportResourceAll', '1'),
(94, 3, 'reportResourceAll', '1'),
(95, 4, 'reportResourceAll', '2'),
(96, 6, 'reportResourceAll', '2'),
(97, 7, 'reportResourceAll', '2'),
(98, 5, 'reportResourceAll', '2'),
(99, 1, 'canUpdateCreation', '1'),
(100, 2, 'canUpdateCreation', '2'),
(101, 3, 'canUpdateCreation', '2'),
(102, 4, 'canUpdateCreation', '2'),
(103, 6, 'canUpdateCreation', '2'),
(104, 7, 'canUpdateCreation', '2'),
(105, 5, 'canUpdateCreation', '2'),
(106, 1, 'viewComponents', '1'),
(107, 2, 'viewComponents', '1'),
(108, 3, 'viewComponents', '1'),
(109, 4, 'viewComponents', '1'),
(110, 6, 'viewComponents', '2'),
(111, 7, 'viewComponents', '2'),
(112, 5, 'viewComponents', '2'),
(113, 1, 'joblist', '1'),
(114, 2, 'joblist', '1'),
(115, 3, 'joblist', '1'),
(116, 4, 'joblist', '1'),
(117, 6, 'joblist', '2'),
(118, 7, 'joblist', '2'),
(119, 5, 'joblist', '2'),
(120, 1, 'changeValidatedData', '1'),
(121, 2, 'changeValidatedData', '1'),
(122, 3, 'changeValidatedData', '1'),
(123, 4, 'changeValidatedData', '2'),
(124, 6, 'changeValidatedData', '2'),
(125, 7, 'changeValidatedData', '2'),
(126, 5, 'changeValidatedData', '2'),
(127, 1, 'subscription', '4'),
(128, 3, 'subscription', '3'),
(129, 1, 'multipleUpdate', '1'),
(130, 2, 'multipleUpdate', '1'),
(131, 3, 'multipleUpdate', '1'),
(132, 4, 'multipleUpdate', '1'),
(133, 5, 'multipleUpdate', '1'),
(134, 6, 'multipleUpdate', '1'),
(135, 7, 'multipleUpdate', '1'),
(136, 1, 'changeManualProgress', '1'),
(137, 3, 'changeManualProgress', '1'),
(138, 1, 'changePriorityProj', '1'),
(139, 2, 'changePriorityProj', '1'),
(140, 3, 'changePriorityProj', '1'),
(141, 4, 'changePriorityProj', '2'),
(142, 6, 'changePriorityProj', '2'),
(143, 7, 'changePriorityProj', '2'),
(144, 5, 'changePriorityProj', '2'),
(145, 1, 'scheduledReport', '4'),
(146, 2, 'scheduledReport', '2'),
(147, 3, 'scheduledReport', '2'),
(148, 4, 'scheduledReport', '2'),
(149, 5, 'scheduledReport', '2'),
(150, 6, 'scheduledReport', '2'),
(151, 7, 'scheduledReport', '2'),
(152, 1, 'dataCloningRight', '4'),
(153, 2, 'dataCloningRight', '2'),
(154, 3, 'dataCloningRight', '6'),
(155, 4, 'dataCloningRight', '1'),
(156, 5, 'dataCloningRight', '1'),
(157, 6, 'dataCloningRight', '1'),
(158, 7, 'dataCloningRight', '1'),
(159, 1, 'dataCloningTotal', '10'),
(160, 2, 'dataCloningTotal', '1'),
(161, 3, 'dataCloningTotal', '3'),
(162, 4, 'dataCloningTotal', '0'),
(163, 5, 'dataCloningTotal', '0'),
(164, 6, 'dataCloningTotal', '0'),
(165, 7, 'dataCloningTotal', '0'),
(166, 1, 'feedingOfTheReal', '1'),
(167, 3, 'feedingOfTheReal', '1'),
(168, 1, 'canChangeNote', '1'),
(169, 3, 'canChangeNote', '1'),
(170, 1, 'canDeleteAttachment', '1'),
(171, 3, 'canDeleteAttachment', '1'),
(172, 1, 'situation', '1'),
(173, 3, 'situation', '1'),
(175, 2, 'situation', '2'),
(176, 4, 'situation', '2'),
(177, 5, 'situation', '2'),
(178, 6, 'situation', '2'),
(179, 7, 'situation', '2'),
(182, 1, 'generateProjExpense', '1'),
(183, 2, 'generateProjExpense', '1'),
(184, 3, 'generateProjExpense', '1'),
(185, 4, 'generateProjExpense', '1'),
(186, 5, 'generateProjExpense', '1'),
(187, 6, 'generateProjExpense', '1'),
(188, 7, 'generateProjExpense', '1'),
(189, 1, 'validatePlanning', '1'),
(190, 2, 'validatePlanning', '1'),
(191, 3, 'validatePlanning', '1'),
(192, 4, 'validatePlanning', '2'),
(193, 6, 'validatePlanning', '2'),
(194, 7, 'validatePlanning', '2'),
(195, 5, 'validatePlanning', '2'),
(196, 1, 'changePriorityOther', '1'),
(197, 3, 'changePriorityOther', '1'),
(198, 1, 'lockedImputation', '1'),
(199, 2, 'lockedImputation', '1'),
(200, 3, 'lockedImputation', '1'),
(201, 4, 'lockedImputation', '2'),
(202, 5, 'lockedImputation', '2'),
(203, 6, 'lockedImputation', '2'),
(204, 7, 'lockedImputation', '2'),
(205, 1, 'validationImputation', '1'),
(206, 2, 'validationImputation', '1'),
(207, 3, 'validationImputation', '1'),
(208, 4, 'validationImputation', '2'),
(209, 5, 'validationImputation', '2'),
(210, 6, 'validationImputation', '2'),
(211, 7, 'validationImputation', '2'),
(212, 1, 'lockedLeftWork', '1'),
(213, 2, 'lockedLeftWork', '1'),
(214, 3, 'lockedLeftWork', '1'),
(215, 4, 'lockedLeftWork', '1'),
(216, 5, 'lockedLeftWork', '1'),
(217, 6, 'lockedLeftWork', '1'),
(218, 7, 'lockedLeftWork', '1'),
(219, 1, 'subtask', '1'),
(220, 2, 'subtask', '1'),
(221, 3, 'subtask', '1'),
(222, 4, 'subtask', '1'),
(223, 5, 'subtask', '2'),
(224, 6, 'subtask', '2'),
(225, 7, 'subtask', '2'),
(226, 1, 'canWorkOnTicket', '1'),
(227, 2, 'canWorkOnTicket', '1'),
(228, 3, 'canWorkOnTicket', '1'),
(229, 4, 'canWorkOnTicket', '1'),
(233, 5, 'canWorkOnTicket', '2'),
(234, 6, 'canWorkOnTicket', '2'),
(235, 7, 'canWorkOnTicket', '2'),
(236, 1, 'canManageVotes', '1'),
(237, 3, 'canManageVotes', '1'),
(238, 1, 'canAttributeLayout', '1'),
(239, 3, 'canAttributeLayout', '1'),
(240, 1, 'reportAdminProject', '1'),
(241, 2, 'reportAdminProject', '1'),
(242, 3, 'reportAdminProject', '1'),
(243, 4, 'reportAdminProject', '2'),
(244, 6, 'reportAdminProject', '2'),
(245, 7, 'reportAdminProject', '2'),
(246, 5, 'reportAdminProject', '2'),
(247, 1, 'canCreateTags', '1'),
(248, 3, 'canCreateTags', '1'),
(249, 1, 'nameVoterDetail', '1'),
(250, 1, 'votingPanelDetail', '1'),
(251, 1, 'workPlan', '1'),
(252, 2, 'workPlan', '1'),
(253, 3, 'workPlan', '1'),
(254, 4, 'workPlan', '2'),
(255, 6, 'workPlan', '2'),
(256, 7, 'workPlan', '2'),
(257, 5, 'workPlan', '2'),
(258, 1, 'canWorkOnImputation', '1'),
(259, 2, 'canWorkOnImputation', '2'),
(260, 3, 'canWorkOnImputation', '2'),
(261, 4, 'canWorkOnImputation', '2'),
(262, 5, 'canWorkOnImputation', '2'),
(263, 6, 'canWorkOnImputation', '2'),
(264, 7, 'canWorkOnImputation', '2'),
(266, 1, 'canAddNoteClosedEl', '2'),
(267, 2, 'canAddNoteClosedEl', '2'),
(268, 3, 'canAddNoteClosedEl', '2'),
(269, 4, 'canAddNoteClosedEl', '2'),
(270, 5, 'canAddNoteClosedEl', '2'),
(271, 6, 'canAddNoteClosedEl', '2'),
(272, 7, 'canAddNoteClosedEl', '2'),
(273, 1, 'canAddNoteReadOnlyEl', '2'),
(274, 2, 'canAddNoteReadOnlyEl', '2'),
(275, 3, 'canAddNoteReadOnlyEl', '2'),
(276, 4, 'canAddNoteReadOnlyEl', '2'),
(277, 5, 'canAddNoteReadOnlyEl', '2'),
(278, 6, 'canAddNoteReadOnlyEl', '2'),
(279, 7, 'canAddNoteReadOnlyEl', '2'),
(280, 1, 'enableAutomaticCal', '1'),
(281, 3, 'enableAutomaticCal', '1'),
(283, 2, 'enableAutomaticCal', '2'),
(284, 4, 'enableAutomaticCal', '2'),
(285, 5, 'enableAutomaticCal', '2'),
(286, 6, 'enableAutomaticCal', '2'),
(287, 7, 'enableAutomaticCal', '2');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]habilitationreport`
--

CREATE TABLE `[[dbprefix]]habilitationreport` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `allowAccess` int(1) unsigned DEFAULT NULL COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `habilitationReportProfile` (`idProfile`),
  KEY `habilitationReportReport` (`idReport`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=384 ;

--
-- Dumping data for table `[[dbprefix]]habilitationreport`
--

INSERT INTO `[[dbprefix]]habilitationreport` VALUES
(1, 1, 1, 1),
(2, 1, 2, 1),
(3, 1, 3, 1),
(4, 1, 4, 1),
(5, 1, 5, 1),
(6, 1, 6, 1),
(8, 1, 8, 1),
(9, 1, 9, 1),
(10, 1, 10, 1),
(11, 1, 11, 1),
(12, 1, 12, 1),
(13, 1, 13, 1),
(14, 1, 14, 1),
(15, 1, 15, 1),
(16, 1, 16, 1),
(17, 1, 17, 1),
(18, 1, 18, 1),
(19, 1, 19, 1),
(20, 1, 20, 1),
(21, 1, 21, 1),
(22, 1, 22, 1),
(23, 1, 23, 1),
(24, 1, 24, 1),
(25, 1, 25, 1),
(26, 2, 1, 1),
(27, 2, 2, 1),
(28, 2, 3, 1),
(29, 2, 4, 1),
(30, 2, 5, 1),
(31, 2, 6, 1),
(33, 2, 8, 1),
(34, 2, 9, 1),
(35, 2, 10, 1),
(36, 2, 11, 1),
(37, 2, 12, 1),
(38, 2, 13, 1),
(39, 2, 14, 1),
(40, 2, 15, 1),
(41, 2, 16, 1),
(42, 2, 17, 1),
(43, 2, 18, 1),
(44, 2, 19, 1),
(45, 2, 20, 1),
(46, 2, 21, 1),
(47, 2, 22, 1),
(48, 2, 23, 1),
(49, 3, 1, 1),
(50, 3, 2, 1),
(51, 3, 3, 1),
(52, 3, 4, 1),
(53, 3, 5, 1),
(54, 3, 6, 1),
(56, 3, 8, 1),
(57, 3, 9, 1),
(58, 3, 10, 1),
(59, 3, 11, 1),
(60, 3, 12, 1),
(61, 3, 13, 1),
(62, 3, 14, 1),
(63, 3, 15, 1),
(64, 3, 16, 1),
(65, 3, 17, 1),
(66, 3, 18, 1),
(67, 3, 19, 1),
(68, 3, 20, 1),
(69, 3, 21, 1),
(70, 3, 22, 1),
(71, 3, 23, 1),
(72, 1, 26, 1),
(73, 1, 27, 1),
(74, 2, 26, 1),
(75, 2, 27, 1),
(76, 3, 26, 1),
(77, 3, 27, 1),
(78, 1, 28, 1),
(79, 1, 29, 1),
(80, 1, 30, 1),
(81, 2, 28, 1),
(82, 2, 29, 1),
(83, 2, 30, 1),
(84, 3, 28, 1),
(85, 3, 29, 1),
(86, 3, 30, 1),
(87, 1, 31, 1),
(88, 2, 31, 1),
(89, 3, 31, 1),
(90, 1, 32, 1),
(91, 2, 32, 1),
(92, 3, 32, 1),
(93, 1, 33, 1),
(94, 2, 33, 1),
(95, 3, 33, 1),
(96, 1, 34, 1),
(97, 2, 34, 1),
(98, 3, 34, 1),
(99, 1, 35, 1),
(100, 2, 35, 1),
(101, 3, 35, 1),
(102, 1, 36, 1),
(103, 2, 36, 1),
(104, 3, 36, 1),
(105, 1, 37, 1),
(106, 2, 37, 0),
(107, 3, 37, 0),
(108, 4, 37, 0),
(109, 5, 37, 0),
(110, 6, 37, 0),
(111, 7, 37, 0),
(112, 1, 38, 1),
(113, 2, 38, 1),
(114, 3, 38, 1),
(115, 4, 38, 0),
(116, 5, 38, 0),
(117, 6, 38, 0),
(118, 7, 38, 0),
(119, 1, 39, 1),
(120, 2, 39, 1),
(121, 3, 39, 1),
(122, 4, 39, 0),
(123, 5, 39, 0),
(124, 6, 39, 0),
(125, 7, 39, 0),
(126, 1, 40, 1),
(127, 2, 40, 1),
(128, 3, 40, 1),
(129, 4, 40, 0),
(130, 5, 40, 0),
(131, 6, 40, 0),
(132, 7, 40, 0),
(133, 1, 44, 1),
(134, 2, 44, 1),
(135, 3, 44, 1),
(136, 4, 44, 0),
(137, 5, 44, 0),
(138, 6, 44, 0),
(139, 7, 44, 0),
(140, 1, 41, 1),
(141, 2, 41, 1),
(142, 3, 41, 1),
(143, 4, 41, 0),
(144, 5, 41, 0),
(145, 6, 41, 0),
(146, 7, 41, 0),
(147, 1, 42, 1),
(148, 2, 42, 1),
(149, 3, 42, 1),
(150, 4, 42, 0),
(151, 5, 42, 0),
(152, 6, 42, 0),
(153, 7, 42, 0),
(154, 1, 43, 1),
(155, 2, 43, 1),
(156, 3, 43, 1),
(157, 4, 43, 0),
(158, 5, 43, 0),
(159, 6, 43, 0),
(160, 7, 43, 0),
(161, 1, 45, 1),
(162, 2, 45, 1),
(163, 3, 45, 0),
(164, 4, 45, 0),
(165, 1, 46, 1),
(166, 2, 46, 1),
(167, 3, 46, 0),
(168, 4, 46, 0),
(169, 1, 48, 1),
(170, 2, 48, 0),
(171, 3, 48, 0),
(172, 4, 48, 0),
(180, 1, 50, 1),
(181, 2, 50, 1),
(182, 3, 50, 1),
(183, 1, 52, 1),
(184, 2, 52, 1),
(185, 3, 52, 1),
(186, 1, 53, 1),
(187, 2, 53, 1),
(188, 3, 53, 1),
(189, 4, 53, 0),
(190, 5, 53, 0),
(191, 6, 53, 0),
(192, 7, 53, 0),
(193, 1, 54, 1),
(194, 2, 54, 1),
(195, 3, 54, 1),
(196, 4, 54, 1),
(197, 5, 54, 0),
(198, 6, 54, 0),
(199, 7, 54, 0),
(200, 1, 55, 1),
(201, 2, 55, 1),
(202, 3, 55, 1),
(203, 4, 55, 1),
(204, 5, 55, 0),
(205, 6, 55, 0),
(206, 7, 55, 0),
(207, 1, 56, 1),
(208, 2, 56, 1),
(209, 3, 56, 1),
(210, 4, 56, 1),
(211, 5, 56, 0),
(212, 6, 56, 0),
(213, 7, 56, 0),
(214, 1, 57, 1),
(215, 2, 57, 1),
(216, 3, 57, 1),
(217, 4, 57, 1),
(218, 1, 58, 1),
(219, 2, 58, 1),
(220, 3, 58, 1),
(221, 4, 58, 1),
(222, 1, 59, 1),
(223, 2, 59, 1),
(224, 3, 59, 1),
(225, 1, 60, 1),
(226, 2, 60, 1),
(227, 3, 60, 1),
(228, 1, 61, 1),
(229, 2, 61, 1),
(230, 3, 61, 1),
(231, 1, 62, 1),
(232, 2, 62, 1),
(233, 3, 62, 1),
(234, 1, 63, 1),
(235, 2, 63, 1),
(236, 3, 63, 1),
(237, 1, 64, 1),
(238, 2, 64, 1),
(239, 3, 64, 1),
(240, 1, 65, 1),
(241, 2, 65, 1),
(242, 1, 66, 1),
(243, 2, 66, 1),
(244, 3, 66, 1),
(245, 1, 67, 1),
(246, 2, 67, 1),
(247, 1, 68, 1),
(248, 2, 68, 1),
(249, 3, 68, 1),
(250, 1, 69, 1),
(251, 2, 69, 1),
(252, 3, 69, 1),
(253, 1, 70, 1),
(254, 2, 70, 1),
(255, 1, 71, 1),
(256, 2, 71, 1),
(257, 3, 71, 1),
(258, 1, 72, 1),
(259, 2, 72, 1),
(260, 1, 73, 1),
(261, 2, 73, 1),
(262, 3, 73, 1),
(263, 1, 74, 1),
(264, 2, 74, 1),
(265, 3, 74, 1),
(266, 1, 75, 1),
(267, 1, 76, 1),
(268, 2, 76, 1),
(269, 3, 76, 1),
(270, 4, 76, 1),
(271, 1, 77, 1),
(272, 2, 77, 1),
(273, 3, 77, 1),
(274, 4, 77, 1),
(275, 1, 78, 1),
(276, 2, 78, 1),
(277, 3, 78, 1),
(278, 4, 78, 1),
(279, 1, 79, 1),
(280, 1, 80, 1),
(281, 1, 81, 1),
(282, 1, 82, 1),
(283, 1, 83, 1),
(284, 1, 84, 1),
(285, 2, 84, 1),
(286, 3, 84, 1),
(287, 1, 86, 1),
(288, 2, 86, 1),
(289, 3, 86, 1),
(290, 1, 87, 1),
(291, 2, 87, 1),
(292, 3, 87, 1),
(294, 2, 81, 1),
(295, 3, 81, 1),
(296, 1, 88, 1),
(297, 2, 88, 1),
(298, 3, 88, 1),
(299, 1, 89, 1),
(300, 2, 89, 1),
(301, 3, 89, 1),
(302, 1, 90, 1),
(303, 2, 90, 1),
(304, 3, 90, 1),
(305, 1, 91, 1),
(306, 2, 91, 1),
(307, 3, 91, 1),
(308, 1, 92, 1),
(309, 2, 92, 1),
(310, 3, 92, 1),
(311, 1, 102, 1),
(312, 1, 103, 1),
(313, 1, 104, 1),
(314, 1, 107, 1),
(315, 1, 105, 1),
(316, 1, 106, 1),
(317, 1, 108, 1),
(318, 1, 109, 1),
(319, 1, 110, 1),
(320, 1, 111, 1),
(321, 1, 112, 1),
(322, 1, 113, 1),
(323, 1, 114, 1),
(324, 1, 115, 1),
(325, 2, 115, 1),
(326, 3, 115, 1),
(327, 1, 116, 1),
(328, 1, 117, 1),
(329, 1, 118, 1),
(330, 1, 119, 1),
(331, 1, 120, 1),
(332, 1, 121, 1),
(333, 1, 122, 1),
(334, 1, 123, 1),
(335, 1, 124, 1),
(336, 1, 125, 1),
(337, 1, 126, 1),
(338, 1, 127, 1),
(339, 1, 128, 1),
(340, 2, 124, 1),
(341, 2, 125, 1),
(342, 2, 126, 1),
(343, 2, 127, 1),
(344, 2, 128, 1),
(345, 3, 124, 1),
(346, 3, 125, 1),
(347, 3, 126, 1),
(348, 3, 127, 1),
(349, 3, 128, 1),
(350, 1, 130, 1),
(351, 1, 131, 1),
(352, 2, 130, 1),
(353, 2, 131, 1),
(354, 3, 130, 1),
(355, 3, 131, 1),
(356, 1, 132, 1),
(357, 2, 132, 1),
(358, 3, 132, 1),
(359, 1, 133, 1),
(360, 2, 133, 1),
(361, 3, 133, 1),
(362, 1, 134, 1),
(363, 1, 135, 1),
(364, 3, 135, 1),
(365, 1, 136, 1),
(366, 1, 137, 1),
(367, 1, 138, 1),
(368, 1, 139, 1),
(369, 1, 140, 1),
(370, 1, 141, 1),
(371, 2, 141, 1),
(372, 3, 141, 1),
(373, 1, 142, 1),
(374, 2, 142, 1),
(375, 3, 142, 1),
(376, 1, 144, 1),
(377, 1, 145, 1),
(378, 2, 145, 1),
(379, 3, 145, 1),
(380, 4, 145, 1),
(381, 6, 145, 1),
(382, 7, 145, 1),
(383, 1, 146, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]health`
--

CREATE TABLE `[[dbprefix]]health` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `icon` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]health`
--

INSERT INTO `[[dbprefix]]health` VALUES
(1, 'secured', '#32CD32', 100, 0, NULL),
(2, 'surveyed', '#ffd700', 200, 0, NULL),
(3, 'in danger', '#FF0000', 300, 0, NULL),
(4, 'crashed', '#000000', 400, 0, NULL),
(5, 'paused', '#E0E0E0', 500, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]highlight`
--

CREATE TABLE `[[dbprefix]]highlight` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `operation` varchar(10) DEFAULT NULL,
  `colName` varchar(200) DEFAULT NULL,
  `oldValue` mediumtext,
  `newValue` mediumtext,
  `operationDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isWorkHistory` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `historyUser` (`idUser`),
  KEY `historyRef` (`refType`,`refId`),
  KEY `historyOperationDate` (`operationDate`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=23 ;

--
-- Dumping data for table `[[dbprefix]]history`
--

INSERT INTO `[[dbprefix]]history` VALUES
(1, 'User', 1, 'update', 'apiKey', NULL, '[[apiKeyid1]]', '[[regtime]]', NULL, 0, NULL),
(2, 'User', 1, 'update', 'passwordChangeDate', NULL, '[[date]]', '[[regtime]]', NULL, 0, NULL),
(3, 'User', 2, 'update', 'apiKey', NULL, '[[apiKeyid2]]', '[[regtime]]', NULL, 0, NULL),
(4, 'User', 2, 'update', 'passwordChangeDate', NULL, '[[date]]', '[[regtime]]', NULL, 0, NULL),
(5, 'DeliveryType', 206, 'insert', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(6, 'DeliveryType', 207, 'insert', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(7, 'DeliveryType', 208, 'insert', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(8, 'Module', 13, 'update', 'active', '1', '0', '[[regtime]]', NULL, 0, NULL),
(9, 'ModuleMenu', 56, 'update', 'active', '1', '0', '[[regtime]]', NULL, 0, NULL),
(10, 'ModuleMenu', 64, 'update', 'active', '1', '0', '[[regtime]]', NULL, 0, NULL),
(11, 'ReportParameter', 565, 'insert', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(12, 'Kanban', 1, 'insert', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(13, 'Habilitation', 484, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(14, 'Habilitation', 510, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(15, 'HabilitationReport', 173, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(16, 'HabilitationReport', 174, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(17, 'HabilitationReport', 175, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(18, 'HabilitationReport', 176, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(19, 'HabilitationReport', 293, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(20, 'AccessRight', 211, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(21, 'ReportParameter', 495, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL),
(22, 'ReportParameter', 494, 'delete', NULL, NULL, NULL, '[[regtime]]', NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]historyarchive`
--

CREATE TABLE `[[dbprefix]]historyarchive` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `operation` varchar(10) DEFAULT NULL,
  `colName` varchar(200) DEFAULT NULL,
  `oldValue` mediumtext,
  `newValue` mediumtext,
  `operationDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isWorkHistory` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `historyarchiveRef` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]importable`
--

CREATE TABLE `[[dbprefix]]importable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=85 ;

--
-- Dumping data for table `[[dbprefix]]importable`
--

INSERT INTO `[[dbprefix]]importable` VALUES
(1, 'Ticket', 0),
(2, 'Activity', 0),
(3, 'Milestone', 0),
(4, 'Risk', 0),
(5, 'Action', 0),
(6, 'Issue', 0),
(7, 'Meeting', 0),
(8, 'Decision', 0),
(9, 'Question', 0),
(10, 'IndividualExpense', 0),
(11, 'ProjectExpense', 0),
(12, 'Client', 0),
(13, 'Contact', 0),
(14, 'Project', 0),
(15, 'Team', 0),
(16, 'Resource', 0),
(17, 'Affectation', 0),
(18, 'Assignment', 0),
(19, 'Product', 0),
(20, 'ProductVersion', 0),
(21, 'Document', 0),
(22, 'Requirement', 0),
(23, 'TestCase', 0),
(24, 'TestSession', 0),
(25, 'TestCaseRun', 0),
(26, 'Opportunity', 0),
(27, 'Command', 0),
(28, 'Quotation', 0),
(29, 'Work', 0),
(30, 'Component', 0),
(31, 'ComponentVersion', 0),
(32, 'ProductStructure', 0),
(33, 'Bill', 0),
(34, 'Payment', 0),
(35, 'ResourceCost', 0),
(42, 'DocumentDirectory', 0),
(43, 'Provider', 0),
(44, 'User', 0),
(45, 'DocumentVersion', 0),
(46, 'Organization', 0),
(47, 'Deliverable', 0),
(48, 'Incoming', 0),
(49, 'Delivery', 0),
(50, 'Tender', 0),
(51, 'CallForTender', 0),
(52, 'ActivityPrice', 0),
(53, 'Term', 0),
(54, 'Budget', 0),
(55, 'ChangeRequest', 0),
(56, 'ProviderOrder', 0),
(57, 'ProviderBill', 0),
(58, 'SupplierContract', 0),
(59, 'ClientContract', 0),
(60, 'Asset', 0),
(61, 'Brand', 0),
(62, 'Model', 0),
(63, 'Location', 0),
(64, 'IncomingMail', 0),
(65, 'OutgoingMail', 0),
(66, 'ProductVersionStructure', 0),
(67, 'BillLine', 0),
(68, 'Role', 0),
(69, 'Skill', 0),
(70, 'ResourceSkill', 0),
(71, 'ImputationWork', 0),
(72, 'ActivityWorkUnit', 0),
(73, 'ActivityExpense', 0),
(74, 'LessonLearned', 0),
(75, 'Assumption', 0),
(76, 'Constraint', 0),
(77, 'Prospect', 0),
(78, 'DomainProspect', 0),
(79, 'PositionProspect', 0),
(80, 'DecisionMakerProspect', 0),
(81, 'ProspectOrigin', 0),
(82, 'ProspectEvent', 0),
(83, 'ResourceTeam', 0),
(84, 'ResourceTeamAffectation', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]importlog`
--

CREATE TABLE `[[dbprefix]]importlog` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `mode` varchar(10) DEFAULT 'manual',
  `importDateTime` datetime DEFAULT NULL,
  `importFile` varchar(1000) DEFAULT NULL,
  `importClass` varchar(100) DEFAULT NULL,
  `importStatus` varchar(10) DEFAULT NULL,
  `importTodo` int(6) DEFAULT NULL COMMENT '6',
  `importDone` int(6) DEFAULT NULL COMMENT '6',
  `importDoneCreated` int(6) DEFAULT NULL COMMENT '6',
  `importDoneModified` int(6) DEFAULT NULL COMMENT '6',
  `importDoneUnchanged` int(6) DEFAULT NULL COMMENT '6',
  `importRejected` int(6) DEFAULT NULL COMMENT '6',
  `importRejectedInvalid` int(6) DEFAULT NULL COMMENT '6',
  `importRejectedError` int(6) DEFAULT NULL COMMENT '6',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]incomingmail`
--

CREATE TABLE `[[dbprefix]]incomingmail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idIncomingMailType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResponsible` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `receptionDate` date DEFAULT NULL,
  `idDeliveryMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `descriptionTransmitter` mediumtext,
  `description` mediumtext,
  `idApprovalStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]indicator`
--

CREATE TABLE `[[dbprefix]]indicator` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `targetDateColumnName` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=36 ;

--
-- Dumping data for table `[[dbprefix]]indicator`
--

INSERT INTO `[[dbprefix]]indicator` VALUES
(1, 'initialDueDateTime', 'IDDT', 'delay', 110, 0, NULL),
(2, 'actualDueDateTime', 'ADDT', 'delay', 120, 0, NULL),
(3, 'initialDueDate', 'IDD', 'delay', 130, 0, NULL),
(4, 'actualDueDate', 'ADD', 'delay', 140, 0, NULL),
(5, 'initialEndDate', 'IED', 'delay', 150, 0, NULL),
(6, 'validatedEndDate', 'VED', 'delay', 160, 0, NULL),
(7, 'plannedEndDate', 'PED', 'delay', 170, 0, NULL),
(8, 'initialStartDate', 'ISD', 'delay', 180, 0, NULL),
(9, 'validatedStartDate', 'VSD', 'delay', 190, 0, NULL),
(10, 'plannedStartDate', 'PSD', 'delay', 200, 0, NULL),
(11, 'PlannedCostOverValidatedCost', 'PCOVC', 'percent', 210, 0, NULL),
(12, 'PlannedCostOverAssignedCost', 'PCOAC', 'percent', 220, 0, NULL),
(13, 'PlannedWorkOverValidatedWork', 'PWOVW', 'percent', 230, 0, NULL),
(14, 'PlannedWorkOverAssignedWork', 'PWOAW', 'percent', 240, 0, NULL),
(15, 'RealWorkOverValidatedWork', 'RWOVW', 'percent', 250, 0, NULL),
(16, 'RealWorkOverAssignedWork', 'RWOAW', 'percent', 260, 0, NULL),
(17, 'expectedTenderDateTime', 'DELAY', 'delay', 310, 0, 'receptionDateTime'),
(18, 'expensePlannedDate', 'DELAY', 'delay', 320, 0, 'expenseRealDate'),
(19, 'deliveryDate', 'DELAY', 'delay', 330, 0, 'receptionDate'),
(20, 'validityEndDate', 'DELAY', 'delay', 340, 0, 'idleDate'),
(21, 'validatedDate', 'DELAY', 'delay', 350, 0, 'idBill'),
(22, 'plannedDate', 'DELAY', 'delay', 360, 0, 'idBill'),
(23, 'date', 'DELAY', 'delay', 370, 0, 'idBill'),
(24, 'paymentDueDate', 'DELAY', 'delay', 380, 0, 'paymentDate'),
(25, 'meetingDate', 'DELAY', 'delay', 390, 0, 'done'),
(26, 'date', 'DELAY', 'delay', 400, 0, 'sendDate'),
(27, 'deliveryExpectedDate', 'DELAY', 'delay', 410, 0, 'deliveryDoneDate'),
(28, 'date', 'DELAY', 'delay', 420, 0, 'isPaid'),
(29, 'CaMoreThanCommandSum', 'CACS', 'percent', 430, 0, NULL),
(30, 'CaLessThanBillSum', 'CABS', 'percent', 440, 0, NULL),
(31, 'RealWorkOverPlannedWork', 'RWOPW', 'percent', 270, 0, NULL),
(32, 'PlannedExpenseOverAssignedExpense', 'PEOAE', 'percent', 275, 0, NULL),
(33, 'PlannedExpenseOverValidatedExpense', 'PEOVE', 'percent', 280, 0, NULL),
(34, 'RealExpenseOverAssignedExpense', 'REOAE', 'percent', 285, 0, NULL),
(35, 'RealExpenseOverValidatedExpense', 'REOVE', 'percent', 290, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]indicatorable`
--

CREATE TABLE `[[dbprefix]]indicatorable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]indicatorable`
--

INSERT INTO `[[dbprefix]]indicatorable` VALUES
(1, 'Ticket', 0),
(2, 'Activity', 0),
(3, 'Milestone', 0),
(4, 'Risk', 0),
(5, 'Action', 0),
(6, 'Issue', 0),
(7, 'Question', 0),
(8, 'Project', 0),
(9, 'TestSession', 0),
(12, 'Requirement', 0),
(14, 'Tender', 0),
(15, 'IndividualExpense', 0),
(16, 'ProjectExpense', 0),
(17, 'Quotation', 0),
(18, 'Command', 0),
(19, 'Term', 0),
(20, 'Bill', 0),
(21, 'Meeting', 0),
(22, 'ProviderOrder', 0),
(23, 'ProviderTerm', 0),
(24, 'ProviderBill', 0),
(25, 'IndividualExpense', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]indicatorableindicator`
--

CREATE TABLE `[[dbprefix]]indicatorableindicator` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idIndicatorable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `nameIndicatorable` varchar(100) DEFAULT NULL,
  `idIndicator` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `indicatorableindicatorIndicatorable` (`idIndicatorable`),
  KEY `indicatorableindicatorIndicator` (`idIndicator`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=83 ;

--
-- Dumping data for table `[[dbprefix]]indicatorableindicator`
--

INSERT INTO `[[dbprefix]]indicatorableindicator` VALUES
(1, 1, 'Ticket', 1, 0),
(2, 1, 'Ticket', 2, 0),
(3, 4, 'Risk', 3, 0),
(4, 5, 'Action', 3, 0),
(5, 6, 'Issue', 3, 0),
(6, 7, 'Question', 3, 0),
(7, 4, 'Risk', 4, 0),
(8, 5, 'Action', 4, 0),
(9, 6, 'Issue', 4, 0),
(10, 7, 'Question', 4, 0),
(11, 2, 'Activity', 5, 0),
(12, 3, 'Milestone', 5, 0),
(13, 8, 'Project', 5, 0),
(14, 2, 'Activity', 6, 0),
(15, 3, 'Milestone', 6, 0),
(16, 8, 'Project', 6, 0),
(17, 2, 'Activity', 7, 0),
(18, 3, 'Milestone', 7, 0),
(19, 8, 'Project', 7, 0),
(20, 2, 'Activity', 8, 0),
(21, 8, 'Project', 8, 0),
(22, 2, 'Activity', 9, 0),
(23, 8, 'Project', 9, 0),
(24, 2, 'Activity', 10, 0),
(25, 8, 'Project', 10, 0),
(26, 2, 'Activity', 11, 0),
(27, 8, 'Project', 11, 0),
(28, 2, 'Activity', 12, 0),
(29, 8, 'Project', 12, 0),
(30, 2, 'Activity', 13, 0),
(31, 8, 'Project', 13, 0),
(32, 2, 'Activity', 14, 0),
(33, 8, 'Project', 14, 0),
(34, 2, 'Activity', 15, 0),
(35, 8, 'Project', 15, 0),
(36, 2, 'Activity', 16, 0),
(37, 8, 'Project', 16, 0),
(38, 9, 'TestSession', 6, 0),
(39, 9, 'TestSession', 7, 0),
(40, 9, 'TestSession', 8, 0),
(41, 9, 'TestSession', 9, 0),
(42, 9, 'TestSession', 10, 0),
(43, 9, 'TestSession', 11, 0),
(44, 9, 'TestSession', 12, 0),
(45, 9, 'TestSession', 13, 0),
(46, 9, 'TestSession', 14, 0),
(47, 9, 'TestSession', 15, 0),
(48, 9, 'TestSession', 16, 0),
(55, 12, 'Requirement', 3, 0),
(56, 12, 'Requirement', 4, 0),
(57, 14, 'Tender', 17, 0),
(58, 15, 'IndividualExpense', 18, 0),
(59, 16, 'ProjectExpense', 18, 0),
(60, 16, 'ProjectExpense', 19, 0),
(61, 17, 'Quotation', 20, 0),
(62, 18, 'Command', 5, 0),
(63, 18, 'Command', 6, 0),
(64, 19, 'Term', 21, 0),
(65, 19, 'Term', 22, 0),
(66, 19, 'Term', 23, 0),
(67, 20, 'Bill', 24, 0),
(68, 21, 'Meeting', 25, 0),
(69, 20, 'Bill', 26, 0),
(70, 22, 'ProviderOrder', 27, 0),
(71, 24, 'ProviderBill', 24, 0),
(72, 23, 'ProviderTerm', 28, 0),
(73, 8, 'Project', 29, 0),
(74, 8, 'Project', 30, 0),
(75, 2, 'Activity', 31, 0),
(76, 9, 'TestSession', 31, 0),
(77, 8, 'Project', 31, 0),
(78, 8, 'Project', 32, 0),
(79, 8, 'Project', 33, 0),
(80, 8, 'Project', 34, 0),
(81, 8, 'Project', 35, 0),
(82, 82, 'ActivityExpense', 25, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]indicatordefinition`
--

CREATE TABLE `[[dbprefix]]indicatordefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idIndicatorable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `nameIndicatorable` varchar(100) DEFAULT NULL,
  `idIndicator` int(12) unsigned DEFAULT NULL COMMENT '12',
  `codeIndicator` varchar(10) DEFAULT NULL,
  `typeIndicator` varchar(10) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `warningValue` decimal(6,3) DEFAULT NULL,
  `idWarningDelayUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `codeWarningDelayUnit` varchar(10) DEFAULT NULL,
  `alertValue` decimal(6,3) DEFAULT NULL,
  `idAlertDelayUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `codeAlertDelayUnit` varchar(10) DEFAULT NULL,
  `mailToUser` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToResource` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToContact` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToLeader` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToOther` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToUser` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToResource` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToContact` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToLeader` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToAssigned` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToManager` int(1) unsigned DEFAULT '0' COMMENT '1',
  `otherMail` varchar(4000) DEFAULT NULL,
  `alertToAssigned` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToManager` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToSubscribers` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToSubscribers` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) DEFAULT NULL COMMENT '12',
  `isProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToProjectIncludingParentProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToProjectIncludingParentProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToAccountable` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToAccountable` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `indicatordefinitionIndicatorable` (`idIndicatorable`),
  KEY `indicatordefinitionIndicator` (`idIndicator`),
  KEY `indicatordefinitionType` (`idType`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]indicatordefinition`
--

INSERT INTO `[[dbprefix]]indicatordefinition` VALUES
(1, 1, 'actualDueDateTime', 'Ticket', 2, 'ADDT', 'delay', NULL, '1.000', 1, 'HH', '0.000', 1, 'HH', 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0),
(2, 1, 'initialDueDateTime', 'Ticket', 1, 'IDDT', 'delay', NULL, '0.000', 1, 'HH', NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0),
(3, 2, 'validatedEndDate', 'Activity', 6, 'VED', 'delay', NULL, '1.000', 4, 'OD', '0.000', 1, 'HH', 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0),
(4, 2, 'PlannedWorkOverValidatedWork', 'Activity', 13, 'PWOVW', 'percent', NULL, '100.000', 5, 'PCT', '110.000', 5, 'PCT', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0),
(5, 5, 'actualDueDate', 'Action', 4, 'ADD', 'delay', NULL, '1.000', 4, 'OD', '1.000', 2, 'OH', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0),
(6, 3, 'validatedEndDate', 'Milestone', 6, 'VED', 'delay', 25, '1.000', 4, 'OD', NULL, NULL, NULL, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]indicatorvalue`
--

CREATE TABLE `[[dbprefix]]indicatorvalue` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(10) unsigned DEFAULT NULL COMMENT '10',
  `idIndicatorDefinition` int(10) unsigned DEFAULT NULL COMMENT '10',
  `targetDateTime` datetime DEFAULT NULL,
  `targetValue` decimal(11,2) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `warningTargetDateTime` datetime DEFAULT NULL,
  `warningTargetValue` decimal(11,2) DEFAULT NULL,
  `warningSent` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertTargetDateTime` datetime DEFAULT NULL,
  `alertTargetValue` decimal(11,2) DEFAULT NULL,
  `alertSent` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `status` varchar(2) DEFAULT NULL,
  `targetDateColumnName` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `indicatorvalueIndicatordefinition` (`idIndicatorDefinition`),
  KEY `indicatorvalueReference` (`refType`,`refId`),
  KEY `indicatorvalueType` (`type`,`idle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inputmailboxhistory`
--

CREATE TABLE `[[dbprefix]]inputmailboxhistory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idInputMailbox` int(12) unsigned DEFAULT NULL COMMENT '12',
  `adress` varchar(200) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `result` varchar(200) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inputmailboximport`
--

CREATE TABLE `[[dbprefix]]inputmailboximport` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `serverImap` varchar(200) DEFAULT NULL,
  `imapUserAccount` varchar(200) DEFAULT NULL,
  `pwdImap` varchar(50) DEFAULT NULL,
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lastInputDate` datetime DEFAULT NULL,
  `failedRead` int(1) unsigned DEFAULT '0' COMMENT '1',
  `failedMessage` int(1) unsigned DEFAULT '0' COMMENT '1',
  `limitOfHistory` int(6) unsigned DEFAULT '0' COMMENT '6',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `autoclosedReason` varchar(200) DEFAULT NULL,
  `autoclosedDateTime` datetime DEFAULT NULL,
  `limitOfInputPerHourImport` int(6) unsigned DEFAULT '0' COMMENT '6',
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  `actionOK` varchar(10) DEFAULT 'READ',
  `actionKO` varchar(10) DEFAULT 'READ',
  `idOAuthClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `connectionMode` varchar(100) DEFAULT 'basic',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inputmailboxticket`
--

CREATE TABLE `[[dbprefix]]inputmailboxticket` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `serverImap` varchar(200) DEFAULT NULL,
  `imapUserAccount` varchar(200) DEFAULT NULL,
  `pwdImap` varchar(50) DEFAULT NULL,
  `securityConstraint` varchar(10) DEFAULT NULL,
  `allowAttach` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sizeAttachment` int(6) unsigned DEFAULT '5' COMMENT '6',
  `idTicketType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lastInputDate` datetime DEFAULT NULL,
  `idTicket` int(12) unsigned DEFAULT NULL COMMENT '12',
  `totalInputTicket` int(12) unsigned DEFAULT '0' COMMENT '12',
  `failedRead` int(1) unsigned DEFAULT '0' COMMENT '1',
  `failedMessage` int(1) unsigned DEFAULT '0' COMMENT '1',
  `limitOfInputPerHour` int(6) unsigned DEFAULT '0' COMMENT '6',
  `limitOfHistory` int(6) unsigned DEFAULT '0' COMMENT '6',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `autoclosedReason` varchar(200) DEFAULT NULL,
  `autoclosedDateTime` datetime DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  `actionOK` varchar(10) DEFAULT 'READ',
  `actionKO` varchar(10) DEFAULT 'READ',
  `addToFollowUp` int(1) unsigned DEFAULT '0' COMMENT '1',
  `addPseudoUsers` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idOAuthClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `connectionMode` varchar(100) DEFAULT 'basic',
  PRIMARY KEY (`id`),
  KEY `inputmailboxProject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]interventioncapacity`
--

CREATE TABLE `[[dbprefix]]interventioncapacity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `month` varchar(6) DEFAULT NULL,
  `fte` decimal(3,1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `interventioncapacityRef` (`refType`,`refId`,`month`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]interventionmode`
--

CREATE TABLE `[[dbprefix]]interventionmode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `letter` varchar(3) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]interventionmode`
--

INSERT INTO `[[dbprefix]]interventionmode` VALUES
(1, 'Teleworking', 'T', 10, 0, NULL),
(2, 'On remote site', 'R', 20, 0, NULL),
(3, 'On-call duty', 'C', 30, 0, NULL),
(4, 'Hotline', 'H', 40, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]issue`
--

CREATE TABLE `[[dbprefix]]issue` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idIssueType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cause` mediumtext,
  `impact` mediumtext,
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialEndDate` date DEFAULT NULL,
  `actualEndDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `idCriticality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `issueProject` (`idProject`),
  KEY `issueUser` (`idUser`),
  KEY `issueResource` (`idResource`),
  KEY `issueStatus` (`idStatus`),
  KEY `issueType` (`idIssueType`),
  KEY `issuePriority` (`idPriority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]job`
--

CREATE TABLE `[[dbprefix]]job` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idJoblistDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idJobDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` datetime DEFAULT NULL,
  `checkTime` datetime DEFAULT NULL,
  `comment` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobJobDefinition` (`idJobDefinition`),
  KEY `jobJoblistDefinition` (`idJoblistDefinition`),
  KEY `jobReference` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]jobdefinition`
--

CREATE TABLE `[[dbprefix]]jobdefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idJoblistDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `title` varchar(1000) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `daysBeforeWarning` int(3) DEFAULT NULL COMMENT '3',
  PRIMARY KEY (`id`),
  KEY `jobdefinitionJoblistDefinition` (`idJoblistDefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]joblistdefinition`
--

CREATE TABLE `[[dbprefix]]joblistdefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idChecklistable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `nameChecklistable` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lineCount` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `joblistdefinitionChecklistable` (`idChecklistable`),
  KEY `joblistdefinitionNameChecklistable` (`nameChecklistable`),
  KEY `joblistdefinitionType` (`idType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kanban`
--

CREATE TABLE `[[dbprefix]]kanban` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) DEFAULT NULL COMMENT '12',
  `isShared` int(1) DEFAULT NULL COMMENT '1',
  `name` varchar(64) DEFAULT NULL,
  `type` varchar(64) DEFAULT NULL,
  `param` varchar(10000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]kanban`
--

INSERT INTO `[[dbprefix]]kanban` VALUES
(1, NULL, 0, 'Kanban', 'Status', '{"column":[{"from":"1","name":"Backlog","cantDelete":true},{"from":"10","name":"In progress"},{"from":"4","name":"Done"},{"from":"7","name":"Closed"}],"typeData":"Ticket"}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kpidefinition`
--

CREATE TABLE `[[dbprefix]]kpidefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `kpidefinitionCode` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]kpidefinition`
--

INSERT INTO `[[dbprefix]]kpidefinition` VALUES
(1, 'project duration KPI', 'duration', '\n<b>KPI for not ended project = [project planned duration] / [project validated duration]</b><br/>\n<b>KPI for ended project = [project real duration] / [project validated duration]</b><br/>\n<br/>\nKPI < 1 => project is shorter than expected<br/>\nKPI = 1 => project is exactly as long as expected<br/>\nKPI > 1 => project is longer than expected<br/>\n<br/>\nThis indicator is consolidated amongst projects (for organization) without weighting.', 0),
(2, 'project workload KPI', 'workload', '\n<b>KPI for project = ( [project real work] + [project left work] / [project validated work]</b><br/>\n<br/>\nKPI < 1 => project workload is less than expected<br/>\nKPI = 1 => project workload is conform to expected<br/>\nKPI > 1 => project workload is more than expected<br/>\n<br/>\nThis indicator is consolidated amongst projects (for organization) with weighting on [project validated work].', 0),
(3, 'project terms KPI', 'term', '\n<b>KPI for project = [sum of real amount for all project terms] / [sum of validated amount for all project terms]</b><br/>\n<br/>\nThis indicator has no intrinsic meaning but has some compared to project progress.<br/>\nSo for this indicator, thresholds will not be compared to KPI value directly but to : [project progress] - [KPI value] <br/>(that should then be as small as possible).<br/>\n<br/>\nThis indicator is not consolidated amongst projects (for organization).', 0),
(4, 'project deliverables quality KPI', 'deliverable', '\n<b>KPI for deliverable = [Estimated quality value of deliverable] / [Nominal (max) quality value for deliverables]</b><br/>\nQuality value is defined in the deliverable status list, that will be selected on the deliverable.<br/>\nNominal quality value is the max of the values defined in the deliverable status list.<br/>\n<b>KPI consolidated on project = Sum of ([Estimated quality value of deliverables]*[Weighting of deliverable]) / Sum([Nominal (max) quality value of deliverables]*[Weighting of deliverable])</b><br/>\nWeigting value of deliverable is defined in the deliverable weighting list, that will be selected on the deliverable.<br/>\nConsolidated value may not be calculated if all deliverables have zero weight.<br/>\nUnitary value of KPI for single deliverable is not stored in KPI history. Only consolidated value for project is stored is KPI history.<br/>\n<br/>\nThis indicator is consolidated amongst projects (for organization) with weighting on global weight of deliverables on each project.', 0),
(5, 'project incomings quality KPI', 'incoming', '\n<b>KPI for incoming = ( [Estimated Quality value of incoming] / [Nominal (max) Quality value for incomings]</b><br/>\nQuality value is defined in the incoming Status list, that will be selected on the incoming.<br/>\nNominal Quality value is the max of the values defined in the incoming Status list.<br/>\n<b>KPI consolidated on project = ( Sum of ([Estimated Quality value of incomings]*[Weighting of incoming]) / Sum([Nominal (max) Quality value of incomings]*[Weighting of incoming])</b><br/>\nWeigting value of incoming is defined in the incoming Weighting list, that will be selected on the incoming.<br/>\nConsolidated value may not be calculated if all incomings have zero weight.<br/>\nUnitary value of KPI for single incoming is not stored in KPI history. Only consolidated value for project is stored is KPI history.<br/>\n<br/>\nThis indicator is consolidated amongst projects (for organization) with weighting on global weight of incomings on each project.', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kpihistory`
--

CREATE TABLE `[[dbprefix]]kpihistory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idKpiDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `kpiType` varchar(1) DEFAULT NULL,
  `kpiDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `kpiValue` decimal(5,2) DEFAULT NULL,
  `weight` decimal(14,5) DEFAULT NULL,
  `refDone` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `kpihistoryKpiDefinitionReferenceDate` (`idKpiDefinition`,`refType`,`refId`,`kpiDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kpithreshold`
--

CREATE TABLE `[[dbprefix]]kpithreshold` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idKpiDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `thresholdValue` decimal(5,2) DEFAULT NULL,
  `thresholdColor` varchar(7) DEFAULT '#FFFFFF',
  PRIMARY KEY (`id`),
  KEY `kpithresholdKpiDefinition` (`idKpiDefinition`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]kpithreshold`
--

INSERT INTO `[[dbprefix]]kpithreshold` VALUES
(1, 'good', 1, '0.00', '#98fb98'),
(2, 'acceptable', 1, '1.20', '#f4a460'),
(3, 'not acceptable', 1, '1.50', '#f08080'),
(4, 'good', 2, '0.00', '#98fb98'),
(5, 'acceptable', 2, '1.20', '#f4a460'),
(6, 'not acceptable', 2, '1.50', '#f08080'),
(7, 'sufficient', 3, '0.00', '#98fb98'),
(8, 'partially sufficient', 3, '0.40', '#f4a460'),
(9, 'not sufficient', 3, '0.70', '#f08080'),
(10, 'not good', 4, '0.00', '#f08080'),
(11, 'good', 4, '0.66', '#98fb98'),
(12, 'not good', 5, '0.00', '#f08080'),
(13, 'good', 5, '0.66', '#98fb98');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kpivalue`
--

CREATE TABLE `[[dbprefix]]kpivalue` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idKpiDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `kpiType` varchar(1) DEFAULT NULL,
  `kpiDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `kpiValue` decimal(5,2) DEFAULT NULL,
  `weight` decimal(14,5) DEFAULT NULL,
  `refDone` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `kpivalueKpiDefinition` (`idKpiDefinition`),
  KEY `kpivalueReference` (`refType`,`refId`),
  KEY `kpivaluerequestReference` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kpivaluerequest`
--

CREATE TABLE `[[dbprefix]]kpivaluerequest` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `requestDate` date DEFAULT NULL,
  `requestDateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language`
--

CREATE TABLE `[[dbprefix]]language` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(10) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languageskilllevel`
--

CREATE TABLE `[[dbprefix]]languageskilllevel` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]languageskilllevel`
--

INSERT INTO `[[dbprefix]]languageskilllevel` VALUES
(1, 'beginner', '#ff0000', 10, 0),
(2, 'intermediate', '#ffa500', 20, 0),
(3, 'advanced', '#00ff00', 30, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layout`
--

CREATE TABLE `[[dbprefix]]layout` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned NOT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `objectClass` varchar(50) DEFAULT NULL,
  `isShared` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isDefault` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  `comment` mediumtext,
  PRIMARY KEY (`id`),
  KEY `layoutUser` (`idUser`),
  KEY `layoutObjectClass` (`objectClass`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layoutcolumnselector`
--

CREATE TABLE `[[dbprefix]]layoutcolumnselector` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idLayout` int(12) unsigned NOT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `objectClass` varchar(50) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `field` varchar(100) DEFAULT NULL,
  `attribute` varchar(100) DEFAULT NULL,
  `hidden` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  `widthPct` int(3) unsigned DEFAULT '0' COMMENT '3',
  `name` varchar(100) DEFAULT NULL,
  `subItem` varchar(100) DEFAULT NULL,
  `formatter` varchar(100) DEFAULT NULL,
  `isReportList` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `layoutcolumnselectorLayout` (`idLayout`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layoutforced`
--

CREATE TABLE `[[dbprefix]]layoutforced` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLayout` int(12) unsigned NOT NULL COMMENT '12',
  `objectClass` varchar(50) DEFAULT NULL,
  `idCreator` int(12) unsigned NOT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `layoutforcedObjectClass` (`objectClass`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layoutgroup`
--

CREATE TABLE `[[dbprefix]]layoutgroup` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layoutgroupuser`
--

CREATE TABLE `[[dbprefix]]layoutgroupuser` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idLayoutGroup` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `layoutgroupuserLayoutGroup` (`idLayoutGroup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]leavessystemhabilitation`
--

CREATE TABLE `[[dbprefix]]leavessystemhabilitation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `menuName` varchar(100) NOT NULL,
  `viewAccess` varchar(10) DEFAULT NULL,
  `readAccess` varchar(10) DEFAULT NULL,
  `createAccess` varchar(10) DEFAULT NULL,
  `updateAccess` varchar(10) DEFAULT NULL,
  `deleteAccess` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leavessystemhabilitationMenu` (`menuName`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]leavessystemhabilitation`
--

INSERT INTO `[[dbprefix]]leavessystemhabilitation` VALUES
(1, 'menuHumanResource', 'AME', NULL, NULL, NULL, NULL),
(2, 'menuHumanResourceParameters', 'AME', NULL, NULL, NULL, NULL),
(3, 'menuLeavesSystemHabilitation', 'A', 'A', 'A', 'A', 'A'),
(4, 'menuEmploymentContractType', 'AM', 'AM', 'AM', 'AM', 'AM'),
(5, 'menuLeaveCalendar', 'E', NULL, NULL, NULL, NULL),
(6, 'menuLeaveType', 'A', 'A', 'A', 'A', 'A'),
(7, 'menuLeave', 'E', 'AmO', 'E', 'AmO', 'AmO'),
(8, 'menuEmployee', 'AME', 'AmO', '', 'AmO', ''),
(9, 'menuEmploymentContract', 'AME', 'AmO', 'AM', 'AmO', 'A'),
(10, 'menuEmployeeLeaveEarned', 'E', 'AMO', 'AM', 'AM', 'AM'),
(11, 'menuEmploymentContractEndReason', 'A', 'A', 'A', 'A', 'A'),
(12, 'menuLeaveTypeOfEmploymentContractType', 'A', 'A', 'A', 'A', 'A'),
(13, 'menuEmployeeManager', 'AM', 'AMO', 'AM', 'AM', 'AO'),
(14, 'menuDelegationManager', 'AM', 'AME', 'AO', 'AO', 'AO'),
(15, 'menuDashboardEmployeeManager', 'Am', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]leavetype`
--

CREATE TABLE `[[dbprefix]]leavetype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkflow` int(12) unsigned DEFAULT NULL COMMENT '12',
  `color` varchar(7) DEFAULT NULL,
  `notificationOnCreate` varchar(255) DEFAULT NULL,
  `notificationOnUpdate` varchar(255) DEFAULT NULL,
  `notificationOnDelete` varchar(255) DEFAULT NULL,
  `notificationOnTreatment` varchar(255) DEFAULT NULL,
  `alertOnCreate` varchar(255) DEFAULT NULL,
  `alertOnUpdate` varchar(255) DEFAULT NULL,
  `alertOnDelete` varchar(255) DEFAULT NULL,
  `alertOnTreatment` varchar(255) DEFAULT NULL,
  `emailOnCreate` varchar(255) DEFAULT NULL,
  `emailOnUpdate` varchar(255) DEFAULT NULL,
  `emailOnDelete` varchar(255) DEFAULT NULL,
  `emailOnTreatment` varchar(255) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `notRequiredRight` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]leavetypeofemploymentcontracttype`
--

CREATE TABLE `[[dbprefix]]leavetypeofemploymentcontracttype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idEmploymentContractType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLeaveType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startMonthPeriod` varchar(2) DEFAULT NULL,
  `startDayPeriod` varchar(2) DEFAULT NULL,
  `periodDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  `quantity` decimal(4,1) unsigned DEFAULT NULL,
  `isIntegerQuotity` int(1) unsigned DEFAULT '0' COMMENT '1',
  `earnedPeriod` int(5) unsigned DEFAULT NULL COMMENT '5',
  `isUnpayedAllowed` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isJustifiable` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isAnticipated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `validityDuration` int(5) unsigned DEFAULT '12' COMMENT '5',
  `nbDaysAfterNowLeaveDemandIsAllowed` int(5) unsigned DEFAULT NULL COMMENT '5',
  `nbDaysBeforeNowLeaveDemandIsAllowed` int(5) unsigned DEFAULT NULL COMMENT '5',
  `hasNoRight` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lessonlearned`
--

CREATE TABLE `[[dbprefix]]lessonlearned` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLessonLearnedType` int(12) unsigned NOT NULL COMMENT '12',
  `description` mediumtext,
  `idStatus` int(12) unsigned NOT NULL COMMENT '12',
  `actionPlan` mediumtext,
  `result` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idResource` int(12) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lessonlearnproject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]likelihood`
--

CREATE TABLE `[[dbprefix]]likelihood` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `valuePct` int(3) unsigned DEFAULT '0' COMMENT '3',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]likelihood`
--

INSERT INTO `[[dbprefix]]likelihood` VALUES
(1, 'Low (10%)', 1, '#32cd32', 10, 0, 10),
(2, 'Medium (50%)', 2, '#ffd700', 20, 0, 50),
(3, 'High (90%)', 4, '#ff0000', 30, 0, 90);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]link`
--

CREATE TABLE `[[dbprefix]]link` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `ref1Type` varchar(100) DEFAULT NULL,
  `ref1Id` int(12) unsigned DEFAULT NULL COMMENT '12',
  `ref2Type` varchar(100) DEFAULT NULL,
  `ref2Id` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(4000) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSynchronizationItem` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `linkRef1` (`ref1Type`,`ref1Id`),
  KEY `linkRef2` (`ref2Type`,`ref2Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]linkable`
--

CREATE TABLE `[[dbprefix]]linkable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idDefaultLinkable` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]linkable`
--

INSERT INTO `[[dbprefix]]linkable` VALUES
(1, 'Action', 0, 3),
(2, 'Issue', 0, 1),
(3, 'Risk', 0, 1),
(4, 'Meeting', 0, 5),
(5, 'Decision', 0, 4),
(6, 'Question', 0, 4),
(7, 'Ticket', 0, 7),
(8, 'Activity', 0, 8),
(9, 'Milestone', 0, 21),
(10, 'Document', 0, 10),
(11, 'Requirement', 0, 12),
(12, 'TestCase', 0, 11),
(13, 'TestSession', 0, 8),
(14, 'Project', 0, 14),
(15, 'IndividualExpense', 0, 4),
(16, 'ProjectExpense', 0, 8),
(17, 'Opportunity', 0, 1),
(18, 'Command', 0, 14),
(19, 'Quotation', 0, 18),
(21, 'Deliverable', 0, 9),
(22, 'Incoming', 0, 9),
(23, 'Bill', 0, 18),
(24, 'Term', 0, 23),
(25, 'Product', 0, 25),
(26, 'Component', 0, 26),
(27, 'ProductVersion', 0, 27),
(28, 'ComponentVersion', 0, 28),
(29, 'Delivery', NULL, 0),
(30, 'Tender', NULL, 0),
(31, 'ProviderOrder', NULL, 0),
(32, 'ProviderBill', NULL, 0),
(33, 'CallForTender', NULL, 0),
(34, 'ChangeRequest', 0, NULL),
(35, 'SupplierContract', 0, NULL),
(36, 'ClientContract', 0, NULL),
(37, 'Asset', 0, NULL),
(38, 'Budget', 0, NULL),
(39, 'IncomingMail', 0, NULL),
(40, 'OutgoingMail', 0, NULL),
(41, 'ActivityExpense', 0, NULL),
(42, 'LessonLearned', 0, 1),
(43, 'Assumption', 0, 1),
(44, 'Constraint', 0, 1),
(45, 'Prospect', 0, 1),
(46, 'DomainProspect', 0, 1),
(47, 'PositionProspect', 0, 1),
(48, 'DecisionMakerProspect', 0, 1),
(49, 'ProspectOrigin', 0, 1),
(50, 'ProspectEvent', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]list`
--

CREATE TABLE `[[dbprefix]]list` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `list` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `listList` (`list`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1000003 ;

--
-- Dumping data for table `[[dbprefix]]list`
--

INSERT INTO `[[dbprefix]]list` VALUES
(1, 'yesNo', 'displayYes', 'YES', 20, 0),
(2, 'yesNo', 'displayNo', 'NO', 10, 0),
(101, 'teamOrga', 'displayAll', 'all', 10, 0),
(102, 'teamOrga', 'displayOrga', 'orga', 30, 0),
(103, 'teamOrga', 'displayTeam', 'team', 40, 0),
(104, 'teamOrga', 'displaySubOrga', 'subOrga', 20, 0),
(1001, 'orgaSubOrga', 'displayAll', 'all', 10, 0),
(1002, 'orgaSubOrga', 'displaySubOrga', 'subOrga', 20, 0),
(1003, 'orgaSubOrga', 'displayOrga', 'orga', 30, 0),
(1000001, 'readWrite', 'displayWrite', 'WRITE', 10, 0),
(1000002, 'readWrite', 'displayReadOnly', 'READ', 20, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]listhidevalue`
--

CREATE TABLE `[[dbprefix]]listhidevalue` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `nameList` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idValue` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]livemeeting`
--

CREATE TABLE `[[dbprefix]]livemeeting` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idMeeting` int(12) DEFAULT NULL COMMENT '12',
  `param` varchar(5000) DEFAULT NULL,
  `result` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localizationitem`
--

CREATE TABLE `[[dbprefix]]localizationitem` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `localizationId` varchar(100) DEFAULT NULL,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLocalizationRequest` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLocalizationItemType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLocalizationTranslator` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLanguage` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOriginLanguage` int(12) unsigned DEFAULT NULL COMMENT '12',
  `textToTranslate` mediumtext,
  `actualDueDate` date DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `context` mediumtext,
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `localizationResult` mediumtext,
  `automaticProcess` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localizationrequest`
--

CREATE TABLE `[[dbprefix]]localizationrequest` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `textToTranslate` mediumtext,
  `context` mediumtext,
  `localizationId` varchar(100) DEFAULT NULL,
  `idLocalizationRequestType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLocalizationItemType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLanguage` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLocalizationTranslator` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAccountable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedDeliveryDate` date DEFAULT NULL,
  `realDeliveryDate` date DEFAULT NULL,
  `creationDateTime` datetime DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localizationtranslator`
--

CREATE TABLE `[[dbprefix]]localizationtranslator` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localizationtranslatorlanguage`
--

CREATE TABLE `[[dbprefix]]localizationtranslatorlanguage` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idTranslator` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLanguage` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLanguageSkillLevel` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location`
--

CREATE TABLE `[[dbprefix]]location` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `description` mediumtext,
  `designation` varchar(200) DEFAULT NULL,
  `street` varchar(200) DEFAULT NULL,
  `complement` varchar(200) DEFAULT NULL,
  `zipCode` varchar(200) DEFAULT NULL,
  `city` varchar(200) DEFAULT NULL,
  `state` varchar(200) DEFAULT NULL,
  `country` varchar(200) DEFAULT NULL,
  `idLocation` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lockedimputation`
--

CREATE TABLE `[[dbprefix]]lockedimputation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idProject` int(12) DEFAULT NULL COMMENT '12',
  `idResource` int(12) DEFAULT NULL COMMENT '12',
  `month` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]macrostatus`
--

CREATE TABLE `[[dbprefix]]macrostatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]macrostatus`
--

INSERT INTO `[[dbprefix]]macrostatus` VALUES
(1, 'macroStatusHandled'),
(2, 'macroStatusDone'),
(3, 'macroStatusIdle');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail`
--

CREATE TABLE `[[dbprefix]]mail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mailDateTime` datetime DEFAULT NULL,
  `mailTo` varchar(4000) DEFAULT NULL,
  `mailTitle` varchar(4000) DEFAULT NULL,
  `mailBody` mediumtext,
  `mailStatus` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `mailProject` (`idProject`),
  KEY `mailUser` (`idUser`),
  KEY `mailRef` (`refType`,`refId`),
  KEY `mailStatus` (`idStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailable`
--

CREATE TABLE `[[dbprefix]]mailable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=60 ;

--
-- Dumping data for table `[[dbprefix]]mailable`
--

INSERT INTO `[[dbprefix]]mailable` VALUES
(1, 'Ticket', 0),
(2, 'Activity', 0),
(3, 'Milestone', 0),
(4, 'Risk', 0),
(5, 'Action', 0),
(6, 'Issue', 0),
(7, 'Meeting', 0),
(8, 'Decision', 0),
(9, 'Question', 0),
(10, 'Requirement', 0),
(11, 'TestSession', 0),
(12, 'TestCase', 0),
(13, 'Project', 0),
(14, 'Document', 0),
(15, 'IndividualExpense', 0),
(16, 'ProjectExpense', 0),
(17, 'Term', 0),
(18, 'Bill', 0),
(19, 'ActivityPrice', 0),
(20, 'Opportunity', 0),
(21, 'Command', 0),
(22, 'Quotation', 0),
(23, 'Product', 0),
(24, 'ProductVersion', 0),
(25, 'Component', 0),
(26, 'ComponentVersion', 0),
(27, 'Incoming', 0),
(28, 'Deliverable', 0),
(29, 'DocumentDirectory', 0),
(30, 'Delivery', 0),
(31, 'Client', 0),
(32, 'Payment', 0),
(33, 'Provider', 0),
(34, 'Team', 0),
(35, 'Tender', 0),
(36, 'ProviderOrder', 0),
(37, 'ProviderBill', 0),
(38, 'ProviderPayment', 0),
(39, 'Budget', 0),
(40, 'CallForTender', 0),
(41, 'ChangeRequest', 0),
(42, 'SupplierContract', 0),
(43, 'ClientContract', 0),
(44, 'Asset', 0),
(45, 'LocalizationItem', 0),
(46, 'LocalizationRequest', 0),
(47, 'User', 0),
(48, 'IncomingMail', 0),
(49, 'OutgoingMail', 0),
(50, 'ActivityExpense', 0),
(51, 'LessonLearned', 0),
(52, 'Assumption', 0),
(53, 'Constraint', 0),
(54, 'Prospect', 0),
(55, 'DomainProspect', 0),
(56, 'PositionProspect', 0),
(57, 'DecisionMakerProspect', 0),
(58, 'ProspectOrigin', 0),
(59, 'ProspectEvent', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailtosend`
--

CREATE TABLE `[[dbprefix]]mailtosend` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEmailTemplate` int(12) unsigned DEFAULT NULL COMMENT '12',
  `template` varchar(100) DEFAULT NULL,
  `title` varchar(4000) DEFAULT NULL,
  `dest` varchar(4000) DEFAULT NULL,
  `recordDateTime` datetime DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `mailtosendReference` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]measureunit`
--

CREATE TABLE `[[dbprefix]]measureunit` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `pluralName` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]measureunit`
--

INSERT INTO `[[dbprefix]]measureunit` VALUES
(1, 'piece', 'pieces', 10, 0),
(2, 'lot', 'lots', 20, 0),
(3, 'day', 'days', 30, 0),
(4, 'month', 'months', 50, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]meeting`
--

CREATE TABLE `[[dbprefix]]meeting` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMeetingType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `meetingDate` date DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `attendees` varchar(4000) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendTo` varchar(4000) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `result` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `description` mediumtext,
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `meetingStartTime` time DEFAULT NULL,
  `meetingEndTime` time DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPeriodicMeeting` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isPeriodic` int(1) unsigned DEFAULT '0' COMMENT '1',
  `periodicOccurence` int(3) unsigned DEFAULT NULL COMMENT '3',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `meetingStartDateTime` datetime DEFAULT NULL,
  `meetingEndDateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meetingProject` (`idProject`),
  KEY `meetingType` (`idMeetingType`),
  KEY `meetingUser` (`idUser`),
  KEY `meetingResource` (`idResource`),
  KEY `meetingStatus` (`idStatus`),
  KEY `meetingPeriodicMeeting` (`idPeriodicMeeting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu`
--

CREATE TABLE `[[dbprefix]]menu` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `type` varchar(100) DEFAULT NULL,
  `sortOrder` int(5) unsigned DEFAULT NULL COMMENT '5',
  `level` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `menuClass` varchar(400) DEFAULT NULL,
  `isAdminMenu` int(1) DEFAULT '0' COMMENT '1',
  `isLeavesSystemMenu` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `menuMenu` (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=100006002 ;

--
-- Dumping data for table `[[dbprefix]]menu`
--

INSERT INTO `[[dbprefix]]menu` VALUES
(1, 'menuToday', 0, 'item', 10, NULL, 0, 'Work Risk RequirementTest Financial Review ', 0, 0),
(2, 'menuWork', 0, 'menu', 40, 'Project', 1, 'Work Risk Review ', 0, 0),
(3, 'menuRisk', 43, 'object', 300, 'Project', 0, 'Risk ', 0, 0),
(4, 'menuAction', 2, 'object', 90, 'Project', 0, 'Work Risk Review ', 0, 0),
(5, 'menuIssue', 43, 'object', 320, 'Project', 0, 'Risk ', 0, 0),
(6, 'menuReview', 0, 'menu', 330, NULL, 1, 'Work Review ', 0, 0),
(7, 'menuFollowup', 0, 'menu', 100, NULL, 1, 'Work Risk RequirementTest Financial ', 0, 0),
(8, 'menuImputation', 7, 'item', 110, NULL, 0, 'Work ', 0, 0),
(9, 'menuPlanning', 7, 'item', 120, NULL, 0, 'Work ', 0, 0),
(11, 'menuTool', 0, 'menu', 495, NULL, 1, 'Admin ', 0, 0),
(13, 'menuParameter', 0, 'menu', 800, NULL, 1, 'Work Risk RequirementTest Financial Review Admin Automation EnvironmentalParameter ListOfValues Type HabilitationParameter ', 0, 0),
(14, 'menuEnvironmentalParameter', 0, 'menu', 540, NULL, 1, 'Work Financial EnvironmentalParameter ', 0, 0),
(15, 'menuClient', 14, 'object', 620, 'ReadWriteEnvironment', 0, 'Financial EnvironmentalParameter ', 0, 0),
(16, 'menuProject', 0, 'object', 20, 'Project', 0, 'Work Risk RequirementTest Financial Review ', 0, 0),
(17, 'menuUser', 14, 'object', 590, 'ReadWriteEnvironment', 0, 'EnvironmentalParameter HabilitationParameter ', 1, 0),
(18, 'menuGlobalParameter', 13, 'item', 1085, NULL, 0, 'Admin EnvironmentalParameter HabilitationParameter ', 1, 0),
(19, 'menuProjectParameter', 13, 'item', 1090, NULL, 1, '', 0, 0),
(20, 'menuUserParameter', 13, 'item', 1095, '', 0, 'Work Risk RequirementTest Financial Review Admin Automation EnvironmentalParameter ListOfValues Type HabilitationParameter ', 0, 0),
(21, 'menuHabilitation', 37, 'item', 1230, NULL, 0, 'HabilitationParameter ', 1, 0),
(22, 'menuTicket', 2, 'object', 50, 'Project', 0, 'Work ', 0, 0),
(25, 'menuActivity', 2, 'object', 70, 'Project', 0, 'Work ', 0, 0),
(26, 'menuMilestone', 2, 'object', 80, 'Project', 0, 'Work ', 0, 0),
(34, 'menuStatus', 36, 'object', 820, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(36, 'menuListOfValues', 13, 'menu', 805, NULL, 1, 'ListOfValues ', 0, 0),
(37, 'menuHabilitationParameter', 0, 'menu', 1200, NULL, 1, 'Type ', 1, 0),
(38, 'menuSeverity', 36, 'object', 855, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(39, 'menuLikelihood', 36, 'object', 845, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(40, 'menuCriticality', 36, 'object', 850, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(41, 'menuPriority', 36, 'object', 865, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(42, 'menuUrgency', 36, 'object', 860, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(43, 'menuRiskManagementPlan', 0, 'menu', 295, NULL, 1, 'Risk ', 0, 0),
(44, 'menuResource', 14, 'object', 600, 'ReadWriteEnvironment', 0, 'Work EnvironmentalParameter ', 0, 0),
(45, 'menuRiskType', 79, 'object', 960, 'ReadWriteType', 0, 'Type ', 0, 0),
(46, 'menuIssueType', 79, 'object', 975, 'ReadWriteType', 0, 'Type ', 0, 0),
(47, 'menuAccessProfile', 37, 'object', 1245, NULL, 0, 'HabilitationParameter ', 1, 0),
(48, 'menuAccessRight', 37, 'item', 1250, NULL, 0, 'HabilitationParameter ', 1, 0),
(49, 'menuProfile', 37, 'object', 1210, NULL, 0, 'HabilitationParameter ', 1, 0),
(50, 'menuAffectation', 14, 'object', 570, 'Project', 0, 'EnvironmentalParameter ', 0, 0),
(51, 'menuMessage', 11, 'object', 520, 'ReadWriteTool', 0, 'Admin ', 0, 0),
(52, 'menuMessageType', 79, 'object', 995, 'ReadWriteType', 0, 'Type ', 0, 0),
(53, 'menuTicketType', 79, 'object', 910, 'ReadWriteType', 0, 'Type ', 0, 0),
(55, 'menuActivityType', 79, 'object', 915, 'ReadWriteType', 0, 'Type ', 0, 0),
(56, 'menuMilestoneType', 79, 'object', 920, 'ReadWriteType', 0, 'Type ', 0, 0),
(57, 'menuTeam', 14, 'object', 640, 'ReadWriteEnvironment', 0, 'EnvironmentalParameter ', 0, 0),
(58, 'menuImportData', 11, 'item', 525, NULL, 0, 'Admin ', 0, 0),
(59, 'menuWorkflow', 88, 'object', 680, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(60, 'menuActionType', 79, 'object', 970, 'ReadWriteType', 0, 'Type ', 0, 0),
(61, 'menuReports', 7, 'item', 148, NULL, 0, 'Work Risk RequirementTest Financial ', 0, 0),
(62, 'menuMeeting', 6, 'object', 340, 'Project', 0, 'Work Review ', 0, 0),
(63, 'menuDecision', 6, 'object', 360, 'Project', 0, 'Review ', 0, 0),
(64, 'menuQuestion', 6, 'object', 370, 'Project', 0, 'Review ', 0, 0),
(65, 'menuMeetingType', 79, 'object', 980, 'ReadWriteType', 0, 'Type ', 0, 0),
(66, 'menuDecisionType', 79, 'object', 985, 'ReadWriteType', 0, 'Type ', 0, 0),
(67, 'menuQuestionType', 79, 'object', 990, 'ReadWriteType', 0, 'Type ', 0, 0),
(68, 'menuStatusMail', 88, 'object', 690, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(69, 'menuMail', 11, 'object', 500, 'Project', 0, 'Admin ', 0, 0),
(70, 'menuHabilitationReport', 37, 'item', 1240, NULL, 0, 'HabilitationParameter ', 1, 0),
(71, 'menuHabilitationOther', 37, 'item', 1270, NULL, 0, 'HabilitationParameter ', 1, 0),
(72, 'menuContact', 14, 'object', 610, 'ReadWriteEnvironment', 0, 'Financial EnvironmentalParameter ', 0, 0),
(73, 'menuRole', 36, 'object', 815, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(74, 'menuFinancial', 0, 'menu', 200, NULL, 1, 'Work Financial ', 0, 0),
(75, 'menuIndividualExpense', 151, 'object', 211, 'Project', 0, 'Work Financial ', 0, 0),
(76, 'menuProjectExpense', 151, 'object', 220, 'Project', 0, 'Financial ', 0, 0),
(78, 'menuPayment', 152, 'object', 270, 'Project', 0, 'Financial ', 0, 0),
(79, 'menuType', 13, 'menu', 901, NULL, 1, '', 0, 0),
(80, 'menuIndividualExpenseType', 79, 'object', 933, 'ReadWriteType', 0, 'Type ', 0, 0),
(81, 'menuProjectExpenseType', 79, 'object', 937, 'ReadWriteType', 0, 'Type ', 0, 0),
(82, 'menuInvoiceType', 79, 'object', 962, 'ReadWriteType', 1, 'Type ', 0, 0),
(83, 'menuPaymentType', 79, 'object', 957, 'ReadWriteType', 0, 'Type ', 0, 0),
(84, 'menuExpenseDetailType', 79, 'object', 941, 'ReadWriteType', 0, 'Type ', 0, 0),
(85, 'menuCalendar', 14, 'item', 660, 'ReadWriteEnvironment', 0, 'Work EnvironmentalParameter ', 0, 0),
(86, 'menuProduct', 173, 'object', 382, 'ReadWriteConfiguration', 0, 'Work Configuration EnvironmentalParameter', 0, 0),
(87, 'menuProductVersion', 173, 'object', 384, 'ReadWriteConfiguration', 0, 'Work Configuration EnvironmentalParameter', 0, 0),
(88, 'menuAutomation', 0, 'menu', 670, NULL, 1, 'Automation ', 0, 0),
(89, 'menuTicketDelay', 88, 'object', 700, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(90, 'menuIndicatorDefinition', 88, 'object', 710, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(91, 'menuAlert', 11, 'object', 510, 'Project', 0, 'Admin ', 0, 0),
(92, 'menuAdmin', 0, 'item', 1300, NULL, 0, 'Admin ', 1, 0),
(93, 'menuProjectType', 79, 'object', 905, 'ReadWriteType', 0, 'Type ', 0, 0),
(94, 'menuActivityPrice', 152, 'object', 280, 'Project', 0, 'Financial ', 0, 0),
(95, 'menuRecipient', 14, 'object', 630, 'ReadWriteEnvironment', 0, 'Financial EnvironmentalParameter ', 0, 0),
(96, 'menuTerm', 152, 'object', 250, 'Project', 0, 'Financial ', 0, 0),
(97, 'menuBill', 152, 'object', 260, 'Project', 0, 'Financial ', 0, 0),
(100, 'menuBillType', 79, 'object', 953, 'ReadWriteType', 0, 'Type ', 0, 0),
(101, 'menuDocumentType', 79, 'object', 1000, 'ReadWriteType', 0, 'Type ', 0, 0),
(102, 'menuDocument', 0, 'object', 30, 'Project', 0, 'Work Risk RequirementTest Financial Review ', 0, 0),
(103, 'menuDocumentDirectory', 14, 'object', 650, 'ReadWritePrincipal', 0, 'EnvironmentalParameter ', 0, 0),
(104, 'menuContext', 14, 'object', 580, NULL, 0, 'EnvironmentalParameter ', 0, 0),
(105, 'menuContextType', 79, 'object', 1005, 'ReadWriteType', 0, 'Type ', 0, 0),
(106, 'menuResourcePlanning', 7, 'item', 140, NULL, 0, 'Work ', 0, 0),
(107, 'menuRequirementType', 79, 'object', 1010, 'ReadWriteType', 0, 'Type ', 0, 0),
(108, 'menuTestCaseType', 79, 'object', 1015, 'ReadWriteType', 0, 'Type ', 0, 0),
(109, 'menuTestSessionType', 79, 'object', 1020, 'ReadWriteType', 0, 'Type ', 0, 0),
(110, 'menuRequirementTest', 0, 'menu', 162, NULL, 1, 'Work RequirementTest ', 0, 0),
(111, 'menuRequirement', 110, 'object', 170, 'Project', 0, 'RequirementTest ', 0, 0),
(112, 'menuTestCase', 110, 'object', 180, 'Project', 0, 'RequirementTest ', 0, 0),
(113, 'menuTestSession', 110, 'object', 190, 'Project', 0, 'RequirementTest ', 0, 0),
(114, 'menuRiskLevel', 36, 'object', 870, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(115, 'menuFeasibility', 36, 'object', 875, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(116, 'menuPredefinedNote', 88, 'object', 720, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(117, 'menuEfficiency', 36, 'object', 880, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(118, 'menuTicketSimple', 2, 'object', 60, 'Project', 0, 'Work ', 0, 0),
(119, 'menuOpportunity', 43, 'object', 310, 'Project', 0, 'Risk ', 0, 0),
(120, 'menuOpportunityType', 79, 'object', 965, 'ReadWriteType', 0, 'Type ', 0, 0),
(121, 'menuHealth', 36, 'object', 830, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(122, 'menuAudit', 11, 'object', 535, NULL, 0, 'Admin ', 0, 0),
(123, 'menuPortfolioPlanning', 7, 'item', 130, NULL, 0, 'Work ', 0, 0),
(124, 'menuPeriodicMeeting', 6, 'object', 350, 'Project', 0, 'Review ', 0, 0),
(125, 'menuCommand', 152, 'object', 240, 'Project', 0, 'Financial ', 0, 0),
(126, 'menuCommandType', 79, 'object', 949, 'ReadWriteType', 0, 'Type ', 0, 0),
(127, 'menuOverallProgress', 36, 'object', 835, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(128, 'menuQuality', 36, 'object', 825, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(129, 'menuTrend', 36, 'object', 840, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(130, 'menuChecklistDefinition', 88, 'object', 730, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(131, 'menuQuotation', 152, 'object', 230, 'Project', 0, 'Financial ', 0, 0),
(132, 'menuQuotationType', 79, 'object', 945, 'ReadWriteType', 0, 'Type ', 0, 0),
(133, 'menuDiary', 7, 'item', 145, NULL, 0, 'Work ', 0, 0),
(134, 'menuClientType', 79, 'object', 1025, 'ReadWriteType', 0, 'Type ', 0, 0),
(135, 'menuAccessRightNoProject', 37, 'item', 1260, NULL, 0, 'HabilitationParameter ', 1, 0),
(136, 'menuPluginManagement', 143, 'item', 9110, NULL, 0, 'Admin ', 1, 0),
(137, 'menuPaymentDelay', 36, 'object', 885, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(138, 'menuPaymentMode', 36, 'object', 886, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(139, 'menuDeliveryMode', 36, 'object', 887, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(140, 'menuMeasureUnit', 36, 'object', 888, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(141, 'menuComponent', 173, 'object', 386, 'ReadWriteConfiguration', 0, 'Work Configuration EnvironmentalParameter', 0, 0),
(142, 'menuComponentVersion', 173, 'object', 388, 'ReadWriteConfiguration', 0, 'Work Configuration EnvironmentalParameter', 0, 0),
(143, 'menuPlugin', NULL, 'menu', 9100, NULL, 1, 'Admin', 1, 0),
(144, 'menuProductType', 79, 'object', 1030, 'ReadWriteType', 0, 'Type ', 0, 0),
(145, 'menuComponentType', 79, 'object', 1032, 'ReadWriteType', 0, 'Type ', 0, 0),
(146, 'menuGallery', 152, 'item', 282, NULL, 0, 'Financial', 0, 0),
(147, 'menuProviderType', 79, 'object', 1027, 'ReadWriteType', 0, 'Type ', 0, 0),
(148, 'menuProvider', 14, 'object', 625, 'ReadWriteEnvironment', 0, 'Financial EnvironmentalParameter ', 0, 0),
(149, 'menuResolution', 36, 'object', 822, 'ReadWriteList', 0, 'ListOfValues ', 0, 0),
(150, 'menuDashboardTicket', 0, 'item', 15, NULL, 0, 'Work Risk RequirementTest Financial Review ', 0, 0),
(151, 'menuExpenses', 74, 'menu', 201, NULL, 1, '', 0, 0),
(152, 'menuIncomes', 74, 'menu', 225, NULL, 1, '', 0, 0),
(153, 'menuCallForTender', 151, 'object', 205, 'Project', 0, 'Financial ', 0, 0),
(154, 'menuTender', 151, 'object', 206, 'Project', 0, 'Financial ', 0, 0),
(155, 'menuCallForTenderType', 79, 'object', 925, 'ReadWriteType', 0, 'Type ', 0, 0),
(156, 'menuTenderType', 79, 'object', 929, 'ReadWriteType', 0, 'Type ', 0, 0),
(157, 'menuTenderStatus', 36, 'object', 890, NULL, 0, 'ListOfValues ', 0, 0),
(158, 'menuOrganization', 0, 'object', 18, 'ReadWritePrincipal', 0, 'EnvironmentalParameter', 0, 0),
(159, 'menuOrganizationType', 79, 'object', 903, 'ReadWriteType', 0, 'Type', 0, 0),
(160, 'menuProductVersionType', 79, 'object', 1033, 'ReadWriteType', 0, 'Type', 0, 0),
(161, 'menuComponentVersionType', 79, 'object', 1034, 'ReadWriteType', 0, 'Type', 0, 0),
(162, 'menuJoblistDefinition', 88, 'object', 740, 'ReadWriteAutomation', 0, 'Automation ', 0, 0),
(163, 'menuDeliverableWeight', 36, 'object', 892, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(164, 'menuDeliverableStatus', 36, 'object', 894, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(165, 'menuDeliverableType', 79, 'object', 1038, 'ReadWriteType', 0, 'Type', 0, 0),
(166, 'menuIncomingType', 79, 'object', 1036, 'ReadWriteType', 0, 'Type', 0, 0),
(167, 'menuDeliverable', 6, 'object', 374, 'Project', 0, 'Work Review', 0, 0),
(168, 'menuIncoming', 6, 'object', 372, 'Project', 0, 'Work Review', 0, 0),
(169, 'menuKpiDefinition', 88, 'object', 715, 'ReadWriteAutomation', 0, 'Automation', 0, 0),
(170, 'menuCategory', 36, 'object', 891, 'ReadWriteList', 0, ' ListOfValues', 0, 0),
(171, 'menuIncomingWeight', 36, 'object', 891, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(172, 'menuIncomingStatus', 36, 'object', 893, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(173, 'menuConfiguration', 0, 'menu', 380, NULL, 1, 'Work Review EnvironmentalParameter', 0, 0),
(174, 'menuCatalog', 152, 'object', 284, 'ReadWritePrincipal', 0, 'Financial', 0, 0),
(175, 'menuCatalogType', 79, 'object', 958, 'ReadWriteType', 0, 'Type', 0, 0),
(176, 'menuDelivery', 6, 'object', 375, 'Project', 0, 'Work Review', 0, 0),
(177, 'menuActivityStream', 0, 'item', 19, NULL, 0, 'Work Risk RequirementTest Financial Review', 0, 0),
(178, 'menuLanguage', 36, 'object', 895, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(179, 'menuVersionsPlanning', 173, 'item', 390, NULL, 0, 'Work Configuration EnvironmentalParameter', 0, 0),
(180, 'menuStatusMailPerProject', 88, 'object', 691, 'Project', 0, 'Automation', 0, 0),
(181, 'menuIndicatorDefinitionPerProject', 88, 'object', 711, 'Project', 0, 'Automation', 0, 0),
(182, 'menuTicketDelayPerProject', 88, 'object', 701, 'Project', 0, 'Automation', 0, 0),
(183, 'menuDeliveryType', 79, 'object', 1040, 'ReadWriteType', 0, 'Type', 0, 0),
(184, 'menuEmailTemplate', 88, 'object', 685, 'ReadWriteAutomation', 0, 'Automation', 0, 0),
(185, 'menuNotification', 11, 'object', 531, 'ReadWriteTool', 0, 'Admin Notification', 0, 0),
(186, 'menuNotificationDefinition', 88, 'object', 772, 'ReadWriteAutomation', 0, 'Automation Notification', 0, 0),
(187, 'menuMailToSend', 11, 'object', 502, '', 0, 'Admin', 0, 0),
(188, 'menuResourceTeam', 14, 'object', 605, 'ReadWriteEnvironment', 0, 'Work EnvironmentalParameter', 0, 0),
(189, 'menuDashboardRequirement', 110, 'item', 165, NULL, 0, 'RequirementTest', 0, 0),
(190, 'menuProviderOrderType', 79, 'object', 930, 'ReadWriteType', 0, 'Type ', 0, 0),
(191, 'menuProviderOrder', 151, 'object', 207, 'Project', 0, 'Financial ', 0, 0),
(192, 'menuGlobalView', 2, 'object', 95, NULL, 0, 'Work', 0, 0),
(193, 'menuProviderBillType', 79, 'object', 931, 'ReadWriteType', 0, 'Type ', 0, 0),
(194, 'menuProviderBill', 151, 'object', 209, 'Project', 0, 'Financial ', 0, 0),
(195, 'menuProviderTerm', 151, 'object', 208, 'Project', 0, 'Financial ', 0, 0),
(196, 'menuGlobalPlanning', 7, 'item', 125, NULL, 0, 'Work', 0, 0),
(197, 'menuBudget', 151, 'object', 202, 'ReadWritePrincipal', 0, 'Financial', 0, 0),
(198, 'menuBudgetType', 79, 'object', 924, 'ReadWriteType', 0, 'Type', 0, 0),
(199, 'menuBudgetOrientation', 36, 'object', 889, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(200, 'menuBudgetCategory', 36, 'object', 889, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(201, 'menuProviderPayment', 151, 'object', 210, 'Project', 0, 'Financial ', 0, 0),
(202, 'menuProviderPaymentType', 79, 'object', 932, 'ReadWriteType', 0, 'Type ', 0, 0),
(203, 'menuAbsence', 7, 'item', 115, NULL, 0, 'Work', 0, 0),
(204, 'menuImputationValidation', 7, 'item', 118, NULL, 0, 'Work', 0, 0),
(205, 'menuAutoSendReport', 11, 'item', 505, NULL, 0, 'Work', 0, 0),
(208, 'menuHumanResource', 0, 'menu', 400, NULL, 1, 'HumanResource', 0, 1),
(209, 'menuLeaveCalendar', 208, 'item', 405, NULL, 0, 'HumanResource', 0, 1),
(210, 'menuLeave', 208, 'object', 410, NULL, 0, 'HumanResource', 0, 1),
(211, 'menuEmployeeLeaveEarned', 208, 'object', 420, NULL, 0, 'HumanResource', 0, 1),
(212, 'menuEmployee', 14, 'object', 602, NULL, 0, 'HumanResource', 0, 1),
(213, 'menuEmploymentContract', 208, 'object', 430, NULL, 0, 'HumanResource', 0, 1),
(214, 'menuEmployeeManager', 208, 'object', 435, NULL, 0, 'HumanResource', 0, 1),
(215, 'menuDashboardEmployeeManager', 208, 'item', 440, NULL, 0, 'HumanResource', 0, 1),
(216, 'menuHumanResourceParameters', 13, 'menu', 1060, NULL, 1, 'HumanResource', 0, 1),
(217, 'menuLeaveType', 216, 'object', 1061, NULL, 0, 'HumanResource', 0, 1),
(218, 'menuEmploymentContractType', 216, 'object', 1062, NULL, 0, 'HumanResource', 0, 1),
(219, 'menuEmploymentContractEndReason', 216, 'object', 1063, NULL, 0, 'HumanResource', 0, 1),
(220, 'menuLeavesSystemHabilitation', 216, 'item', 1064, NULL, 0, 'HumanResource', 0, 1),
(221, 'menuModule', 37, 'item', 1205, NULL, 0, 'Admin HabilitationParameter', 1, 0),
(222, 'menuDataCloning', 11, 'item', 530, NULL, 0, 'Admin', 0, 0),
(223, 'menuMessageLegal', 11, 'object', 521, 'ReadWriteTool', 0, 'Admin', 0, 0),
(224, 'menuDataCloningParameter', 13, 'item', 1070, NULL, 0, 'Admin', 0, 0),
(225, 'menuChangeRequest', 6, 'object', 355, 'Project', 0, 'Work Review EnvironmentalParameter', 0, 0),
(226, 'menuChangeRequestType', 79, 'object', 982, 'ReadWriteType', 0, 'Type', 0, 0),
(227, 'menuVersionsComponentPlanning', 173, 'item', 395, NULL, 0, 'Work', 0, 0),
(228, 'menuSupplierContract', 151, 'object', 204, 'Project', 0, 'Financial', 0, 0),
(229, 'menuSupplierContractType', 79, 'object', 926, 'ReadWriteType', 0, 'Type', 0, 0),
(231, 'menuRenewal', 36, 'object', 897, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(232, 'menuGanttSupplierContract', 151, 'item', 204, NULL, 0, 'Financial', 0, 0),
(233, 'menuHierarchicalBudget', 151, 'item', 203, NULL, 0, 'Financial', 0, 0),
(234, 'menuClientContract', 152, 'object', 228, 'Project', 0, 'Financial', 0, 0),
(235, 'menuGanttClientContract', 152, 'item', 229, NULL, 0, 'Financial', 0, 0),
(236, 'menuClientContractType', 79, 'object', 928, 'ReadWriteType', 0, 'Type', 0, 0),
(237, 'menuAsset', 243, 'object', 455, 'ReadWritePrincipal', 0, 'Asset', 0, 0),
(238, 'menuLocation', 243, 'object', 465, 'ReadWriteList', 0, 'Asset', 0, 0),
(239, 'menuBrand', 243, 'object', 461, 'ReadWriteList', 0, 'Asset', 0, 0),
(240, 'menuModel', 243, 'object', 463, 'ReadWriteList', 0, 'Asset', 0, 0),
(241, 'menuAssetCategory', 243, 'object', 460, 'ReadWriteList', 0, 'Asset', 0, 0),
(243, 'menuAssetManagment', 0, 'menu', 450, NULL, 1, 'Asset', 0, 0),
(244, 'menuSituation', 74, 'menu', 287, NULL, 1, NULL, 0, 0),
(245, 'menuProjectSituation', 244, 'object', 288, 'Project', 0, 'Financial', 0, 0),
(246, 'menuProjectSituationExpense', 244, 'object', 289, 'Project', 0, 'Financial', 0, 0),
(247, 'menuProjectSituationIncome', 244, 'object', 290, 'Project', 0, 'Financial', 0, 0),
(248, 'menuAssetType', 243, 'object', 459, 'ReadWriteType', 0, 'Asset Type', 0, 0),
(249, 'menuPredefinedSituation', 36, 'object', 898, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(250, 'menuInputMailboxTicket', 88, 'object', 693, 'Project', 0, 'Automation', 0, 0),
(251, 'menuInterventionMode', 36, 'object', 899, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(252, 'menuPlannedWorkManual', 7, 'item', 122, NULL, 0, 'Work', 0, 0),
(253, 'menuConsultationPlannedWorkManual', 7, 'item', 150, NULL, 0, 'Work', 0, 0),
(254, 'menuConsultationValidation', 7, 'item', 119, NULL, 0, 'Work', 0, 0),
(255, 'menuCatalogUO', 152, 'object', 285, 'Project', 0, 'Financial', 0, 0),
(256, 'menuAccessProfileNoProject', 37, 'object', 1255, NULL, 0, 'HabilitationParameter', 1, 0),
(257, 'menuViewAllSubTask', 7, 'item', 123, NULL, 0, 'Work', 0, 0),
(258, 'menuDocumentRight', 37, 'item', 1275, NULL, 0, 'HabilitationParameter ', 0, 0),
(259, 'menuPokerSession', 7, 'object', 152, 'Project', 0, 'Work ', 0, 0),
(260, 'menuPokerSessionVoting', 7, 'object', 153, 'Project', 0, 'Work ', 0, 0),
(261, 'menuLocalization', 0, 'menu', 476, NULL, 1, 'Localization', 0, 0),
(262, 'menuLocalizationRequest', 261, 'object', 477, 'ReadWriteLocalization', 0, 'Localization', 0, 0),
(263, 'menuLocalizationItem', 261, 'object', 478, 'ReadWriteLocalization', 0, 'Localization', 0, 0),
(264, 'menuLocalizationTranslator', 261, 'object', 479, 'ReadWriteLocalization', 0, 'Localization', 0, 0),
(265, 'menuLanguageSkillLevel', 36, 'object', 896, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(266, 'menuLocalizationRequestType', 79, 'object', 1042, 'ReadWriteType', 0, 'Type', 0, 0),
(267, 'menuLocalizationItemType', 79, 'object', 1043, 'ReadWriteType', 0, 'Type', 0, 0),
(268, 'menuPokerSessionType', 79, 'object', 981, 'ReadWriteType', 0, 'Type', 0, 0),
(269, 'menuPokerComplexity', 36, 'object', 900, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(270, 'menuOutgoingMail', 6, 'object', 376, 'Project', 0, 'Work ', 0, 0),
(271, 'menuIncomingMail', 6, 'object', 377, 'Project', 0, 'Work ', 0, 0),
(272, 'menuIncomingMailType', 79, 'object', 997, 'ReadWriteType', 0, 'Type', 0, 0),
(273, 'menuOutgoingMailType', 79, 'object', 998, 'ReadWriteType', 0, 'Type', 0, 0),
(274, 'menuTokenDefinition', 152, 'object', 286, 'Project', 0, 'Financial', 0, 0),
(275, 'menuSkill', 208, 'object', 441, 'ReadWritePrincipal', 0, 'Skill', 0, 0),
(276, 'menuSkillLevel', 208, 'object', 442, 'ReadWritePrincipal', 0, 'Skill', 0, 0),
(277, 'menuResourceSkill', 208, 'item', 443, NULL, 0, 'Skill', 0, 0),
(278, 'menuVotingAttributionRule', 7, 'object', 155, 'ReadWritePrincipal', 0, 'Admin', 0, 0),
(279, 'menuVotingUseRule', 7, 'object', 157, 'ReadWritePrincipal', 0, 'Admin', 0, 0),
(280, 'menuVotingUseRulePerProject', 7, 'object', 158, 'Project', 0, 'Admin', 0, 0),
(281, 'menuHierarchicalSkill', 208, 'item', 444, NULL, 0, 'Skill', 0, 0),
(282, 'menuVotingFollowUp', 7, 'item', 159, NULL, 0, 'Admin', 0, 0),
(283, 'menuVotingAttributionFollowUp', 7, 'item', 160, NULL, 0, 'Admin', 0, 0),
(284, 'menuCriticalResources', 7, 'item', 121, NULL, 0, 'Work', 0, 0),
(285, 'menuResourceMaterial', 14, 'object', 665, 'ReadWriteEnvironment', 0, 'Work EnvironmentalParameter', 0, 0),
(286, 'menuAssignment', 14, 'object', 575, 'Project', 0, 'EnvironmentalParameter ', 0, 0),
(287, 'menuActivityExpense', 151, 'object', 215, 'Project', 0, 'Work Financial', 0, 0),
(288, 'menuActivityExpenseType', 79, 'object', 940, 'ReadWriteType', 0, 'Type', 0, 0),
(289, 'menuStartGuide', 0, 'item', 1, NULL, 0, 'Work Risk RequirementTest Financial Review', 0, 0),
(290, 'menuLessonLearned', 7, 'object', 142, 'Project', 0, 'Followup', 0, 0),
(291, 'menuLessonLearnedType', 79, 'object', 1050, 'ReadWriteType', 0, 'Followup', 0, 0),
(292, 'menuAssumption', 7, 'object', 145, 'Project', 0, 'Followup', 0, 0),
(293, 'menuAssumptionType', 79, 'object', 1051, 'ReadWriteType', 0, 'Followup', 0, 0),
(294, 'menuConstraint', 7, 'object', 146, 'Project', 0, 'Followup', 0, 0),
(295, 'menuConstraintType', 79, 'object', 1052, 'ReadWriteType', 0, 'Followup', 0, 0),
(300, 'menuSubscription', 0, 'item', 1280, NULL, 0, 'Admin', 1, 0),
(301, 'menuProspect', 7, 'object', 141, 'ReadWriteEnvironment', 0, 'Followup', 0, 0),
(302, 'menuProspectType', 79, 'object', 1053, 'ReadWriteType', 0, 'Followup', 0, 0),
(303, 'menuDomainProspect', 7, 'object', 143, 'ReadWriteList', 0, 'Followup', 0, 0),
(304, 'menuPositionProspect', 7, 'object', 144, 'ReadWriteList', 0, 'Followup', 0, 0),
(305, 'menuDecisionMakerProspect', 7, 'object', 147, 'ReadWriteList', 0, 'Followup', 0, 0),
(306, 'menuProspectOrigin', 7, 'object', 149, 'ReadWriteEnvironment', 0, 'Followup', 0, 0),
(307, 'menuProspectEvent', 7, 'object', 139, NULL, 1, 'Followup', 0, 0),
(308, 'menuProspectEventType', 79, 'object', 1054, 'ReadWriteType', 0, 'Followup', 0, 0),
(309, 'menuPlanningMode', 36, 'object', 812, 'ReadWriteList', 0, 'ListOfValues', 0, 0),
(310, 'menuWorkCommand', 152, 'object', 245, 'Project', 0, 'Financial', 0, 0),
(311, 'menuAcceptance', 6, 'object', 378, 'Project', 0, 'Work Meeting', 0, 0),
(312, 'menuAcceptanceType', 79, 'object', 1055, 'ReadWriteType', 0, 'Type', 0, 0),
(313, 'menuWorkPlan', 7, 'item', 155, NULL, 0, 'Work', 0, 0),
(314, 'menuPlanningWorkPlan', 7, 'item', 154, NULL, 0, 'Work ', 0, 0),
(315, 'menuInputMailboxImport', 88, 'object', 694, 'Project', 0, 'Automation', 0, 0),
(316, 'menuResourceSkillSimple', 208, 'item', 445, NULL, 0, 'Skill', 0, 0),
(100006001, 'menuKanban', 0, 'item', 35, NULL, 0, 'Work Risk RequirementTest Financial Meeting ', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menucustom`
--

CREATE TABLE `[[dbprefix]]menucustom` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idRow` int(12) DEFAULT '1' COMMENT '12',
  `sortOrder` int(3) unsigned DEFAULT '1' COMMENT '3',
  PRIMARY KEY (`id`),
  KEY `menucustomUser` (`idUser`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]menucustom`
--

INSERT INTO `[[dbprefix]]menucustom` VALUES
(1, NULL, 'menuProject', 1, 0, 1, 1),
(2, NULL, 'menuActivity', 1, 0, 1, 2),
(3, NULL, 'menuMilestone', 1, 0, 1, 3),
(4, NULL, 'menuMeeting', 1, 0, 1, 4),
(5, NULL, 'menuPlanning', 1, 0, 1, 5),
(6, NULL, 'menuResource', 1, 0, 1, 6),
(7, NULL, 'menuReports', 1, 0, 1, 7),
(8, NULL, 'menuTicket', 1, 0, 2, 1),
(9, NULL, 'menuTicketSimple', 1, 0, 2, 2),
(10, NULL, 'menuKanban', 1, 0, 2, 3),
(11, NULL, 'menuImputation', 1, 0, 2, 4),
(12, NULL, 'menuAbsence', 1, 0, 2, 5),
(13, NULL, 'menuProject', 2, 0, 1, 1),
(14, NULL, 'menuActivity', 2, 0, 1, 2),
(15, NULL, 'menuMilestone', 2, 0, 1, 3),
(16, NULL, 'menuMeeting', 2, 0, 1, 4),
(17, NULL, 'menuPlanning', 2, 0, 1, 5),
(18, NULL, 'menuResource', 2, 0, 1, 6),
(19, NULL, 'menuReports', 2, 0, 1, 7),
(20, NULL, 'menuTicket', 2, 0, 2, 1),
(21, NULL, 'menuTicketSimple', 2, 0, 2, 2),
(22, NULL, 'menuKanban', 2, 0, 2, 3),
(23, NULL, 'menuImputation', 2, 0, 2, 4),
(24, NULL, 'menuAbsence', 2, 0, 2, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menuselector`
--

CREATE TABLE `[[dbprefix]]menuselector` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message`
--

CREATE TABLE `[[dbprefix]]message` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idMessageType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `showOnLogin` int(1) unsigned DEFAULT '0' COMMENT '1',
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `messageProject` (`idProject`),
  KEY `messageUser` (`idUser`),
  KEY `messageType` (`idMessageType`),
  KEY `messageProfile` (`idProfile`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]message`
--

INSERT INTO `[[dbprefix]]message` VALUES
(1, NULL, 'Welcome', 15, 'Welcome to ProjeQtOr web application', NULL, NULL, 0, 0, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messagelegal`
--

CREATE TABLE `[[dbprefix]]messagelegal` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messagelegalfollowup`
--

CREATE TABLE `[[dbprefix]]messagelegalfollowup` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idMessageLegal` int(12) DEFAULT NULL COMMENT '12',
  `idUser` int(12) DEFAULT NULL COMMENT '12',
  `firstViewDate` datetime DEFAULT NULL,
  `lastViewDate` datetime DEFAULT NULL,
  `acceptedDate` datetime DEFAULT NULL,
  `accepted` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]milestone`
--

CREATE TABLE `[[dbprefix]]milestone` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idMilestoneType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lastUpdateDateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `milestoneProject` (`idProject`),
  KEY `milestoneUser` (`idUser`),
  KEY `milestoneResource` (`idResource`),
  KEY `milestoneStatus` (`idStatus`),
  KEY `milestoneType` (`idMilestoneType`),
  KEY `milestoneActivity` (`idActivity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]model`
--

CREATE TABLE `[[dbprefix]]model` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idAssetType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idBrand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module`
--

CREATE TABLE `[[dbprefix]]module` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(5) DEFAULT NULL COMMENT '5',
  `idModule` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `active` int(1) DEFAULT '1' COMMENT '1',
  `parentActive` int(1) unsigned DEFAULT '0' COMMENT '1',
  `notActiveAlone` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=36 ;

--
-- Dumping data for table `[[dbprefix]]module`
--

INSERT INTO `[[dbprefix]]module` VALUES
(1, 'modulePlanning', 100, NULL, 0, 1, 0, 0),
(2, 'moduleTicket', 200, NULL, 0, 1, 0, 0),
(3, 'moduleImputation', 310, 25, 0, 1, 1, 0),
(4, 'moduleRequirement', 740, 10, 0, 1, 1, 0),
(5, 'moduleFinancial', 500, NULL, 0, 1, 0, 1),
(6, 'moduleExpenses', 510, 5, 0, 1, 1, 0),
(7, 'moduleIncomes', 520, 5, 0, 1, 1, 0),
(8, 'moduleRisk', 730, 10, 0, 1, 1, 0),
(9, 'moduleMeeting', 110, 1, 0, 1, 1, 0),
(10, 'moduleReview', 710, NULL, 0, 1, 0, 0),
(11, 'moduleConfiguration', 800, NULL, 0, 1, 0, 0),
(12, 'moduleAbsence', 910, 31, 0, 0, 1, 0),
(13, 'moduleNotification', 1600, NULL, 0, 0, 0, 0),
(14, 'moduleOrganization', 1100, NULL, 0, 1, 0, 0),
(15, 'moduleDocument', 1000, NULL, 0, 1, 0, 0),
(16, 'moduleActivityStream', 1500, NULL, 0, 1, 0, 0),
(17, 'moduleDataCloning', 1200, NULL, 0, 0, 0, 0),
(18, 'moduleAssets', 720, 10, 0, 0, 0, 0),
(19, 'moduleSituation', 530, 5, 0, 0, 0, 0),
(20, 'moduleGestionCA', 540, 5, 0, 0, 0, 0),
(21, 'moduleLocalization', 880, NULL, 0, 0, 0, 0),
(22, 'modulePoker', 120, 1, 0, 0, 0, 0),
(23, 'moduleTargetMilestone', 112, 1, 0, 0, 0, 0),
(24, 'moduleTechnicalProgress', 114, 1, 0, 0, 0, 0),
(25, 'moduleFollowUp', 300, NULL, 0, 1, 0, 1),
(26, 'moduleBudgetFunctionOfOrga', 1110, 14, 0, 0, 0, 0),
(27, 'moduleTodoList', 320, 25, 0, 0, 0, 0),
(28, 'moduleChecklist', 330, 25, 0, 0, 0, 0),
(29, 'moduleMail', 750, 10, 0, 0, 0, 0),
(30, 'moduleTokenManagement', 550, 5, 0, 0, 0, 0),
(31, 'moduleHumanResource', 900, NULL, 0, 0, 0, 1),
(32, 'moduleSkillManagement', 920, 31, 0, 0, 1, 0),
(33, 'moduleVoting', 340, 25, 0, 0, 0, 1),
(34, 'moduleProjectAnalysis', 760, 10, 0, 0, 0, 0),
(35, 'moduleCrmProspect', 990, NULL, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modulemenu`
--

CREATE TABLE `[[dbprefix]]modulemenu` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idModule` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `hidden` int(1) DEFAULT '1' COMMENT '1',
  `active` int(1) DEFAULT '1' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `moduleMenuMenu` (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=247 ;

--
-- Dumping data for table `[[dbprefix]]modulemenu`
--

INSERT INTO `[[dbprefix]]modulemenu` VALUES
(1, 2, 150, 0, 1),
(2, 14, 158, 0, 1),
(3, 16, 177, 0, 1),
(4, 15, 102, 0, 1),
(5, 2, 22, 0, 1),
(6, 2, 118, 0, 1),
(7, 1, 25, 0, 1),
(8, 1, 26, 0, 1),
(9, 9, 4, 0, 1),
(10, 8, 4, 0, 1),
(11, 8, 192, 0, 1),
(12, 10, 192, 0, 1),
(13, 2, 192, 0, 1),
(14, 3, 8, 0, 1),
(15, 3, 203, 0, 1),
(16, 1, 196, 0, 1),
(17, 1, 123, 0, 1),
(18, 1, 106, 0, 1),
(19, 1, 133, 0, 1),
(20, 4, 189, 0, 1),
(21, 4, 111, 0, 1),
(22, 4, 112, 0, 1),
(23, 4, 113, 0, 1),
(24, 6, 197, 0, 1),
(25, 6, 153, 0, 1),
(26, 6, 154, 0, 1),
(27, 6, 191, 0, 1),
(28, 6, 195, 0, 1),
(29, 6, 194, 0, 1),
(30, 6, 201, 0, 1),
(31, 6, 75, 0, 1),
(32, 6, 76, 0, 1),
(33, 7, 131, 0, 1),
(34, 7, 125, 0, 1),
(35, 7, 96, 0, 1),
(36, 7, 97, 0, 1),
(37, 7, 78, 0, 1),
(38, 7, 94, 0, 1),
(39, 7, 146, 0, 1),
(40, 7, 174, 0, 1),
(41, 8, 3, 0, 1),
(42, 8, 119, 0, 1),
(43, 8, 5, 0, 1),
(44, 9, 62, 0, 1),
(45, 9, 124, 0, 1),
(46, 10, 63, 0, 1),
(47, 10, 64, 0, 1),
(48, 10, 168, 0, 1),
(49, 10, 167, 0, 1),
(50, 10, 176, 0, 1),
(51, 11, 86, 0, 1),
(52, 11, 87, 0, 1),
(53, 11, 141, 0, 1),
(54, 11, 142, 0, 1),
(55, 11, 179, 0, 1),
(56, 13, 185, 0, 0),
(57, 2, 104, 0, 1),
(58, 6, 148, 0, 1),
(59, 7, 95, 0, 1),
(60, 15, 103, 0, 1),
(61, 2, 89, 0, 1),
(62, 2, 182, 0, 1),
(63, 1, 162, 0, 1),
(64, 13, 186, 0, 0),
(65, 2, 149, 1, 1),
(66, 8, 39, 1, 1),
(67, 7, 39, 1, 1),
(68, 8, 40, 1, 1),
(69, 4, 40, 1, 1),
(70, 2, 40, 1, 1),
(71, 8, 38, 1, 1),
(72, 4, 42, 1, 1),
(73, 2, 42, 1, 1),
(74, 8, 41, 1, 1),
(75, 9, 41, 1, 1),
(76, 4, 41, 1, 1),
(77, 2, 41, 1, 1),
(78, 4, 114, 1, 1),
(79, 4, 115, 1, 1),
(80, 9, 117, 1, 1),
(81, 8, 117, 1, 1),
(82, 6, 137, 1, 1),
(83, 7, 137, 1, 1),
(84, 6, 138, 1, 1),
(85, 7, 138, 1, 1),
(86, 6, 139, 1, 1),
(87, 7, 139, 1, 1),
(88, 6, 140, 1, 1),
(89, 7, 140, 1, 1),
(90, 6, 199, 1, 1),
(91, 6, 200, 1, 1),
(92, 6, 157, 1, 1),
(93, 10, 171, 1, 1),
(94, 10, 163, 1, 1),
(95, 10, 172, 1, 1),
(96, 10, 164, 1, 1),
(97, 11, 178, 1, 1),
(98, 14, 159, 1, 1),
(99, 2, 53, 1, 1),
(100, 1, 55, 1, 1),
(101, 1, 56, 1, 1),
(102, 6, 198, 1, 1),
(103, 6, 155, 1, 1),
(104, 6, 156, 1, 1),
(105, 6, 190, 1, 1),
(106, 6, 193, 1, 1),
(107, 6, 202, 1, 1),
(108, 6, 80, 1, 1),
(109, 6, 81, 1, 1),
(110, 6, 84, 1, 1),
(111, 7, 132, 1, 1),
(112, 7, 126, 1, 1),
(113, 7, 100, 1, 1),
(114, 7, 83, 1, 1),
(115, 7, 175, 1, 1),
(116, 8, 45, 1, 1),
(117, 7, 82, 1, 1),
(118, 8, 120, 1, 1),
(119, 9, 60, 1, 1),
(120, 8, 60, 1, 1),
(121, 8, 46, 1, 1),
(122, 9, 65, 1, 1),
(123, 10, 66, 1, 1),
(124, 10, 67, 1, 1),
(125, 15, 101, 1, 1),
(126, 2, 105, 1, 1),
(127, 4, 107, 1, 1),
(128, 4, 108, 1, 1),
(129, 4, 109, 1, 1),
(130, 6, 147, 1, 1),
(131, 11, 144, 1, 1),
(132, 11, 145, 1, 1),
(133, 11, 160, 1, 1),
(134, 11, 161, 1, 1),
(135, 7, 166, 1, 1),
(136, 10, 165, 1, 1),
(137, 10, 183, 1, 1),
(138, 1, 9, 0, 1),
(139, 12, 209, 0, 1),
(140, 12, 210, 0, 1),
(141, 12, 211, 0, 1),
(142, 12, 212, 0, 1),
(143, 12, 213, 0, 1),
(144, 12, 214, 0, 1),
(145, 12, 215, 0, 1),
(146, 12, 216, 1, 1),
(147, 12, 217, 1, 1),
(148, 12, 218, 1, 1),
(149, 12, 219, 1, 1),
(150, 12, 220, 1, 1),
(151, 3, 204, 0, 1),
(152, 17, 222, 0, 0),
(153, 17, 224, 0, 0),
(154, 10, 225, 0, 1),
(155, 10, 226, 1, 1),
(156, 11, 227, 0, 1),
(157, 6, 228, 0, 1),
(158, 6, 229, 1, 1),
(159, 6, 231, 1, 1),
(160, 6, 232, 0, 1),
(161, 6, 233, 0, 1),
(162, 7, 234, 0, 1),
(163, 7, 235, 0, 1),
(164, 7, 236, 1, 1),
(165, 19, 244, 0, 0),
(166, 19, 245, 0, 0),
(167, 19, 246, 0, 0),
(168, 19, 247, 0, 0),
(169, 19, 249, 0, 0),
(170, 18, 243, 1, 0),
(171, 18, 237, 0, 0),
(172, 18, 238, 1, 0),
(173, 18, 239, 0, 0),
(174, 18, 240, 0, 0),
(175, 18, 248, 0, 0),
(176, 18, 241, 0, 0),
(177, 3, 254, 0, 1),
(178, 20, 255, 0, 0),
(180, 1, 252, 0, 1),
(181, 1, 253, 0, 1),
(182, 1, 90, 0, 1),
(183, 1, 181, 0, 1),
(184, 10, 90, 0, 1),
(185, 10, 181, 0, 1),
(186, 1, 100006001, 0, 1),
(187, 2, 100006001, 0, 1),
(188, 4, 100006001, 0, 1),
(189, 10, 100006001, 0, 1),
(190, 1, 169, 0, 1),
(191, 10, 169, 0, 1),
(198, 22, 259, 0, 0),
(199, 22, 260, 0, 0),
(200, 22, 268, 0, 0),
(201, 22, 269, 0, 0),
(202, 21, 262, 0, 0),
(203, 21, 263, 0, 0),
(204, 21, 264, 0, 0),
(205, 21, 265, 0, 0),
(206, 21, 266, 0, 0),
(207, 21, 267, 0, 0),
(208, 27, 257, 0, 0),
(209, 28, 130, 0, 0),
(210, 29, 270, 0, 0),
(211, 29, 271, 0, 0),
(212, 29, 272, 0, 0),
(213, 29, 273, 0, 0),
(214, 30, 274, 0, 0),
(215, 32, 275, 0, 0),
(216, 32, 276, 0, 0),
(217, 32, 277, 0, 0),
(218, 33, 278, 0, 0),
(219, 33, 279, 0, 0),
(220, 33, 280, 0, 0),
(221, 32, 281, 0, 0),
(222, 33, 282, 0, 0),
(223, 33, 283, 0, 0),
(224, 31, 208, 0, 0),
(225, 6, 287, 0, 1),
(226, 6, 288, 1, 1),
(227, 34, 290, 0, 0),
(228, 34, 291, 0, 0),
(229, 34, 292, 0, 0),
(230, 34, 293, 0, 0),
(231, 34, 294, 0, 0),
(232, 34, 295, 0, 0),
(233, 35, 301, 0, 0),
(234, 35, 303, 0, 0),
(235, 35, 304, 0, 0),
(236, 35, 305, 0, 0),
(237, 35, 306, 0, 0),
(238, 35, 307, 0, 0),
(239, 35, 302, 0, 0),
(240, 1, 313, 0, 1),
(241, 7, 310, 0, 1),
(242, 10, 311, 0, 1),
(243, 1, 286, 0, 1),
(244, 1, 50, 0, 1),
(245, 1, 314, 0, 1),
(246, 32, 316, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modulereport`
--

CREATE TABLE `[[dbprefix]]modulereport` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idModule` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `hidden` int(1) DEFAULT '1' COMMENT '1',
  `active` int(1) DEFAULT '1' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `moduleReportReport` (`idReport`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=121 ;

--
-- Dumping data for table `[[dbprefix]]modulereport`
--

INSERT INTO `[[dbprefix]]modulereport` VALUES
(1, 3, 1, 0, 1),
(2, 3, 2, 0, 1),
(3, 3, 3, 0, 1),
(4, 3, 28, 0, 1),
(5, 3, 29, 0, 1),
(6, 3, 30, 0, 1),
(7, 3, 54, 0, 1),
(8, 3, 55, 0, 1),
(9, 3, 56, 0, 1),
(12, 1, 8, 0, 1),
(13, 1, 78, 0, 1),
(14, 1, 5, 0, 1),
(15, 1, 6, 0, 1),
(16, 1, 42, 0, 1),
(17, 1, 31, 0, 1),
(18, 1, 57, 0, 1),
(19, 1, 58, 0, 1),
(20, 1, 19, 0, 1),
(21, 1, 20, 0, 1),
(22, 1, 76, 0, 1),
(23, 1, 77, 0, 1),
(24, 1, 32, 0, 1),
(25, 1, 52, 0, 1),
(26, 1, 4, 0, 1),
(27, 1, 60, 0, 1),
(28, 2, 9, 0, 1),
(29, 2, 10, 0, 1),
(30, 2, 11, 0, 1),
(31, 2, 12, 0, 1),
(32, 2, 13, 0, 1),
(33, 2, 17, 0, 1),
(34, 2, 14, 0, 1),
(35, 2, 15, 0, 1),
(36, 2, 16, 0, 1),
(37, 2, 18, 0, 1),
(38, 2, 73, 0, 1),
(39, 2, 74, 0, 1),
(40, 2, 80, 0, 1),
(41, 2, 83, 0, 1),
(42, 2, 21, 0, 1),
(43, 1, 21, 0, 1),
(44, 2, 22, 0, 1),
(45, 1, 22, 0, 1),
(46, 8, 23, 0, 1),
(47, 8, 47, 0, 1),
(48, 11, 39, 0, 1),
(49, 1, 63, 0, 1),
(50, 1, 26, 0, 1),
(51, 6, 26, 0, 1),
(52, 1, 27, 0, 1),
(53, 6, 27, 0, 1),
(54, 6, 33, 0, 1),
(55, 6, 34, 0, 1),
(56, 6, 35, 0, 1),
(57, 1, 36, 0, 1),
(58, 6, 36, 0, 1),
(59, 7, 37, 0, 1),
(60, 7, 45, 0, 1),
(61, 7, 46, 0, 1),
(62, 6, 86, 0, 1),
(63, 6, 87, 0, 1),
(64, 4, 44, 0, 1),
(65, 4, 41, 0, 1),
(66, 4, 53, 0, 1),
(67, 4, 43, 0, 1),
(68, 4, 81, 0, 1),
(69, 4, 82, 0, 1),
(70, 4, 88, 0, 1),
(71, 4, 79, 0, 1),
(72, 4, 84, 0, 1),
(73, 4, 89, 0, 1),
(74, 4, 90, 0, 1),
(75, 4, 91, 0, 1),
(76, 4, 92, 0, 1),
(77, 1, 59, 0, 1),
(78, 1, 61, 0, 1),
(79, 1, 62, 0, 1),
(80, 1, 75, 0, 1),
(81, 2, 75, 0, 1),
(82, 1, 64, 0, 1),
(83, 1, 65, 0, 1),
(84, 3, 66, 0, 1),
(85, 3, 67, 0, 1),
(86, 10, 69, 0, 1),
(87, 10, 70, 0, 1),
(88, 10, 71, 0, 1),
(89, 10, 72, 0, 1),
(90, 7, 68, 0, 1),
(91, 3, 110, 0, 1),
(92, 3, 112, 0, 1),
(93, 3, 113, 0, 1),
(94, 3, 114, 0, 1),
(95, 12, 102, 0, 0),
(96, 12, 103, 0, 0),
(97, 12, 104, 0, 0),
(98, 1, 105, 0, 1),
(99, 1, 106, 0, 1),
(100, 1, 109, 0, 1),
(101, 1, 111, 0, 1),
(102, 1, 66, 0, 1),
(103, 10, 66, 0, 1),
(104, 1, 67, 0, 1),
(105, 10, 67, 0, 1),
(106, 1, 108, 0, 1),
(107, 3, 116, 0, 1),
(108, 3, 117, 0, 1),
(109, 2, 118, 0, 1),
(110, 1, 118, 0, 1),
(111, 2, 119, 0, 1),
(112, 2, 120, 0, 1),
(113, 1, 121, 0, 1),
(114, 1, 122, 0, 1),
(115, 7, 123, 0, 1),
(117, 3, 130, 0, 1),
(118, 3, 131, 0, 1),
(119, 7, 145, 0, 1),
(120, 1, 146, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mutex`
--

CREATE TABLE `[[dbprefix]]mutex` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]navigation`
--

CREATE TABLE `[[dbprefix]]navigation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `idParent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `tag` varchar(4000) DEFAULT NULL,
  `moduleName` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=414 ;

--
-- Dumping data for table `[[dbprefix]]navigation`
--

INSERT INTO `[[dbprefix]]navigation` VALUES
(1, 'navPlanning', 0, 0, 0, 20, 'gantt', 'modulePlanning'),
(2, 'navTicketing', 0, 0, 0, 30, NULL, 'moduleTicket'),
(3, 'navFollowup', 0, 0, 0, 40, NULL, NULL),
(4, 'navFinancial', 0, 0, 0, 60, NULL, NULL),
(5, 'navSteering', 0, 0, 0, 50, NULL, 'moduleReview'),
(6, 'navReports', 0, 0, 0, 110, NULL, NULL),
(7, 'navTool', 0, 0, 0, 100, NULL, NULL),
(8, 'navAdministration', 0, 0, 0, 120, NULL, NULL),
(9, 'menuToday', 0, 1, 0, 10, NULL, NULL),
(10, 'navPlanningView', 1, 0, 0, 100, NULL, NULL),
(11, 'navIndicators', 2, 0, 0, 70, NULL, NULL),
(12, 'navLeaveSystem', 3, 0, 0, 40, NULL, NULL),
(13, 'navExpenses', 4, 0, 0, 30, NULL, NULL),
(14, 'navIncomes', 4, 0, 0, 40, NULL, NULL),
(15, 'navSituationNav', 4, 0, 0, 50, NULL, NULL),
(16, 'navRiskManagement', 5, 0, 0, 80, NULL, 'moduleRisk'),
(17, 'navRequirementsManagement', 5, 0, 0, 90, NULL, NULL),
(18, 'navConfigurationManagement', 0, 0, 0, 70, NULL, NULL),
(19, 'navAssetManagement', 5, 0, 0, 100, NULL, NULL),
(20, 'menuProject', 1, 16, 0, 10, NULL, NULL),
(21, 'menuActivity', 1, 25, 0, 20, NULL, NULL),
(22, 'menuMilestone', 1, 26, 0, 30, NULL, NULL),
(23, 'menuMeeting', 1, 62, 0, 40, NULL, NULL),
(24, 'menuPlanning', 1, 9, 0, 70, 'gantt', NULL),
(25, 'menuPlannedWorkManual', 1, 252, 0, 80, NULL, NULL),
(26, 'menuPortfolioPlanning', 10, 123, 0, 20, 'gantt', NULL),
(27, 'menuGlobalPlanning', 10, 196, 0, 40, 'gantt', NULL),
(28, 'menuResourcePlanning', 10, 106, 0, 30, 'gantt', NULL),
(30, 'menuGlobalView', 3, 192, 0, 90, NULL, NULL),
(31, 'menuDashboardTicket', 2, 150, 0, 60, NULL, NULL),
(32, 'menuTicket', 2, 22, 0, 20, NULL, NULL),
(33, 'menuTicketSimple', 2, 118, 0, 30, NULL, NULL),
(34, 'menuKanban', 2, 100006001, 0, 50, NULL, NULL),
(35, 'menuTicketDelay', 11, 89, 0, 10, NULL, NULL),
(36, 'menuTicketDelayPerProject', 11, 182, 0, 20, NULL, NULL),
(37, 'menuIndicatorDefinition', 11, 90, 0, 30, NULL, NULL),
(38, 'menuIndicatorDefinitionPerProject', 11, 181, 0, 40, NULL, NULL),
(39, 'menuImputation', 3, 8, 0, 20, NULL, NULL),
(40, 'menuAbsence', 3, 203, 0, 30, NULL, NULL),
(41, 'menuImputationValidation', 3, 204, 0, 50, NULL, NULL),
(42, 'menuConsultationPlannedWorkManual', 3, 253, 0, 80, NULL, NULL),
(44, 'menuDiary', 3, 133, 0, 100, NULL, NULL),
(45, 'menuLeaveCalendar', 12, 209, 0, 10, NULL, NULL),
(46, 'menuLeave', 12, 210, 0, 20, NULL, NULL),
(47, 'menuDashboardEmployeeManager', 12, 215, 0, 30, NULL, NULL),
(48, 'menuBudget', 13, 197, 0, 10, NULL, NULL),
(49, 'menuSupplierContract', 13, 228, 0, 100, NULL, NULL),
(50, 'menuCallForTender', 13, 153, 0, 40, NULL, NULL),
(51, 'menuTender', 13, 154, 0, 50, NULL, NULL),
(52, 'menuProviderOrder', 13, 191, 0, 60, NULL, NULL),
(53, 'menuProviderTerm', 13, 195, 0, 80, NULL, NULL),
(54, 'menuProviderBill', 13, 194, 0, 70, NULL, NULL),
(55, 'menuProviderPayment', 13, 201, 0, 90, NULL, NULL),
(56, 'menuIndividualExpense', 13, 75, 0, 30, NULL, NULL),
(57, 'menuProjectExpense', 13, 76, 0, 20, NULL, NULL),
(58, 'menuClientContract', 14, 234, 0, 100, NULL, NULL),
(59, 'menuQuotation', 14, 131, 0, 10, NULL, NULL),
(60, 'menuCommand', 14, 125, 0, 20, NULL, NULL),
(61, 'menuTerm', 14, 96, 0, 30, NULL, NULL),
(62, 'menuBill', 14, 97, 0, 40, NULL, NULL),
(63, 'menuPayment', 14, 78, 0, 50, NULL, NULL),
(64, 'menuActivityPrice', 14, 94, 0, 70, NULL, NULL),
(65, 'menuGallery', 14, 146, 0, 60, NULL, NULL),
(66, 'menuCatalog', 14, 174, 0, 80, NULL, NULL),
(67, 'menuCatalogUO', 14, 255, 0, 90, NULL, NULL),
(68, 'menuHierarchicalBudget', 4, 233, 0, 10, NULL, NULL),
(69, 'menuGanttSupplierContract', 13, 232, 0, 110, NULL, NULL),
(70, 'menuGanttClientContract', 14, 235, 0, 110, NULL, NULL),
(71, 'menuProjectSituation', 15, 245, 0, 10, NULL, NULL),
(72, 'menuProjectSituationExpense', 15, 246, 0, 20, NULL, NULL),
(73, 'menuProjectSituationIncome', 15, 247, 0, 30, NULL, NULL),
(74, 'menuMeeting', 5, 62, 0, 10, NULL, NULL),
(75, 'menuDecision', 5, 63, 0, 50, NULL, NULL),
(76, 'menuQuestion', 5, 64, 0, 60, NULL, NULL),
(77, 'menuPeriodicMeeting', 5, 124, 0, 20, NULL, NULL),
(78, 'menuDeliverable', 312, 167, 0, 20, NULL, NULL),
(80, 'menuIncoming', 312, 168, 0, 10, NULL, NULL),
(81, 'menuDelivery', 312, 176, 0, 30, NULL, NULL),
(82, 'menuChangeRequest', 5, 225, 0, 40, NULL, NULL),
(83, 'menuRisk', 16, 3, 0, 10, NULL, NULL),
(84, 'menuIssue', 16, 5, 0, 20, NULL, NULL),
(85, 'menuOpportunity', 16, 119, 0, 30, NULL, NULL),
(86, 'menuRequirement', 17, 111, 0, 10, NULL, NULL),
(87, 'menuTestCase', 17, 112, 0, 20, NULL, NULL),
(88, 'menuTestSession', 17, 113, 0, 30, NULL, NULL),
(89, 'menuDashboardRequirement', 17, 189, 0, 40, NULL, NULL),
(90, 'menuProduct', 18, 86, 0, 10, NULL, NULL),
(91, 'menuProductVersion', 18, 87, 0, 20, NULL, NULL),
(92, 'menuComponent', 18, 141, 0, 30, NULL, NULL),
(93, 'menuComponentVersion', 18, 142, 0, 40, NULL, NULL),
(94, 'menuVersionsPlanning', 18, 179, 0, 50, 'gantt', NULL),
(95, 'menuVersionsComponentPlanning', 18, 227, 0, 60, 'gantt', NULL),
(96, 'menuAsset', 19, 237, 0, 10, NULL, NULL),
(97, 'menuLocation', 19, 238, 0, 20, NULL, NULL),
(98, 'menuBrand', 19, 239, 0, 30, NULL, NULL),
(99, 'menuModel', 19, 240, 0, 40, NULL, NULL),
(100, 'menuAssetCategory', 19, 241, 0, 50, NULL, NULL),
(101, 'menuAssetType', 19, 248, 0, 60, NULL, NULL),
(102, 'menuMessage', 7, 51, 0, 40, NULL, NULL),
(103, 'menuImportData', 7, 58, 0, 30, NULL, NULL),
(104, 'menuMail', 7, 69, 0, 60, NULL, NULL),
(105, 'menuAlert', 7, 91, 0, 80, NULL, NULL),
(106, 'menuAudit', 8, 122, 0, 20, NULL, NULL),
(107, 'menuNotification', 7, 185, 0, 90, NULL, NULL),
(108, 'menuMailToSend', 7, 187, 0, 70, NULL, NULL),
(109, 'menuAutoSendReport', 7, 205, 0, 100, NULL, NULL),
(110, 'menuDataCloning', 7, 222, 0, 110, NULL, NULL),
(111, 'menuMessageLegal', 7, 223, 0, 50, NULL, NULL),
(112, 'navHumanResourceNav', 0, 0, 0, 80, NULL, NULL),
(113, 'menuLeaveCalendar', 112, 209, 0, 10, NULL, NULL),
(114, 'menuLeave', 112, 210, 0, 20, NULL, NULL),
(115, 'menuEmployeeLeaveEarned', 112, 211, 0, 30, NULL, NULL),
(116, 'menuEmploymentContract', 112, 213, 0, 40, NULL, NULL),
(117, 'menuEmployeeManager', 112, 214, 0, 50, NULL, NULL),
(118, 'menuDashboardEmployeeManager', 112, 215, 0, 60, NULL, NULL),
(119, 'navParameter', 112, 0, 0, 70, NULL, NULL),
(120, 'menuLeaveType', 119, 217, 0, 10, NULL, NULL),
(121, 'menuEmploymentContractType', 119, 218, 0, 20, NULL, NULL),
(122, 'menuEmploymentContractEndReason', 119, 219, 0, 30, NULL, NULL),
(123, 'menuLeavesSystemHabilitation', 119, 220, 0, 40, NULL, NULL),
(124, 'menuGlobalParameter', 8, 18, 0, 40, NULL, NULL),
(125, 'menuUserParameter', 8, 20, 0, 30, NULL, NULL),
(126, 'menuAdmin', 8, 92, 0, 10, 'log;cron', NULL),
(128, 'navEnvironmentNav', 0, 0, 0, 90, NULL, NULL),
(129, 'navAutomation', 8, 0, 0, 70, NULL, NULL),
(130, 'navHabilitationParameter', 8, 0, 0, 60, NULL, NULL),
(131, 'navListOfValues', 8, 0, 0, 80, NULL, NULL),
(132, 'navType', 8, 0, 0, 90, NULL, NULL),
(133, 'navHumanResourceParameters', 8, 0, 0, 100, NULL, NULL),
(134, 'menuDataCloningParameter', 8, 224, 0, 110, NULL, NULL),
(135, 'menuClient', 128, 15, 0, 70, NULL, NULL),
(136, 'menuUser', 128, 17, 0, 20, NULL, NULL),
(137, 'menuResource', 128, 44, 0, 30, NULL, NULL),
(139, 'menuAffectation', 128, 50, 0, 90, NULL, NULL),
(140, 'menuTeam', 128, 57, 0, 100, NULL, NULL),
(141, 'menuContact', 128, 72, 0, 60, NULL, NULL),
(142, 'menuCalendar', 128, 85, 0, 140, NULL, NULL),
(143, 'menuRecipient', 128, 95, 0, 110, NULL, NULL),
(144, 'menuDocumentDirectory', 128, 103, 0, 130, NULL, NULL),
(145, 'menuContext', 128, 104, 0, 120, NULL, NULL),
(146, 'menuProvider', 128, 148, 0, 80, NULL, NULL),
(147, 'menuResourceTeam', 128, 188, 0, 40, NULL, NULL),
(148, 'menuEmployee', 128, 212, 0, 50, NULL, NULL),
(149, 'menuWorkflow', 129, 59, 0, 10, NULL, NULL),
(150, 'menuStatusMail', 129, 68, 0, 30, NULL, NULL),
(151, 'menuTicketDelay', 129, 89, 0, 60, NULL, NULL),
(152, 'menuIndicatorDefinition', 129, 90, 0, 80, NULL, NULL),
(153, 'menuPredefinedNote', 129, 116, 0, 110, NULL, NULL),
(154, 'menuChecklistDefinition', 129, 130, 0, 120, NULL, NULL),
(155, 'menuJoblistDefinition', 129, 162, 0, 130, NULL, NULL),
(156, 'menuKpiDefinition', 129, 169, 0, 50, NULL, NULL),
(157, 'menuStatusMailPerProject', 129, 180, 0, 40, NULL, NULL),
(158, 'menuIndicatorDefinitionPerProject', 129, 181, 0, 90, NULL, NULL),
(159, 'menuTicketDelayPerProject', 129, 182, 0, 70, NULL, NULL),
(160, 'menuEmailTemplate', 129, 184, 0, 20, NULL, NULL),
(161, 'menuNotificationDefinition', 129, 186, 0, 100, NULL, NULL),
(162, 'menuInputMailboxTicket', 129, 250, 0, 50, NULL, NULL),
(163, 'menuHabilitation', 130, 21, 0, 30, NULL, NULL),
(164, 'menuAccessProfile', 130, 47, 0, 40, NULL, NULL),
(165, 'menuAccessRight', 130, 48, 0, 50, NULL, NULL),
(166, 'menuProfile', 130, 49, 0, 20, NULL, NULL),
(167, 'menuHabilitationReport', 130, 70, 0, 80, NULL, NULL),
(168, 'menuHabilitationOther', 130, 71, 0, 90, NULL, NULL),
(169, 'menuAccessRightNoProject', 130, 135, 0, 70, NULL, NULL),
(170, 'menuModule', 130, 221, 0, 10, NULL, NULL),
(171, 'menuAccessProfileNoProject', 130, 256, 0, 60, NULL, NULL),
(172, 'menuRole', 131, 73, 0, 20, NULL, NULL),
(173, 'menuStatus', 131, 34, 0, 10, NULL, NULL),
(174, 'menuResolution', 131, 149, 0, 40, NULL, NULL),
(175, 'menuQuality', 321, 128, 0, 10, NULL, NULL),
(176, 'menuHealth', 321, 121, 0, 20, NULL, NULL),
(177, 'menuOverallProgress', 321, 127, 0, 30, NULL, NULL),
(178, 'menuTrend', 321, 129, 0, 40, NULL, NULL),
(179, 'menuLikelihood', 321, 39, 0, 50, NULL, NULL),
(180, 'menuCriticality', 321, 40, 0, 60, NULL, NULL),
(181, 'menuSeverity', 321, 38, 0, 70, NULL, NULL),
(182, 'menuUrgency', 321, 42, 0, 80, NULL, NULL),
(183, 'menuPriority', 321, 41, 0, 90, NULL, NULL),
(184, 'menuRiskLevel', 322, 114, 0, 130, NULL, NULL),
(185, 'menuFeasibility', 322, 115, 0, 140, NULL, NULL),
(186, 'menuEfficiency', 322, 117, 0, 150, NULL, NULL),
(187, 'menuPaymentDelay', 323, 137, 0, 160, NULL, NULL),
(188, 'menuPaymentMode', 323, 138, 0, 170, NULL, NULL),
(189, 'menuDeliveryMode', 323, 139, 0, 180, NULL, NULL),
(190, 'menuMeasureUnit', 323, 140, 0, 190, NULL, NULL),
(191, 'menuBudgetOrientation', 323, 199, 0, 200, NULL, NULL),
(192, 'menuBudgetCategory', 323, 200, 0, 210, NULL, NULL),
(193, 'menuTenderStatus', 323, 157, 0, 220, NULL, NULL),
(194, 'menuCategory', 131, 170, 0, 30, NULL, NULL),
(195, 'menuIncomingWeight', 324, 171, 0, 240, NULL, NULL),
(196, 'menuDeliverableWeight', 324, 163, 0, 250, NULL, NULL),
(197, 'menuIncomingStatus', 324, 172, 0, 260, NULL, NULL),
(198, 'menuDeliverableStatus', 324, 164, 0, 270, NULL, NULL),
(199, 'menuLanguage', 354, 178, 0, 10, NULL, NULL),
(200, 'menuOrganizationType', 330, 159, 0, 10, NULL, NULL),
(201, 'menuProjectType', 132, 93, 0, 10, NULL, NULL),
(202, 'menuTicketType', 132, 53, 0, 50, NULL, NULL),
(203, 'menuActivityType', 132, 55, 0, 20, NULL, NULL),
(204, 'menuMilestoneType', 132, 56, 0, 30, NULL, NULL),
(205, 'menuBudgetType', 328, 198, 0, 10, NULL, NULL),
(206, 'menuCallForTenderType', 328, 155, 0, 50, NULL, NULL),
(207, 'menuTenderType', 328, 156, 0, 60, NULL, NULL),
(208, 'menuProviderOrderType', 328, 190, 0, 70, NULL, NULL),
(209, 'menuProviderBillType', 328, 193, 0, 80, NULL, NULL),
(210, 'menuProviderPaymentType', 328, 202, 0, 90, NULL, NULL),
(211, 'menuIndividualExpenseType', 328, 80, 0, 30, NULL, NULL),
(212, 'menuProjectExpenseType', 328, 81, 0, 20, NULL, NULL),
(213, 'menuExpenseDetailType', 328, 84, 0, 40, NULL, NULL),
(214, 'menuQuotationType', 329, 132, 0, 10, NULL, NULL),
(215, 'menuCommandType', 329, 126, 0, 20, NULL, NULL),
(216, 'menuBillType', 329, 100, 0, 30, NULL, NULL),
(217, 'menuPaymentType', 329, 83, 0, 40, NULL, NULL),
(218, 'menuCatalogType', 329, 175, 0, 50, NULL, NULL),
(219, 'menuInvoiceType', 329, 82, 0, 60, NULL, NULL),
(220, 'menuRiskType', 330, 45, 0, 15, NULL, NULL),
(221, 'menuOpportunityType', 330, 120, 0, 30, NULL, NULL),
(222, 'menuActionType', 132, 60, 0, 60, NULL, NULL),
(223, 'menuIssueType', 330, 46, 0, 20, NULL, NULL),
(224, 'menuMeetingType', 132, 65, 0, 40, NULL, NULL),
(225, 'menuChangeRequestType', 330, 226, 0, 50, NULL, NULL),
(226, 'menuDecisionType', 330, 66, 0, 60, NULL, NULL),
(227, 'menuQuestionType', 330, 67, 0, 70, NULL, NULL),
(228, 'menuMessageType', 332, 52, 0, 20, NULL, NULL),
(229, 'menuDocumentType', 332, 101, 0, 10, NULL, NULL),
(230, 'menuContextType', 332, 105, 0, 50, NULL, NULL),
(231, 'menuRequirementType', 330, 107, 0, 80, NULL, NULL),
(232, 'menuTestCaseType', 330, 108, 0, 90, NULL, NULL),
(233, 'menuTestSessionType', 330, 109, 0, 100, NULL, NULL),
(234, 'menuClientType', 332, 134, 0, 30, NULL, NULL),
(235, 'menuProviderType', 332, 147, 0, 40, NULL, NULL),
(236, 'menuProductType', 331, 144, 0, 10, NULL, NULL),
(237, 'menuComponentType', 331, 145, 0, 20, NULL, NULL),
(238, 'menuProductVersionType', 331, 160, 0, 30, NULL, NULL),
(239, 'menuComponentVersionType', 331, 161, 0, 40, NULL, NULL),
(240, 'menuIncomingType', 330, 166, 0, 110, NULL, NULL),
(241, 'menuDeliverableType', 330, 165, 0, 120, NULL, NULL),
(242, 'menuDeliveryType', 330, 183, 0, 130, NULL, NULL),
(243, 'menuSupplierContractType', 328, 229, 0, 100, NULL, NULL),
(244, 'menuClientContractType', 329, 236, 0, 70, NULL, NULL),
(245, 'menuRenewal', 323, 231, 0, 290, NULL, NULL),
(246, 'menuPredefinedSituation', 323, 249, 0, 300, NULL, NULL),
(247, 'menuInterventionMode', 131, 251, 0, 60, NULL, NULL),
(248, 'menuDocument', 7, 102, 0, 10, NULL, NULL),
(249, 'menuAction', 5, 4, 0, 30, NULL, NULL),
(250, 'menuActivityStream', 3, 177, 0, 110, NULL, NULL),
(252, 'menuOrganization', 128, 158, 0, 10, NULL, NULL),
(253, 'menuConsultationValidation', 3, 254, 0, 60, NULL, NULL),
(254, 'menuLeaveType', 133, 217, 0, 10, NULL, NULL),
(255, 'menuEmploymentContractType', 133, 218, 0, 20, NULL, NULL),
(256, 'menuEmploymentContractEndReason', 133, 219, 0, 30, NULL, NULL),
(257, 'menuLeavesSystemHabilitation', 133, 220, 0, 40, NULL, NULL),
(258, 'menuPlannedWorkManual', 3, 252, 0, 70, NULL, NULL),
(260, 'menuPlanning', 10, 9, 0, 10, 'gantt', NULL),
(300, 'navPlugin', 0, 0, 0, 130, NULL, NULL),
(301, 'menuPluginManagement', 300, 136, 0, 10, NULL, NULL),
(302, 'menuPeriodicMeeting', 1, 124, 0, 50, NULL, NULL),
(303, 'menuTestSession', 1, 113, 0, 60, NULL, NULL),
(304, 'menuProject', 2, 16, 0, 10, NULL, NULL),
(305, 'menuProject', 3, 16, 0, 10, NULL, NULL),
(306, 'menuVersionsPlanning', 10, 179, 0, 70, 'gantt', NULL),
(307, 'menuVersionsComponentPlanning', 10, 227, 0, 80, 'gantt', NULL),
(308, 'menuGanttSupplierContract', 10, 232, 0, 90, NULL, NULL),
(309, 'menuGanttClientContract', 10, 235, 0, 100, NULL, NULL),
(310, 'menuKanban', 1, 100006001, 0, 90, NULL, NULL),
(311, 'menuAction', 2, 4, 0, 40, NULL, NULL),
(312, 'navDelivery', 5, 0, 0, 70, NULL, NULL),
(313, 'menuKpiDefinition', 312, 169, 0, 80, NULL, NULL),
(314, 'menuAction', 16, 4, 0, 40, NULL, NULL),
(315, 'menuProjectSituation', 4, 245, 0, 20, NULL, NULL),
(317, 'menuDocumentDirectory', 7, 103, 0, 20, NULL, NULL),
(318, 'menuAudit', 7, 122, 0, 120, NULL, NULL),
(319, 'menuModule', 8, 221, 0, 50, NULL, NULL),
(321, 'navQuality', 131, 0, 0, 70, NULL, NULL),
(322, 'navSteering', 131, 0, 0, 80, NULL, 'moduleReview'),
(323, 'navFinancial', 131, 0, 0, 90, NULL, NULL),
(324, 'navDelivery', 131, 0, 0, 100, NULL, NULL),
(325, 'menuPredefinedSituation', 15, 249, 0, 40, NULL, NULL),
(328, 'navExpenses', 132, 0, 0, 70, NULL, NULL),
(329, 'navIncomes', 132, 0, 0, 80, NULL, NULL),
(330, 'navSteering', 132, 0, 0, 90, NULL, 'moduleReview'),
(331, 'navProduct', 132, 0, 0, 100, NULL, NULL),
(332, 'navEnvironmentNav', 132, 0, 0, 110, NULL, NULL),
(333, 'reportRiskManagementPlan', 16, 0, 23, 50, NULL, NULL),
(336, 'menuViewAllSubTask', 3, 257, 0, 55, NULL, NULL),
(337, 'menuViewAllSubTask', 5, 257, 0, 35, NULL, NULL),
(338, 'menuDocumentRight', 130, 258, 0, 85, NULL, NULL),
(339, 'menuPokerSession', 372, 259, 0, 115, NULL, NULL),
(340, 'menuPokerSessionVoting', 372, 260, 0, 120, NULL, NULL),
(341, 'navLocalization', 0, 0, 0, 95, NULL, 'moduleLocalization'),
(342, 'menuLocalizationRequest', 341, 262, 0, 20, NULL, NULL),
(343, 'menuLocalizationItem', 341, 263, 0, 30, NULL, NULL),
(344, 'menuLocalizationTranslator', 341, 264, 0, 40, NULL, NULL),
(345, 'menuLanguageSkillLevel', 354, 265, 0, 30, NULL, NULL),
(346, 'menuLocalizationRequestType', 332, 266, 0, 60, NULL, NULL),
(347, 'menuLocalizationItemType', 332, 267, 0, 70, NULL, NULL),
(348, 'menuLanguageSkillLevel', 341, 265, 0, 50, NULL, NULL),
(349, 'menuLocalizationRequestType', 341, 266, 0, 60, NULL, NULL),
(350, 'menuLocalizationItemType', 341, 267, 0, 70, NULL, NULL),
(351, 'menuPokerSessionType', 132, 268, 0, 45, NULL, NULL),
(352, 'menuPokerComplexity', 322, 269, 0, 155, NULL, NULL),
(353, 'menuEmployee', 112, 212, 0, 65, NULL, NULL),
(354, 'navLocalization', 131, 0, 0, 110, NULL, NULL),
(355, 'menuLanguage', 341, 178, 0, 45, NULL, NULL),
(356, 'menuKanban', 17, 100006001, 0, 85, NULL, NULL),
(357, 'navMailNavigation', 5, 0, 0, 110, NULL, 'moduleMail'),
(358, 'menuOutgoingMail', 357, 270, 0, 115, NULL, 'moduleMail'),
(359, 'menuIncomingMail', 357, 271, 0, 120, NULL, 'moduleMail'),
(360, 'menuIncomingMailType', 330, 272, 0, 999, NULL, 'moduleMail'),
(361, 'menuOutgoingMailType', 330, 273, 0, 998, NULL, 'moduleMail'),
(362, 'menuTokenDefinition', 14, 274, 0, 95, NULL, NULL),
(364, 'menuSkill', 112, 275, 0, 61, NULL, NULL),
(365, 'menuSkillLevel', 112, 276, 0, 63, NULL, NULL),
(366, 'menuResourceSkill', 112, 277, 0, 65, NULL, NULL),
(367, 'menuResource', 112, 44, 0, 67, NULL, NULL),
(368, 'navVoting', 3, 0, 0, 140, NULL, 'moduleVoting'),
(369, 'menuVotingAttributionRule', 368, 278, 0, 10, NULL, 'moduleVoting'),
(370, 'menuVotingUseRule', 368, 279, 0, 20, NULL, 'moduleVoting'),
(371, 'menuVotingUseRulePerProject', 368, 280, 0, 30, NULL, 'moduleVoting'),
(372, 'navPoker', 3, 0, 0, 138, NULL, 'moduleVoting'),
(373, 'menuHierarchicalSkill', 112, 281, 0, 62, NULL, NULL),
(374, 'menuVotingFollowUp', 368, 282, 0, 40, NULL, 'moduleVoting'),
(375, 'menuVotingAttributionFollowUp', 368, 283, 0, 50, NULL, 'moduleVoting'),
(376, 'menuUser', 368, 17, 0, 60, NULL, 'moduleVoting'),
(377, 'menuClient', 368, 15, 0, 70, NULL, 'moduleVoting'),
(378, 'menuCriticalResources', 1, 284, 0, 75, NULL, NULL),
(379, 'menuResourceMaterial', 128, 285, 0, 45, NULL, NULL),
(380, 'menuAssignment', 128, 286, 0, 95, NULL, NULL),
(381, 'menuActivityExpense', 13, 287, 0, 25, NULL, NULL),
(382, 'menuActivityExpenseType', 328, 288, 0, 25, NULL, NULL),
(383, 'menuLessonLearned', 389, 290, 0, 300, NULL, 'moduleProjectAnalysis'),
(384, 'menuLessonLearnedType', 330, 291, 0, 900, NULL, 'moduleProjectAnalysis'),
(385, 'menuAssumption', 389, 292, 0, 100, NULL, 'moduleProjectAnalysis'),
(386, 'menuAssumptionType', 330, 293, 0, 901, NULL, 'moduleProjectAnalysis'),
(387, 'menuConstraint', 389, 294, 0, 200, NULL, 'moduleProjectAnalysis'),
(388, 'menuConstraintType', 330, 295, 0, 902, NULL, 'moduleProjectAnalysis'),
(389, 'navProjectAnalysis', 5, 0, 0, 900, NULL, 'moduleProjectAnalysis'),
(390, 'menuAction', 389, 4, 0, 500, NULL, 'moduleProjectAnalysis'),
(391, 'menuSubscription', 0, 300, 0, 900, NULL, NULL),
(392, 'menuProspect', 398, 301, 0, 300, NULL, 'moduleCrmProspect'),
(393, 'menuProspectType', 398, 302, 0, 911, NULL, 'moduleCrmProspect'),
(394, 'menuDomainProspect', 398, 303, 0, 306, NULL, 'moduleCrmProspect'),
(395, 'menuPositionProspect', 398, 304, 0, 307, NULL, 'moduleCrmProspect'),
(396, 'menuDecisionMakerProspect', 398, 305, 0, 308, NULL, 'moduleCrmProspect'),
(397, 'menuProspectOrigin', 398, 306, 0, 301, NULL, 'moduleCrmProspect'),
(398, 'navCrmProspect', 0, 0, 0, 85, NULL, 'moduleCrmProspect'),
(401, 'menuPlanningMode', 131, 309, 0, 50, NULL, 'modulePlanning'),
(402, 'menuWorkCommand', 14, 310, 0, 25, NULL, NULL),
(405, 'menuAcceptance', 5, 311, 0, 65, NULL, NULL),
(406, 'menuAcceptanceType', 330, 312, 0, 296, NULL, NULL),
(407, 'menuWorkPlan', 10, 313, 0, 110, NULL, NULL),
(408, 'menuWorkPlan', 1, 313, 0, 71, NULL, NULL),
(409, 'menuInputMailboxImport', 129, 315, 0, 989, NULL, NULL),
(410, 'menuPlanningWorkPlan', 1, 314, 0, 72, 'gantt', NULL),
(411, 'menuPlanningWorkPlan', 10, 314, 0, 111, 'gantt', NULL),
(412, 'menuProspectEventType', 398, 308, 0, 921, NULL, 'moduleCrmProspect'),
(413, 'menuResourceSkillSimple', 112, 316, 0, 66, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]note`
--

CREATE TABLE `[[dbprefix]]note` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `note` mediumtext,
  `idPrivacy` int(12) unsigned DEFAULT '1' COMMENT '12',
  `idTeam` int(12) unsigned DEFAULT '1' COMMENT '12',
  `fromEmail` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `idNote` int(12) DEFAULT NULL COMMENT '12',
  `replyLevel` int(12) DEFAULT '0' COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `noteUser` (`idUser`),
  KEY `noteRef` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifiable`
--

CREATE TABLE `[[dbprefix]]notifiable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `notifiableItem` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=37 ;

--
-- Dumping data for table `[[dbprefix]]notifiable`
--

INSERT INTO `[[dbprefix]]notifiable` VALUES
(1, 'Action', 'Action', 0),
(3, 'Bill', 'Bill', 0),
(4, 'Command', 'Command', 0),
(5, 'Deliverable', 'Deliverable', 0),
(6, 'Incoming', 'Incoming', 0),
(7, 'Issue', 'Issue', 0),
(8, 'Meeting', 'Meeting', 0),
(10, 'Opportunity', 'Opportunity', 0),
(11, 'ProjectExpense', 'ProjectExpense', 0),
(12, 'Quotation', 'Quotation', 0),
(13, 'Requirement', 'Requirement', 0),
(14, 'Risk', 'Risk', 0),
(15, 'Ticket', 'Ticket', 0),
(16, 'Term', 'Term', 0),
(17, 'Delivery', 'Delivery', 0),
(18, 'ProviderOrder', 'ProviderOrder', 0),
(19, 'ProviderTerm', 'ProviderTerm', 0),
(20, 'ProviderBill', 'ProviderBill', 0),
(21, 'Tender', 'Tender', 0),
(22, 'Leave', 'Leave', 0),
(23, 'EmployeeLeaveEarned', 'EmployeeLeaveEarned', 0),
(27, 'ChangeRequest', 'ChangeRequest', 0),
(28, 'SupplierContract', 'SupplierContract', 0),
(29, 'ClientContract', 'ClientContract', 0),
(30, 'Asset', 'Asset', 0),
(32, 'ActivityExpense', 'ActivityExpense', 0),
(33, 'IndividualExpense', 'IndividualExpense', 0),
(34, 'ActivityPlanningElement', 'ActivityPlanningElement', 0),
(35, 'ProjectPlanningElement', 'ProjectPlanningElement', 0),
(36, 'MilestonePlanningElement', 'MilestonePlanningElement', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification`
--

CREATE TABLE `[[dbprefix]]notification` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idNotificationDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idNotifiable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idNotificationType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatusNotification` int(12) unsigned DEFAULT NULL COMMENT '12',
  `title` varchar(4000) DEFAULT NULL,
  `content` mediumtext,
  `creationDateTime` datetime DEFAULT NULL,
  `notificationDate` date DEFAULT NULL,
  `notificationTime` time DEFAULT NULL,
  `notifiedObjectId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendEmail` int(1) DEFAULT '0' COMMENT '1',
  `emailSent` int(1) DEFAULT '0' COMMENT '1',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `idPluginIdVersion` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notificationHasNotificationDefinition_idx` (`idNotificationDefinition`),
  KEY `notificationNotifiable_idx` (`idNotifiable`),
  KEY `notificationStatusNotification_idx` (`idStatusNotification`),
  KEY `notificationNotificationType_idx` (`idNotificationType`),
  KEY `notificationMenu_idx` (`idMenu`),
  KEY `notificationResource_idx` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notificationdefinition`
--

CREATE TABLE `[[dbprefix]]notificationdefinition` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idNotifiable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMenu` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idNotificationType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `title` varchar(100) DEFAULT NULL,
  `content` mediumtext,
  `notificationRule` varchar(400) DEFAULT NULL,
  `notificationReceivers` varchar(400) DEFAULT NULL,
  `sendEmail` int(1) DEFAULT '0' COMMENT '1',
  `targetDateNotifiableField` varchar(100) DEFAULT NULL,
  `everyDay` int(1) DEFAULT '0' COMMENT '1',
  `everyWeek` int(1) DEFAULT '0' COMMENT '1',
  `everyMonth` int(1) DEFAULT '0' COMMENT '1',
  `everyYear` int(1) DEFAULT '0' COMMENT '1',
  `fixedDay` int(5) DEFAULT NULL COMMENT '5',
  `fixedMonth` int(5) DEFAULT NULL COMMENT '5',
  `notificationNbRepeatsBefore` int(5) DEFAULT NULL COMMENT '5',
  `notificationGenerateBefore` int(5) DEFAULT NULL COMMENT '5',
  `notificationGenerateBeforeInMin` int(5) DEFAULT NULL COMMENT '5',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `notificationdefinitionNotifiable_idx` (`idNotifiable`),
  KEY `notificationdefinitionNotificationType_idx` (`idNotificationType`),
  KEY `notificationdefinitionMenu_idx` (`idMenu`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauthclient`
--

CREATE TABLE `[[dbprefix]]oauthclient` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `oauthSource` varchar(200) DEFAULT NULL,
  `tenantId` varchar(200) DEFAULT NULL,
  `clientId` varchar(200) DEFAULT NULL,
  `clientSecret` varchar(2000) DEFAULT NULL,
  `scope` varchar(2000) DEFAULT NULL,
  `token` varchar(4000) DEFAULT NULL,
  `refreshToken` varchar(4000) DEFAULT NULL,
  `tokenDateTime` datetime DEFAULT NULL,
  `tokenExpires` int(10) unsigned DEFAULT NULL COMMENT '10',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]opportunity`
--

CREATE TABLE `[[dbprefix]]opportunity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idOpportunityType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cause` mediumtext,
  `impact` mediumtext,
  `idSeverity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLikelihood` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCriticality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialEndDate` date DEFAULT NULL,
  `actualEndDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `impactCost` decimal(11,2) unsigned DEFAULT '0.00',
  `projectReserveAmount` decimal(11,2) unsigned DEFAULT '0.00',
  `impactCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `projectReserveAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `opportunityProject` (`idProject`),
  KEY `opportunityUser` (`idUser`),
  KEY `opportunityResource` (`idResource`),
  KEY `opportunityStatus` (`idStatus`),
  KEY `opportunityType` (`idOpportunityType`),
  KEY `opportunitySeverity` (`idSeverity`),
  KEY `opportunityLikelihood` (`idLikelihood`),
  KEY `opportunityCriticality` (`idCriticality`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]organization`
--

CREATE TABLE `[[dbprefix]]organization` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sortOrder` varchar(400) DEFAULT NULL,
  `idOrganizationType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `lastUpdateDateTime` datetime DEFAULT NULL,
  `alertOverPct` int(3) unsigned DEFAULT '0' COMMENT '3',
  `warningOverPct` int(3) unsigned DEFAULT '0' COMMENT '3',
  `okUnderPct` int(3) unsigned DEFAULT '0' COMMENT '3',
  `idleDateTime` datetime DEFAULT NULL,
  `organizationCode` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resourceOrganization` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]origin`
--

CREATE TABLE `[[dbprefix]]origin` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `originType` varchar(100) DEFAULT NULL,
  `originId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `originOrigin` (`originType`,`originId`),
  KEY `originRef` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]originable`
--

CREATE TABLE `[[dbprefix]]originable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=45 ;

--
-- Dumping data for table `[[dbprefix]]originable`
--

INSERT INTO `[[dbprefix]]originable` VALUES
(1, 'Ticket', 0),
(2, 'Activity', 0),
(3, 'Milestone', 0),
(4, 'IndividualExpense', 0),
(5, 'ProjectExpense', 0),
(6, 'Risk', 0),
(7, 'Action', 0),
(8, 'Issue', 0),
(9, 'Meeting', 0),
(10, 'Decision', 0),
(11, 'Question', 0),
(12, 'Project', 0),
(13, 'Document', 0),
(14, 'Requirement', 0),
(15, 'TestSession', 0),
(16, 'TestCase', 0),
(17, 'Command', 0),
(18, 'Quotation', 0),
(19, 'Bill', 0),
(20, 'Deliverable', 0),
(21, 'Delivery', 0),
(22, 'Incoming', 0),
(23, 'Opportunity', 0),
(24, 'Tender', 0),
(25, 'DocumentVersion', 0),
(26, 'ProviderOrder', 0),
(27, 'ProviderBill', 0),
(28, 'ChangeRequest', 0),
(29, 'SupplierContract', 0),
(30, 'ClientContract', 0),
(31, 'Asset', 0),
(32, 'CallForTender', 0),
(33, 'IncomingMail', 0),
(34, 'OutgoingMail', 0),
(35, 'ActivityExpense', 0),
(36, 'LessonLearned', 0),
(37, 'Assumption', 0),
(38, 'Constraint', 0),
(39, 'Prospect', 0),
(40, 'DomainProspect', 0),
(41, 'PositionProspect', 0),
(42, 'DecisionMakerProspect', 0),
(43, 'ProspectOrigin', 0),
(44, 'ProspectEvent', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]otherclient`
--

CREATE TABLE `[[dbprefix]]otherclient` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(4000) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `otherclientRef` (`refType`,`refId`),
  KEY `otherclientVersion` (`idClient`),
  KEY `otherclientUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]otherversion`
--

CREATE TABLE `[[dbprefix]]otherversion` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `comment` varchar(4000) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `otherversionRef` (`refType`,`refId`),
  KEY `otherversionVersion` (`idVersion`),
  KEY `otherversionUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]outgoingmail`
--

CREATE TABLE `[[dbprefix]]outgoingmail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOutgoingMailType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendDate` date DEFAULT NULL,
  `idDeliveryMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResponsible` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `address` varchar(200) DEFAULT NULL,
  `descriptionRecipient` mediumtext,
  `description` mediumtext,
  `idApprovalStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]overallprogress`
--

CREATE TABLE `[[dbprefix]]overallprogress` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]overallprogress`
--

INSERT INTO `[[dbprefix]]overallprogress` VALUES
(1, '0%', 100, 0),
(2, '10%', 200, 0),
(3, '25%', 300, 0),
(4, '50%', 400, 0),
(5, '75%', 500, 0),
(6, '90%', 600, 0),
(7, '100%', 700, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]parameter`
--

CREATE TABLE `[[dbprefix]]parameter` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `parameterCode` varchar(100) DEFAULT NULL,
  `parameterValue` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `parameterUserProject` (`idUser`,`idProject`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=226 ;

--
-- Dumping data for table `[[dbprefix]]parameter`
--

INSERT INTO `[[dbprefix]]parameter` VALUES
(1, NULL, NULL, 'isManualProgress', 'YES'),
(2, NULL, NULL, 'startAM', '08:00'),
(3, NULL, NULL, 'endAM', '12:00'),
(4, NULL, NULL, 'startPM', '14:00'),
(5, NULL, NULL, 'endPM', '18:00'),
(6, NULL, NULL, 'dayTime', '8.00'),
(7, NULL, NULL, 'alertCheckTime', '60'),
(8, NULL, NULL, 'cronSleepTime', '10'),
(9, NULL, NULL, 'cronCheckDates', '30'),
(10, NULL, NULL, 'ldapDefaultProfile', '5'),
(11, NULL, NULL, 'ldapMsgOnUserCreation', 'NO'),
(12, NULL, NULL, 'csvSeparator', ';'),
(13, NULL, NULL, 'referenceFormatPrefix', '{PROJ}-{TYPE}-'),
(14, NULL, NULL, 'changeReferenceOnTypeChange', 'NO'),
(15, NULL, NULL, 'draftSeparator', '_draft'),
(16, NULL, NULL, 'billPrefix', 'BILL'),
(17, NULL, NULL, 'billSuffix', '_FR'),
(18, NULL, NULL, 'billNumSize', '5'),
(19, NULL, NULL, 'billNumStart', '10000'),
(20, NULL, NULL, 'displayResourcePlan', 'initials'),
(21, NULL, NULL, 'maxProjectsToDisplay', '25'),
(22, NULL, NULL, 'paramMailTitleStatus', '[${dbName}] ${item} #${id} moved to status ''${status}'' : "${name}"'),
(23, NULL, NULL, 'paramMailTitleResponsible', '[${dbName}] ${responsible} is now responsible of ${item} #${id} : "${name}"'),
(24, NULL, NULL, 'paramMailTitleNote', '[${dbName}] New note has been posted on ${item} #${id} : "${name}"'),
(25, NULL, NULL, 'paramMailTitleAttachment', '[${dbName}] New attachment has been posted on ${item} #${id} : "${name}"'),
(26, NULL, NULL, 'paramMailTitleNew', '[${dbName}] ${item} #${id} has been created : "${name}"'),
(27, NULL, NULL, 'cronCheckImport', '60'),
(28, NULL, NULL, 'cronImportDirectory', '../files/import'),
(29, NULL, NULL, 'cronImportLogDestination', 'file'),
(30, NULL, NULL, 'cronImportMailList', ''),
(31, NULL, NULL, 'cronDirectory', '../files/cron'),
(32, NULL, NULL, 'paramMailTitleDirect', '[${dbName}] message from ${sender} : ${item} #${id}'),
(33, NULL, NULL, 'maxItemsInTodayLists', '100'),
(34, NULL, NULL, 'msgClosedApplication', 'Application is closed. \nOnly admin user can connect. \nPlease come back later.'),
(35, NULL, NULL, 'paramMailBodyUser', 'You are welcome to ${dbName} at <a href="${url}">${url}</a>.<br/>Your login is <b>${login}</b>.<br/>Your password is initialized to <b>${password}</b><br/>You will have to change it on first connection.<br/><br/>In case of an issue contact your administrator at <b>${adminMail}</b>.'),
(36, NULL, NULL, 'paramMailTitleUser', '[${dbName}] message from ${sender} : Your account information'),
(37, NULL, NULL, 'paramMailTitleNoteChange', '[${dbName}] A note has been modified on ${item} #${id} : "${name}"'),
(38, NULL, NULL, 'paramMailTitleDescription', '[${dbName}] Description has been modified on ${item} #${id} : "${name}"'),
(39, NULL, NULL, 'paramMailTitleResult', '[${dbName}] Result has been modified on ${item} #${id} : "${name}'),
(40, NULL, NULL, 'paramMailTitleAssignment', '[${dbName}] New assignment has been added on ${item} #${id} : "${name}"'),
(41, NULL, NULL, 'paramMailTitleAssignmentChange', '[${dbName}] An assignment has been modified on ${item} #${id} : "${name}"'),
(42, NULL, NULL, 'paramMailTitleAnyChange', '[${dbName}] ${item} #${id} has been modified : "${name}"'),
(43, NULL, NULL, 'documentReferenceFormat', '{PROJ}-{TYPE}-{NUM}-{NAME}'),
(44, NULL, NULL, 'versionReferenceSuffix', '-{VERS}'),
(45, NULL, NULL, 'realWorkOnlyForResponsible', 'NO'),
(46, NULL, NULL, 'maxDaysToBookWork', '7'),
(47, NULL, NULL, 'cronCheckEmails', '-1'),
(48, NULL, NULL, 'paramTopIconSize', '16'),
(49, NULL, NULL, 'paramMailTitleApprover', '[${dbName}] Message from ${sender} : You need to approve an element'),
(50, NULL, NULL, 'paramMailBodyApprover', 'You are approver of element <a href="${url}" > ${item} #${id}</a> : "${name}".<br/>Please access <a href="${url}" >this element</a> and follow approval process.'),
(51, NULL, NULL, 'startPage', 'today.php'),
(52, NULL, NULL, 'setDoneOnNoLeftWork', 'YES'),
(53, NULL, NULL, 'messageAlertImputationResource', 'Your real work allocation is not complete up to ${DAY}'),
(54, NULL, NULL, 'messageAlertImputationProjectLeader', 'Some of your resources did not enter real work up to ${DAY}'),
(55, NULL, NULL, 'imputationAlertGenerationDay', '5'),
(56, NULL, NULL, 'imputationAlertGenerationHour', '17:00'),
(57, NULL, NULL, 'imputationAlertControlDay', 'current'),
(58, NULL, NULL, 'imputationAlertControlNumberOfDays', '7'),
(59, NULL, NULL, 'imputationAlertSendToResource', 'MAIL'),
(60, NULL, NULL, 'imputationAlertSendToProjectLeader', 'MAIL'),
(61, NULL, NULL, 'imputationAlertSendToTeamManager', 'MAIL'),
(62, NULL, NULL, 'OpenDaySunday', 'offDays'),
(63, NULL, NULL, 'OpenDaySaturday', 'offDays'),
(64, NULL, NULL, 'OpenDayFriday', 'openDays'),
(65, NULL, NULL, 'OpenDayThursday', 'openDays'),
(66, NULL, NULL, 'OpenDayWednesday', 'openDays'),
(67, NULL, NULL, 'OpenDayTuesday', 'openDays'),
(68, NULL, NULL, 'OpenDayMonday', 'openDays'),
(69, 1, NULL, 'planningHideColumnValidatedCost', '1'),
(70, 2, NULL, 'planningHideColumnValidatedCost', '1'),
(72, 1, NULL, 'planningHideColumnAssignedCost', '1'),
(73, 2, NULL, 'planningHideColumnAssignedCost', '1'),
(75, 1, NULL, 'planningHideColumnRealCost', '1'),
(76, 2, NULL, 'planningHideColumnRealCost', '1'),
(78, 1, NULL, 'planningHideColumnLeftCost', '1'),
(79, 2, NULL, 'planningHideColumnLeftCost', '1'),
(81, 1, NULL, 'planningHideColumnPlannedCost', '1'),
(82, 2, NULL, 'planningHideColumnPlannedCost', '1'),
(84, 1, NULL, 'planningHideColumnIdStatus', '1'),
(85, 2, NULL, 'planningHideColumnIdStatus', '1'),
(87, 1, NULL, 'planningHideColumnType', '1'),
(88, 2, NULL, 'planningHideColumnType', '1'),
(90, NULL, NULL, 'useOrganizationBudgetElement', 'NO'),
(91, NULL, NULL, 'paramMailTitleAffectationAdd', '[${dbName}] New allocation of resource ${responsible} has been created on Project ${project}'),
(92, NULL, NULL, 'paramMailTitleAffectationChange', '[${dbName}] Allocation of resource ${responsible} has been changed on Project ${project}'),
(93, NULL, NULL, 'paramMailTitleLinkAdd', '[${dbName}] New link #${id} has been created on ${item} #${id} '),
(94, NULL, NULL, 'paramMailTitleLinkDelete', '[${dbName}] Link #${id} has been removed from ${item} #${id}'),
(95, NULL, NULL, 'mailerTestTitle', '[${dbName}] test email sent at ${date}'),
(96, NULL, NULL, 'mailerTestMessage', 'This is a test email sent from ${dbName} at ${date}.<br/>Receiving this email means that counfiguration is correct.'),
(97, NULL, NULL, 'autoSetAssignmentByResponsible', 'YES'),
(98, NULL, NULL, 'notificationSystemActiv', 'NO'),
(99, NULL, NULL, 'cronCheckNotifications', '3600'),
(100, NULL, NULL, 'mailGroupPeriod', '60'),
(101, NULL, NULL, 'mailGroupActive', 'NO'),
(102, NULL, NULL, 'mailGroupDifferent', 'ALL'),
(103, NULL, NULL, 'ImputOfAmountProvider', 'HT'),
(104, NULL, NULL, 'ImputOfBillLineProvider', 'HT'),
(105, NULL, NULL, 'ImputOfAmountClient', 'HT'),
(106, NULL, NULL, 'ImputOfBillLineClient', 'HT'),
(107, NULL, NULL, 'authorizeActivityOnDeliveredProduct', 'YES'),
(108, NULL, NULL, 'paramMailBodyReport', '[${dbName}] Report ${report} - ${date}'),
(109, NULL, NULL, 'paramMailTitleReport', '[${dbName}] Report ${report} - ${date}'),
(110, NULL, NULL, 'leavesSystemActiv', 'NO'),
(111, NULL, NULL, 'leavesSystemAdmin', '1'),
(112, NULL, NULL, 'typeExportXLSorODS', 'Excel'),
(113, NULL, NULL, 'SAML_attributeUid', 'uid'),
(114, NULL, NULL, 'SAML_attributeMail', 'mail'),
(115, NULL, NULL, 'SAML_defaultProfile', '5'),
(116, NULL, NULL, 'SAML_ssoCommonName', 'SSO'),
(117, NULL, NULL, 'dataCloningCreationRequest', '5'),
(118, NULL, NULL, 'dataCloningPerDay', '5'),
(119, NULL, NULL, 'paramPasswordStrength', '1'),
(120, NULL, NULL, 'paramAttachmentNum', ''),
(121, NULL, NULL, 'paramScreen', 'left'),
(122, NULL, NULL, 'paramRightDiv', 'bottom'),
(123, NULL, NULL, 'contentPaneDetailDivHeight', '260'),
(124, NULL, NULL, 'contentPaneDetailDivWidth', '410'),
(125, NULL, NULL, 'contentPaneTopDetailDivHeight', '0'),
(126, NULL, NULL, 'contentPaneTopDetailDivWidth', '0'),
(127, NULL, NULL, 'paramLayoutObjectDetail', 'tab'),
(128, NULL, NULL, 'modeActiveStreamGlobal', 'false'),
(129, NULL, NULL, 'automaticFeedingOfTheReal', 'NO'),
(130, NULL, NULL, 'cronArchiveTime', '365'),
(131, NULL, NULL, 'cronArchiveCloseItems', 'YES'),
(132, NULL, NULL, 'cronArchivePlannedDate', '18:30'),
(133, NULL, NULL, 'paramAttachmentMaxSizeMail', '5242880'),
(134, NULL, NULL, 'paramAttachmentNumMail', 'M'),
(135, NULL, NULL, 'technicalProgress', 'NO'),
(136, NULL, NULL, 'ComplexitiesNumber', '3'),
(137, NULL, NULL, 'menuLeftDisplayMode', 'ICONTXT'),
(138, 1, NULL, 'newGui', '1'),
(139, 2, NULL, 'newGui', '1'),
(141, NULL, NULL, 'displaySubTask', 'YES'),
(142, NULL, NULL, 'activityOnRealTime', 'NO'),
(143, NULL, NULL, 'showDonePlannedWork', '1'),
(144, NULL, NULL, 'notStartBeforeValidatedStartDate', 'NO'),
(145, NULL, NULL, 'paramTryToHackObjectMail', 'Try to hack detected'),
(146, NULL, NULL, 'paramMailTitlePriorityChanged', '[${dbName}] Priority change on ticket #${id}'),
(147, NULL, NULL, 'paramMailTitleNewUserCreated', '[${dbName}] The user #${id} has been created'),
(148, NULL, NULL, 'limitDisplayPlanning', '2000'),
(149, NULL, NULL, 'coversListPlan', 'CLOSE'),
(150, NULL, NULL, 'projectSelectorLimitProjectLevel', '0'),
(151, NULL, NULL, 'afterMailTreatment', 'markAsReadMail'),
(152, NULL, NULL, 'refreshAuto', '0'),
(153, NULL, NULL, 'refreshAutoTimer', '30'),
(154, NULL, NULL, 'statusChangeAssignment', 'NO'),
(157, NULL, NULL, 'sizeAttachmentInputMails', '5'),
(158, NULL, NULL, 'skillsAlertResource', 'NO'),
(159, NULL, NULL, 'skillsAlertTeamManager', 'NO'),
(160, NULL, NULL, 'skillsAlertOrganismManager', 'NO'),
(161, NULL, NULL, 'skillsAlertLeadTimes', '0'),
(162, NULL, NULL, 'skillsAlertPeriodicity', 'onlyOnce'),
(163, NULL, NULL, 'consolidateValidated', 'IFSET'),
(164, 1, NULL, 'startPage', 'startGuide.php'),
(165, NULL, NULL, 'newGui', '1'),
(166, NULL, NULL, 'newGuiThemeColor', '545381'),
(167, NULL, NULL, 'newGuiThemeColorBis', 'e97b2c'),
(168, NULL, NULL, 'requiredOldPassword', 'YES'),
(169, NULL, NULL, 'oldPasswordDifferentNew', 'YES'),
(170, NULL, NULL, 'paramDbDisplayName', '[[site_name]]'),
(171, NULL, NULL, 'paramMailTitle', NULL),
(172, NULL, NULL, 'paramMailMessage', NULL),
(173, NULL, NULL, 'paramMailSender', NULL),
(174, NULL, NULL, 'paramMailReplyTo', NULL),
(175, NULL, NULL, 'paramAdminMail', '[[admin_email]]'),
(176, NULL, NULL, 'paramMailSmtpServer', 'localhost'),
(177, NULL, NULL, 'paramMailSmtpPort', '25'),
(178, NULL, NULL, 'paramMailSmtpUsername', NULL),
(179, NULL, NULL, 'paramMailSmtpPassword', NULL),
(180, NULL, NULL, 'paramMailSendmailPath', NULL),
(181, NULL, NULL, 'paramMailShowDetail', NULL),
(182, NULL, NULL, 'paramLdap_allow_login', 'false'),
(183, NULL, NULL, 'paramLdap_base_dn', 'dc=mydomain,dc=com'),
(184, NULL, NULL, 'paramLdap_host', 'localhost'),
(185, NULL, NULL, 'paramLdap_port', '389'),
(186, NULL, NULL, 'paramLdap_version', '3'),
(187, NULL, NULL, 'paramLdap_search_user', 'cn=Manager,dc=mydomain,dc=com'),
(188, NULL, NULL, 'paramLdap_search_pass', 'secret'),
(189, NULL, NULL, 'paramLdap_user_filter', 'uid=%USERNAME%'),
(190, NULL, NULL, 'paramDefaultPassword', NULL),
(191, NULL, NULL, 'paramPasswordMinLength', '5'),
(192, NULL, NULL, 'lockPassword', NULL),
(193, NULL, NULL, 'paramDefaultLocale', '[[language]]'),
(194, NULL, NULL, 'paramDefaultTimezone', 'America/New_York'),
(195, NULL, NULL, 'currency', '$'),
(196, NULL, NULL, 'currencyPosition', 'after'),
(197, NULL, NULL, 'paramFadeLoadingMode', NULL),
(198, NULL, NULL, 'paramRowPerPage', NULL),
(199, NULL, NULL, 'paramIconSize', NULL),
(200, NULL, NULL, 'defaultTheme', NULL),
(201, NULL, NULL, 'paramPathSeparator', '/'),
(202, NULL, NULL, 'paramAttachmentDirectory', '../files/attach/'),
(203, NULL, NULL, 'paramAttachmentMaxSize', '10485760'),
(204, NULL, NULL, 'paramReportTempDirectory', '../files/report/'),
(205, NULL, NULL, 'paramMemoryLimitForPDF', '512'),
(206, NULL, NULL, 'defaultBillCode', NULL),
(207, NULL, NULL, 'paramMailEol', 'CRLF'),
(208, NULL, NULL, 'documentRoot', '../files/documents/'),
(209, NULL, NULL, 'AttachmentMaxSizeMail', '2097152'),
(210, NULL, NULL, 'defaultProfile', '5'),
(211, NULL, NULL, 'ldapFormatUri', 'true'),
(212, NULL, NULL, 'billReferenceFormat', '{NUME}'),
(213, NULL, NULL, 'imputationAlertSendToOrganismManager', NULL),
(214, NULL, NULL, 'imputationAlertControlDayResource', NULL),
(215, NULL, NULL, 'imputationAlertControlNumberOfDaysResource', NULL),
(216, NULL, NULL, 'imputationAlertControlDayProjectLeader', NULL),
(217, NULL, NULL, 'imputationAlertControlNumberOfDaysProjectLeader', NULL),
(218, NULL, NULL, 'imputationAlertControlDayTeamManager', NULL),
(219, NULL, NULL, 'imputationAlertControlNumberOfDaysTeamManager', NULL),
(220, NULL, NULL, 'imputationAlertControlDayOrganismManager', NULL),
(221, NULL, NULL, 'imputationAlertControlNumberOfDaysOrganismManager', NULL),
(222, NULL, NULL, 'dbVersion', 'V12.3.2'),
(223, NULL, NULL, 'lastRevisionInstalled', '23695'),
(224, 1, NULL, 'currentLocale', '[[admin_language]]'),
(225, 1, NULL, 'lang', '[[admin_language]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment`
--

CREATE TABLE `[[dbprefix]]payment` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDate` date DEFAULT NULL,
  `idPaymentMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `idPaymentType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentAmount` decimal(11,2) unsigned DEFAULT NULL,
  `paymentFeeAmount` decimal(11,2) unsigned DEFAULT NULL,
  `paymentCreditAmount` decimal(11,2) unsigned DEFAULT NULL,
  `description` mediumtext,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `referenceBill` varchar(100) DEFAULT NULL,
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `billAmount` decimal(11,2) unsigned DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `billAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `paymentAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `paymentCreditAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `paymentFeeAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `paymentBill` (`idBill`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]paymentdatemode`
--

CREATE TABLE `[[dbprefix]]paymentdatemode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]paymentdatemode`
--

INSERT INTO `[[dbprefix]]paymentdatemode` VALUES
(1, 'paymentStartDateMode', 100, 0),
(2, 'paymentMedianDateMode', 200, 0),
(3, 'paymentEndDateMode', 300, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]paymentdelay`
--

CREATE TABLE `[[dbprefix]]paymentdelay` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `days` int(3) unsigned DEFAULT NULL COMMENT '3',
  `endOfMonth` int(1) DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]paymentdelay`
--

INSERT INTO `[[dbprefix]]paymentdelay` VALUES
(1, '15 days', 15, 0, 10, 0),
(2, '15 days end of month', 15, 1, 20, 0),
(3, '30 days', 30, 0, 30, 0),
(4, '30 days end of month', 30, 1, 40, 0),
(5, '45 days', 45, 0, 50, 0),
(6, '45 days end of month', 45, 1, 60, 0),
(7, '60 days', 60, 0, 70, 0),
(8, 'on order', 0, 0, 80, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]paymentmode`
--

CREATE TABLE `[[dbprefix]]paymentmode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]paymentmode`
--

INSERT INTO `[[dbprefix]]paymentmode` VALUES
(1, 'bank transfer', 10, 0),
(2, 'cheque', 20, 0),
(3, 'credit card', 30, 0),
(4, 'virtual payment terminal', 40, 0),
(5, 'paypal', 50, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]periodicity`
--

CREATE TABLE `[[dbprefix]]periodicity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `periodicityCode` varchar(10) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]periodicity`
--

INSERT INTO `[[dbprefix]]periodicity` VALUES
(1, 'periodicityDaily', 'DAY', 100, 0),
(2, 'periodicityWeekly', 'WEEK', 200, 0),
(3, 'periodicityMonthlyDay', 'MONTHDAY', 300, 0),
(4, 'periodicityMonthlyWeek', 'MONTHWEEK', 400, 0),
(5, 'periodicityYearly', 'YEAR', 500, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]periodicmeeting`
--

CREATE TABLE `[[dbprefix]]periodicmeeting` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMeetingType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `periodicityStartDate` date DEFAULT NULL,
  `periodicityEndDate` date DEFAULT NULL,
  `meetingStartTime` time DEFAULT NULL,
  `meetingEndTime` time DEFAULT NULL,
  `periodicityTimes` int(3) DEFAULT NULL COMMENT '3',
  `idPeriodicity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `periodicityDailyFrequency` int(2) DEFAULT NULL COMMENT '2',
  `periodicityWeeklyFrequency` int(2) DEFAULT NULL COMMENT '2',
  `periodicityWeeklyDay` int(1) DEFAULT NULL COMMENT '1',
  `periodicityMonthlyDayFrequency` int(2) DEFAULT NULL COMMENT '2',
  `periodicityMonthlyDayDay` int(2) DEFAULT NULL COMMENT '2',
  `periodicityMonthlyWeekFrequency` int(2) DEFAULT NULL COMMENT '2',
  `periodicityMonthlyWeekNumber` int(1) DEFAULT NULL COMMENT '1',
  `periodicityMonthlyWeekDay` int(2) DEFAULT NULL COMMENT '2',
  `periodicityYearlyDay` int(2) DEFAULT NULL COMMENT '2',
  `periodicityYearlyMonth` int(2) DEFAULT NULL COMMENT '2',
  `periodicityOpenDays` int(1) unsigned DEFAULT NULL COMMENT '1',
  `name` varchar(100) DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `attendees` varchar(4000) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `periodicmeetingProject` (`idProject`),
  KEY `periodicmeetingType` (`idMeetingType`),
  KEY `periodicmeetingUser` (`idUser`),
  KEY `periodicmeetingResource` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plannedwork`
--

CREATE TABLE `[[dbprefix]]plannedwork` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `work` decimal(8,5) unsigned DEFAULT NULL,
  `workDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `dailyCost` decimal(7,2) DEFAULT NULL,
  `cost` decimal(11,2) DEFAULT NULL,
  `idLeave` int(12) unsigned DEFAULT NULL COMMENT '12',
  `surbooked` int(1) DEFAULT '0' COMMENT '1',
  `surbookedWork` decimal(8,5) unsigned DEFAULT NULL,
  `isManual` int(1) unsigned DEFAULT '0' COMMENT '1',
  `costLocal` decimal(11,2) DEFAULT NULL,
  `dailyCostLocal` decimal(7,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `plannedworkDay` (`day`),
  KEY `plannedworkWeek` (`week`),
  KEY `plannedworkMonth` (`month`),
  KEY `plannedworkYear` (`year`),
  KEY `plannedworkRef` (`refType`,`refId`),
  KEY `plannedworkResource` (`idResource`),
  KEY `plannedworkAssignment` (`idAssignment`),
  KEY `plannedworkProject` (`idProject`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plannedworkbaseline`
--

CREATE TABLE `[[dbprefix]]plannedworkbaseline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idBaseline` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `work` decimal(8,5) unsigned DEFAULT NULL,
  `workDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `dailyCost` decimal(7,2) DEFAULT NULL,
  `cost` decimal(11,2) DEFAULT NULL,
  `isRealWork` int(1) unsigned DEFAULT '0' COMMENT '1',
  `surbooked` int(1) DEFAULT '0' COMMENT '1',
  `surbookedWork` decimal(8,5) unsigned DEFAULT NULL,
  `isManual` int(1) unsigned DEFAULT '0' COMMENT '1',
  `costLocal` decimal(11,2) DEFAULT NULL,
  `dailyCostLocal` decimal(7,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `plannedworkbaselineWorkDate` (`workDate`),
  KEY `plannedworkbaselineRef` (`refType`,`refId`),
  KEY `plannedworkbaselineBaseline` (`idBaseline`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plannedworkmanual`
--

CREATE TABLE `[[dbprefix]]plannedworkmanual` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `work` decimal(8,5) unsigned DEFAULT NULL,
  `workDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `dailyCost` decimal(7,2) DEFAULT NULL,
  `cost` decimal(11,2) DEFAULT NULL,
  `period` varchar(2) DEFAULT NULL,
  `inputUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `inputDateTime` datetime DEFAULT NULL,
  `idInterventionMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWork` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPlannedWork` int(12) unsigned DEFAULT NULL COMMENT '12',
  `costLocal` decimal(11,2) DEFAULT NULL,
  `dailyCostLocal` decimal(7,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `plannedworkmanualDay` (`day`),
  KEY `plannedworkmanualWeek` (`week`),
  KEY `plannedworkmanualMonth` (`month`),
  KEY `plannedworkmanualYear` (`year`),
  KEY `plannedworkmanualRef` (`refType`,`refId`),
  KEY `plannedworkmanualResource` (`idResource`),
  KEY `plannedworkmanualAssignment` (`idAssignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]planningelement`
--

CREATE TABLE `[[dbprefix]]planningelement` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refName` varchar(100) DEFAULT NULL,
  `initialStartDate` date DEFAULT NULL,
  `validatedStartDate` date DEFAULT NULL,
  `plannedStartDate` date DEFAULT NULL,
  `realStartDate` date DEFAULT NULL,
  `initialEndDate` date DEFAULT NULL,
  `validatedEndDate` date DEFAULT NULL,
  `plannedEndDate` date DEFAULT NULL,
  `realEndDate` date DEFAULT NULL,
  `initialDuration` int(5) DEFAULT NULL COMMENT '5',
  `validatedDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  `plannedDuration` int(5) DEFAULT NULL COMMENT '5',
  `realDuration` int(5) DEFAULT NULL COMMENT '5',
  `initialWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `validatedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `plannedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `realWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `wbs` varchar(100) DEFAULT NULL,
  `wbsSortable` varchar(600) DEFAULT NULL,
  `topId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `topRefType` varchar(100) DEFAULT NULL,
  `topRefId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `priority` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT NULL COMMENT '1',
  `elementary` int(1) unsigned DEFAULT NULL COMMENT '1',
  `leftWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `assignedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `dependencyLevel` decimal(3,0) unsigned DEFAULT NULL,
  `idPlanningMode` int(12) DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `initialCost` decimal(11,2) DEFAULT NULL,
  `validatedCost` decimal(11,2) DEFAULT NULL,
  `assignedCost` decimal(11,2) DEFAULT NULL,
  `realCost` decimal(11,2) DEFAULT NULL,
  `leftCost` decimal(11,2) DEFAULT NULL,
  `plannedCost` decimal(11,2) DEFAULT NULL,
  `idBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `progress` int(3) unsigned DEFAULT '0' COMMENT '3',
  `expectedProgress` int(6) unsigned DEFAULT '0' COMMENT '6',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `validatedCalculated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `workElementEstimatedWork` decimal(9,5) unsigned DEFAULT NULL,
  `workElementRealWork` decimal(9,5) unsigned DEFAULT NULL,
  `workElementLeftWork` decimal(9,5) unsigned DEFAULT NULL,
  `workElementCount` decimal(5,0) unsigned DEFAULT NULL,
  `expenseAssignedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expensePlannedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expenseRealAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expenseLeftAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expenseValidatedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `totalAssignedCost` decimal(12,2) DEFAULT NULL,
  `totalPlannedCost` decimal(12,2) DEFAULT NULL,
  `totalRealCost` decimal(12,2) DEFAULT NULL,
  `totalLeftCost` decimal(12,2) DEFAULT NULL,
  `totalValidatedCost` decimal(12,2) DEFAULT NULL,
  `notPlannedWork` decimal(12,5) unsigned DEFAULT '0.00000',
  `marginWork` decimal(14,5) DEFAULT NULL,
  `marginCost` decimal(14,5) DEFAULT NULL,
  `marginWorkPct` int(6) DEFAULT NULL COMMENT '6',
  `marginCostPct` int(6) DEFAULT NULL COMMENT '6',
  `plannedStartFraction` decimal(6,5) DEFAULT '0.00000',
  `plannedEndFraction` decimal(6,5) DEFAULT '1.00000',
  `validatedStartFraction` decimal(6,5) DEFAULT '0.00000',
  `validatedEndFraction` decimal(6,5) DEFAULT '1.00000',
  `reserveAmount` decimal(12,2) DEFAULT NULL,
  `validatedExpenseCalculated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `needReplan` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `organizationInherited` int(1) unsigned DEFAULT NULL COMMENT '1',
  `organizationElementary` int(1) unsigned DEFAULT NULL COMMENT '1',
  `latestStartDate` date DEFAULT NULL,
  `latestEndDate` date DEFAULT NULL,
  `isOnCriticalPath` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isManualProgress` int(1) unsigned DEFAULT '0' COMMENT '1',
  `surbooked` int(1) DEFAULT '0' COMMENT '1',
  `indivisibility` int(1) unsigned DEFAULT '0' COMMENT '1',
  `minimumThreshold` decimal(7,4) unsigned DEFAULT NULL,
  `fixPlanning` int(1) unsigned DEFAULT '0' COMMENT '1',
  `unitToDeliver` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitToRealise` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitRealised` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitLeft` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitProgress` decimal(8,2) DEFAULT NULL,
  `idProgressMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `unitWeight` decimal(8,2) DEFAULT NULL,
  `idWeightMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `color` varchar(7) DEFAULT NULL,
  `revenue` decimal(11,2) unsigned DEFAULT NULL,
  `commandSum` decimal(11,2) unsigned DEFAULT NULL,
  `billSum` decimal(11,2) unsigned DEFAULT NULL,
  `idRevenueMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paused` int(1) unsigned DEFAULT '0' COMMENT '1',
  `hasWorkUnit` int(1) unsigned DEFAULT '0' COMMENT '1',
  `automaticAssignment` int(1) unsigned DEFAULT '0' COMMENT '1',
  `inheritedEndDate` date DEFAULT NULL,
  `inheritedStartDate` date DEFAULT NULL,
  `assignedCostLocal` decimal(11,2) DEFAULT NULL,
  `expenseAssignedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expenseLeftAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expensePlannedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expenseRealAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expenseValidatedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `initialCostLocal` decimal(11,2) DEFAULT NULL,
  `leftCostLocal` decimal(11,2) DEFAULT NULL,
  `marginCostLocal` decimal(14,5) DEFAULT NULL,
  `plannedCostLocal` decimal(11,2) DEFAULT NULL,
  `realCostLocal` decimal(11,2) DEFAULT NULL,
  `reserveAmountLocal` decimal(12,2) DEFAULT NULL,
  `totalAssignedCostLocal` decimal(12,2) DEFAULT NULL,
  `totalLeftCostLocal` decimal(12,2) DEFAULT NULL,
  `totalPlannedCostLocal` decimal(12,2) DEFAULT NULL,
  `totalRealCostLocal` decimal(12,2) DEFAULT NULL,
  `totalValidatedCostLocal` decimal(12,2) DEFAULT NULL,
  `validatedCostLocal` decimal(11,2) DEFAULT NULL,
  `revenueLocal` decimal(11,2) DEFAULT NULL,
  `commandSumLocal` decimal(11,2) DEFAULT NULL,
  `billSumLocal` decimal(11,2) DEFAULT NULL,
  `quickplanStartDate` date DEFAULT NULL,
  `quickplanEndDate` date DEFAULT NULL,
  `quickplanUpdated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `assignedDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  PRIMARY KEY (`id`),
  UNIQUE KEY `planningelementReference` (`refType`,`refId`),
  KEY `planningelementTopId` (`topId`),
  KEY `planningelementTopRef` (`topRefType`,`topRefId`),
  KEY `planningelementProject` (`idProject`),
  KEY `planningelementWbsSortable` (`wbsSortable`(180)),
  KEY `planningElementDependencyLevel` (`dependencyLevel`),
  KEY `planningelementPlanningMode` (`idPlanningMode`),
  KEY `planningelementBill` (`idBill`),
  KEY `planningelementOrganization` (`idOrganization`),
  KEY `planningelementFixplanning` (`fixPlanning`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]planningelementbaseline`
--

CREATE TABLE `[[dbprefix]]planningelementbaseline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idBaseline` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) NOT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refName` varchar(100) DEFAULT NULL,
  `initialStartDate` date DEFAULT NULL,
  `validatedStartDate` date DEFAULT NULL,
  `plannedStartDate` date DEFAULT NULL,
  `realStartDate` date DEFAULT NULL,
  `initialEndDate` date DEFAULT NULL,
  `validatedEndDate` date DEFAULT NULL,
  `plannedEndDate` date DEFAULT NULL,
  `realEndDate` date DEFAULT NULL,
  `initialDuration` int(5) DEFAULT NULL COMMENT '5',
  `validatedDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  `plannedDuration` int(5) DEFAULT NULL COMMENT '5',
  `realDuration` int(5) DEFAULT NULL COMMENT '5',
  `initialWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `validatedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `plannedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `realWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `wbs` varchar(100) DEFAULT NULL,
  `wbsSortable` varchar(600) DEFAULT NULL,
  `topId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `topRefType` varchar(100) DEFAULT NULL,
  `topRefId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `priority` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT NULL COMMENT '1',
  `elementary` int(1) unsigned DEFAULT NULL COMMENT '1',
  `leftWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `assignedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `dependencyLevel` decimal(3,0) unsigned DEFAULT NULL,
  `idPlanningMode` int(12) DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `initialCost` decimal(11,2) DEFAULT NULL,
  `validatedCost` decimal(11,2) DEFAULT NULL,
  `assignedCost` decimal(11,2) DEFAULT NULL,
  `realCost` decimal(11,2) DEFAULT NULL,
  `leftCost` decimal(11,2) DEFAULT NULL,
  `plannedCost` decimal(11,2) DEFAULT NULL,
  `idBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `progress` int(3) unsigned DEFAULT '0' COMMENT '3',
  `expectedProgress` int(6) unsigned DEFAULT '0' COMMENT '6',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `validatedCalculated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `workElementEstimatedWork` decimal(9,5) unsigned DEFAULT NULL,
  `workElementRealWork` decimal(9,5) unsigned DEFAULT NULL,
  `workElementLeftWork` decimal(9,5) unsigned DEFAULT NULL,
  `workElementCount` decimal(5,0) unsigned DEFAULT NULL,
  `expenseAssignedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expensePlannedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expenseRealAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expenseLeftAmount` decimal(11,2) unsigned DEFAULT NULL,
  `expenseValidatedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `totalAssignedCost` decimal(11,2) unsigned DEFAULT NULL,
  `totalPlannedCost` decimal(11,2) unsigned DEFAULT NULL,
  `totalRealCost` decimal(11,2) unsigned DEFAULT NULL,
  `totalLeftCost` decimal(11,2) unsigned DEFAULT NULL,
  `totalValidatedCost` decimal(11,2) unsigned DEFAULT NULL,
  `notPlannedWork` decimal(12,5) unsigned DEFAULT '0.00000',
  `marginWork` decimal(14,5) DEFAULT NULL,
  `marginCost` decimal(14,5) DEFAULT NULL,
  `marginWorkPct` int(6) DEFAULT NULL COMMENT '6',
  `marginCostPct` int(6) DEFAULT NULL COMMENT '6',
  `plannedStartFraction` decimal(6,5) DEFAULT '0.00000',
  `plannedEndFraction` decimal(6,5) DEFAULT '1.00000',
  `validatedStartFraction` decimal(6,5) DEFAULT '0.00000',
  `validatedEndFraction` decimal(6,5) DEFAULT '1.00000',
  `reserveAmount` decimal(11,2) unsigned DEFAULT '0.00',
  `validatedExpenseCalculated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `needReplan` int(1) unsigned DEFAULT '0' COMMENT '1',
  `latestStartDate` date DEFAULT NULL,
  `latestEndDate` date DEFAULT NULL,
  `isOnCriticalPath` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isGlobal` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isManualProgress` int(1) unsigned DEFAULT '0' COMMENT '1',
  `surbooked` int(1) DEFAULT '0' COMMENT '1',
  `indivisibility` int(1) unsigned DEFAULT '0' COMMENT '1',
  `minimumThreshold` decimal(7,4) unsigned DEFAULT NULL,
  `fixPlanning` int(1) unsigned DEFAULT '0' COMMENT '1',
  `unitToDeliver` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitToRealise` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitRealised` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitLeft` int(6) unsigned DEFAULT NULL COMMENT '6',
  `unitProgress` decimal(8,2) DEFAULT NULL,
  `idProgressMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `unitWeight` decimal(8,2) DEFAULT NULL,
  `idWeightMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `color` varchar(7) DEFAULT NULL,
  `revenue` decimal(11,2) unsigned DEFAULT NULL,
  `commandSum` decimal(11,2) unsigned DEFAULT NULL,
  `billSum` decimal(11,2) unsigned DEFAULT NULL,
  `idRevenueMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paused` int(1) unsigned DEFAULT '0' COMMENT '1',
  `hasWorkUnit` int(1) unsigned DEFAULT '0' COMMENT '1',
  `automaticAssignment` int(1) unsigned DEFAULT '0' COMMENT '1',
  `inheritedEndDate` date DEFAULT NULL,
  `inheritedStartDate` date DEFAULT NULL,
  `assignedCostLocal` decimal(11,2) DEFAULT NULL,
  `expenseAssignedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expenseLeftAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expensePlannedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expenseRealAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `expenseValidatedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `initialCostLocal` decimal(11,2) DEFAULT NULL,
  `leftCostLocal` decimal(11,2) DEFAULT NULL,
  `marginCostLocal` decimal(14,5) DEFAULT NULL,
  `plannedCostLocal` decimal(11,2) DEFAULT NULL,
  `realCostLocal` decimal(11,2) DEFAULT NULL,
  `reserveAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalAssignedCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalLeftCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalPlannedCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalRealCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalValidatedCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `validatedCostLocal` decimal(11,2) DEFAULT NULL,
  `revenueLocal` decimal(11,2) DEFAULT NULL,
  `quickplanStartDate` date DEFAULT NULL,
  `quickplanEndDate` date DEFAULT NULL,
  `assignedDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  `quickplanUpdated` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `planningelementbaselineBaseline` (`idBaseline`),
  KEY `planningelementbaselineRef` (`refType`,`refId`),
  KEY `planningelementbaselineProject` (`idProject`),
  KEY `planningelementbaselineWbsSortable` (`wbsSortable`(180))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]planningelementextension`
--

CREATE TABLE `[[dbprefix]]planningelementextension` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `topId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `topRefType` varchar(100) DEFAULT NULL,
  `topRefId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `wbs` varchar(100) DEFAULT NULL,
  `wbsSortable` varchar(600) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `planningelementextensionReference` (`refType`,`refId`),
  KEY `planningelementextensionTopReference` (`topRefType`,`topRefId`),
  KEY `planningelementextensionWbsSortable` (`wbsSortable`(180))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]planninghistory`
--

CREATE TABLE `[[dbprefix]]planninghistory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `date` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `projects` mediumtext,
  `startDate` datetime DEFAULT NULL,
  `startTime` varchar(100) DEFAULT NULL,
  `endTime` varchar(100) DEFAULT NULL,
  `result` varchar(100) DEFAULT NULL,
  `resultDescription` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]planningmode`
--

CREATE TABLE `[[dbprefix]]planningmode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(5) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `mandatoryStartDate` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mandatoryEndDate` int(1) unsigned DEFAULT '0' COMMENT '1',
  `applyTo` varchar(20) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mandatoryDuration` int(1) unsigned DEFAULT '0' COMMENT '1',
  `defaultDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  PRIMARY KEY (`id`),
  KEY `planningmodeApplyTo` (`applyTo`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `[[dbprefix]]planningmode`
--

INSERT INTO `[[dbprefix]]planningmode` VALUES
(1, 'PlanningModeASAP', 'ASAP', 100, 0, 0, 'Activity', 0, 0, NULL),
(2, 'PlanningModeREGUL', 'REGUL', 700, 1, 1, 'Activity', 0, 0, NULL),
(3, 'PlanningModeFULL', 'FULL', 710, 1, 1, 'Activity', 0, 0, NULL),
(4, 'PlanningModeALAP', 'ALAP', 500, 0, 1, 'Activity', 0, 0, NULL),
(5, 'PlanningModeFLOAT', 'FLOAT', 100, 0, 0, 'Milestone', 0, 0, NULL),
(6, 'PlanningModeFIXED', 'FIXED', 200, 0, 1, 'Milestone', 0, 0, NULL),
(7, 'PlanningModeHALF', 'HALF', 720, 1, 1, 'Activity', 0, 0, NULL),
(8, 'PlanningModeFDUR', 'FDUR', 300, 0, 0, 'Activity', 0, 1, 1),
(9, 'PlanningModeASAP', 'ASAP', 100, 0, 0, 'TestSession', 0, 0, NULL),
(10, 'PlanningModeREGUL', 'REGUL', 700, 1, 1, 'TestSession', 0, 0, NULL),
(11, 'PlanningModeFULL', 'FULL', 710, 1, 1, 'TestSession', 0, 0, NULL),
(12, 'PlanningModeALAP', 'ALAP', 500, 0, 1, 'TestSession', 0, 0, NULL),
(13, 'PlanningModeHALF', 'HALF', 720, 1, 1, 'TestSession', 0, 0, NULL),
(14, 'PlanningModeFDUR', 'FDUR', 300, 0, 0, 'TestSession', 0, 1, 1),
(16, 'PlanningModeFIXED', 'FIXED', 100, 1, 0, 'Meeting', 0, 0, NULL),
(17, 'PlanningModeGROUP', 'GROUP', 200, 0, 0, 'Activity', 0, 0, NULL),
(18, 'PlanningModeGROUP', 'GROUP', 200, 0, 0, 'TestSession', 0, 0, NULL),
(19, 'PlanningModeSTART', 'START', 400, 1, 0, 'Activity', 0, 0, NULL),
(20, 'PlanningModeQUART', 'QUART', 730, 1, 1, 'Activity', 0, 0, NULL),
(21, 'PlanningModeSTART', 'START', 400, 1, 0, 'TestSession', 0, 0, NULL),
(22, 'PlanningModeRECW', 'RECW', 800, 0, 0, 'Activity', 0, 0, NULL),
(23, 'PlanningModeManual', 'MAN', 900, 0, 0, 'Activity', 0, 0, NULL),
(24, 'PlanningModeFIXED', 'FIXED', 100, 1, 0, 'PokerSession', 0, 0, NULL),
(25, 'PlanningModeSTARTREQUIRED', 'STARR', 420, 1, 0, 'Activity', 0, 0, NULL),
(26, 'PlanningModeSTARTREQUIRED', 'STARR', 420, 1, 0, 'TestSession', 0, 0, NULL),
(27, 'PlanningModeDDUR', 'DDUR', 320, 0, 0, 'Activity', 0, 1, 1),
(28, 'PlanningModeDDUR', 'DDUR', 320, 0, 0, 'TestSession', 0, 1, 1),
(29, 'PlanningModeCDUR', 'CDUR', 340, 0, 0, 'Activity', 1, 1, 1),
(30, 'PlanningModeCDUR', 'CDUR', 340, 0, 0, 'TestSession', 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugin`
--

CREATE TABLE `[[dbprefix]]plugin` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext,
  `name` varchar(100) DEFAULT NULL,
  `zipFile` varchar(4000) DEFAULT NULL,
  `deploymentDate` date DEFAULT NULL,
  `isDeployed` int(1) unsigned DEFAULT '0' COMMENT '1',
  `deploymentVersion` varchar(100) DEFAULT NULL,
  `compatibilityVersion` varchar(100) DEFAULT NULL,
  `pluginVersion` varchar(100) DEFAULT NULL,
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `comment` varchar(4000) DEFAULT NULL,
  `uniqueCode` varchar(100) DEFAULT NULL,
  `licenceKey` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pluginName` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pluginbutton`
--

CREATE TABLE `[[dbprefix]]pluginbutton` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idPlugin` int(12) unsigned DEFAULT NULL COMMENT '12',
  `buttonName` varchar(100) DEFAULT NULL,
  `className` varchar(100) DEFAULT NULL,
  `scriptJS` varchar(255) DEFAULT NULL,
  `scriptPHP` varchar(255) DEFAULT NULL,
  `iconClass` varchar(100) DEFAULT NULL,
  `scope` varchar(10) DEFAULT NULL,
  `sortOrder` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `pluginbuttonplugin` (`idPlugin`),
  KEY `pluginbuttonclassname` (`className`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugintriggeredevent`
--

CREATE TABLE `[[dbprefix]]plugintriggeredevent` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idPlugin` int(12) unsigned DEFAULT NULL COMMENT '12',
  `event` varchar(100) DEFAULT NULL,
  `className` varchar(100) DEFAULT NULL,
  `script` varchar(255) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `plugintriggeredeventPlugin` (`idPlugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pokercomplexity`
--

CREATE TABLE `[[dbprefix]]pokercomplexity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `itemWork` decimal(9,5) unsigned DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` datetime DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]pokercomplexity`
--

INSERT INTO `[[dbprefix]]pokercomplexity` VALUES
(1, '1', 1, '0.50000', 10, 0, NULL, '#a2a2c3'),
(2, '2', 2, '1.00000', 20, 0, NULL, '#a2a2c3'),
(3, '3', 3, '1.50000', 30, 0, NULL, '#a2a2c3'),
(4, '5', 5, '2.50000', 40, 0, NULL, '#a2a2c3'),
(5, '8', 8, '4.00000', 50, 0, NULL, '#a2a2c3'),
(6, '13', 13, '6.50000', 60, 0, NULL, '#a2a2c3'),
(7, '20', 20, '10.00000', 70, 0, NULL, '#a2a2c3'),
(8, '40', 40, '20.00000', 80, 0, NULL, '#a2a2c3'),
(9, '60', 60, '30.00000', 90, 0, NULL, '#a2a2c3'),
(10, '100', 100, '50.00000', 100, 0, NULL, '#a2a2c3'),
(11, '?', NULL, '0.00000', 110, 0, NULL, '#f1a874');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pokeritem`
--

CREATE TABLE `[[dbprefix]]pokeritem` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPokerSession` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value` varchar(100) DEFAULT NULL,
  `work` decimal(9,5) unsigned DEFAULT NULL,
  `isOpen` int(1) unsigned DEFAULT '0' COMMENT '1',
  `comment` varchar(4000) DEFAULT NULL,
  `flipped` int(1) DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pokerresource`
--

CREATE TABLE `[[dbprefix]]pokerresource` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idPokerSession` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pokersession`
--

CREATE TABLE `[[dbprefix]]pokersession` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `pokerSessionDate` date DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPokerSessionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `attendees` varchar(4000) DEFAULT NULL,
  `pokerSessionStartTime` time DEFAULT NULL,
  `pokerSessionEndTime` time DEFAULT NULL,
  `pokerSessionStartDateTime` datetime DEFAULT NULL,
  `pokerSessionEndDateTime` datetime DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `description` mediumtext,
  `result` mediumtext,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pokervote`
--

CREATE TABLE `[[dbprefix]]pokervote` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idPokerItem` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPokerSession` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]positionprospect`
--

CREATE TABLE `[[dbprefix]]positionprospect` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(12) unsigned NOT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]positionprospect`
--

INSERT INTO `[[dbprefix]]positionprospect` VALUES
(1, 1, 'CEO / Director', 10, 0),
(2, 1, 'CTO / IT Director', 20, 0),
(3, 1, 'Project Manager', 30, 0),
(4, 1, 'Project Leader', 40, 0),
(5, 1, 'Other', 50, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]predefinedaction`
--

CREATE TABLE `[[dbprefix]]predefinedaction` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idActionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialDueDateDelay` int(3) unsigned DEFAULT NULL COMMENT '3',
  `actualDueDateDelay` int(3) unsigned DEFAULT NULL COMMENT '3',
  `result` mediumtext,
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idEfficiency` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isPrivate` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]predefinedsituation`
--

CREATE TABLE `[[dbprefix]]predefinedsituation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idSituationable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `situation` varchar(100) DEFAULT NULL,
  `comment` mediumtext,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]predefinedtext`
--

CREATE TABLE `[[dbprefix]]predefinedtext` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `idTextable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `text` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]priority`
--

CREATE TABLE `[[dbprefix]]priority` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]priority`
--

INSERT INTO `[[dbprefix]]priority` VALUES
(1, 'Low priority', 1, '#32cd32', 40, 0),
(2, 'Medium priority', 2, '#ffd700', 30, 0),
(3, 'High priority', 4, '#ff0000', 20, 0),
(4, 'Critical priority', 8, '#000000', 10, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]privacy`
--

CREATE TABLE `[[dbprefix]]privacy` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]privacy`
--

INSERT INTO `[[dbprefix]]privacy` VALUES
(1, 'public', '#003399', 100, 0),
(2, 'team', '#99FF99', 200, 0),
(3, 'private', '#FF9966', 300, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]product`
--

CREATE TABLE `[[dbprefix]]product` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `designation` varchar(100) DEFAULT NULL,
  `scope` varchar(100) DEFAULT NULL,
  `idProductType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponentType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `productClient` (`idClient`),
  KEY `productContact` (`idContact`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productasset`
--

CREATE TABLE `[[dbprefix]]productasset` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idAsset` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(100) DEFAULT NULL,
  `creationDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `productassetAsset` (`idAsset`),
  KEY `productassetProduct` (`idProductVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productcontext`
--

CREATE TABLE `[[dbprefix]]productcontext` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContext` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date NOT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `scope` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productlanguage`
--

CREATE TABLE `[[dbprefix]]productlanguage` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLanguage` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date NOT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `scope` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productproject`
--

CREATE TABLE `[[dbprefix]]productproject` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `productprojectProject` (`idProject`),
  KEY `productprojectProduct` (`idProduct`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productstructure`
--

CREATE TABLE `[[dbprefix]]productstructure` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(4000) DEFAULT NULL,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `ProductStructureProduct` (`idProduct`),
  KEY `ProductStructureComponent` (`idComponent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productversionstructure`
--

CREATE TABLE `[[dbprefix]]productversionstructure` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(4000) DEFAULT NULL,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `ProductVersionStructureProduct` (`idProductVersion`),
  KEY `ProductVersionStructureComponent` (`idComponentVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]profile`
--

CREATE TABLE `[[dbprefix]]profile` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `profileCode` varchar(3) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]profile`
--

INSERT INTO `[[dbprefix]]profile` VALUES
(1, 'profileAdministrator', 'Has a visibility over all the projects', 'ADM', 100, 0),
(2, 'profileSupervisor', 'Has a visibility over all the projects', 'SUP', 200, 0),
(3, 'profileProjectLeader', 'Leads his owns project', 'PL', 310, 0),
(4, 'profileTeamMember', 'Works for a project', 'TM', 320, 0),
(5, 'profileGuest', 'Has limited visibility to a project', 'G', 500, 0),
(6, 'profileExternalProjectLeader', NULL, 'EPL', 410, 0),
(7, 'profileExternalTeamMember', NULL, 'ETM', 420, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]progressmode`
--

CREATE TABLE `[[dbprefix]]progressmode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]progressmode`
--

INSERT INTO `[[dbprefix]]progressmode` VALUES
(1, 'calculated', 100, 0),
(2, 'manual', 200, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project`
--

CREATE TABLE `[[dbprefix]]project` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` mediumtext,
  `idClient` int(12) DEFAULT NULL COMMENT '12',
  `projectCode` varchar(25) DEFAULT NULL,
  `contractCode` varchar(25) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sortOrder` varchar(600) CHARACTER SET ascii DEFAULT NULL,
  `idProjectType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `codeType` varchar(10) DEFAULT 'OPE',
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDelay` int(3) DEFAULT NULL COMMENT '3',
  `longitude` decimal(15,12) DEFAULT NULL,
  `latitude` decimal(15,12) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idHealth` int(12) unsigned DEFAULT NULL COMMENT '12',
  `fixPlanning` int(1) unsigned DEFAULT '0' COMMENT '1',
  `clientCode` varchar(25) DEFAULT NULL,
  `idOverallProgress` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idQuality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTrend` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSponsor` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `objectives` mediumtext,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isUnderConstruction` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lastUpdateDateTime` datetime DEFAULT NULL,
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `organizationInherited` int(1) unsigned DEFAULT NULL COMMENT '1',
  `organizationElementary` int(1) unsigned DEFAULT NULL COMMENT '1',
  `idCategory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `excludeFromGlobalPlanning` int(1) unsigned DEFAULT '0' COMMENT '1',
  `fixPerimeter` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isLeaveMngProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `commandOnValidWork` int(1) unsigned DEFAULT '0' COMMENT '1',
  `allowReduction` int(1) unsigned DEFAULT '0' COMMENT '1',
  `paused` int(1) unsigned DEFAULT '0' COMMENT '1',
  `startAM` time DEFAULT NULL,
  `endAM` time DEFAULT NULL,
  `startPM` time DEFAULT NULL,
  `endPM` time DEFAULT NULL,
  `idCatalogUO` int(12) unsigned DEFAULT NULL COMMENT '12',
  `strength` mediumtext,
  `weakness` mediumtext,
  `opportunity` mediumtext,
  `threats` mediumtext,
  `strategicvalue` int(10) unsigned DEFAULT NULL COMMENT '10',
  `idRiskLevel` int(12) unsigned DEFAULT NULL COMMENT '12',
  `benefitValue` int(10) DEFAULT NULL COMMENT '10',
  `idCalendarDefinition` int(12) unsigned DEFAULT NULL COMMENT '12',
  `tags` varchar(1000) DEFAULT NULL,
  `localCurrency` varchar(10) DEFAULT NULL,
  `localCurrencyPosition` varchar(10) DEFAULT NULL,
  `localToGlobalConversion` decimal(14,5) DEFAULT '0.00000',
  `globalToLocalConversion` decimal(14,5) DEFAULT '0.00000',
  `inheritedCurrency` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `projectProject` (`idProject`),
  KEY `projectClient` (`idClient`),
  KEY `projectUser` (`idUser`),
  KEY `projectContact` (`idContact`),
  KEY `projectRecipient` (`idRecipient`),
  KEY `projectStatus` (`idStatus`),
  KEY `projectOrganization` (`idOrganization`),
  KEY `projectSortOrder` (`sortOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projecthistory`
--

CREATE TABLE `[[dbprefix]]projecthistory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `day` varchar(10) DEFAULT NULL,
  `realWork` decimal(14,5) unsigned DEFAULT NULL,
  `leftWork` decimal(14,5) unsigned DEFAULT NULL,
  `realCost` decimal(11,2) unsigned DEFAULT NULL,
  `leftCost` decimal(11,2) unsigned DEFAULT NULL,
  `totalRealCost` decimal(11,2) unsigned DEFAULT NULL,
  `totalLeftCost` decimal(11,2) unsigned DEFAULT NULL,
  `validatedWork` decimal(9,5) unsigned DEFAULT NULL,
  `validatedCost` decimal(11,2) unsigned DEFAULT NULL,
  `leftCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `realCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalLeftCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalRealCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `validatedCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projecthistoryProjectDay` (`idProject`,`day`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projectsituation`
--

CREATE TABLE `[[dbprefix]]projectsituation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `situationNameExpense` varchar(100) DEFAULT NULL,
  `refTypeExpense` varchar(100) DEFAULT NULL,
  `refIdExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `situationDateExpense` datetime DEFAULT NULL,
  `idResourceExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `situationNameIncome` varchar(100) DEFAULT NULL,
  `refTypeIncome` varchar(100) DEFAULT NULL,
  `refIdIncome` int(12) unsigned DEFAULT NULL COMMENT '12',
  `situationDateIncome` datetime DEFAULT NULL,
  `idResourceIncome` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]prospect`
--

CREATE TABLE `[[dbprefix]]prospect` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `prospectNameContact` varchar(100) DEFAULT NULL,
  `prospectNameCompany` varchar(100) DEFAULT NULL,
  `idProspectType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProspectOrigin` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDomainProspect` int(12) unsigned DEFAULT NULL COMMENT '12',
  `prospectFunction` varchar(100) DEFAULT NULL,
  `idPositionProspect` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idDecisionMakerProspect` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `email` varchar(100) DEFAULT NULL,
  `designation` varchar(100) DEFAULT NULL,
  `street` varchar(100) DEFAULT NULL,
  `complement` varchar(100) DEFAULT NULL,
  `zip` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `mobile` varchar(100) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `networkLink` varchar(100) DEFAULT NULL,
  `idStatus` int(12) unsigned NOT NULL COMMENT '12',
  `lastEventDatetime` datetime DEFAULT NULL,
  `toBeRecontacted` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]prospectevent`
--

CREATE TABLE `[[dbprefix]]prospectevent` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProspect` int(12) unsigned DEFAULT NULL COMMENT '12',
  `eventDateTime` datetime DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idProspectEventType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]prospectorigin`
--

CREATE TABLE `[[dbprefix]]prospectorigin` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(5) unsigned DEFAULT NULL COMMENT '5',
  `date` datetime DEFAULT NULL,
  `idProspectType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]provider`
--

CREATE TABLE `[[dbprefix]]provider` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `idProviderType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `providerCode` varchar(25) DEFAULT NULL,
  `idPaymentDelay` int(12) unsigned DEFAULT NULL COMMENT '12',
  `numTax` varchar(100) DEFAULT NULL,
  `tax` decimal(5,2) DEFAULT NULL,
  `designation` varchar(100) DEFAULT NULL,
  `street` varchar(100) DEFAULT NULL,
  `complement` varchar(100) DEFAULT NULL,
  `zip` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `providerProviderType` (`idProviderType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]providerbill`
--

CREATE TABLE `[[dbprefix]]providerbill` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `idProviderBillType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `date` date DEFAULT NULL,
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `externalReference` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `additionalInfo` mediumtext,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendDate` datetime DEFAULT NULL,
  `evaluationValue` decimal(7,2) DEFAULT NULL,
  `evaluationRank` int(3) DEFAULT NULL COMMENT '3',
  `totalUntaxedAmount` decimal(11,2) DEFAULT NULL,
  `taxPct` decimal(5,2) DEFAULT NULL,
  `totalTaxAmount` decimal(11,2) DEFAULT NULL,
  `totalFullAmount` decimal(11,2) DEFAULT NULL,
  `untaxedAmount` decimal(11,2) DEFAULT NULL,
  `taxAmount` decimal(11,2) DEFAULT NULL,
  `fullAmount` decimal(11,2) DEFAULT NULL,
  `discountAmount` decimal(11,2) DEFAULT NULL,
  `discountRate` decimal(5,2) DEFAULT NULL,
  `discountFrom` varchar(10) DEFAULT NULL,
  `lastPaymentDate` date DEFAULT NULL,
  `paymentAmount` decimal(11,2) DEFAULT NULL,
  `paymentCondition` varchar(100) DEFAULT NULL,
  `paymentDate` date DEFAULT NULL,
  `idPaymentDelay` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDueDate` date DEFAULT NULL,
  `paymentsCount` int(3) DEFAULT '0' COMMENT '3',
  `paymentDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `comment` mediumtext,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `idProjectExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `discountFullAmount` decimal(11,2) DEFAULT NULL,
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `discountAmountLocal` decimal(11,2) DEFAULT NULL,
  `discountFullAmountLocal` decimal(11,2) DEFAULT NULL,
  `fullAmountLocal` decimal(11,2) DEFAULT NULL,
  `paymentAmountLocal` decimal(11,2) DEFAULT NULL,
  `taxAmountLocal` decimal(11,2) DEFAULT NULL,
  `totalFullAmountLocal` decimal(11,2) DEFAULT NULL,
  `totalTaxAmountLocal` decimal(11,2) DEFAULT NULL,
  `totalUntaxedAmountLocal` decimal(11,2) DEFAULT NULL,
  `untaxedAmountLocal` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `providerbillProject` (`idProject`),
  KEY `providerbillUser` (`idUser`),
  KEY `providerbillResource` (`idResource`),
  KEY `providerbillStatus` (`idStatus`),
  KEY `providerbillType` (`idProviderBillType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]providerorder`
--

CREATE TABLE `[[dbprefix]]providerorder` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `idProviderOrderType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `externalReference` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `additionalInfo` mediumtext,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendDate` datetime DEFAULT NULL,
  `evaluationValue` decimal(7,2) DEFAULT NULL,
  `evaluationRank` int(3) DEFAULT NULL COMMENT '3',
  `totalUntaxedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `taxPct` decimal(5,2) DEFAULT NULL,
  `totalTaxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `totalFullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `untaxedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `taxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `fullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `discountAmount` decimal(11,2) DEFAULT NULL,
  `discountRate` decimal(5,2) DEFAULT NULL,
  `discountFrom` varchar(10) DEFAULT NULL,
  `deliveryDelay` varchar(100) DEFAULT NULL,
  `deliveryExpectedDate` date DEFAULT NULL,
  `deliveryDoneDate` date DEFAULT NULL,
  `deliveryValidationDate` date DEFAULT NULL,
  `paymentCondition` varchar(100) DEFAULT NULL,
  `comment` mediumtext,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `idProjectExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `discountFullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `discountAmountLocal` decimal(11,2) DEFAULT NULL,
  `discountFullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `fullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `taxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalFullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalTaxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalUntaxedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `untaxedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `providerorderProject` (`idProject`),
  KEY `providerorderUser` (`idUser`),
  KEY `providerorderResource` (`idResource`),
  KEY `providerorderStatus` (`idStatus`),
  KEY `providerorderType` (`idProviderOrderType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]providerpayment`
--

CREATE TABLE `[[dbprefix]]providerpayment` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idProviderBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProviderTerm` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentDate` date DEFAULT NULL,
  `idPaymentMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `idProviderPaymentType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentAmount` decimal(11,2) unsigned DEFAULT NULL,
  `paymentFeeAmount` decimal(11,2) unsigned DEFAULT NULL,
  `paymentCreditAmount` decimal(11,2) unsigned DEFAULT NULL,
  `description` mediumtext,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `referenceProviderBill` varchar(100) DEFAULT NULL,
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `providerBillAmount` decimal(11,2) unsigned DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paymentAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `paymentCreditAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `paymentFeeAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `providerBillAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `providerpaymentBill` (`idProviderBill`),
  KEY `providerpaymentProvider` (`idProvider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]providerterm`
--

CREATE TABLE `[[dbprefix]]providerterm` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT NULL COMMENT '1',
  `idle` int(1) unsigned DEFAULT NULL COMMENT '1',
  `idProviderOrder` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProviderBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `untaxedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `taxPct` decimal(5,2) DEFAULT NULL,
  `taxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `fullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `idProjectExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isBilled` int(1) unsigned DEFAULT NULL COMMENT '1',
  `isPaid` int(1) unsigned DEFAULT NULL COMMENT '1',
  `fullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `taxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `untaxedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `providertermProject` (`idProject`),
  KEY `providertermOrder` (`idProviderOrder`),
  KEY `providertermBill` (`idProviderBill`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quality`
--

CREATE TABLE `[[dbprefix]]quality` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `icon` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]quality`
--

INSERT INTO `[[dbprefix]]quality` VALUES
(1, 'conform', '#32CD32', 100, 'smileyGreen.png', 0),
(2, 'some remarks', '#ffd700', 200, 'smileyYellow.png', 0),
(3, 'not conform', '#FF0000', 300, 'smileyRed.png', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question`
--

CREATE TABLE `[[dbprefix]]question` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idQuestionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sendMail` varchar(100) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `replier` varchar(100) DEFAULT NULL,
  `initialDueDate` date DEFAULT NULL,
  `actualDueDate` date DEFAULT NULL,
  `result` mediumtext,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `questionProject` (`idProject`),
  KEY `questionType` (`idQuestionType`),
  KEY `questionUser` (`idUser`),
  KEY `questionResource` (`idResource`),
  KEY `questionStatus` (`idStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quotation`
--

CREATE TABLE `[[dbprefix]]quotation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idQuotationType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `additionalInfo` mediumtext,
  `initialEndDate` date DEFAULT NULL,
  `untaxedAmount` decimal(12,2) DEFAULT NULL,
  `initialPricePerDayAmount` decimal(12,2) DEFAULT '0.00',
  `initialAmount` decimal(12,2) DEFAULT '0.00',
  `comment` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `sendDate` date DEFAULT NULL,
  `validityEndDate` date DEFAULT NULL,
  `idActivityType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `result` mediumtext,
  `idPaymentDelay` int(12) unsigned DEFAULT NULL COMMENT '12',
  `tax` decimal(5,2) DEFAULT NULL,
  `fullAmount` decimal(12,2) DEFAULT NULL,
  `idDeliveryMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLikelihood` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedWork` decimal(12,2) DEFAULT '0.00',
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `fullAmountLocal` decimal(12,2) DEFAULT NULL,
  `initialAmountLocal` decimal(12,2) DEFAULT NULL,
  `initialPricePerDayAmountLocal` decimal(12,2) DEFAULT NULL,
  `untaxedAmountLocal` decimal(12,2) DEFAULT NULL,
  `taxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotationProject` (`idProject`),
  KEY `quotationUser` (`idUser`),
  KEY `quotationResource` (`idResource`),
  KEY `quotationStatus` (`idStatus`),
  KEY `quotationType` (`idQuotationType`),
  KEY `quotationClient` (`idClient`),
  KEY `quotationContact` (`idContact`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]recipient`
--

CREATE TABLE `[[dbprefix]]recipient` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `companyNumber` varchar(100) DEFAULT NULL,
  `numTax` varchar(100) DEFAULT NULL,
  `bankName` varchar(100) DEFAULT NULL,
  `ibanCountry` varchar(2) DEFAULT NULL,
  `ibanKey` varchar(2) DEFAULT NULL,
  `ibanBban` varchar(34) DEFAULT NULL,
  `designation` varchar(50) DEFAULT NULL,
  `street` varchar(50) DEFAULT NULL,
  `complement` varchar(50) DEFAULT NULL,
  `zip` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `taxFree` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `legalNotice` varchar(1000) DEFAULT NULL,
  `contactName` varchar(100) DEFAULT NULL,
  `contactEmail` varchar(100) DEFAULT NULL,
  `contactPhone` varchar(100) DEFAULT NULL,
  `contactMobile` varchar(100) DEFAULT NULL,
  `bankNationalAccountNumber` varchar(100) DEFAULT NULL,
  `bankInternationalAccountNumber` varchar(100) DEFAULT NULL,
  `bankIdentificationCode` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]referencable`
--

CREATE TABLE `[[dbprefix]]referencable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `[[dbprefix]]referencable`
--

INSERT INTO `[[dbprefix]]referencable` VALUES
(1, 'Ticket', 0),
(2, 'Activity', 0),
(3, 'Milestone', 0),
(4, 'IndividualExpense', 0),
(5, 'ProjectExpense', 0),
(6, 'Risk', 0),
(7, 'Action', 0),
(8, 'Issue', 0),
(9, 'Meeting', 0),
(10, 'Decision', 0),
(11, 'Question', 0),
(12, 'Document', 0),
(13, 'Requirement', 0),
(14, 'TestCase', 0),
(15, 'TestSession', 0),
(16, 'Command', 0),
(17, 'Opportunity', 0),
(18, 'Quotation', 0),
(19, 'Bill', 0),
(20, 'CallForTender', 0),
(21, 'Deliverable', 0),
(22, 'Delivery', 0),
(23, 'Incoming', 0),
(24, 'Payment', 1),
(25, 'Tender', 0),
(26, 'ProviderOrder', 0),
(27, 'ProviderBill', 0),
(28, 'ProviderPayment', 1),
(29, 'ActivityExpense', 0),
(30, 'ChangeRequest', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]renewal`
--

CREATE TABLE `[[dbprefix]]renewal` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]renewal`
--

INSERT INTO `[[dbprefix]]renewal` VALUES
(1, 'never', 100, 0),
(2, 'tacit', 200, 0),
(3, 'express', 300, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report`
--

CREATE TABLE `[[dbprefix]]report` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idReportCategory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `file` varchar(100) DEFAULT NULL,
  `sortOrder` int(5) DEFAULT NULL COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `orientation` varchar(1) DEFAULT 'L',
  `hasCsv` int(1) unsigned DEFAULT '0' COMMENT '1',
  `hasView` int(1) DEFAULT '1' COMMENT '1',
  `hasPrint` int(1) DEFAULT '1' COMMENT '1',
  `hasPdf` int(1) DEFAULT '1' COMMENT '1',
  `hasToday` int(1) DEFAULT '1' COMMENT '1',
  `hasFavorite` int(1) DEFAULT '1' COMMENT '1',
  `hasWord` int(1) DEFAULT '0' COMMENT '1',
  `hasExcel` int(1) DEFAULT '0' COMMENT '1',
  `filterClass` varchar(100) DEFAULT NULL,
  `referTo` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reportReportCategory` (`idReportCategory`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5000001 ;

--
-- Dumping data for table `[[dbprefix]]report`
--

INSERT INTO `[[dbprefix]]report` VALUES
(1, 'reportWorkWeekly', 1, 'work.php', 110, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(2, 'reportWorkMonthly', 1, 'work.php', 120, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(3, 'reportWorkYearly', 1, 'work.php', 125, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(4, 'reportPlanColoredMonthly', 2, 'colorPlan.php', 283, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(5, 'reportPlanResourceMonthly', 2, 'resourcePlan.php', 240, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planMonthly'),
(6, 'reportPlanProjectMonthly', 2, 'projectPlan.php', 250, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planMonthly'),
(8, 'reportWorkPlan', 2, 'workPlan.php', 220, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'synthesisWork'),
(9, 'reportTicketYearly', 3, 'ticketYearlyReport.php', 310, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketCount'),
(10, 'reportTicketYearlyByType', 3, 'ticketYearlyReportByType.php', 320, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketCount'),
(11, 'reportTicketWeeklyCrossReport', 3, 'ticketReport.php', 330, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', NULL),
(12, 'reportTicketMonthlyCrossReport', 3, 'ticketReport.php', 340, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', NULL),
(13, 'reportTicketYearlyCrossReport', 3, 'ticketReport.php', 350, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', NULL),
(14, 'reportTicketWeeklySynthesis', 3, 'ticketSynthesis.php', 360, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketsRepartition'),
(15, 'reportTicketMonthlySynthesis', 3, 'ticketSynthesis.php', 370, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketsRepartition'),
(16, 'reportTicketYearlySynthesis', 3, 'ticketSynthesis.php', 380, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketsRepartition'),
(17, 'reportTicketGlobalCrossReport', 3, 'ticketReport.php', 355, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', NULL),
(18, 'reportTicketGlobalSynthesis', 3, 'ticketSynthesis.php', 390, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketsRepartition'),
(19, 'reportGlobalWorkPlanningWeekly', 2, 'globalWorkPlanning.php?scale=week', 260, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(20, 'reportGlobalWorkPlanningMonthly', 2, 'globalWorkPlanning.php?scale=month', 270, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(21, 'reportStatusOngoing', 4, 'status.php', 410, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(22, 'reportStatusAll', 4, 'status.php?showIdle=true', 420, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(23, 'reportRiskManagementPlan', 4, 'riskManagementPlan.php', 430, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(24, 'reportHistoryDeteled', 9, 'history.php?scope=deleted', 915, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(25, 'reportHistoryDetail', 9, 'history.php?scope=item', 905, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(26, 'reportCostDetail', 6, 'costPlan.php', 610, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(27, 'reportCostMonthly', 6, 'globalCostPlanning.php?scale=month', 620, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(28, 'reportWorkDetailWeekly', 1, 'workDetail.php?scale=week', 140, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(29, 'reportWorkDetailMonthly', 1, 'workDetail.php?scale=month', 150, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(30, 'reportWorkDetailYearly', 1, 'workDetail.php?scale=year', 160, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(31, 'reportPlanDetail', 2, 'detailPlan.php', 255, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planMonthly'),
(32, 'reportAvailabilityPlan', 2, 'availabilityPlan.php', 280, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'dispo'),
(33, 'reportExpenseProject', 6, 'expensePlan.php?scale=month&scope=Project&showVAT=false', 660, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(34, 'reportExpenseResource', 6, 'expensePlan.php?scale=month&scope=Individual&showVAT=false', 670, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(35, 'reportExpenseTotal', 6, 'expensePlan.php?scale=month&showVAT=false', 680, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(36, 'reportExpenseCostTotal', 6, 'expenseCostTotalPlan.php?scale=month', 690, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(37, 'reportBill', 7, 'bill.php', 710, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(38, 'reportVersionStatus', 4, 'versionReport.php', 440, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(39, 'reportVersionDetail', 4, 'versionDetail.php', 450, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(40, 'reportWorkPerActivity', 1, 'workPerActivity.php', 170, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(41, 'reportProductTest', 8, 'productTest.php', 820, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'testCoverage'),
(42, 'reportPlanActivityMonthly', 2, 'activityPlan.php', 252, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planMonthly'),
(43, 'reportTestSession', 8, 'testSession.php', 830, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'testCoverage'),
(44, 'reportRequirementTest', 8, 'requirementTest.php', 810, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'testCoverage'),
(45, 'reportTermMonthly', 7, 'term.php', 720, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(46, 'reportTermWeekly', 7, 'term.php', 730, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(47, 'reportOpportunityPlan', 4, 'opportunityPlan.php', 440, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(48, 'reportAudit', 9, 'audit.php', 910, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(50, 'reportProject', 9, 'projectDashboard.php', 920, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(52, 'reportAvailabilitySynthesis', 2, 'availabilitySynthesis.php', 282, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'dispo'),
(53, 'reportProductTestDetail', 8, 'productTestDetail.php', 825, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'testCoverage'),
(54, 'reportWorkWeeklyResource', 1, 'work.php', 170, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(55, 'reportWorkMonthlyResource', 1, 'work.php', 180, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(56, 'reportWorkYearlyResource', 1, 'work.php', 190, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(57, 'reportPlanDetailPerResource', 2, 'detailPlan.php', 256, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planMonthly'),
(58, 'reportPlanProjectDetailPerResource', 2, 'activityPlan.php', 257, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planMonthly'),
(59, 'reportBurndownChart', 10, 'burndownChart.php', 1010, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(60, 'reportPlanProjectPerRessourceAndMonth', 2, 'reportPlanProjectPerRessourceAndMonth.php', 284, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planYearly'),
(61, 'reportSCurveChart', 10, 'reportSCurveChart.php', 1020, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(62, 'report45DegreeChart', 10, 'report45DegreeChart.php', 1030, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(63, 'reportMacroJoblist', 4, 'joblist.php', 460, 0, 'L', 1, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(64, 'reportKpiDurationProject', 11, 'kpiDuration.php?scope=Project', 1110, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(65, 'reportKpiDurationOrganization', 11, 'kpiDuration.php?scope=Organization', 1115, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(66, 'reportKpiWorkloadProject', 11, 'kpiWorkload.php?scope=Project', 1120, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(67, 'reportKpiWorkloadOrganization', 11, 'kpiWorkload.php?scope=Organization', 1125, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(68, 'reportKpiTerm', 11, 'kpiTerm.php', 1150, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(69, 'reportKpiDeliverableProject', 11, 'kpiDeliverable.php?class=Deliverable&scope=Project', 1130, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(70, 'reportKpiDeliverableOrganization', 11, 'kpiDeliverable.php?scope=Organization', 1135, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(71, 'reportKpiIncomingProject', 11, 'kpiDeliverable.php?class=Incoming&scope=Project', 1140, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(72, 'reportKpiIncomingOrganization', 11, 'kpiDeliverable.php?class=Incoming&scope=Organization', 1145, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(73, 'reportTicketOpenedClosed', 3, 'ticketOpenedClosedReport.php', 392, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketCount'),
(74, 'reportTicketYearlyByProduct', 3, 'ticketYearlyReportByProduct.php', 395, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', 'ticketCount'),
(75, 'performanceIndicator', 10, 'performanceIndicator.php', 1040, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(76, 'reportGlobalWorkPlanningPerResourceWeekly', 2, 'globalWorkPlanningPerResource.php?scale=week', 276, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'globalWorkPlanning'),
(77, 'reportGlobalWorkPlanningPerResourceMonthly', 2, 'globalWorkPlanningPerResource.php?scale=month', 277, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'globalWorkPlanning'),
(78, 'reportWorkPlanPerTicket', 2, 'workPlanPerTicket.php', 225, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'synthesisWork'),
(79, 'burnDownCurve', 8, 'burnDownCurve.php', 860, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(80, 'curveOfTicketsBurndown', 3, 'curveOfTickets.php', 398, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, 'Ticket', NULL),
(81, 'reportRequirementCumulatedAnnual', 8, 'requirementCumulatedAnualReport.php', 840, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'requirementFlow'),
(82, 'reportRequirementCumulatedNbOfDays', 8, 'requirementNbOfDays.php', 850, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'requirementFlow'),
(83, 'clientsForVersion', 3, 'clientsForVersion.php', 399, 0, 'L', 1, 1, 1, 1, 1, 1, 0, 0, 'Ticket', NULL),
(84, 'reportRequirementOpenQuestion', 8, 'requirementOpenQuestion.php', 880, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(86, 'financialExpenseBoard', 7, 'financialExpenseBoard.php', 740, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(87, 'financialExpenseSynthesis', 7, 'financialExpenseSynthesis.php', 750, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(88, 'reportRequirementYearlyByType', 8, 'requirementYearlyByTypeReport.php', 855, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'requirementFlow'),
(89, 'reportRequirementWeeklySynthesis', 8, 'RequirementOpenedSynthesis.php', 885, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(90, 'reportRequirementMonthlySynthesis', 8, 'RequirementOpenedSynthesis.php', 886, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(91, 'reportRequirementYearlySynthesis', 8, 'RequirementOpenedSynthesis.php', 887, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(92, 'reportRequirementGlobalSynthesis', 8, 'RequirementOpenedSynthesis.php', 888, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(102, 'reportResourceInputOutput', 20, 'resourceReportInputOutput.php', 1210, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(103, 'reportResourceWorkload', 20, 'resourceReportWorkload.php', 1220, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(104, 'reportResourceSeniority', 20, 'resourceReportSeniority.php', 1230, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(105, 'reportWorkForAResourceByActivityTypeMonthly', 1, 'workPerTypeOfActivity.php', 195, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(106, 'reportWorkForAResourceByActivityTypeYearly', 1, 'workPerTypeOfActivity.php', 197, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(107, 'reportSubscription', 9, 'reportSubscription.php', 940, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(108, 'reportTechnicalProgress', 2, 'technicalProgress.php', 227, 0, 'L', 1, 1, 1, 1, 1, 1, 0, 0, NULL, 'synthesisWork'),
(109, 'reportShowIntervention', 2, 'plannedWorkManual.php', 285, 0, 'L', 0, 1, 1, 0, 1, 1, 0, 0, NULL, NULL),
(110, 'reportConsolidationValidation', 7, 'consultationValidation.php', 760, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(111, 'reportLeftWork', 1, 'leftWork.php', 199, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(112, 'reportWorkWeekDetail', 1, 'workDetailed.php', 131, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(113, 'reportWorkMonthDetail', 1, 'workDetailed.php', 132, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(114, 'reportWorkYearDetail', 1, 'workDetailed.php', 133, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(115, 'reportAttachment', 9, 'attachment.php', 950, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(116, 'reportWorkTwoDate', 1, 'work.php', 130, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(117, 'reportWorkDetailTwoDate', 1, 'workDetailed.php', 134, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(118, 'reportApprovalDocument', 4, 'documentApproval.php', 470, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(119, 'reportTicketHandledMonthSynthesis', 3, 'ticketHandledMonthSynthesis.php', 396, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'ticketSynthesisStatus'),
(120, 'reportTicketDoneMonthSynthesis', 3, 'ticketDoneMonthSynthesis.php', 397, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'ticketSynthesisStatus'),
(121, 'reportYearlyResourcePlan', 2, 'yearlyResourcePlan.php', 245, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planYearly'),
(122, 'reportYearlyPlanResource', 2, 'yearlyPlanResource.php', 251, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'planYearly'),
(123, 'reportSynthesisOrdersInvoiceClient', 7, 'synthesisOrdersInvoiceClient.php', 770, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(124, 'reportWorkPlanTwoDate', 2, 'workPlan.php?scale=twoDate', 222, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'synthesisWork'),
(125, 'reportWorkDetailTwoDates', 1, 'workDetail.php?scale=twoDate', 162, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(126, 'reportWorkUnitSynthesis', 11, 'workUnitSynthesis.php', 1160, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(127, 'reportWorkPerActivityTwoDate', 1, 'workPerActivity.php?scale=twoDate', 175, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(128, 'reportWorkPlanPerPeriods', 2, 'workPlanPerPeriods.php', 278, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'globalWorkPlanning'),
(130, 'reportWorkTwoDatesResource', 1, 'work.php', 192, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(131, 'reportWorkForAResourceByActivityTypeTwoDates', 1, 'workPerTypeOfActivity.php', 198, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(132, 'reportResourcePlan', 2, 'resourcePlanReport.php', 228, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'synthesisWork'),
(133, 'reportWorkLoadHistory', 11, 'workloadhistory.php', 1165, 0, 'P', 0, 1, 1, 1, 1, 1, 0, 0, '0', NULL),
(134, 'proposales', 10, 'proposal.php', 1055, 0, 'L', 0, 1, 1, 0, 0, 1, 0, 0, NULL, NULL),
(135, 'reportRida', 10, 'rida.php', 1060, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(136, 'reportYearlyPlanResourceActivity', 2, 'yearlyPlanResourceActivity.php', 290, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'planYearly'),
(137, 'reportWorkMonthlyByResource', 1, 'activityPlan.php?onlyRealWork=true', 200, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'work'),
(138, 'reportWorkMonthlyDetailByResource', 1, 'detailPlan.php?onlyRealWork=true', 202, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, 'work'),
(139, 'reportWorkYearlyPerMonth', 1, 'yearlyResourcePlan.php?onlyRealWork=true', 204, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, 'work'),
(140, 'reportActionTable', 4, 'riskManagementPlan.php?onlyAction=true', 431, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(141, 'reportCostMonthlyPerActivity', 6, 'globalCostPlanningPerActivity.php', 625, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(142, 'reportProjectAnalysis', 10, 'reportProjectAnalysis.php', 1070, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 1, NULL, NULL),
(144, 'reportPlanColoredMonthlySameScale', 2, 'colorPlan.php?scale=same', 300, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(145, 'reportAcceptationWorkCommand', 7, 'reportAcceptationWorkCommand.php', 780, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(146, 'reportListOfWorksForAnActivity', 1, 'reportListOfWorksForAnActivity.php', 206, 0, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL),
(5000000, 'startForReportList', 21, '', 0, 1, 'L', 0, 1, 1, 1, 1, 1, 0, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportcategory`
--

CREATE TABLE `[[dbprefix]]reportcategory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(5) DEFAULT NULL COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]reportcategory`
--

INSERT INTO `[[dbprefix]]reportcategory` VALUES
(1, 'reportCategoryWork', 10, 0),
(2, 'reportCategoryPlan', 20, 0),
(3, 'reportCategoryTicket', 30, 0),
(4, 'reportCategoryStatus', 40, 0),
(6, 'reportCategoryCost', 50, 0),
(7, 'reportCategoryBill', 60, 0),
(8, 'reportCategoryRequirementTest', 70, 0),
(9, 'reportCategoryMisc', 80, 0),
(10, 'reportCategorySteeringCharts', 25, 0),
(11, 'reportCategoryKpi', 27, 0),
(20, 'reportCategoryResources', 90, 0),
(21, 'reportCategoryObjectList', 100, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportlayout`
--

CREATE TABLE `[[dbprefix]]reportlayout` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned NOT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `objectClass` varchar(50) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  `isShared` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idFilter` int(10) unsigned DEFAULT NULL COMMENT '12',
  `directFilter` mediumtext,
  `comment` mediumtext,
  PRIMARY KEY (`id`),
  KEY `reportLayoutUser` (`idUser`),
  KEY `reportLayoutObjectClass` (`objectClass`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportparameter`
--

CREATE TABLE `[[dbprefix]]reportparameter` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `paramType` varchar(100) DEFAULT NULL,
  `sortOrder` int(5) DEFAULT NULL COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `defaultValue` varchar(100) DEFAULT NULL,
  `multiple` int(1) unsigned DEFAULT '0' COMMENT '1',
  `required` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `reportparameterReport` (`idReport`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=566 ;

--
-- Dumping data for table `[[dbprefix]]reportparameter`
--

INSERT INTO `[[dbprefix]]reportparameter` VALUES
(1, 1, 'week', 'week', 10, 0, 'currentWeek', 0, 0),
(2, 2, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(3, 3, 'year', 'year', 10, 0, 'currentYear', 0, 0),
(4, 4, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(5, 5, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(6, 6, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(11, 8, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(12, 9, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(13, 9, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(14, 9, 'idTicketType', 'ticketType', 30, 0, NULL, 0, 0),
(15, 9, 'issuer', 'userList', 40, 0, NULL, 0, 0),
(16, 9, 'responsible', 'resourceList', 50, 0, NULL, 0, 0),
(17, 10, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(18, 10, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(19, 10, 'issuer', 'userList', 40, 0, NULL, 0, 0),
(20, 10, 'responsible', 'resourceList', 50, 0, NULL, 0, 0),
(21, 11, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(22, 11, 'week', 'week', 20, 0, 'currentWeek', 0, 0),
(23, 11, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(24, 11, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(25, 12, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(26, 12, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(27, 12, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(28, 12, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(29, 13, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(30, 13, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(31, 13, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(32, 13, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(33, 14, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(34, 14, 'week', 'week', 20, 0, 'currentWeek', 0, 0),
(35, 14, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(36, 14, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(37, 15, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(38, 15, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(39, 15, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(40, 15, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(41, 16, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(42, 16, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(43, 16, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(44, 16, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(45, 17, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(46, 17, 'issuer', 'userList', 20, 0, NULL, 0, 0),
(47, 17, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(48, 18, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(49, 18, 'issuer', 'userList', 20, 0, NULL, 0, 0),
(50, 18, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(51, 19, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(52, 20, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(53, 21, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(54, 21, 'issuer', 'userList', 20, 0, NULL, 0, 0),
(55, 21, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(56, 22, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(57, 22, 'issuer', 'userList', 20, 0, NULL, 0, 0),
(58, 22, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(59, 23, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(61, 25, 'refType', 'objectList', 10, 0, NULL, 0, 0),
(62, 25, 'refId', 'id', 20, 0, NULL, 0, 0),
(63, 26, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(64, 27, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(65, 28, 'week', 'week', 10, 0, 'currentWeek', 0, 0),
(66, 29, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(67, 30, 'year', 'year', 10, 0, 'currentYear', 0, 0),
(68, 31, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(69, 31, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(70, 32, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(71, 33, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(72, 34, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(73, 35, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(74, 36, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(75, 34, 'idResource', 'resourceList', 20, 0, NULL, 0, 0),
(76, 9, 'requestor', 'requestorList', 35, 0, NULL, 0, 0),
(77, 10, 'requestor', 'requestorList', 35, 0, NULL, 0, 0),
(78, 11, 'requestor', 'requestorList', 25, 0, NULL, 0, 0),
(79, 12, 'requestor', 'requestorList', 25, 0, NULL, 0, 0),
(80, 13, 'requestor', 'requestorList', 25, 0, NULL, 0, 0),
(81, 14, 'requestor', 'requestorList', 25, 0, NULL, 0, 0),
(82, 15, 'requestor', 'requestorList', 25, 0, NULL, 0, 0),
(83, 16, 'requestor', 'requestorList', 25, 0, NULL, 0, 0),
(84, 17, 'requestor', 'requestorList', 15, 0, NULL, 0, 0),
(85, 18, 'requestor', 'requestorList', 15, 0, NULL, 0, 0),
(86, 37, 'idBill', 'billList', 10, 0, NULL, 0, 0),
(87, 37, 'idProject', 'projectList', 20, 0, 'currentProject', 0, 0),
(88, 37, 'idClient', 'clientList', 30, 0, NULL, 0, 0),
(89, 1, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(90, 2, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(91, 3, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(92, 28, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(93, 29, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(94, 30, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(95, 4, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(96, 5, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(97, 6, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(98, 38, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(99, 38, 'idTicketType', 'ticketType', 20, 0, NULL, 0, 0),
(100, 38, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(101, 39, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(102, 39, 'idVersion', 'versionList', 20, 0, NULL, 0, 0),
(103, 39, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(104, 40, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(105, 44, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(106, 44, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(107, 44, 'showDetail', 'showDetail', 40, 0, NULL, 0, 0),
(108, 41, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(109, 41, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(110, 41, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(111, 41, 'showDetail', 'showDetail', 40, 0, NULL, 0, 0),
(112, 42, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(113, 42, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(114, 43, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(115, 43, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(116, 43, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(117, 43, 'idTestSession', 'testSessionList', 40, 0, NULL, 0, 0),
(118, 43, 'showDetail', 'showDetail', 50, 0, NULL, 0, 0),
(119, 44, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(120, 1, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(121, 2, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(122, 3, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(123, 28, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(124, 29, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(125, 30, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(126, 4, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(127, 5, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(128, 6, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(129, 42, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(130, 31, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(131, 32, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(132, 38, 'otherVersions', 'boolean', 900, 0, NULL, 0, 0),
(133, 39, 'otherVersions', 'boolean', 900, 0, NULL, 0, 0),
(134, 45, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(135, 45, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(136, 46, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(137, 46, 'week', 'week', 20, 0, 'currentWeek', 0, 0),
(138, 19, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(139, 19, 'week', 'week', 30, 0, 'currentYear', 0, 0),
(140, 20, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(141, 20, 'month', 'month', 30, 0, 'currentYear', 0, 0),
(142, 27, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(143, 27, 'month', 'month', 30, 0, 'currentYear', 0, 0),
(144, 47, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(145, 48, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(151, 50, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(152, 52, 'period', 'nextPeriod', 10, 0, '10/month', 0, 0),
(153, 52, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(154, 53, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(155, 53, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(156, 53, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(157, 54, 'week', 'week', 30, 0, 'currentWeek', 0, 0),
(158, 55, 'month', 'month', 30, 0, 'currentMonth', 0, 0),
(159, 56, 'year', 'year', 30, 0, 'currentYear', 0, 0),
(160, 54, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(161, 55, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(162, 56, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(163, 54, 'idResource', 'resourceList', 20, 0, 'currentResource', 0, 0),
(164, 55, 'idResource', 'resourceList', 20, 0, 'currentResource', 0, 0),
(165, 56, 'idResource', 'resourceList', 20, 0, 'currentResource', 0, 0),
(166, 38, 'showDoneVersions', 'boolean', 850, 0, NULL, 0, 0),
(167, 39, 'showDoneVersions', 'boolean', 850, 0, NULL, 0, 0),
(168, 57, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(169, 57, 'idResource', 'resourceList', 10, 0, 'currentResource', 0, 0),
(170, 31, 'idResource', 'resourceList', 17, 0, NULL, 0, 0),
(171, 42, 'idResource', 'resourceList', 17, 0, NULL, 0, 0),
(172, 58, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(173, 58, 'idResource', 'resourceList', 10, 0, 'currentResource', 0, 0),
(174, 31, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(175, 57, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(176, 4, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(177, 5, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(178, 6, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(179, 42, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(180, 58, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(181, 59, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(182, 59, 'format', 'periodScale', 20, 0, 'day', 0, 0),
(183, 59, 'startDate', 'date', 30, 0, NULL, 0, 0),
(184, 59, 'endDate', 'date', 40, 0, NULL, 0, 0),
(185, 59, 'showBurndownActivities', 'boolean', 50, 0, '1', 0, 0),
(186, 59, 'showBurndownToday', 'boolean', 60, 0, '1', 0, 0),
(187, 59, 'showBurndownLegendOnTop', 'boolean', 70, 0, '0', 0, 0),
(188, 8, 'showIdle', 'boolean', 20, 0, 'currentProject', 0, 0),
(189, 60, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(190, 60, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(191, 60, 'month', 'month', 40, 0, NULL, 0, 0),
(192, 61, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(193, 61, 'idBaselineSelect', 'baselineList', 20, 0, NULL, 0, 0),
(194, 61, 'format', 'periodScale', 30, 0, 'day', 0, 0),
(195, 61, 'startDate', 'date', 40, 0, NULL, 0, 0),
(196, 61, 'endDate', 'date', 50, 0, NULL, 0, 0),
(197, 61, 'showBurndownToday', 'boolean', 60, 0, '1', 0, 0),
(198, 61, 'showBurndownLegendOnTop', 'boolean', 70, 0, '0', 0, 0),
(199, 62, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(200, 62, 'format', 'periodScale', 20, 0, 'day', 0, 0),
(201, 62, 'idMilestoneType', 'milestoneTypeList', 30, 0, NULL, 0, 0),
(202, 62, 'startDate', 'date', 40, 0, NULL, 0, 0),
(203, 62, 'endDate', 'date', 45, 0, NULL, 0, 0),
(204, 62, 'showBurndownToday', 'boolean', 60, 0, '1', 0, 0),
(205, 63, 'idActivity', 'activityList', 20, 0, NULL, 0, 0),
(206, 63, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(207, 64, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(208, 64, 'month', 'month', 20, 0, NULL, 0, 0),
(209, 64, 'showThreshold', 'boolean', 30, 0, '1', 0, 0),
(210, 65, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(211, 65, 'idProjectType', 'projectTypeList', 20, 0, NULL, 0, 0),
(212, 65, 'month', 'month', 30, 0, 'currentYear', 0, 0),
(213, 65, 'showThreshold', 'boolean', 40, 0, '1', 0, 0),
(214, 65, 'onlyFinished', 'boolean', 50, 0, '1', 0, 0),
(215, 66, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(216, 66, 'month', 'month', 20, 0, NULL, 0, 0),
(217, 66, 'showThreshold', 'boolean', 30, 0, '1', 0, 0),
(218, 67, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(219, 67, 'idProjectType', 'projectTypeList', 20, 0, NULL, 0, 0),
(220, 67, 'idCategory', 'categoryList', 30, 0, NULL, 0, 0),
(221, 67, 'month', 'month', 40, 0, 'currentYear', 0, 0),
(222, 67, 'showThreshold', 'boolean', 50, 0, '1', 0, 0),
(223, 67, 'onlyFinished', 'boolean', 60, 0, '1', 0, 0),
(224, 68, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(225, 68, 'month', 'month', 20, 0, NULL, 0, 0),
(226, 69, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(227, 69, 'month', 'month', 20, 0, NULL, 0, 0),
(228, 69, 'showThreshold', 'boolean', 30, 0, '1', 0, 0),
(229, 70, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(230, 70, 'idProjectType', 'projectTypeList', 20, 0, NULL, 0, 0),
(231, 70, 'month', 'month', 30, 0, 'currentYear', 0, 0),
(232, 70, 'showThreshold', 'boolean', 40, 0, '1', 0, 0),
(233, 70, 'onlyFinished', 'boolean', 50, 0, '1', 0, 0),
(234, 71, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(235, 71, 'month', 'month', 20, 0, NULL, 0, 0),
(236, 71, 'showThreshold', 'boolean', 30, 0, '1', 0, 0),
(237, 72, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(238, 72, 'idProjectType', 'projectTypeList', 20, 0, NULL, 0, 0),
(239, 72, 'month', 'month', 30, 0, 'currentYear', 0, 0),
(240, 72, 'showThreshold', 'boolean', 40, 0, '1', 0, 0),
(241, 72, 'onlyFinished', 'boolean', 50, 0, '1', 0, 0),
(242, 62, 'showIdle', 'boolean', 70, 0, '0', 0, 0),
(243, 9, 'priority', 'priorityList', 60, 0, NULL, 0, 0),
(244, 10, 'priority', 'priorityList', 60, 0, NULL, 0, 0),
(245, 11, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(246, 12, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(247, 13, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(248, 14, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(249, 15, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(250, 16, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(251, 17, 'priority', 'priorityList', 40, 0, NULL, 0, 0),
(252, 18, 'priority', 'priorityList', 40, 0, NULL, 0, 0),
(253, 73, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(254, 73, 'idTicketType', 'ticketType', 20, 0, NULL, 0, 0),
(255, 73, 'idProduct', 'productList', 30, 0, NULL, 0, 0),
(256, 73, 'nbOfDays', 'intInput', 40, 0, '30', 0, 0),
(257, 73, 'priority', 'priorityList', 50, 0, NULL, 0, 0),
(258, 74, 'idProduct', 'productList', 10, 0, NULL, 0, 0),
(259, 74, 'idVersion', 'versionList', 20, 0, NULL, 0, 0),
(260, 74, 'year', 'year', 30, 0, 'currentYear', 0, 0),
(261, 74, 'idTicketType', 'ticketType', 40, 0, NULL, 0, 0),
(262, 74, 'requestor', 'requestorList', 40, 0, NULL, 0, 0),
(263, 74, 'issuer', 'userList', 60, 0, NULL, 0, 0),
(264, 74, 'responsible', 'resourceList', 70, 0, NULL, 0, 0),
(265, 74, 'priority', 'priorityList', 80, 0, NULL, 0, 0),
(266, 4, 'showAdminProj', 'boolean', 60, 0, '0', 0, 0),
(267, 23, 'showClosedItems', 'boolean', 850, 0, NULL, 0, 0),
(268, 75, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(269, 75, 'format', 'periodScale', 30, 0, 'week', 0, 0),
(270, 75, 'startDate', 'date', 40, 0, NULL, 0, 0),
(271, 75, 'endDate', 'date', 50, 0, NULL, 0, 0),
(272, 75, 'activityOrTicket', 'element', 60, 0, NULL, 0, 0),
(273, 75, 'idTeam', 'teamList', 70, 0, NULL, 0, 0),
(274, 75, 'idResource', 'resourceList', 80, 0, NULL, 0, 0),
(275, 76, 'idResource', 'resourceList', 10, 0, NULL, 0, 0),
(276, 76, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(277, 76, 'week', 'week', 30, 0, NULL, 0, 0),
(278, 77, 'idResource', 'resourceList', 10, 0, NULL, 0, 0),
(279, 77, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(280, 77, 'month', 'month', 30, 0, NULL, 0, 0),
(281, 78, 'showIdle', 'boolean', 20, 0, '0', 0, 0),
(282, 78, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(283, 79, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(284, 79, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(285, 79, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(286, 79, 'IdUrgency', 'urgencyList', 40, 0, NULL, 0, 0),
(287, 79, 'idCriticality', 'criticalityList', 50, 0, NULL, 0, 0),
(288, 80, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(289, 80, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(290, 80, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(291, 80, 'idPriority', 'priorityList', 50, 0, NULL, 0, 0),
(292, 81, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(293, 81, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(294, 81, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(295, 81, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(296, 81, 'idPriority', 'priorityList', 50, 0, NULL, 0, 0),
(297, 82, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(298, 82, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(299, 82, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(300, 82, 'nbOfDays', 'intInput', 40, 0, '30', 0, 0),
(301, 82, 'idPriority', 'priorityList', 50, 0, NULL, 0, 0),
(302, 83, 'idProduct', 'productList', 10, 0, NULL, 0, 0),
(303, 83, 'idProductVersion', 'productVersionList', 20, 0, NULL, 0, 0),
(304, 83, 'listTickets', 'boolean', 30, 0, NULL, 0, 0),
(305, 83, 'idStatus', 'statusList', 40, 0, NULL, 1, 0),
(306, 84, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(307, 84, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(308, 84, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(309, 83, 'showDetail', 'showDetail', 35, 0, NULL, 0, 0),
(310, 86, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(311, 86, 'idProjectType', 'projectTypeList', 20, 0, NULL, 0, 0),
(312, 86, 'idOrganization', 'organizationList', 30, 0, NULL, 0, 0),
(313, 86, 'showExpense', 'boolean', 35, 0, '1', 0, 0),
(314, 86, 'showClosedItems', 'boolean', 40, 0, NULL, 0, 0),
(315, 87, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(316, 87, 'idProjectType', 'projectTypeList', 20, 0, NULL, 0, 0),
(317, 87, 'idOrganization', 'organizationList', 30, 0, NULL, 0, 0),
(318, 81, 'idRequirementType', 'requirementTypeList', 50, 0, NULL, 0, 0),
(319, 81, 'responsible', 'resourceList', 60, 0, NULL, 0, 0),
(320, 81, 'requestor', 'requestorList', 70, 0, NULL, 0, 0),
(321, 88, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(322, 88, 'idProduct', 'productList', 20, 0, NULL, 0, 0),
(323, 88, 'idVersion', 'versionList', 30, 0, NULL, 0, 0),
(324, 88, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(325, 88, 'responsible', 'resourceList', 50, 0, NULL, 0, 0),
(326, 88, 'requestor', 'requestorList', 60, 0, NULL, 0, 0),
(327, 88, 'issuer', 'userList', 70, 0, NULL, 0, 0),
(328, 88, 'idPriority', 'priorityList', 80, 0, NULL, 0, 0),
(329, 89, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(330, 89, 'week', 'week', 20, 0, 'currentWeek', 0, 0),
(331, 89, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(332, 89, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(333, 89, 'requestor', 'requestorList', 50, 0, NULL, 0, 0),
(334, 90, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(335, 90, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(336, 90, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(337, 90, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(338, 90, 'requestor', 'requestorList', 50, 0, NULL, 0, 0),
(339, 91, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(340, 91, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(341, 91, 'issuer', 'userList', 30, 0, NULL, 0, 0),
(342, 91, 'responsible', 'resourceList', 40, 0, NULL, 0, 0),
(343, 91, 'requestor', 'requestorList', 50, 0, NULL, 0, 0),
(344, 92, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(345, 92, 'issuer', 'userList', 20, 0, NULL, 0, 0),
(346, 92, 'responsible', 'resourceList', 30, 0, NULL, 0, 0),
(347, 92, 'requestor', 'requestorList', 40, 0, NULL, 0, 0),
(348, 102, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(349, 102, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(350, 102, 'isEmployee', 'isEmployee', 35, 0, NULL, 0, 0),
(351, 102, 'idProfile', 'profileList', 40, 0, NULL, 1, 0),
(352, 103, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(353, 103, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(354, 103, 'isEmployee', 'isEmployee', 35, 0, NULL, 0, 0),
(355, 103, 'idProfile', 'profileList', 40, 0, NULL, 1, 0),
(356, 104, 'idOrganization', 'organizationList', 10, 0, 'currentOrganization', 0, 0),
(357, 104, 'year', 'year', 20, 0, 'currentYear', 0, 0),
(358, 104, 'nbOfMonths', 'intMonthInput', 30, 0, '12', 0, 0),
(359, 104, 'isEmployee', 'isEmployee', 35, 0, NULL, 0, 0),
(360, 104, 'idProfile', 'profileList', 40, 0, NULL, 1, 0),
(361, 40, 'showIdle', 'boolean', 20, 0, NULL, 0, 0),
(362, 1, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(363, 2, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(364, 3, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(365, 28, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(366, 29, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(367, 30, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(368, 5, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(369, 6, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(370, 42, 'idOrganization', 'organizationList', 11, 0, NULL, 0, 0),
(371, 31, 'idOrganization', 'organizationList', 11, 0, NULL, 0, 0),
(372, 19, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(373, 20, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(374, 76, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(375, 77, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(376, 32, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(377, 52, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(378, 4, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(379, 60, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(380, 75, 'idOrganization', 'organizationList', 65, 0, NULL, 0, 0),
(381, 27, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(382, 107, 'idUser', 'userList', 10, 0, NULL, 0, 0),
(383, 107, 'refType', 'objectList', 20, 0, NULL, 0, 0),
(384, 105, 'idProject', 'projectList', 10, 0, NULL, 0, 0),
(385, 105, 'idResource', 'resourceList', 20, 0, NULL, 0, 0),
(386, 105, 'idActivityType', 'activityTypeList', 30, 0, NULL, 0, 0),
(387, 105, 'showDetail', 'boolean', 35, 0, NULL, 0, 0),
(388, 105, 'month', 'month', 40, 0, 'currentMonth', 0, 0),
(389, 106, 'idProject', 'projectList', 10, 0, NULL, 0, 0),
(390, 106, 'idResource', 'resourceList', 20, 0, NULL, 0, 0),
(391, 106, 'idActivityType', 'activityTypeList', 30, 0, NULL, 0, 0),
(392, 106, 'showDetail', 'boolean', 35, 0, NULL, 0, 0),
(393, 106, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(394, 108, 'showIdle', 'boolean', 20, 0, '0', 0, 0),
(395, 108, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(396, 109, 'idResource', 'resourceList', 5, 0, 'currentResource', 0, 0),
(397, 109, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(398, 109, 'idTeam', 'teamList', 20, 0, NULL, 0, 0),
(399, 109, 'idOrganization', 'organizationList', 15, 0, NULL, 0, 0),
(400, 109, 'month', 'month', 40, 0, 'currentMonth', 0, 0),
(401, 110, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(402, 110, 'idProjectType', 'projectTypeList', 15, 0, NULL, 0, 0),
(403, 110, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(404, 110, 'month', 'month', 25, 0, 'currentMonth', 0, 0),
(405, 111, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(406, 111, 'idProjectType', 'projectTypeList', 15, 0, NULL, 0, 0),
(407, 111, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(408, 112, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(409, 112, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(410, 112, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(411, 112, 'week', 'week', 25, 0, 'currentWeek', 0, 0),
(412, 113, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(413, 113, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(414, 113, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(415, 113, 'month', 'month', 25, 0, 'currentMonth', 0, 0),
(416, 114, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(417, 114, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(418, 114, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(419, 114, 'year', 'year', 25, 0, 'currentYear', 0, 0),
(420, 19, 'showAdminProj', 'boolean', 100, 0, '0', 0, 0),
(421, 20, 'showAdminProj', 'boolean', 100, 0, '0', 0, 0),
(422, 60, 'showAdminProj', 'boolean', 100, 0, '0', 0, 0),
(423, 76, 'showAdminProj', 'boolean', 100, 0, '0', 0, 0),
(424, 77, 'showAdminProj', 'boolean', 100, 0, '0', 0, 0),
(425, 30, 'limitNbMonth', 'nbMonth', 15, 0, NULL, 0, 0),
(426, 115, 'idUser', 'userList', 10, 0, NULL, 0, 0),
(427, 115, 'Idle', 'boolean', 20, 0, '1', 0, 0),
(428, 116, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(429, 116, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(430, 116, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(431, 116, 'startDate', 'date', 25, 0, 'lastMonth', 0, 0),
(432, 116, 'endDate', 'date', 30, 0, 'today', 0, 0),
(433, 117, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(434, 117, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(435, 117, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(436, 117, 'startDate', 'date', 25, 0, 'lastMonth', 0, 0),
(437, 117, 'endDate', 'date', 30, 0, 'today', 0, 0),
(438, 118, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(439, 119, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(440, 119, 'idTicketType', 'ticketType', 15, 0, NULL, 0, 0),
(441, 119, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(442, 119, 'issuer', 'userList', 25, 0, NULL, 0, 0),
(443, 119, 'requestor', 'requestorList', 30, 0, NULL, 0, 0),
(444, 119, 'responsible', 'resourceList', 35, 0, NULL, 0, 0),
(445, 119, 'ticketWithoutDelay', 'boolean', 40, 0, NULL, 0, 0),
(446, 120, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(447, 120, 'idTicketType', 'ticketType', 15, 0, NULL, 0, 0),
(448, 120, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(449, 120, 'issuer', 'userList', 25, 0, NULL, 0, 0),
(450, 120, 'requestor', 'requestorList', 30, 0, NULL, 0, 0),
(451, 120, 'responsible', 'resourceList', 35, 0, NULL, 0, 0),
(452, 120, 'ticketWithoutDelay', 'boolean', 40, 0, NULL, 0, 0),
(453, 121, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(454, 121, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(455, 121, 'idTeam', 'teamList', 30, 0, NULL, 0, 0),
(456, 121, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(457, 122, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(458, 122, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(459, 122, 'idTeam', 'teamList', 30, 0, NULL, 0, 0),
(460, 122, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(461, 123, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(462, 123, 'idClient', 'clientList', 20, 0, NULL, 0, 0),
(463, 123, 'showClosedItems', 'boolean', 30, 0, NULL, 0, 0),
(464, 123, 'showReference', 'boolean', 40, 0, NULL, 0, 0),
(465, 1, 'idActivityType', 'activityTypeList', 7, 0, NULL, 0, 0),
(466, 2, 'idActivityType', 'activityTypeList', 7, 0, NULL, 0, 0),
(467, 3, 'idActivityType', 'activityTypeList', 7, 0, NULL, 0, 0),
(468, 28, 'idActivityType', 'activityTypeList', 7, 0, NULL, 0, 0),
(469, 29, 'idActivityType', 'activityTypeList', 7, 0, NULL, 0, 0),
(470, 30, 'idActivityType', 'activityTypeList', 7, 0, NULL, 0, 0),
(471, 40, 'idActivityType', 'activityTypeList', 30, 0, NULL, 0, 0),
(472, 111, 'idActivityType', 'activityTypeList', 30, 0, NULL, 0, 0),
(473, 112, 'idActivityType', 'activityTypeList', 23, 0, NULL, 0, 0),
(474, 113, 'idActivityType', 'activityTypeList', 23, 0, NULL, 0, 0),
(475, 114, 'idActivityType', 'activityTypeList', 23, 0, NULL, 0, 0),
(476, 124, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(477, 124, 'startDate', 'date', 15, 0, 'lastMonth', 0, 1),
(478, 124, 'endDate', 'date', 20, 0, 'today', 0, 1),
(479, 124, 'showIdle', 'boolean', 25, 0, NULL, 0, 0),
(480, 125, 'idProject', 'projectList', 5, 0, 'currentProject', 0, 0),
(481, 125, 'idOrganization', 'organizationList', 10, 0, NULL, 0, 0),
(482, 125, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(483, 125, 'idActivityType', 'activityTypeList', 20, 0, NULL, 0, 0),
(484, 125, 'startDate', 'date', 25, 0, 'lastMonth', 0, 0),
(485, 125, 'endDate', 'date', 30, 0, 'today', 0, 0),
(486, 126, 'idProject', 'projectList', 5, 0, 'currentProject', 0, 1),
(487, 126, 'idActivityType', 'activityTypeList', 10, 0, NULL, 0, 0),
(488, 126, 'idProduct', 'productList', 15, 0, NULL, 0, 0),
(489, 126, 'idVersion', 'versionList', 20, 0, NULL, 0, 0),
(490, 127, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(491, 127, 'startDate', 'date', 15, 0, 'lastMonth', 0, 1),
(492, 127, 'endDate', 'date', 20, 0, 'today', 0, 1),
(493, 127, 'showIdle', 'boolean', 25, 0, NULL, 0, 0),
(496, 128, 'startDate', 'date', 10, 0, 'today', 0, 0),
(497, 128, 'endDate', 'date', 15, 0, 'nextMonth', 0, 0),
(498, 128, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(499, 128, 'idTeam', 'teamList', 25, 0, NULL, 0, 0),
(500, 20, 'idResource', 'resourceList', 25, 0, NULL, 0, 0),
(501, 19, 'idResource', 'resourceList', 25, 0, NULL, 0, 0),
(502, 112, 'idResource', 'resourceList', 22, 0, NULL, 0, 0),
(503, 113, 'idResource', 'resourceList', 22, 0, NULL, 0, 0),
(504, 114, 'idResource', 'resourceList', 22, 0, NULL, 0, 0),
(505, 117, 'idResource', 'resourceList', 22, 0, NULL, 0, 0),
(506, 130, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(507, 130, 'idResource', 'resourceList', 20, 0, 'currentResource', 0, 0),
(508, 130, 'startDate', 'date', 30, 0, 'lastMonth', 0, 0),
(509, 130, 'endDate', 'date', 40, 0, 'today', 0, 0),
(510, 131, 'idProject', 'projectList', 10, 0, NULL, 0, 0),
(511, 131, 'idResource', 'resourceList', 20, 0, NULL, 0, 0),
(512, 131, 'idActivityType', 'activityTypeList', 30, 0, NULL, 0, 0),
(513, 131, 'showDetail', 'boolean', 40, 0, NULL, 0, 0),
(514, 131, 'startDate', 'date', 50, 0, 'lastMonth', 0, 0),
(515, 131, 'endDate', 'date', 60, 0, 'today', 0, 0),
(517, 28, 'idRole', 'roleList', 8, 0, '0', 1, 0),
(518, 29, 'idRole', 'roleList', 8, 0, '0', 1, 0),
(519, 30, 'idRole', 'roleList', 8, 0, '0', 1, 0),
(520, 125, 'idRole', 'roleList', 22, 0, '0', 1, 0),
(521, 33, 'showVAT', 'boolean', 30, 0, 'false', 0, 0),
(522, 35, 'showVAT', 'boolean', 30, 0, 'false', 0, 0),
(523, 132, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(524, 132, 'showIdle', 'boolean', 25, 0, NULL, 0, 0),
(525, 133, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 1),
(526, 135, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(528, 136, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(529, 136, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(530, 136, 'idTeam', 'teamList', 30, 0, NULL, 0, 0),
(531, 136, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(532, 137, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(533, 137, 'idResource', 'resourceList', 10, 0, 'currentResource', 0, 0),
(534, 137, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(535, 138, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(536, 138, 'month', 'month', 20, 0, 'currentMonth', 0, 0),
(537, 138, 'idTeam', 'teamList', 15, 0, NULL, 0, 0),
(538, 138, 'idResource', 'resourceList', 17, 0, NULL, 0, 0),
(539, 138, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(540, 138, 'idOrganization', 'organizationList', 11, 0, NULL, 0, 0),
(541, 139, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(542, 139, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(543, 139, 'idTeam', 'teamList', 30, 0, NULL, 0, 0),
(544, 139, 'year', 'year', 40, 0, 'currentYear', 0, 0),
(545, 140, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(546, 140, 'showIdle', 'boolean', 20, 0, '0', 0, 0),
(547, 110, 'showClosedItems', 'boolean', 12, 0, NULL, 0, 0),
(548, 141, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(549, 141, 'idOrganization', 'organizationList', 20, 0, NULL, 0, 0),
(550, 141, 'idTeam', 'teamList', 30, 0, NULL, 0, 0),
(551, 141, 'month', 'month', 50, 0, 'currentYear', 0, 0),
(552, 142, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 0),
(553, 144, 'month', 'month', 10, 0, 'currentMonth', 0, 0),
(554, 144, 'idOrganization', 'organizationList', 3, 0, NULL, 0, 0),
(555, 144, 'showAdminProj', 'boolean', 60, 0, NULL, 0, 0),
(556, 144, 'includeNextMonth', 'boolean', 50, 0, NULL, 0, 0),
(557, 144, 'idTeam', 'teamList', 5, 0, NULL, 0, 0),
(558, 144, 'idProject', 'projectList', 1, 0, 'currentProject', 0, 0),
(559, 145, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 1),
(560, 145, 'year', 'year', 20, 0, 'currentYear', 0, 1),
(561, 145, 'showClosedItems', 'boolean', 40, 0, NULL, 0, 0),
(562, 146, 'idProject', 'projectList', 10, 0, 'currentProject', 0, 1),
(563, 146, 'idActivity', 'activityList', 20, 0, NULL, 0, 0),
(564, 59, 'filterActivity', 'filterActivityInput', 45, 0, '', 0, 0),
(565, 26, 'showIdle', 'boolean', 20, 0, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]requirement`
--

CREATE TABLE `[[dbprefix]]requirement` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRequirementType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `description` mediumtext,
  `idRequirement` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `idTargetProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `plannedWork` decimal(14,5) unsigned DEFAULT '0.00000',
  `idUrgency` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCriticality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idFeasibility` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRiskLevel` int(12) unsigned DEFAULT NULL COMMENT '12',
  `result` mediumtext,
  `countPassed` int(5) DEFAULT '0' COMMENT '5',
  `countFailed` int(5) DEFAULT '0' COMMENT '5',
  `countBlocked` int(5) DEFAULT '0' COMMENT '5',
  `countPlanned` int(5) DEFAULT '0' COMMENT '5',
  `countLinked` int(5) DEFAULT '0' COMMENT '5',
  `countIssues` int(5) DEFAULT '0' COMMENT '5',
  `countTotal` int(5) DEFAULT '0' COMMENT '5',
  `idRunStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `locked` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idLocker` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lockedDate` datetime DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `initialDueDate` date DEFAULT NULL,
  `actualDueDate` date DEFAULT NULL,
  `idBusinessFeature` int(12) DEFAULT NULL COMMENT '12',
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComponent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTargetComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `requirementProject` (`idProject`),
  KEY `requirementProduct` (`idProduct`),
  KEY `requirementVersion` (`idVersion`),
  KEY `requirementType` (`idRequirementType`),
  KEY `requirementUser` (`idUser`),
  KEY `requirementRequirement` (`idRequirement`),
  KEY `requirementStatus` (`idStatus`),
  KEY `requirementResource` (`idResource`),
  KEY `requirementTargetVersion` (`idTargetProductVersion`),
  KEY `requirementUrgency` (`idUrgency`),
  KEY `requirementCriticality` (`idCriticality`),
  KEY `requirementFeasibility` (`idFeasibility`),
  KEY `requiremenRiskLevel` (`idRiskLevel`),
  KEY `requirementPriority` (`idPriority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resolution`
--

CREATE TABLE `[[dbprefix]]resolution` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `solved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]resolution`
--

INSERT INTO `[[dbprefix]]resolution` VALUES
(1, 'not resolved', 1, '#eeeeee', 10, 0),
(2, 'fixed', 1, '#00ff00', 20, 0),
(3, 'already fixed', 1, '#00ff00', 30, 0),
(4, 'duplicate', 0, '#ff0000', 40, 0),
(5, 'rejected', 0, '#ff0000', 50, 0),
(6, 'support provided', 1, '#00ff00', 60, 0),
(7, 'workaround provided', 1, '#00ff00', 70, 0),
(8, 'evolution done', 1, '#00ff00', 80, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource`
--

CREATE TABLE `[[dbprefix]]resource` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `fullName` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `password` varchar(100) DEFAULT NULL,
  `idProfile` int(12) DEFAULT NULL COMMENT '12',
  `isResource` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isUser` int(1) unsigned DEFAULT '0' COMMENT '1',
  `locked` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `phone` varchar(20) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `idTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  `capacity` decimal(8,5) DEFAULT '1.00000',
  `address` varchar(4000) DEFAULT NULL,
  `isContact` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRole` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isLdap` int(1) unsigned DEFAULT '0' COMMENT '1',
  `initials` varchar(10) DEFAULT NULL,
  `designation` varchar(50) DEFAULT NULL,
  `street` varchar(50) DEFAULT NULL,
  `complement` varchar(50) DEFAULT NULL,
  `zip` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `idRecipient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `loginTry` int(5) unsigned DEFAULT '0' COMMENT '5',
  `salt` varchar(100) DEFAULT NULL,
  `crypto` varchar(100) DEFAULT NULL,
  `idCalendarDefinition` int(12) unsigned DEFAULT '1' COMMENT '12',
  `cookieHash` varchar(400) DEFAULT NULL,
  `passwordChangeDate` date DEFAULT NULL,
  `apiKey` varchar(400) DEFAULT NULL,
  `dontReceiveTeamMails` int(1) unsigned DEFAULT '0' COMMENT '1',
  `contactFunction` varchar(100) DEFAULT NULL,
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOrganization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLanguage` int(12) DEFAULT NULL COMMENT '12',
  `isResourceTeam` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isEmployee` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isLeaveManager` int(1) unsigned DEFAULT '0' COMMENT '1',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `subcontractor` int(1) DEFAULT '0' COMMENT '1',
  `student` int(1) DEFAULT '0' COMMENT '1',
  `maxDailyWork` decimal(9,6) unsigned DEFAULT NULL,
  `maxWeeklyWork` decimal(9,6) unsigned DEFAULT NULL,
  `isMaterial` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mustChangePassword` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dummy` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `userProfile` (`idProfile`),
  KEY `userTeam` (`idTeam`),
  KEY `userIsResource` (`isResource`),
  KEY `userIsUser` (`isUser`),
  KEY `userIsContact` (`isContact`),
  KEY `userRecipient` (`idRecipient`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]resource`
--

INSERT INTO `[[dbprefix]]resource` VALUES
(1, '[[admin_username]]', NULL, NULL, NULL, '[[admin_pass]]', 1, 0, 1, 0, 0, NULL, NULL, NULL, NULL, '1.00000', NULL, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 'md5', 1, NULL, '[[date]]', '[[apiKeyid1]]', 0, NULL, NULL, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, 0, 0, 0),
(2, 'guest', NULL, NULL, NULL, '084e0343a0486ff05530df6c705c8bb4', 5, 0, 1, 0, 0, NULL, NULL, NULL, NULL, '1.00000', NULL, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 'md5', 1, NULL, '[[date]]', '[[apiKeyid2]]', 0, NULL, NULL, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourcecapacity`
--

CREATE TABLE `[[dbprefix]]resourcecapacity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) DEFAULT NULL COMMENT '12',
  `capacity` decimal(8,5) unsigned DEFAULT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resourcevariablecapacity` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourcecost`
--

CREATE TABLE `[[dbprefix]]resourcecost` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRole` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cost` decimal(11,2) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `resourcecostResource` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourceincompatible`
--

CREATE TABLE `[[dbprefix]]resourceincompatible` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idIncompatible` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourceskill`
--

CREATE TABLE `[[dbprefix]]resourceskill` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSkill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSkillLevel` int(12) unsigned DEFAULT NULL COMMENT '12',
  `useSince` date DEFAULT NULL,
  `useUntil` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `comment` varchar(4000) DEFAULT NULL,
  `lastAlertDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourcesupport`
--

CREATE TABLE `[[dbprefix]]resourcesupport` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idSupport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `rate` int(3) unsigned DEFAULT NULL COMMENT '3',
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourcesurbooking`
--

CREATE TABLE `[[dbprefix]]resourcesurbooking` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) DEFAULT NULL COMMENT '12',
  `capacity` decimal(10,2) DEFAULT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resourcevariablesurbooking` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resourceteamaffectation`
--

CREATE TABLE `[[dbprefix]]resourceteamaffectation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResourceTeam` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `rate` int(3) unsigned DEFAULT NULL COMMENT '3',
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]restrictlist`
--

CREATE TABLE `[[dbprefix]]restrictlist` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `showAll` int(1) DEFAULT NULL COMMENT '1',
  `showStarted` int(1) DEFAULT NULL COMMENT '1',
  `showDelivered` int(1) DEFAULT NULL COMMENT '1',
  `showInService` int(1) DEFAULT NULL COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]restricttype`
--

CREATE TABLE `[[dbprefix]]restricttype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProjectType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `className` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `restricttypeProjectType` (`idProjectType`,`className`,`idType`),
  KEY `restricttypeProject` (`idProject`,`className`,`idType`),
  KEY `restricttypeProfile` (`idProfile`,`className`,`idType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]revenuemode`
--

CREATE TABLE `[[dbprefix]]revenuemode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]revenuemode`
--

INSERT INTO `[[dbprefix]]revenuemode` VALUES
(1, 'fixed', 100, 0),
(2, 'variable', 200, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]revisionupdate`
--

CREATE TABLE `[[dbprefix]]revisionupdate` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `revisionId` varchar(100) DEFAULT NULL,
  `version` varchar(100) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `files` varchar(4000) DEFAULT NULL,
  `tickets` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]risk`
--

CREATE TABLE `[[dbprefix]]risk` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idRiskType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cause` mediumtext,
  `impact` mediumtext,
  `idSeverity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLikelihood` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCriticality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialEndDate` date DEFAULT NULL,
  `actualEndDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `impactCost` decimal(11,2) unsigned DEFAULT '0.00',
  `projectReserveAmount` decimal(11,2) unsigned DEFAULT '0.00',
  `mitigationPlan` mediumtext,
  `impactCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  `projectReserveAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `riskProject` (`idProject`),
  KEY `riskUser` (`idUser`),
  KEY `riskResource` (`idResource`),
  KEY `riskStatus` (`idStatus`),
  KEY `riskType` (`idRiskType`),
  KEY `riskSeverity` (`idSeverity`),
  KEY `riskLikelihood` (`idLikelihood`),
  KEY `riskCriticality` (`idCriticality`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]risklevel`
--

CREATE TABLE `[[dbprefix]]risklevel` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]risklevel`
--

INSERT INTO `[[dbprefix]]risklevel` VALUES
(1, 'Very Low', '#00FF00', 100, 0),
(2, 'Low', '#00AAAA', 200, 0),
(3, 'Average', '#AAAAAA', 300, 0),
(4, 'High', '#AAAA00', 400, 0),
(5, 'Very High', '#FF0000', 500, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role`
--

CREATE TABLE `[[dbprefix]]role` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `defaultCost` decimal(9,2) DEFAULT NULL,
  `defaultExternalCost` decimal(9,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]role`
--

INSERT INTO `[[dbprefix]]role` VALUES
(1, 'Manager', 'Leader/Manager of the project', 10, 0, NULL, NULL),
(2, 'Analyst', 'Responsible of specifications', 20, 0, NULL, NULL),
(3, 'Developer', 'Sowftware developer', 30, 0, NULL, NULL),
(4, 'Expert', 'Technical expert', 40, 0, NULL, NULL),
(5, 'Machine', 'Non human resource', 50, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rulableforempcontracttype`
--

CREATE TABLE `[[dbprefix]]rulableforempcontracttype` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `rulableItem` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]rulableforempcontracttype`
--

INSERT INTO `[[dbprefix]]rulableforempcontracttype` VALUES
(1, 'Employee', 'Employee', 0),
(2, 'EmploymentContract', 'EmploymentContract', 0),
(3, 'EmployeeLeaveEarned', 'EmployeeLeaveEarned', 0),
(4, 'Leave', 'Leave', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]runstatus`
--

CREATE TABLE `[[dbprefix]]runstatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]runstatus`
--

INSERT INTO `[[dbprefix]]runstatus` VALUES
(1, 'planned', '#FFFFFF', 200, 0),
(2, 'passed', '#32CD32', 300, 0),
(3, 'failed', '#FF0000', 500, 0),
(4, 'blocked', '#FFA500', 400, 0),
(5, 'notPlanned', '#BB64BB', 100, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]severity`
--

CREATE TABLE `[[dbprefix]]severity` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]severity`
--

INSERT INTO `[[dbprefix]]severity` VALUES
(1, 'Low', 1, '#32cd32', 10, 0),
(2, 'Medium', 2, '#ffd700', 20, 0),
(3, 'High', 4, '#ff0000', 30, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]situation`
--

CREATE TABLE `[[dbprefix]]situation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `situationType` varchar(100) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]situationable`
--

CREATE TABLE `[[dbprefix]]situationable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `type` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]situationable`
--

INSERT INTO `[[dbprefix]]situationable` VALUES
(1, 'CallForTender', 0, 'Expense'),
(2, 'Tender', 0, 'Expense'),
(3, 'ProviderOrder', 0, 'Expense'),
(4, 'ProviderBill', 0, 'Expense'),
(5, 'Bill', 0, 'Income'),
(6, 'Quotation', 0, 'Income'),
(7, 'Command', 0, 'Income');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]skill`
--

CREATE TABLE `[[dbprefix]]skill` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idSkill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sbs` varchar(1000) DEFAULT NULL,
  `sbsSortable` varchar(4000) DEFAULT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]skilllevel`
--

CREATE TABLE `[[dbprefix]]skilllevel` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `weight` decimal(14,5) DEFAULT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]skilllevel`
--

INSERT INTO `[[dbprefix]]skilllevel` VALUES
(1, 'Trained', 10, '1.00000', 'skill_1-4.png', 0),
(2, 'Occasional use', 20, '2.00000', 'skill_2-4.png', 0),
(3, 'Regular use', 30, '3.00000', 'skill_3-4.png', 0),
(4, 'Expert', 40, '5.00000', 'skill_4-4.png', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sla`
--

CREATE TABLE `[[dbprefix]]sla` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTicketType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `durationSla` double DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]status`
--

CREATE TABLE `[[dbprefix]]status` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `setDoneStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setIdleStatus` int(1) unsigned DEFAULT NULL COMMENT '1',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setHandledStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isCopyStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setCancelledStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setIntoserviceStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setSubmittedLeave` int(1) DEFAULT '0' COMMENT '1',
  `setAcceptedLeave` int(1) DEFAULT '0' COMMENT '1',
  `setRejectedLeave` int(1) DEFAULT '0' COMMENT '1',
  `fixPlanning` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setPausedStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  `setAssignedStatus` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]status`
--

INSERT INTO `[[dbprefix]]status` VALUES
(1, 'recorded', 0, 0, '#ffa500', 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(2, 'qualified', 0, 0, '#87ceeb', 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(3, 'in progress', 0, 0, '#d2691e', 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(4, 'done', 1, 0, '#afeeee', 400, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(5, 'verified', 1, 0, '#32cd32', 500, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(6, 'delivered', 1, 0, '#4169e1', 600, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(7, 'closed', 1, 1, '#c0c0c0', 700, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(8, 're-opened', 0, 0, '#ff0000', 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(9, 'cancelled', 0, 1, '#c0c0c0', 999, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0),
(10, 'assigned', 0, 0, '#8b4513', 275, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(11, 'accepted', 0, 0, '#a52a2a', 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(12, 'validated', 1, 0, '#98fb98', 650, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(13, 'prepared', 0, 0, '#d2691e', 290, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(14, 'copied', 0, 0, '#ffffff', 999, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(15, 'paused', 0, 0, '#BABABA', 350, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]statusmail`
--

CREATE TABLE `[[dbprefix]]statusmail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMailable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mailToUser` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToResource` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToContact` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToLeader` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToOther` int(1) unsigned DEFAULT '0' COMMENT '1',
  `otherMail` varchar(4000) DEFAULT NULL,
  `idEventForMail` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mailToManager` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToAssigned` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mailToSubscribers` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToProjectIncludingParentProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) DEFAULT NULL COMMENT '12',
  `isProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mailToAccountable` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idEmailTemplate` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mailToFinancialResponsible` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToContact` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToUser` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToResource` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToProjectIncludingParentProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToLeader` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToManager` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToAccountable` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToAssigned` int(1) unsigned DEFAULT '0' COMMENT '1',
  `alertToSubscribers` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `statusmailStatus` (`idStatus`),
  KEY `statusmailMailable` (`idMailable`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=68 ;

--
-- Dumping data for table `[[dbprefix]]statusmail`
--

INSERT INTO `[[dbprefix]]statusmail` VALUES
(1, 1, 1, 1, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(2, 2, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(3, 11, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(4, 8, 1, 1, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(5, 10, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(6, 3, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(7, 4, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(8, 5, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(9, 6, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(10, 12, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(11, 7, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(12, 9, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(13, 8, 2, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(14, 10, 2, 0, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(15, 3, 2, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(16, 4, 2, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(17, 12, 2, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(18, 7, 2, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(19, 9, 2, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(20, 8, 3, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(21, 10, 3, 0, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(22, 3, 3, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(23, 4, 3, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(24, 12, 3, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(25, 7, 3, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(26, 9, 3, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(27, 8, 4, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(28, 10, 4, 0, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(29, 3, 4, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(30, 4, 4, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(31, 12, 4, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(32, 7, 4, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(33, 9, 4, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(34, 8, 5, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(35, 10, 5, 0, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(36, 3, 5, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(37, 4, 5, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(38, 12, 5, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(39, 7, 5, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(40, 9, 5, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(41, 8, 6, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(42, 10, 6, 0, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(43, 3, 6, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(44, 4, 6, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(45, 12, 6, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(46, 7, 6, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(47, 9, 6, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(48, 13, 7, 0, 0, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(49, 6, 7, 0, 0, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(50, 12, 8, 0, 0, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(51, 9, 8, 0, 0, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(52, 1, 9, 1, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(53, 2, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(54, 11, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(55, 8, 9, 1, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(56, 10, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(57, 3, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(58, 4, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(59, 5, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(60, 6, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(61, 12, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(62, 7, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(63, 9, 9, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(64, 4, 10, 0, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(65, 12, 10, 0, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(66, 3, 11, 0, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(67, 4, 11, 0, 1, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]statusnotification`
--

CREATE TABLE `[[dbprefix]]statusnotification` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]statusnotification`
--

INSERT INTO `[[dbprefix]]statusnotification` VALUES
(1, 'unread', '#ff7f50'),
(2, 'read', '#32CD32');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]statusperiod`
--

CREATE TABLE `[[dbprefix]]statusperiod` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `active` int(1) unsigned DEFAULT NULL COMMENT '1',
  `type` varchar(10) DEFAULT NULL,
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `idStatusStart` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatusEnd` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUserStart` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUserEnd` int(12) unsigned DEFAULT NULL COMMENT '12',
  `duration` varchar(100) DEFAULT NULL,
  `durationOpenTime` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscription`
--

CREATE TABLE `[[dbprefix]]subscription` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idAffectable` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(4000) DEFAULT NULL,
  `isAutoSub` int(1) DEFAULT '0' COMMENT '1',
  `inCopy` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `subscriptionAffectable` (`idAffectable`),
  KEY `subscriptionReference` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subtask`
--

CREATE TABLE `[[dbprefix]]subtask` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTargetProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sortOrder` int(5) unsigned DEFAULT NULL COMMENT '5',
  `name` varchar(4000) DEFAULT NULL,
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `dueDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]suppliercontract`
--

CREATE TABLE `[[dbprefix]]suppliercontract` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `number` varchar(100) DEFAULT NULL,
  `idSupplierContractType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `tenderReference` varchar(100) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `initialContractTerm` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idUnitDurationContract` int(12) unsigned DEFAULT NULL COMMENT '12',
  `endDate` date DEFAULT NULL,
  `noticePeriod` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idUnitDurationNotice` int(12) unsigned DEFAULT NULL COMMENT '12',
  `noticeDate` date DEFAULT NULL,
  `deadlineDate` date DEFAULT NULL,
  `periodicityContract` int(5) unsigned DEFAULT '0' COMMENT '5',
  `periodicityBill` int(5) unsigned DEFAULT '0' COMMENT '5',
  `idRenewal` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContactContract` int(12) unsigned DEFAULT NULL COMMENT '12',
  `phoneNumber` varchar(20) DEFAULT NULL,
  `weekPeriod` time DEFAULT NULL,
  `saturdayPeriod` time DEFAULT NULL,
  `sundayAndOffDayPeriod` time DEFAULT NULL,
  `weekPeriodEnd` time DEFAULT NULL,
  `saturdayPeriodEnd` time DEFAULT NULL,
  `sundayAndOffDayPeriodEnd` time DEFAULT NULL,
  `sla` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]synchronization`
--

CREATE TABLE `[[dbprefix]]synchronization` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `originType` varchar(100) DEFAULT NULL,
  `targetType` varchar(100) DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOrigineType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTargetType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `setActivity` int(1) unsigned DEFAULT '1' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]synchronizeditems`
--

CREATE TABLE `[[dbprefix]]synchronizeditems` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idSynchronization` int(12) unsigned DEFAULT NULL COMMENT '12',
  `ref1Type` varchar(100) DEFAULT NULL,
  `ref1Id` int(12) unsigned DEFAULT NULL COMMENT '12',
  `ref2Type` varchar(100) DEFAULT NULL,
  `ref2Id` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `synchronizeditemsRef1` (`ref1Type`,`ref1Id`),
  KEY `synchronizeditemsRef2` (`ref2Type`,`ref2Id`),
  KEY `synchronizeditemsDefinition` (`idSynchronization`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tagName` (`refType`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]team`
--

CREATE TABLE `[[dbprefix]]team` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tempupdate`
--

CREATE TABLE `[[dbprefix]]tempupdate` (
  `id` int(12) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) DEFAULT NULL COMMENT '12',
  `idOther` int(12) unsigned DEFAULT NULL COMMENT '12',
  `workValue` decimal(8,5) unsigned DEFAULT NULL,
  `costValue` decimal(12,2) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tender`
--

CREATE TABLE `[[dbprefix]]tender` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `idTenderType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCallForTender` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTenderStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idProvider` int(12) unsigned DEFAULT NULL COMMENT '12',
  `externalReference` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `requestDateTime` datetime DEFAULT NULL,
  `expectedTenderDateTime` datetime DEFAULT NULL,
  `receptionDateTime` datetime DEFAULT NULL,
  `evaluationValue` decimal(7,2) DEFAULT NULL,
  `evaluationRank` int(3) DEFAULT NULL COMMENT '3',
  `offerValidityEndDate` date DEFAULT NULL,
  `totalUntaxedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `taxPct` decimal(5,2) DEFAULT NULL,
  `totalTaxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `totalFullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `untaxedAmount` decimal(11,2) unsigned DEFAULT NULL,
  `taxAmount` decimal(11,2) unsigned DEFAULT NULL,
  `fullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `deliveryDelay` varchar(100) DEFAULT NULL,
  `deliveryDate` date DEFAULT NULL,
  `paymentCondition` varchar(100) DEFAULT NULL,
  `evaluation` decimal(7,2) DEFAULT NULL,
  `result` mediumtext,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `doneDate` date DEFAULT NULL,
  `idleDate` date DEFAULT NULL,
  `discountAmount` decimal(11,2) DEFAULT NULL,
  `discountRate` decimal(5,2) DEFAULT NULL,
  `idProjectExpense` int(12) unsigned DEFAULT NULL COMMENT '12',
  `discountFrom` varchar(10) DEFAULT NULL,
  `discountFullAmount` decimal(11,2) unsigned DEFAULT NULL,
  `idSituation` int(12) unsigned DEFAULT NULL COMMENT '12',
  `discountAmountLocal` decimal(11,2) DEFAULT NULL,
  `discountFullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `fullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `taxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalFullAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalTaxAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `totalUntaxedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  `untaxedAmountLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tenderProject` (`idProject`),
  KEY `tenderType` (`idTenderType`),
  KEY `tenderProvider` (`idProvider`),
  KEY `tenderStatusIndex` (`idStatus`),
  KEY `tenderTenderStatus` (`idTenderStatus`),
  KEY `tenderCallForTender` (`idCallForTender`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tenderevaluation`
--

CREATE TABLE `[[dbprefix]]tenderevaluation` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idTenderEvaluationCriteria` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTender` int(12) unsigned DEFAULT NULL COMMENT '12',
  `evaluationValue` decimal(5,2) DEFAULT NULL,
  `comment` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tenderevaluationTenderEvaluationCriteria` (`idTenderEvaluationCriteria`),
  KEY `tenderevaluationTender` (`idTender`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tenderevaluationcriteria`
--

CREATE TABLE `[[dbprefix]]tenderevaluationcriteria` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idCallForTender` int(12) unsigned DEFAULT NULL COMMENT '12',
  `criteriaName` varchar(100) DEFAULT NULL,
  `criteriaMaxValue` int(3) unsigned DEFAULT '10' COMMENT '3',
  `criteriaCoef` int(3) unsigned DEFAULT '1' COMMENT '3',
  PRIMARY KEY (`id`),
  KEY `tenderevaluationcriteriaCallForTender` (`idCallForTender`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tenderstatus`
--

CREATE TABLE `[[dbprefix]]tenderstatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `isWaiting` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isReceived` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isNotSelect` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isSelected` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]tenderstatus`
--

INSERT INTO `[[dbprefix]]tenderstatus` VALUES
(1, 'request to send', '#ffa500', 10, 0, 0, 0, 0, 0),
(2, 'waiting for reply', '#f08080', 20, 1, 0, 0, 0, 0),
(3, 'out of date answer', '#c0c0c0', 30, 0, 1, 1, 0, 0),
(4, 'incomplete file', '#c0c0c0', 40, 0, 1, 1, 0, 0),
(5, 'admissible', '#87ceeb', 50, 0, 1, 0, 0, 0),
(6, 'short list', '#4169e1', 60, 0, 1, 0, 0, 0),
(7, 'not selected', '#c0c0c0', 70, 0, 1, 1, 0, 0),
(8, 'selected', '#98fb98', 80, 0, 1, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]term`
--

CREATE TABLE `[[dbprefix]]term` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `amount` decimal(10,2) DEFAULT NULL,
  `validatedAmount` decimal(10,2) DEFAULT NULL,
  `plannedAmount` decimal(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `validatedDate` date DEFAULT NULL,
  `plannedDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT NULL COMMENT '1',
  `idBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `amountLocal` decimal(10,2) DEFAULT NULL,
  `plannedAmountLocal` decimal(10,2) DEFAULT NULL,
  `validatedAmountLocal` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `termProject` (`idProject`),
  KEY `termBill` (`idBill`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]testcase`
--

CREATE TABLE `[[dbprefix]]testcase` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTestCaseType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `idContext1` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContext2` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContext3` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `idTestCase` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `prerequisite` mediumtext,
  `result` mediumtext,
  `sessionCount` int(5) DEFAULT '0' COMMENT '5',
  `runCount` int(5) DEFAULT '0' COMMENT '5',
  `lastRunDate` date DEFAULT NULL,
  `idRunStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idBusinessFeature` int(12) DEFAULT NULL COMMENT '12',
  `idComponentVersion` int(12) DEFAULT NULL COMMENT '12',
  `plannedWork` decimal(14,5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `testcaseProject` (`idProject`),
  KEY `testcaseProduct` (`idProduct`),
  KEY `testcaseVersion` (`idVersion`),
  KEY `testcaseType` (`idTestCaseType`),
  KEY `testcaseUser` (`idUser`),
  KEY `testcaseTestCase` (`idTestCase`),
  KEY `testcaseStatus` (`idStatus`),
  KEY `testcaseResource` (`idResource`),
  KEY `testcasePriority` (`idPriority`),
  KEY `testcaseRunStatus` (`idRunStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]testcaserun`
--

CREATE TABLE `[[dbprefix]]testcaserun` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idTestCase` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTestSession` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idRunStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTicket` int(12) unsigned DEFAULT NULL COMMENT '12',
  `statusDateTime` datetime DEFAULT NULL,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sortOrder` int(3) DEFAULT '0' COMMENT '3',
  `result` varchar(2000) DEFAULT NULL,
  `idUser` int(12) DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `testcaserunTestCase` (`idTestCase`),
  KEY `testcaserunTestSession` (`idTestSession`),
  KEY `testcaserunRunStatus` (`idRunStatus`),
  KEY `testcaserunTicket` (`idTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]testsession`
--

CREATE TABLE `[[dbprefix]]testsession` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTestSessionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDateTime` datetime DEFAULT NULL,
  `description` mediumtext,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDate` date DEFAULT NULL,
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleDate` date DEFAULT NULL,
  `result` mediumtext,
  `countPassed` int(5) DEFAULT '0' COMMENT '5',
  `countFailed` int(5) DEFAULT '0' COMMENT '5',
  `countBlocked` int(5) DEFAULT '0' COMMENT '5',
  `countTotal` int(5) DEFAULT '0' COMMENT '5',
  `countIssues` int(5) DEFAULT '0' COMMENT '5',
  `countPlanned` int(5) DEFAULT '0' COMMENT '5',
  `idRunStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTestSession` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `sumPlannedWork` decimal(14,5) DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `testsessionProject` (`idProject`),
  KEY `testsessionProduct` (`idProduct`),
  KEY `testsessionVersion` (`idVersion`),
  KEY `testsessionType` (`idTestSessionType`),
  KEY `testsessionUser` (`idUser`),
  KEY `testsessionStatus` (`idStatus`),
  KEY `testsessionResource` (`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]textable`
--

CREATE TABLE `[[dbprefix]]textable` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=47 ;

--
-- Dumping data for table `[[dbprefix]]textable`
--

INSERT INTO `[[dbprefix]]textable` VALUES
(1, 'Action', 0),
(2, 'Activity', 0),
(3, 'Bill', 0),
(4, 'Decision', 0),
(5, 'IndividualExpense', 0),
(6, 'Issue', 0),
(7, 'Meeting', 0),
(8, 'Milestone', 0),
(9, 'Product', 0),
(10, 'Project', 0),
(11, 'ProjectExpense', 0),
(12, 'Question', 0),
(13, 'Requirement', 0),
(14, 'Risk', 0),
(15, 'Term', 0),
(16, 'TestCase', 0),
(17, 'TestSession', 0),
(18, 'Ticket', 0),
(20, 'Quotation', 0),
(21, 'CallForTender', 0),
(22, 'Client', 0),
(23, 'Command', 0),
(24, 'Component', 0),
(25, 'ComponentVersion', 0),
(26, 'Deliverable', 0),
(27, 'Delivery', 0),
(28, 'Document', 0),
(29, 'Incoming', 0),
(30, 'Notification', 0),
(31, 'Opportunity', 0),
(32, 'Organization', 0),
(33, 'Payment', 0),
(34, 'PeriodicMeeting', 0),
(35, 'ProductVersion', 0),
(36, 'Provider', 0),
(37, 'Team', 0),
(38, 'Tender', 0),
(39, 'ActivityPrice', 0),
(40, 'ChangeRequest', 0),
(41, 'SupplierContract', 0),
(42, 'ClientContract', 0),
(43, 'Asset', 0),
(44, 'IncomingMail', 0),
(45, 'OutgoingMail', 0),
(46, 'ActivityExpense', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket`
--

CREATE TABLE `[[dbprefix]]ticket` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTicketType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `description` mediumtext,
  `creationDateTime` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `initialDueDateTime` datetime DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `actualDueDateTime` datetime DEFAULT NULL,
  `idleDateTime` datetime DEFAULT NULL,
  `result` mediumtext,
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idCriticality` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUrgency` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idPriority` int(12) unsigned DEFAULT NULL COMMENT '12',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `doneDateTime` datetime DEFAULT NULL,
  `handled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `handledDateTime` datetime DEFAULT NULL,
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTargetProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOriginalProductVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(100) DEFAULT NULL,
  `externalReference` varchar(100) DEFAULT NULL,
  `idTicket` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContext1` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContext2` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContext3` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `cancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idComponent` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idOriginalComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idTargetComponentVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResolution` int(12) unsigned DEFAULT NULL COMMENT '12',
  `solved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lastUpdateDateTime` datetime DEFAULT NULL,
  `idBusinessFeature` int(12) DEFAULT NULL COMMENT '12',
  `delayReadOnly` int(1) DEFAULT '0' COMMENT '1',
  `isRegression` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idAccountable` int(12) DEFAULT NULL COMMENT '12',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  `paused` int(1) unsigned DEFAULT '0' COMMENT '1',
  `pausedDateTime` datetime DEFAULT NULL,
  `tags` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticketProject` (`idProject`),
  KEY `ticketUser` (`idUser`),
  KEY `ticketResource` (`idResource`),
  KEY `ticketStatus` (`idStatus`),
  KEY `ticketType` (`idTicketType`),
  KEY `ticketActivity` (`idActivity`),
  KEY `ticketUrgency` (`idUrgency`),
  KEY `ticketPriority` (`idPriority`),
  KEY `ticketCriticality` (`idCriticality`),
  KEY `ticketReference` (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]timeline`
--

CREATE TABLE `[[dbprefix]]timeline` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned NOT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]today`
--

CREATE TABLE `[[dbprefix]]today` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `staticSection` varchar(100) DEFAULT NULL,
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `todayUser` (`idUser`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=40 ;

--
-- Dumping data for table `[[dbprefix]]today`
--

INSERT INTO `[[dbprefix]]today` VALUES
(1, 1, 'static', 'Projects', NULL, 1, 0),
(2, 2, 'static', 'Projects', NULL, 1, 0),
(4, 1, 'static', 'AssignedTasks', NULL, 2, 0),
(5, 2, 'static', 'AssignedTasks', NULL, 2, 0),
(7, 1, 'static', 'ResponsibleTasks', NULL, 3, 0),
(8, 2, 'static', 'ResponsibleTasks', NULL, 3, 0),
(10, 1, 'static', 'IssuerRequestorTasks', NULL, 4, 0),
(11, 2, 'static', 'IssuerRequestorTasks', NULL, 4, 0),
(13, 1, 'static', 'ProjectsTasks', NULL, 5, 0),
(14, 2, 'static', 'ProjectsTasks', NULL, 5, 0),
(16, 1, 'static', 'Documents', NULL, 6, 0),
(17, 2, 'static', 'Documents', NULL, 6, 0),
(19, 1, 'static', 'ResponsibleTodoList', NULL, 7, 0),
(20, 2, 'static', 'ResponsibleTodoList', NULL, 7, 0),
(22, 1, 'newGui', 'Projects', NULL, 1, 0),
(23, 2, 'newGui', 'Projects', NULL, 1, 0),
(25, 1, 'newGui', 'Message', NULL, 2, 0),
(26, 2, 'newGui', 'Message', NULL, 2, 0),
(28, 1, 'newGui', 'Documents', NULL, 3, 0),
(29, 2, 'newGui', 'Documents', NULL, 3, 0),
(31, 1, 'newGui', 'Todo', NULL, 4, 0),
(32, 2, 'newGui', 'Todo', NULL, 4, 0),
(34, 1, 'newGui', 'ResponsibleTodoList', NULL, 5, 0),
(35, 2, 'newGui', 'ResponsibleTodoList', NULL, 5, 0),
(37, 1, 'newGui', 'News', NULL, 6, 0),
(38, 2, 'newGui', 'News', NULL, 6, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]todayparameter`
--

CREATE TABLE `[[dbprefix]]todayparameter` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idReport` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idToday` int(12) unsigned DEFAULT NULL COMMENT '12',
  `parameterName` varchar(100) DEFAULT NULL,
  `parameterValue` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `todayParameterUser` (`idUser`),
  KEY `todayParameterReport` (`idReport`),
  KEY `todayParameterToday` (`idToday`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]trend`
--

CREATE TABLE `[[dbprefix]]trend` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `icon` varchar(100) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]trend`
--

INSERT INTO `[[dbprefix]]trend` VALUES
(1, 'increasing', '#32CD32', 100, 'arrowUpGreen.png', 0),
(2, 'even', '#ffd700', 200, 'arrowRightGrey.png', 0),
(3, 'decreasing', '#FF0000', 300, 'arrowDownRed.png', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]type`
--

CREATE TABLE `[[dbprefix]]type` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `scope` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `color` varchar(7) DEFAULT NULL,
  `idWorkflow` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mandatoryDescription` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mandatoryResultOnDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mandatoryResourceOnHandled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lockHandled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lockDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lockIdle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `code` varchar(10) DEFAULT NULL,
  `internalData` varchar(1) DEFAULT NULL,
  `description` mediumtext,
  `lockCancelled` int(1) unsigned DEFAULT '0' COMMENT '1',
  `showInFlash` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idPlanningMode` int(12) unsigned DEFAULT NULL COMMENT '12',
  `mandatoryResolutionOnDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lockSolved` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idCategory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `lockNoLeftOnDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `priority` int(3) unsigned DEFAULT NULL COMMENT '3',
  `lockIntoservice` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lockUseOnlyForCC` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isLeadProject` int(1) unsigned DEFAULT '0' COMMENT '1',
  `icon` varchar(100) DEFAULT NULL,
  `canHaveSubActivity` int(1) unsigned DEFAULT '1' COMMENT '1',
  `activityOnRealTime` int(1) unsigned DEFAULT '0' COMMENT '1',
  `lockPaused` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idStatus` int(12) unsigned DEFAULT NULL,
  `numberDaysBeforeDueDate` int(6) unsigned DEFAULT NULL COMMENT '6',
  `mandatoryContact` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mandatoryRecipient` int(1) unsigned DEFAULT '0' COMMENT '1',
  `mandatorySubTaskOnDone` int(1) unsigned DEFAULT '0' COMMENT '1',
  `defaultDuration` int(5) unsigned DEFAULT NULL COMMENT '5',
  PRIMARY KEY (`id`),
  KEY `typeScope` (`scope`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=209 ;

--
-- Dumping data for table `[[dbprefix]]type`
--

INSERT INTO `[[dbprefix]]type` VALUES
(1, 'Risk', 'Contractual', 10, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'CON', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(2, 'Risk', 'Operational', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'OPE', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(3, 'Risk', 'Technical', 30, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'TEC', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(4, 'Issue', 'Technical issue', 10, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'TEC', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(5, 'Issue', 'Process non conformity', 30, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'PRO', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(6, 'Issue', 'Quality non conformity', 40, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'QUA', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(7, 'Issue', 'Process non appliability', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'PRO', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(8, 'Issue', 'Customer complaint', 90, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'CUS', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(9, 'Issue', 'Delay non respect', 50, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'DEL', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(10, 'Issue', 'Resource management issue', 70, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'RES', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(12, 'Issue', 'Financial loss', 80, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'FIN', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(13, 'Message', 'ALERT', 10, 0, '#ff0000', 1, 0, 1, 1, 1, 1, 1, 'ALE', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(14, 'Message', 'WARNING', 10, 0, '#ffa500', 1, 0, 1, 1, 1, 1, 1, 'WAR', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(15, 'Message', 'INFO', 30, 0, '#0000ff', 1, 0, 1, 1, 1, 1, 1, 'INF', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(16, 'Ticket', 'Incident', 10, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'INC', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 1, NULL, NULL, 0, 0, 0, NULL),
(17, 'Ticket', 'Support / Assistance', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'SUP', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 1, NULL, NULL, 0, 0, 0, NULL),
(18, 'Ticket', 'Anomaly / Bug', 30, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'ANO', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 1, NULL, NULL, 0, 0, 0, NULL),
(19, 'Activity', 'Development', 10, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'DEV', NULL, NULL, 1, 0, 1, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(20, 'Activity', 'Evolution', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'EVO', NULL, NULL, 1, 0, 1, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(21, 'Activity', 'Management', 30, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'MAN', NULL, NULL, 1, 0, 1, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(22, 'Activity', 'Phase', 40, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'PHA', NULL, NULL, 1, 0, 1, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(23, 'Milestone', 'Deliverable', 10, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'DEL', NULL, NULL, 1, 0, 5, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(24, 'Milestone', 'Incoming', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'INC', NULL, NULL, 1, 0, 5, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(25, 'Milestone', 'Key date', 30, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'KEY', NULL, NULL, 1, 0, 5, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(26, 'Activity', 'Task', 1, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'TAS', NULL, NULL, 1, 0, 1, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(27, 'Action', 'Project', 10, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'PRO', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(28, 'Action', 'Internal', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'INT', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(29, 'Action', 'Customer', 20, 0, NULL, 1, 0, 1, 1, 1, 1, 1, 'CUS', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(30, 'Meeting', 'Steering Committee', 10, 0, NULL, 7, 0, 1, 1, 1, 1, 1, 'STE', NULL, NULL, 1, 0, 16, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(31, 'Meeting', 'Progress Metting', 20, 0, NULL, 7, 0, 1, 1, 1, 1, 1, 'PRO', NULL, NULL, 1, 0, 16, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(32, 'Meeting', 'Team meeting', 30, 0, NULL, 7, 0, 1, 1, 1, 1, 1, 'TEA', NULL, NULL, 1, 0, 16, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(33, 'Decision', 'Functional', 10, 0, NULL, 6, 0, 1, 1, 1, 1, 1, 'FUN', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(34, 'Decision', 'Operational', 20, 0, NULL, 6, 0, 1, 1, 1, 1, 1, 'OPE', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(35, 'Decision', 'Contractual', 30, 0, NULL, 6, 0, 1, 1, 1, 1, 1, 'CON', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(36, 'Decision', 'Strategic', 40, 0, NULL, 6, 0, 1, 1, 1, 1, 1, 'STR', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(37, 'Question', 'Functional', 10, 0, NULL, 5, 0, 1, 1, 1, 1, 1, 'FUN', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(38, 'Question', 'Technical', 20, 0, NULL, 5, 0, 1, 1, 1, 1, 1, 'TEC', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(39, 'IndividualExpense', 'Expense report', 10, 0, NULL, 8, 0, 0, 0, 0, 0, 0, 'EXP', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(40, 'ProjectExpense', 'Machine expense', 10, 0, NULL, 8, 0, 0, 0, 0, 0, 0, 'MAC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(41, 'ProjectExpense', 'Office expense', 20, 0, NULL, 8, 0, 0, 0, 0, 0, 0, 'OFF', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(46, 'Payment', 'partial payment', 20, 0, NULL, 8, 0, 0, 0, 0, 0, 0, 'PAR', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(47, 'Payment', 'final payment', 10, 0, NULL, 8, 0, 0, 0, 0, 0, 0, 'FIN', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(48, 'Project', 'Fixed Price', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'OPE', 'E', NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(49, 'Project', 'Time & Materials', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'OPE', 'R', NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(50, 'Project', 'Capped Time & Materials', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'OPE', 'P', NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(51, 'Project', 'Internal', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'OPE', 'N', NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(52, 'Project', 'Administrative', 80, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'ADM', 'N', NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(53, 'Project', 'Template', 90, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'TMP', 'N', NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(54, 'Document', 'Need expression', 210, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'NEEDEXP', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(55, 'Document', 'General Specification', 220, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'GENSPEC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(56, 'Document', 'Detailed Specification', 230, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'DETSPEC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(57, 'Document', 'General Conception', 240, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'GENCON', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(58, 'Document', 'Detail Conception', 250, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'DETCON', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(59, 'Document', 'Test Plan', 260, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'TEST', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(60, 'Document', 'Installaton manual', 270, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'INST', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(61, 'Document', 'Exploitation manual', 280, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'EXPL', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(62, 'Document', 'User manual', 290, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'MANUAL', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(63, 'Document', 'Contract', 110, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'CTRCT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(64, 'Document', 'Management', 120, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'MGT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(65, 'Document', 'Meeting Review', 130, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'MEETREV', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(66, 'Document', 'Follow-up', 140, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'F-UP', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(67, 'Document', 'Financial', 150, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'FIN', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(68, 'Versioning', 'evolutive', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'EVO', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(69, 'Versioning', 'chronological', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'EVT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(70, 'Versioning', 'sequential', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'SEQ', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(71, 'Versioning', 'external', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'EXT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(72, 'Bill', 'Partial bill', 100, 0, NULL, 1, 0, 0, 0, 0, 1, 1, 'PARTIAL', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 1, 1, 0, NULL),
(73, 'Bill', 'Final bill', 200, 0, NULL, 1, 0, 0, 0, 0, 1, 1, 'FINAL', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 1, 1, 0, NULL),
(74, 'Bill', 'Complete bill', 300, 0, NULL, 1, 0, 0, 0, 0, 1, 1, 'COMPLETE', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 1, 1, 0, NULL),
(75, 'Requirement', 'Functional', 10, 0, NULL, 1, 1, 0, 1, 1, 1, 1, 'FUNC', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(76, 'Requirement', 'Technical', 20, 0, NULL, 1, 1, 0, 1, 1, 1, 1, 'TECH', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(77, 'Requirement', 'Security', 30, 0, NULL, 1, 1, 0, 1, 1, 1, 1, 'SECU', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(78, 'Requirement', 'Regulatory', 40, 0, NULL, 1, 1, 0, 1, 1, 1, 1, 'REGL', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(79, 'TestCase', 'Requirement test', 10, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'REQU', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(80, 'TestCase', 'Non regression', 30, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'NR', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(81, 'TestCase', 'Unit test', 20, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'UT', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(82, 'TestSession', 'Evolution test session', 10, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'EVO', NULL, NULL, 1, 0, 9, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(83, 'TestSession', 'Development test session', 20, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'DEV', NULL, NULL, 1, 0, 9, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(84, 'TestSession', 'Non regression test session', 30, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'NR', NULL, NULL, 1, 0, 9, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(85, 'TestSession', 'Unitary case test session', 40, 0, NULL, 1, 1, 1, 1, 1, 1, 1, 'UT', NULL, NULL, 1, 0, 9, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(86, 'Opportunity', 'Contractual', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(87, 'Opportunity', 'Operational', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(88, 'Opportunity', 'Technical', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(89, 'Command', 'Fixed Price', 10, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(90, 'Command', 'Per day', 20, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(91, 'Quotation', 'Fixed Price', 10, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(92, 'Quotation', 'Per day', 20, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(93, 'Quotation', 'Per month', 30, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(94, 'Quotation', 'Per year', 40, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(95, 'Command', 'Per month', 30, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(96, 'Command', 'Per year', 40, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(97, 'Client', 'business prospect', 10, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(98, 'Client', 'customer', 10, 0, NULL, 1, 0, 0, 0, 0, 1, 1, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(99, 'Product', 'software', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(100, 'Product', 'service', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(101, 'Component', 'specific', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(102, 'Component', 'on the shelf', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(103, 'Provider', 'wholesaler', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(104, 'Provider', 'retailer', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(105, 'Provider', 'service provider', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(106, 'Provider', 'subcontractor', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(107, 'Provider', 'central purchasing', 50, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(108, 'CallForTender', 'by mutual agreement', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(109, 'CallForTender', 'adapted procedure', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(110, 'CallForTender', 'open call for tender', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(111, 'CallForTender', 'restricted call for tender', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(112, 'Tender', 'by mutual agreement', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(113, 'Tender', 'adapted procedure', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(114, 'Tender', 'open call for tender', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(115, 'Tender', 'restricted call for tender', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(116, 'Organization', 'Department', 10, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'DEPT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(117, 'Organization', 'Unit', 20, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'UNIT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(118, 'Organization', 'Location', 30, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'LOC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(119, 'ProductVersion', 'Major Version', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'MAJ', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(120, 'ProductVersion', 'Minor Version', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'MIN', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(121, 'ProductVersion', 'Patch', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'PATCH', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(122, 'ComponentVersion', 'Major Version', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'maj', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(123, 'ComponentVersion', 'Minor Version', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'min', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(124, 'ComponentVersion', 'Patch', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'patch', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(125, 'Deliverable', 'document', 10, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'DOC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(126, 'Deliverable', 'software', 20, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'SOFT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(127, 'Deliverable', 'hardware', 30, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'HARD', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(128, 'Incoming', 'document', 10, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'DOC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(129, 'Incoming', 'software', 20, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'SOFT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(130, 'Incoming', 'hardware', 30, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, 'HARD', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(131, 'Catalog', 'Product', NULL, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(132, 'Catalog', 'Service', NULL, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(133, 'Notification', 'ALERT', 10, 0, '#ff0000', NULL, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(134, 'Notification', 'WARNING', 20, 0, '#ffa500', NULL, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(135, 'Notification', 'INFO', 30, 0, '#0000ff', NULL, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(136, 'ProviderOrder', 'Product', 10, 0, NULL, 1, 0, 0, 0, 1, 1, 1, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(137, 'ProviderOrder', 'Service', 20, 0, NULL, 1, 0, 0, 0, 1, 1, 1, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(138, 'ProviderBill', 'Partial bill', 10, 0, NULL, 1, 0, 0, 0, 1, 1, 1, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(139, 'ProviderBill', 'Final bill', 20, 0, NULL, 1, 0, 0, 0, 1, 1, 1, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(140, 'ProviderBill', 'Complete bill', 30, 0, NULL, 1, 0, 0, 0, 1, 1, 1, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(141, 'ProviderPayment', 'event payment', 10, 0, NULL, 8, 0, 0, 0, 1, 1, 0, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(142, 'ProviderPayment', 'partial payment', 20, 0, NULL, 8, 0, 0, 0, 1, 1, 0, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(143, 'ProviderPayment', 'final payment', 30, 0, NULL, 8, 0, 0, 0, 1, 1, 0, NULL, NULL, NULL, 1, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(144, 'Budget', 'Initial', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(145, 'Budget', 'Additional', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(146, 'ChangeRequest', 'recurring problem', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(147, 'ChangeRequest', 'functional improvement', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(148, 'ChangeRequest', 'technical improvement', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(149, 'ChangeRequest', 'regulatory constraint', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(150, 'ChangeRequest', 'process and quality', 50, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(151, 'SupplierContract', 'management assistance', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(152, 'SupplierContract', 'hosting', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(153, 'SupplierContract', 'technical improvement', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(154, 'SupplierContract', 'maintenance & support', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(155, 'ClientContract', 'management assistance', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(156, 'ClientContract', 'hosting', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(157, 'ClientContract', 'technical improvement', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(158, 'ClientContract', 'maintenance & support', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(159, 'Asset', 'Software', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(160, 'Asset', 'Computer', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(161, 'Asset', 'Printer', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(162, 'Asset', 'Server', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(163, 'PokerSession', 'live session', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(164, 'PokerSession', 'session with due date voting', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(165, 'LocalizationRequest', 'standard translation', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, 1, NULL, 0, 0, 0, NULL),
(166, 'LocalizationRequest', 'urgent translation', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, 1, NULL, 0, 0, 0, NULL),
(167, 'LocalizationItem', 'item', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, 1, NULL, 0, 0, 0, NULL),
(168, 'IncomingMail', 'postal mail', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(169, 'IncomingMail', 'email', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(170, 'IncomingMail', 'service note', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(171, 'OutgoingMail', 'postal mail', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(172, 'OutgoingMail', 'email', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(173, 'OutgoingMail', 'service note', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(174, 'Project', 'Proposale', 100, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'PRP', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(175, 'ActivityExpense', 'Expense activity', 10, 0, NULL, 8, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(176, 'LessonLearned', 'resource', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(177, 'LessonLearned', 'organizational', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(178, 'LessonLearned', 'technical', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(179, 'LessonLearned', 'financial', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(180, 'LessonLearned', 'contractual', 50, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(181, 'LessonLearned', 'external', 60, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(182, 'Assumption', 'resource', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(183, 'Assumption', 'organizational', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(184, 'Assumption', 'technical', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(185, 'Assumption', 'financial', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(186, 'Assumption', 'contractual', 50, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(187, 'Assumption', 'external', 60, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(188, 'Constraint', 'resource', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(189, 'Constraint', 'organizational', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(190, 'Constraint', 'technical', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(191, 'Constraint', 'financial', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(192, 'Constraint', 'contractual', 50, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(193, 'Constraint', 'external', 60, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(194, 'Prospect', 'buisiness show', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(195, 'Prospect', 'emailing', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(196, 'Prospect', 'direct', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(197, 'Prospect', 'sponsorship', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(198, 'Prospect', 'unknown', 90, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(199, 'ProspectEvent', 'phone call', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(200, 'ProspectEvent', 'email', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(201, 'ProspectEvent', 'meeting', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(202, 'ProspectEvent', 'buisiness show', 40, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(203, 'ProspectEvent', 'import', 90, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(204, 'Acceptance', 'partial', 10, 1, NULL, NULL, 0, 0, 0, 0, 0, 0, 'PART', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(205, 'Acceptance', 'total', 20, 1, NULL, NULL, 0, 0, 0, 0, 0, 0, 'ALL', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(206, 'Delivery', 'document', 10, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'DOC', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(207, 'Delivery', 'software', 20, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'SOFT', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL),
(208, 'Delivery', 'hardware', 30, 0, NULL, 1, 0, 0, 0, 0, 0, 0, 'HARD', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, NULL, 0, 0, 0, NULL, 1, 0, 0, NULL, NULL, 0, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]unitcontract`
--

CREATE TABLE `[[dbprefix]]unitcontract` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]unitcontract`
--

INSERT INTO `[[dbprefix]]unitcontract` VALUES
(1, 'day', 40, 0),
(2, 'month', 50, 0),
(3, 'year', 60, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]urgency`
--

CREATE TABLE `[[dbprefix]]urgency` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `value` int(3) unsigned DEFAULT NULL COMMENT '3',
  `color` varchar(7) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]urgency`
--

INSERT INTO `[[dbprefix]]urgency` VALUES
(1, 'Blocking', 4, '#ff0000', 30, 0),
(2, 'Urgent', 2, '#ffd700', 20, 0),
(3, 'Not urgent', 1, '#32cd32', 10, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]version`
--

CREATE TABLE `[[dbprefix]]version` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProduct` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idContact` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `creationDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `initialEisDate` date DEFAULT NULL,
  `plannedEisDate` date DEFAULT NULL,
  `realEisDate` date DEFAULT NULL,
  `initialEndDate` date DEFAULT NULL,
  `plannedEndDate` date DEFAULT NULL,
  `realEndDate` date DEFAULT NULL,
  `isEis` int(1) unsigned DEFAULT '0' COMMENT '1',
  `scope` varchar(100) DEFAULT NULL,
  `versionNumber` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersionType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `isStarted` int(1) unsigned DEFAULT '0' COMMENT '1',
  `realStartDate` date DEFAULT NULL,
  `plannedStartDate` date DEFAULT NULL,
  `initialStartDate` date DEFAULT NULL,
  `isDelivered` int(1) unsigned DEFAULT '0' COMMENT '1',
  `realDeliveryDate` date DEFAULT NULL,
  `plannedDeliveryDate` date DEFAULT NULL,
  `initialDeliveryDate` date DEFAULT NULL,
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idMilestone` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`),
  KEY `versionProduct` (`idProduct`),
  KEY `versionContact` (`idContact`),
  KEY `versionResource` (`idResource`),
  KEY `versionVersionType` (`idVersionType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]versioncompatibility`
--

CREATE TABLE `[[dbprefix]]versioncompatibility` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idVersionA` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersionB` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) DEFAULT '0' COMMENT '1',
  `comment` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]versioncontext`
--

CREATE TABLE `[[dbprefix]]versioncontext` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `idContext` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date NOT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]versionlanguage`
--

CREATE TABLE `[[dbprefix]]versionlanguage` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `idLanguage` int(12) unsigned DEFAULT NULL COMMENT '12',
  `creationDate` date NOT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]versionproject`
--

CREATE TABLE `[[dbprefix]]versionproject` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVersion` int(12) unsigned DEFAULT NULL COMMENT '12',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `versionprojectProject` (`idProject`),
  KEY `versionprojectVersion` (`idVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]visibilityscope`
--

CREATE TABLE `[[dbprefix]]visibilityscope` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `accessCode` varchar(3) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]visibilityscope`
--

INSERT INTO `[[dbprefix]]visibilityscope` VALUES
(1, 'visibilityScopeNo', 'NO', 100, 0),
(2, 'visibilityScopeValid', 'VAL', 200, 0),
(4, 'visibilityScopeAll', 'ALL', 400, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]voting`
--

CREATE TABLE `[[dbprefix]]voting` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVoter` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idNote` int(12) unsigned DEFAULT NULL COMMENT '12',
  `value` int(5) DEFAULT NULL COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votingattribution`
--

CREATE TABLE `[[dbprefix]]votingattribution` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idVotingAttributionRule` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClient` int(12) unsigned DEFAULT NULL COMMENT '12',
  `totalValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `usedValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `leftValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `lastAttributionDate` date DEFAULT NULL,
  `endAttributionDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votingattributionrule`
--

CREATE TABLE `[[dbprefix]]votingattributionrule` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `refType` varchar(100) DEFAULT NULL,
  `fixValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `dailyValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `weeklyValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `monthlyValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `yearlyValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `limitValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votingitem`
--

CREATE TABLE `[[dbprefix]]votingitem` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `targetValue` int(5) unsigned DEFAULT NULL COMMENT '5',
  `actualValue` int(5) DEFAULT NULL COMMENT '5',
  `pctRate` int(3) unsigned DEFAULT NULL COMMENT '3',
  `locked` int(1) unsigned DEFAULT '0' COMMENT '1',
  `nbVoted` int(5) DEFAULT NULL COMMENT '5',
  PRIMARY KEY (`id`),
  UNIQUE KEY `votingItemId` (`refType`,`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votinguserule`
--

CREATE TABLE `[[dbprefix]]votinguserule` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `idType` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatus` int(12) unsigned DEFAULT NULL COMMENT '12',
  `workPointConvertion` decimal(5,2) unsigned DEFAULT NULL,
  `fixValue` decimal(7,2) unsigned DEFAULT NULL,
  `maxPointsPerUser` int(5) unsigned DEFAULT NULL COMMENT '5',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `isDownVoting` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]waitingupdate`
--

CREATE TABLE `[[dbprefix]]waitingupdate` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `scope` varchar(100) DEFAULT NULL,
  `itemId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `parameter` varchar(100) DEFAULT NULL,
  `storeDateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]weightmode`
--

CREATE TABLE `[[dbprefix]]weightmode` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT NULL COMMENT '3',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]weightmode`
--

INSERT INTO `[[dbprefix]]weightmode` VALUES
(1, 'manual', 100, 0),
(2, 'consolidated', 200, 0),
(3, 'UO', 300, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]work`
--

CREATE TABLE `[[dbprefix]]work` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAssignment` int(12) unsigned DEFAULT NULL COMMENT '12',
  `work` decimal(8,5) unsigned DEFAULT NULL,
  `workDate` date DEFAULT NULL,
  `day` varchar(8) DEFAULT NULL,
  `week` varchar(6) DEFAULT NULL,
  `month` varchar(6) DEFAULT NULL,
  `year` varchar(4) DEFAULT NULL,
  `dailyCost` decimal(11,2) unsigned DEFAULT NULL,
  `cost` decimal(11,2) DEFAULT NULL,
  `idBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkElement` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idLeave` int(12) unsigned DEFAULT NULL COMMENT '12',
  `inputUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `inputDateTime` datetime DEFAULT NULL,
  `isManual` int(1) unsigned DEFAULT '0' COMMENT '1',
  `costLocal` decimal(11,2) DEFAULT NULL,
  `dailyCostLocal` decimal(11,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `workReference` (`idAssignment`,`workDate`,`idWorkElement`),
  KEY `workDay` (`day`),
  KEY `workWeek` (`week`),
  KEY `workMonth` (`month`),
  KEY `workYear` (`year`),
  KEY `workRef` (`refType`,`refId`),
  KEY `workResource` (`idResource`),
  KEY `workAssignment` (`idAssignment`),
  KEY `workBill` (`idBill`),
  KEY `workWorkelement` (`idWorkElement`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workcategory`
--

CREATE TABLE `[[dbprefix]]workcategory` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) unsigned DEFAULT '0' COMMENT '3',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workcommand`
--

CREATE TABLE `[[dbprefix]]workcommand` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idComplexity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(200) DEFAULT NULL,
  `unitAmount` decimal(14,2) DEFAULT NULL,
  `commandQuantity` decimal(8,3) DEFAULT NULL,
  `commandAmount` decimal(14,2) DEFAULT NULL,
  `doneQuantity` decimal(8,3) DEFAULT NULL,
  `doneAmount` decimal(14,2) DEFAULT NULL,
  `billedQuantity` decimal(8,3) DEFAULT NULL,
  `billedAmount` decimal(14,2) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `unitAmountLocal` decimal(11,2) DEFAULT NULL,
  `commandAmountLocal` decimal(11,2) DEFAULT NULL,
  `doneAmountLocal` decimal(11,2) DEFAULT NULL,
  `billedAmountLocal` decimal(11,2) DEFAULT NULL,
  `acceptedAmountLocal` decimal(11,2) DEFAULT NULL,
  `acceptedQuantity` decimal(8,3) DEFAULT NULL,
  `acceptedAmount` decimal(14,2) DEFAULT NULL,
  `idWorkCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `elementary` int(1) unsigned DEFAULT '1' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workcommandaccepted`
--

CREATE TABLE `[[dbprefix]]workcommandaccepted` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `acceptedQuantity` decimal(8,3) DEFAULT NULL,
  `idActivityWorkUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idAcceptance` int(10) unsigned DEFAULT NULL COMMENT '12',
  `acceptedDate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workcommandbilled`
--

CREATE TABLE `[[dbprefix]]workcommandbilled` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idBill` int(12) unsigned DEFAULT NULL COMMENT '12',
  `billedQuantity` decimal(8,3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workcommanddone`
--

CREATE TABLE `[[dbprefix]]workcommanddone` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkCommand` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `doneQuantity` decimal(8,3) DEFAULT NULL,
  `idActivityWorkUnit` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workdetail`
--

CREATE TABLE `[[dbprefix]]workdetail` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idWork` int(12) unsigned DEFAULT NULL COMMENT '12',
  `work` decimal(8,5) DEFAULT NULL,
  `idWorkCategory` int(12) unsigned DEFAULT NULL COMMENT '12',
  `uncertainties` varchar(4000) DEFAULT NULL,
  `progress` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workelement`
--

CREATE TABLE `[[dbprefix]]workelement` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `refType` varchar(100) DEFAULT NULL,
  `refId` int(12) unsigned DEFAULT NULL COMMENT '12',
  `refName` varchar(200) DEFAULT NULL,
  `plannedWork` decimal(9,5) unsigned DEFAULT '0.00000',
  `realWork` decimal(9,5) unsigned DEFAULT '0.00000',
  `leftWork` decimal(9,5) unsigned DEFAULT '0.00000',
  `done` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `ongoing` int(1) unsigned DEFAULT '0' COMMENT '1',
  `ongoingStartDateTime` datetime DEFAULT NULL,
  `idUser` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idActivity` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `realCost` decimal(11,2) DEFAULT NULL,
  `leftCost` decimal(11,2) DEFAULT NULL,
  `tokenUsed` decimal(5,2) DEFAULT NULL,
  `tokenBillable` decimal(5,2) DEFAULT NULL,
  `leftCostLocal` decimal(11,2) DEFAULT NULL,
  `realCostLocal` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `workelementReference` (`refType`,`refId`),
  KEY `workelementUser` (`idUser`),
  KEY `workelementActivity` (`idActivity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflow`
--

CREATE TABLE `[[dbprefix]]workflow` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` mediumtext,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `workflowUpdate` varchar(100) DEFAULT NULL,
  `sortOrder` int(3) DEFAULT NULL COMMENT '3',
  `isLeaveWorkflow` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]workflow`
--

INSERT INTO `[[dbprefix]]workflow` VALUES
(1, 'Default', 'Default workflow with just logic constraints.\nAnyone can change status.', 0, '[     ]', NULL, 0),
(2, 'Simple', 'Simple workflow with limited status.\nAnyone can change status.', 0, '[      ]', NULL, 0),
(3, 'External validation', 'Elaborated workflow with internal team treatment and external validation.', 0, '[      ]', NULL, 0),
(4, 'External acceptation & validation', 'Elaborated workflow with external acceptation, internal team treatment and external validation.', 0, '[     ]', NULL, 0),
(5, 'Simple with validation', 'Simple workflow with limited status, including validation.\nAnyone can change status.', 0, '[     ]', NULL, 0),
(6, 'Validation', 'Short workflow with only validation or cancel possibility.\nRestricted validation rights.', 0, '[      ]', NULL, 0),
(7, 'Simple with preparation', 'Simple workflow with limited status, including preparation.\nAnyone can change status.', 0, '[     ]', NULL, 0),
(8, 'Simple with Project Leader validation', 'Simple workflow with limited status, including Project Leader validation.\nAnyone can change status, except validation : only Project Leader.', 0, '[     ]', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflowprofile`
--

CREATE TABLE `[[dbprefix]]workflowprofile` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idWorkflow` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `checked` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workflowstatus`
--

CREATE TABLE `[[dbprefix]]workflowstatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idWorkflow` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatusFrom` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idStatusTo` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idProfile` int(12) unsigned DEFAULT NULL COMMENT '12',
  `allowed` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `workflowstatusReference` (`idWorkflow`,`idStatusFrom`,`idStatusTo`,`idProfile`),
  KEY `workflowstatusProfile` (`idProfile`),
  KEY `workflowstatusWorkflow` (`idWorkflow`),
  KEY `workflowstatusStatusFrom` (`idStatusFrom`),
  KEY `workflowstatusStatusTo` (`idStatusTo`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=679 ;

--
-- Dumping data for table `[[dbprefix]]workflowstatus`
--

INSERT INTO `[[dbprefix]]workflowstatus` VALUES
(1, 0, 1, 8, 1, 1),
(2, 0, 1, 8, 2, 1),
(3, 0, 1, 8, 3, 1),
(4, 3, 1, 2, 4, 1),
(5, 1, 1, 11, 3, 1),
(6, 1, 1, 11, 4, 1),
(7, 1, 1, 11, 6, 1),
(8, 1, 1, 11, 7, 1),
(9, 1, 1, 11, 5, 1),
(10, 1, 1, 10, 1, 1),
(11, 1, 1, 10, 2, 1),
(12, 1, 1, 10, 3, 1),
(13, 1, 1, 10, 4, 1),
(14, 1, 1, 10, 6, 1),
(15, 1, 1, 10, 7, 1),
(16, 1, 1, 10, 5, 1),
(17, 1, 1, 11, 1, 1),
(18, 1, 1, 11, 2, 1),
(19, 1, 2, 10, 1, 1),
(20, 1, 2, 3, 1, 1),
(21, 1, 2, 3, 2, 1),
(22, 1, 2, 3, 3, 1),
(23, 1, 2, 3, 4, 1),
(24, 1, 2, 3, 6, 1),
(25, 1, 2, 3, 7, 1),
(26, 1, 2, 3, 5, 1),
(27, 2, 1, 10, 1, 1),
(28, 2, 1, 10, 2, 1),
(29, 2, 1, 10, 3, 1),
(30, 2, 1, 10, 4, 1),
(31, 2, 1, 10, 6, 1),
(32, 2, 1, 10, 7, 1),
(33, 2, 1, 10, 5, 1),
(34, 1, 1, 3, 1, 1),
(35, 1, 1, 3, 4, 1),
(36, 1, 1, 4, 3, 1),
(37, 1, 1, 2, 3, 1),
(38, 1, 1, 2, 7, 1),
(39, 1, 1, 4, 2, 1),
(40, 1, 1, 3, 2, 1),
(41, 1, 1, 3, 7, 1),
(42, 1, 1, 3, 3, 1),
(43, 1, 1, 4, 4, 1),
(44, 1, 1, 4, 1, 1),
(45, 1, 1, 4, 7, 1),
(46, 3, 1, 10, 3, 1),
(47, 3, 1, 10, 4, 1),
(48, 3, 1, 3, 3, 1),
(49, 3, 1, 3, 4, 1),
(71, 1, 4, 5, 2, 1),
(72, 1, 4, 5, 3, 1),
(73, 1, 4, 5, 4, 1),
(74, 1, 4, 5, 6, 1),
(75, 1, 4, 5, 7, 1),
(76, 1, 4, 5, 5, 1),
(77, 1, 1, 2, 1, 1),
(78, 1, 1, 2, 2, 1),
(79, 1, 1, 2, 4, 1),
(80, 1, 1, 2, 6, 1),
(81, 1, 1, 2, 5, 1),
(82, 1, 1, 3, 6, 1),
(83, 1, 1, 3, 5, 1),
(84, 1, 1, 4, 6, 1),
(85, 1, 1, 4, 5, 1),
(86, 1, 1, 9, 1, 1),
(87, 1, 1, 9, 2, 1),
(88, 1, 1, 9, 3, 1),
(89, 1, 1, 9, 4, 1),
(90, 1, 1, 9, 6, 1),
(91, 1, 1, 9, 7, 1),
(92, 1, 1, 9, 5, 1),
(93, 1, 2, 11, 1, 1),
(94, 1, 2, 11, 2, 1),
(95, 1, 2, 11, 3, 1),
(96, 1, 2, 11, 4, 1),
(97, 1, 2, 11, 6, 1),
(98, 1, 2, 11, 7, 1),
(99, 1, 2, 11, 5, 1),
(100, 1, 2, 10, 2, 1),
(101, 1, 2, 10, 3, 1),
(102, 1, 2, 10, 4, 1),
(103, 1, 2, 10, 6, 1),
(104, 1, 2, 10, 7, 1),
(105, 1, 2, 10, 5, 1),
(106, 1, 2, 4, 1, 1),
(107, 1, 2, 4, 2, 1),
(108, 1, 2, 4, 3, 1),
(109, 1, 2, 4, 4, 1),
(110, 1, 2, 4, 6, 1),
(111, 1, 2, 4, 7, 1),
(112, 1, 2, 4, 5, 1),
(113, 1, 2, 9, 1, 1),
(114, 1, 2, 9, 2, 1),
(115, 1, 2, 9, 3, 1),
(116, 1, 2, 9, 4, 1),
(117, 1, 2, 9, 6, 1),
(118, 1, 2, 9, 7, 1),
(119, 1, 2, 9, 5, 1),
(120, 1, 11, 10, 1, 1),
(121, 1, 11, 10, 2, 1),
(122, 1, 11, 10, 3, 1),
(123, 1, 11, 10, 4, 1),
(124, 1, 11, 10, 6, 1),
(125, 1, 11, 10, 7, 1),
(126, 1, 11, 10, 5, 1),
(127, 1, 11, 3, 1, 1),
(128, 1, 11, 3, 2, 1),
(129, 1, 11, 3, 3, 1),
(130, 1, 11, 3, 4, 1),
(131, 1, 11, 3, 6, 1),
(132, 1, 11, 3, 7, 1),
(133, 1, 11, 3, 5, 1),
(134, 1, 11, 4, 1, 1),
(135, 1, 11, 4, 2, 1),
(136, 1, 11, 4, 3, 1),
(137, 1, 11, 4, 4, 1),
(138, 1, 11, 4, 6, 1),
(139, 1, 11, 4, 7, 1),
(140, 1, 11, 4, 5, 1),
(141, 1, 11, 9, 1, 1),
(142, 1, 11, 9, 2, 1),
(143, 1, 11, 9, 3, 1),
(144, 1, 11, 9, 4, 1),
(145, 1, 11, 9, 6, 1),
(146, 1, 11, 9, 7, 1),
(147, 1, 11, 9, 5, 1),
(148, 1, 8, 10, 1, 1),
(149, 1, 8, 10, 2, 1),
(150, 1, 8, 10, 3, 1),
(151, 1, 8, 10, 4, 1),
(152, 1, 8, 10, 6, 1),
(153, 1, 8, 10, 7, 1),
(154, 1, 8, 10, 5, 1),
(155, 1, 8, 3, 1, 1),
(156, 1, 8, 3, 2, 1),
(157, 1, 8, 3, 3, 1),
(158, 1, 8, 3, 4, 1),
(159, 1, 8, 3, 6, 1),
(160, 1, 8, 3, 7, 1),
(161, 1, 8, 3, 5, 1),
(162, 1, 8, 4, 1, 1),
(163, 1, 8, 4, 2, 1),
(164, 1, 8, 4, 3, 1),
(165, 1, 8, 4, 4, 1),
(166, 1, 8, 4, 6, 1),
(167, 1, 8, 4, 7, 1),
(168, 1, 8, 4, 5, 1),
(169, 1, 8, 5, 1, 1),
(170, 1, 8, 5, 2, 1),
(171, 1, 8, 5, 3, 1),
(172, 1, 8, 5, 4, 1),
(173, 1, 8, 5, 6, 1),
(174, 1, 8, 5, 7, 1),
(175, 1, 8, 5, 5, 1),
(176, 1, 8, 6, 1, 1),
(177, 1, 8, 6, 2, 1),
(178, 1, 8, 6, 3, 1),
(179, 1, 8, 6, 4, 1),
(180, 1, 8, 6, 6, 1),
(181, 1, 8, 6, 7, 1),
(182, 1, 8, 6, 5, 1),
(183, 1, 8, 12, 1, 1),
(184, 1, 8, 12, 2, 1),
(185, 1, 8, 12, 3, 1),
(186, 1, 8, 12, 4, 1),
(187, 1, 8, 12, 6, 1),
(188, 1, 8, 12, 7, 1),
(189, 1, 8, 12, 5, 1),
(190, 1, 8, 7, 1, 1),
(191, 1, 8, 7, 2, 1),
(192, 1, 8, 7, 3, 1),
(193, 1, 8, 7, 4, 1),
(194, 1, 8, 7, 6, 1),
(195, 1, 8, 7, 7, 1),
(196, 1, 8, 7, 5, 1),
(197, 1, 8, 9, 1, 1),
(198, 1, 8, 9, 2, 1),
(199, 1, 8, 9, 3, 1),
(200, 1, 8, 9, 4, 1),
(201, 1, 8, 9, 6, 1),
(202, 1, 8, 9, 7, 1),
(203, 1, 8, 9, 5, 1),
(204, 1, 10, 3, 1, 1),
(205, 1, 10, 3, 2, 1),
(206, 1, 10, 3, 3, 1),
(207, 1, 10, 3, 4, 1),
(208, 1, 10, 3, 6, 1),
(209, 1, 10, 3, 7, 1),
(210, 1, 10, 3, 5, 1),
(211, 1, 10, 4, 1, 1),
(212, 1, 10, 4, 2, 1),
(213, 1, 10, 4, 3, 1),
(214, 1, 10, 4, 4, 1),
(215, 1, 10, 4, 6, 1),
(216, 1, 10, 4, 7, 1),
(217, 1, 10, 4, 5, 1),
(218, 1, 10, 9, 1, 1),
(219, 1, 10, 9, 2, 1),
(220, 1, 10, 9, 3, 1),
(221, 1, 10, 9, 4, 1),
(222, 1, 10, 9, 6, 1),
(223, 1, 10, 9, 7, 1),
(224, 1, 10, 9, 5, 1),
(225, 1, 3, 4, 1, 1),
(226, 1, 3, 4, 2, 1),
(227, 1, 3, 4, 3, 1),
(228, 1, 3, 4, 4, 1),
(229, 1, 3, 4, 6, 1),
(230, 1, 3, 4, 7, 1),
(231, 1, 3, 4, 5, 1),
(232, 1, 3, 9, 1, 1),
(233, 1, 3, 9, 2, 1),
(234, 1, 3, 9, 3, 1),
(235, 1, 3, 9, 4, 1),
(236, 1, 3, 9, 6, 1),
(237, 1, 3, 9, 7, 1),
(238, 1, 3, 9, 5, 1),
(239, 1, 4, 8, 1, 1),
(240, 1, 4, 8, 2, 1),
(241, 1, 4, 8, 3, 1),
(242, 1, 4, 8, 4, 1),
(243, 1, 4, 8, 6, 1),
(244, 1, 4, 8, 7, 1),
(245, 1, 4, 8, 5, 1),
(246, 1, 4, 5, 1, 1),
(247, 1, 4, 6, 1, 1),
(248, 1, 4, 6, 2, 1),
(249, 1, 4, 6, 3, 1),
(250, 1, 4, 6, 4, 1),
(251, 1, 4, 6, 6, 1),
(252, 1, 4, 6, 7, 1),
(253, 1, 4, 6, 5, 1),
(254, 1, 4, 12, 1, 1),
(255, 1, 4, 12, 2, 1),
(256, 1, 4, 12, 3, 1),
(257, 1, 4, 12, 4, 1),
(258, 1, 4, 12, 6, 1),
(259, 1, 4, 12, 7, 1),
(260, 1, 4, 12, 5, 1),
(261, 1, 4, 7, 1, 1),
(262, 1, 4, 7, 2, 1),
(263, 1, 4, 7, 3, 1),
(264, 1, 4, 7, 4, 1),
(265, 1, 4, 7, 6, 1),
(266, 1, 4, 7, 7, 1),
(267, 1, 4, 7, 5, 1),
(268, 1, 5, 8, 1, 1),
(269, 1, 5, 8, 2, 1),
(270, 1, 5, 8, 3, 1),
(271, 1, 5, 8, 4, 1),
(272, 1, 5, 8, 6, 1),
(273, 1, 5, 8, 7, 1),
(274, 1, 5, 8, 5, 1),
(275, 1, 5, 6, 1, 1),
(276, 1, 5, 6, 2, 1),
(277, 1, 5, 6, 3, 1),
(278, 1, 5, 6, 4, 1),
(279, 1, 5, 6, 6, 1),
(280, 1, 5, 6, 7, 1),
(281, 1, 5, 6, 5, 1),
(282, 1, 5, 12, 1, 1),
(283, 1, 5, 12, 2, 1),
(284, 1, 5, 12, 3, 1),
(285, 1, 5, 12, 4, 1),
(286, 1, 5, 12, 6, 1),
(287, 1, 5, 12, 7, 1),
(288, 1, 5, 12, 5, 1),
(289, 1, 5, 7, 1, 1),
(290, 1, 5, 7, 2, 1),
(291, 1, 5, 7, 3, 1),
(292, 1, 5, 7, 4, 1),
(293, 1, 5, 7, 6, 1),
(294, 1, 5, 7, 7, 1),
(295, 1, 5, 7, 5, 1),
(296, 1, 6, 8, 1, 1),
(297, 1, 6, 8, 2, 1),
(298, 1, 6, 8, 3, 1),
(299, 1, 6, 8, 4, 1),
(300, 1, 6, 8, 6, 1),
(301, 1, 6, 8, 7, 1),
(302, 1, 6, 8, 5, 1),
(303, 1, 6, 12, 1, 1),
(304, 1, 6, 12, 2, 1),
(305, 1, 6, 12, 3, 1),
(306, 1, 6, 12, 4, 1),
(307, 1, 6, 12, 6, 1),
(308, 1, 6, 12, 7, 1),
(309, 1, 6, 12, 5, 1),
(310, 1, 6, 7, 1, 1),
(311, 1, 6, 7, 2, 1),
(312, 1, 6, 7, 3, 1),
(313, 1, 6, 7, 4, 1),
(314, 1, 6, 7, 6, 1),
(315, 1, 6, 7, 7, 1),
(316, 1, 6, 7, 5, 1),
(317, 1, 12, 8, 1, 1),
(318, 1, 12, 8, 2, 1),
(319, 1, 12, 8, 3, 1),
(320, 1, 12, 8, 4, 1),
(321, 1, 12, 8, 6, 1),
(322, 1, 12, 8, 7, 1),
(323, 1, 12, 8, 5, 1),
(324, 1, 12, 7, 1, 1),
(325, 1, 12, 7, 2, 1),
(326, 1, 12, 7, 3, 1),
(327, 1, 12, 7, 4, 1),
(328, 1, 12, 7, 6, 1),
(329, 1, 12, 7, 7, 1),
(330, 1, 12, 7, 5, 1),
(331, 1, 7, 8, 1, 1),
(332, 1, 7, 8, 2, 1),
(333, 1, 7, 8, 3, 1),
(334, 1, 7, 8, 4, 1),
(335, 1, 7, 8, 6, 1),
(336, 1, 7, 8, 7, 1),
(337, 1, 7, 8, 5, 1),
(338, 1, 9, 8, 1, 1),
(339, 1, 9, 8, 2, 1),
(340, 1, 9, 8, 3, 1),
(341, 1, 9, 8, 4, 1),
(342, 1, 9, 8, 6, 1),
(343, 1, 9, 8, 7, 1),
(344, 1, 9, 8, 5, 1),
(345, 2, 1, 9, 1, 1),
(346, 2, 1, 9, 2, 1),
(347, 2, 1, 9, 3, 1),
(348, 2, 1, 9, 4, 1),
(349, 2, 1, 9, 6, 1),
(350, 2, 1, 9, 7, 1),
(351, 2, 1, 9, 5, 1),
(352, 2, 8, 10, 1, 1),
(353, 2, 8, 10, 2, 1),
(354, 2, 8, 10, 3, 1),
(355, 2, 8, 10, 4, 1),
(356, 2, 8, 10, 6, 1),
(357, 2, 8, 10, 7, 1),
(358, 2, 8, 10, 5, 1),
(359, 2, 8, 9, 1, 1),
(360, 2, 8, 9, 2, 1),
(361, 2, 8, 9, 3, 1),
(362, 2, 8, 9, 4, 1),
(363, 2, 8, 9, 6, 1),
(364, 2, 8, 9, 7, 1),
(365, 2, 8, 9, 5, 1),
(366, 2, 10, 3, 1, 1),
(367, 2, 10, 3, 2, 1),
(368, 2, 10, 3, 3, 1),
(369, 2, 10, 3, 4, 1),
(370, 2, 10, 3, 6, 1),
(371, 2, 10, 3, 7, 1),
(372, 2, 10, 3, 5, 1),
(373, 2, 10, 9, 1, 1),
(374, 2, 10, 9, 2, 1),
(375, 2, 10, 9, 3, 1),
(376, 2, 10, 9, 4, 1),
(377, 2, 10, 9, 6, 1),
(378, 2, 10, 9, 7, 1),
(379, 2, 10, 9, 5, 1),
(380, 2, 3, 4, 1, 1),
(381, 2, 3, 4, 2, 1),
(382, 2, 3, 4, 3, 1),
(383, 2, 3, 4, 4, 1),
(384, 2, 3, 4, 6, 1),
(385, 2, 3, 4, 7, 1),
(386, 2, 3, 4, 5, 1),
(387, 2, 3, 9, 1, 1),
(388, 2, 3, 9, 2, 1),
(389, 2, 3, 9, 3, 1),
(390, 2, 3, 9, 4, 1),
(391, 2, 3, 9, 6, 1),
(392, 2, 3, 9, 7, 1),
(393, 2, 3, 9, 5, 1),
(394, 2, 4, 8, 1, 1),
(395, 2, 4, 8, 2, 1),
(396, 2, 4, 8, 3, 1),
(397, 2, 4, 8, 4, 1),
(398, 2, 4, 8, 6, 1),
(399, 2, 4, 8, 7, 1),
(400, 2, 4, 8, 5, 1),
(401, 2, 4, 7, 1, 1),
(402, 2, 4, 7, 2, 1),
(403, 2, 4, 7, 3, 1),
(404, 2, 4, 7, 4, 1),
(405, 2, 4, 7, 6, 1),
(406, 2, 4, 7, 7, 1),
(407, 2, 4, 7, 5, 1),
(408, 2, 7, 8, 1, 1),
(409, 2, 7, 8, 2, 1),
(410, 2, 7, 8, 3, 1),
(411, 2, 7, 8, 4, 1),
(412, 2, 7, 8, 6, 1),
(413, 2, 7, 8, 7, 1),
(414, 2, 7, 8, 5, 1),
(415, 2, 9, 8, 1, 1),
(416, 2, 9, 8, 2, 1),
(417, 2, 9, 8, 3, 1),
(418, 2, 9, 8, 4, 1),
(419, 2, 9, 8, 6, 1),
(420, 2, 9, 8, 7, 1),
(421, 2, 9, 8, 5, 1),
(422, 3, 1, 2, 3, 1),
(423, 3, 1, 9, 3, 1),
(424, 3, 1, 9, 4, 1),
(425, 3, 2, 10, 3, 1),
(426, 3, 2, 10, 4, 1),
(427, 3, 2, 3, 3, 1),
(428, 3, 2, 3, 4, 1),
(429, 3, 2, 9, 3, 1),
(430, 3, 2, 9, 4, 1),
(431, 3, 8, 10, 3, 1),
(432, 3, 8, 10, 4, 1),
(433, 3, 8, 3, 3, 1),
(434, 3, 8, 3, 4, 1),
(435, 3, 8, 9, 3, 1),
(436, 3, 8, 9, 4, 1),
(437, 3, 10, 3, 3, 1),
(438, 3, 10, 3, 4, 1),
(439, 3, 10, 9, 3, 1),
(440, 3, 10, 9, 4, 1),
(441, 3, 3, 4, 3, 1),
(442, 3, 3, 4, 4, 1),
(443, 3, 3, 9, 3, 1),
(444, 3, 3, 9, 4, 1),
(445, 3, 4, 3, 3, 1),
(446, 3, 4, 3, 4, 1),
(447, 3, 4, 5, 3, 1),
(448, 3, 4, 5, 4, 1),
(449, 3, 4, 6, 3, 1),
(450, 3, 5, 6, 3, 1),
(451, 3, 6, 8, 6, 1),
(452, 3, 6, 8, 7, 1),
(453, 3, 6, 12, 6, 1),
(454, 3, 6, 12, 7, 1),
(455, 3, 12, 7, 3, 1),
(456, 3, 12, 7, 4, 1),
(457, 3, 12, 7, 6, 1),
(458, 3, 12, 7, 7, 1),
(459, 3, 7, 8, 3, 1),
(460, 3, 7, 8, 4, 1),
(461, 3, 7, 8, 6, 1),
(462, 3, 7, 8, 7, 1),
(463, 3, 9, 8, 3, 1),
(464, 3, 9, 8, 4, 1),
(465, 3, 9, 8, 6, 1),
(466, 3, 9, 8, 7, 1),
(467, 4, 1, 2, 3, 1),
(468, 4, 1, 2, 4, 1),
(469, 4, 2, 11, 6, 1),
(470, 4, 2, 11, 7, 1),
(471, 4, 2, 9, 6, 1),
(472, 4, 2, 9, 7, 1),
(473, 4, 11, 10, 3, 1),
(474, 4, 11, 10, 4, 1),
(475, 4, 11, 3, 3, 1),
(476, 4, 11, 3, 4, 1),
(477, 4, 8, 10, 3, 1),
(478, 4, 8, 10, 4, 1),
(479, 4, 8, 3, 3, 1),
(480, 4, 8, 3, 4, 1),
(481, 4, 10, 3, 3, 1),
(482, 4, 10, 3, 4, 1),
(483, 4, 3, 4, 3, 1),
(484, 4, 3, 4, 4, 1),
(485, 4, 11, 2, 3, 1),
(486, 4, 4, 5, 3, 1),
(487, 4, 4, 5, 4, 1),
(488, 4, 5, 6, 3, 1),
(489, 4, 4, 10, 3, 1),
(490, 4, 4, 10, 4, 1),
(491, 4, 4, 3, 3, 1),
(492, 4, 4, 3, 4, 1),
(493, 4, 6, 8, 6, 1),
(494, 4, 6, 8, 7, 1),
(495, 4, 6, 12, 6, 1),
(496, 4, 6, 12, 7, 1),
(497, 4, 12, 7, 3, 1),
(498, 4, 12, 7, 4, 1),
(499, 4, 12, 7, 6, 1),
(500, 4, 12, 7, 7, 1),
(501, 4, 7, 8, 3, 1),
(502, 4, 7, 8, 6, 1),
(503, 4, 9, 8, 6, 1),
(504, 5, 1, 10, 1, 1),
(505, 5, 1, 10, 2, 1),
(506, 5, 1, 10, 3, 1),
(507, 5, 1, 10, 4, 1),
(508, 5, 1, 10, 6, 1),
(509, 5, 1, 10, 7, 1),
(510, 5, 1, 10, 5, 1),
(511, 5, 1, 9, 1, 1),
(512, 5, 1, 9, 2, 1),
(513, 5, 1, 9, 3, 1),
(514, 5, 1, 9, 4, 1),
(515, 5, 1, 9, 6, 1),
(516, 5, 1, 9, 7, 1),
(517, 5, 1, 9, 5, 1),
(518, 5, 8, 10, 1, 1),
(519, 5, 8, 10, 2, 1),
(520, 5, 8, 10, 3, 1),
(521, 5, 8, 10, 4, 1),
(522, 5, 8, 10, 6, 1),
(523, 5, 8, 10, 7, 1),
(524, 5, 8, 10, 5, 1),
(525, 5, 8, 9, 1, 1),
(526, 5, 8, 9, 2, 1),
(527, 5, 8, 9, 3, 1),
(528, 5, 8, 9, 4, 1),
(529, 5, 8, 9, 6, 1),
(530, 5, 8, 9, 7, 1),
(531, 5, 8, 9, 5, 1),
(532, 5, 10, 3, 1, 1),
(533, 5, 10, 3, 2, 1),
(534, 5, 10, 3, 3, 1),
(535, 5, 10, 3, 4, 1),
(536, 5, 10, 3, 6, 1),
(537, 5, 10, 3, 7, 1),
(538, 5, 10, 3, 5, 1),
(539, 5, 10, 9, 1, 1),
(540, 5, 10, 9, 2, 1),
(541, 5, 10, 9, 3, 1),
(542, 5, 10, 9, 4, 1),
(543, 5, 10, 9, 6, 1),
(544, 5, 10, 9, 7, 1),
(545, 5, 10, 9, 5, 1),
(546, 5, 3, 4, 1, 1),
(547, 5, 3, 4, 2, 1),
(548, 5, 3, 4, 3, 1),
(549, 5, 3, 4, 4, 1),
(550, 5, 3, 4, 6, 1),
(551, 5, 3, 4, 7, 1),
(552, 5, 3, 4, 5, 1),
(553, 5, 3, 9, 1, 1),
(554, 5, 3, 9, 2, 1),
(555, 5, 3, 9, 3, 1),
(556, 5, 3, 9, 4, 1),
(557, 5, 3, 9, 6, 1),
(558, 5, 3, 9, 7, 1),
(559, 5, 3, 9, 5, 1),
(560, 5, 4, 8, 1, 1),
(561, 5, 4, 8, 2, 1),
(562, 5, 4, 8, 3, 1),
(563, 5, 4, 8, 4, 1),
(564, 5, 4, 8, 6, 1),
(565, 5, 4, 8, 7, 1),
(566, 5, 4, 8, 5, 1),
(567, 5, 4, 12, 1, 1),
(568, 5, 4, 12, 2, 1),
(569, 5, 4, 12, 3, 1),
(570, 5, 4, 12, 4, 1),
(571, 5, 4, 12, 6, 1),
(572, 5, 4, 12, 7, 1),
(573, 5, 4, 12, 5, 1),
(574, 5, 12, 8, 1, 1),
(575, 5, 12, 8, 2, 1),
(576, 5, 12, 8, 3, 1),
(577, 5, 12, 8, 4, 1),
(578, 5, 12, 8, 6, 1),
(579, 5, 12, 8, 7, 1),
(580, 5, 12, 8, 5, 1),
(581, 5, 12, 7, 1, 1),
(582, 5, 12, 7, 2, 1),
(583, 5, 12, 7, 3, 1),
(584, 5, 12, 7, 4, 1),
(585, 5, 12, 7, 6, 1),
(586, 5, 12, 7, 7, 1),
(587, 5, 12, 7, 5, 1),
(588, 5, 7, 8, 1, 1),
(589, 5, 7, 8, 2, 1),
(590, 5, 7, 8, 3, 1),
(591, 5, 7, 8, 4, 1),
(592, 5, 7, 8, 6, 1),
(593, 5, 7, 8, 7, 1),
(594, 5, 7, 8, 5, 1),
(595, 5, 9, 8, 1, 1),
(596, 5, 9, 8, 2, 1),
(597, 5, 9, 8, 3, 1),
(598, 5, 9, 8, 4, 1),
(599, 5, 9, 8, 6, 1),
(600, 5, 9, 8, 7, 1),
(601, 5, 9, 8, 5, 1),
(602, 7, 1, 13, 1, 1),
(603, 7, 1, 13, 2, 1),
(604, 7, 1, 13, 3, 1),
(605, 7, 1, 13, 4, 1),
(606, 7, 1, 13, 6, 1),
(607, 7, 1, 13, 7, 1),
(608, 7, 1, 13, 5, 1),
(609, 7, 1, 9, 1, 1),
(610, 7, 1, 9, 2, 1),
(611, 7, 1, 9, 3, 1),
(612, 7, 1, 9, 4, 1),
(613, 7, 1, 9, 6, 1),
(614, 7, 1, 9, 7, 1),
(615, 7, 1, 9, 5, 1),
(616, 7, 13, 9, 1, 1),
(617, 7, 13, 9, 2, 1),
(618, 7, 13, 9, 3, 1),
(619, 7, 13, 9, 4, 1),
(620, 7, 13, 9, 6, 1),
(621, 7, 13, 9, 7, 1),
(622, 7, 13, 9, 5, 1),
(623, 7, 13, 4, 1, 1),
(624, 7, 13, 4, 2, 1),
(625, 7, 13, 4, 3, 1),
(626, 7, 13, 4, 4, 1),
(627, 7, 13, 4, 6, 1),
(628, 7, 13, 4, 7, 1),
(629, 7, 13, 4, 5, 1),
(630, 7, 4, 6, 1, 1),
(631, 7, 4, 6, 2, 1),
(632, 7, 4, 6, 3, 1),
(633, 7, 4, 6, 4, 1),
(634, 7, 4, 6, 6, 1),
(635, 7, 4, 6, 7, 1),
(636, 7, 4, 6, 5, 1),
(637, 7, 6, 12, 1, 1),
(638, 7, 6, 12, 2, 1),
(639, 7, 6, 12, 3, 1),
(640, 7, 6, 12, 6, 1),
(642, 7, 6, 12, 7, 1),
(643, 7, 6, 12, 5, 1),
(644, 6, 1, 12, 1, 1),
(645, 6, 1, 12, 3, 1),
(646, 6, 1, 9, 1, 1),
(647, 6, 1, 9, 3, 1),
(648, 8, 1, 3, 1, 1),
(649, 8, 1, 3, 2, 1),
(650, 8, 1, 3, 3, 1),
(651, 8, 1, 3, 4, 1),
(652, 8, 1, 3, 6, 1),
(653, 8, 1, 3, 7, 1),
(654, 8, 1, 3, 5, 1),
(655, 8, 3, 4, 1, 1),
(656, 8, 3, 4, 2, 1),
(657, 8, 3, 4, 3, 1),
(658, 8, 3, 4, 4, 1),
(659, 8, 3, 4, 6, 1),
(660, 8, 3, 4, 7, 1),
(661, 8, 3, 4, 5, 1),
(662, 8, 4, 3, 3, 1),
(663, 8, 4, 12, 3, 1),
(664, 8, 12, 7, 3, 1),
(665, 1, 3, 15, 1, 1),
(666, 1, 3, 15, 2, 1),
(667, 1, 3, 15, 3, 1),
(668, 1, 3, 15, 4, 1),
(669, 1, 3, 15, 5, 1),
(670, 1, 3, 15, 6, 1),
(671, 1, 3, 15, 7, 1),
(672, 1, 15, 3, 1, 1),
(673, 1, 15, 3, 2, 1),
(674, 1, 15, 3, 3, 1),
(675, 1, 15, 3, 4, 1),
(676, 1, 15, 3, 5, 1),
(677, 1, 15, 3, 6, 1),
(678, 1, 15, 3, 7, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workperiod`
--

CREATE TABLE `[[dbprefix]]workperiod` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idResource` int(12) unsigned DEFAULT NULL COMMENT '12',
  `periodRange` varchar(10) DEFAULT NULL,
  `periodValue` varchar(10) DEFAULT NULL,
  `submitted` int(1) unsigned DEFAULT '0' COMMENT '1',
  `submittedDate` datetime DEFAULT NULL,
  `validated` int(1) unsigned DEFAULT '0' COMMENT '1',
  `validatedDate` datetime DEFAULT NULL,
  `idLocker` int(12) unsigned DEFAULT NULL COMMENT '12',
  `comment` varchar(4000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`),
  KEY `workperiodResource` (`idResource`),
  KEY `workperiodPeriod` (`periodRange`,`periodValue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]worktoken`
--

CREATE TABLE `[[dbprefix]]worktoken` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  `description` mediumtext,
  `duration` decimal(8,5) unsigned DEFAULT NULL,
  `amount` decimal(13,5) unsigned DEFAULT NULL,
  `splittable` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `amountLocal` decimal(13,5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]worktokenclientcontract`
--

CREATE TABLE `[[dbprefix]]worktokenclientcontract` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idWorkToken` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idClientContract` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `quantity` decimal(7,2) unsigned DEFAULT NULL,
  `duration` decimal(13,5) unsigned DEFAULT NULL,
  `amount` decimal(13,5) unsigned DEFAULT NULL,
  `fullyConsumed` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idleToken` int(1) unsigned DEFAULT '0' COMMENT '1',
  `amountLocal` decimal(13,5) unsigned DEFAULT NULL,
  `reportQuantity` decimal(7,2) DEFAULT NULL,
  `newQuantity` decimal(7,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]worktokenclientcontractwork`
--

CREATE TABLE `[[dbprefix]]worktokenclientcontractwork` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idWork` int(12) unsigned DEFAULT NULL COMMENT '12',
  `time` int(12) unsigned DEFAULT NULL COMMENT '12',
  `idWorkTokenClientContract` int(12) unsigned DEFAULT NULL COMMENT '12',
  `workTokenQuantity` decimal(5,2) unsigned DEFAULT NULL,
  `idWorkTokenMarkup` int(12) unsigned DEFAULT NULL COMMENT '12',
  `workTokenMarkupQuantity` decimal(5,2) unsigned DEFAULT NULL,
  `billable` int(1) unsigned DEFAULT '0' COMMENT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]worktokenmarkup`
--

CREATE TABLE `[[dbprefix]]worktokenmarkup` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idWorkToken` int(12) unsigned DEFAULT NULL COMMENT '12',
  `name` varchar(100) DEFAULT NULL,
  `coefficient` decimal(6,3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workunit`
--

CREATE TABLE `[[dbprefix]]workunit` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCatalogUO` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(200) DEFAULT NULL,
  `description` mediumtext,
  `entering` mediumtext,
  `deliverable` mediumtext,
  `validityDate` date DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0' COMMENT '1',
  `idProject` int(12) unsigned DEFAULT NULL COMMENT '12',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workunitcatalogphase`
--

CREATE TABLE `[[dbprefix]]workunitcatalogphase` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '12',
  `idCatalogUO` int(12) unsigned DEFAULT NULL COMMENT '12',
  `reference` varchar(200) DEFAULT NULL,
  `ratioPct` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
