{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 *}
{if isset($hasRequiredDependencies) && !$hasRequiredDependencies}
  <script src="https://assets.prestashop3.com/dst/mbo/v1/mbo-cdc-dependencies-resolver.umd.js"></script>
  <div id="mbo-cdc-container"></div>

  <script defer>
    const renderMboCdcDependencyResolver = window?.mboCdcDependencyResolver?.render
    const context = {
      ...{$requiredDependencies|json_encode},
      onDependenciesResolved: () => {
        setTimeout(() => {
          window.location.reload()
        }, 2000);
      },
      onDependencyResolved: (dependencyData) => console.log('Dependency installed', dependencyData),
      onDependencyFailed: (dependencyData) => console.log('Failed to install dependency', dependencyData),
      onDependenciesFailed: () => console.log('There are some errors'),
    }
    renderMboCdcDependencyResolver(context, '#mbo-cdc-container')
  </script>
{/if}

<div id="app"{if isset($hasRequiredDependencies) && !$hasRequiredDependencies} style="display:none;"{/if}></div>

<style>
  /** Hide native multistore module activation panel, because of visual regressions on non-bootstrap content */
  #content.nobootstrap div.bootstrap.panel {
    display: none;
  }
</style>

<script>
    // Enhance page subtitle with module version
    const pageSubtitles = document.querySelectorAll('#content.nobootstrap .page-head .page-subtitle, #content.bootstrap .page-head .page-subtitle');
    const moduleVersion = window?.store?.context?.moduleVersion ? ' v' + window.store.context.moduleVersion : '';

    pageSubtitles?.forEach((pageSubtitle) => {
        if (pageSubtitle) {
            pageSubtitle.textContent = pageSubtitle.textContent
                + moduleVersion;
        }
    });
</script>
