## Version 4.3.1 - May 21, 2025

ENH: Issue #993 - Added TDatePicker::DropDownCssClass to apply a class to all the dropdowns
ENH: Issue #997 - Nginx fixes to run appliaction in subfolder
ENH: Issue #998 - Replace Exception by Throwable to catch eval ParseError and Error.
ENH: Issue #1002 - Add THttpSessionhandler to avoid use of deprecated session_set_save_handler() ctor
ENH: Migrate functional tests from phpunit-selenium to php-webdriver
ENH: Php 8.4 compatibility: limit use of deprecated SID and E_STRICT constants
ENH: Php 8.4 compatibility: use explicit nullable type
ENH: Php 8.2 compatibility:remove deprecated usage of dynamic defined properties in TActiveRecord
BUG: Avoid recursive error while reporting an error and the source file can't be loaded

## Version 4.3.0 - October 26, 2023

ENH: Issues #824, #838, #851, #891, #910, #917 - General Behaviors Update: Cloning and Serializing supports behaviors.  IBaseBehavior has init($config) method. TClassBehavior tracks their owners.  Behaviors attach their registered event handlers at the behavior priority.  Registered Behavior event can optionally attached and detached automatically when the behavior is enabled or disabled (default).  Behavior events() support Closures. IBehavior are attachable class-wide by cloning. Behaviors for behaviors has better support.  Behaviors are case insensitive.  Supports Anonymous (unnamed/numeric) behaviors.  Wakeup updates the component behaviors with new named class behaviors. (belisoful)
BUG: Issue #843 - Permissions Manager behaviors rename the method 'getManager' to 'getPermissionsManager' for specificity. (belisoful)
ENH: Issue #845 - PHP Clone and Unserialize of TComponent objects supports behaviors. (belisoful)
ENH: Issue #848 - TComponent events support Closure (anonymous functions) as handlers. (belisoful)
ENH: Issue #861 - TWebColors lists all the Web Colors in a TEnumerable and implements TPropertyValue::ensureHexColor (belisoful)
ENH: Issue #886 - Lists the 1st level traits of the class and its parents in TComponent::getClassHierarchy.  Class-wide behaviors support attaching to Traits as well as interfaces, classes, and their parents. (belisoful)
ENH: Issue #904 - TRational and TURational for reading, writing, and computing EXIF-Tiff (GPS) Rational and URational unit types; in Prado\Util\Math. (belisoful)
BUG: Issue #911 - Protect the message cache file to be thread safe. (majuca)
ENH: Issue #939 - TEventHandler for embedding data with a specific event handler callable. (belisoful)
ENH: Issue #944 - TExitException for gracefully exiting the application anywhere. Exception chaining with the last parameter being the previous Exception. (belisoful)
ENH: Issue #979 - TComponent::raiseEvent optionally execute handlers in reverse; asa() and getBehaviors() searches for behaviors based on class after failing on name. (belisoful)
ENH: Issue #975 - Prado base object methods for each log type and automatic discovery of calling object for log category. (belisoful)
ENH: Issue #977 - THttpRequest::onResolveRequest for custom service resolution and TRequestConnectionUpgrade behavior for selecting service on http headers for "websocket". (belisoful)
ENH: Issue #982 - General Logging update: Profiling, Flushing large logs for long running processes, optional Tracing, tracks PID for multi-threaded logging, TBrowserLogRoute colorizes the time delta, TDbLogRoute adds a new DB field 'prefix' and functions for getting the DB log, DB log count, and deleting DB logs, TDBLogRoute also adds a RetainPeriod for automatically removing old logs, Adds an event TLogger::OnFlushLogs and flushes as a register_shutdown_function, adds the TSysLogRoute, and adds unit tests for logging. (belisoful)
ENH: Issue #984 - TEventSubscription for temporary event handlers. (belisoful)
ENH: Issue #972 - TProcessHelper (isSystemWindows, forking, kill, priority) and TSignalsDispatcher for delegating signals to respective global events, alarm interrupt callbacks at specific times, and per child PIDs callbacks. TEventSubscription can subscribe to a PHP process signal, an integer, as an event "name" (in TSignalsDispatcher).  (belisoful)
ENH: Issue #973 - Embedded PHP Development Web Server CLI Action. (belisoful)
ENH: Issue #976 - A class's static functions are extendable with class-wide behaviors or a singleton implementing ISingleton.  The PHP magic method TComponent::__callStatic forwards static function calls to implementing class-wide or ISingleton behaviors. (belisoful)

## Version 4.2.2 - April 6, 2023

BUG: Issue #811 - Update TSqlCriteria.php for fix phpdoc (zendre4)
BUG: Issue #814 - TSkinTemplate: ensure the full-NS class name is returned from the skin to match the one from the template (ctrlaltca)
BUG: Issue #815 - Cron trigger on first run fix, repeat running fix, and removed time zone code (belisoful)
BUG: Issue #819 - Support for OFFSET parameter without LIMIT clause in SQL query for TActiveRecord (ganiuszka)
ENH: Issue #820 - TApplicationComponent::getClassFxEvents Performance Mode should cache all (belisoful)
ENH: Issue #828 - TApplication::onSetUser raised when setting user. (belisoful)
ENH: Issues #821, #822, #823, #825, #826, #834, #839, #842 - Behavior updates (belisoful)
ENH: Issues #840, #847 - TPriority updates (belisoful)
ENH: Issues #818, #846 - TCallChain updates (belisoful)
ENH: Issue #866 - HTMLPurifier_Config and cache path (majuca)
ENH: Issue #868 - RFC: Service detection is fragile (ctrlaltca)
ENH: Issue #865 - File and dir permissions were too permissive 0777, now the file permissions are 0644 and 0755 for directory by default. (majuca)
ENH: Issue #869 - Remove execute permission on all files excepted on php-cli (majuca)
ENH: Issue #875 - Make Prado::using able to autoload traits defined as prado3 namespaces (ctrlaltca)

## Version 4.2.1 - May 9, 2022

BUG: Issue #809 - Interface order and minimum required PHP version (ganiuszka)
BUG: Issue #810 - Index 0 is out of range error from TAuthorizationRuleCollection::insertAt (ganiuszka)

## Version 4.2.0 - Apr 19, 2022

ENH: Issue #790 TPermissionsManager implements Role Based Access Control and Authorization Rules for each permission (belisoful)  
ENH: Prado::createComponent can take an array with "class" and object properties to set on the new object (belisoful)  
ENH: TAuthorizationRule adds Priority for proper ordering of Authorization Rules, eg. Deny All can be and stay the final rule using priorities. (belisoful)  
ENH: TPageConfiguration is extendable with dynamic events for loading xml & php and then applying (belisoful)  
ENH: TUser adds dynamic events dyDefaultRoles and dyIsInRole for default roles and checking the user in a role. (belisoful)  
BUG: Issue #791 - TUserManager loads PHP user file configurations properly (belisoful)  
ENH: Adds IPriorityItem for auto-prioritizing items in TPriorityList and TPriorityMap (belisoful)  
CHG: Issue #783 - Refactor the Shell system with Composer in mind; shell routes and actions, updated the help system. (belisoful)  
ENH: Issue #761 - TCronModule and TDbCronModule with supporting classes, scheduled like linux cron schedule expression, 8 languages. (belisoful)  
ENH: Issue #743 - Integrate Composer extensions for PRADO, module ids can be the composer package names and the class will be ['extra']['bootstrap'] (from the composer.json file). TPluginModule/TDbPluginModule for additional functionality as the parent class for extensions.  Composer "type" : "prado4-extension" (belisoful)  
BUG: Issue #784 - Prado-CLI corrected I18N by translating the shell "LANG" into "HTTP_ACCEPT_LANGUAGE" (belisoful)  
ENH: Issue #778 - Added TEventContent for filling in the control content from handlers of a global event (belisoful)  
ENH: Issue #776 - Added TDataSize for formatting data sizes with bytes, kB, MB, KiB, MiB, etc. (belisoful)  
ENH: Issue #775 - TPageService::onAdditionalPagePaths for additional pages (to look for) from composer package extensions (belisoful)  
ENH: Issue #772 - TMap, TPriorityMap adds dyNoItem, dyAddItem, and dyRemoveItem dynamic events. (belisoful)  
ENH: Issue #771 - Added TDbParameterModule for reading and setting application parameters with a database-table. (belisoful)  
CHG: Issue #765 - Prado-CLI moved into their own set of classes rather than one big prado-cli file with all the functionality in it. (belisoful)  
CHG: Issue #763 - Moved secondary saving of global variables until after onEndRequest in case global state changes in onEndRequest. (belisoful)  
ENH: Issue #750 - Added TGravatar (belisoful)  
ENH: issue #744 - Added RTL theme support (belisoful)  
BUG: Issue #742 - TSecurityManager::setHashAlgorithm uses hash_algos() rather than hash_hmac_algos() - some algos may be set that are not supported by hmac (belisoful)  
ENH: Issue #741 - TBehaviorsModule and TBehaviorParameterLoader for instancing behaviors in an application; added various behaviors like TParameterizeBehavior that gives new defaults and data from the parameters to any prado object property. (belisoful)  
ENH: Issue #740 - Behaviors can instances from an array with class and properties, important for #741 (belisoful)  
BUG: Issue #739 - TApplicationConfiguration::loadParametersPhp variable unset but called (belisoful)  
CHG: AutoGlobalListen is true for TApplicationComponents (but not TWebControls), and select TComponent children, their 'fx' events will automatically listen and unlisten to fx events on construct and destruct.
ENH: Issue #738 - Added TAuthManager::onLogin, onLogout, and onLoginFailed events (belisoful)  
ENH: Issue #737 - Added TSkinTemplate that doesn't do class/attribute validation so skins are more portable between apps (belisoful)  
ENH: Issue #735 - Added TPageService::onPreRunPage so modules can access Page events (belisoful)  
BUG: Issue #728 - TWeakCallableCollection makes use of 7.4 WeakReference so fx events do not stop garbage collection (belisoful)  
CHG: Split Wsat into its own repo pradosoft/prado-wsat (ctrlaltca)  
CHG: T(Active)HtmlArea4 has been replaced by T(Active)HtmlArea5, based on tinyMCE version 5 (ctrlaltca)
CHG: removed hardcoded bootstrap libraries (ctrlaltca)

## Version 4.1.2 - Aug 28, 2021

BUG: Issue #706 - TOutputcache: don't serialize controls state (jcass77, ctrlaltca)  
BUG: Issue #715 - Problem saving files on TActiveFileUpload when Multiple=true (ctrlaltca)  
BUG: Issue #718 - Fix clientside exception logging in debug mode (jmartens, ctrlaltca)  
BUG: Issue #722 - Problem with TactiveButton Text property (ctrlaltca)  
BUG: Issue #720 - TSecurityManager: use correct private property (qysp)  
BUG: Fix bug in TStyleDiff that didn't render CssClass and Style correctly on callback (ctrlaltca)  
BUG: Issue #727 - Php compatibility bug in TMysqlMetaData.php (PixelHomie)  
ENH: Issue #724 - Ajax queue improvement (ganiuszka)  
ENH: Add support for SameSite property on cookies (ctrlaltca)  

## Version 4.1.1 - Mar 27, 2020

BUG: TActiveFileUpload: avoid warning in browser console by removing usage of an empty page as initial content (ctrlaltca)  
BUG: TExpression: fix naming conflict of class variable (ctrlaltca)  
BUG TActiveRecordConfig: fixed bug in default manager class (LCSKJ)  
ENH: Added compatibility with Php 7.4 (ctrlaltca)  
ENH: issue #708 Add support for PostgreSQL 12 (ganiuszka)  
CHG: Deprecated / ported method using attributes obsoleted in html5 (ctrlalta)  

## Version 4.1.0 - Nov 18, 2019

BUG: Issue #694 - Undefined variable: conn notice in Active Record Scaffold (ganiuszka)  
BUG: Issue #696 - SQL error when trying to disable PDO::ATTR_EMULATE_PREPARES option for MySQL (ganiuszka)  
BUG: Issue #698 - TActiveFileUpload - multi upload always shows a red X for incomplete upload (ctrlaltca)  
ENH: Added ClientSide.RetryLimit to retry timeout out ajax requests (ctrlaltca)  

## Version 4.0.2 - Apr 12, 2019

BUG: Issue #669 - Wrong Gettext class filename (gani)  
BUG: Issue #671 - THtmlArea4 in TActiveRepeater (ctrlaltca)  
BUG: Issue #674 - Fix TValidationSummary when no validator has an ErrorMessage set and js is disabled (ctrlaltca)  
BUG: Issue #675 - TDatePicker position problems with jQuery 3.3 (ctrlaltca)  
BUG: Issue #683 - TRequiredFieldValidator doesn't work with TActiveListBox (gani, ctrlaltca)  
BUG: Issue #533 - Mitigate CVE-2011-4718 by regenerating the session id when TAuthManager swiches user (david0)  
BUG: Issue #439 - Remove internal I18n data; use php's intl instead (ctrlaltca)  
ENH: Added support for igbinary serializator (ctrlaltca)  
ENH: Added TGlobalizationAutoDetect::AvailableLanguages property to set the list of available cultures on the website (ctrlaltca)  
ENH: Make TableColumnClass in TMysqlMetaData variable (LCSKJ)  

## Version 4.0.1 - Apr 1, 2018

CHG: Removed all deprecated code (ctrlaltca)  
CHG: Removed deprecated components based on the prototype javascript library (ctrlaltca)  
CHG: Removed bundled copy of JSMin-php library, get it from composer instead (ctrlaltca)  
ENH: Added composer script commands to run phpunit and apigen (ctrlaltca)  
BUG: Issue #660 - Wsat redirect broken (ctrlaltca)  
ENH: Added html5 charset attribute to meta (frkinta)  
BUG: Issue #662 - External links to API manual doesn't work anymore (frkinta)  
BUG: Issue #663 - PHP 7.2 warning messages break active controls (ctrlaltca)  

## Version 3.3.3 Jan 25, 2018

Backported fixes from master branch:
BUG: Issue #625 - The url tag produce an extra directory separator before the result (ctrlaltca)  
BUG: Issue #610 - IIS: Page redirect dosn't work (ctrlaltca)  
BUG: Issue #648 - Fix status header in cgi/fpm mode (ctrlaltca)  

## Version 4.0.0 - November 20, 2017

CHG: Add native php namespace support on all classes (ctrlaltca, david0, LCSKJ)  
CHG: Add native composer autoloader support (ctrlaltca, david0, LCSKJ)  
CHG: Drop bundled dependencies and use composer instead (ctrlaltca, david0, LCSKJ)  
CHG: Split demos in another repo (ctrlaltca, david0, LCSKJ)  
BUG: Issue #625 - IIS: The url tag produce an extra directory separator before the result (ctrlaltca)  
BUG: Issue #610 - IIS: Page redirect dosn't work (ctrlaltca)  
BUG: Issue #642 - Firefox restores hidden field value after callback on F5-Reload (LCSKJ, ctrlaltca)  
BUG: Fix missing language file in TJuiDatePicker when regional default is set (LCSKJ)  
BUG: Issue #648 - Fix status header in cgi/fpm mode (ctrlaltca)  
BUG: Issue #651 TFileUpload doesn't work if rendered on callback (ctrlaltca)  
BUG: Issue #652 - TActiveFileUpload problem on files containing a single quote (ctrlaltca)  
ENH: Issue #633 - Added two new controls TActiveHtmlArea and TActiveHtmlArea4 (LCSKJ)  
ENH: Issue #635 - Added HTML5 multiple file upload support in TFileUpload and TActiveFileUpload (LCSKJ)  
ENH: Added two new cache modules based on key-value stores: Redis and etcd (LCSKJ)  
ENH: Issue #93 - Translation storage in php array (ctrlaltca)  
ENH: Issue #139 - Add support for xdebug (ctrlaltca)  

## Version 3.3.2 August 23, 2016

BUG: Issue #592 - Fix TActiveMultiView broken on 3.3.1 (ctrlaltca)  
BUG: Issue #588 - Fix reading values of controls inside TJuiDialog (ctrlaltca)  
BUG: Issue #597 - TDatePicker::getDateFromPostData selected month issue (Sachat)  
BUG: Issue #599 - Allowing translation message cache to be initialized (emkael)  
BUG: Issue #604 - TActiveImageButton inside TJuiDialog javascript problem (ctrlaltca)  
BUG: Issue #607 - TActiveFileUpload does not work inside TJuiDialog (ctrlaltca)  
BUG: Issue #608 - Fix retrieving value from viewstate (frkinta, ctrlaltca)  
ENH: Issue #591 - Support for hyphenated attributes via <prop:\*></prop:\*> template syntax (emkael)  
ENH: Issue #594 - Added ability to check for subcontrols using isset(), empty() (jojoinside)  
ENH: Allow TStyle behaviors (LCSKJ)  

## Version 3.3.1 April 19, 2016

BUG: Issue #540 - Fix TActiveFileUpload on IE11 (ctrlaltca)  
BUG: Issue #574 - Fix TActiveCustomValidator validation after error (ctrlaltca)  
BUG: Issue #581 - TActiveFileUpload loses track of LocalName for a moment (emkael)  
BUG: Issue #582 - Prado autoloader breaks class_exists conditionals (ctrlaltca)  
BUG: Issue #585 - Calling unserialize() on TMappedStatement throws TApplicationException (emkael)  
BUG: TJuiAutoComplete: fix parsing of suggestions (ctrlaltca)  
BUG: Fix callback for controls with PostState=false (ctrlaltca)  
BUG: Fix stopping even propagation on javascript events (ctrlaltca)  
BUG: Fix callback loading for dynamically created JuiControls (ctrlaltca)  
BUG: Fix ClientSide.RequestTimeOut on active controls (ctrlaltca)  
BUG: Fix error reporting for not-existing property set on TJuiControl (ctrlaltca)  
BUG: TJuiDialog: avoid "cannot call methods on dialog prior to initialization" error (ctrlaltca)  
BUG: Fix callback update of TActiveCheckBoxList when initially empty (LCSKJ)  
ENH: Issue #562 - Added TClientStyleSheet::PradoStyles (ctrlaltca)  
ENH: Issue #569 - Improved TJavascriptLogger / browser console logging of errors (ctrlaltca)  
ENH: Issue #587 - Misc fixes for PHP7 compatibility (emkael)  
ENH: Applied some misc optimizations to class serialization (ctrlaltca)  
ENH: Intercept fatal errors using register_shutdown_function (ctrlaltca)  
ENH: Activecontrols: avoid updating client side if the value didn't change (ctrlaltca)  
ENH: Added TReCaptcha2 / TReCaptcha2Validator (camilohaze)  

## Version 3.3.0 February 15, 2016

CHG: Added jQuery and rebased PRADO's effect and controls on it (ctrlaltca)  
ENH: Added jQueryUI and created new controls (ctrlaltca)  
ENH: Added Bootstrap3 (daniel)  
BUG: Issue #558 - TActiveFileUpload escaping ' in file names (ctrlaltca)  
BUG: Issue #550 - TActivePager not working correctly on XAMP 5.6.3 (LCSKJ)  
BUG: Issue #549 - TSqlCriteria, not possible to reset value of condition (majuca)  
BUG: Issue #542 - Fix clientside validation in TActiveCustomValidator (majuca)  
BUG: Issue #546 - Wrong exception messages in TAccordion (david0)  
ENH: Issue #545 - Make Prado.Callback return the request (majuca, david0)  
BUG: Issue #543 - Can't set a url mapping pattern class in php config (plachance)  
BUG: Issue #541 - Security - HttpOnly parameter in THttpSession and THttpCookie (ctrlaltca)  
BUG: Issue #539 - Status Code not send when throwing a THttpException (ctrlaltca)  
BUG: Issues #528, 538 - Fix errors in Prado.Validation.validateControl (majuca, david0)  
ENH: Issue #559 - Add support for memcached (majuca)  

## Version 3.2.4 Aug 26, 2014

BUG: Issue #492 - Prado generates json_error when encoding an exception with non UTF-8 data (david0)  
ENH: Issue #494 - Adding toArray() and toJSON() to TActiveRecord (dmarko484)  
BUG: Issue #498 - Typo in TActiveFileUpload (Jens-mB)  
BUG: Issue #499 - Avoid scrolling when calling TControl::focus() (david0)  
BUG: Issue #502 - TSlider behaves strangely in TTabView (ctrlaltca)  
BUG: Issue #504 - Default Button cannot be referenced by <subControlId>.<controlId> (ctrlaltca)  
BUG: Issue #506 - Unused lines of code in TLiteralColumn::initializeCell (cross)  
BUG: Issue #511 - TActivePager's ButtonCssClass property is not rendered in buttons (ctrlaltca)  
BUG: Issue #515 - THtmlArea should override Readonly property (ctrlaltca)  
BUG: Issue #516 - Check Validators in TActiveEditCommandColumn (ctrlaltca)  
BUG: Issue #517 - TXmlDocument adjustment (gnit)  
BUG: Issue #518 - Runtime Notice in Gettext::factory() (ctrlaltca)  
BUG: Issue #519 - For MySQL in case PDO::CASE_LOWER creating table info does not work (ganiuszka)  
BUG: Issue #246 - Refix: User date() instead of gmdate() in TLogRoute (drigolin)  
BUG: Issue #520 - Unknown runtime error with Internet Explorer 8 (david0)  
BUG: Issue #524 - JSON error (5): Malformed UTF-8 characters when encoding callback response (david0)  
BUG: Issue #526 - TJsonRpcProtocol::callMethod, requested method is called twice (jojoinside)  
BUG: Issue #527 - TJsonRpcProtocol::callMethod, semicolon must be removed (jojoinside)  
ENH: Ported tests to Selenium2
BUG: Avoid an exception loop on callback error when headers have already been sent (ctrlaltca)  
BUG: Avoid rendering script blocks in callbacks (ctrlaltca)  
BUG: Avoid dependency loop between TRadioButton and TRadioButtonList (ctrlaltca)  
ENH: Dropped Markdown for Parsedown (ctrlaltca)  
ENH: Web site administration tool (WSAT) (Daniel Sampedro)  

## Version 3.2.3 Nov 26, 2013

BUG: Issue #467 - TSafeHtml error on php 5.5 (ctrlaltca)  
BUG: Issue #470 - Problem escaping characters in TActiveDropDownList (ctrlaltca)  
BUG: Issue #468 - Update prototype to workaround IE10 bug (Raoul Bhatia)  
BUG: Issue #469 - JS Update to TDatePicker (Jürgen Aloy)  
BUG: Issue #465 - Textmate editor plugin template error (ctrlaltca)  
BUG: Issue #472 - No https support from wsdl generator (Marcin Piotrowski)  
ENH: Issue #473 - wsdl support for additional attributes of a custom type's property (Marcin Piotrowski)  
BUG: Issue #476 - Demo's don't work out of box (ctrlaltca)  
BUG: Issue #479 - TUrlMapping instanciates patterns twice (ctrlaltca)  
BUG: Issue #480 - THyperLink is not usable using keyboard navigation (david otto)  
BUG: Issue #481 - Typo in composer: ext-eaccellerator (ciromattia)  
BUG: Issue #482 - composer: add include path for prado.php (ciromattia)  
BUG: Issue #484 - Wrong DateTimePatterns for italian culture (ciromattia)  
BUG: Issue #485 - NumberFormat fails if LC_ALL locale provides non-english notation (ciromattia, drigolin)  
EHN: Issue #260 - TComponent Update: Behaviors, Class Behaviors, fx global events, and dy one to one events (javalizard)  
EHN: Issue #292 - Events should have priorities to allow event handler order to be specified (javalizard)  
BUG: TDatePicker can't render css attributes class "datepicker_year_options" (m_rizki_r)  
ENH: Added THtmlArea4 based on TinyMCE4 (ctrlaltca)  
BUG: TDatePicker renders a spurious TTextBox (ctrlaltca)  

## Version 3.2.2 Jul 20, 2013

ENH: Issue  #50 - TUrlMapping - implement caching for loadUrlMappings (ctrlaltca)  
ENH: Issue #433 - Prado object-creation performance micro-optimizations (gabor)  
BUG: Issue #434 - Buttons stops working properly after response->writeFile (ctrlaltca)  
BUG: Issue #435 - TWizard + No ID = Prototype Error (ctrlaltca)  
BUG: Issue #436 - French Canadian date formats should be the same in TDateFormat and TDatePicker (ctrlaltca)  
ENH: Issue #437 - TUrlMapping optimizations: merge DxUrlMapping (gabor)  
ENH: Issue #439 - Module lazy loading (ctrlaltca)  
BUG: Issue #441 - TAccordion's ActiveViewIndex property is not honored on postback (ctrlatca)  
BUG: Issue #442 - TWizard's ShowSideBar property can't be changed from php (ctrlaltca)  
BUG: Issue #444 - Input validation vulnerability in unit test (ctrlaltca)  
BUG: Issue #446 - THtmlArea can't be updated in a callback (ctrlaltca)  
BUG: Issue #447 - Array to string conversion notice in TClientScriptManager (ctrlaltca)  
ENH: Issue #448 - Add TEACache eAccellerator cache module (drigolin)  
BUG: Issue #315 - TEmailAddressValidator regex (ctrlaltca)  
ENH: Issue #454 - TDraggableConstraint missing (ctrlaltca)  
ENH: Issue #455 - Support PDO::sqlsrv to support MS SQL database servers for PHP5.2+ (jonathan.martens)  
ENH: Issue #456 - Add ImageAlign to THyperLink (raoul@bhatia.at)  
ENH: Issue #459 - Add ToolTip and AlternateText to TButtonColumn (raoul@bhatia.at)  
ENH: Issue #451 - TRequiredFieldValidator should (automatically?) consider PromptValue as error (ctrlaltca)  
BUG: Issue #460 - Minor error in TUrlMappingPattern (raoul@bhatia.at)  
BUG: Issue #464 - Do not issue a callback request if an ActiveControl is disabled (ctrlaltca)  

## Version 3.2.1 Jan 19, 2013

BUG: Issue  #44 - [895] SDateFormatter cannot parse date earlier than 1970 (ctrlaltca)  
ENH: Issue #180 - Integrate XMLRPC web service (rojaro)  
BUG: Issue #412 - open_basedir restriction (ctrlaltca)  
BUG: Issue #413 - TActiveDatePicker does not fire TCallbackClientSide's events (ctrlaltca)  
BUG: Issue #414 - ActiveDatagrid's pager does not fire TCallbackClientSide's events (ctrlaltca)  
BUG: Issue #415 - prado-cli throws an error if the application is making use of THttpSession (ctrlaltca)  
BUG: Issue #416 - TJsonService reports the wrong content-type (ctrlaltca)  
BUG: Issue #417 - TActiveCustomValidator and Display=Dynamic not work anymore (sampsa.saarela)  
BUG: Issue #418 - Can't get parameters when friendly url enabled with UrlFormat=Path (sampsa.saarela)  
ENH: Issue #419 - CssClass for PushButtons of TPager (ctrlaltca)  
ENH: Issue #420 - Permit to easily mock TActiveRecordgateway for unit testing (mvschaik)  
BUG: Issue #421 - TAutocomplete not rendering an empty suggestion list (Dario Rigolin)  
BUG: Issue #424 - TDefaultButton broken when multiple TDefaultButton are on the same page (ctrlaltca)  
BUG: Issue #425 - Error generating WSDL (cezarpirajant)  
ENH: Issue #426 - Make TDataFieldAccessor capable to access data in nested arrays (ctrlaltca)  
BUG: Issue #427 - Var name mismatch in TActiveFileUpload.php (piotr.knapik)  
BUG: Issue #428 - Using a TActiveCustomValidator with a TActiveTextBox and AutoPostBack does not work as expected (ctrlaltca)  
BUG: Issue #431 - TReCaptcha does not work well with active controls (Gabor)  
BUG: Issue #432 - Double slash with URL Tags in www root (ctrlaltca)  

EHN: Permit to change the default cipher in TSecurityManager::setEncryption(); changed the default cipher from 3DES to AES256 (ctrlaltca)  
EHN: Added a new UrlFormat for TUrlManager: HiddenPath; works like the 'Path' format, but hides the entryscript.php name (ctrlaltca)  
EHN: Use php's hash_hmac() when available in TSecurityManager, and permit the use of all algorithms supported by php (ctrlaltca)  
EHN: Use mbstring when available in TSecurityManager to better handle multibyte text (ctrlaltca)  
EHN: Updated TinyMCE to 3.5.6 (ctrlaltca)  
CHG: Rewrite TDateTimeStamp as a wrapper to php's native DateTime and deprecate it (ctrlaltca)  
CHG: Updated prototype to 1.7.1 (ctrlaltca)  

## Version 3.2.0 Jun 25, 2012
BUG: Fixed an inconsistency in TRegularExpressionValidator
ENH: Update TDraggable::revert property to accept "failure" value (Christophe)  
CHG/ENH: Change behavior of THttpRequest::getBaseUrl() & THttpRequest::getAbsoluteApplicationUrl() to make it possible to force either http or https (Yves)  
EHN: Add property SecureConnection to TUrlMappingPattern and related enum TUrlMappingPatternSecureConnection to make it possible to to define wether to use http or https on pattern level (Yves)  
EHN: Add second parameter to THttpResponse::appendHeader whether the header should replace a previous similar header, or add a second header of the same type (Yves)  
ENH: Add THttpSession::regenerate() to update the current session id with a newly generated one (Yves)  
CHG: Remove TReflectionClass and all references since equals ReflectionClass (Yves)  
CHG: Modify TTemplate::parseAttributes to allow definition of "HTML5 Custom Data Attributes (data-\*)" e.g Attributes.data-custom-value="foobar" (Yves)  
EHN: Modify TActiveRecordConfig & TActiveRecordManager to allow custom subclassing of System.Data.ActiveRecord.TActiveRecordManager & System.Data.ActiveRecord.TActiveRecordGateway (Yves)  
EHN: Add methods quoteTableName, quoteColumnName, quoteColumnAlias to TDbMetaData & TDbConnection and add TDbConnection:getDbMetaData [TODO: customize TOracleMetaData] (Yves)  
EHN: Add method getHeaders to THttpRequest & THttpResponse (Yves)  
EHN: Modify TThemeManager to allow custom subclassing of TTheme (Yves)  
ENH: Performance (micro)optimization in TUrlMapping::loadUrlMappings - invoke `getDefaultMappingClass` outside of loop (Yves)  
BUG: TActiveMultiView must update clientside only when necessary to get other active controls work fine inside it (ctrlaltca)  
BUG: TListBox doesn't correctly reports selected indices to serverside on callback
BUG: TErrorHandler: avoid an error when trying to hide the file path of a lambda function (ctrlaltca)  
BUG: TSecurityManager: avoid a race condition when first generating the encryptionkey or the validationkey (ctrlaltca)  
BUG: TActiveFileUpload: urlencode the base64'ed token since it can contain the "+" character (otherway it would be traslated to a space) (ctrlaltca)  
BUG: TCaptcha: publish images with image/png content-type (ctrlaltca)  
ENH: prado-cli: added generateAll command (darthdaniel85)  

BUG: Issue  #35 - [840] Capital letters for the initial letter of the directories name (ctrlaltca)  
BUG: Issue  #66 - TButton.CausesValidation=False ignored when pressing Enter on the button within a control with DefaultButton (ctrlaltca)  
NEW: Issue  #83 - PHP configuration style (Carl)  
BUG: Issue  #91 - TActiveCustomValidator can not be updated in JavaScript callback (ctrlaltca)  
ENH: Issue #106 - TJavaScript::jsonEncode and TJavaScript::jsonDecode should use built-in PHP functions (ctrlaltca)  
ENH: Issue #173 - Add "dragdropextra" (supergsting) patch, mouse coordinates and key status to drag & drop controls (Christophe, DevWorx)  
BUG: Issue #179 - Serialization issues in Prado (ctrlaltca)  
BUG: Issue #181 - Reworked a better patch to handle clientside event handling (gabor)  
BUG: Issue #203 - Workaround for ->CallbackClient->click under IE<=8 (ctrlaltca)  
ENH: Issue #210 - Improvement: Auto-switch for TTabPanel (gabor)  
BUG: Issue #232 - Could not change enable-state of TActiveCheckBox via Ajax callback (Christophe)  
ENH: Issue #235 - Progressive rendering not possible (Gabor)  
BUG: Issue #237 - Log at a long time running process (ctrlaltca)  
BUG: Issue #240 - TXCache has wrong flush() implementation (ctrlaltca)  
BUG: Issue #243 - Cross-site scripting issue in TForm (ctrlaltca)  
BUG: Issue #254 - TDbCache should use hash index for the cache key (ctrlaltca)  
BUG: Issue #265 - Using scroll wheel causes NaN values in TDatePicker (Gabor)  
BUG: Issue #275 - THttpResponse::writeFile delivers the wrong content type (ctrlaltca)  
BUG: Issue #283 - constructUrl does not work as before in TShellApplication (ctrlaltca)  
BUG: Issue #284 - Wrong reading of information_schema (ctrlaltca)  
BUG: Issue #301 - Fixed a bug in TActiveFileUpload (ctrlaltca)  
BUG: Issue #314 - T(Active)FileUpload $\_errorCode private vs protected (ctrlaltca)  
ENH: Issue #337 - Prado serialization optimizations (Gabor)  
BUG: Issue #341 - TSafeHtmlParser messes up UTF8-encoded strings (ctrlaltca)  
BUG: Issue #342 - TStyle does no accept style values with ":" (ctrlaltca)  
NEW: Issue #345 - Added TReCaptcha control (Gabor)  
BUG: Issue #346 - TJavaScript, TJSON documentation missing/misbehaving (ctrlaltca)  
BUG: Issue #348 - Scripts for dynamically created controls not registered properly in/after a callback (Gabor)  
BUG: Issue #351 - THtmlArea prone to double-registration, doesn't deregister properly (Gabor)  
BUG: Issue #353 - Accordion control behaves oddly if clicked too fast (Gabor)  
BUG: Issue #354 - Oracle MetaData : Nullable/Not Nullable columns inverted (ctrlaltca)  
ENH: Issue #356 - Added a new "Clickable" operating mode to TDatePicker (ctrlaltca)  
BUG: Issue #358 - THtmlArea Insert Image Bug (uacaman)  
BUG: Issue #361 - TActiveListBox multiple selection bug (ctrlaltca)  
BUG: Issue #366 - Use divs instead of spans around tables in TActiveDataGrid (ctrlaltca)  
BUG: Issue #365 - [Runtime Notice] Declaration of T${DriverName}MetaData::quoteTableName() should be compatible with that of TDbMetaData::quoteTableName() (Yves)  
BUG: Issue #367 - Parameterized RegularExpression property in UrlMapping raise TPhpErrorException in DOMDocument::loadXML() (Yves)  
BUG: Issue #368 - Clearing selection of a TActiveDropDownList in callback should select its prompt (ctrlaltca)  
CHG: Issue #370 - Deprecated TSqliteCache since it's based on php's sqlite extension (ctrlaltca)  
BUG: Issue #371 - Sorting on TActiveDataGrid autogenerated column not work (ctrlaltca)  
ENH: Issue #372 - ActiveControls's Visible property should be reflected clientside on ajax requests (ctrlaltca)  
BUG: Issue #375 - Iconv error using htmlarea in TActiveDataList and chars like "áéíóúñ" (ctrlaltca)  
BUG: Issue #377 - THtmlArea Template Pluggin Options Parse Error (ctrlaltca)  
BUG: Issue #379 - JSON float encoding depends on current locale (ctrlaltca)  
BUG: Issue #380 - TCustomValidator's ControlToValidate should be optional (ctrlaltca)  
BUG: Issue #381 - The property CausesValidation in the TActiveDatePicker not work (ctrlaltca)  
BUG: Issue #382	- TJavaScript::quoteString() vulnerable to Unicode strings & TJavaScript::jsonEncode() doesn't check for errors (gabor)  
BUG: Issue #383 - Some THttpRequest methods raise NOTICE level errors on missing headers (gabor)  
BUG: Issue #388 - Output caching will raise error in Performance mode (gabor)  
BUG: Issue #390 - TJavaScript::encode() float encoding depends on current locale (gabor)  
BUG: Issue #391 - TJavaScript::encode() provides no simple way to pass strings in an XSS-safe way (gabor, ctrlaltca)  
BUG: Issue #393 - THttpResponse::redirect() fails if output buffering has been disabled completely (gabor)  
BUG: Issue #394 - TActiveCustomValidator Display Dynamic error or Double Update Value (ctrlaltca)  
BUG: Issue #395 - 'TActiveDatePicker' does not support AutoPostBack. (ctrlaltca)  
BUG: Issue #396 - TApplication warning with is_file php function (ctrlaltca)  
BUG: Issue #399 - ratings.js script always included on pages with postback controls (gabor, ctrlaltca)  
BUG: Issue #400 - FastCGI/Exceptions: Status code not sent to browser (ctrlaltca)  
BUG: Issue #401 - TClientScript doesn't render correctly itself if set visible in callback (ctrlaltca)  
BUG: Issue #402 - Component property 'TDatePickerClientScript.setOnLoading' is not defined. (ctrlaltca)  
BUG: Issue #404 - THtmlArea sometimes not loading properly from callbacks (gabor)  
BUG: Issue #406 - Prado does not allow extension of the application configuration (gabor)  
BUG: Issue #407 - Prado does not allow custom SqlMap data caching strategy/method & has inefficient Basic cache (gabor)  
BUG: Issue #408 - Missing script/stylesheet file(s) halt(s) callback processing (gabor)  
BUG: Issue #410 - Deferred script rendering does not work well with output caching (gabor)  

## Version 3.1.10 Jul 17, 2011
BUG: Added missing timeout on TCacheHttpSession (ctrlaltca)  
BUG: Issue#332 - Minor typos (ctrlaltca)  
BUG: Issue#333 - Wrong tracker url on quickstart (ctrlaltca)  
BUG: Issue#334 - Wrong variable acces in TTemplateControlInheritable (ctrlaltca)  
BUG: Issue#335 - setcookie() bug (ctrlaltca)  
BUG: Issue#343 - New TTabPanel breaks compatibility (ctrlaltca)  
BUG: Issue#349 - Security problem in TActiveFileUpload control (Gabor)  
ENH: Merged a bit TPager's view style with TDataGridPager's one adding first/last buttons to TDataGridPagerStyle (ctrlaltca)  
ENH: Reworked the patch for #103 so that it actually fixes the use of TActiveCustomValidator with normal Postback controls (ctrlaltca)  

## Version 3.1.9 June 3, 2011
BUG: Issue#280 - Documentation has been updated
BUG: Issue#311 - TDataList : FooterStyle not used (ctrlaltca)  
BUG: Issue#326 - Translation don't work with Prado 3.1.8 (ctrlaltca)  
BUG: Issue#327 - TDbCache with PostgreSQL throw a TDbException (ctrlaltca)  
NEW: added documentation and samples to the quickstart tutorial to include the active controls (ctrlaltca)  
NEW: Added TTemplateControlInheritable control
NEW: Added TActiveDataGrid control (LCS Team, Christophe)  
NEW: Added TActiveDataList control (Marcosanobre, Robin)  
NEW: Added TActiveMultiView control (LCS Team)  
NEW: Added TActiveRepeater control (LCS Team, Christophe)  
NEW: Add TActiveTableRow (LCS Team)  
NEW: Add TActiveTableCell (LCS Team)  

## Version 3.1.8 May 29, 2011
BUG: Issue#16  - [684] TDatePicker problems (rojaro)  
BUG: Issue#18  - [909] findAllBySql with non-column ORDER BY (rojaro)  
BUG: Issue 58  - TWizard defaults to wrong button (ctrlaltca)  
BUG: Issue#103 - TActiveCustomValidator CallBack problem (rojaro)  
BUG: Issue#133 - Problem with localazing text with entities (rojaro)  
BUG: Issue#134 - XLIFF files have hardcoded source language (rojaro)  
BUG: Issue#181 - Prado client-side flawed - aka Multiple client-side (JS) object instances created for the same single DOM control (uacaman)  
BUG: Issue#226 - TTimerControl fires immediately (rojaro)  
BUG: Issue#227 - Clientscript.php return last-modified date header for scripts (rojaro)  
BUG: Issue#229 - Typo in TCachePageStatePersister.php (Christophe)  
BUG: Issue#230 - TCachingStatement property access not working (rojaro)  
BUG: Issue#232 - Could not change enable-state of TActiveCheckBox via Ajax callback (Christophe)  
BUG: Issue#233 - THtmlWriter flush() doesn't result the contents of the output buffer (rojaro)  
BUG: Issue#234 - Unable to override default HTML writer / pointless THttpResponse::HtmlWriterType (uacaman)  
BUG: Issue#236 - Bug in getIsView() in TOracleMetaData (rojaro)  
BUG: Issue#239 - set_magic_quotes_runtime is deprecate since php 5.3.0 and will be removed in 6.0 (rojaro)  
BUG: Issue#246 - TQueue::peek returns the top not the bottom (Christophe)  
BUG: Issue#261 - TRequiredFieldValidator attached to TCheckBox client side implementation broken in 3.1.7 (ctrlaltca)  
BUG: Issue#268 - String comparison with "=" does not work in Mysql 5.1 (rojaro)  
BUG: Issue#270 - TPage private attribute \_restPostData does not allow one to extends TPage (uacaman)  
BUG: Issue#273 - Typo in TURLMapping->getPatternMatches UrlFormat="Path" (rojaro)  
BUG: Issue#276 - TListItemCollection never existed caused by Warning "PradoBase::include_once(TListItemCollection.php)" (rojaro)  
BUG: Issue#277 - Inconsistence in setting 'day' value in TDatePicker (rojaro)  
BUG: Issue#278 - Typo in file TActiveRecordRelation (rojaro)  
BUG: Issue#281 - THtmlArea bad mapping Japanese language (ctrlaltca)  
BUG: Issue#285 - getPathOfNamespace returns cached namespace and ignores ext (rojaro)  
BUG: Issue#286 - TBoundColumn->initializeCell bugs (rojaro)  
BUG: Issue#287 - Inconsistent behavior in TSimpleDateFormatter->parse() (rojaro)  
BUG: Issue#288 - Fixed two bugs in the Translation->init() method (rojaro)  
BUG: Issue#294 - Better handling of missing array parameters in SQLMap (rojaro)  
BUG: Issue#296 - URL tag not being parsed in component attributes (rojaro)  
BUG: Issue#300 - Minor error in TErrorHandler.php (rojaro)  
BUG: Issue#301 - TActiveFileUpload problems (rojaro)  
BUG: Issue#304 - Possible security issue in cookies (rojaro)  
BUG: Issue#305 - Password type TTextBox does not support AutoCompleteType (rojaro)  
BUG: Issue#319 - When TPanel's DefaultButton property is set to a TActiveButton it inhibits TButton's postbacks (ctrlaltca)  
BUG: Issue#324 - TTabPanel doesn't render properly upon postback if a TTabView's visible property = false (ctrlaltca)  
ENH: Security manager: removed the zero byte right trim from the decryption routine and also made some cosmetic changes (rojaro)  
ENH: Upgraded the phpunit ini file to work with PHPUnit 3.3 3.4 and 3.5. There are conditionals for 3.3 and 3.4. No more Framework file includes are needed with 3.5. (javalizard)  
ENH: Issue#264 - Prado wasting CPU by using ArrayAccess and IteratorAggregate interfaces (uacaman)  
ENH: Issue#199/272 - Updated prototype to 1.7 scriptaculous to 1.9.0 and dropped json.js for json2.js. Adds IE9 support (ctrlaltca)  
ENH: Updated tinyMCE to latest version (3.4.2). The package size grew up a bit (from 3.7 to 5.5 mb) since the new version is bigger in sizea and adds support for a lot of new localizations. Adds IE9 support (ctrlaltca)  

## Version 3.1.7 February 22, 2010
ENH: Issue#24  - Specify needed fields on demand (Yves)  
BUG: Issue#80  - Inconsistencies in TRegularExpressionValidator (Christophe)  
BUG: Issue#86  - THttpSession.CookieMode ignored / Session ID leak (Christophe)  
BUG: Issue#94  - DataGrid header/footer renderers unable to locate their parent grid in setData() method (Christophe)  
BUG: Issue#113/195 - THttpRequest -> getPathInfo doesn't work on servers when cgi.fix_pathinfo=1 (Yves)  
BUG: Issue#151 - TTextBox fails to display inital line break (Yves)  
BUG: Issue#153 - Bug with calls like MyActiveRedorc->withText()->withUser()->find(...) and null result (Christophe)  
BUG: Issue#157 - Enabled does not work properly on TActiveRadioButton/CheckBoxList controls (Bradley, Carl)  
BUG: Issue#166 - E_NOTICE level error in TDataGatewayCommand (Carl)  
BUG: Issue#169 - FlushOnExecute on Basic CacheModel flushes all Application Cache (E.Letard, Christophe)  
BUG: Issue#171 - \<connection> tag in SqlMap config ignored in 3.1.5 and above, introduced by solving Issue#68 (Yves)  
EHN: Issue#184 - THttpResponse doesn't support custom Content-Type headers, remove charset part of header if THttpResponse.Charset=false (Yves)  
BUG: Issue#188 - TDbCache doesn't check if db connection is active. (Yves)  
BUG: Issue#189 - Page State corrupted when EnableStateValidation=False (Christophe)  
BUG: Issue#191 - Bad parsing of MySQL ENUM type column (Yves)  
BUG: Issue#192 - soap-enc:Array not a valid complex type (mosonyi at esix.hu)  
BUG: Issue#189 - Page State corrupted when EnableStateValidation=False (Christophe)  
BUG: Issue#198 - "Undefined variable: tagName" after error in application configuration. (Christophe)  
BUG: Issue#200 - TShellApplication failed when no service are defined in application configuration. (Christophe)  
BUG: Issue#208 - TDbConnection.Charset not working properly (googlenew at pcforum.hu, Christophe)  
BUG: Issue#209 - SqlMap doesn't escape inline params properly (Yves)  
BUG: Issue#212 - Mistaken query executed by TMysqlMetaData (pbenny, Christophe)  
BUG: Issue#216 - TTabPanel doesn't preserve active tab on callback request (googlenew at pcforum.hu,Christophe)  
BUG: Issue~223 - TXmlElement doesn't support all types in attributes - fails to save (Christophe)  
BUG: Typo in TBoundColumn (Robin)  
BUG: TActiveDatePicker js error when date format does not have the 3 elements (Christophe)  
ENH: Add property ClientScriptManagerClass to TPageService and releated changes in TPage.getClientScript() (Yves)  
ENH: Always render clientside counterparts of validation control even if not enabled, but pass-through Enabled property, to allow Enabled/Disable of validator on callback. (Yves)  
EHN: Add property TValidationSummary.ScrollToSummary to server-side control since property exists on client-side. (Yves)  
EHN: Add property TransactionClass (defaults to System.Data.TDbTransaction) to TDbConnection and modify beginTransaction() (Yves)  
ENH: Modify TDbTableInfo::getColumnNames() to store result in private class member (Yves)  
ENH: Issue#215 - Add ClientSide property to TDropContainer (googlenew at pcforum.hu, Christophe)  
ENH: Issue#222 - Add Columns property to TInPlaceTextBox (Christophe)  
CHG: Issue#218 - Change URL of Javascript Logger (Christophe)  
EHN: Clientside performance (micro)optimization: Declare local javascript variables explicit as local to avoid scope chain lookups (Yves)  

## Version 3.1.6 July 22, 2009
BUG: Issue#98 - Missing file in quickstart demo (Chrisotphe)  
BUG: Issue#105 - Enabling/disabling TFileUpload on TPanel (Carl)  
BUG: Issue#115 - Clientside registry of serverside controls don't cover all controls: Prado.WebUI.TAutoComplete, Prado.WebUI.TInPlaceTextBox (Yves)  
BUG: Issue#117 - Consider TValidationSummary.DisplayMode="HeaderOnly" if TValidationSummary.ShowMessageBox is set (Yves)  
BUG: Issue#164 - CultureInfo::validCulture should be declared as a static method (Christophe)  
BUG: Issue#168 - TSqlMapXmlConfiguration: CacheModel properties are not set (Yves)  
BUG: Issue#172 - TDbCache fails to recognize need to re-create cache table (Yves)  
BUG: Issue#105 - Enabling/disabling TFileUpload on TPanel (Carl)  
BUG: Issue#178 - TActiveFileUpload progress indicator is misleading (Christophe, googlenew-at-pcforum.hu)  
ENH: Issue#174 - TErrorHandler: HTTP error messages contains sensitive information (Yves)  
ENH: Issue#175 - TBulletedList: Introduce TBulletStyle::None (Yves)  
ENH: Issue#176 - THttpResponse::writeFile() add additional parameters to take more influence on behavior (forceDownload, clientFileName, fileSize), add png to defaultMimeTypes (Yves)  
BUG: TCallbackErrorHandler::displayException() force HTTP status "500 Internal Server Error" to ensure TCallbackOptions.ClientSide.OnFailure is raised (Yves)  
ENH: TAssetManager: introduce protected property "Published" to allow subclasses access (Yves)  
ENH: TFirePhpLogRoute: bypass to TBrowserLogRoute if headers already sent / php.ini (output_buffering=Off, implicit_flush=On) (Yves)  
EHN: Performance optimization in PradoBase::createComponent() (Yves)  
EHN: Add property TPage.EnableStateCompression and related modifications in TPageStateFormatter since it is unnecessary to compress clientstate if TCachePageStatePersister/TSessionPageStatePersister is used (Yves)  
ENH: Add property CssClass to TBrowserLog otuput and hide inline CSS (Carl)  

## Version 3.1.5 May 24, 2009
BUG: Issue#55 - TPropertyAccess.get and has don't recognize magic getter \__get (Yves)  
BUG: Issue#68 - TSqlMapConfig::createSqlMapGateway(): assign current connection to cached TSqlMapManager to avoid loosing active transaction (Yves)  
BUG: Issue#87 - TinyMCE : empty string disapears after encoding JS, that's a problem! (Christophe)  
BUG: Issue#88 - SQLMap $Param$ re-evaluation bug (Yves)  
BUG: Issue#95 - TMysqlMetaData::getShowCreateTable() throws TPhpErrorException "[Notice] Undefined index: Create Table" if table is a view (Yves)  
BUG: Issue#96 - THttpResponse::redirect don't send status code (Christophe)  
BUG: Issue#99 - TActiveRecord::save(): confusion with order of keys in table/index (Christophe)  
BUG: Issue#108 - clientscripts.php: prepending set_time_limit(0) call with an "@" to suppress PHP warning in safe mode (Yves)  
BUG: Issue#107 - typo in TDbConnection::getCharset() (Christophe)  
BUG: Issue#120 - TActiveDropDownList PromptText and PromptValue got lost during callback and data rebind (Yves)  
BUG: Issue#122 - SqlMap: support for properties in resource filenames, fix sqlmap doc - property "name" instead of "key" (Yves)  
BUG: Issue#126 - THtmlArea: boolean options output as strings (Christophe)  
BUG: Issue#127 - TDataSourceConfig::findConnectionByID try to access private var (Cristophe)  
BUG: Issue#129 - TDbLogRoute::init don't close the sql command (Christophe)  
BUG: Issue#130 - TDbLogRoute::processLogs wrong values binding (Christophe)  
BUG: Issue#136 - TActiveDatePicker don't callback when ShowCalendar is false (Christophe)  
BUG: Issue#139 - add schema support to TActiveRecordRelation::findForeignKeys() (Yves)  
BUG: Issue#148 - Bad Oracle Support (E.Letard)  
BUG: Issue#150 - Multiple TDropContainers in same namingcontainer give error (Christophe)  
Bug: Issue#154 - Bug in TOracleMetaData.php causing SqlMap not work with Oracle database (Christophe)  
BUG: Issue#161 - SqlMap add cache dependencies if TApplicationMode Debug/Normal (Yves)  
BUG: URL wildcard patterns didn't work with subfolders
BUG: TDbLogRoute::createDbTable: add AUTO_INCREMENT attribute to log_id column if driver is mysql (Yves)  
BUG: Ensure rendering of clientID in TActivePanel (Christophe)  
BUG: TPgsqlTableInfo::getTableFullName() return void if no schema given
BUG/ENH: TSqlMapCacheModel now consider <flushInterval> tag as described in doc (sqlmap.pdf) - valid attributes are duration in sec or seconds, minutes, hours, days (Yves)  
BUG/ENH: Issue#112 - TXmlDocument add support for namespaces: for backward compatibility only if SimpleXml installed (Yves)  
ENH: Issue#115 - Registry for Prado generated clientside counterparts of serverside controls (Yves Berkholz)  
ENH: Issue#117 - TValidationSummary: new display mode "HeaderOnly" that only render value of HeaderText property (Yves)  
ENH: Issue#135 - Add AutoPostBack property to TActiveFileUpload (Bradley)  
ENH: Issue#146 - replace deprecated(php5.3>) split with explode in TPgsqlMetaData:getPrimaryKeys(), PradoBase::getUserLanguages() (Yves)  
ENH: Issue#141 - TDbCache performance: modify structure of indices, new property 'FlushInterval' to control how often expired items will be removed (Yves)  
ENH: Issue#74 - Introduce a new property 'InvalidFinderResult' (related enum TActiveRecordInvalidFinderResult) to TActiveRecordConfig, TActiveRecordManager, TActiveRecord that allows to control how TActiveRecord react if an invalid magic-finder invoked (Yves)  
CHG: Issue#7 - Clients Scripts are not combined anymore in Debug application mode (Christophe)  
ENH: Added caching of message files to TException (Michael)  
ENH: Updated to scriptaculous 1.8.2 & Prototype 1.6.0.3
ENH: clientscripts.php Updated to JSMin 1.1.1 - According to author 15% faster with 94% less memory usage (Yves)  
ENH: replace is_null() function calls with native language constuct (Yves)  
ENH: replace array_push() function calls with native language constuct if make sense (Yves)  
ENH: TBrowserLogRoute: add table-layout:auto and explicit set column with to avoid bad render behavior in table-layout:fixed environment, explicit set text color to increase readability (Yves)  
ENH: new log route subclass for FirePHP: TFirePhpLogRoute - FirePHP is ideally suited for AJAX development where clean JSON and XML responses are required (Yves)  
ENH: TBaseValidator, TCustomValidator: change visibilty (protected => public) of getValidationTarget() (Yves)  

## Version 3.1.4 January 11, 2009
BUG: Issue#9  - Global page properties are ignored when using external configuration (Christophe)  
BUG: Issue#59 - TPropertyAccess::has() returns false even if the property of an object was found (Carl)  
BUG: Issue#61 - TLogRouter throws exception when using external config file (Michael)  
BUG: Issue#62 - Some mistyping: TJavascript or TJavaScript? (Carl)  
BUG: Issue#79 - Missing new operator for Exception in TSqlMapObjectCollectionTree::onChildNodesVisited() (Christophe)  
BUG: TActiveLinkButton and TActiveRadioButtonList crashes if it's the only active control imported. Added TActiveControlAdapter (Carl)  
BUG: TUrlMapping encoded extra parameters twice (Michael)  
BUG: Issue#89 - TActiveFileUpload doesn't work (Carl)  
CHG: Removal of generator meta tag in THead
ENH: TActiveCheckBox, TActiveRadioButton, TActiveDropDownList, TActiveListBox won't raise callback if AutoPostBack is false (Christophe)  
ENH: Issue#36 - Refactored TRatingList/TActiveRatingList, and added some docs (Bradley)  
ENH: Issue#52 - Upgraded to TinyMCE 3.2.1
ENH: Issue#72 - Add wildcard support to TUrlMapping (friendly-urls) (Michael)  
ENH: Issue#77 - TJsonService missing exception messages (Carl)  
ENH: Issue#29 -	Ability to specify position of popup TDatePicker/TActiveDatePicker (Carl)  
ENH: Issue#75 - TApplication::setRuntimePath() to update uniqueID and cacheFile (Carl)  
ENH: Issue#64 - Don't throw exception on wrong value for TListcontrols (Carl)  
ENH: Issue#65 - Improvement of TActiveRecord::populateObjects() (Christophe)  
NEW: Issue#51 - Additional template tag (Carl)  

## Version 3.1.3 November 1, 2008
BUG: Ticket#595 - ControlCssClass not applied correctly if using multiple validators on same control (Michael)  
BUG: Ticket#834 - TDbCommandBuilder::applyOrdering(): Add support for function calls in ORDER BY clause (Knut)  
BUG: Ticket#836 - TRatingList downgrade (Christophe)  
BUG: Ticket#841 - Strange output from THttpResponse (Christophe)  
BUG: Ticket#847 - getBaseUrl sometimes fails (Christophe)  
BUG: Ticket#843 - TDataList alternatinItem issue after changes in rev 2227 (Christophe)  
BUG: Ticket#845 - TCaptchaValidator with TCaptcha.CaseSensitive=false JS Error (Christophe)  
BUG: Ticket#849 - TDatePicker selecting current date problem (Christophe)  
BUG: Ticket#851 - TPropertyAccess doesn't get properties right if an object has a \__call() method (Simon Lehmann, Knut)  
BUG: Ticket#855 - TActiveRecord: Make db-connection serializable in \__sleep() function (Knut)  
BUG: Ticket#856 - Assets PRADO_CHMOD constant missing in several places (Carl)  
BUG: Ticket#859 - errorhandler error (stever)  
BUG: Ticket#860 - Prado::localize() bug (japplegame)  
BUG: Ticket#865 - TActiveLabels always get an id attribute (Michael)  
BUG: Ticket#870 - Callback with redirect breaks lifecycle of page (stever)  
BUG: Ticket#872 - use PATH_SEPARATOR in phpunit.php (fragmaster b)  
BUG: Ticket#886 - TSimpleDateFormatter: One month offset in time stamp with date pattern "yyyy" (Knut)  
BUG: Ticket#897 - TSimpleDateFormatter: If no YearPattern is set it should default to current year (Knut)  
BUG: Ticket#899 - TSqlCriteria: SQL-statements with limit and offset doesn't work (Knut)  
BUG: Ticket#900 - TDataGrid with TRequireFieldValidator and TEditCommandColumn interaction error (Michael)  
BUG: Ticket#904 - TDbConnection: Add emulate prepares workaround for boolean compares (Knut)  
BUG: Ticket#908 - TDbCache::init / Exception (Knut)  
BUG: Ticket#922 - Problem with TUrlMapping and urlencoding (Michael)  
BUG: Ticket#938 - TPageStateFormatter EnableStateEncryption causes massive page state (Michael)  
BUG: Ticket#942 - MultiLine TInplaceTextBox (Christophe)  
BUG: Issue#38 - TValidationSummary, works different when it's showing Javascript Validation than Server Validation (Carl)  
CHG: Ticket#844 - Upgraded TinyMCE to 3.1.0.1 (Christophe)  
CHG: Ticket#917 - TUrlMapping - change members to protected (Michael)  
CHG: Ticket#919 - TUserManager loadUserData function (Michael)  
CHG: Issue#39 - Implement validator not requiring ControlToValidate (Carl)  
ENH: Workaround for slow meta data retrieval in MySQL<5.1.21 (Michael)  
ENH: Ticket#756 - TDateFormat & TNumberFormat - allow settings default text when Value isn't set. (Carl)  
ENH: Ticket#823 - PromptText/PromptValue only populated if there is data (Knut)  
ENH: Ticket#876 - Assign empty string to CssUrl on TTabPanel to avoid loading extra css (GoDZilla, Knut)  
ENH: Ticket#882 - Allow to escape # and $ in sqlmap (Michael)  
ENH: Ticket#890 - Minor optimization: Use $var===null over is_null($var) (Knut)  
ENH: Ticket#893 - Added page parameter to queryForPagedList() to specify the initial page to load (Michael)  
ENH: Ticket#896 - TTheme - enhance for subclassing (Knut)  
ENH: Ticket#898 - Minor optimization: Use (int) over intval() (Knut)  
ENH: Ticket#813 - (Issue #13) TRegularExpressionValidator has new ClientSidePatternModifier property (Michael)  
ENH: Ticket#809 - "LIMIT 1" for ActiveRecord find() and findBy() (Carl)  
ENH: Ticket#848 - TCache "set" and "add" with empty values (Carl)  
ENH: Ticket#822 - Not receiving emails from TEmailLogRoute (Carl)  
ENH: Ticket#901 - Using TDbDataReader directly as a DataSource of TDataBoundControl's like TDataGrid (Knut)  
ENH: Ticket#911 - prado-cli: Better error message if database connection fails when generating Active Record skeletons (Knut)  
ENH: Ticket#913 - PRADO Copyright notice in HTML source (Carl)  
ENH: Ticket#925 - TTimeTriggeredCallback update interval during callback (Brad, Christophe)  
ENH: Ticket#941 - Add addRoute() method to TLogRouter (Michael)  
ENH: Ticket#46 - TColorPicker - Output is missing alt tag (Carl)  
ENH: Issue#32 - Implement ability to specify default service ID (Carl)  
ENH: Issue#31 - Consider UTF MessageSource_XLIFF class file (Carl)  
NEW: Added Prado.Validation.validateControl(id) on client side to validate a specific control (Michael)  
NEW: Added MessageSource_Database to I18N (uses TDbConnection) (Michael)  
NEW: Ticket#790 - Added TActiveFileUpload (Bradley, Christophe)  
NEW: Ticket#935 - Added TActiveDatePicker (Bradley, Christophe)  
NEW: Ticket#857 - Added Authentication expiration support to TAuthManager (Michael)  
NEW: Ticket#853 - Added Drag and drop components (Christophe)  
NEW: Ticket#891 - Added method that returns table name to TActiveRecord (Michael)  

## Version 3.1.2 April 21, 2008
BUG: Ticket#595 - ControlCssClass not applied correctly if using multiple validators on same control (Christophe)  
BUG: Ticket#622 - Changing Display-attribute of a TActiveCheckBox dynamically isn't possible (Michael)  
BUG: Ticket#636 - I18N catalogue problem (Christophe)  
BUG: Ticket#669 - Strange rendering behaviour with TActivePanel (Christophe)  
BUG: Ticket#671 - TActiveCustomValidator Callback Problem (Christophe)  
BUG: Ticket#679 - TActiveLabel can't be shown from inside TRepeater. TActiveRadioButton cant be unchecked (Christophe)  
BUG: Ticket#695 - ActiveTextBox filled in IE blocks other elements (Michael)  
BUG: Ticket#707 - TPropertyAccess sets property twice on object when using setters (Qiang)  
BUG: Ticket#718 - prop:ClientSide OnLoading don't work in Opera (Christophe)  
BUG: Ticket#719 - TAutoCompleter should not trigger Validation if CausesValidation=False (Christophe)  
BUG: Ticket#721 - TActiveCustomValidator + TValidationSummary problem (Christophe)  
BUG: Ticket#736 - Files never created in clientscript.php (Qiang)  
BUG: Ticket#744 - Callback error handling is improved (Qiang)  
BUG: Ticket#747 - TRangeValidator accept letters when type Integer is specified (Christophe)  
BUG: Ticket#750 - The "expire" parameter is used inconsistently in cache modules (Qiang)  
BUG: Ticket#753 - Themes not allways being set (Qiang)  
BUG: Ticket#754 - CultureInfo constructor errors (Qiang)  
BUG: Ticket#759 - TSlider wrong layout with horizontal with center horizontal align (Christophe)  
BUG: Ticket#769 - Problem with Validator inside TActivePanel (Christophe)  
BUG: Ticket#776 - Logout button should not cause validation in blog tutorial (Qiang)  
BUG: Ticket#785 - TDatePicker OnDateChanged event problem (Christophe)  
BUG: Ticket#787 - Typo in validation3.js (Christophe)  
BUG: Ticket#766, #786 - TDbCache does not work with MySQL and PostgreSQL (Qiang)  
BUG: Ticket#799 - Fixed several link errors in documentation about PDO (Qiang)  
BUG: Ticket#803 - TActiveRecord cannot be serialized/unserialized correctly. (Qiang)  
BUG: Ticket#808 - Client side validation should work for file upload. (Qiang)  
BUG: Ticket#828 - Validators not working when RepeatLayout="Raw" (Qiang)  
BUG: Fixed a bug in TPropertyValue::ensureArray() (Qiang)  
CHG: Ticket#819 - TLogRoute now displays GM time instead of local time (Qiang)  
CHG: Changed TConditional so that the controls in its template behave like they are in its parent (Qiang)  
CHG: Active Record many-to-many relationship change from self::HAS_MANY to self::MANY_TO_MANY (Wei)  
CHG: Active Record no longer automatically performs adding/removing/updating related objects (Qiang)  
CHG: TJavaScript::encode() will encode data as a list if integer indices are detected (Qiang)  
CHG: Ticket#755 - Upgraded to Prototype 1.6 and Scriptaculous 1.8 (j, Christophe)  
ENH: Ticket#660 - Using Globalization.Charset in JSON for AJAX Callbacks (Michael)  
ENH: Ticket#722 - Added Read Only capabilities to TInPlaceTextBox (Christophe)  
ENH: Ticket#741 - Added CDbConnection.currentTransaction property (Qiang)  
ENH: Ticket#743 - Added status code header in HTTP response when in error (Qiang)  
ENH: Ticket#745 - TWizard action MoveTo - allow specify step ID's (Christophe)  
ENH: Ticket#757 - TDateFormat and TNumberFormat now implement IDataRenderer (Qiang)  
EHH: Ticket#770 - THttpResponse send HTTP 1.1 Status code to the client (Christophe)  
ENH: Ticket#783 - Added date/time type support to soap implementation (Hongliang)  
ENH: Ticket#800,#833 - Added database connection charset for MySql and PgSql (donkee)  
ENH: Active Record supports multiple foreign references of the same table (Wei)  
ENH: Added TDbCommand.queryColumn() (Qiang)  
ENH: Active Record now supports implicitly declared related properties (Qiang)  
ENH: Active Record now supports query criteria for implicitly declared related properties (Qiang)  
ENH: TDataFieldAccessor now supports chained property access without getters. (Qiang)  
ENH: TParameterModule added caching support (Qiang)  
ENH: Added TAuthManager.switchUser() (Qiang)  
NEW: Added TDbLogRoute (Qiang)  
NEW: Added TDataRenderer and TItemDataRenderer (Qiang)  
NEW: Added THtmlElement (Qiang)  
NEW: Ticket#544 - Added TXCache (Wei)  
NEW: Ticket#729 - Added TActivePager (Christophe)  
NEW: Ticket#791 - Added TFirebugLogRoute (Christophe)  

## Version 3.1.1 October 1, 2007
BUG: Ticket#340 - Callbacks and Firebug compatibility problem (Christophe)  
BUG: Ticket#533 - HttpRequest::getBrowser() throws an error if browsercap.ini is invalid (Carl)  
BUG: Ticket#592 - TRadioButton with UniqueGroupName always return false to getChecked (Christophe)  
BUG: Ticket#648 - Validation: onClick and onBlur events order (Christophe)  
BUG: Ticket#656 - TDatePicker does not return correct value when in callback mode (Christophe)  
BUG: Ticket#661 - ActiveRecord PostgreSQL 7.3.2 Support doesn't work (Qiang)  
BUG: Ticket#662 - Ensure TForm to properly encode the ampersand in action URL (Qiang)  
BUG: Ticket#666 - TActiveRecord::deleteAll() method always requires a criteria or null parameter (Qiang)  
BUG: Ticket#670 - TDatePicker: Year Issue (Christophe)  
BUG: Ticket#689 - TRangeValidator: Problem in clientscript when MaxValue=<%= 0 %> (Qiang)  
ENH: Ticket#370 - TDataGrid now supports grouping cells (Qiang)  
ENH: Ticket#577 - Added image button support for TPager (Qiang)  
ENH: Ticket#623 - TMemCache to support multiple servers (Carl)  
ENH: Ticket#664 - Added support to styling thead, tbody, tfoot of TDataGrid (Qiang)  
ENH: Ticket#665 - Added support to column mapping in Active Record (Qiang)  
ENH: Ticket#667 - Added TFeedService.ContentType property (Qiang)  
ENH: Ticket#672 - ForceSecureConnection to THttpRequest (Carl)  
ENH: Ticket#676 - Updated ActiveRecord Oracle Drives (Qiang)  
ENH: Ticket#678 - Improved DateTimeFormatInfo performance (Stever)  
ENH: Ticket#681 - TUrlMapping can construct custom URLs now (Qiang)  
ENH: Ticket#692,700 - Added support to wildcard in pages configuration; added IP filters in auth rules. (Qiang)  
ENH: Ticket#709 - Added TDbCache.ConnectionID (Qiang)  
ENH: Added THead requirement check (Qiang)  
ENH: Added TOutputCache.CacheTime (Qiang)  
ENH: Added "remember login" support to TAuthManager and the related modules/classes (Qiang)  
ENH: Added prompt text support to TDropDownList and TListBox (Qiang)  
CHG: Ticket#685 - Slashes and backslashes mixup in PradoBase (Qiang)  
CHG: Ticket#705 - TImage will not set border style by default (Qiang)  
CHG: GeSHi is replaced with Text_Highlighter (Christophe)  
CHG: Changed the way to declare relationships in Active Record (Qiang)  
CHG: Validators will not validate disabled controls (Qiang)  
NEW: Ticket#676 - Added primilary Oracle support (Christophe)  
NEW: Ticket#680 - Added TCacheHttpSession (Carl, Qiang)  
NEW: Added TTabPanel (Qiang)  
NEW: Added TKeyboard (Qiang)  
NEW: Added TCaptcha and TCaptchaValidator (Qiang)  
NEW: Added TCachePageStatePersister (Qiang)  
NEW: Added TSlider (Christophe)  
NEW: Added TConditional (Qiang)  
NEW: Added Indonesian translation to QuickStart, requirements and error messages (Zaenal Mutaqin)  
NEW: Added French translation to the blog tutorial (Eric Marchetti)  

## Version 3.1.0 July 2, 2007
BUG: Ticket#621 - TWizardNavigationButtonStyle could not be found (Qiang)  
BUG: Ticket#627 - Logout did not set correct status to the user object (Qiang)  
BUG: Ticket#650 - Fixed TMysqlMetaData bug about SHOW FULL TABLES (Qiang)  
BUG: Ticket#651 - TUserManager Roles names (from config) should be trimmed (Qiang)  
BUG: Ticket#652 - OFFSET must be specified together with LIMIT for TScaffoldView (Qiang)  
BUG: Ticket#653 - TUrlMapping: ServiceId irgnored in URL-Map (Qiang)  
BUG: Ticket#488 - TActiveCustomValidator Is Bypassing My Callback (Wei)  
BUG: Ticket#620 - PRADO should not take over all of Prototype's Callbacks (Wei)  
BUG: Ticket#635 - TDatePicker not correctly updating month (Christophe)  
BUG: Ticket#649 - Wrong error message in THttpCookieCollection::itemAt() (Knut)  
BUG: Ticket#654 - TAssetManager::copyDirectory() do not run closedir on an invalid resource (Knut)  
BUG: Ticket#655 - TAssetManager::publishTarFile() exception for 'assetmanager_tarchecksum_invalid' is not thrown on BSD systems (Knut)  
BUG: Ticket#659 - Asset is not published correctly for child classes (Qiang)  
BUG: TWizard Sidebar using TDataListItemRenderer has error (Qiang)  
BUG: TOutputCache crashes when a default button is set (Qiang)  
BUG: Fixed several typos in TDbCache (Qiang)  
BUG: Fix the bug that <include> tag was ignored in page configurations (Qiang)  
ENH: Ticket#625 - Added @ to represent authenticated users in auth rules (Qiang)  
ENH: Ticket#631 - Make TQueue implement Countable as the other collection classes (Knut)  
ENH: Ticket#634 - Override \__toString for TXmlElement and TXmlDocument (Knut)  
ENH: Ticket#639 - Added setters for certain properties of TTheme (Qiang)  
ENH: Ticket#641 - Added support to find out controls of specified class or parent classes (Qiang)  
ENH: Ticket#646 - Implement TAPCCache::add() (Knut)  
ENH: Added TAuthManager.ReturnUrlVarName property (Qiang)  
ENH: Added TPageService.DefaultPageUrl property (Qiang)  
NEW: TActiveHiddenField (Carl)  

## Version 3.1.0 RC May 14, 2007
BUG: Ticket#525 - SQLMap->queryForList error with offset/limit parameters (Wei)  
BUG: Ticket#547 - SQLMap problem with PDO::DBLIB (Wei)  
BUG: Ticket#578 - ActiveControls broken by presence of THtmlArea in the .page (Wei)  
BUG: Ticket#587 - TActiveDropDownList doesn't work if modified during TAutoComplete callback (Wei)  
BUG: Ticket#598 - ClientSide.HasPriority raises JS Exception (Wei)  
BUG: Ticket#599 - Searching in QuickStart Tutorial generate TInvalidOperationException (Qiang)  
BUG: Ticket#600 - Searching in the Quickstart Tutorial is throwing out the error (Qiang)  
BUG: Ticket#602 - DateTimeFormatInfo missing data (Wei)  
BUG: Ticket#603 - THtmlArea problem after callback - "this.getDoc() has no properties"
BUG: Ticket#605 - TDatePicker don't works in 3.1.b on linux server (Wei)  
BUG: Ticket#606 - TColorPicker bug in Full mode (Wei)  
BUG: Ticket#612 - Documentation Problem on THttpResponse:writeFile() (Qiang)  
BUG: Ticket#616 - SqlMap properties are not replaced in config files (Wei)  
BUG: Ticket#618 - SqlMap's TPreparedCommand needs TDbCommandBuilder (Qiang)  
ENH: Ticket#458 - TSqlMap and runQueryForMap method (Wei)  
ENH: Ticket#594 - TInPlaceTextBox ESC and ENTER keys behaviour (Wei)  
ENH: Ticket#601 - TRectangleHotSpot and javascript onclick handler (Qiang)  
ENH: Ticket#609 - TColorPicker event feature and display issue (Wei)  
ENH: Ticket#613 - clientscripts.php is made PHP4-compliant (Qiang)  
ENH: Ticket#617 - Validators: FocusOnError should focus on the first element of the page (Wei)  
ENH: Add javascript references for "slider" and "dragdrop" for TClientScript::PradoScripts (Wei)  
ENH: Added PatternModifiers property to TRegularExpressionValidator (Wei)  
CHG: <div> tags are used instead of <span> when TDataList.RepeatLayout is Raw (Qiang)  
CHG: changed comment tag to <!--- ... ---> (Qiang)  
NEW: Active Record relationships (Wei)  
NEW: New demos including "address-book", "blog-tutorial", "northwind-db", "chat", "currency-converter", "time-tracker". (Qiang, Wei)  


## Version 3.1.0 beta April 9, 2007
BUG: Ticket#278 - client-side validator enable/disable (conditional) (Wei)  
BUG: Ticket#492 - TDataGridPagerStyle not found error (Qiang)  
BUG: Ticket#500 - URL encode in callback (Wei)  
BUG: Ticket#517 - Quickstart I18N sample: conflicting module ID (Wei)  
BUG: Ticket#521 - comment tag on TActiveButton stop callback (Wei)  
BUG: Ticket#526 - TDatePicker Mode="Button" with ActivePanel Enabled="false" (Wei)  
BUG: Ticket#535 - TRadioButton->GroupName bug on callback (Wei)  
BUG: Ticket#538 - TActiveListBox doesn't support optgroup (Wei)  
BUG: Ticket#549 - set/get Timestamp on TDatePicker shound handle "null" values (Qiang)  
BUG: Ticket#550 - explicitly include TCallbackClientSide in TCallbackOptions (Qiang)  
BUG: Ticket#553 - I18N quickstart sample does not work (Qiang)  
BUG: Ticket#555 - TNumberFormat throws exception (Qiang)  
BUG: Ticket#557 - TAutoComplete is not fool-proof (Wei)  
BUG: Ticket#560 - TActiveImageButton broken (Postback instead of Callback) (Wei)  
BUG: Ticket#566 - <%[ tags (localize tags) missing escaping (Qiang)  
BUG: Ticket#573 - NumberFormat Bug (Wei)  
BUG: Ticket#579 - The rating list lost its Javascript in changeset [1775] (Wei).
BUG: Ticket#584 - Parameter names in TTranslate are case-insensitive (Qiang)  
BUG: Ticket#585 - Can't validate TDatePicker with TActiveCustomValidator (Wei)  
BUG: Ticket#586 - Default TPanel Button not working without validator (Wei)  
BUG: TXmlElement did not encode attribute and text values when being saved as a string (Qiang)  
BUG: SelectedIndices not return expected result for ActiveListBox (Wei)  
ENH: Ticket#339 - TAutoComplete ID field [handled by the OnSuggestionSelected event] (Wei)  
ENH: Ticket#367 - Change default extension for XLIFF files (Wei, changed to support .xlf extension).
ENH: Ticket#430 - clearing the validator errors (Wei)  
ENH: Ticket#436 - update script.aculo.us to 1.6.4 (Wei, updated to v 1.7.1beta)  
ENH: Ticket#482 - ADD TinyMCE 2.0.8 (Wei, TinyMCE 2.1 added)  
ENH: Ticket#503 - Localization and parameter tags can now appear as a substring in a property initial value (Qiang)  
ENH: Ticket#513 - Display last modified / revision in quickstart (Wei)  
ENH: Ticket#519 - Update TActiveRecord implementation (Wei)  
ENH: Ticket#537 - TActiveRecord Pk info (Wei)  
ENH: Ticket#561 - Powered by PRADO image to become an asset (Qiang)  
ENH: Ticket#569 - Added TTextBox.PersistPassword property (Qiang)  
ENH: Ticket#571 - Made TPage.ClientSupportsJavaScript property writable (Qiang)  
ENH: Ticket#575 - Made TAuthManager.ReturnUrl property writable (Qiang)  
ENH: Reduced ViewState size significantly by ignoring initial property values set in template (Qiang)  
ENH: Added PRADO_CHMOD constant so that users can specify the permission of PRADO-created directories (Qiang)  
ENH: Added Display property to TWebControl (Wei)  
ENH: Added TUser.getState() and setState() for storing user session data (Qiang)  
ENH: Added renderer feature to TRepeater, TDataList and TDataGrid (Qiang)  
ENH: Added support to include external application configuration files (Qiang)  
ENH: Added PRADO version info in PRADO-generated directories to avoid upgrading issue (Qiang)  
ENH: Improved exception display with hyperlinked keywords (Qiang)  
ENH: Improved exception display about template syntax error (Qiang)  
CHG: Added getDataChanged() to IPostBackDataHandler (Qiang)  
NEW: TShellApplication (Qiang)  
NEW: TDbCache (Qiang)  
NEW: TDbUserManager and TDbUser (Qiang)  
NEW: Active Record driver for IBM DB2 (Cesar Ramos)  
NEW: TActiveRecord Scaffold support (Wei)  
NEW: TClientScriptLoader combines and loads javascript libraries (Wei)  

## Version 3.1.0 alpha January 15, 2007
BUG: Ticket#188 - Postback js caused controls not inheritable (Qiang)  
ENH: Ticket#99 - TXmlTransform control (Knut)  
ENH: Ticket#117 - added support to configure subproperties in a group. (Qiang)  
ENH: Ticket#180, #222 - Prado js files are not rendered at the beginning of the form (Qiang)  
CHG: Ticket#489 - Contents enclosed within HTML comment tags will now be parsed also (Qiang)  
CHG: All validators ClientSide.OnSuccess becomes ClientSide.OnValidationSuccess, and OnSuccess event becomes OnValidationSuccess. (Wei)  
CHG: All validators ClientSide.OnError becomes ClientSide.OnValidationError, and OnError event becomes OnValidationError. (Wei)  
NEW: Ajax support and active controls (Wei)  
NEW: Data abstraction layer based on PDO (Qiang)  
NEW: SQLMap (Wei)  
NEW: Added a new template comment tag <!-- ---> (Qiang)  
NEW: TOutputCache (Qiang)  
NEW: TQueue (Qiang)  
NEW: TSessionPageStatePersister (Qiang)  
NEW: TSoapService, TSoapServer (Knut, Qiang)  
NEW: TFeedService, TRssFeedDocument (Knut, Qiang)  
NEW: TJsonService
NEW: TCacheDependency, TFileCacheDependency, TDirectoryCacheDependency (Qiang)  
NEW: TGlobalStateCacheDependency, TChainedCacheDependency, TApplicationStateCacheDependency (Qiang)  

## Version 3.0.7 April 2, 2007
BUG: Ticket#481 - Unable to cancel navigation when handling OnSideBarButtonClickEvent (Qiang)  
BUG: typo in THttpResponse.writeFile() about sending headers (Qiang)  
BUG: Ticket#505 - cultureInfo::getEnglishName does not return an arrary (Wei)  
BUG: Ticket#508 - CultureInfo class: PHP Notice because of missing static declaration (Wei)  
BUG: Ticket#558 - TRadionButtonList generates a empty onclick attribute (Qiang)  
BUG: Ticket#573 - NumberFormat Bug (Wei)  
BUG: Event handler specified via subproperty in template does not work (Qiang)  
ENH: Ticket#367 - Change default extension for XLIFF files (Wei, changed to support .xlf extension).
ENH: Upgraded javascript library Prototype to version 1.5.0 (Wei)  
ENH: Upgraded javascript library Scriptaculous to version 1.7.0 (Wei)  
ENH: Upgraded TinyMCE editor to version 2.1 (Wei)  

## Version 3.0.6 December 4, 2006
BUG: Ticket#400 - TJavascriptLogger incompatible with Firefox 2.0 RC1 (Wei)  
BUG: Ticket#442 - TPageService getBasePath in namespace form (Qiang)  
BUG: Ticket#443 - Template comment tag messed up with HTML comment tag (Qiang)  
BUG: Ticket#453 - I18N controls should accept UNIX timestamps (Wei)  
BUG: Ticket#463	- TPhpErrorException: Non-static method DateTimeFormatInfo::getInstance() (Wei)  
BUG: Ticket#467 - typo in TUrlMapping.php (Qiang)  
BUG: Ticket#476 - Problem when adding a new text (translate) with MessageSource_XLIFF (Wei)  
BUG: TTableCell should render &nbsp; only when Text is not set and there's no child (Qiang)  
BUG: global state was not saved when redirect() is invoked (Qiang)  
BUG: TPager would not display if it was invisible previously (Qiang)  
ENH: Ticket#446 - Added TMetaTagCollection.getMetaTagByID method (Qiang)  
ENH: Ticket#451 - Modified TUrlMapping to extend from TUrlManager (Qiang)  
ENH: Ticket#468 - Added support of using all property tags in skins (Qiang)  
ENH: Ticket#471 - Added methods in TAssetManager to expose published path and URL (Qiang)  
ENH: Add ToggleKey for TJavascriptLogger (Wei)  
CHG: Ticket#437 - \__autoload is replaced by spl_autoload_register (Qiang)  
CHG: Ticket#454 - Redundant PHP Version Check (Qiang)  
CHG: Ticket#460 - Validators will not perform validation if parents are disabled (Qiang)  
CHG: TDataGrid now does not set default table styles (Qiang)  
CHG: TRepeater does not render <span> anymore for empty item template (Qiang)  
CHG: THttpRequest.constructUrl() now encodes ampersand by default (Qiang)  
CHG: TDataBoundControl will not throw exception if CurrentPageIndex is out of range (Qiang)  
NEW: TUrlManager (Qiang)  


## Version 3.0.5 October 23, 2006
BUG: Ticket#409 - Multiple page services will mess up page caching (Qiang)  
BUG: Ticket#417 - SelectedIndex in template incorrect caused by bug in TList (Qiang)  
CHG: Ticket#358 - TFileUpload::saveAs() now returns false instead of exception when error (Qiang)  
ENH: Ticket#361 - Introduced include template tag that supports including external templates (Qiang)  
ENH: Ticket#366 - white spaces are now allowed around attribute names in template (Qiang)  
ENH: Ticket#378 - PRADO applications can now run in command line (Qiang)  
ENH: Ticket#379 - TAuthorizationRule performance enhancement (Qiang)  
ENH: Ticket#382 - Untranslated messages can be marked now (Wei)  
ENH: Ticket#394 - Enhancing TDropDownListColumn to allow specifying both text and value (Qiang)  
ENH: Easier to customize the TDatePicker using CssClass (Wei)  
ENH: Added an interactive PHP shell, usage: "prado-cli.php shell" (Wei)  
NEW: TLiteralColumn (Qiang)  
NEW: TUrlMapping (Wei)  

## Version 3.0.4 September 4, 2006
BUG: Fixed a bug that would prevent from using <prop:> tag in skins (Qiang)  
BUG: Fixed a typo in TControl::setCustomData() (Qiang)  
ENH: Ticket#336 - Speed up TSqliteCache with LIMIT SQL clause (Qiang)  
ENH: Ticket#348 - Added THead.ShortcutIcon (Qiang)  
ENH: Ticket#349 - Derived control classes now show trace logs when databinding (Qiang)  
ENH: Ticket#357 - Added TListControl.DataGroupField to allow setting optgroup via databinding (Qiang)  
ENH: TListControl.SelectedValues and SelectedIndices can now be set before databinding (Qiang)  
ENH: Upgrade Scriptaculous javascript library to 1.6.2 (Wei)  
ENH: Uses uncompressed javascript in debug mode. (Wei)  
ENH: Cells in TDataGrid rows can now be accessed via the corresponding column IDs (Qiang)  
ENH: Input controls in some datagrid columns can now be accessed in a named fashion (Qiang)  
ENH: Prado::fatalError() now displays function parameter information (Qiang)  
ENH: TEditCommandColumn now supports image buttons (Qiang)  
CHG: Ticket#356 - TLabel will not render if its associated control is invisible (Qiang)  
CHG: Validator the error message visibility before raising events OnError and OnSuccess (Wei)  
CHG: Unify all client-side javascript event handler syntax. (Wei)  
CHG: Added more conditions in the requirement checker (Qiang)  
CHG: TControl::findControlsByType() now only returns objects of the specified type (Qiang)  
CHG: Moved createdOnTemplate() and addParsedObject() from TControl to TComponent (Qiang)  
NEW: TDateTimeStamp class for supporting time stamps outside 1970-2038 using float (Wei)  
NEW: TDropDownListColumn (Qiang)  
NEW: Added TEnumerable and all needed enumerable types (Qiang)  


## Version 3.0.3 August 6, 2006
BUG: Ticket#264 - Typos in some exception throw statements (Knut)  
BUG: Ticket#268 - THttpResponse.redirect() may fail for some browsers (Qiang)  
BUG: Ticket#271 - Page method setFocus doesn't work (Wei)  
BUG: Ticket#285 - NumberFormat Rounding Bug (Wei)  
BUG: Ticket#297 - THttpRequest::constructUrl() encoding bug about array GET parameters (Qiang)  
BUG: Ticket#320 - Typo in calling TDataList::setSelectedItemIndex and a bug in inserting wizard steps (Qiang)  
BUG: TDataGrid may complain getting ItemType on a non-object if the grid is not data-bound (Qiang)  
BUG: TCheckBox.Value should be converted to string (Qiang)  
BUG: Ticket#302 - TDatePicker's bug with AutoPostBack set to "true" (Wei)  
BUG: Ticket#306 - Prado::localize function may fail when localized string passed as parameter (Wei)  
BUG: Ticket#311 - Several bugs in TDatePicker (Wei)  
BUG: Ticket#312 - TDatePicker's ReadOnly property bug (Wei)  
CHG: Ticket#206 - TBaseValidator.OnValidate is raised only when the validator is visible (Qiang)  
CHG: Raised PHP version requirement to 5.1 and above (Qiang)  
ENH: Ticket#178 - Added TRadioButton.UniqueGroupName property (Qiang)  
ENH: Ticket#220 - TClientScripts method to import custom javascript files (Wei)  
ENH: Ticket#225 - TRadioButton::getRadioButtonsInGroup() added (Wei)  
ENH: Ticket#223 - Use TRequiredFieldValidator for TRadioButtons with GroupName property (Wei)  
ENH: StringLength, multi-byte, check in TRangeValidator (Wei)  
ENH: Ticket#263 - TListBox and TDropDownList support optgroup now (Qiang)  
ENH: Ticket#277 - Added TControl.CustomData property (Qiang)  
ENH: Ticket#278 - client-side validator enable/disable (conditional) (Wei)  
ENH: Ticket#287 - TControl::broadcastEvent() may raise events now (Qiang)  
ENH: Ticket#292 - Added THttpRequest::parseUrl() so that it is easier to be extended (Qiang)  
ENH: Ticket#309 - Added THttpRequest.UrlParamSeparator property (Qiang)  
ENH: Ticket#313 - Added TTableStyle.BorderCollapse property (Qiang)  
ENH: Ticket#316 - Added media type support to CSS files in a theme (Qiang)  
ENH: Validating TDatePicker does not need to explictly specific the DateFormat in validators. (Wei)  
ENH: TRequireFieldValidator can be used to validate a valid date (Wei).
NEW: Added TStyleSheet (Wei)  


## Version 3.0.2 July 2, 2006
BUG: Ticket#182 - List and validator controls cause problem in child classes (Qiang)  
BUG: Ticket#191 - Duplicated postbacks occur when using TButton with validators (Qiang)  
BUG: Ticket#207 - Validators ClientSide.OnError triggered twice (Wei)  
BUG: Ticket#213 - PRADO Requirements Checker charset error (Qiang)  
BUG: Ticket#227 - Enabled property doesn't works with THtmlArea (Wei)  
BUG: Ticket#234 - Postback target could be out of date (Qiang)  
BUG: Ticket#239 - Ondeactivate handler for the first View of MultiView is always fired (Qiang)  
BUG: Ticket#244 - redirect() needs absolute URL (Qiang)  
BUG: Ticket#245 - getIsSecureConnection() is not working correctly (Qiang)  
BUG: Ticket#246 - TDatePicker wrong popup position in scrolled div (Wei)  
BUG: Ticket#260 - Wrong value of a configuration option in setUseTransparentSessionID (Qiang)  
CHG: ensureChildControls() is now invoked in TControl::initRecursive (Qiang)  
CHG: Postback enabled control will always disable default client-side browser action. (Qiang)  
CHG: CSS and JS files in a theme are now included in page in alphabetic order (Qiang)  
ENH: Ticket#206 - Added OnValidate, OnError, OnSuccess events to validators (Qiang)  
ENH: Ticket#230 - Added TDataList.EmptyTemplate property (Qiang)  
ENH: Ticket#231 - Added TButton.ButtonType property to allow reset button (Qiang)  
ENH: Ticket#232 - Allow <%# %> and <%= %> embedded within property values (Qiang)  
ENH: Ticket#256 - Datagrid columns can now be accessed via IDs (Qiang)  
ENH: Ticket#257 - OnSelectedIndexChanged event of TDataList and TDataGrid now passes the original command parameter (Qiang)  
ENH: Ticket#262 - Added TCheckBox.Value property (Qiang)  
ENH: TRepeater, TDataList and TDataGrid will store data indices in DataKeys if DataKeyField is not set. (Qiang)  
ENH: Added TPageService.BasePageClass property (Qiang)  
ENH: Added TDataGrid.EmptyTemplate property (Qiang)  
ENH: Added paging feature to all TDataBoundControl-derived controls (Qiang)  
ENH: ClientSide.ObserveChanges="false" to only revalidate client side validator when control changes (Wei)  
NEW: Added TPager (Qiang)  
NEW: Added Dreamweaver taglib extension (Stanislav, Qiang)  
NEW: Prado Command line script to create a new project, see framework/prado-cli.php (Wei)  

## Version 3.0.1 June 4, 2006
BUG: Ticket#28 - OnClick does not work with Safari/KHTML (Wei)  
BUG: Ticket#37 - Changes of config files do not trigger cache update (Qiang)  
BUG: Ticket#44 - THtmlArea (tiny_mce) not working on some systems (Qiang)  
BUG: Ticket#162 - Missing currency sign in TNumberFormat if Value is 0 (Wei)  
BUG: Ticket#167 - TSecurityManager issues warning when trying to encrypt/decrypt strings (Qiang)  
BUG: Ticket#169 - Validation of subclass of THtmlArea/TDatePicker fails (Wei)  
BUG: Ticket#179 - CGI incompatibility causing clientscripts.php failure (Qiang)  
BUG: Ticket#181 - Unable to change Content-Type in response header if charset is not set (Qiang)  
BUG: Ticket#200 - onClick javascript event triggered twice on CheckBox label (Qiang)  
BUG: newly created controls during postbacks might get their initial states reset during loadStateRecursive. (Qiang)  
ENH: Ticket#150 - TDataGrid and TDataList now render table section tags (Qiang)  
ENH: Ticket#152 - constituent parts of TWizard are exposed (Qiang)  
ENH: Ticket#184 - added TUserManager.Users and Roles properties (Qiang)  
ENH: Ticket#197 - sanity check for datagrid header and footer (Qiang)  
ENH: added sanity check to calling event handlers (Qiang)  
ENH: added search for quickstart tutorials (Wei)  
ENH: added support to property tags for template owner control (Qiang)  
ENH: added Bulgarian requirement checker messages (StanProg)  
ENH: added TTheme.BaseUrl and TTheme.BasePath property (Qiang)  
ENH: added TListControl.SelectedValues property (Qiang)  
ENH: added TThemeManager.AvailableThemes property (Qiang)  
ENH: refactored TUserManager and TAuthManager so that they are easier to be extended (Qiang)  
ENH: template syntax now supports setting event handler via subproperties (Qiang)  
CHG: Ticket#151 - URL format is modified to handle empty GET values (Qiang)  
CHG: Ticket#153 - TAssetManager now ignores .svn directories (Qiang)  
CHG: Changed TControl::onBubbleEvent() to TControl::bubbleEvent() (Qiang)  
NEW: TTableHeaderRow, TTableFooterRow and table section support (Qiang)  
NEW: TCompositeControl (Qiang)  
NEW: TTextProcessor (Qiang)  
NEW: TMarkdown (Wei)  
NEW: Blog demo (Qiang)  

## Version 3.0.0 May 1, 2006
BUG: Ticket#68  - 2 TButtons with THtmlArea causes second button to fail to function (Wei)  
BUG: Ticket#70  - Javascript for TDataTypeValidator added (Wei)  
BUG: Ticket#131 - TImageMap and TLinkButton continue to postback even client validator fails (Wei)  
BUG: Ticket#135 - TBrowserLogRoute reports wrong timings (Qiang)  
BUG: Ticket#137 - The JavasciptLogger does not work (Qiang)  
BUG: Ticket#138 - missing file in TDataGrid (Qiang)  
BUG: Ticket#139 - TThemeManager::setBasePath() should understand an alias path (Qiang)  
BUG: Non-control components can now use expressions in their properties (Qiang)  
BUG: TControl.Visible did not make use of overriden getVisible() (Qiang)  
BUG: TWizard did not stop navigation upon a validation failure (Qiang)  
BUG: NumberFormat will now zero-fill numbers base on the pattern. (Wei)  
ENH: TButton, TImageButton and TLinkButton now implement IButtonControl interface (Qiang)  
ENH: TResponse::writeFile takes three additional parameters to allow sending memory data (Qiang)  
ENH: TButtonColumn can now be a column of image buttons (Qiang)  
ENH: TLiteral will display body content if Text is empty (Qiang)  
ENH: Format string in classes extending TDataGridColumn can now evaluate an expression (Qiang)  
ENH: Format string in classes extending TListControl can now evaluate an expression (Qiang)  
ENH: Added THttpResponse::reload() (Qiang)  
ENH: Custom visual effects can be added to client-side validators via ClientSide property in validators. (Wei)  
ENH: TJavascript::encode() allows raw javascript code when string begins with "javascript:" (Wei)  
ENH: Update TinyMCE to 2.0.5.1
CHG: Rewrote client-side javascript validators, check your client-side validation behaviour (Wei)  
CHG: Updated the javascript Prototype library, a few utilties functions REMOVED, may break your existing javascript code. (Wei)  
CHG: Build javascript without compression, only comments are removed. (Wei)  
CHG: TDatePicker's date can be set using Date property, it value must be in same format as DateFormat, TimeStamp must be set as integer (wei)  
CHG: TSimpleDateFormatter::parse() now return an integer or null on parse error (Wei)  
CHG: TControl::createControls() is changed to public. (Qiang)  
CHG: Template comment tag is changed from <! ... !> to \<!-- ... --!> (Qiang)  
NEW: TListControlValidator (Wei)  
NEW: TClientScript (Wei)  


## Version 3.0RC2 April 16, 2006
BUG: Ticket#54 - recursive reverse() definition (Wei)  
BUG: Ticket#93 - ValidationGroup not working in TImageMap for js validator (Wei)  
BUG: Ticket#97 - Invalid return type value for TSimpleDateFormatter::parse (Wei)  
BUG: Ticket#118 - Variables that may not have been initialized (Qiang)  
BUG: Ticket#121 - OnClick don't fire with TImageButton and TRequiredFieldValidator (Wei)  
BUG: Ticket#129 - TRadioButtonList in TWizard step does not postback correctly (Qiang)  
CHG: Moved localize() into PradoBase (Qiang)  
CHG: List controls now use array keys as list item values even if the array is integer-indexed (Qiang)  
CHG: THttpUtility::htmlEncode and htmlDecode now do not deal with & (Qiang)  
CHG: Expressions appeared in a template are evaluated in PreRender stage (Qiang)  
CHG: The context of expressions appeared in a template is changed to the template control (Qiang)  
ENH: Optimized the representation and evaluation of template expressions (Qiang)  
ENH: Added Raw layout to TDataList (Qiang)  
ENH: Added TRepeater.DataKeys and TRepeater.DataKeyField (Qiang)  

## Version 3.0RC1 April 5, 2006
BUG: Ticket#85 - Undefined TDataGrid::setSelectedIndex (Qiang)  
BUG: Ticket#87 - Typo in IDbConnection (Qiang)  
BUG: Ticket#88 - Unclosed HTML tag in TDatePicker and TColorPicker (Qiang)  
BUG: Ticket#89 - TInlineFrame::ScrollBars wrong behaviour expected (Qiang)  
BUG: Ticket#95 - Typo in TTemplateControl::registerContentPlaceHolder (Qiang)  
BUG: Ticket#103 - Typo in TStyle::setVerticalAlign (Qiang)  
BUG: Ticket#107 - ListControls not respect parent disabling (Qiang)  
BUG: SF#1432624 - Incorrect documentation about caching expiry (Qiang)  
BUG: SF#1446846 - Typo in THead (Qiang)  
BUG: THttpSession fails when user storage module is used (Qiang)  
CHG: TTextHighlighter.EnableCopyCode defaults to false (Qiang)  
CHG: Reorganized quickstart tutorial demo, added new sections (Qiang)  
CHG: Reorganized folders under framework (Qiang)  
CHG: Modified THtmlArea default toolbar and size. (Qiang)  
CHG: Pagers in TDataGrid are now enclosed within panels (Qiang)  
ENH: Ticket#92 - Support for user exception message file (Qiang)  
ENH: Ticket#106 - Support for validation on THiddenField (Qiang)  
ENH: Ticket#110 - Support for TVarDump with syntax highlight (Qiang)  
ENH: TDataFieldAccessor can access public class variables (Qiang)  
ENH: TPhpErrorException now shows the actual error lines (Qiang)  
ENH: Refactored cache classes with support for cache dependency (Qiang)  
NEW: TStack component (Qiang)  
NEW: TImageMap control (Qiang)  
NEW: TWizard control (Qiang)  
NEW: TVarDumper and PradoBase::varDump() (Qiang)  
NEW: TComponentReflection (Qiang)  
NEW: TParameterModule (Qiang)  
NEW: TPropelLogRoute (Jason)  

## Version 3.0b March 6, 2006
BUG: fixed many
CHG: event names must be prefixed with 'On' (Qiang)  
CHG: values of properties whose name ends with 'Template' are parsed directly by template parser (Qiang)  
ENH: template parser reports exact error location (Qiang)  
ENH: cookie HMAC check (Qiang)  
NEW: TInlineFrame (Jason)  
NEW: TAPCCache (Alban)  
NEW: TColorPicker, TDatePicker, TRatingList, TAdodbProvider, TCreoleProvider (Wei)  
NEW: TMultiView, TView, TControlAdapter, TWebControlAdapter, TPagedList, TAttributeCollection (Qiang)  

## Version 3.0a January 18, 2006
Starting, main feaures ready (Qiang)  
