<?php
/*
 * This file is part of pluck, the easy content management system
 * Copyright (c) pluck team
 * http://www.pluck-cms.org

 * Pluck is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * See docs/COPYING for the complete license.
*/

//Make sure the file isn't accessed directly.
defined('IN_PLUCK') or exit('Access denied!');

//-----------------
//Lets start including the pages of the modules.
//-----------------

//Load module admin pages.
if (file_exists('data/modules/'.$_GET['module'].'/'.$_GET['module'].'.admin.php')) {
	require_once ('data/modules/'.$_GET['module'].'/'.$_GET['module'].'.admin.php');

	//Make sure the settings folder for the module is there.
	if (!is_dir('data/settings/modules/'.$_GET['module'])) {
		mkdir('data/settings/modules/'.$_GET['module']);
		chmod('data/settings/modules/'.$_GET['module'], 0777);
	}

	//Check if module is compatible, otherwise don't include pages.
	if (module_is_compatible($_GET['module']) && function_exists($_GET['module'].'_pages_admin')) {
		$module_info = call_user_func($_GET['module'].'_info');
		$module_pages = call_user_func($_GET['module'].'_pages_admin');

		//Include startpage of module.
		if (!isset($_GET['page']) && isset($module_pages[0])) {
			$titelkop = $module_pages[0]['title'];
			include_once ('data/inc/header.php');
			call_user_func($_GET['module'].'_page_admin_'.$module_pages[0]['func']);
		}

		//Include other module-pages,
		//but only include pages if array has been given.
		elseif (isset($module_pages) && isset($_GET['page'])) {
			foreach ($module_pages as $module_page) {
				if ($_GET['page'] == $module_page['func'] && function_exists($_GET['module'].'_page_admin_'.$module_page['func'])) {
					$titelkop = $module_page['title'];
					include_once ('data/inc/header.php');
					call_user_func($_GET['module'].'_page_admin_'.$module_page['func']);
					$module_page_found = true;
				}
			}
			unset($module_page);

			//Go to the modules, if we can't find the page.
			if (!isset($module_page_found)) {
				header('Location: ?action=modules');
				exit;
			}
		}
	}

	//If module is not compatible.
	else {
		$titelkop = $module_name;
		include_once ('data/inc/header.php');
		echo $lang['modules_manage']['not_compatible'];
	}
}

else {
	header('Location: ?action=modules');
	exit;
}
?>