# Release 2024.2
Here you will find all the important new features and release notes of the Platform Version 2024.2 release.

## Most Important New Features

### Pimcore Copilot enhancements
The Pimcore Platform Version 2024.2 includes the following Copilot enhancements:

- **New automation action: AI Image to Image action - upscale image**
  With the upscale image action, you can increase the size of an image without losing too much quality or generating many 
  artifacts. This action can be executed on a single image or multiple images.

  Use case:
  Upscale images if they are too small for a specific channel to be published.


- **New automation action: Filter data objects based on condition**
  Filter data objects based on a condition that can be defined by the newly introduced Pimcore Query Language (PQL, details see below). 
  The result of this action can be used in subsequent action steps.
  
  Use case:
  Filter all objects with missing multiselect values and automatically assign those values.

- **New automation action: Filter assets based on metadata condition**
  Filter assets based on a metadata condition defined by the newly introduced Pimcore Query Language (PQL, details see below). 
  The result of this action can be used in subsequent steps.
  
  Use case:
  Filter all images with expired usage rights (image metadata) and inform a user/group about the expiration.

- **New interaction action: AI Image to Image action – modify image**
  This action is included in our showcase bundle and enables an editor to modify an existing image using a prompt.

  Use case:
  Change the color of a specific object (e.g., a car) of an existing image by using a prompt.

- **Export, import and clone configurations**
  Easily export, import, and clone configurations to speed up the configuration process or deploy actions to another Pimcore instance.

- **Improved error handling**
  The error handling of Pimcore Copilot has been improved with Platform Version 2024.2 to speed up troubleshooting.

More Details see [Pimcore Copilot Documentation](https://pimcore.com/docs/platform/Copilot/)

### Core Improvements
In addition to the enhancements made to the Pimcore Copilot, the following core improvements have been implemented:

#### Generic Execution Engine
The job execution engine in the Pimcore Copilot Bundle provides developers with robust capabilities, including:

- Utilizing built-in actions as steps for custom jobs
- Running jobs consecutively or in parallel
- Querying job status during execution
- Implementing custom job steps
- Cancelling running jobs or rerunning existing ones
- Obtaining detailed error information
- Handling both short and long-running jobs
- And many more features

With the extraction of the job execution engine from the Copilot Bundle into the core as a Generic Execution Engine, we 
are making these powerful features accessible to all developers and bundles within the entire Pimcore ecosystem. This 
centralization offers a unified platform to run and track the progress of longer running jobs, asynchronous via API, 
enhancing the efficiency and scalability of your applications. The Generic Execution Engine will also be used in Pimcore 
Studio for longer-running tasks such as batch updates, exports, and similar activities.

More details see [Documentation Generic Execution Engine](https://pimcore.com/docs/platform/Pimcore/Development_Tools_and_Details/Generic_Execution_Engine/).

#### Pimcore Query Language (PQL)
The Pimcore Query Language (PQL) is a generic service that can be used in multiple bundles to filter for Pimcore elements. 
It is based on the Generic Data Index and provides a simple syntax to allow admins and power users to configure conditions 
directly in the UI without security issues.

The first use cases of the Pimcore Query Language will involve defining preconditions for data pool definition in the 
portal engine and filtering objects and assets in the Pimcore Copilot.

More details see [Documentation Pimcore Query Language](https://pimcore.com/docs/platform/Generic_Data_Index/Searching_For_Data_In_Index/Pimcore_Query_Language/)

#### Performance
We implemented various improvements to enhance performance. The most important improvements regarding performance in the 
Platform Version 2024.2 are:

- Making dependencies calculated asynchronously via Messenger
- Calculate delta for relations when saving data objects with relational field-type to prevent deadlocks


#### Handling Date and Time Values in Pimcore

We made handling of date and time values in Pimcore more consistent and fixed numerous bugs.

**Pimcore's date handling now supports two distinct use cases**:
- Point in Time: Dates are formatted according to the user's timezone (e.g., online order timestamps).
- Time Indication: Dates remain consistent regardless of the user's timezone (e.g., event start times).

**Changes and new Features**:
- Object data type `date`:
    - Column type `date` is now the default for newly added attributes
    - Column type `date` is independent of the user timezone (=Time Indication)
- Object data type `datetime`:
    - Column type `datetime` is now the default for newly added attributes
    - User timezone support can be enabled optionally (= Point in Time).
      Deactivated user timezone support (=Time Indication) is possible in combination with `datetime` column type only.

**Bugfixes**:
- Version preview and CSV export now consider user's timezone (in Core Framework as well as in Portal Engine and Enterprise Asset Metadata).
- Filtering for date and date/time values in grid.

For technical details also see this [issue comment](https://github.com/pimcore/pimcore/issues/16184#issuecomment-2145188141).

#### Official PHP 8.3 support added to all packages of the Platform Version
Benefit from the latest features of PHP 8.3 in your Pimcore projects, like typed class constants or dynamic class constant fetch.


### Additional improvements and housekeeping

Alongside the new features, the following improvements and housekeeping have been implemented:

#### Core Framework
- Introduce initial sort to sql definition for report
- Prepare for Doctrine v4
- Deprecate unused `general.language` setting
- Added basic events for field collection definitions
- Support creating mpg video thumbnails

#### Admin UI Classic Bundle
- Split icon library into submenus: To enhance the responsiveness when working with icons.
- Display read-only asset metadata when granted `view` permission: Up to now, metadata was just displayed with `publish` permission.
- Support comparing localized fields in field collections in version view: Values for localized fields in filed collections will be shown in the version view
- Filtering objects or variant in grid tab
- Add possibility to make specific languages not mandatory
- Support grid editing for input quantity value fields 
- Make global language switch affect classification store
- Support mirror image via thumbnail configuration


#### Generic Data Index
- Add basic support for Pimcore Documents
- Implement missing data object field definition adapters
- Add services to search for all elements and their dependencies
- Add services to locate in tree
- Add tag filter
- Do not delete and recreate index on class definitions save
- Improve and support pagination for big amounts of data


#### Portal Engine
- Additional style settings for login page: the background color of the login screen can be changed now.
- Language switch in share frontend: If portal is using multiple languages, the language can be switched in the share frontend.
- Add Pimcore Query Language support for preconditions: The Pimcore Query Language can be used to define preconditions for data pool definition in the portal engine.


#### Data Importer
- Added support to create variants on object creation: allows the import of variants. 

#### Ecommerce Framework
- Add new parent folder config and deprecate the `strftime` based one
- Add possibility to set custom properties to cart item
- Add events to CommitOrderProcessor cleanUpPendingOrders method

#### Data Quality Management
- Display the date of the last calculation in the details tab


### Upgrade Notes
Before updating, also have a look at the following upgrade notes if relevant to your system:
- [Pimcore Core Framework](https://pimcore.com/docs/platform/Pimcore/Installation_and_Upgrade/Upgrade_Notes/#pimcore-1130)
- [Pimcore Copilot](https://pimcore.com/docs/platform/Copilot/Upgrade_Notes#100-to-110)

Also, please keep in mind, that we needed to stop support for Twig >= 3.9.0. 
