# Release 2024.1
Here you will find all the important new features and release notes of the Platform Version 2024.1 release.

## Most Important New Features

### Pimcore Copilot
The Pimcore Copilot serves as the central starting point for executing various actions within the Pimcore backend. It
will open in a separate window, allowing you to initiate different actions to interact with Pimcore.

The available actions will be context-sensitive, offering different functionalities depending on the context from which
you access the Copilot. These actions will be configurable and customizable.

The Pimcore Copilot will feature a job execution engine and a job run overview, enabling users to track the status of
long-running jobs, abort running jobs, or restart already finished jobs.

Adding new actions can be done programmatically, as well as supported by a configuration window in the backend.
More Details see [Pimcore Copilot Documentation](https://pimcore.com/docs/platform/Copilot/).

### Generic data index
Pimcore now offers a generic OpenSearch-based data index. This data index will be used as a central search engine and
data index for our future applications. For example, the new UI will use the data index to improve searching and
filtering of data objects, assets, and documents. This new index will significantly improve the search experience and
performance in future Pimcore versions. The goal is that this central data index will be used by different extensions,
without the need for each extension to have its own index and update queuing mechanism.

More Details see [Generic data index documentation](https://pimcore.com/docs/platform/Generic_Data_Index/).

## Additional improvements and housekeeping
Alongside the new features, the following improvements and housekeeping have been implemented:

- **[Portal Engine] Integrate data index into Portals**  
  The Pimcore Portal engine will be the first application of the new generic data index. Therefore, it will be powered
  by OpenSearch in the future and share its data index with the new Pimcore UI. The index queue mechanism of the generic
  data index has been improved compared to the Portal engine’s old index update processes. This makes indexing more
  stable and performant.
- **[Core Framework] Gotenberg v2 support**  
    Gotenberg 8 introduced the possibility to create screenshots from webpages, which is now also supported by Pimcore and makes Headless Chromium obsolete (although it would still work).   
    This significantly reduces the amount of necessary computing resources and external dependencies. To replace Headless Chrome, upgrade to Gotenberg v8 and upgrade the client
    library: `composer require gotenberg/gotenberg-php:^2`
- **[Core Framework] Value Objects**
    Added new self validating Value Objects (`BoolanArray`, `IntegerArray`, `Path`, `PositiveInteger`, `PositiveIntegerArray`, `StringArray`)
- **[Core Framework] QuantityValueRange in Classification store**  
    The Classification store now also supports QuantityValueRange types.  
    Big thank you to Michael Frank for that contribution.
- **[Core Framework] Adaptions in processing .env during boot**
    `.env` files are not processed twice anymore. For [environment variable consistency purposes](https://github.com/pimcore/pimcore/issues/16638) in boostrap, please fix `public/index.php`
    in project root by moving `Bootstrap::bootstrap();` just above `$kernel = Bootstrap::kernel()` line instead of outside the closure.
    Alternatively can be fixed by appling this [patch](https://patch-diff.githubusercontent.com/raw/pimcore/skeleton/pull/183.patch).
- **[Core Framework] Several Deprecations**
- **[Admin UI Classic Bundle] Many-to-many relations: multi-file upload**  
    For many-to-many relations you can now directly upload multiple files at once.  
    Big thank you to our partner Blackbit for that contribution.
- **[Data Hub File Export] Use dedicated queue for file export**
- **[Data Hub Webhooks] Added permissions for webhooks**  
  Added permissions tab to the datahub config to define users and roles permissions.
- **[Alternative Elements Trees] Added more data types**  
  Additional data types (Advanced-Many-To-Many-Object relation, Advanced-Many-To-Many relation, Many-To-Many relation, 
  Countries, Languages, User) for the configuration of Alternative Elements Trees have been added.
- **[Workflow Designer] Upgrade NPM dependency to latest version**  
  The front-end dependencies of the workflow designer were upgraded to the latest version to ensure that no outdated
  packages are used.
- **[Statistics explorer] Upgrade NPM dependency to latest version**  
  The front-end dependencies of the workflow designer were upgraded to the latest version to ensure that no outdated
  packages are used.
- **[Translation Provider Interfaces] Deprecate Xplanation Integration**  
  The Xplanation support will be removed in future versions.
- **[Data Hub GraphQL] Add option to disable SQL condition field**  
  Due to the nature of SQL, a custom SQL condition option for the administrator of the data hub is a potential security
  risk. The data hub therefore now supports disabling this field, and we recommend disabling it if you do not rely on this
  feature. Already existing SQL conditions could be migrated to an event-based approach if there is no need to let the
  administrator change the conditions in the UI. We are additionally evaluating to create further UI based filtering
  options without the need for SQL conditions in future versions.
- **Symfony Version**
  Symfony version now restricted to Symfony 6.4, which is LTS version of Symfony 6. 

## Breaking changes
With the platform version 2024.1 we will introduce the following important changes:

- **[Portal Engine] Remove Pimcore 10.6 support**  
  As it is now based on the generic data index which is only available for Pimcore 11.x, we removed Pimcore 10.6 support.
- **[Portal Engine] Skip Elasticsearch support and switch to Open Search**  
  Take a look at the explanation in the “Additional improvements and housekeeping” section above.
- **[Portal Engine] Removed ongr support**  
- **[Portal Engine] Upgrade front-end dependencies**  
  The front-end dependencies of the portal engine were upgraded to the latest version to ensure that no outdated packages
  are used.
- **[Data Hub Simple REST API] Skip Elasticsearch support and switch to Open Search**  
  For the same reason as for the Portal Engine, Pimcore switched from Elasticsearch to Open Search support.
- **Symfony Messenger**
  Make sure all messages in your queue are processed before starting the upgrade.
- **PHP Version**
  With Platform Version Release 2041.1, minimal PHP version is 8.2. PHP 8.3 is not supported yet due to problems with ImageMagick.

### Support for Open Search
In 2021, Elasticsearch decided to switch their licensing model from the Apache 2.0 license to SSPL. This new license is
no longer an open-source license, as it limits the possibilities to provide managed services based on Elasticsearch.
Therefore, Amazon decided to fork Elasticsearch based on Version 7.10.2 and released it as a new product (OpenSearch)
under the Apache 2.0 license.
OpenSearch is now actively developed by Amazon, and they further improved it in Version 2.x. Because of better license
compatibility and market demand, we also decided to switch to OpenSearch with Pimcore Platform Version 2024.1.
This ensures that hosting Pimcore is still possible without any limitations or additional search engine licensing costs.

More Details see [open search client documentation](https://github.com/pimcore/opensearch-client).

## Extensions removed from Platform Version

Following modules were removed from the Pimcore Platform Version packages. They are still available and can be installed,
but they are not part of the Platform Version release promise anymore.

- Advanced Object Search: There will be no active development anymore as we plan to integrate the functionality into Studio UI. 
- CI-Hub Integration: There will be no active development anymore, as there is an
  [alternative provided by CI-Hub](https://ci-hub.com/integration/pimcore) directly. 

## Upgrade Notes

Before updating, also have a look at the following upgrade notes if relevant to your system:
- [Portal Engine](https://pimcore.com/docs/platform/Portal_Engine/Installation/Upgrade#upgrade-to-400)
- [Datahub](https://pimcore.com/docs/platform/Datahub/Installation_and_Upgrade/Upgrade_Notes#170)
- [Datahub Simple Rest API](https://pimcore.com/docs/platform/Datahub_Simple_Rest/Installation/Upgrade_Notes#v300)
- [Datahub File Export](https://pimcore.com/docs/platform/Datahub_File_Export/Installation/Upgrade#upgrade-to-210)
- [Datahub Webhooks](https://pimcore.com/docs/platform/next/Datahub_Webhooks/Installation/Upgrade_notes#update-to-version-11)
- [Pimcore Core Framework](https://pimcore.com/docs/platform/Pimcore/Installation_and_Upgrade/Upgrade_Notes/#pimcore-1120)



