<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @translated 2014 phpBBArabia.com
* 2017 Updated and maintained by Saeed Hubaishan <https://phpbb-ar.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » ” “ …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'الترجمة برعاية <a href="https://phpbb-ar.com/" title="الدعم العربي لمنتديات phpBB">المنتديات العربية</a>',
	'DIRECTION'			=> 'rtl',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y، H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'ar',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 12,

	'1_DAY'			=> 'يوم',
	'1_MONTH'		=> 'شهر',
	'1_YEAR'		=> 'سنة',
	'2_WEEKS'		=> 'أسبوعان',
	'3_MONTHS'		=> '3 شهور',
	'6_MONTHS'		=> '6 شهور',
	'7_DAYS'		=> 'أسبوع',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'حسابك مفعل الآن',
	'ACCOUNT_DEACTIVATED'			=> 'تم إيقاف حسابك يدويًا وإدارة المنتدى فقط هي القادرة على إعادة تفعيله',
	'ACP'							=> 'لوحة التحكم الرئيسية',
	'ACP_SHORT'						=> 'الإدارة',
	'ACTIVATION_ALREADY_SENT'		=> 'أٌرسل بريد التفعيل إلى عنوانك البريدي، بإمكانك المحاولة بعد 24 ساعة،  إذا استمرت مشاكل التفعيل بالظهور لديك تواصل مع أحد مديري المنتدى.',
	'ACTIVE'						=> 'نشط',
	'ACTIVE_ERROR'					=> 'حسابك معطل الآن. الرجاء تفعيل حسابك ثم حاول الدخول مرة أخرى. إذا واجهت أية مشاكل راجع مدير المنتدى.',
	'ADMINISTRATOR'					=> 'المدير العام',
	'ADMINISTRATORS'				=> 'مديرو المنتدى',
	'AGE'							=> 'العمر',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'خطأ AJAX',
	'AJAX_ERROR_TEXT'				=> 'حدث خطأ أثناء معالجة طلبك.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'تم إيقاف الطلب عن طريق المستخدم.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'لقد نفذ الوقت أثناء التنفيذ؛ يرجى المحاولة لاحقًا.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'حدث خطأ في الطلب وتم إرجاع رد غير سليم من الخادم.',
	'ALLOWED'						=> 'مسموح',
	'ALL_FILES'						=> 'جميع الملفات',
	'ALL_FORUMS'					=> 'جميع المنتديات',
	'ALL_MESSAGES'					=> 'جميع الرسائل',
	'ALL_POSTS'						=> 'جميع المشاركات',
	'ALL_TIMES'						=> 'جميع الأوقات تستخدم <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'جميع المواضيع',
	'ALT_TEXT'						=> 'نص بديل',
	'AND'							=> 'و',
	'ARE_WATCHING_FORUM'			=> 'لقد تابعت هذا المنتدى وستصلك التحديثات الحاصلة فيه',
	'ARE_WATCHING_TOPIC'			=> 'لقد تابعت هذا الموضوع وستصلك التحديثات الحاصلة فيه',
	'ASCENDING'						=> 'تصاعديًا',
	'ATTACHMENTS'					=> 'المرفقات',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'الصورة التي تريد إرفاقها غير صحيحة',
	'AUTHOR'						=> 'الكاتب',
	'AUTH_NO_PROFILE_CREATED'		=> 'خطأ في إنشاء الملف الشخصي للعضو',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'الخدمة الخارجية مربوطة حاليًا مع حساب عضو آخر على المنتدى.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'مدخل قاعدة بيانات غير سليم.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'نوع الخدمة المقدم في معالج OAuth غير سليم.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'تمت بعض الأمور على نحو خاطئ عند معالجة طلب OAuth.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'الخدمة الخارجية أرجعت قيمة خاطئة ولهذا طلبك لم ينفذ.',
 	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'لم يتم إنشاء خدمة OAuth',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'لم يتم تخزين رمز OAuth.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'رمز OAuth تم تخزينه بشكل خاطئ.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'تم إبطال عملية الرفع للشك بأن الملف المرفوع ملف ضار',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'هذه اللاحقة %s غير مسموح بها',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'الصورة الرمزية لم تحمّل. قد يكون الإيصال خاطئا أو لا يعمل',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'الصورة الرمزية التي رفعتها فارغة',
	'AVATAR_INVALID_FILENAME'		=> '%s اسم الملف خاطئ',
	'AVATAR_NOT_UPLOADED'			=> 'لم تُحَمّل الصورة الرمزية',
	'AVATAR_NO_TEMP_DIR'			=> 'لم يتم العثور على المجلد المؤقت أو أنه غير قابل للكتابة.',
	'AVATAR_NO_SIZE'				=> 'لم يتمكن النظام من الحصول على طول وعرض الصورة الرمزية، الرجاء القيام بذلك يدويًا',
	'AVATAR_NO_UPLOAD_DIR'			=> 'مسار حفظ الصور الرمزية غير موجود أو غير قابل للقراءة.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'تحميل الصور الرمزية متاح، لكن المسار غير مضبوط.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'حُمِلّت الصورة جزئيا فقط',
	'AVATAR_PHP_SIZE_NA'			=> 'حجم الصورة/الصور الرمزية كبير جدًا.<br />لا يستطيع النظام تحديد أقصى حجم المعرّف من قبل PHP في ملف php.ini',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'حجم الصورة الشخصيه اكبر من الحد المسموح. الحد المسموح هو %1$d %2$s.<br />الرجاء الانتباه إلى أنه لا يمكن تجاوز اعدادت ملف php.ini',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'الصورة الرمزية المحددة لم يتم رفعها لأن وقت تنفيذ الطلب انتهى.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'ملحقة PHP اوقفت تحميل الملف.',
	'AVATAR_URL_INVALID'			=> 'أُدخِل العنوان بطريقة خاطئة',
	'AVATAR_URL_NOT_FOUND'			=> 'لم يُعثَر على الملف المحدد',
	'AVATAR_WRONG_FILESIZE'			=> 'ينبغي أن يكون حجم الصورة الرمزية بين 0 و %1$d %2$s',
	'AVATAR_WRONG_SIZE'				=> 'عرض الصورة المقدّمة هو %5$s وطولها %6$s .ينبغي أن يكون عرض الصورة الرمزية على الأقل %1$s، وطولها %2$s وعلى الأكثر يكون عرضها %3$s وطولها %4$s.',

	'BACK_TO_TOP'			=> 'أعلى',
	'BACK_TO_PREV'			=> 'العودة للصفحة السابقة',
	'BAN_TRIGGERED_BY_EMAIL'=> 'لقد حُظِر بريدك الإلكتروني',
	'BAN_TRIGGERED_BY_IP'	=> 'لقد حُظِر رقم IP الخاص بك',
	'BAN_TRIGGERED_BY_USER'	=> 'حُظِر اسم المستخدم الخاص بك',
	'BBCODE_GUIDE'			=> 'دليل BBCode',
	'BCC'					=> 'نسخة إلى',
	'BIRTHDAYS'				=> 'أعياد الميلاد',
	'BOARD_BAN_PERM'		=> 'أوقِفَ حسابك <strong>نهائيًا</strong> في هذا المنتدى.<br /><br />رجاءً راسل %2$sمدير المنتدى%3$s لمزيد من المعلومات',
	'BOARD_BAN_REASON'		=> 'أسباب الإيقاف: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'أوقِفَ حسابك في هذا المنتدى حتى <strong>%1$s</strong>.<br /><br />رجاءً راسل %2$sمدير المنتدى%3$s لمزيد من المعلومات',
	'BOARD_DISABLE'			=> 'نأسف لكن المنتدى معطّل الآن',
	'BOARD_DISABLED'		=> 'هذا المنتدى معطل حاليًا',
	'BOARD_UNAVAILABLE'		=> 'نأسف لكن المنتدى متوقف مؤقتًا، عاود الزيارة بعد دقائق',
	'BROWSING_FORUM'		=> 'أعضاء يستعرضون المنتدى: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		0	=> 'المتصفحون للمنتدى الآن: %2$s فقط',
		1	=> 'المتصفحون للمنتدى الآن: %2$s وزائر واحد',
		2	=> 'المتصفحون للمنتدى الآن: %2$s وزائران',
		3	=> 'المتصفحون للمنتدى الآن: %2$s و %1$d زوار',
		4	=> 'المتصفحون للمنتدى الآن: %2$s و %1$d زائرًا',
		5	=> 'المتصفحون للمنتدى الآن: %2$s و %1$d زائر',
		),
	'BUTTON_DELETE'			=> 'حذف',
	'BUTTON_EDIT'			=> 'تعديل',
	'BUTTON_FORUM_LOCKED'	=> 'مغلق',
	'BUTTON_INFORMATION'	=> 'معلومات',
	'BUTTON_NEW_TOPIC'		=> 'موضوع جديد',
	'BUTTON_PM'				=> 'رسالة',
	'BUTTON_PM_FORWARD'		=> 'إعادة إرسال',
	'BUTTON_PM_NEW'			=> 'رسالة جديدة',
	'BUTTON_PM_REPLY'		=> 'أرسل رد',
	'BUTTON_PM_REPLY_ALL'	=> 'رد على الكل',
	'BUTTON_POST_REPLY'		=> 'أضف رد جديد',
	'BUTTON_QUOTE'			=> 'اقتابس',
	'BUTTON_REPORT'			=> 'تبليغ',
	'BUTTON_TOPIC_LOCKED'	=> 'مغلق',
	'BUTTON_WARN'			=> 'تحذير',
	'BYTES'					=> 'بايت',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'إلغاء',
	'CHANGE'				=> 'تغيير',
	'CHANGE_FONT_SIZE'		=> 'تغيير حجم الخط',
	'CHANGING_PREFERENCES'	=> 'يغير إعدادات المنتدى',
	'CHANGING_PROFILE'		=> 'يغير إعدادات الملف الشخصي',
	'CHARACTERS'			=> array(
		1	=> 'حرف واحد',
		2	=> 'حرفان',
		3	=> '%d حروف',
		4	=> '%d حرفًا',
		5	=> '%d حرف',
		),
	// Special version to be used when describing ranges e.g. "min x characters and max y characters"
	'CHARACTERS_XY'			=> array(
		1	=> 'حرف واحد',
		2	=> 'حرفان',
		3	=> '%d حروف',
		4	=> '%d حرفًا',
		5	=> '%d حرف',
		),
	'COLLAPSE_VIEW'			=> 'عرض مصغر',
	'CLOSE_WINDOW'			=> 'أغلق النافذة',
	'CODE'					=> 'كود',
	'COLOUR_SWATCH'			=> 'قائمة الألوان',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> '،',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'تأكيد',
	'CONFIRM_CODE'			=> 'الرمز الأمني',
	'CONFIRM_CODE_EXPLAIN'	=> 'اكتب الرمز كما تراه في الصورة تمامًا',
	'CONFIRM_CODE_WRONG'	=> 'الرمز الأمني الذي أدخلته غير صحيح',
	'CONFIRM_OPERATION'		=> 'هل أنت متأكد من أنك تريد القيام بهذه العملية؟',
	'CONFIRM_AVATAR_DELETE' => 'هل أنت متأكد من أنك تريد حذف هذه الصورة الرمزية؟',
	'CONGRATULATIONS'		=> 'مبروك لـ',
	'CONNECTION_FAILED'		=> 'خطأ في الاتصال',
	'CONNECTION_SUCCESS'	=> 'تم الاتصال بنجاح!',
	'CONTACT'				=> 'اتصال',
	'CONTACT_USER'			=> 'اتصل بـ %s',
	'CONTACT_US'			=> 'اتصل بنا',
	'COOKIE_CONSENT_INFO'	=> 'اعرف المزيد',
	'COOKIE_CONSENT_MSG'	=> 'يستخدم هذا الموقع الكوكيز لضمان الحصول على أفضل تجربه علي موقعنا.',
	'COOKIE_CONSENT_OK'		=> 'بالتوفيق!',
	'COOKIE_CONSENT_HREF'	=> 'http://cookiesandyou.com',
	'COOKIES_DELETED'		=> 'حُذِفت جميع الكعكات (كوكي) الخاصة بالمنتدى بنجاح',
	'CURRENT_TIME'			=> 'اليوم هو %s',

	'DAY'					=> 'يوم',
	'DAYS'					=> 'أيام',
	'DELETE'				=> 'حذف',
	'DELETE_ALL'			=> 'حذف الكل',
	'DELETE_COOKIES'		=> 'حذف الكوكيز',
	'DELETE_MARKED'			=> 'حذف المحدد',
	'DELETE_POST'			=> 'حذف المشاركة',
	'DELIMITER'				=> 'الفاصل',
	'DESCENDING'			=> 'تنازليًا',
	'DISABLED'				=> 'معطل',
	'DISPLAY'				=> 'عرض',
	'DISPLAY_GUESTS'		=> 'عرض الزوار',
	'DISPLAY_MESSAGES'		=> 'عرض رسائل سابقة منذ',
	'DISPLAY_POSTS'			=> 'عرض مشاركات سابقة منذ',
	'DISPLAY_TOPICS'		=> 'عرض مواضيع سابقة منذ',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'الإيميل المدخل ليس له سجل MX صحيح.',
	'DOWNLOADED'			=> 'محمل',
	'DOWNLOADING_FILE'		=> 'تحميل ملف',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'لم يُحمَّل بعد',
		1	=> 'حُمِّل مرة واحدة',
		2	=> 'حُمِّل مرتين',
		3	=> 'حُمِّل %d مرات',
		4	=> 'حُمِّل %d مرةً',
		5	=> 'حُمِّل %d مرة',
		),

	'EDIT_POST'							=> 'تعديل المشاركة',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'بريد',	// Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'البريد الإلكتروني',
	'EMAIL_INVALID_EMAIL'				=> 'البريد الالكتروني المدخل غير صحيح!',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'هناك مشكلة في إرسال البريد الإلكتروني في <strong>السطر %1$s</strong>. الرد: %2$s',
	'EMPTY_SUBJECT'						=> 'ينبغي كتابة عنوان للموضوع',
	'EMPTY_MESSAGE_SUBJECT'				=> 'ينبغي عليك كتابة العنوان عند إنشاء رسالة جديدة',
	'ENABLED'							=> 'مفعّل',
	'ENCLOSURE'							=> 'تطويق',
	'ENTER_USERNAME'					=> 'أدخل اسم مستخدم',
	'ERR_CHANGING_DIRECTORY'			=> 'غير قادر على تغيير الدليل',
	'ERR_CONNECTING_SERVER'				=> 'خطأ في الاتصال بالخادم',
	'ERR_JAB_AUTH'						=> 'غير مسموح باستخدام Jabber على الخادم',
	'ERR_JAB_CONNECT'					=> 'لا يمكن الاتصال بخادم Jabber',
	'ERR_UNABLE_TO_LOGIN'				=> 'خطأ في تسجيل الدخول. اسم المستخدم أو كلمة المرور غير صحيحة',
	'ERR_UNWATCHING'					=> 'حدث خطأ أثناء محاولة إلغاء المتابعة.',
	'ERR_WATCHING'						=> 'حدث خطأ أثناء محاولة المتابعة.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'يبدو أن مسار phpBB الذي أدخلته غير صحيح',
	'ERROR'								=> 'خطأ',
	'EXPAND_VIEW'						=> 'عرض موسع',
	'EXTENSION'							=> 'امتدادات',
	'EXTENSION_DISABLED'				=> 'الامتداد <strong>%s</strong> غير مفعل.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'الامتداد <strong>%s</strong> معطّل الآن ولا يمكن عرضه.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'الامتداد <strong>%s</strong> غير موجود.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'الأسئلة المتكررة',
	'FAQ_EXPLAIN'			=> 'الأسئلة المتكررة',
	'FEATURE_NOT_AVAILABLE' => 'الميزة المطلوبة غير متوفرة في هذا المنتدى.',
	'FILENAME'				=> 'اسم الملف',
	'FILESIZE'				=> 'حجم الملف',
	'FILEDATE'				=> 'تاريخ الملف',
	'FILE_COMMENT'			=> 'التعليق',
	'FILE_CONTENT_ERR'		=> 'لم نتمكن من قراءة محتويات الملف: %s',
	'FILE_JSON_DECODE_ERR'	=> 'فشل في فك شفرة ملف json: %s',
	'FILE_NOT_FOUND'		=> 'لم يُعثَر على الملف المطلوب: %s',
	'FIND_USERNAME'			=> 'بحث عن عضو',
	'FOLDER'				=> 'مجلد',
	'FORGOT_PASS'			=> 'فقدت كلمة المرور',
	'FORM_INVALID'			=> 'النموذج المقدم غير صحيح. حاول تقديمه مرة أخرى',
	'FORUM'					=> 'منتدى',
	'FORUMS'				=> 'منتديات',
	'FORUMS_MARKED'			=> 'عدّت المنتديات مقروءة.',
	'FORUM_CAT'				=> 'تصنيف منتدى',
	'FORUM_INDEX'			=> 'فهرس المنتدى',
	'FORUM_LINK'			=> 'رابط المنتدى',
	'FORUM_LOCATION'		=> 'مكان المنتدى',
	'FORUM_LOCKED'			=> 'منتدى مغلق',
	'FORUM_RULES'			=> 'قوانين المنتدى',
	'FORUM_RULES_LINK'		=> 'رجاءً اضغط لمشاهدة قوانين القسم',
	'FROM'					=> 'من',
	'FSOCK_DISABLED'		=> 'لا يمكن إكمال العملية لأن المهمة <var>fsockopen</var> عُطِلَت أو أن الخادم لا يدعم هذا الأمر',
	'FSOCK_TIMEOUT'			=> 'حدث خطأ timeout أثناء قراءة البيانات من الشبكة.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'تعذر تعديل مجموعة الملفات',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'تعذر تعديل صلاحيات الملف',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'تعذر نسخ الملفات',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'تعذر إنشاء الارتباط الرمزي',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'تعذر إنشاء مسار',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'تعذر حذف الملفات من النظام',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'تعذر تفريغ الملف',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'تعذر النسخ المتطابق للمسار',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'تعذر إعادة تسمية ملف في النظام',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'تعذر إنشاء الملف أو تغيير وقت التعديل',

	'FTP_FSOCK_HOST'				=> 'مستضيف FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'مستضيف FTP المستخدم للاتصال بموقعك',
	'FTP_FSOCK_PASSWORD'			=> 'كلمة مرور FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'كلمة المرور الخاصة باسم مستخدم FTP',
	'FTP_FSOCK_PORT'				=> 'منفذ FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'المنفذ المستخدم للاتصال بالخادم',
	'FTP_FSOCK_ROOT_PATH'			=> 'مسار phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'المسار من المجلد الرئيسي لمنتداك phpBB',
	'FTP_FSOCK_TIMEOUT'				=> 'انتهاء الوقت FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'الوقت بالثواني الذي ينبغي على النظام انتظاره للاستجابة من الخادم',
	'FTP_FSOCK_USERNAME'			=> 'اسم مستخدم FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'اسم المستخدم المستعمل للاتصال بالخادم',

	'FTP_HOST'					=> 'مستضيف FTP',
	'FTP_HOST_EXPLAIN'			=> 'خادم FTP المستعمل للاتصال بموقعك',
	'FTP_PASSWORD'				=> 'كلمة مرور FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'كلمة المرور الخاصة باسم مستخدم FTP',
	'FTP_PORT'					=> 'FTP port',
	'FTP_PORT_EXPLAIN'			=> 'المنفذ المستخدم للاتصال بالخادم',
	'FTP_ROOT_PATH'				=> 'المسار إلى phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'المسار من المجلد الرئيسي لمنتداك phpBB',
	'FTP_TIMEOUT'				=> 'انتهاء الوقت FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'الوقت بالثواني الذي ينبغي على النظام انتظاره للاستجابة من الخادم',
	'FTP_USERNAME'				=> 'اسم مستخدم FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'اسم المستخدم المستعمل للاتصال بالخادم',

	'GENERAL_ERROR'				=> 'خطأ عام',
	'GB'						=> 'جيجابايت',
	'GIB'						=> 'GiB',
	'GO'						=> 'انتقال',
	'GOTO_FIRST_POST'			=> 'اذهب إلى أول مشاركة',
	'GOTO_LAST_POST'			=> 'اذهب إلى آخر مشاركة',
	'GOTO_PAGE'					=> 'الانتقال إلى صفحة',
	'GROUP'						=> 'مجموعة',
	'GROUPS'					=> 'مجموعات',
	'GROUP_ERR_TYPE'			=> 'نوع المجموعة غير مناسب',
	'GROUP_ERR_USERNAME'		=> 'لم يُعَيّن اسم للمجموعة',
	'GROUP_ERR_USER_LONG'		=> 'اسم المجموعة طويل جدًا',
	'GUEST'						=> 'زائر',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'يوجد الآن زائر واحد',
		2	=> 'يوجد الآن زائران',
		3	=> 'يوجد الآن %d زوار',
		4	=> 'يوجد الآن %d زائرًا',
		5	=> 'يوجد الآن %d زائر',
		),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> 'زائر واحد',
		2	=> 'زائران',
		3	=> '%d زوار',
		4	=> '%d زائرًا',
		5	=> '%d زائر',
		6	=> 'لا زوار',
		),
	'G_ADMINISTRATORS'			=> 'المدير العام',
	'G_BOTS'					=> 'محركات البحث',
	'G_GUESTS'					=> 'الزوار',
	'G_REGISTERED'				=> 'الأعضاء',
	'G_REGISTERED_COPPA'		=> 'أعضاء تحت سن الـ 13',
	'G_GLOBAL_MODERATORS'		=> 'مراقب عام',
	'G_NEWLY_REGISTERED'		=> 'آخر الأعضاء المسجلين',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> 'عضو واحد مخفي',
		2	=> 'عضوان مخفيان',
		3	=> '%d أعضاء مخفيون',
		4	=> '%d عضوًا مخفيًا',
		5	=> '%d عضو مخفي',
		),
	'HIDDEN_USERS_TOTAL'		=> array(
		0 	=> '',
		1	=> 'مخفي',
		2	=> 'مخفيان',
		3	=> '%d مخفيون',
		4	=> '%d مخفيًا',
		5	=> '%d مخفي',
		),
	'HIDE_GUESTS'					=> 'إخفاء الزوار',
	'HIDE_ME'						=> 'أخفِ حالة وجودي في المنتدى هذه المرة',
	'HOURS'							=> 'ساعات',
	'HOME'							=> 'الرئيسية',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'إذا',
	'IMAGE'						=> 'صورة',
	'IMAGE_FILETYPE_INVALID'	=> 'نوع ملف الصورة %d لنوع الصورة %s غير مدعوم',
	'IMAGE_FILETYPE_MISMATCH'	=> 'نوع ملف الصورة غير مطابق: التمدد المتوقع %1$s لكن التمدد المعطى هو %2$s',
	'IN'						=> 'في',
	'INACTIVE'					=> 'غير نشط',
	'INDEX'						=> 'الفهرس',
	'INFORMATION'				=> 'معلومات',
	'INSECURE_REDIRECT'			=> 'محاولة لفتح رابط غير آمن.',
	'INTERESTS'					=> 'اهتمامات',
	'INVALID_DIGEST_CHALLENGE'	=> 'غير مسموح digest challenge',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> يحتمل أن يكون عنوان بريدي خاطئا؟',
	'INVALID_FEED_ATTACHMENTS'	=> 'حاولت التغذية المحددة إحضار المرفقات بقيود غير صالحه.',
	'INVALID_PLURAL_RULE'		=> 'قاعدة الجمع المختارة غير صحيحة. القيم الصحيحة تكون أرقامًا بين 0 و 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'عنوان IP الخاص بك %1$s أوقِف لأنه من القائمة السوداء. لمزيد من المعلومات يرجى مراجعة <a href="%2$s">%2$s</a>',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'اشترك في',
	'JUMP_PAGE'				=> 'ادخل رقم الصفحة التي تريد الذهاب إليها',
	'JUMP_TO'				=> 'الانتقال إلى',
	'JUMP_TO_PAGE'			=> 'اضغط للانتقال إلى الصفحة',
	'JUMP_TO_PAGE_CLICK'	=> 'اضغط للذهاب إلى صفحة…',

	'KB'					=> 'كيلوبايت',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'آخر مشاركة',
	'LAST_UPDATED'						=> 'آخر تحديث',
	'LAST_VISIT'						=> 'آخر زيارة',
	'LDAP_NO_LDAP_EXTENSION'			=> 'امتداد LDAP غير متوفر',
	'LDAP_NO_SERVER_CONNECTION'			=> 'لا يمكن الاتصال بخادم LDAP',
	'LDAP_SEARCH_FAILED'				=> 'لقد حدث خطأ أثناء البحث عن امتداد LDAP',
	'LEGEND'							=> 'ألوان المجموعات',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'البحث الحي غير مسموح.',
	'LOADING'							=> 'جار التحميل',
	'LOCATION'							=> 'مكان',
	'LOCK_POST'							=> 'إغلاق المشاركة',
	'LOCK_POST_EXPLAIN'					=> 'منع التعديل',
	'LOCK_TOPIC'						=> 'إغلاق الموضوع',
	'LOGIN'								=> 'تسجيل الدخول',
	'LOGIN_CHECK_PM'					=> 'سجل الدخول لقراءة رسائلك الخاصة',
	'LOGIN_CONFIRMATION'				=> 'تأكيد تسجيل الدخول',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'لمنع محاولات اختراق الحسابات الآلية فإن المنتدى يطالبك بإدخال رمز أمني بعد استنفاذك لجميع محاولات تسجيل الدخول المتاحة. الرمز الأمني مكتوب في الصورة أدناه، إذا كنت غير قادر على قراءة الرموز فيرجى منك مراسلة %sمدير المنتدى%s',	// unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'لقد تجاوزت الحد المسموح لك في محاولات تسجيل الدخول. الآن بالإضافة لاسم المستخدم وكلمة المرور يجب عليك أن تقوم باجتياز اختبار الكابتشا.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'لم تتم مصادقتك من قبل أباتشي',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'لقد تم طلب خدمة OAuth غير متوفرة.',
	'LOGIN_ERROR_PASSWORD'				=> 'قد أدخلت كلمة مرور خاطئة. رجاءً تحقق من كلمة المرور وعاود المحاولة مرة أخرى. إذا كنت تواجه مشاكل اتصل بـ%sمدير المنتدى%s',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'لا يمكن تحويل كلمة المرور أثناء تحديث نظام المنتديات. رجاءً قم بـ %sطلب كلمة مرور جديدة%s. إذا كنت لا تزال تواجه المشاكل الرجاء الاتصال %sبإدارة الموقع%s',
	'LOGIN_ERROR_USERNAME'				=> 'لقد أدخلت اسم مستخدم خاطئ. رجًاء تحقق من اسم المستخدم وعاود المحاولة مرة أخرى. إذا كنت تواجه مشاكل اتصل بـ%sمدير المنتدى%s',
	'LOGIN_FORUM'						=> 'لمشاهدة هذا المنتدى أو المشاركة فيه ينبغي عليك أولًا إدخال كلمة المرور',
	'LOGIN_INFO'						=> 'ينبغي أن تكون مسجلًا لتستطيع الدخول. التسجيل لا يأخذ منك سوى بضع دقائق وسيعطيك مميزات أكثر. وقد تكون إدارة المنتدى خصصت صلاحيات أكثر للأعضاء المسجلين. قبل التسجيل تأكد أنك قرأتَ شروط المنتدى وسياساته وأنك موافق عليها. رجاءً تأكد من قراءتك لشروط كل قسم قبل المشاركة فيه',
	'LOGIN_VIEWFORUM'					=> 'ينبغي أن تكون عضوًا مسجلًا لتستطيع مشاهدة هذا المنتدى',
	'LOGIN_EXPLAIN_EDIT'				=> 'لتستطيع التعديل على مشاركاتك ينبغي أن تكون عضوًا في المنتدى',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'لكي تشاهدة قائمة الموجودين ينبغي عليك التسجيل وتسجيل الدخول',
	'LOGIN_REQUIRED'					=> 'يجب عليك تسجيل الدخول للقيام بهذه العملية.',
	'LOGOUT'							=> 'تسجيل الخروج',
	'LOGOUT_USER'						=> 'تسجيل خروج [ %s ]',
	'LOG_ME_IN'							=> 'تذكرني',

	'MAIN'					=> 'الرئيسية',
	'MARK'					=> 'تحديد',
	'MARK_ALL'				=> 'تحديد الكل',
	'MARK_ALL_READ'			=> 'اعتبر الجميع مقروء',
	'MARK_FORUMS_READ'		=> 'اعتبر جميع المنتديات مقروءة',
	'MARK_READ'				=> 'اعتبره مقروء',
	'MARK_SUBFORUMS_READ'	=> 'اعتبر جميع المنتديات الفرعية مقروءة',
	'MB'					=> 'ميجابايت',
	'MIB'					=> 'MiB',
	'MCP'					=> 'لوحة تحكم المشرف',
	'MCP_SHORT'				=> 'الإشراف',
	'MEMBERLIST'			=> 'قائمة الأعضاء',
	'MEMBERLIST_EXPLAIN'	=> 'مشاهدة قائمة الأعضاء كاملة',
	'MERGE'					=> 'دمج',
	'MERGE_POSTS'			=> 'نقل المشاركات',
	'MERGE_TOPIC'			=> 'دمج المواضيع',
	'MESSAGE'				=> 'رسالة',
	'MESSAGES'				=> 'رسائل',
	'MESSAGES_COUNT'		=> array(
		0	=> 'رسائل غير محدودة',
		1	=> 'رسالة واحدة',
		2	=> 'رسالتان',
		3	=> '%d رسائل',
		4	=> '%d رسالةً',
		5	=> '%d رسالة',
		),
	'MESSAGE_BODY'			=> 'نص الرسالة',
	'MINUTES'				=> 'دقائق',
	'MODERATE'				=> 'إدارة',
	'MODERATOR'				=> 'المشرف',
	'MODERATORS'			=> 'المشرفون',
	'MODULE_NOT_ACCESS'		=> 'لا يمكن الوصول إلى الموديول',
	'MODULE_NOT_FIND'		=> 'لا يمكن إيجاد الموديول %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'ملف الموديول %s لا يحتوي على متغير صحيح [%s]',
	'MONTH'					=> 'شهر',
	'MOVE'					=> 'نقل',

	'NA'						=> 'غير محدد',
	'NEWEST_USER'				=> 'آخر عضو مسجل <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'رسالة جديدة',
	'NEW_MESSAGES'				=> 'رسائل جديدة',
	'NEW_POST'					=> 'مشاركة جديدة',	// Not used anymore
	'NEW_POSTS'					=> 'مشاركات جديدة',	// Not used anymore
	'NEXT'						=> 'التالي',		// Used in pagination
	'NEXT_STEP'					=> 'الخطوة التالية',
	'NEVER'						=> 'أبدًا',
	'NO'						=> 'لا',
	'NO_NOTIFICATIONS'			=> 'لا توجد لديك إشعارات',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'غير مصرح لك بإدارة هذه المجموعة',
	'NOT_AUTHORISED'			=> 'لا تملك الصلاحية لدخول هذه المنطقة',
	'NOT_WATCHING_FORUM'		=> 'لم تعد متابعًا هذا المنتدى',
	'NOT_WATCHING_TOPIC'		=> 'لم تعد متابعًا هذا الموضوع',
	'NOTIFICATIONS'				=> 'الإشعارات',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>رد جديد</strong> من %1$s في موضوع المفضلة:',
		),
	'NOTIFICATION_FORUM'				=> '<em>منتدى:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>طلب انضمام</strong> من %1$s للمجموعة %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>تم قبول طلب الانضمام</strong> للمجموعة %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'الوظيفة "%s" لا تشير إلى وظيفة إشعارات صالحة.',
	'NOTIFICATION_PM'					=> '<strong>رسالة خاصة</strong> من %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>رد جديد</strong> من %1$s في الموضوع:',
		),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>تمت الموافقة على المشاركة</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>لم تتم الموافقة على المشاركة</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>طلب موافقة على مشاركة</strong> من %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>تم اقتباس مشاركتك</strong> من %1$s في:',
		),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>السبب:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>تبليغ عن رسالة خاصة</strong> من %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>التبليع عن رسالة خاصة أغلقه</strong> %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>تبليغ عن مشاركة</strong> من %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>تم إغلاق التقرير</strong> من %1$s الخاص بـ:',
	'NOTIFICATION_TOPIC'				=> '<strong>موضوع جديد</strong> من %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>تمت الموافقة على الموضوع</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>لم تتم الموافقة على الموضوع</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>طلب موافقة على موضوع</strong> من %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'نوع الإشعار "%s" مفقود من ملفات النظام.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>اجراء مطلوب</strong> عضوية معطله او عضويه جديدة ”%1$s“',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'أخرى',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> 'آخران',
		3	=> '%d آخرون',
		4	=> '%d آخرين',
		5	=> '%d آخرون',
		),
	'NOTIFY_ADMIN'				=> 'رجاءً أبلِغ إدارة المنتدى أو الموقع',
	'NOTIFY_ADMIN_EMAIL'		=> 'يرجى منك إخبار مدير المنتدى: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'غير مسموح لك بتحميل هذا الملف',
	'NO_ACTION'					=> 'ليس هناك خيار محدد',
	'NO_ADMINISTRATORS'			=> 'ليس هناك مديرون لهذا المنتدى',
	'NO_AUTH_ADMIN'				=> 'لا تملك صلاحيات المدير وغير مسموح لك الدخول للوحة التحكم الرئيسية',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'لا يمكنك إعادة تعريف نفسك باستخدام عضوية أخرى',
	'NO_AUTH_OPERATION'			=> 'لا تملك الصلاحيات اللازمة لإكمال هذه العملية',
	'NO_AVATARS'				=> 'لا توجد صور رمزية حاليًا',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'لا يمكن الوصول إلى مستضيف smtp : %s : %s',
	'NO_BIRTHDAYS'				=> 'لا توجد أعياد ميلاد اليوم',
	'NO_EMAIL_MESSAGE'			=> 'الرسالة البريدية فارغة',
	'NO_EMAIL_RESPONSE_CODE'	=> 'لم نستطع جلب رد خادم البريد',
	'NO_EMAIL_SUBJECT'			=> 'لم يُعيّن عنوان الرسالة',
	'NO_FORUM'					=> 'المنتدى الذي اخترته غير موجود',
	'NO_FORUMS'					=> 'هذا المنتدى لا يحتوي على أقسام',
	'NO_GROUP'					=> 'المجموعة التي طلبتها غير موجودة',
	'NO_GROUP_MEMBERS'			=> 'هذه المجموعة ليس فيها أعضاء',
	'NO_IPS_DEFINED'			=> 'ليس هناك IP أو مستضيف محدد',
	'NO_MEMBERS'				=> 'لا يوجد عضو بهذه المعايير التي تبحث عنها',
	'NO_MESSAGES'				=> 'لا رسائل',
	'NO_MODE'					=> 'لم يُحدد أي نمط',
	'NO_MODERATORS'				=> 'لم يُعيّن أي مشرف في هذا المنتدى',
	'NO_NEW_MESSAGES'			=> 'لا رسائل جديدة',
	'NO_NEW_POSTS'				=> 'لا رسائل جديدة',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'لا يوجد أعضاء مسجلين متصلين',
	'NO_POSTS'					=> 'لا مشاركات',
	'NO_POSTS_TIME_FRAME'		=> 'لا يوجد مشاركات في هذا الموضوع خلال الفترة الزمنية المحددة',
	'NO_FEED_ENABLED'			=> 'لا يوجد تغذية متاحة لهذا المنتدى Feeds.',
	'NO_FEED'					=> 'التغذية المطلوبة غير متاحة.',
	'NO_STYLE_DATA'				=> 'لا يمكن جلب معلومات الاستايل لuser_style %s المضبوط لuser_id %s',
	'NO_STYLE_CFG'				=> 'لا يمكن جلب ملف إعدادات الاستايل: %s',
	'NO_SUBJECT'				=> 'لا يوجد عنوان محدد',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'البحث المحدد غير موجود',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'لا توجد صلاحيات دعم الطرق',
	'NO_TOPIC'					=> 'الموضوع المطلوب غير موجود',
	'NO_TOPIC_FORUM'			=> 'الموضوع أو المنتدى المطلوب لم يعد موجودًا',
	'NO_TOPICS'					=> 'لا توجد مواضيع أو مشاركات في هذا المنتدى',
	'NO_TOPICS_TIME_FRAME'		=> 'لا يوجد مواضيع في هذا المنتدى خلال الفترة الزمنية المحددة',
	'NO_UNREAD_POSTS'			=> 'لا يوجد مشاركات غير مقروءة',
	'NO_UPLOAD_FORM_FOUND'		=> 'تم الرفع بنجاح لكن لم يوجد شكل الملف',
	'NO_USER'					=> 'العضو المطلوب غير موجود',
	'NO_USERS'					=> 'الأعضاء المطلوبين غير موجودين',
	'NO_USER_SPECIFIED'			=> 'لم يُحدّد اسم مستخدم',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		0	=> 'لا توجد مرفقات',
		1	=> 'ملف مرفق واحد',
		2	=> 'ملفان مرفقان',
		3	=> '%d مرفقات',
		4	=> '%d مرفقًا',
		5	=> '%d مرفق',
		),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'لا مشاركات في الانتظار',		// 0
		1			=> 'مشاركة واحدة في الانتظار',	// 1
		2			=> 'مشاركتان في الانتظار',		// 2
		3			=> '%d مشاركات في الانتظار',		// 3-10
		4			=> '%d مشاركةً في الانتظار',		// 11-99
		5			=> '%d مشاركة في الانتظار',		// 100, 101, 102..
		),

	'OCCUPATION'				=> 'الوظيفة',
	'OFFLINE'					=> 'غير متصل',
	'ONLINE'					=> 'متصل',
	'ONLINE_BUDDIES'			=> 'قائمة الأصدقاء',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'يوجد حاليًا مستخدم واحد : %2$s و %3$s',
		2	=> 'يوجد حاليًا مستخدمان : %2$s و %3$s',
		3	=> 'يوجد حاليًا <strong>%1$d</strong> مستخدمون : %2$s و %3$s',
		4	=> 'يوجد حاليًا <strong>%1$d</strong> مستخدمًا : %2$s و %3$s',
		5	=> 'يوجد حاليًا <strong>%1$d</strong> مستخدم : %2$s و %3$s',
		),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'يوجد حاليًا مستخدم واحد : %2$s، %3$s و %4$s',
		2	=> 'يوجد حاليًا مستخدمان : %2$s، %3$s و %4$s',
		3	=> 'يوجد حاليًا <strong>%1$d</strong> مستخدمين : %2$s، %3$s و %4$s',
		4	=> 'يوجد حاليًا <strong>%1$d</strong> مستخدمًا : %2$s، %3$s و %4$s',
		5	=> 'يوجد حاليًا <strong>%1$d</strong> مستخدم : %2$s، %3$s و %4$s',
		),
	'OPTIONS'					=> 'خيارات',

	'PAGE_NOT_FOUND'		=> 'الصفحة المطلوبة غير موجودة.',
	'PAGE_OF'				=> 'صفحة <strong>%1$d</strong> من <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'صفحة %s',
	'PASSWORD'				=> 'كلمة المرور',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> 'بكسل واحد',
		2	=> 'بكسلان',
		3	=> '%d بكسلات',
		4	=> '%d بكسلًا',
		5	=> '%d بكسل',
		),
	'PLEASE_WAIT'			=> 'يرجى الانتظار.',
	'PM'					=> 'إعادة إرسال',
	'PM_REPORTED'			=> 'اضغط لعرض التقرير',
	'POSTING_MESSAGE'		=> 'إرسال الرسالة في %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'يرسل رسالة خاصة',
	'POST'					=> 'مشاركة',
	'POST_ANNOUNCEMENT'		=> 'إعلان',
	'POST_STICKY'			=> 'مثبت',
	'POSTED'				=> 'مرسل',
	'POSTED_IN_FORUM'		=> 'في',
	'POSTED_ON_DATE'		=> 'في',
	'POSTS'					=> 'مشاركات',
	'POSTS_UNAPPROVED'		=> 'هناك رد واحد على الأقل لم يُوافق عليه في هذا الموضوع.',
	'POSTS_UNAPPROVED_FORUM'=> 'هناك على الأقل مشاركة واحدة في هذا المنتدى لم تتم الموافقة عليها.',
	'POST_BY_AUTHOR'		=> 'بواسطة',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>، والذي هو على قائمة التجاهل لديك، قام بكتابة هذه المشاركة.',
	'POST_DISPLAY'			=> 'عرض هذه المشاركة',
	'POST_DAY'				=> 'مشاركة في اليوم',
	'POST_DELETED_ACTION'	=> 'المشاركة المحذوفة:',
	'POST_DELETED'			=> 'تم حذف هذه المشاركة.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> قام بحذف المشاركة بواسطة <strong>%1$s</strong> في %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> قام بحذف المشاركة بواسطة <strong>%1$s</strong> في %3$s للسبب التالي: %4$s',
	'POST_DETAILS'			=> 'تفاصيل المشاركة',
	'POST_NEW_TOPIC'		=> 'إرسال موضوع جديد',
	'POST_PCT'				=> '%.2f%% من كل المشاركات',
	'POST_PCT_ACTIVE'		=> '%.2f%% من مشاركاتك',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% من مشاركاتك',
	'POST_REPLY'			=> 'إضافة رد',
	'POST_REPORTED'			=> 'اضغط لمشاهدة التقارير',
	'POST_SUBJECT'			=> 'عنوان المشاركة',
	'POST_TIME'				=> 'وقت الإرسال',
	'POST_TOPIC'			=> 'إضافة موضوع جديد',
	'POST_UNAPPROVED_ACTION'	=> 'مشاركة تنتظر الموافقة:',
	'POST_UNAPPROVED'		=> 'هذه المشاركة تنتظر الموافقة',
	'POST_UNAPPROVED_EXPLAIN'	=> 'هذه المشاركة غير مرئية للزوار حتى يتم اعتمادها من أحد المشرفين.',
	'POWERED_BY'			=> 'بدعم من %s',

	'QUOTE'					=> 'اقتباس',

	'PREVIEW'				=> 'استعراض',
	'PREVIOUS'				=> 'السابق',		// Used in pagination
	'PREVIOUS_STEP'			=> 'السابق',
	'PRIVACY'				=> 'سياسة الخصوصية',
	'PRIVACY_LINK'			=> 'الخصوصية',
	'PRIVATE_MESSAGE'		=> 'رسالة خاصة',
	'PRIVATE_MESSAGES'		=> 'الرسائل الخاصة',
	'PRIVATE_MESSAGING'		=> 'مراسلة خاصة',
	'PROFILE'				=> 'لوحة التحكم',

	'QUICK_LINKS'			=> 'روابط سريعة',

	'RANK'						=> 'الرتبة',
	'READING_FORUM'				=> 'يشاهد المواضيع في %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'يقرأ اعلان عام',
	'READING_LINK'				=> 'يتبع الرباط التالي %s',
	'READING_TOPIC'				=> 'يقرأ موضوع في %s',
	'READ_PROFILE'				=> 'الملف الشخصي',
	'REASON'					=> 'السبب',
	'RECORD_ONLINE_USERS'		=> 'أكثر وجود في المنتدى كان <strong>%1$s</strong> في %2$s',
	'REDIRECT'					=> 'تحويل',
	'REDIRECTS'					=> 'إجمالي التحويلات',
	'REGISTER'					=> 'التسجيل',
	'REGISTERED_USERS'			=> 'الأعضاء الموجودون:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'يوجد الآن عضو واحد و %2$s',
		2	=> 'يوجد الآن عضوان و %2$s',
		3	=> 'يوجد الآن %1$d أعضاء و %2$s',
		4	=> 'يوجد الآن %1$d عضوًا و %2$s',
		5	=> 'يوجد الآن %1$d عضو و %2$s',
		6	=> 'يوجد الآن %2$s',
		),
	'REG_USERS_TOTAL'			=> array(
		1	=> 'عضو واحد',
		2	=> 'عضوان',
		3	=> '%d أعضاء',
		4	=> '%d عضوًا',
		5	=> '%d عضو',
		6	=> 'لا أعضاء',
		),
	'REMOVE'					=> 'حذف',
	'REMOVE_INSTALL'			=> 'رجاءً احذف أو انقل أو غيّر اسم مجلد install',
	'REPLIES'					=> 'ردود',
	'REPLY_WITH_QUOTE'			=> 'رد مع اقتباس',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'يرد على اعلان عام',
	'REPLYING_MESSAGE'			=> 'يرد على رسالة في %s',
	'REPORT_BY'					=> 'التقرير بواسطة',
	'REPORT_POST'				=> 'تقرير عن هذه المشاركة',
	'REPORTING_POST'			=> 'تقرير المشاركة',
	'RESEND_ACTIVATION'			=> 'إعادة إرسال كود التفعيل',
	'RESET'						=> 'إعادة',
	'RESTORE_PERMISSIONS'		=> 'استعادة الصلاحيات',
	'RETURN_INDEX'				=> '%sالعودة للصفحة الرئيسية%s',
	'RETURN_FORUM'				=> '%sالرجوع إلى آخر منتدى قمت بزيارته%s',
	'RETURN_PAGE'				=> '%sالعودة للصفحة السابقة%s',
	'RETURN_TOPIC'				=> '%sالرجوع إلى آخر موضوع قمت بزيارته%s',
	'RETURN_TO'					=> 'العودة إلى ”%s“',
	'RETURN_TO_INDEX'			=> 'العودة إلى فهرس المنتدى',

	'ROUTE_NOT_FOUND'				=> 'المسار المطلوب “%s” لم يعثر عليه.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'وسائط مفقودة أو خاطئة أرسلت إلى المسار “%s”.',

	'FEED'						=> 'التغذية - Feed',
	'FEED_NEWS'					=> 'الأخبار - News',
	'FEED_TOPICS_ACTIVE'		=> 'مواضيع نشيطة',
	'FEED_TOPICS_NEW'			=> 'مواضيع جديدة',
	'RULES_ATTACH_CAN'			=> '<strong>تستطيع</strong> إرفاق ملف في هذا المنتدى',
	'RULES_ATTACH_CANNOT'		=> '<strong>لا تستطيع</strong> إرفاق ملف في هذا المنتدى',
	'RULES_DELETE_CAN'			=> '<strong>تستطيع</strong> حذف مشاركاتك في هذا المنتدى',
	'RULES_DELETE_CANNOT'		=> '<strong>لا تستطيع</strong> حذف مشاركاتك في هذا المنتدى',
	'RULES_DOWNLOAD_CAN'		=> '<strong>تستطيع</strong> تحميل المرفقات في هذا المنتدى',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>لا تستطيع</strong> تحميل المرفقات في هذا المنتدى',
	'RULES_EDIT_CAN'			=> '<strong>تستطيع</strong> تعديل مشاركاتك في هذا المنتدى',
	'RULES_EDIT_CANNOT'			=> '<strong>لا تستطيع</strong> تعديل مشاركاتك في هذا المنتدى',
	'RULES_LOCK_CAN'			=> '<strong>تستطيع</strong> إغلاق مواضيعك في هذا المنتدى',
	'RULES_LOCK_CANNOT'			=> '<strong>لا تستطيع</strong> إغلاق مواضيعك في هذا المنتدى',
	'RULES_POST_CAN'			=> '<strong>تستطيع</strong> كتابة مواضيع جديدة في هذا المنتدى',
	'RULES_POST_CANNOT'			=> '<strong>لا تستطيع</strong> كتابة مواضيع جديدة في هذا المنتدى',
	'RULES_REPLY_CAN'			=> '<strong>تستطيع</strong> كتابة ردود في هذا المنتدى',
	'RULES_REPLY_CANNOT'		=> '<strong>لا تستطيع</strong> كتابة ردود في هذا المنتدى',
	'RULES_VOTE_CAN'			=> '<strong>تستطيع</strong> التصويت في هذا المنتدى',
	'RULES_VOTE_CANNOT'			=> '<strong>لا تستطيع</strong> التصويت في هذا المنتدى',

	'SEARCH'					=> 'بحث',
	'SEARCH_MINI'				=> 'بحث …',
	'SEARCH_ADV'				=> 'بحث متقدم',
	'SEARCH_ADV_EXPLAIN'		=> 'عرض خيارات البحث المتقدم',
	'SEARCH_KEYWORDS'			=> 'البحث عن الكلمات',
	'SEARCHING_FORUMS'			=> 'بحث المنتديات',
	'SEARCH_ACTIVE_TOPICS'		=> 'المواضيع النشطة',
	'SEARCH_FOR'				=> 'البحث عن',
	'SEARCH_FORUM'				=> 'ابحث في المنتدى …',
	'SEARCH_NEW'				=> 'المشاركات الجديدة',
	'SEARCH_POSTS_BY'			=> 'ابحث في المشاركات بواسطة',
	'SEARCH_SELF'				=> 'مشاركاتك',
	'SEARCH_TOPIC'				=> 'ابحث في الموضوع…',
	'SEARCH_UNANSWERED'			=> 'مواضيع لم يُرد عليها',
	'SEARCH_UNREAD'				=> 'المشاركات غير المقروءة',
	'SEARCH_USER_POSTS'			=> 'ابحث في مشاركات العضو',
	'SECONDS'					=> 'ثواني',
	'SEE_ALL'					=> 'مشاهدة الكل',
	'SELECT'					=> 'تحديد',
	'SELECT_ALL_CODE'			=> 'تحديد الكل',
	'SELECT_DESTINATION_FORUM'	=> 'فضلًا حدد المنتدى المطلوب',
	'SELECT_FORUM'				=> 'اختيار منتدى',
	'SEND_EMAIL'				=> 'إرسال بريد',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'أرسل بريد الكتروني للعضو %s',
	'SEND_PRIVATE_MESSAGE'		=> 'ارسال رسالة خاصة',
	'SETTINGS'					=> 'إعدادات',
	'SIGNATURE'					=> 'التوقيع',
	'SKIP'						=> 'تجاهل المحتويات',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'لا يدعم خادم SMTP هذه الصلاحيات',
	'SORRY_AUTH_READ'			=> 'ليست لديك الصلاحية لقراءة محتويات هذا المنتدى',
	'SORRY_AUTH_READ_TOPIC'		=> 'غير مصرح لك بالاطلاع على هذا الموضوع.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'لا تملك الصلاحية لتحميل هذا المرفق',
	'SORT_BY'					=> 'مرتبة بواسطة',
	'SORT_DIRECTION'			=> 'اتجاه الترتيب',
	'SORT_JOINED'				=> 'تاريخ الاشتراك',
	'SORT_LOCATION'				=> 'المكان',
	'SORT_OPTIONS'				=> 'خيارات العرض والترتيب',
	'SORT_RANK'					=> 'الرتبة',
	'SORT_POSTS'				=> 'المشاركات',
	'SORT_TOPIC_TITLE'			=> 'عنوان الموضوع',
	'SORT_USERNAME'				=> 'اسم المستخدم',
	'SPLIT_TOPIC'				=> 'تقسيم الموضوع',
	'SQL_ERROR_OCCURRED'		=> 'حدث خطأ SQL أثناء القيام باستدعاء الصفحة. إذا استمر الخطأ قم بمراسلة %sمدير المنتدى%s عن هذه المشكلة',
	'STATISTICS'				=> 'إحصائيات',
	'START_WATCHING_FORUM'		=> 'متابعة هذا المنتدى',
	'START_WATCHING_TOPIC'		=> 'متابعة هذا الموضوع',
	'STOP_WATCHING_FORUM'		=> 'إلغاء متابعة هذا المنتدى',
	'STOP_WATCHING_TOPIC'		=> 'إلغاء متابعة هذا الموضوع',
	'STRING_LIST_MULTI'			=> '%1$s، و %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s و %2$s',
	'SUBFORUM'					=> 'منتدى فرعي',
	'SUBFORUMS'					=> 'منتديات فرعية',
	'SUBJECT'					=> 'عنوان',
	'SUBMIT'					=> 'إرسال',

	'TB'				=> 'تيرابايت',
	'TERMS_LINK'		=> 'الشروط',
	'TERMS_USE'			=> 'شروط الاستخدام',
	'TEST_CONNECTION'	=> 'اختبار الاتصال',
	'THE_TEAM'			=> 'فريق الموقع',
	'TIB'				=> 'TiB',
	'TIME'				=> 'الوقت',
	'TIMEOUT_PROCESSING_REQ'			=> 'وقت التنفيذ انتهى.',

	'TOO_LARGE'						=> 'القيمة المدخلية كبيرة جدًا',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'إن قيمة <strong>عدد المستقبلين الأقصى للرسالة الخاصة</strong> كبير جدًا.',

	'TOO_LONG'						=> 'القيمة المدخلة طويلة جدًا.',

	'TOO_LONG_CONFIRM_CODE'			=> 'الرمز الأمني الذي أدخلته طويل جدًا',
	'TOO_LONG_DATEFORMAT'			=> 'صيغة التاريخ التي أدخلتها كبيرة جدًا',
	'TOO_LONG_JABBER'				=> 'حساب Jabber الذي أدخلته طويل جدًا',
	'TOO_LONG_NEW_PASSWORD'			=> 'كلمة المرور التي أدخلتها طويلة جدًا',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'تأكيد كلمة المرور التي أدخلتها طويل جدًا',
	'TOO_LONG_USER_PASSWORD'		=> 'كلمة المرور التي أدخلتها طويلة جدًا',
	'TOO_LONG_USERNAME'				=> 'اسم المستخدم الذي أدخلته طويل جدًا',
	'TOO_LONG_EMAIL'				=> 'البريد الإلكتروني الذي أدخلته طويل جدًا',

	'TOO_MANY_VOTE_OPTIONS'			=> 'حاولت أن تصوّت للعديد من الخيارات',

	'TOO_SHORT'						=> 'القيمة التي أدخلتها قصيرة جدًا.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'الرمز الأمني الذي أدخلته قصير جدًا',
	'TOO_SHORT_DATEFORMAT'			=> 'صيغة التاريخ التي أدخلتها صغيرة جدًا',
	'TOO_SHORT_JABBER'				=> 'حساب Jabber الذي أدخلته قصير جدًا',
	'TOO_SHORT_NEW_PASSWORD'		=> 'كلمة المرور التي أدخلتها قصيرة جدًا',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'تأكيد كلمة المرور التي أدخلتها قصير جدًا',
	'TOO_SHORT_USER_PASSWORD'		=> 'كلمة المرور التي أدخلتها قصيرة جدًا',
	'TOO_SHORT_USERNAME'			=> 'اسم المستخدم الذي أدخلته قصير جدًا',
	'TOO_SHORT_EMAIL'				=> 'البريد الالكتروني الذي أدخلته قصير جدًا',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'تأكيد البريد الالكتروني الذي أدخلته قصير جدًا.',
	'TOO_SMALL'						=> 'القيمة المدخلية قصيرة جدًا.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'إن قيمة <strong>عدد المستلمين الأقصى للرسالة الخاصة</strong> قصير جدًا.',

	'TOPIC'				=> 'موضوع',
	'TOPICS'			=> 'مواضيع',
	'TOPICS_UNAPPROVED'	=> 'يوجد على الأقل موضوع واحد لم يُوافق عليه بعد.',
	'TOPIC_ICON'		=> 'أيقونة الموضوع',
	'TOPIC_LOCKED'		=> 'هذا الموضوع مغلق، لا تستطيع تعديله أو إضافة الردود عليه',
	'TOPIC_LOCKED_SHORT'=> 'الموضوع مغلق',
	'TOPIC_MOVED'		=> 'موضوع منقول',
	'TOPIC_REVIEW'		=> 'مراجعة الموضوع',
	'TOPIC_TITLE'		=> 'عنوان الموضوع',
	'TOPIC_UNAPPROVED'	=> 'لم يُوافق على هذا الموضوع',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'موضوع واحد ينتظر الموافقة',
		2	=> 'موضوعان ينتظران الموافقة',
		3	=> 'مواضيع تنتظر الموافقة',
		4	=> 'مواضيع تنتظر الموافقة',
		5	=> 'مواضيع تنتظر الموافقة',
		),
	'TOPIC_DELETED'		=> 'هذا الموضوع تم حذفه.',
	'TOTAL_ATTACHMENTS'	=> 'المرفقات',
	'TOTAL_LOGS'		=> array(
		1	=> 'سجل واحد',
		2	=> 'سجلان',
		3	=> '%d سجلات',
		4	=> '%d سجلًا',
		5	=> '%d سجل',
		),
	'TOTAL_PMS'		=> array(
		1	=> 'رسالة خاصة واحدة في المجمل',
		2	=> 'رسالتان خاصتان في المجمل',
		3	=> '%d رسائل خاصة في المجمل',
		4	=> '%d رسالةً خاصة في المجمل',
		5	=> '%d رسالة خاصة في المجمل',
		),
	'TOPIC_POLL'		=> 'هذا الموضوع يحتوي على استطلاع.',
	'TOTAL_POSTS'		=> 'عدد المشاركات',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'عدد المشاركات <strong>%d</strong>',
		),
	'TOPIC_REPORTED'	=> 'تم التبليغ هذا الموضوع',
	'TOTAL_TOPICS'		=> array(
		2	=> 'عدد المواضيع <strong>%d</strong>',
		),
	'TOTAL_USERS'		=> array(
		2	=> 'عدد الأعضاء <strong>%d</strong>',
		),
	'TRACKED_PHP_ERROR'	=> 'أخطاء تتبع PHP: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'لم يتمكن من تحديد أبعاد الصورة',
	'UNABLE_TO_DELIVER_FILE'=> 'غير قادر على توصيل الملف',
	'UNKNOWN_BROWSER'		=> 'متصفح غير معروف',
	'UNMARK_ALL'			=> 'إلغاء تحديد الكل',
	'UNREAD_MESSAGES'		=> 'رسائل غير مقروءة',
	'UNREAD_POST'			=> 'مشاركة غير مقروءة',
	'UNREAD_POSTS'			=> 'مشاركات غير مقروءة',
	'UNWATCH_FORUM_CONFIRM'		=> 'هل انت متأكد أنك تريد أن تلغي اشتراكك في هذا المنتدى؟',
	'UNWATCH_FORUM_DETAILED'	=> 'هل أنت متأكد أنك تريد أن تلغي اشتراكك في المنتدى ”%s“؟',
	'UNWATCH_TOPIC_CONFIRM'		=> 'هل أنت متأكد أنك تريد أن تلغي اشتراكك في هذا الموضوع؟',
	'UNWATCH_TOPIC_DETAILED'	=> 'هل أنت متأكد أنك تريد أن تلغي اشتراكك في الموضوع ”%s“؟',
	'UNWATCHED_FORUMS'			=> 'لم تعد متابعًا المنتديات المحددة',
	'UNWATCHED_TOPICS'			=> 'لم تعد متابعًا المواضيع المحددة',
	'UNWATCHED_FORUMS_TOPICS'	=> 'لم تعد متابعًا المنتديات والمواضيع التي حددتها',
	'UPDATE'				=> 'تحديث',
	'UPLOAD_IN_PROGRESS'	=> 'جاري الرفع حاليًا',
	'URL_REDIRECT'			=> 'إذا كان متصفحك لا يدعم الانتقال التلقائي اضغط %sهنا%s للانتقال',
	'USERGROUPS'			=> 'المجموعات',
	'USERNAME'				=> 'اسم المستخدم',
	'USERNAMES'				=> 'أسماء المستخدمين',
	'USER_AVATAR'			=> 'صورة العضو الرمزية',
	'USER_CANNOT_READ'		=> 'لا يمكنك قراءة المشاركات في هذا المنتدى',
	'USER_POSTS'			=> array(
		1	=> 'مشاركة واحدة',
		2	=> 'مشاركتان',
		3	=> '%d مشاركات',
		4	=> '%d مشاركةً',
		5	=> '%d مشاركة',
		),
	'USERS'					=> 'مستخدمين',
	'USE_PERMISSIONS'		=> 'تجربة صلاحيات هذا المستخدم',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'عذرًا، لست مخوّلًا لاستخدام هذه الميزة. قد تكون عضوًا جديدًا في المنتدى وتحتاج إلى المزيد من المشاركة لتصبح هذه الميزة متاحة لك.',

	'VARIANT_DATE_SEPARATOR'	=> ' /',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'شوهد',
	'VIEWED_COUNTS'		=> array(
		0	=> 'لم تتم مشاهدته بعد',
		1	=> 'تمت المشاهدة مرة واحدة',
		2	=> 'تمت المشاهدة مرتين',
		3	=> 'تمت المشاهدة %d مرات',
		4	=> 'تمت المشاهدة %d مرةً',
		5	=> 'تمت المشاهدة %d مرة',
		),
	'VIEWING_CONTACT_ADMIN'		=> 'يشاهد صفحة الاتصال بالإدارة',
	'VIEWING_FAQ'				=> 'يشاهد الأسئلة المتكررة',
	'VIEWING_MEMBERS'			=> 'يشاهد قائمة الأعضاء',
	'VIEWING_ONLINE'			=> 'يشاهد الموجودين الآن',
	'VIEWING_MCP'				=> 'مشاهدة لوحة تحكم المشرف',
	'VIEWING_MEMBER_PROFILE'	=> 'يشاهد الملف الشخصي لأحد الأعضاء',
	'VIEWING_PRIVATE_MESSAGES'	=> 'يشاهد الرسائل الخاصة',
	'VIEWING_REGISTER'			=> 'يسجل عضوية جديدة',
	'VIEWING_UCP'				=> 'يشاهد لوحة تحكم العضو',
	'VIEWS'						=> 'مشاهدات',
	'VIEW_BOOKMARKS'			=> 'شاهد المفضلات',
	'VIEW_FORUM_LOGS'			=> 'شاهد التسجيلات',
	'VIEW_LATEST_POST'			=> 'شاهد آخر مشاركة',
	'VIEW_NEWEST_POST'			=> 'شاهد أحدث مشاركة',
	'VIEW_NOTES'				=> 'شاهد مذكرات الأعضاء',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'هذه البيانات تعتمد على الأعضاء النشطين خلال الدقيقة الماضية',
		2	=> 'هذه البيانات تعتمد على الأعضاء النشطين خلال الدقيقتان الماضيتان',
		3	=> 'هذه البيانات تعتمد على الأعضاء النشطين خلال الـ %d دقائق الماضية',
		4	=> 'هذه البيانات تعتمد على الأعضاء النشطين خلال الـ %d دقيقةً الماضية',
		5	=> 'هذه البيانات تعتمد على الأعضاء النشطين خلال الـ %d دقيقة الماضية',
		),
	'VIEW_TOPIC'				=> 'مشاهدة الموضوع',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'إعلان:',
	'VIEW_TOPIC_GLOBAL'			=> 'اعلان عام:',
	'VIEW_TOPIC_LOCKED'			=> 'مغلق:',
	'VIEW_TOPIC_LOGS'			=> 'شاهد السجلات',
	'VIEW_TOPIC_MOVED'			=> 'انتقل:',
	'VIEW_TOPIC_POLL'			=> 'الاستطلاع:',
	'VIEW_TOPIC_STICKY'			=> 'مثبت:',
	'VISIT_WEBSITE'				=> 'زيارة الموقع',

	'WARNINGS'			=> 'تحذيرات',
	'WARN_USER'			=> 'تحذير العضو',
	'WATCH_FORUM_CONFIRM'	=> 'هل أنت متأكد انك تريد أن تشترك في هذا المنتدى؟',
	'WATCH_FORUM_DETAILED'	=> 'هل أنت متأكد أنك تريد أن تشترك في المنتدى ”%s“؟',
	'WATCH_TOPIC_CONFIRM'	=> 'هل أنت متأكد أنك تريد أن تشترك في هذا الموضوع؟',
	'WATCH_TOPIC_DETAILED'	=> 'هل أنت متأكد أنك تريد أن تشترك في الموضوع ”%s“؟',
	'WELCOME_SUBJECT'	=> 'أهلا وسهلا بك في منتديات %s',
	'WEBSITE'			=> 'WWW',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'الموجودون الآن',
	'WRONG_PASSWORD'	=> 'لقد أدخلت كلمة مرور خاطئة',

	'WRONG_DATA_COLOUR'			=> 'كود اللون المدخل غير صحيح.',
	'WRONG_DATA_JABBER'			=> 'اسم حساب Jabber الذي أدخلته غير صحيح',
	'WRONG_DATA_LANG'			=> 'اللغة التي حددتها ليست صحيحة',
	'WRONG_DATA_POST_SD'		=> 'اتجاه ترتيب المشاركات الذي حددته غير صالح.',
	'WRONG_DATA_POST_SK'		=> 'خيار ترتيب المشاركات الذي حددته غير صالح.',
	'WRONG_DATA_TOPIC_SD'		=> 'اتجاه ترتيب المواضيع الذي حددته غير صالح.',
	'WRONG_DATA_TOPIC_SK'		=> 'خيار ترتيب المواضيع الذي حددته غير صالح.',
	'WROTE'						=> 'كتب',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'سنة',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'نعم',
	'YOU_LAST_VISIT'	=> 'آخر زيارة كانت في: %s',

	'datetime'			=> array(
		'TODAY'		=> 'اليوم',
		'TOMORROW'	=> 'غدًا',
		'YESTERDAY'	=> 'الأمس',
		'AGO'		=> array(
			0		=> 'منذ أقل من دقيقة',
			1		=> 'منذ دقيقة واحدة',
			2		=> 'منذ دقيقتين',
			3		=> 'منذ %d دقائق',
			4		=> 'منذ %d دقيقة',
			5		=> 'منذ %d دقيقة',
			),

		'Sunday'	=> 'الأحد',
		'Monday'	=> 'الاثنين',
		'Tuesday'	=> 'الثلاثاء',
		'Wednesday'	=> 'الأربعاء',
		'Thursday'	=> 'الخميس',
		'Friday'	=> 'الجمعة',
		'Saturday'	=> 'السبت',

		'Sun'		=> 'الأحد',
		'Mon'		=> 'الاثنين',
		'Tue'		=> 'الثلاثاء',
		'Wed'		=> 'الأربعاء',
		'Thu'		=> 'الخميس',
		'Fri'		=> 'الجمعة',
		'Sat'		=> 'السبت',

		'January'	=> 'يناير',
		'February'	=> 'فبراير',
		'March'		=> 'مارس',
		'April'		=> 'إبريل',
		'May'		=> 'مايو',
		'June'		=> 'يونيو',
		'July'		=> 'يوليو',
		'August'	=> 'أغسطس',
		'September' => 'سبتمبر',
		'October'	=> 'أكتوبر',
		'November'	=> 'نوفمبر',
		'December'	=> 'ديسمبر',

		'Jan'		=> 'يناير',
		'Feb'		=> 'فبراير',
		'Mar'		=> 'مارس',
		'Apr'		=> 'إبريل',
		'May_short'	=> 'مايو',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'يونيو',
		'Jul'		=> 'يوليو',
		'Aug'		=> 'أغسطس',
		'Sep'		=> 'سبتمبر',
		'Oct'		=> 'أكتوبر',
		'Nov'		=> 'نوفمبر',
		'Dec'		=> 'ديسمبر',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'التوقيت العالمي',
		'UTC_OFFSET'			=> 'التوقيت العالمي%1$s',
		'UTC_OFFSET_CURRENT'	=> 'التوقيت العالمي%1$s - %2$s',

		'Etc/GMT-12'	=> 'التوقيت العالمي+12',
		'Etc/GMT-11'	=> 'التوقيت العالمي+11',
		'Etc/GMT-10'	=> 'التوقيت العالمي+10',
		'Etc/GMT-9'		=> 'التوقيت العالمي+9',
		'Etc/GMT-8'		=> 'التوقيت العالمي+8',
		'Etc/GMT-7'		=> 'التوقيت العالمي+7',
		'Etc/GMT-6'		=> 'التوقيت العالمي+6',
		'Etc/GMT-5'		=> 'التوقيت العالمي+5',
		'Etc/GMT-4'		=> 'التوقيت العالمي+4',
		'Etc/GMT-3'		=> 'التوقيت العالمي+3',
		'Etc/GMT-2'		=> 'التوقيت العالمي+2',
		'Etc/GMT-1'		=> 'التوقيت العالمي+1',
		'Etc/GMT+1'		=> 'التوقيت العالمي-1',
		'Etc/GMT+2'		=> 'التوقيت العالمي-2',
		'Etc/GMT+3'		=> 'التوقيت العالمي-3',
		'Etc/GMT+4'		=> 'التوقيت العالمي-4',
		'Etc/GMT+5'		=> 'التوقيت العالمي-5',
		'Etc/GMT+6'		=> 'التوقيت العالمي-6',
		'Etc/GMT+7'		=> 'التوقيت العالمي-7',
		'Etc/GMT+8'		=> 'التوقيت العالمي-8',
		'Etc/GMT+9'		=> 'التوقيت العالمي-9',
		'Etc/GMT+10'	=> 'التوقيت العالمي-10',
		'Etc/GMT+11'	=> 'التوقيت العالمي-11',
		'Etc/GMT+12'	=> 'التوقيت العالمي-12',

		'Africa/Abidjan'	=> 'أفريقيا/أبيدجان',
		'Africa/Accra'		=> 'أفريقيا/أكرا',
		'Africa/Addis_Ababa'	=> 'أفريقيا/أديس أبابا',
		'Africa/Algiers'	=> 'أفريقيا/الجزائر',
		'Africa/Asmara'		=> 'أفريقيا/أسمرة',
		'Africa/Bamako'		=> 'أفريقيا/باماكو',
		'Africa/Bangui'		=> 'أفريقيا/بانغي',
		'Africa/Banjul'		=> 'أفريقيا/بانجول',
		'Africa/Bissau'		=> 'أفريقيا/بيساو',
		'Africa/Blantyre'	=> 'أفريقيا/بلانتير',
		'Africa/Brazzaville'	=> 'أفريقيا/برازافيل',
		'Africa/Bujumbura'	=> 'أفريقيا/بوجومبرا',
		'Africa/Cairo'		=> 'أفريقيا/القاهرة',
		'Africa/Casablanca'	=> 'أفريقيا/الدار البيضاء',
		'Africa/Ceuta'		=> 'أفريقيا/سبتة',
		'Africa/Conakry'	=> 'أفريقيا/كوناكري',
		'Africa/Dakar'		=> 'أفريقيا/داكار',
		'Africa/Dar_es_Salaam'	=> 'أفريقيا/دار السلام',
		'Africa/Djibouti'	=> 'أفريقيا/جيبوتي',
		'Africa/Douala'		=> 'أفريقيا/دوالا',
		'Africa/El_Aaiun'	=> 'أفريقيا/العيون',
		'Africa/Freetown'	=> 'أفريقيا/فريتاون',
		'Africa/Gaborone'	=> 'أفريقيا/غابورون',
		'Africa/Harare'		=> 'أفريقيا/هراري',
		'Africa/Johannesburg'	=> 'أفريقيا/جوهانسبرج',
		'Africa/Juba'		=> 'أفريقيا/جوبا',
		'Africa/Kampala'	=> 'أفريقيا/كمبالا',
		'Africa/Khartoum'	=> 'أفريقيا/الخرطوم',
		'Africa/Kigali'		=> 'أفريقيا/كيغالي',
		'Africa/Kinshasa'	=> 'أفريقيا/كينشاسا',
		'Africa/Lagos'		=> 'أفريقيا/البحيرات',
		'Africa/Libreville'	=> 'أفريقيا/ليبرفيل',
		'Africa/Lome'		=> 'أفريقيا/لومي',
		'Africa/Luanda'		=> 'أفريقيا/لواندا',
		'Africa/Lubumbashi'	=> 'أفريقيا/لوبومباشي',
		'Africa/Lusaka'		=> 'أفريقيا/لوساكا',
		'Africa/Malabo'		=> 'أفريقيا/مالابو',
		'Africa/Maputo'		=> 'أفريقيا/مابوتو',
		'Africa/Maseru'		=> 'أفريقيا/ماسيرو',
		'Africa/Mbabane'	=> 'أفريقيا/مبابان',
		'Africa/Mogadishu'	=> 'أفريقيا/مقديشيو',
		'Africa/Monrovia'	=> 'أفريقيا/مونروفيا',
		'Africa/Nairobi'	=> 'أفريقيا/نيروبي',
		'Africa/Ndjamena'	=> 'أفريقيا/نجامينا',
		'Africa/Niamey'		=> 'أفريقيا/نيامي',
		'Africa/Nouakchott'	=> 'أفريقيا/نواكشوط',
		'Africa/Ouagadougou'	=> 'أفريقيا/واغادوغو',
		'Africa/Porto-Novo'	=> 'أفريقيا/بورتو-نوفو',
		'Africa/Sao_Tome'	=> 'أفريقيا/ساو تومي',
		'Africa/Tripoli'	=> 'أفريقيا/تريبولي',
		'Africa/Tunis'		=> 'أفريقيا/تونس',
		'Africa/Windhoek'	=> 'أفريقيا/ويندهوك',

		'America/Adak'		=> 'أمريكا/اداك',
		'America/Anchorage'	=> 'أمريكا/أنكوريج',
		'America/Anguilla'	=> 'أمريكا/أنغيلا',
		'America/Antigua'	=> 'أمريكا/أنتيغوا',
		'America/Araguaina'	=> 'أمريكا/أراغواينا',

		'America/Argentina/Buenos_Aires'	=> 'أمريكا/الأرجنتين/بوينس آيرس',
		'America/Argentina/Catamarca'	=> 'أمريكا/الأرجنتين/كاتاماركا',
		'America/Argentina/Cordoba'		=> 'أمريكا/الأرجنتين/قرطبة',
		'America/Argentina/Jujuy'		=> 'أمريكا/الأرجنتين/خوخوي',
		'America/Argentina/La_Rioja'	=> 'أمريكا/الأرجنتين/لا ريوخا',
		'America/Argentina/Mendoza'		=> 'أمريكا/الأرجنتين/ميندوزا',
		'America/Argentina/Rio_Gallegos'	=> 'أمريكا/الأرجنتين/ريو غاليغوس',
		'America/Argentina/Salta'		=> 'أمريكا/الأرجنتين/سالتا',
		'America/Argentina/San_Juan'	=> 'أمريكا/الأرجنتين/سان خوان',
		'America/Argentina/San_Luis'	=> 'أمريكا/الأرجنتين/سان لويس',
		'America/Argentina/Tucuman'		=> 'أمريكا/الأرجنتين/توكومان',
		'America/Argentina/Ushuaia'		=> 'أمريكا/الأرجنتين/أوشوايا',

		'America/Aruba'			=> 'أمريكا/أروبا',
		'America/Asuncion'		=> 'أمريكا/أسونسيون',
		'America/Atikokan'		=> 'أمريكا/أتيكوكان',
		'America/Bahia'			=> 'أمريكا/باهيا',
		'America/Bahia_Banderas'	=> 'أمريكا/باهيا بانديراس',
		'America/Barbados'		=> 'أمريكا/بربادوس',
		'America/Belem'			=> 'أمريكا/بيت لحم',
		'America/Belize'		=> 'أمريكا/بليز',
		'America/Blanc-Sablon'	=> 'أمريكا/بلان-سابلون',
		'America/Boa_Vista'		=> 'أمريكا/بوينا فيستا',
		'America/Bogota'		=> 'أمريكا/بوغوتا',
		'America/Boise'			=> 'أمريكا/بويز',
		'America/Cambridge_Bay'	=> 'أمريكا/خليج كامبريدج',
		'America/Campo_Grande'	=> 'أمريكا/كامبو غراندي',
		'America/Cancun'		=> 'أمريكا/كانكون',
		'America/Caracas'		=> 'أمريكا/كراكاس',
		'America/Cayenne'		=> 'أمريكا/كايين',
		'America/Cayman'		=> 'أمريكا/كايمان',
		'America/Chicago'		=> 'أمريكا/شيكاغو',
		'America/Chihuahua'		=> 'أمريكا/شيواوا',
		'America/Costa_Rica'	=> 'أمريكا/كوستا ريكا',
		'America/Creston'		=> 'أمريكا/كريستون',
		'America/Cuiaba'		=> 'أمريكا/كويابا',
		'America/Curacao'		=> 'أمريكا/كوراكاو',
		'America/Danmarkshavn'	=> 'أمريكا/دانماركشافن',
		'America/Dawson'		=> 'أمريكا/داوسون',
		'America/Dawson_Creek'	=> 'أمريكا/داوسون كريك',
		'America/Denver'		=> 'أمريكا/دينفر',
		'America/Detroit'		=> 'أمريكا/ديترويت',
		'America/Dominica'		=> 'أمريكا/دومينيكا',
		'America/Edmonton'		=> 'أمريكا/ادمونتون',
		'America/Eirunepe'		=> 'أمريكا/ايرونيب',
		'America/El_Salvador'	=> 'أمريكا/السلفادور',
		'America/Fortaleza'		=> 'أمريكا/فورتاليزا',
		'America/Glace_Bay'		=> 'أمريكا/خليج جليس',
		'America/Godthab'		=> 'أمريكا/غادتاب',
		'America/Goose_Bay'		=> 'أمريكا/خليج الأوز',
		'America/Grand_Turk'	=> 'أمريكا/غراند تورك',
		'America/Grenada'		=> 'أمريكا/غرينادا',
		'America/Guadeloupe'	=> 'أمريكا/غوادلوب',
		'America/Guatemala'		=> 'أمريكا/جواتيمالا',
		'America/Guayaquil'		=> 'أمريكا/غواياكيل',
		'America/Guyana'		=> 'أمريكا/غيانا',
		'America/Halifax'		=> 'أمريكا/هاليفاكس',
		'America/Havana'		=> 'أمريكا/هافانا',
		'America/Hermosillo'		=> 'أمريكا/هيرموسيلو',
		'America/Indiana/Indianapolis'	=> 'أمريكا/إنديانا/انديانابوليس',
		'America/Indiana/Knox'		=> 'أمريكا/إنديانا/نوكس',
		'America/Indiana/Marengo'	=> 'أمريكا/إنديانا/مارينغو',
		'America/Indiana/Petersburg'	=> 'أمريكا/إنديانا/بطرسبرج',
		'America/Indiana/Tell_City'	=> 'أمريكا/إنديانا/مدينة تيل',
		'America/Indiana/Vevay'		=> 'أمريكا/إنديانا/فيفاي',
		'America/Indiana/Vincennes'	=> 'أمريكا/إنديانا/فينسين',
		'America/Indiana/Winamac'	=> 'أمريكا/إنديانا/ويناماك',
		'America/Inuvik'		=> 'أمريكا/إنوفيك',
		'America/Iqaluit'		=> 'أمريكا/إيكالويت',
		'America/Jamaica'		=> 'أمريكا/جامايكا',
		'America/Juneau'		=> 'أمريكا/جونو',
		'America/Kentucky/Louisville'	=> 'أمريكا/كنتاكي/لويزفيل',
		'America/Kentucky/Monticello'	=> 'أمريكا/كنتاكي/مونتيشيلو',
		'America/Kralendijk'	=> 'أمريكا/كرالنديك',
		'America/La_Paz'		=> 'أمريكا/لاباز',
		'America/Lima'			=> 'أمريكا/ليما',
		'America/Los_Angeles'	=> 'أمريكا/لوس أنجلوس',
		'America/Lower_Princes'	=> 'أمريكا/لاور برنسيس',
		'America/Maceio'		=> 'أمريكا/ماسيو',
		'America/Managua'		=> 'أمريكا/ماناغوا',
		'America/Manaus'		=> 'أمريكا/ماناوس',
		'America/Marigot'		=> 'أمريكا/ماريجوت',
		'America/Martinique'	=> 'أمريكا/مارتينيك',
		'America/Matamoros'		=> 'أمريكا/ماتاموروس',
		'America/Mazatlan'		=> 'أمريكا/مازاتلان',
		'America/Menominee'		=> 'أمريكا/مينوميني',
		'America/Merida'		=> 'أمريكا/ميريدا',
		'America/Metlakatla'	=> 'أمريكا/ميتلاكاتلا',
		'America/Mexico_City'	=> 'أمريكا/مكسيكو سيتي',
		'America/Miquelon'		=> 'أمريكا/ميكلون',
		'America/Moncton'		=> 'أمريكا/مونكتون',
		'America/Monterrey'		=> 'أمريكا/مونتيري',
		'America/Montevideo'	=> 'أمريكا/مونتيفيديو',
		'America/Montreal'		=> 'أمريكا/مونتريال',
		'America/Montserrat'	=> 'أمريكا/مونتسيرات',
		'America/Nassau'		=> 'أمريكا/ناسو',
		'America/New_York'		=> 'أمريكا/نيو يورك',
		'America/Nipigon'		=> 'أمريكا/نيبيجون',
		'America/Nome'			=> 'أمريكا/نوم',
		'America/Noronha'		=> 'أمريكا/نورونها',
		'America/North_Dakota/Beulah'		=> 'أمريكا/داكوتا الشمالية/بيولاه',
		'America/North_Dakota/Center'		=> 'أمريكا/داكوتا الشمالية/سنتر',
		'America/North_Dakota/New_Salem'	=> 'أمريكا/داكوتا الشمالية/نيو سالم',
		'America/Ojinaga'		=> 'أمريكا/أوجيناجا',
		'America/Panama'		=> 'أمريكا/بنما',
		'America/Pangnirtung'	=> 'أمريكا/بانجنيرتونج',
		'America/Paramaribo'	=> 'أمريكا/باراماريبو',
		'America/Phoenix'		=> 'أمريكا/فينكس',
		'America/Port-au-Prince'	=> 'أمريكا/بورت أو برنس',
		'America/Port_of_Spain'	=> 'أمريكا/ميناء أسبانيا',
		'America/Porto_Velho'	=> 'أمريكا/بورتو فيلهو',
		'America/Puerto_Rico'	=> 'أمريكا/بورتو ريكو',
		'America/Rainy_River'	=> 'أمريكا/نهر الأمطار',
		'America/Rankin_Inlet'	=> 'أمريكا/مدخل رانكن',
		'America/Recife'		=> 'أمريكا/ريسيف',
		'America/Regina'		=> 'أمريكا/ريجينا',
		'America/Resolute'		=> 'أمريكا/ريزوليوت',
		'America/Rio_Branco'	=> 'أمريكا/ريو برانكو',
		'America/Santa_Isabel'	=> 'أمريكا/سانتا ايزابيل',
		'America/Santarem'		=> 'أمريكا/سانتاريم',
		'America/Santiago'		=> 'أمريكا/سانتياجو',
		'America/Santo_Domingo'	=> 'أمريكا/سانتو دومينجو',
		'America/Sao_Paulo'		=> 'أمريكا/ساو باولو',
		'America/Scoresbysund'	=> 'أمريكا/سكورسبيسوند',
		'America/Shiprock'		=> 'أمريكا/شيبروك',
		'America/Sitka'			=> 'أمريكا/سيتكا',
		'America/St_Barthelemy'	=> 'أمريكا/سانت بارثيلمي',
		'America/St_Johns'		=> 'أمريكا/سانت جونز',
		'America/St_Kitts'		=> 'أمريكا/سانت كيتس',
		'America/St_Lucia'		=> 'أمريكا/سانت لوسيا',
		'America/St_Thomas'		=> 'أمريكا/سانت توماس',
		'America/St_Vincent'	=> 'أمريكا/سانت فينسنت',
		'America/Swift_Current'	=> 'أمريكا/سويفت كارنت',
		'America/Tegucigalpa'	=> 'أمريكا/تيجوسيجالبا',
		'America/Thule'			=> 'أمريكا/ثول',
		'America/Thunder_Bay'	=> 'أمريكا/خليج الرعد',
		'America/Tijuana'		=> 'أمريكا/تيجوانا',
		'America/Toronto'		=> 'أمريكا/تورنتو',
		'America/Tortola'		=> 'أمريكا/تورتولا',
		'America/Vancouver'		=> 'أمريكا/فانكوفر',
		'America/Whitehorse'	=> 'أمريكا/وايتهورس',
		'America/Winnipeg'		=> 'أمريكا/وينيبيج',
		'America/Yakutat'		=> 'أمريكا/ياكوتات',
		'America/Yellowknife'	=> 'أمريكا/يلونايف',

		'Antarctica/Casey'		=> 'أنتاركتيكا/كيسي',
		'Antarctica/Davis'		=> 'أنتاركتيكا/دافيس',
		'Antarctica/DumontDUrville'	=> 'أنتاركتيكا/دومون دورفيل',
		'Antarctica/Macquarie'	=> 'أنتاركتيكا/ماكواري',
		'Antarctica/Mawson'		=> 'أنتاركتيكا/موسن',
		'Antarctica/McMurdo'	=> 'أنتاركتيكا/ماك موردو',
		'Antarctica/Palmer'		=> 'أنتاركتيكا/بالمر',
		'Antarctica/Rothera'	=> 'أنتاركتيكا/روثيرا',
		'Antarctica/South_Pole'	=> 'أنتاركتيكا/القطب الجنوبي',
		'Antarctica/Syowa'		=> 'أنتاركتيكا/سيووا',
		'Antarctica/Vostok'		=> 'أنتاركتيكا/فوستوك',

		'Arctic/Longyearbyen'	=> 'القطب الشمالي/لونغياربين',

		'Asia/Aden'			=> 'آسيا/عدن',
		'Asia/Almaty'		=> 'آسيا/ألماتي',
		'Asia/Amman'		=> 'آسيا/عمّان',
		'Asia/Anadyr'		=> 'آسيا/أنادير',
		'Asia/Aqtau'		=> 'آسيا/أكتا',
		'Asia/Aqtobe'		=> 'آسيا/أكتوبي',
		'Asia/Ashgabat'		=> 'آسيا/عشق آباد',
		'Asia/Baghdad'		=> 'آسيا/بغداد',
		'Asia/Bahrain'		=> 'آسيا/البحرين',
		'Asia/Baku'			=> 'آسيا/باكو',
		'Asia/Bangkok'		=> 'آسيا/بانكوك',
		'Asia/Beirut'		=> 'آسيا/بيروت',
		'Asia/Bishkek'		=> 'آسيا/بيشكيك',
		'Asia/Brunei'		=> 'آسيا/بروناي',
		'Asia/Choibalsan'	=> 'آسيا/شويبالسان',
		'Asia/Chongqing'	=> 'آسيا/تشونغتشينغ',
		'Asia/Colombo'		=> 'آسيا/كولومبو',
		'Asia/Damascus'		=> 'آسيا/دمشق',
		'Asia/Dhaka'		=> 'آسيا/دكا',
		'Asia/Dili'			=> 'آسيا/ديلي',
		'Asia/Dubai'		=> 'آسيا/دبي',
		'Asia/Dushanbe'		=> 'آسيا/دوشنبه',
		'Asia/Gaza'			=> 'آسيا/غزة',
		'Asia/Harbin'		=> 'آسيا/هاربين',
		'Asia/Hebron'		=> 'آسيا/الخليل',
		'Asia/Ho_Chi_Minh'	=> 'آسيا/هو تشي منه',
		'Asia/Hong_Kong'	=> 'آسيا/هونج كونج',
		'Asia/Hovd'			=> 'آسيا/هوود',
		'Asia/Irkutsk'		=> 'آسيا/إركوتسك',
		'Asia/Jakarta'		=> 'آسيا/جاكارتا',
		'Asia/Jayapura'		=> 'آسيا/جايابورا',
		'Asia/Jerusalem'	=> 'آسيا/القدس',
		'Asia/Kabul'		=> 'آسيا/كابول',
		'Asia/Kamchatka'	=> 'آسيا/كامتشاتكا',
		'Asia/Karachi'		=> 'آسيا/كراتشي',
		'Asia/Kashgar'		=> 'آسيا/كاشغر',
		'Asia/Kathmandu'	=> 'آسيا/كاتماندو',
		'Asia/Khandyga'		=> 'آسيا/خانديجة',
		'Asia/Kolkata'		=> 'آسيا/كالكتة',
		'Asia/Krasnoyarsk'	=> 'آسيا/كراسنويارك',
		'Asia/Kuala_Lumpur'	=> 'آسيا/كوالا لامبور',
		'Asia/Kuching'		=> 'آسيا/كوتشينغ',
		'Asia/Kuwait'		=> 'آسيا/الكويت',
		'Asia/Macau'		=> 'آسيا/ماكاو',
		'Asia/Magadan'		=> 'آسيا/ماغادان',
		'Asia/Makassar'		=> 'آسيا/ماكاسار',
		'Asia/Manila'		=> 'آسيا/مانيلا',
		'Asia/Muscat'		=> 'آسيا/مسقط',
		'Asia/Nicosia'		=> 'آسيا/نيقوسيا',
		'Asia/Novokuznetsk'	=> 'آسيا/نوفوكوزنتسك',
		'Asia/Novosibirsk'	=> 'آسيا/نوفوسيبيرسك',
		'Asia/Omsk'			=> 'آسيا/أومسك',
		'Asia/Oral'			=> 'آسيا/أورال',
		'Asia/Phnom_Penh'	=> 'آسيا/بنوم بنه',
		'Asia/Pontianak'	=> 'آسيا/بونتياناك',
		'Asia/Pyongyang'	=> 'آسيا/بيونغ يانغ',
		'Asia/Qatar'		=> 'آسيا/قطر',
		'Asia/Qyzylorda'	=> 'آسيا/كيزيلوردا',
		'Asia/Rangoon'		=> 'آسيا/رانغون',
		'Asia/Riyadh'		=> 'آسيا/الرياض',
		'Asia/Sakhalin'		=> 'آسيا/سخالين',
		'Asia/Samarkand'	=> 'آسيا/سمرقند',
		'Asia/Seoul'		=> 'آسيا/سيول',
		'Asia/Shanghai'		=> 'آسيا/شانغهاي',
		'Asia/Singapore'	=> 'آسيا/سنغافورة',
		'Asia/Taipei'		=> 'آسيا/تايبي',
		'Asia/Tashkent'		=> 'آسيا/طشقند',
		'Asia/Tbilisi'		=> 'آسيا/تبليسي',
		'Asia/Tehran'		=> 'آسيا/طهران',
		'Asia/Thimphu'		=> 'آسيا/تيمفو',
		'Asia/Tokyo'		=> 'آسيا/طوكيو',
		'Asia/Ulaanbaatar'	=> 'آسيا/أولان باتور',
		'Asia/Urumqi'		=> 'آسيا/اورومتشي',
		'Asia/Ust-Nera'		=> 'آسيا/أوست-نيرا',
		'Asia/Vientiane'	=> 'آسيا/فينتيان',
		'Asia/Vladivostok'	=> 'آسيا/فلاديفوستوك',
		'Asia/Yakutsk'		=> 'آسيا/ياكوتسك',
		'Asia/Yekaterinburg'	=> 'آسيا/ايكاترينبرج',
		'Asia/Yerevan'		=> 'آسيا/يريفان',

		'Atlantic/Azores'		=> 'المحيط الأطلسي/جزر الأزور',
		'Atlantic/Bermuda'		=> 'المحيط الأطلسي/برمودا',
		'Atlantic/Canary'		=> 'المحيط الأطلسي/جزر الكناري',
		'Atlantic/Cape_Verde'	=> 'المحيط الأطلسي/الرأس الأخضر',
		'Atlantic/Faroe'		=> 'المحيط الأطلسي/فارو',
		'Atlantic/Madeira'		=> 'المحيط الأطلسي/ماديرا',
		'Atlantic/Reykjavik'	=> 'المحيط الأطلسي/ريكيافيك',
		'Atlantic/South_Georgia'	=> 'المحيط الأطلسي/جورجيا الجنوبية',
		'Atlantic/St_Helena'	=> 'المحيط الأطلسي/سانت هيلينا',
		'Atlantic/Stanley'		=> 'المحيط الأطلسي/ستانلي',

		'Australia/Adelaide'	=> 'أستراليا/أديليد',
		'Australia/Brisbane'	=> 'أستراليا/بريزبين',
		'Australia/Broken_Hill'	=> 'أستراليا/بروكن هيل',
		'Australia/Currie'		=> 'أستراليا/كاري',
		'Australia/Darwin'		=> 'أستراليا/داروين',
		'Australia/Eucla'		=> 'أستراليا/يوكلا',
		'Australia/Hobart'		=> 'أستراليا/هوبارت',
		'Australia/Lindeman'	=> 'أستراليا/ليندمان',
		'Australia/Lord_Howe'	=> 'أستراليا/لورد هاو',
		'Australia/Melbourne'	=> 'أستراليا/ملبورن',
		'Australia/Perth'		=> 'أستراليا/بيرث',
		'Australia/Sydney'		=> 'أستراليا/سيدني',

		'Europe/Amsterdam'	=> 'أوروبا/أمستردام',
		'Europe/Andorra'	=> 'أوروبا/أندورا',
		'Europe/Athens'		=> 'أوروبا/أثينا',
		'Europe/Belgrade'	=> 'أوروبا/بيلجراد',
		'Europe/Berlin'		=> 'أوروبا/برلين',
		'Europe/Bratislava'	=> 'أوروبا/براتيسلافا',
		'Europe/Brussels'	=> 'أوروبا/بروسيلس',
		'Europe/Bucharest'	=> 'أوروبا/بوخارست',
		'Europe/Budapest'	=> 'أوروبا/بودابست',
		'Europe/Busingen'	=> 'أوروبا/بوسينجن',
		'Europe/Chisinau'	=> 'أوروبا/كيشيناو',
		'Europe/Copenhagen'	=> 'أوروبا/كوبنهاجن',
		'Europe/Dublin'		=> 'أوروبا/دبلن',
		'Europe/Gibraltar'	=> 'أوروبا/جبل طارق',
		'Europe/Guernsey'	=> 'أوروبا/غيرنسي',
		'Europe/Helsinki'	=> 'أوروبا/هلسنكي',
		'Europe/Isle_of_Man'	=> 'أوروبا/آيل أوف مان',
		'Europe/Istanbul'	=> 'أوروبا/اسطنبول',
		'Europe/Jersey'		=> 'أوروبا/جيرسي',
		'Europe/Kaliningrad'	=> 'أوروبا/كالينينغراد',
		'Europe/Kiev'		=> 'أوروبا/كييف',
		'Europe/Lisbon'		=> 'أوروبا/لشبونة',
		'Europe/Ljubljana'	=> 'أوروبا/ليوبليانا',
		'Europe/London'		=> 'أوروبا/لندن',
		'Europe/Luxembourg'	=> 'أوروبا/لوكسمبورج',
		'Europe/Madrid'		=> 'أوروبا/مدريد',
		'Europe/Malta'		=> 'أوروبا/ملطا',
		'Europe/Mariehamn'	=> 'أوروبا/ماريهامن',
		'Europe/Minsk'		=> 'أوروبا/ميسنك',
		'Europe/Monaco'		=> 'أوروبا/موناكو',
		'Europe/Moscow'		=> 'أوروبا/موسكو',
		'Europe/Oslo'		=> 'أوروبا/أوسلو',
		'Europe/Paris'		=> 'أوروبا/باريس',
		'Europe/Podgorica'	=> 'أوروبا/بودغوريتشا',
		'Europe/Prague'		=> 'أوروبا/براغ',
		'Europe/Riga'		=> 'أوروبا/ريغا',
		'Europe/Rome'		=> 'أوروبا/روما',
		'Europe/Samara'		=> 'أوروبا/سمارا',
		'Europe/San_Marino'	=> 'أوروبا/سان مارينو',
		'Europe/Sarajevo'	=> 'أوروبا/سراييفو',
		'Europe/Simferopol'	=> 'أوروبا/سيمفيروبول',
		'Europe/Skopje'		=> 'أوروبا/سكوبي',
		'Europe/Sofia'		=> 'أوروبا/صوفيا',
		'Europe/Stockholm'	=> 'أوروبا/ستوكهولم',
		'Europe/Tallinn'	=> 'أوروبا/تالين',
		'Europe/Tirane'		=> 'أوروبا/تيرانا',
		'Europe/Uzhgorod'	=> 'أوروبا/أوزجورود',
		'Europe/Vaduz'		=> 'أوروبا/فادوز',
		'Europe/Vatican'	=> 'أوروبا/الفاتيكان',
		'Europe/Vienna'		=> 'أوروبا/فيينا',
		'Europe/Vilnius'	=> 'أوروبا/فيلنيوس',
		'Europe/Volgograd'	=> 'أوروبا/فولغوغراد',
		'Europe/Warsaw'		=> 'أوروبا/وارسو',
		'Europe/Zagreb'		=> 'أوروبا/زغرب',
		'Europe/Zaporozhye'	=> 'أوروبا/زابوروجي',
		'Europe/Zurich'		=> 'أوروبا/زيورخ',

		'Indian/Antananarivo'	=> 'المحيط الهندي/أنتاناناريفو',
		'Indian/Chagos'		=> 'المحيط الهندي/تشاغوس',
		'Indian/Christmas'	=> 'المحيط الهندي/كريسماس',
		'Indian/Cocos'		=> 'المحيط الهندي/كوكوس',
		'Indian/Comoro'		=> 'المحيط الهندي/جزر القمر',
		'Indian/Kerguelen'	=> 'المحيط الهندي/كيرغولن',
		'Indian/Mahe'		=> 'المحيط الهندي/ماهي',
		'Indian/Maldives'	=> 'المحيط الهندي/جزر المالديف',
		'Indian/Mauritius'	=> 'المحيط الهندي/موريشيوس',
		'Indian/Mayotte'	=> 'المحيط الهندي/مايوت',
		'Indian/Reunion'	=> 'المحيط الهندي/ريونيون',

		'Pacific/Apia'		=> 'المحيط الهادي/آبيا',
		'Pacific/Auckland'	=> 'المحيط الهادي/أوكلاند',
		'Pacific/Chatham'	=> 'المحيط الهادي/تشاتام',
		'Pacific/Chuuk'		=> 'المحيط الهادي/شوك',
		'Pacific/Easter'	=> 'المحيط الهادي/جزيرة الفصح',
		'Pacific/Efate'		=> 'المحيط الهادي/إيفات',
		'Pacific/Enderbury'	=> 'المحيط الهادي/اندربوري',
		'Pacific/Fakaofo'	=> 'المحيط الهادي/فاكاوفو',
		'Pacific/Fiji'		=> 'المحيط الهادي/فيجي',
		'Pacific/Funafuti'	=> 'المحيط الهادي/فونافوتي',
		'Pacific/Galapagos'	=> 'المحيط الهادي/غالاباغوس',
		'Pacific/Gambier'	=> 'المحيط الهادي/جامبير',
		'Pacific/Guadalcanal'	=> 'المحيط الهادي/القنال',
		'Pacific/Guam'		=> 'المحيط الهادي/غوام',
		'Pacific/Honolulu'	=> 'المحيط الهادي/هونولولو',
		'Pacific/Johnston'	=> 'المحيط الهادي/جونستون',
		'Pacific/Kiritimati'	=> 'المحيط الهادي/كيريتيماتي',
		'Pacific/Kosrae'	=> 'المحيط الهادي/كوسراي',
		'Pacific/Kwajalein'	=> 'المحيط الهادي/كواجالين',
		'Pacific/Majuro'	=> 'المحيط الهادي/ماجورو',
		'Pacific/Marquesas'	=> 'المحيط الهادي/الماركيز',
		'Pacific/Midway'	=> 'المحيط الهادي/ميدواي',
		'Pacific/Nauru'		=> 'المحيط الهادي/ناورو',
		'Pacific/Niue'		=> 'المحيط الهادي/نيوي',
		'Pacific/Norfolk'	=> 'المحيط الهادي/نورفولك',
		'Pacific/Noumea'	=> 'المحيط الهادي/نوميا',
		'Pacific/Pago_Pago'	=> 'المحيط الهادي/باجو باجو',
		'Pacific/Palau'		=> 'المحيط الهادي/بالاو',
		'Pacific/Pitcairn'	=> 'المحيط الهادي/بيتكيرن',
		'Pacific/Pohnpei'	=> 'المحيط الهادي/بوهنباي',
		'Pacific/Port_Moresby'	=> 'المحيط الهادي/ميناء مورسبي',
		'Pacific/Rarotonga'	=> 'المحيط الهادي/راروتونجا',
		'Pacific/Saipan'	=> 'المحيط الهادي/سايبان',
		'Pacific/Tahiti'	=> 'المحيط الهادي/تاهيتي',
		'Pacific/Tarawa'	=> 'المحيط الهادي/تاراوا',
		'Pacific/Tongatapu'	=> 'المحيط الهادي/تونغاتابو',
		'Pacific/Wake'		=> 'المحيط الهادي/ويك',
		'Pacific/Wallis'	=> 'المحيط الهادي/واليس',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'y/m/d H:i'			=> '1/01/2007 13:37',
		'|y/m/d H:i|'		=> '1/01/2007 13:37',
		'Y/n/j g:i a'		=> '1/1/2007 1:37 م',
		'|Y/n/j| g:i a'		=> '1/1/2007 1:37 م',
		'j F Y g:i a'		=> '1 يناير 2007 1:37م',
		'|j F Y| g:i a'		=> '1 يناير 2007 1:37 م',
		'l j F Y g:i a'		=> 'الإثنين 1 يناير 2007 1:37م',
		'|l j F Y| g:i a'	=> 'الإثنين 1 يناير 2007 1:37م',
		'D Y/n/j g:i a'		=> 'الإثنين 2007/1/1 1:37 م',
		'|D Y/n/j| g:i a'	=> 'الإثنين 2007/1/1 1:37 م',
		'D j-n-Y g:i a'		=> 'الإثنين 1-1-2007 1:37 م',
		'|D j-n-Y| g:i a'	=> 'الإثنين 1-1-2007 1:37 م',
		'D Y.n.j g:i a'		=> 'الإثنين 2007.1.1 1:37 م',
		'|D Y.n.j| g:i a'	=> 'الإثنين 2007.1.1 1:37 م',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'l j F Y g:i a',	// Monday 1 January 2007 1:37 pm

));
