<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
* Ελληνική μετάφραση από την ομάδα του phpbbgr.com
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'Με την πρόσβαση στο “%1$s” (εφεξής “εμείς”, “εμάς”, “δικό μας”, “%1$s”, “%2$s”), δέχεστε ότι δεσμεύεστε νομικά από τους όρους που ακολουθούν. Αν δεν δέχεστε ότι δεσμεύεστε νομικά από όλους τους ακόλουθους όρους τότε παρακαλούμε μη δημιουργήσετε κάποιον λογαριασμό και μη χρησιμοποιήσετε το “%1$s”. Είναι πιθανόν να μεταβάλλουμε τους όρους οποιαδήποτε χρονική στιγμή και θα επιδιώξουμε να σας ενημερώσουμε για αυτό με τον προσφορότερο δυνατό τρόπο, όμως θα ήταν συνετό εκ μέρους σας να ξαναδιαβάζετε τακτικά την παρούσα σελίδα καθώς η συνεχιζόμενη χρήση του “%1$s” μετά τις εκάστοτε αλλαγές δείχνει πως δέχεστε ότι δεσμεύεστε νομικά από αυτούς τους όρους με την ανανεωμένη και/ή τροποποιημένη μορφή των όρων.
	<br><br>
	Η ιστοσελίδα μας είναι βασισμένη στο λογισμικό phpBB (εφεξής “αυτοί”, “αυτών”, “αυτούς”, “λογισμικό phpBB”, “www.phpbb.com”, “phpBB Limited”, “phpBB Teams”) που είναι μια λύση συστήματος συζητήσεων που διατίθεται βάσει της “<a href="http://opensource.org/licenses/gpl-2.0.php">GNU General Public License v2</a>” (εφεξής “GPL”) και μπορεί να μεταφορτωθεί από τη σελίδα <a href="https://www.phpbb.com/">www.phpbb.com</a>. Η ομάδα του phpBB δεν μπορεί να ασκήσει την επιρροή στο περιεχόμενο και τους στόχους, τους οποίους ο χρήστης με αυτό το λογισμικό ακολουθεί λόγω των κανονισμών του GPL. Για περισσότερες πληροφορίες σχετικά με το phpBB, παρακαλούμε δείτε στο <a href="https://www.phpbb.com/">https://www.phpbb.com/</a>.
	<br><br>
	Δέχεστε να μη δημοσιεύετε οποιασδήποτε μορφής περιεχόμενο που είναι προσβλητικό, άσεμνο, χυδαίο, συκοφαντικό, περιέχον μίσος ή απειλή, σεξουαλικά προσανατολισμένο ή οτιδήποτε άλλο που πιθανόν να παραβιάζει νόμους είτε της χώρας σας, είτε της χώρας στην οποία φιλοξενείται το “%1$s”, είτε το Διεθνές Δίκαιο. Η δημοσίευση τέτοιου περιεχομένου είναι δυνατόν να οδηγήσει στην άμεση και μόνιμη διαγραφή σας, με ταυτόχρονη ενημέρωση της Υπηρεσίας Παροχής Υπηρεσιών Διαδικτύου που χρησιμοποιείτε εφόσον κρίνουμε απαραίτητο. Η διεύθυνση IP κάθε δημοσίευσης καταγράφεται για τη δυνατότητα επιβολής των παρόντων όρων. Δέχεστε ότι το “%1$s” έχει το δικαίωμα να απομακρύνει, να επεξεργαστεί, να μετακινήσει ή να κλείσει ένα θέμα συζήτησης οποιαδήποτε χρονική στιγμή επιλέξει. Σαν μέλος δέχεστε ότι οποιεσδήποτε πληροφορίες έχετε εισάγει αποθηκεύονται σε μια βάση δεδομένων. Αν και αυτές οι πληροφορίες δεν θα αποκαλυφθούν σε οποιονδήποτε τρίτο χωρίς τη συναίνεσή σας, ούτε το “%1$s” ούτε το phpBB θα θεωρηθούν υπεύθυνοι για οποιαδήποτε απόπειρα ηλεκτρονικής εισβολής ή παραβίασης η οποία είναι δυνατόν να οδηγήσει σε απώλεια αυτών των δεδομένων.
	',

	'PRIVACY_POLICY'		=> 'Αυτή η πολιτική εξηγεί λεπτομερώς πώς το “%1$s” και οι εταιρείες που συνδέονται στενά με αυτό (εφεξής “εμείς”, “εμάς”, “δικό μας”, “%1$s”, “%2$s”) και το phpBB (εφεξής “αυτοί”, “αυτών”, “αυτούς”, “λογισμικό phpBB”, “www.phpbb.com”, “phpBB Limited”, “phpBB Teams”) χρησιμοποιούν οποιεσδήποτε πληροφορίες που συλλέγονται κατά τη διάρκεια κάθε συνεδρίας χρήσης από εσάς (εφεξής “οι πληροφορίες σας”).
	<br><br>
	Οι πληροφορίες σας συλλέγονται με δύο τρόπους. Πρώτον, η περιήγηση στο “%1$s” οδηγεί το λογισμικό phpBB να δημιουργήσει ορισμένα cookies, τα οποία είναι μικρά αρχεία κειμένου τα οποία αποθηκεύονται στα προσωρινά αρχεία του πλοηγού του υπολογιστή σας. Τα πρώτα δύο cookies περιέχουν μόνον ένα προσδιοριστικό μέλους (εφεξής “user-id”) και ένα προσδιοριστικό ανώνυμης συνεδρίας (εφεξής “session-id”), που σας εκχωρούνται αυτόματα από το λογισμικό phpBB. Ένα τρίτο cookie θα δημιουργηθεί μόλις έχετε πλοηγηθεί σε θέματα μέσα στο “%1$s” και χρησιμοποιείται για να καταγράφεται ποια θέματα έχουν αναγνωσθεί, βελτιώνοντας έτσι την εμπειρία σας ως μέλος.
	<br><br>
	Είναι πιθανόν επίσης να δημιουργήσουμε cookies εκτός του λογισμικού phpBB κατά την πλοήγησή σας στο “%1$s”, αν και αυτά είναι έξω από το πεδίο αυτού του εγγράφου, το οποίο καλύπτει μόνο τις σελίδες που δημιουργούνται από το λογισμικό phpBB. Ο δεύτερος τρόπος με τον οποίο συλλέγουμε τις πληροφορίες σας είναι με βάση το υλικό που μας υποβάλετε. Αυτό μπορεί να περιλαμβάνει και να μην περιορίζεται σε: δημοσιεύσεις σαν ανώνυμο μέλος (εφεξής “ανώνυμες δημοσιεύσεις”), εγγραφή στο “%1$s” (εφεξής “ο λογαριασμός σας”) και δημοσιεύσεις που υποβάλετε μετά την εγγραφή και ενώ είστε συνδεδεμένος (εφεξής “οι δημοσιεύσεις σας”).
	<br><br>
	Ο λογαριασμός σας θα περιλαμβάνει ως ελάχιστα στοιχεία ένα μοναδικά αναγνωρίσιμο όνομα (εφεξής “το όνομα μέλους”), ένα προσωπικό μυστικό κωδικό που χρησιμοποιείται για τη σύνδεση με τον λογαριασμό σας (εφεξής “ο κωδικός σας”) και μια προσωπική, έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου (εφεξής “το ηλεκτρονικό ταχυδρομείο σας”). Οι πληροφορίες σας σχετικά με το λογαριασμό σας στο “%1$s” προστατεύονται από τους νόμους περί προστασίας δεδομένων που ισχύουν στη χώρα που μας φιλοξενεί. Οποιεσδήποτε πληροφορίες επιπλέον του ονόματος μέλους, του κωδικού και του ηλεκτρονικού ταχυδρομείου σας που απαιτούνται από το “%1$s” κατά τη διάρκεια της διαδικασίας εγγραφής είναι στην παρέκκλισή μας ως προς το τι είναι υποχρεωτικό και τι προαιρετικό. Σε κάθε περίπτωση, μπορείτε να επιλέξετε ποιες πληροφορίες στον λογαριασμό σας εκτίθενται δημόσια. Επιπλέον, στο λογαριασμό σας έχετε τη δυνατότητα να επιλέξετε αν θα λαμβάνετε ή όχι ηλεκτρονικά μηνύματα που δημιουργούνται αυτόματα από το λογισμικό phpBB.
	<br><br>
	Ο κωδικός σας κρυπτογραφείται έτσι ώστε να είναι ασφαλής. Όμως συνιστάται να μη χρησιμοποιείτε τον ίδιο κωδικό σε πολλές διαφορετικές ιστοσελίδες. Ο κωδικός σας είναι το μέσο που έχετε για την πρόσβαση στο λογαριασμό σας στο “%1$s”, έτσι παρακαλούμε να τον φυλάσσετε προσεκτικά και σε καμία περίπτωση δεν πρόκειται οποιοσδήποτε που συνδέεται με το “%1$s”, το phpBB ή άλλο τρίτο μέρος να σας ζητήσει νόμιμα να αποκαλύψετε τον κωδικό σας. Εάν ξεχάσετε τον κωδικό για τον λογαριασμό σας, μπορείτε να χρησιμοποιήσετε τη λειτουργία “Ξέχασα τον κωδικό μου” που παρέχεται από το λογισμικό phpBB. Αυτή η διαδικασία θα σας ζητήσει να υποβάλετε το όνομα μέλους και το ηλεκτρονικό ταχυδρομείο σας. Στη συνέχεια το λογισμικό phpBB θα δημιουργήσει έναν νέο κωδικό για να συνδεθείτε με το λογαριασμό σας.
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'				=> 'Ο λογαριασμός σας ενεργοποιήθηκε. Ευχαριστούμε για την εγγραφή σας.',
	'ACCOUNT_ACTIVE_ADMIN'			=> 'Ο λογαριασμός ενεργοποιήθηκε.',
	'ACCOUNT_ACTIVE_PROFILE'		=> 'Ο λογαριασμός σας επανενεργοποιήθηκε με επιτυχία.',
	'ACCOUNT_ADDED'					=> 'Ευχαριστούμε για την εγγραφή σας, ο λογαριασμός σας δημιουργήθηκε.',
	'ACCOUNT_COPPA'					=> 'Ο λογαριασμός σας ενεργοποιήθηκε αλλά απαιτείται έγκριση κάποιου διαχειριστή, παρακαλούμε ελέγξτε την ηλεκτρονική σας αλληλογραφία για περαιτέρω λεπτομέρειες.',
	'ACCOUNT_EMAIL_CHANGED'			=> 'Ο λογαριασμός σας ενημερώθηκε. Αυτό το σύστημα συζητήσεων όμως απαιτεί επανενεργοποίηση μετά από αλλαγή της διεύθυνσης ηλεκτρονικής αλληλογραφίας σας. Ένας δεσμός (κλειδί) ενεργοποίησης έχει σταλεί στη νέα διεύθυνση ηλεκτρονικής αλληλογραφίας σας που υποβάλλατε. Παρακαλούμε ελέγξτε την ηλεκτρονική αλληλογραφία σας για περαιτέρω πληροφορίες.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'	=> 'Ο λογαριασμός σας ενημερώθηκε. Αυτό το σύστημα συζητήσεων όμως απαιτεί επανενεργοποίηση του από κάποιον διαχειριστή μετά από αλλαγή της διεύθυνσης ηλεκτρονικού ταχυδρομείου. Ένα μήνυμα ηλεκτρονικού ταχυδρομείου έχει σταλεί σε αυτούς και θα ενημερωθείτε όταν ενεργοποιηθεί ο λογαριασμός σας.',
	'ACCOUNT_INACTIVE'				=> 'Ο λογαριασμός σας δημιουργήθηκε. Αυτό το σύστημα συζητήσεων όμως απαιτεί να τον ενεργοποιήσετε. Ένας κωδικός ενεργοποίησης στάλθηκε στη διεύθυνση ηλεκτρονικού ταχυδρομείου που υποβάλλατε. Παρακαλούμε ελέγξτε την ηλεκτρονική αλληλογραφία σας για περαιτέρω πληροφορίες, επίσης βεβαιωθείτε ότι ελέγξατε το φάκελο ανεπιθύμητης αλληλογραφίας. Για να λάβετε το μήνυμα ενεργοποίησης μπορεί να διαρκέσει λίγο, ανάλογα με τον πάροχο αλληλογραφίας που χρησιμοποιείτε.',
	'ACCOUNT_INACTIVE_ADMIN'		=> 'Ο λογαριασμός σας δημιουργήθηκε. Αυτό το σύστημα συζητήσεων όμως απαιτεί να ενεργοποιηθεί ο λογαριασμός σας από κάποιον διαχειριστή. Ένα μήνυμα ηλεκτρονικού ταχυδρομείου έχει σταλεί σε αυτούς, και θα ενημερωθείτε όταν ενεργοποιηθεί ο λογαριασμός σας.',
	'ACTIVATION_EMAIL_SENT'			=> 'Το μήνυμα ηλεκτρονικής αλληλογραφίας στάλθηκε στη διεύθυνση ηλεκτρονικής αλληλογραφίας σας.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'Το μήνυμα ηλεκτρονικής αλληλογραφίας στάλθηκε στη διεύθυνση ηλεκτρονικής αλληλογραφίας του διαχειριστή.',
	'ADD'							=> 'Προσθήκη',
	'ADD_BCC'						=> 'Κοινοποίηση [BCC]',
	'ADD_FOES'						=> 'Προσθήκη νέων εχθρών',
	'ADD_FOES_EXPLAIN'				=> 'Μπορείτε να εισάγετε πάνω από ένα ονόματα μελών, το καθένα σε διαφορετική γραμμή.',
	'ADD_FOLDER'					=> 'Προσθήκη φακέλου',
	'ADD_FRIENDS'					=> 'Προσθήκη νέων φίλων',
	'ADD_FRIENDS_EXPLAIN'			=> 'Μπορείτε να εισάγετε πάνω από ένα ονόματα μελών, το καθένα σε διαφορετική γραμμή.',
	'ADD_NEW_RULE'					=> 'Προσθήκη νέου κανόνα',
	'ADD_RULE'						=> 'Προσθήκη κανόνα',
	'ADD_TO'						=> 'Προσθήκη [Προς]',
	'ADD_USERS_UCP_EXPLAIN'			=> 'Εδώ μπορείτε να προσθέσετε νέα μέλη στην ομάδα. Μπορείτε να επιλέξετε εάν αυτή η ομάδα γίνει η νέα προεπιλεγμένη για τα επιλεγμένα μέλη. Παρακαλώ εισάγετε κάθε όνομα μέλους σε μια διαφορετική γραμμή.',
	'ADMIN_EMAIL'					=> 'Οι Διαχειριστές μπορούν να μου στείλουν μήνυμα ηλεκτρονικού ταχυδρομείου',
	'AGREE'							=> 'Συμφωνώ με αυτούς τους όρους',
	'ALLOW_PM'						=> 'Επιτρέψτε στα μέλη να σας στέλνουν προσωπικά μηνύματα',
	'ALLOW_PM_EXPLAIN'				=> 'Σημειώστε ότι οι διαχειριστές και οι συντονιστές θα είναι πάντα σε θέση να σας στέλνουν μηνύματα.',
	'ALREADY_ACTIVATED'				=> 'Έχετε ήδη ενεργοποιήσει τον λογαριασμό σας.',
	'ATTACHMENTS_EXPLAIN'			=> 'Αυτή είναι μια λίστα των συνημμένων που έχετε δημοσιεύσει σε αυτή τη Δ. Συζήτηση.',
	'ATTACHMENTS_DELETED'			=> 'Τα συνημμένα διαγράφηκαν με επιτυχία.',
	'ATTACHMENT_DELETED'			=> 'Το συνημμένο διαγράφηκε με επιτυχία.',
	'ATTACHMENT_LOCKED'				=> 'Αυτό το θέμα είναι κλειδωμένο, δε μπορείτε να διαγράψετε το συνημμένο.',
	'AUTOLOGIN_SESSION_KEYS_DELETED'=> 'Τα επιλεγμένα κλειδιά σύνδεσης “Να με θυμάσαι” διαγράφηκαν με επιτυχία.',
	'AVATAR_CATEGORY'				=> 'Κατηγορία',
	'AVATAR_DRIVER_GRAVATAR_TITLE'	=> 'Gravatar',
	'AVATAR_DRIVER_GRAVATAR_EXPLAIN'=> 'Το Gravatar είναι μια υπηρεσία που σας επιτρέπει να χρησιμοποιήσετε το ίδιο άβαταρ σε πολλαπλές ιστοσελίδες. Επισκεφτείτε <a href="http://www.gravatar.com/">Gravatar</a> για περισσότερες πληροφορίες.',
	'AVATAR_DRIVER_LOCAL_TITLE'		=> 'Γκαλερί άβαταρ',
	'AVATAR_DRIVER_LOCAL_EXPLAIN'	=> 'Μπορείτε να επιλέξετε το άβατάρ σας από ένα τοπικά σύνολο διαθέσιμων άβαταρ.',
	'AVATAR_DRIVER_REMOTE_TITLE'	=> 'Φόρτωση από δεσμό',
	'AVATAR_DRIVER_REMOTE_EXPLAIN'	=> 'Σύνδεσμος της εικόνας άβαταρ από άλλη ιστοσελίδα.',
	'AVATAR_DRIVER_UPLOAD_TITLE'	=> 'Φόρτωση άβαταρ',
	'AVATAR_DRIVER_UPLOAD_EXPLAIN'	=> 'Φορτώστε το δικό σας άβαταρ.',
	'AVATAR_EXPLAIN'				=> 'Μέγιστες διαστάσεις: πλάτος: %1$s, ύψος: %2$s, μέγεθος αρχείου: %3$.2f KiB.',
	'AVATAR_EXPLAIN_NO_FILESIZE'	=> 'Μέγιστες διαστάσεις: πλάτος: %1$s, ύψος: %2$s.',
	'AVATAR_FEATURES_DISABLED'		=> 'Η χρήση άβαταρ είναι προσωρινά απενεργοποιημένη.',
	'AVATAR_GALLERY'				=> 'Τοπική γκαλερί',
	'AVATAR_GENERAL_UPLOAD_ERROR'	=> 'Ανεπιτυχής φόρτωση άβαταρ στο %s.',
	'AVATAR_NOT_ALLOWED'			=> 'Το άβατάρ σας δεν μπορεί να εμφανιστεί επειδή τα άβαταρ έχουν απαγορευθεί.',
	'AVATAR_PAGE'					=> 'Σελίδα',
	'AVATAR_SELECT'					=> 'Επιλέξτε το άβατάρ σας',
	'AVATAR_TYPE'					=> 'Τύπος άβαταρ',
	'AVATAR_TYPE_NOT_ALLOWED'		=> 'Το τρέχον άβατάρ σας δεν μπορεί να εμφανιστεί επειδή ο τύπος έχει απαγορευθεί.',

	'BACK_TO_DRAFTS'			=> 'Επιστροφή στα αποθηκευμένα πρόχειρα',
	'BACK_TO_LOGIN'				=> 'Επιστροφή στη σελίδα εισόδου',
	'BIRTHDAY'					=> 'Γενέθλια',
	'BIRTHDAY_EXPLAIN'			=> 'Εισάγοντας το έτος γεννήσεώς σας θα εμφανίζεται και η ηλικία σας την ημέρα γενεθλίων σας.',
	'BOARD_DATE_FORMAT'			=> 'Μορφή ημερομηνίας μου',
	'BOARD_DATE_FORMAT_EXPLAIN'	=> 'Η σύνταξη χρησιμοποιεί ίδια μορφή με τις <a href="https://www.php.net/manual/datetime.format.php">συναρτήσεις ημερομηνίας</a> της PHP.',
	'BOARD_LANGUAGE'			=> 'Γλώσσα επικοινωνίας μου',
	'BOARD_STYLE'				=> 'Το στυλ μου',
	'BOARD_TIMEZONE'			=> 'Η ωρολογιακή ζώνη μου',
	'BOOKMARKS'					=> 'Σελιδοδείκτες',
	'BOOKMARKS_EXPLAIN'			=> 'Μπορείτε να βάλετε σελιδοδείκτες σε θέματα για μελλοντική χρήση. Επιλέξτε το πλαίσιο επιλογής για όποιο σελιδοδείκτη επιθυμείτε να διαγράψετε, μετά πατήστε το κουμπί <em>Αφαίρεση σημειωμένων σελιδοδεικτών</em>.',
	'BOOKMARKS_DISABLED'		=> 'Οι σελιδοδείκτες είναι απενεργοποιημένοι σε αυτό το σύστημα συζητήσεων.',
	'BOOKMARKS_REMOVED'			=> 'Οι σελιδοδείκτες αφαιρέθηκαν με επιτυχία.',

	'CANNOT_EDIT_MESSAGE_TIME'	=> 'Δεν μπορείτε πλέον να επεξεργαστείτε ή να διαγράψετε αυτό το μήνυμα.',
	'CANNOT_MOVE_TO_SAME_FOLDER'=> 'Τα μηνύματα δεν μπορούν να μετακινηθούν στον φάκελο που επιθυμείτε να διαγράψετε.',
	'CANNOT_MOVE_FROM_SPECIAL'	=> 'Τα μηνύματα δεν μπορούν να μετακινηθούν από τα εξερχόμενα.',
	'CANNOT_RENAME_FOLDER'		=> 'Αυτός ο φάκελος δεν μπορεί να μετονομαστεί.',
	'CANNOT_REMOVE_FOLDER'		=> 'Αυτός ο φάκελος δεν μπορεί να διαγραφεί.',
	'CHANGE_DEFAULT_GROUP'		=> 'Αλλαγή προεπιλεγμένης ομάδας',
	'CHANGE_PASSWORD'			=> 'Αλλαγή κωδικού πρόσβασης',
	'CLICK_GOTO_FOLDER'			=> '%1$sΜετάβαση στον δικό “%3$s” φάκελο σας%2$s',
	'CLICK_RETURN_FOLDER'		=> '%1$sΕπιστροφή στον “%3$s” φάκελο σας%2$s',
	'CONFIRMATION'				=> 'Επιβεβαίωση εγγραφής',
	'CONFIRM_CHANGES'			=> 'Επιβεβαίωση αποθήκευσης αλλαγών',
	'CONFIRM_EXPLAIN'			=> 'Για την αποτροπή αυτόματων εγγραφών το σύστημα συζητήσεων απαιτεί από εσάς να εισάγετε ένα κωδικό επιβεβαίωσης. Ο κώδικας εμφανίζεται στην εικόνα που θα πρέπει να βλέπετε παρακάτω. Αν είστε άτομο με προβλήματα όρασης ή δεν μπορείτε να διαβάσετε αυτό τον κώδικα, παρακαλώ επικοινωνήστε με τον %sΔιαχειριστή αυτής της Δ. Συζήτησης%s.',
	'VC_REFRESH'				=> 'Ανανέωση εικόνας κωδικού επιβεβαίωσης',
	'VC_REFRESH_EXPLAIN'		=> 'Εάν δεν μπορείτε να διαβάσετε τον κώδικα, μπορείτε να ζητήσετε ένα νέο με το πάτημα του κουμπιού.',

	'CONFIRM_PASSWORD'			=> 'Επιβεβαίωση κωδικού πρόσβασης',
	'CONFIRM_PASSWORD_EXPLAIN'	=> 'Χρειάζεται να επιβεβαιώσετε πάλι τον κωδικό πρόσβασής σας μόνον εάν τον αλλάξατε παραπάνω.',
	'COPPA_BIRTHDAY'			=> 'Για να προχωρήσετε με την εγγραφή παρακαλούμε συμπληρώστε πότε γεννηθήκατε.',
	'COPPA_COMPLIANCE'			=> 'Συγκατάθεση COPPA',
	'COPPA_EXPLAIN'				=> 'Παρακαλώ σημειώστε ότι πατώντας υποβολή θα δημιουργηθεί ο λογαριασμός σας. Ωστόσο, δεν μπορεί να ενεργοποιηθεί μέχρι ο γονέας ή κηδεμόνας να εγκρίνει την εγγραφή σας. Θα σας αποσταλεί μέσω ηλεκτρονικού ταχυδρομείου ένα αντίγραφο από την απαραίτητη φόρμα με τα στοιχεία για το πού να την αποστείλετε.',
	'CREATE_FOLDER'				=> 'Προσθήκη φακέλου…',
	'CURRENT_IMAGE'				=> 'Τρέχουσα εικόνα',
	'CURRENT_PASSWORD'			=> 'Τρέχων κωδικός πρόσβασης',
	'CURRENT_PASSWORD_EXPLAIN'	=> 'Για να αλλάξετε τον κωδικό πρόσβασής σας, τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας, ή το όνομα μέλους, θα πρέπει να εισάγετε τον τρέχοντα κωδικό πρόσβασής σας.',
	'CURRENT_CHANGE_PASSWORD_EXPLAIN' => 'Για να αλλάξετε τον κωδικό, τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας, ή το όνομα μέλους, πρέπει να αλλάξετε τον τρέχοντα κωδικό.',
	'CUR_PASSWORD_EMPTY'		=> 'Δεν έχετε εισάγει τον τρέχοντα κωδικό πρόσβασης.',
	'CUR_PASSWORD_ERROR'		=> 'Ο τρέχων κωδικός πρόσβασης που εισάγατε δεν είναι σωστός.',
	'CUSTOM_DATEFORMAT'			=> 'Προσαρμοσμένη…',

	'DEFAULT_ACTION'			=> 'Προεπιλεγμένη ενέργεια',
	'DEFAULT_ACTION_EXPLAIN'	=> 'Αυτή η ενέργεια θα εφαρμοστεί εάν κανένα από τα παραπάνω δεν εφαρμόζεται.',
	'DEFAULT_ADD_SIG'			=> 'Επισύναψη υπογραφής μου ως προεπιλογή',
	'DEFAULT_BBCODE'			=> 'Ενεργοποίηση BBCode ως προεπιλογή',
	'DEFAULT_NOTIFY'			=> 'Να ενημερώνομαι μετά από απαντήσεις ως προεπιλογή',
	'DEFAULT_SMILIES'			=> 'Ενεργοποίηση εικονιδίων smilies ως προεπιλογή',
	'DEFINED_RULES'				=> 'Καθορισμένοι κανόνες',
	'DELETED_TOPIC'				=> 'Το θέμα αφαιρέθηκε.',
	'DELETE_ATTACHMENT'			=> 'Διαγραφή συνημμένου',
	'DELETE_ATTACHMENTS'		=> 'Διαγραφή συνημμένων',
	'DELETE_ATTACHMENT_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε αυτό το συνημμένο;',
	'DELETE_ATTACHMENTS_CONFIRM'=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε αυτά τα συνημμένα;',
	'DELETE_AVATAR'				=> 'Διαγραφή εικόνας',
	'DELETE_COOKIES_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε όλα τα cookies από αυτό το σύστημα συζητήσεων;',
	'DELETE_MARKED_PM'			=> 'Διαγραφή επιλεγμένων μηνυμάτων',
	'DELETE_MARKED_PM_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε όλα τα επιλεγμένα μηνύματα;',
	'DELETE_OLDEST_MESSAGES'	=> 'Διαγραφή παλαιότερων μηνυμάτων',
	'DELETE_MESSAGE'			=> 'Διαγραφή μηνύματος',
	'DELETE_MESSAGE_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε αυτό το προσωπικό μήνυμα;',
	'DELETE_MESSAGES_IN_FOLDER'	=> 'Διαγραφή όλων των μηνυμάτων μέσα στον αφαιρούμενο φάκελο',
	'DELETE_RULE'				=> 'Διαγραφή κανόνα',
	'DELETE_RULE_CONFIRM'		=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε αυτό τον κανόνα;',
	'DEMOTE_SELECTED'			=> 'Υποβιβασμός επιλεγμένων',
	'DISABLE_CENSORS'			=> 'Ενεργοποίηση λογοκρισίας λέξεων',
	'DISPLAY_GALLERY'			=> 'Εμφάνιση γκαλερί',
	'DOWNLOADS'					=> 'Μεταφορτώσεις',
	'DRAFTS_DELETED'			=> 'Όλα τα επιλεγμένα πρόχειρα μηνύματα διαγράφηκαν με επιτυχία.',
	'DRAFTS_EXPLAIN'			=> 'Εδώ μπορείτε να δείτε, να επεξεργαστείτε και να διαγράψετε τα αποθηκευμένα σας πρόχειρα μηνύματα.',
	'DRAFT_UPDATED'				=> 'Τα πρόχειρα μηνύματα ενημερώθηκαν με επιτυχία.',

	'EDIT_DRAFT_EXPLAIN'		=> 'Εδώ μπορείτε να επεξεργαστείτε τα πρόχειρα σας. Τα πρόχειρα δεν περιλαμβάνουν συνημμένα ή πληροφορίες ψηφοφοριών.',
	'EMAIL_BANNED_EMAIL'		=> 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που εισάγατε δεν επιτρέπεται να χρησιμοποιηθεί.',
	'EMAIL_REMIND'				=> 'Αυτή πρέπει να είναι η διεύθυνση ηλεκτρονικού ταχυδρομείου που σχετίζεται με τον λογαριασμό σας. Εάν δεν την έχετε αλλάξει μέσω του Πίνακα Ελέγχου Μέλους τότε αυτή είναι η διεύθυνση ηλεκτρονικού ταχυδρομείου που καταχωρήσατε με τον λογαριασμό σας',
	'EMAIL_TAKEN_EMAIL'			=> 'Η εισαχθείσα διεύθυνση ηλεκτρονικού ταχυδρομείου χρησιμοποιείται ήδη.',
	'EMPTY_DRAFT'				=> 'Πρέπει να εισάγετε κάποιο μήνυμα για να αποθηκευτούν οι αλλαγές.',
	'EMPTY_DRAFT_TITLE'			=> 'Πρέπει να εισάγετε τίτλο προχείρου.',
	'EXPORT_AS_XML'				=> 'Εξαγωγή ως XML',
	'EXPORT_AS_CSV'				=> 'Εξαγωγή ως CSV',
	'EXPORT_AS_CSV_EXCEL'		=> 'Εξαγωγή ως CSV (Excel)',
	'EXPORT_AS_TXT'				=> 'Εξαγωγή ως TXT',
	'EXPORT_AS_MSG'				=> 'Εξαγωγή ως MSG',
	'EXPORT_FOLDER'				=> 'Εξαγωγή αυτής της προβολής',

	'FIELD_REQUIRED'					=> 'Το πεδίο “%s” πρέπει να συμπληρωθεί.',
	'FIELD_TOO_SHORT'					=> array(
		1	=> 'Το πεδίο “%2$s” είναι πολύ μικρό, ελάχιστος αριθμός %1$d χαρακτήρα απαιτείται.',
		2	=> 'Το πεδίο “%2$s” είναι πολύ μικρό, ελάχιστος αριθμός %1$d χαρακτήρων απαιτείται.',
	),
	'FIELD_TOO_LONG'					=> array(
		1	=> 'Το πεδίο “%2$s” είναι πολύ μεγάλο, μέγιστος αριθμός %1$d χαρακτήρα επιτρέπεται.',
		2	=> 'Το πεδίο “%2$s” είναι πολύ μεγάλο, μέγιστος αριθμός %1$d χαρακτήρων επιτρέπεται.',
	),
	'FIELD_TOO_SMALL'					=> 'Η τιμή του πεδίου “%2$s” είναι πολύ μικρή, μια ελάχιστη τιμή %1$d επιτρέπεται.',
	'FIELD_TOO_LARGE'					=> 'Η τιμή του πεδίου “%2$s” είναι πολύ μεγάλη, μια μέγιστη τιμή %1$d επιτρέπεται.',
	'FIELD_INVALID_CHARS_INVALID'		=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο αριθμητικοί χαρακτήρες.',
	'FIELD_INVALID_CHARS_ALPHA_DOTS'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο αλφαριθμητικοί ή . χαρακτήρες.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο αλφαριθμητικοί χαρακτήρες.',
	'FIELD_INVALID_CHARS_ALPHA_PUNCTUATION'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο αλφαριθμητικοί ή _ , - . χαρακτήρες και ο πρώτος χαρακτήρας πρέπει να είναι αλφαβητικός.',
	'FIELD_INVALID_CHARS_ALPHA_SPACERS'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, μόνο αλφαριθμητικοί, πλήκτρο διαστήματος ή - + _ [ ] χαρακτήρες επιτρέπονται.',
	'FIELD_INVALID_CHARS_ALPHA_UNDERSCORE'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο αλφαριθμητικοί ή _ χαρακτήρες.',
	'FIELD_INVALID_CHARS_LETTER_NUM_DOTS'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο γράμματα, αριθμητικοί ή . χαρακτήρες.',
	'FIELD_INVALID_CHARS_LETTER_NUM_ONLY'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο γράμματα και αριθμητικοί χαρακτήρες.',
	'FIELD_INVALID_CHARS_LETTER_NUM_PUNCTUATION'	=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο γράμματα, αριθμητικοί ή _ , - . χαρακτήρες και ο πρώτος χαρακτήρας πρέπει να είναι αλφαβητικός.',
	'FIELD_INVALID_CHARS_LETTER_NUM_SPACERS'		=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνο γράμματα, αριθμητικοί, πλήκτρο διαστήματος ή - + _ [ ] χαρακτήρες.',
	'FIELD_INVALID_CHARS_LETTER_NUM_UNDERSCORE'		=> 'Το πεδίο “%s” περιέχει μη επιτρεπτούς χαρακτήρες, επιτρέπονται μόνον γράμματα, αριθμητικοί ή _ χαρακτήρες.',
	'FIELD_INVALID_DATE'				=> 'Το πεδίο “%s” περιέχει μια άκυρη ημερομηνία.',
	'FIELD_INVALID_URL'					=> 'Το πεδίο “%s” περιέχει μη επιτρεπτό σύνδεσμο.',
	'FIELD_INVALID_VALUE'				=> 'Το πεδίο “%s” περιέχει μια άκυρη τιμή.',

	'FOE_MESSAGE'				=> 'Μήνυμα από εχθρό',
	'FOES_EXPLAIN'				=> 'Οι εχθροί είναι μέλη τα οποία αγνοούνται από προεπιλογή. Δημοσιεύσεις από αυτά τα μέλη δεν θα είναι εξ ολοκλήρου ορατές. Τα προσωπικά μηνύματα από εχθρούς εξακολουθούν να επιτρέπονται. Σημειώστε ότι δεν μπορείτε να αγνοήσετε συντονιστές ή διαχειριστές.',
	'FOES_UPDATED'				=> 'Η λίστα εχθρών σας ενημερώθηκε με επιτυχία.',
	'FOLDER_ADDED'				=> 'Ο φάκελος προστέθηκε με επιτυχία.',
	'FOLDER_MESSAGE_STATUS'		=> array(
		1	=> '%2$d από το %1$s μήνυμα αποθηκεύτηκε',
		2	=> '%2$d από τα %1$s μηνύματα αποθηκεύτηκαν',
	),
	'FOLDER_NAME_EMPTY'			=> 'Πρέπει να εισάγετε ένα όνομα για αυτό τον φάκελο.',
	'FOLDER_NAME_EXIST'			=> 'Ο φάκελος <strong>%s</strong> υπάρχει ήδη.',
	'FOLDER_OPTIONS'			=> 'Επιλογές φακέλων',
	'FOLDER_RENAMED'			=> 'Ο φάκελος μετονομάστηκε με επιτυχία.',
	'FOLDER_REMOVED'			=> 'Ο φάκελος διαγράφηκε με επιτυχία.',
	'FOLDER_STATUS_MSG'			=> array(
		1	=> 'Ο φάκελος είναι %3$d%% πλήρης (%2$d από το %1$s μήνυμα αποθηκεύτηκε)',
		2	=> 'Ο φάκελος είναι %3$d%% πλήρης (%2$d από τα %1$s μηνύματα αποθηκεύτηκαν)',
	),
	'FORWARD_PM'				=> 'Προώθηση ΠΜ',
	'FORCE_PASSWORD_EXPLAIN'	=> 'Προκειμένου να μπορέσετε να συνεχίσετε την περιήγηση στο σύστημα συζητήσεων, σας ζητείται να αλλάξετε τον κωδικό πρόσβασής σας.',
	'FRIEND_MESSAGE'			=> 'Μήνυμα από φίλο',
	'FRIENDS'					=> 'Φίλοι',
	'FRIENDS_EXPLAIN'			=> 'Οι φίλοι σας επιτρέπουν γρήγορη πρόσβαση σε μέλη με τα οποία επικοινωνείτε συχνά. Εάν το πρότυπο έχει την κατάλληλη υποστήριξη οποιεσδήποτε δημοσιεύσεις έγιναν από έναν φίλο μπορεί να επισημαίνονται.',
	'FRIENDS_OFFLINE'			=> 'Χωρίς σύνδεση',
	'FRIENDS_ONLINE'			=> 'Σε σύνδεση',
	'FRIENDS_UPDATED'			=> 'Η λίστα φίλων σας ενημερώθηκε με επιτυχία.',
	'FULL_FOLDER_OPTION_CHANGED'=> 'Η ενέργεια που θα πραγματοποιείται όταν κάποιος φάκελος είναι πλήρης έγινε με επιτυχία.',
	'FWD_ORIGINAL_MESSAGE'		=> '-------- Πρωταρχικό μήνυμα --------',
	'FWD_SUBJECT'				=> 'Θέμα: %s',
	'FWD_DATE'					=> 'Ημερομηνία: %s',
	'FWD_FROM'					=> 'Αποστολέας: %s',
	'FWD_TO'					=> 'Παραλήπτης: %s',

	'GLOBAL_ANNOUNCEMENT'		=> 'Γενική ανακοίνωση',

	'GRAVATAR_AVATAR_EMAIL'			=> 'Διεύθυνση ηλεκτρονικού ταχυδρομείου Gravatar',
	'GRAVATAR_AVATAR_EMAIL_EXPLAIN'	=> 'Εισάγετε τη διεύθυνση ηλεκτρονικού ταχυδρομείου που χρησιμοποιήσατε για την εγγραφή σας στον λογαριασμό <a href="http://www.gravatar.com/">Gravatar</a>.',
	'GRAVATAR_AVATAR_SIZE'			=> 'Διαστάσεις άβαταρ',
	'GRAVATAR_AVATAR_SIZE_EXPLAIN'	=> 'Καθορίστε το πλάτος και το ύψος του άβαταρ, αφήστε κενό για προσπάθεια αυτόματης επαλήθευσης.',	

	'HIDE_ONLINE'				=> 'Απόκρυψη των στοιχείων μου κατά τη διάρκεια της σύνδεσης',
	'HIDE_ONLINE_EXPLAIN'		=> 'Η αλλαγή αυτής της ρύθμισης δεν θα τεθεί σε ισχύ μέχρι την επόμενη επίσκεψή σας στο σύστημα συζητήσεων.',
	'HOLD_NEW_MESSAGES'			=> 'Μη αποδοχή νέων μηνυμάτων (Νέα μηνύματα θα παρακρατούνται μέχρι να υπάρχει αρκετός διαθέσιμος χώρος)',
	'HOLD_NEW_MESSAGES_SHORT'	=> 'Τα νέα μηνύματα θα παρακρατούνται',

	'IF_FOLDER_FULL'			=> 'Αν ο φάκελος είναι πλήρης',
	'IMPORTANT_NEWS'			=> 'Σημαντικές ανακοινώσεις',
	'INVALID_USER_BIRTHDAY'		=> 'Η ημερομηνία γέννησης που εισάγατε δεν είναι μια έγκυρη ημερομηνία.',
	'INVALID_CHARS_USERNAME'	=> 'Το όνομα μέλους περιέχει μη επιτρεπτούς χαρακτήρες.',
	'INVALID_EMOJIS_USERNAME'	=> 'Το όνομα μέλους περιέχει μη επιτρεπτούς χαρακτήρες (Emoji).',
	'INVALID_CHARS_NEW_PASSWORD'=> 'Ο κωδικός πρόσβασης δεν περιέχει τους απαιτούμενους χαρακτήρες.',
	'ITEMS_REQUIRED'			=> 'Τα πεδία που είναι σημειωμένα με * είναι υποχρεωτικά και πρέπει να συμπληρωθούν.',

	'JOIN_SELECTED'				=> 'Ένταξη σε επιλεγμένο',

	'LANGUAGE'						=> 'Γλώσσα',
	'LINK_REMOTE_AVATAR'			=> 'Εξωτερικός δεσμός',
	'LINK_REMOTE_AVATAR_EXPLAIN'	=> 'Εισάγετε το δεσμό της τοποθεσίας που περιέχει την εικόνα άβαταρ στην οποία θέλετε να δημιουργήσετε σύνδεσμο.',
	'LINK_REMOTE_SIZE'				=> 'Διαστάσεις άβαταρ',
	'LINK_REMOTE_SIZE_EXPLAIN'		=> 'Καθορίστε το πλάτος και το ύψος του άβαταρ, αφήστε το κενό για αυτόματη εξακρίβωση.',
	'LOGIN_EXPLAIN_UCP'				=> 'Παρακαλώ συνδεθείτε για πρόσβαση στον Πίνακα Ελέγχου Μέλους.',
	'LOGIN_LINK'					=> 'Σύνδεση ή δημιουργία λογαριασμού σε μια εξωτερική υπηρεσία με το λογαριασμό του συστήματος συζητήσεων',
	'LOGIN_LINK_EXPLAIN'			=> 'Έχετε προσπαθήσει να συνδεθείτε με μια εξωτερική υπηρεσία η οποία δεν έχει ακόμα συνδεθεί σε ένα λογαριασμό σε αυτό το σύστημα συζητήσεων. Θα πρέπει τώρα είτε να συνδέσετε αυτό το λογαριασμό σε έναν υπάρχοντα λογαριασμό ή να δημιουργήσετε έναν νέο λογαριασμό.',
	'LOGIN_LINK_MISSING_DATA'		=> 'Τα δεδομένα που είναι αναγκαία για να συνδέσετε το λογαριασμό σας με μια εξωτερική υπηρεσία δεν είναι διαθέσιμα. Κάντε επανεκκίνηση της διαδικασίας σύνδεσης.',
	'LOGIN_LINK_NO_DATA_PROVIDED'	=> 'Δεν έχουν παρασχεθεί δεδομένα σε αυτή τη σελίδα για να συνδέσετε ένα εξωτερικό λογαριασμό σε λογαριασμό του συστήματος συζητήσεων. Παρακαλούμε επικοινωνήστε με τον διαχειριστή του συστήματος εάν συνεχίσετε να αντιμετωπίζετε προβλήματα.',
	'LOGIN_KEY'						=> 'Κλειδί σύνδεσης',
	'LOGIN_TIME'					=> 'Χρόνος σύνδεσης',
	'LOGIN_REDIRECT'				=> 'Έχετε συνδεθεί με επιτυχία.',
	'LOGOUT_FAILED'					=> 'Δεν έχετε αποσυνδεθεί, ωστόσο το αίτημα δεν ταιριάζει στη σύνοδο σας. Παρακαλώ επικοινωνήστε με τον διαχειριστή του συστήματος συζητήσεων εάν συνεχίσετε να αντιμετωπίζετε προβλήματα.',
	'LOGOUT_REDIRECT'				=> 'Έχετε αποσυνδεθεί με επιτυχία.',

	'MARK_IMPORTANT'				=> 'Επισήμανση/Εξαίρεση ως σημαντικό',
	'MARKED_MESSAGE'				=> 'Επιλεγμένο μήνυμα',
	'MAX_FOLDER_REACHED'			=> 'Ό μέγιστος επιτρεπόμενος αριθμός φακέλων που καθορίζονται για μέλη επιτεύχθηκε',
	'MESSAGE_BY_AUTHOR'				=> 'από το μέλος',
	'MESSAGE_COLOURS'				=> 'Χρώματα μηνύματος',
	'MESSAGE_DELETED'				=> 'Το μήνυμα διαγράφηκε με επιτυχία.',
	'MESSAGE_EDITED'				=> 'Το μήνυμα επεξεργάστηκε με επιτυχία.',	
	'MESSAGE_HISTORY'				=> 'Ιστορικό μηνύματος',
	'MESSAGE_REMOVED_FROM_OUTBOX'	=> 'Αυτό το μήνυμα διαγράφτηκε από τον συγγραφέα του.',
	'MESSAGE_REPORTED_MESSAGE'		=> 'Αναφερόμενο μήνυμα',
	'MESSAGE_SENT_ON'				=> 'ανοιχτό',
	'MESSAGE_STORED'				=> 'Το μήνυμα στάλθηκε με επιτυχία.',
	'MESSAGE_TO'					=> 'Προς',
	'MESSAGES_DELETED'				=> 'Τα μηνύματα διαγράφηκαν με επιτυχία',
	'MOVE_DELETED_MESSAGES_TO'		=> 'Μετακίνηση μηνυμάτων από τον φάκελο Διαγραμμένα σε',
	'MOVE_DOWN'						=> 'Μετακίνηση κάτω',
	'MOVE_MARKED_TO_FOLDER'			=> 'Μετακίνηση σημειωμένων σε %s',
	'MOVE_PM_ERROR'					=> array(
		1	=> 'Ένα σφάλμα σημειώθηκε κατά τη μεταφορά των μηνυμάτων στον νέο φάκελο, μόνο %2$d από %1$s μετακινήθηκε.',
		2	=> 'Ένα σφάλμα σημειώθηκε κατά τη μεταφορά των μηνυμάτων στον νέο φάκελο, μόνο %2$d από %1$s μετακινήθηκαν.',
	),
	'MOVE_TO_FOLDER'				=> 'Μετακίνηση στο φάκελο',
	'MOVE_UP'						=> 'Μετακίνηση επάνω',

	'NEW_FOLDER_NAME'				=> 'Όνομα νέου φακέλου',
	'NEW_PASSWORD'					=> 'Νέος κωδικός πρόσβασης',
	'NEW_PASSWORD_CONFIRM_EMPTY'	=> 'Δεν έχετε εισάγει κωδικό επιβεβαίωσης.',
	'NEW_PASSWORD_ERROR'			=> 'Οι κωδικοί πρόσβασης που εισάγατε δεν ταιριάζουν.',

	'NOTIFICATIONS_MARK_ALL_READ'			=> 'Σήμανση ειδοποιήσεων ως αναγνωσμένες',
	'NOTIFICATIONS_MARK_ALL_READ_CONFIRM'	=> 'Είστε βέβαιοι ότι θέλετε να σημειώσετε όλες τις ειδοποιήσεις ως αναγνωσμένες;',
	'NOTIFICATIONS_MARK_ALL_READ_SUCCESS'	=> 'Όλες οι ειδοποιήσεις έχουν σημειωθεί ως αναγνωσμένες.',
	'NOTIFICATION_GROUP_MISCELLANEOUS'		=> 'Διάφορα ειδοποιήσεις',
	'NOTIFICATION_GROUP_MODERATION'			=> 'Συντονισμός ειδοποιήσεων',
	'NOTIFICATION_GROUP_ADMINISTRATION'		=> 'Διαχείριση ειδοποιήσεων',
	'NOTIFICATION_GROUP_POSTING'			=> 'Ειδοποίηση δημοσίευσης',
	'NOTIFICATION_METHOD_BOARD'				=> 'Ειδοποιήσεις',
	'NOTIFICATION_METHOD_EMAIL'				=> 'Ηλεκτρονικό ταχυδρομείο',
	'NOTIFICATION_METHOD_JABBER'			=> 'Jabber',
	'NOTIFICATION_TYPE'						=> 'Τύπος ειδοποίησης',
	'NOTIFICATION_TYPE_BOOKMARK'			=> 'Κάποιος δημοσίευσε σε ένα θέμα που έχετε σε σελιδοδείκτη',
	'NOTIFICATION_TYPE_GROUP_REQUEST'		=> 'Κάποιος έκανε αίτηση για ένταξη στην ομάδα σας',
	'NOTIFICATION_TYPE_FORUM'				=> 'Κάποιος απαντάει σε ένα θέμα σε μια Δ. Συζήτηση στην οποία είστε συνδρομητής',
	'NOTIFICATION_TYPE_IN_MODERATION_QUEUE'	=> 'Μια δημοσίευση ή θέμα χρειάζεται έγκριση',
	'NOTIFICATION_TYPE_MODERATION_QUEUE'	=> 'Τα θέματα/δημοσιεύσεις σας έχουν εγκριθεί ή απορριφθεί από έναν συντονιστή',
	'NOTIFICATION_TYPE_PM'					=> 'Κάποιος σας έστειλε ένα προσωπικό μήνυμα',
	'NOTIFICATION_TYPE_POST'				=> 'Κάποιος απάντησε σε ένα θέμα στο οποίο είστε συνδρομητής',
	'NOTIFICATION_TYPE_QUOTE'				=> 'Κάποιος σας παρέθεσε σε μια δημοσίευση',
	'NOTIFICATION_TYPE_REPORT'				=> 'Κάποιος ανέφερε μια δημοσίευση',
	'NOTIFICATION_TYPE_REPORT_CLOSED'					=> 'Η αναφορά σας σε μια δημοσίευση έχει κλείσει από έναν συντονιστή',
	'NOTIFICATION_TYPE_REPORT_PM'						=> 'Κάποιος ανέφερε ένα προσωπικό μήνυμα',
	'NOTIFICATION_TYPE_REPORT_PM_CLOSED'				=> 'Η αναφορά σας για ένα προσωπικό μήνυμα έχει κλείσει από έναν συντονιστή',
	'NOTIFICATION_TYPE_TOPIC'				=> 'Κάποιος δημιούργησε ένα θέμα σε μια Δ. Συζήτηση στην οποία είστε συνδρομητής',
	'NOTIFICATION_TYPE_ADMIN_ACTIVATE_USER'	=> 'Μέλη που χρειάζονται ενεργοποίηση',

	'NOTIFY_METHOD'					=> 'Μέθοδος ειδοποίησης',
	'NOTIFY_METHOD_BOTH'			=> 'Και τα δυο',
	'NOTIFY_METHOD_EMAIL'			=> 'Μόνο με μήνυμα ηλεκτρονικού ταχυδρομείου',
	'NOTIFY_METHOD_EXPLAIN'			=> 'Μέθοδος για αποστολή μηνυμάτων μέσω του συστήματος συζητήσεων.',
	'NOTIFY_METHOD_IM'				=> 'Μόνο μέσω Jabber',
	'NOTIFY_ON_PM'					=> 'Να ενημερώνομαι για νέα προσωπικά μηνύματα',
	'NOT_ADDED_FRIENDS_ANONYMOUS'	=> 'Δεν μπορείτε να προσθέσετε το μέλος επισκέπτης (anonymous) στη λίστα φίλων σας.',
	'NOT_ADDED_FRIENDS_BOTS'		=> 'Δεν μπορείτε να προσθέσετε bots στη λίστα των φίλων σας.',
	'NOT_ADDED_FRIENDS_FOES'		=> 'Δεν μπορείτε να προσθέσετε στη λίστα φίλων σας μέλη που βρίσκονται στη λίστα εχθρών σας.',
	'NOT_ADDED_FRIENDS_SELF'		=> 'Δεν μπορείτε να προσθέσετε τον εαυτό σας στη λίστα φίλων σας.',
	'NOT_ADDED_FOES_MOD_ADMIN'		=> 'Δεν μπορείτε να προσθέσετε διαχειριστές και συντονιστές στη λίστα εχθρών σας.',
	'NOT_ADDED_FOES_ANONYMOUS'		=> 'Δεν μπορείτε να προσθέσετε το μέλος επισκέπτης (anonymous) στη λίστα εχθρών σας.',
	'NOT_ADDED_FOES_BOTS'			=> 'Δεν μπορείτε να προσθέσετε bots στη λίστα εχθρών σας.',
	'NOT_ADDED_FOES_FRIENDS'		=> 'Δεν μπορείτε να προσθέσετε στη λίστα εχθρών σας μέλη που βρίσκονται στη λίστα φίλων σας.',
	'NOT_ADDED_FOES_SELF'			=> 'Δεν μπορείτε να προσθέσετε τον εαυτό σας στη λίστα εχθρών σας.',
	'NOT_AGREE'						=> 'Δεν συμφωνώ με αυτούς τους όρους',
	'NOT_ENOUGH_SPACE_FOLDER'		=> 'Ο φάκελος προορισμού “%s” πιθανόν να είναι πλήρης. Η επιθυμητή ενέργεια δεν πραγματοποιήθηκε.',
	'NOT_MOVED_MESSAGES'			=> array(
		1	=> 'Έχετε %d προσωπικό μήνυμα σε αναμονή λόγω γεμάτου φακέλου.',
		2	=> 'Έχετε %d προσωπικά μηνύματα σε αναμονή λόγω γεμάτου φακέλου.',
	),
	'NO_ACTION_MODE'				=> 'Δεν ορίσθηκε ενέργεια για τα μηνύματα.',
	'NO_AUTHOR'						=> 'Δεν προσδιορίσθηκε αποστολέας για αυτό το μήνυμα',
	'NO_AVATAR'						=> 'Δεν επιλέχθηκε άβαταρ',
	'NO_AVATAR_CATEGORY'			=> 'Κανένα',

	'NO_AUTH_DELETE_MESSAGE'		=> 'Δεν είστε εξουσιοδοτημένοι να διαγράψετε προσωπικά μηνύματα.',
	'NO_AUTH_EDIT_MESSAGE'			=> 'Δεν είστε εξουσιοδοτημένοι να επεξεργαστείτε προσωπικά μηνύματα.',
	'NO_AUTH_FORWARD_MESSAGE'		=> 'Δεν είστε εξουσιοδοτημένοι να προωθήσετε προσωπικά μηνύματα.',
	'NO_AUTH_GROUP_MESSAGE'			=> 'Δεν είστε εξουσιοδοτημένοι να στέλνετε προσωπικά μηνύματα σε ομάδες μελών.',
	'NO_AUTH_PROFILEINFO'			=> 'Δεν είστε εξουσιοδοτημένοι να αλλάξετε τις πληροφορίες του προφίλ σας.',
	'NO_AUTH_READ_HOLD_MESSAGE'		=> 'Δεν είστε εξουσιοδοτημένοι να διαβάσετε προσωπικά μηνύματα που είναι σε αναμονή.',
	'NO_AUTH_READ_MESSAGE'			=> 'Δεν είστε εξουσιοδοτημένοι να διαβάσετε προσωπικά μηνύματα.',
	'NO_AUTH_PRINT_MESSAGE'			=> 'Δεν είστε εξουσιοδοτημένοι να εκτυπώσετε προσωπικά μηνύματα.',
	'NO_AUTH_READ_REMOVED_MESSAGE'	=> 'Δεν μπορείτε να διαβάσετε αυτό το μήνυμα επειδή διαγράφηκε από τον συγγραφέα του.',
	'NO_AUTH_SEND_MESSAGE'			=> 'Δεν είστε εξουσιοδοτημένοι να στέλνετε προσωπικά μηνύματα.',
	'NO_AUTH_SIGNATURE'				=> 'Δεν είστε εξουσιοδοτημένοι να ορίσετε υπογραφή.',

	'NO_BCC_RECIPIENT'			=> 'Κανένα',
	'NO_BOOKMARKS'				=> 'Δεν έχετε σελιδοδείκτες.',
	'NO_BOOKMARKS_SELECTED'		=> 'Δεν έχετε επιλέξει σελιδοδείκτες.',
	'NO_EDIT_READ_MESSAGE'		=> 'Το προσωπικό μήνυμα δεν μπορεί να επεξεργαστεί επειδή έχει ήδη αναγνωσθεί.',
	'NO_EMAIL_USER'				=> 'Οι πληροφορίες διεύθυνσης ηλεκτρονικού ταχυδρομείου/ονόματος μέλους που εισάγατε δεν μπορούν να βρεθούν.',
	'EMAIL_NOT_UNIQUE'			=> 'Το email που καθορίσατε, χρησιμοποιείται από πολλούς χρήστες. Πρέπει να ορίσετε και όνομα χρήστη.',
	'NO_FOES'					=> 'Δεν έχετε καθορίσει εχθρούς επί του παρόντος',
	'NO_FRIENDS'				=> 'Δεν έχετε καθορίσει φίλους επί του παρόντος',
	'NO_FRIENDS_OFFLINE'		=> 'Κανένας φίλος ανενεργός',
	'NO_FRIENDS_ONLINE'			=> 'Δεν υπάρχουν φίλοι σε σύνδεση',
	'NO_GROUP_SELECTED'			=> 'Δεν καθορίσθηκε ομάδα μελών.',
	'NO_IMPORTANT_NEWS'			=> 'Δεν υπάρχουν σημαντικές ανακοινώσεις σήμερα.',
	'NO_MESSAGE'				=> 'Το προσωπικό μήνυμα δεν μπορεί να βρεθεί.',
	'NO_NEW_FOLDER_NAME'		=> 'Θα πρέπει να ορίσετε ένα νέο όνομα φακέλου.',
	'NO_NEWER_PM'				=> 'Δεν υπάρχουν νέα μηνύματα.',
	'NO_OLDER_PM'				=> 'Δεν υπάρχουν παλιά μηνύματα.',
	'NO_PASSWORD_SUPPLIED'		=> 'Δεν μπορείτε να συνδεθείτε χωρίς κωδικό πρόσβασης.',
	'NO_RECIPIENT'				=> 'Δεν καθορίσθηκε παραλήπτης.',
	'NO_RESET_TOKEN'			=> 'Δεν παρείχατε κάποιο αποδεικτικό επαναφοράς κωδικού.',
	'NO_RULES_DEFINED'			=> 'Δεν καθορίσθηκαν κανόνες.',
	'NO_SAVED_DRAFTS'			=> 'Δεν υπάρχουν αποθηκευμένα πρόχειρα.',
	'NO_TO_RECIPIENT'			=> 'Κανένας',
	'NO_WATCHED_FORUMS'			=> 'Δεν είστε συνδρομητής σε καμία Δ. Συζήτηση.',
	'NO_WATCHED_SELECTED'		=> 'Δεν έχετε επιλέξει κάποια θέματα ή κάποιες Δ. Συζητήσεις συνδρομών.',
	'NO_WATCHED_TOPICS'			=> 'Δεν είστε συνδρομητής σε κανένα θέμα.',

	'PASS_TYPE_ALPHA_EXPLAIN'	=> 'Ο κωδικός πρόσβασης πρέπει να είναι τουλάχιστον %1$s χαρακτήρες σε μήκος και να περιέχει κεφαλαία-πεζά γράμματα ανακατεμένα και αριθμούς.',
	'PASS_TYPE_ANY_EXPLAIN'		=> 'Πρέπει να είναι τουλάχιστον %1$s χαρακτήρες σε μήκος.',
	'PASS_TYPE_CASE_EXPLAIN'	=> 'Ο κωδικός πρόσβασης πρέπει να είναι τουλάχιστον %1$s χαρακτήρες σε μήκος και να περιέχει κεφαλαία-πεζά γράμματα ανακατεμένα.',
	'PASS_TYPE_SYMBOL_EXPLAIN'	=> 'Ο κωδικός πρόσβασης πρέπει να είναι τουλάχιστον %1$s χαρακτήρες σε μήκος και να περιέχει κεφαλαία-πεζά γράμματα ανακατεμένα, αριθμούς και ειδικά σύμβολα.',
	'PASSWORD'					=> 'Κωδικός πρόσβασης',
	'PASSWORD_ACTIVATED'		=> 'Ο νέος σας κωδικός πρόσβασης έχει ενεργοποιηθεί.',
	'PASSWORD_RESET'			=> 'Έχει γίνει επιτυχής επαναφορά του κωδικού σας.',
	'PASSWORD_RESET_LINK_SENT'	=> 'Αν ο λογαριασμός σας υπάρχει, έχει σταλεί ένα μήνυμα στη διεύθυνση ηλεκτρονικού ταχυδρομείου που έχετε δηλώσει. Αν δεν έχετε λέβει ένα μήνυμα, μπορεί να συμβαίνει γιατί έχετε αποκλειστεί, ο λογαριασμός σας δεν είναι ενεργοποιημένος, έχετε αιτηθεί πολλαπλές φορές επαναφορά κωδικού σε σύντομο χρονικό περιθώριο, ή δεν σας επιτρέπεται να αλλάξετε τον κωδικό σας. Επικοινωνήστε με τον διαχειριστή αν ισχύει κάποιος από τους παραπάνω λόγους. Επίσης, παρακαλώ ελέγξτε το φίλτρο spam σας.',
	'PERMISSIONS_RESTORED'		=> 'Οι αρχικές προσβάσεις επανήλθαν με επιτυχία.',
	'PERMISSIONS_TRANSFERRED'	=> 'Οι προσβάσεις του μέλους <strong>%s</strong> μεταφέρθηκαν με επιτυχία, μπορείτε τώρα να περιηγηθείτε στο σύστημα συζητήσεων με τα δικαιώματα αυτού του μέλους.<br />Σημειώστε ότι δικαιώματα διαχειριστή δεν είναι δυνατόν να μεταφερθούν. Μπορείτε να ανακαλέσετε αυτή την ενέργεια οποιαδήποτε στιγμή.',
	'PM_DISABLED'				=> 'Τα προσωπικά μηνύματα έχουν απενεργοποιηθεί σε αυτό το σύστημα συζητήσεων.',
	'PM_FROM'					=> 'Από',
	'PM_FROM_REMOVED_AUTHOR'	=> 'Αυτό το μήνυμα έχει σταλεί από μέλος που δεν είναι πλέον εγγεγραμμένο.',
	'PM_ICON'					=> 'Εικονίδιο ΠΜ',
	'PM_INBOX'					=> 'Εισερχόμενα',
	'PM_MARK_ALL_READ'			=> 'Σήμανση μηνυμάτων ως αναγνωσμένα',
	'PM_MARK_ALL_READ_SUCCESS'	=> 'Όλα τα προσωπικά μηνύματα σε αυτό το φάκελλο σημειώθηκαν ως αναγνωσμένα',
	'PM_NO_USERS'				=> 'Το επιλεγμένο μέλος που θέλετε να προσθέσετε δεν υπάρχει.',
	'PM_OUTBOX'					=> 'Εξερχόμενα',
	'PM_SENTBOX'				=> 'Απεσταλμένα',
	'PM_SUBJECT'				=> 'Θέμα μηνύματος',
	'PM_TO'						=> 'Αποστολή σε',
	'PM_TOOLS'					=> 'Εργαλεία μηνυμάτων',
	'PM_USERS_REMOVED_NO_PERMISSION'	=> 'Μερικά μέλη δεν μπορούν να προστεθούν γιατί δεν έχουν τα δικαιώματα να διαβάζουν προσωπικά μηνύματα.',
	'PM_USERS_REMOVED_NO_PM'	=> 'Μερικά μέλη δεν μπορούν να προστεθούν γιατί έχουν απενεργοποιημένη τη λήψη μηνυμάτων.',
	'POST_EDIT_PM'				=> 'Επεξεργασία μηνύματος',
	'POST_FORWARD_PM'			=> 'Προώθηση μηνύματος',
	'POST_NEW_PM'				=> 'Σύνταξη μηνύματος',
	'POST_PM_LOCKED'			=> 'Η αποστολή προσωπικών μηνυμάτων είναι κλειδωμένη.',
	'POST_PM_POST'				=> 'Παράθεση δημοσίευσης',
	'POST_QUOTE_PM'				=> 'Παράθεση μηνύματος',
	'POST_REPLY_PM'				=> 'Απάντηση στο μήνυμα',
	'PRINT_PM'					=> 'Προεπισκόπηση εκτύπωσης',
	'PREFERENCES_UPDATED'		=> 'Οι επιλογές σας ενημερώθηκαν με επιτυχία.',
	'PROFILE_INFO_NOTICE'		=> 'Παρακαλώ σημειώστε ότι αυτή η πληροφορία μπορεί να είναι ορατή σε άλλα μέλη. Να είστε προσεκτικοί όταν συμπεριλαμβάνετε οποιαδήποτε προσωπικά στοιχεία. Οποιαδήποτε πεδία σημειώνονται με * πρέπει να συμπληρωθούν.',
	'PROFILE_UPDATED'			=> 'Το προφίλ σας ενημερώθηκε.',
	'PROFILE_AUTOLOGIN_KEYS'	=> 'Τα κλειδιά σύνδεσης “Να με θυμάσαι” σας συνδέουν αυτόματα όταν επισκέπτεστε το σύστημα συζητήσεων. Αν αποσυνδεθείτε, το κλειδί σύνδεσης “Να με θυμάσαι” διαγράφεται μόνο στον υπολογιστή που χρησιμοποιείτε για να αποσυνδεθείτε. Εδώ μπορείτε να δείτε τα κλειδιά σύνδεσης “Να με θυμάσαι” που δημιουργούνται σε άλλους υπολογιστές και χρησιμοποιούνται για την πρόσβαση σε αυτή την ιστοσελίδα.',
	'PROFILE_NO_AUTOLOGIN_KEYS'	=> 'Δεν υπάρχουν κλειδιά σύνδεσης "Να με θυμάσαι".',

	'RECIPIENT'							=> 'Παραλήπτης',
	'RECIPIENTS'						=> 'Παραλήπτες',
	'REGISTRATION'						=> 'Εγγραφή',
	'OAUTH_REGISTRATION'				=> 'Εγγραφή με χρήση υπηρεσιών άλλων παρόχων',
	'RELEASE_MESSAGES'					=> '%sΑπελευθέρωση όλων των μηνυμάτων σε αναμονή%s… αυτά θα ταξινομηθούν πάλι στους κατάλληλους φακέλους αν υπάρχει διαθέσιμος χώρος.',
	'REMOVE_ADDRESS'					=> 'Διαγραφή διεύθυνσης',
	'REMOVE_SELECTED_BOOKMARKS'			=> 'Αφαίρεση επιλεγμένων σελιδοδεικτών',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι θέλετε να αφαιρέσετε όλους τους επιλεγμένους σελιδοδείκτες;',
	'REMOVE_BOOKMARK_MARKED'			=> 'Αφαίρεση σημειωμένων σελιδοδεικτών',
	'REMOVE_FOLDER'						=> 'Διαγραφή φακέλου',
	'REMOVE_FOLDER_CONFIRM'				=> 'Είστε σίγουρος (-η) ότι θέλετε να διαγράψετε αυτό το φάκελο;',
	'RENAME'							=> 'Μετονομασία',
	'RENAME_FOLDER'						=> 'Μετονομασία φακέλου',
	'REPLIED_MESSAGE'					=> 'Απάντηση στο μήνυμα',
	'REPLY_TO_ALL'						=> 'Απάντηση στον αποστολέα και όλους τους αποδέκτες.',
	'REPORT_PM'							=> 'Αναφορά προσωπικού μηνύματος',
	'RESET_PASSWORD'					=> 'Επαναφορά κωδικού',
	'RESET_TOKEN_EXPIRED_OR_INVALID'	=> 'Το αποδεικτικό επαναφοράς κωδικού που δώσατε είναι άκυρο ή έχει λήξει.',
	'RESIGN_SELECTED'					=> 'Επιλέχτηκε παραίτηση',
	'RETURN_FOLDER'						=> '%1$sΕπιστροφή στον προηγούμενο φάκελο%2$s',
	'RETURN_UCP'						=> '%sΕπιστροφή στον Πίνακα Ελέγχου Μέλους%s',
	'RULE_ADDED'						=> 'Ο κανόνας προστέθηκε με επιτυχία.',
	'RULE_ALREADY_DEFINED'				=> 'Ο κανόνας αυτός καθορίστηκε ήδη.',
	'RULE_DELETED'						=> 'Ο κανόνας διαγράφηκε με επιτυχία.',
	'RULE_LIMIT_REACHED'				=> 'Δεν μπορείτε να προσθέσετε περισσότερους κανόνες ΠΜ. Έχετε φτάσει τον μέγιστο αριθμό των κανόνων.',
	'RULE_NOT_DEFINED'					=> 'Ο κανόνας δεν καθορίστηκε σωστά.',
	'RULE_REMOVED_MESSAGES'				=> array(
		1	=> '%d προσωπικό μήνυμα διαγράφτηκε εξαιτίας κάποιου φίλτρου προσωπικών μηνυμάτων.',
		2	=> '%d προσωπικά μηνύματα διαγράφτηκαν εξαιτίας κάποιου φίλτρου προσωπικών μηνυμάτων.',
	),

	'SAME_PASSWORD_ERROR'		=> 'Ο νέος κωδικός πρόσβασης που εισάγατε είναι ίδιος με τον τρέχοντα κωδικό πρόσβασης.',
	'SEARCH_YOUR_POSTS'			=> 'Εμφάνιση των δημοσιεύσεών σας',
	'SENT_AT'					=> 'Αποστολή',			// Used before dates in private messages
	'SHOW_EMAIL'				=> 'Τα μέλη μπορούν να επικοινωνήσουν μαζί μου μέσω μηνύματος ηλεκτρονικού ταχυδρομείου',
	'SIGNATURE_EXPLAIN'			=> 'Αυτό είναι ένα κείμενο που μπορεί να προστίθεται στις δημοσιεύσεις σας. Υπάρχει ένα όριο %d χαρακτήρων.',
	'SIGNATURE_PREVIEW'			=> 'Η υπογραφή σας θα εμφανίζεται όπως εδώ στις δημοσιεύσεις σας',
	'SIGNATURE_TOO_LONG'		=> 'Η υπογραφή σας είναι πολύ μεγάλη.',
	'SELECT_CURRENT_TIME'		=> 'Επιλέξτε τρέχουσα ώρα',
	'SELECT_TIMEZONE'			=> 'Επιλέξτε ώρα ζώνης',
	'SORT'						=> 'Ταξινόμηση',
	'SORT_COMMENT'				=> 'Σχόλιο αρχείου',
	'SORT_DOWNLOADS'			=> 'Μεταφόρτωση',
	'SORT_EXTENSION'			=> 'Κατάληξη',
	'SORT_FILENAME'				=> 'Όνομα αρχείου',
	'SORT_POST_TIME'			=> 'Ώρα δημοσίευσης',
	'SORT_SIZE'					=> 'Μέγεθος αρχείου',

	'TIMEZONE'					=> 'Ζώνη ώρας',
	'TIMEZONE_DATE_SUGGESTION'	=> 'Προτεινόμενη: %s',
	'TIMEZONE_INVALID'			=> 'Η ώρα ζώνης που επιλέξατε είναι άκυρη.',
	'TO'						=> 'Προς',
	'TO_MASS'					=> 'Παραλήπτες',
	'TO_ADD'					=> 'Προσθήκη παραλήπτη',
	'TO_ADD_MASS'				=> 'Προσθήκη παραληπτών',
	'TO_ADD_GROUPS'				=> 'Προσθήκη ομάδων',
	'TOO_MANY_RECIPIENTS'		=> 'Προσπαθήσατε να στείλετε ένα προσωπικό μήνυμα σε πάρα πολλούς παραλήπτες.',
	'TOO_MANY_REGISTERS'		=> 'Έχετε υπερβεί τον αριθμό προσπαθειών εγγραφής για αυτή τη σύνοδο. Παρακαλώ δοκιμάστε πάλι αργότερα.',

	'UCP'						=> 'Πίνακας Ελέγχου Μέλους',
	'UCP_ACTIVATE'				=> 'Ενεργοποίηση λογαριασμού',
	'UCP_ADMIN_ACTIVATE'		=> 'Σημειώστε ότι πρέπει να εισάγετε μια έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου πριν ενεργοποιηθεί ο λογαριασμός σας. Ο διαχειριστής θα ελέγξει τον λογαριασμό σας και εάν εγκριθεί θα σας αποσταλεί μήνυμα ηλεκτρονικού ταχυδρομείου στη διεύθυνση που έχετε ορίσει.',
	'UCP_ATTACHMENTS'			=> 'Συνημμένα',
	'UCP_AUTH_LINK'				=> 'Εξωτερικοί λογαριασμοί',
	'UCP_AUTH_LINK_ASK'			=> 'Προς το παρόν δεν έχετε λογαριασμό που συνδέεται με αυτή την εξωτερική υπηρεσία. Πατήστε στο κουμπί παρακάτω για να συνδέσετε το λογαριασμό σας στο σύστημα συζητήσεων σε ένα λογαριασμό σε αυτή την εξωτερική υπηρεσία.',
	'UCP_AUTH_LINK_ID'			=> 'Μοναδικό αναγνωριστικό',
	'UCP_AUTH_LINK_LINK'		=> 'Σύνδεσμος',
	'UCP_AUTH_LINK_MANAGE'		=> 'Διαχείριση συνδέσεων εξωτερικού λογαριασμού',
	'UCP_AUTH_LINK_NOT_SUPPORTED'	=> 'Η σύνδεση λογαριασμών του συστήματος συζητήσεων σε εξωτερικές υπηρεσίες δεν υποστηρίζεται από την τρέχουσα μέθοδο πιστοποίησης αυτού του συστήματος συζητήσεων.',
	'UCP_AUTH_LINK_TITLE'		=> 'Διαχείριση των συνδέσεων του εξωτερικού λογαριασμού σας',
	'UCP_AUTH_LINK_UNLINK'		=> 'Αποσύνδεση',
	'UCP_COPPA_BEFORE'			=> 'Πριν από %s',
	'UCP_COPPA_ON_AFTER'		=> 'Στις ή μετά την %s',
	'UCP_EMAIL_ACTIVATE'		=> 'Σημειώστε ότι πρέπει να εισάγετε μια έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου πριν ενεργοποιηθεί ο λογαριασμός σας. Θα λάβετε ένα μήνυμα ηλεκτρονικού ταχυδρομείου στη διεύθυνση που έχετε ορίσει που θα περιέχει ένα σύνδεσμο ενεργοποίησης του λογαριασμού.',
	'UCP_JABBER'				=> 'Διεύθυνση Jabber',
	'UCP_LOGIN_LINK'			=> 'Ρύθμιση μιας σύνδεσης εξωτερικού λογαριασμού',

	'UCP_MAIN'					=> 'Επισκόπηση',
	'UCP_MAIN_ATTACHMENTS'		=> 'Διαχείριση συνημμένων',
	'UCP_MAIN_BOOKMARKS'		=> 'Διαχείριση σελιδοδεικτών',
	'UCP_MAIN_DRAFTS'			=> 'Διαχείριση προχείρων',
	'UCP_MAIN_FRONT'			=> 'Κύρια σελίδα',
	'UCP_MAIN_SUBSCRIBED'		=> 'Διαχείριση συνδρομών',

	'UCP_NO_ATTACHMENTS'		=> 'Δεν επισυνάψατε κανένα αρχείο.',

	'UCP_NOTIFICATION_LIST'				=> 'Διαχείριση ειδοποιήσεων',
	'UCP_NOTIFICATION_LIST_EXPLAIN'		=> 'Εδώ μπορείτε να δείτε όλες τις τελευταίες ειδοποιήσεις.',
	'UCP_NOTIFICATION_OPTIONS'			=> 'Επεξεργασία επιλογών ειδοποίησης',
	'UCP_NOTIFICATION_OPTIONS_EXPLAIN'	=> 'Εδώ μπορείτε να ρυθμίσετε τις προτιμώμενες μεθόδους ειδοποίησης για το σύστημα συζητήσεων.',

	'UCP_PREFS'					=> 'Προτιμήσεις Δ. Συζήτησης',
	'UCP_PREFS_PERSONAL'		=> 'Επεξεργασία γενικών ρυθμίσεων',
	'UCP_PREFS_POST'			=> 'Επεξεργασία προεπιλογών δημοσίευσης',
	'UCP_PREFS_VIEW'			=> 'Επεξεργασία επιλογών εμφάνισης',

	'UCP_PM'					=> 'Προσωπικά μηνύματα',
	'UCP_PM_COMPOSE'			=> 'Δημιουργία μηνύματος',
	'UCP_PM_DRAFTS'				=> 'Διαχείριση προχείρων ΠΜ',
	'UCP_PM_OPTIONS'			=> 'Κανόνες, φάκελοι &amp; ρυθμίσεις',
	'UCP_PM_UNREAD'				=> 'Μη αναγνωσμένα μηνύματα',
	'UCP_PM_VIEW'				=> 'Προβολή μηνυμάτων',

	'UCP_PROFILE'				=> 'Προφίλ',
	'UCP_PROFILE_AVATAR'		=> 'Επεξεργασία άβαταρ',
	'UCP_PROFILE_PROFILE_INFO'	=> 'Επεξεργασία προφίλ',
	'UCP_PROFILE_REG_DETAILS'	=> 'Επεξεργασία ρυθμίσεων λογαριασμού',
	'UCP_PROFILE_SIGNATURE'		=> 'Επεξεργασία υπογραφής',
	'UCP_PROFILE_AUTOLOGIN_KEYS'=> 'Διαχείριση κλειδιών σύνδεσης “Να με θυμάσαι”',

	'UCP_USERGROUPS'			=> 'Ομάδες μελών',
	'UCP_USERGROUPS_MEMBER'		=> 'Επεξεργασία ιδιοτήτων μέλους',
	'UCP_USERGROUPS_MANAGE'		=> 'Διαχείριση ομάδων',

	'UCP_PASSWORD_RESET_DISABLED'	=> 'Η λειτουργία επαναφοράς κωδικού πρόσβασης έχει απενεργοποιηθεί. Αν χρειάζεστε βοήθεια για την πρόσβαση στο λογαριασμό σας, παρακαλούμε επικοινωνήστε με τον %sΔιαχειριστή της Δ. Συζήτησης%s',
	'UCP_REGISTER_DISABLE'			=> 'Η δημιουργία ενός νέου λογαριασμού δεν είναι προς το παρόν δυνατή.',
	'UCP_RESEND'					=> 'Αποστολή μηνύματος ενεργοποίησης',
	'UCP_WELCOME'					=> 'Καλώς ήρθατε στον Πίνακα Διαχείρισης Μέλους. Από εδώ μπορείτε να παρακολουθείτε, να βλέπετε και να ενημερώνετε το προφίλ σας, τις επιλογές σας και τις Δ. Συζητήσεις ή δημοσιεύσεις που έχετε επιλέξει να παρακολουθείτε. Μπορείτε επίσης να στέλνετε προσωπικά μηνύματα σε άλλους (εάν επιτρέπεται). Παρακαλώ βεβαιωθείτε ότι έχετε διαβάσει οποιεσδήποτε ανακοινώσεις πριν συνεχίσετε.',
	'UCP_ZEBRA'						=> 'Φίλοι &amp; Εχθροί',
	'UCP_ZEBRA_FOES'				=> 'Διαχείριση εχθρών',
	'UCP_ZEBRA_FRIENDS'				=> 'Διαχείριση φίλων',
	'UNDISCLOSED_RECIPIENT'			=> 'Άγνωστος παραλήπτης',
	'UNKNOWN_FOLDER'				=> 'Άγνωστος φάκελος',
	'UNWATCH_MARKED'				=> 'Παύση παρακολούθησης σημειωμένων',
	'UPLOAD_AVATAR_FILE'			=> 'Φόρτωση από το μηχάνημα σας',
	'UPLOAD_AVATAR_URL'				=> 'Φόρτωση από σύνδεσμο (URL)',
	'UPLOAD_AVATAR_URL_EXPLAIN'		=> 'Εισάγετε τον σύνδεσμο (URL) που περιέχει την εικόνα. Η εικόνα αυτή θα αντιγραφεί σε αυτή την ιστοσελίδα.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'	=> 'Το όνομα μέλους πρέπει να κυμαίνεται μεταξύ %1$s και %2$s σε μήκος και να περιέχει μόνο αλφαριθμητικούς χαρακτήρες.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'=> 'Το όνομα μέλους πρέπει να κυμαίνεται μεταξύ %1$s και %2$s σε μήκος και να περιέχει μόνο αλφαριθμητικούς χαρακτήρες, διαστήματα ή - + _ [ ] χαρακτήρες.',
	'USERNAME_ASCII_EXPLAIN'		=> 'Το όνομα μέλους πρέπει να κυμαίνεται μεταξύ %1$s και %2$s σε μήκος και να περιέχει μόνο χαρακτήρες ASCII, και καθόλου ειδικούς χαρακτήρες.',
	'USERNAME_LETTER_NUM_EXPLAIN'	=> 'Το όνομα μέλους πρέπει να κυμαίνεται μεταξύ %1$s και %2$s σε μήκος και να περιέχει μόνο γράμματα ή αριθμούς.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'=> 'Το όνομα μέλους πρέπει να κυμαίνεται μεταξύ %1$s και %2$s σε μήκος και να περιέχει μόνο γράμματα, αριθμούς, διαστήματα ή - + _ [ ] χαρακτήρες.',
	'USERNAME_CHARS_ANY_EXPLAIN'	=> 'Το μήκος πρέπει να κυμαίνεται μεταξύ %1$s και %2$s.',
	'USERNAME_TAKEN_USERNAME'		=> 'Το όνομα μέλους που εισάγατε χρησιμοποιείται ήδη. Παρακαλώ επιλέξτε κάποιο άλλο.',
	'USERNAME_DISALLOWED_USERNAME'	=> 'Το όνομα μέλους που εισάγατε δεν επιτρέπεται ή περιέχει κάποια απαγορευμένη λέξη. Παρακαλώ επιλέξτε κάποιο άλλο.',
	'USER_NOT_FOUND_OR_INACTIVE'	=> 'Τα ονόματα μέλους που εισάγατε δεν μπόρεσαν να βρεθούν ή δεν είναι ενεργοποιημένα μέλη.',

	'VIEW_AVATARS'				=> 'Προβολή άβαταρ',
	'VIEW_EDIT'					=> 'Προβολή/Επεξεργασία',
	'VIEW_FLASH'				=> 'Προβολή κινούμενων εικόνων',
	'VIEW_IMAGES'				=> 'Προβολή εικόνων μέσα στις δημοσιεύσεις',
	'VIEW_NEXT_HISTORY'			=> 'Προβολή ΠΜ στο ιστορικό',
	'VIEW_NEXT_PM'				=> 'Επόμενο ΠΜ',
	'VIEW_PM'					=> 'Προβολή μηνύματος',
	'VIEW_PM_INFO'				=> 'Λεπτομέρειες μηνύματος',
	'VIEW_PM_MESSAGES'			=> array(
		1	=> '%d μήνυμα',
		2	=> '%d μηνύματα',
	),
	'VIEW_PREVIOUS_HISTORY'		=> 'Προηγούμενο ΠΜ στο ιστορικό',
	'VIEW_PREVIOUS_PM'			=> 'Προηγούμενο ΠΜ',
	'VIEW_PROFILE'				=> 'Εμφάνιση προφίλ',
	'VIEW_SIGS'					=> 'Εμφάνιση υπογραφών',
	'VIEW_SMILIES'				=> 'Εμφάνιση smilies ως εικόνες',
	'VIEW_TOPICS_DAYS'			=> 'Εμφάνιση θεμάτων προηγούμενων ημερών',
	'VIEW_TOPICS_DIR'			=> 'Εμφάνιση θεμάτων σε ταξινόμηση',
	'VIEW_TOPICS_KEY'			=> 'Εμφάνιση θεμάτων ταξινομημένα κατά',
	'VIEW_POSTS_DAYS'			=> 'Εμφάνιση δημοσιεύσεων προηγούμενων ημερών',
	'VIEW_POSTS_DIR'			=> 'Εμφάνιση δημοσιεύσεων σε ταξινόμηση',
	'VIEW_POSTS_KEY'			=> 'Εμφάνιση δημοσιεύσεων ταξινομημένες κατά',

	'WATCHED_EXPLAIN'			=> 'Παρακάτω εμφανίζεται μια λίστα των Δ. Συζητήσεων και των θεμάτων που παρακολουθείτε. Θα ενημερωθείτε όταν υπάρξουν νέες δημοσιεύσεις και στα δύο. Για μη παρακολούθηση κάποιου επιλέξτε τη Δ. συζήτηση ή το θέμα και πατήστε στο <em>Παύση παρακολούθησης σημειωμένων</em>.',
	'WATCHED_FORUMS'			=> 'Δ. συζητήσεις που παρακολουθείτε',
	'WATCHED_TOPICS'			=> 'Θέματα που παρακολουθείτε',
	'WRONG_ACTIVATION'			=> 'Ο κωδικός ενεργοποίησης που εισάγατε δεν ταιριάζει με κανέναν στη βάση δεδομένων.',

	'YOUR_DETAILS'				=> 'Η δραστηριότητά σας',
	'YOUR_FOES'					=> 'Οι εχθροί σας',
	'YOUR_FOES_EXPLAIN'			=> 'Για να αφαιρέσετε ονόματα μελών επιλέξτε τα και πατήστε υποβολή.',
	'YOUR_FRIENDS'				=> 'Οι φίλοι σας',
	'YOUR_FRIENDS_EXPLAIN'		=> 'Για να αφαιρέσετε ονόματα μελών επιλέξτε τα και πατήστε υποβολή.',
	'YOUR_WARNINGS'				=> 'Το επίπεδο προειδοποιήσεων σας',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'	=> 'Μετακίνηση σε φάκελο',
		'MARK_AS_READ'		=> 'Επισήμανση ως αναγνωσμένο',
		'MARK_AS_IMPORTANT'	=> 'Επισήμανση μηνύματος',
		'DELETE_MESSAGE'	=> 'Διαγραφή μηνύματος',
	),
	'PM_CHECK' => array(
		'SUBJECT'	=> 'Θέμα',
		'SENDER'	=> 'Αποστολέας',
		'MESSAGE'	=> 'Μήνυμα',
		'STATUS'	=> 'Κατάσταση μηνύματος',
		'TO'		=> 'Αποστολή προς',
	),
	'PM_RULE' => array(
		'IS_LIKE'		=> 'είναι σαν',
		'IS_NOT_LIKE'	=> 'δεν είναι σαν',
		'IS'			=> 'είναι',
		'IS_NOT'		=> 'δεν είναι',
		'BEGINS_WITH'	=> 'αρχίζει με',
		'ENDS_WITH'		=> 'τελειώνει με',
		'IS_FRIEND'		=> 'είναι φίλος',
		'IS_FOE'		=> 'είναι εχθρός',
		'IS_USER'		=> 'είναι μέλος',
		'IS_GROUP'		=> 'είναι μέλος ομάδας',
		'ANSWERED'		=> 'απαντημένο',
		'FORWARDED'		=> 'προωθημένο',
		'TO_GROUP'		=> 'στην προεπιλεγμένη ομάδα μου',
		'TO_ME'			=> 'σε εμένα',
	),

	'GROUPS_EXPLAIN'	=> 'Οι ομάδες μελών επιτρέπουν στους διαχειριστές του συστήματος συζητήσεων την καλύτερη διαχείριση των μελών. Από προεπιλογή θα πρέπει να τοποθετηθείτε σε μια συγκεκριμένη ομάδα, αυτή είναι η προεπιλεγμένη ομάδα σας. Η ομάδα αυτή καθορίζει το πώς θα μπορείτε να εμφανιστείτε σε άλλα μέλη π.χ. το χρώμα του ονόματος μέλους, το άβατάρ σας, το βαθμό σας κλπ. Ανάλογα με το αν ο διαχειριστής σας το επιτρέπει, μπορεί να επιτραπεί να αλλάξετε την προεπιλεγμένη ομάδα σας. Μπορεί επίσης να προστεθείτε ή να σας επιτραπεί να εγγραφείτε σε άλλες ομάδες. Κάποιες ομάδες μπορεί να σας δώσουν επιπρόσθετα δικαιώματα για να βλέπετε το περιεχόμενο ή να αυξήσετε τις δυνατότητές σας και σε άλλους τομείς.',
	'GROUP_LEADER'		=> 'Ιδιότητες συντονιστή ομάδας',
	'GROUP_MEMBER'		=> 'Ιδιότητες μέλους ομάδας',
	'GROUP_PENDING'		=> 'Ιδιότητες εκκρεμούς συμμετοχής',
	'GROUP_NONMEMBER'	=> 'Χωρίς ιδιότητες συμμετοχής',
	'GROUP_DETAILS'		=> 'Λεπτομέρειες ομάδας',

	'NO_LEADER'		=> 'Δεν υπάρχουν ιδιότητες συντονιστών',
	'NO_MEMBER'		=> 'Δεν υπάρχουν ιδιότητες μελών',
	'NO_PENDING'	=> 'Δεν υπάρχουν ιδιότητες εκκρεμών συμμετοχών',
	'NO_NONMEMBER'	=> 'Καμία ομάδα μη μελών',
));
