<?php
/**
 *
 * This file is part of the phpBB Forum Software package.
 *
 * @copyright (c) phpBB Limited <https://www.phpbb.com>
 * @license GNU General Public License, version 2 (GPL-2.0)
 * @copyright (c) 2018 phpBB-Store.it <https://www.phpbb-store.it>
 * @copyright (c) 2021 phpBB-Italia.it <https://www.phpbb-italia.it>
 * For full copyright and license information, please see
 * the docs/CREDITS.txt file.
 *
 */

/**
 * DO NOT CHANGE
 */
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

$lang = array_merge($lang, array(
	'HELP_BBCODE_BLOCK_IMAGES'	=> 'Visualizza immagini nei messaggi',
	'HELP_BBCODE_BLOCK_INTRO'	=> 'Introduzione',
	'HELP_BBCODE_BLOCK_LINKS'	=> 'Creazione collegamenti',
	'HELP_BBCODE_BLOCK_LISTS'	=> 'Generazione liste',
	'HELP_BBCODE_BLOCK_OTHERS'	=> 'Altre questioni',
	'HELP_BBCODE_BLOCK_QUOTES'	=> 'Citazioni e testo a larghezza fissa',
	'HELP_BBCODE_BLOCK_TEXT'	=> 'Formattazione testo',

	'HELP_BBCODE_IMAGES_ATTACHMENT_ANSWER'	=> 'Gli allegati possono essere inseriti in qualsiasi parte di un messaggio utilizzando il nuovo BBCode <strong>[attachment=][/attachment]</strong>, se la funzionalità degli allegati è stata abilitata da un amministratore e se sono state date le autorizzazioni appropriate per creare gli allegati.  All’interno della schermata del messaggio c’è una casella a discesa (premendo un pulsante) per l’immissione degli allegati in linea.',
	'HELP_BBCODE_IMAGES_ATTACHMENT_QUESTION'	=> 'Aggiungi allegati in un messaggio',
	'HELP_BBCODE_IMAGES_BASIC_ANSWER'	=> 'Il BBCode di phpBB incorpora un tag per includere immagini nei tuoi messaggi. Due cose molto importanti da ricordare quando utilizzi questo tag sono: molti utenti non gradiscono vedere molte immagini nei messaggi e, seconda cosa, l’immagine deve essere già disponibile su Internet (non può esistere solo sul tuo computer a meno che non si esegua un caricamento su un server web !). Per visualizzare un’immagine è necessario l’URL che rimanda all’immagine con tag <strong>[img][/img]</strong>. Per esempio:<br /><br /><strong>[img]</strong>https://www.phpbb.com/theme/images/logos/blue/160x52.png<strong>[/img]</strong><br /><br />Come indicato nella sezione URL descritta sopra è possibile disporre un’immagine in un tag <strong>[url][/url]</strong> se lo si desidera, per esempio<br /><br /><strong>[url=https://www.phpbb.com/][img]</strong>https://www.phpbb.com/theme/images/logos/blue/160x52.png<strong>[/img][/url]</strong><br /><br />creerebbe:<br /><br /><a href="https://www.phpbb.com/"><img src="https://www.phpbb.com/theme/images/logos/blue/160x52.png" alt="" /></a>',
	'HELP_BBCODE_IMAGES_BASIC_QUESTION'	=> 'Aggiungi un’immagine al messaggio',

	'HELP_BBCODE_INTRO_BBCODE_ANSWER'	=> 'Il BBCode è una speciale implementazione dell’HTML. La possibilità di utilizzare i BBCode nei tuoi messaggi sul forum è stabilita dall’amministratore. Inoltre, è possibile disabilitare il BBCode in ogni messaggio attraverso il modulo di invio. Il BBCode è simile all’HTML, i tag sono racchiusi tra parentesi quadre [ e ] piuttosto che tra parentesi angolari &lt; e &gt; e offre un maggiore controllo su cosa e come qualcosa viene visualizzata. A seconda del modello grafico (template) che si sta utilizzando è possibile trovare l’aggiunta del BBCode nei tuoi messaggi in modo facile, attraverso un’interfaccia cliccabile sopra la zona messaggio sul modulo di invio. Anche con questo puoi trovare la seguente guida utile.',
	'HELP_BBCODE_INTRO_BBCODE_QUESTION'	=> 'Cos’è il BBCode?',

	'HELP_BBCODE_LINKS_BASIC_ANSWER'	=> 'Il BBCode di phpBB supporta diversi modi per creare URI (Uniform Resource Identifier) meglio conosciuti come URL (Uniform Resource Locator).<ul><li> Il primo di questi utilizza il tag <strong>[url=][/url]</strong>, qualunque cosa digiti dopo il segno = genererà il contenuto del tag che si comporterà come un URL. Per esempio per linkarsi a phpBB.com devi usare:<br /><br /><strong>[url=https://www.phpbb.com/]</strong>Visita phpBB!<strong>[/url]</strong><br /><br />Questo genera il seguente link, <a href="https://www.phpbb.com/">Visita phpBB!</a> Nota che il collegamento si apre nella stessa finestra o scheda o in una nuova finestra o scheda, a seconda delle impostazioni del browser.</li><li>Se desideri che l’URL stesso sia visualizzato come collegamento, puoi farlo utilizzando semplicemente:<br /><br /><strong>[url]</strong>https://www.phpbb.com/<strong>[/url]</strong><br /><br />Questo genera il seguente link, <a href="https://www.phpbb.com/">https://www.phpbb.com/</a></li><li>Inoltre phpBB dispone di una funzione chiamata <i>Magic Links</i>, questo cambierà ogni URL sintatticamente corretto in un link senza la necessità di specificare nessun tag o http://. Per esempio digitando www.phpbb.com nel tuo messaggio, automaticamente verrà cambiato in <a href="https://www.phpbb.com/">www.phpbb.com</a> e verrà mostrato nel messaggio finale.</li><li>La stessa cosa accade per gli indirizzi email, puoi specificare un indirizzo esplicitamente, per esempio:<br /><br /><strong>[email]</strong>no.one@domain.adr<strong>[/email]</strong><br /><br />che mostrerà <a href="mailto:no.one@domain.adr">no.one@domain.adr</a> oppure puoi digitare no.one@domain.adr che verrà automaticamente convertito all’interno del tuo messaggio.</li></ul>Come per tutti i tag del BBCode puoi includere URL in ogni altro tag come <strong>[img][/img]</strong> (guarda il punto successivo), <strong>[b][/b]</strong>, ecc. Come per i tag di formattazione dipende da te verificare che tutti i tag siano correttamente aperti e chiusi, per esempio:<br /><br /><strong>[url=https://www.phpbb.com/][img]</strong>https://www.phpbb.com/theme/images/logos/blue/160x52.png<strong>[/url][/img]</strong><br /><br /><span style="text-decoration: underline">non</span> è corretto e potrebbe cancellare il tuo messaggio. Quindi presta attenzione.',
	'HELP_BBCODE_LINKS_BASIC_QUESTION'	=> 'Reindirizza su altro sito',

	'HELP_BBCODE_LISTS_ORDERER_ANSWER'	=> 'Il secondo tipo di lista, una lista ordinata, ti permette di controllare ciò che è in uscita prima di ogni elemento. Per creare una lista ordinata si utilizza <strong>[list=1][/list]</strong> per creare una lista numerate o alternativamente <strong>[list=a][/list]</strong> una lista alfabetica. Come per la lista non ordinata, gli elementi vengono specificati utilizzando <strong>[*]</strong>. Per esempio:<br /><br /><strong>[list=1]</strong><br /><strong>[*]</strong>Vai al negozio<br /><strong>[*]</strong>Compra un nuovo computer<br /><strong>[*]</strong>Impreca sul computer quando si blocca<br /><strong>[/list]</strong><br /><br />mentre per una lista alfabetica devi usare:<ol style="list-style-type: decimal;"><li>Vai al negozio</li><li>Compra un nuovo computer</li><li>Impreca sul computer quando si blocca</li></ol>mentre per una lista alfabetica devi usare:<br /><br /><strong>[list=a]</strong><br /><strong>[*]</strong>La prima risposta possibile<br /><strong>[*]</strong>La seconda risposta possibile<br /><strong>[*]</strong>La terza risposta possibile<br /><strong>[/list]</strong><br /><br />sarà<ol style="list-style-type: lower-alpha"><li>La prima risposta possibile</li><li>La seconda risposta possibile</li><li>La terza risposta possibile</li></ol><br /><strong>[list=A]</strong><br /><strong>[*]</strong>La prima risposta possibile<br /><strong>[*]</strong>La seconda risposta possibile<br /><strong>[*]</strong>La terza risposta possibile<br /><strong>[/list]</strong><br /><br />sarà<ol style="list-style-type: upper-alpha"><li>La prima risposta possibile</li><li>La seconda risposta possibile</li><li>La terza risposta possibile</li></ol><br /><strong>[list=i]</strong><br /><strong>[*]</strong>La prima risposta possibile<br /><strong>[*]</strong>La seconda risposta possibile<br /><strong>[*]</strong>La terza risposta possibile<br /><strong>[/list]</strong><br /><br />sarà<ol style="list-style-type: lower-roman"><li>La prima risposta possibile</li><li>La seconda risposta possibile</li><li>La terza risposta possibile</li></ol><br /><strong>[list=I]</strong><br /><strong>[*]</strong>La prima risposta possibile<br /><strong>[*]</strong>La seconda risposta possibile<br /><strong>[*]</strong>La terza risposta possibile<br /><strong>[/list]</strong><br /><br />sarà<ol style="list-style-type: upper-roman"><li>La prima risposta possibile</li><li>La seconda risposta possibile</li><li>La terza risposta possibile</li></ol>',
	'HELP_BBCODE_LISTS_ORDERER_QUESTION'	=> 'Creare una lista ordinata',
	'HELP_BBCODE_LISTS_UNORDERER_ANSWER'	=> 'Il BBCode supporta due tipi di liste, ordinate e non. Sono essenzialmente la stessa cosa del loro equivalente in HTML. Una lista non ordinata mostra ogni oggetto nella tua lista in modo sequenziale, uno dopo l’altro inserendo un punto per ogni riga.Per creare una lista non ordinata usa <strong>[list][/list]</strong>  e definisci ogni oggetto nella lista usando <strong>[*]</strong>. Per esempio per fare una lista dei tuoi colori preferiti puoi usare:<br /><br /><strong>[list]</strong><br /><strong>[*]</strong>Rosso<br /><strong>[*]</strong>Blu<br /><strong>[*]</strong>Giallo<br /><strong>[/list]</strong><br /><br />Questo mostrerà questa lista:<ul><li>Rosso</li><li>Blu</li><li>Giallo</li></ul><br />Alternativamente puoi specificare uno stile di elenco puntato usando <strong>[list=disc][/list]</strong>, <strong>[list=circle][/list]</strong>, o <strong>[list=square][/list]</strong>.',
	'HELP_BBCODE_LISTS_UNORDERER_QUESTION'	=> 'Creare una lista non ordinata',

	'HELP_BBCODE_OTHERS_CUSTOM_ANSWER'	=> 'Se sei un amministratore di questa Board ed hai permessi adeguati, puoi aggiungere altri BBCode nella sezione BBCode personalizzati.',
	'HELP_BBCODE_OTHERS_CUSTOM_QUESTION'	=> 'Posso aggiungere i miei tag personali?',

	'HELP_BBCODE_QUOTES_CODE_ANSWER'	=> 'Se vuoi mostrare un pezzo di codice o qualcosa che ha bisogno di una larghezza fissa, come il carattere Courier, devi racchiudere il testo tra i tag <strong>[code][/code]</strong>, es.<br /><br /><strong>[code]</strong>echo &quot;Questo è un codice&quot;;<strong>[/code]</strong><br /><br />Tutta la formattazione utilizzata tra i tag <strong>[code][/code]</strong> viene mantenuta quando viene visualizzata in seguito. Per evidenziare la sintassi PHP usa il tag <strong>[code=php][/code]</strong> ache ne permettono una lettura migliore.',
	'HELP_BBCODE_QUOTES_CODE_QUESTION'	=> 'Mostrare il codice o dati a larghezza fissa',
	'HELP_BBCODE_QUOTES_TEXT_ANSWER'	=> 'Ci sono due modi per fare una citazione, con un referente o senza.<ul><li>Quando utilizzi la funzione Citazione per rispondere ad un messaggio sul forum devi notare che il testo del messaggio viene incluso nella finestra del messaggio tra <strong>[quote=&quot;&quot;][/quote]</strong>. Questo metodo ti permette di fare una citazione riferendoti ad una persona o qualsiasi altra cosa che hai deciso di inserire! Per esempio, per citare un pezzo di testo di Mr. Blobby devi inserire:<br /><br /><strong>[quote=&quot;Mr. Blobby&quot;]</strong>Il testo di Mr. Blobby andrà qui<strong>[/quote]</strong><br /><br />Nel messaggio verrà automaticamente aggiunto, Mr. Blobby ha scritto: prima del testo citato. Ricorda che tu <strong>devi</strong> inserire le virgolette &quot;&quot; attorno al nome che stai citando; non sono opzionali.</li><li>Il secondo metodo ti permette di citare qualcosa senza referente. Per utilizzare questo metodo, racchiudi il testo tra i tag <strong>[quote][/quote]</strong>. Quando vedrai il messaggio comparirà semplicemente il testo dentro un riquadro di citazione.</li></ul>',
	'HELP_BBCODE_QUOTES_TEXT_QUESTION'	=> 'Citazioni di testo nelle risposte',

	'HELP_BBCODE_TEXT_BASIC_ANSWER'	=> 'Il BBCode include dei tag per permetterti di cambiare velocemente lo stile di base del tuo testo. Questo avviene nel seguente modo: <ul><li>Per il testo in grassetto usa <strong>[b][/b]</strong>, es. <br /><br /><strong>[b]</strong>Ciao<strong>[/b]</strong><br /><br />diventerà <strong>Ciao</strong></li><li>Per il testo sottolineato usa <strong>[u][/u]</strong>, es.:<br /><br /><strong>[u]</strong>Buon giorno<strong>[/u]</strong><br /><br />diventa <span style="text-decoration: underline">Buon giorno</span></li><li>Per il testo in corsivo usa <strong>[i][/i]</strong>, es.:<br /><br />Questo è <strong>[i]</strong>Grandioso!<strong>[/i]</strong><br /><br />diventa Questo è <i>Grandioso!</i></li></ul>',
	'HELP_BBCODE_TEXT_BASIC_QUESTION'	=> 'Come creare il testo in grassetto, sottolineato o corsivo',
	'HELP_BBCODE_TEXT_COLOR_ANSWER'	=> 'Per modificare il colore o la grandezza del testo puoi usare i seguenti tag. Tieni a mente che il risultato di come apparirà dipende dal browser e dal sistema di chi lo vede: <ul><li>Cambiare il colore al testo è possibile inserendolo in <strong>[color=][/color]</strong>. Puoi specificare sia un nome di colore riconosciuto (esempio: red, blue, yellow, ecc.) o l’alternativa esadecimale, come #FFFFFF, #000000. Ad esempio, per creare del testo rosso puoi usare:<br /><br /><strong>[color=red]</strong>Ciao!<strong>[/color]</strong><br /><br />oppure<br /><br /><strong>[color=#FF0000]</strong>Ciao!<strong>[/color]</strong><br /><br />Tutti e due daranno come risultato <span style="color:red">Ciao!</span></li><li>Cambiare la dimensione del testo è possibile in modo similare, usando <strong>[size=][/size]</strong>. Questo tag è influenzato dallo stile che l’utente ha selezionato, ma il formato raccomandato è un valore numerico rappresentante la dimensione del testo in percentuale, da 20 fino a 200 (molto grande) come da impostazioni predefinite. Per esempio:<br /><br /><strong>[size=30]</strong>Piccolo<strong>[/size]</strong><br /><br />diventa<span style="font-size:30%;">Piccolo</span><br /><br />mentre:<br /><br /><strong>[size=200]</strong>Enorme!<strong>[/size]</strong><br /><br />diventa <span style="font-size:200%;">Enorme!</span></li></ul>',
	'HELP_BBCODE_TEXT_COLOR_QUESTION'	=> 'Come cambiare colore o grandezza al testo',
	'HELP_BBCODE_TEXT_COMBINE_ANSWER'	=> 'Certo che puoi, ad esempio per attirare l’attenzione di qualcuno puoi scrivere:<br /><br /><strong>[size=200][color=red][b]</strong>Guardami!<strong>[/b][/color][/size]</strong><br /><br />questo genera <span style="color:red;font-size:200%;"><strong>Guardami!</strong></span><br /><br />Ti consigliamo comunque di non esagerare e scrivere molto testo in questo modo. Ricordati inoltre che è compito tuo assicurarti che i tag siano chiusi correttamente. Ad esempio, quello che segue non è corretto:<br /><br /><strong>[b][u]</strong>Questo è sbagliato<strong>[/b][/u]</strong>',
	'HELP_BBCODE_TEXT_COMBINE_QUESTION'	=> 'Posso combinare più tag?',
));
