/*    patchlevel.h
 *
 *    Copyright (C) 1993, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002,
 *    2003, 2004, 2005, 2006, 2007, 2008, 2009, by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#ifndef __PATCHLEVEL_H_INCLUDED__

/* do not adjust the whitespace! Configure expects the numbers to be
 * exactly on the third column */

#define PERL_REVISION	5		/* age */
#define PERL_VERSION	26		/* epoch */
#define PERL_SUBVERSION	3		/* generation */

/* The following numbers describe the earliest compatible version of
   Perl ("compatibility" here being defined as sufficient binary/API
   compatibility to run XS code built with the older version).
   Normally this should not change across maintenance releases.

   Note that this only refers to an out-of-the-box build.  Many non-default
   options such as usemultiplicity tend to break binary compatibility
   more often.

   This is used by Configure et al to figure out
   PERL_INC_VERSION_LIST, which lists version libraries
   to include in @INC.  See INSTALL for how this works.

   Porting/bump-perl-version will automatically set these to the version of perl
   to be released for blead releases, and to 5.X.0 for maint releases. Manually
   changing them should not be necessary.
*/
#define PERL_API_REVISION	5
#define PERL_API_VERSION	26
#define PERL_API_SUBVERSION	0
/*
   XXX Note:  The selection of non-default Configure options, such
   as -Duselonglong may invalidate these settings.  Currently, Configure
   does not adequately test for this.   A.D.  Jan 13, 2000
*/

#define __PATCHLEVEL_H_INCLUDED__
#endif

/*
	local_patches -- list of locally applied less-than-subversion patches.
	If you're distributing such a patch, please give it a name and a
	one-line description, placed just before the last NULL in the array
	below.  If your patch fixes a bug in the perlbug database, please
	mention the bugid.  If your patch *IS* dependent on a prior patch,
	please place your applied patch line after its dependencies. This
	will help tracking of patch dependencies.

	Please either use 'diff --unified=0' if your diff supports
	that or edit the hunk of the diff output which adds your patch
	to this list, to remove context lines which would give patch
	problems. For instance, if the original context diff is

	   *** patchlevel.h.orig	<date here>
	   --- patchlevel.h	<date here>
	   *** 38,43 ***
	   --- 38,44 ---
	     	,"FOO1235 - some patch"
	     	,"BAR3141 - another patch"
	     	,"BAZ2718 - and another patch"
	   + 	,"MINE001 - my new patch"
	     	,NULL
	     };

	please change it to
	   *** patchlevel.h.orig	<date here>
	   --- patchlevel.h	<date here>
	   *** 41,43 ***
	   --- 41,44 ---
	   + 	,"MINE001 - my new patch"
	     	,NULL
	     };

	(Note changes to line numbers as well as removal of context lines.)
	This will prevent patch from choking if someone has previously
	applied different patches than you.

        History has shown that nobody distributes patches that also
        modify patchlevel.h. Do it yourself. The following perl
        program can be used to add a comment to patchlevel.h:

#!perl
die "Usage: perl -x patchlevel.h comment ..." unless @ARGV;
open PLIN, "<", "patchlevel.h" or die "Couldn't open patchlevel.h : $!";
open PLOUT, ">", "patchlevel.new" or die "Couldn't write on patchlevel.new : $!";
my $seen=0;
while (<PLIN>) {
    if (/\t,NULL/ and $seen) {
       while (my $c = shift @ARGV){
	    $c =~ s|\\|\\\\|g;
	    $c =~ s|"|\\"|g;
            print PLOUT qq{\t,"$c"\n};
       }
    }
    $seen++ if /local_patches\[\]/;
    print PLOUT;
}
close PLOUT or die "Couldn't close filehandle writing to patchlevel.new : $!";
close PLIN or die "Couldn't close filehandle reading from patchlevel.h : $!";
close DATA; # needed to allow unlink to work win32.
unlink "patchlevel.bak" or warn "Couldn't unlink patchlevel.bak : $!"
  if -e "patchlevel.bak";
rename "patchlevel.h", "patchlevel.bak" or
  die "Couldn't rename patchlevel.h to patchlevel.bak : $!";
rename "patchlevel.new", "patchlevel.h" or
  die "Couldn't rename patchlevel.new to patchlevel.h : $!";
__END__

Please keep empty lines below so that context diffs of this file do
not ever collect the lines belonging to local_patches() into the same
hunk.

 */

#if !defined(PERL_PATCHLEVEL_H_IMPLICIT) && !defined(LOCAL_PATCH_COUNT)
#  if defined(PERL_IS_MINIPERL)
#    define PERL_PATCHNUM "UNKNOWN-miniperl"
#    define PERL_GIT_UNPUSHED_COMMITS /*leave-this-comment*/
#  elif defined(PERL_MICRO)
#    define PERL_PATCHNUM "UNKNOWN-microperl"
#    define PERL_GIT_UNPUSHED_COMMITS /*leave-this-comment*/
#  else
#include "git_version.h"
#  endif
static const char * const local_patches[] = {
	NULL
#ifdef PERL_GIT_UNCOMMITTED_CHANGES
	,"uncommitted-changes"
#endif
	PERL_GIT_UNPUSHED_COMMITS    	/* do not remove this line */
	,"Fedora Patch1: Removes date check, Fedora/RHEL specific"
	,"Fedora Patch3: support for libdir64"
	,"Fedora Patch4: use libresolv instead of libbind"
	,"Fedora Patch5: USE_MM_LD_RUN_PATH"
	,"Fedora Patch6: Provide MM::maybe_command independently (bug #1129443)"
	,"Fedora Patch7: Dont run one io test due to random builder failures"
	,"Fedora Patch15: Define SONAME for libperl.so"
	,"Fedora Patch16: Install libperl.so to -Dshrpdir value"
	,"Fedora Patch22: Document Math::BigInt::CalcEmu requires Math::BigInt (CPAN RT#85015)"
	,"Fedora Patch26: Make *DBM_File desctructors thread-safe (RT#61912)"
	,"Fedora Patch27: Make PadlistNAMES() lvalue again (CPAN RT#101063)"
	,"Fedora Patch30: Replace EU::MakeMaker dependency with EU::MM::Utils in IPC::Cmd (bug #1129443)"
	,"Fedora Patch31: Make File::Glob more resistant against degenerative matching (RT#131211)"
	,"Fedora Patch36: Fix glob UTF-8 flag on a glob reassignment (RT#131263)"
	,"Fedora Patch38: Fix handling backslashes in PATH environment variable when executing \"perl -S\" (RT#129183)"
	,"Fedora Patch45: Fix File::Glob rt131211.t test random failures"
	,"Fedora Patch46: Fix t/op/hash.t test random failures"
	,"Fedora Patch47: Parse caret variables with subscripts as normal variables inside ${...} escaping (RT#131664)"
	,"Fedora Patch49: Do not display too many bytes when reporting malformed UTF-8 character"
	,"Fedora Patch51: Fix error message for \"our sub foo::bar\" (RT#131679)"
	,"Fedora Patch52: Fix executing arybase::_tie_it() in Safe compartement (RT#131588)"
	,"Fedora Patch54: Fix splitting non-ASCII strings if unicode_strings feature is enabled (RT#130907)"
	,"Fedora Patch55: Fix compiler warnings in code generated by ExtUtils::Constant (CPAN RT#63832)"
	,"Fedora Patch56: Fix compiler warnings in code generated by ExtUtils::Constant (CPAN RT#101487)"
	,"Fedora Patch58: Fix unreliable Time-HiRes tests (CPAN RT#122819)"
	,"Fedora Patch61: Fix Term::ReadLine not to create spurious &STDERR files (RT#132008)"
	,"Fedora Patch64: Fix an overflow when parsing a character range with no preceding character (RT#132245)"
	,"Fedora Patch65: Fix walking symbol table for ISA in Carp"
	,"Fedora Patch66: Fix handling file names with null bytes in stat and lstat functions (RT#131895)"
	,"Fedora Patch67: Fix a crash when untying an object witout a stash"
	,"Fedora Patch68: Fix deparsing of transliterations with unprintable characters (RT#132405)"
	,"Fedora Patch69: Fix error reporting on do() on a directory (RT#125774)"
	,"Fedora Patch70: Fix stack manipulation when a lexical subroutine is defined in a do block in a member of an iteration list (RT#132442)"
	,"Fedora Patch71: Fix setting $! when statting a closed filehandle (RT#108288)"
	,"Fedora Patch72: Fix tainting of s/// with overloaded replacement (RT#115266)"
	,"Fedora Patch73: Expand system() arguments before a fork (RT#121105)"
	,"Fedora Patch76: Avoid undefined behavior when copying memory in Glob and pp_caller (RT#131746)"
	,"Fedora Patch78: Fix compatibility with libxcrypt (RT#133184)"
	,"Fedora Patch79: Link XS modules to pthread library to fix linking with -z defs"
	,"Fedora Patch80: Fix parsing braced subscript after parentheses (RT#8045)"
	,"Fedora Patch81: Do not clobber file bytes in :encoding layer (RT#132833)"
	,"Fedora Patch82: Fix line numbers in multi-line s/// (RT#131930)"
	,"Fedora Patch83: Fix parsing extended bracketed character classes (RT#132167)"
	,"Fedora Patch84: Fix a possibly unitialized memory read in the Perl parser (RT#133074)"
	,"Fedora Patch85: Fix an infinite loop in the regular expression compiler (RT#133185)"
	,"Fedora Patch86: Adjust tests to gdbm-1.15 (RT#133295)"
	,"Fedora Patch88: Fix printing a warning about a wide character when matching a regular expression while ISO-8859-1 locale is in effect"
	,"Fedora Patch89: Fix invoking a check for wide characters while ISO-8859-1 locale is in effect"
	,"Fedora Patch90: Pass the correct CFLAGS to dtrace"
	,"RHEL Patch91: Fix Time-Local tests to pass after year 2019 (bug #1807120)"
	,"RHEL Patch92: Fix CVE-2020-12723 (GH#16947)"
	,"RHEL Patch93: Fix CVE-2020-10543"
	,"RHEL Patch94: Fix CVE-2020-10878"
	,"RHEL Patch95: Fix Net-Ping _resolv return value on failing DNS name lookup (bug #1973030)"
	,"RHEL Patch97: Fix a memory leak when compiling a regular expression with a non-word class (GH#17218)"
	,"RHEL Patch98: Fix CVE-2025-40909"
	,"Fedora Patch200: Link XS modules to libperl.so with EU::CBuilder on Linux"
	,"Fedora Patch201: Link XS modules to libperl.so with EU::MM on Linux"
	,"Fedora Patch202: Add definition of OPTIMIZE to .ph files (bug #2152012)"
	,NULL
};



/* Initial space prevents this variable from being inserted in config.sh  */
#  define	LOCAL_PATCH_COUNT	\
	((int)(C_ARRAY_LENGTH(local_patches)-2))

/* the old terms of reference, add them only when explicitly included */
#define PATCHLEVEL		PERL_VERSION
#undef  SUBVERSION		/* OS/390 has a SUBVERSION in a system header */
#define SUBVERSION		PERL_SUBVERSION
#endif
