SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `ops3502`
--


-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` date DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_type_id` (`type_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcements are messages that can be presented to users e.g. on the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_settings`
--

CREATE TABLE `announcement_settings` (
  `announcement_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`announcement_setting_id`),
  UNIQUE KEY `announcement_settings_unique` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcements, including localized properties like names and contents.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_types`
--

CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcement types allow for announcements to optionally be categorized.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_type_settings`
--

CREATE TABLE `announcement_type_settings` (
  `announcement_type_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`announcement_type_setting_id`),
  UNIQUE KEY `announcement_type_settings_unique` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcement types, including localized properties like their names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `include_in_browse` smallint(6) NOT NULL DEFAULT '1',
  `publication_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `user_group_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `authors_user_group_id` (`user_group_id`),
  KEY `authors_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The authors of a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_affiliations`
--

CREATE TABLE `author_affiliations` (
  `author_affiliation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`author_affiliation_id`),
  KEY `author_affiliations_ror` (`ror`),
  KEY `author_affiliations_author_id_foreign` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Author affiliations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_affiliation_settings`
--

CREATE TABLE `author_affiliation_settings` (
  `author_affiliation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_affiliation_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_affiliation_setting_id`),
  UNIQUE KEY `author_affiliation_settings_unique` (`author_affiliation_id`,`locale`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about author affiliations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_settings`
--

CREATE TABLE `author_settings` (
  `author_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_setting_id`),
  UNIQUE KEY `author_settings_unique` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about authors, including localized properties such as their name and affiliation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT NULL,
  `path` varchar(255) NOT NULL,
  `image` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_path` (`context_id`,`path`),
  KEY `category_context_id` (`context_id`),
  KEY `category_context_parent_id` (`context_id`,`parent_id`),
  KEY `category_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Categories permit the organization of submissions into a heirarchical structure.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_settings`
--

CREATE TABLE `category_settings` (
  `category_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`category_setting_id`),
  UNIQUE KEY `category_settings_unique` (`category_id`,`locale`,`setting_name`),
  KEY `category_settings_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about categories, including localized properties such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citations`
--

CREATE TABLE `citations` (
  `citation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `raw_citation` text NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`citation_id`),
  UNIQUE KEY `citations_publication_seq` (`publication_id`,`seq`),
  KEY `citations_publication` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A citation made by an associated publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citation_settings`
--

CREATE TABLE `citation_settings` (
  `citation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `citation_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`citation_setting_id`),
  UNIQUE KEY `citation_settings_unique` (`citation_id`,`locale`,`setting_name`),
  KEY `citation_settings_citation_id` (`citation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Additional data about citations, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocabs`
--

CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(64) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Every word or phrase used in a controlled vocabulary. Controlled vocabularies are used for submission metadata like keywords and subjects, reviewer interests, and wherever a similar dictionary of words or phrases is required. Each entry corresponds to a word or phrase like "cellular reproduction" and a type like "submissionKeyword".' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entries`
--

CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_controlled_vocab_id` (`controlled_vocab_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The order that a word or phrase used in a controlled vocabulary should appear. For example, the order of keywords in a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entry_settings`
--

CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`controlled_vocab_entry_setting_id`),
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about a controlled vocabulary entry, including localized properties such as the actual word or phrase.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstones`
--

CREATE TABLE `data_object_tombstones` (
  `tombstone_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data_object_id` bigint(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `set_spec` varchar(255) NOT NULL,
  `set_name` varchar(255) NOT NULL,
  `oai_identifier` varchar(255) NOT NULL,
  PRIMARY KEY (`tombstone_id`),
  KEY `data_object_tombstones_data_object_id` (`data_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Entries for published data that has been removed. Usually used in the OAI endpoint.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_oai_set_objects`
--

CREATE TABLE `data_object_tombstone_oai_set_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `data_object_tombstone_oai_set_objects_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between tombstones and other data that can be collected in OAI sets, e.g. sections.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_settings`
--

CREATE TABLE `data_object_tombstone_settings` (
  `tombstone_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`tombstone_setting_id`),
  UNIQUE KEY `data_object_tombstone_settings_unique` (`tombstone_id`,`locale`,`setting_name`),
  KEY `data_object_tombstone_settings_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about data object tombstones, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dois`
--

CREATE TABLE `dois` (
  `doi_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `doi` varchar(255) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`doi_id`),
  KEY `dois_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all DOIs used in the system.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `doi_settings`
--

CREATE TABLE `doi_settings` (
  `doi_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `doi_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`doi_setting_id`),
  UNIQUE KEY `doi_settings_unique` (`doi_id`,`locale`,`setting_name`),
  KEY `doi_settings_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about DOIs, including the registration agency.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `edit_decisions`
--

CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) DEFAULT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) DEFAULT NULL,
  `editor_id` bigint(20) NOT NULL,
  `decision` smallint(6) NOT NULL COMMENT 'A numeric constant indicating the decision that was taken. Possible values are listed in the Decision class.',
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_submission_id` (`submission_id`),
  KEY `edit_decisions_editor_id` (`editor_id`),
  KEY `edit_decisions_review_round_id` (`review_round_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Editorial decisions recorded on a submission, such as decisions to accept or decline the submission, as well as decisions to send for review, send to copyediting, request revisions, and more.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log`
--

CREATE TABLE `email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `email_log_sender_id` (`sender_id`),
  KEY `email_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of email messages that are sent in relation to an associated entity, such as a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log_users`
--

CREATE TABLE `email_log_users` (
  `email_log_user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_log_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`email_log_user_id`),
  UNIQUE KEY `email_log_user_id` (`email_log_id`,`user_id`),
  KEY `email_log_users_email_log_id` (`email_log_id`),
  KEY `email_log_users_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of users associated with an email log entry.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `context_id` bigint(20) NOT NULL,
  `alternate_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`context_id`),
  KEY `email_templates_context_id` (`context_id`),
  KEY `email_templates_alternate_to` (`alternate_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Custom email templates created by each context, and overrides of the default templates.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default_data`
--

CREATE TABLE `email_templates_default_data` (
  `email_templates_default_data_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `locale` varchar(28) NOT NULL DEFAULT 'en',
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text,
  PRIMARY KEY (`email_templates_default_data_id`),
  UNIQUE KEY `email_templates_default_data_unique` (`email_key`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Default email templates created for every installed locale.' AUTO_INCREMENT=28 ;

--
-- Dumping data for table `email_templates_default_data`
--

INSERT INTO `email_templates_default_data` VALUES
(1, 'PASSWORD_RESET_CONFIRM', 'en', 'Password Reset Confirm', 'Password Reset Confirmation', 'We have received a request to reset your password for the {$siteTitle} web site.<br />\n<br />\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.<br />\n<br />\nReset my password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(2, 'USER_REGISTER', 'en', 'User Created', 'Server Registration', '{$recipientName}<br />\n<br />\nYou have now been registered as a user with {$contextName}. We have included your username and password in this email, which are needed for all work with this server through its website. At any point, you can ask to be removed from the server''s list of users by contacting me.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),
(3, 'USER_VALIDATE_CONTEXT', 'en', 'Validate Email (Server Registration)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$contextName}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$contextSignature}'),
(4, 'USER_VALIDATE_SITE', 'en', 'Validate Email (Site)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$siteTitle}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$siteSignature}'),
(5, 'SUBMISSION_ACK', 'en', 'Submission Acknowledgement (Pending Moderation)', 'Thank you for your submission to {$contextName}', '<p>Dear {$recipientName},</p><p>Thank you for your submission to {$contextName}. We have received your preprint, {$submissionTitle}, and a moderator  will see it soon. Once the moderator has reviewed your submission, they will post your preprint or contact you.</p><p>You can view your submission and track its progress through the editorial process at the following location:</p><p>Submission URL: {$authorSubmissionUrl}</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Thank you for considering {$contextName} as a venue for your work.</p>{$contextSignature}'),
(6, 'POSTED_ACK', 'en', 'Posted Acknowledgement', 'Preprint Posted Acknowledgement', '{$recipientName}:<br />\n<br />\nYour preprint, &quot;{$submissionTitle}&quot; has been posted online on {$contextName}.<br />\n<br />\nPreprint URL: {$submissionUrl}<br />\n<br />\nIf you have any questions, please contact me.<br />\n<br />\n{$signature}'),
(7, 'POSTED_NEW_VERSION_ACK', 'en', 'New Version Posted', 'New Version Posted Acknowledgement', '<p>Dear {$recipientName},</p><p>Thank you for posting a new version of your preprint to {$contextName}. The new version is now <a href="{$submissionPublishedUrl}">available</a>.</p><p>If you have any questions, please contact me.</p>{$signature}'),
(8, 'SUBMISSION_ACK_CAN_POST', 'en', 'Submission Acknowledgement (No Moderation Required)', 'Thank you for your submission to {$contextName}', '<p>Dear {$recipientName},</p><p>Thank you for your submission to {$contextName}. This is an automated message to let you know that we have received your preprint, {$submissionTitle}. As a trusted author, no moderation is required, so we invite you to <a href="{$authorSubmissionUrl}">post your preprint</a> as soon as you are ready.</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>Thank you for considering {$contextName} as a venue for your work.</p>{$contextSignature}'),
(9, 'SUBMISSION_ACK_NOT_USER', 'en', 'Submission Confirmation (Other Authors)', 'Submission Acknowledgement', '<p>Dear {$recipientName},</p><p>You have been named as a co-author on a preprint submitted to {$contextName}. The submitter, {$submitterName}, provided the following details:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>If any of these details are incorrect, or you do not wish to be named on this preprint, please contact me.</p><p>Thank you for considering this server as a venue for your work.</p><p>Kind regards,</p>{$contextSignature}'),
(10, 'EDITOR_ASSIGN', 'en', 'Editor Assigned', 'You have been assigned as a moderator on a submission to {$contextName}', '<p>Dear {$recipientName},</p><p>The following preprint has been assigned to you to see through the screening process in your role as Moderator.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the preprint</a>. Use the Discussions section to contact the author if you have any questions. Please post the preprint once you are satisfied that it meets all requirements.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$contextSignature}'),
(11, 'EDITOR_DECISION_ACCEPT', 'en', 'Submission Accepted', 'Your submission has passed moderation at {$contextName}', '<p>Dear {$recipientName},</p><p>I am pleased to inform you that a moderator has decided to accept your preprint at {$contextName}. We found your submission, {$submissionTitle}, to meet the requirements for preprints posted to {$contextName} and thank you for choosing our server as a venue for your work.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),
(12, 'EDITOR_DECISION_INITIAL_DECLINE', 'en', 'Submission Declined', 'Your submission has been declined', '<p>Dear {$recipientName},</p><p>I’m sorry to inform you that, after reviewing your submission, "{$submissionTitle}", the editor has found that it does not meet our requirements for publication in {$contextName}.</p><p>I wish you success if you consider submitting your work elsewhere.</p><p>Kind regards,</p>{$signature}'),
(13, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'en', 'Reinstate Submission Declined Without Review', 'We have reversed the decision to decline your submission', '<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, {$submissionTitle}, has been reversed. \nA moderator will look further at your submission before deciding whether to decline \nor post the submission.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(14, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'en', 'Notify Other Authors', 'An update regarding your submission', '<p>The following email was sent to {$submittingAuthorName} from {$contextName} regarding "{$submissionTitle}".</p>\n<p>You are receiving a copy of this notification because you are identified as an author of the submission. Any instructions in the message below are intended for the submitting author, {$submittingAuthorName}, and no action is required of you at this time.</p>\n\n{$messageToSubmittingAuthor}'),
(15, 'STATISTICS_REPORT_NOTIFICATION', 'en', 'Statistics Report Notification', 'Preprint Server activity for {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nYour preprint health report for {$month}, {$year} is now available. Your key stats for this month are below.<br />\n<ul>\n	<li>New submissions this month: {$newSubmissions}</li>\n	<li>Declined submissions this month: {$declinedSubmissions}</li>\n	<li>Accepted submissions this month: {$acceptedSubmissions}</li>\n	<li>Total submissions in the system: {$totalSubmissions}</li>\n</ul>\nLogin to the the preprint server to view more detailed <a href="{$editorialStatsLink}">trends</a> and <a href="{$publicationStatsLink}">posted preprint stats</a>. A full copy of this month''s trends is attached.<br />\n<br />\nSincerely,<br />\n{$contextSignature}'),
(16, 'ANNOUNCEMENT', 'en', 'New Announcement', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisit our website to read the <a href="{$announcementUrl}">full announcement</a>.'),
(17, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'en', 'Discussion (Production)', 'A message regarding {$contextName}', 'Please enter your message.'),
(18, 'EDITOR_ASSIGN_PRODUCTION', 'en', 'Editor Assigned', 'You have been assigned as a moderator on a submission to {$contextName}', '<p>Dear {$recipientName},</p><p>The following preprint has been assigned to you to see through the screening process in your role as Moderator.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the preprint</a>. Use the Discussions section to contact the author if you have any questions. Please post the preprint once you are satisfied that it meets all requirements.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$contextSignature}'),
(19, 'VERSION_CREATED', 'en', 'Version Created', 'A new version was created for "{$submissionTitle}"', '<p>Dear {$recipientName}, </p><p>This is an automated message to inform you that a new version of your submission, "{$submissionTitle}", was created. You can view this version from your submission dashboard at the following link:</p><p><a href="{$submissionUrl}">"{$submissionTitle}"</a></p><hr><p>This is an automatic email sent from <a href="{$contextUrl}">{$contextName}</a>.</p>'),
(20, 'SUBMISSION_SAVED_FOR_LATER', 'en', 'Submission Saved for Later', 'Resume your submission to {$contextName}', '<p>Dear {$recipientName},</p><p>Your submission details have been saved in our system, but it has not yet been submitted for consideration. You can return to complete your submission at any time by following the link below.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — "{$submissionTitle}"</a></p><hr><p>This is an automated email from <a href="{$contextUrl}">{$contextName}</a>.</p>'),
(21, 'SUBMISSION_NEEDS_EDITOR', 'en', 'Submission Needs Editor', 'A new submission needs an editor to be assigned: "{$submissionTitle}"', '<p>Dear {$recipientName},</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href="{$submissionUrl}">"{$submissionTitle}"</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href="{$contextUrl}">{$contextName}</a>.</p>'),
(22, 'CHANGE_EMAIL', 'en', 'Change Email Address Invitation', 'Confirm account contact email change request', '<p>Dear {$recipientName},</p><p>You are receiving this email because someone has requested a change of your email to {$newEmail}.</p><p>If you have made this request please <a href="{$acceptInvitationUrl}">confirm</a> the email change.</p><p>You can always <a href="{$declineInvitationUrl}">reject</a> this email change.</p><p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Kind regards,</p>{$siteContactName}'),
(23, 'ORCID_COLLECT_AUTHOR_ID', 'en', 'orcidCollectAuthorId', 'Submission ORCID', 'Dear {$recipientName},<br/>\n<br/>\nYou have been listed as an author on a manuscript submission to {$contextName}.<br/>\nTo confirm your authorship, please add your ORCID id to this submission by visiting the link provided below.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">More information about ORCID at {$contextName}</a><br/>\n<br/>\nIf you have any questions, please contact me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(24, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'en', 'orcidRequestAuthorAuthorization', 'Requesting ORCID record access', 'Dear {$recipientName},<br>\n<br>\nYou have been listed as an author on the manuscript submission "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nPlease allow us to add your ORCID id to this submission and also to add the submission to your ORCID profile on publication.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<br>\n<a href="{$authorOrcidUrl}" style="display: inline-flex; align-items: center; background-color: white; text-align: center; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: 2px solid #d7d4d4;"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\nClick here to verify your account with ORCID: <a href="{$authorOrcidUrl}">{$authorOrcidUrl}.</a>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$contextName}</a><br/>\n<br>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(25, 'USER_ROLE_ASSIGNMENT_INVITATION', 'en', 'User Invited to Role Notification', 'You are invited to new roles', '<div class=''email-container''>    <div class=''email-header''>        <h2>Invitation to New Role</h2>    </div>    <div class=''email-content''>        <p>Dear {$recipientName},</p>        <p>In light of your expertise, you have been invited by {$inviterName} to take on new roles at {$contextName}</p>        <p>At {$contextName}, we value your privacy. As such, we have taken steps to ensure that we are fully GDPR compliant. These steps include you being accountable to enter your own data and choosing who can see what information. For additional information on how we handled your data, please refer to our Privacy Policy.</p>        <div>{$existingRoles}</div>        <div>{$rolesAdded}</div>        <p>On accepting the invite, you will be redirected to {$contextName}.</p>        <p>Feel free to contact me with any questions about the process.</p>        <p><a href=''{$acceptUrl}'' class=''btn btn-accept''>Accept Invitation</a></p>        <p><a href=''{$declineUrl}'' class=''btn btn-decline''>Decline Invitation</a></p>        <p>Kind regards,</p>        <p>{$contextName}</p>    </div></div><style>{$emailTemplateStyle}</style>'),
(26, 'USER_ROLE_END', 'en', 'User Role Ended Notification', 'You have been removed from a role', '<div class=''email-container''>    <div class=''email-header''>        <h2>Removed from a Role</h2>    </div>    <div class=''email-content''>        <p>Dear {$recipientName},</p>        <p>Thank you very much for your participation in the role of {$roleRemoved} at {$contextName}.</p>        <p>This is a notice to let you know that you have been removed from the following role at {$contextName}: <b>{$roleRemoved}</b>.</p>        <p>Your account with {$contextName} is still active and any other roles you previously held are still active.</p>        <p>Feel free to contact me with any questions about the process.</p>        <p>Kind regards,</p>        <p>{$contextName}</p>    </div></div><style>{$emailTemplateStyle}</style>'),
(27, 'ORCID_REQUEST_UPDATE_SCOPE', 'en', 'orcidRequestUpdateScope', 'Requesting updated ORCID record access', 'Dear {$recipientName},<br>\n<br>\nYou are listed as a contributor (author or reviewer) on the manuscript submission "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nYou have previously authorized {$contextName} to list your ORCID id on the site, and we require updateded permissions to add your contribution to your ORCID profile.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<br>\n<a href="{$authorOrcidUrl}" style="display: inline-flex; align-items: center; background-color: white; text-align: center; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: 2px solid #d7d4d4;"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\nClick here to update your account with ORCID: <a href="{$authorOrcidUrl}">{$authorOrcidUrl}.</a>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$contextName}</a><br/>\n<br>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n');

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_settings`
--

CREATE TABLE `email_templates_settings` (
  `email_template_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`email_template_setting_id`),
  UNIQUE KEY `email_templates_settings_unique` (`email_id`,`locale`,`setting_name`),
  KEY `email_templates_settings_email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about custom email templates, including localized properties such as the subject and body.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log`
--

CREATE TABLE `event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT 'NULL if it''s system or automated event',
  `date_logged` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `message` text,
  `is_translated` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `event_log_user_id` (`user_id`),
  KEY `event_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all events related to an object like a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log_settings`
--

CREATE TABLE `event_log_settings` (
  `event_log_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`event_log_setting_id`),
  UNIQUE KEY `event_log_settings_unique` (`log_id`,`setting_name`,`locale`),
  KEY `event_log_settings_log_id` (`log_id`),
  KEY `event_log_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about an event log entry. This data is commonly used to display information about an event to a user.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all failed jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `mimetype` varchar(255) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records information in the database about files tracked by the system, linking them to the local filesystem.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `filters`
--

CREATE TABLE `filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_group_id` bigint(20) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `is_template` smallint(6) NOT NULL DEFAULT '0',
  `parent_filter_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`),
  KEY `filters_filter_group_id` (`filter_group_id`),
  KEY `filters_context_id` (`context_id`),
  KEY `filters_parent_filter_id` (`parent_filter_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filters represent a transformation of a supported piece of data from one form to another, such as a PHP object into an XML document.' AUTO_INCREMENT=13 ;

--
-- Dumping data for table `filters`
--

INSERT INTO `filters` VALUES
(1, 1, NULL, 'Crossref XML preprint export', 'APP\\plugins\\generic\\crossref\\filter\\PreprintCrossrefXmlFilter', 0, NULL, 0),
(2, 2, NULL, 'Extract metadata from a(n) Submission', 'APP\\plugins\\metadata\\dc11\\filter\\Dc11SchemaPreprintAdapter', 0, NULL, 0),
(3, 3, NULL, 'Native XML submission export', 'APP\\plugins\\importexport\\native\\filter\\PreprintNativeXmlFilter', 0, NULL, 0),
(4, 4, NULL, 'Native XML submission import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPreprintFilter', 0, NULL, 0),
(5, 5, NULL, 'Native XML author export', 'APP\\plugins\\importexport\\native\\filter\\AuthorNativeXmlFilter', 0, NULL, 0),
(6, 6, NULL, 'Native XML author import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlAuthorFilter', 0, NULL, 0),
(7, 8, NULL, 'Native XML submission file import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPreprintFileFilter', 0, NULL, 0),
(8, 7, NULL, 'Native XML submission file export', 'PKP\\plugins\\importexport\\native\\filter\\SubmissionFileNativeXmlFilter', 0, NULL, 0),
(9, 9, NULL, 'Native XML representation export', 'APP\\plugins\\importexport\\native\\filter\\PreprintGalleyNativeXmlFilter', 0, NULL, 0),
(10, 10, NULL, 'Native XML representation import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPreprintGalleyFilter', 0, NULL, 0),
(11, 11, NULL, 'Native XML Publication export', 'APP\\plugins\\importexport\\native\\filter\\PublicationNativeXmlFilter', 0, NULL, 0),
(12, 12, NULL, 'Native XML publication import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPublicationFilter', 0, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `filter_groups`
--

CREATE TABLE `filter_groups` (
  `filter_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `input_type` varchar(255) DEFAULT NULL,
  `output_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`filter_group_id`),
  UNIQUE KEY `filter_groups_symbolic` (`symbolic`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filter groups are used to organized filters into named sets, which can be retrieved by the application for invocation.' AUTO_INCREMENT=13 ;

--
-- Dumping data for table `filter_groups`
--

INSERT INTO `filter_groups` VALUES
(1, 'preprint=>crossref-xml', 'plugins.importexport.crossref.displayName', 'plugins.importexport.crossref.description', 'class::classes.submission.Submission[]', 'xml::schema(https://www.crossref.org/schemas/crossref5.4.0.xsd)'),
(2, 'preprint=>dc11', 'plugins.metadata.dc11.preprintAdapter.displayName', 'plugins.metadata.dc11.preprintAdapter.description', 'class::classes.submission.Submission', 'metadata::APP\\plugins\\metadata\\dc11\\schema\\Dc11Schema(PREPRINT)'),
(3, 'preprint=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.submission.Submission[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(4, 'native-xml=>preprint', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.submission.Submission[]'),
(5, 'author=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.author.Author[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(6, 'native-xml=>author', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.author.Author[]'),
(7, 'SubmissionFile=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.submissionFile.SubmissionFile', 'xml::schema(plugins/importexport/native/native.xsd)'),
(8, 'native-xml=>SubmissionFile', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.submissionFile.SubmissionFile[]'),
(9, 'preprint-galley=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.galley.Galley', 'xml::schema(plugins/importexport/native/native.xsd)'),
(10, 'native-xml=>PreprintGalley', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.galley.Galley[]'),
(11, 'publication=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.publication.Publication', 'xml::schema(plugins/importexport/native/native.xsd)'),
(12, 'native-xml=>Publication', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.publication.Publication[]');

-- --------------------------------------------------------

--
-- Table structure for table `filter_settings`
--

CREATE TABLE `filter_settings` (
  `filter_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`filter_setting_id`),
  UNIQUE KEY `filter_settings_unique` (`filter_id`,`locale`,`setting_name`),
  KEY `filter_settings_id` (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about filters, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genres`
--

CREATE TABLE `genres` (
  `genre_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `seq` bigint(20) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1',
  `category` bigint(20) NOT NULL DEFAULT '1',
  `dependent` smallint(6) NOT NULL DEFAULT '0',
  `supplementary` smallint(6) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Whether or not at least one file of this genre is required for a new submission.',
  `entry_key` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`genre_id`),
  KEY `genres_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The types of submission files configured for each context, such as Article Text, Data Set, Transcript, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genre_settings`
--

CREATE TABLE `genre_settings` (
  `genre_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `genre_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`genre_setting_id`),
  UNIQUE KEY `genre_settings_unique` (`genre_id`,`locale`,`setting_name`),
  KEY `genre_settings_genre_id` (`genre_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about file genres, including localized properties such as the genre name.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `highlights`
--

CREATE TABLE `highlights` (
  `highlight_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `sequence` bigint(20) NOT NULL,
  `url` varchar(2047) NOT NULL,
  PRIMARY KEY (`highlight_id`),
  KEY `highlights_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Highlights are featured items that can be presented to users, for example on the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `highlight_settings`
--

CREATE TABLE `highlight_settings` (
  `highlight_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `highlight_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`highlight_setting_id`),
  UNIQUE KEY `highlight_settings_unique` (`highlight_id`,`locale`,`setting_name`),
  KEY `highlight_settings_highlight_id` (`highlight_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about highlights, including localized properties like title and description.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institutions`
--

CREATE TABLE `institutions` (
  `institution_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL COMMENT 'ROR (Research Organization Registry) ID',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`institution_id`),
  KEY `institutions_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Institutions for statistics and subscriptions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_ip`
--

CREATE TABLE `institution_ip` (
  `institution_ip_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `ip_string` varchar(40) NOT NULL,
  `ip_start` bigint(20) NOT NULL,
  `ip_end` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`institution_ip_id`),
  KEY `institution_ip_institution_id` (`institution_id`),
  KEY `institution_ip_start` (`ip_start`),
  KEY `institution_ip_end` (`ip_end`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records IP address ranges and associates them with institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_settings`
--

CREATE TABLE `institution_settings` (
  `institution_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`institution_setting_id`),
  UNIQUE KEY `institution_settings_unique` (`institution_id`,`locale`,`setting_name`),
  KEY `institution_settings_institution_id` (`institution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about institutions, including localized properties like names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `invitations`
--

CREATE TABLE `invitations` (
  `invitation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key_hash` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `inviter_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime DEFAULT NULL,
  `payload` json DEFAULT NULL,
  `status` enum('INITIALIZED','PENDING','ACCEPTED','DECLINED','CANCELLED') NOT NULL,
  `email` varchar(255) DEFAULT NULL COMMENT 'When present, the email address of the invitation recipient; when null, user_id must be set and the email can be fetched from the users table.',
  `context_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`invitation_id`),
  KEY `invitations_user_id` (`user_id`),
  KEY `invitations_inviter_id` (`inviter_id`),
  KEY `invitations_context_id` (`context_id`),
  KEY `invitations_status_context_id_user_id_type_index` (`status`,`context_id`,`user_id`,`type`),
  KEY `invitations_expiry_date_index` (`expiry_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Invitations are sent to request a person (by email) to allow them to accept or reject an operation or position, such as a board membership or a submission peer review.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All pending or in-progress jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Job batches allow jobs to be collected into groups for managed processing.';

-- --------------------------------------------------------

--
-- Table structure for table `library_files`
--

CREATE TABLE `library_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `original_file_name` varchar(255) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `type` smallint(6) NOT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `public_access` smallint(6) DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `library_files_context_id` (`context_id`),
  KEY `library_files_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Library files can be associated with the context (press/server/journal) or with individual submissions, and are typically forms, agreements, and other administrative documents that are not part of the scholarly content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `library_file_settings`
--

CREATE TABLE `library_file_settings` (
  `library_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object|date)',
  PRIMARY KEY (`library_file_setting_id`),
  UNIQUE KEY `library_file_settings_unique` (`file_id`,`locale`,`setting_name`),
  KEY `library_file_settings_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about library files, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_context`
--

CREATE TABLE `metrics_context` (
  `metrics_context_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_context_id`),
  KEY `metrics_context_load_id` (`load_id`),
  KEY `metrics_context_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views of the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_daily`
--

CREATE TABLE `metrics_counter_submission_daily` (
  `metrics_counter_submission_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_daily_id`),
  UNIQUE KEY `msd_uc_load_id_context_id_submission_id_date` (`load_id`,`context_id`,`submission_id`,`date`),
  KEY `msd_load_id` (`load_id`),
  KEY `metrics_counter_submission_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_daily_submission_id` (`submission_id`),
  KEY `msd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_daily`
--

CREATE TABLE `metrics_counter_submission_institution_daily` (
  `metrics_counter_submission_institution_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_daily_id`),
  UNIQUE KEY `msid_uc_load_id_context_id_submission_id_institution_id_date` (`load_id`,`context_id`,`submission_id`,`institution_id`,`date`),
  KEY `msid_load_id` (`load_id`),
  KEY `msid_context_id` (`context_id`),
  KEY `msid_submission_id` (`submission_id`),
  KEY `msid_institution_id` (`institution_id`),
  KEY `msid_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_monthly`
--

CREATE TABLE `metrics_counter_submission_institution_monthly` (
  `metrics_counter_submission_institution_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_monthly_id`),
  UNIQUE KEY `msim_uc_context_id_submission_id_institution_id_month` (`context_id`,`submission_id`,`institution_id`,`month`),
  KEY `msim_context_id` (`context_id`),
  KEY `msim_submission_id` (`submission_id`),
  KEY `msim_institution_id` (`institution_id`),
  KEY `msim_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_monthly`
--

CREATE TABLE `metrics_counter_submission_monthly` (
  `metrics_counter_submission_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_monthly_id`),
  UNIQUE KEY `msm_uc_context_id_submission_id_month` (`context_id`,`submission_id`,`month`),
  KEY `metrics_counter_submission_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_monthly_submission_id` (`submission_id`),
  KEY `msm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission`
--

CREATE TABLE `metrics_submission` (
  `metrics_submission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `file_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_id`),
  KEY `ms_load_id` (`load_id`),
  KEY `metrics_submission_context_id` (`context_id`),
  KEY `metrics_submission_submission_id` (`submission_id`),
  KEY `metrics_submission_representation_id` (`representation_id`),
  KEY `metrics_submission_submission_file_id` (`submission_file_id`),
  KEY `ms_context_id_submission_id_assoc_type_file_type` (`context_id`,`submission_id`,`assoc_type`,`file_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_daily`
--

CREATE TABLE `metrics_submission_geo_daily` (
  `metrics_submission_geo_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_daily_id`),
  UNIQUE KEY `msgd_uc_load_context_submission_c_r_c_date` (`load_id`,`context_id`,`submission_id`,`country`,`region`,`city`(80),`date`),
  KEY `msgd_load_id` (`load_id`),
  KEY `msgd_context_id` (`context_id`),
  KEY `msgd_submission_id` (`submission_id`),
  KEY `msgd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_monthly`
--

CREATE TABLE `metrics_submission_geo_monthly` (
  `metrics_submission_geo_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `month` int(11) NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_monthly_id`),
  UNIQUE KEY `msgm_uc_context_submission_c_r_c_month` (`context_id`,`submission_id`,`country`,`region`,`city`(80),`month`),
  KEY `msgm_context_id` (`context_id`),
  KEY `msgm_submission_id` (`submission_id`),
  KEY `msgm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menus`
--

CREATE TABLE `navigation_menus` (
  `navigation_menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `area_name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`navigation_menu_id`),
  KEY `navigation_menus_context_id` (`context_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menus on the website are installed with the software as a default set, and can be customized.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `navigation_menus`
--

INSERT INTO `navigation_menus` VALUES
(1, NULL, 'user', 'User Navigation Menu');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_items`
--

CREATE TABLE `navigation_menu_items` (
  `navigation_menu_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `path` varchar(255) DEFAULT '',
  `type` varchar(255) DEFAULT '',
  PRIMARY KEY (`navigation_menu_item_id`),
  KEY `navigation_menu_items_context_id` (`context_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menu items are single elements within a navigation menu.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_items`
--

INSERT INTO `navigation_menu_items` VALUES
(1, NULL, NULL, 'NMI_TYPE_USER_REGISTER'),
(2, NULL, NULL, 'NMI_TYPE_USER_LOGIN'),
(3, NULL, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(4, NULL, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(5, NULL, NULL, 'NMI_TYPE_USER_PROFILE'),
(6, NULL, NULL, 'NMI_TYPE_ADMINISTRATION'),
(7, NULL, NULL, 'NMI_TYPE_USER_LOGOUT');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignments`
--

CREATE TABLE `navigation_menu_item_assignments` (
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `navigation_menu_id` bigint(20) NOT NULL,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT '0',
  PRIMARY KEY (`navigation_menu_item_assignment_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_id` (`navigation_menu_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_item_id` (`navigation_menu_item_id`),
  KEY `navigation_menu_item_assignments_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Links navigation menu items to navigation menus.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_assignments`
--

INSERT INTO `navigation_menu_item_assignments` VALUES
(1, 1, 1, NULL, 0),
(2, 1, 2, NULL, 1),
(3, 1, 3, NULL, 2),
(4, 1, 4, 3, 0),
(5, 1, 5, 3, 1),
(6, 1, 6, 3, 2),
(7, 1, 7, 3, 3);

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignment_settings`
--

CREATE TABLE `navigation_menu_item_assignment_settings` (
  `navigation_menu_item_assignment_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_assignment_setting_id`),
  UNIQUE KEY `navigation_menu_item_assignment_settings_unique` (`navigation_menu_item_assignment_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_assignment_settings_n_m_i_a_id` (`navigation_menu_item_assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu item assignments to navigation menus, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_settings`
--

CREATE TABLE `navigation_menu_item_settings` (
  `navigation_menu_item_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_setting_id`),
  UNIQUE KEY `navigation_menu_item_settings_unique` (`navigation_menu_item_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_settings_navigation_menu_item_id` (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu items, including localized content such as names.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_settings`
--

INSERT INTO `navigation_menu_item_settings` VALUES
(1, 1, '', 'titleLocaleKey', 'navigation.register', 'string'),
(2, 2, '', 'titleLocaleKey', 'navigation.login', 'string'),
(3, 3, '', 'titleLocaleKey', '{$loggedInUsername}', 'string'),
(4, 4, '', 'titleLocaleKey', 'navigation.dashboard', 'string'),
(5, 5, '', 'titleLocaleKey', 'common.viewProfile', 'string'),
(6, 6, '', 'titleLocaleKey', 'navigation.admin', 'string'),
(7, 7, '', 'titleLocaleKey', 'user.logOut', 'string');

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `note_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `contents` text,
  PRIMARY KEY (`note_id`),
  KEY `notes_user_id` (`user_id`),
  KEY `notes_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Notes allow users to annotate associated entities, such as submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `notification_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `level` bigint(20) NOT NULL,
  `type` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `notifications_context_id` (`context_id`),
  KEY `notifications_user_id` (`user_id`),
  KEY `notifications_context_id_user_id` (`context_id`,`user_id`,`level`),
  KEY `notifications_context_id_level` (`context_id`,`level`),
  KEY `notifications_assoc` (`assoc_type`,`assoc_id`),
  KEY `notifications_user_id_level` (`user_id`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='User notifications created during certain operations.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `notification_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `locale` varchar(28) DEFAULT NULL,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`notification_setting_id`),
  UNIQUE KEY `notification_settings_unique` (`notification_id`,`locale`,`setting_name`),
  KEY `notification_settings_notification_id` (`notification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about notifications, including localized properties.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_subscription_settings`
--

CREATE TABLE `notification_subscription_settings` (
  `setting_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`setting_id`),
  KEY `notification_subscription_settings_user_id` (`user_id`),
  KEY `notification_subscription_settings_context` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which email notifications a user has chosen to unsubscribe from.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oai_resumption_tokens`
--

CREATE TABLE `oai_resumption_tokens` (
  `oai_resumption_token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(32) NOT NULL,
  `expire` bigint(20) NOT NULL,
  `record_offset` int(11) NOT NULL,
  `params` text,
  PRIMARY KEY (`oai_resumption_token_id`),
  UNIQUE KEY `oai_resumption_tokens_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='OAI resumption tokens are used to allow for pagination of large result sets into manageable pieces.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `plugin_settings`
--

CREATE TABLE `plugin_settings` (
  `plugin_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(80) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `setting_name` varchar(80) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`plugin_setting_id`),
  UNIQUE KEY `plugin_settings_unique` (`plugin_name`,`context_id`,`setting_name`),
  KEY `plugin_settings_context_id` (`context_id`),
  KEY `plugin_settings_plugin_name` (`plugin_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about plugins, including localized properties. This table is frequently used to store plugin-specific configuration.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `plugin_settings`
--

INSERT INTO `plugin_settings` VALUES
(1, 'defaultthemeplugin', NULL, 'enabled', '1', 'bool'),
(2, 'tinymceplugin', NULL, 'enabled', '1', 'bool'),
(3, 'usageeventplugin', NULL, 'enabled', '1', 'bool'),
(4, 'developedbyblockplugin', NULL, 'enabled', '0', 'bool'),
(5, 'developedbyblockplugin', NULL, 'seq', '0', 'int'),
(6, 'languagetoggleblockplugin', NULL, 'enabled', '1', 'bool'),
(7, 'languagetoggleblockplugin', NULL, 'seq', '4', 'int');

-- --------------------------------------------------------

--
-- Table structure for table `publications`
--

CREATE TABLE `publications` (
  `publication_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `access_status` bigint(20) DEFAULT '0',
  `date_published` date DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `primary_contact_id` bigint(20) DEFAULT NULL,
  `section_id` bigint(20) DEFAULT NULL,
  `submission_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `url_path` varchar(64) DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`publication_id`),
  KEY `publications_author_id` (`primary_contact_id`),
  KEY `publications_section_id` (`section_id`),
  KEY `publications_submission_id` (`submission_id`),
  KEY `publications_url_path` (`url_path`),
  KEY `publications_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each publication is one version of a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_categories`
--

CREATE TABLE `publication_categories` (
  `publication_category_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `category_id` bigint(20) NOT NULL,
  PRIMARY KEY (`publication_category_id`),
  UNIQUE KEY `publication_categories_id` (`publication_id`,`category_id`),
  KEY `publication_categories_publication_id` (`publication_id`),
  KEY `publication_categories_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates publications (and thus submissions) with categories.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galleys`
--

CREATE TABLE `publication_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(28) DEFAULT NULL,
  `publication_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `remote_url` varchar(2047) DEFAULT NULL,
  `is_approved` tinyint(4) NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `publication_galleys_publication_id` (`publication_id`),
  KEY `publication_galleys_submission_file_id` (`submission_file_id`),
  KEY `publication_galleys_url_path` (`url_path`),
  KEY `publication_galleys_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Publication galleys are representations of publications in a particular format, such as a PDF file.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galley_settings`
--

CREATE TABLE `publication_galley_settings` (
  `publication_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  PRIMARY KEY (`publication_galley_setting_id`),
  UNIQUE KEY `publication_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `publication_galley_settings_galley_id` (`galley_id`),
  KEY `publication_galley_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publication galleys, including localized properties such as labels.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_settings`
--

CREATE TABLE `publication_settings` (
  `publication_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_setting_id`),
  UNIQUE KEY `publication_settings_unique` (`publication_id`,`locale`,`setting_name`),
  KEY `publication_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publications, including localized properties such as the title and abstract.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queries`
--

CREATE TABLE `queries` (
  `query_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `closed` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`query_id`),
  KEY `queries_assoc_id` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Discussions, usually related to a submission, created by editors, authors and other editorial staff.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `query_participants`
--

CREATE TABLE `query_participants` (
  `query_participant_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `query_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`query_participant_id`),
  UNIQUE KEY `query_participants_unique` (`query_id`,`user_id`),
  KEY `query_participants_query_id` (`query_id`),
  KEY `query_participants_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The users assigned to a discussion.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reviewer_suggestions`
--

CREATE TABLE `reviewer_suggestions` (
  `reviewer_suggestion_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `suggesting_user_id` bigint(20) DEFAULT NULL COMMENT 'The user/author who has made the suggestion',
  `submission_id` bigint(20) NOT NULL COMMENT 'Submission at which the suggestion was made',
  `email` varchar(255) NOT NULL COMMENT 'Suggested reviewer email address',
  `orcid_id` varchar(255) DEFAULT NULL COMMENT 'Suggested reviewer optional Orcid Id',
  `approved_at` timestamp NULL DEFAULT NULL COMMENT 'If and when the suggestion approved to add/invite suggested_reviewer',
  `approver_id` bigint(20) DEFAULT NULL COMMENT 'The user who has approved the suggestion',
  `reviewer_id` bigint(20) DEFAULT NULL COMMENT 'The reviewer who has been added/invited through this suggestion',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`reviewer_suggestion_id`),
  KEY `reviewer_suggestions_suggesting_user_id` (`suggesting_user_id`),
  KEY `reviewer_suggestions_submission_id` (`submission_id`),
  KEY `reviewer_suggestions_approver_id_foreign` (`approver_id`),
  KEY `reviewer_suggestions_reviewer_id_foreign` (`reviewer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Author suggested reviewers at the submission time' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reviewer_suggestion_settings`
--

CREATE TABLE `reviewer_suggestion_settings` (
  `reviewer_suggestion_id` bigint(20) NOT NULL COMMENT 'The foreign key mapping of this setting to reviewer_suggestions table',
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  UNIQUE KEY `reviewer_suggestion_settings_unique` (`reviewer_suggestion_id`,`locale`,`setting_name`),
  KEY `reviewer_suggestion_settings_reviewer_suggestion_id` (`reviewer_suggestion_id`),
  KEY `reviewer_suggestion_settings_locale_setting_name_index` (`setting_name`,`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Reviewer suggestion settings table to contain multilingual or extra information';

-- --------------------------------------------------------

--
-- Table structure for table `review_assignments`
--

CREATE TABLE `review_assignments` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `reviewer_id` bigint(20) NOT NULL,
  `competing_interests` text,
  `recommendation` smallint(6) DEFAULT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,
  `date_completed` datetime DEFAULT NULL,
  `date_considered` datetime DEFAULT NULL,
  `date_acknowledged` datetime DEFAULT NULL,
  `date_due` datetime DEFAULT NULL,
  `date_response_due` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reminder_was_automatic` smallint(6) NOT NULL DEFAULT '0',
  `declined` smallint(6) NOT NULL DEFAULT '0',
  `cancelled` smallint(6) NOT NULL DEFAULT '0',
  `date_cancelled` datetime DEFAULT NULL,
  `date_rated` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `quality` smallint(6) DEFAULT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `review_method` smallint(6) NOT NULL DEFAULT '1',
  `round` smallint(6) NOT NULL DEFAULT '1',
  `step` smallint(6) NOT NULL DEFAULT '1',
  `review_form_id` bigint(20) DEFAULT NULL,
  `considered` smallint(6) DEFAULT NULL,
  `request_resent` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`review_id`),
  KEY `review_assignments_submission_id` (`submission_id`),
  KEY `review_assignments_reviewer_id` (`reviewer_id`),
  KEY `review_assignment_reviewer_round` (`review_round_id`,`reviewer_id`),
  KEY `review_assignments_form_id` (`review_form_id`),
  KEY `review_assignments_reviewer_review` (`reviewer_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about peer review assignments for all submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_assignment_settings`
--

CREATE TABLE `review_assignment_settings` (
  `review_assignment_settings_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key.',
  `review_id` bigint(20) NOT NULL COMMENT 'Foreign key referencing record in review_assignments table',
  `locale` varchar(28) DEFAULT NULL COMMENT 'Locale key.',
  `setting_name` varchar(255) NOT NULL COMMENT 'Name of settings record.',
  `setting_value` mediumtext COMMENT 'Settings value.',
  PRIMARY KEY (`review_assignment_settings_id`),
  UNIQUE KEY `review_assignment_settings_unique` (`review_id`,`locale`,`setting_name`),
  KEY `review_assignment_settings_review_id` (`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_files`
--

CREATE TABLE `review_files` (
  `review_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_id` bigint(20) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_file_id`),
  UNIQUE KEY `review_files_unique` (`review_id`,`submission_file_id`),
  KEY `review_files_review_id` (`review_id`),
  KEY `review_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of the submission files made available to each assigned reviewer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_forms`
--

CREATE TABLE `review_forms` (
  `review_form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `is_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Review forms provide custom templates for peer reviews with several types of questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_elements`
--

CREATE TABLE `review_form_elements` (
  `review_form_element_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `element_type` bigint(20) DEFAULT NULL,
  `required` smallint(6) DEFAULT NULL,
  `included` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_element_id`),
  KEY `review_form_elements_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form element represents a single question on a review form.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_element_settings`
--

CREATE TABLE `review_form_element_settings` (
  `review_form_element_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_element_setting_id`),
  UNIQUE KEY `review_form_element_settings_unique` (`review_form_element_id`,`locale`,`setting_name`),
  KEY `review_form_element_settings_review_form_element_id` (`review_form_element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review form elements, including localized content such as question text.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_responses`
--

CREATE TABLE `review_form_responses` (
  `review_form_response_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `review_id` bigint(20) NOT NULL,
  `response_type` varchar(6) DEFAULT NULL,
  `response_value` text,
  PRIMARY KEY (`review_form_response_id`),
  KEY `review_form_responses_review_form_element_id` (`review_form_element_id`),
  KEY `review_form_responses_review_id` (`review_id`),
  KEY `review_form_responses_unique` (`review_form_element_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form response records a reviewer''s answer to a review form element associated with a peer review.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_settings`
--

CREATE TABLE `review_form_settings` (
  `review_form_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_setting_id`),
  UNIQUE KEY `review_form_settings_unique` (`review_form_id`,`locale`,`setting_name`),
  KEY `review_form_settings_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review forms, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_rounds`
--

CREATE TABLE `review_rounds` (
  `review_round_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) NOT NULL,
  `review_revision` bigint(20) DEFAULT NULL,
  `status` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`review_round_id`),
  UNIQUE KEY `review_rounds_submission_id_stage_id_round_pkey` (`submission_id`,`stage_id`,`round`),
  KEY `review_rounds_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Peer review assignments are organized into multiple rounds on a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_round_files`
--

CREATE TABLE `review_round_files` (
  `review_round_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_round_file_id`),
  UNIQUE KEY `review_round_files_unique` (`submission_id`,`review_round_id`,`submission_file_id`),
  KEY `review_round_files_submission_id` (`submission_id`),
  KEY `review_round_files_review_round_id` (`review_round_id`),
  KEY `review_round_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records the files made available to reviewers for a round of reviews. These can be further customized on a per review basis with review_files.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rors`
--

CREATE TABLE `rors` (
  `ror_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ror` varchar(255) NOT NULL,
  `display_locale` varchar(28) NOT NULL,
  `is_active` smallint(6) NOT NULL DEFAULT '1',
  `search_phrase` mediumtext,
  PRIMARY KEY (`ror_id`),
  UNIQUE KEY `rors_unique` (`ror`),
  KEY `rors_display_locale` (`display_locale`),
  KEY `rors_is_active` (`is_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Ror registry dataset cache' AUTO_INCREMENT=120197 ;

--
-- Dumping data for table `rors`
--

INSERT INTO `rors` VALUES
(1, 'https://ror.org/0002pcv65', 'en', 1, 'https://ror.org/0002pcv65 National University of Río Cuarto Universidad Nacional de Río Cuarto'),
(2, 'https://ror.org/0003ewr82', 'no_lang_code', 1, 'https://ror.org/0003ewr82 Bundelkhand University'),
(3, 'https://ror.org/0004gzs06', 'en', 1, 'https://ror.org/0004gzs06 Hokuyukai Neurology Hospital 医療法人北祐会 北祐会神経内科病院'),
(4, 'https://ror.org/0006swh35', 'en', 1, 'https://ror.org/0006swh35 First Affiliated Hospital of Xiamen University 厦门大学附属第一医院'),
(5, 'https://ror.org/000849h34', 'en', 1, 'https://ror.org/000849h34 Liverpool Heart and Chest Hospital'),
(6, 'https://ror.org/0008s4w86', 'en', 1, 'https://ror.org/0008s4w86 Piedmont Atlanta Hospital'),
(7, 'https://ror.org/000917t60', 'en', 1, 'https://ror.org/000917t60 Autonomous University of San Luis Potosí Universidad Autónoma de San Luis Potosí'),
(8, 'https://ror.org/000a2sx58', 'en', 1, 'https://ror.org/000a2sx58 Centre for European Policy Studies'),
(9, 'https://ror.org/000bvba82', 'no_lang_code', 1, 'https://ror.org/000bvba82 Biomarker Technologies (China) 百迈客生物科技'),
(10, 'https://ror.org/000bxzc63', 'en', 1, 'https://ror.org/000bxzc63 Max Planck Institute for Medical Research Max-Planck-Institut für Medizinische Forschung'),
(11, 'https://ror.org/000c39f30', 'en', 1, 'https://ror.org/000c39f30 Al Ain Hospital مستشفى العين'),
(12, 'https://ror.org/000e3j968', 'tr', 1, 'https://ror.org/000e3j968 Türkiye Yüksek İhtisas Hastanesi'),
(13, 'https://ror.org/000ezn412', 'en', 1, 'https://ror.org/000ezn412 Sawai Man Singh Hospital'),
(14, 'https://ror.org/000f32327', 'en', 1, 'https://ror.org/000f32327 Saint Vincent Hospital'),
(15, 'https://ror.org/000fvwg06', 'en', 1, 'https://ror.org/000fvwg06 Queen Sirikit National Institute of Child Health'),
(16, 'https://ror.org/000jd8a09', 'no_lang_code', 1, 'https://ror.org/000jd8a09 Mafraq Hospital مستشفى المفرق'),
(17, 'https://ror.org/000kb2a90', 'en', 1, 'https://ror.org/000kb2a90 Mymensingh Medical College Hospital ময়মনসিংহ মেডিকেল কলেজ'),
(18, 'https://ror.org/000ke5995', 'en', 1, 'https://ror.org/000ke5995 Western Galilee Hospital'),
(19, 'https://ror.org/000p7hm12', 'en', 1, 'https://ror.org/000p7hm12 National Skin Centre'),
(20, 'https://ror.org/000pfrh90', 'en', 1, 'https://ror.org/000pfrh90 Baptist Hospital of Miami'),
(21, 'https://ror.org/000qzf213', 'en', 1, 'https://ror.org/000qzf213 Korea University of Science and Technology 과학기술연합대학원대학교'),
(22, 'https://ror.org/000rgm762', 'en', 1, 'https://ror.org/000rgm762 VA Connecticut Healthcare System'),
(23, 'https://ror.org/000rs7940', 'fr', 1, 'https://ror.org/000rs7940 Hôpital de la Providence'),
(24, 'https://ror.org/000rxe202', 'no_lang_code', 1, 'https://ror.org/000rxe202 Medical Decision Logic'),
(25, 'https://ror.org/000tm9s39', 'fr', 1, 'https://ror.org/000tm9s39 Centre Hospitalier Saint-Charles'),
(26, 'https://ror.org/000tqtb97', 'no_lang_code', 1, 'https://ror.org/000tqtb97 Rafik Hariri University Hospital مستشفى رفيق الحريري الجامعي‎‎'),
(27, 'https://ror.org/000vg5909', 'en', 1, 'https://ror.org/000vg5909 Health & Medical Publishing Group'),
(28, 'https://ror.org/000vjzq57', 'en', 1, 'https://ror.org/000vjzq57 Memphis VA Medical Center'),
(29, 'https://ror.org/000vvpv33', 'en', 1, 'https://ror.org/000vvpv33 Social Insurance Yokohama Central Hospital 横浜中央病院'),
(30, 'https://ror.org/000yct867', 'en', 1, 'https://ror.org/000yct867 Bridgeport Hospital'),
(31, 'https://ror.org/000ywep40', 'en', 1, 'https://ror.org/000ywep40 NHS Tayside'),
(32, 'https://ror.org/000zamq06', 'en', 1, 'https://ror.org/000zamq06 Franklin W. Olin College of Engineering'),
(33, 'https://ror.org/0011azt19', 'en', 1, 'https://ror.org/0011azt19 Saint Agnes Hospital'),
(34, 'https://ror.org/0015hpp74', 'en', 1, 'https://ror.org/0015hpp74 Hannah Research Foundation'),
(35, 'https://ror.org/0015hye09', 'no_lang_code', 1, 'https://ror.org/0015hye09 Tokyo Metropolitan Ohtsuka Hospital 東京都立大塚病院'),
(36, 'https://ror.org/0015r4831', 'en', 1, 'https://ror.org/0015r4831 Government Medical College Bhavnagar'),
(37, 'https://ror.org/00184ca40', 'no_lang_code', 1, 'https://ror.org/00184ca40 Ballard Power Systems (Canada)'),
(38, 'https://ror.org/00186jw56', 'en', 1, 'https://ror.org/00186jw56 Northwestern Health Sciences University'),
(39, 'https://ror.org/00186nd07', 'en', 1, 'https://ror.org/00186nd07 Gajara Raja Medical College'),
(40, 'https://ror.org/00190t495', 'en', 1, 'https://ror.org/00190t495 National Center for Complementary and Integrative Health'),
(41, 'https://ror.org/001b4cb05', 'en', 1, 'https://ror.org/001b4cb05 National University of Trujillo Universidad Nacional de Trujillo'),
(42, 'https://ror.org/001be0c19', 'en', 1, 'https://ror.org/001be0c19 Centennial Medical Center'),
(43, 'https://ror.org/001c9fg13', 'ro', 1, 'https://ror.org/001c9fg13 Unitatea Executiva Pentru Finantarea Invatamantului Superior Si A Cercetarii Stiintifice Universitare'),
(44, 'https://ror.org/001c9gn96', 'en', 1, 'https://ror.org/001c9gn96 University of Science and Arts of Oklahoma'),
(45, 'https://ror.org/001g7jx32', 'en', 1, 'https://ror.org/001g7jx32 New Britain General Hospital'),
(46, 'https://ror.org/001hsnn10', 'en', 1, 'https://ror.org/001hsnn10 Medical Technology and Practice Patterns Institute'),
(47, 'https://ror.org/001hv0k59', 'en', 1, 'https://ror.org/001hv0k59 Toyota Technological Institute 豊田工業大学'),
(48, 'https://ror.org/001hz0050', 'en', 1, 'https://ror.org/001hz0050 Capital Regional District'),
(49, 'https://ror.org/001m5qg34', 'en', 1, 'https://ror.org/001m5qg34 Darent Valley Hospital'),
(50, 'https://ror.org/001rzdq81', 'no_lang_code', 1, 'https://ror.org/001rzdq81 State of The Art'),
(51, 'https://ror.org/001v19997', 'tr', 1, 'https://ror.org/001v19997 Eskişehir Osmangazi Üniversitesi Tıp Fakültesi Hastanesi'),
(52, 'https://ror.org/001v2ey71', 'en', 1, 'https://ror.org/001v2ey71 The Fourth People''s Hospital'),
(53, 'https://ror.org/001wpa366', 'fr', 1, 'https://ror.org/001wpa366 HIA du Val-de-Grâce à Paris, Hôpital d''instruction des armées du Val-de-Grâce'),
(54, 'https://ror.org/001x4vz59', 'en', 1, 'https://ror.org/001x4vz59 St Mary''s Hospital'),
(55, 'https://ror.org/001xq1j98', 'en', 1, 'https://ror.org/001xq1j98 Covenant Health'),
(56, 'https://ror.org/001yjqf23', 'en', 1, 'https://ror.org/001yjqf23 Kuang Tien General Hospital 光田綜合醫院'),
(57, 'https://ror.org/0020hse07', 'en', 1, 'https://ror.org/0020hse07 Aberdeen Maternity Hospital'),
(58, 'https://ror.org/0020x6414', 'en', 1, 'https://ror.org/0020x6414 Hunter Medical Research Institute'),
(59, 'https://ror.org/0022b3c04', 'en', 1, 'https://ror.org/0022b3c04 Nottingham City Hospital'),
(60, 'https://ror.org/00243c192', 'en', 1, 'https://ror.org/00243c192 Monroe Community Hospital'),
(61, 'https://ror.org/0024aa414', 'en', 1, 'https://ror.org/0024aa414 National Institute of Public Health 国立保健医療科学院'),
(62, 'https://ror.org/0024qhz65', 'en', 1, 'https://ror.org/0024qhz65 Bir Hospital बीर अस्पताल'),
(63, 'https://ror.org/0025e3007', 'no_lang_code', 1, 'https://ror.org/0025e3007 TIBCO Software (United States)'),
(64, 'https://ror.org/0025g8755', 'en', 1, 'https://ror.org/0025g8755 Luigi Sacco Hospital Ospedale Luigi Sacco'),
(65, 'https://ror.org/0026m8b31', 'it', 1, 'https://ror.org/0026m8b31 Ospedale San Paolo'),
(66, 'https://ror.org/00274we69', 'no_lang_code', 1, 'https://ror.org/00274we69 Himchan Hospital 부평 힘찬병원'),
(67, 'https://ror.org/0028g5429', 'en', 1, 'https://ror.org/0028g5429 Community Medical Center'),
(68, 'https://ror.org/0029a9d62', 'en', 1, 'https://ror.org/0029a9d62 California Pacific University'),
(69, 'https://ror.org/0029f7m05', 'en', 1, 'https://ror.org/0029f7m05 Geological Society of America'),
(70, 'https://ror.org/0029n1t76', 'en', 1, 'https://ror.org/0029n1t76 Southern Taiwan University of Science and Technology'),
(71, 'https://ror.org/002bjfj29', 'de', 1, 'https://ror.org/002bjfj29 München Klinik Schwabing'),
(72, 'https://ror.org/002g9dc27', 'en', 1, 'https://ror.org/002g9dc27 Inoue Hospital 井上病院'),
(73, 'https://ror.org/002gmks55', 'pt', 1, 'https://ror.org/002gmks55 Instituto Superior de Educação e Trabalho'),
(74, 'https://ror.org/002hsbm82', 'en', 1, 'https://ror.org/002hsbm82 Tufts Medical Center'),
(75, 'https://ror.org/002k8gm39', 'en', 1, 'https://ror.org/002k8gm39 Vikram University विक्रम विश्वविद्यालय'),
(76, 'https://ror.org/002ksg449', 'en', 1, 'https://ror.org/002ksg449 Mary Crowley Cancer Research Center'),
(77, 'https://ror.org/002q1t780', 'en', 1, 'https://ror.org/002q1t780 Henrietta Egleston Hospital for Children'),
(78, 'https://ror.org/002rw7y37', 'no_lang_code', 1, 'https://ror.org/002rw7y37 Aoyama Gakuin University 青山学院大学'),
(79, 'https://ror.org/002tz8e96', 'en', 1, 'https://ror.org/002tz8e96 Shaikh Zayed Hospital'),
(80, 'https://ror.org/002x0mf51', 'tr', 1, 'https://ror.org/002x0mf51 Mareşal Çakmak Askeri Hastanesi'),
(81, 'https://ror.org/002yfn631', 'en', 1, 'https://ror.org/002yfn631 Kuakini Medical Center'),
(82, 'https://ror.org/002ztb251', 'en', 1, 'https://ror.org/002ztb251 Ganesh Shankar Vidyarthi Memorial Medical College गणेश शंकर विद्यार्थी मेमोरियल मेडिकल कॉलेज'),
(83, 'https://ror.org/0030d2559', 'en', 1, 'https://ror.org/0030d2559 Escola Médico-Cirúrgica de Goa Goa Medical College'),
(84, 'https://ror.org/0031afh91', 'en', 1, 'https://ror.org/0031afh91 Henan Provincial Institute of Occupational Health 职业健康河南省研究所'),
(85, 'https://ror.org/0031nsg68', 'en', 1, 'https://ror.org/0031nsg68 Hankyong National University 한경대학교'),
(86, 'https://ror.org/0032p1p15', 'en', 1, 'https://ror.org/0032p1p15 Chubu National Hospital 中部国立病院'),
(87, 'https://ror.org/00372qc85', 'en', 1, 'https://ror.org/00372qc85 National Institute of Biomedical Imaging and Bioengineering'),
(88, 'https://ror.org/0037yf233', 'en', 1, 'https://ror.org/0037yf233 Exploratorium'),
(89, 'https://ror.org/0038gz437', 'en', 1, 'https://ror.org/0038gz437 Newman University'),
(90, 'https://ror.org/0038nst28', 'no_lang_code', 1, 'https://ror.org/0038nst28 Kwangju Christian Hospital 광주기독병원'),
(91, 'https://ror.org/003ammk23', 'en', 1, 'https://ror.org/003ammk23 Walsh University'),
(92, 'https://ror.org/003dzgw21', 'fr', 1, 'https://ror.org/003dzgw21 Centre Technique Des Industries De La Fonderie'),
(93, 'https://ror.org/003g7k569', 'no_lang_code', 1, 'https://ror.org/003g7k569 Litron Laboratories (United States)'),
(94, 'https://ror.org/003hhqx84', 'it', 1, 'https://ror.org/003hhqx84 Ospedale Antonio Cardarelli'),
(95, 'https://ror.org/003hjp881', 'pt', 1, 'https://ror.org/003hjp881 Hospital Madre Teresa'),
(96, 'https://ror.org/003j5cv40', 'en', 1, 'https://ror.org/003j5cv40 Haskins Laboratories'),
(97, 'https://ror.org/003k75717', 'en', 1, 'https://ror.org/003k75717 Advocate Health Care'),
(98, 'https://ror.org/003m0tv02', 'en', 1, 'https://ror.org/003m0tv02 Michigan Public Health Institute'),
(99, 'https://ror.org/003mpgw14', 'en', 1, 'https://ror.org/003mpgw14 St. Elisabeth Hospital'),
(100, 'https://ror.org/003mte806', 'pt', 1, 'https://ror.org/003mte806 Instituto Superior de Administração e Línguas'),
(101, 'https://ror.org/003ncyx50', 'no_lang_code', 1, 'https://ror.org/003ncyx50 Lourdes Hospital'),
(102, 'https://ror.org/003rmx748', 'en', 1, 'https://ror.org/003rmx748 Holy Spirit Northside Private Hospital'),
(103, 'https://ror.org/003sav189', 'de', 1, 'https://ror.org/003sav189 Institute for Information Technology Oldenburger Institut für Informatik'),
(104, 'https://ror.org/003sav965', 'en', 1, 'https://ror.org/003sav965 Tianjin Medical University General Hospital 天津医科大学总医院'),
(105, 'https://ror.org/003sphj24', 'en', 1, 'https://ror.org/003sphj24 Soroka Medical Center'),
(106, 'https://ror.org/003sqpd76', 'en', 1, 'https://ror.org/003sqpd76 Agruicultural Research Institute'),
(107, 'https://ror.org/003sw8164', 'en', 1, 'https://ror.org/003sw8164 Inland Hospital Sykehuset Innlandet'),
(108, 'https://ror.org/003t0xc83', 'en', 1, 'https://ror.org/003t0xc83 Glenbrook Hospital'),
(109, 'https://ror.org/003vfy751', 'fr', 1, 'https://ror.org/003vfy751 University of Burundi Université du Burundi'),
(110, 'https://ror.org/003vkcj31', 'en', 1, 'https://ror.org/003vkcj31 University of Teacher Education Fukuoka 福岡教育大学'),
(111, 'https://ror.org/003x8tf04', 'no_lang_code', 1, 'https://ror.org/003x8tf04 Profilarbed (Luxembourg)'),
(112, 'https://ror.org/004106086', 'en', 1, 'https://ror.org/004106086 Sendai Red Cross Hospital 仙台赤十字病院'),
(113, 'https://ror.org/0041bpv82', 'en', 1, 'https://ror.org/0041bpv82 Hospital Sultanah Aminah Sultanah Aminah Hospital'),
(114, 'https://ror.org/004350h06', 'en', 1, 'https://ror.org/004350h06 Saint Vincent Hospital'),
(115, 'https://ror.org/00458wv14', 'en', 1, 'https://ror.org/00458wv14 Tianjin Beichen Hospital'),
(116, 'https://ror.org/0046mja08', 'en', 1, 'https://ror.org/0046mja08 An-Najah National University جامعة النجاح الوطنية'),
(117, 'https://ror.org/0048myj07', 'it', 1, 'https://ror.org/0048myj07 Ospedale del Ceppo'),
(118, 'https://ror.org/0049erg63', 'en', 1, 'https://ror.org/0049erg63 Kookmin University 국민대학교'),
(119, 'https://ror.org/004a7s815', 'sv', 1, 'https://ror.org/004a7s815 Blekingesjukhuset'),
(120, 'https://ror.org/004cj7n30', 'en', 1, 'https://ror.org/004cj7n30 King''s Cross Hospital'),
(121, 'https://ror.org/004dwfr15', 'en', 1, 'https://ror.org/004dwfr15 Kursk State Medical University Курский государственный медицинский университет'),
(122, 'https://ror.org/004ej3g52', 'en', 1, 'https://ror.org/004ej3g52 National Defense Medical College Hospital 防衛医科大学校病院'),
(123, 'https://ror.org/004fmj330', 'no_lang_code', 1, 'https://ror.org/004fmj330 Technical Resources International (United States)'),
(124, 'https://ror.org/004gqpt18', 'de', 1, 'https://ror.org/004gqpt18 Landeskrankenhaus Feldkirch'),
(125, 'https://ror.org/004hfxk38', 'no_lang_code', 1, 'https://ror.org/004hfxk38 Theageneio General Hospital'),
(126, 'https://ror.org/004jktf35', 'en', 1, 'https://ror.org/004jktf35 Swedish Medical Center'),
(127, 'https://ror.org/004kyan19', 'en', 1, 'https://ror.org/004kyan19 Maricopa County Community College District'),
(128, 'https://ror.org/004nhy279', 'en', 1, 'https://ror.org/004nhy279 Barnet Hospital'),
(129, 'https://ror.org/004q6ee74', 'no_lang_code', 1, 'https://ror.org/004q6ee74 Technical Research Associates (United States)'),
(130, 'https://ror.org/004qj2391', 'es', 1, 'https://ror.org/004qj2391 Hospital General De Segovia'),
(131, 'https://ror.org/004rs4477', 'en', 1, 'https://ror.org/004rs4477 Masonic Medical Research Laboratory'),
(132, 'https://ror.org/004srrf86', 'en', 1, 'https://ror.org/004srrf86 Abilene Christian University Universidad Cristiana de Abilene'),
(133, 'https://ror.org/004sxt390', 'en', 1, 'https://ror.org/004sxt390 North Park University'),
(134, 'https://ror.org/004t34t94', 'no_lang_code', 1, 'https://ror.org/004t34t94 Tsuchiura Kyodo General Hospital 総合病院 土浦協同病院'),
(135, 'https://ror.org/004we6052', 'en', 1, 'https://ror.org/004we6052 Holy Family Hospital'),
(136, 'https://ror.org/004x58208', 'en', 1, 'https://ror.org/004x58208 St. John Medical Center'),
(137, 'https://ror.org/0050g6f93', 'en', 1, 'https://ror.org/0050g6f93 KKR Tohoku Kosai Hospital 東北公済病院'),
(138, 'https://ror.org/0050r1b65', 'en', 1, 'https://ror.org/0050r1b65 Third Affiliated Hospital of Southern Medical University 南方医科大学第三附属医院'),
(139, 'https://ror.org/0050ra204', 'it', 1, 'https://ror.org/0050ra204 Centro Studi Sui Sistemi Di Trasporto Spa'),
(140, 'https://ror.org/00514rc81', 'en', 1, 'https://ror.org/00514rc81 Royal Hallamshire Hospital'),
(141, 'https://ror.org/00520ze08', 'en', 1, 'https://ror.org/00520ze08 South Carolina State University'),
(142, 'https://ror.org/0055d0g64', 'en', 1, 'https://ror.org/0055d0g64 Academia de la Fuerza Aérea de los Estados Unidos United States Air Force Academy'),
(143, 'https://ror.org/0057da036', 'en', 1, 'https://ror.org/0057da036 Mercy San Juan Medical Center'),
(144, 'https://ror.org/0057s8s52', 'en', 1, 'https://ror.org/0057s8s52 John D. Dingell VA Medical Center'),
(145, 'https://ror.org/00582g326', 'en', 1, 'https://ror.org/00582g326 Indian Institute of Technology Roorkee भारतीय प्रौद्योगिकी संस्थान रुड़की இந்திய தொழில்நுட்பக் கழகம் ரூர்க்கி ఇండియన్ ఇన్స్టిట్యూట్ ఆఫ్ టెక్నాలజీ రూర్కీ ഇന്ത്യൻ ഇൻസ്റ്റിറ്റ്യൂട്ട് ഓഫ് ടെക്നോളജി റൂർക്കി'),
(146, 'https://ror.org/005927371', 'en', 1, 'https://ror.org/005927371 Ching Kuo Institute of Management and Health 經國管理暨健康學院'),
(147, 'https://ror.org/0059h1f24', 'en', 1, 'https://ror.org/0059h1f24 Prefectural University of Hiroshima 県立広島大学'),
(148, 'https://ror.org/0059hys23', 'fr', 1, 'https://ror.org/0059hys23 Hôpital Farhat Hached'),
(149, 'https://ror.org/005b2mc68', 'no_lang_code', 1, 'https://ror.org/005b2mc68 NEC (United Kingdom)'),
(150, 'https://ror.org/005ezrx44', 'en', 1, 'https://ror.org/005ezrx44 South-West State University Юго-Западный государственный университет'),
(151, 'https://ror.org/005gkfa10', 'en', 1, 'https://ror.org/005gkfa10 National Changhua University of Education 國立彰化師範大學'),
(152, 'https://ror.org/005h65c20', 'en', 1, 'https://ror.org/005h65c20 Metropolitan Hospital Center'),
(153, 'https://ror.org/005h6qd35', 'en', 1, 'https://ror.org/005h6qd35 Government Medical College'),
(154, 'https://ror.org/005k4dn45', 'en', 1, 'https://ror.org/005k4dn45 University of Arkansas Medical Center'),
(155, 'https://ror.org/005qv5373', 'en', 1, 'https://ror.org/005qv5373 Wakayama Medical University 和歌山県立医科大学'),
(156, 'https://ror.org/005qzv038', 'en', 1, 'https://ror.org/005qzv038 Munson Medical Center'),
(157, 'https://ror.org/005r9p256', 'en', 1, 'https://ror.org/005r9p256 Royal Derby Hospital'),
(158, 'https://ror.org/005s69p38', 'it', 1, 'https://ror.org/005s69p38 Azienda Ospedaliera Ospedale San Carlo Borromeo'),
(159, 'https://ror.org/005t72d47', 'en', 1, 'https://ror.org/005t72d47 Antrim Area Hospital'),
(160, 'https://ror.org/005tw0h26', 'en', 1, 'https://ror.org/005tw0h26 University Clinical Center of Kosovo'),
(161, 'https://ror.org/005w9jb47', 'en', 1, 'https://ror.org/005w9jb47 Lawrence University Universidad Lawrence'),
(162, 'https://ror.org/005wpyn57', 'en', 1, 'https://ror.org/005wpyn57 Children''s Hospital Mansoura University'),
(163, 'https://ror.org/005yg7304', 'no_lang_code', 1, 'https://ror.org/005yg7304 STAR Analytical Services'),
(164, 'https://ror.org/005ywsr52', 'en', 1, 'https://ror.org/005ywsr52 Friends University'),
(165, 'https://ror.org/005zah758', 'en', 1, 'https://ror.org/005zah758 Southern Nazarene University'),
(166, 'https://ror.org/0060t0j89', 'en', 1, 'https://ror.org/0060t0j89 Biblioteca Nacional de Medicina United States National Library of Medicine'),
(167, 'https://ror.org/0065kgn45', 'en', 1, 'https://ror.org/0065kgn45 Center for Studying Health System Change'),
(168, 'https://ror.org/0065mvt73', 'es', 1, 'https://ror.org/0065mvt73 Hospital Costa del Sol'),
(169, 'https://ror.org/0067dx910', 'en', 1, 'https://ror.org/0067dx910 Missouri Baptist Medical Center'),
(170, 'https://ror.org/00682eh61', 'en', 1, 'https://ror.org/00682eh61 Detroit Receiving Hospital'),
(171, 'https://ror.org/0069p7h69', 'en', 1, 'https://ror.org/0069p7h69 Tokushima Breast Care Clinic とくしまブレストケアクリニック'),
(172, 'https://ror.org/006bvjm48', 'en', 1, 'https://ror.org/006bvjm48 Hengyang Normal University'),
(173, 'https://ror.org/006c1jc70', 'en', 1, 'https://ror.org/006c1jc70 UK Material Technology Research Institute'),
(174, 'https://ror.org/006c6a937', 'no_lang_code', 1, 'https://ror.org/006c6a937 Intelligent Hearing Systems (United States)'),
(175, 'https://ror.org/006cvnv84', 'en', 1, 'https://ror.org/006cvnv84 Social Science Research Council'),
(176, 'https://ror.org/006f92m60', 'en', 1, 'https://ror.org/006f92m60 Duchess of Kent Children''s Hospital 大口環根德公爵夫人兒童醫院'),
(177, 'https://ror.org/006g42111', 'en', 1, 'https://ror.org/006g42111 Birmingham–Southern College'),
(178, 'https://ror.org/006gdh317', 'en', 1, 'https://ror.org/006gdh317 Meijo Hospital 名城病院'),
(179, 'https://ror.org/006gvnw06', 'en', 1, 'https://ror.org/006gvnw06 North Dakota Department of Health'),
(180, 'https://ror.org/006j1e620', 'en', 1, 'https://ror.org/006j1e620 Georgia Department of Human Services'),
(181, 'https://ror.org/006jjmw19', 'en', 1, 'https://ror.org/006jjmw19 Hospital de la Universidad de Colorado University of Colorado Hospital'),
(182, 'https://ror.org/006jxzx88', 'en', 1, 'https://ror.org/006jxzx88 Bond University'),
(183, 'https://ror.org/006k2kk72', 'en', 1, 'https://ror.org/006k2kk72 Düsseldorf University Hospital Universitätsklinikum Düsseldorf'),
(184, 'https://ror.org/006kce638', 'es', 1, 'https://ror.org/006kce638 Instituto Tecnológico del Calzado y Conexas'),
(185, 'https://ror.org/006nc8n95', 'pt', 1, 'https://ror.org/006nc8n95 Mackenzie Presbyterian University Universidade Presbiteriana Mackenzie'),
(186, 'https://ror.org/006pw7k84', 'en', 1, 'https://ror.org/006pw7k84 Ambrose Alli University Yunifásítì Ambrose Alli'),
(187, 'https://ror.org/006qqk144', 'no_lang_code', 1, 'https://ror.org/006qqk144 Fukui Prefectural Hospital 福井県立病院'),
(188, 'https://ror.org/006qssd78', 'pt', 1, 'https://ror.org/006qssd78 Universidade do Sul de Santa Catarina'),
(189, 'https://ror.org/006rhxn50', 'no_lang_code', 1, 'https://ror.org/006rhxn50 FORCE Technology (Denmark)'),
(190, 'https://ror.org/006t60p65', 'en', 1, 'https://ror.org/006t60p65 LeTourneau University'),
(191, 'https://ror.org/006x15235', 'en', 1, 'https://ror.org/006x15235 Instituto Nacional de Engenharia, Tecnologia e Inovação National Institute of Engineering, Technology and Innovation'),
(192, 'https://ror.org/006x9gw30', 'no_lang_code', 1, 'https://ror.org/006x9gw30 Koronis Biomedical Technologies (United States)'),
(193, 'https://ror.org/006xyf785', 'en', 1, 'https://ror.org/006xyf785 James A. Haley Veterans'' Hospital'),
(194, 'https://ror.org/006y27614', 'en', 1, 'https://ror.org/006y27614 Keesler Medical Center'),
(195, 'https://ror.org/006yqdy38', 'en', 1, 'https://ror.org/006yqdy38 Min Sheng General Hospital 敏盛綜合醫院'),
(196, 'https://ror.org/0070ga397', 'en', 1, 'https://ror.org/0070ga397 John F. Kennedy Medical Center'),
(197, 'https://ror.org/0071a2k97', 'en', 1, 'https://ror.org/0071a2k97 Queen Elizabeth II Medical Centre'),
(198, 'https://ror.org/00756eb27', 'no_lang_code', 1, 'https://ror.org/00756eb27 Barlow Scientific'),
(199, 'https://ror.org/0077fnc39', 'en', 1, 'https://ror.org/0077fnc39 Greater Baltimore Medical Center'),
(200, 'https://ror.org/0077pzv34', 'en', 1, 'https://ror.org/0077pzv34 Manitoba Health'),
(201, 'https://ror.org/0077tm911', 'en', 1, 'https://ror.org/0077tm911 Iowa Department of Human Services'),
(202, 'https://ror.org/007a5h107', 'en', 1, 'https://ror.org/007a5h107 Tawam Hospital مستشفى توام'),
(203, 'https://ror.org/007b9cn27', 'en', 1, 'https://ror.org/007b9cn27 National Polytechnic University of Armenia Հայաստանի ազգային պոլիտեխնիկական համալսարան'),
(204, 'https://ror.org/007dga614', 'en', 1, 'https://ror.org/007dga614 Bloomsburg University'),
(205, 'https://ror.org/007evha27', 'en', 1, 'https://ror.org/007evha27 Cooper Medical School of Rowan University'),
(206, 'https://ror.org/007f1da21', 'en', 1, 'https://ror.org/007f1da21 University of Baghdad جامعة بغداد'),
(207, 'https://ror.org/007fenw03', 'en', 1, 'https://ror.org/007fenw03 Government Medical College ഗവൺമെന്റ് മെഡിക്കൽ കോളേജ്, തിരുവനന്തപുരം'),
(208, 'https://ror.org/007fyq698', 'en', 1, 'https://ror.org/007fyq698 VA Salt Lake City Healthcare System'),
(209, 'https://ror.org/007h1g065', 'en', 1, 'https://ror.org/007h1g065 Universidad de Tampa University of Tampa'),
(210, 'https://ror.org/007hzv648', 'fr', 1, 'https://ror.org/007hzv648 Hôpital Saint Lazare'),
(211, 'https://ror.org/007jxr441', 'en', 1, 'https://ror.org/007jxr441 Society For Developmental Biology'),
(212, 'https://ror.org/007n03h88', 'en', 1, 'https://ror.org/007n03h88 Purdue Research Foundation'),
(213, 'https://ror.org/007sp7t15', 'en', 1, 'https://ror.org/007sp7t15 INTEGRIS Baptist Medical Center'),
(214, 'https://ror.org/007tn5k56', 'en', 1, 'https://ror.org/007tn5k56 Seton Hall University'),
(215, 'https://ror.org/007vcvm35', 'en', 1, 'https://ror.org/007vcvm35 North Karelia Central Hospital Pohjois-Karjalan Sairaanhoito- Ja Sosiaalipalvelujen Kuntayhtymä'),
(216, 'https://ror.org/007x9se63', 'en', 1, 'https://ror.org/007x9se63 Center for Devices and Radiological Health'),
(217, 'https://ror.org/007xad319', 'en', 1, 'https://ror.org/007xad319 Gezondheidsraad The Health Council of the Netherlands'),
(218, 'https://ror.org/007xcwj53', 'de', 1, 'https://ror.org/007xcwj53 Klinikum Klagenfurt'),
(219, 'https://ror.org/0080acb59', 'en', 1, 'https://ror.org/0080acb59 John Radcliffe Hospital'),
(220, 'https://ror.org/0084bse20', 'sv', 1, 'https://ror.org/0084bse20 Sunderby sjukhus'),
(221, 'https://ror.org/0084g8g60', 'tr', 1, 'https://ror.org/0084g8g60 Bayındır Hastanesi'),
(222, 'https://ror.org/0084te143', 'fr', 1, 'https://ror.org/0084te143 Centre Hospitalier Universitaire de Besançon'),
(223, 'https://ror.org/0086ms749', 'en', 1, 'https://ror.org/0086ms749 Arnold Palmer Hospital for Children'),
(224, 'https://ror.org/0086rpr26', 'en', 1, 'https://ror.org/0086rpr26 University of Sargodha'),
(225, 'https://ror.org/008a4de11', 'en', 1, 'https://ror.org/008a4de11 Manhattan Eye, Ear and Throat Hospital'),
(226, 'https://ror.org/008c4hs90', 'no_lang_code', 1, 'https://ror.org/008c4hs90 Niigata Prefectural Shibata Hospital 新潟県立新発田病院'),
(227, 'https://ror.org/008cz4337', 'da', 1, 'https://ror.org/008cz4337 Regionshospitalet Viborg Viborg Regional Hospital'),
(228, 'https://ror.org/008dmmd16', 'fr', 1, 'https://ror.org/008dmmd16 Hôpital Ophtalmique Jules-Gonin'),
(229, 'https://ror.org/008encc97', 'en', 1, 'https://ror.org/008encc97 East–West Center'),
(230, 'https://ror.org/008hybe55', 'en', 1, 'https://ror.org/008hybe55 JILA, Joint Institute for Laboratory Astrophysics'),
(231, 'https://ror.org/008j59125', 'en', 1, 'https://ror.org/008j59125 Aintree University Hospital'),
(232, 'https://ror.org/008jvv944', 'fr', 1, 'https://ror.org/008jvv944 Héma-Québec'),
(233, 'https://ror.org/008kn1a71', 'en', 1, 'https://ror.org/008kn1a71 Sunnybrook Hospital'),
(234, 'https://ror.org/008ms5s18', 'en', 1, 'https://ror.org/008ms5s18 Lamar University'),
(235, 'https://ror.org/008p85724', 'en', 1, 'https://ror.org/008p85724 Guangdong Province Stomatological Hospital 广东省口腔医院'),
(236, 'https://ror.org/008pwh115', 'en', 1, 'https://ror.org/008pwh115 Florida Memorial University'),
(237, 'https://ror.org/008r2d260', 'en', 1, 'https://ror.org/008r2d260 Louisiana State University Hospital'),
(238, 'https://ror.org/008rqvc37', 'en', 1, 'https://ror.org/008rqvc37 Lata Medical Research Foundation'),
(239, 'https://ror.org/008wtrs16', 'pt', 1, 'https://ror.org/008wtrs16 Instituto Superior de Ciências Educativas'),
(240, 'https://ror.org/008x57b05', 'en', 1, 'https://ror.org/008x57b05 Universiteit Antwerpen University of Antwerp Universität Antwerpen Université d''Anvers'),
(241, 'https://ror.org/008x85y42', 'no_lang_code', 1, 'https://ror.org/008x85y42 Hospital Bqyhallh بیمارستان بقیةالله'),
(242, 'https://ror.org/008xr7e22', 'en', 1, 'https://ror.org/008xr7e22 Mercy Health System'),
(243, 'https://ror.org/008zj0x80', 'en', 1, 'https://ror.org/008zj0x80 Hackensack University Medical Center'),
(244, 'https://ror.org/00911j719', 'en', 1, 'https://ror.org/00911j719 Tianjin Third Central Hospital 天津市第三中心医院'),
(245, 'https://ror.org/0091mqf26', 'en', 1, 'https://ror.org/0091mqf26 Oita Medical Center 国立病院機構 大分医療センタ'),
(246, 'https://ror.org/0092qhe76', 'no_lang_code', 1, 'https://ror.org/0092qhe76 Sanaria'),
(247, 'https://ror.org/0093xcb35', 'en', 1, 'https://ror.org/0093xcb35 Ashikaga Red Cross Hospital 足利赤十字病院'),
(248, 'https://ror.org/00944ve71', 'en', 1, 'https://ror.org/00944ve71 National Central University'),
(249, 'https://ror.org/00947s692', 'en', 1, 'https://ror.org/00947s692 Kurashiki Central Hospital 倉敷中央病院'),
(250, 'https://ror.org/00952fj37', 'en', 1, 'https://ror.org/00952fj37 Jinnah Postgraduate Medical Center'),
(251, 'https://ror.org/009543z50', 'en', 1, 'https://ror.org/009543z50 Northwestern Memorial Hospital'),
(252, 'https://ror.org/0098kke80', 'no_lang_code', 1, 'https://ror.org/0098kke80 Rakuten (Japan) 楽天株式会社'),
(253, 'https://ror.org/0099kc363', 'en', 1, 'https://ror.org/0099kc363 Sardar Patel Medical College'),
(254, 'https://ror.org/009afvb77', 'en', 1, 'https://ror.org/009afvb77 Provincial Laboratory of Public Health'),
(255, 'https://ror.org/009at8f10', 'fr', 1, 'https://ror.org/009at8f10 Hôpital Laveran'),
(256, 'https://ror.org/009c06z12', 'en', 1, 'https://ror.org/009c06z12 Intermountain Medical Center'),
(257, 'https://ror.org/009djsq06', 'en', 1, 'https://ror.org/009djsq06 King Abdulaziz Medical City مدينة الملك عبد العزيز الطبية للحرس الوطني'),
(258, 'https://ror.org/009e5cd49', 'en', 1, 'https://ror.org/009e5cd49 Sun Moon University 선문대학교'),
(259, 'https://ror.org/009ek3139', 'en', 1, 'https://ror.org/009ek3139 Falun Hospital'),
(260, 'https://ror.org/009erh992', 'en', 1, 'https://ror.org/009erh992 Sharp Rees-Stealy Medical Group'),
(261, 'https://ror.org/009ezqy65', 'en', 1, 'https://ror.org/009ezqy65 National Institute of Health and Family Welfare राष्ट्रीय स्वास्थ्य और परिवार कल्याण संस्थान'),
(262, 'https://ror.org/009fhc817', 'pl', 1, 'https://ror.org/009fhc817 Szpital im Tadeusza Marciniaka'),
(263, 'https://ror.org/009fnyh39', 'en', 1, 'https://ror.org/009fnyh39 Malabar Institute of Medical Sciences'),
(264, 'https://ror.org/009gqrs30', 'pt', 1, 'https://ror.org/009gqrs30 Hospital Moinhos de Vento'),
(265, 'https://ror.org/009hj8759', 'en', 1, 'https://ror.org/009hj8759 Grady Memorial Hospital'),
(266, 'https://ror.org/009k7c907', 'en', 1, 'https://ror.org/009k7c907 Northern Health'),
(267, 'https://ror.org/009kr6r15', 'en', 1, 'https://ror.org/009kr6r15 Western General Hospital'),
(268, 'https://ror.org/009nbdt96', 'en', 1, 'https://ror.org/009nbdt96 St. Joseph Medical Center'),
(269, 'https://ror.org/009p4eg54', 'en', 1, 'https://ror.org/009p4eg54 Tilka Manjhi Bhagalpur University तिलका मांझी भागलपुर विश्वविद्यालय'),
(270, 'https://ror.org/009q6vg88', 'no_lang_code', 1, 'https://ror.org/009q6vg88 Virogenomics BioDevelopment (United States)'),
(271, 'https://ror.org/009qqcw96', 'en', 1, 'https://ror.org/009qqcw96 Lehigh Valley Hospital Muhlenberg'),
(272, 'https://ror.org/009raxq57', 'en', 1, 'https://ror.org/009raxq57 Mercy Medical Center'),
(273, 'https://ror.org/009rt9f88', 'en', 1, 'https://ror.org/009rt9f88 Inova Loudoun Hospital'),
(274, 'https://ror.org/009sa0g06', 'en', 1, 'https://ror.org/009sa0g06 Royal Liverpool and Broadgreen University Hospital NHS Trust'),
(275, 'https://ror.org/009szpe27', 'en', 1, 'https://ror.org/009szpe27 Armed Forces Health Surveillance Center'),
(276, 'https://ror.org/009vheq40', 'en', 1, 'https://ror.org/009vheq40 Churchill Hospital'),
(277, 'https://ror.org/009x1kj44', 'pl', 1, 'https://ror.org/009x1kj44 University Children’s Hospital Uniwersytecki Szpital Dziecięcy'),
(278, 'https://ror.org/009z5t729', 'en', 1, 'https://ror.org/009z5t729 Cook Children''s Medical Center'),
(279, 'https://ror.org/00a0jsq62', 'en', 1, 'https://ror.org/00a0jsq62 London School of Hygiene & Tropical Medicine'),
(280, 'https://ror.org/00a0pt066', 'en', 1, 'https://ror.org/00a0pt066 MultiCare Good Samaritan Hospital'),
(281, 'https://ror.org/00a3dqw47', 'en', 1, 'https://ror.org/00a3dqw47 Eastern State Hospital'),
(282, 'https://ror.org/00a43vs85', 'en', 1, 'https://ror.org/00a43vs85 Ya''an Polytechnic College 雅安职业技术学院'),
(283, 'https://ror.org/00a53nq42', 'en', 1, 'https://ror.org/00a53nq42 Cancer Hospital of Shantou University Medical College 汕头大学医学院附属肿瘤医院'),
(284, 'https://ror.org/00a858n67', 'en', 1, 'https://ror.org/00a858n67 Royal United Hospital'),
(285, 'https://ror.org/00a8tg325', 'en', 1, 'https://ror.org/00a8tg325 Korea Institute of Radiological and Medical Sciences 한국 방사선 과학 연구소'),
(286, 'https://ror.org/00a98yf63', 'en', 1, 'https://ror.org/00a98yf63 Second Affiliated Hospital of Guangzhou Medical University 广州医科大学附属第二医院'),
(287, 'https://ror.org/00a99v816', 'no_lang_code', 1, 'https://ror.org/00a99v816'),
(288, 'https://ror.org/00ac5y077', 'pt', 1, 'https://ror.org/00ac5y077 Instituto Superior Autónomo de Estudos Politécnicos'),
(289, 'https://ror.org/00adjy062', 'no_lang_code', 1, 'https://ror.org/00adjy062 Performance Plants (Canada)'),
(290, 'https://ror.org/00ae33288', 'en', 1, 'https://ror.org/00ae33288 London Metropolitan University'),
(291, 'https://ror.org/00af3sa43', 'en', 1, 'https://ror.org/00af3sa43 Isfahan University of Technology دانشگاه صنعتی اصفهان'),
(292, 'https://ror.org/00aff0y51', 'tr', 1, 'https://ror.org/00aff0y51 Dr. Behçet Uz Çocuk Hastalıkları Hastanesi'),
(293, 'https://ror.org/00afgv297', 'es', 1, 'https://ror.org/00afgv297 Hospital General San Juan de Dios'),
(294, 'https://ror.org/00aft1q37', 'en', 1, 'https://ror.org/00aft1q37 Sejong University 세종대학교'),
(295, 'https://ror.org/00agkba13', 'en', 1, 'https://ror.org/00agkba13 Martha Jefferson Hospital'),
(296, 'https://ror.org/00agrkd75', 'en', 1, 'https://ror.org/00agrkd75 Computing Research Association'),
(297, 'https://ror.org/00ajg8537', 'tr', 1, 'https://ror.org/00ajg8537 Gaziantep Onkoloji Hastanesi'),
(298, 'https://ror.org/00ajykz30', 'en', 1, 'https://ror.org/00ajykz30 UK Water Industry Research'),
(299, 'https://ror.org/00akdyv48', 'en', 1, 'https://ror.org/00akdyv48 Centre médical de kettering Kettering Medical Center'),
(300, 'https://ror.org/00apdsa62', 'en', 1, 'https://ror.org/00apdsa62 Privolzhsky Research Medical University Приволжский исследовательский медицинский университет'),
(301, 'https://ror.org/00aqz8k66', 'en', 1, 'https://ror.org/00aqz8k66 Florida Hospital Cancer Institute'),
(302, 'https://ror.org/00asaax56', 'en', 1, 'https://ror.org/00asaax56 Accreditation Council for Graduate Medical Education'),
(303, 'https://ror.org/00av3hs56', 'en', 1, 'https://ror.org/00av3hs56 Chubu Rosai Hospital 中部ろうさい病院'),
(304, 'https://ror.org/00av5yz18', 'en', 1, 'https://ror.org/00av5yz18 Health and Safety Executive'),
(305, 'https://ror.org/00awxvj03', 'en', 1, 'https://ror.org/00awxvj03 Wakayama Rosai Hospital 和歌山ろうさい病院'),
(306, 'https://ror.org/00azwtc53', 'no_lang_code', 1, 'https://ror.org/00azwtc53 Swedish Nuclear Fuel and Waste Management (Sweden)'),
(307, 'https://ror.org/00b0m1444', 'en', 1, 'https://ror.org/00b0m1444 Loewenstein Hospital Rehabilitation Center'),
(308, 'https://ror.org/00b4emx12', 'en', 1, 'https://ror.org/00b4emx12 North Shore Medical Center'),
(309, 'https://ror.org/00b4wat71', 'en', 1, 'https://ror.org/00b4wat71 Shadyside Hospital'),
(310, 'https://ror.org/00b7yvh50', 'en', 1, 'https://ror.org/00b7yvh50 Prefectural University of Kumamoto 熊本県立大学'),
(311, 'https://ror.org/00b7zsw47', 'de', 1, 'https://ror.org/00b7zsw47 Klinik Schillerhöhe'),
(312, 'https://ror.org/00b9w6n61', 'en', 1, 'https://ror.org/00b9w6n61 St. Francis Hospital'),
(313, 'https://ror.org/00baajx12', 'en', 1, 'https://ror.org/00baajx12 Rood and Riddle Equine Hospital'),
(314, 'https://ror.org/00baak391', 'en', 1, 'https://ror.org/00baak391 National Human Genome Research Institute'),
(315, 'https://ror.org/00bb01z14', 'en', 1, 'https://ror.org/00bb01z14 Vladivostok State Medical University Тихоокеанский государственный медицинский университет'),
(316, 'https://ror.org/00bbdze26', 'en', 1, 'https://ror.org/00bbdze26 Ospidéal Ginearálta Loch Garman Wexford General Hospital'),
(317, 'https://ror.org/00bjck208', 'en', 1, 'https://ror.org/00bjck208 Glasgow Royal Infirmary'),
(318, 'https://ror.org/00bmv4102', 'nl', 1, 'https://ror.org/00bmv4102 Emma Children’s Hospital Emma Kinderziekenhuis'),
(319, 'https://ror.org/00bmwjh97', 'en', 1, 'https://ror.org/00bmwjh97 St. James Hospital and Health Centers'),
(320, 'https://ror.org/00bmzhb16', 'en', 1, 'https://ror.org/00bmzhb16 Gembloux Agro-Bio Tech'),
(321, 'https://ror.org/00bpn0984', 'it', 1, 'https://ror.org/00bpn0984 Ospedale San Paolo'),
(322, 'https://ror.org/00bq4rw46', 'es', 1, 'https://ror.org/00bq4rw46 Hospital Italiano de Buenos Aires'),
(323, 'https://ror.org/00bq8v746', 'no_lang_code', 1, 'https://ror.org/00bq8v746 Aomori Prefectural Central Hospital 青森県立中央病院'),
(324, 'https://ror.org/00bs3zm56', 'no_lang_code', 1, 'https://ror.org/00bs3zm56 Nagasaki Municipal Hospital 長崎みなとメディカルセンター市民病院'),
(325, 'https://ror.org/00bsyjc58', 'en', 1, 'https://ror.org/00bsyjc58 Kanchi Mamunivar Centre for Post Graduate Studies'),
(326, 'https://ror.org/00btty905', 'en', 1, 'https://ror.org/00btty905 Ireland Army Community Hospital'),
(327, 'https://ror.org/00bwhj131', 'en', 1, 'https://ror.org/00bwhj131 Newark Beth Israel Medical Center'),
(328, 'https://ror.org/00bx6dj65', 'en', 1, 'https://ror.org/00bx6dj65 Hosei University 法政大学'),
(329, 'https://ror.org/00bx71042', 'en', 1, 'https://ror.org/00bx71042 Coombe Women & Infants University Hospital Ospidéal Ollscoile Ban agus Naíonán an Chúim'),
(330, 'https://ror.org/00bxj7497', 'en', 1, 'https://ror.org/00bxj7497 Vidant Medical Center'),
(331, 'https://ror.org/00bxsm637', 'no_lang_code', 1, 'https://ror.org/00bxsm637 MTU Aero Engines (Germany)'),
(332, 'https://ror.org/00byr8j11', 'en', 1, 'https://ror.org/00byr8j11 National Science Teachers Association'),
(333, 'https://ror.org/00bz6qm80', 'en', 1, 'https://ror.org/00bz6qm80 Dillard University'),
(334, 'https://ror.org/00c01js51', 'en', 1, 'https://ror.org/00c01js51 The Ohio State University Wexner Medical Center'),
(335, 'https://ror.org/00c051916', 'fr', 1, 'https://ror.org/00c051916 Centre Technique des Industries Mécaniques Technical Centre for Mechanical Industry'),
(336, 'https://ror.org/00c099g34', 'en', 1, 'https://ror.org/00c099g34 First People''s Hospital of Yunnan Province 云南省第一人民医院'),
(337, 'https://ror.org/00c879s84', 'en', 1, 'https://ror.org/00c879s84 Groote Schuur Hospital'),
(338, 'https://ror.org/00c8t7d47', 'tr', 1, 'https://ror.org/00c8t7d47 Gülhane Askerî Tıp Akademisi'),
(339, 'https://ror.org/00c8v4891', 'en', 1, 'https://ror.org/00c8v4891 Long Island Jewish Medical Center'),
(340, 'https://ror.org/00c9syb98', 'en', 1, 'https://ror.org/00c9syb98 Merlin Park University Hospital'),
(341, 'https://ror.org/00cb9nn43', 'en', 1, 'https://ror.org/00cb9nn43 American Dental Association'),
(342, 'https://ror.org/00cb9w016', 'en', 1, 'https://ror.org/00cb9w016 Ain Shams University جامعة عين شمس'),
(343, 'https://ror.org/00ccec020', 'pt', 1, 'https://ror.org/00ccec020 Universidade do Oeste Paulista University of Western São Paulo'),
(344, 'https://ror.org/00cckeg37', 'en', 1, 'https://ror.org/00cckeg37 Southern Polytechnic State University'),
(345, 'https://ror.org/00cd86r95', 'en', 1, 'https://ror.org/00cd86r95 Frontier Medical College فرنٹیئر میڈیکل کالج'),
(346, 'https://ror.org/00cd9s024', 'en', 1, 'https://ror.org/00cd9s024 Shanghai Children''s Medical Center 上海儿童医学中心'),
(347, 'https://ror.org/00cdwy346', 'en', 1, 'https://ror.org/00cdwy346 Freeman Hospital'),
(348, 'https://ror.org/00cdz3124', 'es', 1, 'https://ror.org/00cdz3124 Hospital General Universitario Santa María del Rosell'),
(349, 'https://ror.org/00ceh2v36', 'en', 1, 'https://ror.org/00ceh2v36 Hiratsuka City Hospital 平塚市民病院'),
(350, 'https://ror.org/00cfdk448', 'en', 1, 'https://ror.org/00cfdk448 Royal Cornwall Hospital'),
(351, 'https://ror.org/00cfm3y81', 'es', 1, 'https://ror.org/00cfm3y81 Hospital General Universitario Morales Meseguer'),
(352, 'https://ror.org/00cgjx575', 'en', 1, 'https://ror.org/00cgjx575 TRTech'),
(353, 'https://ror.org/00chbca67', 'en', 1, 'https://ror.org/00chbca67 Bhabha Atomic Research Center Hospital'),
(354, 'https://ror.org/00chfja07', 'en', 1, 'https://ror.org/00chfja07 Seoul National University of Science and Technology 서울과학기술대학교'),
(355, 'https://ror.org/00chxjy07', 'en', 1, 'https://ror.org/00chxjy07 Fundação Conservatório Regional de Gaia Gaia Regional Conservatory Foundation'),
(356, 'https://ror.org/00cmfmh53', 'it', 1, 'https://ror.org/00cmfmh53 Azienda Ospedaliera G.Rummo'),
(357, 'https://ror.org/00cmk4n56', 'it', 1, 'https://ror.org/00cmk4n56 Krankenhaus Bozen Ospedale di Bolzano'),
(358, 'https://ror.org/00cr15z55', 'en', 1, 'https://ror.org/00cr15z55 St. Elizabeth''s Medical Center'),
(359, 'https://ror.org/00cr96696', 'en', 1, 'https://ror.org/00cr96696 Center for Clinical Research and Prevention Center for Klinisk Forskning og Forebyggelse'),
(360, 'https://ror.org/00ctk8b26', 'en', 1, 'https://ror.org/00ctk8b26 Bristol City Council'),
(361, 'https://ror.org/00cwrhn79', 'en', 1, 'https://ror.org/00cwrhn79 Saint Vincent''s Catholic Medical Center'),
(362, 'https://ror.org/00d0zag42', 'no_lang_code', 1, 'https://ror.org/00d0zag42 Wooridul Hospital 우리들 병원'),
(363, 'https://ror.org/00d264c35', 'en', 1, 'https://ror.org/00d264c35 Frederiksberg Hospital'),
(364, 'https://ror.org/00d80zx46', 'en', 1, 'https://ror.org/00d80zx46 Chang Gung University'),
(365, 'https://ror.org/00d973h41', 'en', 1, 'https://ror.org/00d973h41 Södertörn University Södertörns högskola'),
(366, 'https://ror.org/00d9qf519', 'en', 1, 'https://ror.org/00d9qf519 Topiwala National Medical College & BYL Nair Charitable Hospital'),
(367, 'https://ror.org/00dc7s858', 'en', 1, 'https://ror.org/00dc7s858 Jiangxi Agricultural University 江西农业大学'),
(368, 'https://ror.org/00ded8656', 'en', 1, 'https://ror.org/00ded8656 Pine Rest Christian Mental Health Services'),
(369, 'https://ror.org/00dfape04', 'en', 1, 'https://ror.org/00dfape04 Good Moonhwa Hospital 좋은문화병원'),
(370, 'https://ror.org/00dpx3e98', 'en', 1, 'https://ror.org/00dpx3e98 American Meteorological Society'),
(371, 'https://ror.org/00dr1cn74', 'en', 1, 'https://ror.org/00dr1cn74 Hangzhou Center for Disease Control and Prevention 杭州市疾病预防控制中心'),
(372, 'https://ror.org/00dr54257', 'en', 1, 'https://ror.org/00dr54257 Alcorn State University'),
(373, 'https://ror.org/00drynx17', 'en', 1, 'https://ror.org/00drynx17 Fukuoka Institute of Health and Environmental Sciences 福岡県保健環境研究所'),
(374, 'https://ror.org/00dt08z19', 'en', 1, 'https://ror.org/00dt08z19 Argyll and Bute Hospital'),
(375, 'https://ror.org/00dv9aw81', 'no_lang_code', 1, 'https://ror.org/00dv9aw81 Experimental Pathology Laboratories'),
(376, 'https://ror.org/00dwz8y55', 'en', 1, 'https://ror.org/00dwz8y55 Sheppard Pratt Health System'),
(377, 'https://ror.org/00e16h982', 'en', 1, 'https://ror.org/00e16h982 Osun State University'),
(378, 'https://ror.org/00e49gy82', 'en', 1, 'https://ror.org/00e49gy82 China University of Political Science and Law 中国政法大学'),
(379, 'https://ror.org/00e4zxr41', 'en', 1, 'https://ror.org/00e4zxr41 Ross University School of Veterinary Medicine'),
(380, 'https://ror.org/00e60hf45', 'en', 1, 'https://ror.org/00e60hf45 Ospidéal Naomh Damhnait St. Davnet''s Hospital'),
(381, 'https://ror.org/00e7ez509', 'no_lang_code', 1, 'https://ror.org/00e7ez509 Daegu Fatima Hospital 대구파티마병원'),
(382, 'https://ror.org/00e7taa66', 'en', 1, 'https://ror.org/00e7taa66 Ingalls Memorial Hospital'),
(383, 'https://ror.org/00e7vmq69', 'en', 1, 'https://ror.org/00e7vmq69 Polytechnic University of the Philippines'),
(384, 'https://ror.org/00e9xa106', 'en', 1, 'https://ror.org/00e9xa106 University of Maine at Machias'),
(385, 'https://ror.org/00eekd641', 'en', 1, 'https://ror.org/00eekd641 Robert Wood Johnson University Hospital'),
(386, 'https://ror.org/00eg8ch54', 'en', 1, 'https://ror.org/00eg8ch54 Hebrew Hospital'),
(387, 'https://ror.org/00egdv862', 'no_lang_code', 1, 'https://ror.org/00egdv862 Hongik University 홍익대학교'),
(388, 'https://ror.org/00eh7f421', 'no_lang_code', 1, 'https://ror.org/00eh7f421 E-Da Hospital'),
(389, 'https://ror.org/00ek9j693', 'en', 1, 'https://ror.org/00ek9j693 Bloodworks Northwest'),
(390, 'https://ror.org/00em04n91', 'en', 1, 'https://ror.org/00em04n91 Moscow State University of Civil Engineering Московский Государственный Строительный Университет'),
(391, 'https://ror.org/00en92979', 'en', 1, 'https://ror.org/00en92979 Kaohsiung Municipal Kai-Syuan Psychiatric Hospital'),
(392, 'https://ror.org/00enq8e33', 'en', 1, 'https://ror.org/00enq8e33 Aurelia Hospital'),
(393, 'https://ror.org/00ep78v21', 'en', 1, 'https://ror.org/00ep78v21 Advocate Good Samaritan Hospital'),
(394, 'https://ror.org/00ey54k21', 'pt', 1, 'https://ror.org/00ey54k21 Universidade de Ribeirão Preto University of Ribeirão Preto'),
(395, 'https://ror.org/00eyk9919', 'en', 1, 'https://ror.org/00eyk9919 Holy Family Hospital ہولی فیملی ہسپتال'),
(396, 'https://ror.org/00eysw063', 'en', 1, 'https://ror.org/00eysw063 Liverpool Women''s Hospital'),
(397, 'https://ror.org/00f1xkb20', 'no_lang_code', 1, 'https://ror.org/00f1xkb20 Robosoft (France)'),
(398, 'https://ror.org/00f2gwr16', 'en', 1, 'https://ror.org/00f2gwr16 Lankenau Medical Center'),
(399, 'https://ror.org/00f2txz25', 'no_lang_code', 1, 'https://ror.org/00f2txz25 Kitasato University 北里大学'),
(400, 'https://ror.org/00f2ymb10', 'en', 1, 'https://ror.org/00f2ymb10 Chesapeake Research Consortium'),
(401, 'https://ror.org/00f2z7n96', 'en', 1, 'https://ror.org/00f2z7n96 RAND Corporation'),
(402, 'https://ror.org/00f4kgf41', 'en', 1, 'https://ror.org/00f4kgf41 Gaziantep Children''s Hospital Gaziantep Çocuk Hastanesi'),
(403, 'https://ror.org/00f54ay49', 'en', 1, 'https://ror.org/00f54ay49 Wakefield Hospital'),
(404, 'https://ror.org/00f5bva59', 'en', 1, 'https://ror.org/00f5bva59 Swedish Medical Center'),
(405, 'https://ror.org/00f93yb19', 'en', 1, 'https://ror.org/00f93yb19 McKay Dee Hospital'),
(406, 'https://ror.org/00f9c2f73', 'en', 1, 'https://ror.org/00f9c2f73 GF Jooste Hospital'),
(407, 'https://ror.org/00fb35g87', 'en', 1, 'https://ror.org/00fb35g87 Third Affiliated Hospital of Guangzhou Medical University 广州医科大学附属第三医院'),
(408, 'https://ror.org/00fb7mg36', 'no_lang_code', 1, 'https://ror.org/00fb7mg36 San-ikukai Hospital 賛育会病院'),
(409, 'https://ror.org/00fbafs03', 'no_lang_code', 1, 'https://ror.org/00fbafs03 MBN Nanomaterialia (Italy)'),
(410, 'https://ror.org/00fc19b96', 'en', 1, 'https://ror.org/00fc19b96 Aomori Rosai Hospital 青森労災病院'),
(411, 'https://ror.org/00ff4bt20', 'en', 1, 'https://ror.org/00ff4bt20 Arcadia University'),
(412, 'https://ror.org/00fg98b82', 'en', 1, 'https://ror.org/00fg98b82 Kaiser Permanente San Diego Medical Center'),
(413, 'https://ror.org/00fgdyv87', 'no_lang_code', 1, 'https://ror.org/00fgdyv87 Hindu Rao Hospital'),
(414, 'https://ror.org/00fh72m39', 'en', 1, 'https://ror.org/00fh72m39 Vladimir State University for the Humanities Владимирский государственный гуманитарный университет'),
(415, 'https://ror.org/00fj3a809', 'en', 1, 'https://ror.org/00fj3a809 Good Samaritan Regional Medical Center'),
(416, 'https://ror.org/00fjv1g65', 'en', 1, 'https://ror.org/00fjv1g65 Kunming Children''s Hospital 昆明市儿童医院'),
(417, 'https://ror.org/00fk0yb75', 'en', 1, 'https://ror.org/00fk0yb75 Plastic Surgery Hospital'),
(418, 'https://ror.org/00fpw9a48', 'no_lang_code', 1, 'https://ror.org/00fpw9a48 Hamburg Ship Model Basin Hamburgische Schiffbau-Versuchsanstalt (Germany)'),
(419, 'https://ror.org/00fqdfs68', 'en', 1, 'https://ror.org/00fqdfs68 Kuopio University Hospital'),
(420, 'https://ror.org/00fqdgv63', 'en', 1, 'https://ror.org/00fqdgv63 Lankenau Heart Institute'),
(421, 'https://ror.org/00fqtfz78', 'en', 1, 'https://ror.org/00fqtfz78 Beebe Healthcare'),
(422, 'https://ror.org/00frst980', 'en', 1, 'https://ror.org/00frst980 University of British Columbia Hospital'),
(423, 'https://ror.org/00frzd868', 'en', 1, 'https://ror.org/00frzd868 St. Francis Hospital'),
(424, 'https://ror.org/00fsrkw38', 'es', 1, 'https://ror.org/00fsrkw38 Hospital Quirón Teknon'),
(425, 'https://ror.org/00ft41876', 'en', 1, 'https://ror.org/00ft41876 Marion duPont Scott Equine Medical Center'),
(426, 'https://ror.org/00ftebr67', 'en', 1, 'https://ror.org/00ftebr67 Wesley Medical Center'),
(427, 'https://ror.org/00fthae95', 'en', 1, 'https://ror.org/00fthae95 Daping Hospital 第三军医大学大坪医院'),
(428, 'https://ror.org/00ftwze80', 'en', 1, 'https://ror.org/00ftwze80 University Dental Hospital on Cardiff University'),
(429, 'https://ror.org/00fv61j67', 'en', 1, 'https://ror.org/00fv61j67 MRC Laboratory for Molecular Cell Biology'),
(430, 'https://ror.org/00fvyjk73', 'en', 1, 'https://ror.org/00fvyjk73 Colby College'),
(431, 'https://ror.org/00fwdyt59', 'en', 1, 'https://ror.org/00fwdyt59 George Washington University Hospital');
INSERT INTO `rors` VALUES
(432, 'https://ror.org/00fwhaq79', 'en', 1, 'https://ror.org/00fwhaq79 Lee University'),
(433, 'https://ror.org/00fxgea47', 'no_lang_code', 1, 'https://ror.org/00fxgea47 Novartis (China) 北京诺华制药有限公司'),
(434, 'https://ror.org/00fzfzc37', 'en', 1, 'https://ror.org/00fzfzc37 Manchester VA Medical Center'),
(435, 'https://ror.org/00g1rc256', 'en', 1, 'https://ror.org/00g1rc256 Central DuPage Hospital'),
(436, 'https://ror.org/00g3pqv36', 'en', 1, 'https://ror.org/00g3pqv36 First Affiliated Hospital of Jiangxi Medical College'),
(437, 'https://ror.org/00g578s43', 'no_lang_code', 1, 'https://ror.org/00g578s43 Oregon Center For Applied Science (United States)'),
(438, 'https://ror.org/00g58cv73', 'en', 1, 'https://ror.org/00g58cv73 Chowan University'),
(439, 'https://ror.org/00g651r29', 'en', 1, 'https://ror.org/00g651r29 Maimonides Medical Center'),
(440, 'https://ror.org/00g6ka752', 'en', 1, 'https://ror.org/00g6ka752 Ferdowsi University of Mashhad دانشگاه فردوسی مشهد'),
(441, 'https://ror.org/00g9xaj16', 'en', 1, 'https://ror.org/00g9xaj16 Saint Agnes Medical Center'),
(442, 'https://ror.org/00gahk913', 'en', 1, 'https://ror.org/00gahk913 Sendai Nishitaga National Hospital 国立病院機構仙台西多賀病院'),
(443, 'https://ror.org/00gdcs242', 'en', 1, 'https://ror.org/00gdcs242 MESA Hospital Mesa Hastanesi'),
(444, 'https://ror.org/00gdxq105', 'en', 1, 'https://ror.org/00gdxq105 Vermont Department of Mental Health'),
(445, 'https://ror.org/00gffbx54', 'fr', 1, 'https://ror.org/00gffbx54 Hôpital La Rabta المستشفى الجامعي الرابطة'),
(446, 'https://ror.org/00ghjek97', 'en', 1, 'https://ror.org/00ghjek97 Orel State University named after I.S. Turgenev Орловский государственный университет имени И. С. Тургенева'),
(447, 'https://ror.org/00gjahp83', 'en', 1, 'https://ror.org/00gjahp83 Midwestern Regional Medical Center'),
(448, 'https://ror.org/00gkd5869', 'en', 1, 'https://ror.org/00gkd5869 Lagos University Teaching Hospital'),
(449, 'https://ror.org/00gkheh82', 'it', 1, 'https://ror.org/00gkheh82 Ospedale regionale di Lugano'),
(450, 'https://ror.org/00gqjdp23', 'en', 1, 'https://ror.org/00gqjdp23 Oita Red Cross Hospital 大分赤十字病院'),
(451, 'https://ror.org/00gr1q288', 'en', 1, 'https://ror.org/00gr1q288 Tokai University Hachioji Hospital 東海大学医学部付属八王子病院'),
(452, 'https://ror.org/00gs85y70', 'en', 1, 'https://ror.org/00gs85y70 Bellin Memorial Hospital'),
(453, 'https://ror.org/00gtcbp88', 'pt', 1, 'https://ror.org/00gtcbp88 Universidade de Pernambuco University of Pernambuco'),
(454, 'https://ror.org/00gv7aj90', 'es', 1, 'https://ror.org/00gv7aj90 Hospital Barros Luco-Trudeau'),
(455, 'https://ror.org/00gvw6327', 'en', 1, 'https://ror.org/00gvw6327 King George''s Medical University छत्रपति शाहूजी महाराज आयुर्विज्ञान विश्वविद्यालय'),
(456, 'https://ror.org/00gw6hy83', 'en', 1, 'https://ror.org/00gw6hy83 Rotherham General Hospital'),
(457, 'https://ror.org/00h04da97', 'en', 1, 'https://ror.org/00h04da97 McNeese State University'),
(458, 'https://ror.org/00h1apf46', 'fr', 1, 'https://ror.org/00h1apf46 Centre Hospitalier Universitaire de Yopougon'),
(459, 'https://ror.org/00h2bj464', 'en', 1, 'https://ror.org/00h2bj464 Deaconess Hospital'),
(460, 'https://ror.org/00h7y2d26', 'no_lang_code', 1, 'https://ror.org/00h7y2d26 Sensimetrics Corporation'),
(461, 'https://ror.org/00h85x510', 'no_lang_code', 1, 'https://ror.org/00h85x510 Tembec'),
(462, 'https://ror.org/00h974d79', 'pt', 1, 'https://ror.org/00h974d79 Instituto de Estudos Superiores Financeiros e Fiscais'),
(463, 'https://ror.org/00hb4yd20', 'en', 1, 'https://ror.org/00hb4yd20 MGMA Health Care Consulting Group'),
(464, 'https://ror.org/00hbq5j06', 'no_lang_code', 1, 'https://ror.org/00hbq5j06 Ecogenomics (Japan)'),
(465, 'https://ror.org/00hdf8e67', 'en', 1, 'https://ror.org/00hdf8e67 Jawaharlal Nehru Medical College'),
(466, 'https://ror.org/00hfbva78', 'en', 1, 'https://ror.org/00hfbva78 General Hospital of Guangzhou Military Command 广州军区广州总医院'),
(467, 'https://ror.org/00hhkn466', 'en', 1, 'https://ror.org/00hhkn466 Japan Society for the Promotion of Science 日本学術振興会'),
(468, 'https://ror.org/00hhwej14', 'en', 1, 'https://ror.org/00hhwej14 Royal Hampshire County Hospital'),
(469, 'https://ror.org/00hm23551', 'no_lang_code', 1, 'https://ror.org/00hm23551 Nishinomiya Municipal Central Hospital 西宮市立中央病院'),
(470, 'https://ror.org/00hm9kt34', 'sv', 1, 'https://ror.org/00hm9kt34 Danderyds sjukhus'),
(471, 'https://ror.org/00hmeez77', 'en', 1, 'https://ror.org/00hmeez77 Barzilai Medical Center'),
(472, 'https://ror.org/00hn92440', 'en', 1, 'https://ror.org/00hn92440 Broomfield Hospital'),
(473, 'https://ror.org/00hnyb151', 'no_lang_code', 1, 'https://ror.org/00hnyb151 Luna Innovations (United States)'),
(474, 'https://ror.org/00hp6as40', 'en', 1, 'https://ror.org/00hp6as40 Mammoth Hospital'),
(475, 'https://ror.org/00hpnj894', 'es', 1, 'https://ror.org/00hpnj894 Hospital Clínico Universitario de Valencia'),
(476, 'https://ror.org/00hpqmv06', 'en', 1, 'https://ror.org/00hpqmv06 Ministry of Health'),
(477, 'https://ror.org/00hq79z10', 'no_lang_code', 1, 'https://ror.org/00hq79z10 Tianjin Nankai Hospital 天津市南开医院'),
(478, 'https://ror.org/00hr54p22', 'en', 1, 'https://ror.org/00hr54p22 Osmania Medical College عثمانیہ میڈیکل کالج ఉస్మానియా మెడికల్ కాలేజీ'),
(479, 'https://ror.org/00hswnf74', 'no_lang_code', 1, 'https://ror.org/00hswnf74 Shizuoka City Shimizu Hospital 静岡市立清水病院'),
(480, 'https://ror.org/00hw84d70', 'en', 1, 'https://ror.org/00hw84d70 Baba Memorial Hospital 社会医療法人ペガサス 馬場記念病院'),
(481, 'https://ror.org/00hwsxp30', 'tr', 1, 'https://ror.org/00hwsxp30 Ankara Fizik Tedavi ve Rehabilitasyon Eğitim ve Araştırma Hastanesi'),
(482, 'https://ror.org/00hx9k210', 'en', 1, 'https://ror.org/00hx9k210 Sasebo City General Hospital 佐世保市総合医療センター'),
(483, 'https://ror.org/00hysg385', 'en', 1, 'https://ror.org/00hysg385 Sinai Grace Hospital'),
(484, 'https://ror.org/00j0b8v53', 'en', 1, 'https://ror.org/00j0b8v53 Regional Medical Research Center क्षेत्रीय आयुर्विगिनं अनुसंधान केंद्र'),
(485, 'https://ror.org/00j0z5m32', 'en', 1, 'https://ror.org/00j0z5m32 Alabama Department of Public Health'),
(486, 'https://ror.org/00j2n4x83', 'en', 1, 'https://ror.org/00j2n4x83 Narayana Dental College and Hospital'),
(487, 'https://ror.org/00j2wht38', 'en', 1, 'https://ror.org/00j2wht38 Virginia Department of Health'),
(488, 'https://ror.org/00j4k1h63', 'en', 1, 'https://ror.org/00j4k1h63 National Institute of Environmental Health Sciences'),
(489, 'https://ror.org/00j4pe902', 'en', 1, 'https://ror.org/00j4pe902 Maharaja Krishna Chandra Gajapati Medical College and Hospital'),
(490, 'https://ror.org/00j4pze04', 'es', 1, 'https://ror.org/00j4pze04 Hospital de Basurto'),
(491, 'https://ror.org/00j899309', 'no_lang_code', 1, 'https://ror.org/00j899309 Inflexxion (United States)'),
(492, 'https://ror.org/00j8ram51', 'en', 1, 'https://ror.org/00j8ram51 Cambridge Military Hospital'),
(493, 'https://ror.org/00j8xcs04', 'en', 1, 'https://ror.org/00j8xcs04 Sir Sayajirao General Hospital Medical College'),
(494, 'https://ror.org/00j9c2840', 'en', 1, 'https://ror.org/00j9c2840 Oslo University Hospital'),
(495, 'https://ror.org/00j9f7w81', 'es', 1, 'https://ror.org/00j9f7w81 Hospital Terrassa'),
(496, 'https://ror.org/00jbkk316', 'en', 1, 'https://ror.org/00jbkk316 Buffalo VA Medical Center'),
(497, 'https://ror.org/00jc2kw33', 'en', 1, 'https://ror.org/00jc2kw33 National Center for Environmental Health'),
(498, 'https://ror.org/00jc57298', 'en', 1, 'https://ror.org/00jc57298 Central Baptist Hospital'),
(499, 'https://ror.org/00jh2w590', 'en', 1, 'https://ror.org/00jh2w590 New Mexico Department of Health'),
(500, 'https://ror.org/00jhae347', 'no_lang_code', 1, 'https://ror.org/00jhae347 Medical Protective'),
(501, 'https://ror.org/00jhyq802', 'en', 1, 'https://ror.org/00jhyq802 Regent University'),
(502, 'https://ror.org/00jjeh629', 'en', 1, 'https://ror.org/00jjeh629 Harvard–MIT Division of Health Sciences and Technology'),
(503, 'https://ror.org/00jjvav84', 'en', 1, 'https://ror.org/00jjvav84 The Hamner Institutes for Health Sciences'),
(504, 'https://ror.org/00jk4qh27', 'no_lang_code', 1, 'https://ror.org/00jk4qh27 TECO'),
(505, 'https://ror.org/00jkkm943', 'pt', 1, 'https://ror.org/00jkkm943 Instituto Superior Manuel Teixeira Gomes'),
(506, 'https://ror.org/00jpae132', 'en', 1, 'https://ror.org/00jpae132 Hillingdon Hospital'),
(507, 'https://ror.org/00jpq0w62', 'fr', 1, 'https://ror.org/00jpq0w62 Centre Hospitalier Universitaire de Tours'),
(508, 'https://ror.org/00jq51013', 'en', 1, 'https://ror.org/00jq51013 Cardinal Glennon Children’s Medical Center'),
(509, 'https://ror.org/00jtwsb29', 'en', 1, 'https://ror.org/00jtwsb29 Suburban Hospital'),
(510, 'https://ror.org/00jv89z46', 'en', 1, 'https://ror.org/00jv89z46 Louisiana Board of Regents'),
(511, 'https://ror.org/00jw56w10', 'nl', 1, 'https://ror.org/00jw56w10 Slingeland Ziekenhuis'),
(512, 'https://ror.org/00jy2zq62', 'en', 1, 'https://ror.org/00jy2zq62 Gifu Prefectural Tajimi Hospital 岐阜県立多治見病院'),
(513, 'https://ror.org/00jy5cn48', 'en', 1, 'https://ror.org/00jy5cn48 Meitan General Hospital 煤炭总医院'),
(514, 'https://ror.org/00jy9e726', 'en', 1, 'https://ror.org/00jy9e726 Capital University'),
(515, 'https://ror.org/00jyx0v10', 'en', 1, 'https://ror.org/00jyx0v10 Alfred I. duPont Hospital for Children'),
(516, 'https://ror.org/00jzexr10', 'en', 1, 'https://ror.org/00jzexr10 Astrakhan State Technical University Астраханский государственный технический университет'),
(517, 'https://ror.org/00k1crd82', 'en', 1, 'https://ror.org/00k1crd82 Museum of Science'),
(518, 'https://ror.org/00k1xr956', 'en', 1, 'https://ror.org/00k1xr956 Grady Health System'),
(519, 'https://ror.org/00k27zs44', 'no_lang_code', 1, 'https://ror.org/00k27zs44 Oxford Biomedical Research'),
(520, 'https://ror.org/00k49k182', 'es', 1, 'https://ror.org/00k49k182 Hospital Virgen de la Luz'),
(521, 'https://ror.org/00k57ac30', 'pt', 1, 'https://ror.org/00k57ac30 Instituto Superior de Novas Profissões'),
(522, 'https://ror.org/00k5k8k03', 'no_lang_code', 1, 'https://ror.org/00k5k8k03 Tianjin Tianhe Hospital 天津市天和医院'),
(523, 'https://ror.org/00k5m1279', 'en', 1, 'https://ror.org/00k5m1279 West Virginia University at Parkersburg'),
(524, 'https://ror.org/00k5vcj72', 'en', 1, 'https://ror.org/00k5vcj72 Molde Hospital Molde sjukehus'),
(525, 'https://ror.org/00k7r7f88', 'en', 1, 'https://ror.org/00k7r7f88 Xuan Wu Hospital of the Capital Medical University 北京市老年病医疗研究中心'),
(526, 'https://ror.org/00k7zpp15', 'en', 1, 'https://ror.org/00k7zpp15 California Animal Hospital'),
(527, 'https://ror.org/00k8adf88', 'en', 1, 'https://ror.org/00k8adf88 Ahmedabad Civil Hospital'),
(528, 'https://ror.org/00k8kp236', 'en', 1, 'https://ror.org/00k8kp236 Applied Technology Council'),
(529, 'https://ror.org/00k9e1m49', 'en', 1, 'https://ror.org/00k9e1m49 Sri Devaraj Urs Medical College'),
(530, 'https://ror.org/00kays408', 'pt', 1, 'https://ror.org/00kays408 Universidade Gama Filho, University Gama Filho'),
(531, 'https://ror.org/00kb4qb80', 'en', 1, 'https://ror.org/00kb4qb80 Ogori Daiichi General Hospital 小郡第一総合病院'),
(532, 'https://ror.org/00kde4z41', 'pt', 1, 'https://ror.org/00kde4z41 Lutheran University of Brazil Universidad Luterana de Brasil Universidade Luterana do Brasil'),
(533, 'https://ror.org/00kfr4659', 'en', 1, 'https://ror.org/00kfr4659 Mito Red Cross Hospital 水戸赤十字病院'),
(534, 'https://ror.org/00kg66g91', 'en', 1, 'https://ror.org/00kg66g91 Women & Children''s Hospital of Buffalo'),
(535, 'https://ror.org/00kgerq53', 'en', 1, 'https://ror.org/00kgerq53 Hawaii Department of Health'),
(536, 'https://ror.org/00khh5r84', 'en', 1, 'https://ror.org/00khh5r84 Tokyo Gakugei University 東京学芸大学'),
(537, 'https://ror.org/00kmzgn35', 'en', 1, 'https://ror.org/00kmzgn35 Hawke''s Bay Hospital'),
(538, 'https://ror.org/00kmzyw28', 'tr', 1, 'https://ror.org/00kmzyw28 Ankara Atatürk Eğitim ve Araştırma Hastanesi'),
(539, 'https://ror.org/00knyd990', 'en', 1, 'https://ror.org/00knyd990 UK Intelligent Systems Research Institute'),
(540, 'https://ror.org/00krab219', 'en', 1, 'https://ror.org/00krab219 Nippon Medical School 日本医科大学'),
(541, 'https://ror.org/00ktqrd38', 'en', 1, 'https://ror.org/00ktqrd38 Kyoto Prefectural University 京都府立大学'),
(542, 'https://ror.org/00kv9pj15', 'no_lang_code', 1, 'https://ror.org/00kv9pj15 BT Group (United Kingdom)'),
(543, 'https://ror.org/00kx7fe64', 'en', 1, 'https://ror.org/00kx7fe64 Fukui Red Cross Hospital 福井赤十字病院'),
(544, 'https://ror.org/00ky3az31', 'en', 1, 'https://ror.org/00ky3az31 VA Puget Sound Health Care System'),
(545, 'https://ror.org/00kym4953', 'no_lang_code', 1, 'https://ror.org/00kym4953 Gemite Group'),
(546, 'https://ror.org/00kzych23', 'en', 1, 'https://ror.org/00kzych23 Nippon Sport Science University 日本体育大学'),
(547, 'https://ror.org/00m1n2078', 'no_lang_code', 1, 'https://ror.org/00m1n2078 CAE (Canada)'),
(548, 'https://ror.org/00m2ag473', 'en', 1, 'https://ror.org/00m2ag473 Archbold Biological Station'),
(549, 'https://ror.org/00m2etp60', 'en', 1, 'https://ror.org/00m2etp60 Holy Family Hospital Nazareth'),
(550, 'https://ror.org/00m4gxn44', 'en', 1, 'https://ror.org/00m4gxn44 Government Medical College'),
(551, 'https://ror.org/00m4rwq02', 'en', 1, 'https://ror.org/00m4rwq02 Christopher Newport University'),
(552, 'https://ror.org/00m5fzs56', 'en', 1, 'https://ror.org/00m5fzs56 Maebashi Red Cross Hospital 前橋赤十字病院'),
(553, 'https://ror.org/00m72p590', 'en', 1, 'https://ror.org/00m72p590 Saint Joseph''s Hospital'),
(554, 'https://ror.org/00m72wv30', 'en', 1, 'https://ror.org/00m72wv30 St. Joseph''s Hospital and Medical Center'),
(555, 'https://ror.org/00m860944', 'en', 1, 'https://ror.org/00m860944 St. Mary''s Hospital'),
(556, 'https://ror.org/00m8prc86', 'no_lang_code', 1, 'https://ror.org/00m8prc86 Deutsche Telekom (Germany) German Telecom'),
(557, 'https://ror.org/00m8tc820', 'en', 1, 'https://ror.org/00m8tc820 Kanazawa Medical Center 金沢医療センター'),
(558, 'https://ror.org/00m9c2804', 'en', 1, 'https://ror.org/00m9c2804 Philadelphia College of Osteopathic Medicine'),
(559, 'https://ror.org/00m9ydx43', 'en', 1, 'https://ror.org/00m9ydx43 National Hospital Organization Mito Medical Center 国立病院機構水戸医療センター'),
(560, 'https://ror.org/00mbaq869', 'en', 1, 'https://ror.org/00mbaq869 Timescape Surveys'),
(561, 'https://ror.org/00mbhee72', 'en', 1, 'https://ror.org/00mbhee72 University Medical Center of Princeton'),
(562, 'https://ror.org/00mbsbt95', 'it', 1, 'https://ror.org/00mbsbt95 Ospedale San Giovanni Bellinzona'),
(563, 'https://ror.org/00mc5wj35', 'en', 1, 'https://ror.org/00mc5wj35 Mudanjiang Medical University 牡丹江医学院'),
(564, 'https://ror.org/00mc91w09', 'it', 1, 'https://ror.org/00mc91w09 Ospedale Cisanello'),
(565, 'https://ror.org/00mch1v74', 'en', 1, 'https://ror.org/00mch1v74 John Muir Medical Center'),
(566, 'https://ror.org/00mczdx43', 'en', 1, 'https://ror.org/00mczdx43 National University of San Luis Universidad Nacional de San Luis'),
(567, 'https://ror.org/00md77g41', 'it', 1, 'https://ror.org/00md77g41 Casa Sollievo della Sofferenza Home for Relief of the Suffering'),
(568, 'https://ror.org/00menq219', 'en', 1, 'https://ror.org/00menq219 Naruto University of Education 鳴門教育大学'),
(569, 'https://ror.org/00meyvj69', 'en', 1, 'https://ror.org/00meyvj69 St. Lawrence River Institute of Environmental Sciences'),
(570, 'https://ror.org/00mj4n083', 'en', 1, 'https://ror.org/00mj4n083 St. Francis Hospital'),
(571, 'https://ror.org/00mj9k629', 'en', 1, 'https://ror.org/00mj9k629 Children''s Hospital Colorado'),
(572, 'https://ror.org/00mjaaf25', 'en', 1, 'https://ror.org/00mjaaf25 National School of Public Health'),
(573, 'https://ror.org/00mjawt10', 'en', 1, 'https://ror.org/00mjawt10 National Sun Yat-sen University'),
(574, 'https://ror.org/00mmq5f59', 'en', 1, 'https://ror.org/00mmq5f59 Mahatma Phule Krishi Vidyapeeth'),
(575, 'https://ror.org/00mns7k70', 'en', 1, 'https://ror.org/00mns7k70 Savannah State University Université d''État de Savannah'),
(576, 'https://ror.org/00mrcjr06', 'en', 1, 'https://ror.org/00mrcjr06 St. Luke''s Hospital'),
(577, 'https://ror.org/00mrhvv69', 'en', 1, 'https://ror.org/00mrhvv69 Kementerian Kesihatan Singapura Ministry of Health சிங்கப்பூர் சுகாதார அமைச்சகம் 新加坡卫生部'),
(578, 'https://ror.org/00mrw8k38', 'en', 1, 'https://ror.org/00mrw8k38 Ramkhamhaeng University มหาวิทยาลัยรามคำแหง'),
(579, 'https://ror.org/00mvp1q86', 'en', 1, 'https://ror.org/00mvp1q86 Hemwati Nandan Bahuguna Garhwal University गढ़वाल विश्वविद्यालय'),
(580, 'https://ror.org/00mwdv335', 'en', 1, 'https://ror.org/00mwdv335 Académie new-yorkaise de médecine New York Academy of Medicine'),
(581, 'https://ror.org/00mwhaw71', 'en', 1, 'https://ror.org/00mwhaw71 Mae Fah Luang University มหาวิทยาลัยแม่ฟ้าหลวง'),
(582, 'https://ror.org/00mwwa992', 'en', 1, 'https://ror.org/00mwwa992 Warde Medical Laboratory'),
(583, 'https://ror.org/00mynj496', 'no_lang_code', 1, 'https://ror.org/00mynj496 Glazer Medical Solutions (United States)'),
(584, 'https://ror.org/00mz0c648', 'en', 1, 'https://ror.org/00mz0c648 Boise VA Medical Center'),
(585, 'https://ror.org/00n14a494', 'en', 1, 'https://ror.org/00n14a494 Korea Polar Research Institute 극지연구소'),
(586, 'https://ror.org/00n1w4965', 'en', 1, 'https://ror.org/00n1w4965 MedStar Union Memorial Hospital'),
(587, 'https://ror.org/00n2w1t65', 'en', 1, 'https://ror.org/00n2w1t65 Presbyterian Hospital'),
(588, 'https://ror.org/00n3e1d98', 'en', 1, 'https://ror.org/00n3e1d98 Takasaki University of Health and Welfare 高崎健康福祉大学'),
(589, 'https://ror.org/00n3egs77', 'en', 1, 'https://ror.org/00n3egs77 Takamatsu Red Cross Hospital 高松赤十字病院'),
(590, 'https://ror.org/00n5htd36', 'en', 1, 'https://ror.org/00n5htd36 Westmar University'),
(591, 'https://ror.org/00n9v4y14', 'en', 1, 'https://ror.org/00n9v4y14 Good Samaritan Hospital'),
(592, 'https://ror.org/00nas2c56', 'no_lang_code', 1, 'https://ror.org/00nas2c56 Ericsson (Canada)'),
(593, 'https://ror.org/00ncfk576', 'en', 1, 'https://ror.org/00ncfk576 Stockholm South General Hospital'),
(594, 'https://ror.org/00nebyg34', 'en', 1, 'https://ror.org/00nebyg34 Central Maine Medical Center'),
(595, 'https://ror.org/00nf20x22', 'en', 1, 'https://ror.org/00nf20x22 Indira Gandhi Medical College and Research Institute'),
(596, 'https://ror.org/00ng6k310', 'en', 1, 'https://ror.org/00ng6k310 Chapel Allerton Hospital'),
(597, 'https://ror.org/00ngrq502', 'en', 1, 'https://ror.org/00ngrq502 Arak University دانشگاه اراک'),
(598, 'https://ror.org/00nh9x179', 'en', 1, 'https://ror.org/00nh9x179 St Bartholomew''s Hospital'),
(599, 'https://ror.org/00nhpk003', 'en', 1, 'https://ror.org/00nhpk003 Mount Auburn Hospital'),
(600, 'https://ror.org/00njz5525', 'en', 1, 'https://ror.org/00njz5525 Juravinski Hospital'),
(601, 'https://ror.org/00nk17n43', 'en', 1, 'https://ror.org/00nk17n43 University of Maine at Presque Isle'),
(602, 'https://ror.org/00nm7k655', 'en', 1, 'https://ror.org/00nm7k655 James Paget University Hospital'),
(603, 'https://ror.org/00nmnnk78', 'en', 1, 'https://ror.org/00nmnnk78 University Medical Center of El Paso'),
(604, 'https://ror.org/00nnh8h94', 'en', 1, 'https://ror.org/00nnh8h94 Red Cross Hospital'),
(605, 'https://ror.org/00nqxe643', 'en', 1, 'https://ror.org/00nqxe643 Cama and Albless Hospital'),
(606, 'https://ror.org/00nr17z89', 'en', 1, 'https://ror.org/00nr17z89 VA Palo Alto Health Care System'),
(607, 'https://ror.org/00nrgkr20', 'it', 1, 'https://ror.org/00nrgkr20 Cattinara Hospital Ospedale di Cattinara'),
(608, 'https://ror.org/00nrtez23', 'it', 1, 'https://ror.org/00nrtez23 Azienda Ospedaliero Universitaria San Giovanni Battista'),
(609, 'https://ror.org/00ns3e792', 'en', 1, 'https://ror.org/00ns3e792 King Edward Memorial Hospital'),
(610, 'https://ror.org/00nsz0a92', 'en', 1, 'https://ror.org/00nsz0a92 Omaha VA Medical Center'),
(611, 'https://ror.org/00nvxt968', 'de', 1, 'https://ror.org/00nvxt968 Universitätsklinikum des Saarlandes'),
(612, 'https://ror.org/00nwc4v84', 'tr', 1, 'https://ror.org/00nwc4v84 İstanbul Eğitim ve Araştırma Hastanesi'),
(613, 'https://ror.org/00nx6aa03', 'en', 1, 'https://ror.org/00nx6aa03 Mater Research'),
(614, 'https://ror.org/00nxna028', 'en', 1, 'https://ror.org/00nxna028 HR Wallingford'),
(615, 'https://ror.org/00ny8jb29', 'en', 1, 'https://ror.org/00ny8jb29 Office of the Medical Examiner of Cook County'),
(616, 'https://ror.org/00nyr7p12', 'en', 1, 'https://ror.org/00nyr7p12 Gauhati Medical College and Hospital গৌহাটী চিকিৎসা মহাবিদ্যালয়'),
(617, 'https://ror.org/00nyxxr91', 'en', 1, 'https://ror.org/00nyxxr91 Peking University Cancer Hospital 北京大学肿瘤医院'),
(618, 'https://ror.org/00nz9t738', 'en', 1, 'https://ror.org/00nz9t738 Ferrarotto Hospital'),
(619, 'https://ror.org/00nzje529', 'en', 1, 'https://ror.org/00nzje529 Antioch University New England'),
(620, 'https://ror.org/00p2tmy87', 'pt', 1, 'https://ror.org/00p2tmy87 Instituto Superior de Espinho'),
(621, 'https://ror.org/00p2x3741', 'en', 1, 'https://ror.org/00p2x3741 Southend Hospital'),
(622, 'https://ror.org/00p82hn55', 'en', 1, 'https://ror.org/00p82hn55 Salus University'),
(623, 'https://ror.org/00p8xqj61', 'en', 1, 'https://ror.org/00p8xqj61 Karpov Institute of Physical Chemistry Акционерное общество Ордена Трудового Красного Знамени научно-исследовательский физико-химический институт имени Л.Я. Карпова'),
(624, 'https://ror.org/00p9h0053', 'en', 1, 'https://ror.org/00p9h0053 Natural History Museum of Los Angeles County'),
(625, 'https://ror.org/00paq4p43', 'en', 1, 'https://ror.org/00paq4p43 Bay Pines VA Healthcare System'),
(626, 'https://ror.org/00pb8h375', 'en', 1, 'https://ror.org/00pb8h375 Bauman Moscow State Technical University Московский государственный технический университет имени Н. Э. Баумана'),
(627, 'https://ror.org/00pbh0a34', 'en', 1, 'https://ror.org/00pbh0a34 British Museum Yr Amgueddfa Brydeinig'),
(628, 'https://ror.org/00pcrz470', 'en', 1, 'https://ror.org/00pcrz470 Chengdu University of Traditional Chinese Medicine 成都中医药大学'),
(629, 'https://ror.org/00pczg388', 'en', 1, 'https://ror.org/00pczg388 Sinclair Community College'),
(630, 'https://ror.org/00pefnv05', 'en', 1, 'https://ror.org/00pefnv05 Museum of Heilongjiang Province 黑龙江省博物馆'),
(631, 'https://ror.org/00pf0g237', 'no_lang_code', 1, 'https://ror.org/00pf0g237 Theragen'),
(632, 'https://ror.org/00pg98t08', 'en', 1, 'https://ror.org/00pg98t08 Francis Marion University'),
(633, 'https://ror.org/00pg9d188', 'en', 1, 'https://ror.org/00pg9d188 Al Noor Hospitals'),
(634, 'https://ror.org/00pk1yr39', 'en', 1, 'https://ror.org/00pk1yr39 Sørlandet Hospital Arendal Sørlandet Sykehus HF'),
(635, 'https://ror.org/00pmcf502', 'no_lang_code', 1, 'https://ror.org/00pmcf502 Talisman Energy'),
(636, 'https://ror.org/00pq96s96', 'en', 1, 'https://ror.org/00pq96s96 UMass Memorial Health Care'),
(637, 'https://ror.org/00prpaj09', 'no_lang_code', 1, 'https://ror.org/00prpaj09 Alion Science and Technology (United States)'),
(638, 'https://ror.org/00pw0pp06', 'en', 1, 'https://ror.org/00pw0pp06 Graz University Hospital Univ. Klinikum Graz'),
(639, 'https://ror.org/00q09pe49', 'en', 1, 'https://ror.org/00q09pe49 National Taiwan University of Science and Technology'),
(640, 'https://ror.org/00q38e504', 'no_lang_code', 1, 'https://ror.org/00q38e504 Lerdsin Hospital โรงพยาบาลเลิดสิน'),
(641, 'https://ror.org/00q5txg88', 'en', 1, 'https://ror.org/00q5txg88 Plains Health Centre'),
(642, 'https://ror.org/00q6w3x44', 'en', 1, 'https://ror.org/00q6w3x44 Ellis Hospital'),
(643, 'https://ror.org/00q6wbs64', 'no_lang_code', 1, 'https://ror.org/00q6wbs64 Tianjin Huanhu Hospital 天津市环湖医院'),
(644, 'https://ror.org/00q75av54', 'en', 1, 'https://ror.org/00q75av54 South Tyneside District Hospital'),
(645, 'https://ror.org/00qcsrr17', 'en', 1, 'https://ror.org/00qcsrr17 Wilhelminen Hospital Wilhelminenspital'),
(646, 'https://ror.org/00qctrq52', 'en', 1, 'https://ror.org/00qctrq52 Manipal College of Medical Sciences'),
(647, 'https://ror.org/00qdkc036', 'no_lang_code', 1, 'https://ror.org/00qdkc036 Hoshigaoka Medical Center 星ヶ丘医療センター'),
(648, 'https://ror.org/00qdsfq65', 'en', 1, 'https://ror.org/00qdsfq65 Korea National Institute of Health'),
(649, 'https://ror.org/00qexeh70', 'en', 1, 'https://ror.org/00qexeh70 Middlesex Hospital'),
(650, 'https://ror.org/00qezxe61', 'no_lang_code', 1, 'https://ror.org/00qezxe61 Ikeda Municipal Hospital 池田市立病院'),
(651, 'https://ror.org/00qfq7b40', 'no_lang_code', 1, 'https://ror.org/00qfq7b40 PerkinElmer Biosignal'),
(652, 'https://ror.org/00qhe6a56', 'no_lang_code', 1, 'https://ror.org/00qhe6a56 Miltenyi Biotec (Germany)'),
(653, 'https://ror.org/00qkhxq50', 'en', 1, 'https://ror.org/00qkhxq50 Jessa Hospital Jessa Ziekenhuis'),
(654, 'https://ror.org/00qmnd673', 'en', 1, 'https://ror.org/00qmnd673 Kindai University Hospital 近畿大学医学部 附属病院'),
(655, 'https://ror.org/00qp1n828', 'en', 1, 'https://ror.org/00qp1n828 King George Hospital'),
(656, 'https://ror.org/00qpv3w06', 'en', 1, 'https://ror.org/00qpv3w06 Amref Health Africa'),
(657, 'https://ror.org/00qt4k071', 'it', 1, 'https://ror.org/00qt4k071 Ospedale San Filippo Neri'),
(658, 'https://ror.org/00qt5ka73', 'no_lang_code', 1, 'https://ror.org/00qt5ka73 Arttic (France)'),
(659, 'https://ror.org/00qvx5329', 'en', 1, 'https://ror.org/00qvx5329 Doheny Eye Institute'),
(660, 'https://ror.org/00qwnam72', 'en', 1, 'https://ror.org/00qwnam72 Chiba Institute of Technology 千葉工業大学'),
(661, 'https://ror.org/00qz24g20', 'en', 1, 'https://ror.org/00qz24g20 University of North Carolina Health Care'),
(662, 'https://ror.org/00qzd4032', 'no_lang_code', 1, 'https://ror.org/00qzd4032 Quality Biological'),
(663, 'https://ror.org/00r1hxj45', 'en', 1, 'https://ror.org/00r1hxj45 Noor Eye Hospital بیمارستان چشم‌پزشکی نور'),
(664, 'https://ror.org/00r2gde63', 'en', 1, 'https://ror.org/00r2gde63 Ascamm Technologic Center Centro Tecnológico Ascamm'),
(665, 'https://ror.org/00r520291', 'en', 1, 'https://ror.org/00r520291 St. Joseph''s Hospital'),
(666, 'https://ror.org/00r59hk87', 'en', 1, 'https://ror.org/00r59hk87 North Kansas City Hospital'),
(667, 'https://ror.org/00r5kgd36', 'en', 1, 'https://ror.org/00r5kgd36 Nenagh Hospital Ospidéal an Aonaigh'),
(668, 'https://ror.org/00r5mr697', 'en', 1, 'https://ror.org/00r5mr697 Western New Mexico University'),
(669, 'https://ror.org/00r66pz14', 'en', 1, 'https://ror.org/00r66pz14 Natural England'),
(670, 'https://ror.org/00r67fz39', 'en', 1, 'https://ror.org/00r67fz39 Second Affiliated Hospital of Chongqing Medical University'),
(671, 'https://ror.org/00r9g7t11', 'en', 1, 'https://ror.org/00r9g7t11 Oregon University System'),
(672, 'https://ror.org/00ra1fg11', 'en', 1, 'https://ror.org/00ra1fg11 Pennsylvania Department of Health'),
(673, 'https://ror.org/00rey4c89', 'no_lang_code', 1, 'https://ror.org/00rey4c89 General Electric (Canada)'),
(674, 'https://ror.org/00rfgpg89', 'en', 1, 'https://ror.org/00rfgpg89 Salem Hospital'),
(675, 'https://ror.org/00rh8m666', 'en', 1, 'https://ror.org/00rh8m666 Institute For Defense Analyses Instituto de Análisis de la Defensa'),
(676, 'https://ror.org/00rjw0467', 'en', 1, 'https://ror.org/00rjw0467 St. Vincent Hospital'),
(677, 'https://ror.org/00rkxs190', 'no_lang_code', 1, 'https://ror.org/00rkxs190 TDA Research (United States)'),
(678, 'https://ror.org/00rm3wf49', 'en', 1, 'https://ror.org/00rm3wf49 Lilavati Hospital & Research Centre'),
(679, 'https://ror.org/00rpfyx16', 'en', 1, 'https://ror.org/00rpfyx16 Belvidere Hospital'),
(680, 'https://ror.org/00rt1d436', 'en', 1, 'https://ror.org/00rt1d436 American Psychological Association'),
(681, 'https://ror.org/00rws8x56', 'en', 1, 'https://ror.org/00rws8x56 Gimpo Airport Wooridul Spine Hospital 서울우리들병원'),
(682, 'https://ror.org/00rz5xc38', 'en', 1, 'https://ror.org/00rz5xc38 Mississippi Valley State University'),
(683, 'https://ror.org/00rzeqe23', 'en', 1, 'https://ror.org/00rzeqe23 Institut postgraduálního vzdělávání ve zdravotnictví Institute for Postgraduate Medical Education'),
(684, 'https://ror.org/00s31qp90', 'en', 1, 'https://ror.org/00s31qp90 Operation PAR'),
(685, 'https://ror.org/00s4vhs88', 'es', 1, 'https://ror.org/00s4vhs88 Doctor Negrín University Hospital Hospital Universitario de Gran Canaria Doctor Negrín'),
(686, 'https://ror.org/00s58vq35', 'en', 1, 'https://ror.org/00s58vq35 Instituto Superior Bissaya Barreto'),
(687, 'https://ror.org/00s5x0w83', 'es', 1, 'https://ror.org/00s5x0w83 Almirante Nef Naval Hospital Hospital Naval Almirante Nef'),
(688, 'https://ror.org/00s7qjp35', 'pt', 1, 'https://ror.org/00s7qjp35 Universidade Vale do Rio Verde'),
(689, 'https://ror.org/00s8bsd30', 'en', 1, 'https://ror.org/00s8bsd30 Via Christi Hospital St. Francis'),
(690, 'https://ror.org/00s9dpb54', 'en', 1, 'https://ror.org/00s9dpb54 Myongji University 명지대학교'),
(691, 'https://ror.org/00sbqe313', 'en', 1, 'https://ror.org/00sbqe313 Sacred Heart Medical Center'),
(692, 'https://ror.org/00se0qr64', 'en', 1, 'https://ror.org/00se0qr64 Summit Oaks Hospital'),
(693, 'https://ror.org/00sf92s91', 'en', 1, 'https://ror.org/00sf92s91 Lehigh Valley Health Network'),
(694, 'https://ror.org/00sge8677', 'en', 1, 'https://ror.org/00sge8677 BRAC University ব্র্যাক ইউনিভার্সিটি'),
(695, 'https://ror.org/00sh4ma05', 'en', 1, 'https://ror.org/00sh4ma05 Southwestern Oregon Community College'),
(696, 'https://ror.org/00shmxd32', 'en', 1, 'https://ror.org/00shmxd32 PBMA''s H.V. Desai Eye Hospital'),
(697, 'https://ror.org/00skrw306', 'en', 1, 'https://ror.org/00skrw306 Colorado Department of Human Services'),
(698, 'https://ror.org/00skwgg83', 'en', 1, 'https://ror.org/00skwgg83 Fukuoka Women''s University 福岡女子大学'),
(699, 'https://ror.org/00sm8k518', 'it', 1, 'https://ror.org/00sm8k518 Azienda Ospedaliera Universitaria Integrata Verona'),
(700, 'https://ror.org/00smq1v26', 'en', 1, 'https://ror.org/00smq1v26 Saitama Children''s Medical Center 埼玉県立小児医療センター'),
(701, 'https://ror.org/00smwky98', 'no_lang_code', 1, 'https://ror.org/00smwky98 Tokushima Bunri University 徳島文理大学'),
(702, 'https://ror.org/00snwj435', 'en', 1, 'https://ror.org/00snwj435 Shriners Hospitals for Children - Portland'),
(703, 'https://ror.org/00spnmn10', 'no_lang_code', 1, 'https://ror.org/00spnmn10 Whalen Biomedical'),
(704, 'https://ror.org/00spys463', 'en', 1, 'https://ror.org/00spys463 Los Angeles Medical Center'),
(705, 'https://ror.org/00sqp6g97', 'fr', 1, 'https://ror.org/00sqp6g97 Centre hospitalier Emile Roux'),
(706, 'https://ror.org/00swp5c87', 'en', 1, 'https://ror.org/00swp5c87 Gynuity Health Projects'),
(707, 'https://ror.org/00swtwf35', 'en', 1, 'https://ror.org/00swtwf35 Chest Diseases Hospital المستشفى الصدري'),
(708, 'https://ror.org/00swv7d52', 'en', 1, 'https://ror.org/00swv7d52 Penn Presbyterian Medical Center'),
(709, 'https://ror.org/00sxe0e68', 'en', 1, 'https://ror.org/00sxe0e68 Harper University Hospital'),
(710, 'https://ror.org/00t0h7472', 'pt', 1, 'https://ror.org/00t0h7472 Escola Superior de Educadores de Infância Maria Ulrich'),
(711, 'https://ror.org/00t1xpx62', 'fr', 1, 'https://ror.org/00t1xpx62 Hôpital Kirchberg'),
(712, 'https://ror.org/00t2n7611', 'da', 1, 'https://ror.org/00t2n7611 Roskilde Hospital Roskilde Sygehus'),
(713, 'https://ror.org/00t30ch44', 'en', 1, 'https://ror.org/00t30ch44 Midwestern State University Université d''État du midwest'),
(714, 'https://ror.org/00t3s0v26', 'en', 1, 'https://ror.org/00t3s0v26 Lok Nayak Jai Prakash Narayan Hospital'),
(715, 'https://ror.org/00t47w971', 'en', 1, 'https://ror.org/00t47w971 Clayton State University'),
(716, 'https://ror.org/00t61fh47', 'en', 1, 'https://ror.org/00t61fh47 Ijinkai Takeda General Hospital 武田総合病院は'),
(717, 'https://ror.org/00t9hhv14', 'en', 1, 'https://ror.org/00t9hhv14 University of South Carolina Upstate'),
(718, 'https://ror.org/00tapj019', 'en', 1, 'https://ror.org/00tapj019 Asociación de Universidades Americanas Association des universités américaines Association of American Universities'),
(719, 'https://ror.org/00tb6zr84', 'en', 1, 'https://ror.org/00tb6zr84 American School Health Association'),
(720, 'https://ror.org/00tcmr651', 'en', 1, 'https://ror.org/00tcmr651 Kathmandu Medical College Teaching Hospital'),
(721, 'https://ror.org/00tdzhd41', 'es', 1, 'https://ror.org/00tdzhd41 Hospital Fernández'),
(722, 'https://ror.org/00te55z70', 'fi', 1, 'https://ror.org/00te55z70 Mikkelin keskussairaala'),
(723, 'https://ror.org/00tfedq56', 'en', 1, 'https://ror.org/00tfedq56 Center for Medical, Agricultural and Veterinary Entomology'),
(724, 'https://ror.org/00tg1yh20', 'no_lang_code', 1, 'https://ror.org/00tg1yh20 Aetna (United States)'),
(725, 'https://ror.org/00tjv0s33', 'en', 1, 'https://ror.org/00tjv0s33 Keimyung University 계명대학교'),
(726, 'https://ror.org/00tkrd758', 'en', 1, 'https://ror.org/00tkrd758 Gartnavel General Hospital'),
(727, 'https://ror.org/00tnppw48', 'en', 1, 'https://ror.org/00tnppw48 Adran yr Amgylchedd, Bwyd a Materion Gwledig Department for Environment Food and Rural Affairs'),
(728, 'https://ror.org/00tq7xg10', 'en', 1, 'https://ror.org/00tq7xg10 Suzuka University of Medical Science 鈴鹿医療科学大学'),
(729, 'https://ror.org/00trhvv58', 'en', 1, 'https://ror.org/00trhvv58 Shriners Hospitals for Children - Greenville'),
(730, 'https://ror.org/00tt53p64', 'en', 1, 'https://ror.org/00tt53p64 SRC'),
(731, 'https://ror.org/00tta1k37', 'en', 1, 'https://ror.org/00tta1k37 Folktandvården Västra Götaland Public Dental Service Västra Götaland'),
(732, 'https://ror.org/00tw3jy02', 'en', 1, 'https://ror.org/00tw3jy02 MRC Laboratory of Molecular Biology'),
(733, 'https://ror.org/00ty4jc02', 'en', 1, 'https://ror.org/00ty4jc02 St. Luke''s Hospital Foundation'),
(734, 'https://ror.org/00tze5d69', 'en', 1, 'https://ror.org/00tze5d69 Teikyo University Hospital 帝京大学医学部附属病院'),
(735, 'https://ror.org/00tzmb306', 'en', 1, 'https://ror.org/00tzmb306 Danish Maritime Institute'),
(736, 'https://ror.org/00v3ak792', 'en', 1, 'https://ror.org/00v3ak792 Universidad de Dallas University of Dallas Université de Dallas'),
(737, 'https://ror.org/00v47dk08', 'no_lang_code', 1, 'https://ror.org/00v47dk08 Ebara Hospital 東京都保健医療公社荏原病院'),
(738, 'https://ror.org/00v4dac24', 'en', 1, 'https://ror.org/00v4dac24 Leeds Teaching Hospitals NHS Trust'),
(739, 'https://ror.org/00v5h4y49', 'en', 1, 'https://ror.org/00v5h4y49 Derriford Hospital'),
(740, 'https://ror.org/00v6af077', 'en', 1, 'https://ror.org/00v6af077 Calvary Hospital'),
(741, 'https://ror.org/00v6s9648', 'en', 1, 'https://ror.org/00v6s9648 University of Worcester'),
(742, 'https://ror.org/00v81k483', 'en', 1, 'https://ror.org/00v81k483 Mokpo National University 목포대학교'),
(743, 'https://ror.org/00v8fdc16', 'en', 1, 'https://ror.org/00v8fdc16 Autonomous University of Queretaro Universidad Autónoma de Querétaro'),
(744, 'https://ror.org/00var5q80', 'en', 1, 'https://ror.org/00var5q80 American Geophysical Union'),
(745, 'https://ror.org/00vbnvy39', 'en', 1, 'https://ror.org/00vbnvy39 Montgomery General Hospital'),
(746, 'https://ror.org/00vcyhn10', 'pt', 1, 'https://ror.org/00vcyhn10 Catholic University of Santos Universidade Católica de Santos'),
(747, 'https://ror.org/00vhhbt37', 'en', 1, 'https://ror.org/00vhhbt37 Howard Payne University'),
(748, 'https://ror.org/00vhr7p75', 'en', 1, 'https://ror.org/00vhr7p75 Battle Hospital'),
(749, 'https://ror.org/00vjb5165', 'en', 1, 'https://ror.org/00vjb5165 Ministry of Health'),
(750, 'https://ror.org/00vkrxq08', 'en', 1, 'https://ror.org/00vkrxq08 University Malaya Medical Centre'),
(751, 'https://ror.org/00vmr1p37', 'en', 1, 'https://ror.org/00vmr1p37 Seacroft Hospital'),
(752, 'https://ror.org/00vpv1x26', 'en', 1, 'https://ror.org/00vpv1x26 Tokyo Medical University Hachioji Medical Center 東京医科大学八王子医療センター'),
(753, 'https://ror.org/00vpw9h05', 'en', 1, 'https://ror.org/00vpw9h05 Honolulu Community College'),
(754, 'https://ror.org/00vqhxg21', 'no_lang_code', 1, 'https://ror.org/00vqhxg21 SMEC (Australia)'),
(755, 'https://ror.org/00vv7qz60', 'no_lang_code', 1, 'https://ror.org/00vv7qz60 Fukuoka Hospital 福岡病院'),
(756, 'https://ror.org/00vvvt117', 'en', 1, 'https://ror.org/00vvvt117 Sookmyung Women''s University 숙명여자대학교'),
(757, 'https://ror.org/00vx2w009', 'en', 1, 'https://ror.org/00vx2w009 Lapin keskussairaala Lapland Central Hospital'),
(758, 'https://ror.org/00vxe3x87', 'de', 1, 'https://ror.org/00vxe3x87 Sternwarte Stuttgart, Stuttgart Observatory'),
(759, 'https://ror.org/00vyyx863', 'en', 1, 'https://ror.org/00vyyx863 Eastern Health'),
(760, 'https://ror.org/00vznbp60', 'no_lang_code', 1, 'https://ror.org/00vznbp60 Alpha Universe'),
(761, 'https://ror.org/00vzzhs86', 'no_lang_code', 1, 'https://ror.org/00vzzhs86 Sir Hurkisondas Nurrotumdas Medical Research Society'),
(762, 'https://ror.org/00w1fsg08', 'en', 1, 'https://ror.org/00w1fsg08 Hyogo Prefectural Awaji Medical Center 兵庫県立淡路医療センター'),
(763, 'https://ror.org/00w6bqp33', 'en', 1, 'https://ror.org/00w6bqp33 National University of Health Sciences'),
(764, 'https://ror.org/00w7dj406', 'en', 1, 'https://ror.org/00w7dj406 American Society of Health-System Pharmacists'),
(765, 'https://ror.org/00w7vnc45', 'en', 1, 'https://ror.org/00w7vnc45 America''s Health Insurance Plans'),
(766, 'https://ror.org/00w81q081', 'fr', 1, 'https://ror.org/00w81q081 Hôpital Albert Calmette'),
(767, 'https://ror.org/00w93dg44', 'en', 1, 'https://ror.org/00w93dg44 Na Homolce Hospital Nemocnice Na Homolce'),
(768, 'https://ror.org/00watgv28', 'en', 1, 'https://ror.org/00watgv28 College of Saint Benedict and Saint John''s University Collège de saint benedict et université de saint jean'),
(769, 'https://ror.org/00wbzw723', 'en', 1, 'https://ror.org/00wbzw723 University of Washington Medical Center'),
(770, 'https://ror.org/00wc07928', 'en', 1, 'https://ror.org/00wc07928 University of Lomé Université de Lomé'),
(771, 'https://ror.org/00we60833', 'en', 1, 'https://ror.org/00we60833 Women''s & Children''s Health Research Institute'),
(772, 'https://ror.org/00wejpz79', 'en', 1, 'https://ror.org/00wejpz79 Hyogo University of Teacher Education 兵庫教育大学'),
(773, 'https://ror.org/00wemg618', 'en', 1, 'https://ror.org/00wemg618 Youjiang Medical College for Nationalities 右江民族医学院'),
(774, 'https://ror.org/00wfvh315', 'en', 1, 'https://ror.org/00wfvh315 Charles Sturt University'),
(775, 'https://ror.org/00wfvxt55', 'en', 1, 'https://ror.org/00wfvxt55 Minnesota Department of Human Services'),
(776, 'https://ror.org/00wg2b048', 'en', 1, 'https://ror.org/00wg2b048 Royal University Hospital'),
(777, 'https://ror.org/00whfdj78', 'no_lang_code', 1, 'https://ror.org/00whfdj78 BioTek (United States)'),
(778, 'https://ror.org/00wk9vd23', 'en', 1, 'https://ror.org/00wk9vd23 Regionshospitalet Skive Skive Hospital'),
(779, 'https://ror.org/00wkhef66', 'en', 1, 'https://ror.org/00wkhef66 Reinier de Graaf Hospital'),
(780, 'https://ror.org/00wksha49', 'en', 1, 'https://ror.org/00wksha49 National Institute of Biological Sciences, Beijing 北京生命科学研究所'),
(781, 'https://ror.org/00wm07d60', 'en', 1, 'https://ror.org/00wm07d60 Van Andel Institute'),
(782, 'https://ror.org/00wmm6v75', 'en', 1, 'https://ror.org/00wmm6v75 American University of Beirut Medical Center'),
(783, 'https://ror.org/00wn7d965', 'en', 1, 'https://ror.org/00wn7d965 University of Virginia Health System'),
(784, 'https://ror.org/00wpte173', 'en', 1, 'https://ror.org/00wpte173 Grey Nuns Community Hospital'),
(785, 'https://ror.org/00wr13y59', 'en', 1, 'https://ror.org/00wr13y59 Lutheran Medical Center'),
(786, 'https://ror.org/00wspbn44', 'en', 1, 'https://ror.org/00wspbn44 Canterbury Health Laboratories'),
(787, 'https://ror.org/00wt7xg39', 'no_lang_code', 1, 'https://ror.org/00wt7xg39 Westat (United States)'),
(788, 'https://ror.org/00wtgx181', 'en', 1, 'https://ror.org/00wtgx181 Highland Hospital'),
(789, 'https://ror.org/00wtq7t14', 'en', 1, 'https://ror.org/00wtq7t14 Governors State University'),
(790, 'https://ror.org/00wygsf57', 'en', 1, 'https://ror.org/00wygsf57 Dongseo University 동서대학교'),
(791, 'https://ror.org/00wys9y90', 'en', 1, 'https://ror.org/00wys9y90 Herlev Hospital'),
(792, 'https://ror.org/00wyx7h61', 'en', 1, 'https://ror.org/00wyx7h61 Royal Alexandra Hospital'),
(793, 'https://ror.org/00wzdr059', 'en', 1, 'https://ror.org/00wzdr059 St. Paul''s Hospital'),
(794, 'https://ror.org/00wzt9y79', 'en', 1, 'https://ror.org/00wzt9y79 Ohio Cancer Research Associates'),
(795, 'https://ror.org/00x396v48', 'en', 1, 'https://ror.org/00x396v48 Mendota Mental Health Institute'),
(796, 'https://ror.org/00x3rpv59', 'en', 1, 'https://ror.org/00x3rpv59 Tomsk State Pedagogical University Томский государственный педагогический университет'),
(797, 'https://ror.org/00x5b2p37', 'en', 1, 'https://ror.org/00x5b2p37 Carroll College'),
(798, 'https://ror.org/00x8ccz20', 'en', 1, 'https://ror.org/00x8ccz20 University of Wisconsin–La Crosse Université du Wisconsin–La Crosse'),
(799, 'https://ror.org/00xb4cb83', 'en', 1, 'https://ror.org/00xb4cb83 Southern Arizona VA Health Care System'),
(800, 'https://ror.org/00xc08717', 'en', 1, 'https://ror.org/00xc08717 Whitchurch Hospital'),
(801, 'https://ror.org/00xdn8y92', 'en', 1, 'https://ror.org/00xdn8y92 Punjabi University पंजाबी विश्वविद्यालय ਪੰਜਾਬੀ ਯੂਨੀਵਰਸਿਟੀ'),
(802, 'https://ror.org/00xgvev73', 'es', 1, 'https://ror.org/00xgvev73 Instituto Nacional de Ciencias Médicas y Nutrición Salvador Zubirán National Institute of Medical Sciences and Nutrition Salvador Zubirán'),
(803, 'https://ror.org/00xmkp704', 'en', 1, 'https://ror.org/00xmkp704 Ghent University Hospital Universitair Ziekenhuis Gent'),
(804, 'https://ror.org/00xmn3c34', 'en', 1, 'https://ror.org/00xmn3c34 Monmouth Medical Center'),
(805, 'https://ror.org/00xmzb398', 'pt', 1, 'https://ror.org/00xmzb398 Hospital Alemão Oswaldo Cruz'),
(806, 'https://ror.org/00xnmcq32', 'en', 1, 'https://ror.org/00xnmcq32 Grey''s Hospital'),
(807, 'https://ror.org/00xpcm295', 'en', 1, 'https://ror.org/00xpcm295 Wyoming State Department of Health'),
(808, 'https://ror.org/00xwgyp12', 'pt', 1, 'https://ror.org/00xwgyp12 Federal Rural University of Rio de Janeiro Universidade Federal Rural do Rio de Janeiro'),
(809, 'https://ror.org/00xyeez13', 'en', 1, 'https://ror.org/00xyeez13 Kunming University of Science and Technology 昆明理工大学'),
(810, 'https://ror.org/00xz1cn67', 'no_lang_code', 1, 'https://ror.org/00xz1cn67 Saiseikai Kumamoto Hospital 済生会熊本病院'),
(811, 'https://ror.org/00xz7ma09', 'fr', 1, 'https://ror.org/00xz7ma09 Hôpital régional'),
(812, 'https://ror.org/00xzbkw82', 'en', 1, 'https://ror.org/00xzbkw82 Ohkawara Neurosurgical Hospital 大川原脳神経外科病院'),
(813, 'https://ror.org/00xznf773', 'en', 1, 'https://ror.org/00xznf773 Auburn Community Hospital'),
(814, 'https://ror.org/00y1kmp77', 'en', 1, 'https://ror.org/00y1kmp77 NIMTS Hospital'),
(815, 'https://ror.org/00y3cpn63', 'en', 1, 'https://ror.org/00y3cpn63 Tachikawa Medical Center 立川メディカルセンター'),
(816, 'https://ror.org/00y64dx33', 'en', 1, 'https://ror.org/00y64dx33 Monroe Carell Jr. Children''s Hospital'),
(817, 'https://ror.org/00y6akb91', 'no_lang_code', 1, 'https://ror.org/00y6akb91 Revolution Analytics (United States)'),
(818, 'https://ror.org/00ydm0027', 'en', 1, 'https://ror.org/00ydm0027 University of Maine at Farmington'),
(819, 'https://ror.org/00yeama42', 'no_lang_code', 1, 'https://ror.org/00yeama42 Compact Membrane Systems (United States)'),
(820, 'https://ror.org/00yep6g06', 'en', 1, 'https://ror.org/00yep6g06 Kaiser Foundation Hospital'),
(821, 'https://ror.org/00yeysh84', 'en', 1, 'https://ror.org/00yeysh84 Lake Superior State University Université d''État du lac supérieur'),
(822, 'https://ror.org/00yfpz909', 'en', 1, 'https://ror.org/00yfpz909 Unity Health System'),
(823, 'https://ror.org/00yghrj63', 'en', 1, 'https://ror.org/00yghrj63 Hendrix College'),
(824, 'https://ror.org/00ygzyy93', 'en', 1, 'https://ror.org/00ygzyy93 Independent University of Moscow Независимый Московский университет'),
(825, 'https://ror.org/00yhnba62', 'en', 1, 'https://ror.org/00yhnba62 Qatar University Universidad de Catar جامعة قطر'),
(826, 'https://ror.org/00yj3jn96', 'en', 1, 'https://ror.org/00yj3jn96 Hunterdon Medical Center'),
(827, 'https://ror.org/00ykktm91', 'pt', 1, 'https://ror.org/00ykktm91 Instituto Superior de Línguas e Administração'),
(828, 'https://ror.org/00ym4dr28', 'pt', 1, 'https://ror.org/00ym4dr28 Hospital Militar Principal'),
(829, 'https://ror.org/00yp6m473', 'en', 1, 'https://ror.org/00yp6m473 Udmurt State University Удмуртский государственный университет'),
(830, 'https://ror.org/00yr70j54', 'en', 1, 'https://ror.org/00yr70j54 Tauranga Hospital'),
(831, 'https://ror.org/00ys1hz88', 'en', 1, 'https://ror.org/00ys1hz88 Nagaoka University of Technology 長岡技術科学大学'),
(832, 'https://ror.org/00ysvbp68', 'en', 1, 'https://ror.org/00ysvbp68 Institute of Post Graduate Medical Education and Research'),
(833, 'https://ror.org/00yv3xr02', 'en', 1, 'https://ror.org/00yv3xr02 Ome Municipal General Hospital 青梅市立総合病院'),
(834, 'https://ror.org/00yw5v481', 'en', 1, 'https://ror.org/00yw5v481 Prince George''s Community College'),
(835, 'https://ror.org/00yx91b22', 'en', 1, 'https://ror.org/00yx91b22 Barnsley Hospital NHS Foundation Trust'),
(836, 'https://ror.org/00yyp2526', 'en', 1, 'https://ror.org/00yyp2526 Silsoe Research Institute'),
(837, 'https://ror.org/00z0drp11', 'no_lang_code', 1, 'https://ror.org/00z0drp11 Agnico Eagle (Canada)'),
(838, 'https://ror.org/00z0ne711', 'en', 1, 'https://ror.org/00z0ne711 Saint Francis Hospital'),
(839, 'https://ror.org/00z0xmg52', 'it', 1, 'https://ror.org/00z0xmg52 Ospedale Santa Maria alle Scotte Santa Maria alle Scotte Hospital'),
(840, 'https://ror.org/00z1vyk43', 'en', 1, 'https://ror.org/00z1vyk43 King Fahd Armed Forces Hospital مستشفى الملك فهد للقوات المسلحة'),
(841, 'https://ror.org/00z28d984', 'it', 1, 'https://ror.org/00z28d984 Azienda ospedaliera "Bianchi-Melacrino-Morelli"'),
(842, 'https://ror.org/00z2qhk53', 'en', 1, 'https://ror.org/00z2qhk53 University of Wisconsin–Superior Université du Wisconsin–Superior'),
(843, 'https://ror.org/00z769k62', 'pt', 1, 'https://ror.org/00z769k62 Hospital de Faro EPE'),
(844, 'https://ror.org/00z847107', 'pt', 1, 'https://ror.org/00z847107 Escola Superior de Educação de Torres Novas'),
(845, 'https://ror.org/00z9qkg54', 'en', 1, 'https://ror.org/00z9qkg54 Highland Hospital'),
(846, 'https://ror.org/00z9zsj19', 'en', 1, 'https://ror.org/00z9zsj19 Butler Hospital'),
(847, 'https://ror.org/00zat6v61', 'en', 1, 'https://ror.org/00zat6v61 Guangzhou Medical University 广州医科大学'),
(848, 'https://ror.org/00zb26x20', 'en', 1, 'https://ror.org/00zb26x20 Ural State University of Economics Уральский государственный экономический университет'),
(849, 'https://ror.org/00zbht122', 'es', 1, 'https://ror.org/00zbht122 Hospital Xeral Calde'),
(850, 'https://ror.org/00zc7y345', 'pt', 1, 'https://ror.org/00zc7y345 Hospital de São José'),
(851, 'https://ror.org/00zcy2665', 'en', 1, 'https://ror.org/00zcy2665 Vestfold University College'),
(852, 'https://ror.org/00zdnkx70', 'en', 1, 'https://ror.org/00zdnkx70 National Tsing Hua University'),
(853, 'https://ror.org/00zerva91', 'en', 1, 'https://ror.org/00zerva91 St. Patrick Hospital'),
(854, 'https://ror.org/00zfzef50', 'en', 1, 'https://ror.org/00zfzef50 National Development and Research Institutes'),
(855, 'https://ror.org/00zhvdn11', 'en', 1, 'https://ror.org/00zhvdn11 Tunghai University 東海大學'),
(856, 'https://ror.org/00zjtek40', 'tr', 1, 'https://ror.org/00zjtek40 Dicle Üniversitesi Hastaneleri'),
(857, 'https://ror.org/00zpz3d35', 'en', 1, 'https://ror.org/00zpz3d35 Nevill Hall Hospital'),
(858, 'https://ror.org/00zrfhe30', 'nl', 1, 'https://ror.org/00zrfhe30 Onze Lieve Vrouwziekenhuis Hospital'),
(859, 'https://ror.org/00zszzj16', 'en', 1, 'https://ror.org/00zszzj16 Al Amal Hospital Jeddah'),
(860, 'https://ror.org/00zydn239', 'tr', 1, 'https://ror.org/00zydn239 Adana Numune Eğitim ve Araştırma Hastanesi'),
(861, 'https://ror.org/00zyk6d86', 'es', 1, 'https://ror.org/00zyk6d86 Hospital Alto Deba'),
(862, 'https://ror.org/00zz54311', 'en', 1, 'https://ror.org/00zz54311 Australian Centre for Sexual Health'),
(863, 'https://ror.org/00zzcmy73', 'en', 1, 'https://ror.org/00zzcmy73 Hellenic Red Cross Ελληνικός Ερυθρός Σταυρός'),
(864, 'https://ror.org/0101aa973', 'en', 1, 'https://ror.org/0101aa973 Hollywood Private Hospital'),
(865, 'https://ror.org/0103a0295', 'no_lang_code', 1, 'https://ror.org/0103a0295 Teleflex (Canada)'),
(866, 'https://ror.org/0103dxn66', 'no_lang_code', 1, 'https://ror.org/0103dxn66 Shanghai Changzheng Hospital');
INSERT INTO `rors` VALUES
(867, 'https://ror.org/0103jbm17', 'en', 1, 'https://ror.org/0103jbm17 Golden Jubilee National Hospital'),
(868, 'https://ror.org/010567a58', 'fr', 1, 'https://ror.org/010567a58 Centre Hospitalier Universitaire Amiens-Picardie'),
(869, 'https://ror.org/01056ge55', 'en', 1, 'https://ror.org/01056ge55 Canisius College'),
(870, 'https://ror.org/0105k4695', 'no_lang_code', 1, 'https://ror.org/0105k4695 Novogene Bioinformatics Institute'),
(871, 'https://ror.org/0107t3e14', 'en', 1, 'https://ror.org/0107t3e14 Akron Children''s Hospital'),
(872, 'https://ror.org/010826a91', 'en', 1, 'https://ror.org/010826a91 Shanghai Ninth People''s Hospital 上海第九人民医院'),
(873, 'https://ror.org/0108e1t34', 'en', 1, 'https://ror.org/0108e1t34 Applied Research and Communications Fund'),
(874, 'https://ror.org/0108gdg43', 'en', 1, 'https://ror.org/0108gdg43 Sri Ramachandra Institute of Higher Education and Research श्री रामचंद्र मेडिकल कालिज एवं अनुसंधान संस्थान சிறீ இராமச்சந்திரா மருத்துவக் கல்லூரி மற்றும் ஆய்வுக் கழகம்'),
(875, 'https://ror.org/010acrp16', 'en', 1, 'https://ror.org/010acrp16 University of West Alabama'),
(876, 'https://ror.org/010bdq555', 'en', 1, 'https://ror.org/010bdq555 Michigan Health Council'),
(877, 'https://ror.org/010bsbc18', 'pt', 1, 'https://ror.org/010bsbc18 Hospital Prof. Dr. Fernando Fonseca'),
(878, 'https://ror.org/010bv4c75', 'no_lang_code', 1, 'https://ror.org/010bv4c75 Tsukuba Memorial Hospital 筑波記念病院'),
(879, 'https://ror.org/010d4kb47', 'it', 1, 'https://ror.org/010d4kb47 Ospedale Sant''Anna'),
(880, 'https://ror.org/010ezwq65', 'no_lang_code', 1, 'https://ror.org/010ezwq65 Praxis (United States)'),
(881, 'https://ror.org/010gbda42', 'en', 1, 'https://ror.org/010gbda42 Government Medical College and Hospital'),
(882, 'https://ror.org/010gckf65', 'en', 1, 'https://ror.org/010gckf65 Sikkim Manipal University'),
(883, 'https://ror.org/010gpfc02', 'no', 1, 'https://ror.org/010gpfc02 Bærum Sykehus'),
(884, 'https://ror.org/010h7bv12', 'no_lang_code', 1, 'https://ror.org/010h7bv12 Integrated Plant Genetics (United States)'),
(885, 'https://ror.org/010hq5p48', 'it', 1, 'https://ror.org/010hq5p48 Ospedale Sacro Cuore Don Calabria'),
(886, 'https://ror.org/010jskt71', 'en', 1, 'https://ror.org/010jskt71 Embry–Riddle Aeronautical University'),
(887, 'https://ror.org/010jx2260', 'en', 1, 'https://ror.org/010jx2260 National Institute of Agricultural Botany'),
(888, 'https://ror.org/010kthv55', 'no_lang_code', 1, 'https://ror.org/010kthv55 Nakadōri General Hospital 中通総合病院'),
(889, 'https://ror.org/010md9d18', 'en', 1, 'https://ror.org/010md9d18 Oklahoma City VA Medical Center'),
(890, 'https://ror.org/010n41y16', 'en', 1, 'https://ror.org/010n41y16 Southeast Missouri State University'),
(891, 'https://ror.org/010njnb56', 'en', 1, 'https://ror.org/010njnb56 Craig Hospital'),
(892, 'https://ror.org/010ns0q29', 'en', 1, 'https://ror.org/010ns0q29 North Memorial Medical Center'),
(893, 'https://ror.org/010q6ek40', 'tr', 1, 'https://ror.org/010q6ek40 Haseki Eğitim ve Araştırma Hastanesi'),
(894, 'https://ror.org/010tb3a87', 'en', 1, 'https://ror.org/010tb3a87 Nagatomi Neurosurgical Hospital 永冨脳神経外科病院'),
(895, 'https://ror.org/010tmdc88', 'it', 1, 'https://ror.org/010tmdc88 Ospedale Maggiore Carlo Alberto Pizzardi'),
(896, 'https://ror.org/010wh8q62', 'en', 1, 'https://ror.org/010wh8q62 Raja Isteri Pengiran Anak Saleha Hospital'),
(897, 'https://ror.org/010zy0m59', 'en', 1, 'https://ror.org/010zy0m59 Kemerovo State Medical Academy Кемеровская государственная медицинская академия'),
(898, 'https://ror.org/0112t7451', 'en', 1, 'https://ror.org/0112t7451 Presidio Ospedaliero San Salvatore - Pesaro San Salvatore Hospital'),
(899, 'https://ror.org/0116mdr21', 'en', 1, 'https://ror.org/0116mdr21 Graduate Hospital'),
(900, 'https://ror.org/0119j8n26', 'no_lang_code', 1, 'https://ror.org/0119j8n26 Glsynthesis'),
(901, 'https://ror.org/011ac6r71', 'en', 1, 'https://ror.org/011ac6r71 Glanrhyd Hospital'),
(902, 'https://ror.org/011apjk30', 'fr', 1, 'https://ror.org/011apjk30 Centre Hospitalier Universitaire Brugmann'),
(903, 'https://ror.org/011as4z76', 'fr', 1, 'https://ror.org/011as4z76 Centre Hospitalier Jean-Rostand'),
(904, 'https://ror.org/011bdtx65', 'en', 1, 'https://ror.org/011bdtx65 Cheng Shiu University'),
(905, 'https://ror.org/011cabk38', 'it', 1, 'https://ror.org/011cabk38 Policlinico Umberto I'),
(906, 'https://ror.org/011ezgm44', 'en', 1, 'https://ror.org/011ezgm44 Dowling College'),
(907, 'https://ror.org/011hn1c89', 'en', 1, 'https://ror.org/011hn1c89 National Hospital of Sri Lanka'),
(908, 'https://ror.org/011htkb76', 'en', 1, 'https://ror.org/011htkb76 UPMC Health System'),
(909, 'https://ror.org/011hz4254', 'en', 1, 'https://ror.org/011hz4254 CRUK/MRC Oxford Institute for Radiation Oncology'),
(910, 'https://ror.org/011mkef94', 'en', 1, 'https://ror.org/011mkef94 Kaiser Permanente Walnut Creek Medical Center'),
(911, 'https://ror.org/011p8xd65', 'en', 1, 'https://ror.org/011p8xd65 Prince Philip Dental Hospital 菲臘牙科醫院'),
(912, 'https://ror.org/011qwff60', 'en', 1, 'https://ror.org/011qwff60 Riverview Medical Center'),
(913, 'https://ror.org/011r34n61', 'en', 1, 'https://ror.org/011r34n61 Indira Gandhi Government Medical College & Hospital इंदिरा गांधी शासकीय वैद्यकीय महाविद्यालय व रुग्णालय'),
(914, 'https://ror.org/011r8ce56', 'en', 1, 'https://ror.org/011r8ce56 Linyi People''s Hospital 临沂市人民医院'),
(915, 'https://ror.org/011t2cn48', 'en', 1, 'https://ror.org/011t2cn48 St. Luke''s-Roosevelt Hospital Center'),
(916, 'https://ror.org/011tm7n37', 'no_lang_code', 1, 'https://ror.org/011tm7n37 Panasonic (Japan) パナソニック'),
(917, 'https://ror.org/011tz3351', 'en', 1, 'https://ror.org/011tz3351 Queens Hospital Center'),
(918, 'https://ror.org/011x7hd11', 'de', 1, 'https://ror.org/011x7hd11 München Klinik Bogenhausen'),
(919, 'https://ror.org/011xca688', 'en', 1, 'https://ror.org/011xca688 Himeji Dokkyo University 姫路獨協大学'),
(920, 'https://ror.org/011xhcs96', 'en', 1, 'https://ror.org/011xhcs96 Affiliated Hospital of Xuzhou Medical College'),
(921, 'https://ror.org/011ygts35', 'en', 1, 'https://ror.org/011ygts35 University Clinic of Traumatology'),
(922, 'https://ror.org/0120mb525', 'nl', 1, 'https://ror.org/0120mb525 Spaarne Ziekenhuis'),
(923, 'https://ror.org/0120w8n36', 'en', 1, 'https://ror.org/0120w8n36 Muhlenberg Regional Medical Center'),
(924, 'https://ror.org/01233dh94', 'en', 1, 'https://ror.org/01233dh94 Prince Philip Hospital'),
(925, 'https://ror.org/01244fm76', 'en', 1, 'https://ror.org/01244fm76 University of Tennessee at Martin'),
(926, 'https://ror.org/0124e9159', 'sv', 1, 'https://ror.org/0124e9159 Hallands sjukhus Kungsbacka'),
(927, 'https://ror.org/0125csy75', 'de', 1, 'https://ror.org/0125csy75 Klinikum Region Hannover'),
(928, 'https://ror.org/0127ytz78', 'en', 1, 'https://ror.org/0127ytz78 Anqing Normal University 安庆师范学院'),
(929, 'https://ror.org/012ae7p27', 'no_lang_code', 1, 'https://ror.org/012ae7p27 Italtel (Italy)'),
(930, 'https://ror.org/012bh1w56', 'fr', 1, 'https://ror.org/012bh1w56 Hôpital 20 Août'),
(931, 'https://ror.org/012bk6h61', 'da', 1, 'https://ror.org/012bk6h61 Medicinsk-historisk Museum i Næstved'),
(932, 'https://ror.org/012dxyr07', 'en', 1, 'https://ror.org/012dxyr07 University of Agriculture in Krakow Uniwersytet Rolniczy im. Hugona Kołłątaja w Krakowie'),
(933, 'https://ror.org/012eghd53', 'en', 1, 'https://ror.org/012eghd53 Rotorua Hospital'),
(934, 'https://ror.org/012gg9483', 'pt', 1, 'https://ror.org/012gg9483 Universidade Cidade de São Paulo'),
(935, 'https://ror.org/012habm93', 'pt', 1, 'https://ror.org/012habm93 Hospital de Egas Moniz'),
(936, 'https://ror.org/012nfex57', 'no_lang_code', 1, 'https://ror.org/012nfex57 Rakuwakai Otowa Hospital 洛和会音羽病院'),
(937, 'https://ror.org/012r5qt14', 'en', 1, 'https://ror.org/012r5qt14 Manitoba Pork Council'),
(938, 'https://ror.org/012vbac09', 'en', 1, 'https://ror.org/012vbac09 Doctors Medical Center'),
(939, 'https://ror.org/012wm7481', 'no_lang_code', 1, 'https://ror.org/012wm7481 Huadong Hospital 复旦大学附属华东医院'),
(940, 'https://ror.org/012yc3523', 'no_lang_code', 1, 'https://ror.org/012yc3523 COM DEV International'),
(941, 'https://ror.org/012zkqp76', 'en', 1, 'https://ror.org/012zkqp76 Delaware Division of Public Health'),
(942, 'https://ror.org/01300np05', 'en', 1, 'https://ror.org/01300np05 Tokyo Dental College Ichikawa General Hospital 東京歯科大学 市川総合病院'),
(943, 'https://ror.org/0132ynj18', 'en', 1, 'https://ror.org/0132ynj18 St. Joseph Hospital'),
(944, 'https://ror.org/0133j5m54', 'en', 1, 'https://ror.org/0133j5m54 Skellefteå Hospital Skellefteå Lasarett'),
(945, 'https://ror.org/0137gef36', 'no_lang_code', 1, 'https://ror.org/0137gef36 Yogi Vemana University யோகி வேமனா பல்கலைக்கழகம் యోగి వేమన విశ్వవిద్యాలయం'),
(946, 'https://ror.org/01381hr71', 'no_lang_code', 1, 'https://ror.org/01381hr71 Golder Associates (Canada)'),
(947, 'https://ror.org/0138ysz16', 'en', 1, 'https://ror.org/0138ysz16 Gifu Municipal Hospital 岐阜市民病院'),
(948, 'https://ror.org/013e0zm98', 'en', 1, 'https://ror.org/013e0zm98 Beijing Technology and Business University 北京工商大学'),
(949, 'https://ror.org/013e81n30', 'en', 1, 'https://ror.org/013e81n30 University of Alberta Hospital'),
(950, 'https://ror.org/013ennz48', 'en', 1, 'https://ror.org/013ennz48 Lesley University'),
(951, 'https://ror.org/013habd96', 'en', 1, 'https://ror.org/013habd96 Twin Cities Public Television'),
(952, 'https://ror.org/013pk4y14', 'en', 1, 'https://ror.org/013pk4y14 Kazan State Medical University Казанский государственный медицинский университет'),
(953, 'https://ror.org/013pz1582', 'en', 1, 'https://ror.org/013pz1582 Lewis & Clark College'),
(954, 'https://ror.org/013q2cj53', 'en', 1, 'https://ror.org/013q2cj53 Universeum'),
(955, 'https://ror.org/013qdbe28', 'tr', 1, 'https://ror.org/013qdbe28 Ankara Numune Eğitim ve Araştırma Hastanesi'),
(956, 'https://ror.org/013qhbw17', 'fr', 1, 'https://ror.org/013qhbw17 Hôpital Mongi Slim'),
(957, 'https://ror.org/013s4zk47', 'en', 1, 'https://ror.org/013s4zk47 Hiroshima General Hospital 広島総合病院'),
(958, 'https://ror.org/013sgak22', 'en', 1, 'https://ror.org/013sgak22 Northwest Community Hospital'),
(959, 'https://ror.org/013vzz882', 'en', 1, 'https://ror.org/013vzz882 Indraprastha Apollo Hospitals'),
(960, 'https://ror.org/013wvjj62', 'en', 1, 'https://ror.org/013wvjj62 Yokohama Welfare Service Association'),
(961, 'https://ror.org/013x5cp73', 'en', 1, 'https://ror.org/013x5cp73 Johns Hopkins All Children''s Hospital'),
(962, 'https://ror.org/013zjb662', 'en', 1, 'https://ror.org/013zjb662 National University of Kaohsiung'),
(963, 'https://ror.org/01435q086', 'es', 1, 'https://ror.org/01435q086 Hospital Universitario Fundación Alcorcón'),
(964, 'https://ror.org/014405c23', 'pt', 1, 'https://ror.org/014405c23 Hospital do Espírito Santo'),
(965, 'https://ror.org/0146tpy53', 'en', 1, 'https://ror.org/0146tpy53 Wellmont Health Systems'),
(966, 'https://ror.org/014936814', 'en', 1, 'https://ror.org/014936814 St. Luke''s Hospital Κλινική Άγιος Λουκάς'),
(967, 'https://ror.org/0149j8908', 'pt', 1, 'https://ror.org/0149j8908 Universidade Santa Úrsula'),
(968, 'https://ror.org/014c68a74', 'en', 1, 'https://ror.org/014c68a74 St. Louis VA Medical Center'),
(969, 'https://ror.org/014f77s28', 'en', 1, 'https://ror.org/014f77s28 Cheng Hsin General Hospital'),
(970, 'https://ror.org/014ft7z36', 'en', 1, 'https://ror.org/014ft7z36 Office of Disease Prevention and Health Promotion'),
(971, 'https://ror.org/014fz7968', 'en', 1, 'https://ror.org/014fz7968 Sojo University 崇城大学'),
(972, 'https://ror.org/014gqa478', 'en', 1, 'https://ror.org/014gqa478 University Health Care System'),
(973, 'https://ror.org/014haym76', 'no_lang_code', 1, 'https://ror.org/014haym76 Fukuoka Tokushukai Hospital 福岡徳洲会病院'),
(974, 'https://ror.org/014j33z40', 'en', 1, 'https://ror.org/014j33z40 National Hospital Abuja'),
(975, 'https://ror.org/014mgn481', 'no_lang_code', 1, 'https://ror.org/014mgn481 Maizuru Municipal Hospital 市立舞鶴市民病院'),
(976, 'https://ror.org/014n7rf11', 'en', 1, 'https://ror.org/014n7rf11 Moscow State Aviation Technological University Российский государственный технологический университет имени К. Э. Циолковского'),
(977, 'https://ror.org/014nm9q97', 'no_lang_code', 1, 'https://ror.org/014nm9q97 Sakai Municipal Hospital 堺市立総合医療センター'),
(978, 'https://ror.org/014nx0w70', 'es', 1, 'https://ror.org/014nx0w70 Hospital Universitario Austral'),
(979, 'https://ror.org/014tckg45', 'en', 1, 'https://ror.org/014tckg45 Crichton Royal Hospital'),
(980, 'https://ror.org/014tg6596', 'en', 1, 'https://ror.org/014tg6596 Victoria Hospital'),
(981, 'https://ror.org/014ttpa29', 'en', 1, 'https://ror.org/014ttpa29 Bangour Village Hospital'),
(982, 'https://ror.org/014v12a39', 'es', 1, 'https://ror.org/014v12a39 Health Research Institute of the Hospital Clínico San Carlos Instituto de Investigación Sanitaria del Hospital Clínico San Carlos'),
(983, 'https://ror.org/014v2t028', 'en', 1, 'https://ror.org/014v2t028 Shandong Pingyi Tianyu Museum of Natural History 山东省天宇自然博物馆'),
(984, 'https://ror.org/014wfj781', 'en', 1, 'https://ror.org/014wfj781 Jacksonville State University Université d''État de jacksonville'),
(985, 'https://ror.org/014x8q810', 'de', 1, 'https://ror.org/014x8q810 Centre for Solar Energy and Hydrogen Research Baden-Württemberg Zentrum für Sonnenenergie- und Wasserstoff-Forschung Baden-Württemberg'),
(986, 'https://ror.org/01509dj67', 'en', 1, 'https://ror.org/01509dj67 MedStar Franklin Square Medical Center'),
(987, 'https://ror.org/0150ewf57', 'en', 1, 'https://ror.org/0150ewf57 Dhaka Medical College and Hospital ঢাকা মেডিকেল কলেজ'),
(988, 'https://ror.org/015178j52', 'en', 1, 'https://ror.org/015178j52 Wested'),
(989, 'https://ror.org/0152bt112', 'en', 1, 'https://ror.org/0152bt112 Health Sciences and Nutrition'),
(990, 'https://ror.org/0152hn881', 'en', 1, 'https://ror.org/0152hn881 Tianjin Medical University Cancer Institute and Hospital 天津医科大学肿瘤医院'),
(991, 'https://ror.org/0152ray34', 'no_lang_code', 1, 'https://ror.org/0152ray34 Maharat Nakhon Ratchasima Hospital โรงพยาบาลมหาราชนครราชสีมา'),
(992, 'https://ror.org/015566d55', 'en', 1, 'https://ror.org/015566d55 University of Azad Jammu and Kashmir'),
(993, 'https://ror.org/015803449', 'en', 1, 'https://ror.org/015803449 South London and Maudsley NHS Foundation Trust'),
(994, 'https://ror.org/015a1ak54', 'en', 1, 'https://ror.org/015a1ak54 York College, City University of New York'),
(995, 'https://ror.org/015a6df35', 'no_lang_code', 1, 'https://ror.org/015a6df35 En Chu Kong Hospital 行天宮醫療志業醫療財團法人恩主公醫院'),
(996, 'https://ror.org/015ah0c92', 'en', 1, 'https://ror.org/015ah0c92 National Institute for Health and Care Excellence'),
(997, 'https://ror.org/015awat24', 'en', 1, 'https://ror.org/015awat24 Western State Hospital'),
(998, 'https://ror.org/015b6az38', 'en', 1, 'https://ror.org/015b6az38 Mackay Memorial Hospital 馬偕紀念醫院'),
(999, 'https://ror.org/015dyrs73', 'en', 1, 'https://ror.org/015dyrs73 Queen Elizabeth Hospital'),
(1000, 'https://ror.org/015e6tf70', 'en', 1, 'https://ror.org/015e6tf70 Madonna Rehabilitation Hospital'),
(1001, 'https://ror.org/015h2da09', 'en', 1, 'https://ror.org/015h2da09 Boston Public Health Commission'),
(1002, 'https://ror.org/015j35893', 'en', 1, 'https://ror.org/015j35893 English Heritage'),
(1003, 'https://ror.org/015nmh932', 'no_lang_code', 1, 'https://ror.org/015nmh932 Kai Research (United States)'),
(1004, 'https://ror.org/015nth639', 'en', 1, 'https://ror.org/015nth639 MRC Cancer Unit'),
(1005, 'https://ror.org/015nymp25', 'en', 1, 'https://ror.org/015nymp25 Edith Nourse Rogers Memorial Veterans Hospital'),
(1006, 'https://ror.org/015qjqf64', 'en', 1, 'https://ror.org/015qjqf64 Stiftung Tierärztliche Hochschule Hannover University of Veterinary Medicine Hannover, Foundation'),
(1007, 'https://ror.org/015rc4h95', 'en', 1, 'https://ror.org/015rc4h95 Hamanomachi Hospital 浜の町病院'),
(1008, 'https://ror.org/015tmw922', 'en', 1, 'https://ror.org/015tmw922 Providence Portland Medical Center'),
(1009, 'https://ror.org/015v9d997', 'en', 1, 'https://ror.org/015v9d997 Jeonju University 전주대학교'),
(1010, 'https://ror.org/015yzft41', 'pt', 1, 'https://ror.org/015yzft41 Instituto Superior Politécnico do Oeste'),
(1011, 'https://ror.org/01600wh70', 'en', 1, 'https://ror.org/01600wh70 University of Toledo Medical Center'),
(1012, 'https://ror.org/01605g366', 'en', 1, 'https://ror.org/01605g366 Kyoto City Hospital 京都市立病院'),
(1013, 'https://ror.org/01616f936', 'en', 1, 'https://ror.org/01616f936 Jefferson College of Health Sciences'),
(1014, 'https://ror.org/01639jx86', 'no_lang_code', 1, 'https://ror.org/01639jx86 Ogikubo Hospital'),
(1015, 'https://ror.org/0163qhr63', 'en', 1, 'https://ror.org/0163qhr63 Hanusch Hospital Hanusch-Krankenhaus'),
(1016, 'https://ror.org/0164vc797', 'en', 1, 'https://ror.org/0164vc797 Vijayanagara Institute of Medical Sciences ವಿಜಯನಗರ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),
(1017, 'https://ror.org/0166mge61', 'es', 1, 'https://ror.org/0166mge61 Hospital San Juan de Dios'),
(1018, 'https://ror.org/01673gn35', 'en', 1, 'https://ror.org/01673gn35 Affiliated Hospital of North Sichuan Medical College 川北医学院附属医院'),
(1019, 'https://ror.org/0167c0661', 'no_lang_code', 1, 'https://ror.org/0167c0661 Exodus (Greece)'),
(1020, 'https://ror.org/01683nj06', 'en', 1, 'https://ror.org/01683nj06 Mangla Hospital and Research Center'),
(1021, 'https://ror.org/01692sz90', 'no_lang_code', 1, 'https://ror.org/01692sz90 Juntendo University 順天堂大学'),
(1022, 'https://ror.org/01699r503', 'en', 1, 'https://ror.org/01699r503 St. Margaret''s Hospital for Women'),
(1023, 'https://ror.org/0169n7f49', 'en', 1, 'https://ror.org/0169n7f49 251 Γενικό Νοσοκομείο Αεροπορίας Hellenic Airforce General Hospital'),
(1024, 'https://ror.org/016a0n751', 'en', 1, 'https://ror.org/016a0n751 Azerbaijan Medical University Azərbaycan Tibb Universiteti Азербайджанский медицинский университет'),
(1025, 'https://ror.org/016bbv872', 'en', 1, 'https://ror.org/016bbv872 Hahnemann University Hospital'),
(1026, 'https://ror.org/016c9ds94', 'en', 1, 'https://ror.org/016c9ds94 Kanagawa Prefectural Institute of Public Health 神奈川県衛生研究所'),
(1027, 'https://ror.org/016dr6b81', 'en', 1, 'https://ror.org/016dr6b81 Waterbury Hospital'),
(1028, 'https://ror.org/016dxxy13', 'en', 1, 'https://ror.org/016dxxy13 Ministry of Health กระทรวงสาธารณสุข'),
(1029, 'https://ror.org/016jc2h42', 'en', 1, 'https://ror.org/016jc2h42 Sint Lucas Andreas Hospital Sint Lucas Andreas Ziekenhuis'),
(1030, 'https://ror.org/016je1253', 'en', 1, 'https://ror.org/016je1253 Government Medical College'),
(1031, 'https://ror.org/016m8pd54', 'en', 1, 'https://ror.org/016m8pd54 Morgan Stanley Children''s Hospital'),
(1032, 'https://ror.org/016nh4b93', 'en', 1, 'https://ror.org/016nh4b93 Mercy Children''s Hospital'),
(1033, 'https://ror.org/016qd7r37', 'es', 1, 'https://ror.org/016qd7r37 Hospital Universitario de Maracaibo'),
(1034, 'https://ror.org/016tyxe19', 'en', 1, 'https://ror.org/016tyxe19 New Mexico Highlands University'),
(1035, 'https://ror.org/016v1bv58', 'es', 1, 'https://ror.org/016v1bv58 Hospital Clínico de la Universidad Católica'),
(1036, 'https://ror.org/016yv6y68', 'en', 1, 'https://ror.org/016yv6y68 Dakota State University'),
(1037, 'https://ror.org/01703db54', 'en', 1, 'https://ror.org/01703db54 National Institute of Advanced Industrial Science and Technology 産業技術総合研究所'),
(1038, 'https://ror.org/0171atz91', 'no_lang_code', 1, 'https://ror.org/0171atz91 Iogen Corporation'),
(1039, 'https://ror.org/01735bk60', 'sv', 1, 'https://ror.org/01735bk60 Göteborgs barnsjukhus'),
(1040, 'https://ror.org/017383496', 'en', 1, 'https://ror.org/017383496 Aultman Hospital'),
(1041, 'https://ror.org/0176arq92', 'en', 1, 'https://ror.org/0176arq92 Milwaukee VA Medical Center'),
(1042, 'https://ror.org/0176jt031', 'en', 1, 'https://ror.org/0176jt031 Huston–Tillotson University'),
(1043, 'https://ror.org/0176wfg98', 'en', 1, 'https://ror.org/0176wfg98 Gleneagles Hospital'),
(1044, 'https://ror.org/0176x9269', 'no_lang_code', 1, 'https://ror.org/0176x9269 Hatyai Hospital โรงพยาบาลหาดใหญ่'),
(1045, 'https://ror.org/0176yjw32', 'pt', 1, 'https://ror.org/0176yjw32 Federal University of Minas Gerais Universidade Federal de Minas Gerais Université fédérale du minas gerais'),
(1046, 'https://ror.org/01786mp71', 'en', 1, 'https://ror.org/01786mp71 Institute of Agrobiological Sciences 生物機能利用研究部門'),
(1047, 'https://ror.org/017b7j426', 'no_lang_code', 1, 'https://ror.org/017b7j426 Altera (United States)'),
(1048, 'https://ror.org/017c6at71', 'en', 1, 'https://ror.org/017c6at71 University of North Carolina at Asheville'),
(1049, 'https://ror.org/017dm4063', 'en', 1, 'https://ror.org/017dm4063 Departamento de Salud Pública del Condado de Los Ángeles Los Angeles County Department of Public Health'),
(1050, 'https://ror.org/017g36q02', 'en', 1, 'https://ror.org/017g36q02 Municipality of Amaroussion'),
(1051, 'https://ror.org/017h1mj21', 'en', 1, 'https://ror.org/017h1mj21 Kaiser Permanente Hayward Medical Center'),
(1052, 'https://ror.org/017hkng22', 'en', 1, 'https://ror.org/017hkng22 Ehime University 愛媛大学'),
(1053, 'https://ror.org/017j2n938', 'en', 1, 'https://ror.org/017j2n938 Kobe Central Hospital 神戸中央病院'),
(1054, 'https://ror.org/017je7s69', 'en', 1, 'https://ror.org/017je7s69 National Institute for Research in Reproductive Health राष्ट्रीय प्रजनन स्वास्थ्य अनुसंधान संस्थान'),
(1055, 'https://ror.org/017kgtg39', 'en', 1, 'https://ror.org/017kgtg39 Fukuoka Children''s Hospital and Medical Center for Infectious Diseases 福岡市立こども病院'),
(1056, 'https://ror.org/017m05e51', 'en', 1, 'https://ror.org/017m05e51 Health Policy Alternatives, Inc.'),
(1057, 'https://ror.org/017ph0934', 'en', 1, 'https://ror.org/017ph0934 Ulusal ve Uluslararası Ekonomi Üniversitesi University of National and World Economy Университет за национално и световно стопанство'),
(1058, 'https://ror.org/017pz3h73', 'en', 1, 'https://ror.org/017pz3h73 Urban Institute'),
(1059, 'https://ror.org/017q2rt66', 'en', 1, 'https://ror.org/017q2rt66 Mercy University Hospital'),
(1060, 'https://ror.org/017t1dh18', 'fr', 1, 'https://ror.org/017t1dh18 Hôpital Max Fourestier'),
(1061, 'https://ror.org/017vgxg86', 'no_lang_code', 1, 'https://ror.org/017vgxg86 Ford (Germany)'),
(1062, 'https://ror.org/017wcm924', 'en', 1, 'https://ror.org/017wcm924 University System of Georgia'),
(1063, 'https://ror.org/017xnm587', 'en', 1, 'https://ror.org/017xnm587 Soongsil University 숭실대학교'),
(1064, 'https://ror.org/017ztfb41', 'en', 1, 'https://ror.org/017ztfb41 San Francisco Department of Public Health'),
(1065, 'https://ror.org/01818mf51', 'no_lang_code', 1, 'https://ror.org/01818mf51 Messerschmitt-Bölkow-Blohm (Germany)'),
(1066, 'https://ror.org/01820qp25', 'en', 1, 'https://ror.org/01820qp25 Ornsköldsvik Hospital Örnsköldsviks sjukhus'),
(1067, 'https://ror.org/018224621', 'en', 1, 'https://ror.org/018224621 American Academy of Arts and Sciences'),
(1068, 'https://ror.org/018224j82', 'en', 1, 'https://ror.org/018224j82 Buena Vista University'),
(1069, 'https://ror.org/0184gbk60', 'en', 1, 'https://ror.org/0184gbk60 Steinbeis Foundation Steinbeis-Stiftung'),
(1070, 'https://ror.org/0184p1881', 'en', 1, 'https://ror.org/0184p1881 Nevada Department of Health and Human Services'),
(1071, 'https://ror.org/0187t0j49', 'en', 1, 'https://ror.org/0187t0j49 John Hunter Hospital'),
(1072, 'https://ror.org/018dx8725', 'en', 1, 'https://ror.org/018dx8725 Sparrow Hospital'),
(1073, 'https://ror.org/018k7fz65', 'en', 1, 'https://ror.org/018k7fz65 Ministry of Health ក្រសួងសុខាភិបាល'),
(1074, 'https://ror.org/018kd1e03', 'en', 1, 'https://ror.org/018kd1e03 Wesley Hospital'),
(1075, 'https://ror.org/018mgzn65', 'en', 1, 'https://ror.org/018mgzn65 Baylor Medical Center at Garland'),
(1076, 'https://ror.org/018pq0b08', 'no_lang_code', 1, 'https://ror.org/018pq0b08 Niigata Prefectural Central Hospital 新潟県立中央病院'),
(1077, 'https://ror.org/018s10n18', 'en', 1, 'https://ror.org/018s10n18 Jewish Hospital'),
(1078, 'https://ror.org/018s6xs98', 'en', 1, 'https://ror.org/018s6xs98 International Cooperative Administrative Support Services'),
(1079, 'https://ror.org/018txrr13', 'en', 1, 'https://ror.org/018txrr13 VA Ann Arbor Healthcare System'),
(1080, 'https://ror.org/018vqfn69', 'en', 1, 'https://ror.org/018vqfn69 Matsunami General Hospital 松波病院'),
(1081, 'https://ror.org/0190kj665', 'es', 1, 'https://ror.org/0190kj665 Hospital General de Granollers'),
(1082, 'https://ror.org/0193sb042', 'en', 1, 'https://ror.org/0193sb042 Henry Ford Hospital Hôpital henry ford'),
(1083, 'https://ror.org/0195twz09', 'en', 1, 'https://ror.org/0195twz09 St. Luke''s Episcopal Hospital'),
(1084, 'https://ror.org/019621n74', 'en', 1, 'https://ror.org/019621n74 Public Health Institute'),
(1085, 'https://ror.org/019br0e98', 'no_lang_code', 1, 'https://ror.org/019br0e98 Metabolic Solutions'),
(1086, 'https://ror.org/019bxes45', 'en', 1, 'https://ror.org/019bxes45 University Dental Hospital of Manchester'),
(1087, 'https://ror.org/019e4d354', 'en', 1, 'https://ror.org/019e4d354 Government Medical College ਸਰਕਾਰੀ ਮੈਡੀਕਲ ਕਾਲਜ'),
(1088, 'https://ror.org/019e4dr88', 'en', 1, 'https://ror.org/019e4dr88 Erie County Medical Center'),
(1089, 'https://ror.org/019f36t97', 'en', 1, 'https://ror.org/019f36t97 Royal Berkshire Hospital'),
(1090, 'https://ror.org/019k4jq75', 'en', 1, 'https://ror.org/019k4jq75 Brooklyn College College de Brooklyn de la Universidad de la Ciudad de Nueva York'),
(1091, 'https://ror.org/019kgqr73', 'en', 1, 'https://ror.org/019kgqr73 The University of Texas at Arlington Université du Texas à Arlington'),
(1092, 'https://ror.org/019krky16', 'en', 1, 'https://ror.org/019krky16 Medical Group Management Association'),
(1093, 'https://ror.org/019my5047', 'en', 1, 'https://ror.org/019my5047 Royal London Hospital'),
(1094, 'https://ror.org/019myg640', 'de', 1, 'https://ror.org/019myg640 Krankenanstalt Rudolfstiftung der Stadt Wien'),
(1095, 'https://ror.org/019n8y489', 'en', 1, 'https://ror.org/019n8y489 Utah Valley Regional Medical Center'),
(1096, 'https://ror.org/019rjbt98', 'en', 1, 'https://ror.org/019rjbt98 Colorado Department of Public Health and Environment'),
(1097, 'https://ror.org/019s1t671', 'en', 1, 'https://ror.org/019s1t671 Montgomery County Department of Health and Human Services'),
(1098, 'https://ror.org/019tq3436', 'en', 1, 'https://ror.org/019tq3436 Far Eastern Memorial Hospital'),
(1099, 'https://ror.org/019tstz42', 'sv', 1, 'https://ror.org/019tstz42 Ersta sjukhus'),
(1100, 'https://ror.org/019x0cx75', 'no_lang_code', 1, 'https://ror.org/019x0cx75 Science and Engineering Services (United States)'),
(1101, 'https://ror.org/019x26026', 'en', 1, 'https://ror.org/019x26026 Uwajima City Hospital 宇和島市病院'),
(1102, 'https://ror.org/019z71f50', 'en', 1, 'https://ror.org/019z71f50 National Taipei University of Nursing and Health Science 國立臺北護理健康大學'),
(1103, 'https://ror.org/019z9dk17', 'en', 1, 'https://ror.org/019z9dk17 Mount Elizabeth Hospital மவுண்ட் எலிசபெத் மருத்துவமனை'),
(1104, 'https://ror.org/019zp2770', 'en', 1, 'https://ror.org/019zp2770 Upstate University Hospital'),
(1105, 'https://ror.org/01a0h9c53', 'no_lang_code', 1, 'https://ror.org/01a0h9c53 Kingston Process Metallurgy (Canada)'),
(1106, 'https://ror.org/01a1mbs69', 'en', 1, 'https://ror.org/01a1mbs69 Princess of Wales Hospital'),
(1107, 'https://ror.org/01a1x1d92', 'no_lang_code', 1, 'https://ror.org/01a1x1d92 Ruttonjee Hospital 律敦治醫院'),
(1108, 'https://ror.org/01a3mef16', 'en', 1, 'https://ror.org/01a3mef16 Pondicherry University पॉन्डिचेरी विश्वविद्यालय புதுவைப் பல்கலைக்கழகம் పాండిచ్చేరి విశ్వవిద్యాలయం പോണ്ടിച്ചേരി സർവകലാശാല'),
(1109, 'https://ror.org/01a3zyd02', 'it', 1, 'https://ror.org/01a3zyd02 Ospedale Regionale di Locarno'),
(1110, 'https://ror.org/01a423692', 'no_lang_code', 1, 'https://ror.org/01a423692 Aastrom Biosciences (United States)'),
(1111, 'https://ror.org/01a4bac78', 'en', 1, 'https://ror.org/01a4bac78 Cantox Health Sciences International'),
(1112, 'https://ror.org/01a4d6k20', 'en', 1, 'https://ror.org/01a4d6k20 Jawaharlal Nehru Medical College'),
(1113, 'https://ror.org/01a4gqp27', 'en', 1, 'https://ror.org/01a4gqp27 Harry S. Truman Memorial Veterans'' Hospital'),
(1114, 'https://ror.org/01a6tsm75', 'en', 1, 'https://ror.org/01a6tsm75 Hillel Yaffe Medical Center'),
(1115, 'https://ror.org/01adsjd47', 'no_lang_code', 1, 'https://ror.org/01adsjd47 Seonam University'),
(1116, 'https://ror.org/01aeq1t78', 'en', 1, 'https://ror.org/01aeq1t78 Shriners Hospitals for Children - Cincinnati'),
(1117, 'https://ror.org/01agth861', 'en', 1, 'https://ror.org/01agth861 American Association of Physics Teachers'),
(1118, 'https://ror.org/01akfrh45', 'no_lang_code', 1, 'https://ror.org/01akfrh45 Farwaniya Hospital مستشفى الفروانية'),
(1119, 'https://ror.org/01ans1m53', 'no_lang_code', 1, 'https://ror.org/01ans1m53 SomaGenics (United States)'),
(1120, 'https://ror.org/01apd5369', 'en', 1, 'https://ror.org/01apd5369 John Paul II Hospital Krakowski Szpital Specjalistyczny im. Jana Pawła II'),
(1121, 'https://ror.org/01apvbh93', 'en', 1, 'https://ror.org/01apvbh93 Akademiska sjukhuset Uppsala University Hospital'),
(1122, 'https://ror.org/01ar9e455', 'en', 1, 'https://ror.org/01ar9e455 The Aerospace Corporation'),
(1123, 'https://ror.org/01aryec24', 'en', 1, 'https://ror.org/01aryec24 Southeastern Oklahoma State University'),
(1124, 'https://ror.org/01as10d06', 'en', 1, 'https://ror.org/01as10d06 Harrisburg Hospital'),
(1125, 'https://ror.org/01atr9m08', 'no_lang_code', 1, 'https://ror.org/01atr9m08 Biotex (United States)'),
(1126, 'https://ror.org/01atwky19', 'en', 1, 'https://ror.org/01atwky19 North Oaks Health System'),
(1127, 'https://ror.org/01aw2gs83', 'en', 1, 'https://ror.org/01aw2gs83 Nagasaki Kawatana Medical Center 国立病院機構長崎川棚医療センター'),
(1128, 'https://ror.org/01ayg2409', 'no_lang_code', 1, 'https://ror.org/01ayg2409 Juniata College'),
(1129, 'https://ror.org/01ayqmq97', 'en', 1, 'https://ror.org/01ayqmq97 Rajendra Hospital'),
(1130, 'https://ror.org/01azs0t89', 'es', 1, 'https://ror.org/01azs0t89 Hospital Carmen y Severo Ochoa'),
(1131, 'https://ror.org/01b1c8m98', 'en', 1, 'https://ror.org/01b1c8m98 Ministry of Health وزارة الصحة'),
(1132, 'https://ror.org/01b1r6152', 'en', 1, 'https://ror.org/01b1r6152 Kowloon Hospital 九龍醫院'),
(1133, 'https://ror.org/01b2c5015', 'es', 1, 'https://ror.org/01b2c5015 Hospital Sierrallana'),
(1134, 'https://ror.org/01b2wv937', 'en', 1, 'https://ror.org/01b2wv937 New York State Office of Mental Health'),
(1135, 'https://ror.org/01b330649', 'no_lang_code', 1, 'https://ror.org/01b330649 Nova Research Company (United States)'),
(1136, 'https://ror.org/01b3dvp57', 'en', 1, 'https://ror.org/01b3dvp57 Garvan Institute of Medical Research'),
(1137, 'https://ror.org/01b5d7p48', 'no_lang_code', 1, 'https://ror.org/01b5d7p48 Schlumberger (France)'),
(1138, 'https://ror.org/01b6d9h22', 'hr', 1, 'https://ror.org/01b6d9h22 Klinička bolnica Merkur'),
(1139, 'https://ror.org/01b78mz79', 'pt', 1, 'https://ror.org/01b78mz79 Federal University of Santa Maria Universidad Federal de Santa María Universidade Federal de Santa Maria'),
(1140, 'https://ror.org/01b8f4h92', 'no_lang_code', 1, 'https://ror.org/01b8f4h92 Athens Technology Center (Greece)'),
(1141, 'https://ror.org/01b8kcc49', 'en', 1, 'https://ror.org/01b8kcc49 National Cheng Kung University'),
(1142, 'https://ror.org/01bbyhp53', 'en', 1, 'https://ror.org/01bbyhp53 Basingstoke and North Hampshire Hospital'),
(1143, 'https://ror.org/01bcp3a67', 'en', 1, 'https://ror.org/01bcp3a67 Benenden Hospital'),
(1144, 'https://ror.org/01bdr6121', 'en', 1, 'https://ror.org/01bdr6121 University of Guilan دانشگاه گیلان'),
(1145, 'https://ror.org/01bgafn72', 'no_lang_code', 1, 'https://ror.org/01bgafn72 Hamad General Hospital'),
(1146, 'https://ror.org/01bgds823', 'en', 1, 'https://ror.org/01bgds823 Affiliated Hospital of Chengde Medical College 承德医学院附属医院'),
(1147, 'https://ror.org/01bhkfn26', 'en', 1, 'https://ror.org/01bhkfn26 Southern Command Hospital'),
(1148, 'https://ror.org/01bk73674', 'en', 1, 'https://ror.org/01bk73674 Chengdu Military General Hospital 中国人民解放军成都军区总医院'),
(1149, 'https://ror.org/01bk7pz18', 'no_lang_code', 1, 'https://ror.org/01bk7pz18 Tokushima Prefectural Central Hospital 徳島県立中央病院'),
(1150, 'https://ror.org/01bkdwe73', 'pt', 1, 'https://ror.org/01bkdwe73 Hospital Heliópolis'),
(1151, 'https://ror.org/01bmj6z20', 'en', 1, 'https://ror.org/01bmj6z20 Maesot General Hospital โรงพยาบาลแม่สอด'),
(1152, 'https://ror.org/01bn4rh74', 'en', 1, 'https://ror.org/01bn4rh74 Heritage Valley Beaver'),
(1153, 'https://ror.org/01bnyxq20', 'es', 1, 'https://ror.org/01bnyxq20 Hospital Ramos Mejía'),
(1154, 'https://ror.org/01bry7z39', 'en', 1, 'https://ror.org/01bry7z39 Northwest Nazarene University'),
(1155, 'https://ror.org/01bt82v32', 'en', 1, 'https://ror.org/01bt82v32 Northern Light Mercy Hospital'),
(1156, 'https://ror.org/01bthtp68', 'no_lang_code', 1, 'https://ror.org/01bthtp68 Corixa Corporation'),
(1157, 'https://ror.org/01btjc831', 'it', 1, 'https://ror.org/01btjc831 Ospedale San Giacomo Apostolo'),
(1158, 'https://ror.org/01bvmk374', 'no_lang_code', 1, 'https://ror.org/01bvmk374 GIUNTI Intenational Division (Italy)'),
(1159, 'https://ror.org/01bw9xe44', 'en', 1, 'https://ror.org/01bw9xe44 Academy of Georgofili Accademia dei Georgofili'),
(1160, 'https://ror.org/01bx8ja67', 'no_lang_code', 1, 'https://ror.org/01bx8ja67 Maharaja Sayajirao University of Baroda મહારાજા સયાજીરાવ વિશ્વવિદ્યાલય மகாராஜா சாயாஜிராவ் பல்கலைக்கழகம்'),
(1161, 'https://ror.org/01by1qv45', 'en', 1, 'https://ror.org/01by1qv45 Santa Casa Hospital'),
(1162, 'https://ror.org/01bywqg69', 'no_lang_code', 1, 'https://ror.org/01bywqg69 Automotive Fuel Cell Cooperation (Canada)'),
(1163, 'https://ror.org/01c1ce922', 'it', 1, 'https://ror.org/01c1ce922 Nuovo Ospedale San Giovanni di Dio'),
(1164, 'https://ror.org/01c2dee93', 'en', 1, 'https://ror.org/01c2dee93 Baystate Franklin Medical Center'),
(1165, 'https://ror.org/01c2wzp81', 'tr', 1, 'https://ror.org/01c2wzp81 Dr Lütfi Kırdar Kartal Eğitim ve Araştırma Hastanesi'),
(1166, 'https://ror.org/01c3hyk82', 'en', 1, 'https://ror.org/01c3hyk82 Shih Chien University'),
(1167, 'https://ror.org/01c524129', 'en', 1, 'https://ror.org/01c524129 King Fahd Military Medical Complex'),
(1168, 'https://ror.org/01c5cqy87', 'en', 1, 'https://ror.org/01c5cqy87 General Hospital of Serres Γενικό Νοσοκομείο Σερρών'),
(1169, 'https://ror.org/01c5j0443', 'fr', 1, 'https://ror.org/01c5j0443 Institut d''Économie Rurale'),
(1170, 'https://ror.org/01c74sd89', 'no_lang_code', 1, 'https://ror.org/01c74sd89 STMicroelectronics (France)'),
(1171, 'https://ror.org/01c804c94', 'no_lang_code', 1, 'https://ror.org/01c804c94 First Point Scientific'),
(1172, 'https://ror.org/01cb0kd74', 'en', 1, 'https://ror.org/01cb0kd74 Royal Hospital for Children'),
(1173, 'https://ror.org/01cgbsh11', 'en', 1, 'https://ror.org/01cgbsh11 Hutt Hospital'),
(1174, 'https://ror.org/01ch4qb51', 'en', 1, 'https://ror.org/01ch4qb51 Mercy Hospital for Women'),
(1175, 'https://ror.org/01cjd8n57', 'no_lang_code', 1, 'https://ror.org/01cjd8n57 Nagasaki Rousai Hospital 長崎労災病院'),
(1176, 'https://ror.org/01ckbq028', 'en', 1, 'https://ror.org/01ckbq028 Whittington Hospital'),
(1177, 'https://ror.org/01ckz8750', 'no_lang_code', 1, 'https://ror.org/01ckz8750 Lickenbrock'),
(1178, 'https://ror.org/01cmpkr67', 'no_lang_code', 1, 'https://ror.org/01cmpkr67 Materials Modification (United States)'),
(1179, 'https://ror.org/01cpcy908', 'en', 1, 'https://ror.org/01cpcy908 McLaren Regional Medical Center'),
(1180, 'https://ror.org/01cqcrc47', 'en', 1, 'https://ror.org/01cqcrc47 Rangsit University มหาวิทยาลัยรังสิต'),
(1181, 'https://ror.org/01cqmqj90', 'en', 1, 'https://ror.org/01cqmqj90 Hadassah Medical Center مركز هداسا الطبي'),
(1182, 'https://ror.org/01cqx0m58', 'en', 1, 'https://ror.org/01cqx0m58 Centro Italiano Ricerche Aerospaziali Italian Aerospace Research Centre'),
(1183, 'https://ror.org/01cqxk816', 'en', 1, 'https://ror.org/01cqxk816 University of West Georgia'),
(1184, 'https://ror.org/01cs14q41', 'en', 1, 'https://ror.org/01cs14q41 Glangwili General Hospital Ysbyty Cyffredinol Glangwili'),
(1185, 'https://ror.org/01ctb0h41', 'en', 1, 'https://ror.org/01ctb0h41 Triangle Coalition For Science and Technology Education'),
(1186, 'https://ror.org/01cv0eh48', 'en', 1, 'https://ror.org/01cv0eh48 Royal Belfast Hospital for Sick Children'),
(1187, 'https://ror.org/01cw77n16', 'en', 1, 'https://ror.org/01cw77n16 Fairfield Infectious Diseases Hospital'),
(1188, 'https://ror.org/01cwbae71', 'en', 1, 'https://ror.org/01cwbae71 Hannam University 한남대학교'),
(1189, 'https://ror.org/01cx2sj34', 'pl', 1, 'https://ror.org/01cx2sj34 Centrum Medyczne Kształcenia Podyplomowego'),
(1190, 'https://ror.org/01cyv3m84', 'en', 1, 'https://ror.org/01cyv3m84 Ospedale di Santa Maria Nuova Santa Maria Nuova Hospital'),
(1191, 'https://ror.org/01cyzat07', 'en', 1, 'https://ror.org/01cyzat07 Wesley Guild Hospital'),
(1192, 'https://ror.org/01czx1v82', 'en', 1, 'https://ror.org/01czx1v82 Huzhou Central Hospital 湖州市中心医院'),
(1193, 'https://ror.org/01d00rw04', 'en', 1, 'https://ror.org/01d00rw04 KPC Medical College and Hospital কেপিসি মেডিকাল কলেজ ও কে এস রায় টিবি হাসপাতাল'),
(1194, 'https://ror.org/01d012874', 'es', 1, 'https://ror.org/01d012874 Clínica La Luz, Hospital La Luz'),
(1195, 'https://ror.org/01d1m4h32', 'en', 1, 'https://ror.org/01d1m4h32 Samaritan Center'),
(1196, 'https://ror.org/01d261e32', 'en', 1, 'https://ror.org/01d261e32 Furness General Hospital'),
(1197, 'https://ror.org/01d2e9e05', 'en', 1, 'https://ror.org/01d2e9e05 Maternity and Children''s Hospital'),
(1198, 'https://ror.org/01d2sy711', 'no_lang_code', 1, 'https://ror.org/01d2sy711 E-One Moli Energy (Canada)'),
(1199, 'https://ror.org/01d3gh658', 'en', 1, 'https://ror.org/01d3gh658 Centraal Militair Hospitaal Central Military Hospital'),
(1200, 'https://ror.org/01d59nd22', 'en', 1, 'https://ror.org/01d59nd22 Federal Ministry of Health وزارة الصحة الإتحادية'),
(1201, 'https://ror.org/01d692d57', 'en', 1, 'https://ror.org/01d692d57 University of Sindh سندھ یونیورسٹی'),
(1202, 'https://ror.org/01d86hn60', 'it', 1, 'https://ror.org/01d86hn60 Ospedale San Carlo'),
(1203, 'https://ror.org/01d9cs377', 'en', 1, 'https://ror.org/01d9cs377 University Health System'),
(1204, 'https://ror.org/01dcrt245', 'en', 1, 'https://ror.org/01dcrt245 Dubai Health Authority هيئة الصحة بدبي'),
(1205, 'https://ror.org/01defpn95', 'en', 1, 'https://ror.org/01defpn95 Sathyabama Institute of Science and Technology சத்யபாமா ப‌ல்கலைக்கழகம் సత్యభామ విశ్వవిద్యాలయం'),
(1206, 'https://ror.org/01df9ep43', 'en', 1, 'https://ror.org/01df9ep43 Era''s Lucknow Medical College and Hospital'),
(1207, 'https://ror.org/01dgc8k02', 'it', 1, 'https://ror.org/01dgc8k02 Ospedale Cristo Re'),
(1208, 'https://ror.org/01dgn5344', 'en', 1, 'https://ror.org/01dgn5344 Rider University Universidad Rider Université de rider'),
(1209, 'https://ror.org/01dgncy67', 'no_lang_code', 1, 'https://ror.org/01dgncy67 Saiseikai Shimonoseki General Hospital 山口県済生会下関総合病院'),
(1210, 'https://ror.org/01djnr762', 'no_lang_code', 1, 'https://ror.org/01djnr762 Dalsa Corporation'),
(1211, 'https://ror.org/01dk3f134', 'no_lang_code', 1, 'https://ror.org/01dk3f134 Tokyo Metropolitan Bokutoh Hospital 東京都立墨東病院'),
(1212, 'https://ror.org/01dk7q852', 'no_lang_code', 1, 'https://ror.org/01dk7q852 Cardiovascular Center Hokkaido Ohno Hospital 心臓血管センター北海道大野病院'),
(1213, 'https://ror.org/01dkn0c77', 'pt', 1, 'https://ror.org/01dkn0c77 Hospital Santa Izabel'),
(1214, 'https://ror.org/01dkvrg87', 'en', 1, 'https://ror.org/01dkvrg87 Sabbatsberg Hospital Sabbatsbergs Sjukhus'),
(1215, 'https://ror.org/01dm04760', 'en', 1, 'https://ror.org/01dm04760 Lexington VA Health Care System'),
(1216, 'https://ror.org/01dm18990', 'en', 1, 'https://ror.org/01dm18990 Lakeshore Hospital'),
(1217, 'https://ror.org/01dmyj570', 'en', 1, 'https://ror.org/01dmyj570 Shriners Hospitals for Children - Northern California'),
(1218, 'https://ror.org/01dpw6893', 'en', 1, 'https://ror.org/01dpw6893 Scripps Memorial Hospital'),
(1219, 'https://ror.org/01dqhdd78', 'en', 1, 'https://ror.org/01dqhdd78 Clatterbridge Hospital Ysbyty Clattebridge'),
(1220, 'https://ror.org/01dspcb60', 'en', 1, 'https://ror.org/01dspcb60 Jiangxi Provincial People''s Hospital 江西省人民医院'),
(1221, 'https://ror.org/01dsw4m23', 'en', 1, 'https://ror.org/01dsw4m23 Repatriation General Hospital'),
(1222, 'https://ror.org/01dsy9055', 'en', 1, 'https://ror.org/01dsy9055 University Hospital Ayr'),
(1223, 'https://ror.org/01dszvc69', 'en', 1, 'https://ror.org/01dszvc69 Sapporo Azabu Neurosurgical Hospital 札幌麻生脳神経外科病院'),
(1224, 'https://ror.org/01dxm2p72', 'no_lang_code', 1, 'https://ror.org/01dxm2p72 Saipem (Italy) Società Anonima Italiana Perforazioni E Montaggi'),
(1225, 'https://ror.org/01dzpsy49', 'en', 1, 'https://ror.org/01dzpsy49 Nara City Hospital 市立奈良病院'),
(1226, 'https://ror.org/01e2avb80', 'en', 1, 'https://ror.org/01e2avb80 Prince George''s Hospital Center'),
(1227, 'https://ror.org/01e320272', 'fr', 1, 'https://ror.org/01e320272 Hôpital Saint-Philibert'),
(1228, 'https://ror.org/01e4pq116', 'fr', 1, 'https://ror.org/01e4pq116 Hôpital Saint Charles'),
(1229, 'https://ror.org/01e4pq504', 'en', 1, 'https://ror.org/01e4pq504 Portland Community College'),
(1230, 'https://ror.org/01e4z3q24', 'en', 1, 'https://ror.org/01e4z3q24 Priest Hospital โรงพยาบาลสงฆ์'),
(1231, 'https://ror.org/01e5t7e46', 'no_lang_code', 1, 'https://ror.org/01e5t7e46 Nanomaterials Research (United States)'),
(1232, 'https://ror.org/01e87ch81', 'en', 1, 'https://ror.org/01e87ch81 Oregon Museum of Science and Industry'),
(1233, 'https://ror.org/01ec7xj20', 'en', 1, 'https://ror.org/01ec7xj20 Jaswant Rai Speciality Hospital'),
(1234, 'https://ror.org/01ecnnp60', 'en', 1, 'https://ror.org/01ecnnp60 Jackson State University Université d''État de Jackson'),
(1235, 'https://ror.org/01eedy375', 'en', 1, 'https://ror.org/01eedy375 Alabama State University'),
(1236, 'https://ror.org/01eeehv22', 'no_lang_code', 1, 'https://ror.org/01eeehv22 Bell Helicopter Textron (Canada)'),
(1237, 'https://ror.org/01efrfk30', 'en', 1, 'https://ror.org/01efrfk30 Stetson University'),
(1238, 'https://ror.org/01egmr022', 'no_lang_code', 1, 'https://ror.org/01egmr022 Nantong Tumor Hospital 南通市肿瘤医院'),
(1239, 'https://ror.org/01ej92a17', 'en', 1, 'https://ror.org/01ej92a17 Sandviken Hospital Sandviken sykehus'),
(1240, 'https://ror.org/01ejxf797', 'en', 1, 'https://ror.org/01ejxf797 Mohamed I University Université Mohammed Ier جامعة محمد الأول'),
(1241, 'https://ror.org/01ekg2j77', 'en', 1, 'https://ror.org/01ekg2j77 Blood Systems Research Institute'),
(1242, 'https://ror.org/01emnh554', 'no_lang_code', 1, 'https://ror.org/01emnh554 Saga-Ken Medical Centre Koseikan 佐賀県医療センター好生館'),
(1243, 'https://ror.org/01emtgd92', 'en', 1, 'https://ror.org/01emtgd92 Mansfield University'),
(1244, 'https://ror.org/01emxrg90', 'pt', 1, 'https://ror.org/01emxrg90 Hospital Pedro Hispano'),
(1245, 'https://ror.org/01eq8c489', 'en', 1, 'https://ror.org/01eq8c489 Lady Reading Hospital'),
(1246, 'https://ror.org/01eqjmz45', 'en', 1, 'https://ror.org/01eqjmz45 Hokko Memorial Hospital 北光記念病院'),
(1247, 'https://ror.org/01es3w453', 'no_lang_code', 1, 'https://ror.org/01es3w453 Northwest Media (United States)'),
(1248, 'https://ror.org/01espdw89', 'en', 1, 'https://ror.org/01espdw89 Beijing Chest Hospital'),
(1249, 'https://ror.org/01evb6z23', 'en', 1, 'https://ror.org/01evb6z23 King University'),
(1250, 'https://ror.org/01ew49p77', 'en', 1, 'https://ror.org/01ew49p77 Malcom Randall VA Medical Center'),
(1251, 'https://ror.org/01eyb5f38', 'en', 1, 'https://ror.org/01eyb5f38 Kern Medical Center'),
(1252, 'https://ror.org/01f97j659', 'en', 1, 'https://ror.org/01f97j659 Anyang Academy of Agricultural Sciences 安阳市农业科学院'),
(1253, 'https://ror.org/01fbdn283', 'en', 1, 'https://ror.org/01fbdn283 Magee-Womens Hospital'),
(1254, 'https://ror.org/01fbz6h17', 'en', 1, 'https://ror.org/01fbz6h17 Denver Health Medical Center'),
(1255, 'https://ror.org/01fd8g905', 'en', 1, 'https://ror.org/01fd8g905 University of Montevallo'),
(1256, 'https://ror.org/01fksx040', 'en', 1, 'https://ror.org/01fksx040 Gaustad Hospital Gaustad Sykehus'),
(1257, 'https://ror.org/01fm87m50', 'en', 1, 'https://ror.org/01fm87m50 Rambam Health Care Campus רמב"ם - הקריה הרפואית לבריאות האדם‎ مشفى رمبام'),
(1258, 'https://ror.org/01fmz4h16', 'no_lang_code', 1, 'https://ror.org/01fmz4h16 Hirosakiaiseikai Hospital 弘前愛成会病院'),
(1259, 'https://ror.org/01fpjqs91', 'en', 1, 'https://ror.org/01fpjqs91 St. Joseph''s Hospital'),
(1260, 'https://ror.org/01fv1ds98', 'no_lang_code', 1, 'https://ror.org/01fv1ds98 Yuan Ze University'),
(1261, 'https://ror.org/01fvf0d84', 'en', 1, 'https://ror.org/01fvf0d84 Tajen University'),
(1262, 'https://ror.org/01fvnb423', 'en', 1, 'https://ror.org/01fvnb423 Presbyterian Medical Center 예수병원'),
(1263, 'https://ror.org/01fxd7077', 'en', 1, 'https://ror.org/01fxd7077 Center for Health Care Law'),
(1264, 'https://ror.org/01fxdkm29', 'en', 1, 'https://ror.org/01fxdkm29 Doshisha University 同志社大学'),
(1265, 'https://ror.org/01fzm0693', 'en', 1, 'https://ror.org/01fzm0693 Abbott Northwestern Hospital'),
(1266, 'https://ror.org/01g171x08', 'en', 1, 'https://ror.org/01g171x08 Alice Ho Miu Ling Nethersole Hospital 雅麗氏何妙齡那打素醫院'),
(1267, 'https://ror.org/01g246z62', 'en', 1, 'https://ror.org/01g246z62 International Union of Railways Union internationale des chemins de fer'),
(1268, 'https://ror.org/01g2xkw11', 'pt', 1, 'https://ror.org/01g2xkw11 Instituto Superior de Gestão e Administração de Santarém'),
(1269, 'https://ror.org/01g312x22', 'no_lang_code', 1, 'https://ror.org/01g312x22 BG Group (United Kingdom)'),
(1270, 'https://ror.org/01g3pwn65', 'en', 1, 'https://ror.org/01g3pwn65 Mississippi Department of Mental Health'),
(1271, 'https://ror.org/01g63ab19', 'en', 1, 'https://ror.org/01g63ab19 Northside Hospital'),
(1272, 'https://ror.org/01g67by91', 'en', 1, 'https://ror.org/01g67by91 Mercer University Health Sciences Center'),
(1273, 'https://ror.org/01gaptw32', 'es', 1, 'https://ror.org/01gaptw32 Hospital de Hellín'),
(1274, 'https://ror.org/01gcc9p15', 'en', 1, 'https://ror.org/01gcc9p15 Saint John''s Health Center'),
(1275, 'https://ror.org/01gd3da15', 'no_lang_code', 1, 'https://ror.org/01gd3da15 Stantec (Canada)'),
(1276, 'https://ror.org/01gezbc84', 'en', 1, 'https://ror.org/01gezbc84 Japanese Red Cross Medical Center 日本赤十字社医療センター'),
(1277, 'https://ror.org/01ggyr403', 'en', 1, 'https://ror.org/01ggyr403 Canadian Foundation for Healthcare Improvement'),
(1278, 'https://ror.org/01ghsr491', 'no_lang_code', 1, 'https://ror.org/01ghsr491 Trevigen'),
(1279, 'https://ror.org/01gqe3t73', 'no_lang_code', 1, 'https://ror.org/01gqe3t73 Sangji University 상지대학교'),
(1280, 'https://ror.org/01grdhw06', 'en', 1, 'https://ror.org/01grdhw06 Center for Tuberculosis Control of Guangdong Province 广东省结核病控制'),
(1281, 'https://ror.org/01grq2104', 'en', 1, 'https://ror.org/01grq2104 Torrey Pines Institute For Molecular Studies'),
(1282, 'https://ror.org/01gst4g14', 'en', 1, 'https://ror.org/01gst4g14 New York City Department of Health and Mental Hygiene'),
(1283, 'https://ror.org/01gt7sg63', 'pt', 1, 'https://ror.org/01gt7sg63 Universidade de Taubaté University of Taubaté'),
(1284, 'https://ror.org/01gvfxs59', 'en', 1, 'https://ror.org/01gvfxs59 National Sagamihara Hospital 国立病院機構相模原病院'),
(1285, 'https://ror.org/01gxs7p86', 'en', 1, 'https://ror.org/01gxs7p86 Christiana Hospital'),
(1286, 'https://ror.org/01gynte55', 'en', 1, 'https://ror.org/01gynte55 Sharp Memorial Hospital'),
(1287, 'https://ror.org/01gzkdv90', 'en', 1, 'https://ror.org/01gzkdv90 Kun Shan University'),
(1288, 'https://ror.org/01h0x7c18', 'en', 1, 'https://ror.org/01h0x7c18 PBR Laboratories');
INSERT INTO `rors` VALUES
(1289, 'https://ror.org/01h22ap11', 'en', 1, 'https://ror.org/01h22ap11 Penn State Milton S. Hershey Medical Center'),
(1290, 'https://ror.org/01h29af62', 'no_lang_code', 1, 'https://ror.org/01h29af62 Spartan Bioscience (Canada)'),
(1291, 'https://ror.org/01h2hg078', 'en', 1, 'https://ror.org/01h2hg078 Birjand University of Medical Sciences دانشگاه علوم پزشکی بیرجند'),
(1292, 'https://ror.org/01h2jcs31', 'en', 1, 'https://ror.org/01h2jcs31 Jewish Hospital'),
(1293, 'https://ror.org/01h4hqc60', 'en', 1, 'https://ror.org/01h4hqc60 Transylvania University'),
(1294, 'https://ror.org/01h65nt31', 'en', 1, 'https://ror.org/01h65nt31 St. Mark''s Hospital'),
(1295, 'https://ror.org/01h6pd645', 'no_lang_code', 1, 'https://ror.org/01h6pd645 SurModics (United States)'),
(1296, 'https://ror.org/01h89k731', 'no_lang_code', 1, 'https://ror.org/01h89k731 TXT e-solutions (Italy)'),
(1297, 'https://ror.org/01h9xtf29', 'no_lang_code', 1, 'https://ror.org/01h9xtf29 Friday Systems (United States)'),
(1298, 'https://ror.org/01h9y0t02', 'en', 1, 'https://ror.org/01h9y0t02 Mount Sinai Hospital'),
(1299, 'https://ror.org/01ha5h612', 'en', 1, 'https://ror.org/01ha5h612 Princess Margaret Rose Orthopaedic Hospital'),
(1300, 'https://ror.org/01ha6bm93', 'no_lang_code', 1, 'https://ror.org/01ha6bm93 Progenra (United States)'),
(1301, 'https://ror.org/01hcyya48', 'en', 1, 'https://ror.org/01hcyya48 Cincinnati Children''s Hospital Medical Center'),
(1302, 'https://ror.org/01hhasq22', 'cs', 1, 'https://ror.org/01hhasq22 Výzkumný Ústav Zdraví Dítěte'),
(1303, 'https://ror.org/01hkncq81', 'en', 1, 'https://ror.org/01hkncq81 Hiroshima City Asa Citizens Hospital 広島市立安佐市民病院'),
(1304, 'https://ror.org/01hs43g67', 'en', 1, 'https://ror.org/01hs43g67 Mississippi University for Women'),
(1305, 'https://ror.org/01hssm416', 'en', 1, 'https://ror.org/01hssm416 St John''s Hospital'),
(1306, 'https://ror.org/01hsw0492', 'en', 1, 'https://ror.org/01hsw0492 Gesellschaft für Chemische Technik und Biotechnologie Society for Chemical Engineering and Biotechnology'),
(1307, 'https://ror.org/01hy1ab69', 'en', 1, 'https://ror.org/01hy1ab69 Michigan Surgical Hospital'),
(1308, 'https://ror.org/01hy4qx27', 'en', 1, 'https://ror.org/01hy4qx27 University of Minnesota, Duluth'),
(1309, 'https://ror.org/01hyxtd05', 'no_lang_code', 1, 'https://ror.org/01hyxtd05 Neova Technologies Inc.'),
(1310, 'https://ror.org/01j0n2h15', 'en', 1, 'https://ror.org/01j0n2h15 Universidad de Phoenix University of Phoenix Université de phoenix'),
(1311, 'https://ror.org/01j0qa041', 'it', 1, 'https://ror.org/01j0qa041 Ospedali Riuniti di Ancona'),
(1312, 'https://ror.org/01j17xg39', 'en', 1, 'https://ror.org/01j17xg39 New York Hospital Queens'),
(1313, 'https://ror.org/01j25h453', 'en', 1, 'https://ror.org/01j25h453 Kelowna General Hospital'),
(1314, 'https://ror.org/01j6t9363', 'fr', 1, 'https://ror.org/01j6t9363 Hôpital Razi de La Manouba مستشفئ الرازي'),
(1315, 'https://ror.org/01j780996', 'de', 1, 'https://ror.org/01j780996 Leopoldina Krankenhaus Schweinfurt'),
(1316, 'https://ror.org/01j7azy31', 'tr', 1, 'https://ror.org/01j7azy31 Dr Sami Ulus Çocuk Sağlığı ve Hastalıkları Eğitim ve Araştırma Hastanesi'),
(1317, 'https://ror.org/01j8kmv80', 'en', 1, 'https://ror.org/01j8kmv80 Golmud People''s Hospital 格尔木市人民医院'),
(1318, 'https://ror.org/01j9pph68', 'en', 1, 'https://ror.org/01j9pph68 Orlando Regional Medical Center'),
(1319, 'https://ror.org/01ja5zt45', 'en', 1, 'https://ror.org/01ja5zt45 District of Columbia Department of Health'),
(1320, 'https://ror.org/01jaaym28', 'en', 1, 'https://ror.org/01jaaym28 Shimane University 島根大学'),
(1321, 'https://ror.org/01jckan13', 'en', 1, 'https://ror.org/01jckan13 Kin-ikyo Chuo Hospital 勤医協中央病院'),
(1322, 'https://ror.org/01jdekv92', 'en', 1, 'https://ror.org/01jdekv92 Berkeley Geochronology Center'),
(1323, 'https://ror.org/01je6q363', 'fr', 1, 'https://ror.org/01je6q363 Centre Technique Industriel De La Construction Metallique'),
(1324, 'https://ror.org/01jfr3w16', 'en', 1, 'https://ror.org/01jfr3w16 Pacific Institute For Research and Evaluation'),
(1325, 'https://ror.org/01jg3a168', 'en', 1, 'https://ror.org/01jg3a168 Gosford Hospital'),
(1326, 'https://ror.org/01jh1mm11', 'en', 1, 'https://ror.org/01jh1mm11 Istanbul Florence Nightingale Hospital İstanbul Florence Nightingale Hastanesi'),
(1327, 'https://ror.org/01jhgy173', 'en', 1, 'https://ror.org/01jhgy173 Kishiwada City Hospital 市立岸和田市民病院'),
(1328, 'https://ror.org/01jhsfg10', 'pt', 1, 'https://ror.org/01jhsfg10 Hospital de Dona Estefânia'),
(1329, 'https://ror.org/01jj26143', 'it', 1, 'https://ror.org/01jj26143 Hospital of the Holy Spirit Ospedale di Santo Spirito, Ospedale di Santo Spirito in Sassia'),
(1330, 'https://ror.org/01jj2sr90', 'en', 1, 'https://ror.org/01jj2sr90 Broward Health Medical Center'),
(1331, 'https://ror.org/01jjm6w53', 'en', 1, 'https://ror.org/01jjm6w53 Banner Desert Medical Center'),
(1332, 'https://ror.org/01jk32r56', 'no_lang_code', 1, 'https://ror.org/01jk32r56 Sirehna'),
(1333, 'https://ror.org/01jk6xr82', 'en', 1, 'https://ror.org/01jk6xr82 Rochester General Hospital'),
(1334, 'https://ror.org/01jm17996', 'en', 1, 'https://ror.org/01jm17996 Mission Heritage Medical Group'),
(1335, 'https://ror.org/01jm19r53', 'no_lang_code', 1, 'https://ror.org/01jm19r53 TuTech Innovation (Germany)'),
(1336, 'https://ror.org/01jmd7f74', 'en', 1, 'https://ror.org/01jmd7f74 Chuvash State University Чувашский государственный университет имени И. Н. Ульянова'),
(1337, 'https://ror.org/01jmsem62', 'es', 1, 'https://ror.org/01jmsem62 Hospital General Universitario de Elche'),
(1338, 'https://ror.org/01jn2rz36', 'fr', 1, 'https://ror.org/01jn2rz36 Hôpital de Jolimont'),
(1339, 'https://ror.org/01jqz8f37', 'en', 1, 'https://ror.org/01jqz8f37 Wayne Memorial Health System'),
(1340, 'https://ror.org/01jtn9895', 'no_lang_code', 1, 'https://ror.org/01jtn9895 Osaka Ohtani University 大阪大谷大学'),
(1341, 'https://ror.org/01k05jx47', 'en', 1, 'https://ror.org/01k05jx47 Mercy Catholic Medical Center'),
(1342, 'https://ror.org/01k18gj34', 'en', 1, 'https://ror.org/01k18gj34 Ashworth College'),
(1343, 'https://ror.org/01k1azd31', 'no_lang_code', 1, 'https://ror.org/01k1azd31 Kumamotorosaibyoin 熊本労災病院'),
(1344, 'https://ror.org/01k1ea759', 'no_lang_code', 1, 'https://ror.org/01k1ea759 AUG Signals (Canada)'),
(1345, 'https://ror.org/01k22c722', 'en', 1, 'https://ror.org/01k22c722 Dr. V. M. Government Medical College डॉ. वैशंपायन स्मृती शासकीय वैद्यकीय महाविद्यालय'),
(1346, 'https://ror.org/01k5k4m02', 'en', 1, 'https://ror.org/01k5k4m02 Jan Evangelista Purkyně Military Medical Academy'),
(1347, 'https://ror.org/01k5x4673', 'en', 1, 'https://ror.org/01k5x4673 Saint Francis Medical Center'),
(1348, 'https://ror.org/01k6vxj52', 'en', 1, 'https://ror.org/01k6vxj52 Omsk State University Омский государственный университет имени Ф. М. Достоевского'),
(1349, 'https://ror.org/01k7a6660', 'en', 1, 'https://ror.org/01k7a6660 Hennepin County Medical Center'),
(1350, 'https://ror.org/01k8ej563', 'en', 1, 'https://ror.org/01k8ej563 Keio University Hospital 慶應義塾大学病院'),
(1351, 'https://ror.org/01kbw1w05', 'no_lang_code', 1, 'https://ror.org/01kbw1w05 Infinite Biomedical Technologies (United States)'),
(1352, 'https://ror.org/01kc65v41', 'it', 1, 'https://ror.org/01kc65v41 Fondazione "Ugo Bordoni" Ugo Bordoni Foundation'),
(1353, 'https://ror.org/01kcq3761', 'en', 1, 'https://ror.org/01kcq3761 Kent Hospital'),
(1354, 'https://ror.org/01kdnph40', 'es', 1, 'https://ror.org/01kdnph40 Hospital La Paloma'),
(1355, 'https://ror.org/01kdvym37', 'de', 1, 'https://ror.org/01kdvym37 Battelle-Institut ev'),
(1356, 'https://ror.org/01kgs1r94', 'no_lang_code', 1, 'https://ror.org/01kgs1r94 Electrical Geodesics (United States)'),
(1357, 'https://ror.org/01khsr243', 'en', 1, 'https://ror.org/01khsr243 St. Peter''s Hospital'),
(1358, 'https://ror.org/01kq6mv68', 'en', 1, 'https://ror.org/01kq6mv68 Second Affiliated Hospital of Kunming Medical College 昆明医科大学第二附属医院'),
(1359, 'https://ror.org/01kqjm533', 'en', 1, 'https://ror.org/01kqjm533 Kurihama Medical and Addiction Center 久里浜医療センター'),
(1360, 'https://ror.org/01kr7aq59', 'en', 1, 'https://ror.org/01kr7aq59 Rivers State University'),
(1361, 'https://ror.org/01krywm46', 'en', 1, 'https://ror.org/01krywm46 University of Virginia Children''s Hospital'),
(1362, 'https://ror.org/01kta7d96', 'en', 1, 'https://ror.org/01kta7d96 McLean Hospital'),
(1363, 'https://ror.org/01kvp0178', 'no_lang_code', 1, 'https://ror.org/01kvp0178 Ontario Power Generation'),
(1364, 'https://ror.org/01kvtm035', 'en', 1, 'https://ror.org/01kvtm035 South Australia Pathology'),
(1365, 'https://ror.org/01kw6jz33', 'no_lang_code', 1, 'https://ror.org/01kw6jz33 BGI Group (Japan)'),
(1366, 'https://ror.org/01kxqsy59', 'no_lang_code', 1, 'https://ror.org/01kxqsy59 Atos (Spain)'),
(1367, 'https://ror.org/01ky2n109', 'pt', 1, 'https://ror.org/01ky2n109 Hospital Federal dos Servidores do Estado'),
(1368, 'https://ror.org/01kzgyz42', 'en', 1, 'https://ror.org/01kzgyz42 Qiqihar Medical University 齐齐哈尔医学院'),
(1369, 'https://ror.org/01m006041', 'en', 1, 'https://ror.org/01m006041 Thiel College'),
(1370, 'https://ror.org/01m1gv240', 'en', 1, 'https://ror.org/01m1gv240 King Fahad Specialist Hospital مستشفى الملك فهد التخصصي'),
(1371, 'https://ror.org/01m1pv723', 'en', 1, 'https://ror.org/01m1pv723 Hôpitaux universitaires de Genève University Hospital of Geneva'),
(1372, 'https://ror.org/01m1v6377', 'en', 1, 'https://ror.org/01m1v6377 Association Of Atlantic Universities'),
(1373, 'https://ror.org/01m2js356', 'en', 1, 'https://ror.org/01m2js356 Orthopaedic Hospital'),
(1374, 'https://ror.org/01m46xf39', 'en', 1, 'https://ror.org/01m46xf39 All India Institute of Hygiene and Public Health अखिल भारतीय स्वास्थ्य र्विज्ञान एवं जन स्वास्थ्य संस्थान'),
(1375, 'https://ror.org/01m484026', 'no_lang_code', 1, 'https://ror.org/01m484026 Smithers Pira'),
(1376, 'https://ror.org/01m7mrx20', 'es', 1, 'https://ror.org/01m7mrx20 Hospital Central Dr. Ignacio Morones Prieto'),
(1377, 'https://ror.org/01m9rk435', 'en', 1, 'https://ror.org/01m9rk435 Richmond University Medical Center'),
(1378, 'https://ror.org/01mfrg562', 'en', 1, 'https://ror.org/01mfrg562 Dauphin Island Sea Lab'),
(1379, 'https://ror.org/01mh1c318', 'en', 1, 'https://ror.org/01mh1c318 Federation of American Societies for Experimental Biology'),
(1380, 'https://ror.org/01mhbkr88', 'en', 1, 'https://ror.org/01mhbkr88 St Martha''s Regional Hospital'),
(1381, 'https://ror.org/01mpngw81', 'en', 1, 'https://ror.org/01mpngw81 Government Kilpauk Medical College கீழ்பாக்கம் மருத்துவக் கல்லூரி'),
(1382, 'https://ror.org/01mqsmm97', 'es', 1, 'https://ror.org/01mqsmm97 Hospital Regional Universitario de Málaga'),
(1383, 'https://ror.org/01mqvjv41', 'pt', 1, 'https://ror.org/01mqvjv41 Federal University of Mato Grosso Universidade Federal de Mato Grosso'),
(1384, 'https://ror.org/01msdga41', 'no_lang_code', 1, 'https://ror.org/01msdga41 Dornier Flugzeugwerke (Germany)'),
(1385, 'https://ror.org/01mtpwn71', 'no_lang_code', 1, 'https://ror.org/01mtpwn71 Adan Hospital مستشفى العدان'),
(1386, 'https://ror.org/01mvmmg68', 'en', 1, 'https://ror.org/01mvmmg68 San Jacinto Methodist Hospital'),
(1387, 'https://ror.org/01mw6s018', 'it', 1, 'https://ror.org/01mw6s018 Casa di Cura Villa Garda'),
(1388, 'https://ror.org/01mxpdw03', 'en', 1, 'https://ror.org/01mxpdw03 First Affiliated Hospital of Guangzhou University of Chinese Medicine'),
(1389, 'https://ror.org/01myv2z03', 'en', 1, 'https://ror.org/01myv2z03 Nayoro City General Hospital 名寄市立総合病院'),
(1390, 'https://ror.org/01myv5196', 'en', 1, 'https://ror.org/01myv5196 Sivas Devlet Hastanesi Sivas State Hospital'),
(1391, 'https://ror.org/01mz9wf40', 'en', 1, 'https://ror.org/01mz9wf40 Chu Shang Show Chwan Hospital'),
(1392, 'https://ror.org/01n1j0f20', 'fr', 1, 'https://ror.org/01n1j0f20 Hôpital Aristide Le Dantec'),
(1393, 'https://ror.org/01n260e81', 'en', 1, 'https://ror.org/01n260e81 Rancho Santa Ana Botanic Garden'),
(1394, 'https://ror.org/01n2xwm51', 'en', 1, 'https://ror.org/01n2xwm51 Meyer Children''s Hospital Ospedale Pediatrico Meyer'),
(1395, 'https://ror.org/01n67jr26', 'en', 1, 'https://ror.org/01n67jr26 Forest Department Sarawak'),
(1396, 'https://ror.org/01n70p029', 'en', 1, 'https://ror.org/01n70p029 Birmingham and Midland Eye Centre'),
(1397, 'https://ror.org/01n85qf05', 'pt', 1, 'https://ror.org/01n85qf05 Escola Superior de Enfermagem S. Francisco das Misericórdias'),
(1398, 'https://ror.org/01na5rp93', 'no_lang_code', 1, 'https://ror.org/01na5rp93 Bioqual'),
(1399, 'https://ror.org/01ncx3917', 'en', 1, 'https://ror.org/01ncx3917 Rosie Hospital'),
(1400, 'https://ror.org/01nf63x62', 'en', 1, 'https://ror.org/01nf63x62 Institute of Global Environment and Society'),
(1401, 'https://ror.org/01ng1yh19', 'en', 1, 'https://ror.org/01ng1yh19 Charlie Norwood VA Medical Center'),
(1402, 'https://ror.org/01nhcyg40', 'no_lang_code', 1, 'https://ror.org/01nhcyg40 Nagoya Ekisaikai Hospital 名古屋掖済会病院'),
(1403, 'https://ror.org/01nhrc260', 'en', 1, 'https://ror.org/01nhrc260 Froedtert Hospital'),
(1404, 'https://ror.org/01nhzsw25', 'fr', 1, 'https://ror.org/01nhzsw25 Hydro-Québec'),
(1405, 'https://ror.org/01nj4ek07', 'en', 1, 'https://ror.org/01nj4ek07 Hinchingbrooke Hospital'),
(1406, 'https://ror.org/01nj8sa76', 'en', 1, 'https://ror.org/01nj8sa76 Royal Alexandra Hospital'),
(1407, 'https://ror.org/01nn35n25', 'en', 1, 'https://ror.org/01nn35n25 Institute of Accelerating Systems and Applications Ινστιτούτο Επιταχυντικών Συστημάτων και Εφαρμογών'),
(1408, 'https://ror.org/01npf0s58', 'en', 1, 'https://ror.org/01npf0s58 National Ilan University 國立宜蘭大學'),
(1409, 'https://ror.org/01nr6fy72', 'en', 1, 'https://ror.org/01nr6fy72 Ljubljana University Medical Centre'),
(1410, 'https://ror.org/01nthrq77', 'es', 1, 'https://ror.org/01nthrq77 Instituto Tecnologico Del Embalaje, Transporte Y Logistica'),
(1411, 'https://ror.org/01nw60f27', 'no_lang_code', 1, 'https://ror.org/01nw60f27 Saiseikai Wakakusa Hospital 済生会若草病院'),
(1412, 'https://ror.org/01nwsvf80', 'en', 1, 'https://ror.org/01nwsvf80 Shiga Medical Center for Children 子供のための滋賀医療センター'),
(1413, 'https://ror.org/01nxjpd08', 'en', 1, 'https://ror.org/01nxjpd08 Vladimir State University Федеральное государственное бюджетное образовательное учреждение высшего образования Владимирский государственный университет имени Александра Григорьевича и Николая Григорьевича Столетовых'),
(1414, 'https://ror.org/01nxv5c88', 'en', 1, 'https://ror.org/01nxv5c88 Second Affiliated Hospital of Nanchang University 南昌大学第二附属医院'),
(1415, 'https://ror.org/01nyv7k26', 'en', 1, 'https://ror.org/01nyv7k26 Oita University 大分大学'),
(1416, 'https://ror.org/01p01k535', 'en', 1, 'https://ror.org/01p01k535 Taoyuan Armed Forces General Hospital 桃园武装部队总医院'),
(1417, 'https://ror.org/01p0ttv97', 'en', 1, 'https://ror.org/01p0ttv97 Dickinson State University'),
(1418, 'https://ror.org/01p2t4k13', 'en', 1, 'https://ror.org/01p2t4k13 Heilongjiang Center for Tuberculosis Control and Prevention'),
(1419, 'https://ror.org/01p37he69', 'en', 1, 'https://ror.org/01p37he69 Kansas Wesleyan University'),
(1420, 'https://ror.org/01p3tpn79', 'es', 1, 'https://ror.org/01p3tpn79 Hospital Universitari Arnau de Vilanova'),
(1421, 'https://ror.org/01p7j6t08', 'en', 1, 'https://ror.org/01p7j6t08 Mississippi College'),
(1422, 'https://ror.org/01p830915', 'en', 1, 'https://ror.org/01p830915 Morriston Hospital Ysbyty Treforus'),
(1423, 'https://ror.org/01p8da469', 'it', 1, 'https://ror.org/01p8da469 Ospedale Amedeo di Savoia'),
(1424, 'https://ror.org/01papkj44', 'en', 1, 'https://ror.org/01papkj44 University of Tabriz دانشگاه تبریز'),
(1425, 'https://ror.org/01pd66220', 'en', 1, 'https://ror.org/01pd66220 302 Military Hospital of China 中国人民解放军第302医院'),
(1426, 'https://ror.org/01phhgk62', 'en', 1, 'https://ror.org/01phhgk62 Boca Raton Regional Hospital'),
(1427, 'https://ror.org/01phydj90', 'en', 1, 'https://ror.org/01phydj90 Akdeniz University Hospital Akdeniz Üniversitesi Hastanesi'),
(1428, 'https://ror.org/01pj4nt72', 'en', 1, 'https://ror.org/01pj4nt72 Nordland Hospital'),
(1429, 'https://ror.org/01pjjvq50', 'en', 1, 'https://ror.org/01pjjvq50 Eastbourne District General Hospital'),
(1430, 'https://ror.org/01pm59m24', 'en', 1, 'https://ror.org/01pm59m24 Akashi Municipal City Hospital 明石市立市民病院'),
(1431, 'https://ror.org/01pp15642', 'en', 1, 'https://ror.org/01pp15642 South Nassau Communities Hospital'),
(1432, 'https://ror.org/01ppcnz44', 'tr', 1, 'https://ror.org/01ppcnz44 Antalya Eğitim ve Araştırma Hastanesi'),
(1433, 'https://ror.org/01ppsp263', 'en', 1, 'https://ror.org/01ppsp263 Toneyama National Hospital 刀根山国立病院'),
(1434, 'https://ror.org/01praqa56', 'en', 1, 'https://ror.org/01praqa56 National Institute of Occupational Health'),
(1435, 'https://ror.org/01ps4ag81', 'no_lang_code', 1, 'https://ror.org/01ps4ag81 Fountain Biopharma (Taiwan)'),
(1436, 'https://ror.org/01pveve47', 'en', 1, 'https://ror.org/01pveve47 United States Army Medical Research Institute of Infectious Diseases'),
(1437, 'https://ror.org/01pvgz545', 'no_lang_code', 1, 'https://ror.org/01pvgz545 Ishikiriseiki Hospital 石切生喜病院'),
(1438, 'https://ror.org/01px48m89', 'en', 1, 'https://ror.org/01px48m89 Bentley University'),
(1439, 'https://ror.org/01px77p81', 'en', 1, 'https://ror.org/01px77p81 Sun Yat-sen Memorial Hospital'),
(1440, 'https://ror.org/01pxg9d10', 'en', 1, 'https://ror.org/01pxg9d10 Meyer Children''s Hospital'),
(1441, 'https://ror.org/01pxhdc49', 'en', 1, 'https://ror.org/01pxhdc49 Miyazaki Prefectural Hospital 宮崎県立病院'),
(1442, 'https://ror.org/01pym8r61', 'en', 1, 'https://ror.org/01pym8r61 Centre for Research in Medical Entomology'),
(1443, 'https://ror.org/01pzjt917', 'eu', 1, 'https://ror.org/01pzjt917 Hospital Txagorritxu'),
(1444, 'https://ror.org/01q046q46', 'fr', 1, 'https://ror.org/01q046q46 Hôpital Pierre Wertheimer'),
(1445, 'https://ror.org/01q11am17', 'en', 1, 'https://ror.org/01q11am17 Roper Hospital'),
(1446, 'https://ror.org/01q1jaw52', 'en', 1, 'https://ror.org/01q1jaw52 AHEPA University Hospital Πανεπιστημιακό Νοσοκομείο ΑΧΕΠΑ'),
(1447, 'https://ror.org/01q1y4t48', 'en', 1, 'https://ror.org/01q1y4t48 Virginia Tech - Wake Forest University School of Biomedical Engineering & Sciences'),
(1448, 'https://ror.org/01q2nz307', 'en', 1, 'https://ror.org/01q2nz307 Baystate Medical Center'),
(1449, 'https://ror.org/01q2ty078', 'no_lang_code', 1, 'https://ror.org/01q2ty078 Saku Central Hospital 佐久総合病院'),
(1450, 'https://ror.org/01q2y2d42', 'en', 1, 'https://ror.org/01q2y2d42 Departamento de Salud y Servicios Sociales de los Estados Unidos Département de la santé et des services sociaux des États-unis State of Maine Department of Health and Human Services'),
(1451, 'https://ror.org/01q4pk532', 'no_lang_code', 1, 'https://ror.org/01q4pk532 Hydro One (Canada)'),
(1452, 'https://ror.org/01q6b3f33', 'no_lang_code', 1, 'https://ror.org/01q6b3f33 Al Omooma Hospital'),
(1453, 'https://ror.org/01q6hrg49', 'it', 1, 'https://ror.org/01q6hrg49 Ospedale Garibaldi'),
(1454, 'https://ror.org/01q750e89', 'nl', 1, 'https://ror.org/01q750e89 Elkerliek Ziekenhuis'),
(1455, 'https://ror.org/01q8f6705', 'no_lang_code', 1, 'https://ror.org/01q8f6705 BASF (Germany)'),
(1456, 'https://ror.org/01q9r1072', 'en', 1, 'https://ror.org/01q9r1072 Boys Town National Research Hospital'),
(1457, 'https://ror.org/01qbebb31', 'en', 1, 'https://ror.org/01qbebb31 Papworth Hospital NHS Foundation Trust'),
(1458, 'https://ror.org/01qc48765', 'en', 1, 'https://ror.org/01qc48765 Association of Academic Health Centers'),
(1459, 'https://ror.org/01qcxb695', 'no_lang_code', 1, 'https://ror.org/01qcxb695 Mahosot Hospital'),
(1460, 'https://ror.org/01qd3xc93', 'en', 1, 'https://ror.org/01qd3xc93 Fondazione Mario Negri Sud Mario Negri Sud Foundation'),
(1461, 'https://ror.org/01qdp7m73', 'en', 1, 'https://ror.org/01qdp7m73 Bryn Mawr Rehabilitation Hospital'),
(1462, 'https://ror.org/01qe4gr33', 'en', 1, 'https://ror.org/01qe4gr33 Family and Social Services Administration'),
(1463, 'https://ror.org/01qe7f394', 'en', 1, 'https://ror.org/01qe7f394 Ministerio de Salud de Chile Ministry of Health'),
(1464, 'https://ror.org/01qemgb02', 'en', 1, 'https://ror.org/01qemgb02 Manipal Teaching Hospital मणिपाल टीचिंग हस्पिटल'),
(1465, 'https://ror.org/01qh26a66', 'en', 1, 'https://ror.org/01qh26a66 Sichuan Academy of Medical Sciences & Sichuan Provincial People''s Hospital 四川省中医药科学院'),
(1466, 'https://ror.org/01qh83x04', 'sv', 1, 'https://ror.org/01qh83x04 Västmanlands sjukhus Västerås'),
(1467, 'https://ror.org/01qn0gc28', 'en', 1, 'https://ror.org/01qn0gc28 Yuri Gagarin State Technical University of Saratov Саратовский государственный технический университет имени Ю. А. Гагарина'),
(1468, 'https://ror.org/01qr3vg91', 'en', 1, 'https://ror.org/01qr3vg91 Regional Medical Research Centre'),
(1469, 'https://ror.org/01qr5a671', 'en', 1, 'https://ror.org/01qr5a671 Tohoku Fukushi University 東北福祉大学'),
(1470, 'https://ror.org/01qt0gj86', 'lt', 1, 'https://ror.org/01qt0gj86 Lietuvos Bioetikos Komitetas Lithuanian Bioethics Committee'),
(1471, 'https://ror.org/01qtc5416', 'en', 1, 'https://ror.org/01qtc5416 Federal Office of Public Health'),
(1472, 'https://ror.org/01qtnxn83', 'en', 1, 'https://ror.org/01qtnxn83 Technical University of Nova Scotia'),
(1473, 'https://ror.org/01qv3ba61', 'en', 1, 'https://ror.org/01qv3ba61 University of Port Harcourt Teaching Hospital'),
(1474, 'https://ror.org/01qv3p587', 'no_lang_code', 1, 'https://ror.org/01qv3p587 Universal Stabilization Technologies'),
(1475, 'https://ror.org/01qww1p93', 'en', 1, 'https://ror.org/01qww1p93 Dominican University'),
(1476, 'https://ror.org/01qyd4k24', 'en', 1, 'https://ror.org/01qyd4k24 Hoseo University 호서대학교'),
(1477, 'https://ror.org/01qz7fr76', 'en', 1, 'https://ror.org/01qz7fr76 Brighton and Sussex Medical School'),
(1478, 'https://ror.org/01r05t925', 'tr', 1, 'https://ror.org/01r05t925 Ankara Onkoloji Eğitim ve Araştırma Hastanesi'),
(1479, 'https://ror.org/01r0bpx56', 'no_lang_code', 1, 'https://ror.org/01r0bpx56 Hiratsuka Kyosai Hospital 平塚共済病院'),
(1480, 'https://ror.org/01r2n9849', 'en', 1, 'https://ror.org/01r2n9849 Saint John''s Hospital'),
(1481, 'https://ror.org/01r3ez507', 'en', 1, 'https://ror.org/01r3ez507 Sterling Hospitals'),
(1482, 'https://ror.org/01r3kd649', 'tr', 1, 'https://ror.org/01r3kd649 S.B. Keçiören Eğitim ve Araştırma Hastanesi'),
(1483, 'https://ror.org/01r4bn552', 'en', 1, 'https://ror.org/01r4bn552 Institut von karman de dynamique des fluides Von Karman Institut für Strömungsmechanik Von Karman Institute for Fluid Dynamics'),
(1484, 'https://ror.org/01r5r0r56', 'en', 1, 'https://ror.org/01r5r0r56 Washington Adventist Hospital'),
(1485, 'https://ror.org/01r89q997', 'en', 1, 'https://ror.org/01r89q997 Royal Victoria Regional Health Centre'),
(1486, 'https://ror.org/01r8fpq52', 'en', 1, 'https://ror.org/01r8fpq52 Niigata City General Hospital 新潟市民病院'),
(1487, 'https://ror.org/01r9be524', 'en', 1, 'https://ror.org/01r9be524 Bristol Hospital'),
(1488, 'https://ror.org/01r9ea713', 'en', 1, 'https://ror.org/01r9ea713 Blackpool Victoria Hospital'),
(1489, 'https://ror.org/01rabm487', 'pt', 1, 'https://ror.org/01rabm487 Hospital Nossa Senhora das Graças'),
(1490, 'https://ror.org/01rahby95', 'en', 1, 'https://ror.org/01rahby95 Department of Human Services'),
(1491, 'https://ror.org/01rb2ev69', 'no_lang_code', 1, 'https://ror.org/01rb2ev69 Inspiralia'),
(1492, 'https://ror.org/01rb2st83', 'sk', 1, 'https://ror.org/01rb2st83 Univerzitná Nemocnica Louisa Pasteura'),
(1493, 'https://ror.org/01rb4vv49', 'en', 1, 'https://ror.org/01rb4vv49 Shariati Hospital بیمارستان شریعتی'),
(1494, 'https://ror.org/01rdjpj45', 'en', 1, 'https://ror.org/01rdjpj45 M. P. Shah Medical College શ્રી એમપી શાહ સરકારી મેડિકલ કોલેજ'),
(1495, 'https://ror.org/01rdvwx15', 'en', 1, 'https://ror.org/01rdvwx15 Lee Memorial Hospital'),
(1496, 'https://ror.org/01rf07780', 'es', 1, 'https://ror.org/01rf07780 Hospital Provincial de Conxo'),
(1497, 'https://ror.org/01rm42p40', 'en', 1, 'https://ror.org/01rm42p40 University of Alabama at Birmingham Hospital'),
(1498, 'https://ror.org/01rrcbe60', 'en', 1, 'https://ror.org/01rrcbe60 White Memorial Medical Center'),
(1499, 'https://ror.org/01rrd4612', 'no_lang_code', 1, 'https://ror.org/01rrd4612 Hiroshima Prefectural Hospital 県立広島病院'),
(1500, 'https://ror.org/01rs0ht88', 'en', 1, 'https://ror.org/01rs0ht88 Ministry of Health and Medical Education'),
(1501, 'https://ror.org/01rsda187', 'en', 1, 'https://ror.org/01rsda187 Mitate Hospital 見立病院'),
(1502, 'https://ror.org/01rvf6k07', 'en', 1, 'https://ror.org/01rvf6k07 Military Hospital'),
(1503, 'https://ror.org/01rws6r75', 'en', 1, 'https://ror.org/01rws6r75 Ahvaz Jundishapur University of Medical Sciences دانشگاه علوم پزشکی جندی‌شاپور اهواز'),
(1504, 'https://ror.org/01rx63s97', 'pt', 1, 'https://ror.org/01rx63s97 Guarulhos University'),
(1505, 'https://ror.org/01rxfrp27', 'en', 1, 'https://ror.org/01rxfrp27 La Trobe University'),
(1506, 'https://ror.org/01ry6tw68', 'no_lang_code', 1, 'https://ror.org/01ry6tw68 Balance Technology Consulting'),
(1507, 'https://ror.org/01rzm0s68', 'en', 1, 'https://ror.org/01rzm0s68 Sentara Rockingham Memorial Hospital Medical Center'),
(1508, 'https://ror.org/01s0phq15', 'en', 1, 'https://ror.org/01s0phq15 Inverclyde Royal Hospital'),
(1509, 'https://ror.org/01s434164', 'en', 1, 'https://ror.org/01s434164 Nathan Kline Institute for Psychiatric Research'),
(1510, 'https://ror.org/01s4cx283', 'no_lang_code', 1, 'https://ror.org/01s4cx283 Shizuoka Saiseikai General Hospital 静岡済生会総合病院'),
(1511, 'https://ror.org/01s5axj25', 'en', 1, 'https://ror.org/01s5axj25 Lunenfeld-Tanenbaum Research Institute'),
(1512, 'https://ror.org/01s5r6w32', 'en', 1, 'https://ror.org/01s5r6w32 Central Arkansas Veterans Healthcare System'),
(1513, 'https://ror.org/01s5ya894', 'en', 1, 'https://ror.org/01s5ya894 National Institute of Neurological Disorders and Stroke'),
(1514, 'https://ror.org/01s7jxc19', 'en', 1, 'https://ror.org/01s7jxc19 Miyagi University of Education 宮城教育大学'),
(1515, 'https://ror.org/01s7w1z60', 'fr', 1, 'https://ror.org/01s7w1z60 Hotel Dieu Hospital'),
(1516, 'https://ror.org/01s7y5e82', 'en', 1, 'https://ror.org/01s7y5e82 Ivan Franko Nemzeti Egyetem Lviv Lviv University Uniwersytet Lwowski Львовский национальный университет имени Ивана Франко Львівський національний університет імені Івана Франка'),
(1517, 'https://ror.org/01s8xxq04', 'en', 1, 'https://ror.org/01s8xxq04 Eastern Oregon University'),
(1518, 'https://ror.org/01s9rzk09', 'en', 1, 'https://ror.org/01s9rzk09 Kushiro Rosai Hospital 釧路ろうさい病院'),
(1519, 'https://ror.org/01sgn8034', 'en', 1, 'https://ror.org/01sgn8034 Trinitas Regional Medical Center'),
(1520, 'https://ror.org/01shhkn05', 'en', 1, 'https://ror.org/01shhkn05 East Orange VA Medical Center'),
(1521, 'https://ror.org/01ska0k70', 'en', 1, 'https://ror.org/01ska0k70 Millard Fillmore Suburban Hospital'),
(1522, 'https://ror.org/01skxn174', 'en', 1, 'https://ror.org/01skxn174 Lower Manhattan Hospital'),
(1523, 'https://ror.org/01sm4s887', 'en', 1, 'https://ror.org/01sm4s887 Bundesinstitut für gesundheitlichen Verbraucherschutz und Veterinärmedizin Federal Institute for Health Protection of Consumers and Veterinary Medicine'),
(1524, 'https://ror.org/01smmxq73', 'en', 1, 'https://ror.org/01smmxq73 Doctors Hospital'),
(1525, 'https://ror.org/01smpj292', 'en', 1, 'https://ror.org/01smpj292 Arizona Department of Health Services'),
(1526, 'https://ror.org/01sps7q28', 'en', 1, 'https://ror.org/01sps7q28 The University of Texas Health Science Center at Tyler'),
(1527, 'https://ror.org/01sxtx626', 'en', 1, 'https://ror.org/01sxtx626 Ministry of Health Міністерство охорони здоров''я України'),
(1528, 'https://ror.org/01sytk573', 'en', 1, 'https://ror.org/01sytk573 National Science Museum'),
(1529, 'https://ror.org/01t0n3b84', 'it', 1, 'https://ror.org/01t0n3b84 Consorzio Pisa Ricerche'),
(1530, 'https://ror.org/01t33qq42', 'en', 1, 'https://ror.org/01t33qq42 Arkansas Children''s Hospital'),
(1531, 'https://ror.org/01t3emk15', 'en', 1, 'https://ror.org/01t3emk15 Central Chest Institute of Thailand'),
(1532, 'https://ror.org/01t409e13', 'en', 1, 'https://ror.org/01t409e13 Regional Hospital Holstebro'),
(1533, 'https://ror.org/01t54q348', 'en', 1, 'https://ror.org/01t54q348 Grantham Hospital 葛量洪醫院'),
(1534, 'https://ror.org/01t5yh786', 'en', 1, 'https://ror.org/01t5yh786 Hôpital Universitaire Des Enfants Reine Fabiola Queen Fabiola Children''s University Hospital'),
(1535, 'https://ror.org/01t69y763', 'en', 1, 'https://ror.org/01t69y763 St. Luke''s Hospital'),
(1536, 'https://ror.org/01t6fdj11', 'en', 1, 'https://ror.org/01t6fdj11 Mary Free Bed Rehabilitation Hospital'),
(1537, 'https://ror.org/01t6tyq74', 'en', 1, 'https://ror.org/01t6tyq74 Consortium of Universities for Research in Earthquake Engineering'),
(1538, 'https://ror.org/01t817z14', 'en', 1, 'https://ror.org/01t817z14 University of Houston - Clear Lake'),
(1539, 'https://ror.org/01t8svj65', 'en', 1, 'https://ror.org/01t8svj65 University of California San Francisco Medical Center'),
(1540, 'https://ror.org/01tcy5w98', 'no_lang_code', 1, 'https://ror.org/01tcy5w98 Aurum Institute'),
(1541, 'https://ror.org/01tek4f86', 'hu', 1, 'https://ror.org/01tek4f86 Bács-Kiskun Megyei Kórház'),
(1542, 'https://ror.org/01thzqc78', 'pt', 1, 'https://ror.org/01thzqc78 Universidade Sagrado Coração'),
(1543, 'https://ror.org/01tj58m37', 'en', 1, 'https://ror.org/01tj58m37 Montana State University Billings'),
(1544, 'https://ror.org/01tqqny90', 'en', 1, 'https://ror.org/01tqqny90 Nagasaki International University 長崎国際大学'),
(1545, 'https://ror.org/01ttqjq76', 'en', 1, 'https://ror.org/01ttqjq76 North Wales Hospital'),
(1546, 'https://ror.org/01v00e311', 'en', 1, 'https://ror.org/01v00e311 Hayashi Eye Hospital'),
(1547, 'https://ror.org/01v0xk274', 'pt', 1, 'https://ror.org/01v0xk274 Universidade Ibirapuera'),
(1548, 'https://ror.org/01v13p275', 'en', 1, 'https://ror.org/01v13p275 Watford General Hospital'),
(1549, 'https://ror.org/01v16x378', 'en', 1, 'https://ror.org/01v16x378 Command Hospital'),
(1550, 'https://ror.org/01v27vf29', 'en', 1, 'https://ror.org/01v27vf29 Children''s Medical Center'),
(1551, 'https://ror.org/01v49sd11', 'en', 1, 'https://ror.org/01v49sd11 Saint Louis University Hospital'),
(1552, 'https://ror.org/01v5y3463', 'en', 1, 'https://ror.org/01v5y3463 Autonomous University of Campeche Universidad Autónoma de Campeche'),
(1553, 'https://ror.org/01v62m802', 'en', 1, 'https://ror.org/01v62m802 Siena College'),
(1554, 'https://ror.org/01v6gr187', 'no_lang_code', 1, 'https://ror.org/01v6gr187 Semex'),
(1555, 'https://ror.org/01v7y5b55', 'en', 1, 'https://ror.org/01v7y5b55 Korea Maritime and Ocean University 한국해양대학교'),
(1556, 'https://ror.org/01v8mb410', 'en', 1, 'https://ror.org/01v8mb410 National Sanyo Hospital 国立病院機構山口宇部医療センター'),
(1557, 'https://ror.org/01v95tx09', 'en', 1, 'https://ror.org/01v95tx09 Shriners Hospitals for Children - Galveston'),
(1558, 'https://ror.org/01v9g9c07', 'en', 1, 'https://ror.org/01v9g9c07 Mie University Hospital 三重大学病院'),
(1559, 'https://ror.org/01va7e105', 'en', 1, 'https://ror.org/01va7e105 Ibis Reproductive Health'),
(1560, 'https://ror.org/01vj9qy35', 'en', 1, 'https://ror.org/01vj9qy35 Christian Medical College'),
(1561, 'https://ror.org/01vjd7j86', 'en', 1, 'https://ror.org/01vjd7j86 Federalni Zavod za geologiju The Federal Institute for Geology'),
(1562, 'https://ror.org/01vjtf564', 'en', 1, 'https://ror.org/01vjtf564 Rabin Medical Center'),
(1563, 'https://ror.org/01vk45p32', 'en', 1, 'https://ror.org/01vk45p32 Eiju General Hospital 永寿総合病院'),
(1564, 'https://ror.org/01vka3a64', 'en', 1, 'https://ror.org/01vka3a64 CARE Hospitals'),
(1565, 'https://ror.org/01vqqz948', 'fr', 1, 'https://ror.org/01vqqz948 Hopital Universitaire Hedi Chaker المستشفى الجامعي بصفاقس'),
(1566, 'https://ror.org/01vr7z878', 'en', 1, 'https://ror.org/01vr7z878 Khyber Medical College'),
(1567, 'https://ror.org/01vtn3k88', 'es', 1, 'https://ror.org/01vtn3k88 Hospital Pablo Tobon Uribe'),
(1568, 'https://ror.org/01vv03303', 'en', 1, 'https://ror.org/01vv03303 King Abdul Aziz University Hospital'),
(1569, 'https://ror.org/01vx7zt03', 'en', 1, 'https://ror.org/01vx7zt03 Addington Hospital'),
(1570, 'https://ror.org/01vzp6a32', 'en', 1, 'https://ror.org/01vzp6a32 Korle Bu Teaching Hospital'),
(1571, 'https://ror.org/01w0d5g70', 'en', 1, 'https://ror.org/01w0d5g70 University of Missouri–Kansas City'),
(1572, 'https://ror.org/01w1pbe36', 'en', 1, 'https://ror.org/01w1pbe36 University of Maryland Global Campus'),
(1573, 'https://ror.org/01w3ec513', 'en', 1, 'https://ror.org/01w3ec513 Arnot Ogden Medical Center'),
(1574, 'https://ror.org/01w3xx622', 'en', 1, 'https://ror.org/01w3xx622 Lanzhou Army General Hospital 陆军总院'),
(1575, 'https://ror.org/01w502745', 'nl', 1, 'https://ror.org/01w502745 Slotervaartziekenhuis'),
(1576, 'https://ror.org/01w5s1t11', 'en', 1, 'https://ror.org/01w5s1t11 Buffalo Medical Group'),
(1577, 'https://ror.org/01w62yz22', 'en', 1, 'https://ror.org/01w62yz22 Advanced Institute of Convergence Technology 차세대융합기술연구원'),
(1578, 'https://ror.org/01w6vdf77', 'en', 1, 'https://ror.org/01w6vdf77 Gorgan University of Agricultural Sciences and Natural Resources دانشگاه علوم کشاورزی و منابع طبیعی گرگان'),
(1579, 'https://ror.org/01w6wtk13', 'en', 1, 'https://ror.org/01w6wtk13 Shizuoka University 静岡大学'),
(1580, 'https://ror.org/01w756144', 'en', 1, 'https://ror.org/01w756144 Meriter Hospital'),
(1581, 'https://ror.org/01w8whh21', 'en', 1, 'https://ror.org/01w8whh21 University of Oklahoma Medical Center'),
(1582, 'https://ror.org/01wc5x922', 'en', 1, 'https://ror.org/01wc5x922 Providence Sacred Heart Medical Center'),
(1583, 'https://ror.org/01wcey047', 'en', 1, 'https://ror.org/01wcey047 Joseph Eye Hospital'),
(1584, 'https://ror.org/01wdckv42', 'en', 1, 'https://ror.org/01wdckv42 Bayfront Medical Center'),
(1585, 'https://ror.org/01wddqe20', 'en', 1, 'https://ror.org/01wddqe20 The Alfred Hospital'),
(1586, 'https://ror.org/01wf0xv67', 'en', 1, 'https://ror.org/01wf0xv67 Eastern Command Hospital'),
(1587, 'https://ror.org/01wgych27', 'en', 1, 'https://ror.org/01wgych27 Kaiser Permanente Riverside Medical Center'),
(1588, 'https://ror.org/01whq8m38', 'en', 1, 'https://ror.org/01whq8m38 Mokwon University 목원대학교'),
(1589, 'https://ror.org/01wjz9118', 'en', 1, 'https://ror.org/01wjz9118 Nizam''s Institute of Medical Sciences'),
(1590, 'https://ror.org/01wmj1g45', 'en', 1, 'https://ror.org/01wmj1g45 Atlanta University Center'),
(1591, 'https://ror.org/01wpkc438', 'en', 1, 'https://ror.org/01wpkc438 Canadian Foundation For The International Space University'),
(1592, 'https://ror.org/01wpqwr25', 'en', 1, 'https://ror.org/01wpqwr25 Lemuel Shattuck Hospital'),
(1593, 'https://ror.org/01wqrpc44', 'en', 1, 'https://ror.org/01wqrpc44 Kyushu Sangyo University 九州産業大学'),
(1594, 'https://ror.org/01wrc0z23', 'en', 1, 'https://ror.org/01wrc0z23 Jersey City Medical Center'),
(1595, 'https://ror.org/01wv1aw46', 'en', 1, 'https://ror.org/01wv1aw46 BongSeng Memorial Hospital 봉생병원입니다'),
(1596, 'https://ror.org/01wx86652', 'en', 1, 'https://ror.org/01wx86652 Astley Ainslie Hospital'),
(1597, 'https://ror.org/01wxb8362', 'en', 1, 'https://ror.org/01wxb8362 Maria Cecilia Hospital'),
(1598, 'https://ror.org/01wxddc07', 'en', 1, 'https://ror.org/01wxddc07 Katsushika Medical Center 葛飾医療センタ'),
(1599, 'https://ror.org/01wxzd328', 'no_lang_code', 1, 'https://ror.org/01wxzd328 Kunitachi Sakura Hospital 国立さくら病院'),
(1600, 'https://ror.org/01x21tj82', 'no_lang_code', 1, 'https://ror.org/01x21tj82 Microsoft (Netherlands)'),
(1601, 'https://ror.org/01x2t4526', 'en', 1, 'https://ror.org/01x2t4526 Lee Memorial Health System'),
(1602, 'https://ror.org/01x37cs02', 'en', 1, 'https://ror.org/01x37cs02 West Cumberland Hospital'),
(1603, 'https://ror.org/01x3f1613', 'en', 1, 'https://ror.org/01x3f1613 Driscoll Children''s Hospital'),
(1604, 'https://ror.org/01x3jjv63', 'en', 1, 'https://ror.org/01x3jjv63 Uzhhorod National University Użhorodzki Uniwersytet Narodowy Ужгородский национальный университет Ужгородський національний університет'),
(1605, 'https://ror.org/01x5yfk91', 'en', 1, 'https://ror.org/01x5yfk91 HealthONE Spalding Rehabilitation Hospital'),
(1606, 'https://ror.org/01x62kg38', 'en', 1, 'https://ror.org/01x62kg38 Tianjin People''s Hospital 天津市人民医院'),
(1607, 'https://ror.org/01x66cn47', 'it', 1, 'https://ror.org/01x66cn47 Ospedale di Santa Maria dei Battuti'),
(1608, 'https://ror.org/01x69an44', 'en', 1, 'https://ror.org/01x69an44 Children''s & Women''s Health Centre of British Columbia'),
(1609, 'https://ror.org/01x8bpc61', 'en', 1, 'https://ror.org/01x8bpc61 Saint Elizabeth Regional Medical Center'),
(1610, 'https://ror.org/01x8yyz38', 'en', 1, 'https://ror.org/01x8yyz38 Etelä-Karjalan keskussairaala South Karelia Central Hospital'),
(1611, 'https://ror.org/01x9g5g52', 'no_lang_code', 1, 'https://ror.org/01x9g5g52 Ension'),
(1612, 'https://ror.org/01xapny78', 'en', 1, 'https://ror.org/01xapny78 Cabrini Medical Center'),
(1613, 'https://ror.org/01xar8k65', 'en', 1, 'https://ror.org/01xar8k65 Flower Hospital'),
(1614, 'https://ror.org/01xb3t395', 'en', 1, 'https://ror.org/01xb3t395 Summa Akron City Hospital'),
(1615, 'https://ror.org/01xd2tj29', 'no_lang_code', 1, 'https://ror.org/01xd2tj29 Weifang People''s Hospital 潍坊市人民医院'),
(1616, 'https://ror.org/01xd4z152', 'en', 1, 'https://ror.org/01xd4z152 Southwest Washington Medical Center'),
(1617, 'https://ror.org/01xdjhe59', 'en', 1, 'https://ror.org/01xdjhe59 Iwata City Hospital 磐田市立総合病院'),
(1618, 'https://ror.org/01xereq81', 'en', 1, 'https://ror.org/01xereq81 Jamaica Hospital'),
(1619, 'https://ror.org/01xf83457', 'it', 1, 'https://ror.org/01xf83457 Azienda Ospedaliera San Gerardo'),
(1620, 'https://ror.org/01xfgtq85', 'en', 1, 'https://ror.org/01xfgtq85 VA West Los Angeles Medical Center'),
(1621, 'https://ror.org/01xg9pd38', 'en', 1, 'https://ror.org/01xg9pd38 Fitzgerald Health Education Associates'),
(1622, 'https://ror.org/01xhmje49', 'en', 1, 'https://ror.org/01xhmje49 Birmingham Dental Hospital'),
(1623, 'https://ror.org/01xjqrm90', 'en', 1, 'https://ror.org/01xjqrm90 Umm al-Qura University جامعة أم القرى'),
(1624, 'https://ror.org/01xkmcr24', 'de', 1, 'https://ror.org/01xkmcr24 Universitäts-Augenklinik Bonn'),
(1625, 'https://ror.org/01xkzjp97', 'en', 1, 'https://ror.org/01xkzjp97 Health Promotion Board 新加坡保健促进局'),
(1626, 'https://ror.org/01xm3qq33', 'de', 1, 'https://ror.org/01xm3qq33 Schulthess-Klinik'),
(1627, 'https://ror.org/01xm4tt59', 'en', 1, 'https://ror.org/01xm4tt59 Woodruff Health Sciences Center'),
(1628, 'https://ror.org/01xn4ac42', 'en', 1, 'https://ror.org/01xn4ac42 Brandon Regional Health Authority'),
(1629, 'https://ror.org/01xngwb59', 'en', 1, 'https://ror.org/01xngwb59 Fortis Escorts Hospital'),
(1630, 'https://ror.org/01xnhkz22', 'en', 1, 'https://ror.org/01xnhkz22 Scarborough General Hospital'),
(1631, 'https://ror.org/01xnwqx93', 'en', 1, 'https://ror.org/01xnwqx93 University Hospital Bonn Universitätsklinikum Bonn'),
(1632, 'https://ror.org/01xq02v66', 'en', 1, 'https://ror.org/01xq02v66 Hasbro Children''s Hospital'),
(1633, 'https://ror.org/01xqed412', 'en', 1, 'https://ror.org/01xqed412 Haywood Community Hospital'),
(1634, 'https://ror.org/01xrazc29', 'en', 1, 'https://ror.org/01xrazc29 Jaipur National University'),
(1635, 'https://ror.org/01xrnpj63', 'no_lang_code', 1, 'https://ror.org/01xrnpj63 Sahara Hospital'),
(1636, 'https://ror.org/01xrsrd14', 'en', 1, 'https://ror.org/01xrsrd14 Meenakshi Mission Hospital and Research Centre'),
(1637, 'https://ror.org/01xtjs520', 'fr', 1, 'https://ror.org/01xtjs520 Institut Laue-Langevin'),
(1638, 'https://ror.org/01xtpc441', 'en', 1, 'https://ror.org/01xtpc441 Northport VA Medical Center'),
(1639, 'https://ror.org/01xv1nn60', 'en', 1, 'https://ror.org/01xv1nn60 Taibah University جامعة طيبة'),
(1640, 'https://ror.org/01xvcf081', 'en', 1, 'https://ror.org/01xvcf081 New York Blood Center'),
(1641, 'https://ror.org/01xxd6b82', 'en', 1, 'https://ror.org/01xxd6b82 Kosair Children''s Hospital'),
(1642, 'https://ror.org/01y3zfr79', 'en', 1, 'https://ror.org/01y3zfr79 National Institute of Nursing Research'),
(1643, 'https://ror.org/01y4xm534', 'en', 1, 'https://ror.org/01y4xm534 Islamic Azad University, Karaj, Karaj Islamic Azad University دانشگاه آزاد اسلامی واحد کرج'),
(1644, 'https://ror.org/01y8xtk20', 'en', 1, 'https://ror.org/01y8xtk20 Southwestern Oklahoma State University'),
(1645, 'https://ror.org/01y8zn427', 'en', 1, 'https://ror.org/01y8zn427 Chittagong Medical College চট্টগ্রাম মেডিকেল কলেজ'),
(1646, 'https://ror.org/01y946378', 'en', 1, 'https://ror.org/01y946378 Hospital Umum Sarawak Sarawak General Hospital'),
(1647, 'https://ror.org/01yav5t22', 'en', 1, 'https://ror.org/01yav5t22 Conference Board Math Sciences'),
(1648, 'https://ror.org/01ybfxd46', 'en', 1, 'https://ror.org/01ybfxd46 University Hospital Complex Of Vigo'),
(1649, 'https://ror.org/01ybj8n97', 'en', 1, 'https://ror.org/01ybj8n97 Dundee Dental Hospital'),
(1650, 'https://ror.org/01ycr6b80', 'en', 1, 'https://ror.org/01ycr6b80 Royal Liverpool University Hospital'),
(1651, 'https://ror.org/01yedz573', 'en', 1, 'https://ror.org/01yedz573 Kunming General Hospital of Chengdu Military Command 成都军区昆明总医院'),
(1652, 'https://ror.org/01yft1b10', 'en', 1, 'https://ror.org/01yft1b10 Catalyst Health Economics Consultants Ltd'),
(1653, 'https://ror.org/01yhc9w15', 'en', 1, 'https://ror.org/01yhc9w15 Sherman Hospital'),
(1654, 'https://ror.org/01yjyvb35', 'en', 1, 'https://ror.org/01yjyvb35 Bemidji State University'),
(1655, 'https://ror.org/01ym47j46', 'en', 1, 'https://ror.org/01ym47j46 Fulbourn Hospital'),
(1656, 'https://ror.org/01yn60017', 'en', 1, 'https://ror.org/01yn60017 Waukesha Memorial Hospital'),
(1657, 'https://ror.org/01yp8kc21', 'es', 1, 'https://ror.org/01yp8kc21 Hospital San Pedro de Alcántara'),
(1658, 'https://ror.org/01ypwfg63', 'no_lang_code', 1, 'https://ror.org/01ypwfg63 Ecofys (Netherlands)'),
(1659, 'https://ror.org/01yqewm58', 'en', 1, 'https://ror.org/01yqewm58 Kuban State University Кубанский государственный университет'),
(1660, 'https://ror.org/01ysgtb61', 'en', 1, 'https://ror.org/01ysgtb61 Baqiyatallah University of Medical Sciences دانشگاه علوم پزشکی بقیةالله'),
(1661, 'https://ror.org/01yth7f19', 'no_lang_code', 1, 'https://ror.org/01yth7f19 Kudanzaka Hospital 九段坂病院'),
(1662, 'https://ror.org/01yvj7247', 'en', 1, 'https://ror.org/01yvj7247 Bnai Zion Medical Center מרכז רפואי בני ציון'),
(1663, 'https://ror.org/01ywpxj09', 'en', 1, 'https://ror.org/01ywpxj09 Queen Victoria Hospital'),
(1664, 'https://ror.org/01yytng49', 'en', 1, 'https://ror.org/01yytng49 Kanagawa Rehabilitation Hospital 神奈川リハビリテーション病院'),
(1665, 'https://ror.org/01yyxv878', 'en', 1, 'https://ror.org/01yyxv878 Wingate University'),
(1666, 'https://ror.org/01yzgg311', 'es', 1, 'https://ror.org/01yzgg311 Hospital Central de la Cruz Roja San José y Santa Adela'),
(1667, 'https://ror.org/01yzz0f51', 'en', 1, 'https://ror.org/01yzz0f51 Chung Hua University'),
(1668, 'https://ror.org/01z07eq06', 'en', 1, 'https://ror.org/01z07eq06 Hubei Polytechnic University 湖北理工学院'),
(1669, 'https://ror.org/01z1dtf94', 'en', 1, 'https://ror.org/01z1dtf94 Shriners Hospitals for Children - Canada'),
(1670, 'https://ror.org/01z3j3n30', 'en', 1, 'https://ror.org/01z3j3n30 Schneider Children''s Medical Center'),
(1671, 'https://ror.org/01z719741', 'en', 1, 'https://ror.org/01z719741 Scripps Clinic Medical Group'),
(1672, 'https://ror.org/01z7mq587', 'tr', 1, 'https://ror.org/01z7mq587 Diyarbakır Askeri Hastanesi'),
(1673, 'https://ror.org/01z83rb65', 'fr', 1, 'https://ror.org/01z83rb65 Adi Valor'),
(1674, 'https://ror.org/01z8t1s57', 'en', 1, 'https://ror.org/01z8t1s57 International Center for Public Health'),
(1675, 'https://ror.org/01z9vrt66', 'en', 1, 'https://ror.org/01z9vrt66 Okazaki City Hospital 岡崎市民病院'),
(1676, 'https://ror.org/01za8fg18', 'en', 1, 'https://ror.org/01za8fg18 Lagos State University Yunifásítì Ìpínlẹ̀ Èkó'),
(1677, 'https://ror.org/01zbeej63', 'fi', 1, 'https://ror.org/01zbeej63 Keski-Satakunnan Terveydenhuollon kuntayhtymä'),
(1678, 'https://ror.org/01zbhpb91', 'en', 1, 'https://ror.org/01zbhpb91 Meenakshi Ammal Dental College and Hospital'),
(1679, 'https://ror.org/01zbzxe52', 'en', 1, 'https://ror.org/01zbzxe52 Royal South Hants Hospital'),
(1680, 'https://ror.org/01zc7k534', 'no_lang_code', 1, 'https://ror.org/01zc7k534 Koga Hospital 古賀病院'),
(1681, 'https://ror.org/01zd7yk57', 'en', 1, 'https://ror.org/01zd7yk57 Louisville VA Medical Center'),
(1682, 'https://ror.org/01zdmh905', 'en', 1, 'https://ror.org/01zdmh905 Office of the Chief Medical Examiner'),
(1683, 'https://ror.org/01zjsmf32', 'en', 1, 'https://ror.org/01zjsmf32 Government Rajaji Hospital'),
(1684, 'https://ror.org/01zjvhn75', 'en', 1, 'https://ror.org/01zjvhn75 National Taiwan Sport University'),
(1685, 'https://ror.org/01zkyz108', 'en', 1, 'https://ror.org/01zkyz108 Hospital Monte Sinaí Mount Sinai Hospital'),
(1686, 'https://ror.org/01zmw6f28', 'it', 1, 'https://ror.org/01zmw6f28 Ospedale Santa Maria Annunziata'),
(1687, 'https://ror.org/01znbfh26', 'fi', 1, 'https://ror.org/01znbfh26 Forssan Seudun Terveydenhuollon Kuntayhtymä'),
(1688, 'https://ror.org/01zp13r18', 'en', 1, 'https://ror.org/01zp13r18 Research Medical Center'),
(1689, 'https://ror.org/01zqccq48', 'en', 1, 'https://ror.org/01zqccq48 Daegu University 대구대학교'),
(1690, 'https://ror.org/01zqztb27', 'no_lang_code', 1, 'https://ror.org/01zqztb27 Caritas Medical Centre 明愛醫院'),
(1691, 'https://ror.org/01zr6qe45', 'en', 1, 'https://ror.org/01zr6qe45 Colorado Center For Hospice and Palliative Care'),
(1692, 'https://ror.org/01zvqw119', 'en', 1, 'https://ror.org/01zvqw119 Auckland University of Technology'),
(1693, 'https://ror.org/01zx16v02', 'en', 1, 'https://ror.org/01zx16v02 Athens State University Université d''État d''athens'),
(1694, 'https://ror.org/01zxdeg39', 'en', 1, 'https://ror.org/01zxdeg39 Harvard Pilgrim Health Care'),
(1695, 'https://ror.org/01zy11s57', 'en', 1, 'https://ror.org/01zy11s57 North Tyneside General Hospital'),
(1696, 'https://ror.org/01zy69h55', 'en', 1, 'https://ror.org/01zy69h55 401 General Military Hospital of Athens 401 Γενικό Στρατιωτικό Νοσοκομείο Αθηνών'),
(1697, 'https://ror.org/01zyevp23', 'en', 1, 'https://ror.org/01zyevp23 Musgrave Park Hospital'),
(1698, 'https://ror.org/020268t49', 'de', 1, 'https://ror.org/020268t49 Papiertechnische Stiftung'),
(1699, 'https://ror.org/0202bpc71', 'tr', 1, 'https://ror.org/0202bpc71 Türkiye Cumhuriyeti Devlet Demiryolları Hastanesi'),
(1700, 'https://ror.org/0203evn05', 'en', 1, 'https://ror.org/0203evn05 Federation of American Hospitals'),
(1701, 'https://ror.org/0204pdj19', 'en', 1, 'https://ror.org/0204pdj19 Institute For European Environmental Policy'),
(1702, 'https://ror.org/0209dk158', 'en', 1, 'https://ror.org/0209dk158 Lowell Observatory'),
(1703, 'https://ror.org/020afzk37', 'no_lang_code', 1, 'https://ror.org/020afzk37 Mirus Bio (United States)'),
(1704, 'https://ror.org/020b6jb08', 'en', 1, 'https://ror.org/020b6jb08 Canadian Mathematical Society'),
(1705, 'https://ror.org/020cmsc29', 'en', 1, 'https://ror.org/020cmsc29 Rajendra Memorial Research Institute of Medical Sciences'),
(1706, 'https://ror.org/020hchp05', 'en', 1, 'https://ror.org/020hchp05 Integrated Laboratory Systems, Inc.'),
(1707, 'https://ror.org/020jbrt22', 'en', 1, 'https://ror.org/020jbrt22 Tbilisi State Medical University Թբիլիսիի պետական բժշկական համալսարան თბილისის სახელმწიფო სამედიცინო უნივერსიტეტი'),
(1708, 'https://ror.org/020jkns84', 'en', 1, 'https://ror.org/020jkns84 Foundation University Medical College'),
(1709, 'https://ror.org/020k76687', 'no_lang_code', 1, 'https://ror.org/020k76687 Autonomous Operator of Parisian Transports Régie Autonome des Transports Parisiens (France)'),
(1710, 'https://ror.org/020k7fn51', 'no_lang_code', 1, 'https://ror.org/020k7fn51 Information Management Services'),
(1711, 'https://ror.org/020m4km16', 'en', 1, 'https://ror.org/020m4km16 Bexar County Medical Examiner''s Office'),
(1712, 'https://ror.org/020nckd56', 'pt', 1, 'https://ror.org/020nckd56 Instituto Superior de Ciências da Administração'),
(1713, 'https://ror.org/020qgp237', 'no_lang_code', 1, 'https://ror.org/020qgp237 DuPont (Canada)');
INSERT INTO `rors` VALUES
(1714, 'https://ror.org/020rayx20', 'tr', 1, 'https://ror.org/020rayx20 Konya Eğitim ve Araştırma Hastanesi'),
(1715, 'https://ror.org/020rmtx45', 'no_lang_code', 1, 'https://ror.org/020rmtx45 Envirogen (United States)'),
(1716, 'https://ror.org/020rvjj03', 'en', 1, 'https://ror.org/020rvjj03 Satakunta Central Hospital'),
(1717, 'https://ror.org/020rzx487', 'en', 1, 'https://ror.org/020rzx487 Sheba Medical Center'),
(1718, 'https://ror.org/020sa1s57', 'en', 1, 'https://ror.org/020sa1s57 Aomori University of Health and Welfare 青森県立保健大学'),
(1719, 'https://ror.org/020vmqv16', 'en', 1, 'https://ror.org/020vmqv16 Roosevelt University'),
(1720, 'https://ror.org/020wf1g18', 'en', 1, 'https://ror.org/020wf1g18 Huron Hospital'),
(1721, 'https://ror.org/0213f0637', 'it', 1, 'https://ror.org/0213f0637 Azienda Ospedaliero Universitaria Ospedali Riuniti'),
(1722, 'https://ror.org/0217hb928', 'en', 1, 'https://ror.org/0217hb928 Middlebury College'),
(1723, 'https://ror.org/02182hd81', 'pt', 1, 'https://ror.org/02182hd81 Escola do Serviço de Saúde Militar'),
(1724, 'https://ror.org/021959v84', 'fr', 1, 'https://ror.org/021959v84 Hôpital Saint-André'),
(1725, 'https://ror.org/0219djn76', 'en', 1, 'https://ror.org/0219djn76 Rush Children''s Hospital'),
(1726, 'https://ror.org/0219m2k96', 'en', 1, 'https://ror.org/0219m2k96 Decision Research'),
(1727, 'https://ror.org/021a7pw18', 'en', 1, 'https://ror.org/021a7pw18 New York City College of Technology'),
(1728, 'https://ror.org/021aj5d10', 'en', 1, 'https://ror.org/021aj5d10 Dr. R. Ahmed Dental College and Hospital ডাঃ আর আহমেদ ডেন্টাল কলেজ ও হাসপাতাল'),
(1729, 'https://ror.org/021bj7008', 'no_lang_code', 1, 'https://ror.org/021bj7008 Meitetsu Hospital 名鉄病院'),
(1730, 'https://ror.org/021ctjg87', 'en', 1, 'https://ror.org/021ctjg87 Northern Territory Health Services'),
(1731, 'https://ror.org/021dmtc66', 'en', 1, 'https://ror.org/021dmtc66 Regional Hospital Horsens Regionshospitalet Horsens'),
(1732, 'https://ror.org/021e5j056', 'en', 1, 'https://ror.org/021e5j056 Kuwait University جامعة الكويت'),
(1733, 'https://ror.org/021f4qx93', 'en', 1, 'https://ror.org/021f4qx93 Noto General Hospital 公立能登総合病院'),
(1734, 'https://ror.org/021jxzw96', 'it', 1, 'https://ror.org/021jxzw96 Azienda Ospedaliera S.Giuseppe Moscati'),
(1735, 'https://ror.org/021m54z79', 'no_lang_code', 1, 'https://ror.org/021m54z79 Takara (Japan) 宝ホールディングス株式会社'),
(1736, 'https://ror.org/021nb2v44', 'en', 1, 'https://ror.org/021nb2v44 Medical College and Hospital, Kolkata कलकत्ता मेडिकल कॉलेज কলকাতা মেডিক্যাল কলেজ ও হাসপাতাল'),
(1737, 'https://ror.org/021rths28', 'en', 1, 'https://ror.org/021rths28 National Center for Chronic Disease Prevention and Health Promotion'),
(1738, 'https://ror.org/021rvrs67', 'ca', 1, 'https://ror.org/021rvrs67 Hospital Sant Pau i Santa Tecla'),
(1739, 'https://ror.org/021wsw395', 'fr', 1, 'https://ror.org/021wsw395 Hôpital Fontmaure'),
(1740, 'https://ror.org/021wvan87', 'no_lang_code', 1, 'https://ror.org/021wvan87 Qi2'),
(1741, 'https://ror.org/021x6km63', 'en', 1, 'https://ror.org/021x6km63 Kirwan Health Campus'),
(1742, 'https://ror.org/021zm6p18', 'en', 1, 'https://ror.org/021zm6p18 Norfolk and Norwich University Hospital'),
(1743, 'https://ror.org/022261z88', 'en', 1, 'https://ror.org/022261z88 Evans Army Community Hospital'),
(1744, 'https://ror.org/022296476', 'en', 1, 'https://ror.org/022296476 National Kyushu Medical Center 国立病院機構 九州医療センター'),
(1745, 'https://ror.org/0222am037', 'it', 1, 'https://ror.org/0222am037 Ospedaliero Sirai'),
(1746, 'https://ror.org/0222df516', 'en', 1, 'https://ror.org/0222df516 Probity Medical Research'),
(1747, 'https://ror.org/0222p1e69', 'en', 1, 'https://ror.org/0222p1e69 Eugene Applebaum College of Pharmacy and Health Sciences'),
(1748, 'https://ror.org/0223apb60', 'en', 1, 'https://ror.org/0223apb60 Mahatma Gandhi Memorial Medical College'),
(1749, 'https://ror.org/0226ax553', 'en', 1, 'https://ror.org/0226ax553 St. Mary''s Medical Center'),
(1750, 'https://ror.org/0226env10', 'no_lang_code', 1, 'https://ror.org/0226env10 Sociometrics Corporation'),
(1751, 'https://ror.org/0228w5t68', 'en', 1, 'https://ror.org/0228w5t68 KK Women''s and Children''s Hospital'),
(1752, 'https://ror.org/0229c7854', 'en', 1, 'https://ror.org/0229c7854 Massachusetts Mental Health Center'),
(1753, 'https://ror.org/022a11m05', 'no_lang_code', 1, 'https://ror.org/022a11m05 Iwaki Kyoritsu General Hospital いわき共立総合病院'),
(1754, 'https://ror.org/022arq532', 'en', 1, 'https://ror.org/022arq532 Prince of Wales Hospital'),
(1755, 'https://ror.org/022ctzz37', 'no_lang_code', 1, 'https://ror.org/022ctzz37 Ohtsuka Eye Hospital 大塚眼科病院'),
(1756, 'https://ror.org/022d5qt08', 'de', 1, 'https://ror.org/022d5qt08 Bundesforschungsinstitut für Kulturpflanzen, Julius Kühn-Institut Federal Research Centre for Cultivated Plants'),
(1757, 'https://ror.org/022ekqa73', 'en', 1, 'https://ror.org/022ekqa73 National Animal Husbandry Service 全国畜牧总站'),
(1758, 'https://ror.org/022em3k58', 'en', 1, 'https://ror.org/022em3k58 De Duve Instituut L''Institut de Duve de Duve Institute'),
(1759, 'https://ror.org/022gnbj15', 'en', 1, 'https://ror.org/022gnbj15 Louisiana State University System'),
(1760, 'https://ror.org/022h0tq76', 'en', 1, 'https://ror.org/022h0tq76 Kanagawa Children''s Medical Center 神奈川県立こども医療センター'),
(1761, 'https://ror.org/022j3nr24', 'en', 1, 'https://ror.org/022j3nr24 Hospital central de Kamuzu Kamuzu Central Hospital'),
(1762, 'https://ror.org/022jeg055', 'en', 1, 'https://ror.org/022jeg055 Dallas Diabetes Research Center'),
(1763, 'https://ror.org/022k36x48', 'no_lang_code', 1, 'https://ror.org/022k36x48 Taylor Wimpey (United Kingdom)'),
(1764, 'https://ror.org/022k8bt28', 'en', 1, 'https://ror.org/022k8bt28 Nishi Eye Hospital 西眼科病院'),
(1765, 'https://ror.org/022mjvt30', 'en', 1, 'https://ror.org/022mjvt30 Japanese Red Cross Fukuoka Hospital 福岡赤十字病院'),
(1766, 'https://ror.org/022qy2d08', 'en', 1, 'https://ror.org/022qy2d08 Brenau University'),
(1767, 'https://ror.org/022rkxt86', 'no_lang_code', 1, 'https://ror.org/022rkxt86 Trojan Technologies (Canada)'),
(1768, 'https://ror.org/022swbj46', 'en', 1, 'https://ror.org/022swbj46 National Brain Research Centre राष्ट्रीय मस्तिष्क अनुसंधान केंद्र, मानेसर, हरियाणा'),
(1769, 'https://ror.org/022v32y85', 'en', 1, 'https://ror.org/022v32y85 Andreas Sygros Hospital Ανδρέας Συγγρός Νοσοκομείο'),
(1770, 'https://ror.org/022vd9g66', 'fr', 1, 'https://ror.org/022vd9g66 Hôpital Orthopédique de la Suisse Romande'),
(1771, 'https://ror.org/022wqqf69', 'es', 1, 'https://ror.org/022wqqf69 Centre for Technical Research and Studies Centro de Estudios e Investigaciones Técnicas de Gipuzkoa'),
(1772, 'https://ror.org/022xmez67', 'no_lang_code', 1, 'https://ror.org/022xmez67 Microbiotix (United States)'),
(1773, 'https://ror.org/022yckc24', 'pt', 1, 'https://ror.org/022yckc24 Hospital Universitário Evangélico de Curitiba'),
(1774, 'https://ror.org/022yvqh08', 'en', 1, 'https://ror.org/022yvqh08 University College Hospital, Ibadan'),
(1775, 'https://ror.org/0230h1q47', 'en', 1, 'https://ror.org/0230h1q47 King Fahd Hospital of the University مستشفى جامعة الملك فيصل'),
(1776, 'https://ror.org/0231d2y50', 'en', 1, 'https://ror.org/0231d2y50 Lenox Hill Hospital'),
(1777, 'https://ror.org/0231m7n15', 'en', 1, 'https://ror.org/0231m7n15 Lake Regional Hospital'),
(1778, 'https://ror.org/023733d09', 'es', 1, 'https://ror.org/023733d09 Hospital de l''Esperança'),
(1779, 'https://ror.org/02378jc90', 'en', 1, 'https://ror.org/02378jc90 Raja Ramanna Centre for Advanced Technology राजा रामण्णा अत्याधुनिक तंत्रज्ञान केंद्र राजा रामन्ना प्रगत प्रौद्योगिकी केन्द्र രാജാ രാമണ്ണ സെന്റർ ഫോർ അഡ്വാൻസ്ഡ് ടെക്നോളജി'),
(1780, 'https://ror.org/0238gtq84', 'en', 1, 'https://ror.org/0238gtq84 Rajavithi Hospital'),
(1781, 'https://ror.org/0238gz740', 'en', 1, 'https://ror.org/0238gz740 Institute for Theoretical and Experimental Physics Институт теоретической и экспериментальной физики'),
(1782, 'https://ror.org/023bq8521', 'en', 1, 'https://ror.org/023bq8521 Saint Petersburg State Electrotechnical University Санкт-Петербургский государственный электротехнический университет'),
(1783, 'https://ror.org/023cara48', 'en', 1, 'https://ror.org/023cara48 Center for Epidemiology and Animal Health'),
(1784, 'https://ror.org/023cbtv31', 'en', 1, 'https://ror.org/023cbtv31 Madrid Health Service Servicio Madrileño de Salud'),
(1785, 'https://ror.org/023cpc062', 'no_lang_code', 1, 'https://ror.org/023cpc062 DNA Link (South Korea)'),
(1786, 'https://ror.org/023dma244', 'en', 1, 'https://ror.org/023dma244 Colchester Hospital'),
(1787, 'https://ror.org/023dwm995', 'en', 1, 'https://ror.org/023dwm995 St. Thomas Hospital'),
(1788, 'https://ror.org/023fgmp71', 'en', 1, 'https://ror.org/023fgmp71 East Georgia State College'),
(1789, 'https://ror.org/023gt0394', 'en', 1, 'https://ror.org/023gt0394 St Richard''s Hospital'),
(1790, 'https://ror.org/023hj8v22', 'en', 1, 'https://ror.org/023hj8v22 Memorial Hospital'),
(1791, 'https://ror.org/023kfg220', 'en', 1, 'https://ror.org/023kfg220 National Institute for Agro-Environmental Sciences 農業環境変動研究センター'),
(1792, 'https://ror.org/023m35461', 'en', 1, 'https://ror.org/023m35461 Istanbul Bilim University İstanbul Bilim Üniversitesi'),
(1793, 'https://ror.org/023pqj155', 'es', 1, 'https://ror.org/023pqj155 Hospital Santiago Apostol'),
(1794, 'https://ror.org/023q4bk22', 'en', 1, 'https://ror.org/023q4bk22 Central Queensland University'),
(1795, 'https://ror.org/023r6xh67', 'en', 1, 'https://ror.org/023r6xh67 Ignatius Hospital Sint Ignatiusziekenhuis'),
(1796, 'https://ror.org/023v4bd62', 'en', 1, 'https://ror.org/023v4bd62 National Agriculture and Food Research Organization 農業・食品産業技術総合研究機構'),
(1797, 'https://ror.org/023wdy559', 'tr', 1, 'https://ror.org/023wdy559 University of Health Sciences İstanbul Ümranyie Training and Research Hospital Ümraniye Eğitim ve Araştırma Hastanesi'),
(1798, 'https://ror.org/023wqmm33', 'en', 1, 'https://ror.org/023wqmm33 DeKalb Medical Center'),
(1799, 'https://ror.org/023z51242', 'en', 1, 'https://ror.org/023z51242 Enterprise Ireland'),
(1800, 'https://ror.org/023znxa73', 'en', 1, 'https://ror.org/023znxa73 St Petersburg University Санкт-Петербургский государственный университет'),
(1801, 'https://ror.org/02405mj67', 'en', 1, 'https://ror.org/02405mj67 Belfast City Hospital'),
(1802, 'https://ror.org/02408be69', 'en', 1, 'https://ror.org/02408be69 National Center of Hygiene Medical Ecology and Nutrition'),
(1803, 'https://ror.org/0240cjw65', 'fr', 1, 'https://ror.org/0240cjw65 Polyclinique de Bordeaux-Tondu'),
(1804, 'https://ror.org/0241b8f19', 'en', 1, 'https://ror.org/0241b8f19 Gomal University جامعہ گومل'),
(1805, 'https://ror.org/0241gfe92', 'en', 1, 'https://ror.org/0241gfe92 University of Minnesota, Waseca'),
(1806, 'https://ror.org/0242qs713', 'en', 1, 'https://ror.org/0242qs713 Birmingham VA Medical Center'),
(1807, 'https://ror.org/02436cs38', 'no_lang_code', 1, 'https://ror.org/02436cs38 Unilever (Netherlands)'),
(1808, 'https://ror.org/0243t3259', 'en', 1, 'https://ror.org/0243t3259 Militair Hospitaal Koningin Astrid Queen Astrid Military Hospital'),
(1809, 'https://ror.org/0249v7n71', 'en', 1, 'https://ror.org/0249v7n71 Institute for Computer Science and Control Magyar Tudományos Akadémia Számítástechnikai és Automatizálási Kutatóintézete'),
(1810, 'https://ror.org/024amfv85', 'en', 1, 'https://ror.org/024amfv85 Federal Agency for Health and Social Development Федеральное агентство по здравоохранению и социальному развитию'),
(1811, 'https://ror.org/024b7e967', 'en', 1, 'https://ror.org/024b7e967 Phoenix VA Health Care System'),
(1812, 'https://ror.org/024bsrp32', 'en', 1, 'https://ror.org/024bsrp32 Casa Colina Centers for Rehabilitation'),
(1813, 'https://ror.org/024c2fq17', 'en', 1, 'https://ror.org/024c2fq17 Sharif University of Technology دانشگاه صنعتی شریف'),
(1814, 'https://ror.org/024cn3w16', 'fr', 1, 'https://ror.org/024cn3w16 Centre Hospitalier Philippe Pinel'),
(1815, 'https://ror.org/024daed65', 'no_lang_code', 1, 'https://ror.org/024daed65 Social and Scientific Systems (United States)'),
(1816, 'https://ror.org/024esvk12', 'en', 1, 'https://ror.org/024esvk12 Saint Barnabas Medical Center'),
(1817, 'https://ror.org/024eyyq66', 'en', 1, 'https://ror.org/024eyyq66 Armed Forces Hospital'),
(1818, 'https://ror.org/024nkak84', 'en', 1, 'https://ror.org/024nkak84 Taiwan Adventist Hospital 台安医院'),
(1819, 'https://ror.org/024q5j973', 'en', 1, 'https://ror.org/024q5j973 Hacettepe University Hospital'),
(1820, 'https://ror.org/024ran220', 'en', 1, 'https://ror.org/024ran220 Kansai Rosai Hospital 関西ろうさい病院'),
(1821, 'https://ror.org/024xs2z82', 'no_lang_code', 1, 'https://ror.org/024xs2z82 ArcelorMittal (France)'),
(1822, 'https://ror.org/024xyyq03', 'en', 1, 'https://ror.org/024xyyq03 Nashville VA Medical Center'),
(1823, 'https://ror.org/024yc3q36', 'en', 1, 'https://ror.org/024yc3q36 Tottori University 鳥取大学'),
(1824, 'https://ror.org/024zq6d87', 'en', 1, 'https://ror.org/024zq6d87 Sisters of Mercy Health System'),
(1825, 'https://ror.org/025020z88', 'en', 1, 'https://ror.org/025020z88 Hunan Cancer Hospital'),
(1826, 'https://ror.org/0250jpt55', 'en', 1, 'https://ror.org/0250jpt55 Saurashtra University'),
(1827, 'https://ror.org/0252jr437', 'no_lang_code', 1, 'https://ror.org/0252jr437 Starks Associates'),
(1828, 'https://ror.org/02550n020', 'en', 1, 'https://ror.org/02550n020 European Synchrotron Radiation Facility'),
(1829, 'https://ror.org/02558wk32', 'en', 1, 'https://ror.org/02558wk32 Islamic Azad University, Arak دانشگاه آزاد اسلامی واحد اراک'),
(1830, 'https://ror.org/0255fcy13', 'en', 1, 'https://ror.org/0255fcy13 Warrington Hospital'),
(1831, 'https://ror.org/025714n80', 'es', 1, 'https://ror.org/025714n80 Hospital de Galdakao'),
(1832, 'https://ror.org/025821s54', 'en', 1, 'https://ror.org/025821s54 University Hospital Coventry'),
(1833, 'https://ror.org/0258b0610', 'en', 1, 'https://ror.org/0258b0610 Kansas Department of Health and Environment'),
(1834, 'https://ror.org/0258h0g75', 'en', 1, 'https://ror.org/0258h0g75 Rajendra Institute of Medical Sciences'),
(1835, 'https://ror.org/0259e4473', 'en', 1, 'https://ror.org/0259e4473 The Military General Hospital of Beijing PLA 中国人民解放军空军总医院'),
(1836, 'https://ror.org/025bm0k33', 'no_lang_code', 1, 'https://ror.org/025bm0k33 Kawasaki Municipal Hospital 川崎市立川崎病院'),
(1837, 'https://ror.org/025chrz76', 'en', 1, 'https://ror.org/025chrz76 Marshfield Clinic'),
(1838, 'https://ror.org/025fyfd20', 'en', 1, 'https://ror.org/025fyfd20 Children''s Hospital of Zhejiang University'),
(1839, 'https://ror.org/025kav035', 'en', 1, 'https://ror.org/025kav035 Ripon College'),
(1840, 'https://ror.org/025n13r50', 'en', 1, 'https://ror.org/025n13r50 Adelphi University'),
(1841, 'https://ror.org/025nszc09', 'no_lang_code', 1, 'https://ror.org/025nszc09 Canadian Natural Resources'),
(1842, 'https://ror.org/025ny1854', 'en', 1, 'https://ror.org/025ny1854 George Eliot Hospital'),
(1843, 'https://ror.org/025q7sd17', 'es', 1, 'https://ror.org/025q7sd17 Hospital General Dr. Manuel Gea Gonzalez'),
(1844, 'https://ror.org/025sdjb25', 'fr', 1, 'https://ror.org/025sdjb25 Centre Hospitalier et Universitaire de Brazzaville'),
(1845, 'https://ror.org/025sthg37', 'en', 1, 'https://ror.org/025sthg37 Queen Elizabeth Central Hospital'),
(1846, 'https://ror.org/025wfj672', 'en', 1, 'https://ror.org/025wfj672 MRC Unit the Gambia'),
(1847, 'https://ror.org/025xmgt30', 'en', 1, 'https://ror.org/025xmgt30 Oregon Social Learning Center'),
(1848, 'https://ror.org/025z8ah66', 'en', 1, 'https://ror.org/025z8ah66 Public Health Ontario Santé publique Ontario'),
(1849, 'https://ror.org/0260bkf37', 'no_lang_code', 1, 'https://ror.org/0260bkf37 NuroRestore (United States)'),
(1850, 'https://ror.org/0261g6j35', 'en', 1, 'https://ror.org/0261g6j35 Chaudhary Charan Singh Haryana Agricultural University चौधरी चरण सिंह हरियाणा कृषि विश्वविद्यालय சௌதரி சரண் சிங் அரியானா வேளாண்மை பல்கலைக்கழகம்'),
(1851, 'https://ror.org/026452768', 'no_lang_code', 1, 'https://ror.org/026452768 PTV Group (Germany)'),
(1852, 'https://ror.org/026492508', 'en', 1, 'https://ror.org/026492508 Spalding University'),
(1853, 'https://ror.org/0264d9934', 'en', 1, 'https://ror.org/0264d9934 Royal Aberdeen Children''s Hospital'),
(1854, 'https://ror.org/0267zkr58', 'no_lang_code', 1, 'https://ror.org/0267zkr58 Safdarjang Hospital'),
(1855, 'https://ror.org/0269fmf70', 'en', 1, 'https://ror.org/0269fmf70 St. Mary''s Hospital'),
(1856, 'https://ror.org/026as0d42', 'es', 1, 'https://ror.org/026as0d42 Hospital Angeles Pedregal'),
(1857, 'https://ror.org/026b7da27', 'en', 1, 'https://ror.org/026b7da27 Government Medical College'),
(1858, 'https://ror.org/026dp0v66', 'en', 1, 'https://ror.org/026dp0v66 Union for International Cancer Control Union internationale contre le cancer'),
(1859, 'https://ror.org/026e9yy16', 'en', 1, 'https://ror.org/026e9yy16 Affiliated Hospital of Qingdao University'),
(1860, 'https://ror.org/026gtm069', 'en', 1, 'https://ror.org/026gtm069 Maryknoll Medical Center 메리놀병원'),
(1861, 'https://ror.org/026mnhe80', 'en', 1, 'https://ror.org/026mnhe80 Chongqing Academy of Animal Science 重庆市畜牧科学院'),
(1862, 'https://ror.org/026mp1041', 'en', 1, 'https://ror.org/026mp1041 St. Joseph Hospital'),
(1863, 'https://ror.org/026n33e29', 'en', 1, 'https://ror.org/026n33e29 Cohen Children''s Medical Center'),
(1864, 'https://ror.org/026p6d134', 'en', 1, 'https://ror.org/026p6d134 Memorial Health University Medical Center'),
(1865, 'https://ror.org/026qp7597', 'tr', 1, 'https://ror.org/026qp7597 Zekai Tahir Burak Kadın Sağlığı Eğitim ve Araştırma Hastanesi'),
(1866, 'https://ror.org/026r1ac43', 'no_lang_code', 1, 'https://ror.org/026r1ac43 Fukuyama City Hospital 福山市民病院'),
(1867, 'https://ror.org/026s99n34', 'en', 1, 'https://ror.org/026s99n34 West Virginia State Department of Health and Human Resources'),
(1868, 'https://ror.org/026tktq31', 'en', 1, 'https://ror.org/026tktq31 Solapur University सोलापूर विद्यापीठ'),
(1869, 'https://ror.org/026vvkz19', 'en', 1, 'https://ror.org/026vvkz19 National Interuniversity Consortium for the Physical Sciences of Matter'),
(1870, 'https://ror.org/026xdcm93', 'en', 1, 'https://ror.org/026xdcm93 Royal Cornwall Hospital Trust'),
(1871, 'https://ror.org/02722hp10', 'no_lang_code', 1, 'https://ror.org/02722hp10 Assaf Harofeh Medical Center'),
(1872, 'https://ror.org/027487t94', 'en', 1, 'https://ror.org/027487t94 Aurora University'),
(1873, 'https://ror.org/0277g6a74', 'en', 1, 'https://ror.org/0277g6a74 Douglass Hanly Moir Pathology'),
(1874, 'https://ror.org/0277n1841', 'en', 1, 'https://ror.org/0277n1841 University of Tennessee Medical Center'),
(1875, 'https://ror.org/027970q43', 'no_lang_code', 1, 'https://ror.org/027970q43 Emergent BioSolutions (United States)'),
(1876, 'https://ror.org/02797hn66', 'en', 1, 'https://ror.org/02797hn66 Dr. Ram Manohar Lohia Avadh University डॉ राम मनोहर लोहिया अवध विश्वविद्यालय'),
(1877, 'https://ror.org/027b0sp52', 'no_lang_code', 1, 'https://ror.org/027b0sp52 Kema International (Netherlands)'),
(1878, 'https://ror.org/027dft319', 'en', 1, 'https://ror.org/027dft319 Bethesda Hospital East'),
(1879, 'https://ror.org/027evcf19', 'tr', 1, 'https://ror.org/027evcf19 Özel Ortadoğu 19 Mayıs Hastanesi'),
(1880, 'https://ror.org/027f9rb06', 'en', 1, 'https://ror.org/027f9rb06 Shimonoseki City Hospital 下関市立市民病院'),
(1881, 'https://ror.org/027fjzp74', 'en', 1, 'https://ror.org/027fjzp74 Obihiro Kosei General Hospital 帯広厚生病院'),
(1882, 'https://ror.org/027fvqp63', 'no_lang_code', 1, 'https://ror.org/027fvqp63 Emmes (United States)'),
(1883, 'https://ror.org/027grcd37', 'hu', 1, 'https://ror.org/027grcd37 Állami Szívkórház'),
(1884, 'https://ror.org/027mjht27', 'de', 1, 'https://ror.org/027mjht27 Institut Universitaire Kurt Bösch'),
(1885, 'https://ror.org/027mz0g68', 'en', 1, 'https://ror.org/027mz0g68 Salem VA Medical Center'),
(1886, 'https://ror.org/027nene90', 'no_lang_code', 1, 'https://ror.org/027nene90 Sugiyama Jogakuen University 椙山女学園大学'),
(1887, 'https://ror.org/027nk1z82', 'no_lang_code', 1, 'https://ror.org/027nk1z82 INRAD (United States)'),
(1888, 'https://ror.org/027pqks09', 'no_lang_code', 1, 'https://ror.org/027pqks09 S&N (Germany)'),
(1889, 'https://ror.org/027q9k466', 'en', 1, 'https://ror.org/027q9k466 Alexandra Hospital'),
(1890, 'https://ror.org/027ry4q41', 'en', 1, 'https://ror.org/027ry4q41 Miller Children''s & Women''s Hospital'),
(1891, 'https://ror.org/027t58004', 'en', 1, 'https://ror.org/027t58004 Eastern Maine Medical Center'),
(1892, 'https://ror.org/027tvqf96', 'no_lang_code', 1, 'https://ror.org/027tvqf96 CAS Software (Germany)'),
(1893, 'https://ror.org/027v86y62', 'en', 1, 'https://ror.org/027v86y62 El Paso County Public Health'),
(1894, 'https://ror.org/027wyhf03', 'hr', 1, 'https://ror.org/027wyhf03 Klinički Bolnički Centar Rijeka'),
(1895, 'https://ror.org/027x3m696', 'en', 1, 'https://ror.org/027x3m696 Mother Teresa Hospital Qendra Spitalore Universitare Nene Tereza'),
(1896, 'https://ror.org/027xnsa83', 'no_lang_code', 1, 'https://ror.org/027xnsa83 Prapokklao Hospital โรงพยาบาลพระปกเกล้า'),
(1897, 'https://ror.org/02827ca86', 'en', 1, 'https://ror.org/02827ca86 Prince of Wales Hospital'),
(1898, 'https://ror.org/0282qcz50', 'en', 1, 'https://ror.org/0282qcz50 Children''s Hospital of Orange County'),
(1899, 'https://ror.org/0282s7q36', 'en', 1, 'https://ror.org/0282s7q36 Tenshi Hospital 天使病院'),
(1900, 'https://ror.org/02834m470', 'en', 1, 'https://ror.org/02834m470 Chia Nan University of Pharmacy and Science'),
(1901, 'https://ror.org/0283k4z65', 'en', 1, 'https://ror.org/0283k4z65 Anne Arundel Medical Center'),
(1902, 'https://ror.org/02843s885', 'en', 1, 'https://ror.org/02843s885 Behavioral Tech Research, Inc.'),
(1903, 'https://ror.org/0284e2q78', 'en', 1, 'https://ror.org/0284e2q78 American Red Cross Croix-rouge américaine Cruz Roja Americana'),
(1904, 'https://ror.org/0284gmm72', 'fr', 1, 'https://ror.org/0284gmm72 Cité Internationale Universitaire de Paris'),
(1905, 'https://ror.org/0285m5c69', 'nl', 1, 'https://ror.org/0285m5c69 De Wever-Ziekenhuis'),
(1906, 'https://ror.org/0285prp25', 'en', 1, 'https://ror.org/0285prp25 NTT Medical Center NTT東日本関東病院'),
(1907, 'https://ror.org/0286g6711', 'en', 1, 'https://ror.org/0286g6711 Shaoguan University 韶关学院'),
(1908, 'https://ror.org/0287e5797', 'no_lang_code', 1, 'https://ror.org/0287e5797 Siemens (United Kingdom)'),
(1909, 'https://ror.org/0287vk548', 'no_lang_code', 1, 'https://ror.org/0287vk548 Sequella (United States)'),
(1910, 'https://ror.org/0288jxv49', 'en', 1, 'https://ror.org/0288jxv49 Institute of Development Studies'),
(1911, 'https://ror.org/028d75n58', 'es', 1, 'https://ror.org/028d75n58 Hospital El Bierzo'),
(1912, 'https://ror.org/028f19s63', 'en', 1, 'https://ror.org/028f19s63 Dairy Farmers Of Canada'),
(1913, 'https://ror.org/028gzjv13', 'en', 1, 'https://ror.org/028gzjv13 Kaiser Permanente Center for Health Research'),
(1914, 'https://ror.org/028hv5492', 'en', 1, 'https://ror.org/028hv5492 University Hospital Leipzig Universitätsklinikum Leipzig'),
(1915, 'https://ror.org/028jc0449', 'en', 1, 'https://ror.org/028jc0449 Austrian Research Promotion Agency Österreichische Forschungsförderungsgesellschaft'),
(1916, 'https://ror.org/028jh2126', 'en', 1, 'https://ror.org/028jh2126 Al al-Bayt University جامعة آل البيت'),
(1917, 'https://ror.org/028jmfg90', 'it', 1, 'https://ror.org/028jmfg90 Ospedale Koelliker'),
(1918, 'https://ror.org/028jrgj19', 'en', 1, 'https://ror.org/028jrgj19 Multnomah County Health Department'),
(1919, 'https://ror.org/028nq5192', 'en', 1, 'https://ror.org/028nq5192 Affiliated Hospital of Jiangxi College of TCM 江西中医学院附属医院'),
(1920, 'https://ror.org/028rvnd71', 'en', 1, 'https://ror.org/028rvnd71 Temple University Hospital'),
(1921, 'https://ror.org/028sv9734', 'no_lang_code', 1, 'https://ror.org/028sv9734 PotashCorp (Canada)'),
(1922, 'https://ror.org/028v4fg64', 'no_lang_code', 1, 'https://ror.org/028v4fg64 Vattenfall (Sweden)'),
(1923, 'https://ror.org/028vv3s82', 'en', 1, 'https://ror.org/028vv3s82 East Surrey Hospital'),
(1924, 'https://ror.org/028vxwa22', 'en', 1, 'https://ror.org/028vxwa22 Kyoto Prefectural University of Medicine 京都府立医科大学'),
(1925, 'https://ror.org/028xtgx62', 'en', 1, 'https://ror.org/028xtgx62 Albert Schweitzer Hospital Hôpital albert-schweitzer'),
(1926, 'https://ror.org/02917wp91', 'en', 1, 'https://ror.org/02917wp91 Hospital of the University of Pennsylvania'),
(1927, 'https://ror.org/0291hsm26', 'en', 1, 'https://ror.org/0291hsm26 Asahikawa City Hospital 市立旭川病院'),
(1928, 'https://ror.org/0292hc709', 'en', 1, 'https://ror.org/0292hc709 University of Santo Tomas Hospital'),
(1929, 'https://ror.org/0293qmt12', 'en', 1, 'https://ror.org/0293qmt12 NC Department of Health and Human Services'),
(1930, 'https://ror.org/02944xg79', 'en', 1, 'https://ror.org/02944xg79 Laconia Women''s Health Center'),
(1931, 'https://ror.org/02952et24', 'en', 1, 'https://ror.org/02952et24 St. Barnabas Hospital'),
(1932, 'https://ror.org/0296jvb66', 'no_lang_code', 1, 'https://ror.org/0296jvb66 WNET (United States)'),
(1933, 'https://ror.org/0299dqs22', 'en', 1, 'https://ror.org/0299dqs22 JA Toride Medical Center JAとりで総合医療センター'),
(1934, 'https://ror.org/0299ptp31', 'en', 1, 'https://ror.org/0299ptp31 Kaiser Permanente San Rafael Medical Center'),
(1935, 'https://ror.org/029bp0k25', 'en', 1, 'https://ror.org/029bp0k25 University of Central Arkansas'),
(1936, 'https://ror.org/029cz3039', 'en', 1, 'https://ror.org/029cz3039 Kijabe Hospital'),
(1937, 'https://ror.org/029dttz57', 'en', 1, 'https://ror.org/029dttz57 Resurrection Medical Center'),
(1938, 'https://ror.org/029es6637', 'en', 1, 'https://ror.org/029es6637 Alaska Native Tribal Health Consortium'),
(1939, 'https://ror.org/029f8s748', 'en', 1, 'https://ror.org/029f8s748 Canadian Science Centre for Human and Animal Health'),
(1940, 'https://ror.org/029fzbq43', 'no_lang_code', 1, 'https://ror.org/029fzbq43 Oita Prefectural Hospital 大分県立病院'),
(1941, 'https://ror.org/029gksw03', 'en', 1, 'https://ror.org/029gksw03 Semnan University دانشگاه سمنان'),
(1942, 'https://ror.org/029gprt07', 'en', 1, 'https://ror.org/029gprt07 Dunedin Public Hospital'),
(1943, 'https://ror.org/029gr6k74', 'en', 1, 'https://ror.org/029gr6k74 Medical Society of Delaware'),
(1944, 'https://ror.org/029hept94', 'en', 1, 'https://ror.org/029hept94 Alexandra Hospital'),
(1945, 'https://ror.org/029hzjx43', 'en', 1, 'https://ror.org/029hzjx43 Rappaport Family Institute for Research in the Medical Sciences'),
(1946, 'https://ror.org/029jj9438', 'en', 1, 'https://ror.org/029jj9438 Troy University'),
(1947, 'https://ror.org/029njb796', 'en', 1, 'https://ror.org/029njb796 Perm State University Пермский государственный университет'),
(1948, 'https://ror.org/029nzwk08', 'en', 1, 'https://ror.org/029nzwk08 Levanger Hospital Sykehuset Levanger'),
(1949, 'https://ror.org/029rx2040', 'en', 1, 'https://ror.org/029rx2040 Federal Medical Centre'),
(1950, 'https://ror.org/029s9j634', 'en', 1, 'https://ror.org/029s9j634 Cairns Hospital'),
(1951, 'https://ror.org/029t2gr02', 'no_lang_code', 1, 'https://ror.org/029t2gr02 Xenon Pharmaceuticals (Canada)'),
(1952, 'https://ror.org/029tkqm80', 'en', 1, 'https://ror.org/029tkqm80 St. Vincent''s University Hospital'),
(1953, 'https://ror.org/029tn5b56', 'en', 1, 'https://ror.org/029tn5b56 Regina General Hospital'),
(1954, 'https://ror.org/029wb5j17', 'en', 1, 'https://ror.org/029wb5j17 Our Lady of the Lake University'),
(1955, 'https://ror.org/029wq9x81', 'en', 1, 'https://ror.org/029wq9x81 Sichuan Cancer Hospital 四川省肿瘤研究所'),
(1956, 'https://ror.org/029x6kq07', 'en', 1, 'https://ror.org/029x6kq07 Regina Qu''Appelle Health Region'),
(1957, 'https://ror.org/02a0k6s81', 'en', 1, 'https://ror.org/02a0k6s81 Tianjin Children''s Hospital 天津市儿童医院'),
(1958, 'https://ror.org/02a1et264', 'en', 1, 'https://ror.org/02a1et264 Blackburn College'),
(1959, 'https://ror.org/02a2vbq68', 'en', 1, 'https://ror.org/02a2vbq68 Nagoya Memorial Hospital 名古屋記念病院'),
(1960, 'https://ror.org/02a37xs76', 'en', 1, 'https://ror.org/02a37xs76 Health Services Academy'),
(1961, 'https://ror.org/02a5q3y73', 'es', 1, 'https://ror.org/02a5q3y73 Hospital Universitario HM Madrid'),
(1962, 'https://ror.org/02a6g3h39', 'en', 1, 'https://ror.org/02a6g3h39 Hawler Medical University جامعة هولير الطبية'),
(1963, 'https://ror.org/02a7yfb86', 'pt', 1, 'https://ror.org/02a7yfb86 Pontifícia Universidade Católica de Goiás Université pontificale catholique de goiás'),
(1964, 'https://ror.org/02aa8kj12', 'en', 1, 'https://ror.org/02aa8kj12 The People''s Hospital of Guangxi Zhuang Autonomous Region 广西壮族自治区人民医院'),
(1965, 'https://ror.org/02ab2dg68', 'en', 1, 'https://ror.org/02ab2dg68 Singleton Hospital Ysbyty Singleton'),
(1966, 'https://ror.org/02adcah05', 'no_lang_code', 1, 'https://ror.org/02adcah05 Doty Scientific (United States)'),
(1967, 'https://ror.org/02adg5v98', 'en', 1, 'https://ror.org/02adg5v98 Nagoya City University Hospital 名古屋市立大学病院'),
(1968, 'https://ror.org/02aea0q64', 'pt', 1, 'https://ror.org/02aea0q64 IADE Superior de Marketing e Publicidade'),
(1969, 'https://ror.org/02af4h012', 'en', 1, 'https://ror.org/02af4h012 Jadavpur University Université jadavpur यादवपुर विश्वविद्यालय যাদবপুর বিশ্ববিদ্যালয় ਜਾਦਵਪੁਰ ਯੂਨੀਵਰਸਿਟੀ જાદવપુર યુનિવર્સિટી జాదవ్ పూర్ విశ్వవిద్యాలయం ಜಾದವ್ ಪುರ ವಿಶ್ವವಿದ್ಯಾಲಯ'),
(1970, 'https://ror.org/02afbf040', 'en', 1, 'https://ror.org/02afbf040 Karachi Medical and Dental College'),
(1971, 'https://ror.org/02ahxbh87', 'en', 1, 'https://ror.org/02ahxbh87 Biomedical Primate Research Centre'),
(1972, 'https://ror.org/02ajrkx50', 'en', 1, 'https://ror.org/02ajrkx50 St. Luke''s Hospital'),
(1973, 'https://ror.org/02aknh966', 'en', 1, 'https://ror.org/02aknh966 Emory University Hospital Midtown'),
(1974, 'https://ror.org/02amggm23', 'en', 1, 'https://ror.org/02amggm23 Trimbos Institute Trimbos instituut'),
(1975, 'https://ror.org/02ap76n24', 'en', 1, 'https://ror.org/02ap76n24 Egyptian Universities Network شبكة الجامعات المصرية'),
(1976, 'https://ror.org/02aseym49', 'en', 1, 'https://ror.org/02aseym49 Australian Centre for Disease Preparedness'),
(1977, 'https://ror.org/02atdvd89', 'en', 1, 'https://ror.org/02atdvd89 Sarasota Memorial Hospital'),
(1978, 'https://ror.org/02atpex25', 'es', 1, 'https://ror.org/02atpex25 Hospital Rio Carrion'),
(1979, 'https://ror.org/02ax13658', 'no_lang_code', 1, 'https://ror.org/02ax13658 Barkatullah University'),
(1980, 'https://ror.org/02azxx136', 'en', 1, 'https://ror.org/02azxx136 University of Health Sciences Vientiane ມະຫາວິທະຍາໄລ ວິທະຍາສາດ ສຸຂະພາບ'),
(1981, 'https://ror.org/02b48z609', 'en', 1, 'https://ror.org/02b48z609 University Cancer Center Hamburg Universitäres Cancer Center Hamburg'),
(1982, 'https://ror.org/02b50zn53', 'en', 1, 'https://ror.org/02b50zn53 Université de wilberforce Wilberforce University'),
(1983, 'https://ror.org/02b68mf79', 'it', 1, 'https://ror.org/02b68mf79 Ospedale Santa Maria'),
(1984, 'https://ror.org/02b72da46', 'en', 1, 'https://ror.org/02b72da46 Abbasi Shaheed Hospital عباسی شهيد ہسپتال'),
(1985, 'https://ror.org/02b730m35', 'pt', 1, 'https://ror.org/02b730m35 Instituto Superior de Ciências da Informação e da Administração'),
(1986, 'https://ror.org/02b8m7s43', 'en', 1, 'https://ror.org/02b8m7s43 American Anthropological Association'),
(1987, 'https://ror.org/02bcf5b42', 'no_lang_code', 1, 'https://ror.org/02bcf5b42 Foxconn (Japan)'),
(1988, 'https://ror.org/02beve479', 'en', 1, 'https://ror.org/02beve479 La Salle University Universidad de la Salle Université la Salle'),
(1989, 'https://ror.org/02bfqd210', 'en', 1, 'https://ror.org/02bfqd210 Regions Hospital'),
(1990, 'https://ror.org/02bg8cb41', 'en', 1, 'https://ror.org/02bg8cb41 Alaska Native Medical Center'),
(1991, 'https://ror.org/02bhk3j29', 'es', 1, 'https://ror.org/02bhk3j29 Hospital Virgen de la Concha'),
(1992, 'https://ror.org/02bj40x52', 'en', 1, 'https://ror.org/02bj40x52 Osaka Rosai Hospital 大阪労災病院'),
(1993, 'https://ror.org/02bn97g32', 'en', 1, 'https://ror.org/02bn97g32 National Defense Medical Center'),
(1994, 'https://ror.org/02bnz8785', 'en', 1, 'https://ror.org/02bnz8785 First Affiliated Hospital of Shantou University Medical College 汕头大学医学院第一附属医院'),
(1995, 'https://ror.org/02bqrry13', 'en', 1, 'https://ror.org/02bqrry13 Jerry L. Pettis Memorial VA Medical Center'),
(1996, 'https://ror.org/02bs0cv29', 'en', 1, 'https://ror.org/02bs0cv29 Oklahoma City University'),
(1997, 'https://ror.org/02bste653', 'it', 1, 'https://ror.org/02bste653 Ospedale “M. Bufalini” di Cesena'),
(1998, 'https://ror.org/02bwjrg36', 'en', 1, 'https://ror.org/02bwjrg36 Academia Nacional Superior de Orquestra'),
(1999, 'https://ror.org/02bxrp522', 'en', 1, 'https://ror.org/02bxrp522 Knoxville College'),
(2000, 'https://ror.org/02byvdx91', 'en', 1, 'https://ror.org/02byvdx91 Kobe Rosai Hospital 神戸労災病院'),
(2001, 'https://ror.org/02byvsq24', 'en', 1, 'https://ror.org/02byvsq24 Community Regional Medical Center'),
(2002, 'https://ror.org/02bz7vk34', 'en', 1, 'https://ror.org/02bz7vk34 Kaiser Permanente Redwood City Medical Center'),
(2003, 'https://ror.org/02bzkv281', 'en', 1, 'https://ror.org/02bzkv281 Chengde Medical University 承德医学院'),
(2004, 'https://ror.org/02c1c4p76', 'en', 1, 'https://ror.org/02c1c4p76 Magee Rehabilitation Hospital'),
(2005, 'https://ror.org/02c1pgm26', 'en', 1, 'https://ror.org/02c1pgm26 Royal Inland Hospital'),
(2006, 'https://ror.org/02c2f8975', 'en', 1, 'https://ror.org/02c2f8975 University of Ulsan 울산대학교'),
(2007, 'https://ror.org/02c495c76', 'en', 1, 'https://ror.org/02c495c76 St. Joseph’s University Medical Center'),
(2008, 'https://ror.org/02c8hpe74', 'en', 1, 'https://ror.org/02c8hpe74 James J. Peters VA Medical Center'),
(2009, 'https://ror.org/02c8npj93', 'en', 1, 'https://ror.org/02c8npj93 General-Maternity District Hospital Helena Venizelou Περιφερειακό Γενικό Νοσοκομείο - Μαιευτήριο - "ΕΛΕΝΑ ΒΕΝΙΖΕΛΟΥ"'),
(2010, 'https://ror.org/02c93ee60', 'en', 1, 'https://ror.org/02c93ee60 Osaka Occupational Health Research Center 大阪労働衛生総合センター'),
(2011, 'https://ror.org/02c97ng92', 'no_lang_code', 1, 'https://ror.org/02c97ng92 ArcelorMittal (Canada)'),
(2012, 'https://ror.org/02caez234', 'en', 1, 'https://ror.org/02caez234 Fuzhou Dermatosis Prevention Hospital 福州市皮肤病防治院'),
(2013, 'https://ror.org/02cbk9w51', 'es', 1, 'https://ror.org/02cbk9w51 Hospital Nacional Dos de Mayo'),
(2014, 'https://ror.org/02cc58y38', 'fr', 1, 'https://ror.org/02cc58y38 Hôpital Debrousse'),
(2015, 'https://ror.org/02ccwf677', 'no_lang_code', 1, 'https://ror.org/02ccwf677 Proportional Technologies'),
(2016, 'https://ror.org/02cetwy62', 'en', 1, 'https://ror.org/02cetwy62 Prince Charles Hospital'),
(2017, 'https://ror.org/02cevbn07', 'en', 1, 'https://ror.org/02cevbn07 Mississippi State Medical Association'),
(2018, 'https://ror.org/02cg59151', 'pt', 1, 'https://ror.org/02cg59151 Hospital Pulido Valente'),
(2019, 'https://ror.org/02ch1zb66', 'en', 1, 'https://ror.org/02ch1zb66 Tianjin First Center Hospital 天津市第一中心医院'),
(2020, 'https://ror.org/02chbx029', 'no_lang_code', 1, 'https://ror.org/02chbx029 Oji General Hospital 王子総合病院'),
(2021, 'https://ror.org/02cjhb354', 'it', 1, 'https://ror.org/02cjhb354 Azienda Ospedaliera Santa Maria Degli Angeli'),
(2022, 'https://ror.org/02ckh3s34', 'da', 1, 'https://ror.org/02ckh3s34 Herning Regional Hospital Regionshospitalet Herning'),
(2023, 'https://ror.org/02cm2rk35', 'en', 1, 'https://ror.org/02cm2rk35 Raritan Bay Medical Center'),
(2024, 'https://ror.org/02cmyty27', 'en', 1, 'https://ror.org/02cmyty27 St. Joseph''s Hospital'),
(2025, 'https://ror.org/02cpwdj94', 'en', 1, 'https://ror.org/02cpwdj94 Kerala Institute of Medical Sciences'),
(2026, 'https://ror.org/02cpzy455', 'en', 1, 'https://ror.org/02cpzy455 424 General Military Hospital 424 Γενικό Στρατιωτικό Νοσοκομείο Θεσσαλονίκης'),
(2027, 'https://ror.org/02cqgeg62', 'no_lang_code', 1, 'https://ror.org/02cqgeg62 INRA Transfert (France)'),
(2028, 'https://ror.org/02cqyyd50', 'en', 1, 'https://ror.org/02cqyyd50 Nottingham General Hospital'),
(2029, 'https://ror.org/02crz6e12', 'en', 1, 'https://ror.org/02crz6e12 Singapore Eye Research Institute'),
(2030, 'https://ror.org/02cs3sv23', 'sv', 1, 'https://ror.org/02cs3sv23 Uddevalla sjukhus'),
(2031, 'https://ror.org/02ct41q97', 'en', 1, 'https://ror.org/02ct41q97 John Brown University'),
(2032, 'https://ror.org/02cv4ah81', 'en', 1, 'https://ror.org/02cv4ah81 Ishikawa Prefectural Central Hospital 石川県立中央病院'),
(2033, 'https://ror.org/02cy9a842', 'en', 1, 'https://ror.org/02cy9a842 Carmel Medical Center'),
(2034, 'https://ror.org/02d07gm56', 'en', 1, 'https://ror.org/02d07gm56 SUNY Korea 한국뉴욕주립대학교'),
(2035, 'https://ror.org/02d09a271', 'pt', 1, 'https://ror.org/02d09a271 Positive University Universidade Positivo'),
(2036, 'https://ror.org/02d0kps43', 'de', 1, 'https://ror.org/02d0kps43 UMIT - Private Universität für Gesundheitswissenschaften, Medizinische Informatik und Technik'),
(2037, 'https://ror.org/02d0tyt78', 'en', 1, 'https://ror.org/02d0tyt78 Silpakorn University มหาวิทยาลัยศิลปากร'),
(2038, 'https://ror.org/02d1ved90', 'tr', 1, 'https://ror.org/02d1ved90 Dokuz Eylül Üniversitesi Hastanesi'),
(2039, 'https://ror.org/02d3bpj67', 'no_lang_code', 1, 'https://ror.org/02d3bpj67 Medical Physics Consultants'),
(2040, 'https://ror.org/02d3k5845', 'en', 1, 'https://ror.org/02d3k5845 St Francis Medical Center'),
(2041, 'https://ror.org/02d439m40', 'en', 1, 'https://ror.org/02d439m40 University Mental Health Research Institute'),
(2042, 'https://ror.org/02d57ed54', 'en', 1, 'https://ror.org/02d57ed54 Sarojini Naidu Medical College सरोजिनी नायडू चिकित्सा महाविद्यालय'),
(2043, 'https://ror.org/02d9k9g58', 'en', 1, 'https://ror.org/02d9k9g58 University of South Carolina Aiken'),
(2044, 'https://ror.org/02dc47z81', 'pt', 1, 'https://ror.org/02dc47z81 Hospital São Teotónio'),
(2045, 'https://ror.org/02dcp1550', 'en', 1, 'https://ror.org/02dcp1550 Central Texas Veterans Health Care System'),
(2046, 'https://ror.org/02df8t483', 'no_lang_code', 1, 'https://ror.org/02df8t483 Bridgepoint (United Kingdom)'),
(2047, 'https://ror.org/02dgbcj80', 'en', 1, 'https://ror.org/02dgbcj80 Southwest Baptist University'),
(2048, 'https://ror.org/02dgmb809', 'no_lang_code', 1, 'https://ror.org/02dgmb809 Numerical Mechanics Applications International (Belgium)'),
(2049, 'https://ror.org/02dktng58', 'en', 1, 'https://ror.org/02dktng58 Institute for Scientific Analysis'),
(2050, 'https://ror.org/02dmc4h32', 'en', 1, 'https://ror.org/02dmc4h32 Providence St. Vincent Medical Center'),
(2051, 'https://ror.org/02dpa2319', 'en', 1, 'https://ror.org/02dpa2319 Cornwall Regional Hospital'),
(2052, 'https://ror.org/02dqqj223', 'en', 1, 'https://ror.org/02dqqj223 East Kent Hospitals University NHS Foundation Trust'),
(2053, 'https://ror.org/02dr19631', 'en', 1, 'https://ror.org/02dr19631 Medical Radiological Research Center Медицинский радиологический научный центр'),
(2054, 'https://ror.org/02dvgss50', 'en', 1, 'https://ror.org/02dvgss50 Stepping Hill Hospital'),
(2055, 'https://ror.org/02e0bfh77', 'no_lang_code', 1, 'https://ror.org/02e0bfh77 Bio Chem Analysis Corporation (United States)'),
(2056, 'https://ror.org/02e16g702', 'en', 1, 'https://ror.org/02e16g702 Hokkaido University 北海道大学'),
(2057, 'https://ror.org/02e1cpg76', 'en', 1, 'https://ror.org/02e1cpg76 Hauptman-Woodward Medical Research Institute'),
(2058, 'https://ror.org/02e1t6r96', 'en', 1, 'https://ror.org/02e1t6r96 Maryland Department of Health'),
(2059, 'https://ror.org/02e22bh87', 'en', 1, 'https://ror.org/02e22bh87 Western Infirmary'),
(2060, 'https://ror.org/02e2dtd78', 'en', 1, 'https://ror.org/02e2dtd78 Calcutta National Medical College and Hospital কলিকাতা জাতীয় আয়ুর্বিজ্ঞান বিদ্যামন্দির జాతీయ వైద్య కళాశాల'),
(2061, 'https://ror.org/02e3mzq40', 'en', 1, 'https://ror.org/02e3mzq40 Middlesex London Health Unit'),
(2062, 'https://ror.org/02e560b93', 'de', 1, 'https://ror.org/02e560b93 Barmherzige Brüder Klinikum St. Elisabeth in Straubing'),
(2063, 'https://ror.org/02e5pan03', 'en', 1, 'https://ror.org/02e5pan03 Charlton Memorial Hospital'),
(2064, 'https://ror.org/02e8hzf44', 'en', 1, 'https://ror.org/02e8hzf44 Helsinki University Hospital'),
(2065, 'https://ror.org/02e9zc863', 'en', 1, 'https://ror.org/02e9zc863 Kwangwoon University 광운대학교'),
(2066, 'https://ror.org/02eb0rk31', 'en', 1, 'https://ror.org/02eb0rk31 Association for the Advancement of Artificial Intelligence'),
(2067, 'https://ror.org/02egdz393', 'en', 1, 'https://ror.org/02egdz393 Rocky Mountain University of Health Professions'),
(2068, 'https://ror.org/02ejsvn42', 'en', 1, 'https://ror.org/02ejsvn42 Comité Européen de Normalisation European Committee for Standardization'),
(2069, 'https://ror.org/02emy8e21', 'en', 1, 'https://ror.org/02emy8e21 Kings County Hospital Center'),
(2070, 'https://ror.org/02eqchk86', 'en', 1, 'https://ror.org/02eqchk86 Daejeon University 대전대학교'),
(2071, 'https://ror.org/02eqka166', 'en', 1, 'https://ror.org/02eqka166 Mercy Medical Center'),
(2072, 'https://ror.org/02erhaz63', 'en', 1, 'https://ror.org/02erhaz63 Lanzhou University Second Hospital'),
(2073, 'https://ror.org/02etexs15', 'en', 1, 'https://ror.org/02etexs15 Children''s Hospital of New Orleans'),
(2074, 'https://ror.org/02evem426', 'pt', 1, 'https://ror.org/02evem426 Escola Superior de Enfermagem de Santa Maria'),
(2075, 'https://ror.org/02ew45630', 'en', 1, 'https://ror.org/02ew45630 Apollo Hospitals'),
(2076, 'https://ror.org/02eyff421', 'en', 1, 'https://ror.org/02eyff421 Ministry of Health'),
(2077, 'https://ror.org/02eypkr92', 'en', 1, 'https://ror.org/02eypkr92 Northwest Hospital and Medical Center'),
(2078, 'https://ror.org/02f2vsx71', 'no_lang_code', 1, 'https://ror.org/02f2vsx71 Hungkuang University'),
(2079, 'https://ror.org/02f30ff69', 'es', 1, 'https://ror.org/02f30ff69 Hospital General Universitario de Ciudad Real'),
(2080, 'https://ror.org/02f38b560', 'pt', 1, 'https://ror.org/02f38b560 Hospital São Rafael'),
(2081, 'https://ror.org/02f3b8e29', 'en', 1, 'https://ror.org/02f3b8e29 Alexandra Hospital 亚历山大医院'),
(2082, 'https://ror.org/02f4tsf92', 'en', 1, 'https://ror.org/02f4tsf92 MRC Centre for Reproductive Health'),
(2083, 'https://ror.org/02f53md90', 'en', 1, 'https://ror.org/02f53md90 Tamworth Hospital'),
(2084, 'https://ror.org/02f6ghw27', 'fr', 1, 'https://ror.org/02f6ghw27 Hôpital Charles-Nicolle'),
(2085, 'https://ror.org/02f9det96', 'en', 1, 'https://ror.org/02f9det96 University of Hildesheim Universität Hildesheim'),
(2086, 'https://ror.org/02fjqfr36', 'en', 1, 'https://ror.org/02fjqfr36 Wildlife Conservation Society Indonesia'),
(2087, 'https://ror.org/02fjy3w42', 'en', 1, 'https://ror.org/02fjy3w42 Ivanovo State University of Chemistry and Technology Ивановский государственный химико-технологический университет'),
(2088, 'https://ror.org/02fkdpc07', 'fi', 1, 'https://ror.org/02fkdpc07 Kanta-Hämeen Keskussairaala'),
(2089, 'https://ror.org/02fmkev06', 'en', 1, 'https://ror.org/02fmkev06 Building Research Establishment'),
(2090, 'https://ror.org/02fn8j763', 'en', 1, 'https://ror.org/02fn8j763 Wangjing Hospital of China Academy of Chinese Medical Sciences 中国中医科学院望京医院'),
(2091, 'https://ror.org/02fnpv153', 'en', 1, 'https://ror.org/02fnpv153 American Association For Cancer Research'),
(2092, 'https://ror.org/02fppms28', 'en', 1, 'https://ror.org/02fppms28 Missouri Department of Mental Health'),
(2093, 'https://ror.org/02fsmcz03', 'en', 1, 'https://ror.org/02fsmcz03 First Teaching Hospital of Tianjin University of Traditional Chinese Medicine 中国传统医药的天津大学第一附属医院'),
(2094, 'https://ror.org/02fsxgh46', 'fr', 1, 'https://ror.org/02fsxgh46 Hôpital l''Archet'),
(2095, 'https://ror.org/02fv7x872', 'en', 1, 'https://ror.org/02fv7x872 Deenanath Mangeshkar Hospital and Research Center दीनानाथ मंगेशकर रुग्णालय'),
(2096, 'https://ror.org/02fv8hj62', 'es', 1, 'https://ror.org/02fv8hj62 Tecnalia'),
(2097, 'https://ror.org/02fvvnh95', 'en', 1, 'https://ror.org/02fvvnh95 Spenshult Hospital'),
(2098, 'https://ror.org/02fw4cc98', 'en', 1, 'https://ror.org/02fw4cc98 Canadian Agency for Drugs and Technologies in Health'),
(2099, 'https://ror.org/02fw9q305', 'en', 1, 'https://ror.org/02fw9q305 Norwich University of the Arts'),
(2100, 'https://ror.org/02fwb6r86', 'no_lang_code', 1, 'https://ror.org/02fwb6r86 Intelligent Automation (United States)'),
(2101, 'https://ror.org/02fxsj090', 'en', 1, 'https://ror.org/02fxsj090 Kaiser Permanente San Francisco Medical Center'),
(2102, 'https://ror.org/02fyxjb45', 'en', 1, 'https://ror.org/02fyxjb45 Sri Krishnadevaraya University శ్రీ కృష్ణదేవరాయ విశ్వవిద్యాలయము'),
(2103, 'https://ror.org/02fze0e77', 'en', 1, 'https://ror.org/02fze0e77 Star General Hospital 星総合病院'),
(2104, 'https://ror.org/02fzxed89', 'en', 1, 'https://ror.org/02fzxed89 American Statistical Association'),
(2105, 'https://ror.org/02g01ht84', 'en', 1, 'https://ror.org/02g01ht84 First Affiliated Hospital of Kunming Medical University'),
(2106, 'https://ror.org/02g02rq35', 'en', 1, 'https://ror.org/02g02rq35 Centers for Medicare and Medicaid Services'),
(2107, 'https://ror.org/02g1bg244', 'en', 1, 'https://ror.org/02g1bg244 Cheongju St. Mary''s Hospital 청주 성모 병원'),
(2108, 'https://ror.org/02g2pz956', 'en', 1, 'https://ror.org/02g2pz956 Amager Hospital'),
(2109, 'https://ror.org/02g397b52', 'en', 1, 'https://ror.org/02g397b52 Shriners Hospitals for Children - Boston'),
(2110, 'https://ror.org/02g48bh60', 'en', 1, 'https://ror.org/02g48bh60 Chris Hani Baragwanath Hospital'),
(2111, 'https://ror.org/02g6d4t03', 'de', 1, 'https://ror.org/02g6d4t03 Gesellschaft Fur Mathematik Und Datenverarbeitung'),
(2112, 'https://ror.org/02g8ene02', 'en', 1, 'https://ror.org/02g8ene02 Federal Medical Centre'),
(2113, 'https://ror.org/02gaqn537', 'en', 1, 'https://ror.org/02gaqn537 Royal Cornhill Hospital'),
(2114, 'https://ror.org/02gar4w80', 'en', 1, 'https://ror.org/02gar4w80 University Library in Bratislava Univerzitná knižnica v Bratislave'),
(2115, 'https://ror.org/02gcp3110', 'en', 1, 'https://ror.org/02gcp3110 Charing Cross Hospital'),
(2116, 'https://ror.org/02ge60j37', 'en', 1, 'https://ror.org/02ge60j37 Scott & White Memorial Hospital'),
(2117, 'https://ror.org/02gen2282', 'pt', 1, 'https://ror.org/02gen2282 Federal University from Jequitinhonha and Mucuri''s Valleys Universidade Federal dos Vales do Jequitinhonha e Mucuri'),
(2118, 'https://ror.org/02gj19t78', 'en', 1, 'https://ror.org/02gj19t78 Humber River Regional Hospital'),
(2119, 'https://ror.org/02gj58768', 'en', 1, 'https://ror.org/02gj58768 Apollo Gleneagles Hospitals'),
(2120, 'https://ror.org/02gjsze31', 'en', 1, 'https://ror.org/02gjsze31 St. Luke''s Magic Valley Medical Center'),
(2121, 'https://ror.org/02gpdzc63', 'no_lang_code', 1, 'https://ror.org/02gpdzc63 Labor (Italy)'),
(2122, 'https://ror.org/02grymn95', 'en', 1, 'https://ror.org/02grymn95 University of Arkansas – Fort Smith'),
(2123, 'https://ror.org/02gxh1s15', 'en', 1, 'https://ror.org/02gxh1s15 St. Anthony Hospital'),
(2124, 'https://ror.org/02gxymm77', 'en', 1, 'https://ror.org/02gxymm77 Nakamura Memorial Hospital 中村記念病院'),
(2125, 'https://ror.org/02gy6qp39', 'en', 1, 'https://ror.org/02gy6qp39 Allegheny General Hospital'),
(2126, 'https://ror.org/02gzbg991', 'en', 1, 'https://ror.org/02gzbg991 Seattle Pacific University'),
(2127, 'https://ror.org/02gzfb532', 'en', 1, 'https://ror.org/02gzfb532 Taipei City Hospital 臺北市政府'),
(2128, 'https://ror.org/02gzhbc75', 'en', 1, 'https://ror.org/02gzhbc75 Matsudo City Hospital 松戸市立病院'),
(2129, 'https://ror.org/02h1b1x27', 'en', 1, 'https://ror.org/02h1b1x27 Universidad de Los Andes University of the Andes');
INSERT INTO `rors` VALUES
(2130, 'https://ror.org/02h1scg40', 'en', 1, 'https://ror.org/02h1scg40 Maternal and Child Health Care Hospital of Bao''an 宝安区妇幼保健院'),
(2131, 'https://ror.org/02h2j1586', 'en', 1, 'https://ror.org/02h2j1586 Beijing Anzhen Hospital 北京市心肺血管疾病研究所'),
(2132, 'https://ror.org/02h2qwk37', 'en', 1, 'https://ror.org/02h2qwk37 St Vincent Medical Center'),
(2133, 'https://ror.org/02h4kdd20', 'en', 1, 'https://ror.org/02h4kdd20 St. Luke''s Medical Center'),
(2134, 'https://ror.org/02h63je06', 'en', 1, 'https://ror.org/02h63je06 Quality Education for Minorities Network'),
(2135, 'https://ror.org/02h6j4611', 'en', 1, 'https://ror.org/02h6j4611 Princess Margaret Hospital'),
(2136, 'https://ror.org/02h70he60', 'en', 1, 'https://ror.org/02h70he60 Okayama Red Cross General Hospital 岡山赤十字病院'),
(2137, 'https://ror.org/02h7s7a86', 'en', 1, 'https://ror.org/02h7s7a86 Allen University'),
(2138, 'https://ror.org/02h8a1848', 'en', 1, 'https://ror.org/02h8a1848 Ningxia Medical University 宁夏医科大学'),
(2139, 'https://ror.org/02h905004', 'en', 1, 'https://ror.org/02h905004 Christiana Care Health System'),
(2140, 'https://ror.org/02ha38c24', 'en', 1, 'https://ror.org/02ha38c24 San Joaquin General Hospital'),
(2141, 'https://ror.org/02hbhxa68', 'no_lang_code', 1, 'https://ror.org/02hbhxa68 Airbus (United Kingdom)'),
(2142, 'https://ror.org/02hc70w10', 'en', 1, 'https://ror.org/02hc70w10 United Hospital'),
(2143, 'https://ror.org/02he2nc27', 'en', 1, 'https://ror.org/02he2nc27 National Research Tomsk State University Национа́льный иссле́довательский То́мский госуда́рственный университе́т'),
(2144, 'https://ror.org/02hfws565', 'en', 1, 'https://ror.org/02hfws565 Northwick Park Institute for Medical Research'),
(2145, 'https://ror.org/02hm3sf87', 'no_lang_code', 1, 'https://ror.org/02hm3sf87 European Institute For Research and Strategic Studies In Telecommunications'),
(2146, 'https://ror.org/02hngyx35', 'en', 1, 'https://ror.org/02hngyx35 Rocky Mountain Hospital for Children'),
(2147, 'https://ror.org/02hp4jd32', 'en', 1, 'https://ror.org/02hp4jd32 Summa Barberton Hospital'),
(2148, 'https://ror.org/02hpatg29', 'en', 1, 'https://ror.org/02hpatg29 Fukuoka University Tsukushi Hospital 福岡大学筑紫病院'),
(2149, 'https://ror.org/02hsexy86', 'en', 1, 'https://ror.org/02hsexy86 Riverside Methodist Hospital'),
(2150, 'https://ror.org/02hsneh43', 'en', 1, 'https://ror.org/02hsneh43 Shizuoka City Hospital 静岡市立静岡病院'),
(2151, 'https://ror.org/02hsq0e05', 'no_lang_code', 1, 'https://ror.org/02hsq0e05 EIC Laboratories'),
(2152, 'https://ror.org/02hssy432', 'it', 1, 'https://ror.org/02hssy432 Istituto Superiore di Sanità National Institute of Health'),
(2153, 'https://ror.org/02hvsf428', 'nl', 1, 'https://ror.org/02hvsf428 Ziekenhuis Bethesda'),
(2154, 'https://ror.org/02hw5fp67', 'en', 1, 'https://ror.org/02hw5fp67 National Institute for Environmental Studies 国立環境研究所'),
(2155, 'https://ror.org/02hxrag63', 'en', 1, 'https://ror.org/02hxrag63 Memorial Medical Center'),
(2156, 'https://ror.org/02hxrrn62', 'en', 1, 'https://ror.org/02hxrrn62 Interbalkan Medical Center Ιατρικό Διαβαλκανικό Κέντρο'),
(2157, 'https://ror.org/02hy2mb20', 'no_lang_code', 1, 'https://ror.org/02hy2mb20 De Gezondheidsdienst voor Dieren'),
(2158, 'https://ror.org/02hyxwa22', 'en', 1, 'https://ror.org/02hyxwa22 Center for Urban Population Health'),
(2159, 'https://ror.org/02j3enb93', 'no_lang_code', 1, 'https://ror.org/02j3enb93 ArcelorMittal (Spain)'),
(2160, 'https://ror.org/02j4gdg91', 'en', 1, 'https://ror.org/02j4gdg91 Vivekananda Institute of Medical Sciences'),
(2161, 'https://ror.org/02j4j5k41', 'en', 1, 'https://ror.org/02j4j5k41 John Muir Health'),
(2162, 'https://ror.org/02j7h9426', 'no_lang_code', 1, 'https://ror.org/02j7h9426 Komagino Hospital 駒木野病院'),
(2163, 'https://ror.org/02j8pe645', 'en', 1, 'https://ror.org/02j8pe645 National Academy of Sciences of Belarus Национальная академия наук Беларуси Нацыянальная акадэмія навук Беларусі'),
(2164, 'https://ror.org/02jagkr09', 'en', 1, 'https://ror.org/02jagkr09 Gulbarga University गुलबर्गा विश्वविद्यालय குல்பர்கா பல்கலைக்கழகம் గుల్బర్గా విశ్వవిద్యాలయం ಗುಲ್ಬರ್ಗಾ ವಿಶ್ವವಿದ್ಯಾಲಯ'),
(2165, 'https://ror.org/02jb3jv25', 'en', 1, 'https://ror.org/02jb3jv25 Yuanpei University 元培醫事科技大學'),
(2166, 'https://ror.org/02jb7ng92', 'en', 1, 'https://ror.org/02jb7ng92 Moorgreen Hospital'),
(2167, 'https://ror.org/02jbvhm37', 'en', 1, 'https://ror.org/02jbvhm37 Southeastern Universities Research Association'),
(2168, 'https://ror.org/02jbzrw51', 'en', 1, 'https://ror.org/02jbzrw51 Gallup Indian Medical Center'),
(2169, 'https://ror.org/02jed3n25', 'en', 1, 'https://ror.org/02jed3n25 Sacred Heart Hospital'),
(2170, 'https://ror.org/02jj7t426', 'en', 1, 'https://ror.org/02jj7t426 Dade County Medical Examiner Department'),
(2171, 'https://ror.org/02jj9nh46', 'no_lang_code', 1, 'https://ror.org/02jj9nh46 Artron Bioresearch (Canada)'),
(2172, 'https://ror.org/02jk5qe80', 'en', 1, 'https://ror.org/02jk5qe80 Aalborg Universitetshospital Aalborg University Hospital'),
(2173, 'https://ror.org/02jmkw435', 'en', 1, 'https://ror.org/02jmkw435 Saratov State Medical University Саратовский государственный медицинский университет'),
(2174, 'https://ror.org/02jn27q49', 'en', 1, 'https://ror.org/02jn27q49 Riverview Psychiatric Center'),
(2175, 'https://ror.org/02jqapy19', 'en', 1, 'https://ror.org/02jqapy19 Qingdao Municipal Hospital'),
(2176, 'https://ror.org/02jqn4a25', 'en', 1, 'https://ror.org/02jqn4a25 Ursinus College'),
(2177, 'https://ror.org/02jqtg033', 'en', 1, 'https://ror.org/02jqtg033 Institute for Energy Technology'),
(2178, 'https://ror.org/02jr6tp70', 'en', 1, 'https://ror.org/02jr6tp70 Azienda Ospedaliera Universitaria Federico II Federico II University Hospital'),
(2179, 'https://ror.org/02js37d36', 'en', 1, 'https://ror.org/02js37d36 IBM Research - Zurich'),
(2180, 'https://ror.org/02jv06474', 'en', 1, 'https://ror.org/02jv06474 Hanseo University'),
(2181, 'https://ror.org/02jvh3a15', 'en', 1, 'https://ror.org/02jvh3a15 Diakonhjemmet Hospital'),
(2182, 'https://ror.org/02jw82j47', 'en', 1, 'https://ror.org/02jw82j47 Kaiser Permanente Fontana Medical Center'),
(2183, 'https://ror.org/02jwg2f21', 'en', 1, 'https://ror.org/02jwg2f21 Hammerfest Hospital Hammerfest Sykehus'),
(2184, 'https://ror.org/02jwvs344', 'en', 1, 'https://ror.org/02jwvs344 Port Moresby General Hospital'),
(2185, 'https://ror.org/02jww9n06', 'en', 1, 'https://ror.org/02jww9n06 Matsuyama Red Cross Hospital 松山赤十字病院'),
(2186, 'https://ror.org/02jxw8995', 'no_lang_code', 1, 'https://ror.org/02jxw8995 Goroka Base Hospital'),
(2187, 'https://ror.org/02jy1hx10', 'en', 1, 'https://ror.org/02jy1hx10 Makati Medical Center'),
(2188, 'https://ror.org/02jygs973', 'en', 1, 'https://ror.org/02jygs973 Changes in Health Care Financing & Organization'),
(2189, 'https://ror.org/02jz99c72', 'en', 1, 'https://ror.org/02jz99c72 Atlantic Health System'),
(2190, 'https://ror.org/02jzt8c33', 'en', 1, 'https://ror.org/02jzt8c33 Children''s Hospital of Winnipeg'),
(2191, 'https://ror.org/02k0t9a94', 'no_lang_code', 1, 'https://ror.org/02k0t9a94 Sankara Nethralaya'),
(2192, 'https://ror.org/02k2v9264', 'es', 1, 'https://ror.org/02k2v9264 Hospital Luis Calvo Mackenna'),
(2193, 'https://ror.org/02k46bn27', 'en', 1, 'https://ror.org/02k46bn27 Pfeiffer University'),
(2194, 'https://ror.org/02k4h0b10', 'en', 1, 'https://ror.org/02k4h0b10 Rajshahi Medical College রাজশাহী মেডিকেল কলেজ'),
(2195, 'https://ror.org/02k4w3g59', 'en', 1, 'https://ror.org/02k4w3g59 Helen Hayes Hospital'),
(2196, 'https://ror.org/02k57ty04', 'de', 1, 'https://ror.org/02k57ty04 Klinikum Lüneburg'),
(2197, 'https://ror.org/02k61s246', 'en', 1, 'https://ror.org/02k61s246 American Society for Cell Biology'),
(2198, 'https://ror.org/02k72jz38', 'no_lang_code', 1, 'https://ror.org/02k72jz38 TagCyx Biotechnologies (Japan)'),
(2199, 'https://ror.org/02k9jrs03', 'en', 1, 'https://ror.org/02k9jrs03 University Children’s Hospital Bern Universitätskinderklinik Bern'),
(2200, 'https://ror.org/02kckde25', 'en', 1, 'https://ror.org/02kckde25 Earl K. Long Medical Center'),
(2201, 'https://ror.org/02kcpr174', 'en', 1, 'https://ror.org/02kcpr174 MRC Human Immunology Unit'),
(2202, 'https://ror.org/02ke5vh78', 'en', 1, 'https://ror.org/02ke5vh78 Tianjin Central Hospital of Gynecology Obstetrics 天津市中心妇产科医院'),
(2203, 'https://ror.org/02kexp407', 'en', 1, 'https://ror.org/02kexp407 Miami Valley Hospital'),
(2204, 'https://ror.org/02kf0fj54', 'no_lang_code', 1, 'https://ror.org/02kf0fj54 AnyGen (South Korea)'),
(2205, 'https://ror.org/02kg81z20', 'en', 1, 'https://ror.org/02kg81z20 Universidad de La Verne University of La Verne'),
(2206, 'https://ror.org/02khfkr46', 'en', 1, 'https://ror.org/02khfkr46 Institute of Electron Technology'),
(2207, 'https://ror.org/02khzxe16', 'pt', 1, 'https://ror.org/02khzxe16 Instituto Superior de Comunicação Empresarial'),
(2208, 'https://ror.org/02kjq0603', 'en', 1, 'https://ror.org/02kjq0603 American Bar Foundation'),
(2209, 'https://ror.org/02kk6xv61', 'en', 1, 'https://ror.org/02kk6xv61 Creative England'),
(2210, 'https://ror.org/02kk9ec90', 'en', 1, 'https://ror.org/02kk9ec90 Organization For Tropical Studies'),
(2211, 'https://ror.org/02kswma64', 'it', 1, 'https://ror.org/02kswma64 Istituto Nazionale per la Fisica della Materia'),
(2212, 'https://ror.org/02kta5139', 'es', 1, 'https://ror.org/02kta5139 Metropolitan Autonomous University Universidad Autónoma Metropolitana'),
(2213, 'https://ror.org/02kwcpg86', 'en', 1, 'https://ror.org/02kwcpg86 Karlstad Central Hospital'),
(2214, 'https://ror.org/02kxeh053', 'no_lang_code', 1, 'https://ror.org/02kxeh053 Veria General Hospital Γενικό Νοσοκομείο Ημαθίας'),
(2215, 'https://ror.org/02kyckx55', 'en', 1, 'https://ror.org/02kyckx55 University of Akron'),
(2216, 'https://ror.org/02kzxd152', 'en', 1, 'https://ror.org/02kzxd152 Medical University Plovdiv Medizinischen Universität Plovdiv Медицински университет - Пловдив'),
(2217, 'https://ror.org/02m0p4y77', 'de', 1, 'https://ror.org/02m0p4y77 Klinikum Südstadt Rostock'),
(2218, 'https://ror.org/02m11x738', 'en', 1, 'https://ror.org/02m11x738 Furtwangen University Hochschule Furtwangen'),
(2219, 'https://ror.org/02m1efx83', 'no_lang_code', 1, 'https://ror.org/02m1efx83 Taconic (United States)'),
(2220, 'https://ror.org/02m4p8096', 'en', 1, 'https://ror.org/02m4p8096 Hochschule Kempten Kempten University of Applied Sciences'),
(2221, 'https://ror.org/02m5e3762', 'no_lang_code', 1, 'https://ror.org/02m5e3762 Dr. Balabhai Nanavati Hospital'),
(2222, 'https://ror.org/02m82p074', 'no_lang_code', 1, 'https://ror.org/02m82p074 Suez Canal University Université du Canal de Suez جامعة قناة السويس'),
(2223, 'https://ror.org/02m9ewz37', 'no_lang_code', 1, 'https://ror.org/02m9ewz37 Sumitomo Hospital 一般財団法人住友病院'),
(2224, 'https://ror.org/02m9pj861', 'pt', 1, 'https://ror.org/02m9pj861 Hospital de Santo António'),
(2225, 'https://ror.org/02maedm12', 'en', 1, 'https://ror.org/02maedm12 Rawalpindi Medical University'),
(2226, 'https://ror.org/02mb9s657', 'en', 1, 'https://ror.org/02mb9s657 Hampden–Sydney College'),
(2227, 'https://ror.org/02mby1820', 'it', 1, 'https://ror.org/02mby1820 Azienda USL di Bologna'),
(2228, 'https://ror.org/02mek6v69', 'fr', 1, 'https://ror.org/02mek6v69 Hôpital Bonnet'),
(2229, 'https://ror.org/02mfapa96', 'en', 1, 'https://ror.org/02mfapa96 Acharya Nagarjuna University ఆచార్య నాగార్జున విశ్వవిద్యాలయం'),
(2230, 'https://ror.org/02mg9y350', 'en', 1, 'https://ror.org/02mg9y350 Winona Medical Cosmetic Center 薇诺娜皮肤医疗美容中心'),
(2231, 'https://ror.org/02mp2av58', 'en', 1, 'https://ror.org/02mp2av58 Universidad de Hawái en Hilo University of Hawaii at Hilo Université d''hawaï à hilo'),
(2232, 'https://ror.org/02mpfs279', 'en', 1, 'https://ror.org/02mpfs279 Daejeon Sun Hospital 대전선병원'),
(2233, 'https://ror.org/02mssnc42', 'no_lang_code', 1, 'https://ror.org/02mssnc42 Nagano Municipal Hospital 長野市民病院'),
(2234, 'https://ror.org/02mtbrk18', 'en', 1, 'https://ror.org/02mtbrk18 Immaculata University'),
(2235, 'https://ror.org/02mvsxw13', 'en', 1, 'https://ror.org/02mvsxw13 Kobe City Nishi-Kobe Medical Center 神戸市立西神戸医療センター'),
(2236, 'https://ror.org/02mx8nz45', 'en', 1, 'https://ror.org/02mx8nz45 Bradley Hospital'),
(2237, 'https://ror.org/02mxfm070', 'en', 1, 'https://ror.org/02mxfm070 St Joseph''s Hospital Health Center'),
(2238, 'https://ror.org/02my3bx32', 'en', 1, 'https://ror.org/02my3bx32 Hubei University of Chinese Medicine 湖北中医药大学'),
(2239, 'https://ror.org/02myg6142', 'en', 1, 'https://ror.org/02myg6142 Maryville University'),
(2240, 'https://ror.org/02n10g966', 'en', 1, 'https://ror.org/02n10g966 Long Beach Animal Hospital'),
(2241, 'https://ror.org/02n1cyj49', 'en', 1, 'https://ror.org/02n1cyj49 AdventHealth Orlando'),
(2242, 'https://ror.org/02n22cc74', 'en', 1, 'https://ror.org/02n22cc74 Koshigaya Municipal Hospital 越谷市立病院'),
(2243, 'https://ror.org/02n2ava60', 'en', 1, 'https://ror.org/02n2ava60 University of New England'),
(2244, 'https://ror.org/02n5cs023', 'en', 1, 'https://ror.org/02n5cs023 Elizabeth City State University'),
(2245, 'https://ror.org/02n73hp60', 'en', 1, 'https://ror.org/02n73hp60 Victoria General Hospital'),
(2246, 'https://ror.org/02nbyhf94', 'no_lang_code', 1, 'https://ror.org/02nbyhf94 Coanda Research and Development Corporation (Canada)'),
(2247, 'https://ror.org/02nckwn80', 'en', 1, 'https://ror.org/02nckwn80 Cheyney University of Pennsylvania Universidad de Cheyney de Pensilvania Université cheyney de pennsylvanie'),
(2248, 'https://ror.org/02ndk3y82', 'en', 1, 'https://ror.org/02ndk3y82 Children''s Medical Center'),
(2249, 'https://ror.org/02nh10f55', 'en', 1, 'https://ror.org/02nh10f55 Evanston Hospital'),
(2250, 'https://ror.org/02npavb70', 'en', 1, 'https://ror.org/02npavb70 Shimane Prefectural Institute of Public Health and Environmental Sciences 島根県保健環境科学研究所'),
(2251, 'https://ror.org/02npppw10', 'no_lang_code', 1, 'https://ror.org/02npppw10 BMT Group (United Kingdom)'),
(2252, 'https://ror.org/02nqy8390', 'en', 1, 'https://ror.org/02nqy8390 Letterman Army Medical Center'),
(2253, 'https://ror.org/02nr3fr97', 'en', 1, 'https://ror.org/02nr3fr97 Center for Biologics Evaluation and Research'),
(2254, 'https://ror.org/02nren818', 'en', 1, 'https://ror.org/02nren818 Chestnut Hill Hospital'),
(2255, 'https://ror.org/02ntgty32', 'en', 1, 'https://ror.org/02ntgty32 Flygtekniska försöksanstalten National Aeronautical Research Institute'),
(2256, 'https://ror.org/02nvt4474', 'es', 1, 'https://ror.org/02nvt4474 Institute for Clinical Efectiveness and Health Policy Instituto de Efectividad Clínica y Sanitaria'),
(2257, 'https://ror.org/02nx5r318', 'en', 1, 'https://ror.org/02nx5r318 College of New Jersey'),
(2258, 'https://ror.org/02nycs597', 'en', 1, 'https://ror.org/02nycs597 Funabashi Municipal Medical Center 船橋市立医療センター'),
(2259, 'https://ror.org/02nyfes25', 'en', 1, 'https://ror.org/02nyfes25 Science Museum of Minnesota'),
(2260, 'https://ror.org/02nzaav06', 'es', 1, 'https://ror.org/02nzaav06 Hospital Luis Vernaza'),
(2261, 'https://ror.org/02p23ar50', 'en', 1, 'https://ror.org/02p23ar50 Kent and Canterbury Hospital'),
(2262, 'https://ror.org/02p47pe37', 'de', 1, 'https://ror.org/02p47pe37 Kaiser-Franz-Josef-Spital'),
(2263, 'https://ror.org/02p599b54', 'en', 1, 'https://ror.org/02p599b54 Treatment Research Institute'),
(2264, 'https://ror.org/02p620w18', 'en', 1, 'https://ror.org/02p620w18 Blood Center of Zhejiang Province 浙江省血液中心'),
(2265, 'https://ror.org/02p6pjw94', 'en', 1, 'https://ror.org/02p6pjw94 Moncton Hospital'),
(2266, 'https://ror.org/02p71fr67', 'en', 1, 'https://ror.org/02p71fr67 Monilek Hospital and Research Center'),
(2267, 'https://ror.org/02p72h367', 'en', 1, 'https://ror.org/02p72h367 University of Cincinnati Medical Center'),
(2268, 'https://ror.org/02p74z057', 'en', 1, 'https://ror.org/02p74z057 K S Hegde Medical Academy'),
(2269, 'https://ror.org/02p9e5v87', 'en', 1, 'https://ror.org/02p9e5v87 Concord Hospital'),
(2270, 'https://ror.org/02paek818', 'en', 1, 'https://ror.org/02paek818 Hutzel Women''s Hospital'),
(2271, 'https://ror.org/02pagex14', 'en', 1, 'https://ror.org/02pagex14 Archimedes Foundation'),
(2272, 'https://ror.org/02pb4g840', 'tr', 1, 'https://ror.org/02pb4g840 Bahriye Merkez Hastanesi, Kasımpaşa Asker Hastanesi'),
(2273, 'https://ror.org/02pb9wz46', 'fr', 1, 'https://ror.org/02pb9wz46 Hôpital Léon Bérard'),
(2274, 'https://ror.org/02pes1a77', 'de', 1, 'https://ror.org/02pes1a77 Krankenhaus der Elisabethinen'),
(2275, 'https://ror.org/02pf50490', 'no_lang_code', 1, 'https://ror.org/02pf50490 Immunomedics (United States)'),
(2276, 'https://ror.org/02pfhv998', 'no_lang_code', 1, 'https://ror.org/02pfhv998 Nongwoo Bio (South Korea)'),
(2277, 'https://ror.org/02pfqts47', 'es', 1, 'https://ror.org/02pfqts47 Hospital Casa de Salud'),
(2278, 'https://ror.org/02pg0e883', 'en', 1, 'https://ror.org/02pg0e883 University of Aizu 会津大学'),
(2279, 'https://ror.org/02pj04690', 'en', 1, 'https://ror.org/02pj04690 Theda Clark Medical Center'),
(2280, 'https://ror.org/02pk13h45', 'en', 1, 'https://ror.org/02pk13h45 St George Hospital'),
(2281, 'https://ror.org/02pkd6e53', 'no_lang_code', 1, 'https://ror.org/02pkd6e53 Deschutes Research'),
(2282, 'https://ror.org/02pp7xn25', 'en', 1, 'https://ror.org/02pp7xn25 Punjab Government Dental College and Hospital'),
(2283, 'https://ror.org/02ptw3r05', 'es', 1, 'https://ror.org/02ptw3r05 Hospital Universitario Son Dureta'),
(2284, 'https://ror.org/02pyp8h55', 'en', 1, 'https://ror.org/02pyp8h55 Lions Gate Hospital'),
(2285, 'https://ror.org/02q0qx558', 'en', 1, 'https://ror.org/02q0qx558 Health Resources Unlimited'),
(2286, 'https://ror.org/02q1nnh04', 'en', 1, 'https://ror.org/02q1nnh04 St. Cloud VA Health Care System'),
(2287, 'https://ror.org/02q291e51', 'no_lang_code', 1, 'https://ror.org/02q291e51 Suncor Energy (Canada)'),
(2288, 'https://ror.org/02q2dn726', 'no_lang_code', 1, 'https://ror.org/02q2dn726 Sinte Gleska University'),
(2289, 'https://ror.org/02q2rtn50', 'no_lang_code', 1, 'https://ror.org/02q2rtn50 Tangam Gaming Inc'),
(2290, 'https://ror.org/02q3bak66', 'en', 1, 'https://ror.org/02q3bak66 Buckinghamshire New University Prifysgol Newydd Swydd Buckingham'),
(2291, 'https://ror.org/02q404g62', 'en', 1, 'https://ror.org/02q404g62 Kaiser Permanente Sacramento Medical Center'),
(2292, 'https://ror.org/02q5gkg61', 'en', 1, 'https://ror.org/02q5gkg61 Henderson State University Université d''État henderson'),
(2293, 'https://ror.org/02q8h2f47', 'fr', 1, 'https://ror.org/02q8h2f47 Institut Technologique Forêt Cellulose Bois-Construction Ameublement'),
(2294, 'https://ror.org/02q8vys74', 'en', 1, 'https://ror.org/02q8vys74 American Institute of Physics'),
(2295, 'https://ror.org/02q97rh88', 'en', 1, 'https://ror.org/02q97rh88 Shotley Bridge Hospital'),
(2296, 'https://ror.org/02qb5a654', 'en', 1, 'https://ror.org/02qb5a654 Somerset Medical Center'),
(2297, 'https://ror.org/02qeh3c90', 'en', 1, 'https://ror.org/02qeh3c90 University of Louisiana at Monroe Université de Louisiane à Monroe'),
(2298, 'https://ror.org/02qeysd40', 'en', 1, 'https://ror.org/02qeysd40 Tacoma Community College'),
(2299, 'https://ror.org/02qnsw591', 'en', 1, 'https://ror.org/02qnsw591 Centre for European Economic Research Zentrum für Europäische Wirtschaftsforschung'),
(2300, 'https://ror.org/02qp2hh41', 'en', 1, 'https://ror.org/02qp2hh41 Walden University'),
(2301, 'https://ror.org/02qqemj91', 'en', 1, 'https://ror.org/02qqemj91 Jaipur Golden Hospital'),
(2302, 'https://ror.org/02qsqdv65', 'no_lang_code', 1, 'https://ror.org/02qsqdv65 Alstom (United Kingdom)'),
(2303, 'https://ror.org/02qv90y91', 'en', 1, 'https://ror.org/02qv90y91 Nagasaki Medical Center 長崎医療センター'),
(2304, 'https://ror.org/02qvqb543', 'no_lang_code', 1, 'https://ror.org/02qvqb543 Aretaeio Hospital'),
(2305, 'https://ror.org/02qx1ae98', 'en', 1, 'https://ror.org/02qx1ae98 First Affiliated Hospital of Xinjiang Medical University 新疆医科大学第一附属医院'),
(2306, 'https://ror.org/02r2pcs39', 'en', 1, 'https://ror.org/02r2pcs39 Polyclinic Medical Center'),
(2307, 'https://ror.org/02r2tq059', 'en', 1, 'https://ror.org/02r2tq059 Saraswati Dental College and Hospital'),
(2308, 'https://ror.org/02r3xg590', 'en', 1, 'https://ror.org/02r3xg590 Kaiser Permanente Vallejo Medical Center'),
(2309, 'https://ror.org/02r4khx44', 'en', 1, 'https://ror.org/02r4khx44 King Hussein Medical Center مدينة الحسين الطبية'),
(2310, 'https://ror.org/02r581p42', 'pt', 1, 'https://ror.org/02r581p42 Hospital de Santa Cruz'),
(2311, 'https://ror.org/02r5cmz65', 'en', 1, 'https://ror.org/02r5cmz65 Babol University of Medical Sciences دانشگاه علوم پزشکی بابل'),
(2312, 'https://ror.org/02ra1fm11', 'no_lang_code', 1, 'https://ror.org/02ra1fm11 Thermal Technologies (United States)'),
(2313, 'https://ror.org/02retg991', 'en', 1, 'https://ror.org/02retg991 University of Jammu जम्मू विश्वविद्यालय'),
(2314, 'https://ror.org/02rfs1804', 'no_lang_code', 1, 'https://ror.org/02rfs1804 Shimada Municipal Hospital 島田市民病院'),
(2315, 'https://ror.org/02rg6ka44', 'en', 1, 'https://ror.org/02rg6ka44 Southwest Bahia State University Universidad Estatal del Sudoeste de Bahía Universidade Estadual do Sudoeste da Bahia'),
(2316, 'https://ror.org/02rg9ze43', 'en', 1, 'https://ror.org/02rg9ze43 Madonna University Université madonna'),
(2317, 'https://ror.org/02rjrn566', 'en', 1, 'https://ror.org/02rjrn566 Nishtar Medical College and Hospital'),
(2318, 'https://ror.org/02rn1w290', 'en', 1, 'https://ror.org/02rn1w290 Princess Mary Maternity Hospital'),
(2319, 'https://ror.org/02rn83489', 'en', 1, 'https://ror.org/02rn83489 Corniche Hospital مستشفى الكورنيش للأمومة'),
(2320, 'https://ror.org/02rnep118', 'en', 1, 'https://ror.org/02rnep118 Queen''s Hospital'),
(2321, 'https://ror.org/02rrbpf42', 'en', 1, 'https://ror.org/02rrbpf42 King Edward Medical University کنگ ایڈورڈ میڈیکل یونیورسٹی'),
(2322, 'https://ror.org/02rsjqy82', 'en', 1, 'https://ror.org/02rsjqy82 Point Loma Nazarene University'),
(2323, 'https://ror.org/02rsydb28', 'en', 1, 'https://ror.org/02rsydb28 Misericordia Community Hospital'),
(2324, 'https://ror.org/02rw2zs46', 'en', 1, 'https://ror.org/02rw2zs46 Bai Jerbai Wadia Hospital for Children'),
(2325, 'https://ror.org/02s0dm484', 'en', 1, 'https://ror.org/02s0dm484 Sunderland Royal Hospital'),
(2326, 'https://ror.org/02s0xcm55', 'it', 1, 'https://ror.org/02s0xcm55 Agency for the Promotion of European Research Agenzia per la Promozione della Ricerca Europea'),
(2327, 'https://ror.org/02s1hvj37', 'en', 1, 'https://ror.org/02s1hvj37 Indiana University South Bend'),
(2328, 'https://ror.org/02s280t43', 'en', 1, 'https://ror.org/02s280t43 New Hanover Regional Medical Center'),
(2329, 'https://ror.org/02s3d7j94', 'en', 1, 'https://ror.org/02s3d7j94 Chang Jung Christian University'),
(2330, 'https://ror.org/02s3xyj47', 'en', 1, 'https://ror.org/02s3xyj47 Qatif Central Hospital مستشفى القطيف المركزي'),
(2331, 'https://ror.org/02s4j2a36', 'en', 1, 'https://ror.org/02s4j2a36 Conquest Hospital'),
(2332, 'https://ror.org/02s4xaf90', 'en', 1, 'https://ror.org/02s4xaf90 Calgary General Hospital'),
(2333, 'https://ror.org/02s5yma07', 'en', 1, 'https://ror.org/02s5yma07 Himachal Pradesh University'),
(2334, 'https://ror.org/02s6h0431', 'it', 1, 'https://ror.org/02s6h0431 Circolo Hospital and Macchi Foundation Ospedale di Circolo e Fondazione Macchi'),
(2335, 'https://ror.org/02s6w8y22', 'en', 1, 'https://ror.org/02s6w8y22 University of Bamako Université de Bamako'),
(2336, 'https://ror.org/02s7c9e98', 'en', 1, 'https://ror.org/02s7c9e98 Fourth Affiliated Hospital of Harbin Medical University 哈尔滨医科大学第四附属医院'),
(2337, 'https://ror.org/02s7et124', 'it', 1, 'https://ror.org/02s7et124 Azienda Ospedaliera Universitaria Senese'),
(2338, 'https://ror.org/02s7fkk92', 'es', 1, 'https://ror.org/02s7fkk92 Hospital Arnau de Vilanova'),
(2339, 'https://ror.org/02s7hnh67', 'en', 1, 'https://ror.org/02s7hnh67 Thammasat University Hospital โรงพยาบาลธรรมศาสตร์เฉลิมพระเกียรติ'),
(2340, 'https://ror.org/02s8jk784', 'en', 1, 'https://ror.org/02s8jk784 PVS Memorial Hospital'),
(2341, 'https://ror.org/02s8znz42', 'fr', 1, 'https://ror.org/02s8znz42 Centre Hospitalier de Mulhouse'),
(2342, 'https://ror.org/02sb3pg33', 'en', 1, 'https://ror.org/02sb3pg33 Kaleida Health'),
(2343, 'https://ror.org/02sc91t34', 'en', 1, 'https://ror.org/02sc91t34 American Association of Geographers'),
(2344, 'https://ror.org/02sehzp52', 'en', 1, 'https://ror.org/02sehzp52 Belarusian State University of Informatics and Radioelectronics Беларускі дзяржаўны ўніверсітэт інфарматыкі і радыёэлектронікі Белорусский государственный университет информатики и радиоэлектроники'),
(2345, 'https://ror.org/02sjmdw37', 'en', 1, 'https://ror.org/02sjmdw37 Western Consortium for Public Health'),
(2346, 'https://ror.org/02sjnfb25', 'en', 1, 'https://ror.org/02sjnfb25 Versiti Blood Center of Wisconsin'),
(2347, 'https://ror.org/02smkcg51', 'tr', 1, 'https://ror.org/02smkcg51 Bakırköy Dr.Sadi Konuk Eğitim ve Araştırma Hastanesi'),
(2348, 'https://ror.org/02smq5q54', 'en', 1, 'https://ror.org/02smq5q54 Birmingham City Hospital'),
(2349, 'https://ror.org/02smsax08', 'pt', 1, 'https://ror.org/02smsax08 Hospital Nossa Senhora da Conceição'),
(2350, 'https://ror.org/02sn5gb64', 'en', 1, 'https://ror.org/02sn5gb64 Toyota Technological Institute at Chicago'),
(2351, 'https://ror.org/02sp1z620', 'en', 1, 'https://ror.org/02sp1z620 Burke Medical Research Institute'),
(2352, 'https://ror.org/02sp8x745', 'en', 1, 'https://ror.org/02sp8x745 Royal Jubilee Hospital'),
(2353, 'https://ror.org/02srrbc50', 'en', 1, 'https://ror.org/02srrbc50 Erzurum Bölge Eğitim ve Araştırma Hastanesi Erzurum Regional Training and Research Hospital'),
(2354, 'https://ror.org/02srt1z47', 'en', 1, 'https://ror.org/02srt1z47 Kansai Electric Power Hospital 関西電力病院'),
(2355, 'https://ror.org/02ss35t63', 'en', 1, 'https://ror.org/02ss35t63 Emerson Hospital'),
(2356, 'https://ror.org/02ssjh827', 'en', 1, 'https://ror.org/02ssjh827 Hôpital National de Niamey National Hospital Niamey'),
(2357, 'https://ror.org/02sttfr93', 'en', 1, 'https://ror.org/02sttfr93 Kyushu Central Hospital of the Mutual Aid Association of Public School Teachers 公立学校共済組合 九州中央病院'),
(2358, 'https://ror.org/02stwhg86', 'en', 1, 'https://ror.org/02stwhg86 St. Charles Medical Center'),
(2359, 'https://ror.org/02stzb903', 'en', 1, 'https://ror.org/02stzb903 Victoria Hospital'),
(2360, 'https://ror.org/02sxmkm79', 'en', 1, 'https://ror.org/02sxmkm79 Mercy Hospital'),
(2361, 'https://ror.org/02sxy6c22', 'no_lang_code', 1, 'https://ror.org/02sxy6c22 Daehang Hospital 대항병원'),
(2362, 'https://ror.org/02syg0q74', 'en', 1, 'https://ror.org/02syg0q74 Hirosaki University 弘前大学'),
(2363, 'https://ror.org/02sz71d65', 'en', 1, 'https://ror.org/02sz71d65 Methodist Hospital'),
(2364, 'https://ror.org/02t0qr014', 'en', 1, 'https://ror.org/02t0qr014 Universidad de Carolina del Norte en Wilmington University of North Carolina Wilmington Université de wilmington'),
(2365, 'https://ror.org/02t36bt26', 'en', 1, 'https://ror.org/02t36bt26 Regional Institute of Medical Sciences'),
(2366, 'https://ror.org/02t3sfp68', 'en', 1, 'https://ror.org/02t3sfp68 Sejong General Hospital 세종 병원'),
(2367, 'https://ror.org/02t4f0726', 'no_lang_code', 1, 'https://ror.org/02t4f0726 Radikal Therapeutics'),
(2368, 'https://ror.org/02t5j9303', 'en', 1, 'https://ror.org/02t5j9303 Lakehead Psychiatric Hospital'),
(2369, 'https://ror.org/02t69m177', 'no_lang_code', 1, 'https://ror.org/02t69m177 Adipogen (South Korea)'),
(2370, 'https://ror.org/02t96cy48', 'it', 1, 'https://ror.org/02t96cy48 Azienda Ospedaliera S.Maria'),
(2371, 'https://ror.org/02tbz8k15', 'no_lang_code', 1, 'https://ror.org/02tbz8k15 University Research Co (United States)'),
(2372, 'https://ror.org/02tc32w13', 'en', 1, 'https://ror.org/02tc32w13 Cumann Ollscoileanna Éireann Irish Universities Association'),
(2373, 'https://ror.org/02tcape08', 'en', 1, 'https://ror.org/02tcape08 Xinjiang Academy of Animal Science 新疆维吾尔自治区畜牧科学院'),
(2374, 'https://ror.org/02tdhvw55', 'tr', 1, 'https://ror.org/02tdhvw55 Fırat Üniversitesi Hastanesi'),
(2375, 'https://ror.org/02tdmfk69', 'en', 1, 'https://ror.org/02tdmfk69 Belfast Health and Social Care Trust'),
(2376, 'https://ror.org/02teamz63', 'en', 1, 'https://ror.org/02teamz63 La Rabida Children''s Hospital'),
(2377, 'https://ror.org/02tj04e91', 'en', 1, 'https://ror.org/02tj04e91 Sydney Children''s Hospital'),
(2378, 'https://ror.org/02tp2kq68', 'it', 1, 'https://ror.org/02tp2kq68 Fondazione Ospedale Salesi'),
(2379, 'https://ror.org/02tpgw303', 'en', 1, 'https://ror.org/02tpgw303 Institute for Systems Biology'),
(2380, 'https://ror.org/02ts7ew79', 'en', 1, 'https://ror.org/02ts7ew79 West Suffolk Hospital'),
(2381, 'https://ror.org/02tse0z86', 'en', 1, 'https://ror.org/02tse0z86 Bryn Mawr Hospital'),
(2382, 'https://ror.org/02tt4fr50', 'no_lang_code', 1, 'https://ror.org/02tt4fr50 Kanto Central Hospital 公立学校共済組合関東中央病院'),
(2383, 'https://ror.org/02tvcev59', 'en', 1, 'https://ror.org/02tvcev59 La Nueva Escuela New School'),
(2384, 'https://ror.org/02tvg0w73', 'en', 1, 'https://ror.org/02tvg0w73 Riverside Research Institute'),
(2385, 'https://ror.org/02tvhd105', 'es', 1, 'https://ror.org/02tvhd105 Clemente Álvarez Emergency Hospital Hospital de Emergencias Dr. Clemente Álvarez'),
(2386, 'https://ror.org/02tvvs825', 'en', 1, 'https://ror.org/02tvvs825 Robinson Memorial Hospital'),
(2387, 'https://ror.org/02twt6343', 'fr', 1, 'https://ror.org/02twt6343 Hôpital Louis-H Lafontaine'),
(2388, 'https://ror.org/02v0be184', 'no_lang_code', 1, 'https://ror.org/02v0be184 Shioda General Hospital 汐田総合病院'),
(2389, 'https://ror.org/02v3sdn51', 'en', 1, 'https://ror.org/02v3sdn51 MRC/CSO Social and Public Health Sciences Unit'),
(2390, 'https://ror.org/02v3txv81', 'en', 1, 'https://ror.org/02v3txv81 Portland VA Medical Center'),
(2391, 'https://ror.org/02v5mzt02', 'en', 1, 'https://ror.org/02v5mzt02 St David''s Medical Center'),
(2392, 'https://ror.org/02v6ptf51', 'no_lang_code', 1, 'https://ror.org/02v6ptf51 Khoula Hospital مستشفى خولة'),
(2393, 'https://ror.org/02v7qv571', 'en', 1, 'https://ror.org/02v7qv571 Santa Clara Valley Medical Center'),
(2394, 'https://ror.org/02v8rz176', 'no_lang_code', 1, 'https://ror.org/02v8rz176 Guru Teg Bahadur Hospital'),
(2395, 'https://ror.org/02vaqnn82', 'en', 1, 'https://ror.org/02vaqnn82 Madras Medical Mission'),
(2396, 'https://ror.org/02vbxt202', 'no_lang_code', 1, 'https://ror.org/02vbxt202 ThyssenKrupp (Germany)'),
(2397, 'https://ror.org/02vdn8424', 'en', 1, 'https://ror.org/02vdn8424 Administration of Occupational Safety and Health Vinnueftirlitið'),
(2398, 'https://ror.org/02vej5573', 'no_lang_code', 1, 'https://ror.org/02vej5573 Estácio (Brazil)'),
(2399, 'https://ror.org/02vfy4r65', 'en', 1, 'https://ror.org/02vfy4r65 Charleston Area Medical Center'),
(2400, 'https://ror.org/02vgb0r89', 'en', 1, 'https://ror.org/02vgb0r89 Kinki Central Hospital 近畿中央病院'),
(2401, 'https://ror.org/02vgs9327', 'en', 1, 'https://ror.org/02vgs9327 Kumamoto University Hospital 熊本大学医学部附属病院'),
(2402, 'https://ror.org/02vhmfv49', 'en', 1, 'https://ror.org/02vhmfv49 United Christian Hospital'),
(2403, 'https://ror.org/02vj1vm13', 'en', 1, 'https://ror.org/02vj1vm13 Zhangzhou Normal University 闽南师范大学'),
(2404, 'https://ror.org/02vjsj444', 'en', 1, 'https://ror.org/02vjsj444 Fort Sanders Regional Medical Center'),
(2405, 'https://ror.org/02vn11j58', 'en', 1, 'https://ror.org/02vn11j58 Ulyanovsk State University Ульяновский государственный университет'),
(2406, 'https://ror.org/02vn5as77', 'nl', 1, 'https://ror.org/02vn5as77 Streekziekenhuis Koningin Beatrix'),
(2407, 'https://ror.org/02vnyaz83', 'en', 1, 'https://ror.org/02vnyaz83 Mills Peninsula Health Services'),
(2408, 'https://ror.org/02vqh3346', 'en', 1, 'https://ror.org/02vqh3346 James Cook University Hospital'),
(2409, 'https://ror.org/02vt4z508', 'en', 1, 'https://ror.org/02vt4z508 Jen-Ai Hospital 仁愛醫療財團法人'),
(2410, 'https://ror.org/02vtd2q19', 'es', 1, 'https://ror.org/02vtd2q19 Hospital Universitario Reina Sofía Reina Sofia Hospital'),
(2411, 'https://ror.org/02vtstx21', 'en', 1, 'https://ror.org/02vtstx21 Allen Hospital'),
(2412, 'https://ror.org/02vvj6403', 'en', 1, 'https://ror.org/02vvj6403 Smolensk University for Humanities Смоленский гуманитарный университет'),
(2413, 'https://ror.org/02vwnat91', 'en', 1, 'https://ror.org/02vwnat91 London South Bank University'),
(2414, 'https://ror.org/02vxh6479', 'no_lang_code', 1, 'https://ror.org/02vxh6479 Fortis Hospital'),
(2415, 'https://ror.org/02vzyrj94', 'en', 1, 'https://ror.org/02vzyrj94 Fairview Southdale Hospital'),
(2416, 'https://ror.org/02w043707', 'en', 1, 'https://ror.org/02w043707 University of Aden جامعة عدن'),
(2417, 'https://ror.org/02w1g0f30', 'en', 1, 'https://ror.org/02w1g0f30 Bashkir State Medical University Башкирский государственный медицинский университет'),
(2418, 'https://ror.org/02w2vzn61', 'en', 1, 'https://ror.org/02w2vzn61 Ruchill Hospital'),
(2419, 'https://ror.org/02w35z347', 'fr', 1, 'https://ror.org/02w35z347 Hôpital Gui de Chauliac'),
(2420, 'https://ror.org/02w3g4478', 'en', 1, 'https://ror.org/02w3g4478 Keller Army Community Hospital'),
(2421, 'https://ror.org/02w3gk008', 'en', 1, 'https://ror.org/02w3gk008 Silla University 신라대학교'),
(2422, 'https://ror.org/02w4p5q74', 'en', 1, 'https://ror.org/02w4p5q74 Assam Medical College অসম চিকিৎসা মহাবিদ্যালয়'),
(2423, 'https://ror.org/02w5pxz31', 'en', 1, 'https://ror.org/02w5pxz31 Assiut University Hospitals'),
(2424, 'https://ror.org/02w8sz675', 'en', 1, 'https://ror.org/02w8sz675 Shriners Hospitals for Children - Tampa'),
(2425, 'https://ror.org/02w8ws377', 'en', 1, 'https://ror.org/02w8ws377 Chung Yuan Christian University'),
(2426, 'https://ror.org/02w95ej18', 'en', 1, 'https://ror.org/02w95ej18 Suita Municipal Hospital 市立吹田市民病院'),
(2427, 'https://ror.org/02wc1yz29', 'en', 1, 'https://ror.org/02wc1yz29 Eye & ENT Hospital of Fudan University'),
(2428, 'https://ror.org/02wcqs336', 'en', 1, 'https://ror.org/02wcqs336 Jerusalem Mental Health Center המרכז לבריאות הנפש ירושלים'),
(2429, 'https://ror.org/02wcweb64', 'en', 1, 'https://ror.org/02wcweb64 Larkin Community Hospital'),
(2430, 'https://ror.org/02wdkng16', 'en', 1, 'https://ror.org/02wdkng16 Catholic Health Association of the United States'),
(2431, 'https://ror.org/02wdp5k87', 'no_lang_code', 1, 'https://ror.org/02wdp5k87 Keskuslaboratorio'),
(2432, 'https://ror.org/02wdwsb32', 'no_lang_code', 1, 'https://ror.org/02wdwsb32 GenVec'),
(2433, 'https://ror.org/02wf9yg07', 'en', 1, 'https://ror.org/02wf9yg07 Chidicon Medical Center'),
(2434, 'https://ror.org/02wg4pk78', 'no_lang_code', 1, 'https://ror.org/02wg4pk78 Produits forestiers Résolu Resolute Forest Products (Canada)'),
(2435, 'https://ror.org/02wgfsz09', 'en', 1, 'https://ror.org/02wgfsz09 Grant Medical Center'),
(2436, 'https://ror.org/02wjcw796', 'en', 1, 'https://ror.org/02wjcw796 Miyake Eye Hospital 眼科三宅病院'),
(2437, 'https://ror.org/02wk1td69', 'pt', 1, 'https://ror.org/02wk1td69 Fundacao Universitaria Jose Bonifacio'),
(2438, 'https://ror.org/02wkcrp04', 'en', 1, 'https://ror.org/02wkcrp04 Mazandaran University of Medical Sciences دانشگاه علوم پزشکی مازندران'),
(2439, 'https://ror.org/02wnfwq15', 'es', 1, 'https://ror.org/02wnfwq15 Hospital General Yagüe'),
(2440, 'https://ror.org/02wpa5731', 'en', 1, 'https://ror.org/02wpa5731 Takatsuki Red Cross Hospital 高槻赤十字病院'),
(2441, 'https://ror.org/02wtdvm35', 'en', 1, 'https://ror.org/02wtdvm35 Saskatchewan Health Authority'),
(2442, 'https://ror.org/02wxcj895', 'en', 1, 'https://ror.org/02wxcj895 Chesterfield Royal Hospital'),
(2443, 'https://ror.org/02wxzt832', 'no_lang_code', 1, 'https://ror.org/02wxzt832 Echelon Biosciences'),
(2444, 'https://ror.org/02x0hgx61', 'fr', 1, 'https://ror.org/02x0hgx61 Hôpital Militaire Moulay Ismail'),
(2445, 'https://ror.org/02x0wmd77', 'en', 1, 'https://ror.org/02x0wmd77 St. John’s Health Sciences Centre'),
(2446, 'https://ror.org/02x1txb82', 'no_lang_code', 1, 'https://ror.org/02x1txb82 Hafez Hospital بیمارستان حافظ'),
(2447, 'https://ror.org/02x1vjk79', 'pt', 1, 'https://ror.org/02x1vjk79 Pontifical Catholic University of Paraná Pontificia Universidad Católica de Paraná Pontifícia Universidade Católica do Paraná Université pontificale catholique du paraná'),
(2448, 'https://ror.org/02x2aj034', 'en', 1, 'https://ror.org/02x2aj034 Millersville University'),
(2449, 'https://ror.org/02x2kaq51', 'en', 1, 'https://ror.org/02x2kaq51 Florida Medical Entomology Laboratory'),
(2450, 'https://ror.org/02x3erj71', 'no_lang_code', 1, 'https://ror.org/02x3erj71 Personal Improvement Computer Systems'),
(2451, 'https://ror.org/02x3skf39', 'en', 1, 'https://ror.org/02x3skf39 Bridgewater State University Université d''État de bridgewater'),
(2452, 'https://ror.org/02x4pnt63', 'pt', 1, 'https://ror.org/02x4pnt63 Hospital Geral de Bonsucesso'),
(2453, 'https://ror.org/02x581406', 'fr', 1, 'https://ror.org/02x581406 Hôpital Pellegrin'),
(2454, 'https://ror.org/02x73b849', 'en', 1, 'https://ror.org/02x73b849 University of Electro-Communications 電気通信大学'),
(2455, 'https://ror.org/02x91aj62', 'en', 1, 'https://ror.org/02x91aj62 Peter the Great St. Petersburg Polytechnic University Санкт-Петербургский политехнический университет Петра Великого'),
(2456, 'https://ror.org/02x9bj444', 'en', 1, 'https://ror.org/02x9bj444 Hampton VA Medical Center'),
(2457, 'https://ror.org/02xa5mk57', 'en', 1, 'https://ror.org/02xa5mk57 Brooklyn Hospital Center'),
(2458, 'https://ror.org/02xag2b27', 'en', 1, 'https://ror.org/02xag2b27 Eastern New Mexico University'),
(2459, 'https://ror.org/02xf0fd83', 'en', 1, 'https://ror.org/02xf0fd83 JSS Medical College and Hospital'),
(2460, 'https://ror.org/02xf7p935', 'en', 1, 'https://ror.org/02xf7p935 Incheon National University 인천대학교'),
(2461, 'https://ror.org/02xgzjz11', 'en', 1, 'https://ror.org/02xgzjz11 Hanil General Hospital 한전병원'),
(2462, 'https://ror.org/02xh9x144', 'en', 1, 'https://ror.org/02xh9x144 University of Prince Edward Island Université de l''Île-du-prince-Édouard'),
(2463, 'https://ror.org/02xj89f04', 'pt', 1, 'https://ror.org/02xj89f04 Universidade Veiga de Almeida'),
(2464, 'https://ror.org/02xkx3e48', 'en', 1, 'https://ror.org/02xkx3e48 Queen Mary Hospital 瑪麗醫院'),
(2465, 'https://ror.org/02xmq6r77', 'en', 1, 'https://ror.org/02xmq6r77 Kibi International University 吉備国際大学'),
(2466, 'https://ror.org/02xp6nt38', 'en', 1, 'https://ror.org/02xp6nt38 Wheeling Hospital'),
(2467, 'https://ror.org/02xpn4676', 'no_lang_code', 1, 'https://ror.org/02xpn4676 Micronet (United States)'),
(2468, 'https://ror.org/02xqze381', 'it', 1, 'https://ror.org/02xqze381 Ospedale San Bassiano'),
(2469, 'https://ror.org/02xtpdq88', 'es', 1, 'https://ror.org/02xtpdq88 Hospital Clínico de la Universidad de Chile'),
(2470, 'https://ror.org/02xxgh713', 'en', 1, 'https://ror.org/02xxgh713 Sisters of Charity Hospital'),
(2471, 'https://ror.org/02xyqwh78', 'no_lang_code', 1, 'https://ror.org/02xyqwh78 FEV (Germany)'),
(2472, 'https://ror.org/02xz2v383', 'en', 1, 'https://ror.org/02xz2v383 National Council of Teachers of Mathematics'),
(2473, 'https://ror.org/02y005z64', 'no_lang_code', 1, 'https://ror.org/02y005z64 Hokkaido hospital 北海道病院'),
(2474, 'https://ror.org/02y041669', 'en', 1, 'https://ror.org/02y041669 Gannon University'),
(2475, 'https://ror.org/02y070a55', 'en', 1, 'https://ror.org/02y070a55 Jackson Memorial Hospital'),
(2476, 'https://ror.org/02y0es528', 'en', 1, 'https://ror.org/02y0es528 George Eliot Hospital NHS Trust'),
(2477, 'https://ror.org/02y0wc381', 'en', 1, 'https://ror.org/02y0wc381 Pravara Institute of Medical Sciences'),
(2478, 'https://ror.org/02y0x4c78', 'en', 1, 'https://ror.org/02y0x4c78 General Leonard Wood Army Community Hospital'),
(2479, 'https://ror.org/02y2htg06', 'en', 1, 'https://ror.org/02y2htg06 Chi Mei Medical Center'),
(2480, 'https://ror.org/02y4qch95', 'en', 1, 'https://ror.org/02y4qch95 Lovelace Medical Center'),
(2481, 'https://ror.org/02y5qtc81', 'pt', 1, 'https://ror.org/02y5qtc81 Hospital Infantil Joana de Gusmão'),
(2482, 'https://ror.org/02y9ayd76', 'en', 1, 'https://ror.org/02y9ayd76 Vokkaligara Sangha Dental College & Hospital'),
(2483, 'https://ror.org/02y9g2b52', 'en', 1, 'https://ror.org/02y9g2b52 Morehouse College'),
(2484, 'https://ror.org/02y9nww90', 'en', 1, 'https://ror.org/02y9nww90 Chuo Kikuu cha Nairobi University of Nairobi'),
(2485, 'https://ror.org/02y9x6z24', 'pt', 1, 'https://ror.org/02y9x6z24 Hospital de São Bernardo'),
(2486, 'https://ror.org/02y9xvd02', 'en', 1, 'https://ror.org/02y9xvd02 Shenyang Medical College 沈阳医学院'),
(2487, 'https://ror.org/02ya5qg51', 'no_lang_code', 1, 'https://ror.org/02ya5qg51 Electrosonics Medical'),
(2488, 'https://ror.org/02yacz525', 'en', 1, 'https://ror.org/02yacz525 Dongzhimen Hospital Affiliated to Beijing University of Chinese Medicine 北京中医药大学东直门医院'),
(2489, 'https://ror.org/02ybb5327', 'es', 1, 'https://ror.org/02ybb5327 Universidad Nacional Experimental Francisco de Miranda'),
(2490, 'https://ror.org/02ybkn114', 'en', 1, 'https://ror.org/02ybkn114 Health Sciences Authority Penguasa Sains Kesihatan'),
(2491, 'https://ror.org/02ybzrf68', 'en', 1, 'https://ror.org/02ybzrf68 Civil Hospital Karachi'),
(2492, 'https://ror.org/02ycvrx49', 'en', 1, 'https://ror.org/02ycvrx49 Program for Appropriate Technology in Health'),
(2493, 'https://ror.org/02ye8a398', 'en', 1, 'https://ror.org/02ye8a398 Keystone Symposia On Molecular and Cellular Biology'),
(2494, 'https://ror.org/02yf2ch17', 'en', 1, 'https://ror.org/02yf2ch17 Carroll University'),
(2495, 'https://ror.org/02yfanq70', 'en', 1, 'https://ror.org/02yfanq70 International Vaccine Institute'),
(2496, 'https://ror.org/02yhdjx59', 'en', 1, 'https://ror.org/02yhdjx59 Interfaith Medical Center'),
(2497, 'https://ror.org/02yhx1447', 'en', 1, 'https://ror.org/02yhx1447 Western Pennsylvania Hospital'),
(2498, 'https://ror.org/02yj55q56', 'en', 1, 'https://ror.org/02yj55q56 Kunsan National University 군산대학교'),
(2499, 'https://ror.org/02yjksy18', 'en', 1, 'https://ror.org/02yjksy18 Princess Anne Hospital'),
(2500, 'https://ror.org/02yjrq169', 'en', 1, 'https://ror.org/02yjrq169 Savannah Technical College'),
(2501, 'https://ror.org/02ynb0474', 'en', 1, 'https://ror.org/02ynb0474 Razi University دانشگاه رازی'),
(2502, 'https://ror.org/02yq6my61', 'en', 1, 'https://ror.org/02yq6my61 Oklahoma Department of Mental Health and Substance Abuse Services'),
(2503, 'https://ror.org/02ysppy04', 'tr', 1, 'https://ror.org/02ysppy04 Kayseri Eğitim ve Araştırma Hastanesi'),
(2504, 'https://ror.org/02yvd4j36', 'en', 1, 'https://ror.org/02yvd4j36 Bundesamt für Strahlenschutz Federal Office for Radiation Protection'),
(2505, 'https://ror.org/02yw7q747', 'en', 1, 'https://ror.org/02yw7q747 Palmetto Health Richland'),
(2506, 'https://ror.org/02yx0mh38', 'en', 1, 'https://ror.org/02yx0mh38 University of Miami Hospital'),
(2507, 'https://ror.org/02yx11005', 'en', 1, 'https://ror.org/02yx11005 Borders General Hospital'),
(2508, 'https://ror.org/02yxyvn23', 'en', 1, 'https://ror.org/02yxyvn23 Mercy Medical Center North Iowa'),
(2509, 'https://ror.org/02yyjwk88', 'no_lang_code', 1, 'https://ror.org/02yyjwk88 Kyowa-kako (Japan)'),
(2510, 'https://ror.org/02yyv4c82', 'no_lang_code', 1, 'https://ror.org/02yyv4c82 Spire Corporation (United States)'),
(2511, 'https://ror.org/02z125451', 'en', 1, 'https://ror.org/02z125451 Zhongshan Hospital of Xiamen University 厦门大学附属中山医院'),
(2512, 'https://ror.org/02z2d6373', 'en', 1, 'https://ror.org/02z2d6373 Yunnan Academy of Agricultural Sciences 云南省农业科学院'),
(2513, 'https://ror.org/02z310y44', 'en', 1, 'https://ror.org/02z310y44 Wheeling Jesuit University'),
(2514, 'https://ror.org/02z58ft15', 'en', 1, 'https://ror.org/02z58ft15 University of Charleston Université de Charleston'),
(2515, 'https://ror.org/02z5bnb65', 'en', 1, 'https://ror.org/02z5bnb65 College of Idaho'),
(2516, 'https://ror.org/02z6cxz02', 'en', 1, 'https://ror.org/02z6cxz02 Warwick Hospital'),
(2517, 'https://ror.org/02z7dnx86', 'en', 1, 'https://ror.org/02z7dnx86 Japanese Red Cross Katsushika Maternity Hospital 日本赤十字社葛飾マタニティ病院'),
(2518, 'https://ror.org/02z7qcb63', 'tr', 1, 'https://ror.org/02z7qcb63 Izmir Bozyaka Eğitim ve Araştırma Hastanesi'),
(2519, 'https://ror.org/02z87mf86', 'en', 1, 'https://ror.org/02z87mf86 Mountain Home VA Healthcare System'),
(2520, 'https://ror.org/02z8mgx68', 'en', 1, 'https://ror.org/02z8mgx68 Exempla Saint Joseph Hospital'),
(2521, 'https://ror.org/02z8t9146', 'en', 1, 'https://ror.org/02z8t9146 Mayo General Hospital'),
(2522, 'https://ror.org/02z9b2w17', 'sv', 1, 'https://ror.org/02z9b2w17 Länssjukhuset Sundsvall-Härnösand'),
(2523, 'https://ror.org/02z9d3e27', 'en', 1, 'https://ror.org/02z9d3e27 Dr. Mohan''s Diabetes Specialities Centre'),
(2524, 'https://ror.org/02z9g9j20', 'en', 1, 'https://ror.org/02z9g9j20 BJC HealthCare'),
(2525, 'https://ror.org/02z9t1k38', 'es', 1, 'https://ror.org/02z9t1k38 Universidad Anáhuac'),
(2526, 'https://ror.org/02zc6c986', 'en', 1, 'https://ror.org/02zc6c986 Bethlem Royal Hospital'),
(2527, 'https://ror.org/02zc85170', 'en', 1, 'https://ror.org/02zc85170 Babol Noshirvani University of Technology دانشگاه صنعتی نوشیروانی بابل'),
(2528, 'https://ror.org/02ze5w302', 'en', 1, 'https://ror.org/02ze5w302 Tufts Children''s Hospital'),
(2529, 'https://ror.org/02zfrea47', 'en', 1, 'https://ror.org/02zfrea47 Nacionalni Inštitut za Javno Zdravje National Institute of Public Health'),
(2530, 'https://ror.org/02zg49d29', 'en', 1, 'https://ror.org/02zg49d29 Leicester General Hospital'),
(2531, 'https://ror.org/02zg69r60', 'en', 1, 'https://ror.org/02zg69r60 Vancouver General Hospital'),
(2532, 'https://ror.org/02zh77j65', 'en', 1, 'https://ror.org/02zh77j65 National Registry of Emergency Medical Technicians'),
(2533, 'https://ror.org/02zha5019', 'en', 1, 'https://ror.org/02zha5019 Beijing Museum of Natural History 北京自然博物馆'),
(2534, 'https://ror.org/02zme4e72', 'no_lang_code', 1, 'https://ror.org/02zme4e72 JEOL (Japan) 日本電子'),
(2535, 'https://ror.org/02zn9x324', 'no_lang_code', 1, 'https://ror.org/02zn9x324 INTRASOFT International (Luxembourg)'),
(2536, 'https://ror.org/02zpc2253', 'it', 1, 'https://ror.org/02zpc2253 Ospedale Santa Maria della Misericordia di Udine'),
(2537, 'https://ror.org/02zrvx577', 'en', 1, 'https://ror.org/02zrvx577 University of Bahr El-Ghazal'),
(2538, 'https://ror.org/02zvkba47', 'en', 1, 'https://ror.org/02zvkba47 National University of Comahue Universidad Nacional del Comahue'),
(2539, 'https://ror.org/02zwb6n98', 'en', 1, 'https://ror.org/02zwb6n98 Hamad Medical Corporation'),
(2540, 'https://ror.org/02zwxrr04', 'en', 1, 'https://ror.org/02zwxrr04 Sharp Grossmont Hospital'),
(2541, 'https://ror.org/02zwyfg51', 'en', 1, 'https://ror.org/02zwyfg51 Virginia Union University'),
(2542, 'https://ror.org/02zy72z44', 'no_lang_code', 1, 'https://ror.org/02zy72z44 Profectus Biosciences (United States)'),
(2543, 'https://ror.org/02zzw8g45', 'en', 1, 'https://ror.org/02zzw8g45 Mayo Clinic Health System'),
(2544, 'https://ror.org/0300pwe30', 'it', 1, 'https://ror.org/0300pwe30 Ospedale San Giovanni Bosco'),
(2545, 'https://ror.org/0300yd604', 'pt', 1, 'https://ror.org/0300yd604 Bahian School of Medicine and Public Health Escola Bahiana de Medicina e Saúde Pública'),
(2546, 'https://ror.org/03025ga79', 'en', 1, 'https://ror.org/03025ga79 AC Camargo Hospital'),
(2547, 'https://ror.org/03032jm09', 'en', 1, 'https://ror.org/03032jm09 Levine Children''s Hospital'),
(2548, 'https://ror.org/0303y7a51', 'en', 1, 'https://ror.org/0303y7a51 Durban University of Technology Inyuvesi yasethekwini yezobuchwepheshe'),
(2549, 'https://ror.org/03044am22', 'en', 1, 'https://ror.org/03044am22 Harrogate District Hospital'),
(2550, 'https://ror.org/0304t8e63', 'pt', 1, 'https://ror.org/0304t8e63 Instituto Superior de Serviço Social do Porto'),
(2551, 'https://ror.org/0305ndp35', 'no_lang_code', 1, 'https://ror.org/0305ndp35 MatTek Corporation (United States)'),
(2552, 'https://ror.org/030637x68', 'en', 1, 'https://ror.org/030637x68 Sussex Eye Hospital'),
(2553, 'https://ror.org/0306jgh11', 'en', 1, 'https://ror.org/0306jgh11 Association of Commonwealth Universities'),
(2554, 'https://ror.org/0306r8m89', 'no_lang_code', 1, 'https://ror.org/0306r8m89 Enerkem (Canada)'),
(2555, 'https://ror.org/0307h0f23', 'en', 1, 'https://ror.org/0307h0f23 Higher Institute of Police Sciences and Homeland Security Instituto Superior de Ciências Policiais e Segurança Interna'),
(2556, 'https://ror.org/030b05n70', 'no_lang_code', 1, 'https://ror.org/030b05n70 123 Certification (Canada)');
INSERT INTO `rors` VALUES
(2557, 'https://ror.org/030e09f60', 'en', 1, 'https://ror.org/030e09f60 First Affiliated Hospital of Fujian Medical University 福建医科大学附属第一医院'),
(2558, 'https://ror.org/030g3hg75', 'en', 1, 'https://ror.org/030g3hg75 Lankenau Institute for Medical Research'),
(2559, 'https://ror.org/030j6qm79', 'en', 1, 'https://ror.org/030j6qm79 Northwick Park Hospital'),
(2560, 'https://ror.org/030jhb479', 'en', 1, 'https://ror.org/030jhb479 Yunnan Nationalities University 云南民族大学'),
(2561, 'https://ror.org/030kaa114', 'en', 1, 'https://ror.org/030kaa114 Alessandro Manzoni Hospital Ospedale Alessandro Manzoni'),
(2562, 'https://ror.org/030m18266', 'en', 1, 'https://ror.org/030m18266 Tatung University 大同大學'),
(2563, 'https://ror.org/030ma0n95', 'en', 1, 'https://ror.org/030ma0n95 Ralph H. Johnson VA Medical Center'),
(2564, 'https://ror.org/030mbcp39', 'en', 1, 'https://ror.org/030mbcp39 Robert Jones and Agnes Hunt Orthopaedic Hospital'),
(2565, 'https://ror.org/030p45079', 'no_lang_code', 1, 'https://ror.org/030p45079 Cleveland Medical Devices'),
(2566, 'https://ror.org/030pk6463', 'no_lang_code', 1, 'https://ror.org/030pk6463 Univax (United States)'),
(2567, 'https://ror.org/030pydv62', 'en', 1, 'https://ror.org/030pydv62 Norfolk State University Université d''État de norfolk'),
(2568, 'https://ror.org/030rm3988', 'en', 1, 'https://ror.org/030rm3988 National Police Hospital 국립경찰병원'),
(2569, 'https://ror.org/030s54078', 'en', 1, 'https://ror.org/030s54078 University of the Philippines Los Baños'),
(2570, 'https://ror.org/030sc3x20', 'en', 1, 'https://ror.org/030sc3x20 First Affiliated Hospital of GuangXi Medical University'),
(2571, 'https://ror.org/030tcms06', 'en', 1, 'https://ror.org/030tcms06 Rocky Mountain Biological Laboratory'),
(2572, 'https://ror.org/030vg1t69', 'en', 1, 'https://ror.org/030vg1t69 Misr International University جامعة مصر الدولية'),
(2573, 'https://ror.org/030wyr187', 'en', 1, 'https://ror.org/030wyr187 Finnish Institute of Occupational Health'),
(2574, 'https://ror.org/0312m2266', 'en', 1, 'https://ror.org/0312m2266 University Hospital of Heraklion'),
(2575, 'https://ror.org/0313f3w77', 'en', 1, 'https://ror.org/0313f3w77 Başkent University Hospital'),
(2576, 'https://ror.org/031699d98', 'en', 1, 'https://ror.org/031699d98 Payame Noor University دانشگاه پیام نور'),
(2577, 'https://ror.org/0317ekv86', 'en', 1, 'https://ror.org/0317ekv86 University of Bahrain جامعة البحرين'),
(2578, 'https://ror.org/0317prg89', 'no_lang_code', 1, 'https://ror.org/0317prg89 Bastyr University'),
(2579, 'https://ror.org/03181bn25', 'en', 1, 'https://ror.org/03181bn25 City College of San Francisco'),
(2580, 'https://ror.org/031b7yx83', 'no_lang_code', 1, 'https://ror.org/031b7yx83 Lucigen Corporation'),
(2581, 'https://ror.org/031bsb921', 'en', 1, 'https://ror.org/031bsb921 University of Mannheim Universität Mannheim'),
(2582, 'https://ror.org/031e6xm45', 'es', 1, 'https://ror.org/031e6xm45 Universidad del Norte'),
(2583, 'https://ror.org/031f8kt38', 'es', 1, 'https://ror.org/031f8kt38 Autonomous University of Hidalgo State Universidad Autónoma del Estado de Hidalgo'),
(2584, 'https://ror.org/031g2ej16', 'no_lang_code', 1, 'https://ror.org/031g2ej16 Dow Chemical (Canada)'),
(2585, 'https://ror.org/031hmx230', 'en', 1, 'https://ror.org/031hmx230 Tokyo Medical University Ibaraki Medical Center 東京医科大学茨城医療センター'),
(2586, 'https://ror.org/031m0eg77', 'en', 1, 'https://ror.org/031m0eg77 Chung Hwa University of Medical Technology 中華醫事科技大學'),
(2587, 'https://ror.org/031maes79', 'en', 1, 'https://ror.org/031maes79 Second Affiliated Hospital of Chengdu University of Traditional Chinese 成都中医药大学'),
(2588, 'https://ror.org/031nbgr73', 'en', 1, 'https://ror.org/031nbgr73 Bedford Hospital NHS Trust'),
(2589, 'https://ror.org/031pw0y55', 'en', 1, 'https://ror.org/031pw0y55 Dakota Wesleyan University'),
(2590, 'https://ror.org/031sxg258', 'no_lang_code', 1, 'https://ror.org/031sxg258 Boehringer Ingelheim (Canada)'),
(2591, 'https://ror.org/031w3f751', 'en', 1, 'https://ror.org/031w3f751 Tulane Medical Center'),
(2592, 'https://ror.org/031wwqy14', 'en', 1, 'https://ror.org/031wwqy14 Sound Shore Medical Center'),
(2593, 'https://ror.org/031xyzp67', 'en', 1, 'https://ror.org/031xyzp67 Social Security Children''s Hospital'),
(2594, 'https://ror.org/031z68d90', 'fr', 1, 'https://ror.org/031z68d90 Institut Universitaire de Gériatrie de Montréal'),
(2595, 'https://ror.org/031zc8d88', 'en', 1, 'https://ror.org/031zc8d88 City Hospital'),
(2596, 'https://ror.org/0321tdt28', 'it', 1, 'https://ror.org/0321tdt28 Ospedale San Giovanni Antica Sede'),
(2597, 'https://ror.org/032298f51', 'it', 1, 'https://ror.org/032298f51 Azienda Ospedaliera Sant''Andrea'),
(2598, 'https://ror.org/0322mf940', 'en', 1, 'https://ror.org/0322mf940 Spartanburg Regional Medical Center'),
(2599, 'https://ror.org/0322p7317', 'en', 1, 'https://ror.org/0322p7317 Kitakyushu Municipal Medical Center 北九州市立医療センター'),
(2600, 'https://ror.org/03237y496', 'en', 1, 'https://ror.org/03237y496 Ahmadu Bello University Teaching Hospital'),
(2601, 'https://ror.org/0327f3359', 'en', 1, 'https://ror.org/0327f3359 Anhui Agricultural University 安徽农业大学'),
(2602, 'https://ror.org/032af5232', 'no_lang_code', 1, 'https://ror.org/032af5232 Gweru Provincial Hospital'),
(2603, 'https://ror.org/032cjfs80', 'en', 1, 'https://ror.org/032cjfs80 Mind Research Network'),
(2604, 'https://ror.org/032d59j24', 'en', 1, 'https://ror.org/032d59j24 Hospital Tan Tock Seng Tan Tock Seng Hospital மருத்துவமனையில்ல் 陈笃生医院'),
(2605, 'https://ror.org/032fk0x53', 'en', 1, 'https://ror.org/032fk0x53 Urmia University دانشگاه ارومیه'),
(2606, 'https://ror.org/032kmqj66', 'en', 1, 'https://ror.org/032kmqj66 Kettering General Hospital'),
(2607, 'https://ror.org/032knn732', 'en', 1, 'https://ror.org/032knn732 Mayville State University'),
(2608, 'https://ror.org/032kth403', 'en', 1, 'https://ror.org/032kth403 Rani Durgavati University'),
(2609, 'https://ror.org/032m4kp77', 'en', 1, 'https://ror.org/032m4kp77 Iowa Department of Public Health'),
(2610, 'https://ror.org/032nh7f71', 'en', 1, 'https://ror.org/032nh7f71 RTI Health Solutions'),
(2611, 'https://ror.org/032p0xe91', 'no', 1, 'https://ror.org/032p0xe91 Privatsykehuset Haugesund'),
(2612, 'https://ror.org/032ppma22', 'en', 1, 'https://ror.org/032ppma22 American Academy of Orthopaedic Surgeons'),
(2613, 'https://ror.org/032q2fe98', 'en', 1, 'https://ror.org/032q2fe98 Michigan State Medical Society'),
(2614, 'https://ror.org/032qfz281', 'en', 1, 'https://ror.org/032qfz281 Kaiser Permanente South San Francisco Medical Center'),
(2615, 'https://ror.org/032x22645', 'en', 1, 'https://ror.org/032x22645 Zhongshan Hospital 中山医院'),
(2616, 'https://ror.org/032xf8h46', 'en', 1, 'https://ror.org/032xf8h46 Kyonggi University 경기대학교'),
(2617, 'https://ror.org/032zc6m47', 'en', 1, 'https://ror.org/032zc6m47 Bronson Methodist Hospital'),
(2618, 'https://ror.org/0331pzy82', 'no_lang_code', 1, 'https://ror.org/0331pzy82 Miyata Eye Hospital 宮田眼科病院'),
(2619, 'https://ror.org/033212v26', 'no_lang_code', 1, 'https://ror.org/033212v26 McPhee Research (United States)'),
(2620, 'https://ror.org/0332k3m42', 'en', 1, 'https://ror.org/0332k3m42 Syracuse VA Medical Center'),
(2621, 'https://ror.org/03364yv75', 'it', 1, 'https://ror.org/03364yv75 Ospedaliera di Piacenza'),
(2622, 'https://ror.org/0336f9q30', 'no_lang_code', 1, 'https://ror.org/0336f9q30 Suez (Canada)'),
(2623, 'https://ror.org/03378k036', 'pt', 1, 'https://ror.org/03378k036 Institute of Higher Studies of Fafe Instituto de Estudos Superiores de Fafe LDA'),
(2624, 'https://ror.org/03384k835', 'en', 1, 'https://ror.org/03384k835 Tokushima Red Cross Hospital 徳島赤十字病院'),
(2625, 'https://ror.org/033dfb770', 'en', 1, 'https://ror.org/033dfb770 Fukuyama Cardiovascular Hospital 福山循環器病院'),
(2626, 'https://ror.org/033gfa640', 'en', 1, 'https://ror.org/033gfa640 Royal Hospital Haslar'),
(2627, 'https://ror.org/033js5093', 'no_lang_code', 1, 'https://ror.org/033js5093 Gunma Saiseikai Maebashi Hospital 群馬県済生会前橋病院'),
(2628, 'https://ror.org/033kc7n58', 'no_lang_code', 1, 'https://ror.org/033kc7n58 Creusot-Loire Entreprises (France)'),
(2629, 'https://ror.org/033t8gt11', 'en', 1, 'https://ror.org/033t8gt11 University of Forestry Лесотехнически университет'),
(2630, 'https://ror.org/033tc5r37', 'en', 1, 'https://ror.org/033tc5r37 Institute of Dermatology & Venereology of the Yunnan Province'),
(2631, 'https://ror.org/033vjpd42', 'en', 1, 'https://ror.org/033vjpd42 Belmont University'),
(2632, 'https://ror.org/033vryh36', 'es', 1, 'https://ror.org/033vryh36 Tekniker'),
(2633, 'https://ror.org/033xwx807', 'it', 1, 'https://ror.org/033xwx807 Policlinico Universitario di Catania'),
(2634, 'https://ror.org/0340t0585', 'en', 1, 'https://ror.org/0340t0585 General Hospital of Shenyang Military Region 中国人民解放军沈阳军区总医院'),
(2635, 'https://ror.org/0340wst14', 'en', 1, 'https://ror.org/0340wst14 Changzhi Medical College 长治医学院'),
(2636, 'https://ror.org/03436rn68', 'en', 1, 'https://ror.org/03436rn68 Wentworth Douglass Hospital'),
(2637, 'https://ror.org/0346ycw92', 'no_lang_code', 1, 'https://ror.org/0346ycw92 Saiseikai Central Hospital 東京都済生会中央病院'),
(2638, 'https://ror.org/034adnw64', 'en', 1, 'https://ror.org/034adnw64 Durham VA Medical Center'),
(2639, 'https://ror.org/034c1gc25', 'en', 1, 'https://ror.org/034c1gc25 Maine Medical Center'),
(2640, 'https://ror.org/034c6s521', 'en', 1, 'https://ror.org/034c6s521 Amarillo VA Health Care System'),
(2641, 'https://ror.org/034dczg46', 'en', 1, 'https://ror.org/034dczg46 Chandka Medical College'),
(2642, 'https://ror.org/034de1n65', 'en', 1, 'https://ror.org/034de1n65 Utah Department of Health'),
(2643, 'https://ror.org/034f0sr31', 'no_lang_code', 1, 'https://ror.org/034f0sr31 NuvOx Pharma (United States)'),
(2644, 'https://ror.org/034fmtr90', 'en', 1, 'https://ror.org/034fmtr90 Empirica. Gesellschaft für Kommunikations- und Technologieforschung empirica - Communication and Technology Research'),
(2645, 'https://ror.org/034pdr896', 'en', 1, 'https://ror.org/034pdr896 Dallas VA Medical Center'),
(2646, 'https://ror.org/034t5cp02', 'en', 1, 'https://ror.org/034t5cp02 North Carolina Division of Public Health'),
(2647, 'https://ror.org/034w83t88', 'tr', 1, 'https://ror.org/034w83t88 Özel Trakya Hastanesi'),
(2648, 'https://ror.org/034xj0q80', 'en', 1, 'https://ror.org/034xj0q80 Orenburg State Medical Academy Оренбургский государственный медицинский университет'),
(2649, 'https://ror.org/034zcbh25', 'tr', 1, 'https://ror.org/034zcbh25 Ergani Devlet Hastanesi'),
(2650, 'https://ror.org/0351yd374', 'en', 1, 'https://ror.org/0351yd374 Shinkyo Hospital'),
(2651, 'https://ror.org/0353kya20', 'pt', 1, 'https://ror.org/0353kya20 Hospital Curry Cabral'),
(2652, 'https://ror.org/0353q6p88', 'en', 1, 'https://ror.org/0353q6p88 Sydney South West Area Health Service'),
(2653, 'https://ror.org/0353zfd89', 'en', 1, 'https://ror.org/0353zfd89 Sultan Qaboos Hospital مستشفى السلطان قابوس'),
(2654, 'https://ror.org/0354m4207', 'no_lang_code', 1, 'https://ror.org/0354m4207 Kinexus Bioinformatics Corporation (Canada)'),
(2655, 'https://ror.org/0356c4a29', 'en', 1, 'https://ror.org/0356c4a29 Läkemedelsverket Medical Products Agency'),
(2656, 'https://ror.org/0357r2107', 'en', 1, 'https://ror.org/0357r2107 Ministry of Health'),
(2657, 'https://ror.org/035a72598', 'en', 1, 'https://ror.org/035a72598 Lincoln Medical Center'),
(2658, 'https://ror.org/035dmz332', 'en', 1, 'https://ror.org/035dmz332 World Health Organization - Australia'),
(2659, 'https://ror.org/035gy9016', 'no_lang_code', 1, 'https://ror.org/035gy9016 Tecnatom (Spain)'),
(2660, 'https://ror.org/035j0tq82', 'no_lang_code', 1, 'https://ror.org/035j0tq82 Orange (France)'),
(2661, 'https://ror.org/035j3m047', 'en', 1, 'https://ror.org/035j3m047 New York Hall of Science'),
(2662, 'https://ror.org/035khf156', 'en', 1, 'https://ror.org/035khf156 Hyogo Social Welfare Corporation 兵庫県立リハビリテーション中央病院'),
(2663, 'https://ror.org/035n3nf68', 'en', 1, 'https://ror.org/035n3nf68 Security Forces Hospital'),
(2664, 'https://ror.org/035p1zc77', 'en', 1, 'https://ror.org/035p1zc77 St John of Jerusalem Eye Hospital Group'),
(2665, 'https://ror.org/035rhx828', 'en', 1, 'https://ror.org/035rhx828 Kunming University 昆明学院'),
(2666, 'https://ror.org/035t17984', 'en', 1, 'https://ror.org/035t17984 Beijing Jishuitan Hospital 北京市创伤骨科研究所'),
(2667, 'https://ror.org/035vb3h42', 'en', 1, 'https://ror.org/035vb3h42 Kinderspital Zürich University Children''s Hospital Zurich'),
(2668, 'https://ror.org/035xbsb93', 'en', 1, 'https://ror.org/035xbsb93 Al-Sabah Hospital'),
(2669, 'https://ror.org/035xhk118', 'en', 1, 'https://ror.org/035xhk118 Audie L. Murphy Memorial VA Hospital'),
(2670, 'https://ror.org/035y9xj66', 'en', 1, 'https://ror.org/035y9xj66 Consortium For Mathematics & Its Applications'),
(2671, 'https://ror.org/035z2ew45', 'en', 1, 'https://ror.org/035z2ew45 Eastern Illinois University Université de l''illinois de l''est'),
(2672, 'https://ror.org/035z6xf33', 'en', 1, 'https://ror.org/035z6xf33 Oklahoma Medical Research Foundation'),
(2673, 'https://ror.org/0360cq027', 'en', 1, 'https://ror.org/0360cq027 LDS Hospital'),
(2674, 'https://ror.org/0362za439', 'en', 1, 'https://ror.org/0362za439 Ministry of Health'),
(2675, 'https://ror.org/03645mz20', 'nl', 1, 'https://ror.org/03645mz20 Stichting Technasium'),
(2676, 'https://ror.org/0364a8z71', 'tr', 1, 'https://ror.org/0364a8z71 Denizli Devlet Hastanesi Denizli State Hospital'),
(2677, 'https://ror.org/03661z977', 'no_lang_code', 1, 'https://ror.org/03661z977 HEF Groupe (France)'),
(2678, 'https://ror.org/0367d2222', 'en', 1, 'https://ror.org/0367d2222 Tao Yuan General Hospital 桃園醫院'),
(2679, 'https://ror.org/0367njg58', 'en', 1, 'https://ror.org/0367njg58 East Central University'),
(2680, 'https://ror.org/0367sye10', 'nl', 1, 'https://ror.org/0367sye10 Atrium Medisch Centrum Parkstad'),
(2681, 'https://ror.org/0368s4g32', 'en', 1, 'https://ror.org/0368s4g32 China Medical University Hospital'),
(2682, 'https://ror.org/0369pvp92', 'no_lang_code', 1, 'https://ror.org/0369pvp92 Nanchang Hangkong University 南昌航空大学'),
(2683, 'https://ror.org/0369st156', 'en', 1, 'https://ror.org/0369st156 Slippery Rock University'),
(2684, 'https://ror.org/036a0e562', 'en', 1, 'https://ror.org/036a0e562 Baltimore VA Medical Center'),
(2685, 'https://ror.org/036c27j91', 'en', 1, 'https://ror.org/036c27j91 Washington University Medical Center'),
(2686, 'https://ror.org/036c3t778', 'en', 1, 'https://ror.org/036c3t778 Niigata Prefectural Museum of History 新潟県立歴史博物館'),
(2687, 'https://ror.org/036dess41', 'pt', 1, 'https://ror.org/036dess41 Hospital do Desterro'),
(2688, 'https://ror.org/036dkm174', 'es', 1, 'https://ror.org/036dkm174 Hospital Santa Caterina'),
(2689, 'https://ror.org/036mbxj57', 'en', 1, 'https://ror.org/036mbxj57 Banff Mineral Springs Hospital'),
(2690, 'https://ror.org/036njfn21', 'en', 1, 'https://ror.org/036njfn21 Ministry of Health'),
(2691, 'https://ror.org/036nxkh98', 'en', 1, 'https://ror.org/036nxkh98 Carilion Roanoke Memorial Hospital'),
(2692, 'https://ror.org/036qtaj98', 'en', 1, 'https://ror.org/036qtaj98 Greenwich Hospital'),
(2693, 'https://ror.org/036s9kg65', 'en', 1, 'https://ror.org/036s9kg65 Monash Medical Centre'),
(2694, 'https://ror.org/036sak533', 'en', 1, 'https://ror.org/036sak533 Southern Arkansas University'),
(2695, 'https://ror.org/036sdak78', 'en', 1, 'https://ror.org/036sdak78 Educational Commission for Foreign Medical Graduates'),
(2696, 'https://ror.org/036wxg427', 'no_lang_code', 1, 'https://ror.org/036wxg427 Jordan Hospital مستشفى الأردن'),
(2697, 'https://ror.org/036yvre49', 'en', 1, 'https://ror.org/036yvre49 Kemerovo State University Кемеровский государственный университет'),
(2698, 'https://ror.org/03720tm64', 'pt', 1, 'https://ror.org/03720tm64 Fundação Ricardo do Espírito Santo Silva'),
(2699, 'https://ror.org/0372t5741', 'en', 1, 'https://ror.org/0372t5741 Gifu Pharmaceutical University 岐阜薬科大学'),
(2700, 'https://ror.org/0373nm262', 'en', 1, 'https://ror.org/0373nm262 Kongju National University 공주대학교'),
(2701, 'https://ror.org/03763ep67', 'en', 1, 'https://ror.org/03763ep67 Children''s Hospital of Pittsburgh'),
(2702, 'https://ror.org/0376mc966', 'en', 1, 'https://ror.org/0376mc966 Haskell Indian Nations University'),
(2703, 'https://ror.org/0376myh60', 'pt', 1, 'https://ror.org/0376myh60 Catholic University of Pelotas Universidade Católica de Pelotas'),
(2704, 'https://ror.org/0376vhj74', 'en', 1, 'https://ror.org/0376vhj74 Lewis University'),
(2705, 'https://ror.org/037767x92', 'en', 1, 'https://ror.org/037767x92 Himeji Medical Center 独立行政法人 国立病院機構 姫路医療センター'),
(2706, 'https://ror.org/0378e9394', 'no_lang_code', 1, 'https://ror.org/0378e9394 Saitama Municipal Hospital さいたま市立病院'),
(2707, 'https://ror.org/0378zg266', 'en', 1, 'https://ror.org/0378zg266 Nyack Hospital'),
(2708, 'https://ror.org/037a76178', 'en', 1, 'https://ror.org/037a76178 Handa City Hospital 半田市立半田病院'),
(2709, 'https://ror.org/037d0vf92', 'en', 1, 'https://ror.org/037d0vf92 Nizhny Novgorod State Technical University Нижегородский государственный технический университет'),
(2710, 'https://ror.org/037dvnz29', 'en', 1, 'https://ror.org/037dvnz29 Shriners Hospitals for Children - Houston'),
(2711, 'https://ror.org/037f4ry86', 'en', 1, 'https://ror.org/037f4ry86 Regional West Medical Center'),
(2712, 'https://ror.org/037m3rm63', 'en', 1, 'https://ror.org/037m3rm63 Japanese Red Cross Asahikawa Hospital 旭川赤十字病院'),
(2713, 'https://ror.org/037m6e306', 'no_lang_code', 1, 'https://ror.org/037m6e306 Pera (United Kingdom)'),
(2714, 'https://ror.org/037mpqg03', 'no_lang_code', 1, 'https://ror.org/037mpqg03 Xstrata (United Kingdom)'),
(2715, 'https://ror.org/037nakk48', 'no_lang_code', 1, 'https://ror.org/037nakk48 Pinnacle Technology'),
(2716, 'https://ror.org/037pmhh38', 'no_lang_code', 1, 'https://ror.org/037pmhh38 Physical Optics Corporation'),
(2717, 'https://ror.org/037r57b62', 'en', 1, 'https://ror.org/037r57b62 Buddhist Tzu Chi General Hospital'),
(2718, 'https://ror.org/037rt4a55', 'en', 1, 'https://ror.org/037rt4a55 National Academy of Agricultural Science 국립농업과학원'),
(2719, 'https://ror.org/037s3ck33', 'en', 1, 'https://ror.org/037s3ck33 Shatin Hospital 沙田醫院'),
(2720, 'https://ror.org/037s71n47', 'en', 1, 'https://ror.org/037s71n47 Imelda Hospital Imelda ziekenhuis'),
(2721, 'https://ror.org/037v8w471', 'en', 1, 'https://ror.org/037v8w471 Memorial Hermann Institute for Rehabilitation and Research Foundation'),
(2722, 'https://ror.org/037wegn60', 'en', 1, 'https://ror.org/037wegn60 University of the District of Columbia Université du district de columbia'),
(2723, 'https://ror.org/037wq4b75', 'de', 1, 'https://ror.org/037wq4b75 Klinikum Ludwigshafen'),
(2724, 'https://ror.org/037x4vd23', 'en', 1, 'https://ror.org/037x4vd23 Teaching Hospital Kandy මහනුවර ශික්ෂණ රෝහල'),
(2725, 'https://ror.org/037y13578', 'en', 1, 'https://ror.org/037y13578 West Park Healthcare Centre'),
(2726, 'https://ror.org/037y5zq83', 'en', 1, 'https://ror.org/037y5zq83 Kolding Hospital'),
(2727, 'https://ror.org/037ybm139', 'en', 1, 'https://ror.org/037ybm139 Baptist Medical Center Jacksonville'),
(2728, 'https://ror.org/037yff262', 'no_lang_code', 1, 'https://ror.org/037yff262 Tokyo Metropolitan Matsuzawa Hospital 東京都立松沢病院'),
(2729, 'https://ror.org/037ze7373', 'tr', 1, 'https://ror.org/037ze7373 Etlik Zübeyde Hanım Kadın Hastalıkları Eğitim ve Araştırma Hastanesi'),
(2730, 'https://ror.org/0380w8h49', 'en', 1, 'https://ror.org/0380w8h49 Ealing Hospital NHS Trust'),
(2731, 'https://ror.org/038152964', 'es', 1, 'https://ror.org/038152964 Hospital Riotinto'),
(2732, 'https://ror.org/0382k6j58', 'en', 1, 'https://ror.org/0382k6j58 Nambu University'),
(2733, 'https://ror.org/0382m3r69', 'en', 1, 'https://ror.org/0382m3r69 Dr Gray''s Hospital'),
(2734, 'https://ror.org/038321296', 'en', 1, 'https://ror.org/038321296 Gladstone Institutes'),
(2735, 'https://ror.org/0384ghs60', 'en', 1, 'https://ror.org/0384ghs60 National Center for Drug Screening 国家新药筛选中心'),
(2736, 'https://ror.org/0389fv189', 'en', 1, 'https://ror.org/0389fv189 Guangxi Maternal and Child Health Hospital 广西妇幼保健院'),
(2737, 'https://ror.org/0389pw608', 'en', 1, 'https://ror.org/0389pw608 Center for High Pressure Science and Technology Advanced Research 北京高压科学研究中心'),
(2738, 'https://ror.org/0389pzc90', 'en', 1, 'https://ror.org/0389pzc90 Altai State Technical University Алтайский государственный технический университет имени И. И. Ползунова'),
(2739, 'https://ror.org/038bgk418', 'en', 1, 'https://ror.org/038bgk418 Okayama Prefectural University 岡山県立大学'),
(2740, 'https://ror.org/038c5sp60', 'en', 1, 'https://ror.org/038c5sp60 Poudre Valley Hospital'),
(2741, 'https://ror.org/038ckz871', 'no_lang_code', 1, 'https://ror.org/038ckz871 Kaneka (Japan) 株式会社カネカ'),
(2742, 'https://ror.org/038cpkc46', 'en', 1, 'https://ror.org/038cpkc46 Northrop University'),
(2743, 'https://ror.org/038d10y34', 'en', 1, 'https://ror.org/038d10y34 National Wildlife Health Center'),
(2744, 'https://ror.org/038e9x269', 'no_lang_code', 1, 'https://ror.org/038e9x269 Kumaun University कुमाऊँ विश्वविद्यालय குமாவுன் பல்கலைக்கழகம்'),
(2745, 'https://ror.org/038estk42', 'en', 1, 'https://ror.org/038estk42 Shinmatsudo Central General Hospital 新松戸中央総合病院'),
(2746, 'https://ror.org/038fqcc39', 'en', 1, 'https://ror.org/038fqcc39 UPMC Hamot'),
(2747, 'https://ror.org/038ftrz90', 'en', 1, 'https://ror.org/038ftrz90 Western Attica General Hospital'),
(2748, 'https://ror.org/038fwcw54', 'en', 1, 'https://ror.org/038fwcw54 National Satellite Ocean Application Service 国家卫星海洋应用中心'),
(2749, 'https://ror.org/038h97h67', 'tr', 1, 'https://ror.org/038h97h67 Izmir Tepecik Eğitim ve Araştırma Hastanesi'),
(2750, 'https://ror.org/038j9sn30', 'en', 1, 'https://ror.org/038j9sn30 Shanghai Institute of Hypertension'),
(2751, 'https://ror.org/038jxf238', 'en', 1, 'https://ror.org/038jxf238 Natividad Medical Center'),
(2752, 'https://ror.org/038mfx688', 'en', 1, 'https://ror.org/038mfx688 National Academy of Sciences'),
(2753, 'https://ror.org/038mzt421', 'no_lang_code', 1, 'https://ror.org/038mzt421 Nerviano Medical Sciences'),
(2754, 'https://ror.org/038nb9c73', 'en', 1, 'https://ror.org/038nb9c73 Olivet Nazarene University'),
(2755, 'https://ror.org/038qbqz41', 'en', 1, 'https://ror.org/038qbqz41 Lovelace Respiratory Research Institute'),
(2756, 'https://ror.org/038rhxb62', 'no_lang_code', 1, 'https://ror.org/038rhxb62 IM Systems (United States)'),
(2757, 'https://ror.org/038v5dr76', 'en', 1, 'https://ror.org/038v5dr76 Rapid City Regional Hospital'),
(2758, 'https://ror.org/038vg5g56', 'en', 1, 'https://ror.org/038vg5g56 Delaware County Memorial Hospital'),
(2759, 'https://ror.org/038x2fh14', 'en', 1, 'https://ror.org/038x2fh14 Charles R. Drew University of Medicine and Science'),
(2760, 'https://ror.org/038ygd080', 'en', 1, 'https://ror.org/038ygd080 Inner Mongolia Medical College Hospital 内蒙古医科大学附属医院'),
(2761, 'https://ror.org/038yw9848', 'en', 1, 'https://ror.org/038yw9848 Kaiser Permanente Santa Clara Medical Center'),
(2762, 'https://ror.org/038zf2n28', 'en', 1, 'https://ror.org/038zf2n28 Youngstown State University'),
(2763, 'https://ror.org/0393ghj09', 'no_lang_code', 1, 'https://ror.org/0393ghj09 Habib hospital Thameur'),
(2764, 'https://ror.org/03950pc16', 'en', 1, 'https://ror.org/03950pc16 Allergy and Asthma Medical Group and Research Center'),
(2765, 'https://ror.org/03964hc96', 'en', 1, 'https://ror.org/03964hc96 Borgess Medical Center'),
(2766, 'https://ror.org/0396v4y86', 'fr', 1, 'https://ror.org/0396v4y86 Hôpital Louis Pradel'),
(2767, 'https://ror.org/039713658', 'en', 1, 'https://ror.org/039713658 First Affiliated Hospital of Chinese PLA General Hospital 中国人民解放军总医院第一附属医院'),
(2768, 'https://ror.org/0397tsa92', 'en', 1, 'https://ror.org/0397tsa92 Clark Atlanta University'),
(2769, 'https://ror.org/0398yj006', 'es', 1, 'https://ror.org/0398yj006 Hospital Muñiz, Hospital de Infecciosas “Dr. Francisco Javier Muñiz"'),
(2770, 'https://ror.org/039ajs610', 'no_lang_code', 1, 'https://ror.org/039ajs610 Weyerhauser (Canada)'),
(2771, 'https://ror.org/039bxh911', 'it', 1, 'https://ror.org/039bxh911 Ospedale Infermi di Rimini'),
(2772, 'https://ror.org/039c6rk82', 'en', 1, 'https://ror.org/039c6rk82 Ninewells Hospital'),
(2773, 'https://ror.org/039cbw303', 'no_lang_code', 1, 'https://ror.org/039cbw303 Dhaka Shishu Hospital'),
(2774, 'https://ror.org/039dmez53', 'en', 1, 'https://ror.org/039dmez53 LeMoyne–Owen College'),
(2775, 'https://ror.org/039efr729', 'pt', 1, 'https://ror.org/039efr729 Instituto Português de Administração de Marketing'),
(2776, 'https://ror.org/039evc422', 'en', 1, 'https://ror.org/039evc422 Municipal Institute for Medical Research'),
(2777, 'https://ror.org/039f7g519', 'en', 1, 'https://ror.org/039f7g519 Springfield Technical Community College'),
(2778, 'https://ror.org/039k9pj72', 'en', 1, 'https://ror.org/039k9pj72 T. D. Medical College'),
(2779, 'https://ror.org/039nw9e11', 'en', 1, 'https://ror.org/039nw9e11 Third Affiliated Hospital of Zhengzhou University 郑州大学第三附属医院'),
(2780, 'https://ror.org/039p7ck60', 'en', 1, 'https://ror.org/039p7ck60 Dongduk Women''s University 동덕여자대학교'),
(2781, 'https://ror.org/039q00p63', 'en', 1, 'https://ror.org/039q00p63 Edward Francis Small Teaching Hospital'),
(2782, 'https://ror.org/039se3q37', 'en', 1, 'https://ror.org/039se3q37 County Hospital'),
(2783, 'https://ror.org/039thcs93', 'en', 1, 'https://ror.org/039thcs93 Sri Venkateswara Institute of Medical Sciences'),
(2784, 'https://ror.org/039tm4h11', 'en', 1, 'https://ror.org/039tm4h11 Sree Balaji Dental College and Hospital'),
(2785, 'https://ror.org/039tzxh97', 'en', 1, 'https://ror.org/039tzxh97 Queen Elizabeth the Queen Mother Hospital'),
(2786, 'https://ror.org/039xdnp48', 'no_lang_code', 1, 'https://ror.org/039xdnp48 Takano Hospital 高野病院'),
(2787, 'https://ror.org/039xw7n32', 'en', 1, 'https://ror.org/039xw7n32 Istituto Universitario di Studi Europei University Institute of European Studies'),
(2788, 'https://ror.org/039ygjf22', 'en', 1, 'https://ror.org/039ygjf22 Jikei University School of Medicine 東京慈恵会医科大学'),
(2789, 'https://ror.org/039zd5s34', 'en', 1, 'https://ror.org/039zd5s34 Integral University Université intégrale de lucknow इंटीग्रल विश्वविद्यालय'),
(2790, 'https://ror.org/03a1gte98', 'en', 1, 'https://ror.org/03a1gte98 Agence spatiale canadienne Canadian Space Agency'),
(2791, 'https://ror.org/03a1rt493', 'en', 1, 'https://ror.org/03a1rt493 Kätilöopisto Maternity Hospital'),
(2792, 'https://ror.org/03a23ch04', 'en', 1, 'https://ror.org/03a23ch04 Health Protection Surveillance Centre Lárionad Faire um Chosaint Sláinte'),
(2793, 'https://ror.org/03a2szg51', 'no_lang_code', 1, 'https://ror.org/03a2szg51 Saiseikai Utsunomiya hospital 済生会宇都宮病院'),
(2794, 'https://ror.org/03a3qwm26', 'en', 1, 'https://ror.org/03a3qwm26 Augustana University'),
(2795, 'https://ror.org/03a4d7t12', 'en', 1, 'https://ror.org/03a4d7t12 Saitama Cancer Center 埼玉県立がんセンター'),
(2796, 'https://ror.org/03a4vma36', 'en', 1, 'https://ror.org/03a4vma36 Queensborough Community College, CUNY'),
(2797, 'https://ror.org/03a6a0a65', 'pt', 1, 'https://ror.org/03a6a0a65 Universidade do Oeste de Santa Catarina'),
(2798, 'https://ror.org/03a6zw892', 'en', 1, 'https://ror.org/03a6zw892 Lurie Children''s Hospital'),
(2799, 'https://ror.org/03a8gac78', 'es', 1, 'https://ror.org/03a8gac78 Hospital Del Mar'),
(2800, 'https://ror.org/03aam9155', 'en', 1, 'https://ror.org/03aam9155 KLE University'),
(2801, 'https://ror.org/03ac64295', 'en', 1, 'https://ror.org/03ac64295 American Society For Engineering Education'),
(2802, 'https://ror.org/03acrxj66', 'en', 1, 'https://ror.org/03acrxj66 North Memorial Health Care'),
(2803, 'https://ror.org/03ag59v15', 'pt', 1, 'https://ror.org/03ag59v15 Universidade Estadual de Ciências da Saúde de Alagoas'),
(2804, 'https://ror.org/03ag5ed62', 'no_lang_code', 1, 'https://ror.org/03ag5ed62 Allied Technology (United States)'),
(2805, 'https://ror.org/03am3jt82', 'sv', 1, 'https://ror.org/03am3jt82 Helsingborgs lasarett'),
(2806, 'https://ror.org/03andr831', 'en', 1, 'https://ror.org/03andr831 Christian Brothers University'),
(2807, 'https://ror.org/03ap6wx93', 'en', 1, 'https://ror.org/03ap6wx93 Queen''s Medical Centre'),
(2808, 'https://ror.org/03apjks92', 'en', 1, 'https://ror.org/03apjks92 Martin Luther King, Jr. Multi-Service Ambulatory Care Center'),
(2809, 'https://ror.org/03atxgt72', 'en', 1, 'https://ror.org/03atxgt72 Coney Island Hospital'),
(2810, 'https://ror.org/03awtex73', 'no_lang_code', 1, 'https://ror.org/03awtex73 Arup Group (United States)'),
(2811, 'https://ror.org/03ay8b853', 'en', 1, 'https://ror.org/03ay8b853 Police General Hospital โรงพยาบาลตำรวจ'),
(2812, 'https://ror.org/03ayf0c60', 'en', 1, 'https://ror.org/03ayf0c60 Kagawa Nutrition University 女子栄養大学'),
(2813, 'https://ror.org/03b2b5383', 'en', 1, 'https://ror.org/03b2b5383 Diana Princess of Wales Hospital'),
(2814, 'https://ror.org/03b353k89', 'en', 1, 'https://ror.org/03b353k89 Saint Michael''s College'),
(2815, 'https://ror.org/03b3qq257', 'es', 1, 'https://ror.org/03b3qq257 Hospital Padre Hurtado'),
(2816, 'https://ror.org/03b48gv34', 'en', 1, 'https://ror.org/03b48gv34 University of Mary Washington Université de mary washington'),
(2817, 'https://ror.org/03b5q4637', 'en', 1, 'https://ror.org/03b5q4637 Educational Testing Service'),
(2818, 'https://ror.org/03b6sp482', 'en', 1, 'https://ror.org/03b6sp482 Southern University System'),
(2819, 'https://ror.org/03b705z14', 'es', 1, 'https://ror.org/03b705z14 Hospital Vargas'),
(2820, 'https://ror.org/03b7nc883', 'en', 1, 'https://ror.org/03b7nc883 Colmery-O''Neil VA Medical Center'),
(2821, 'https://ror.org/03b982x90', 'en', 1, 'https://ror.org/03b982x90 Post Graduate Medical Institute'),
(2822, 'https://ror.org/03bag5a72', 'en', 1, 'https://ror.org/03bag5a72 Ladoke Akintola University of Technology Teaching Hospital'),
(2823, 'https://ror.org/03bahkk91', 'en', 1, 'https://ror.org/03bahkk91 Arkansas Tech University'),
(2824, 'https://ror.org/03bfp2076', 'en', 1, 'https://ror.org/03bfp2076 Beckman Laser Institute and Medical Clinic'),
(2825, 'https://ror.org/03bg2rq25', 'en', 1, 'https://ror.org/03bg2rq25 American Public Health Association'),
(2826, 'https://ror.org/03bg65591', 'en', 1, 'https://ror.org/03bg65591 Susquehanna Health'),
(2827, 'https://ror.org/03bj8zh59', 'no_lang_code', 1, 'https://ror.org/03bj8zh59 Tata Steel (United Kingdom)'),
(2828, 'https://ror.org/03bpc5f92', 'en', 1, 'https://ror.org/03bpc5f92 Institute for Medical Research'),
(2829, 'https://ror.org/03bq2c460', 'no_lang_code', 1, 'https://ror.org/03bq2c460 Barrick Gold (Canada)'),
(2830, 'https://ror.org/03bqt8z64', 'no_lang_code', 1, 'https://ror.org/03bqt8z64 National Institute of Technology'),
(2831, 'https://ror.org/03bs2yy11', 'en', 1, 'https://ror.org/03bs2yy11 Queen Victoria Hospital NHS Foundation Trust'),
(2832, 'https://ror.org/03btaj690', 'no_lang_code', 1, 'https://ror.org/03btaj690 Numazu City Hospital 沼津市立病院'),
(2833, 'https://ror.org/03btpnr35', 'en', 1, 'https://ror.org/03btpnr35 Shaukat Khanum Memorial Cancer Hospital and Research Center شوکت خانم یادگاری سرطان شفاخانہ اور مرکز تحقیق'),
(2834, 'https://ror.org/03bvvnt49', 'en', 1, 'https://ror.org/03bvvnt49 National Taiwan Ocean University'),
(2835, 'https://ror.org/03bvx5w91', 'it', 1, 'https://ror.org/03bvx5w91 Fondazione Eni Enrico Mattei'),
(2836, 'https://ror.org/03bwf4y78', 'sk', 1, 'https://ror.org/03bwf4y78 Slovak National Library Slovenska Narodna Kniznica, Slovenská národná knižnica'),
(2837, 'https://ror.org/03bwzch55', 'en', 1, 'https://ror.org/03bwzch55 Kyushu Dental University 九州歯科大学'),
(2838, 'https://ror.org/03bx60s49', 'en', 1, 'https://ror.org/03bx60s49 Cancer Prevention Institute of California'),
(2839, 'https://ror.org/03byx8t68', 'en', 1, 'https://ror.org/03byx8t68 Clarke University'),
(2840, 'https://ror.org/03bzbh797', 'en', 1, 'https://ror.org/03bzbh797 UPMC Montefiore'),
(2841, 'https://ror.org/03bzz8q98', 'en', 1, 'https://ror.org/03bzz8q98 175th Hospital of People''s Liberation Army 解放军第175医院'),
(2842, 'https://ror.org/03c23hy31', 'no_lang_code', 1, 'https://ror.org/03c23hy31 One Cell Systems (United States)'),
(2843, 'https://ror.org/03c266r37', 'en', 1, 'https://ror.org/03c266r37 Gifu Prefectural General Medical Center 岐阜県総合医療センター'),
(2844, 'https://ror.org/03c3d1v10', 'en', 1, 'https://ror.org/03c3d1v10 General University Hospital of Patras'),
(2845, 'https://ror.org/03c622h45', 'en', 1, 'https://ror.org/03c622h45 National Academy for State Health Policy'),
(2846, 'https://ror.org/03c648b36', 'en', 1, 'https://ror.org/03c648b36 Ehime Prefectural Central Hospital 愛媛県立中央病院'),
(2847, 'https://ror.org/03c7caz94', 'en', 1, 'https://ror.org/03c7caz94 Sri Aurobindo Institute of Medical Sciences'),
(2848, 'https://ror.org/03c8c9n80', 'en', 1, 'https://ror.org/03c8c9n80 Cathay General Hospital'),
(2849, 'https://ror.org/03c8ed890', 'en', 1, 'https://ror.org/03c8ed890 Sewickley Valley Hospital'),
(2850, 'https://ror.org/03c8vvr84', 'en', 1, 'https://ror.org/03c8vvr84 University of Western States'),
(2851, 'https://ror.org/03ca99543', 'tr', 1, 'https://ror.org/03ca99543 SSK İhtisas Hastanesi'),
(2852, 'https://ror.org/03cbwf726', 'en', 1, 'https://ror.org/03cbwf726 Lakeland Regional Medical Center'),
(2853, 'https://ror.org/03cc0mm23', 'en', 1, 'https://ror.org/03cc0mm23 Nassau University Medical Center'),
(2854, 'https://ror.org/03cf9xg09', 'en', 1, 'https://ror.org/03cf9xg09 California Institute for Medical Research'),
(2855, 'https://ror.org/03cfvmk82', 'en', 1, 'https://ror.org/03cfvmk82 VA Sierra Nevada Health Care System'),
(2856, 'https://ror.org/03cfz7739', 'no_lang_code', 1, 'https://ror.org/03cfz7739 Kawasaki Hospital 川崎病院'),
(2857, 'https://ror.org/03chkg278', 'en', 1, 'https://ror.org/03chkg278 Coe College'),
(2858, 'https://ror.org/03chnr738', 'en', 1, 'https://ror.org/03chnr738 Hope College'),
(2859, 'https://ror.org/03cht9689', 'en', 1, 'https://ror.org/03cht9689 Royal Hospital'),
(2860, 'https://ror.org/03cjj7d58', 'pt', 1, 'https://ror.org/03cjj7d58 Hospital Municipal Souza Aguiar'),
(2861, 'https://ror.org/03cngf009', 'en', 1, 'https://ror.org/03cngf009 Craigavon Area Hospital'),
(2862, 'https://ror.org/03cqd3e64', 'en', 1, 'https://ror.org/03cqd3e64 Connecticut Department of Public Health'),
(2863, 'https://ror.org/03cqsth74', 'en', 1, 'https://ror.org/03cqsth74 Muhlenberg College'),
(2864, 'https://ror.org/03cxsty68', 'pt', 1, 'https://ror.org/03cxsty68 Universidade Estadual do Centro-Oeste'),
(2865, 'https://ror.org/03cyvdv85', 'en', 1, 'https://ror.org/03cyvdv85 First Affiliated Hospital of Wenzhou Medical University'),
(2866, 'https://ror.org/03d0z1f54', 'no_lang_code', 1, 'https://ror.org/03d0z1f54 Electrosynthesis Company (United States)'),
(2867, 'https://ror.org/03d1v2g75', 'no_lang_code', 1, 'https://ror.org/03d1v2g75 Epoch Biosciences (United States)'),
(2868, 'https://ror.org/03d1wq758', 'en', 1, 'https://ror.org/03d1wq758 Maine Medical Center Research Institute'),
(2869, 'https://ror.org/03d4d3711', 'en', 1, 'https://ror.org/03d4d3711 Central Taiwan University of Science and Technology'),
(2870, 'https://ror.org/03d532p87', 'fr', 1, 'https://ror.org/03d532p87 Hôpital Xavier Arnozan'),
(2871, 'https://ror.org/03d58dr58', 'en', 1, 'https://ror.org/03d58dr58 National Neuroscience Institute'),
(2872, 'https://ror.org/03d5pp684', 'pt', 1, 'https://ror.org/03d5pp684 Escola Superior de Enfermagem de São José de Cluny'),
(2873, 'https://ror.org/03d6dzy78', 'en', 1, 'https://ror.org/03d6dzy78 Karnataka Institute of Medical Sciences ಕರ್ನಾಟಕ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),
(2874, 'https://ror.org/03d7m4a98', 'no_lang_code', 1, 'https://ror.org/03d7m4a98 Ross Video (Canada)'),
(2875, 'https://ror.org/03d8mqt26', 'en', 1, 'https://ror.org/03d8mqt26 Princess Royal University Hospital'),
(2876, 'https://ror.org/03davap66', 'en', 1, 'https://ror.org/03davap66 Illinois State Museum'),
(2877, 'https://ror.org/03db3by08', 'en', 1, 'https://ror.org/03db3by08 Northeast Radio Observatory Corporation'),
(2878, 'https://ror.org/03dcdys28', 'en', 1, 'https://ror.org/03dcdys28 Alaska Department of Health and Social Services'),
(2879, 'https://ror.org/03ddsp339', 'no_lang_code', 1, 'https://ror.org/03ddsp339 Pyrogenesis (Canada)'),
(2880, 'https://ror.org/03ddz1316', 'en', 1, 'https://ror.org/03ddz1316 Anhui Provincial Center for Disease Control and Prevention 安徽省疾病预防控制中心'),
(2881, 'https://ror.org/03dhz7247', 'en', 1, 'https://ror.org/03dhz7247 Research Centre for Medical Genetics'),
(2882, 'https://ror.org/03djvm380', 'it', 1, 'https://ror.org/03djvm380 Ospedale Generale Regionale Francesco Miulli'),
(2883, 'https://ror.org/03dke3h47', 'en', 1, 'https://ror.org/03dke3h47 Association of Science-Technology Centers'),
(2884, 'https://ror.org/03dkpj951', 'en', 1, 'https://ror.org/03dkpj951 East Jefferson General Hospital'),
(2885, 'https://ror.org/03dkyhy49', 'no_lang_code', 1, 'https://ror.org/03dkyhy49 Artann Laboratories, Inc.'),
(2886, 'https://ror.org/03dm1pq74', 'en', 1, 'https://ror.org/03dm1pq74 Grant Medical College and Sir Jamshedjee Jeejeebhoy Group of Hospitals'),
(2887, 'https://ror.org/03dm2se39', 'en', 1, 'https://ror.org/03dm2se39 Christ Hospital'),
(2888, 'https://ror.org/03dnktm38', 'no_lang_code', 1, 'https://ror.org/03dnktm38 Scimar Engineering Ltd'),
(2889, 'https://ror.org/03dqzan26', 'en', 1, 'https://ror.org/03dqzan26 Salem University'),
(2890, 'https://ror.org/03dsc8d33', 'no_lang_code', 1, 'https://ror.org/03dsc8d33 Systems, Applications & Products in Data Processing (Germany)'),
(2891, 'https://ror.org/03dsgss45', 'ca', 1, 'https://ror.org/03dsgss45 Hospital Mare de Déu de la Mercè'),
(2892, 'https://ror.org/03dwvx056', 'tr', 1, 'https://ror.org/03dwvx056 Elazig Education and Research Hospital Elazığ Eğitim ve Araştırma Hastanesi'),
(2893, 'https://ror.org/03dwx1z96', 'en', 1, 'https://ror.org/03dwx1z96 Maulana Azad Medical College மௌலானா ஆசாத் மருத்துவக் கல்லூரி'),
(2894, 'https://ror.org/03dwxvb85', 'no_lang_code', 1, 'https://ror.org/03dwxvb85 Jamia Hamdard'),
(2895, 'https://ror.org/03dx46b94', 'en', 1, 'https://ror.org/03dx46b94 Royal National Orthopaedic Hospital NHS Trust'),
(2896, 'https://ror.org/03e05fb06', 'en', 1, 'https://ror.org/03e05fb06 DSO National Laboratories'),
(2897, 'https://ror.org/03e1ayz78', 'en', 1, 'https://ror.org/03e1ayz78 University of Minnesota Medical Center'),
(2898, 'https://ror.org/03e1xkn26', 'en', 1, 'https://ror.org/03e1xkn26 Florida Department of Health'),
(2899, 'https://ror.org/03e269852', 'en', 1, 'https://ror.org/03e269852 Donetsk State University of Management Донецкий государственный университет управления Донецький державний університет управління'),
(2900, 'https://ror.org/03e2qe334', 'no_lang_code', 1, 'https://ror.org/03e2qe334 Naresuan University มหาวิทยาลัยนเรศวร'),
(2901, 'https://ror.org/03e36d037', 'es', 1, 'https://ror.org/03e36d037 ABC Medical Center Centro Médico ABC'),
(2902, 'https://ror.org/03e4nh963', 'en', 1, 'https://ror.org/03e4nh963 Federal Medical Centre'),
(2903, 'https://ror.org/03e8ncw23', 'en', 1, 'https://ror.org/03e8ncw23 Gunma Prefectural Institute of Public Health and Environmental Sciences 群馬県衛生環境研究所'),
(2904, 'https://ror.org/03e8s1d88', 'en', 1, 'https://ror.org/03e8s1d88 Potsdam Institute for Climate Impact Research Potsdam-Institut für Klimafolgenforschung'),
(2905, 'https://ror.org/03eaw8c11', 'en', 1, 'https://ror.org/03eaw8c11 Bethesda North Hospital'),
(2906, 'https://ror.org/03ebg0v16', 'en', 1, 'https://ror.org/03ebg0v16 Boys Town'),
(2907, 'https://ror.org/03ec4j852', 'en', 1, 'https://ror.org/03ec4j852 St. Luke’s Boise Medical Center'),
(2908, 'https://ror.org/03edafd86', 'en', 1, 'https://ror.org/03edafd86 Bogomolets National Medical University Narodowy Medyczny Uniwersytet im. O.Bohomolca Национальный медицинский университет имени А. А. Богомольца Національний медичний університет імені Олександра Богомольця'),
(2909, 'https://ror.org/03edth057', 'en', 1, 'https://ror.org/03edth057 Teikyo University Chiba Medical Center 帝京大学ちば総合医療センター'),
(2910, 'https://ror.org/03efxpx82', 'it', 1, 'https://ror.org/03efxpx82 A. O. Ordine Mauriziano di Torino'),
(2911, 'https://ror.org/03ehcbt32', 'no_lang_code', 1, 'https://ror.org/03ehcbt32 Saiseikai Suita Hospital 大阪府済生会吹田病院'),
(2912, 'https://ror.org/03ehzxb24', 'en', 1, 'https://ror.org/03ehzxb24 St. Francis Medical Center'),
(2913, 'https://ror.org/03ej8bw49', 'en', 1, 'https://ror.org/03ej8bw49 Shanghai Changning Mental Health Center 长宁区精神卫生中心'),
(2914, 'https://ror.org/03ej9xm26', 'pt', 1, 'https://ror.org/03ej9xm26 Hospital de Clínicas Universidade Federal do Paraná'),
(2915, 'https://ror.org/03eksqx74', 'en', 1, 'https://ror.org/03eksqx74 Winthrop-University Hospital'),
(2916, 'https://ror.org/03ekzka28', 'en', 1, 'https://ror.org/03ekzka28 Antioch University'),
(2917, 'https://ror.org/03ene5287', 'en', 1, 'https://ror.org/03ene5287 Orange County Healthcare Agency'),
(2918, 'https://ror.org/03enmdz06', 'en', 1, 'https://ror.org/03enmdz06 California State University, Fresno Université d''État de Californie à Fresno'),
(2919, 'https://ror.org/03ephvw84', 'en', 1, 'https://ror.org/03ephvw84 Dronning Ingrids Hospital Queen Ingrid''s Hospital'),
(2920, 'https://ror.org/03er5cb38', 'en', 1, 'https://ror.org/03er5cb38 Moisio Hospital Moision Sairaala'),
(2921, 'https://ror.org/03et1qs84', 'en', 1, 'https://ror.org/03et1qs84 Centre médical universitaire de loma linda Loma Linda University Medical Center'),
(2922, 'https://ror.org/03ew6dd87', 'en', 1, 'https://ror.org/03ew6dd87 East Tennessee Children''s Hospital'),
(2923, 'https://ror.org/03exj3651', 'en', 1, 'https://ror.org/03exj3651 Littlemore Hospital'),
(2924, 'https://ror.org/03eydna48', 'en', 1, 'https://ror.org/03eydna48 St. Joseph Hospital'),
(2925, 'https://ror.org/03ezzqh77', 'en', 1, 'https://ror.org/03ezzqh77 Iwate Biotechnology Research Center 財団法人 岩手生物工学研究センター'),
(2926, 'https://ror.org/03f1ecr94', 'en', 1, 'https://ror.org/03f1ecr94 Saint Thomas Midtown Hospital'),
(2927, 'https://ror.org/03f27y887', 'es', 1, 'https://ror.org/03f27y887 National University of Asuncion Universidad Nacional de Asunción'),
(2928, 'https://ror.org/03f3jde70', 'en', 1, 'https://ror.org/03f3jde70 Jaamacada Ummada Soomaaliyeed Somali National University Università nazionale somala'),
(2929, 'https://ror.org/03f8drh85', 'no_lang_code', 1, 'https://ror.org/03f8drh85 Haibara General Hospital 榛原総合病院'),
(2930, 'https://ror.org/03f91xw18', 'en', 1, 'https://ror.org/03f91xw18 Museum of the Earth'),
(2931, 'https://ror.org/03f94es11', 'pt', 1, 'https://ror.org/03f94es11 Instituto Superior Dom Afonso III'),
(2932, 'https://ror.org/03fa2nf38', 'en', 1, 'https://ror.org/03fa2nf38 Methodist University'),
(2933, 'https://ror.org/03fakbf87', 'en', 1, 'https://ror.org/03fakbf87 Colorado Permanente Medical Group'),
(2934, 'https://ror.org/03fan2n27', 'en', 1, 'https://ror.org/03fan2n27 St. Stephen’s Hospital'),
(2935, 'https://ror.org/03fbkqs26', 'no_lang_code', 1, 'https://ror.org/03fbkqs26 Bombardier (Canada)'),
(2936, 'https://ror.org/03fcgva33', 'en', 1, 'https://ror.org/03fcgva33 Westchester Medical Center'),
(2937, 'https://ror.org/03fcpsq87', 'en', 1, 'https://ror.org/03fcpsq87 Providence University 靜宜大學'),
(2938, 'https://ror.org/03feyt230', 'en', 1, 'https://ror.org/03feyt230 Tougaloo College'),
(2939, 'https://ror.org/03ff06b47', 'en', 1, 'https://ror.org/03ff06b47 Hardin–Simmons University'),
(2940, 'https://ror.org/03ffc6g28', 'en', 1, 'https://ror.org/03ffc6g28 Kagawa National Children''s Hospital 国立病院機構香川小児病院'),
(2941, 'https://ror.org/03fgkzb55', 'en', 1, 'https://ror.org/03fgkzb55 Novant Health Presbyterian Medical Center'),
(2942, 'https://ror.org/03fh7t044', 'en', 1, 'https://ror.org/03fh7t044 University of Benghazi جامعة بنغازي'),
(2943, 'https://ror.org/03fhjvs31', 'en', 1, 'https://ror.org/03fhjvs31 Center for Molecular Medicine and Immunology'),
(2944, 'https://ror.org/03fkc8c64', 'en', 1, 'https://ror.org/03fkc8c64 University of the West Indies'),
(2945, 'https://ror.org/03fng6237', 'en', 1, 'https://ror.org/03fng6237 Black Hills State University'),
(2946, 'https://ror.org/03fpqn433', 'es', 1, 'https://ror.org/03fpqn433 Hospital Juan Ramón Jiménez'),
(2947, 'https://ror.org/03fr85h91', 'en', 1, 'https://ror.org/03fr85h91 University of Uyo Teaching Hospital'),
(2948, 'https://ror.org/03fs4aq04', 'en', 1, 'https://ror.org/03fs4aq04 Institute of Fundamental Technological Research Instytut Podstawowych Problemów Techniki'),
(2949, 'https://ror.org/03ftky336', 'en', 1, 'https://ror.org/03ftky336 Saitama International Medical Center 埼玉医科大学国際医療センター'),
(2950, 'https://ror.org/03fvp2v86', 'en', 1, 'https://ror.org/03fvp2v86 Lokmanya Tilak Municipal General Hospital and Lokmanya Tilak Municipal Medical College'),
(2951, 'https://ror.org/03fvyqb23', 'en', 1, 'https://ror.org/03fvyqb23 Baptist Health Louisville'),
(2952, 'https://ror.org/03fwxcd28', 'en', 1, 'https://ror.org/03fwxcd28 Sentara Norfolk General Hospital'),
(2953, 'https://ror.org/03fz4ce66', 'en', 1, 'https://ror.org/03fz4ce66 Shanghai Institute of Hematology 上海血液学研究所'),
(2954, 'https://ror.org/03fz57f90', 'hu', 1, 'https://ror.org/03fz57f90 Markusovszky Egyetemi Oktatókórház'),
(2955, 'https://ror.org/03g1nep17', 'no_lang_code', 1, 'https://ror.org/03g1nep17 3M (Canada)'),
(2956, 'https://ror.org/03g35dg18', 'en', 1, 'https://ror.org/03g35dg18 Delaware State University'),
(2957, 'https://ror.org/03g4hym73', 'en', 1, 'https://ror.org/03g4hym73 University of Birjand دانشگاه بیرجند'),
(2958, 'https://ror.org/03g8yqb46', 'fi', 1, 'https://ror.org/03g8yqb46 Keski-Pohjanmaan keskussairaala'),
(2959, 'https://ror.org/03gbbyk68', 'en', 1, 'https://ror.org/03gbbyk68 Holmes Regional Medical Center'),
(2960, 'https://ror.org/03gd1jf50', 'en', 1, 'https://ror.org/03gd1jf50 Shaikh Khalifa Medical City مدينة الشيخ خليفة الطبية'),
(2961, 'https://ror.org/03gd3wz76', 'en', 1, 'https://ror.org/03gd3wz76 Sher-i-Kashmir Institute of Medical Sciences شیرِ کشمیر انسٹیچیوٹ آف میڈیکل سائنسز'),
(2962, 'https://ror.org/03gd5jm66', 'en', 1, 'https://ror.org/03gd5jm66 Texas Scottish Rite Hospital for Children'),
(2963, 'https://ror.org/03gd6ja31', 'en', 1, 'https://ror.org/03gd6ja31 Al-Ameen Medical College'),
(2964, 'https://ror.org/03gfmry48', 'en', 1, 'https://ror.org/03gfmry48 Sheppard and Enoch Pratt Hospital'),
(2965, 'https://ror.org/03gfs5c49', 'en', 1, 'https://ror.org/03gfs5c49 Nordic School of Public Health'),
(2966, 'https://ror.org/03ghnvz91', 'en', 1, 'https://ror.org/03ghnvz91 West Palm Beach VA Medical Center'),
(2967, 'https://ror.org/03gjyng84', 'no_lang_code', 1, 'https://ror.org/03gjyng84 Sierra Wireless (Canada)'),
(2968, 'https://ror.org/03gk81f96', 'en', 1, 'https://ror.org/03gk81f96 Kaohsiung Medical University'),
(2969, 'https://ror.org/03gke3141', 'en', 1, 'https://ror.org/03gke3141 World Technology Evaluation Center'),
(2970, 'https://ror.org/03gpsj088', 'en', 1, 'https://ror.org/03gpsj088 Jacobs Institute of Women''s Health'),
(2971, 'https://ror.org/03grgv984', 'en', 1, 'https://ror.org/03grgv984 University Centre of Legal Medicine'),
(2972, 'https://ror.org/03grprm46', 'en', 1, 'https://ror.org/03grprm46 Clinical Emergency Hospital Bucharest Spitalul Clinic de Urgenta Bucuresti'),
(2973, 'https://ror.org/03gvpk069', 'no_lang_code', 1, 'https://ror.org/03gvpk069 Edendale Hospital'),
(2974, 'https://ror.org/03gzyz068', 'it', 1, 'https://ror.org/03gzyz068 Ospedale Annunziata di Cosenza'),
(2975, 'https://ror.org/03h1gw307', 'en', 1, 'https://ror.org/03h1gw307 Ospedale S. Eugenio St. Eugenio Hospital'),
(2976, 'https://ror.org/03h1jr755', 'en', 1, 'https://ror.org/03h1jr755 Argerich Hospital'),
(2977, 'https://ror.org/03h2ajh11', 'en', 1, 'https://ror.org/03h2ajh11 Saint Francis Hospital & Medical Center'),
(2978, 'https://ror.org/03h2bh287', 'en', 1, 'https://ror.org/03h2bh287 Oxford University Hospitals NHS Trust'),
(2979, 'https://ror.org/03h2c3g63', 'no_lang_code', 1, 'https://ror.org/03h2c3g63 Matériaux Blanchet'),
(2980, 'https://ror.org/03h3yrx93', 'es', 1, 'https://ror.org/03h3yrx93 Hospital Pediátrico Moctezuma'),
(2981, 'https://ror.org/03h4fx826', 'en', 1, 'https://ror.org/03h4fx826 Lehigh Valley Hospital'),
(2982, 'https://ror.org/03h5v7z82', 'en', 1, 'https://ror.org/03h5v7z82 Connolly Hospital Blanchardstown Ospidéal Uí Chonghaile, Baile Bhlainséir'),
(2983, 'https://ror.org/03hamhx47', 'en', 1, 'https://ror.org/03hamhx47 Universidad de Massachusetts Lowell University of Massachusetts Lowell');
INSERT INTO `rors` VALUES
(2984, 'https://ror.org/03haqmz43', 'fr', 1, 'https://ror.org/03haqmz43 Université Félix Houphouët-Boigny'),
(2985, 'https://ror.org/03hbd7c15', 'no_lang_code', 1, 'https://ror.org/03hbd7c15 Therapeutics Systems Research Laboratories (United States)'),
(2986, 'https://ror.org/03hj7dq77', 'it', 1, 'https://ror.org/03hj7dq77 Ospedale Sandro Pertini'),
(2987, 'https://ror.org/03hkffh19', 'en', 1, 'https://ror.org/03hkffh19 Legacy Emanuel Medical Center'),
(2988, 'https://ror.org/03hqrv489', 'no_lang_code', 1, 'https://ror.org/03hqrv489 Advanced Liquid Logic'),
(2989, 'https://ror.org/03hrxmf69', 'en', 1, 'https://ror.org/03hrxmf69 Newton Wellesley Hospital'),
(2990, 'https://ror.org/03hvxkc45', 'en', 1, 'https://ror.org/03hvxkc45 Bibra International'),
(2991, 'https://ror.org/03hwe2705', 'en', 1, 'https://ror.org/03hwe2705 UCSF Benioff Children''s Hospital'),
(2992, 'https://ror.org/03j05zz84', 'en', 1, 'https://ror.org/03j05zz84 Philadelphia VA Medical Center'),
(2993, 'https://ror.org/03j2sb517', 'en', 1, 'https://ror.org/03j2sb517 Slade Hospital'),
(2994, 'https://ror.org/03j2vsq41', 'en', 1, 'https://ror.org/03j2vsq41 Beijing Great Wall Hospital 北京市长城医院'),
(2995, 'https://ror.org/03j42gp22', 'en', 1, 'https://ror.org/03j42gp22 University HealthSystem Consortium'),
(2996, 'https://ror.org/03j4rdg62', 'en', 1, 'https://ror.org/03j4rdg62 Mater Mothers'' Hospital'),
(2997, 'https://ror.org/03j53f755', 'en', 1, 'https://ror.org/03j53f755 ''''Καραμανδάνειο'''' Γενικό Νοσοκομείο Παίδων Πατρών General Hospital Pediatric Karamandanio'),
(2998, 'https://ror.org/03j554d90', 'en', 1, 'https://ror.org/03j554d90 M.S. Ramaiah Medical College'),
(2999, 'https://ror.org/03j6rvb05', 'fr', 1, 'https://ror.org/03j6rvb05 Hôpital Ambroise-Paré'),
(3000, 'https://ror.org/03j78my65', 'en', 1, 'https://ror.org/03j78my65 Kaiser Foundation Hospital'),
(3001, 'https://ror.org/03j7khn53', 'en', 1, 'https://ror.org/03j7khn53 Shizuoka Red Cross Hospital 静岡赤十字病院'),
(3002, 'https://ror.org/03j7t7330', 'en', 1, 'https://ror.org/03j7t7330 St. Joseph''s Children''s Hospital'),
(3003, 'https://ror.org/03j808814', 'no_lang_code', 1, 'https://ror.org/03j808814 Hokkaido Central Hospital 北海道中央病院'),
(3004, 'https://ror.org/03j9npf54', 'en', 1, 'https://ror.org/03j9npf54 Geisinger Medical Center'),
(3005, 'https://ror.org/03ja1ak26', 'en', 1, 'https://ror.org/03ja1ak26 MedStar Georgetown University Hospital'),
(3006, 'https://ror.org/03ja8fa88', 'en', 1, 'https://ror.org/03ja8fa88 Doctors Hospital'),
(3007, 'https://ror.org/03jachw67', 'en', 1, 'https://ror.org/03jachw67 Elliot Hospital'),
(3008, 'https://ror.org/03jb9b006', 'en', 1, 'https://ror.org/03jb9b006 Dwight D. Eisenhower VA Medical Center'),
(3009, 'https://ror.org/03jc0y470', 'en', 1, 'https://ror.org/03jc0y470 United Hospital Fund'),
(3010, 'https://ror.org/03jckbw05', 'en', 1, 'https://ror.org/03jckbw05 First Affiliated Hospital of Chengdu Medical College 成都医学院第一附属医院'),
(3011, 'https://ror.org/03jcxa214', 'en', 1, 'https://ror.org/03jcxa214 National Maternity Hospital'),
(3012, 'https://ror.org/03jd3cd78', 'en', 1, 'https://ror.org/03jd3cd78 Kobe Children''s Hospital 兵庫県立こども病院'),
(3013, 'https://ror.org/03jd4q354', 'it', 1, 'https://ror.org/03jd4q354 Ospedale G.B. Morgagni - L.Pierantoni'),
(3014, 'https://ror.org/03je4r797', 'en', 1, 'https://ror.org/03je4r797 Luodong Poh-Ai Hospital 羅東博愛醫院'),
(3015, 'https://ror.org/03jeg4p28', 'en', 1, 'https://ror.org/03jeg4p28 Cone Health'),
(3016, 'https://ror.org/03jfzsd28', 'en', 1, 'https://ror.org/03jfzsd28 Shigei Medical Research Institute 重井医学研究所'),
(3017, 'https://ror.org/03jg32m15', 'en', 1, 'https://ror.org/03jg32m15 Dorothea Dix Hospital'),
(3018, 'https://ror.org/03jg6a761', 'en', 1, 'https://ror.org/03jg6a761 Southeast Louisiana Veterans Health Care System'),
(3019, 'https://ror.org/03jgh1p68', 'en', 1, 'https://ror.org/03jgh1p68 Abington Memorial Hospital'),
(3020, 'https://ror.org/03jh5a977', 'en', 1, 'https://ror.org/03jh5a977 Center for Information Technology'),
(3021, 'https://ror.org/03jhnpw59', 'en', 1, 'https://ror.org/03jhnpw59 Museum Of Northern Arizona'),
(3022, 'https://ror.org/03jmdp146', 'en', 1, 'https://ror.org/03jmdp146 Motilal Nehru Medical College'),
(3023, 'https://ror.org/03jmfdf59', 'en', 1, 'https://ror.org/03jmfdf59 Agency for Healthcare Research and Quality'),
(3024, 'https://ror.org/03jpekd50', 'en', 1, 'https://ror.org/03jpekd50 Guangdong General Hospital 广东省老年医学研究所'),
(3025, 'https://ror.org/03jpj9789', 'en', 1, 'https://ror.org/03jpj9789 Glan Clwyd Hospital Ysbyty Glan Clwyd'),
(3026, 'https://ror.org/03jpm9j23', 'pt', 1, 'https://ror.org/03jpm9j23 Hospital da Luz'),
(3027, 'https://ror.org/03jrn4k58', 'no_lang_code', 1, 'https://ror.org/03jrn4k58 GlaxoSmithKline (China)'),
(3028, 'https://ror.org/03js6zg56', 'en', 1, 'https://ror.org/03js6zg56 University of Agricultural Sciences, Bangalore'),
(3029, 'https://ror.org/03jss6s30', 'pt', 1, 'https://ror.org/03jss6s30 Dr. Euryclides Hospital de Jesus Zerbini'),
(3030, 'https://ror.org/03jt4wj37', 'de', 1, 'https://ror.org/03jt4wj37 Universitätskliniken Salzburg'),
(3031, 'https://ror.org/03jv28t80', 'no_lang_code', 1, 'https://ror.org/03jv28t80 Lynntech (United States)'),
(3032, 'https://ror.org/03jv45898', 'no_lang_code', 1, 'https://ror.org/03jv45898 Aphios Corporation'),
(3033, 'https://ror.org/03k0jff29', 'en', 1, 'https://ror.org/03k0jff29 Thunder Bay Regional Health Sciences Centre'),
(3034, 'https://ror.org/03k1gyh28', 'no_lang_code', 1, 'https://ror.org/03k1gyh28 SNC-Lavalin (Canada)'),
(3035, 'https://ror.org/03k25vb36', 'en', 1, 'https://ror.org/03k25vb36 Indiana State Department of Education'),
(3036, 'https://ror.org/03k3bq214', 'en', 1, 'https://ror.org/03k3bq214 National Center of Biomedical Analysis 国家生物医学分析中心'),
(3037, 'https://ror.org/03k6ngg59', 'en', 1, 'https://ror.org/03k6ngg59 Friarage Hospital'),
(3038, 'https://ror.org/03k6q9261', 'en', 1, 'https://ror.org/03k6q9261 St. Mary''s Medical Center'),
(3039, 'https://ror.org/03k793y62', 'en', 1, 'https://ror.org/03k793y62 Agricultural University of Tirana Universiteti Bujqësor i Tiranës Γεωπονικό πανεπιστήμιο Τιράνων'),
(3040, 'https://ror.org/03k7veg12', 'no_lang_code', 1, 'https://ror.org/03k7veg12 Odawara Municipal Hospital 小田原市立病院'),
(3041, 'https://ror.org/03k8anr87', 'en', 1, 'https://ror.org/03k8anr87 Health South Rehabilitation Hospital'),
(3042, 'https://ror.org/03ka27b61', 'en', 1, 'https://ror.org/03ka27b61 West Bengal University of Animal and Fishery Sciences पश्चिम बंगाल मत्स्य एवं पशुपालन विज्ञान विश्वविद्यालय পশ্চিমবঙ্গ প্রাণী ও মৎস্যবিজ্ঞান বিশ্ববিদ্যালয়'),
(3043, 'https://ror.org/03kcsjh25', 'en', 1, 'https://ror.org/03kcsjh25 National Institute of Statistical Sciences'),
(3044, 'https://ror.org/03kcxpp45', 'en', 1, 'https://ror.org/03kcxpp45 Iwakuni Medical Center 岩国医療センター'),
(3045, 'https://ror.org/03ke6tv85', 'en', 1, 'https://ror.org/03ke6tv85 University of Southern Maine'),
(3046, 'https://ror.org/03ke9vf24', 'en', 1, 'https://ror.org/03ke9vf24 Al-Arab Medical University جامعة العرب الطبية'),
(3047, 'https://ror.org/03khjyh83', 'en', 1, 'https://ror.org/03khjyh83 Genome Research Foundation'),
(3048, 'https://ror.org/03kkr2s40', 'en', 1, 'https://ror.org/03kkr2s40 Pondicherry Institute of Medical Sciences'),
(3049, 'https://ror.org/03kmrjq19', 'en', 1, 'https://ror.org/03kmrjq19 Departamento de Salud y Servicios para las Personas Mayores del Estado de Nueva Jersey New Jersey Department of Health'),
(3050, 'https://ror.org/03kpa7r53', 'en', 1, 'https://ror.org/03kpa7r53 Herttoniemi Hospital'),
(3051, 'https://ror.org/03kpvby98', 'en', 1, 'https://ror.org/03kpvby98 MRC Unit for Lifelong Health and Ageing'),
(3052, 'https://ror.org/03ks67450', 'en', 1, 'https://ror.org/03ks67450 Inova Alexandria Hospital'),
(3053, 'https://ror.org/03kv7mk61', 'no_lang_code', 1, 'https://ror.org/03kv7mk61 MPC Computers (United States)'),
(3054, 'https://ror.org/03kw9gc02', 'en', 1, 'https://ror.org/03kw9gc02 Aligarh Muslim University Université musulmane d''aligarh جامعہ علی گڑھ अलीगढ़ मुस्लिम विश्वविद्यालय আলিগড় মুসলিম বিশ্ববিদ্যালয় ਅਲੀਗੜ ਮੁਸਲਿਮ ਯੂਨੀਵਰਸਿਟੀ அலிகார் முஸ்லிம் பல்கலைக்கழகம் అలీఘర్ ముస్లిం విశ్వవిద్యాలయం ಅಲಿಘರ್ ಮುಸ್ಲಿಮ್ ವಿಶ್ವವಿದ್ಯಾಲಯ അലിഗഢ് മുസ്ലിം സർവകലാശാല'),
(3055, 'https://ror.org/03kzpyr73', 'en', 1, 'https://ror.org/03kzpyr73 MedStar Good Samaritan Hospital'),
(3056, 'https://ror.org/03m04df46', 'en', 1, 'https://ror.org/03m04df46 University Hospital Magdeburg Universitätsklinikum Magdeburg'),
(3057, 'https://ror.org/03m2nqg26', 'fr', 1, 'https://ror.org/03m2nqg26 Centre Hospitalier Universitaire Hassan II'),
(3058, 'https://ror.org/03m52v505', 'en', 1, 'https://ror.org/03m52v505 Suffolk County Department of Health Services'),
(3059, 'https://ror.org/03m5bv793', 'en', 1, 'https://ror.org/03m5bv793 Marianjoy Rehabilitation Hospital'),
(3060, 'https://ror.org/03m6tev69', 'en', 1, 'https://ror.org/03m6tev69 Morristown Medical Center'),
(3061, 'https://ror.org/03m7azy07', 'en', 1, 'https://ror.org/03m7azy07 Nebraska Department of Health and Human Services'),
(3062, 'https://ror.org/03m908832', 'en', 1, 'https://ror.org/03m908832 Lehman College'),
(3063, 'https://ror.org/03m964n84', 'en', 1, 'https://ror.org/03m964n84 Aichi University of Education 愛知教育大学'),
(3064, 'https://ror.org/03max4q92', 'tr', 1, 'https://ror.org/03max4q92 Izmir Atatürk Eğitim ve Araştırma Hastanesi'),
(3065, 'https://ror.org/03mbq3y29', 'en', 1, 'https://ror.org/03mbq3y29 Lahey Hospital and Medical Center'),
(3066, 'https://ror.org/03mccxv57', 'en', 1, 'https://ror.org/03mccxv57 Derbyshire Children''s Hospital'),
(3067, 'https://ror.org/03mdzf107', 'en', 1, 'https://ror.org/03mdzf107 Amala Institute of Medical Sciences അമല ഇൻസ്റ്റിട്ട്യൂട്ട് ഓഫ് മെഡിക്കൽ സയൻസസ്'),
(3068, 'https://ror.org/03mehsr39', 'en', 1, 'https://ror.org/03mehsr39 Hokushin General Hospital 北信総合病院'),
(3069, 'https://ror.org/03mfyz684', 'en', 1, 'https://ror.org/03mfyz684 King County Medical Examiner''s Office'),
(3070, 'https://ror.org/03mh75s52', 'en', 1, 'https://ror.org/03mh75s52 Hangzhou Red Cross Hospital 杭州市红十字会医院'),
(3071, 'https://ror.org/03mjtdk61', 'en', 1, 'https://ror.org/03mjtdk61 Mater Health Services'),
(3072, 'https://ror.org/03mm5qn83', 'en', 1, 'https://ror.org/03mm5qn83 Occupational Safety & Health Administration'),
(3073, 'https://ror.org/03mmk1j33', 'no_lang_code', 1, 'https://ror.org/03mmk1j33 Blackberry (Canada)'),
(3074, 'https://ror.org/03mnm0t94', 'en', 1, 'https://ror.org/03mnm0t94 University of Wisconsin–Eau Claire Université du Wisconsin à Eau Claire'),
(3075, 'https://ror.org/03mnxwj46', 'en', 1, 'https://ror.org/03mnxwj46 Metropolitan State University of Denver'),
(3076, 'https://ror.org/03mpa4w20', 'en', 1, 'https://ror.org/03mpa4w20 Okinawa Prefectural Chubu Hospital 沖縄県立中部病院'),
(3077, 'https://ror.org/03msdae35', 'en', 1, 'https://ror.org/03msdae35 Minnesota State University Moorhead Université d''État du minnesota'),
(3078, 'https://ror.org/03mt09h51', 'en', 1, 'https://ror.org/03mt09h51 Lyndon Baines Johnson Hospital'),
(3079, 'https://ror.org/03mt12903', 'es', 1, 'https://ror.org/03mt12903 Hospital San Juan de Dios'),
(3080, 'https://ror.org/03mtnpp42', 'it', 1, 'https://ror.org/03mtnpp42 Ospedale Cannizzaro'),
(3081, 'https://ror.org/03mv07c21', 'no_lang_code', 1, 'https://ror.org/03mv07c21 Arthur D. Little (Czechia)'),
(3082, 'https://ror.org/03mv9x076', 'en', 1, 'https://ror.org/03mv9x076 HCI International Medical Centre'),
(3083, 'https://ror.org/03mwa7s65', 'en', 1, 'https://ror.org/03mwa7s65 Ministry of Health Labour and Welfare 厚生労働省'),
(3084, 'https://ror.org/03mwnnn55', 'en', 1, 'https://ror.org/03mwnnn55 Charleston Southern University'),
(3085, 'https://ror.org/03mx23f83', 'es', 1, 'https://ror.org/03mx23f83 Hospital Montecelo'),
(3086, 'https://ror.org/03mxm6g77', 'en', 1, 'https://ror.org/03mxm6g77 Tomah VA Medical Center'),
(3087, 'https://ror.org/03mxv9643', 'en', 1, 'https://ror.org/03mxv9643 Onslow Memorial Hospital'),
(3088, 'https://ror.org/03n0fp725', 'en', 1, 'https://ror.org/03n0fp725 Children''s Hospital at Montefiore'),
(3089, 'https://ror.org/03n0nnh89', 'ms', 1, 'https://ror.org/03n0nnh89 Hospital Kuala Lumpur'),
(3090, 'https://ror.org/03n20pp93', 'en', 1, 'https://ror.org/03n20pp93 Awadhesh Pratap Singh University अवधेश प्रताप सिंह विश्वविद्यालय'),
(3091, 'https://ror.org/03n2ay196', 'en', 1, 'https://ror.org/03n2ay196 South Texas Veterans Health Care System'),
(3092, 'https://ror.org/03n34rg04', 'en', 1, 'https://ror.org/03n34rg04 Elmhurst Hospital Center'),
(3093, 'https://ror.org/03n35e656', 'no_lang_code', 1, 'https://ror.org/03n35e656 Shuguang Hospital'),
(3094, 'https://ror.org/03n3pz732', 'en', 1, 'https://ror.org/03n3pz732 Medwin Hospital'),
(3095, 'https://ror.org/03n5gdd09', 'en', 1, 'https://ror.org/03n5gdd09 Anhui Provincial Hospital'),
(3096, 'https://ror.org/03n60ms07', 'it', 1, 'https://ror.org/03n60ms07 Ospedale G.F. Ingrassia'),
(3097, 'https://ror.org/03n6cf849', 'no_lang_code', 1, 'https://ror.org/03n6cf849 Ricerca sul Sistema Energetico (Italy)'),
(3098, 'https://ror.org/03n6vs369', 'fr', 1, 'https://ror.org/03n6vs369 Hôpital Avicenne'),
(3099, 'https://ror.org/03n85hy63', 'es', 1, 'https://ror.org/03n85hy63 Hospital Militar Dr. Carlos Arvelo'),
(3100, 'https://ror.org/03n92bt27', 'en', 1, 'https://ror.org/03n92bt27 Overton Brooks VA Medical Center'),
(3101, 'https://ror.org/03na8p459', 'no_lang_code', 1, 'https://ror.org/03na8p459 Yokohama Rosai Hospital 横浜労災病院'),
(3102, 'https://ror.org/03navsr28', 'fr', 1, 'https://ror.org/03navsr28 Hôpital Mère-Enfant'),
(3103, 'https://ror.org/03nc3zw41', 'en', 1, 'https://ror.org/03nc3zw41 Matsue Red Cross Hospital 松江赤十字病院'),
(3104, 'https://ror.org/03ncj7n33', 'no_lang_code', 1, 'https://ror.org/03ncj7n33 Jordanian Universities Network (Jordan)'),
(3105, 'https://ror.org/03nd0nz77', 'en', 1, 'https://ror.org/03nd0nz77 Kagoshima Medical Center 鹿児島医療センター'),
(3106, 'https://ror.org/03ndmsg87', 'no_lang_code', 1, 'https://ror.org/03ndmsg87 Charles River Laboratories (United States)'),
(3107, 'https://ror.org/03ne66j56', 'en', 1, 'https://ror.org/03ne66j56 Flushing Hospital Medical Center'),
(3108, 'https://ror.org/03nj2kd75', 'en', 1, 'https://ror.org/03nj2kd75 Houston Health and Human Services Department'),
(3109, 'https://ror.org/03np13864', 'en', 1, 'https://ror.org/03np13864 Universidad de Trinidad y Tobago University of Trinidad and Tobago'),
(3110, 'https://ror.org/03npxtg86', 'en', 1, 'https://ror.org/03npxtg86 Queen Elizabeth Hospital'),
(3111, 'https://ror.org/03nr55d93', 'en', 1, 'https://ror.org/03nr55d93 North West Armed Forces Hospital مستشفى القوات المسلحة بالشمالية'),
(3112, 'https://ror.org/03nrgvp52', 'en', 1, 'https://ror.org/03nrgvp52 Centinela Hospital Medical Center'),
(3113, 'https://ror.org/03nscjy42', 'no_lang_code', 1, 'https://ror.org/03nscjy42 General Electric (Denmark)'),
(3114, 'https://ror.org/03nteze27', 'en', 1, 'https://ror.org/03nteze27 National Taiwan University Hospital'),
(3115, 'https://ror.org/03nvpm562', 'en', 1, 'https://ror.org/03nvpm562 Shimane University Hospital 島根大学病院'),
(3116, 'https://ror.org/03nw9hs25', 'en', 1, 'https://ror.org/03nw9hs25 Alberta Hospital Edmonton'),
(3117, 'https://ror.org/03nysxh02', 'no_lang_code', 1, 'https://ror.org/03nysxh02 NovoMedix (United States)'),
(3118, 'https://ror.org/03nzegx43', 'es', 1, 'https://ror.org/03nzegx43 Cruces University Hospital Hospital de Cruces'),
(3119, 'https://ror.org/03nzj6y61', 'en', 1, 'https://ror.org/03nzj6y61 Health Net'),
(3120, 'https://ror.org/03p09n514', 'no_lang_code', 1, 'https://ror.org/03p09n514 Danya International, Inc.'),
(3121, 'https://ror.org/03p15s250', 'en', 1, 'https://ror.org/03p15s250 National Center for Health Statistics'),
(3122, 'https://ror.org/03p30f964', 'en', 1, 'https://ror.org/03p30f964 Lincoln County Hospital'),
(3123, 'https://ror.org/03p43tq86', 'ms', 1, 'https://ror.org/03p43tq86 Hospital Selayang'),
(3124, 'https://ror.org/03p6fpw74', 'en', 1, 'https://ror.org/03p6fpw74 Summa Health System'),
(3125, 'https://ror.org/03panb555', 'en', 1, 'https://ror.org/03panb555 Lanzhou University of Technology 兰州理工大学'),
(3126, 'https://ror.org/03pdc2j75', 'tr', 1, 'https://ror.org/03pdc2j75 Haydarpaşa Numune Eğitim ve Araştırma Hastanesi'),
(3127, 'https://ror.org/03pfmgq50', 'en', 1, 'https://ror.org/03pfmgq50 Fooyin University'),
(3128, 'https://ror.org/03pj30e67', 'no_lang_code', 1, 'https://ror.org/03pj30e67 Saiseikai Nakatsu Hospital 大阪府済生会中津病院'),
(3129, 'https://ror.org/03pjj1n42', 'en', 1, 'https://ror.org/03pjj1n42 Dhahran Health Center'),
(3130, 'https://ror.org/03pm2yz25', 'en', 1, 'https://ror.org/03pm2yz25 Kumamoto Health Science University 熊本保健科学大学'),
(3131, 'https://ror.org/03pmd4250', 'no_lang_code', 1, 'https://ror.org/03pmd4250 Shinko Hospital 神鋼記念病院'),
(3132, 'https://ror.org/03pq6f684', 'en', 1, 'https://ror.org/03pq6f684 Asian Institute of Gastroenterology'),
(3133, 'https://ror.org/03pshcc38', 'en', 1, 'https://ror.org/03pshcc38 Halton General Hospital'),
(3134, 'https://ror.org/03psk2k71', 'sl', 1, 'https://ror.org/03psk2k71 Splošna Bolnišnica Celje'),
(3135, 'https://ror.org/03pskkc12', 'en', 1, 'https://ror.org/03pskkc12 National Academy of Medical Sciences'),
(3136, 'https://ror.org/03pwcc270', 'en', 1, 'https://ror.org/03pwcc270 Auburn University System'),
(3137, 'https://ror.org/03px4ez74', 'en', 1, 'https://ror.org/03px4ez74 Zoological Society of London'),
(3138, 'https://ror.org/03pz1p187', 'en', 1, 'https://ror.org/03pz1p187 Alberta Health'),
(3139, 'https://ror.org/03pz7fw94', 'it', 1, 'https://ror.org/03pz7fw94 Azienda Sanitaria Ospedaliera S.Croce e Carle Cuneo'),
(3140, 'https://ror.org/03pzgk858', 'en', 1, 'https://ror.org/03pzgk858 Hospital South West Jutland Sydvestjysk Sygehus'),
(3141, 'https://ror.org/03q0mrg27', 'es', 1, 'https://ror.org/03q0mrg27 Hospital Can Misses'),
(3142, 'https://ror.org/03q1gvb68', 'no_lang_code', 1, 'https://ror.org/03q1gvb68 Neoleukin Therapeutics (Canada)'),
(3143, 'https://ror.org/03q21mh05', 'en', 1, 'https://ror.org/03q21mh05 Cairo University Université du Caire جامعة القاهرة'),
(3144, 'https://ror.org/03q3gmk48', 'en', 1, 'https://ror.org/03q3gmk48 MedStar National Rehabilitation Hospital'),
(3145, 'https://ror.org/03q3s7962', 'en', 1, 'https://ror.org/03q3s7962 Huizhou University 惠州学院'),
(3146, 'https://ror.org/03q45zd70', 'en', 1, 'https://ror.org/03q45zd70 South Dakota Foundation for Medical Care'),
(3147, 'https://ror.org/03q4p1y48', 'en', 1, 'https://ror.org/03q4p1y48 Haga Hospital HagaZiekenhuis'),
(3148, 'https://ror.org/03q7hxz75', 'en', 1, 'https://ror.org/03q7hxz75 Tachikawa Hospital 立川病院'),
(3149, 'https://ror.org/03q7y2p06', 'en', 1, 'https://ror.org/03q7y2p06 Ibaraki Prefectural Central Hospital 茨城県立中央病院'),
(3150, 'https://ror.org/03q82br40', 'sv', 1, 'https://ror.org/03q82br40 Vrinnevi Hospital Vrinnevisjukhuset i Norrköping'),
(3151, 'https://ror.org/03qaqdm58', 'sv', 1, 'https://ror.org/03qaqdm58 Capio Lundby Sjukhus'),
(3152, 'https://ror.org/03qg42k57', 'no_lang_code', 1, 'https://ror.org/03qg42k57 Ishinomaki Senshu University 石巻専修大学'),
(3153, 'https://ror.org/03qgg3111', 'es', 1, 'https://ror.org/03qgg3111 Universidad Centroccidental Lisandro Alvarado'),
(3154, 'https://ror.org/03qjk6p58', 'en', 1, 'https://ror.org/03qjk6p58 Dayton VA Medical Center'),
(3155, 'https://ror.org/03qk02j94', 'en', 1, 'https://ror.org/03qk02j94 West Jefferson Medical Center'),
(3156, 'https://ror.org/03qpaq263', 'sv', 1, 'https://ror.org/03qpaq263 Vårdcentralen Teleborg'),
(3157, 'https://ror.org/03qqbe534', 'en', 1, 'https://ror.org/03qqbe534 Korea National University of Transportation 한국교통대학교'),
(3158, 'https://ror.org/03qrkhd32', 'en', 1, 'https://ror.org/03qrkhd32 Heilongjiang Provincial Hospital 黑龙江省医院'),
(3159, 'https://ror.org/03qrrp624', 'en', 1, 'https://ror.org/03qrrp624 Hirosaki National Hospital 国立病院機構弘前病院'),
(3160, 'https://ror.org/03qwghy04', 'en', 1, 'https://ror.org/03qwghy04 Duran i Reynals Hospital'),
(3161, 'https://ror.org/03qx1c439', 'en', 1, 'https://ror.org/03qx1c439 Wayne Memorial Hospital'),
(3162, 'https://ror.org/03qxkp346', 'pt', 1, 'https://ror.org/03qxkp346 Hospital of St. Francis Xavier'),
(3163, 'https://ror.org/03qyxqf94', 'en', 1, 'https://ror.org/03qyxqf94 Little Company of Mary Hospital'),
(3164, 'https://ror.org/03qz9vy49', 'no_lang_code', 1, 'https://ror.org/03qz9vy49 Photon Imaging (United States)'),
(3165, 'https://ror.org/03r1zz567', 'en', 1, 'https://ror.org/03r1zz567 Idaho Department of Health and Welfare'),
(3166, 'https://ror.org/03r24vd05', 'en', 1, 'https://ror.org/03r24vd05 Robert Morris University Universidad Robert Morris'),
(3167, 'https://ror.org/03r419717', 'en', 1, 'https://ror.org/03r419717 Kementerian Kesehatan Ministry of Health'),
(3168, 'https://ror.org/03r56rv89', 'en', 1, 'https://ror.org/03r56rv89 King Edward VIII Hospital'),
(3169, 'https://ror.org/03r5mk904', 'pt', 1, 'https://ror.org/03r5mk904 Hospital Sírio-Libanês Syrian-Lebanese Hospital'),
(3170, 'https://ror.org/03r6k1a05', 'en', 1, 'https://ror.org/03r6k1a05 Institute of Occupational Medicine'),
(3171, 'https://ror.org/03r6qg857', 'en', 1, 'https://ror.org/03r6qg857 Cambridge Hospital'),
(3172, 'https://ror.org/03r776098', 'en', 1, 'https://ror.org/03r776098 Saint Alphonsus Regional Medical Center'),
(3173, 'https://ror.org/03r781319', 'en', 1, 'https://ror.org/03r781319 Bronovo Hospital Bronovo Ziekenhuis'),
(3174, 'https://ror.org/03r7eh333', 'en', 1, 'https://ror.org/03r7eh333 Tulane Lakeside Hospital'),
(3175, 'https://ror.org/03rbn9086', 'en', 1, 'https://ror.org/03rbn9086 Monmouth College'),
(3176, 'https://ror.org/03rfbyn37', 'en', 1, 'https://ror.org/03rfbyn37 Northampton General Hospital'),
(3177, 'https://ror.org/03rhyss57', 'en', 1, 'https://ror.org/03rhyss57 Day General Hospital بیمارستان دی'),
(3178, 'https://ror.org/03rj2a342', 'en', 1, 'https://ror.org/03rj2a342 Good Samaritan Hospital'),
(3179, 'https://ror.org/03rjt0z37', 'en', 1, 'https://ror.org/03rjt0z37 German University in Cairo الجامعة الألمانية بالقاهرة'),
(3180, 'https://ror.org/03rppv730', 'en', 1, 'https://ror.org/03rppv730 Aga Khan University Hospital Nairobi'),
(3181, 'https://ror.org/03rq2h425', 'no_lang_code', 1, 'https://ror.org/03rq2h425 Shimane Prefectural Central Hospital 島根県立中央病院'),
(3182, 'https://ror.org/03rq50d77', 'en', 1, 'https://ror.org/03rq50d77 Royal Victoria Hospital'),
(3183, 'https://ror.org/03rr7q548', 'en', 1, 'https://ror.org/03rr7q548 Armstrong Atlantic State University'),
(3184, 'https://ror.org/03rtgjq94', 'en', 1, 'https://ror.org/03rtgjq94 University of South Carolina System'),
(3185, 'https://ror.org/03rx00z90', 'no_lang_code', 1, 'https://ror.org/03rx00z90 Sakurabashi Watanabe Hospital 桜橋渡辺病院'),
(3186, 'https://ror.org/03rx7qt61', 'en', 1, 'https://ror.org/03rx7qt61 Maryland State Medical Society'),
(3187, 'https://ror.org/03rx9r010', 'en', 1, 'https://ror.org/03rx9r010 Carraway Methodist Medical Center'),
(3188, 'https://ror.org/03s18mw09', 'it', 1, 'https://ror.org/03s18mw09 Ospedale L. Bonomo'),
(3189, 'https://ror.org/03s2fmv96', 'en', 1, 'https://ror.org/03s2fmv96 Lancaster General Hospital'),
(3190, 'https://ror.org/03s2gs602', 'en', 1, 'https://ror.org/03s2gs602 Kawasaki University of Medical Welfare 川崎医療福祉大学'),
(3191, 'https://ror.org/03s32c292', 'en', 1, 'https://ror.org/03s32c292 Queen Elizabeth II Hospital'),
(3192, 'https://ror.org/03s33gc98', 'it', 1, 'https://ror.org/03s33gc98 Ospedale Bassini'),
(3193, 'https://ror.org/03s3dhf22', 'en', 1, 'https://ror.org/03s3dhf22 Centre hospitalier de St- Mary St Mary''s Hospital'),
(3194, 'https://ror.org/03s5r4e84', 'en', 1, 'https://ror.org/03s5r4e84 VA NY Harbor Healthcare System'),
(3195, 'https://ror.org/03s8txj32', 'en', 1, 'https://ror.org/03s8txj32 Second Affiliated Hospital of Harbin Medical University'),
(3196, 'https://ror.org/03s9ada67', 'en', 1, 'https://ror.org/03s9ada67 HealthPartners'),
(3197, 'https://ror.org/03s9jrm13', 'no_lang_code', 1, 'https://ror.org/03s9jrm13 Kwong Wah Hospital 廣華醫院'),
(3198, 'https://ror.org/03sbc8x80', 'fr', 1, 'https://ror.org/03sbc8x80 Centre Hospitalier Universitaire Ibn Rochd'),
(3199, 'https://ror.org/03sc99320', 'en', 1, 'https://ror.org/03sc99320 Hitachi General Hospital 日立総合病院'),
(3200, 'https://ror.org/03scbek41', 'en', 1, 'https://ror.org/03scbek41 Royal Orthopaedic Hospital'),
(3201, 'https://ror.org/03sf6p593', 'en', 1, 'https://ror.org/03sf6p593 Showa Women''s University 昭和女子大学'),
(3202, 'https://ror.org/03sfkwk85', 'en', 1, 'https://ror.org/03sfkwk85 Rockefeller Foundation'),
(3203, 'https://ror.org/03shav252', 'en', 1, 'https://ror.org/03shav252 Kazan State Technological University Казанский национальный исследовательский технологический университет'),
(3204, 'https://ror.org/03sjjqm13', 'en', 1, 'https://ror.org/03sjjqm13 Inouye Eye Hospital 井上眼科病院'),
(3205, 'https://ror.org/03sn6yr77', 'en', 1, 'https://ror.org/03sn6yr77 Point Blue Conservation Science'),
(3206, 'https://ror.org/03snrmr61', 'en', 1, 'https://ror.org/03snrmr61 Genesys Regional Medical Center'),
(3207, 'https://ror.org/03ssyyt85', 'en', 1, 'https://ror.org/03ssyyt85 Ottawa County Health Department'),
(3208, 'https://ror.org/03sz8rb35', 'es', 1, 'https://ror.org/03sz8rb35 Hospital General Universitario De Valencia'),
(3209, 'https://ror.org/03t0zwh35', 'en', 1, 'https://ror.org/03t0zwh35 International Women''s Health Coalition'),
(3210, 'https://ror.org/03t1yn780', 'en', 1, 'https://ror.org/03t1yn780 First Affiliated Hospital of Anhui Medical University'),
(3211, 'https://ror.org/03t3q6164', 'en', 1, 'https://ror.org/03t3q6164 Rancho Los Amigos National Rehabilitation Center'),
(3212, 'https://ror.org/03t3qg659', 'en', 1, 'https://ror.org/03t3qg659 Substance Abuse and Mental Health Services Administration'),
(3213, 'https://ror.org/03t40cz74', 'no_lang_code', 1, 'https://ror.org/03t40cz74 Hypres (United States)'),
(3214, 'https://ror.org/03t4gtw27', 'ro', 1, 'https://ror.org/03t4gtw27 Spitalul Clinic de Urgenta Sfantul Ioan'),
(3215, 'https://ror.org/03t78za89', 'en', 1, 'https://ror.org/03t78za89 Regional Medical Center'),
(3216, 'https://ror.org/03t7m8092', 'en', 1, 'https://ror.org/03t7m8092 Public Health Foundation Enterprises'),
(3217, 'https://ror.org/03t8gvx47', 'en', 1, 'https://ror.org/03t8gvx47 Rampton Hospital'),
(3218, 'https://ror.org/03t995d97', 'en', 1, 'https://ror.org/03t995d97 St. Joseph Health System'),
(3219, 'https://ror.org/03tatzf36', 'en', 1, 'https://ror.org/03tatzf36 Shandong Eye Institute & Hospital 山东省眼科研究所青岛与医院'),
(3220, 'https://ror.org/03tbh6y23', 'en', 1, 'https://ror.org/03tbh6y23 University of the Philippines Diliman'),
(3221, 'https://ror.org/03tds6380', 'en', 1, 'https://ror.org/03tds6380 Ohio Department of Mental Health & Addiction Services'),
(3222, 'https://ror.org/03teaad16', 'en', 1, 'https://ror.org/03teaad16 Rex Hospital'),
(3223, 'https://ror.org/03tf96d34', 'it', 1, 'https://ror.org/03tf96d34 Azienda Ospedaliera Universitaria Policlinico "G. Martino"'),
(3224, 'https://ror.org/03tfy3c27', 'es', 1, 'https://ror.org/03tfy3c27 Hospital Vega Baja'),
(3225, 'https://ror.org/03tg0z446', 'en', 1, 'https://ror.org/03tg0z446 Odisha University of Agriculture and Technology उडिसा कृषि एवं प्रौद्योगिकी विश्वविद्यालय'),
(3226, 'https://ror.org/03tgvv724', 'en', 1, 'https://ror.org/03tgvv724 Swedish Covenant Hospital'),
(3227, 'https://ror.org/03thhhv76', 'en', 1, 'https://ror.org/03thhhv76 American Type Culture Collection'),
(3228, 'https://ror.org/03thzz813', 'en', 1, 'https://ror.org/03thzz813 Meikai University 明海大学'),
(3229, 'https://ror.org/03tkfgy13', 'en', 1, 'https://ror.org/03tkfgy13 Simanogleio-Amalia Fleming General Hospital Σισμανόγλειο-Αμαλία Φλέμινγκ Γενικό Νοσοκομείο'),
(3230, 'https://ror.org/03tktyg33', 'en', 1, 'https://ror.org/03tktyg33 Western Oklahoma State College'),
(3231, 'https://ror.org/03tn5ee41', 'en', 1, 'https://ror.org/03tn5ee41 Benha University Université de Banha جامعة بنها'),
(3232, 'https://ror.org/03tp0ty93', 'en', 1, 'https://ror.org/03tp0ty93 Geha Mental Health Center המרכז לבריאות הנפש גהה'),
(3233, 'https://ror.org/03tqnz817', 'en', 1, 'https://ror.org/03tqnz817 Sachs'' Children and Youth Hospital'),
(3234, 'https://ror.org/03tr4r126', 'en', 1, 'https://ror.org/03tr4r126 Narayan Medical College and Hospital'),
(3235, 'https://ror.org/03tth1e03', 'en', 1, 'https://ror.org/03tth1e03 University of Life Sciences in Poznań Uniwersytet Przyrodniczy w Poznaniu'),
(3236, 'https://ror.org/03txk6b49', 'en', 1, 'https://ror.org/03txk6b49 St. Luke''s Hospital'),
(3237, 'https://ror.org/03ty5px05', 'en', 1, 'https://ror.org/03ty5px05 Hunan Entry-Exit Inspection and Quarantine Bureau'),
(3238, 'https://ror.org/03ty7jy62', 'en', 1, 'https://ror.org/03ty7jy62 Alexian Brothers Medical Center'),
(3239, 'https://ror.org/03v188q73', 'en', 1, 'https://ror.org/03v188q73 Earthquake Engineering Research Institute'),
(3240, 'https://ror.org/03v4m1x12', 'en', 1, 'https://ror.org/03v4m1x12 Damghan University دانشگاه دامغان'),
(3241, 'https://ror.org/03v5sbh78', 'en', 1, 'https://ror.org/03v5sbh78 Swami Devi Dyal Hospital and Dental College'),
(3242, 'https://ror.org/03v7hnv07', 'no_lang_code', 1, 'https://ror.org/03v7hnv07 Metaxa Hospital'),
(3243, 'https://ror.org/03v8v5y65', 'it', 1, 'https://ror.org/03v8v5y65 Consorzio Interuniversitario Nazionale per l''Informatica National Interuniversity Consortium for Informatics'),
(3244, 'https://ror.org/03vaer060', 'en', 1, 'https://ror.org/03vaer060 MRC University of Glasgow Centre for Virus Research'),
(3245, 'https://ror.org/03vamsh08', 'en', 1, 'https://ror.org/03vamsh08 County Durham and Darlington NHS Foundation Trust'),
(3246, 'https://ror.org/03vb4dm14', 'en', 1, 'https://ror.org/03vb4dm14 Texas A&M University at Qatar جامعة تكساس أي اند إم'),
(3247, 'https://ror.org/03vc5bf16', 'en', 1, 'https://ror.org/03vc5bf16 Cappagh National Orthopaedic Hospital'),
(3248, 'https://ror.org/03vc89b25', 'en', 1, 'https://ror.org/03vc89b25 Osaka Bio Headquarters'),
(3249, 'https://ror.org/03vd2y814', 'en', 1, 'https://ror.org/03vd2y814 Kitasato University Medical Center 北里大学メディカルセンター'),
(3250, 'https://ror.org/03vdj0f87', 'en', 1, 'https://ror.org/03vdj0f87 AtlantiCare'),
(3251, 'https://ror.org/03vf51s41', 'hr', 1, 'https://ror.org/03vf51s41 Klinički bolnički centar Osijek'),
(3252, 'https://ror.org/03vgdd632', 'no_lang_code', 1, 'https://ror.org/03vgdd632 Ichor Medical Systems (United States)'),
(3253, 'https://ror.org/03vgqy581', 'no_lang_code', 1, 'https://ror.org/03vgqy581 Asahikawa University 旭川大学'),
(3254, 'https://ror.org/03vj41343', 'en', 1, 'https://ror.org/03vj41343 San Francicso Brain Research Institute & SAM Technology'),
(3255, 'https://ror.org/03vj98x35', 'en', 1, 'https://ror.org/03vj98x35 Beijing Dao Pei Hospital 北京道培医院'),
(3256, 'https://ror.org/03vjkf643', 'en', 1, 'https://ror.org/03vjkf643 Shanghai Tenth People''s Hospital 上海第十人民医院'),
(3257, 'https://ror.org/03vkkz907', 'en', 1, 'https://ror.org/03vkkz907 Batra Hospital and Medical Research Centre'),
(3258, 'https://ror.org/03vmdsx94', 'en', 1, 'https://ror.org/03vmdsx94 Nagara Medical Center 国立病院機構長良医療センター'),
(3259, 'https://ror.org/03vn2ff22', 'en', 1, 'https://ror.org/03vn2ff22 Missouri Western State University'),
(3260, 'https://ror.org/03vnftm46', 'no_lang_code', 1, 'https://ror.org/03vnftm46 Maxwell Sensors'),
(3261, 'https://ror.org/03vnj0h28', 'en', 1, 'https://ror.org/03vnj0h28 Duke Children''s Hospital & Health Center'),
(3262, 'https://ror.org/03vnshb93', 'en', 1, 'https://ror.org/03vnshb93 Transport for London'),
(3263, 'https://ror.org/03vpd6e34', 'en', 1, 'https://ror.org/03vpd6e34 Hayatabad Medical Complex'),
(3264, 'https://ror.org/03vt2s541', 'en', 1, 'https://ror.org/03vt2s541 Ministry of Health and Social Welfare'),
(3265, 'https://ror.org/03vw2zn10', 'fr', 1, 'https://ror.org/03vw2zn10 Hôpital Saint-Vincent-de-Paul'),
(3266, 'https://ror.org/03vwxd822', 'no_lang_code', 1, 'https://ror.org/03vwxd822 Chugoku Rosai Hospital 中国労災病院'),
(3267, 'https://ror.org/03vz8ns51', 'en', 1, 'https://ror.org/03vz8ns51 Ziauddin University'),
(3268, 'https://ror.org/03vzfth13', 'en', 1, 'https://ror.org/03vzfth13 Hospital for Special Care'),
(3269, 'https://ror.org/03vzpaf33', 'en', 1, 'https://ror.org/03vzpaf33 Einstein Medical Center Philadelphia'),
(3270, 'https://ror.org/03w0k0x36', 'en', 1, 'https://ror.org/03w0k0x36 Beijing Sport University 北京体育大学'),
(3271, 'https://ror.org/03w0kj141', 'en', 1, 'https://ror.org/03w0kj141 Army Medical College'),
(3272, 'https://ror.org/03w11wq45', 'es', 1, 'https://ror.org/03w11wq45 El Hospital General de Agudos Carlos G. Durand'),
(3273, 'https://ror.org/03w1tbe79', 'no_lang_code', 1, 'https://ror.org/03w1tbe79 Molecular GPS Technologies (United States)'),
(3274, 'https://ror.org/03w37n116', 'en', 1, 'https://ror.org/03w37n116 Alta Bates Summit Medical Center'),
(3275, 'https://ror.org/03w44ff23', 'en', 1, 'https://ror.org/03w44ff23 Brigham and Women''s Faulkner Hospital'),
(3276, 'https://ror.org/03w5gm511', 'en', 1, 'https://ror.org/03w5gm511 Adventist University of Health Sciences'),
(3277, 'https://ror.org/03w5j8p12', 'en', 1, 'https://ror.org/03w5j8p12 Rega Institute for Medical Research'),
(3278, 'https://ror.org/03w6p2n94', 'en', 1, 'https://ror.org/03w6p2n94 Bendigo Health'),
(3279, 'https://ror.org/03w8m2977', 'no_lang_code', 1, 'https://ror.org/03w8m2977 Yibin University'),
(3280, 'https://ror.org/03w94w157', 'en', 1, 'https://ror.org/03w94w157 Mater Private Hospital'),
(3281, 'https://ror.org/03w9cdv26', 'no_lang_code', 1, 'https://ror.org/03w9cdv26 Maichin Dom Университетска акушеро-гинекологична болница “Майчин дом”'),
(3282, 'https://ror.org/03wc8tg09', 'en', 1, 'https://ror.org/03wc8tg09 Jessop Hospital'),
(3283, 'https://ror.org/03wckff62', 'no_lang_code', 1, 'https://ror.org/03wckff62 Southwest Sciences (United States)'),
(3284, 'https://ror.org/03we1zb10', 'en', 1, 'https://ror.org/03we1zb10 Warneford Hospital'),
(3285, 'https://ror.org/03wed5r38', 'en', 1, 'https://ror.org/03wed5r38 Eginition Hospital'),
(3286, 'https://ror.org/03wff9w51', 'en', 1, 'https://ror.org/03wff9w51 Sema Hastanesi Sema Hospital'),
(3287, 'https://ror.org/03wg58p93', 'en', 1, 'https://ror.org/03wg58p93 Hamilton Medical Center'),
(3288, 'https://ror.org/03wgfnb71', 'no_lang_code', 1, 'https://ror.org/03wgfnb71 Barron Associates (United States)'),
(3289, 'https://ror.org/03wgsss62', 'no_lang_code', 1, 'https://ror.org/03wgsss62 Aciéries Réunies de Burbach-Eich-Dudelange Arbed (Luxembourg) Vereinigte Stahlhütten Burbach-Eich-Düdelingen'),
(3290, 'https://ror.org/03wjr6873', 'en', 1, 'https://ror.org/03wjr6873 VA Central California Health Care System'),
(3291, 'https://ror.org/03wkg3b53', 'en', 1, 'https://ror.org/03wkg3b53 National Eye Institute'),
(3292, 'https://ror.org/03wmmfz90', 'en', 1, 'https://ror.org/03wmmfz90 Tennessee Department of Health'),
(3293, 'https://ror.org/03wn09h25', 'no_lang_code', 1, 'https://ror.org/03wn09h25 Novelis (Canada)'),
(3294, 'https://ror.org/03wq4px44', 'en', 1, 'https://ror.org/03wq4px44 North Medical Center 京都府立医科大学附属北部医療センター'),
(3295, 'https://ror.org/03wqxws86', 'no_lang_code', 1, 'https://ror.org/03wqxws86 Teine Keijinkai Hospital 渓仁会グループ'),
(3296, 'https://ror.org/03wwbp431', 'en', 1, 'https://ror.org/03wwbp431 Victoria General Hospital'),
(3297, 'https://ror.org/03wwnw466', 'en', 1, 'https://ror.org/03wwnw466 Milpark Hospital'),
(3298, 'https://ror.org/03wzyp716', 'en', 1, 'https://ror.org/03wzyp716 Mount Carmel Health'),
(3299, 'https://ror.org/03x0d4x24', 'en', 1, 'https://ror.org/03x0d4x24 Pacific Northwest Diabetes Research Institute'),
(3300, 'https://ror.org/03x1jna21', 'en', 1, 'https://ror.org/03x1jna21 Central China Normal University 华中师范大学'),
(3301, 'https://ror.org/03x295n29', 'no_lang_code', 1, 'https://ror.org/03x295n29 Sant Parmanand Hospital'),
(3302, 'https://ror.org/03x516a66', 'en', 1, 'https://ror.org/03x516a66 Bundesanstalt für Materialforschung und -prüfung Federal Institute For Materials Research and Testing'),
(3303, 'https://ror.org/03x8jdc94', 'en', 1, 'https://ror.org/03x8jdc94 Lady Hardinge Medical College'),
(3304, 'https://ror.org/03xbkmz44', 'en', 1, 'https://ror.org/03xbkmz44 Athens Naval & Veterans Hospital Ναυτικό Νοσοκομείο Αθηνών'),
(3305, 'https://ror.org/03xg1f311', 'en', 1, 'https://ror.org/03xg1f311 Kansai University 関西大学'),
(3306, 'https://ror.org/03xgh2v50', 'en', 1, 'https://ror.org/03xgh2v50 Toyama Prefectural University 富山県立大学'),
(3307, 'https://ror.org/03xh40058', 'en', 1, 'https://ror.org/03xh40058 Ministry of Health وزارة الصحة'),
(3308, 'https://ror.org/03xhrps63', 'en', 1, 'https://ror.org/03xhrps63 Central State University'),
(3309, 'https://ror.org/03xhwyc44', 'en', 1, 'https://ror.org/03xhwyc44 Chongqing Emergency Medical Center 重庆市急救医疗中心'),
(3310, 'https://ror.org/03xjacd83', 'en', 1, 'https://ror.org/03xjacd83 Cleveland Clinic'),
(3311, 'https://ror.org/03xms6995', 'en', 1, 'https://ror.org/03xms6995 Central Police University'),
(3312, 'https://ror.org/03xp4dz54', 'en', 1, 'https://ror.org/03xp4dz54 Nebraska Wesleyan University'),
(3313, 'https://ror.org/03xrts777', 'en', 1, 'https://ror.org/03xrts777 Shizuoka Medical Center 静岡医療センター'),
(3314, 'https://ror.org/03xvpaf72', 'en', 1, 'https://ror.org/03xvpaf72 Wakasa History and Folklore Museum 福井県立 若狭歴史博物館'),
(3315, 'https://ror.org/03xww6m08', 'en', 1, 'https://ror.org/03xww6m08 Nicolae Testemițanu State University of Medicine and Pharmacy Universitatea de Medicină și Farmacie Nicolae Testemițanu din Chișinău Государственный университет медицины и фармакологии имени Николая Тестемицяну'),
(3316, 'https://ror.org/03xz3hj66', 'no_lang_code', 1, 'https://ror.org/03xz3hj66 Shonan Kamakura General Hospital 湘南鎌倉総合病院'),
(3317, 'https://ror.org/03y1rev40', 'en', 1, 'https://ror.org/03y1rev40 Hyvinkää Hospital'),
(3318, 'https://ror.org/03y2evj08', 'tr', 1, 'https://ror.org/03y2evj08 Göztepe Şafak Hastanesi'),
(3319, 'https://ror.org/03y4myd35', 'en', 1, 'https://ror.org/03y4myd35 Infectious Disease Research Institute'),
(3320, 'https://ror.org/03yb8aa18', 'it', 1, 'https://ror.org/03yb8aa18 Ospedale Santa Maria della Misericordia di Rovigo'),
(3321, 'https://ror.org/03ycmew18', 'en', 1, 'https://ror.org/03ycmew18 Matsushita Memorial Hospital 松下記念病院'),
(3322, 'https://ror.org/03ydkyb10', 'en', 1, 'https://ror.org/03ydkyb10 Sistema Universitario de Wisconsin University of Wisconsin System Université du Wisconsin'),
(3323, 'https://ror.org/03ydmxb41', 'es', 1, 'https://ror.org/03ydmxb41 Hospital Alemán'),
(3324, 'https://ror.org/03yegf956', 'en', 1, 'https://ror.org/03yegf956 Alice Springs Hospital'),
(3325, 'https://ror.org/03yemaq40', 'en', 1, 'https://ror.org/03yemaq40 University of Findlay'),
(3326, 'https://ror.org/03yjk2s16', 'fr', 1, 'https://ror.org/03yjk2s16 Centre Hospitalier National Universitaire de Fann'),
(3327, 'https://ror.org/03yjkej49', 'en', 1, 'https://ror.org/03yjkej49 Center for Interuniversity Research and Analysis on Organizations'),
(3328, 'https://ror.org/03yk5k102', 'en', 1, 'https://ror.org/03yk5k102 Institute of Child Health'),
(3329, 'https://ror.org/03ypbx660', 'no_lang_code', 1, 'https://ror.org/03ypbx660 Renji Hospital 上海交通大学医学院附属仁济医院'),
(3330, 'https://ror.org/03ysk5e42', 'en', 1, 'https://ror.org/03ysk5e42 University of Suwon 수원대학교'),
(3331, 'https://ror.org/03yt4qx74', 'en', 1, 'https://ror.org/03yt4qx74 Kasumigaura Medical Center 霞ヶ浦医療センター'),
(3332, 'https://ror.org/03ywwzv91', 'no_lang_code', 1, 'https://ror.org/03ywwzv91 3C Institute'),
(3333, 'https://ror.org/03yz7v531', 'en', 1, 'https://ror.org/03yz7v531 Mysore Medical College'),
(3334, 'https://ror.org/03yzzaw34', 'it', 1, 'https://ror.org/03yzzaw34 Ospedale Regina Apostolorum'),
(3335, 'https://ror.org/03z0bdc81', 'no_lang_code', 1, 'https://ror.org/03z0bdc81 Bundang Jesaeng Hospital 분당제생병원'),
(3336, 'https://ror.org/03z27es23', 'en', 1, 'https://ror.org/03z27es23 Universidad Mayor de San Simón University of San Simón'),
(3337, 'https://ror.org/03z2mza16', 'en', 1, 'https://ror.org/03z2mza16 Dewsbury and District Hospital'),
(3338, 'https://ror.org/03z4rrt03', 'de', 1, 'https://ror.org/03z4rrt03 Lindenhofspital'),
(3339, 'https://ror.org/03z6cqs20', 'es', 1, 'https://ror.org/03z6cqs20 Hospital Materno-Infantil'),
(3340, 'https://ror.org/03z8sn326', 'en', 1, 'https://ror.org/03z8sn326 Women & Infants Hospital of Rhode Island'),
(3341, 'https://ror.org/03z8x2j90', 'en', 1, 'https://ror.org/03z8x2j90 Frenchay Hospital'),
(3342, 'https://ror.org/03zayce58', 'en', 1, 'https://ror.org/03zayce58 Princess Margaret Cancer Centre'),
(3343, 'https://ror.org/03zd4p313', 'en', 1, 'https://ror.org/03zd4p313 Norwich Community Hospital'),
(3344, 'https://ror.org/03zeamg24', 'no_lang_code', 1, 'https://ror.org/03zeamg24 Kobe Asahi Hospital 神戸朝日病院'),
(3345, 'https://ror.org/03zeek684', 'it', 1, 'https://ror.org/03zeek684 Consorzio Universitario In Ingegneria Della Qualita'),
(3346, 'https://ror.org/03zeg3732', 'en', 1, 'https://ror.org/03zeg3732 Horton General Hospital'),
(3347, 'https://ror.org/03zgmap36', 'en', 1, 'https://ror.org/03zgmap36 Easton Hospital'),
(3348, 'https://ror.org/03zhhr656', 'en', 1, 'https://ror.org/03zhhr656 Kyoto University of Education 京都教育大学'),
(3349, 'https://ror.org/03zhk7994', 'en', 1, 'https://ror.org/03zhk7994 London Chest Hospital'),
(3350, 'https://ror.org/03zj0ps89', 'en', 1, 'https://ror.org/03zj0ps89 Vardhman Mahavir Medical College & Safdarjung Hospital वर्धमान महावीर मेडिकल कॉलेज और सफदरजंग अस्पताल'),
(3351, 'https://ror.org/03zjj0p70', 'en', 1, 'https://ror.org/03zjj0p70 Population Council'),
(3352, 'https://ror.org/03zk9v026', 'en', 1, 'https://ror.org/03zk9v026 Sutter Medical Center'),
(3353, 'https://ror.org/03zkja782', 'en', 1, 'https://ror.org/03zkja782 Luton and Dunstable University Hospital NHS Foundation Trust'),
(3354, 'https://ror.org/03zms7281', 'en', 1, 'https://ror.org/03zms7281 Good Samaritan Hospital'),
(3355, 'https://ror.org/03zn9xk79', 'en', 1, 'https://ror.org/03zn9xk79 University Teaching Hospital'),
(3356, 'https://ror.org/03zpnb459', 'no_lang_code', 1, 'https://ror.org/03zpnb459 Bikur Cholim Hospital'),
(3357, 'https://ror.org/03zq81960', 'en', 1, 'https://ror.org/03zq81960 Hôpital général de kingston Kingston General Hospital'),
(3358, 'https://ror.org/03zrwm897', 'en', 1, 'https://ror.org/03zrwm897 Technical University of Varna Технически университет - Варна'),
(3359, 'https://ror.org/03zsbd109', 'en', 1, 'https://ror.org/03zsbd109 Hanwa Memorial Hospital 阪和記念病院'),
(3360, 'https://ror.org/03zsjhd07', 'en', 1, 'https://ror.org/03zsjhd07 University of Arkansas at Pine Bluff Université de l''arkansas à pine bluff'),
(3361, 'https://ror.org/03zstcc67', 'en', 1, 'https://ror.org/03zstcc67 Randolph–Macon College'),
(3362, 'https://ror.org/03zvd4s03', 'en', 1, 'https://ror.org/03zvd4s03 WellStar Kennestone Hospital'),
(3363, 'https://ror.org/03zwf0j41', 'en', 1, 'https://ror.org/03zwf0j41 Macclesfield District General Hospital'),
(3364, 'https://ror.org/03zx0nf33', 'en', 1, 'https://ror.org/03zx0nf33 AcademyHealth'),
(3365, 'https://ror.org/03zzj3f20', 'en', 1, 'https://ror.org/03zzj3f20 Fields Institute for Research in Mathematical Sciences'),
(3366, 'https://ror.org/03zzjb946', 'en', 1, 'https://ror.org/03zzjb946 Nishinomiya Kyoritsu Neurosurgical Hospital 西宮協立脳神経外科病院'),
(3367, 'https://ror.org/03zzvtn22', 'de', 1, 'https://ror.org/03zzvtn22 Klinikum im Friedrichshain'),
(3368, 'https://ror.org/03zzyap02', 'en', 1, 'https://ror.org/03zzyap02 Tohoku Medical Megabank Organization 東北メディカル・メガバンク機構'),
(3369, 'https://ror.org/03zzzks34', 'en', 1, 'https://ror.org/03zzzks34 Liverpool Hospital'),
(3370, 'https://ror.org/0402ejh63', 'en', 1, 'https://ror.org/0402ejh63 La Jolla Institute For Molecular Medicine'),
(3371, 'https://ror.org/0403w5x31', 'en', 1, 'https://ror.org/0403w5x31 Guglielmo da Saliceto Hospital'),
(3372, 'https://ror.org/04043k259', 'en', 1, 'https://ror.org/04043k259 Austral University Universidad Austral'),
(3373, 'https://ror.org/0404efv41', 'en', 1, 'https://ror.org/0404efv41 Mercy Medical Center'),
(3374, 'https://ror.org/0405qn567', 'no_lang_code', 1, 'https://ror.org/0405qn567 Nerima General Hospital 練馬総合病院'),
(3375, 'https://ror.org/0405thq08', 'en', 1, 'https://ror.org/0405thq08 Saint Ambrose University Université saint ambroise'),
(3376, 'https://ror.org/0408b4j80', 'en', 1, 'https://ror.org/0408b4j80 B.J. Medical College'),
(3377, 'https://ror.org/0408cp281', 'en', 1, 'https://ror.org/0408cp281 Delaware Department of Health and Social Services'),
(3378, 'https://ror.org/0409zd934', 'en', 1, 'https://ror.org/0409zd934 Universidad de Cartagena University of Cartagena'),
(3379, 'https://ror.org/040bb8882', 'pt', 1, 'https://ror.org/040bb8882 Hospital de São Marcos'),
(3380, 'https://ror.org/040cn9093', 'en', 1, 'https://ror.org/040cn9093 Community Health Network'),
(3381, 'https://ror.org/040cnym54', 'en', 1, 'https://ror.org/040cnym54 Pennington Biomedical Research Center'),
(3382, 'https://ror.org/040d1yx23', 'no_lang_code', 1, 'https://ror.org/040d1yx23 Senvion SE (Germany)'),
(3383, 'https://ror.org/040e0d212', 'en', 1, 'https://ror.org/040e0d212 Tuscaloosa VA Medical Center'),
(3384, 'https://ror.org/040epzy68', 'en', 1, 'https://ror.org/040epzy68 Istanbul Memorial Hospital'),
(3385, 'https://ror.org/040f7tw31', 'no_lang_code', 1, 'https://ror.org/040f7tw31 Inuyama Chuo Hospital 犬山中央病院'),
(3386, 'https://ror.org/040fscg47', 'en', 1, 'https://ror.org/040fscg47 Texas Orthopedic Hospital'),
(3387, 'https://ror.org/040hwr020', 'en', 1, 'https://ror.org/040hwr020 Borough of Manhattan Community College'),
(3388, 'https://ror.org/040jhkj51', 'fr', 1, 'https://ror.org/040jhkj51 Centre Hospitalier de Saint Jean de Dieu'),
(3389, 'https://ror.org/040jk5g10', 'en', 1, 'https://ror.org/040jk5g10 Samuel Merritt University'),
(3390, 'https://ror.org/040m2wv49', 'en', 1, 'https://ror.org/040m2wv49 Skaraborg Hospital Skaraborgs Sjukhus'),
(3391, 'https://ror.org/040m56689', 'hu', 1, 'https://ror.org/040m56689 Baranya Megyei Kórház'),
(3392, 'https://ror.org/040nggs60', 'en', 1, 'https://ror.org/040nggs60 West China Medical Center of Sichuan University 四川大学华西医学中心'),
(3393, 'https://ror.org/040qhpb54', 'en', 1, 'https://ror.org/040qhpb54 Aomori University 青森大学'),
(3394, 'https://ror.org/040qrra89', 'en', 1, 'https://ror.org/040qrra89 G.V. (Sonny) Montgomery VA Medical Center'),
(3395, 'https://ror.org/040qxz868', 'no_lang_code', 1, 'https://ror.org/040qxz868 Chhatrapati Shahu Ji Maharaj University छत्रपति शाहूजी महाराज विश्वविद्यालय சத்ரபதி ஷாகுஜி மகராஜ் பல்கலைக்கழகம்'),
(3396, 'https://ror.org/040r8fr65', 'en', 1, 'https://ror.org/040r8fr65 Aarhus University Hospital Skejby Sygehus'),
(3397, 'https://ror.org/040vfm237', 'en', 1, 'https://ror.org/040vfm237 North West Regional Hospital'),
(3398, 'https://ror.org/040vwpm13', 'en', 1, 'https://ror.org/040vwpm13 University of Houston System'),
(3399, 'https://ror.org/040yv4379', 'fi', 1, 'https://ror.org/040yv4379 Kainuun keskussairaala'),
(3400, 'https://ror.org/04133ks15', 'en', 1, 'https://ror.org/04133ks15 Ecpi University'),
(3401, 'https://ror.org/0416des07', 'es', 1, 'https://ror.org/0416des07 Hospital Universitario Lucus Augusti'),
(3402, 'https://ror.org/0416m3683', 'de', 1, 'https://ror.org/0416m3683 Institut für Rundfunktechnik'),
(3403, 'https://ror.org/0418a3v02', 'en', 1, 'https://ror.org/0418a3v02 Setsunan University 摂南大学'),
(3404, 'https://ror.org/0419bgt07', 'en', 1, 'https://ror.org/0419bgt07 University of Florida Health Science Center'),
(3405, 'https://ror.org/0419nfc77', 'en', 1, 'https://ror.org/0419nfc77 China Three Gorges University 三峡大学'),
(3406, 'https://ror.org/041b40q78', 'no_lang_code', 1, 'https://ror.org/041b40q78 Olympus (Australia)'),
(3407, 'https://ror.org/041bf1s37', 'no_lang_code', 1, 'https://ror.org/041bf1s37 Kanto Gakuin University 関東学院大学'),
(3408, 'https://ror.org/041e85345', 'en', 1, 'https://ror.org/041e85345 Bhumibol Adulyadej Hospital โรงพยาบาลภูมิพลอดุลยเดช'),
(3409, 'https://ror.org/041f0qb31', 'en', 1, 'https://ror.org/041f0qb31 University Hospital Crosshouse');
INSERT INTO `rors` VALUES
(3410, 'https://ror.org/041hae580', 'en', 1, 'https://ror.org/041hae580 Countess of Chester Hospital'),
(3411, 'https://ror.org/041jw5813', 'en', 1, 'https://ror.org/041jw5813 University of San Carlos'),
(3412, 'https://ror.org/041jyhr41', 'en', 1, 'https://ror.org/041jyhr41 Selly Oak Hospital'),
(3413, 'https://ror.org/041m0cc93', 'en', 1, 'https://ror.org/041m0cc93 Providence VA Medical Center'),
(3414, 'https://ror.org/041m74w67', 'en', 1, 'https://ror.org/041m74w67 Wellborn Road Veterinary Medical Center'),
(3415, 'https://ror.org/041mbwk52', 'no_lang_code', 1, 'https://ror.org/041mbwk52 Fisher Bioservices (United States)'),
(3416, 'https://ror.org/041tn5e09', 'no_lang_code', 1, 'https://ror.org/041tn5e09 Shinrakuen Hospital 信楽園病院'),
(3417, 'https://ror.org/041wfjw90', 'en', 1, 'https://ror.org/041wfjw90 LungenClinic Grosshansdorf'),
(3418, 'https://ror.org/04219vz71', 'en', 1, 'https://ror.org/04219vz71 Silver Cross Hospital'),
(3419, 'https://ror.org/0421dgn24', 'en', 1, 'https://ror.org/0421dgn24 Taipei Municipal Women and Children''s Hospital'),
(3420, 'https://ror.org/0422nk691', 'no_lang_code', 1, 'https://ror.org/0422nk691 Fukujuji Hospital 複十字病院'),
(3421, 'https://ror.org/0422q5a32', 'en', 1, 'https://ror.org/0422q5a32 Scripps Whittier Diabetes Institute'),
(3422, 'https://ror.org/0423jvm15', 'en', 1, 'https://ror.org/0423jvm15 Upton Hospital'),
(3423, 'https://ror.org/04253q669', 'en', 1, 'https://ror.org/04253q669 Medical City Children''s Hospital'),
(3424, 'https://ror.org/0425pcn39', 'no_lang_code', 1, 'https://ror.org/0425pcn39 NeuroComp Systems (United States)'),
(3425, 'https://ror.org/0427fee43', 'en', 1, 'https://ror.org/0427fee43 Maharani Laxmi Bai Medical College'),
(3426, 'https://ror.org/0429d0v34', 'en', 1, 'https://ror.org/0429d0v34 China Animal Health and Epidemiology Center 中国动物卫生与流行病学中心'),
(3427, 'https://ror.org/042asnw05', 'en', 1, 'https://ror.org/042asnw05 Castle Hill Hospital'),
(3428, 'https://ror.org/042awg277', 'en', 1, 'https://ror.org/042awg277 MCNC Research and Development Institute'),
(3429, 'https://ror.org/042bbge36', 'en', 1, 'https://ror.org/042bbge36 Nova Southeastern University Universidad de Nova Southeastern'),
(3430, 'https://ror.org/042bdnm87', 'no_lang_code', 1, 'https://ror.org/042bdnm87 Svenskt Stål (Finland) Swedish Steel'),
(3431, 'https://ror.org/042bhxs14', 'en', 1, 'https://ror.org/042bhxs14 Burdwan Medical College & Hospital'),
(3432, 'https://ror.org/042ck3w97', 'en', 1, 'https://ror.org/042ck3w97 Hyogo Ion Beam Medical Center 兵庫県立粒子線医療センター'),
(3433, 'https://ror.org/042ckra75', 'en', 1, 'https://ror.org/042ckra75 Research Foundation For Mental Hygiene'),
(3434, 'https://ror.org/042e7c302', 'fr', 1, 'https://ror.org/042e7c302 Multitel'),
(3435, 'https://ror.org/042fv2404', 'en', 1, 'https://ror.org/042fv2404 Musgrove Park Hospital'),
(3436, 'https://ror.org/042jtt364', 'en', 1, 'https://ror.org/042jtt364 Air Force General Hospital PLA'),
(3437, 'https://ror.org/042q8va29', 'no_lang_code', 1, 'https://ror.org/042q8va29 Sidenor (Greece) ΣΙΔΕΝΟΡ'),
(3438, 'https://ror.org/042qjjy86', 'en', 1, 'https://ror.org/042qjjy86 Ministry of Health ကျန်းမာရေးဝန်ကြီးဌာန'),
(3439, 'https://ror.org/042rz6s74', 'en', 1, 'https://ror.org/042rz6s74 Nissan Tamagawa Hospital 日産厚生会 玉川病院'),
(3440, 'https://ror.org/042thbm45', 'en', 1, 'https://ror.org/042thbm45 Manly Hospital'),
(3441, 'https://ror.org/042vq9b25', 'pt', 1, 'https://ror.org/042vq9b25 Instituto Superior de Educação e Ciências'),
(3442, 'https://ror.org/042vvex07', 'en', 1, 'https://ror.org/042vvex07 Jos University Teaching Hospital'),
(3443, 'https://ror.org/042x68w22', 'pt', 1, 'https://ror.org/042x68w22 Escola Superior de Enfermagem Dr. José Timóteo Montalvão Machado'),
(3444, 'https://ror.org/043071f54', 'en', 1, 'https://ror.org/043071f54 University of Roehampton'),
(3445, 'https://ror.org/0431v1017', 'fr', 1, 'https://ror.org/0431v1017 Hôpital Riviera-Chablais'),
(3446, 'https://ror.org/0431x1p15', 'en', 1, 'https://ror.org/0431x1p15 Gunma Children''s Medical Center 群馬県立小児医療センター'),
(3447, 'https://ror.org/0432p8t34', 'en', 1, 'https://ror.org/0432p8t34 Guangdong Academy of Medical Sciences'),
(3448, 'https://ror.org/04330ze25', 'en', 1, 'https://ror.org/04330ze25 Ashford Hospital'),
(3449, 'https://ror.org/0433abe34', 'en', 1, 'https://ror.org/0433abe34 K.N.Toosi University of Technology دانشگاه صنعتی خواجه نصیرالدین طوسی'),
(3450, 'https://ror.org/0433kqc49', 'en', 1, 'https://ror.org/0433kqc49 Pukyong National University 부경대학교'),
(3451, 'https://ror.org/043889z90', 'en', 1, 'https://ror.org/043889z90 The General Hospital of Heraklion "Venizeleio-Pananio" Γενικό Νοσοκομείο Ηρακλείου "Βενιζέλειο - Πανάνειο"'),
(3452, 'https://ror.org/043brc084', 'en', 1, 'https://ror.org/043brc084 Kuo General Hospital 郭综合医院'),
(3453, 'https://ror.org/043ckch24', 'en', 1, 'https://ror.org/043ckch24 Rehabilitation Hospital of Indiana'),
(3454, 'https://ror.org/043dm5251', 'no_lang_code', 1, 'https://ror.org/043dm5251 Microfab Technologies (United States)'),
(3455, 'https://ror.org/043e04s74', 'en', 1, 'https://ror.org/043e04s74 Civil Aerospace Medical Institute'),
(3456, 'https://ror.org/043ek5g31', 'en', 1, 'https://ror.org/043ek5g31 Henan Cancer Hospital 河南省肿瘤医院'),
(3457, 'https://ror.org/043eknq26', 'en', 1, 'https://ror.org/043eknq26 General Hospital of Nikea Γενικό Νοσοκομείο Νίκαιας'),
(3458, 'https://ror.org/043h2w593', 'en', 1, 'https://ror.org/043h2w593 Akita Red Cross Hospital 秋田赤十字病院'),
(3459, 'https://ror.org/043j17q40', 'en', 1, 'https://ror.org/043j17q40 San Antonio State Chest Hospital'),
(3460, 'https://ror.org/043j9bc42', 'en', 1, 'https://ror.org/043j9bc42 Royal National Orthopaedic Hospital'),
(3461, 'https://ror.org/043jqrs76', 'en', 1, 'https://ror.org/043jqrs76 Sunchon National University 순천대학교'),
(3462, 'https://ror.org/043m85342', 'en', 1, 'https://ror.org/043m85342 Hospital Povisa Povisa Hospital'),
(3463, 'https://ror.org/043mrw780', 'en', 1, 'https://ror.org/043mrw780 Institute For Community Research'),
(3464, 'https://ror.org/043mzjj67', 'en', 1, 'https://ror.org/043mzjj67 Beaumont Hospital'),
(3465, 'https://ror.org/043p8z282', 'en', 1, 'https://ror.org/043p8z282 JR Tokyo General Hospital JR東京総合病院'),
(3466, 'https://ror.org/043ppnw54', 'it', 1, 'https://ror.org/043ppnw54 Ospedale San Donato'),
(3467, 'https://ror.org/043qmbk61', 'en', 1, 'https://ror.org/043qmbk61 Arbor Research Collaborative for Health'),
(3468, 'https://ror.org/043rjaw23', 'no_lang_code', 1, 'https://ror.org/043rjaw23 Profactor (Austria)'),
(3469, 'https://ror.org/043sbvg03', 'en', 1, 'https://ror.org/043sbvg03 Eastern Hepatobiliary Surgery Hospital 东方肝胆外科医院'),
(3470, 'https://ror.org/043xhwq03', 'en', 1, 'https://ror.org/043xhwq03 Carney Hospital'),
(3471, 'https://ror.org/043y3sk06', 'en', 1, 'https://ror.org/043y3sk06 Ohio Heart & Vascular Center'),
(3472, 'https://ror.org/043yd1m08', 'en', 1, 'https://ror.org/043yd1m08 The Evergreen State College'),
(3473, 'https://ror.org/043yy3r57', 'en', 1, 'https://ror.org/043yy3r57 Central India Institute of Medical Sciences'),
(3474, 'https://ror.org/043z88g18', 'fr', 1, 'https://ror.org/043z88g18 Hôpital Sahloul'),
(3475, 'https://ror.org/043zcrg65', 'en', 1, 'https://ror.org/043zcrg65 Birmingham Accident Hospital'),
(3476, 'https://ror.org/0441cbj57', 'en', 1, 'https://ror.org/0441cbj57 National University of Life and Environmental Sciences of Ukraine Национальный университет биоресурсов и природопользования Національний університет біоресурсів і природокористування України'),
(3477, 'https://ror.org/0445ctr76', 'fr', 1, 'https://ror.org/0445ctr76 Hôpital des Diaconesses'),
(3478, 'https://ror.org/04461gd92', 'en', 1, 'https://ror.org/04461gd92 Salmaniya Medical Complex مجمع السلمانية الطبي'),
(3479, 'https://ror.org/0446vnd56', 'en', 1, 'https://ror.org/0446vnd56 Western Kentucky University'),
(3480, 'https://ror.org/0446zdv37', 'en', 1, 'https://ror.org/0446zdv37 Oklahoma Panhandle State University'),
(3481, 'https://ror.org/0447kww10', 'en', 1, 'https://ror.org/0447kww10 University of Miyazaki 宮崎大学'),
(3482, 'https://ror.org/044a5dk27', 'en', 1, 'https://ror.org/044a5dk27 Universidad del Verbo Encarnado University of the Incarnate Word Université du verbe incarné'),
(3483, 'https://ror.org/044ed7z69', 'en', 1, 'https://ror.org/044ed7z69 Ministry of Health and Child Welfare'),
(3484, 'https://ror.org/044em4v11', 'en', 1, 'https://ror.org/044em4v11 Tennessee Department of Mental Health and Substance Abuse Services'),
(3485, 'https://ror.org/044f69t13', 'en', 1, 'https://ror.org/044f69t13 Ministry of Natural Resources and Wildlife Ministère de l''Énergie et des Ressources naturelles'),
(3486, 'https://ror.org/044fz2011', 'en', 1, 'https://ror.org/044fz2011 Rhode Island Department of Behavioral Healthcare, Developmental Disabilities and Hospitals'),
(3487, 'https://ror.org/044hb6b32', 'fr', 1, 'https://ror.org/044hb6b32 Hôpital des Enfants'),
(3488, 'https://ror.org/044kkfr75', 'sv', 1, 'https://ror.org/044kkfr75 AlbaNova'),
(3489, 'https://ror.org/044p01n12', 'en', 1, 'https://ror.org/044p01n12 Vidant Health'),
(3490, 'https://ror.org/044pc0j16', 'no_lang_code', 1, 'https://ror.org/044pc0j16 Mycologics'),
(3491, 'https://ror.org/044pcn091', 'en', 1, 'https://ror.org/044pcn091 University of Mississippi Medical Center'),
(3492, 'https://ror.org/044pfy487', 'en', 1, 'https://ror.org/044pfy487 Georgia Southwestern State University'),
(3493, 'https://ror.org/044prn184', 'en', 1, 'https://ror.org/044prn184 Holy Family Hospital'),
(3494, 'https://ror.org/044r07286', 'en', 1, 'https://ror.org/044r07286 Ouachita Baptist University'),
(3495, 'https://ror.org/044r51149', 'en', 1, 'https://ror.org/044r51149 Hanoi School Of Public Health Trường Đại học Y tế công cộng'),
(3496, 'https://ror.org/044s9gr80', 'en', 1, 'https://ror.org/044s9gr80 Japanese Red Cross Society, Japan 日本赤十字社'),
(3497, 'https://ror.org/044sjfg03', 'en', 1, 'https://ror.org/044sjfg03 Frere Hospital'),
(3498, 'https://ror.org/044t1gs69', 'es', 1, 'https://ror.org/044t1gs69 Centro de Alta Resolución San Millán'),
(3499, 'https://ror.org/044v7v886', 'en', 1, 'https://ror.org/044v7v886 Advocate Children''s Hospital'),
(3500, 'https://ror.org/044vy1d05', 'en', 1, 'https://ror.org/044vy1d05 Tokushima University 徳島大学'),
(3501, 'https://ror.org/044wvm991', 'no_lang_code', 1, 'https://ror.org/044wvm991 Laniado Hospital'),
(3502, 'https://ror.org/044ww3909', 'en', 1, 'https://ror.org/044ww3909 Boone Hospital Center'),
(3503, 'https://ror.org/044xe8f87', 'en', 1, 'https://ror.org/044xe8f87 Queen Mary''s Hospital Sidcup'),
(3504, 'https://ror.org/044ycg712', 'it', 1, 'https://ror.org/044ycg712 Ospedale dei Bambini Vittore Buzzi'),
(3505, 'https://ror.org/044zkrt47', 'en', 1, 'https://ror.org/044zkrt47 National Institute of Health of Thailand สถาบันวิจัยวิทยาศาสตร์สาธารณสุข'),
(3506, 'https://ror.org/0454vek02', 'no_lang_code', 1, 'https://ror.org/0454vek02 National Society of French Railways Société Nationale des Chemins de Fer Français (France)'),
(3507, 'https://ror.org/04551r843', 'en', 1, 'https://ror.org/04551r843 Ministry of Health'),
(3508, 'https://ror.org/0457avm18', 'en', 1, 'https://ror.org/0457avm18 Bishop Auckland Hospital'),
(3509, 'https://ror.org/0457edg47', 'no_lang_code', 1, 'https://ror.org/0457edg47 HREM Research (Japan) 有限会社 HREM'),
(3510, 'https://ror.org/0457yg222', 'en', 1, 'https://ror.org/0457yg222 Acıbadem Kadıköy Hospital Kadıköy Hastanesi'),
(3511, 'https://ror.org/0457zbj98', 'en', 1, 'https://ror.org/0457zbj98 University of Oklahoma Health Sciences Center'),
(3512, 'https://ror.org/04580ts27', 'en', 1, 'https://ror.org/04580ts27 Geisinger Wyoming Valley Medical Center'),
(3513, 'https://ror.org/045ae7j03', 'pt', 1, 'https://ror.org/045ae7j03 Universidade São Francisco University of San Francisco'),
(3514, 'https://ror.org/045bbxm74', 'en', 1, 'https://ror.org/045bbxm74 Tamil Nadu Government Dental College and Hospital'),
(3515, 'https://ror.org/045cqy185', 'en', 1, 'https://ror.org/045cqy185 Mamata Medical College'),
(3516, 'https://ror.org/045czjy48', 'en', 1, 'https://ror.org/045czjy48 Cape Fear Valley Medical Center'),
(3517, 'https://ror.org/045d4f586', 'tr', 1, 'https://ror.org/045d4f586 Ulucanlar Göz Eğitim ve Araştırma Hastanesi'),
(3518, 'https://ror.org/045dgap26', 'en', 1, 'https://ror.org/045dgap26 Iowa Methodist Medical Center'),
(3519, 'https://ror.org/045exnh37', 'no_lang_code', 1, 'https://ror.org/045exnh37 Portiuncula Hospital'),
(3520, 'https://ror.org/045g3sx57', 'en', 1, 'https://ror.org/045g3sx57 Armed Forces Capital Hospital 國軍首都病院 국군수도병원'),
(3521, 'https://ror.org/045gmmg53', 'de', 1, 'https://ror.org/045gmmg53 Max Rubner Institut'),
(3522, 'https://ror.org/045h96a50', 'en', 1, 'https://ror.org/045h96a50 Cooperative Research Centre for Polymers'),
(3523, 'https://ror.org/045jb6x14', 'en', 1, 'https://ror.org/045jb6x14 Sundaram Medical Foundation'),
(3524, 'https://ror.org/045kb1d14', 'en', 1, 'https://ror.org/045kb1d14 Kyoto Medical Center 京都医療センター'),
(3525, 'https://ror.org/045kfbt16', 'no_lang_code', 1, 'https://ror.org/045kfbt16 Dibrugarh University ডিব্রুগড় বিশ্ববিদ্যালয়'),
(3526, 'https://ror.org/045m9y072', 'en', 1, 'https://ror.org/045m9y072 Moses H Cone Memorial Hospital'),
(3527, 'https://ror.org/045nawc23', 'nl', 1, 'https://ror.org/045nawc23 Tergooi'),
(3528, 'https://ror.org/045nemn19', 'en', 1, 'https://ror.org/045nemn19 Ubon Ratchathani University มหาวิทยาลัยอุบลราชธานี'),
(3529, 'https://ror.org/045r80n66', 'en', 1, 'https://ror.org/045r80n66 Cincinnati VA Medical Center'),
(3530, 'https://ror.org/045r8zm03', 'en', 1, 'https://ror.org/045r8zm03 American Sociological Association'),
(3531, 'https://ror.org/045rcvm30', 'en', 1, 'https://ror.org/045rcvm30 Kentucky Cabinet For Health and Family Services'),
(3532, 'https://ror.org/045rd3583', 'no_lang_code', 1, 'https://ror.org/045rd3583 Koto Hospital 江東病院'),
(3533, 'https://ror.org/045s3rx57', 'en', 1, 'https://ror.org/045s3rx57 Bedford Hospital'),
(3534, 'https://ror.org/045v7ay82', 'en', 1, 'https://ror.org/045v7ay82 Chicago Department of Public Health'),
(3535, 'https://ror.org/045vatr18', 'en', 1, 'https://ror.org/045vatr18 University of Ilorin Teaching Hospital'),
(3536, 'https://ror.org/045x76g34', 'en', 1, 'https://ror.org/045x76g34 McMurry University'),
(3537, 'https://ror.org/045xjv649', 'en', 1, 'https://ror.org/045xjv649 Netaji Subhash Chandra Bose Medical College'),
(3538, 'https://ror.org/0460a5x58', 'en', 1, 'https://ror.org/0460a5x58 Eugenides Hospital ΕΥΓΕΝΙΔΕΙΟ ΘΕΡΑΠΕΥΤΗΡΙΟ'),
(3539, 'https://ror.org/0460fxw51', 'en', 1, 'https://ror.org/0460fxw51 Sacred Heart Hospital'),
(3540, 'https://ror.org/0460s9920', 'en', 1, 'https://ror.org/0460s9920 Kyoto first Red Cross hospital 京都第一赤十字病院'),
(3541, 'https://ror.org/0461cvh40', 'en', 1, 'https://ror.org/0461cvh40 Gangneung–Wonju National University 강릉원주대학교'),
(3542, 'https://ror.org/0463dsf87', 'no_lang_code', 1, 'https://ror.org/0463dsf87 G. Papanikolaou General Hospital'),
(3543, 'https://ror.org/046410650', 'en', 1, 'https://ror.org/046410650 Muskingum University'),
(3544, 'https://ror.org/04661b187', 'en', 1, 'https://ror.org/04661b187 Beppu Medical Center 別府医療センター'),
(3545, 'https://ror.org/0466c1b11', 'en', 1, 'https://ror.org/0466c1b11 Kobe City Medical Center West Hospital 神戸市立医療センター西市民病院'),
(3546, 'https://ror.org/0466fwq98', 'en', 1, 'https://ror.org/0466fwq98 St. Mary Medical Center'),
(3547, 'https://ror.org/0467j3j44', 'it', 1, 'https://ror.org/0467j3j44 Ospedale di Belcolle'),
(3548, 'https://ror.org/046a9q865', 'en', 1, 'https://ror.org/046a9q865 Space Science Institute'),
(3549, 'https://ror.org/046a9t092', 'es', 1, 'https://ror.org/046a9t092 Hospital de Niños de la Santísima Trinidad'),
(3550, 'https://ror.org/046aym564', 'en', 1, 'https://ror.org/046aym564 Lock Haven University'),
(3551, 'https://ror.org/046bk9643', 'en', 1, 'https://ror.org/046bk9643 Government Medical College, Amritsar ਸਰਕਾਰੀ ਮੈਡੀਕਲ ਕਾਲਜ'),
(3552, 'https://ror.org/046c18a90', 'en', 1, 'https://ror.org/046c18a90 Guangzhou Medical University Cancer Hospital 广州医科大学附属肿瘤医院'),
(3553, 'https://ror.org/046db5297', 'en', 1, 'https://ror.org/046db5297 Sioux Valley Hospital'),
(3554, 'https://ror.org/046e0q987', 'en', 1, 'https://ror.org/046e0q987 St Lawrence Hospital'),
(3555, 'https://ror.org/046ekqm80', 'en', 1, 'https://ror.org/046ekqm80 Kentucky Community and Technical College System'),
(3556, 'https://ror.org/046fa4y88', 'en', 1, 'https://ror.org/046fa4y88 The Heart Research Institute'),
(3557, 'https://ror.org/046fm7598', 'en', 1, 'https://ror.org/046fm7598 Gunma University 群馬大学'),
(3558, 'https://ror.org/046gme853', 'en', 1, 'https://ror.org/046gme853 Dandenong Hospital'),
(3559, 'https://ror.org/046h7rx26', 'en', 1, 'https://ror.org/046h7rx26 Tri-Service General Hospital Songshan Branch'),
(3560, 'https://ror.org/046jyn221', 'en', 1, 'https://ror.org/046jyn221 Mayo Hospital'),
(3561, 'https://ror.org/046kb4y45', 'en', 1, 'https://ror.org/046kb4y45 University of Virginia Medical Center'),
(3562, 'https://ror.org/046taf492', 'en', 1, 'https://ror.org/046taf492 St Mary''s Hospital'),
(3563, 'https://ror.org/046vare28', 'de', 1, 'https://ror.org/046vare28 St. Josef-Hospital'),
(3564, 'https://ror.org/046vje122', 'en', 1, 'https://ror.org/046vje122 MRC Biostatistics Unit'),
(3565, 'https://ror.org/046w0kr18', 'it', 1, 'https://ror.org/046w0kr18 Azienda Ospedaliera Ospedale Civile di Legnano'),
(3566, 'https://ror.org/046wwv897', 'es', 1, 'https://ror.org/046wwv897 Hospital Virgen del Camino'),
(3567, 'https://ror.org/046x15q93', 'en', 1, 'https://ror.org/046x15q93 The 309th Hospital of Chinese People''s Liberation Army 中国人民解放军第三〇九医院'),
(3568, 'https://ror.org/046yr0268', 'en', 1, 'https://ror.org/046yr0268 Heartland Regional Medical Center'),
(3569, 'https://ror.org/046yvwt23', 'fr', 1, 'https://ror.org/046yvwt23 Hôpital Principal de Dakar'),
(3570, 'https://ror.org/0470b8t84', 'en', 1, 'https://ror.org/0470b8t84 Capella University'),
(3571, 'https://ror.org/0470men05', 'en', 1, 'https://ror.org/0470men05 Tainan Municipal Hospital 台南市立醫院'),
(3572, 'https://ror.org/04718hx42', 'no_lang_code', 1, 'https://ror.org/04718hx42 Srinakharinwirot University มหาวิทยาลัยศรีนครินทรวิโรฒ'),
(3573, 'https://ror.org/04748z305', 'en', 1, 'https://ror.org/04748z305 Taurida National V.I. Vernadsky University Tawrijski Uniwersytet Narodowy im. Władimira Wiernadskiego Таврический национальный университет имени В. И. Вернадского Таврійський національний університет імені В. І. Вернадського'),
(3574, 'https://ror.org/0475w6974', 'no_lang_code', 1, 'https://ror.org/0475w6974 Kinjo Gakuin University 金城学院大学'),
(3575, 'https://ror.org/04760qd13', 'tr', 1, 'https://ror.org/04760qd13 GATA Haydarpaşa Eğitim Hastanesi'),
(3576, 'https://ror.org/0478ng049', 'en', 1, 'https://ror.org/0478ng049 Roger Williams Medical Center'),
(3577, 'https://ror.org/047ae9605', 'en', 1, 'https://ror.org/047ae9605 Taleghani General Hospital بیمارستان طالقانی تهران'),
(3578, 'https://ror.org/047asq971', 'en', 1, 'https://ror.org/047asq971 Medical Research Institute of New Zealand'),
(3579, 'https://ror.org/047b5av97', 'nl', 1, 'https://ror.org/047b5av97 Juliana Kinderziekenhuis'),
(3580, 'https://ror.org/047c5ks69', 'en', 1, 'https://ror.org/047c5ks69 Sunny Hill Health Centre for Children'),
(3581, 'https://ror.org/047g72407', 'en', 1, 'https://ror.org/047g72407 Eastern Nazarene College'),
(3582, 'https://ror.org/047hxsy31', 'en', 1, 'https://ror.org/047hxsy31 Kaiser Permanente Anaheim Medical Center'),
(3583, 'https://ror.org/047k06737', 'en', 1, 'https://ror.org/047k06737 South Dakota Department of Health'),
(3584, 'https://ror.org/047krn550', 'es', 1, 'https://ror.org/047krn550 Hospital César Milstein'),
(3585, 'https://ror.org/047n0b268', 'en', 1, 'https://ror.org/047n0b268 Aichi Prefectural University 愛知県立大学'),
(3586, 'https://ror.org/047n4ns40', 'en', 1, 'https://ror.org/047n4ns40 Taipei Municipal YangMing Hospital 台北市立阳明医院'),
(3587, 'https://ror.org/047qrb368', 'en', 1, 'https://ror.org/047qrb368 South Carolina State Governor''s Office'),
(3588, 'https://ror.org/047sehh14', 'en', 1, 'https://ror.org/047sehh14 Himeji Red Cross Hospital 姫路赤十字病院'),
(3589, 'https://ror.org/047tjmd17', 'en', 1, 'https://ror.org/047tjmd17 Coastal Area Health Education Center'),
(3590, 'https://ror.org/047v2cv91', 'en', 1, 'https://ror.org/047v2cv91 Maidstone Hospital'),
(3591, 'https://ror.org/047vb2x72', 'no_lang_code', 1, 'https://ror.org/047vb2x72 MATIMOP'),
(3592, 'https://ror.org/047x96110', 'en', 1, 'https://ror.org/047x96110 Johannesburg Hospital'),
(3593, 'https://ror.org/047xgg150', 'tr', 1, 'https://ror.org/047xgg150 Malatya Devlet Hastanesi'),
(3594, 'https://ror.org/047yk3s18', 'en', 1, 'https://ror.org/047yk3s18 Catholic University of America Universidad Católica de América Université catholique d''amérique'),
(3595, 'https://ror.org/047ypwv36', 'en', 1, 'https://ror.org/047ypwv36 Baghdad Medical City مدينة الطب'),
(3596, 'https://ror.org/047z4n946', 'en', 1, 'https://ror.org/047z4n946 Semiconductor Research Corporation'),
(3597, 'https://ror.org/04838xh83', 'es', 1, 'https://ror.org/04838xh83 Empresarios Agrupados'),
(3598, 'https://ror.org/0483mr804', 'en', 1, 'https://ror.org/0483mr804 Carolinas Medical Center'),
(3599, 'https://ror.org/0484pjq71', 'en', 1, 'https://ror.org/0484pjq71 Box Hill Hospital'),
(3600, 'https://ror.org/0488cct49', 'en', 1, 'https://ror.org/0488cct49 Orlando Health'),
(3601, 'https://ror.org/0488ndr53', 'en', 1, 'https://ror.org/0488ndr53 Hairmyres Hospital'),
(3602, 'https://ror.org/0489f6q08', 'en', 1, 'https://ror.org/0489f6q08 Cardiff and Vale University Health Board'),
(3603, 'https://ror.org/048a96r61', 'en', 1, 'https://ror.org/048a96r61 Glenfield Hospital'),
(3604, 'https://ror.org/048d1b238', 'en', 1, 'https://ror.org/048d1b238 Miami Children''s Hospital'),
(3605, 'https://ror.org/048drzm61', 'en', 1, 'https://ror.org/048drzm61 Frostburg State University Université d''État de frostburg'),
(3606, 'https://ror.org/048dt4c25', 'en', 1, 'https://ror.org/048dt4c25 Taipei Municipal Jen-Ai Hospital'),
(3607, 'https://ror.org/048f17730', 'en', 1, 'https://ror.org/048f17730 Health Research and Educational Trust'),
(3608, 'https://ror.org/048h7jv87', 'fr', 1, 'https://ror.org/048h7jv87 Centre Hospitalier Universitaire de Cocody'),
(3609, 'https://ror.org/048hj2019', 'en', 1, 'https://ror.org/048hj2019 Joseph Brant Hospital'),
(3610, 'https://ror.org/048j5n646', 'en', 1, 'https://ror.org/048j5n646 National Aerospace University – Kharkiv Aviation Institute Национальный аэрокосмический университет имени Н. Е. Жуковского Національний аерокосмічний університет імені М. Є. Жуковського Харківський авіаційний інститут'),
(3611, 'https://ror.org/048nj0621', 'en', 1, 'https://ror.org/048nj0621 Fulton County Medical Examiner''s Office'),
(3612, 'https://ror.org/048vjc278', 'en', 1, 'https://ror.org/048vjc278 AdventHealth Celebration'),
(3613, 'https://ror.org/048xpjb02', 'en', 1, 'https://ror.org/048xpjb02 National Association of County and City Health Officials'),
(3614, 'https://ror.org/048zq6v82', 'en', 1, 'https://ror.org/048zq6v82 Children''s Research Hospital 小児研究病院'),
(3615, 'https://ror.org/04929s478', 'en', 1, 'https://ror.org/04929s478 NewYork–Presbyterian Brooklyn Methodist Hospital'),
(3616, 'https://ror.org/0493bmq37', 'no_lang_code', 1, 'https://ror.org/0493bmq37 Fujifilm (Japan) 富士フイルム株式会社'),
(3617, 'https://ror.org/0493caa98', 'no_lang_code', 1, 'https://ror.org/0493caa98 Lallemand (Canada)'),
(3618, 'https://ror.org/0493hgw16', 'en', 1, 'https://ror.org/0493hgw16 National Institute on Minority Health and Health Disparities'),
(3619, 'https://ror.org/0493tt883', 'en', 1, 'https://ror.org/0493tt883 Carl T. Hayden Veterans Affairs Medical Center'),
(3620, 'https://ror.org/0494reh34', 'en', 1, 'https://ror.org/0494reh34 Millsaps College'),
(3621, 'https://ror.org/0495efn48', 'en', 1, 'https://ror.org/0495efn48 Guangxi University for Nationalities 广西民族大学'),
(3622, 'https://ror.org/0495vrm88', 'es', 1, 'https://ror.org/0495vrm88 Hospital Municipal de Badalona'),
(3623, 'https://ror.org/04983z422', 'en', 1, 'https://ror.org/04983z422 Taishan Medical University 泰山医学院'),
(3624, 'https://ror.org/049840423', 'en', 1, 'https://ror.org/049840423 Ministry of Health Министерство здравоохранения Республики Беларусь'),
(3625, 'https://ror.org/049aadf12', 'en', 1, 'https://ror.org/049aadf12 Bezmialem Foundation University Medical Faculty Hospital Bezmiâlem Vakıf Üniversitesi Tıp Fakültesi Hastanesi'),
(3626, 'https://ror.org/049ams583', 'en', 1, 'https://ror.org/049ams583 Northwestern State University Université d''État northwestern'),
(3627, 'https://ror.org/049bdss47', 'en', 1, 'https://ror.org/049bdss47 Joanneum Research Joanneum Research Forschungsgesellschaft mbH'),
(3628, 'https://ror.org/049cbmb74', 'en', 1, 'https://ror.org/049cbmb74 Children''s Hospital of Wisconsin'),
(3629, 'https://ror.org/049dkqr57', 'en', 1, 'https://ror.org/049dkqr57 Ningxia Medical University General Hospital 宁夏医科大学总医院'),
(3630, 'https://ror.org/049hmfa48', 'en', 1, 'https://ror.org/049hmfa48 Henry Mayo Newhall Memorial Hospital'),
(3631, 'https://ror.org/049knzm77', 'en', 1, 'https://ror.org/049knzm77 Sturdy Memorial Hospital'),
(3632, 'https://ror.org/049mgby18', 'en', 1, 'https://ror.org/049mgby18 National Institute of Child Health'),
(3633, 'https://ror.org/049mpkx27', 'en', 1, 'https://ror.org/049mpkx27 Shriners Hospitals for Children - St. Louis'),
(3634, 'https://ror.org/049pcfs17', 'en', 1, 'https://ror.org/049pcfs17 Indira Gandhi Institute of Medical Sciences'),
(3635, 'https://ror.org/049peqw80', 'en', 1, 'https://ror.org/049peqw80 San Francisco VA Medical Center'),
(3636, 'https://ror.org/049pfb863', 'en', 1, 'https://ror.org/049pfb863 Kent State University Université d''État de kent'),
(3637, 'https://ror.org/049q0vg17', 'en', 1, 'https://ror.org/049q0vg17 Anqing City Hospital'),
(3638, 'https://ror.org/049v7zy31', 'en', 1, 'https://ror.org/049v7zy31 Chiba Rosai Hospital 千葉労災病院'),
(3639, 'https://ror.org/049w1th24', 'en', 1, 'https://ror.org/049w1th24 Doernbecher Children''s Hospital'),
(3640, 'https://ror.org/049wjac82', 'en', 1, 'https://ror.org/049wjac82 Cooper University Hospital'),
(3641, 'https://ror.org/049x01c36', 'en', 1, 'https://ror.org/049x01c36 Shaw University'),
(3642, 'https://ror.org/049xx5c95', 'en', 1, 'https://ror.org/049xx5c95 Sultan Qaboos University Hospital مستشفى جامعة السلطان قابوس'),
(3643, 'https://ror.org/049yc0897', 'en', 1, 'https://ror.org/049yc0897 Winston-Salem State University'),
(3644, 'https://ror.org/049yfnz48', 'en', 1, 'https://ror.org/049yfnz48 Houston Medical Center'),
(3645, 'https://ror.org/049yjqb12', 'en', 1, 'https://ror.org/049yjqb12 Communications and Information Technology Ontario'),
(3646, 'https://ror.org/049yzyv96', 'en', 1, 'https://ror.org/049yzyv96 VA Central Iowa Health Care System'),
(3647, 'https://ror.org/049zedh07', 'en', 1, 'https://ror.org/049zedh07 Robert Jones and Agnes Hunt Orthopaedic Hospital NHS Trust'),
(3648, 'https://ror.org/049zrh188', 'en', 1, 'https://ror.org/049zrh188 Shanghai Sixth People''s Hospital 上海市第六人民医院'),
(3649, 'https://ror.org/04a0qsn58', 'en', 1, 'https://ror.org/04a0qsn58 St. Margaret Memorial Hospital'),
(3650, 'https://ror.org/04a105t20', 'en', 1, 'https://ror.org/04a105t20 St. Mary''s Hospital'),
(3651, 'https://ror.org/04a20gb33', 'en', 1, 'https://ror.org/04a20gb33 Hispanic Health Council'),
(3652, 'https://ror.org/04a22qz44', 'en', 1, 'https://ror.org/04a22qz44 Seton Medical Center'),
(3653, 'https://ror.org/04a3akw68', 'no_lang_code', 1, 'https://ror.org/04a3akw68 Airbus (Germany)'),
(3654, 'https://ror.org/04a5hr295', 'es', 1, 'https://ror.org/04a5hr295 Complejo Hospitalario Universitario de Albacete Hospital General Universitario de Albacete'),
(3655, 'https://ror.org/04a6gpn58', 'pt', 1, 'https://ror.org/04a6gpn58 Centro Universitário São Camilo'),
(3656, 'https://ror.org/04aa89262', 'en', 1, 'https://ror.org/04aa89262 Radiolabs'),
(3657, 'https://ror.org/04aaeds92', 'no_lang_code', 1, 'https://ror.org/04aaeds92 Israel Aerospace Industries (Israel)'),
(3658, 'https://ror.org/04abjq359', 'es', 1, 'https://ror.org/04abjq359 Hospital Ruber Internacional'),
(3659, 'https://ror.org/04abkkn33', 'pt', 1, 'https://ror.org/04abkkn33 Hospital Santo António dos Capuchos'),
(3660, 'https://ror.org/04aj4sh46', 'en', 1, 'https://ror.org/04aj4sh46 Brookings Institution Institución Brookings'),
(3661, 'https://ror.org/04akqfa40', 'no_lang_code', 1, 'https://ror.org/04akqfa40 Chung Hsiao Municipal Hospital'),
(3662, 'https://ror.org/04am5a125', 'en', 1, 'https://ror.org/04am5a125 Mount Vernon Hospital'),
(3663, 'https://ror.org/04anjm411', 'en', 1, 'https://ror.org/04anjm411 Instituto Superior D. Dinis'),
(3664, 'https://ror.org/04ap0ew90', 'no_lang_code', 1, 'https://ror.org/04ap0ew90 Hlabisa Hospital'),
(3665, 'https://ror.org/04ar23e02', 'en', 1, 'https://ror.org/04ar23e02 Kingston Hospital'),
(3666, 'https://ror.org/04arkmn57', 'en', 1, 'https://ror.org/04arkmn57 University of Defence Univerzita Obrany'),
(3667, 'https://ror.org/04at0zw32', 'en', 1, 'https://ror.org/04at0zw32 Jichi Medical University Hospital 自治医科大学附属病院'),
(3668, 'https://ror.org/04aw32z04', 'en', 1, 'https://ror.org/04aw32z04 Poriya Medical Center בית חולים ברוך פדה'),
(3669, 'https://ror.org/04ayype77', 'en', 1, 'https://ror.org/04ayype77 Wolfson Medical Center מרכז רפואי וולפסון'),
(3670, 'https://ror.org/04azbjn80', 'en', 1, 'https://ror.org/04azbjn80 Guangdong University of Technology 广东工业大学'),
(3671, 'https://ror.org/04aznd361', 'en', 1, 'https://ror.org/04aznd361 Government Medical College கோழிக்கோடு மருத்துவக் கல்லூரி ഗവൺമെന്റ് മെഡിക്കൽ കോളേജ്, കോഴിക്കോട്'),
(3672, 'https://ror.org/04b0jw528', 'en', 1, 'https://ror.org/04b0jw528 Imakiire General Hospital 公益財団法人昭和会 今給黎総合病院'),
(3673, 'https://ror.org/04b0ry431', 'es', 1, 'https://ror.org/04b0ry431 Hospital General de Elda'),
(3674, 'https://ror.org/04b2fhx54', 'en', 1, 'https://ror.org/04b2fhx54 Seoul Women''s University 서울여자대학교'),
(3675, 'https://ror.org/04b2pvs09', 'en', 1, 'https://ror.org/04b2pvs09 Rashid Hospital مستشفى راشد'),
(3676, 'https://ror.org/04b3jmc64', 'en', 1, 'https://ror.org/04b3jmc64 Social Sciences Innovations'),
(3677, 'https://ror.org/04b4hfb84', 'en', 1, 'https://ror.org/04b4hfb84 Green Pastures Hospital and Rehabilitation Centre'),
(3678, 'https://ror.org/04b787h29', 'en', 1, 'https://ror.org/04b787h29 Santa Barbara Cottage Hospital'),
(3679, 'https://ror.org/04b7w1811', 'en', 1, 'https://ror.org/04b7w1811 Yamaguchi Prefectural University 山口県立大学'),
(3680, 'https://ror.org/04b8y3f13', 'no_lang_code', 1, 'https://ror.org/04b8y3f13 Alexandrovska Hospital университетска болница „Александровска'),
(3681, 'https://ror.org/04ba73c73', 'no_lang_code', 1, 'https://ror.org/04ba73c73 MC3 (United States)'),
(3682, 'https://ror.org/04bcdt432', 'pt', 1, 'https://ror.org/04bcdt432 European University of Lisbon Universidade Europeia'),
(3683, 'https://ror.org/04bf33n91', 'en', 1, 'https://ror.org/04bf33n91 University of Balochistan جامعہ بلوچستان'),
(3684, 'https://ror.org/04bg1hy68', 'en', 1, 'https://ror.org/04bg1hy68 Saint Thomas West Hospital'),
(3685, 'https://ror.org/04bgfm609', 'en', 1, 'https://ror.org/04bgfm609 Stowers Institute for Medical Research'),
(3686, 'https://ror.org/04bgfrg80', 'en', 1, 'https://ror.org/04bgfrg80 Ministry of Public Health Ministère de la Santé Publique du Cameroun'),
(3687, 'https://ror.org/04bghze60', 'tr', 1, 'https://ror.org/04bghze60 Dışkapı Yıldırım Beyazıt Eğitim ve Araştırma Hastanesi'),
(3688, 'https://ror.org/04bm03037', 'en', 1, 'https://ror.org/04bm03037 Genesis Medical Center'),
(3689, 'https://ror.org/04bmgpj29', 'en', 1, 'https://ror.org/04bmgpj29 Walsall Manor Hospital'),
(3690, 'https://ror.org/04bpf7m84', 'pt', 1, 'https://ror.org/04bpf7m84 Escola Superior de Saúde Ribeiro Sanches'),
(3691, 'https://ror.org/04bt00m07', 'en', 1, 'https://ror.org/04bt00m07 Mercy General Hospital'),
(3692, 'https://ror.org/04c07bj87', 'en', 1, 'https://ror.org/04c07bj87 Institute of Mental Health'),
(3693, 'https://ror.org/04c0a2j77', 'en', 1, 'https://ror.org/04c0a2j77 Memorial Hospital of Rhode Island'),
(3694, 'https://ror.org/04c0sqe08', 'en', 1, 'https://ror.org/04c0sqe08 Truckee Meadows Community College'),
(3695, 'https://ror.org/04c1d9r22', 'en', 1, 'https://ror.org/04c1d9r22 Services Institute of Medical Sciences سروسز انسٹیٹوٹ آف میڈیکل سائنسز ਸੈਰਵਿਸਜ਼ ਇੰਸਟਿਟਿਊਟ ਆਫ਼ ਮੈਡੀਕਲ ਸਾਈਨਸਜ਼'),
(3696, 'https://ror.org/04c1s4764', 'es', 1, 'https://ror.org/04c1s4764 Hospital Monte Naranco'),
(3697, 'https://ror.org/04c6bry31', 'en', 1, 'https://ror.org/04c6bry31 St. James''s Hospital'),
(3698, 'https://ror.org/04c9pv832', 'de', 1, 'https://ror.org/04c9pv832 Krankenhaus Salem'),
(3699, 'https://ror.org/04can6445', 'no_lang_code', 1, 'https://ror.org/04can6445 P2D Bioscience (United States)'),
(3700, 'https://ror.org/04cb32210', 'en', 1, 'https://ror.org/04cb32210 Scottish Rite Hospital'),
(3701, 'https://ror.org/04cb4je22', 'en', 1, 'https://ror.org/04cb4je22 Ca'' Foncello Hospital'),
(3702, 'https://ror.org/04cbm7s05', 'es', 1, 'https://ror.org/04cbm7s05 Hospital Universitario Insular de Gran Canaria'),
(3703, 'https://ror.org/04cd75h10', 'en', 1, 'https://ror.org/04cd75h10 Iwate University 岩手大学'),
(3704, 'https://ror.org/04cdn2797', 'en', 1, 'https://ror.org/04cdn2797 Banaras Hindu University Université hindoue de bénarès काशी हिन्दू विश् वविद्यालय কাশী হিন্দু বিশ্ববিদ্যালয় બનારસ હિંદુ યુનિવર્સિટી பனாரசு இந்து பல்கலைக்கழகம் బెనారస్ హిందూ విశ్వవిద్యాలయం ಬನಾರಸ್ ಹಿಂದೂ ವಿಶ್ವವಿದ್ಯಾನಿಲಯ ബനാറസ് ഹിന്ദു യൂണിവേഴ്സിറ്റി'),
(3705, 'https://ror.org/04cepy814', 'es', 1, 'https://ror.org/04cepy814 Hospital Juárez de México'),
(3706, 'https://ror.org/04cewr321', 'en', 1, 'https://ror.org/04cewr321 University of Vermont Medical Center'),
(3707, 'https://ror.org/04cf4ba49', 'da', 1, 'https://ror.org/04cf4ba49 Holbæk Sygehus'),
(3708, 'https://ror.org/04cfbdf66', 'no_lang_code', 1, 'https://ror.org/04cfbdf66 Shanghai GenomePilot Technology (China) 上海佰真生物科技有限公司'),
(3709, 'https://ror.org/04cg70g73', 'en', 1, 'https://ror.org/04cg70g73 Atmospheric and Environmental Research'),
(3710, 'https://ror.org/04cjdzt83', 'en', 1, 'https://ror.org/04cjdzt83 King Abdulaziz Hospital مستشفى الملك عبدالعزي'),
(3711, 'https://ror.org/04cjgh922', 'no_lang_code', 1, 'https://ror.org/04cjgh922 Honeywell (Canada)'),
(3712, 'https://ror.org/04ckgfr29', 'en', 1, 'https://ror.org/04ckgfr29 Sri Manakula Vinayagar Medical College and Hospital'),
(3713, 'https://ror.org/04ckvpk15', 'fr', 1, 'https://ror.org/04ckvpk15 Hôpital Laennec'),
(3714, 'https://ror.org/04cmadr83', 'en', 1, 'https://ror.org/04cmadr83 Okayama Rosai Hospital 岡山労災病院'),
(3715, 'https://ror.org/04cnfrn26', 'en', 1, 'https://ror.org/04cnfrn26 University of the Arts London'),
(3716, 'https://ror.org/04cpf2p55', 'en', 1, 'https://ror.org/04cpf2p55 Bess Kaiser Hospital'),
(3717, 'https://ror.org/04cqs5j56', 'en', 1, 'https://ror.org/04cqs5j56 Southern Illinois University Edwardsville'),
(3718, 'https://ror.org/04crdae34', 'en', 1, 'https://ror.org/04crdae34 Mahatma Gandhi Institute of Medical Sciences महात्मा गांधी वैद्यकीय संस्था'),
(3719, 'https://ror.org/04cs55d24', 'no_lang_code', 1, 'https://ror.org/04cs55d24 Charoenkrung Pracharak Hospital โรงพยาบาลเจริญกรุงประชารักษ์'),
(3720, 'https://ror.org/04ctp9859', 'it', 1, 'https://ror.org/04ctp9859 Ospedale Maria Vittoria'),
(3721, 'https://ror.org/04cwap208', 'en', 1, 'https://ror.org/04cwap208 Inner Mongolia University for Nationalities'),
(3722, 'https://ror.org/04cxm4j25', 'en', 1, 'https://ror.org/04cxm4j25 Australian Catholic University'),
(3723, 'https://ror.org/04cy4z909', 'es', 1, 'https://ror.org/04cy4z909 Hospital de Mataró'),
(3724, 'https://ror.org/04cyk2a69', 'en', 1, 'https://ror.org/04cyk2a69 General de Jesus College'),
(3725, 'https://ror.org/04czxss33', 'en', 1, 'https://ror.org/04czxss33 Dubai Hospital مستشفى دبـــي'),
(3726, 'https://ror.org/04d0rfg41', 'en', 1, 'https://ror.org/04d0rfg41 St. Paul''s Hospital'),
(3727, 'https://ror.org/04d0szq68', 'en', 1, 'https://ror.org/04d0szq68 Shaare Zedek Medical Center מרכז רפואי שערי צדק'),
(3728, 'https://ror.org/04d45ra64', 'fr', 1, 'https://ror.org/04d45ra64 Hôpital du Hasenrain'),
(3729, 'https://ror.org/04d4dxm04', 'fr', 1, 'https://ror.org/04d4dxm04 Société de Mathématiques Appliquées et de Sciences Humaines'),
(3730, 'https://ror.org/04d52ej85', 'en', 1, 'https://ror.org/04d52ej85 Lawrence Technological University Université technologique lawrence'),
(3731, 'https://ror.org/04d5k5771', 'en', 1, 'https://ror.org/04d5k5771 European Institute for Energy Research Europäisches Institut für Energieforschung'),
(3732, 'https://ror.org/04d5w7479', 'en', 1, 'https://ror.org/04d5w7479 Aurora Health Care'),
(3733, 'https://ror.org/04d6eav07', 'en', 1, 'https://ror.org/04d6eav07 Red Cross War Memorial Children''s Hospital'),
(3734, 'https://ror.org/04d7e4m76', 'en', 1, 'https://ror.org/04d7e4m76 I-Shou University'),
(3735, 'https://ror.org/04d7es448', 'it', 1, 'https://ror.org/04d7es448 Azienda Ospedaliera Universitaria "San Martino", Ospedale Policlinico San Martino'),
(3736, 'https://ror.org/04d7ez939', 'en', 1, 'https://ror.org/04d7ez939 VA Eastern Colorado Health Care System'),
(3737, 'https://ror.org/04d8ymc03', 'en', 1, 'https://ror.org/04d8ymc03 Doai Memorial Hospital 同愛記念病院'),
(3738, 'https://ror.org/04d9g9604', 'en', 1, 'https://ror.org/04d9g9604 Sankt Hans Hospital'),
(3739, 'https://ror.org/04dc8es52', 'de', 1, 'https://ror.org/04dc8es52 Klinik Donaustauf'),
(3740, 'https://ror.org/04dd5bw95', 'en', 1, 'https://ror.org/04dd5bw95 Fujisawa City Hospital 藤沢市民病院'),
(3741, 'https://ror.org/04df9p911', 'no_lang_code', 1, 'https://ror.org/04df9p911 Biorem Technologies (Canada)'),
(3742, 'https://ror.org/04dhg0348', 'en', 1, 'https://ror.org/04dhg0348 Heidelberg Repatriation Hospital'),
(3743, 'https://ror.org/04djj4v98', 'es', 1, 'https://ror.org/04djj4v98 Buenos Aires British Hospital Hospital Británico de Buenos Aires'),
(3744, 'https://ror.org/04dm1cm79', 'de', 1, 'https://ror.org/04dm1cm79 Universitätsmedizin Rostock'),
(3745, 'https://ror.org/04dms0022', 'fr', 1, 'https://ror.org/04dms0022 Hôpital de la Tour'),
(3746, 'https://ror.org/04dngzj56', 'en', 1, 'https://ror.org/04dngzj56 American University of Armenia Հայաստանի ամերիկյան համալսարան'),
(3747, 'https://ror.org/04dns5t03', 'en', 1, 'https://ror.org/04dns5t03 Brighton General Hospital'),
(3748, 'https://ror.org/04dnsc767', 'en', 1, 'https://ror.org/04dnsc767 Burke Rehabilitation Hospital'),
(3749, 'https://ror.org/04drvxt59', 'en', 1, 'https://ror.org/04drvxt59 Beth Israel Deaconess Medical Center'),
(3750, 'https://ror.org/04ds03q08', 'no_lang_code', 1, 'https://ror.org/04ds03q08 Mita Hospital 国際医療福祉大学三田病院'),
(3751, 'https://ror.org/04dt6a039', 'en', 1, 'https://ror.org/04dt6a039 Military Medical Academy Војномедицинска академија'),
(3752, 'https://ror.org/04dwjqq87', 'en', 1, 'https://ror.org/04dwjqq87 Tanglewood Research'),
(3753, 'https://ror.org/04dx82x73', 'en', 1, 'https://ror.org/04dx82x73 Nanning Normal University 南宁师范大学'),
(3754, 'https://ror.org/04dzhx486', 'en', 1, 'https://ror.org/04dzhx486 Exeter Hospital'),
(3755, 'https://ror.org/04dzpzw79', 'en', 1, 'https://ror.org/04dzpzw79 National Health Promotion Associates'),
(3756, 'https://ror.org/04dzvew28', 'en', 1, 'https://ror.org/04dzvew28 Hackensack University Medical Center Mountainside'),
(3757, 'https://ror.org/04dzvks42', 'en', 1, 'https://ror.org/04dzvks42 XinHua Hospital 上海交通大学医学院附属新华医院'),
(3758, 'https://ror.org/04e0j1059', 'en', 1, 'https://ror.org/04e0j1059 Bethune-Cookman University'),
(3759, 'https://ror.org/04e1w6923', 'fr', 1, 'https://ror.org/04e1w6923 Hôpital d''Hautepierre'),
(3760, 'https://ror.org/04e2x2229', 'en', 1, 'https://ror.org/04e2x2229 Lala Lajpat Rai Memorial Medical College'),
(3761, 'https://ror.org/04e4abg78', 'no_lang_code', 1, 'https://ror.org/04e4abg78 Nantan General Hospital 公立南丹病院'),
(3762, 'https://ror.org/04e4jbv10', 'fr', 1, 'https://ror.org/04e4jbv10 Institut de Recherche Robert-Sauvé en Santé et en Sécurité du Travail Occupational Health and Safety Research Institute'),
(3763, 'https://ror.org/04e5j7m81', 'en', 1, 'https://ror.org/04e5j7m81 American Society of Mechanical Engineers'),
(3764, 'https://ror.org/04e79zk25', 'en', 1, 'https://ror.org/04e79zk25 Institute for Medical Informatics and Biostatistics'),
(3765, 'https://ror.org/04e7bpp71', 'no_lang_code', 1, 'https://ror.org/04e7bpp71 King Fahad Hospital Hufūf'),
(3766, 'https://ror.org/04e857469', 'it', 1, 'https://ror.org/04e857469 Ospedale Regina Margherita Regina Margherita hospital'),
(3767, 'https://ror.org/04e8jbs38', 'en', 1, 'https://ror.org/04e8jbs38 Helmut Schmidt University Helmut-Schmidt-Universität'),
(3768, 'https://ror.org/04e8mq383', 'en', 1, 'https://ror.org/04e8mq383 Hyogo Prefectural Amagasaki General Medical Center 兵庫県立尼崎総合医療センター'),
(3769, 'https://ror.org/04edns687', 'en', 1, 'https://ror.org/04edns687 Northeastern Illinois University'),
(3770, 'https://ror.org/04ejkkg63', 'en', 1, 'https://ror.org/04ejkkg63 Ecologic Institute'),
(3771, 'https://ror.org/04epb4p87', 'en', 1, 'https://ror.org/04epb4p87 Zhejiang Chinese Medical University 浙江中医药大学'),
(3772, 'https://ror.org/04esata81', 'en', 1, 'https://ror.org/04esata81 European Science Foundation'),
(3773, 'https://ror.org/04esb6v42', 'en', 1, 'https://ror.org/04esb6v42 Imam Hossein University دانشگاه امام حسین'),
(3774, 'https://ror.org/04esegk75', 'en', 1, 'https://ror.org/04esegk75 Allina Health'),
(3775, 'https://ror.org/04esvpn06', 'en', 1, 'https://ror.org/04esvpn06 Université d''État de virginie Virginia State University'),
(3776, 'https://ror.org/04etaja30', 'no_lang_code', 1, 'https://ror.org/04etaja30 Beijing YouAn Hospital 北京佑安医院'),
(3777, 'https://ror.org/04evcxq23', 'it', 1, 'https://ror.org/04evcxq23 Consorzio Nazionale Interuniversitario per i Trasporti e la Logistica'),
(3778, 'https://ror.org/04evw4v13', 'pt', 1, 'https://ror.org/04evw4v13 Instituto Superior de Paços de Brandão'),
(3779, 'https://ror.org/04ezg6d83', 'en', 1, 'https://ror.org/04ezg6d83 Toyohashi University of Technology 豊橋技術科学大学'),
(3780, 'https://ror.org/04f2pye70', 'en', 1, 'https://ror.org/04f2pye70 St. Jude Medical Center'),
(3781, 'https://ror.org/04f3vmh71', 'tr', 1, 'https://ror.org/04f3vmh71 Medeniyet Üniversitesi Göztepe Eğitim ve Araştırma Hastanesi'),
(3782, 'https://ror.org/04f4syj68', 'it', 1, 'https://ror.org/04f4syj68 Polo Universitario Città di Prato'),
(3783, 'https://ror.org/04f558b63', 'pt', 1, 'https://ror.org/04f558b63 Centro Universitário Filadélfia'),
(3784, 'https://ror.org/04f6p2t28', 'en', 1, 'https://ror.org/04f6p2t28 Hospital Labbafinejad بیمارستان لبافی‌نژ'),
(3785, 'https://ror.org/04f761z39', 'pt', 1, 'https://ror.org/04f761z39 Instituto Superior da Maia'),
(3786, 'https://ror.org/04f812k67', 'en', 1, 'https://ror.org/04f812k67 Palo Alto University'),
(3787, 'https://ror.org/04f86t017', 'es', 1, 'https://ror.org/04f86t017 Hospital de Especialidades'),
(3788, 'https://ror.org/04faw9m73', 'sv', 1, 'https://ror.org/04faw9m73 Hallands sjukhus Halmstad'),
(3789, 'https://ror.org/04fbnx371', 'en', 1, 'https://ror.org/04fbnx371 West Virginia University Hospitals'),
(3790, 'https://ror.org/04fc1dc24', 'en', 1, 'https://ror.org/04fc1dc24 Dorset County Hospital'),
(3791, 'https://ror.org/04fdkjq44', 'en', 1, 'https://ror.org/04fdkjq44 Methodist University Hospital'),
(3792, 'https://ror.org/04fj0p555', 'en', 1, 'https://ror.org/04fj0p555 Tata Main Hospital'),
(3793, 'https://ror.org/04fkbqt11', 'ro', 1, 'https://ror.org/04fkbqt11 Hospital Colentina Spitalul Clinic Colentina'),
(3794, 'https://ror.org/04fp78s33', 'en', 1, 'https://ror.org/04fp78s33 Hunter Holmes McGuire VA Medical Center'),
(3795, 'https://ror.org/04fp9fm22', 'en', 1, 'https://ror.org/04fp9fm22 National University Hospital'),
(3796, 'https://ror.org/04fpj6846', 'en', 1, 'https://ror.org/04fpj6846 Iowa Medical Society'),
(3797, 'https://ror.org/04frzv033', 'en', 1, 'https://ror.org/04frzv033 Institute of Medical Biology'),
(3798, 'https://ror.org/04fs4yy09', 'en', 1, 'https://ror.org/04fs4yy09 Lakewood Regional Medical Center'),
(3799, 'https://ror.org/04fv66053', 'en', 1, 'https://ror.org/04fv66053 American Health Care Association'),
(3800, 'https://ror.org/04fvmv716', 'it', 1, 'https://ror.org/04fvmv716 Ospedale Vito Fazzi'),
(3801, 'https://ror.org/04fw3kw37', 'en', 1, 'https://ror.org/04fw3kw37 Shri Maharaja Hari Singh Hospital'),
(3802, 'https://ror.org/04fwa4t58', 'en', 1, 'https://ror.org/04fwa4t58 Harefield Hospital'),
(3803, 'https://ror.org/04fwyqr44', 'en', 1, 'https://ror.org/04fwyqr44 International Goodwill Hospital 国際親善総合病院'),
(3804, 'https://ror.org/04fyasj17', 'en', 1, 'https://ror.org/04fyasj17 Nagoya Central Hospital 名古屋セントラル病院'),
(3805, 'https://ror.org/04fybn584', 'en', 1, 'https://ror.org/04fybn584 Universidad del Cauca University of Cauca'),
(3806, 'https://ror.org/04fz99q08', 'en', 1, 'https://ror.org/04fz99q08 Minami Wakayama Medical Center 国立病院機構南和歌山医療センタ'),
(3807, 'https://ror.org/04g0bt697', 'en', 1, 'https://ror.org/04g0bt697 MultiCare Health System'),
(3808, 'https://ror.org/04g27v387', 'ca', 1, 'https://ror.org/04g27v387 Hospital Universitari de Girona Doctor Josep Trueta Residencia Sanitaria de la Seguridad Social de Gerona'),
(3809, 'https://ror.org/04g2hhm55', 'en', 1, 'https://ror.org/04g2hhm55 Birmingham General Hospital'),
(3810, 'https://ror.org/04g33m791', 'en', 1, 'https://ror.org/04g33m791 Norrköping Hospital'),
(3811, 'https://ror.org/04g3dn724', 'en', 1, 'https://ror.org/04g3dn724 Massachusetts Eye and Ear Infirmary'),
(3812, 'https://ror.org/04g3stk86', 'sv', 1, 'https://ror.org/04g3stk86 Länssjukhuset i Kalmar'),
(3813, 'https://ror.org/04g3t6s80', 'en', 1, 'https://ror.org/04g3t6s80 National Institute of Occupational Health'),
(3814, 'https://ror.org/04g43x563', 'en', 1, 'https://ror.org/04g43x563 Minnesota Department of Health'),
(3815, 'https://ror.org/04g7tnd56', 'en', 1, 'https://ror.org/04g7tnd56 North Maharashtra University उत्तर महाराष्ट्र विश्वविद्यालय'),
(3816, 'https://ror.org/04g8hwy69', 'en', 1, 'https://ror.org/04g8hwy69 Holy Cross Hospital'),
(3817, 'https://ror.org/04g9xj393', 'en', 1, 'https://ror.org/04g9xj393 Legacy Health'),
(3818, 'https://ror.org/04gbhgc79', 'en', 1, 'https://ror.org/04gbhgc79 Hôpital Général de Montréal Montreal General Hospital'),
(3819, 'https://ror.org/04gd4wn47', 'en', 1, 'https://ror.org/04gd4wn47 Arabian Gulf University جامعة الخليج العربي دانشگاه خلیج عربی'),
(3820, 'https://ror.org/04gfeaw48', 'en', 1, 'https://ror.org/04gfeaw48 Southern Utah University'),
(3821, 'https://ror.org/04gh26240', 'en', 1, 'https://ror.org/04gh26240 Mount Gould Hospital'),
(3822, 'https://ror.org/04ghtpd15', 'en', 1, 'https://ror.org/04ghtpd15 Institute of Child Health ινστιτούτο υγείας του παιδιού'),
(3823, 'https://ror.org/04gjkkf30', 'en', 1, 'https://ror.org/04gjkkf30 Banner Sun Health Research Institute'),
(3824, 'https://ror.org/04gknbs13', 'en', 1, 'https://ror.org/04gknbs13 National Chiayi University 國立嘉義大學'),
(3825, 'https://ror.org/04gmtmm57', 'no_lang_code', 1, 'https://ror.org/04gmtmm57 Misgav Ladach מִשְׂגָּב לַדָּךְ'),
(3826, 'https://ror.org/04gnvnd68', 'en', 1, 'https://ror.org/04gnvnd68 AnMed Health Medical Center'),
(3827, 'https://ror.org/04gpcyk21', 'en', 1, 'https://ror.org/04gpcyk21 Japan Women''s University 日本女子大学'),
(3828, 'https://ror.org/04gpfvy81', 'nl', 1, 'https://ror.org/04gpfvy81 Elisabeth-TweeSteden Ziekenhuis'),
(3829, 'https://ror.org/04gqx4x78', 'it', 1, 'https://ror.org/04gqx4x78 Campus Bio-Medico University Università Campus Bio-Medico');
INSERT INTO `rors` VALUES
(3830, 'https://ror.org/04grcvp20', 'no_lang_code', 1, 'https://ror.org/04grcvp20 Ingenieria Y Economia Del Transporte'),
(3831, 'https://ror.org/04gs6xd08', 'en', 1, 'https://ror.org/04gs6xd08 Sjællands universitetshospital, Køge Zealand University Hospital Køge'),
(3832, 'https://ror.org/04gt4je81', 'sv', 1, 'https://ror.org/04gt4je81 Lasarettet i Motala'),
(3833, 'https://ror.org/04gw05r18', 'fr', 1, 'https://ror.org/04gw05r18 Centre Hospitalier Victor Dupouy'),
(3834, 'https://ror.org/04gzbav43', 'en', 1, 'https://ror.org/04gzbav43 Amirkabir University of Technology دانشگاه صنعتی امیرکبیر'),
(3835, 'https://ror.org/04h3ct388', 'en', 1, 'https://ror.org/04h3ct388 Imo State University Teaching Hospital'),
(3836, 'https://ror.org/04h687w28', 'no_lang_code', 1, 'https://ror.org/04h687w28 Khalili Hospital بیمارستان خلیلی'),
(3837, 'https://ror.org/04h74qb21', 'en', 1, 'https://ror.org/04h74qb21 Pilgrim Hospital'),
(3838, 'https://ror.org/04h7nbn38', 'en', 1, 'https://ror.org/04h7nbn38 Canberra Hospital'),
(3839, 'https://ror.org/04hahwc19', 'en', 1, 'https://ror.org/04hahwc19 Meiji University of Integrative Medicine 明治国際医療大学'),
(3840, 'https://ror.org/04hbpw172', 'en', 1, 'https://ror.org/04hbpw172 Punjab Medical College'),
(3841, 'https://ror.org/04hcg0q34', 'en', 1, 'https://ror.org/04hcg0q34 Alameda Health System'),
(3842, 'https://ror.org/04hgm3062', 'en', 1, 'https://ror.org/04hgm3062 Iowa City VA Health Care System'),
(3843, 'https://ror.org/04hj57858', 'en', 1, 'https://ror.org/04hj57858 Tokyo Metropolitan Children''s Medical Center 東京都子供の医療センター'),
(3844, 'https://ror.org/04hjf5k52', 'no_lang_code', 1, 'https://ror.org/04hjf5k52 Pivotal Labs'),
(3845, 'https://ror.org/04hjn8p44', 'en', 1, 'https://ror.org/04hjn8p44 Staten Island University Hospital'),
(3846, 'https://ror.org/04hk86037', 'en', 1, 'https://ror.org/04hk86037 Universidad de Matanzas "Camilo Cienfuegos" University of Matanzas, University of Matanzas "Camilo Cienfuegos"'),
(3847, 'https://ror.org/04hnqrf16', 'en', 1, 'https://ror.org/04hnqrf16 National Center of Public Health and Analyses Национален център по обществено здраве и анализи'),
(3848, 'https://ror.org/04hnrs676', 'pt', 1, 'https://ror.org/04hnrs676 Universidade de Mogi das Cruzes University of Mogi das Cruzes'),
(3849, 'https://ror.org/04hp86393', 'no_lang_code', 1, 'https://ror.org/04hp86393 National Grid (United Kingdom)'),
(3850, 'https://ror.org/04hsvgn43', 'en', 1, 'https://ror.org/04hsvgn43 Rangaraya Medical College'),
(3851, 'https://ror.org/04hzm4679', 'en', 1, 'https://ror.org/04hzm4679 National Institute for Occupational Health'),
(3852, 'https://ror.org/04hzs7842', 'fr', 1, 'https://ror.org/04hzs7842 Centre Hospitalier Edmond Garcin'),
(3853, 'https://ror.org/04hzsfs96', 'en', 1, 'https://ror.org/04hzsfs96 Hôpital adventiste porter Porter Adventist Hospital'),
(3854, 'https://ror.org/04j0szy54', 'fr', 1, 'https://ror.org/04j0szy54 Hôpital Boucicaut'),
(3855, 'https://ror.org/04j19h351', 'en', 1, 'https://ror.org/04j19h351 Chase Farm Hospital'),
(3856, 'https://ror.org/04j1w0q97', 'en', 1, 'https://ror.org/04j1w0q97 Islamic University ইসলামী বিশ্ববিদ্যালয়'),
(3857, 'https://ror.org/04j2cfe69', 'en', 1, 'https://ror.org/04j2cfe69 Tianjin Medical University Eye Hospital'),
(3858, 'https://ror.org/04j339g17', 'en', 1, 'https://ror.org/04j339g17 Tokyo Teishin Hospital 東京逓信病院'),
(3859, 'https://ror.org/04j36h363', 'en', 1, 'https://ror.org/04j36h363 Children''s Hospital & Medical Center'),
(3860, 'https://ror.org/04j3jhk11', 'en', 1, 'https://ror.org/04j3jhk11 San Antonio Uniformed Services Health Education Consortium'),
(3861, 'https://ror.org/04j3vr751', 'en', 1, 'https://ror.org/04j3vr751 Hunan University of Technology'),
(3862, 'https://ror.org/04j572391', 'en', 1, 'https://ror.org/04j572391 University Park Pathology Associates'),
(3863, 'https://ror.org/04j6ay666', 'en', 1, 'https://ror.org/04j6ay666 Akashi Medical Center 明石医療センター'),
(3864, 'https://ror.org/04j6dw954', 'en', 1, 'https://ror.org/04j6dw954 Have Dreams'),
(3865, 'https://ror.org/04j71m034', 'en', 1, 'https://ror.org/04j71m034 Saint Francis Health System'),
(3866, 'https://ror.org/04j7rhg40', 'no_lang_code', 1, 'https://ror.org/04j7rhg40 Prime Focus World'),
(3867, 'https://ror.org/04j9bvy88', 'en', 1, 'https://ror.org/04j9bvy88 BG University Hospital Bergmannsheil Bochum BG Universitätsklinikum Bergmannsheil Bochum'),
(3868, 'https://ror.org/04j9yn198', 'en', 1, 'https://ror.org/04j9yn198 Tianjin Hospital 天津市天津医院'),
(3869, 'https://ror.org/04jc0r179', 'no_lang_code', 1, 'https://ror.org/04jc0r179 UK Coal'),
(3870, 'https://ror.org/04jca3284', 'es', 1, 'https://ror.org/04jca3284 Hospital Metropolitano'),
(3871, 'https://ror.org/04jdq2t93', 'en', 1, 'https://ror.org/04jdq2t93 Aaron Diamond AIDS Research Center'),
(3872, 'https://ror.org/04je6yw13', 'en', 1, 'https://ror.org/04je6yw13 Cheikh Anta Diop University Université Cheikh Anta Diop'),
(3873, 'https://ror.org/04jer6b34', 'en', 1, 'https://ror.org/04jer6b34 Washington State Board of Education'),
(3874, 'https://ror.org/04jfnqt61', 'no_lang_code', 1, 'https://ror.org/04jfnqt61 Western Forest Products'),
(3875, 'https://ror.org/04jg4z821', 'no_lang_code', 1, 'https://ror.org/04jg4z821 Okayama Central Hospital 岡山中央病院'),
(3876, 'https://ror.org/04jjkfw48', 'en', 1, 'https://ror.org/04jjkfw48 Tirat Carmel Mental Health Center המרכז לבריאות הנפש'),
(3877, 'https://ror.org/04jjn8965', 'en', 1, 'https://ror.org/04jjn8965 Simpson College'),
(3878, 'https://ror.org/04jkbm032', 'en', 1, 'https://ror.org/04jkbm032 Stratheden Hospital'),
(3879, 'https://ror.org/04jkbnw46', 'en', 1, 'https://ror.org/04jkbnw46 Center for Infectious Disease Research'),
(3880, 'https://ror.org/04jkk6t02', 'no_lang_code', 1, 'https://ror.org/04jkk6t02 IQuum (United States)'),
(3881, 'https://ror.org/04jq4p608', 'pt', 1, 'https://ror.org/04jq4p608 Hospital Garcia de Orta'),
(3882, 'https://ror.org/04jq72f57', 'en', 1, 'https://ror.org/04jq72f57 Royal Darwin Hospital'),
(3883, 'https://ror.org/04jqj7p05', 'no_lang_code', 1, 'https://ror.org/04jqj7p05 Hitotsubashi University 一橋大学'),
(3884, 'https://ror.org/04js17g72', 'en', 1, 'https://ror.org/04js17g72 Ifakara Health Institute'),
(3885, 'https://ror.org/04jwmdy30', 'no_lang_code', 1, 'https://ror.org/04jwmdy30 XMG Studio (Canada)'),
(3886, 'https://ror.org/04jx7r642', 'no_lang_code', 1, 'https://ror.org/04jx7r642 Process Research Ortech (Canada)'),
(3887, 'https://ror.org/04jxcef68', 'en', 1, 'https://ror.org/04jxcef68 Royal Edinburgh Hospital'),
(3888, 'https://ror.org/04jy8zw69', 'en', 1, 'https://ror.org/04jy8zw69 Yehuda Abarbanel Mental Health Center אברבנאל - המרכז לבריאות הנפש'),
(3889, 'https://ror.org/04jztag35', 'en', 1, 'https://ror.org/04jztag35 Peking Union Medical College Hospital 北京协和医院'),
(3890, 'https://ror.org/04k093t90', 'en', 1, 'https://ror.org/04k093t90 Chaudhary Sarwan Kumar Himachal Pradesh Krishi Vishvavidyalaya'),
(3891, 'https://ror.org/04k0yqc48', 'en', 1, 'https://ror.org/04k0yqc48 Buskerud University College'),
(3892, 'https://ror.org/04k1cm432', 'en', 1, 'https://ror.org/04k1cm432 Saint Luke''s Hospital'),
(3893, 'https://ror.org/04k1f6611', 'en', 1, 'https://ror.org/04k1f6611 Maccabi Health Care Services מכבי שירותי בריאות‎'),
(3894, 'https://ror.org/04k26n974', 'pt', 1, 'https://ror.org/04k26n974 Instituto Superior Politécnico Gaya'),
(3895, 'https://ror.org/04k3jt835', 'en', 1, 'https://ror.org/04k3jt835 Ronald Reagan UCLA Medical Center'),
(3896, 'https://ror.org/04k6zqn86', 'en', 1, 'https://ror.org/04k6zqn86 Beijing Hua Xin Hospital 北京华信医院'),
(3897, 'https://ror.org/04k820v98', 'en', 1, 'https://ror.org/04k820v98 Saudi Aramco Medical Services Organization'),
(3898, 'https://ror.org/04k8zab17', 'en', 1, 'https://ror.org/04k8zab17 Alliant International University'),
(3899, 'https://ror.org/04ka38w49', 'da', 1, 'https://ror.org/04ka38w49 Svendborg Sygehus'),
(3900, 'https://ror.org/04kbvfy96', 'es', 1, 'https://ror.org/04kbvfy96 Hospital de Sagunto'),
(3901, 'https://ror.org/04kg3w865', 'no_lang_code', 1, 'https://ror.org/04kg3w865 Phylonix (United States)'),
(3902, 'https://ror.org/04kgqpx54', 'no_lang_code', 1, 'https://ror.org/04kgqpx54 Voestalpine (Austria)'),
(3903, 'https://ror.org/04kjpp702', 'en', 1, 'https://ror.org/04kjpp702 Kaiser Permanente Santa Rosa Medical Center'),
(3904, 'https://ror.org/04kk13p96', 'en', 1, 'https://ror.org/04kk13p96 Reading Hospital'),
(3905, 'https://ror.org/04kt0yt69', 'tr', 1, 'https://ror.org/04kt0yt69 Etimesgut Asker Hastanesi'),
(3906, 'https://ror.org/04kte4472', 'no_lang_code', 1, 'https://ror.org/04kte4472 Materials and Electrochemical Research (United States)'),
(3907, 'https://ror.org/04kvh1910', 'en', 1, 'https://ror.org/04kvh1910 Resurrection Health Care'),
(3908, 'https://ror.org/04ky9dq80', 'no_lang_code', 1, 'https://ror.org/04ky9dq80 Vaexjoe Energi Ab'),
(3909, 'https://ror.org/04ky9n739', 'no_lang_code', 1, 'https://ror.org/04ky9n739 Beijing Chuiyangliu Hospital 北京市垂杨柳医院'),
(3910, 'https://ror.org/04kzbp858', 'no_lang_code', 1, 'https://ror.org/04kzbp858 Agropur cooperative'),
(3911, 'https://ror.org/04kzhn079', 'en', 1, 'https://ror.org/04kzhn079 St. Joseph''s Hospital'),
(3912, 'https://ror.org/04m0kdq23', 'it', 1, 'https://ror.org/04m0kdq23 Ospedale Sant''Anna'),
(3913, 'https://ror.org/04m2hyg08', 'en', 1, 'https://ror.org/04m2hyg08 Maryland Science Center'),
(3914, 'https://ror.org/04m3xd186', 'pt', 1, 'https://ror.org/04m3xd186 Centro Universitário de Belo Horizonte, Centro Universitário de belo Horizonte'),
(3915, 'https://ror.org/04m61mj84', 'fr', 1, 'https://ror.org/04m61mj84 Centre Hospitalier Universitaire Henri-Mondor'),
(3916, 'https://ror.org/04m88de33', 'en', 1, 'https://ror.org/04m88de33 Froedtert Menomonee Falls Hospital'),
(3917, 'https://ror.org/04m8b1e20', 'en', 1, 'https://ror.org/04m8b1e20 Georgian Court University'),
(3918, 'https://ror.org/04m8bh175', 'no_lang_code', 1, 'https://ror.org/04m8bh175 Advanced Fuel Research (United States)'),
(3919, 'https://ror.org/04m8z4n60', 'en', 1, 'https://ror.org/04m8z4n60 Harris Health System'),
(3920, 'https://ror.org/04mat8m15', 'fi', 1, 'https://ror.org/04mat8m15 Reumasäätiön sairaala'),
(3921, 'https://ror.org/04mc30s43', 'no_lang_code', 1, 'https://ror.org/04mc30s43 Olivieri Foods'),
(3922, 'https://ror.org/04mc4md34', 'tr', 1, 'https://ror.org/04mc4md34 Rize Devlet Hastanesi'),
(3923, 'https://ror.org/04mc82d47', 'en', 1, 'https://ror.org/04mc82d47 Scientific Committee On Oceanic Research'),
(3924, 'https://ror.org/04mdycw91', 'no_lang_code', 1, 'https://ror.org/04mdycw91 Eurofins (France)'),
(3925, 'https://ror.org/04mf6js28', 'en', 1, 'https://ror.org/04mf6js28 Credit Valley Hospital'),
(3926, 'https://ror.org/04mgjym08', 'en', 1, 'https://ror.org/04mgjym08 Institute of Occupational Medicine and Environmental Health Instytut Medycyny Pracy i Zdrowia Środowiskowego'),
(3927, 'https://ror.org/04mh52z70', 'en', 1, 'https://ror.org/04mh52z70 Observatorio Astrofísico Smithsonian Smithsonian Astrophysical Observatory'),
(3928, 'https://ror.org/04mhx6838', 'en', 1, 'https://ror.org/04mhx6838 National Institute on Deafness and Other Communication Disorders'),
(3929, 'https://ror.org/04mkpd147', 'es', 1, 'https://ror.org/04mkpd147 Red Universitaria Nacional'),
(3930, 'https://ror.org/04mm17p39', 'en', 1, 'https://ror.org/04mm17p39 Novant Health Forsyth Medical Center'),
(3931, 'https://ror.org/04mpzkf73', 'en', 1, 'https://ror.org/04mpzkf73 Winthrop University'),
(3932, 'https://ror.org/04mqy3p58', 'pt', 1, 'https://ror.org/04mqy3p58 Instituto de Engenharia de Sistemas e Computadores Investigação e Desenvolvimento'),
(3933, 'https://ror.org/04mrdd905', 'en', 1, 'https://ror.org/04mrdd905 University of Wisconsin American Family Children''s Hospital'),
(3934, 'https://ror.org/04mszwh44', 'en', 1, 'https://ror.org/04mszwh44 Gerontological Society of America'),
(3935, 'https://ror.org/04mwdyf26', 'en', 1, 'https://ror.org/04mwdyf26 Al-Makassed Islamic Charitable Society Hospital'),
(3936, 'https://ror.org/04mx3cr06', 'en', 1, 'https://ror.org/04mx3cr06 Leighton Hospital'),
(3937, 'https://ror.org/04mxrtj31', 'en', 1, 'https://ror.org/04mxrtj31 Mater Children''s Hospital'),
(3938, 'https://ror.org/04my10541', 'en', 1, 'https://ror.org/04my10541 Centre of Advanced Studies'),
(3939, 'https://ror.org/04mzvw485', 'en', 1, 'https://ror.org/04mzvw485 Thai Moogambigai Dental College and Hospital'),
(3940, 'https://ror.org/04n4dcv16', 'en', 1, 'https://ror.org/04n4dcv16 Ardabil University of Medical Sciences دانشگاه علوم پزشکی اردبیل'),
(3941, 'https://ror.org/04n4f3r80', 'en', 1, 'https://ror.org/04n4f3r80 Military Hospital of Tunis'),
(3942, 'https://ror.org/04n9z8z70', 'en', 1, 'https://ror.org/04n9z8z70 New Mexico VA Health Care System'),
(3943, 'https://ror.org/04nbe0v26', 'en', 1, 'https://ror.org/04nbe0v26 Institute of Studies for the Integration of Systems l’Istituto di Studi per l’Integrazione dei Sistemi'),
(3944, 'https://ror.org/04nc9r025', 'en', 1, 'https://ror.org/04nc9r025 Colonial War Memorial Hospital'),
(3945, 'https://ror.org/04nctyb57', 'en', 1, 'https://ror.org/04nctyb57 Sharp Mary Birch Hospital for Women & Newborns'),
(3946, 'https://ror.org/04ned8342', 'en', 1, 'https://ror.org/04ned8342 Saint Michael''s Medical Center'),
(3947, 'https://ror.org/04nfc4n06', 'en', 1, 'https://ror.org/04nfc4n06 Franciscan Hospital for Children'),
(3948, 'https://ror.org/04ngpga37', 'en', 1, 'https://ror.org/04ngpga37 Park University'),
(3949, 'https://ror.org/04ngv0f69', 'en', 1, 'https://ror.org/04ngv0f69 Buffalo General Medical Center'),
(3950, 'https://ror.org/04nn0sh76', 'en', 1, 'https://ror.org/04nn0sh76 Mogilev State University of Food Technologies Магілёўскі дзяржаўны ўніверсітэт харчавання'),
(3951, 'https://ror.org/04npk0q16', 'en', 1, 'https://ror.org/04npk0q16 Animal Health Trust'),
(3952, 'https://ror.org/04npss011', 'en', 1, 'https://ror.org/04npss011 Gandhi Medical College गांधी चिकित्सा महाविद्यालय, भोपाल గాంధీ వైద్య కళాశాల'),
(3953, 'https://ror.org/04npy5k94', 'no_lang_code', 1, 'https://ror.org/04npy5k94 Intracom Telecom (Greece)'),
(3954, 'https://ror.org/04nq4c835', 'no_lang_code', 1, 'https://ror.org/04nq4c835 Okayama Saiseikai General Hospital 岡山済生会総合病院'),
(3955, 'https://ror.org/04nqv0v23', 'en', 1, 'https://ror.org/04nqv0v23 Lynn University'),
(3956, 'https://ror.org/04nr0c858', 'es', 1, 'https://ror.org/04nr0c858 Hospital Vozandes'),
(3957, 'https://ror.org/04nrjxa63', 'en', 1, 'https://ror.org/04nrjxa63 Shanghai Agrobiological Gene Center 上海市农业生物基因中心'),
(3958, 'https://ror.org/04nrs5002', 'en', 1, 'https://ror.org/04nrs5002 Helen Joseph Hospital'),
(3959, 'https://ror.org/04nt8b154', 'en', 1, 'https://ror.org/04nt8b154 Fukuoka University 福岡大学'),
(3960, 'https://ror.org/04nwm7739', 'en', 1, 'https://ror.org/04nwm7739 Oklahoma Baptist University'),
(3961, 'https://ror.org/04nx04y60', 'en', 1, 'https://ror.org/04nx04y60 Taichung Armed Forces General Hospital 國軍臺中總醫院'),
(3962, 'https://ror.org/04nyf1f54', 'en', 1, 'https://ror.org/04nyf1f54 Shanghai Center For Bioinformation Technology 上海生物信息技术研究中心'),
(3963, 'https://ror.org/04p405e02', 'en', 1, 'https://ror.org/04p405e02 Biblioteca del Congreso de Estados Unidos Bibliothèque du Congrès Library of Congress'),
(3964, 'https://ror.org/04p4s5b35', 'en', 1, 'https://ror.org/04p4s5b35 St. John''s Hospital'),
(3965, 'https://ror.org/04p7nde68', 'en', 1, 'https://ror.org/04p7nde68 Hakodate Central General Hospital 函館中央病院'),
(3966, 'https://ror.org/04pag4b70', 'fr', 1, 'https://ror.org/04pag4b70 Hôpital Jean-Verdier'),
(3967, 'https://ror.org/04pb6gq71', 'en', 1, 'https://ror.org/04pb6gq71 Orthopedic Specialty Hospital'),
(3968, 'https://ror.org/04pc31859', 'en', 1, 'https://ror.org/04pc31859 Stobhill Hospital'),
(3969, 'https://ror.org/04pc7j325', 'en', 1, 'https://ror.org/04pc7j325 Meir Medical Center מרכז רפואי מאיר'),
(3970, 'https://ror.org/04pcmf738', 'en', 1, 'https://ror.org/04pcmf738 Kempegowda Institute of Medical Sciences ಕೆಂಪೇಗೌಡ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),
(3971, 'https://ror.org/04pd9b824', 'no_lang_code', 1, 'https://ror.org/04pd9b824 Doosan (United Kingdom)'),
(3972, 'https://ror.org/04pf12f40', 'en', 1, 'https://ror.org/04pf12f40 Louisiana State University at Eunice Université d''État de louisiane à eunice'),
(3973, 'https://ror.org/04pf1fm38', 'en', 1, 'https://ror.org/04pf1fm38 Seirei Social Welfare Community'),
(3974, 'https://ror.org/04pmdg365', 'en', 1, 'https://ror.org/04pmdg365 Ulster Hospital'),
(3975, 'https://ror.org/04pne0d08', 'en', 1, 'https://ror.org/04pne0d08 Norton Medical Centre'),
(3976, 'https://ror.org/04pr9pz75', 'it', 1, 'https://ror.org/04pr9pz75 Azienda Ospedaliera San Giovanni Addolorata San Giovanni Addolorata Hospital'),
(3977, 'https://ror.org/04ptbrd12', 'en', 1, 'https://ror.org/04ptbrd12 Guilan University of Medical Sciences دانشگاه علوم پزشکی گیلان'),
(3978, 'https://ror.org/04pwc8466', 'en', 1, 'https://ror.org/04pwc8466 Johns Hopkins Bayview Medical Center'),
(3979, 'https://ror.org/04py1g812', 'en', 1, 'https://ror.org/04py1g812 Jiangsu Province Hospital 江苏省人民医院'),
(3980, 'https://ror.org/04pyrxz13', 'en', 1, 'https://ror.org/04pyrxz13 Southern California University of Health Sciences'),
(3981, 'https://ror.org/04pysv427', 'en', 1, 'https://ror.org/04pysv427 Lady Ridgeway Hospital for Children லேடி ரிட்ஜ்வே வைத்தியசாலையில் රිජ්වේ ආර්යා ළමා රෝහල'),
(3982, 'https://ror.org/04q48ey07', 'en', 1, 'https://ror.org/04q48ey07 National Institute of General Medical Sciences'),
(3983, 'https://ror.org/04qbdwc31', 'en', 1, 'https://ror.org/04qbdwc31 Southport and Formby District General Hospital'),
(3984, 'https://ror.org/04qcftj32', 'en', 1, 'https://ror.org/04qcftj32 UK Health and Environment Research Institute'),
(3985, 'https://ror.org/04qdwp261', 'es', 1, 'https://ror.org/04qdwp261 Hospital Clinico San Borja Arriaran, Hospital San Borja Arriarán'),
(3986, 'https://ror.org/04qesyg82', 'en', 1, 'https://ror.org/04qesyg82 Medical Education Institute'),
(3987, 'https://ror.org/04qgcgz06', 'en', 1, 'https://ror.org/04qgcgz06 University Hospital of North Durham'),
(3988, 'https://ror.org/04qj1gz53', 'de', 1, 'https://ror.org/04qj1gz53 Lukaskrankenhaus'),
(3989, 'https://ror.org/04qjnvx31', 'en', 1, 'https://ror.org/04qjnvx31 Brentwood Biomedical Research Institute'),
(3990, 'https://ror.org/04qk4yf71', 'en', 1, 'https://ror.org/04qk4yf71 Conemaugh Memorial Medical Center'),
(3991, 'https://ror.org/04qkq2m54', 'en', 1, 'https://ror.org/04qkq2m54 National Yunlin University of Science and Technology'),
(3992, 'https://ror.org/04qkymg17', 'no_lang_code', 1, 'https://ror.org/04qkymg17 Assuta Medical Center אסותא מרכזים רפואיים'),
(3993, 'https://ror.org/04qm8ac48', 'en', 1, 'https://ror.org/04qm8ac48 Philadelphia Department of Public Health'),
(3994, 'https://ror.org/04qma4821', 'pt', 1, 'https://ror.org/04qma4821 Hospital Pró-Cardíaco'),
(3995, 'https://ror.org/04qmkfe11', 'en', 1, 'https://ror.org/04qmkfe11 VA St. Louis Health Care System'),
(3996, 'https://ror.org/04qpegs24', 'en', 1, 'https://ror.org/04qpegs24 Resources For The Future'),
(3997, 'https://ror.org/04qqcs583', 'en', 1, 'https://ror.org/04qqcs583 National Hospital of Pediatrics'),
(3998, 'https://ror.org/04qs81248', 'en', 1, 'https://ror.org/04qs81248 Russells Hall Hospital'),
(3999, 'https://ror.org/04qvdf239', 'tr', 1, 'https://ror.org/04qvdf239 Bozok Universitesi Bozok University'),
(4000, 'https://ror.org/04qwmjc96', 'no_lang_code', 1, 'https://ror.org/04qwmjc96 BASF (Canada)'),
(4001, 'https://ror.org/04r0kzx48', 'en', 1, 'https://ror.org/04r0kzx48 Baker University'),
(4002, 'https://ror.org/04r17y386', 'en', 1, 'https://ror.org/04r17y386 Danish Health and Medicines Authority, National Board of Health Sundhedsstyrelsen'),
(4003, 'https://ror.org/04r33pf22', 'en', 1, 'https://ror.org/04r33pf22 Guy''s Hospital'),
(4004, 'https://ror.org/04r3ebn54', 'en', 1, 'https://ror.org/04r3ebn54 Oklahoma Foundation for Medical Quality'),
(4005, 'https://ror.org/04r5ess67', 'en', 1, 'https://ror.org/04r5ess67 Sleep and Human Health Institute'),
(4006, 'https://ror.org/04r61xa45', 'no_lang_code', 1, 'https://ror.org/04r61xa45 Saiseikai Ibaraki Hospital 大阪府済生会茨木病院'),
(4007, 'https://ror.org/04r69jb93', 'en', 1, 'https://ror.org/04r69jb93 Kokushikan University 国士舘大学'),
(4008, 'https://ror.org/04r9qdk92', 'tr', 1, 'https://ror.org/04r9qdk92 Kudret Eye Hospital Kudret Göz Hastanesi'),
(4009, 'https://ror.org/04rha3g10', 'en', 1, 'https://ror.org/04rha3g10 Queen Alexandra Hospital'),
(4010, 'https://ror.org/04rhdtb47', 'en', 1, 'https://ror.org/04rhdtb47 Obstetrics and Gynecology Hospital of Fudan University 复旦大学附属妇产科医院'),
(4011, 'https://ror.org/04rj5w171', 'en', 1, 'https://ror.org/04rj5w171 Olabisi Onabanjo University Teaching Hospital'),
(4012, 'https://ror.org/04rqpth59', 'en', 1, 'https://ror.org/04rqpth59 Boston Biomedical Research Institute'),
(4013, 'https://ror.org/04rr42t68', 'nl', 1, 'https://ror.org/04rr42t68 Jeroen Bosch Ziekenhuis'),
(4014, 'https://ror.org/04rsexf17', 'no_lang_code', 1, 'https://ror.org/04rsexf17 Stemcell Technologies'),
(4015, 'https://ror.org/04rssyw40', 'en', 1, 'https://ror.org/04rssyw40 Universitatea de Științe Agronomice și Medicină Veterinară din București University of Agronomic Sciences and Veterinary Medicine of Bucharest'),
(4016, 'https://ror.org/04rvm9c15', 'en', 1, 'https://ror.org/04rvm9c15 Southland Hospital'),
(4017, 'https://ror.org/04rvms649', 'es', 1, 'https://ror.org/04rvms649 Hospital Nuestra Señora de Alarcos'),
(4018, 'https://ror.org/04rx0dh54', 'en', 1, 'https://ror.org/04rx0dh54 Sansum Medical Clinic'),
(4019, 'https://ror.org/04rxn4y96', 'no_lang_code', 1, 'https://ror.org/04rxn4y96 Cell and Tissue Systems (United States)'),
(4020, 'https://ror.org/04s2yen12', 'en', 1, 'https://ror.org/04s2yen12 Letterkenny University Hospital Ospidéal Ginearálta Leitir Ceanainn'),
(4021, 'https://ror.org/04s36qm86', 'en', 1, 'https://ror.org/04s36qm86 Chelyabinsk State University Челябинский государственный университет'),
(4022, 'https://ror.org/04s4j9e43', 'en', 1, 'https://ror.org/04s4j9e43 Omar Bongo University Université Omar Bongo'),
(4023, 'https://ror.org/04s5n7912', 'en', 1, 'https://ror.org/04s5n7912 Science Research Laboratory'),
(4024, 'https://ror.org/04s7f5535', 'no_lang_code', 1, 'https://ror.org/04s7f5535 Beta Technology Limited'),
(4025, 'https://ror.org/04s8a8w57', 'en', 1, 'https://ror.org/04s8a8w57 University Hospital of the West Indies'),
(4026, 'https://ror.org/04s9hft57', 'en', 1, 'https://ror.org/04s9hft57 Quaid-i-Azam University جامعہ قائداعظم'),
(4027, 'https://ror.org/04sah3q11', 'en', 1, 'https://ror.org/04sah3q11 St. Francis Medical Center'),
(4028, 'https://ror.org/04saq4y86', 'en', 1, 'https://ror.org/04saq4y86 Indira Gandhi Institute of Child Health'),
(4029, 'https://ror.org/04sbcrt14', 'en', 1, 'https://ror.org/04sbcrt14 Bhavnagar University'),
(4030, 'https://ror.org/04scbtr44', 'es', 1, 'https://ror.org/04scbtr44 Hospital Universitario de Fuenlabrada'),
(4031, 'https://ror.org/04scfb908', 'en', 1, 'https://ror.org/04scfb908 Alfred Health'),
(4032, 'https://ror.org/04sexa105', 'en', 1, 'https://ror.org/04sexa105 Qazvin University of Medical Sciences دانشگاه علوم پزشكي و خدمات درماني قزوین'),
(4033, 'https://ror.org/04sfmcd28', 'fr', 1, 'https://ror.org/04sfmcd28 Centre Hospitalier Universitaire Pointe-à-Pitre'),
(4034, 'https://ror.org/04sgkca59', 'en', 1, 'https://ror.org/04sgkca59 Funabashi Central Hospital 船橋中央病院'),
(4035, 'https://ror.org/04sgy9050', 'pt', 1, 'https://ror.org/04sgy9050 Hospital Santa Marcelina'),
(4036, 'https://ror.org/04sh9kd82', 'en', 1, 'https://ror.org/04sh9kd82 Starship Children''s Health'),
(4037, 'https://ror.org/04shepe48', 'en', 1, 'https://ror.org/04shepe48 Chinese Culture University 中國文化大學'),
(4038, 'https://ror.org/04sheqe49', 'en', 1, 'https://ror.org/04sheqe49 Daisy Hill Hospital Otharlann Chnoc na Nóiníní'),
(4039, 'https://ror.org/04skjvf92', 'pt', 1, 'https://ror.org/04skjvf92 Hospital da Restauração'),
(4040, 'https://ror.org/04skph061', 'en', 1, 'https://ror.org/04skph061 Hospital de la Universidad de Nuevo México University of New Mexico Hospital'),
(4041, 'https://ror.org/04sq8k219', 'en', 1, 'https://ror.org/04sq8k219 University of Louisville Hospital'),
(4042, 'https://ror.org/04sr36h49', 'no_lang_code', 1, 'https://ror.org/04sr36h49 Seeders (South Korea)'),
(4043, 'https://ror.org/04ss1bw11', 'en', 1, 'https://ror.org/04ss1bw11 Tzu Chi University 慈濟大學'),
(4044, 'https://ror.org/04ssfah06', 'es', 1, 'https://ror.org/04ssfah06 Hospital Virgen de los Lirios'),
(4045, 'https://ror.org/04svdmv30', 'fr', 1, 'https://ror.org/04svdmv30 The Association of the European Rail Industry, Union des Industries Ferroviaires Européennes'),
(4046, 'https://ror.org/04sx7v519', 'fr', 1, 'https://ror.org/04sx7v519 Hôtel-Dieu de Lyon'),
(4047, 'https://ror.org/04sxj4848', 'en', 1, 'https://ror.org/04sxj4848 Sarah Lawrence College'),
(4048, 'https://ror.org/04sz7qx51', 'fr', 1, 'https://ror.org/04sz7qx51 Centre Hospitalier Universitaire de Rabat-Salé'),
(4049, 'https://ror.org/04szr1369', 'en', 1, 'https://ror.org/04szr1369 Guangzhou Chest Hospital 广州市胸科医院'),
(4050, 'https://ror.org/04t0s7x83', 'en', 1, 'https://ror.org/04t0s7x83 National Institute of Mental Health 国立精神衛生研究所'),
(4051, 'https://ror.org/04t23pb41', 'fr', 1, 'https://ror.org/04t23pb41 Hôpital Civil de Charleroi'),
(4052, 'https://ror.org/04t41ec74', 'en', 1, 'https://ror.org/04t41ec74 Father Muller Medical College Hospital फादर म्युलर मेडिकल कॉलेज பாதர் முல்லெர் மெடிக்கல் காலேஜ் ఫాదర్ ముల్లెర్ మెడికల్ కాలేజ్ ಫಾದೆರ್ ಮುಲ್ಲರ್ ಮೆಡಿಕಲ್ ಕಾಳಜ್ ഫാദർ മുള്ളെർ മെഡിക്കൽ കോളേജ്'),
(4053, 'https://ror.org/04t4jzh38', 'en', 1, 'https://ror.org/04t4jzh38 Notre Dame Seishin University ノートルダム清心女子大学'),
(4054, 'https://ror.org/04t6r6d34', 'en', 1, 'https://ror.org/04t6r6d34 International Space University'),
(4055, 'https://ror.org/04t6zb108', 'en', 1, 'https://ror.org/04t6zb108 University Hospitals Geneva Medical Center'),
(4056, 'https://ror.org/04t77r183', 'es', 1, 'https://ror.org/04t77r183 Hospital Ludovica Hospital de Niños Superiora Sor María Ludovica'),
(4057, 'https://ror.org/04tavf782', 'en', 1, 'https://ror.org/04tavf782 Beijing Computational Science Research Center 北京计算科学研究中心'),
(4058, 'https://ror.org/04tbm0m52', 'en', 1, 'https://ror.org/04tbm0m52 Pinderfields Hospital'),
(4059, 'https://ror.org/04tf4g123', 'en', 1, 'https://ror.org/04tf4g123 Sichuan Provincial Academy of Natural Resource Sciences 四川省自然资源科学院'),
(4060, 'https://ror.org/04tft4718', 'no_lang_code', 1, 'https://ror.org/04tft4718 Tamkang University 淡江大學'),
(4061, 'https://ror.org/04tm3k558', 'en', 1, 'https://ror.org/04tm3k558 Third Affiliated Hospital of Sun Yat-sen University'),
(4062, 'https://ror.org/04tpqnr72', 'en', 1, 'https://ror.org/04tpqnr72 Harold Wood Hospital'),
(4063, 'https://ror.org/04tqcn816', 'en', 1, 'https://ror.org/04tqcn816 Health Sciences University of Hokkaido 北海道医療大学'),
(4064, 'https://ror.org/04tr09862', 'en', 1, 'https://ror.org/04tr09862 Sequoia Hospital'),
(4065, 'https://ror.org/04ts4qa58', 'en', 1, 'https://ror.org/04ts4qa58 Changwon National University 창원대학교'),
(4066, 'https://ror.org/04ttjf776', 'en', 1, 'https://ror.org/04ttjf776 RMIT University'),
(4067, 'https://ror.org/04twccc71', 'en', 1, 'https://ror.org/04twccc71 National United University'),
(4068, 'https://ror.org/04tzy5g14', 'en', 1, 'https://ror.org/04tzy5g14 Missouri Botanical Garden'),
(4069, 'https://ror.org/04v00sg98', 'en', 1, 'https://ror.org/04v00sg98 VA Boston Healthcare System'),
(4070, 'https://ror.org/04v0wnx78', 'tr', 1, 'https://ror.org/04v0wnx78 Dr. Siyami Ersek Göğüs Kalp Ve Damar Cerrahisi Eğitim Ve Araştırma Hastanesi'),
(4071, 'https://ror.org/04v24dh28', 'en', 1, 'https://ror.org/04v24dh28 Sumitomo Besshi Hospital 住友別子病院'),
(4072, 'https://ror.org/04v3sec91', 'en', 1, 'https://ror.org/04v3sec91 Saint Mary''s University of Minnesota'),
(4073, 'https://ror.org/04v403p80', 'en', 1, 'https://ror.org/04v403p80 Consorzio Interuniversitario Risonanze Magnetiche di Metallo Proteine Interuniversity Consortium for Magnetic Resonance'),
(4074, 'https://ror.org/04v91tb50', 'es', 1, 'https://ror.org/04v91tb50 Complejo Hospitalario Torrecárdenas'),
(4075, 'https://ror.org/04v98kq37', 'no_lang_code', 1, 'https://ror.org/04v98kq37 Renault (France)'),
(4076, 'https://ror.org/04va7bx33', 'en', 1, 'https://ror.org/04va7bx33 Killingbeck'),
(4077, 'https://ror.org/04vccmr34', 'nl', 1, 'https://ror.org/04vccmr34 Medisch Centrum Alkmaar'),
(4078, 'https://ror.org/04vcxwm16', 'en', 1, 'https://ror.org/04vcxwm16 Mission Hospital'),
(4079, 'https://ror.org/04vdpck27', 'en', 1, 'https://ror.org/04vdpck27 Catholic University of the Maule Universidad Católica del Maule'),
(4080, 'https://ror.org/04vfsmv21', 'en', 1, 'https://ror.org/04vfsmv21 National Institutes of Health Clinical Center'),
(4081, 'https://ror.org/04vfyfx73', 'no_lang_code', 1, 'https://ror.org/04vfyfx73 Teer Coatings (United Kingdom)'),
(4082, 'https://ror.org/04vgkzj18', 'en', 1, 'https://ror.org/04vgkzj18 Ibaraki Prefectural University of Health Sciences 茨城県立医療大学'),
(4083, 'https://ror.org/04vhsg885', 'en', 1, 'https://ror.org/04vhsg885 Allama Iqbal Medical College علامہ اقبال میڈیکل کالج'),
(4084, 'https://ror.org/04vnz0695', 'no_lang_code', 1, 'https://ror.org/04vnz0695 Asahikawa Kosei Hospital 旭川厚生病院'),
(4085, 'https://ror.org/04vq5kb54', 'en', 1, 'https://ror.org/04vq5kb54 UCLA Medical Center'),
(4086, 'https://ror.org/04vqzd428', 'en', 1, 'https://ror.org/04vqzd428 Social Insurance Saitama Chuo Hospital 埼玉メディカルセンター'),
(4087, 'https://ror.org/04vrsb288', 'en', 1, 'https://ror.org/04vrsb288 Far Eastern State Medical University Дальневосточный государственный медицинский университет'),
(4088, 'https://ror.org/04vt4a111', 'en', 1, 'https://ror.org/04vt4a111 Behavioral Health Research Center of the Southwest'),
(4089, 'https://ror.org/04vtx5s55', 'en', 1, 'https://ror.org/04vtx5s55 University of Malawi'),
(4090, 'https://ror.org/04vxr4k74', 'no_lang_code', 1, 'https://ror.org/04vxr4k74 Sahmyook University 삼육대학교'),
(4091, 'https://ror.org/04vy5s568', 'en', 1, 'https://ror.org/04vy5s568 La Universidad del Zulia University of Zulia'),
(4092, 'https://ror.org/04w1m5n60', 'fr', 1, 'https://ror.org/04w1m5n60 Hôtel-Dieu de France'),
(4093, 'https://ror.org/04w3f9b42', 'no_lang_code', 1, 'https://ror.org/04w3f9b42 Takarazuka City Hospital 宝塚市立病院'),
(4094, 'https://ror.org/04w3ve464', 'no_lang_code', 1, 'https://ror.org/04w3ve464 Kyoto Katsura Hospital 京都桂病院'),
(4095, 'https://ror.org/04w40b524', 'en', 1, 'https://ror.org/04w40b524 Abderrahmane Mami Hospital'),
(4096, 'https://ror.org/04waphv22', 'en', 1, 'https://ror.org/04waphv22 Tamil Nadu Veterinary and Animal Sciences University தமிழ்நாடு கால்நடை மருத்துவ அறிவியல் பல்கலைக்கழகம்'),
(4097, 'https://ror.org/04wbhy398', 'pl', 1, 'https://ror.org/04wbhy398 Wojewódzki Szpital Zespolony'),
(4098, 'https://ror.org/04wbsx459', 'en', 1, 'https://ror.org/04wbsx459 Nambour General Hospital'),
(4099, 'https://ror.org/04wc5jk96', 'en', 1, 'https://ror.org/04wc5jk96 Hôpital de Montréal pour enfants Montreal Children''s Hospital'),
(4100, 'https://ror.org/04wd31514', 'no_lang_code', 1, 'https://ror.org/04wd31514 CFD Research Corporation (United States)'),
(4101, 'https://ror.org/04whfy367', 'en', 1, 'https://ror.org/04whfy367 Memorial Hospital of South Bend'),
(4102, 'https://ror.org/04wm83d45', 'en', 1, 'https://ror.org/04wm83d45 Selma University'),
(4103, 'https://ror.org/04wmhsz10', 'en', 1, 'https://ror.org/04wmhsz10 Sandwell General Hospital'),
(4104, 'https://ror.org/04wn28048', 'en', 1, 'https://ror.org/04wn28048 University of Tulsa Université de tulsa'),
(4105, 'https://ror.org/04wngnd82', 'en', 1, 'https://ror.org/04wngnd82 University Heights Center'),
(4106, 'https://ror.org/04wnwd012', 'en', 1, 'https://ror.org/04wnwd012 Education Development Center'),
(4107, 'https://ror.org/04wpkfc35', 'fr', 1, 'https://ror.org/04wpkfc35 Hôpital d''Instruction des Armées Sainte-Anne'),
(4108, 'https://ror.org/04wpmby09', 'en', 1, 'https://ror.org/04wpmby09 Memorial Regional Hospital'),
(4109, 'https://ror.org/04wprr919', 'en', 1, 'https://ror.org/04wprr919 Athens Eye Hospital Οφθαλμολογικό Νοσοκομείο Αθηνών'),
(4110, 'https://ror.org/04wrfcw61', 'en', 1, 'https://ror.org/04wrfcw61 Sanford USD Medical Center'),
(4111, 'https://ror.org/04ws1n245', 'en', 1, 'https://ror.org/04ws1n245 King Fahad Hospital Jeddah مستشفى الملك فهد بجدة'),
(4112, 'https://ror.org/04ws6z706', 'en', 1, 'https://ror.org/04ws6z706 Saint Xavier University'),
(4113, 'https://ror.org/04wwbpd10', 'no_lang_code', 1, 'https://ror.org/04wwbpd10 Biomedware (United States)'),
(4114, 'https://ror.org/04wwg3z97', 'no_lang_code', 1, 'https://ror.org/04wwg3z97 Dammam Central Hospital مستشفى الدمام المركزي'),
(4115, 'https://ror.org/04x0k0m51', 'en', 1, 'https://ror.org/04x0k0m51 Seokyeong University 서경대학교'),
(4116, 'https://ror.org/04x0r0b44', 'en', 1, 'https://ror.org/04x0r0b44 Connecticut Department of Mental Health and Addiction Services'),
(4117, 'https://ror.org/04x0wqd92', 'en', 1, 'https://ror.org/04x0wqd92 Tokyo Rosai Hospital 東京労災病院'),
(4118, 'https://ror.org/04x16j349', 'no_lang_code', 1, 'https://ror.org/04x16j349 Invotek'),
(4119, 'https://ror.org/04x16yc34', 'no_lang_code', 1, 'https://ror.org/04x16yc34 Al Nahdha Hospital مستشفى النهضة'),
(4120, 'https://ror.org/04x1ptk36', 'en', 1, 'https://ror.org/04x1ptk36 Ibis Reproductive Health'),
(4121, 'https://ror.org/04x1z3t86', 'en', 1, 'https://ror.org/04x1z3t86 Mercy St. Vincent Medical Center'),
(4122, 'https://ror.org/04x27ad97', 'en', 1, 'https://ror.org/04x27ad97 Baby Memorial Hospital'),
(4123, 'https://ror.org/04x41ba23', 'en', 1, 'https://ror.org/04x41ba23 Captain James A. Lovell Federal Health Care Center'),
(4124, 'https://ror.org/04x495f64', 'en', 1, 'https://ror.org/04x495f64 Rainbow Babies & Children''s Hospital'),
(4125, 'https://ror.org/04x744g62', 'en', 1, 'https://ror.org/04x744g62 Shin Kong WHS Memorial Hospital'),
(4126, 'https://ror.org/04xbrv698', 'en', 1, 'https://ror.org/04xbrv698 Institut für Mobil- und Satellitenfunktechnik Institute for Mobile and Satellite Communication Technology'),
(4127, 'https://ror.org/04xdbp773', 'no_lang_code', 1, 'https://ror.org/04xdbp773 Academic Edge'),
(4128, 'https://ror.org/04xeg9z08', 'en', 1, 'https://ror.org/04xeg9z08 Instituto Nacional de Salud Mental National Institute of Mental Health'),
(4129, 'https://ror.org/04xfhjr27', 'en', 1, 'https://ror.org/04xfhjr27 Great Western Hospital'),
(4130, 'https://ror.org/04xfsbk97', 'en', 1, 'https://ror.org/04xfsbk97 Shenzhen Third People’s Hospital 深圳市第三人民医院'),
(4131, 'https://ror.org/04xhnr923', 'no_lang_code', 1, 'https://ror.org/04xhnr923 Hyogo Prefectural Nishinomiya Hospital 兵庫県立西宮病院'),
(4132, 'https://ror.org/04xnzxv25', 'en', 1, 'https://ror.org/04xnzxv25 Khyber Teaching Hospital'),
(4133, 'https://ror.org/04xpmtk39', 'en', 1, 'https://ror.org/04xpmtk39 Southern Hills Medical Center'),
(4134, 'https://ror.org/04xraxn18', 'en', 1, 'https://ror.org/04xraxn18 Fondazione Telethon Telethon Foundation'),
(4135, 'https://ror.org/04xsjmh40', 'en', 1, 'https://ror.org/04xsjmh40 American Society for Microbiology'),
(4136, 'https://ror.org/04xtpk854', 'en', 1, 'https://ror.org/04xtpk854 Manchester Royal Eye Hospital'),
(4137, 'https://ror.org/04xv01a59', 'en', 1, 'https://ror.org/04xv01a59 The Pirbright Institute'),
(4138, 'https://ror.org/04xv63e47', 'en', 1, 'https://ror.org/04xv63e47 Sin-Lau Christian Hospital'),
(4139, 'https://ror.org/04xvkcm66', 'no_lang_code', 1, 'https://ror.org/04xvkcm66 Apption'),
(4140, 'https://ror.org/04xz2c768', 'en', 1, 'https://ror.org/04xz2c768 R. K. Khan Hospital'),
(4141, 'https://ror.org/04xze1462', 'no_lang_code', 1, 'https://ror.org/04xze1462 Nokia (Belgium)'),
(4142, 'https://ror.org/04xzj3x20', 'en', 1, 'https://ror.org/04xzj3x20 LAC+USC Medical Center'),
(4143, 'https://ror.org/04y0sey15', 'en', 1, 'https://ror.org/04y0sey15 Oasis of Hope Hospital'),
(4144, 'https://ror.org/04y28m257', 'no_lang_code', 1, 'https://ror.org/04y28m257 SOLINET'),
(4145, 'https://ror.org/04y2gp806', 'en', 1, 'https://ror.org/04y2gp806 King Fahad Central Hospital مستشفى الملك فهد المركزي بجازان'),
(4146, 'https://ror.org/04y2hdd14', 'no_lang_code', 1, 'https://ror.org/04y2hdd14 Amiri Hospital المستشفى الأميري'),
(4147, 'https://ror.org/04y3ze847', 'en', 1, 'https://ror.org/04y3ze847 Ospidéal na hOllscoile, Luimneach University Hospital Limerick'),
(4148, 'https://ror.org/04y6m3r89', 'en', 1, 'https://ror.org/04y6m3r89 Arkansas State Department of Human Services'),
(4149, 'https://ror.org/04y71bh49', 'en', 1, 'https://ror.org/04y71bh49 Southern University at Shreveport'),
(4150, 'https://ror.org/04y908s98', 'en', 1, 'https://ror.org/04y908s98 Government Medical College'),
(4151, 'https://ror.org/04yajdn66', 'en', 1, 'https://ror.org/04yajdn66 Wuhan Medical Center for Women and Children'),
(4152, 'https://ror.org/04yb7hq57', 'en', 1, 'https://ror.org/04yb7hq57 Stavropol State Medical University Ставропольский государственный медицинский университет'),
(4153, 'https://ror.org/04ycpbx82', 'en', 1, 'https://ror.org/04ycpbx82 Prifysgol Westminster University of Westminster'),
(4154, 'https://ror.org/04yd6pw26', 'en', 1, 'https://ror.org/04yd6pw26 Cape Cod Hospital'),
(4155, 'https://ror.org/04ye60n79', 'en', 1, 'https://ror.org/04ye60n79 Tikur Anbessa Hospital ጥቁር አንበሳ ሆስፒታል'),
(4156, 'https://ror.org/04yj19304', 'en', 1, 'https://ror.org/04yj19304 California Baptist University'),
(4157, 'https://ror.org/04ymee833', 'en', 1, 'https://ror.org/04ymee833 Central Institute for the Deaf'),
(4158, 'https://ror.org/04ymr6s03', 'en', 1, 'https://ror.org/04ymr6s03 Launceston General Hospital'),
(4159, 'https://ror.org/04yrw5x43', 'it', 1, 'https://ror.org/04yrw5x43 Ospedale di Livorno'),
(4160, 'https://ror.org/04ytrbh65', 'en', 1, 'https://ror.org/04ytrbh65 Osaka University of Health and Sport Sciences 大阪体育大学'),
(4161, 'https://ror.org/04ywg3445', 'no_lang_code', 1, 'https://ror.org/04ywg3445 New England Biolabs (United States)'),
(4162, 'https://ror.org/04yxtqc27', 'en', 1, 'https://ror.org/04yxtqc27 Caroline Chisholm Centre for Health Ethics'),
(4163, 'https://ror.org/04yy7zb66', 'en', 1, 'https://ror.org/04yy7zb66 Centre for Mental Health'),
(4164, 'https://ror.org/04yyp8h20', 'no_lang_code', 1, 'https://ror.org/04yyp8h20 Pilkington (United Kingdom)'),
(4165, 'https://ror.org/04z18y971', 'no_lang_code', 1, 'https://ror.org/04z18y971 Jennerex Biotherapeutics (Canada)'),
(4166, 'https://ror.org/04z1c5686', 'no_lang_code', 1, 'https://ror.org/04z1c5686 Encana (Canada)'),
(4167, 'https://ror.org/04z5vy146', 'en', 1, 'https://ror.org/04z5vy146 Carlo Forlanini Hospital'),
(4168, 'https://ror.org/04z61sd03', 'en', 1, 'https://ror.org/04z61sd03 Alder Hey Children''s Hospital'),
(4169, 'https://ror.org/04z7fc725', 'en', 1, 'https://ror.org/04z7fc725 St.John''s Medical College Hospital'),
(4170, 'https://ror.org/04z89xx32', 'en', 1, 'https://ror.org/04z89xx32 Atlanta VA Medical Center'),
(4171, 'https://ror.org/04z9w5078', 'no_lang_code', 1, 'https://ror.org/04z9w5078 Xerox (Canada)'),
(4172, 'https://ror.org/04z9zma62', 'en', 1, 'https://ror.org/04z9zma62 American Hospital Association'),
(4173, 'https://ror.org/04zah8g26', 'no_lang_code', 1, 'https://ror.org/04zah8g26 Pouliadis Associates Corporation'),
(4174, 'https://ror.org/04zap7912', 'en', 1, 'https://ror.org/04zap7912 Yunnan University of Traditional Chinese Medicine 云南中医药大学'),
(4175, 'https://ror.org/04zb59n70', 'en', 1, 'https://ror.org/04zb59n70 Leibniz Institute for Solid State and Materials Research Leibniz-Institut für Festkörper- und Werkstoffforschung Dresden'),
(4176, 'https://ror.org/04zbgcp34', 'no_lang_code', 1, 'https://ror.org/04zbgcp34 Kantar Health (United States)'),
(4177, 'https://ror.org/04zbkyt39', 'en', 1, 'https://ror.org/04zbkyt39 National Hispanic University'),
(4178, 'https://ror.org/04zfmcq84', 'en', 1, 'https://ror.org/04zfmcq84 Children''s Mercy Hospital'),
(4179, 'https://ror.org/04zgkpa58', 'en', 1, 'https://ror.org/04zgkpa58 Health Protection Scotland'),
(4180, 'https://ror.org/04zgvbn76', 'en', 1, 'https://ror.org/04zgvbn76 Guthrie Hospice'),
(4181, 'https://ror.org/04zgvy449', 'no_lang_code', 1, 'https://ror.org/04zgvy449 PSA Peugeot Citroën (France)'),
(4182, 'https://ror.org/04zhhva53', 'en', 1, 'https://ror.org/04zhhva53 Thomas Jefferson University Hospital'),
(4183, 'https://ror.org/04zjvnp94', 'en', 1, 'https://ror.org/04zjvnp94 Clalit Health Services שירותי בריאות כללית'),
(4184, 'https://ror.org/04zkctn64', 'en', 1, 'https://ror.org/04zkctn64 University Hospital of Alexandroupolis'),
(4185, 'https://ror.org/04zmppn46', 'en', 1, 'https://ror.org/04zmppn46 Public Health Solutions'),
(4186, 'https://ror.org/04zn42r77', 'en', 1, 'https://ror.org/04zn42r77 Shahid Bahonar University of Kerman دانشگاه شهید باهنر کرمان'),
(4187, 'https://ror.org/04zn9qp70', 'en', 1, 'https://ror.org/04zn9qp70 Pennsylvania Department of Human Services'),
(4188, 'https://ror.org/04zpy9a42', 'en', 1, 'https://ror.org/04zpy9a42 Nil Ratan Sircar Medical College and Hospital नील रतन सरकार मेडिकल कॉलेज र अस्पताल'),
(4189, 'https://ror.org/04zsytt76', 'en', 1, 'https://ror.org/04zsytt76 Wise & Munro Learning Research'),
(4190, 'https://ror.org/04ztdzs79', 'en', 1, 'https://ror.org/04ztdzs79 Fenway Health'),
(4191, 'https://ror.org/04zx3rq17', 'en', 1, 'https://ror.org/04zx3rq17 National Cheng Kung University Hospital'),
(4192, 'https://ror.org/04zy7mm10', 'en', 1, 'https://ror.org/04zy7mm10 Canadian Dairy Network'),
(4193, 'https://ror.org/04zyews33', 'no_lang_code', 1, 'https://ror.org/04zyews33 Baylis Medical (Canada)'),
(4194, 'https://ror.org/04zygv656', 'en', 1, 'https://ror.org/04zygv656 Airedale General Hospital'),
(4195, 'https://ror.org/04zyja509', 'pt', 1, 'https://ror.org/04zyja509 Universidade de Franca'),
(4196, 'https://ror.org/04zzqmk94', 'en', 1, 'https://ror.org/04zzqmk94 Kintampo Health Research Centre'),
(4197, 'https://ror.org/050113w36', 'en', 1, 'https://ror.org/050113w36 SRM Institute of Science and Technology திரு. இராமசாமி நினைவுப் பல்கலைக்கழகம்'),
(4198, 'https://ror.org/0502a2655', 'en', 1, 'https://ror.org/0502a2655 National Institute for Occupational Safety and Health'),
(4199, 'https://ror.org/05031qk94', 'en', 1, 'https://ror.org/05031qk94 Taipei Medical University'),
(4200, 'https://ror.org/0504y0m80', 'en', 1, 'https://ror.org/0504y0m80 Polyclinic General Hospital'),
(4201, 'https://ror.org/05087r129', 'en', 1, 'https://ror.org/05087r129 Hizen Psychiatric Center 肥前精神医療センター'),
(4202, 'https://ror.org/0509tgg56', 'no_lang_code', 1, 'https://ror.org/0509tgg56 Airbus (Spain)'),
(4203, 'https://ror.org/050adm910', 'no_lang_code', 1, 'https://ror.org/050adm910 Chiba Hokusou Hospital 日本医科大学千葉北総病院'),
(4204, 'https://ror.org/050b05p79', 'en', 1, 'https://ror.org/050b05p79 Sriram Chandra Bhanja Medical College Hospital ଶ୍ରୀରାମ ଚନ୍ଦ୍ର ଭଞ୍ଜ ଭେଷଜ ମହାବିଦ୍ୟାଳୟ'),
(4205, 'https://ror.org/050b31k83', 'en', 1, 'https://ror.org/050b31k83 Hunter New England Local Health District'),
(4206, 'https://ror.org/050batv17', 'en', 1, 'https://ror.org/050batv17 Mater Hospital'),
(4207, 'https://ror.org/050bd8661', 'en', 1, 'https://ror.org/050bd8661 Royal Surrey NHS Foundation Trust'),
(4208, 'https://ror.org/050c9qp51', 'en', 1, 'https://ror.org/050c9qp51 Massachusetts Department of Public Health'),
(4209, 'https://ror.org/050cwzy61', 'en', 1, 'https://ror.org/050cwzy61 St Mary''s Hospital'),
(4210, 'https://ror.org/050fz5z96', 'en', 1, 'https://ror.org/050fz5z96 Washington DC VA Medical Center'),
(4211, 'https://ror.org/050hwd209', 'en', 1, 'https://ror.org/050hwd209 Hokkaido Institute of Public Health 北海道立衛生研究所'),
(4212, 'https://ror.org/050j2vm64', 'en', 1, 'https://ror.org/050j2vm64 Bangalore University Université de bangalore बंगलौर विश्वविद्यालय बंगळुरू विद्यापीठ பெங்களூர்ப் பல்கலைக்கழகம் బెంగుళూరు విశ్వవిద్యాలయం ಬೆಂಗಳೂರು ವಿಶ್ವವಿದ್ಯಾಲಯ'),
(4213, 'https://ror.org/050k2da37', 'en', 1, 'https://ror.org/050k2da37 Global Medical Imaging'),
(4214, 'https://ror.org/050mdr969', 'en', 1, 'https://ror.org/050mdr969 Kansas City VA Medical Center'),
(4215, 'https://ror.org/050nkg722', 'en', 1, 'https://ror.org/050nkg722 Oita University Hospital 大分大学医学部附属病院'),
(4216, 'https://ror.org/050pqs331', 'en', 1, 'https://ror.org/050pqs331 MRC Human Nutrition Research'),
(4217, 'https://ror.org/050qew682', 'no_lang_code', 1, 'https://ror.org/050qew682 Bolder Biotechnology, Inc.'),
(4218, 'https://ror.org/050qpjf10', 'en', 1, 'https://ror.org/050qpjf10 Botsford Hospital'),
(4219, 'https://ror.org/050rkhq40', 'en', 1, 'https://ror.org/050rkhq40 Jacksonville University Universidad de Jacksonville Université de jacksonville'),
(4220, 'https://ror.org/050th9p79', 'en', 1, 'https://ror.org/050th9p79 Scunthorpe General Hospital'),
(4221, 'https://ror.org/050w2g362', 'no_lang_code', 1, 'https://ror.org/050w2g362 Inovamais'),
(4222, 'https://ror.org/050wjeh45', 'en', 1, 'https://ror.org/050wjeh45 Eisenhower Medical Center'),
(4223, 'https://ror.org/050y0ba80', 'no_lang_code', 1, 'https://ror.org/050y0ba80 D''Appolonia (Italy)'),
(4224, 'https://ror.org/050ztxn78', 'en', 1, 'https://ror.org/050ztxn78 Madras Medical College மதராசு மருத்துவக் கல்லூரி మద్రాస్ వైద్య కళాశాల'),
(4225, 'https://ror.org/0511k4970', 'en', 1, 'https://ror.org/0511k4970 Children''s Hospital أطفال مستشفى تونس'),
(4226, 'https://ror.org/0511th722', 'fr', 1, 'https://ror.org/0511th722 Hôpital Albert-Chenevier'),
(4227, 'https://ror.org/0511yej17', 'en', 1, 'https://ror.org/0511yej17 Dartmouth Institute for Health Policy and Clinical Practice'),
(4228, 'https://ror.org/0512xad50', 'en', 1, 'https://ror.org/0512xad50 American Academy of Pediatrics'),
(4229, 'https://ror.org/0513nfd47', 'en', 1, 'https://ror.org/0513nfd47 Kootenai Medical Center'),
(4230, 'https://ror.org/051525m98', 'en', 1, 'https://ror.org/051525m98 Mercy Medical Center'),
(4231, 'https://ror.org/0516ah480', 'en', 1, 'https://ror.org/0516ah480 The Graduate University for Advanced Studies, SOKENDAI 総合研究大学院大学'),
(4232, 'https://ror.org/051a97h21', 'no_lang_code', 1, 'https://ror.org/051a97h21 National Nuclear Corporation (United Kingdom)'),
(4233, 'https://ror.org/051b68e86', 'en', 1, 'https://ror.org/051b68e86 Frankston Hospital'),
(4234, 'https://ror.org/051b9c228', 'it', 1, 'https://ror.org/051b9c228 Ospedale Martini'),
(4235, 'https://ror.org/051c2ew73', 'es', 1, 'https://ror.org/051c2ew73 Hospital General de La Rioja'),
(4236, 'https://ror.org/051cp7s36', 'en', 1, 'https://ror.org/051cp7s36 Fatima Jinnah Medical University فاطمہ جناح میڈیکل کالج'),
(4237, 'https://ror.org/051dzw862', 'en', 1, 'https://ror.org/051dzw862 Gentofte Hospital'),
(4238, 'https://ror.org/051fpt583', 'it', 1, 'https://ror.org/051fpt583 Ospedale Buccheri la Ferla Fatebenefratelli'),
(4239, 'https://ror.org/051hvcm98', 'en', 1, 'https://ror.org/051hvcm98 Jiangsu Normal University 江苏师范大学'),
(4240, 'https://ror.org/051j8zv27', 'no_lang_code', 1, 'https://ror.org/051j8zv27 Osaka Kyoiku University 大阪教育大学'),
(4241, 'https://ror.org/051jx6464', 'en', 1, 'https://ror.org/051jx6464 Waianae Coast Comprehensive Health Center'),
(4242, 'https://ror.org/051mda743', 'en', 1, 'https://ror.org/051mda743 Garrahan Hospital'),
(4243, 'https://ror.org/051mn8706', 'en', 1, 'https://ror.org/051mn8706 Tumor Hospital of Guangxi Medical University 广西医科大学肿瘤医院'),
(4244, 'https://ror.org/051nxfa23', 'de', 1, 'https://ror.org/051nxfa23 St. Franziskus Hospital'),
(4245, 'https://ror.org/051ppg660', 'en', 1, 'https://ror.org/051ppg660 National Institute of Animal Health 動物衛生研究部門'),
(4246, 'https://ror.org/051qv3667', 'no_lang_code', 1, 'https://ror.org/051qv3667 Applus+ IDIADA (Spain) Institut d''Investigació Aplicada de l''Automòbil'),
(4247, 'https://ror.org/051s3e988', 'fr', 1, 'https://ror.org/051s3e988 Hôpital Universitaire Dupuytren'),
(4248, 'https://ror.org/051sezk39', 'no_lang_code', 1, 'https://ror.org/051sezk39 Micralyne');
INSERT INTO `rors` VALUES
(4249, 'https://ror.org/051smbs96', 'en', 1, 'https://ror.org/051smbs96 The University of Texas of the Permian Basin'),
(4250, 'https://ror.org/051wnqr14', 'en', 1, 'https://ror.org/051wnqr14 Department of Defence'),
(4251, 'https://ror.org/0520j5d52', 'no_lang_code', 1, 'https://ror.org/0520j5d52 Peptidream (Japan) ペプチドリーム'),
(4252, 'https://ror.org/0522mgp14', 'en', 1, 'https://ror.org/0522mgp14 Wesley Long Hospital'),
(4253, 'https://ror.org/0522w3m69', 'no_lang_code', 1, 'https://ror.org/0522w3m69 Sinhgad Dental College and Hospital'),
(4254, 'https://ror.org/0524j1g61', 'en', 1, 'https://ror.org/0524j1g61 Stoke Mandeville Hospital Ysbyty Stoke Mandeville'),
(4255, 'https://ror.org/052578691', 'en', 1, 'https://ror.org/052578691 MRC Epidemiology Unit'),
(4256, 'https://ror.org/0525h8d02', 'en', 1, 'https://ror.org/0525h8d02 New Mexico Regional Federal Medical Center'),
(4257, 'https://ror.org/0525j6d32', 'en', 1, 'https://ror.org/0525j6d32 Nishijin Hospital 西陣病院'),
(4258, 'https://ror.org/05275vm15', 'en', 1, 'https://ror.org/05275vm15 Gelre Hospitals Gelre Ziekenhuizen'),
(4259, 'https://ror.org/05278be16', 'es', 1, 'https://ror.org/05278be16 Hospital del Niño'),
(4260, 'https://ror.org/0527gjc91', 'en', 1, 'https://ror.org/0527gjc91 Temple Street Children''s University Hospital'),
(4261, 'https://ror.org/052963a64', 'en', 1, 'https://ror.org/052963a64 Ohio Northern University'),
(4262, 'https://ror.org/052dmyg58', 'en', 1, 'https://ror.org/052dmyg58 Greenville Memorial Hospital'),
(4263, 'https://ror.org/052fdp564', 'no_lang_code', 1, 'https://ror.org/052fdp564 Enel (Italy)'),
(4264, 'https://ror.org/052g5ww90', 'fr', 1, 'https://ror.org/052g5ww90 Hopital Universitaire Habib Bourguiba'),
(4265, 'https://ror.org/052jt6v75', 'pl', 1, 'https://ror.org/052jt6v75 Wojewódzki Szpital Zespolony im. Jędrzeja Śniadeckiego'),
(4266, 'https://ror.org/052k2q138', 'en', 1, 'https://ror.org/052k2q138 Shodair Children''s Hospital'),
(4267, 'https://ror.org/052qqbc08', 'en', 1, 'https://ror.org/052qqbc08 Michael E. DeBakey VA Medical Center'),
(4268, 'https://ror.org/052ra0j05', 'en', 1, 'https://ror.org/052ra0j05 Sinai Hospital'),
(4269, 'https://ror.org/052vjje65', 'en', 1, 'https://ror.org/052vjje65 Royal Manchester Children''s Hospital'),
(4270, 'https://ror.org/052vn2478', 'en', 1, 'https://ror.org/052vn2478 Liaocheng People''s Hospital 聊城市人民医院'),
(4271, 'https://ror.org/052vt9742', 'en', 1, 'https://ror.org/052vt9742 St. Joseph Medical Center'),
(4272, 'https://ror.org/052w2jw50', 'fr', 1, 'https://ror.org/052w2jw50 Hôpital Saint-Jacques'),
(4273, 'https://ror.org/052wqwf92', 'en', 1, 'https://ror.org/052wqwf92 Shuto General Hospital 周東総合病院'),
(4274, 'https://ror.org/052zr0n46', 'en', 1, 'https://ror.org/052zr0n46 Institute for Medical Research and Occupational Health'),
(4275, 'https://ror.org/0531xck41', 'en', 1, 'https://ror.org/0531xck41 Southeastern Louisiana University Universidad del Sudeste de Luisiana'),
(4276, 'https://ror.org/05328fn02', 'en', 1, 'https://ror.org/05328fn02 Hermanos Ameijeiras Hospital Hospital Clínico Quirúrgico "Hermanos Ameijeiras"'),
(4277, 'https://ror.org/0532h0d08', 'en', 1, 'https://ror.org/0532h0d08 Deaconess Hospital'),
(4278, 'https://ror.org/0534awx66', 'en', 1, 'https://ror.org/0534awx66 Guangzhou Eighth People''s Hospital 广州市第八人民医院'),
(4279, 'https://ror.org/0534dba08', 'en', 1, 'https://ror.org/0534dba08 Tamil University தமிழ்ப் பல்கலைக்கழகம், தஞ்சாவூர் തമിഴ് സർവകലാശാല'),
(4280, 'https://ror.org/05359he25', 'no_lang_code', 1, 'https://ror.org/05359he25 Ibn Sina Hospital مستشفى ابن سينا'),
(4281, 'https://ror.org/0535cbe18', 'en', 1, 'https://ror.org/0535cbe18 Kanazawa Medical University 金沢医科大学'),
(4282, 'https://ror.org/05362x394', 'en', 1, 'https://ror.org/05362x394 MRC Toxicology Unit'),
(4283, 'https://ror.org/053658081', 'en', 1, 'https://ror.org/053658081 Mitsubishi Kyoto Hospital 三菱京都病院'),
(4284, 'https://ror.org/05368pf49', 'en', 1, 'https://ror.org/05368pf49 Institute of the Pupils of the Army Instituto dos Pupilos do Exército'),
(4285, 'https://ror.org/05388sw24', 'en', 1, 'https://ror.org/05388sw24 University of South Alabama Medical Center'),
(4286, 'https://ror.org/053ad7h16', 'no_lang_code', 1, 'https://ror.org/053ad7h16 Saiseikai Shigaken Hospital 済生会滋賀県病院'),
(4287, 'https://ror.org/053bqv655', 'no_lang_code', 1, 'https://ror.org/053bqv655 STMicroelectronics (Italy)'),
(4288, 'https://ror.org/053c75a48', 'en', 1, 'https://ror.org/053c75a48 East Texas Medical Center'),
(4289, 'https://ror.org/053cd8j25', 'no_lang_code', 1, 'https://ror.org/053cd8j25 Osmania General Hospital ఉస్మానియా జనరల్ హాస్పిటల్'),
(4290, 'https://ror.org/053d3tv41', 'en', 1, 'https://ror.org/053d3tv41 International University of Health and Welfare 国際医療福祉大学'),
(4291, 'https://ror.org/053dkp921', 'en', 1, 'https://ror.org/053dkp921 Los Alamos Medical Center'),
(4292, 'https://ror.org/053exzj86', 'en', 1, 'https://ror.org/053exzj86 Miriam Hospital'),
(4293, 'https://ror.org/053eyjs84', 'en', 1, 'https://ror.org/053eyjs84 Princess Royal Maternity Hospital'),
(4294, 'https://ror.org/053fh2363', 'en', 1, 'https://ror.org/053fh2363 Benedictine University'),
(4295, 'https://ror.org/053fx7g25', 'en', 1, 'https://ror.org/053fx7g25 Royal Bolton Hospital'),
(4296, 'https://ror.org/053fzma23', 'en', 1, 'https://ror.org/053fzma23 Sichuan University of Science and Engineering 四川理工学院'),
(4297, 'https://ror.org/053gjjp11', 'tr', 1, 'https://ror.org/053gjjp11 Pamukkale Üniversitesi Hastaneleri'),
(4298, 'https://ror.org/053h7gw81', 'en', 1, 'https://ror.org/053h7gw81 Swami Vivekanand Subharti University'),
(4299, 'https://ror.org/053hkmn05', 'en', 1, 'https://ror.org/053hkmn05 Primary Children''s Hospital'),
(4300, 'https://ror.org/053kccs63', 'en', 1, 'https://ror.org/053kccs63 Osaka Dental University 大阪歯科大学'),
(4301, 'https://ror.org/053mxw461', 'en', 1, 'https://ror.org/053mxw461 Sevastopol National Technical University Севастопольский национальный технический университет Севастопольський національний технічний університет'),
(4302, 'https://ror.org/053ny5136', 'no_lang_code', 1, 'https://ror.org/053ny5136 Fujitsu (United Kingdom)'),
(4303, 'https://ror.org/053v1pf86', 'no_lang_code', 1, 'https://ror.org/053v1pf86 Biomedical Development Corporation'),
(4304, 'https://ror.org/053vdeh68', 'en', 1, 'https://ror.org/053vdeh68 St. Luke''s Hospital'),
(4305, 'https://ror.org/053vhdz56', 'en', 1, 'https://ror.org/053vhdz56 Ospedale di Santa Maria Nuova Santa Maria Nuova Hospital'),
(4306, 'https://ror.org/053vvhn22', 'en', 1, 'https://ror.org/053vvhn22 Whiston Hospital'),
(4307, 'https://ror.org/053vynf43', 'en', 1, 'https://ror.org/053vynf43 King Khaled Hospital مستشفى الملك خالد'),
(4308, 'https://ror.org/053xhbr86', 'en', 1, 'https://ror.org/053xhbr86 Ryhov Hospital Jönköping'),
(4309, 'https://ror.org/053zey189', 'en', 1, 'https://ror.org/053zey189 Takayama Red Cross Hospital 高山赤十字病院'),
(4310, 'https://ror.org/0540c8n94', 'no_lang_code', 1, 'https://ror.org/0540c8n94 Soka Municipal Hospital 草加市立病院'),
(4311, 'https://ror.org/05422jd13', 'en', 1, 'https://ror.org/05422jd13 University Children''s Hospital, Belgrade Univerzitetska dečja klinika u Beogradu'),
(4312, 'https://ror.org/0542q3127', 'en', 1, 'https://ror.org/0542q3127 Lviv Polytechnic National University Politechnika Lwowska Национальный университет «Львовская политехника» Національний університет «Львівська політехніка»'),
(4313, 'https://ror.org/054652k97', 'en', 1, 'https://ror.org/054652k97 Public Health – Seattle & King County'),
(4314, 'https://ror.org/0546wew42', 'en', 1, 'https://ror.org/0546wew42 New Jersey City University'),
(4315, 'https://ror.org/054876c03', 'tr', 1, 'https://ror.org/054876c03 Ankara Atatürk Göğüs Hastalıkları Ve Göğüs Cerrahisi Eğitim Ve Araştırma Hastanesi'),
(4316, 'https://ror.org/0549ak978', 'en', 1, 'https://ror.org/0549ak978 Gifu Red Cross Hospital 岐阜赤十字病院'),
(4317, 'https://ror.org/054bptx32', 'fr', 1, 'https://ror.org/054bptx32 Hôpital Maison Blanche'),
(4318, 'https://ror.org/054dq5m81', 'no_lang_code', 1, 'https://ror.org/054dq5m81 Universal Hi-Tech Development'),
(4319, 'https://ror.org/054e9ag92', 'en', 1, 'https://ror.org/054e9ag92 Chang Gung Children''s Hospital'),
(4320, 'https://ror.org/054ekwz94', 'en', 1, 'https://ror.org/054ekwz94 Queen Margaret Hospital'),
(4321, 'https://ror.org/054ezs277', 'en', 1, 'https://ror.org/054ezs277 Framingham Union Hospital'),
(4322, 'https://ror.org/054gzqw08', 'en', 1, 'https://ror.org/054gzqw08 Central Connecticut State University Universidad Estatal de Connecticut Central'),
(4323, 'https://ror.org/054kr1687', 'en', 1, 'https://ror.org/054kr1687 Holy Cross Hospital'),
(4324, 'https://ror.org/054nax084', 'en', 1, 'https://ror.org/054nax084 Clinical Centre of Kragujevac Клинички центар Крагујевац'),
(4325, 'https://ror.org/054p2n359', 'en', 1, 'https://ror.org/054p2n359 Arkansas Department of Health'),
(4326, 'https://ror.org/054qnke07', 'en', 1, 'https://ror.org/054qnke07 Ningbo No.6 Hospital 宁波市第六医院'),
(4327, 'https://ror.org/054tgm925', 'en', 1, 'https://ror.org/054tgm925 Aspirus Wausau Hospital'),
(4328, 'https://ror.org/054zbmd26', 'en', 1, 'https://ror.org/054zbmd26 Hera General Hospital'),
(4329, 'https://ror.org/054zv1w86', 'no_lang_code', 1, 'https://ror.org/054zv1w86 Glencore (Switzerland)'),
(4330, 'https://ror.org/055546q82', 'en', 1, 'https://ror.org/055546q82 Bộ Y tế (Việt Nam) Ministry of Health'),
(4331, 'https://ror.org/05564r514', 'en', 1, 'https://ror.org/05564r514 Association of European Renewable Energy Research Centres'),
(4332, 'https://ror.org/05586rd65', 'nl', 1, 'https://ror.org/05586rd65 Kiwa'),
(4333, 'https://ror.org/055a6nt34', 'it', 1, 'https://ror.org/055a6nt34 Servizio Sanitario Nazionale'),
(4334, 'https://ror.org/055aebe25', 'no_lang_code', 1, 'https://ror.org/055aebe25 CRE Group (United States)'),
(4335, 'https://ror.org/055awd420', 'fr', 1, 'https://ror.org/055awd420 Hôpital de Sion'),
(4336, 'https://ror.org/055bcma36', 'en', 1, 'https://ror.org/055bcma36 Hospital Venereal and Skin Diseases Thessaloniki Νοσοκομείο Αφροδισίων & Δερματικών Νόσων Θεσσαλονίκης'),
(4337, 'https://ror.org/055bpw879', 'en', 1, 'https://ror.org/055bpw879 MRC Cognition and Brain Sciences Unit'),
(4338, 'https://ror.org/055epge17', 'en', 1, 'https://ror.org/055epge17 Arkansas Foundation for Medical Care'),
(4339, 'https://ror.org/055f7t516', 'en', 1, 'https://ror.org/055f7t516 National Research University Higher School of Economics Высшая школа экономики Юғары иҡтисад мәктәбе'),
(4340, 'https://ror.org/055fgjp51', 'no_lang_code', 1, 'https://ror.org/055fgjp51 Nimbus Landscape Materials (United States)'),
(4341, 'https://ror.org/055gkcy74', 'en', 1, 'https://ror.org/055gkcy74 Union Hospital'),
(4342, 'https://ror.org/055gq1960', 'no_lang_code', 1, 'https://ror.org/055gq1960 Ada Technologies (United States)'),
(4343, 'https://ror.org/055hhmc29', 'en', 1, 'https://ror.org/055hhmc29 Oregon Department of Human Services'),
(4344, 'https://ror.org/055k2e754', 'en', 1, 'https://ror.org/055k2e754 Baltimore County Department of Health'),
(4345, 'https://ror.org/055m2tx54', 'en', 1, 'https://ror.org/055m2tx54 North Eastern Hill University نارتھ ایسٹ ہل یونیورسٹی'),
(4346, 'https://ror.org/055m51988', 'no_lang_code', 1, 'https://ror.org/055m51988 Ohkubo Hospital 大久保病院'),
(4347, 'https://ror.org/055mfda29', 'en', 1, 'https://ror.org/055mfda29 Earth and Space Research'),
(4348, 'https://ror.org/055mfza47', 'en', 1, 'https://ror.org/055mfza47 Saint Peter''s University Hospital'),
(4349, 'https://ror.org/055ne9q08', 'en', 1, 'https://ror.org/055ne9q08 Wentworth Hospital'),
(4350, 'https://ror.org/055p2yz63', 'es', 1, 'https://ror.org/055p2yz63 Hospital General Universitario de Albacete'),
(4351, 'https://ror.org/055redd10', 'it', 1, 'https://ror.org/055redd10 Azienda Ospedaliera di Desio e Vimercate'),
(4352, 'https://ror.org/055vbxf86', 'en', 1, 'https://ror.org/055vbxf86 Addenbrooke''s Hospital'),
(4353, 'https://ror.org/055xb4311', 'en', 1, 'https://ror.org/055xb4311 Austrian Agency for Health and Food Safety Österreichische Agentur für Gesundheit und Ernährungssicherheit'),
(4354, 'https://ror.org/055y34y19', 'en', 1, 'https://ror.org/055y34y19 Rose Medical Center'),
(4355, 'https://ror.org/055zmrh94', 'en', 1, 'https://ror.org/055zmrh94 John Innes Centre'),
(4356, 'https://ror.org/0560hqd63', 'it', 1, 'https://ror.org/0560hqd63 Ospedale Monaldi'),
(4357, 'https://ror.org/0560xr487', 'en', 1, 'https://ror.org/0560xr487 DR. B.R.A. Institute Rotary Cancer Hospital'),
(4358, 'https://ror.org/056221z03', 'en', 1, 'https://ror.org/056221z03 Centre Hospitalier Universitaire de Treichville University Hospital Medical Center at Treichville'),
(4359, 'https://ror.org/0566w5t03', 'en', 1, 'https://ror.org/0566w5t03 United States Office of Personnel Management'),
(4360, 'https://ror.org/0567p6j84', 'en', 1, 'https://ror.org/0567p6j84 Stanley Medical College இசுடான்லி மருத்துவக் கல்லூரி'),
(4361, 'https://ror.org/0567w8j84', 'en', 1, 'https://ror.org/0567w8j84 Bowie State University'),
(4362, 'https://ror.org/0569bbe51', 'en', 1, 'https://ror.org/0569bbe51 Connecticut Mental Health Center'),
(4363, 'https://ror.org/056a2fb24', 'no_lang_code', 1, 'https://ror.org/056a2fb24 Nanoprobes (United States)'),
(4364, 'https://ror.org/056d7mp27', 'no_lang_code', 1, 'https://ror.org/056d7mp27 Applied Biological Materials (Canada)'),
(4365, 'https://ror.org/056dkgp19', 'en', 1, 'https://ror.org/056dkgp19 Health Forecasting'),
(4366, 'https://ror.org/056ep7w45', 'en', 1, 'https://ror.org/056ep7w45 Siksha O Anusandhan University'),
(4367, 'https://ror.org/056mx1477', 'en', 1, 'https://ror.org/056mx1477 Children''s Hospital at Dartmouth Hitchcock'),
(4368, 'https://ror.org/056nn5n22', 'en', 1, 'https://ror.org/056nn5n22 Aurora Sinai Medical Center'),
(4369, 'https://ror.org/056p2ex35', 'en', 1, 'https://ror.org/056p2ex35 Asir Central Hospital مستشفى عسير المركزي'),
(4370, 'https://ror.org/056pbvy42', 'it', 1, 'https://ror.org/056pbvy42 Ospedale di Monfalcone'),
(4371, 'https://ror.org/056pg9759', 'en', 1, 'https://ror.org/056pg9759 SSM Health Care'),
(4372, 'https://ror.org/056phcb82', 'en', 1, 'https://ror.org/056phcb82 The Keystone Center'),
(4373, 'https://ror.org/056q45h83', 'es', 1, 'https://ror.org/056q45h83 Hospital Doctor Hernán Henríquez Aravena'),
(4374, 'https://ror.org/056qqqn18', 'en', 1, 'https://ror.org/056qqqn18 National Disaster Medical Center 国立病院機構災害医療センター'),
(4375, 'https://ror.org/056r5vk88', 'en', 1, 'https://ror.org/056r5vk88 Penza State University Пензенский государственный университет'),
(4376, 'https://ror.org/056rage58', 'en', 1, 'https://ror.org/056rage58 Indira Gandhi Medical College'),
(4377, 'https://ror.org/056rp9e47', 'en', 1, 'https://ror.org/056rp9e47 Metropolitan State University'),
(4378, 'https://ror.org/056rz0f32', 'no_lang_code', 1, 'https://ror.org/056rz0f32 Virtually Better'),
(4379, 'https://ror.org/056sm7z81', 'en', 1, 'https://ror.org/056sm7z81 Council of Chief State School Officers'),
(4380, 'https://ror.org/056t4gr41', 'no_lang_code', 1, 'https://ror.org/056t4gr41 Morinomiya Hospital もりのみや ほｓぴたｌ'),
(4381, 'https://ror.org/056t5qz59', 'no_lang_code', 1, 'https://ror.org/056t5qz59 Fortis Hospital'),
(4382, 'https://ror.org/056tb3809', 'de', 1, 'https://ror.org/056tb3809 Kantonsspital Aarau'),
(4383, 'https://ror.org/056v1sx90', 'en', 1, 'https://ror.org/056v1sx90 Nicosia General Hospital'),
(4384, 'https://ror.org/056yje678', 'fr', 1, 'https://ror.org/056yje678 Hôpital Mustapha Pacha'),
(4385, 'https://ror.org/056zv5g90', 'en', 1, 'https://ror.org/056zv5g90 Jinnah University for Women جناح یونیورسٹی برائے خواتین'),
(4386, 'https://ror.org/05735fh94', 'en', 1, 'https://ror.org/05735fh94 Gujarat Ayurved University गुजरात आयुर्वेद विश्वविद्यालय ગુજરાત આયુર્વેદ યુનિવર્સિટી'),
(4387, 'https://ror.org/0573hvw69', 'tr', 1, 'https://ror.org/0573hvw69 Farabi Hastanesi'),
(4388, 'https://ror.org/0573ts924', 'en', 1, 'https://ror.org/0573ts924 Princess Royal Hospital'),
(4389, 'https://ror.org/0574j1p50', 'ro', 1, 'https://ror.org/0574j1p50 Spitalul Clinic de Recuperare'),
(4390, 'https://ror.org/05757k612', 'en', 1, 'https://ror.org/05757k612 Sree Chitra Thirunal Institute for Medical Sciences and Technology'),
(4391, 'https://ror.org/0576bwz31', 'no_lang_code', 1, 'https://ror.org/0576bwz31 Aizawa Hospital 相澤病院'),
(4392, 'https://ror.org/05783y657', 'en', 1, 'https://ror.org/05783y657 Smith-Kettlewell Eye Research Institute'),
(4393, 'https://ror.org/057anza51', 'en', 1, 'https://ror.org/057anza51 Metropolitan University of Educational Sciences Universidad Metropolitana de Ciencias de la Educación'),
(4394, 'https://ror.org/057ays557', 'no_lang_code', 1, 'https://ror.org/057ays557 Kestrel Corporation'),
(4395, 'https://ror.org/057b2d479', 'pt', 1, 'https://ror.org/057b2d479 Hospital Maria Pia'),
(4396, 'https://ror.org/057cm0m66', 'en', 1, 'https://ror.org/057cm0m66 Sismanoglio General Hospital Γενικό Νοσοκομείο Σισμανόγλειο'),
(4397, 'https://ror.org/057d2v504', 'en', 1, 'https://ror.org/057d2v504 Kohat University of Science and Technology'),
(4398, 'https://ror.org/057e34m22', 'en', 1, 'https://ror.org/057e34m22 University of Massachusetts Donahue Institute'),
(4399, 'https://ror.org/057edve92', 'en', 1, 'https://ror.org/057edve92 Tokyo Yamate Medical Center 東京山手メディカルセンター'),
(4400, 'https://ror.org/057ft1y03', 'no_lang_code', 1, 'https://ror.org/057ft1y03 Kochi Municipal Central Hospital 高知県立中央病院'),
(4401, 'https://ror.org/057hbdz28', 'en', 1, 'https://ror.org/057hbdz28 Tochigi Medical Center 栃木医療センター'),
(4402, 'https://ror.org/057jp7h82', 'en', 1, 'https://ror.org/057jp7h82 IIT Research Institute'),
(4403, 'https://ror.org/057n8mx64', 'en', 1, 'https://ror.org/057n8mx64 Ministry of Health وزارة الصحة'),
(4404, 'https://ror.org/057nqxc22', 'en', 1, 'https://ror.org/057nqxc22 West Virginia Wesleyan College'),
(4405, 'https://ror.org/057p7h461', 'en', 1, 'https://ror.org/057p7h461 Affiliated Hospital of Guangdong Medical College Hospital'),
(4406, 'https://ror.org/057pdzy92', 'es', 1, 'https://ror.org/057pdzy92 Hospital del Trabajador'),
(4407, 'https://ror.org/057s4cx47', 'no_lang_code', 1, 'https://ror.org/057s4cx47 Katsumata Hospital 勝又病院'),
(4408, 'https://ror.org/057seh071', 'en', 1, 'https://ror.org/057seh071 Franklin Institute'),
(4409, 'https://ror.org/057v2pg43', 'fr', 1, 'https://ror.org/057v2pg43 Hôpital Saint-Michel'),
(4410, 'https://ror.org/057vc9k50', 'en', 1, 'https://ror.org/057vc9k50 Tai Po Hospital 大埔醫院'),
(4411, 'https://ror.org/057vt8c33', 'fr', 1, 'https://ror.org/057vt8c33 Hôpital Paule de Viguier'),
(4412, 'https://ror.org/057vy9683', 'en', 1, 'https://ror.org/057vy9683 Hamamatsu University 浜松大学'),
(4413, 'https://ror.org/057wh9709', 'fr', 1, 'https://ror.org/057wh9709 Centre hospitalier Robert-Ballanger'),
(4414, 'https://ror.org/057xx1h21', 'en', 1, 'https://ror.org/057xx1h21 Association Médicale Canadienne Canadian Medical Association'),
(4415, 'https://ror.org/057z0pt68', 'en', 1, 'https://ror.org/057z0pt68 Kansas Department for Children and Families'),
(4416, 'https://ror.org/05819fq78', 'en', 1, 'https://ror.org/05819fq78 Punjab Institute of Medical Sciences'),
(4417, 'https://ror.org/05831wz16', 'en', 1, 'https://ror.org/05831wz16 Republic of Palau Ministry of Health'),
(4418, 'https://ror.org/0583j8v67', 'en', 1, 'https://ror.org/0583j8v67 Strong Memorial Hospital'),
(4419, 'https://ror.org/0584fj407', 'en', 1, 'https://ror.org/0584fj407 University of North Alabama'),
(4420, 'https://ror.org/0586a5g03', 'no_lang_code', 1, 'https://ror.org/0586a5g03 Clinical Tools, Inc.'),
(4421, 'https://ror.org/0586bt104', 'en', 1, 'https://ror.org/0586bt104 Southport and Ormskirk Hospital NHS Trust'),
(4422, 'https://ror.org/0587whv30', 'no_lang_code', 1, 'https://ror.org/0587whv30 Nexeon (United Kingdom)'),
(4423, 'https://ror.org/0589bxs97', 'en', 1, 'https://ror.org/0589bxs97 McGill University and Génome Québec Innovation Centre'),
(4424, 'https://ror.org/058c4h389', 'no_lang_code', 1, 'https://ror.org/058c4h389 Atom Sciences'),
(4425, 'https://ror.org/058fy8f68', 'en', 1, 'https://ror.org/058fy8f68 Govind Ballabh Pant Hospital'),
(4426, 'https://ror.org/058hnhf91', 'en', 1, 'https://ror.org/058hnhf91 Oral Roberts University'),
(4427, 'https://ror.org/058hsp657', 'en', 1, 'https://ror.org/058hsp657 Hospital of Lithuanian University of Health Sciences Kaunas Clinics Lietuvos sveikatos mokslų universiteto ligoninė Kauno klinikos'),
(4428, 'https://ror.org/058kbr222', 'no_lang_code', 1, 'https://ror.org/058kbr222 Qurient (South Korea)'),
(4429, 'https://ror.org/058ms9w43', 'en', 1, 'https://ror.org/058ms9w43 Fujian Provincial Cancer Hospital 福建省肿瘤医院'),
(4430, 'https://ror.org/058p1kn93', 'en', 1, 'https://ror.org/058p1kn93 VA Long Beach Healthcare System'),
(4431, 'https://ror.org/058peea52', 'en', 1, 'https://ror.org/058peea52 Sharp Cabrillo Hospital'),
(4432, 'https://ror.org/058prbp42', 'en', 1, 'https://ror.org/058prbp42 Shaikh Zayed Postgraduate Medical Institute شیخ زید پوسٹ گریجویٹ میڈیکل انسٹی ٹیوٹ'),
(4433, 'https://ror.org/058q6m856', 'en', 1, 'https://ror.org/058q6m856 Medical Trust Hospital'),
(4434, 'https://ror.org/058qmst67', 'fr', 1, 'https://ror.org/058qmst67 Hôpital Saint Roch'),
(4435, 'https://ror.org/058qp7v13', 'en', 1, 'https://ror.org/058qp7v13 BGS Global Hospital'),
(4436, 'https://ror.org/058rkm744', 'en', 1, 'https://ror.org/058rkm744 Niabi Zoological Society'),
(4437, 'https://ror.org/058rxv392', 'en', 1, 'https://ror.org/058rxv392 University Hospital of North Tees'),
(4438, 'https://ror.org/058s20p71', 'en', 1, 'https://ror.org/058s20p71 Public Health Foundation of India భారత ప్రజారోగ్య సమాఖ్య'),
(4439, 'https://ror.org/058s98e36', 'en', 1, 'https://ror.org/058s98e36 Promotion of Operational Links With Integrated Services'),
(4440, 'https://ror.org/058td2q88', 'fr', 1, 'https://ror.org/058td2q88 Hôpital Foch'),
(4441, 'https://ror.org/058vcb964', 'it', 1, 'https://ror.org/058vcb964 Casa di Cura Villa Bianca'),
(4442, 'https://ror.org/058w59113', 'en', 1, 'https://ror.org/058w59113 Des Moines University Université de des moines'),
(4443, 'https://ror.org/058x7dy48', 'en', 1, 'https://ror.org/058x7dy48 Royal United Hospital Bath NHS Trust'),
(4444, 'https://ror.org/058xqe166', 'en', 1, 'https://ror.org/058xqe166 Kingston Hospital NHS Trust'),
(4445, 'https://ror.org/058xqwv02', 'en', 1, 'https://ror.org/058xqwv02 Voluntary Health Services Hospital'),
(4446, 'https://ror.org/058ydcm32', 'en', 1, 'https://ror.org/058ydcm32 Kaiser Foundation Hospital'),
(4447, 'https://ror.org/058yxq906', 'en', 1, 'https://ror.org/058yxq906 Nikko Memorial Hospital 日鋼記念病院'),
(4448, 'https://ror.org/0595gz585', 'en', 1, 'https://ror.org/0595gz585 University of Gondar'),
(4449, 'https://ror.org/0596qfc35', 'en', 1, 'https://ror.org/0596qfc35 Kaweah Delta Health Care District'),
(4450, 'https://ror.org/0599zba67', 'tr', 1, 'https://ror.org/0599zba67 Kent Hastanesi Kent Hospital'),
(4451, 'https://ror.org/059c3mv67', 'en', 1, 'https://ror.org/059c3mv67 Cambridge Health Alliance'),
(4452, 'https://ror.org/059cjpv64', 'en', 1, 'https://ror.org/059cjpv64 Second Affiliated Hospital of Zhejiang University'),
(4453, 'https://ror.org/059dkdx38', 'en', 1, 'https://ror.org/059dkdx38 National Taiwan Normal University'),
(4454, 'https://ror.org/059dqb057', 'en', 1, 'https://ror.org/059dqb057 American Chemical Society'),
(4455, 'https://ror.org/059ebsr57', 'es', 1, 'https://ror.org/059ebsr57 Hospital Universitario de San Vicente Fundación'),
(4456, 'https://ror.org/059f2k568', 'en', 1, 'https://ror.org/059f2k568 Ministry of Health'),
(4457, 'https://ror.org/059g69b28', 'en', 1, 'https://ror.org/059g69b28 Dong-Eui University 동의대학교'),
(4458, 'https://ror.org/059jq5127', 'en', 1, 'https://ror.org/059jq5127 Harborview Medical Center'),
(4459, 'https://ror.org/059kfmf89', 'fr', 1, 'https://ror.org/059kfmf89 Centre hospitalier régional de la Citadelle'),
(4460, 'https://ror.org/059t16j93', 'no_lang_code', 1, 'https://ror.org/059t16j93 Takatsuki General Hospital 高槻病院'),
(4461, 'https://ror.org/059w0gb06', 'en', 1, 'https://ror.org/059w0gb06 Karakalpak State University'),
(4462, 'https://ror.org/059wef195', 'en', 1, 'https://ror.org/059wef195 Nishi Niigata Chuo National Hospital 国立病院機構西新潟中央病院'),
(4463, 'https://ror.org/059x21724', 'en', 1, 'https://ror.org/059x21724 University of Yamanashi 山梨大学'),
(4464, 'https://ror.org/059xepj08', 'en', 1, 'https://ror.org/059xepj08 Akron General Medical Center'),
(4465, 'https://ror.org/059xmmg10', 'en', 1, 'https://ror.org/059xmmg10 Eastern Mennonite University'),
(4466, 'https://ror.org/059xnz004', 'en', 1, 'https://ror.org/059xnz004 Christ Hospital'),
(4467, 'https://ror.org/059y9v737', 'en', 1, 'https://ror.org/059y9v737 Central College'),
(4468, 'https://ror.org/05a01hn31', 'en', 1, 'https://ror.org/05a01hn31 Mater Dei Hospital'),
(4469, 'https://ror.org/05a064c11', 'no_lang_code', 1, 'https://ror.org/05a064c11 Caisson Laboratories (United States)'),
(4470, 'https://ror.org/05a2agx14', 'en', 1, 'https://ror.org/05a2agx14 Crouse Hospital'),
(4471, 'https://ror.org/05a3jmv43', 'no_lang_code', 1, 'https://ror.org/05a3jmv43 Format International Ltd'),
(4472, 'https://ror.org/05a79ds67', 'no_lang_code', 1, 'https://ror.org/05a79ds67 Bhatia Hospital'),
(4473, 'https://ror.org/05a7hcs31', 'en', 1, 'https://ror.org/05a7hcs31 Providence Health & Services Oregon and Southwest Washington'),
(4474, 'https://ror.org/05a90fj07', 'en', 1, 'https://ror.org/05a90fj07 Ealing Hospital'),
(4475, 'https://ror.org/05aczzj13', 'en', 1, 'https://ror.org/05aczzj13 Shumei University 秀明大学'),
(4476, 'https://ror.org/05aem0d44', 'en', 1, 'https://ror.org/05aem0d44 Francis Hospital Franziskus Hospital Bielefeld'),
(4477, 'https://ror.org/05aeshm06', 'en', 1, 'https://ror.org/05aeshm06 Governador Celso Ramos Hospital'),
(4478, 'https://ror.org/05afnhv08', 'en', 1, 'https://ror.org/05afnhv08 Sapporo National Hospital 国立病院機構北海道がんセンター'),
(4479, 'https://ror.org/05ahq3q81', 'en', 1, 'https://ror.org/05ahq3q81 Amersham Hospital'),
(4480, 'https://ror.org/05ajyt645', 'en', 1, 'https://ror.org/05ajyt645 Japanese Red Cross Society Wakayama Medical Center 日本赤十字社和歌山医療センター'),
(4481, 'https://ror.org/05am5g719', 'en', 1, 'https://ror.org/05am5g719 St Mark''s Hospital'),
(4482, 'https://ror.org/05apdps44', 'en', 1, 'https://ror.org/05apdps44 Raigmore Hospital'),
(4483, 'https://ror.org/05aqcx827', 'en', 1, 'https://ror.org/05aqcx827 Ayrshire Central Hospital'),
(4484, 'https://ror.org/05atemp08', 'en', 1, 'https://ror.org/05atemp08 MedStar Health'),
(4485, 'https://ror.org/05atz9219', 'en', 1, 'https://ror.org/05atz9219 East Stroudsburg University Université de pennsylvanie d''east stroudsburg'),
(4486, 'https://ror.org/05av4b478', 'en', 1, 'https://ror.org/05av4b478 Sri Dharmasthala Manjunatheshwara College of Dental Sciences & Hospital'),
(4487, 'https://ror.org/05ayf4d73', 'en', 1, 'https://ror.org/05ayf4d73 Southlake Regional Health Center'),
(4488, 'https://ror.org/05aykvr94', 'de', 1, 'https://ror.org/05aykvr94 Augusta Krankenhaus'),
(4489, 'https://ror.org/05azzyk65', 'en', 1, 'https://ror.org/05azzyk65 Piedmont Athens Regional'),
(4490, 'https://ror.org/05b01nv96', 'en', 1, 'https://ror.org/05b01nv96 Subang Jaya Medical Centre'),
(4491, 'https://ror.org/05b021m32', 'en', 1, 'https://ror.org/05b021m32 Alta Bates Summit Medical Center'),
(4492, 'https://ror.org/05b0gpy83', 'en', 1, 'https://ror.org/05b0gpy83 Center for Forensic Mental Health, Chiba University 千葉大学 社会精神保健研究センター'),
(4493, 'https://ror.org/05b45bk66', 'en', 1, 'https://ror.org/05b45bk66 Regional Environmental Center for Central and Eastern Europe'),
(4494, 'https://ror.org/05b6ypc36', 'no_lang_code', 1, 'https://ror.org/05b6ypc36 Volvo (Sweden) Volvokoncernen'),
(4495, 'https://ror.org/05b81av32', 'en', 1, 'https://ror.org/05b81av32 Luton and Dunstable Hospital'),
(4496, 'https://ror.org/05b8yvg40', 'en', 1, 'https://ror.org/05b8yvg40 Barnsley Hospital'),
(4497, 'https://ror.org/05bd2wa15', 'en', 1, 'https://ror.org/05bd2wa15 Shanghai Mental Health Center 上海市精神卫生中心'),
(4498, 'https://ror.org/05be98497', 'en', 1, 'https://ror.org/05be98497 Okinawa Prefectural Institute of Health and Environment 健康と環境の沖縄県立大学'),
(4499, 'https://ror.org/05bhd7f62', 'en', 1, 'https://ror.org/05bhd7f62 458th Hospital PLA 中国人民解放军第四五八'),
(4500, 'https://ror.org/05bjm5v11', 'no_lang_code', 1, 'https://ror.org/05bjm5v11 Sibtech (United States)'),
(4501, 'https://ror.org/05bp3jx78', 'en', 1, 'https://ror.org/05bp3jx78 Tokyo Metropolitan Kiyose Children''s Hospital 東京都立小児総合医療センター'),
(4502, 'https://ror.org/05bpnne23', 'en', 1, 'https://ror.org/05bpnne23 MetroWest Medical Center'),
(4503, 'https://ror.org/05bq1qp94', 'en', 1, 'https://ror.org/05bq1qp94 Forrest General Hospital'),
(4504, 'https://ror.org/05brmpx55', 'en', 1, 'https://ror.org/05brmpx55 John F. Kennedy Medical Center'),
(4505, 'https://ror.org/05bt0cf40', 'tr', 1, 'https://ror.org/05bt0cf40 Okmeydanı Eğitim ve Araştırma Hastanesi'),
(4506, 'https://ror.org/05btaka91', 'no_lang_code', 1, 'https://ror.org/05btaka91 University of Veterinary Medicine in Košice Univerzita veterinárskeho lekárstva a farmácie v Košiciach'),
(4507, 'https://ror.org/05bx1gz93', 'en', 1, 'https://ror.org/05bx1gz93 Utsunomiya University 宇都宮大学'),
(4508, 'https://ror.org/05bx2yj81', 'en', 1, 'https://ror.org/05bx2yj81 Salisbury District Hospital'),
(4509, 'https://ror.org/05bxb3784', 'no_lang_code', 1, 'https://ror.org/05bxb3784 Academia Sinica 中央研究院'),
(4510, 'https://ror.org/05by5hm18', 'en', 1, 'https://ror.org/05by5hm18 California State Polytechnic University Universidad Estatal Politécnica de California, Pomona Université d''État polytechnique de californie à pomona'),
(4511, 'https://ror.org/05bz1tw26', 'pt', 1, 'https://ror.org/05bz1tw26 Hospital de Santa Maria'),
(4512, 'https://ror.org/05c06ww48', 'no_lang_code', 1, 'https://ror.org/05c06ww48 Anjo Kosei Hospital 安城更生病院'),
(4513, 'https://ror.org/05c3wfp46', 'en', 1, 'https://ror.org/05c3wfp46 Governor''s Institutes of Vermont'),
(4514, 'https://ror.org/05c4nx247', 'en', 1, 'https://ror.org/05c4nx247 B.C. Women''s Hospital & Health Centre'),
(4515, 'https://ror.org/05c5js686', 'en', 1, 'https://ror.org/05c5js686 Ashland University'),
(4516, 'https://ror.org/05c8e3213', 'no_lang_code', 1, 'https://ror.org/05c8e3213 Saiseikai Fukuoka General Hospital 済生会福岡総合病院'),
(4517, 'https://ror.org/05cetba26', 'en', 1, 'https://ror.org/05cetba26 Edward Hospital'),
(4518, 'https://ror.org/05cggb038', 'no_lang_code', 1, 'https://ror.org/05cggb038 Teck (Canada)'),
(4519, 'https://ror.org/05cqhmv85', 'en', 1, 'https://ror.org/05cqhmv85 SangStat Medical Corporation'),
(4520, 'https://ror.org/05crbcr45', 'en', 1, 'https://ror.org/05crbcr45 Tokyo University of Agriculture 東京農業大学'),
(4521, 'https://ror.org/05crs8s98', 'en', 1, 'https://ror.org/05crs8s98 Periyar University பெரியார் பல்கலைக்கழகம்'),
(4522, 'https://ror.org/05csdwp88', 'en', 1, 'https://ror.org/05csdwp88 Greenslopes Private Hospital'),
(4523, 'https://ror.org/05ct0ag17', 'en', 1, 'https://ror.org/05ct0ag17 Banner Estrella Medical Center'),
(4524, 'https://ror.org/05ct3pv92', 'no_lang_code', 1, 'https://ror.org/05ct3pv92 Lanxess (Canada)'),
(4525, 'https://ror.org/05cvd2j85', 'pt', 1, 'https://ror.org/05cvd2j85 Hospital de Santa Marta'),
(4526, 'https://ror.org/05cvxat96', 'en', 1, 'https://ror.org/05cvxat96 Walton Centre'),
(4527, 'https://ror.org/05cwpz219', 'en', 1, 'https://ror.org/05cwpz219 Riverview Hospital'),
(4528, 'https://ror.org/05cx69s52', 'en', 1, 'https://ror.org/05cx69s52 Command Hospital Air Force'),
(4529, 'https://ror.org/05cz6df97', 'en', 1, 'https://ror.org/05cz6df97 Alabama Department of Mental Health'),
(4530, 'https://ror.org/05d2xpa49', 'en', 1, 'https://ror.org/05d2xpa49 First Hospital of Lanzhou University'),
(4531, 'https://ror.org/05d503a40', 'en', 1, 'https://ror.org/05d503a40 Iwate Prefectural Kamaishi Hospital'),
(4532, 'https://ror.org/05d576879', 'en', 1, 'https://ror.org/05d576879 Southmead Hospital'),
(4533, 'https://ror.org/05d5vvz89', 'en', 1, 'https://ror.org/05d5vvz89 First Affiliated Hospital of Jinan University 暨南大学附属第一医院'),
(4534, 'https://ror.org/05d6v2h63', 'fr', 1, 'https://ror.org/05d6v2h63 Hôpital Manchester'),
(4535, 'https://ror.org/05d871a36', 'en', 1, 'https://ror.org/05d871a36 Saifee Hospital'),
(4536, 'https://ror.org/05d9dtr71', 'en', 1, 'https://ror.org/05d9dtr71 Changhua Christian Hospital'),
(4537, 'https://ror.org/05d9wmt54', 'no_lang_code', 1, 'https://ror.org/05d9wmt54 Mpilo Central Hospital'),
(4538, 'https://ror.org/05db3sk67', 'en', 1, 'https://ror.org/05db3sk67 New Jewish Home'),
(4539, 'https://ror.org/05dbe0q91', 'en', 1, 'https://ror.org/05dbe0q91 Warren Spring Laboratory'),
(4540, 'https://ror.org/05dd3wr66', 'en', 1, 'https://ror.org/05dd3wr66 Huntsman Marine Science Centre'),
(4541, 'https://ror.org/05deks119', 'en', 1, 'https://ror.org/05deks119 Mount Sinai Hospital'),
(4542, 'https://ror.org/05dfcz246', 'en', 1, 'https://ror.org/05dfcz246 Tianjin University of Traditional Chinese Medicine 天津中医药大学'),
(4543, 'https://ror.org/05dfdta49', 'en', 1, 'https://ror.org/05dfdta49 Aultman Health Foundation'),
(4544, 'https://ror.org/05dfzd836', 'es', 1, 'https://ror.org/05dfzd836 Hospital Universitario Infanta Sofía'),
(4545, 'https://ror.org/05dhw1e18', 'no_lang_code', 1, 'https://ror.org/05dhw1e18 Kinan Hospital'),
(4546, 'https://ror.org/05dkqa017', 'en', 1, 'https://ror.org/05dkqa017 Hochschule Kaiserslautern University of Applied Sciences Kaiserslautern'),
(4547, 'https://ror.org/05dm4ck87', 'en', 1, 'https://ror.org/05dm4ck87 Emory University Hospital'),
(4548, 'https://ror.org/05dm6kv37', 'en', 1, 'https://ror.org/05dm6kv37 Institute of Child and Mother Health'),
(4549, 'https://ror.org/05dna8580', 'de', 1, 'https://ror.org/05dna8580 VDI/VDE Innovation + Technik'),
(4550, 'https://ror.org/05dp7wz77', 'en', 1, 'https://ror.org/05dp7wz77 Creative Health Care Management'),
(4551, 'https://ror.org/05drcjw53', 'en', 1, 'https://ror.org/05drcjw53 Pai Chai University 배재대학교'),
(4552, 'https://ror.org/05drpm847', 'it', 1, 'https://ror.org/05drpm847 Ospedale Civile di Venezia'),
(4553, 'https://ror.org/05dsgrz38', 'en', 1, 'https://ror.org/05dsgrz38 Hawaii Permanente Medical Group'),
(4554, 'https://ror.org/05dtqka83', 'hu', 1, 'https://ror.org/05dtqka83 Békés Megyei Központi Kórház'),
(4555, 'https://ror.org/05dxmex87', 'en', 1, 'https://ror.org/05dxmex87 Minnesota Medical Association'),
(4556, 'https://ror.org/05dzsmt79', 'no', 1, 'https://ror.org/05dzsmt79 Helse Førde'),
(4557, 'https://ror.org/05e1xz016', 'en', 1, 'https://ror.org/05e1xz016 Shalvata Mental Health Center המרכז לבריאות הנפש שלוותה'),
(4558, 'https://ror.org/05e247w35', 'en', 1, 'https://ror.org/05e247w35 Morristown Hamblen Hospital Foundation'),
(4559, 'https://ror.org/05e272m53', 'en', 1, 'https://ror.org/05e272m53 Munroe Regional Medical Center'),
(4560, 'https://ror.org/05e3rkh95', 'en', 1, 'https://ror.org/05e3rkh95 Sweet Briar College'),
(4561, 'https://ror.org/05eb9pt23', 'en', 1, 'https://ror.org/05eb9pt23 Methodist Dallas Medical Center'),
(4562, 'https://ror.org/05ecec111', 'en', 1, 'https://ror.org/05ecec111 Bạch Mai Hospital Bệnh viện Bạch Mai'),
(4563, 'https://ror.org/05echw708', 'en', 1, 'https://ror.org/05echw708 Archbishop Makarios III Hospital'),
(4564, 'https://ror.org/05ee2qy47', 'en', 1, 'https://ror.org/05ee2qy47 Queen Elizabeth Hospital'),
(4565, 'https://ror.org/05eer8g02', 'en', 1, 'https://ror.org/05eer8g02 Jimma University'),
(4566, 'https://ror.org/05eewjw07', 'no_lang_code', 1, 'https://ror.org/05eewjw07 Bellbrook Labs (United States)'),
(4567, 'https://ror.org/05ef11p71', 'en', 1, 'https://ror.org/05ef11p71 Grochowski Hospital'),
(4568, 'https://ror.org/05efbh861', 'en', 1, 'https://ror.org/05efbh861 Prince Charles Hospital'),
(4569, 'https://ror.org/05efr5n38', 'en', 1, 'https://ror.org/05efr5n38 Taranaki Base Hospital'),
(4570, 'https://ror.org/05efsr055', 'en', 1, 'https://ror.org/05efsr055 Estonian Interuniversity Population Research Centre'),
(4571, 'https://ror.org/05ehe6278', 'no_lang_code', 1, 'https://ror.org/05ehe6278 Cameco (Canada)'),
(4572, 'https://ror.org/05ejygc42', 'en', 1, 'https://ror.org/05ejygc42 Foundation for Advancement of International Medical Education and Research'),
(4573, 'https://ror.org/05ekwbr88', 'en', 1, 'https://ror.org/05ekwbr88 Chicago State University Université d''État de chicago'),
(4574, 'https://ror.org/05en5nh73', 'en', 1, 'https://ror.org/05en5nh73 University of Seoul 서울시립대학교'),
(4575, 'https://ror.org/05epcpp46', 'en', 1, 'https://ror.org/05epcpp46 Asahi University 朝日大学'),
(4576, 'https://ror.org/05eq01d13', 'en', 1, 'https://ror.org/05eq01d13 Gold Coast Hospital'),
(4577, 'https://ror.org/05eq41471', 'en', 1, 'https://ror.org/05eq41471 Veterans Health Administration'),
(4578, 'https://ror.org/05eq86m59', 'en', 1, 'https://ror.org/05eq86m59 Lander University'),
(4579, 'https://ror.org/05eqt7s39', 'en', 1, 'https://ror.org/05eqt7s39 Athens Information Technology'),
(4580, 'https://ror.org/05eqycp84', 'en', 1, 'https://ror.org/05eqycp84 Cheng Ching Hospital 澄清湖医院'),
(4581, 'https://ror.org/05et9pf90', 'en', 1, 'https://ror.org/05et9pf90 B.P. Koirala Institute of Health Sciences विपी कोइराला स्वास्थ्य विज्ञान प्रतिष्ठान'),
(4582, 'https://ror.org/05exmrf24', 'en', 1, 'https://ror.org/05exmrf24 Coppin State University'),
(4583, 'https://ror.org/05f2xwq77', 'en', 1, 'https://ror.org/05f2xwq77 Charles Clifford Dental Hospital'),
(4584, 'https://ror.org/05faw8a11', 'en', 1, 'https://ror.org/05faw8a11 Shaughnessy Hospital'),
(4585, 'https://ror.org/05fb8h434', 'pt', 1, 'https://ror.org/05fb8h434 Instituto Superior de Administração e Gestão'),
(4586, 'https://ror.org/05fccw142', 'it', 1, 'https://ror.org/05fccw142 Ospedale San Pietro Fatebenefratelli'),
(4587, 'https://ror.org/05fcfqq67', 'en', 1, 'https://ror.org/05fcfqq67 Oregon National Primate Research Center'),
(4588, 'https://ror.org/05fcrn131', 'en', 1, 'https://ror.org/05fcrn131 University Hospital Llandough'),
(4589, 'https://ror.org/05fde5z47', 'en', 1, 'https://ror.org/05fde5z47 Hampton University Université de hampton'),
(4590, 'https://ror.org/05fe2n505', 'en', 1, 'https://ror.org/05fe2n505 Royal Sussex County Hospital'),
(4591, 'https://ror.org/05fhtd457', 'es', 1, 'https://ror.org/05fhtd457 Hospital Central Militar'),
(4592, 'https://ror.org/05fk0de79', 'en', 1, 'https://ror.org/05fk0de79 Bassett Medical Center'),
(4593, 'https://ror.org/05fkq4848', 'fr', 1, 'https://ror.org/05fkq4848 Hôpital Civil, Strasbourg'),
(4594, 'https://ror.org/05fmwts39', 'tr', 1, 'https://ror.org/05fmwts39 Şişli Etfal Eğitim ve Araştırma Hastanesi'),
(4595, 'https://ror.org/05fnpxf31', 'en', 1, 'https://ror.org/05fnpxf31 Holy Name Medical Center'),
(4596, 'https://ror.org/05fscjm95', 'en', 1, 'https://ror.org/05fscjm95 Jorvi Hospital Jorvin sairaala'),
(4597, 'https://ror.org/05fwyj602', 'en', 1, 'https://ror.org/05fwyj602 St. Jerome''s University'),
(4598, 'https://ror.org/05fx5mz56', 'en', 1, 'https://ror.org/05fx5mz56 University of Nigeria Teaching Hospital'),
(4599, 'https://ror.org/05fyf7995', 'en', 1, 'https://ror.org/05fyf7995 R. G. Kar Medical College and Hospital'),
(4600, 'https://ror.org/05fz2yc38', 'it', 1, 'https://ror.org/05fz2yc38 Ospedale Bellaria, Ospedale Bellaria "Carlo Alberto Pizzardi"'),
(4601, 'https://ror.org/05g1mag11', 'en', 1, 'https://ror.org/05g1mag11 Hebei Normal University of Science and Technology 河北科技师范学院'),
(4602, 'https://ror.org/05g2amy04', 'en', 1, 'https://ror.org/05g2amy04 Acıbadem Adana Hospital'),
(4603, 'https://ror.org/05g2gkn28', 'en', 1, 'https://ror.org/05g2gkn28 Minoh City Hospital 箕面市立病院'),
(4604, 'https://ror.org/05g3m5c29', 'en', 1, 'https://ror.org/05g3m5c29 Asanogawa General Hospital 浅ノ川総合病院'),
(4605, 'https://ror.org/05g42cb02', 'en', 1, 'https://ror.org/05g42cb02 Netcare Sunninghill Hospital'),
(4606, 'https://ror.org/05g44an34', 'en', 1, 'https://ror.org/05g44an34 Long Beach City College'),
(4607, 'https://ror.org/05g4mtv59', 'no_lang_code', 1, 'https://ror.org/05g4mtv59 Hewlett-Packard (United Kingdom)'),
(4608, 'https://ror.org/05g5v7496', 'en', 1, 'https://ror.org/05g5v7496 Burnley General Teaching Hospital'),
(4609, 'https://ror.org/05g6w6j42', 'en', 1, 'https://ror.org/05g6w6j42 Armed Forces Medical College ആംഡ് ഫോഴ്സസ് മെഡിക്കൽ കോളേജ്'),
(4610, 'https://ror.org/05g91z486', 'no_lang_code', 1, 'https://ror.org/05g91z486 Organ Technologies (Japan) オーガンテクノロジーズ'),
(4611, 'https://ror.org/05gbwr869', 'en', 1, 'https://ror.org/05gbwr869 First Affiliated Hospital of Nanchang University 南昌大学第一附属医院'),
(4612, 'https://ror.org/05gehxw18', 'en', 1, 'https://ror.org/05gehxw18 Detroit Medical Center'),
(4613, 'https://ror.org/05gf6dk22', 'pt', 1, 'https://ror.org/05gf6dk22 Base Hospital Hospital de Base'),
(4614, 'https://ror.org/05gfebp73', 'en', 1, 'https://ror.org/05gfebp73 CSI Holdsworth Memorial Hospital'),
(4615, 'https://ror.org/05gg4qm19', 'en', 1, 'https://ror.org/05gg4qm19 Yamagata University Hospital 山形大学医学部附属病院'),
(4616, 'https://ror.org/05gh0na70', 'en', 1, 'https://ror.org/05gh0na70 Jinnah Medical & Dental College'),
(4617, 'https://ror.org/05gh5ar80', 'en', 1, 'https://ror.org/05gh5ar80 Gloucestershire Royal Hospital'),
(4618, 'https://ror.org/05gn4hz56', 'no_lang_code', 1, 'https://ror.org/05gn4hz56 Kishiwada Tokushukai Hospital 岸和田徳洲会病院'),
(4619, 'https://ror.org/05gn84d31', 'es', 1, 'https://ror.org/05gn84d31 Hospital de León'),
(4620, 'https://ror.org/05gnna589', 'it', 1, 'https://ror.org/05gnna589 Consorzio Nazionale Interuniversitario per la Nanoelettronica Interuniversity Consortium for Nanoelectronics'),
(4621, 'https://ror.org/05gpmx630', 'no_lang_code', 1, 'https://ror.org/05gpmx630 ShinKokura Hospital 新小倉病院'),
(4622, 'https://ror.org/05gqcbq50', 'en', 1, 'https://ror.org/05gqcbq50 Aspen Center For Physics Centre pour la physique d''aspen'),
(4623, 'https://ror.org/05gr5bv62', 'no_lang_code', 1, 'https://ror.org/05gr5bv62 Vala Sciences (United States)'),
(4624, 'https://ror.org/05gx19t11', 'en', 1, 'https://ror.org/05gx19t11 Evergreen Health Medical Center'),
(4625, 'https://ror.org/05gzcpj23', 'pt', 1, 'https://ror.org/05gzcpj23 Escola Superior de Saúde do Alcoitão'),
(4626, 'https://ror.org/05h0f1d70', 'en', 1, 'https://ror.org/05h0f1d70 C. S. Mott Children''s Hospital'),
(4627, 'https://ror.org/05h1kgg64', 'en', 1, 'https://ror.org/05h1kgg64 National Institute of Health'),
(4628, 'https://ror.org/05h29d328', 'en', 1, 'https://ror.org/05h29d328 Saint Francis Memorial Hospital'),
(4629, 'https://ror.org/05h450y11', 'no_lang_code', 1, 'https://ror.org/05h450y11 Talaria (United States)'),
(4630, 'https://ror.org/05h4zj272', 'en', 1, 'https://ror.org/05h4zj272 Harbor–UCLA Medical Center'),
(4631, 'https://ror.org/05h6r6f02', 'no_lang_code', 1, 'https://ror.org/05h6r6f02 Saiseikai Yahata General Hospital 福岡県済生会八幡総合病院'),
(4632, 'https://ror.org/05h7pem82', 'no_lang_code', 1, 'https://ror.org/05h7pem82 Bugando Medical Centre'),
(4633, 'https://ror.org/05h8pvh61', 'fr', 1, 'https://ror.org/05h8pvh61 Hôpital Broussais'),
(4634, 'https://ror.org/05h9pgm95', 'en', 1, 'https://ror.org/05h9pgm95 Kyungsung University 경성대학교'),
(4635, 'https://ror.org/05hbrxp80', 'en', 1, 'https://ror.org/05hbrxp80 Agricultural Research Organization מנהל המחקר החקלאי - מרכז וולקני'),
(4636, 'https://ror.org/05hh8d621', 'no_lang_code', 1, 'https://ror.org/05hh8d621 IBM (United States)'),
(4637, 'https://ror.org/05hkmas65', 'en', 1, 'https://ror.org/05hkmas65 Baptist Hospital 침례병원'),
(4638, 'https://ror.org/05hm0vv72', 'en', 1, 'https://ror.org/05hm0vv72 Shahjalal University of Science and Technology শাহজালাল বিজ্ঞান ও প্রযুক্তি বিশ্ববিদ্যালয়'),
(4639, 'https://ror.org/05hm6ny55', 'en', 1, 'https://ror.org/05hm6ny55 Good Samaritan Hospital'),
(4640, 'https://ror.org/05hmwx760', 'en', 1, 'https://ror.org/05hmwx760 Poultry Industry Council'),
(4641, 'https://ror.org/05hn3aw08', 'en', 1, 'https://ror.org/05hn3aw08 Lincoln University - Missouri'),
(4642, 'https://ror.org/05hpt6x15', 'en', 1, 'https://ror.org/05hpt6x15 Riverside Regional Medical Center'),
(4643, 'https://ror.org/05hrczs03', 'en', 1, 'https://ror.org/05hrczs03 American Association of University Women'),
(4644, 'https://ror.org/05hrg0j24', 'en', 1, 'https://ror.org/05hrg0j24 Lister Hospital'),
(4645, 'https://ror.org/05hs5r386', 'en', 1, 'https://ror.org/05hs5r386 Mathematical Sciences Research Institute'),
(4646, 'https://ror.org/05hs7nx69', 'en', 1, 'https://ror.org/05hs7nx69 Social Insurance Futase Hospital 社会保険 二瀬病院'),
(4647, 'https://ror.org/05htjfp05', 'en', 1, 'https://ror.org/05htjfp05 Loma Linda University Children''s Hospital'),
(4648, 'https://ror.org/05hwn6x82', 'en', 1, 'https://ror.org/05hwn6x82 Spring Branch Medical Center'),
(4649, 'https://ror.org/05hzgxd58', 'pt', 1, 'https://ror.org/05hzgxd58 Universidade de Uberaba'),
(4650, 'https://ror.org/05j0w0e76', 'en', 1, 'https://ror.org/05j0w0e76 American Association For The Advancement of Science Asociación Estadounidense para el Avance de la Ciencia Association américaine pour l''avancement de la science'),
(4651, 'https://ror.org/05j1gs298', 'en', 1, 'https://ror.org/05j1gs298 Erasmus Hospital Erasmus Ziekenhuis Hôpital Érasme'),
(4652, 'https://ror.org/05j37e495', 'en', 1, 'https://ror.org/05j37e495 South Western Sydney Local Health District'),
(4653, 'https://ror.org/05j40pq70', 'en', 1, 'https://ror.org/05j40pq70 Saitama Red Cross Hospital さいたま赤十字病院'),
(4654, 'https://ror.org/05j4p5w63', 'en', 1, 'https://ror.org/05j4p5w63 MetroHealth Medical Center'),
(4655, 'https://ror.org/05j5y0r89', 'en', 1, 'https://ror.org/05j5y0r89 Sir Paul Boffa Hospital'),
(4656, 'https://ror.org/05j752d14', 'en', 1, 'https://ror.org/05j752d14 McLaughlin Research Institute'),
(4657, 'https://ror.org/05j7rz205', 'en', 1, 'https://ror.org/05j7rz205 Halifax Health Medical Center'),
(4658, 'https://ror.org/05j82jr52', 'en', 1, 'https://ror.org/05j82jr52 Gaylord Hospital'),
(4659, 'https://ror.org/05j8hg602', 'en', 1, 'https://ror.org/05j8hg602 American Physical Society Société américaine de physique'),
(4660, 'https://ror.org/05j8naw58', 'en', 1, 'https://ror.org/05j8naw58 Sinai Health System'),
(4661, 'https://ror.org/05j8x4n38', 'en', 1, 'https://ror.org/05j8x4n38 San Francisco General Hospital'),
(4662, 'https://ror.org/05j91v252', 'en', 1, 'https://ror.org/05j91v252 Oregon Research Institute'),
(4663, 'https://ror.org/05japer20', 'en', 1, 'https://ror.org/05japer20 Wilson College'),
(4664, 'https://ror.org/05jb57h29', 'en', 1, 'https://ror.org/05jb57h29 Hatanpaan Sairaala Hatanpää Hospital'),
(4665, 'https://ror.org/05jbt9m15', 'en', 1, 'https://ror.org/05jbt9m15 Universidad de Arkansas University of Arkansas at Fayetteville Université de l''arkansas'),
(4666, 'https://ror.org/05jbvqr49', 'no_lang_code', 1, 'https://ror.org/05jbvqr49 Gastops (Canada)'),
(4667, 'https://ror.org/05jc5ee02', 'en', 1, 'https://ror.org/05jc5ee02 University of Minnesota Children''s Hospital'),
(4668, 'https://ror.org/05jd2pj53', 'en', 1, 'https://ror.org/05jd2pj53 King Chulalongkorn Memorial Hospital โรงพยาบาลจุฬาลงกรณ์'),
(4669, 'https://ror.org/05jeza980', 'no_lang_code', 1, 'https://ror.org/05jeza980 Rolls-Royce (Germany)'),
(4670, 'https://ror.org/05jfq2w07', 'en', 1, 'https://ror.org/05jfq2w07 Scottish Universities Environmental Research Centre'),
(4671, 'https://ror.org/05jg8yp15', 'en', 1, 'https://ror.org/05jg8yp15 Hammersmith Hospital'),
(4672, 'https://ror.org/05jhpk184', 'en', 1, 'https://ror.org/05jhpk184 Memorial Hospital'),
(4673, 'https://ror.org/05jk51a88', 'en', 1, 'https://ror.org/05jk51a88 Nihon University 日本大学'),
(4674, 'https://ror.org/05jr18655', 'en', 1, 'https://ror.org/05jr18655 Self-Defense Forces Central Hospital 自衛隊中央病院'),
(4675, 'https://ror.org/05jr1e079', 'no_lang_code', 1, 'https://ror.org/05jr1e079 Advanced Medical Electronics (United States)'),
(4676, 'https://ror.org/05jr4qt09', 'en', 1, 'https://ror.org/05jr4qt09 Stamford Hospital'),
(4677, 'https://ror.org/05jse4442', 'it', 1, 'https://ror.org/05jse4442 Ospedale Santa Corona'),
(4678, 'https://ror.org/05jt1df44', 'en', 1, 'https://ror.org/05jt1df44 Milton Keynes Hospital'),
(4679, 'https://ror.org/05jtcqr88', 'no_lang_code', 1, 'https://ror.org/05jtcqr88 Thermo Fisher Scientific (China)'),
(4680, 'https://ror.org/05jv5t769', 'en', 1, 'https://ror.org/05jv5t769 Eltron Research');
INSERT INTO `rors` VALUES
(4681, 'https://ror.org/05jvgwr81', 'en', 1, 'https://ror.org/05jvgwr81 National Institute of Medical Rehabilitation Országos Orvosi Rehabilitációs Intézet'),
(4682, 'https://ror.org/05jvra197', 'no_lang_code', 1, 'https://ror.org/05jvra197 JA Shizuoka Koseiren ENSHU hospital じゃ しずおか こせいれん えんしゅ ほｓぴたｌ'),
(4683, 'https://ror.org/05jwhyp78', 'en', 1, 'https://ror.org/05jwhyp78 Good Samaritan Hospital Medical Center'),
(4684, 'https://ror.org/05jxj5k51', 'no_lang_code', 1, 'https://ror.org/05jxj5k51 Eesti Innovatsiooni Instituut'),
(4685, 'https://ror.org/05jyavm62', 'en', 1, 'https://ror.org/05jyavm62 Henrico Doctors'' Hospital'),
(4686, 'https://ror.org/05jyrng31', 'en', 1, 'https://ror.org/05jyrng31 McMaster University Medical Centre'),
(4687, 'https://ror.org/05jytgw54', 'en', 1, 'https://ror.org/05jytgw54 Gay Men''s Health Crisis'),
(4688, 'https://ror.org/05k07p323', 'en', 1, 'https://ror.org/05k07p323 Texas Health Dallas'),
(4689, 'https://ror.org/05k1smr06', 'cs', 1, 'https://ror.org/05k1smr06 Nemocnice Šternberk'),
(4690, 'https://ror.org/05k4mr860', 'en', 1, 'https://ror.org/05k4mr860 Saint John Regional Hospital'),
(4691, 'https://ror.org/05k71ja87', 'en', 1, 'https://ror.org/05k71ja87 Statistics Canada Statistique Canada'),
(4692, 'https://ror.org/05k7z2b58', 'en', 1, 'https://ror.org/05k7z2b58 Shriners Hospitals for Children Medical Center - Lexington'),
(4693, 'https://ror.org/05k87vq12', 'no_lang_code', 1, 'https://ror.org/05k87vq12 Microsoft Research (United Kingdom)'),
(4694, 'https://ror.org/05k8nw239', 'no_lang_code', 1, 'https://ror.org/05k8nw239 Western Research Company, Inc.'),
(4695, 'https://ror.org/05k8pq072', 'pt', 1, 'https://ror.org/05k8pq072 Universidade Cruzeiro do Sul'),
(4696, 'https://ror.org/05k9bck94', 'en', 1, 'https://ror.org/05k9bck94 Marietta Memorial Hospital'),
(4697, 'https://ror.org/05kcb8115', 'it', 1, 'https://ror.org/05kcb8115 Consorzio Interuniversitario Per L''Ottimizzazione E La Ricerca Operativa'),
(4698, 'https://ror.org/05ked8481', 'en', 1, 'https://ror.org/05ked8481 University of South Carolina Beaufort'),
(4699, 'https://ror.org/05kfvx519', 'fr', 1, 'https://ror.org/05kfvx519 Hôpital Albert Michallon'),
(4700, 'https://ror.org/05kjeqc29', 'no_lang_code', 1, 'https://ror.org/05kjeqc29 Jahra Hospital مستشفى الجهراء'),
(4701, 'https://ror.org/05kn6fr85', 'en', 1, 'https://ror.org/05kn6fr85 Government Medical College शासकीय वैद्यकीय महाविद्यालय व रुग्णालय, औरंगाबाद'),
(4702, 'https://ror.org/05kpx1157', 'en', 1, 'https://ror.org/05kpx1157 Royal Preston Hospital'),
(4703, 'https://ror.org/05kr7zx86', 'en', 1, 'https://ror.org/05kr7zx86 Georgia College & State University'),
(4704, 'https://ror.org/05ks08368', 'en', 1, 'https://ror.org/05ks08368 Komfo Anokye Teaching Hospital'),
(4705, 'https://ror.org/05ktv1y25', 'en', 1, 'https://ror.org/05ktv1y25 William Woods University'),
(4706, 'https://ror.org/05kwh9e63', 'no_lang_code', 1, 'https://ror.org/05kwh9e63 Adenosine Therapeutics (United States)'),
(4707, 'https://ror.org/05kwhtp56', 'es', 1, 'https://ror.org/05kwhtp56 Hospital Perpetuo Socorro'),
(4708, 'https://ror.org/05kx1ke03', 'en', 1, 'https://ror.org/05kx1ke03 Narayana Health'),
(4709, 'https://ror.org/05kxrms28', 'hu', 1, 'https://ror.org/05kxrms28 Bajcsy-Zsilinszky Kórház és Rendelőintézet'),
(4710, 'https://ror.org/05kz7bw59', 'en', 1, 'https://ror.org/05kz7bw59 Kwai Chung Hospital 葵涌醫院'),
(4711, 'https://ror.org/05kzadn81', 'en', 1, 'https://ror.org/05kzadn81 Nara Advanced Teachers College for Women, Nara Women''s University 奈良女子大学'),
(4712, 'https://ror.org/05kzbz291', 'no_lang_code', 1, 'https://ror.org/05kzbz291 Nagoya Kyouritsu Hospital 名古屋共立病院'),
(4713, 'https://ror.org/05m34fq04', 'no_lang_code', 1, 'https://ror.org/05m34fq04 Motorola (France)'),
(4714, 'https://ror.org/05m3qrs33', 'en', 1, 'https://ror.org/05m3qrs33 Ipswich Hospital'),
(4715, 'https://ror.org/05m4bwg25', 'no_lang_code', 1, 'https://ror.org/05m4bwg25 Shinonoi General Hospital 篠ノ井総合病院'),
(4716, 'https://ror.org/05m4t4820', 'en', 1, 'https://ror.org/05m4t4820 Makassed General Hospital'),
(4717, 'https://ror.org/05m5z4f19', 'en', 1, 'https://ror.org/05m5z4f19 Steel Construction Institute'),
(4718, 'https://ror.org/05m64xs77', 'en', 1, 'https://ror.org/05m64xs77 Monklands Hospital'),
(4719, 'https://ror.org/05m6e7d23', 'it', 1, 'https://ror.org/05m6e7d23 Ospedale San Giuseppe'),
(4720, 'https://ror.org/05m762q77', 'no_lang_code', 1, 'https://ror.org/05m762q77 Tianjin haihe hospital 天津市海河医院'),
(4721, 'https://ror.org/05m7vf540', 'en', 1, 'https://ror.org/05m7vf540 Capital District Health Authority'),
(4722, 'https://ror.org/05m7zw681', 'no_lang_code', 1, 'https://ror.org/05m7zw681 Rio Tinto (United Kingdom)'),
(4723, 'https://ror.org/05m8d2x46', 'en', 1, 'https://ror.org/05m8d2x46 North Shore University Hospital'),
(4724, 'https://ror.org/05ma4gw77', 'en', 1, 'https://ror.org/05ma4gw77 Universidad del Pacífico University of the Pacific Université du pacifique'),
(4725, 'https://ror.org/05maved80', 'en', 1, 'https://ror.org/05maved80 Northwest Missouri State University'),
(4726, 'https://ror.org/05mdb5j94', 'en', 1, 'https://ror.org/05mdb5j94 MedStar Harbor Hospital'),
(4727, 'https://ror.org/05megpp22', 'pt', 1, 'https://ror.org/05megpp22 Hospital Geral de Fortaleza'),
(4728, 'https://ror.org/05meqs994', 'no_lang_code', 1, 'https://ror.org/05meqs994 Innovation Research and Training'),
(4729, 'https://ror.org/05mg61p80', 'en', 1, 'https://ror.org/05mg61p80 Englewood Hospital and Medical Center'),
(4730, 'https://ror.org/05mgn5w61', 'no_lang_code', 1, 'https://ror.org/05mgn5w61 Hiraka General Hospital 平鹿総合病院'),
(4731, 'https://ror.org/05mhswc23', 'en', 1, 'https://ror.org/05mhswc23 Kushiro City General Hospital 市立釧路総合病院'),
(4732, 'https://ror.org/05mj6fy81', 'en', 1, 'https://ror.org/05mj6fy81 Universidad de Houston-Downtown University of Houston - Downtown'),
(4733, 'https://ror.org/05mmga691', 'fi', 1, 'https://ror.org/05mmga691 Kymenlaakson keskussairaala'),
(4734, 'https://ror.org/05mnb6484', 'en', 1, 'https://ror.org/05mnb6484 Grambling State University Université d''État de grambling'),
(4735, 'https://ror.org/05mpt6s70', 'no_lang_code', 1, 'https://ror.org/05mpt6s70 Applica Sprl'),
(4736, 'https://ror.org/05mqksr19', 'en', 1, 'https://ror.org/05mqksr19 Catawba Valley Medical Center'),
(4737, 'https://ror.org/05mryn396', 'no_lang_code', 1, 'https://ror.org/05mryn396 Manipal Hospital'),
(4738, 'https://ror.org/05mshxb09', 'en', 1, 'https://ror.org/05mshxb09 Sheffield Children''s Hospital'),
(4739, 'https://ror.org/05msy3z48', 'en', 1, 'https://ror.org/05msy3z48 Legacy Good Samaritan Medical Center'),
(4740, 'https://ror.org/05mw4gk09', 'en', 1, 'https://ror.org/05mw4gk09 Rebecca Sieff Hospital'),
(4741, 'https://ror.org/05myvb614', 'en', 1, 'https://ror.org/05myvb614 Miami VA Healthcare System'),
(4742, 'https://ror.org/05mzkvr65', 'en', 1, 'https://ror.org/05mzkvr65 Skokie Hospital'),
(4743, 'https://ror.org/05n0m7p40', 'fr', 1, 'https://ror.org/05n0m7p40 Hôpital El Ayachi'),
(4744, 'https://ror.org/05n0wgt02', 'en', 1, 'https://ror.org/05n0wgt02 King Faisal Specialist Hospital & Research Centre مستشفى الملك فيصل التخصصي'),
(4745, 'https://ror.org/05n13be63', 'en', 1, 'https://ror.org/05n13be63 Children''s Hospital of Fudan University'),
(4746, 'https://ror.org/05n56ba96', 'en', 1, 'https://ror.org/05n56ba96 Latifa Hospital'),
(4747, 'https://ror.org/05n5d3f06', 'en', 1, 'https://ror.org/05n5d3f06 Nagahama City Hospital 長浜市病院'),
(4748, 'https://ror.org/05n5drh21', 'en', 1, 'https://ror.org/05n5drh21 George E. Wahlen Department of VA Medical Center'),
(4749, 'https://ror.org/05n8n9378', 'en', 1, 'https://ror.org/05n8n9378 Eduardo Mondlane University Universidade Eduardo Mondlane'),
(4750, 'https://ror.org/05n8v4z84', 'en', 1, 'https://ror.org/05n8v4z84 Milwaukee County Medical Complex'),
(4751, 'https://ror.org/05n952b74', 'en', 1, 'https://ror.org/05n952b74 North Mississippi Medical Center'),
(4752, 'https://ror.org/05n9fs062', 'no_lang_code', 1, 'https://ror.org/05n9fs062 Ghaem Hospital بیمارستان قائم'),
(4753, 'https://ror.org/05na1sz60', 'en', 1, 'https://ror.org/05na1sz60 Mercy Medical Center'),
(4754, 'https://ror.org/05nakwy60', 'en', 1, 'https://ror.org/05nakwy60 Ideta Eye Hospital 出田眼科病院'),
(4755, 'https://ror.org/05nbsaj33', 'en', 1, 'https://ror.org/05nbsaj33 Bhopal Memorial Hospital & Research Centre'),
(4756, 'https://ror.org/05ncvf986', 'en', 1, 'https://ror.org/05ncvf986 Sam Higginbottom Institute of Agriculture सैम हिग्गिनबॉटम कृषि, प्रौद्योगिकी एवं विज्ञान संस्थान അലഹബാദ് അഗ്രികൾച്ചറൽ ഇൻസ്റ്റിറ്റ്യൂട്ട്'),
(4757, 'https://ror.org/05ne3s142', 'en', 1, 'https://ror.org/05ne3s142 Saint Petersburg Academic University Санкт-Петербургский академический университет — научно-образовательный центр нанотехнологий'),
(4758, 'https://ror.org/05ne4t757', 'en', 1, 'https://ror.org/05ne4t757 Kent and Sussex Hospital'),
(4759, 'https://ror.org/05nfzf209', 'es', 1, 'https://ror.org/05nfzf209 Hospital Universitario Infanta Leonor'),
(4760, 'https://ror.org/05ngnkr69', 'no_lang_code', 1, 'https://ror.org/05ngnkr69 Ambergen (United States)'),
(4761, 'https://ror.org/05nhkt138', 'tr', 1, 'https://ror.org/05nhkt138 Bursa Yuksek Ihtisas Egitim Ve Arastirma Hastanesi'),
(4762, 'https://ror.org/05nmfef18', 'en', 1, 'https://ror.org/05nmfef18 Hoag Memorial Hospital Presbyterian'),
(4763, 'https://ror.org/05nmzkr23', 'en', 1, 'https://ror.org/05nmzkr23 Bankura Sammilani Medical College বাঁকুড়া সম্মিলনী মেডিক্যাল কলেজ'),
(4764, 'https://ror.org/05npsb488', 'en', 1, 'https://ror.org/05npsb488 Foundation for Medical Research'),
(4765, 'https://ror.org/05nr3de46', 'en', 1, 'https://ror.org/05nr3de46 Onomichi General Hospital 尾道総合病院'),
(4766, 'https://ror.org/05nrhca20', 'en', 1, 'https://ror.org/05nrhca20 West Australian Sleep Disorders Research Institute'),
(4767, 'https://ror.org/05ns8wm63', 'no_lang_code', 1, 'https://ror.org/05ns8wm63 Abratech Corporation'),
(4768, 'https://ror.org/05nsbhw27', 'en', 1, 'https://ror.org/05nsbhw27 Centre hospitalier pour enfants de l''est de l''Ontario Children''s Hospital of Eastern Ontario'),
(4769, 'https://ror.org/05nter171', 'en', 1, 'https://ror.org/05nter171 Avera Health'),
(4770, 'https://ror.org/05nv2rz39', 'en', 1, 'https://ror.org/05nv2rz39 University of Eswatini'),
(4771, 'https://ror.org/05nvmzs58', 'pt', 1, 'https://ror.org/05nvmzs58 Universidade de Santo Amaro'),
(4772, 'https://ror.org/05nx0xs09', 'en', 1, 'https://ror.org/05nx0xs09 Baoji University of Arts and Sciences 宝鸡文理学院'),
(4773, 'https://ror.org/05nyenj39', 'de', 1, 'https://ror.org/05nyenj39 Asklepios Hospital Barmbek Asklepios Klinik Barmbek'),
(4774, 'https://ror.org/05nygae07', 'pl', 1, 'https://ror.org/05nygae07 Okręgowy Szpital Kolejowy'),
(4775, 'https://ror.org/05nz57427', 'en', 1, 'https://ror.org/05nz57427 Cardinal Stritch University'),
(4776, 'https://ror.org/05nzesv70', 'en', 1, 'https://ror.org/05nzesv70 Royal Glamorgan Hospital'),
(4777, 'https://ror.org/05p1frt18', 'en', 1, 'https://ror.org/05p1frt18 Glostrup Hospital'),
(4778, 'https://ror.org/05p1phv38', 'en', 1, 'https://ror.org/05p1phv38 Huntington Medical Research Institutes'),
(4779, 'https://ror.org/05p21z194', 'it', 1, 'https://ror.org/05p21z194 Azienda Ospedaliera Universitaria Policlinico "Paolo Giaccone" di Palermo'),
(4780, 'https://ror.org/05p38yh32', 'en', 1, 'https://ror.org/05p38yh32 Hubei Cancer Hospital 湖北省肿瘤医院'),
(4781, 'https://ror.org/05p48p517', 'en', 1, 'https://ror.org/05p48p517 Northern California Institute for Research and Education'),
(4782, 'https://ror.org/05p4f7w60', 'en', 1, 'https://ror.org/05p4f7w60 University of the West Indies'),
(4783, 'https://ror.org/05p668j08', 'en', 1, 'https://ror.org/05p668j08 Ospidéal Ginearálta Naomh Lúcás St. Luke''s General Hospital'),
(4784, 'https://ror.org/05p89st11', 'en', 1, 'https://ror.org/05p89st11 American Geosciences Institute'),
(4785, 'https://ror.org/05pcyqv21', 'no_lang_code', 1, 'https://ror.org/05pcyqv21 Petro-Canada'),
(4786, 'https://ror.org/05peke140', 'es', 1, 'https://ror.org/05peke140 Hospital Virgen del Puerto'),
(4787, 'https://ror.org/05pet2p92', 'no_lang_code', 1, 'https://ror.org/05pet2p92 Nishida Hospital 西田病院'),
(4788, 'https://ror.org/05pfdp204', 'en', 1, 'https://ror.org/05pfdp204 Crozer-Keystone Health System'),
(4789, 'https://ror.org/05pgywt51', 'en', 1, 'https://ror.org/05pgywt51 Queen Elizabeth Hospital'),
(4790, 'https://ror.org/05ph11m41', 'en', 1, 'https://ror.org/05ph11m41 CTO Hospital Ospedale Centro Traumatologico Ortopedico'),
(4791, 'https://ror.org/05pkzpg75', 'en', 1, 'https://ror.org/05pkzpg75 Ningbo First Hospital 宁波市第一医院'),
(4792, 'https://ror.org/05pp39346', 'en', 1, 'https://ror.org/05pp39346 Haifa Medical Center'),
(4793, 'https://ror.org/05prep819', 'en', 1, 'https://ror.org/05prep819 National Hsinchu University of Education'),
(4794, 'https://ror.org/05pvryz52', 'no_lang_code', 1, 'https://ror.org/05pvryz52 IQ Solutions'),
(4795, 'https://ror.org/05pwfyy15', 'en', 1, 'https://ror.org/05pwfyy15 National Centre for Research and Development'),
(4796, 'https://ror.org/05pwsw714', 'en', 1, 'https://ror.org/05pwsw714 Hangzhou First People''s Hospital 杭州市第一人民医院'),
(4797, 'https://ror.org/05py5qd41', 'en', 1, 'https://ror.org/05py5qd41 Lebanon Valley College'),
(4798, 'https://ror.org/05q2e1368', 'no_lang_code', 1, 'https://ror.org/05q2e1368 ISA Associate'),
(4799, 'https://ror.org/05q60vz69', 'en', 1, 'https://ror.org/05q60vz69 South African Medical Research Council'),
(4800, 'https://ror.org/05q6tgt32', 'en', 1, 'https://ror.org/05q6tgt32 Kennedy Krieger Institute'),
(4801, 'https://ror.org/05q7jp496', 'en', 1, 'https://ror.org/05q7jp496 South African Institute for Medical Research'),
(4802, 'https://ror.org/05q87sg56', 'en', 1, 'https://ror.org/05q87sg56 Saint Joseph''s University Universidad de San José Université saint-joseph de philadelphie'),
(4803, 'https://ror.org/05q8e6988', 'en', 1, 'https://ror.org/05q8e6988 Southern University at New Orleans'),
(4804, 'https://ror.org/05q8mwj81', 'en', 1, 'https://ror.org/05q8mwj81 Hamilton General Hospital'),
(4805, 'https://ror.org/05q9t1y70', 'no_lang_code', 1, 'https://ror.org/05q9t1y70 Siga Technologies (United States)'),
(4806, 'https://ror.org/05qa36453', 'en', 1, 'https://ror.org/05qa36453 Olmsted Medical Center'),
(4807, 'https://ror.org/05qapqt30', 'en', 1, 'https://ror.org/05qapqt30 Montana Department of Public Health and Human Services'),
(4808, 'https://ror.org/05qcjn862', 'en', 1, 'https://ror.org/05qcjn862 Greenbrier Valley Medical Center'),
(4809, 'https://ror.org/05qderh61', 'en', 1, 'https://ror.org/05qderh61 University of Calabar Yunifásítì ìlú Calabar'),
(4810, 'https://ror.org/05qe0pv23', 'no_lang_code', 1, 'https://ror.org/05qe0pv23 Kashiwa Municipal Hospital 柏市立柏病院'),
(4811, 'https://ror.org/05qfnkv67', 'en', 1, 'https://ror.org/05qfnkv67 St. Vincent''s Medical Center'),
(4812, 'https://ror.org/05qfq7p37', 'en', 1, 'https://ror.org/05qfq7p37 Sint Clara Ziekenhuis St Clara Hospital'),
(4813, 'https://ror.org/05qj9p026', 'en', 1, 'https://ror.org/05qj9p026 Lu''an First People''s Hospital'),
(4814, 'https://ror.org/05qk3dq04', 'en', 1, 'https://ror.org/05qk3dq04 Malta Council for Science and Technology'),
(4815, 'https://ror.org/05qkf9y72', 'en', 1, 'https://ror.org/05qkf9y72 Government General Hospital'),
(4816, 'https://ror.org/05qkm6m65', 'no_lang_code', 1, 'https://ror.org/05qkm6m65 Engi-Mat (United States)'),
(4817, 'https://ror.org/05qkp7h42', 'en', 1, 'https://ror.org/05qkp7h42 Five Branches University'),
(4818, 'https://ror.org/05qmezx22', 'no_lang_code', 1, 'https://ror.org/05qmezx22 Guelph Chemical Labs'),
(4819, 'https://ror.org/05qmk4a18', 'en', 1, 'https://ror.org/05qmk4a18 Bangalore Medical College and Research Institute ಬೆಂಗಳೂರು ವೈದ್ಯಕೀಯ ವಿದ್ಯಾಲಯ'),
(4820, 'https://ror.org/05qtccm96', 'ga', 1, 'https://ror.org/05qtccm96 Forbairt'),
(4821, 'https://ror.org/05qv7gx64', 'en', 1, 'https://ror.org/05qv7gx64 Western Hospital'),
(4822, 'https://ror.org/05qx0rg92', 'no_lang_code', 1, 'https://ror.org/05qx0rg92 HealthMark Multimedia'),
(4823, 'https://ror.org/05qye4525', 'en', 1, 'https://ror.org/05qye4525 Mercy Hospital'),
(4824, 'https://ror.org/05qz2jt34', 'de', 1, 'https://ror.org/05qz2jt34 Bundeswehrkrankenhaus'),
(4825, 'https://ror.org/05r3hm325', 'it', 1, 'https://ror.org/05r3hm325 Azienda Ospedaliera Carlo Poma'),
(4826, 'https://ror.org/05r409z22', 'en', 1, 'https://ror.org/05r409z22 Northern General Hospital'),
(4827, 'https://ror.org/05r5k8873', 'en', 1, 'https://ror.org/05r5k8873'),
(4828, 'https://ror.org/05r6ndz30', 'en', 1, 'https://ror.org/05r6ndz30 Physicians for a National Health Program'),
(4829, 'https://ror.org/05r9v1368', 'en', 1, 'https://ror.org/05r9v1368 Tianjin Chest Hospital 天津市胸科医院'),
(4830, 'https://ror.org/05raceh98', 'no_lang_code', 1, 'https://ror.org/05raceh98 Shirasagi Hospital 白鷺病院'),
(4831, 'https://ror.org/05rad4t93', 'en', 1, 'https://ror.org/05rad4t93 Gordon Research Conferences'),
(4832, 'https://ror.org/05rbwvc13', 'en', 1, 'https://ror.org/05rbwvc13 Queen Elizabeth Hospital'),
(4833, 'https://ror.org/05re2b915', 'en', 1, 'https://ror.org/05re2b915 European Road Transport Telematics Implementation Co-Ordination'),
(4834, 'https://ror.org/05rejmm18', 'no_lang_code', 1, 'https://ror.org/05rejmm18 DELL (United States)'),
(4835, 'https://ror.org/05rfek682', 'en', 1, 'https://ror.org/05rfek682 Kaiser Permanente Oakland Medical Center'),
(4836, 'https://ror.org/05rfh1r09', 'en', 1, 'https://ror.org/05rfh1r09 Aquatic Animal Health Research Laboratory'),
(4837, 'https://ror.org/05rkz5e28', 'no_lang_code', 1, 'https://ror.org/05rkz5e28 Toranomon Hospital 虎の門病院'),
(4838, 'https://ror.org/05rm13h81', 'ms', 1, 'https://ror.org/05rm13h81 Hospital Tengku Ampuan Afzan'),
(4839, 'https://ror.org/05rmxkq05', 'en', 1, 'https://ror.org/05rmxkq05 Dominican Hospital'),
(4840, 'https://ror.org/05rq9gz82', 'en', 1, 'https://ror.org/05rq9gz82 303 Hospital of People''s Liberation Army 中国人民解放军303医院'),
(4841, 'https://ror.org/05rsbck92', 'no_lang_code', 1, 'https://ror.org/05rsbck92 Kitano Hospital 北野病院'),
(4842, 'https://ror.org/05rsf2c37', 'it', 1, 'https://ror.org/05rsf2c37 Ospedali Riuniti Umberto I'),
(4843, 'https://ror.org/05rtvan68', 'en', 1, 'https://ror.org/05rtvan68 Royal University of Phnom Penh សាកលវិទ្យាល័យភូមិន្ទភ្នំពេញ'),
(4844, 'https://ror.org/05rvey468', 'en', 1, 'https://ror.org/05rvey468 Oglethorpe University'),
(4845, 'https://ror.org/05rw9t746', 'en', 1, 'https://ror.org/05rw9t746 IBM Research - Haifa'),
(4846, 'https://ror.org/05ry42w04', 'en', 1, 'https://ror.org/05ry42w04 MedStar Washington Hospital Center'),
(4847, 'https://ror.org/05ryv0s68', 'en', 1, 'https://ror.org/05ryv0s68 Euresearch Association'),
(4848, 'https://ror.org/05rz49z56', 'en', 1, 'https://ror.org/05rz49z56 Smt. N.H.L. Municipal Medical College શ્રીમતી. એનએચએલ મ્યુનિસિપલ મેડિકલ કોલેજ'),
(4849, 'https://ror.org/05rzmnp25', 'en', 1, 'https://ror.org/05rzmnp25 University of the Ryukyus University Hospital 琉球大学医学部附属病院'),
(4850, 'https://ror.org/05s0ee237', 'en', 1, 'https://ror.org/05s0ee237 Morton Plant Hospital'),
(4851, 'https://ror.org/05s3h8004', 'es', 1, 'https://ror.org/05s3h8004 Hospital Universitario Severo Ochoa'),
(4852, 'https://ror.org/05s74hd65', 'en', 1, 'https://ror.org/05s74hd65 Oakwood University'),
(4853, 'https://ror.org/05s7s9x02', 'no_lang_code', 1, 'https://ror.org/05s7s9x02 Lucideon (United Kingdom)'),
(4854, 'https://ror.org/05s9f4d27', 'en', 1, 'https://ror.org/05s9f4d27 University of Wisconsin–Parkside Université du Wisconsin–Parkside'),
(4855, 'https://ror.org/05sb0dh40', 'en', 1, 'https://ror.org/05sb0dh40 Aishin Memorial Hospital 愛心メモリアル病院'),
(4856, 'https://ror.org/05sc3m345', 'en', 1, 'https://ror.org/05sc3m345 Hungarian Institute of Occupational Health Országos Munkahigiénés és Foglalkozásegészségügyi Intézet'),
(4857, 'https://ror.org/05sep9w93', 'es', 1, 'https://ror.org/05sep9w93 Instituto Tecnológico de Aragón'),
(4858, 'https://ror.org/05sgcwh30', 'fr', 1, 'https://ror.org/05sgcwh30 Ministère des Transports'),
(4859, 'https://ror.org/05sgxk616', 'en', 1, 'https://ror.org/05sgxk616 Doctors Medical Center'),
(4860, 'https://ror.org/05shfp710', 'en', 1, 'https://ror.org/05shfp710 Evangel University'),
(4861, 'https://ror.org/05sj7yp62', 'en', 1, 'https://ror.org/05sj7yp62 Universidad de Carabobo University of Carabobo'),
(4862, 'https://ror.org/05sk0a617', 'en', 1, 'https://ror.org/05sk0a617 Association of Schools of Allied Health Professions'),
(4863, 'https://ror.org/05skj8r52', 'en', 1, 'https://ror.org/05skj8r52 Rutland Regional Medical Center'),
(4864, 'https://ror.org/05sn8t512', 'en', 1, 'https://ror.org/05sn8t512 Hospital Authority 醫院管理局'),
(4865, 'https://ror.org/05sqd3t97', 'en', 1, 'https://ror.org/05sqd3t97 Sistema universitario estatal de Florida State University System of Florida'),
(4866, 'https://ror.org/05srfkv34', 'en', 1, 'https://ror.org/05srfkv34 Chelyabinsk State Medical Academy Южно-Уральский государственный медицинский университет'),
(4867, 'https://ror.org/05sv6pg41', 'en', 1, 'https://ror.org/05sv6pg41 University of Wisconsin–Stevens Point Université du Wisconsin–Stevens Point'),
(4868, 'https://ror.org/05sy5w128', 'en', 1, 'https://ror.org/05sy5w128 Kumamoto Medical Center 熊本医療センター'),
(4869, 'https://ror.org/05t3n1398', 'en', 1, 'https://ror.org/05t3n1398 Natural Resources Institute'),
(4870, 'https://ror.org/05t4ef339', 'en', 1, 'https://ror.org/05t4ef339 Northern Arizona VA Health Care System'),
(4871, 'https://ror.org/05t4vgv93', 'no_lang_code', 1, 'https://ror.org/05t4vgv93 Rotunda Hospital'),
(4872, 'https://ror.org/05t626n88', 'en', 1, 'https://ror.org/05t626n88 Suwa Red Cross Hospital 諏訪赤十字病院'),
(4873, 'https://ror.org/05t65ke24', 'en', 1, 'https://ror.org/05t65ke24 Sophiahemmet Hospital Sophiahemmet Sjukhus'),
(4874, 'https://ror.org/05t6gpm70', 'en', 1, 'https://ror.org/05t6gpm70 University of California Davis Medical Center'),
(4875, 'https://ror.org/05t70xh16', 'en', 1, 'https://ror.org/05t70xh16 Kyoto Sangyo University 京都産業大学'),
(4876, 'https://ror.org/05t7jxa31', 'en', 1, 'https://ror.org/05t7jxa31 Institute for Cancer Prevention'),
(4877, 'https://ror.org/05t8kxz54', 'en', 1, 'https://ror.org/05t8kxz54 Saddleback Memorial Medical Center'),
(4878, 'https://ror.org/05t9mkx39', 'en', 1, 'https://ror.org/05t9mkx39 Touro University Nevada Université touro du nevada'),
(4879, 'https://ror.org/05tby3y60', 'en', 1, 'https://ror.org/05tby3y60 Judge Baker Children''s Center'),
(4880, 'https://ror.org/05tc07s46', 'en', 1, 'https://ror.org/05tc07s46 Matsuyama University 松山大学'),
(4881, 'https://ror.org/05tdbce05', 'en', 1, 'https://ror.org/05tdbce05 Biological Sciences Curriculum Study'),
(4882, 'https://ror.org/05te51w08', 'es', 1, 'https://ror.org/05te51w08 Hospital General de Niños Ricardo Gutierrez'),
(4883, 'https://ror.org/05tkvpg69', 'es', 1, 'https://ror.org/05tkvpg69 Centro Agronomico Tropical de Investigacion y Ensenanza Catie'),
(4884, 'https://ror.org/05tmv0d13', 'en', 1, 'https://ror.org/05tmv0d13 American Society of Civil Engineers'),
(4885, 'https://ror.org/05tqne909', 'no_lang_code', 1, 'https://ror.org/05tqne909 (주)인실리코젠 Insilicogen (South Korea)'),
(4886, 'https://ror.org/05ts0bd12', 'en', 1, 'https://ror.org/05ts0bd12 VA Northern California Health Care System'),
(4887, 'https://ror.org/05tta9908', 'de', 1, 'https://ror.org/05tta9908 Children''s Hospital in Eastern Switzerland Ostschweizer Kinderspital'),
(4888, 'https://ror.org/05txhk819', 'es', 1, 'https://ror.org/05txhk819 Hospital General de Agudos Dr. TEODORO ALVAREZ'),
(4889, 'https://ror.org/05txkk980', 'es', 1, 'https://ror.org/05txkk980 Hospital Universitario Infanta Cristina'),
(4890, 'https://ror.org/05txvbe22', 'en', 1, 'https://ror.org/05txvbe22 Federal Teaching Hospital Abakaliki'),
(4891, 'https://ror.org/05tzr3y75', 'en', 1, 'https://ror.org/05tzr3y75 Kassala University جامعة كسلا'),
(4892, 'https://ror.org/05v1y0t93', 'en', 1, 'https://ror.org/05v1y0t93 China Jiliang University'),
(4893, 'https://ror.org/05v4bdf81', 'en', 1, 'https://ror.org/05v4bdf81 Southampton Hospital'),
(4894, 'https://ror.org/05v4j1v63', 'no_lang_code', 1, 'https://ror.org/05v4j1v63 Takanoko Hospital'),
(4895, 'https://ror.org/05v4pjq26', 'en', 1, 'https://ror.org/05v4pjq26 Mahatma Gandhi Medical College and Research Institute'),
(4896, 'https://ror.org/05v4pwe63', 'en', 1, 'https://ror.org/05v4pwe63 Canniesburn Hospital'),
(4897, 'https://ror.org/05v558c44', 'it', 1, 'https://ror.org/05v558c44 Azienda Ospedaliera Fatebenefratelli e Oftalmico'),
(4898, 'https://ror.org/05v55dh34', 'en', 1, 'https://ror.org/05v55dh34 Memorial Hospital'),
(4899, 'https://ror.org/05v58y004', 'en', 1, 'https://ror.org/05v58y004 Shaoxing People''s Hospital 绍兴市人民医院'),
(4900, 'https://ror.org/05v5wwy67', 'en', 1, 'https://ror.org/05v5wwy67 Hippocration General Hospital Γενικό Νοσοκομείο Αθηνών Ιπποκράτειο'),
(4901, 'https://ror.org/05v6jj657', 'en', 1, 'https://ror.org/05v6jj657 Office of Chief Medical Examiner'),
(4902, 'https://ror.org/05v6r7450', 'en', 1, 'https://ror.org/05v6r7450 Shanghai Skin Disease Hospital 上海皮肤病医院长宁区门诊部'),
(4903, 'https://ror.org/05v7axt97', 'no_lang_code', 1, 'https://ror.org/05v7axt97 Resodyn Corporation (United States)'),
(4904, 'https://ror.org/05v7bbe50', 'tr', 1, 'https://ror.org/05v7bbe50 Fatih Sultan Mehmet Eğitim Ve Araştırma Hastanesi'),
(4905, 'https://ror.org/05v7jp327', 'en', 1, 'https://ror.org/05v7jp327 Atlanta Medical Center'),
(4906, 'https://ror.org/05v7v1303', 'no_lang_code', 1, 'https://ror.org/05v7v1303 IRIS Educational Media'),
(4907, 'https://ror.org/05v823t63', 'en', 1, 'https://ror.org/05v823t63 South Essex Partnership University Foundation NHS Trust'),
(4908, 'https://ror.org/05va5gy74', 'en', 1, 'https://ror.org/05va5gy74 Royal National Hospital for Rheumatic Diseases'),
(4909, 'https://ror.org/05vc4qy60', 'nl', 1, 'https://ror.org/05vc4qy60 Rijnland Ziekenhuis'),
(4910, 'https://ror.org/05vchgv90', 'no_lang_code', 1, 'https://ror.org/05vchgv90 Kouseiren Takaoka Hospital 厚生連高岡病院'),
(4911, 'https://ror.org/05vczwc13', 'en', 1, 'https://ror.org/05vczwc13 Deaconess Hospital'),
(4912, 'https://ror.org/05vf56z40', 'en', 1, 'https://ror.org/05vf56z40 University of Tehran دانشگاه تهران'),
(4913, 'https://ror.org/05vgmh969', 'pl', 1, 'https://ror.org/05vgmh969 Szpital Uniwersytecki w Krakowie'),
(4914, 'https://ror.org/05vhczg54', 'en', 1, 'https://ror.org/05vhczg54 Feng Chia University'),
(4915, 'https://ror.org/05vn3ca78', 'en', 1, 'https://ror.org/05vn3ca78 National Chung Hsing University'),
(4916, 'https://ror.org/05vp5x049', 'en', 1, 'https://ror.org/05vp5x049 Children''s Hospital of Richmond at VCU'),
(4917, 'https://ror.org/05vtzqy31', 'en', 1, 'https://ror.org/05vtzqy31 Deaconess Hospital'),
(4918, 'https://ror.org/05vvzn852', 'en', 1, 'https://ror.org/05vvzn852 University of Kentucky HealthCare'),
(4919, 'https://ror.org/05vxnmp88', 'en', 1, 'https://ror.org/05vxnmp88 Cheil General Hospital and Women''s Healthcare Center'),
(4920, 'https://ror.org/05vy1kj95', 'en', 1, 'https://ror.org/05vy1kj95 American Mathematical Society Sociedad Estadounidense de Matemática'),
(4921, 'https://ror.org/05vy2sc54', 'en', 1, 'https://ror.org/05vy2sc54 First Affiliated Hospital of Harbin Medical University'),
(4922, 'https://ror.org/05vz28418', 'en', 1, 'https://ror.org/05vz28418 Southern Illinois University System Université de l''illinois du sud'),
(4923, 'https://ror.org/05vzbfc95', 'en', 1, 'https://ror.org/05vzbfc95 Yeditepe University Hospital Yeditepe Üniversitesi Hastanesi'),
(4924, 'https://ror.org/05vzqzh92', 'en', 1, 'https://ror.org/05vzqzh92 University of Minnesota Morris Université du minnesota à morris'),
(4925, 'https://ror.org/05w0p9h92', 'en', 1, 'https://ror.org/05w0p9h92 Shenandoah University'),
(4926, 'https://ror.org/05w1yqq10', 'en', 1, 'https://ror.org/05w1yqq10 Israel Defense Forces Medical Corps'),
(4927, 'https://ror.org/05w3e4z48', 'en', 1, 'https://ror.org/05w3e4z48 New Cross Hospital'),
(4928, 'https://ror.org/05w6fx554', 'ro', 1, 'https://ror.org/05w6fx554 Institutul Clinic Fundeni'),
(4929, 'https://ror.org/05w6g2m14', 'en', 1, 'https://ror.org/05w6g2m14 Government Medical College'),
(4930, 'https://ror.org/05w90nk74', 'en', 1, 'https://ror.org/05w90nk74 Stollery Children''s Hospital'),
(4931, 'https://ror.org/05wbx0564', 'en', 1, 'https://ror.org/05wbx0564 Chonburi Hospital โรงพยาบาลชลบุรี'),
(4932, 'https://ror.org/05wc95s05', 'en', 1, 'https://ror.org/05wc95s05 Khoo Teck Puat Hospital'),
(4933, 'https://ror.org/05wcbg446', 'en', 1, 'https://ror.org/05wcbg446 Sveučilišna klinička bolnica Mostar University Clinical Hospital Mostar'),
(4934, 'https://ror.org/05wd11c32', 'en', 1, 'https://ror.org/05wd11c32 Research Corporation of The University of Hawaii'),
(4935, 'https://ror.org/05wd86d64', 'it', 1, 'https://ror.org/05wd86d64 Ospedale San Bortolo'),
(4936, 'https://ror.org/05weahn72', 'en', 1, 'https://ror.org/05weahn72 Sri Venkateswara University جامعہ سری وینکٹیشورا श्री वेंकटेश्वर विश्वविद्यालय சிறீ வெங்கடேசுவரா பல்கலைக்கழகம் శ్రీ వేంకటేశ్వర విశ్వవిద్యాలయం'),
(4937, 'https://ror.org/05wf8v135', 'en', 1, 'https://ror.org/05wf8v135 Bronglais General Hospital'),
(4938, 'https://ror.org/05wfna922', 'tr', 1, 'https://ror.org/05wfna922 American Hospital Amerikan Hastanesi'),
(4939, 'https://ror.org/05wjv2104', 'en', 1, 'https://ror.org/05wjv2104 University Hospital Innsbruck'),
(4940, 'https://ror.org/05wnp6x23', 'en', 1, 'https://ror.org/05wnp6x23 Goa Dental College and Hospital'),
(4941, 'https://ror.org/05wqbqy84', 'en', 1, 'https://ror.org/05wqbqy84 Aminu Kano Teaching Hospital'),
(4942, 'https://ror.org/05wqhv079', 'en', 1, 'https://ror.org/05wqhv079 Mater Adult Hospital'),
(4943, 'https://ror.org/05wr49d48', 'en', 1, 'https://ror.org/05wr49d48 Wakayama University 和歌山大学'),
(4944, 'https://ror.org/05wrpbp17', 'en', 1, 'https://ror.org/05wrpbp17 Andalusian School of Public Health Escuela Andaluza de Salud Pública'),
(4945, 'https://ror.org/05wstbs93', 'en', 1, 'https://ror.org/05wstbs93 Obihiro National Hospital 国立病院機構帯広病院'),
(4946, 'https://ror.org/05wtx0016', 'no_lang_code', 1, 'https://ror.org/05wtx0016 Canon (Canada)'),
(4947, 'https://ror.org/05wvk1430', 'en', 1, 'https://ror.org/05wvk1430 Municipal Hirakata City Hospital 市立枚方市民病院'),
(4948, 'https://ror.org/05wyncb52', 'en', 1, 'https://ror.org/05wyncb52 Kings Mill Hospital'),
(4949, 'https://ror.org/05wyq9e07', 'en', 1, 'https://ror.org/05wyq9e07 Stony Brook University Hospital'),
(4950, 'https://ror.org/05x0h7m97', 'en', 1, 'https://ror.org/05x0h7m97 Ratchaburi Hospital โรงพยาบาลราชบุรี'),
(4951, 'https://ror.org/05x0kmy47', 'no_lang_code', 1, 'https://ror.org/05x0kmy47 Shaanxi Yulin Energy Group'),
(4952, 'https://ror.org/05x14am29', 'en', 1, 'https://ror.org/05x14am29 Escola Superior Gallaecia Gallaecia Higher School'),
(4953, 'https://ror.org/05x2sza30', 'en', 1, 'https://ror.org/05x2sza30 Higashi Nagoya National Hospital 国立病院機構東名古屋病院'),
(4954, 'https://ror.org/05x3tad86', 'no_lang_code', 1, 'https://ror.org/05x3tad86 Inotek Pharmaceuticals (United States)'),
(4955, 'https://ror.org/05x3tq720', 'en', 1, 'https://ror.org/05x3tq720 Mennonite Christian Hospital 門諾醫院'),
(4956, 'https://ror.org/05x57ne79', 'en', 1, 'https://ror.org/05x57ne79 Calderdale Royal Hospital'),
(4957, 'https://ror.org/05x5g2972', 'en', 1, 'https://ror.org/05x5g2972 Crittenton Hospital Medical Center'),
(4958, 'https://ror.org/05x6qnc69', 'en', 1, 'https://ror.org/05x6qnc69 Lebanese University Université Libanaise الجامعة اللبنانية'),
(4959, 'https://ror.org/05x8jna23', 'fr', 1, 'https://ror.org/05x8jna23 Hôpital de La Grave'),
(4960, 'https://ror.org/05x8xdg58', 'en', 1, 'https://ror.org/05x8xdg58 St. Mary''s Hospital'),
(4961, 'https://ror.org/05xanxb38', 'en', 1, 'https://ror.org/05xanxb38 Govt. Dental College & Hospital'),
(4962, 'https://ror.org/05xc56p63', 'en', 1, 'https://ror.org/05xc56p63 Royal Alexandra Children''s Hospital'),
(4963, 'https://ror.org/05xcx0k58', 'en', 1, 'https://ror.org/05xcx0k58 Aga Khan University Hospital'),
(4964, 'https://ror.org/05xcyt367', 'en', 1, 'https://ror.org/05xcyt367 Loyola University Medical Center'),
(4965, 'https://ror.org/05xdd0k85', 'en', 1, 'https://ror.org/05xdd0k85 Cheltenham General Hospital'),
(4966, 'https://ror.org/05xdxc763', 'en', 1, 'https://ror.org/05xdxc763 Advocate Children''s Hospital'),
(4967, 'https://ror.org/05xeczx11', 'no_lang_code', 1, 'https://ror.org/05xeczx11 Curtiss-Wright (Canada)'),
(4968, 'https://ror.org/05xf34x41', 'en', 1, 'https://ror.org/05xf34x41 South Carolina State Department of Mental Health'),
(4969, 'https://ror.org/05xh7ac43', 'en', 1, 'https://ror.org/05xh7ac43 Kettering General Hospital NHS Trust'),
(4970, 'https://ror.org/05xh86w23', 'en', 1, 'https://ror.org/05xh86w23 Gastroenterology Medical Center and Hospital'),
(4971, 'https://ror.org/05xhkqs13', 'en', 1, 'https://ror.org/05xhkqs13 North Bengal Medical College and Hospital নর্থবেঙ্গল মেডিক্যাল কলেজ'),
(4972, 'https://ror.org/05xhpce34', 'en', 1, 'https://ror.org/05xhpce34 St Göran''s Children''s Hospital'),
(4973, 'https://ror.org/05xjxp170', 'en', 1, 'https://ror.org/05xjxp170 Lovelace Health System'),
(4974, 'https://ror.org/05xmvmv34', 'es', 1, 'https://ror.org/05xmvmv34 Centro Sociosanitario Nuestra Señora del Pino'),
(4975, 'https://ror.org/05xn9jy83', 'en', 1, 'https://ror.org/05xn9jy83 University of Arkansas at Monticello'),
(4976, 'https://ror.org/05xnecb03', 'en', 1, 'https://ror.org/05xnecb03 St. Mary''s Health Center'),
(4977, 'https://ror.org/05xrsn753', 'en', 1, 'https://ror.org/05xrsn753 Choithram Hospital and Research Centre'),
(4978, 'https://ror.org/05xswp225', 'en', 1, 'https://ror.org/05xswp225 Khulna Medical College খুলনা মেডিকেল কলেজ'),
(4979, 'https://ror.org/05xszy717', 'en', 1, 'https://ror.org/05xszy717 National Defense Academy of Japan 防衛大学校'),
(4980, 'https://ror.org/05xtj6g89', 'en', 1, 'https://ror.org/05xtj6g89 Baptist Memorial Hospital'),
(4981, 'https://ror.org/05xtmzc93', 'en', 1, 'https://ror.org/05xtmzc93 Baptist Medical Center Beaches'),
(4982, 'https://ror.org/05xv0p989', 'tr', 1, 'https://ror.org/05xv0p989 Ege Üniversitesi Tıp Fakültesi Hastanesi'),
(4983, 'https://ror.org/05xwc2w62', 'pt', 1, 'https://ror.org/05xwc2w62 Escola Superior de Educação de Almeida Garrett'),
(4984, 'https://ror.org/05xxmnm27', 'en', 1, 'https://ror.org/05xxmnm27 Altnagelvin Area Hospital'),
(4985, 'https://ror.org/05xysjr32', 'en', 1, 'https://ror.org/05xysjr32 Kessler Institute for Rehabilitation'),
(4986, 'https://ror.org/05y06tg49', 'en', 1, 'https://ror.org/05y06tg49 October 6 University جامعة السادس من أكتوبر'),
(4987, 'https://ror.org/05y26ar20', 'pt', 1, 'https://ror.org/05y26ar20 Universidade Regional do Cariri'),
(4988, 'https://ror.org/05y33vv83', 'es', 1, 'https://ror.org/05y33vv83 Universidad del Desarrollo'),
(4989, 'https://ror.org/05y50nr98', 'en', 1, 'https://ror.org/05y50nr98 Suffolk University Universidad de Suffolk'),
(4990, 'https://ror.org/05y5qmm69', 'en', 1, 'https://ror.org/05y5qmm69 Heritage University'),
(4991, 'https://ror.org/05y7e6905', 'no_lang_code', 1, 'https://ror.org/05y7e6905 Sahmyook Medical Center 삼육의료원서울병원'),
(4992, 'https://ror.org/05y8s3144', 'no_lang_code', 1, 'https://ror.org/05y8s3144 TPL (United States)'),
(4993, 'https://ror.org/05y999856', 'pt', 1, 'https://ror.org/05y999856 Hospital Mãe de Deus'),
(4994, 'https://ror.org/05ybvz010', 'en', 1, 'https://ror.org/05ybvz010 Mater Dei Hospital'),
(4995, 'https://ror.org/05ydecq02', 'en', 1, 'https://ror.org/05ydecq02 Urho Kaleva Kekkonen Institute'),
(4996, 'https://ror.org/05yevkn97', 'en', 1, 'https://ror.org/05yevkn97 Sendai Kousei Hospital 仙台厚生病院'),
(4997, 'https://ror.org/05yjz6y13', 'en', 1, 'https://ror.org/05yjz6y13 University Medical Center Rizk Hospital'),
(4998, 'https://ror.org/05yjze111', 'en', 1, 'https://ror.org/05yjze111 Unity Hospital'),
(4999, 'https://ror.org/05ym42410', 'en', 1, 'https://ror.org/05ym42410 Gansu Agricultural University 甘肃农业大学'),
(5000, 'https://ror.org/05ymyxj51', 'en', 1, 'https://ror.org/05ymyxj51 Royal Columbian Hospital'),
(5001, 'https://ror.org/0002vhf72', 'no_lang_code', 1, 'https://ror.org/0002vhf72 Galenea (United States)'),
(5002, 'https://ror.org/0003zy991', 'en', 1, 'https://ror.org/0003zy991 York Hospital'),
(5003, 'https://ror.org/0004bx792', 'no_lang_code', 1, 'https://ror.org/0004bx792 SignalChem (Canada)'),
(5004, 'https://ror.org/0004ysa08', 'en', 1, 'https://ror.org/0004ysa08 Centre for innovative process engineering'),
(5005, 'https://ror.org/0006jev58', 'no_lang_code', 1, 'https://ror.org/0006jev58 Alpha Technologies (Canada)'),
(5006, 'https://ror.org/0006n3612', 'en', 1, 'https://ror.org/0006n3612 Oak Crest Institute of Science'),
(5007, 'https://ror.org/0007tes83', 'no_lang_code', 1, 'https://ror.org/0007tes83 Tominaga hospital 富永病院'),
(5008, 'https://ror.org/0008kdt06', 'en', 1, 'https://ror.org/0008kdt06 Hearthstone Alzheimer Care'),
(5009, 'https://ror.org/00096h502', 'en', 1, 'https://ror.org/00096h502 Native American Cancer Research'),
(5010, 'https://ror.org/000a1cz07', 'no_lang_code', 1, 'https://ror.org/000a1cz07 Fianium (United Kingdom)'),
(5011, 'https://ror.org/000apqb71', 'en', 1, 'https://ror.org/000apqb71 Philadelphia Fire Department'),
(5012, 'https://ror.org/000cxfw53', 'no_lang_code', 1, 'https://ror.org/000cxfw53 Aradigm (United States)'),
(5013, 'https://ror.org/000czbn37', 'no_lang_code', 1, 'https://ror.org/000czbn37 iProgen Biotech (Canada)'),
(5014, 'https://ror.org/000dhg681', 'no_lang_code', 1, 'https://ror.org/000dhg681 Stratonics (United States)'),
(5015, 'https://ror.org/000dzg547', 'no_lang_code', 1, 'https://ror.org/000dzg547 Scientific Solutions (United States)'),
(5016, 'https://ror.org/000ep5m48', 'es', 1, 'https://ror.org/000ep5m48 Instituto de Salud Pública de Navarra'),
(5017, 'https://ror.org/000fmbj50', 'en', 1, 'https://ror.org/000fmbj50 California Rural Indian Health Board'),
(5018, 'https://ror.org/000g90y93', 'en', 1, 'https://ror.org/000g90y93 Fresno Unified School District'),
(5019, 'https://ror.org/000jqak13', 'no_lang_code', 1, 'https://ror.org/000jqak13 ECBio (Portugal)'),
(5020, 'https://ror.org/000qjjz95', 'en', 1, 'https://ror.org/000qjjz95 Park Centre for Mental Health'),
(5021, 'https://ror.org/000smmv87', 'no_lang_code', 1, 'https://ror.org/000smmv87 Morinaga Institute of Biological Science'),
(5022, 'https://ror.org/000vy8681', 'en', 1, 'https://ror.org/000vy8681 National Institute of Agricultural Science and Technology'),
(5023, 'https://ror.org/000x99506', 'no_lang_code', 1, 'https://ror.org/000x99506 Biodynamic Research Corporation (United States)'),
(5024, 'https://ror.org/000z4wj31', 'en', 1, 'https://ror.org/000z4wj31 Center for Naval Analyses'),
(5025, 'https://ror.org/000zk0m89', 'no_lang_code', 1, 'https://ror.org/000zk0m89 Nanoco Technologies (United Kingdom)'),
(5026, 'https://ror.org/000znb612', 'no_lang_code', 1, 'https://ror.org/000znb612 Banca Rìoghail na h-Alba Royal Bank of Scotland (United Kingdom)'),
(5027, 'https://ror.org/001040h60', 'en', 1, 'https://ror.org/001040h60 American Indian Center'),
(5028, 'https://ror.org/00109m582', 'en', 1, 'https://ror.org/00109m582 Community Connections'),
(5029, 'https://ror.org/0010c1z81', 'de', 1, 'https://ror.org/0010c1z81 Deutsche Klinik für Diagnostik'),
(5030, 'https://ror.org/0010ry587', 'no_lang_code', 1, 'https://ror.org/0010ry587 Ultra Electronics (Canada)'),
(5031, 'https://ror.org/0011v4420', 'en', 1, 'https://ror.org/0011v4420 Zübeyde Hanim Maternity Hospital'),
(5032, 'https://ror.org/0012w1115', 'no_lang_code', 1, 'https://ror.org/0012w1115 EcoMetrix'),
(5033, 'https://ror.org/0014wkh93', 'no_lang_code', 1, 'https://ror.org/0014wkh93 Tucker-Davis Technologies (United States)'),
(5034, 'https://ror.org/0015wff52', 'no_lang_code', 1, 'https://ror.org/0015wff52 Implant Sciences (United States)'),
(5035, 'https://ror.org/0015zns27', 'no_lang_code', 1, 'https://ror.org/0015zns27 KCTS 9 (United States)'),
(5036, 'https://ror.org/0016w2w54', 'en', 1, 'https://ror.org/0016w2w54 Des Moines Area Community College'),
(5037, 'https://ror.org/0016z8240', 'no_lang_code', 1, 'https://ror.org/0016z8240 Liminal BioSciences (Canada)'),
(5038, 'https://ror.org/00174r125', 'en', 1, 'https://ror.org/00174r125 Foundation for Blood Research'),
(5039, 'https://ror.org/001b7ye13', 'en', 1, 'https://ror.org/001b7ye13 Building Services Research and Information Association'),
(5040, 'https://ror.org/001cbt815', 'en', 1, 'https://ror.org/001cbt815 Mt. Hood Community College'),
(5041, 'https://ror.org/001dsq926', 'no_lang_code', 1, 'https://ror.org/001dsq926 DeltaMetrics (United States)'),
(5042, 'https://ror.org/001dw2225', 'en', 1, 'https://ror.org/001dw2225 Central Aerohydrodynamic Institute Центральный аэрогидродинамический институт имени профессора Н.Е. Жуковского'),
(5043, 'https://ror.org/001fvka94', 'no_lang_code', 1, 'https://ror.org/001fvka94 Wilson Wolf Manufacturing (United States)'),
(5044, 'https://ror.org/001g7ce71', 'no_lang_code', 1, 'https://ror.org/001g7ce71 Biomass Technology Group (Netherlands)'),
(5045, 'https://ror.org/001kbwb95', 'no_lang_code', 1, 'https://ror.org/001kbwb95 Decision Demographics (United States)'),
(5046, 'https://ror.org/001kp4y75', 'no_lang_code', 1, 'https://ror.org/001kp4y75 Avanzare (Spain)'),
(5047, 'https://ror.org/001m3hq40', 'en', 1, 'https://ror.org/001m3hq40 Communication Matters'),
(5048, 'https://ror.org/001m7ja14', 'no_lang_code', 1, 'https://ror.org/001m7ja14 FIT Consulting (Italy)'),
(5049, 'https://ror.org/001q3y090', 'no_lang_code', 1, 'https://ror.org/001q3y090 Creativa (Italy) Creativa Impresa di Comunicazione srl'),
(5050, 'https://ror.org/001s05659', 'en', 1, 'https://ror.org/001s05659 Blood Transfusion Centre of Slovenia'),
(5051, 'https://ror.org/001s4dh65', 'no_lang_code', 1, 'https://ror.org/001s4dh65 Cambridge Scientific (United States)'),
(5052, 'https://ror.org/001tmkc70', 'no_lang_code', 1, 'https://ror.org/001tmkc70 Ivoclar Vivadent (Liechtenstein)'),
(5053, 'https://ror.org/001yedb91', 'no_lang_code', 1, 'https://ror.org/001yedb91 Actelion (Switzerland)'),
(5054, 'https://ror.org/001ykb961', 'en', 1, 'https://ror.org/001ykb961 National Evolutionary Synthesis Center'),
(5055, 'https://ror.org/00226bs07', 'no_lang_code', 1, 'https://ror.org/00226bs07 Scarab Genomics (United States)'),
(5056, 'https://ror.org/002298757', 'no_lang_code', 1, 'https://ror.org/002298757 Allozyne (United States)'),
(5057, 'https://ror.org/0023asr12', 'en', 1, 'https://ror.org/0023asr12 Singapore Science Park Taman Sains Singapura 新加坡科学园'),
(5058, 'https://ror.org/0024cws33', 'en', 1, 'https://ror.org/0024cws33 Food Research Institute'),
(5059, 'https://ror.org/0024cyb77', 'no_lang_code', 1, 'https://ror.org/0024cyb77 Stottler Henke Associates (United States)'),
(5060, 'https://ror.org/002573656', 'no_lang_code', 1, 'https://ror.org/002573656 NeurAxon (Canada)'),
(5061, 'https://ror.org/00273wp13', 'en', 1, 'https://ror.org/00273wp13 Energy Cities'),
(5062, 'https://ror.org/0027jd641', 'no_lang_code', 1, 'https://ror.org/0027jd641 Cell Culture Company (United States)'),
(5063, 'https://ror.org/0028z3k74', 'en', 1, 'https://ror.org/0028z3k74 Orange County Research Center'),
(5064, 'https://ror.org/00298sd14', 'no_lang_code', 1, 'https://ror.org/00298sd14 Battelle Ingenieurtechnik (Germany)'),
(5065, 'https://ror.org/002bnpr17', 'pt', 1, 'https://ror.org/002bnpr17 Fundação de Medicina Tropical'),
(5066, 'https://ror.org/002cajb45', 'no_lang_code', 1, 'https://ror.org/002cajb45 Carterra (United States)'),
(5067, 'https://ror.org/002feag21', 'en', 1, 'https://ror.org/002feag21 Bostwick Laboratories'),
(5068, 'https://ror.org/002fen565', 'no_lang_code', 1, 'https://ror.org/002fen565 BC Platforms (Finland)'),
(5069, 'https://ror.org/002j9jj25', 'en', 1, 'https://ror.org/002j9jj25 Harrisburg Area Community College'),
(5070, 'https://ror.org/002kdhq94', 'no_lang_code', 1, 'https://ror.org/002kdhq94 Online Technologies (United States)'),
(5071, 'https://ror.org/002m5c441', 'no_lang_code', 1, 'https://ror.org/002m5c441 Xention (United Kingdom)'),
(5072, 'https://ror.org/002mbwb34', 'en', 1, 'https://ror.org/002mbwb34 Passaic County Community College'),
(5073, 'https://ror.org/002nf6q61', 'en', 1, 'https://ror.org/002nf6q61 Bandim Health Project Projecto de Saúde Bandim'),
(5074, 'https://ror.org/002t6g510', 'en', 1, 'https://ror.org/002t6g510 Dick Young Productions'),
(5075, 'https://ror.org/002vjkr06', 'en', 1, 'https://ror.org/002vjkr06 Pima Prevention Partnership'),
(5076, 'https://ror.org/002xn3f27', 'no_lang_code', 1, 'https://ror.org/002xn3f27 SciberQuest (United States)'),
(5077, 'https://ror.org/002yzpx87', 'no_lang_code', 1, 'https://ror.org/002yzpx87 BASF (United States)'),
(5078, 'https://ror.org/0033n4009', 'no_lang_code', 1, 'https://ror.org/0033n4009 ABB (Sweden)'),
(5079, 'https://ror.org/0034k3d56', 'en', 1, 'https://ror.org/0034k3d56 Department of Community and Human Services'),
(5080, 'https://ror.org/003518063', 'no_lang_code', 1, 'https://ror.org/003518063 ComputIT (Norway)'),
(5081, 'https://ror.org/0037fa039', 'no_lang_code', 1, 'https://ror.org/0037fa039 Avantune (Italy)'),
(5082, 'https://ror.org/0038zh709', 'it', 1, 'https://ror.org/0038zh709 Consorzio per Valutazioni Biologiche e Farmacologiche'),
(5083, 'https://ror.org/0039ss191', 'no_lang_code', 1, 'https://ror.org/0039ss191 Altravax (United States)'),
(5084, 'https://ror.org/003c3rr61', 'no_lang_code', 1, 'https://ror.org/003c3rr61 Diehl (Germany)'),
(5085, 'https://ror.org/003ck6433', 'en', 1, 'https://ror.org/003ck6433 National Microelectronics Institute'),
(5086, 'https://ror.org/003dqcp70', 'no_lang_code', 1, 'https://ror.org/003dqcp70 Fujirebio (Belgium)'),
(5087, 'https://ror.org/003fgzm76', 'en', 1, 'https://ror.org/003fgzm76 Mount Carmel College of Nursing'),
(5088, 'https://ror.org/003fzn994', 'no_lang_code', 1, 'https://ror.org/003fzn994 TMO Renewables (United Kingdom)'),
(5089, 'https://ror.org/003g0xf19', 'en', 1, 'https://ror.org/003g0xf19 VA New Jersey Health Care System'),
(5090, 'https://ror.org/003hr6w03', 'en', 1, 'https://ror.org/003hr6w03 MotherToBaby'),
(5091, 'https://ror.org/003jsdw96', 'en', 1, 'https://ror.org/003jsdw96 Macedonian Academy of Sciences and Arts'),
(5092, 'https://ror.org/003jtsa97', 'en', 1, 'https://ror.org/003jtsa97 St. Joseph''s Hospital'),
(5093, 'https://ror.org/003kv9x13', 'en', 1, 'https://ror.org/003kv9x13 Health & Safety Laboratory'),
(5094, 'https://ror.org/003kxr082', 'no_lang_code', 1, 'https://ror.org/003kxr082 British Airways (United Kingdom)'),
(5095, 'https://ror.org/003nnep52', 'pt', 1, 'https://ror.org/003nnep52 Irmandade da Santa Casa de Misericórdia de São Paulo'),
(5096, 'https://ror.org/003pdcw24', 'no_lang_code', 1, 'https://ror.org/003pdcw24 Vestas (Denmark)'),
(5097, 'https://ror.org/003qr7703', 'en', 1, 'https://ror.org/003qr7703 Peijaksen sairaala Peijas Hospital'),
(5098, 'https://ror.org/003tra577', 'en', 1, 'https://ror.org/003tra577 Arizona Office of the Governor'),
(5099, 'https://ror.org/003v2c511', 'no_lang_code', 1, 'https://ror.org/003v2c511 Allgemeine Elektrizitäts Gesellschaft (Germany) General Electricity Company'),
(5100, 'https://ror.org/0042e5975', 'it', 1, 'https://ror.org/0042e5975 Istituto Nanoscienze'),
(5101, 'https://ror.org/0044m1c71', 'no_lang_code', 1, 'https://ror.org/0044m1c71 Conceptivity (Switzerland)'),
(5102, 'https://ror.org/0046pcp30', 'no_lang_code', 1, 'https://ror.org/0046pcp30 Gwent Group (United Kingdom)'),
(5103, 'https://ror.org/00485s352', 'no_lang_code', 1, 'https://ror.org/00485s352 Danaher (United Kingdom)'),
(5104, 'https://ror.org/004a2wv92', 'en', 1, 'https://ror.org/004a2wv92 National Institute of Dental and Craniofacial Research'),
(5105, 'https://ror.org/004aekm03', 'en', 1, 'https://ror.org/004aekm03 South Carolina HIV/AIDS Council'),
(5106, 'https://ror.org/004amc442', 'en', 1, 'https://ror.org/004amc442 Orthopaedic Center'),
(5107, 'https://ror.org/004cah429', 'no_lang_code', 1, 'https://ror.org/004cah429 Toyama Prefectural Central Hospital 富山県立中央病院'),
(5108, 'https://ror.org/004ejmg69', 'no_lang_code', 1, 'https://ror.org/004ejmg69 Aerpio Pharmaceuticals (United States)'),
(5109, 'https://ror.org/004es3518', 'no_lang_code', 1, 'https://ror.org/004es3518 Red Hill Studios'),
(5110, 'https://ror.org/004g7tk16', 'en', 1, 'https://ror.org/004g7tk16 Canadian Fitness and Lifestyle Research Institute'),
(5111, 'https://ror.org/004gw9825', 'en', 1, 'https://ror.org/004gw9825 Southeast Community College'),
(5112, 'https://ror.org/004hxna20', 'en', 1, 'https://ror.org/004hxna20 Overlake Hospital Medical Center'),
(5113, 'https://ror.org/004m2d892', 'no_lang_code', 1, 'https://ror.org/004m2d892 Impact Assessment'),
(5114, 'https://ror.org/004n9sm55', 'en', 1, 'https://ror.org/004n9sm55 New England Center for Children');
INSERT INTO `rors` VALUES
(5115, 'https://ror.org/004np0e76', 'no_lang_code', 1, 'https://ror.org/004np0e76 Dornier (Germany)'),
(5116, 'https://ror.org/004pk7083', 'en', 1, 'https://ror.org/004pk7083 Cedars-Sinai Kerlan-Jobe Institute'),
(5117, 'https://ror.org/004s94c80', 'pt', 1, 'https://ror.org/004s94c80 Biocant'),
(5118, 'https://ror.org/004v7xm28', 'no_lang_code', 1, 'https://ror.org/004v7xm28 Modellium (Canada)'),
(5119, 'https://ror.org/004vn8r55', 'es', 1, 'https://ror.org/004vn8r55 Centro Médico Nacional La Raza'),
(5120, 'https://ror.org/004wdnc96', 'no_lang_code', 1, 'https://ror.org/004wdnc96 Siloam Biosciences (United States)'),
(5121, 'https://ror.org/004wh0w58', 'en', 1, 'https://ror.org/004wh0w58 Guthrie Foundation'),
(5122, 'https://ror.org/004xj7429', 'no_lang_code', 1, 'https://ror.org/004xj7429 Ingenza (United Kingdom)'),
(5123, 'https://ror.org/004zcwt94', 'no_lang_code', 1, 'https://ror.org/004zcwt94 Universal Sensors (United States)'),
(5124, 'https://ror.org/004zwen25', 'no_lang_code', 1, 'https://ror.org/004zwen25 Intelligent Optical Systems (United States)'),
(5125, 'https://ror.org/005296895', 'en', 1, 'https://ror.org/005296895 BOOMHealth'),
(5126, 'https://ror.org/0053ctp29', 'it', 1, 'https://ror.org/0053ctp29 Ospedale Maggiore'),
(5127, 'https://ror.org/0056qeq43', 'no_lang_code', 1, 'https://ror.org/0056qeq43 Toyonaka Municipal Hospital 市立豊中病院'),
(5128, 'https://ror.org/0056x7z10', 'en', 1, 'https://ror.org/0056x7z10 Philander Smith College'),
(5129, 'https://ror.org/0057tdk10', 'no_lang_code', 1, 'https://ror.org/0057tdk10 La Jolla Science Applications (United States)'),
(5130, 'https://ror.org/0059mbq09', 'no_lang_code', 1, 'https://ror.org/0059mbq09 Integrity Testing Laboratory (Canada)'),
(5131, 'https://ror.org/005avv954', 'en', 1, 'https://ror.org/005avv954 Shea Ear Clinic'),
(5132, 'https://ror.org/005df7g82', 'en', 1, 'https://ror.org/005df7g82 Saudi Center for Organ Transplantation'),
(5133, 'https://ror.org/005dyph89', 'en', 1, 'https://ror.org/005dyph89 Hawaii Agriculture Research Center'),
(5134, 'https://ror.org/005e54928', 'no_lang_code', 1, 'https://ror.org/005e54928 Kjobenhavns Telefon Aktieselskab (Denmark)'),
(5135, 'https://ror.org/005f16662', 'en', 1, 'https://ror.org/005f16662 FishBase Information and Research Group'),
(5136, 'https://ror.org/005f8zs60', 'no_lang_code', 1, 'https://ror.org/005f8zs60 Nanoptics (United States)'),
(5137, 'https://ror.org/005fx5296', 'en', 1, 'https://ror.org/005fx5296 Austen Riggs Center'),
(5138, 'https://ror.org/005j1v069', 'en', 1, 'https://ror.org/005j1v069 Pathfinder International'),
(5139, 'https://ror.org/005jham19', 'no_lang_code', 1, 'https://ror.org/005jham19 Ente Nazionale Assistenza al Volo (Italy)'),
(5140, 'https://ror.org/005kew443', 'no_lang_code', 1, 'https://ror.org/005kew443 GC Image (United States)'),
(5141, 'https://ror.org/005kxm139', 'no_lang_code', 1, 'https://ror.org/005kxm139 Bridge12 Technologies (United States)'),
(5142, 'https://ror.org/005m2at17', 'en', 1, 'https://ror.org/005m2at17 Harvard Affiliated Emergency Medicine Residency'),
(5143, 'https://ror.org/005nrbr06', 'no_lang_code', 1, 'https://ror.org/005nrbr06 Phrixus Pharmaceuticals (United States)'),
(5144, 'https://ror.org/005pxtk56', 'no_lang_code', 1, 'https://ror.org/005pxtk56 Cabezon Group (United States)'),
(5145, 'https://ror.org/005qf7j34', 'en', 1, 'https://ror.org/005qf7j34 Harlem United'),
(5146, 'https://ror.org/005sd3904', 'no_lang_code', 1, 'https://ror.org/005sd3904 Enviscope (Germany)'),
(5147, 'https://ror.org/005t0ps98', 'fr', 1, 'https://ror.org/005t0ps98 Institut Arnault Tzanck'),
(5148, 'https://ror.org/005tjs461', 'en', 1, 'https://ror.org/005tjs461 American Association for the Study of Liver Diseases'),
(5149, 'https://ror.org/005yt8w56', 'no_lang_code', 1, 'https://ror.org/005yt8w56 Opotek (United States) Opotek Incorporation'),
(5150, 'https://ror.org/0060hwx87', 'no_lang_code', 1, 'https://ror.org/0060hwx87 Alliance Pharmaceutical (United States)'),
(5151, 'https://ror.org/0062dz060', 'en', 1, 'https://ror.org/0062dz060 Norwich Research Park'),
(5152, 'https://ror.org/00655dk85', 'en', 1, 'https://ror.org/00655dk85 Glasgow Life'),
(5153, 'https://ror.org/0068vzv72', 'no_lang_code', 1, 'https://ror.org/0068vzv72 National Instruments (United Kingdom)'),
(5154, 'https://ror.org/0069kqw53', 'en', 1, 'https://ror.org/0069kqw53 Environmental Research Institute of Michigan'),
(5155, 'https://ror.org/006d11e04', 'no_lang_code', 1, 'https://ror.org/006d11e04 Agricultural Development Advisory Service (United Kingdom)'),
(5156, 'https://ror.org/006dtpb58', 'en', 1, 'https://ror.org/006dtpb58 Monterey Peninsula College'),
(5157, 'https://ror.org/006efkq12', 'de', 1, 'https://ror.org/006efkq12 Unfallkrankenhaus Wien Lorenz Böhler'),
(5158, 'https://ror.org/006gebr77', 'no_lang_code', 1, 'https://ror.org/006gebr77 Toxikon (United States)'),
(5159, 'https://ror.org/006gfkv11', 'no_lang_code', 1, 'https://ror.org/006gfkv11 Stoelting (United States)'),
(5160, 'https://ror.org/006gpqj72', 'no_lang_code', 1, 'https://ror.org/006gpqj72 rEVO Biologics (United States)'),
(5161, 'https://ror.org/006hrz834', 'no_lang_code', 1, 'https://ror.org/006hrz834 Roche (Canada)'),
(5162, 'https://ror.org/006jktr69', 'it', 1, 'https://ror.org/006jktr69 Azienda Ospedaliera di Perugia'),
(5163, 'https://ror.org/006jzf029', 'no_lang_code', 1, 'https://ror.org/006jzf029 TriboFilm Research (United States)'),
(5164, 'https://ror.org/006pq9r08', 'it', 1, 'https://ror.org/006pq9r08 Centro Cardiologico Monzino'),
(5165, 'https://ror.org/006q1m605', 'no_lang_code', 1, 'https://ror.org/006q1m605 BlueInGreen (United States)'),
(5166, 'https://ror.org/006qz8583', 'en', 1, 'https://ror.org/006qz8583 Mahatma Gandhi Kashi Vidyapith महात्मा गाँधी काशी विद्यापीठ மகாத்மா காந்தி காசி வித்யாபீடம்'),
(5167, 'https://ror.org/006tyy056', 'no_lang_code', 1, 'https://ror.org/006tyy056 Integran (Canada)'),
(5168, 'https://ror.org/006vvv981', 'no_lang_code', 1, 'https://ror.org/006vvv981 BioLegend (United States)'),
(5169, 'https://ror.org/006ys0j28', 'no_lang_code', 1, 'https://ror.org/006ys0j28 VinTech (United States)'),
(5170, 'https://ror.org/006zn3t30', 'en', 1, 'https://ror.org/006zn3t30 National Institute of Arthritis and Musculoskeletal and Skin Diseases'),
(5171, 'https://ror.org/0070c9h23', 'en', 1, 'https://ror.org/0070c9h23 Latino Health Institute (United States)'),
(5172, 'https://ror.org/0070nx673', 'no_lang_code', 1, 'https://ror.org/0070nx673 Okino Computer Graphics (Canada)'),
(5173, 'https://ror.org/0071ct727', 'en', 1, 'https://ror.org/0071ct727 Saskatchewan Hospice Palliative Care Association'),
(5174, 'https://ror.org/0072j3s02', 'no_lang_code', 1, 'https://ror.org/0072j3s02 Aster'),
(5175, 'https://ror.org/0073h0969', 'no_lang_code', 1, 'https://ror.org/0073h0969 Indus Instruments (United States)'),
(5176, 'https://ror.org/0073nm244', 'en', 1, 'https://ror.org/0073nm244 Loud Crow Interactive'),
(5177, 'https://ror.org/0075mfb88', 'no_lang_code', 1, 'https://ror.org/0075mfb88 Sharp Laboratories of Europe (United Kingdom)'),
(5178, 'https://ror.org/00770p954', 'en', 1, 'https://ror.org/00770p954 Healthcare Technology Systems'),
(5179, 'https://ror.org/0077s8c55', 'en', 1, 'https://ror.org/0077s8c55 Gyeongsangnam-do Agricultural Research and Extension Services 경상남도농업기술원'),
(5180, 'https://ror.org/0078ww552', 'no_lang_code', 1, 'https://ror.org/0078ww552 Cochlear (Switzerland)'),
(5181, 'https://ror.org/007aah170', 'en', 1, 'https://ror.org/007aah170 Highline College'),
(5182, 'https://ror.org/007app753', 'no_lang_code', 1, 'https://ror.org/007app753 Neuroscript (United States)'),
(5183, 'https://ror.org/007b9a961', 'no_lang_code', 1, 'https://ror.org/007b9a961 KeraNetics (United States)'),
(5184, 'https://ror.org/007bn8q13', 'en', 1, 'https://ror.org/007bn8q13 Association of State and Territorial Health Officials'),
(5185, 'https://ror.org/007jsya95', 'en', 1, 'https://ror.org/007jsya95 Hubbs-Sea World Research Institute'),
(5186, 'https://ror.org/007m28f12', 'no_lang_code', 1, 'https://ror.org/007m28f12 Bio-Synthesis (United States)'),
(5187, 'https://ror.org/007mg2f66', 'no_lang_code', 1, 'https://ror.org/007mg2f66 Prototypes (United States)'),
(5188, 'https://ror.org/007mtxb37', 'no_lang_code', 1, 'https://ror.org/007mtxb37 Oceanit (United States)'),
(5189, 'https://ror.org/007n8tg79', 'no_lang_code', 1, 'https://ror.org/007n8tg79 DanSteel (Denmark)'),
(5190, 'https://ror.org/007paj431', 'en', 1, 'https://ror.org/007paj431 Maine Maritime Academy'),
(5191, 'https://ror.org/007pyhw16', 'en', 1, 'https://ror.org/007pyhw16 Diamond Headache Clinic'),
(5192, 'https://ror.org/007qdqj47', 'en', 1, 'https://ror.org/007qdqj47 Department of Health and Wellness Promotion'),
(5193, 'https://ror.org/007sw5k32', 'pt', 1, 'https://ror.org/007sw5k32 Centro de Genética Clínica'),
(5194, 'https://ror.org/007wes890', 'it', 1, 'https://ror.org/007wes890 Istituto per lo Studio e la Prevenzione Oncologica'),
(5195, 'https://ror.org/007yc7a13', 'no_lang_code', 1, 'https://ror.org/007yc7a13 Brimatech (Austria)'),
(5196, 'https://ror.org/007yjv643', 'no_lang_code', 1, 'https://ror.org/007yjv643 Companhia União Fabril'),
(5197, 'https://ror.org/00806hw79', 'en', 1, 'https://ror.org/00806hw79 Huddersfield Royal Infirmary'),
(5198, 'https://ror.org/0080fc349', 'no_lang_code', 1, 'https://ror.org/0080fc349 JEOL (United Kingdom)'),
(5199, 'https://ror.org/0081r6c67', 'no_lang_code', 1, 'https://ror.org/0081r6c67 Addcomp (Netherlands)'),
(5200, 'https://ror.org/00840a568', 'no_lang_code', 1, 'https://ror.org/00840a568 Watershed Associates'),
(5201, 'https://ror.org/0085yat49', 'en', 1, 'https://ror.org/0085yat49 City of Bradford Metropolitan District Council'),
(5202, 'https://ror.org/00862c839', 'no_lang_code', 1, 'https://ror.org/00862c839 Ricardo AEA (Netherlands)'),
(5203, 'https://ror.org/0087djs12', 'en', 1, 'https://ror.org/0087djs12 Max Planck Institute for Dynamics and Self-Organization Max-Planck-Institut für Dynamik und Selbstorganisation'),
(5204, 'https://ror.org/0088p5f80', 'no_lang_code', 1, 'https://ror.org/0088p5f80 NeuroDx Development (United States)'),
(5205, 'https://ror.org/008ebms37', 'en', 1, 'https://ror.org/008ebms37 Institute of Theoretical and Experimental Biophysics Федеральное государственное бюджетное учреждение науки Институт теоретической и экспериментальной биофизики Российской академии наук'),
(5206, 'https://ror.org/008egzn26', 'pt', 1, 'https://ror.org/008egzn26 Centro Brasileiro de Estudos em Dermatologia'),
(5207, 'https://ror.org/008ghcb80', 'en', 1, 'https://ror.org/008ghcb80 American Nurses Association'),
(5208, 'https://ror.org/008h82p94', 'no_lang_code', 1, 'https://ror.org/008h82p94 Boston Applied Technologies (United States)'),
(5209, 'https://ror.org/008k5ng46', 'en', 1, 'https://ror.org/008k5ng46 Central Council for Research in Ayurvedic Science'),
(5210, 'https://ror.org/008qdc072', 'no_lang_code', 1, 'https://ror.org/008qdc072 Monteco (Canada)'),
(5211, 'https://ror.org/008tdn922', 'no_lang_code', 1, 'https://ror.org/008tdn922 Premier Foods (United Kingdom)'),
(5212, 'https://ror.org/008vjgw77', 'no_lang_code', 1, 'https://ror.org/008vjgw77 MediSpectra (United States)'),
(5213, 'https://ror.org/008vp0c43', 'en', 1, 'https://ror.org/008vp0c43 Sunderland Eye Infirmary'),
(5214, 'https://ror.org/008wcy231', 'en', 1, 'https://ror.org/008wcy231 Zensa Hospital'),
(5215, 'https://ror.org/008wfp513', 'no_lang_code', 1, 'https://ror.org/008wfp513 Buck Consultants International'),
(5216, 'https://ror.org/008x12972', 'en', 1, 'https://ror.org/008x12972 American Society for Reproductive Medicine'),
(5217, 'https://ror.org/008y69805', 'no_lang_code', 1, 'https://ror.org/008y69805 Inscent (United States)'),
(5218, 'https://ror.org/00918g650', 'en', 1, 'https://ror.org/00918g650 Confederation of National Associations of Tanners and Dressers of the European Community'),
(5219, 'https://ror.org/0093s9g83', 'en', 1, 'https://ror.org/0093s9g83 Ministère du Travail Ontario Ministry of Labour'),
(5220, 'https://ror.org/0094yx268', 'en', 1, 'https://ror.org/0094yx268 Philosophy of Science Association'),
(5221, 'https://ror.org/0094yxj20', 'en', 1, 'https://ror.org/0094yxj20 National Association of School Nurses'),
(5222, 'https://ror.org/0095q0x79', 'no_lang_code', 1, 'https://ror.org/0095q0x79 MAX Mobility (United States)'),
(5223, 'https://ror.org/0097hz889', 'no_lang_code', 1, 'https://ror.org/0097hz889 ChemGreen Innovation (Canada)'),
(5224, 'https://ror.org/0097wef15', 'no_lang_code', 1, 'https://ror.org/0097wef15 MacConnell Research (United States)'),
(5225, 'https://ror.org/0097wyf31', 'no_lang_code', 1, 'https://ror.org/0097wyf31 Hitachi (United Kingdom)'),
(5226, 'https://ror.org/00996xv77', 'en', 1, 'https://ror.org/00996xv77 Red Rocks Community College'),
(5227, 'https://ror.org/009azd705', 'it', 1, 'https://ror.org/009azd705 Figli Adottivi e Genitori Naturali'),
(5228, 'https://ror.org/009bsy196', 'en', 1, 'https://ror.org/009bsy196 Edinburgh Royal Infirmary'),
(5229, 'https://ror.org/009cgyv75', 'it', 1, 'https://ror.org/009cgyv75 Consorzio Multi-Ente per la promozione e l''adozione di Tecnologie di calcolo Avanzato'),
(5230, 'https://ror.org/009ee8v97', 'no_lang_code', 1, 'https://ror.org/009ee8v97 Jet Process Corporation (United States)'),
(5231, 'https://ror.org/009frj756', 'no_lang_code', 1, 'https://ror.org/009frj756 360pi (Canada)'),
(5232, 'https://ror.org/009gw7733', 'en', 1, 'https://ror.org/009gw7733 National Renewable Energy Centre'),
(5233, 'https://ror.org/009h0v784', 'it', 1, 'https://ror.org/009h0v784 Fondazione Istituto Neurologico Nazionale Casimiro Mondino'),
(5234, 'https://ror.org/009ht6s65', 'no_lang_code', 1, 'https://ror.org/009ht6s65 Picarro (United States)'),
(5235, 'https://ror.org/009j32424', 'en', 1, 'https://ror.org/009j32424 Institute of Livestock and Grassland Science 畜産研究部門'),
(5236, 'https://ror.org/009jvpf03', 'no_lang_code', 1, 'https://ror.org/009jvpf03 Integrated DNA Technologies (United States)'),
(5237, 'https://ror.org/009k2za57', 'no_lang_code', 1, 'https://ror.org/009k2za57 Chembio (United States)'),
(5238, 'https://ror.org/009mb6m53', 'pt', 1, 'https://ror.org/009mb6m53 Instituto H. Ellis'),
(5239, 'https://ror.org/009mjd053', 'no_lang_code', 1, 'https://ror.org/009mjd053 Advanced Circulatory System (United States)'),
(5240, 'https://ror.org/009mk5659', 'en', 1, 'https://ror.org/009mk5659 American College of Surgeons'),
(5241, 'https://ror.org/009n4a626', 'no_lang_code', 1, 'https://ror.org/009n4a626 StataCorp (United States)'),
(5242, 'https://ror.org/009qffz28', 'en', 1, 'https://ror.org/009qffz28 Central Institute of Psychiatry केन्द्रीय मनश्चिकित्सा संस्थान'),
(5243, 'https://ror.org/009rbsv73', 'en', 1, 'https://ror.org/009rbsv73 The Tech Interactive'),
(5244, 'https://ror.org/009rf1452', 'en', 1, 'https://ror.org/009rf1452 San Francisco Film Society'),
(5245, 'https://ror.org/009s7a550', 'en', 1, 'https://ror.org/009s7a550 Pamela Youde Nethersole Eastern Hospital 東區尤德夫人那打素醫院'),
(5246, 'https://ror.org/009vh5d61', 'en', 1, 'https://ror.org/009vh5d61 Rollins College'),
(5247, 'https://ror.org/009xkka62', 'no_lang_code', 1, 'https://ror.org/009xkka62 Sema Construction (United States)'),
(5248, 'https://ror.org/009y6jy27', 'no_lang_code', 1, 'https://ror.org/009y6jy27 GVD Corporation (United States)'),
(5249, 'https://ror.org/00a0kf832', 'en', 1, 'https://ror.org/00a0kf832 F.D. Ovcharenko Institute of Biocolloidal Chemistry Інститут біоколоїдної хімії ім. Ф. Д. Овчаренка'),
(5250, 'https://ror.org/00a1a0x11', 'no_lang_code', 1, 'https://ror.org/00a1a0x11 Area Detector Systems Corporation (United States)'),
(5251, 'https://ror.org/00a34rj81', 'no_lang_code', 1, 'https://ror.org/00a34rj81 Bax & Willems'),
(5252, 'https://ror.org/00a3bx267', 'en', 1, 'https://ror.org/00a3bx267 Toyama Institute of Health 富山県衛生研究所'),
(5253, 'https://ror.org/00a4npp83', 'no_lang_code', 1, 'https://ror.org/00a4npp83 Dyson (United Kingdom)'),
(5254, 'https://ror.org/00a56am39', 'en', 1, 'https://ror.org/00a56am39 Philippine General Hospital'),
(5255, 'https://ror.org/00a6fbp85', 'en', 1, 'https://ror.org/00a6fbp85 P. D. Hinduja Hospital and Medical Research Centre'),
(5256, 'https://ror.org/00a75q479', 'no_lang_code', 1, 'https://ror.org/00a75q479 Nature Technology Corporation (United States)'),
(5257, 'https://ror.org/00aac7f28', 'no_lang_code', 1, 'https://ror.org/00aac7f28 Ion Physics (United States)'),
(5258, 'https://ror.org/00ab7ks98', 'en', 1, 'https://ror.org/00ab7ks98 W.M. Keck Observatory'),
(5259, 'https://ror.org/00afc8732', 'en', 1, 'https://ror.org/00afc8732 William Beaumont Army Medical Center'),
(5260, 'https://ror.org/00afpvb68', 'fr', 1, 'https://ror.org/00afpvb68 Collège Shawinigan'),
(5261, 'https://ror.org/00agtat91', 'de', 1, 'https://ror.org/00agtat91 Städtisches Klinikum Karlsruhe'),
(5262, 'https://ror.org/00ah4xn57', 'en', 1, 'https://ror.org/00ah4xn57 Capital Allergy and Respiratory Disease Center'),
(5263, 'https://ror.org/00ahe2k65', 'no_lang_code', 1, 'https://ror.org/00ahe2k65 Adasa (Spain)'),
(5264, 'https://ror.org/00akhwn95', 'en', 1, 'https://ror.org/00akhwn95 Queen Saovabha Memorial Institute'),
(5265, 'https://ror.org/00akjja53', 'no_lang_code', 1, 'https://ror.org/00akjja53 Atlas Elektronik (Germany)'),
(5266, 'https://ror.org/00akkff67', 'no_lang_code', 1, 'https://ror.org/00akkff67 Phcc (United States)'),
(5267, 'https://ror.org/00amjd520', 'en', 1, 'https://ror.org/00amjd520 Saint Vincent College'),
(5268, 'https://ror.org/00an43c80', 'no_lang_code', 1, 'https://ror.org/00an43c80 SonaCare Medical (United States)'),
(5269, 'https://ror.org/00anm2x55', 'en', 1, 'https://ror.org/00anm2x55 Ministry of Justice'),
(5270, 'https://ror.org/00anthv74', 'no_lang_code', 1, 'https://ror.org/00anthv74 P&P Optica (Canada)'),
(5271, 'https://ror.org/00aqgm431', 'en', 1, 'https://ror.org/00aqgm431 Island Peer Review Organization'),
(5272, 'https://ror.org/00aqm2347', 'en', 1, 'https://ror.org/00aqm2347 Florence–Darlington Technical College'),
(5273, 'https://ror.org/00ar79186', 'no_lang_code', 1, 'https://ror.org/00ar79186 Performance Polymer Solutions (United States)'),
(5274, 'https://ror.org/00av7p167', 'en', 1, 'https://ror.org/00av7p167 Center for Science in the Public Interest (United States)'),
(5275, 'https://ror.org/00awfs868', 'no_lang_code', 1, 'https://ror.org/00awfs868 FFA Sciences (United States)'),
(5276, 'https://ror.org/00ay43505', 'fr', 1, 'https://ror.org/00ay43505 Institut de Virologie'),
(5277, 'https://ror.org/00aztzy37', 'no_lang_code', 1, 'https://ror.org/00aztzy37 El.En. Group (Italy)'),
(5278, 'https://ror.org/00b0jfb70', 'no_lang_code', 1, 'https://ror.org/00b0jfb70 BM-Science'),
(5279, 'https://ror.org/00b0t9z66', 'en', 1, 'https://ror.org/00b0t9z66 Vision Eye Institute'),
(5280, 'https://ror.org/00b1drk46', 'no_lang_code', 1, 'https://ror.org/00b1drk46 Asper Biotech (Estonia)'),
(5281, 'https://ror.org/00b51s809', 'no_lang_code', 1, 'https://ror.org/00b51s809 InnerSea Technology (United States)'),
(5282, 'https://ror.org/00b5ztt43', 'en', 1, 'https://ror.org/00b5ztt43 Rancho Santiago Community College District'),
(5283, 'https://ror.org/00b605v51', 'no_lang_code', 1, 'https://ror.org/00b605v51 Mandel Scientific (Canada)'),
(5284, 'https://ror.org/00b970e83', 'en', 1, 'https://ror.org/00b970e83 Fond du Lac Tribal and Community College'),
(5285, 'https://ror.org/00baryp08', 'en', 1, 'https://ror.org/00baryp08 Association for Symbolic Logic'),
(5286, 'https://ror.org/00bbe8x87', 'no_lang_code', 1, 'https://ror.org/00bbe8x87 Stallergenes Greer (France)'),
(5287, 'https://ror.org/00bcqra17', 'no_lang_code', 1, 'https://ror.org/00bcqra17 Local Data Company (United Kingdom)'),
(5288, 'https://ror.org/00bdvg512', 'no_lang_code', 1, 'https://ror.org/00bdvg512 Juvaris BioTherapeutics (United States)'),
(5289, 'https://ror.org/00beq0325', 'pt', 1, 'https://ror.org/00beq0325 Centro Tecnológico do Calçado de Portugal'),
(5290, 'https://ror.org/00berct97', 'no_lang_code', 1, 'https://ror.org/00berct97 NTT (Japan) 日本電信電話株式会社'),
(5291, 'https://ror.org/00bewwj71', 'no_lang_code', 1, 'https://ror.org/00bewwj71 Cooperative Resources International (United States)'),
(5292, 'https://ror.org/00bfb4h45', 'no_lang_code', 1, 'https://ror.org/00bfb4h45 Endacea (United States)'),
(5293, 'https://ror.org/00bh4sk41', 'no_lang_code', 1, 'https://ror.org/00bh4sk41 Endomedix (United States)'),
(5294, 'https://ror.org/00bjwbm70', 'en', 1, 'https://ror.org/00bjwbm70 International Society for Optical Engineering'),
(5295, 'https://ror.org/00bma2332', 'en', 1, 'https://ror.org/00bma2332 Royal Institute of British Architects'),
(5296, 'https://ror.org/00bmxak18', 'en', 1, 'https://ror.org/00bmxak18 Fukuoka Institute of Technology 福岡工業大学'),
(5297, 'https://ror.org/00bnthp71', 'fr', 1, 'https://ror.org/00bnthp71 Institut de Recherche pour le Développement'),
(5298, 'https://ror.org/00bppv849', 'en', 1, 'https://ror.org/00bppv849 National Partnership for Environmental Technology Education'),
(5299, 'https://ror.org/00bqy3h17', 'en', 1, 'https://ror.org/00bqy3h17 Merrimack College'),
(5300, 'https://ror.org/00bvzmn76', 'no_lang_code', 1, 'https://ror.org/00bvzmn76 Blackrock Microsystems (United States)'),
(5301, 'https://ror.org/00bw4xw30', 'en', 1, 'https://ror.org/00bw4xw30 Institute of Experimental Cardiology'),
(5302, 'https://ror.org/00bxgws88', 'en', 1, 'https://ror.org/00bxgws88 Cascade AIDS Project'),
(5303, 'https://ror.org/00by7mn52', 'no_lang_code', 1, 'https://ror.org/00by7mn52 Allocadia (Canada)'),
(5304, 'https://ror.org/00by9f077', 'en', 1, 'https://ror.org/00by9f077 Food Research Institute 食品総合研究所'),
(5305, 'https://ror.org/00bycf367', 'en', 1, 'https://ror.org/00bycf367 Botanical Society of America'),
(5306, 'https://ror.org/00byczw08', 'en', 1, 'https://ror.org/00byczw08 Penrose Hospital'),
(5307, 'https://ror.org/00bz2pj54', 'no_lang_code', 1, 'https://ror.org/00bz2pj54 21st Century Therapeutics (United States)'),
(5308, 'https://ror.org/00bzsst90', 'en', 1, 'https://ror.org/00bzsst90 Institute for Advanced Studies in Basic Sciences مرکز تحصیلات تکمیلی در علوم پایه زنجان'),
(5309, 'https://ror.org/00c211r48', 'no_lang_code', 1, 'https://ror.org/00c211r48 Boulder Language Technologies (United States)'),
(5310, 'https://ror.org/00c489v88', 'en', 1, 'https://ror.org/00c489v88 Academy of Medical Sciences'),
(5311, 'https://ror.org/00c6b1k17', 'no_lang_code', 1, 'https://ror.org/00c6b1k17 Capgemini (Belgium)'),
(5312, 'https://ror.org/00ca7az78', 'no_lang_code', 1, 'https://ror.org/00ca7az78 BIC Bratislava (Slovakia)'),
(5313, 'https://ror.org/00cb06v13', 'no_lang_code', 1, 'https://ror.org/00cb06v13 ABB (United States)'),
(5314, 'https://ror.org/00cfm3753', 'no_lang_code', 1, 'https://ror.org/00cfm3753 ANI Pharmaceuticals (United States)'),
(5315, 'https://ror.org/00chzyy83', 'no_lang_code', 1, 'https://ror.org/00chzyy83 Virscio (United States)'),
(5316, 'https://ror.org/00ckx8y08', 'no_lang_code', 1, 'https://ror.org/00ckx8y08 Berliner Nanotest und Design'),
(5317, 'https://ror.org/00cm8nm15', 'en', 1, 'https://ror.org/00cm8nm15 University of California, Irvine Medical Center'),
(5318, 'https://ror.org/00cnpxz07', 'en', 1, 'https://ror.org/00cnpxz07 Connecticut Business and Industry Association'),
(5319, 'https://ror.org/00cp8tk34', 'no_lang_code', 1, 'https://ror.org/00cp8tk34 Infor (Netherlands)'),
(5320, 'https://ror.org/00cpb6264', 'it', 1, 'https://ror.org/00cpb6264 Istituto Neurologico Mediterraneo'),
(5321, 'https://ror.org/00cpcby17', 'no_lang_code', 1, 'https://ror.org/00cpcby17 Centre Technique Cuir Chaussure Maroquinerie (France)'),
(5322, 'https://ror.org/00csvwd48', 'no_lang_code', 1, 'https://ror.org/00csvwd48 Capstone Therapeutics (United States)'),
(5323, 'https://ror.org/00ctdh943', 'es', 1, 'https://ror.org/00ctdh943 Instituto Nacional de Perinatología National Institute of Perinatología Isidro Espinosa de los Reyes'),
(5324, 'https://ror.org/00cvaph79', 'en', 1, 'https://ror.org/00cvaph79 BioNB'),
(5325, 'https://ror.org/00cwrns71', 'en', 1, 'https://ror.org/00cwrns71 Indian Space Research Organisation भारतीय अंतराळ संशोधन संस्था भारतीय अंतरिक्ष अनुसंधान संगठन भारतीय अन्तरिक्ष अनुसन्धान संगठन ভারতীয় মহাকাশ গবেষণা সংস্থা ਇਸਰੋ ઇસરો இந்திய விண்வெளி ஆய்வு மையம் భారతీయ అంతరిక్ష పరిశోధనా సంస్థ ಭಾರತೀಯ ಬಾಹ್ಯಾಕಾಶ ಸಂಶೋಧನೆ ಸಂಸ್ಥೆ ഇന്ത്യൻ സ്പേസ് റിസർച്ച് ഓർഗനൈസേഷൻ'),
(5326, 'https://ror.org/00cwwgn12', 'no_lang_code', 1, 'https://ror.org/00cwwgn12 Recombinant Technologies (United States)'),
(5327, 'https://ror.org/00cyfck94', 'no_lang_code', 1, 'https://ror.org/00cyfck94 Parsons Brinckerhoff'),
(5328, 'https://ror.org/00d00px90', 'en', 1, 'https://ror.org/00d00px90 Langley Environmental Partners Society'),
(5329, 'https://ror.org/00d0rvy84', 'no_lang_code', 1, 'https://ror.org/00d0rvy84 Yokohama Minami Kyosai Hospital 横浜南共済病院'),
(5330, 'https://ror.org/00d2efr72', 'no_lang_code', 1, 'https://ror.org/00d2efr72 PLx Pharma (United States)'),
(5331, 'https://ror.org/00d2y1254', 'en', 1, 'https://ror.org/00d2y1254 Misericordia University'),
(5332, 'https://ror.org/00d3vm134', 'en', 1, 'https://ror.org/00d3vm134 Archaeology Southwest'),
(5333, 'https://ror.org/00d53ja24', 'no_lang_code', 1, 'https://ror.org/00d53ja24 Aspen Aerogels (United States)'),
(5334, 'https://ror.org/00d5z2352', 'no_lang_code', 1, 'https://ror.org/00d5z2352 Bekaert (Belgium)'),
(5335, 'https://ror.org/00d67eh84', 'en', 1, 'https://ror.org/00d67eh84 Central Laboratory for Radiological Protection Centralnego Laboratorium Ochrony Radiologicznej'),
(5336, 'https://ror.org/00d7mpc92', 'en', 1, 'https://ror.org/00d7mpc92 PENTA Foundation'),
(5337, 'https://ror.org/00d9spg57', 'it', 1, 'https://ror.org/00d9spg57 Agenzia dei Trasporti Autoferrotranviari del Comune'),
(5338, 'https://ror.org/00da6z433', 'no_lang_code', 1, 'https://ror.org/00da6z433 Haematologic Technologies (United States)'),
(5339, 'https://ror.org/00dbnf369', 'en', 1, 'https://ror.org/00dbnf369 National Marine Mammal Foundation'),
(5340, 'https://ror.org/00dcv1019', 'en', 1, 'https://ror.org/00dcv1019 Allen Institute for Brain Science'),
(5341, 'https://ror.org/00ddb6b18', 'en', 1, 'https://ror.org/00ddb6b18 Refugee and Immigrant Center'),
(5342, 'https://ror.org/00de6v257', 'no_lang_code', 1, 'https://ror.org/00de6v257 Envisa (France)'),
(5343, 'https://ror.org/00death42', 'en', 1, 'https://ror.org/00death42 Administrative Staff College of India'),
(5344, 'https://ror.org/00dg4je56', 'no_lang_code', 1, 'https://ror.org/00dg4je56 Thermal-Lube (Canada)'),
(5345, 'https://ror.org/00dh4zq96', 'no_lang_code', 1, 'https://ror.org/00dh4zq96 TRIA Bioscience (United States)'),
(5346, 'https://ror.org/00dhe8f29', 'no_lang_code', 1, 'https://ror.org/00dhe8f29 Gooch & Housego (United Kingdom)'),
(5347, 'https://ror.org/00dhmq281', 'en', 1, 'https://ror.org/00dhmq281 Foothill College'),
(5348, 'https://ror.org/00dj48n36', 'en', 1, 'https://ror.org/00dj48n36 Colorado Judicial Branch'),
(5349, 'https://ror.org/00djyb934', 'no_lang_code', 1, 'https://ror.org/00djyb934 Oxford Lasers (United Kingdom)'),
(5350, 'https://ror.org/00dkszm12', 'no_lang_code', 1, 'https://ror.org/00dkszm12 Dantec Dynamics (Germany)'),
(5351, 'https://ror.org/00dmq5618', 'no_lang_code', 1, 'https://ror.org/00dmq5618 Compagnie Maritime d''Expertises (France)'),
(5352, 'https://ror.org/00dmrtm29', 'en', 1, 'https://ror.org/00dmrtm29 New York City Health and Hospitals Corporation'),
(5353, 'https://ror.org/00dnb8a67', 'fr', 1, 'https://ror.org/00dnb8a67 Science pour tous'),
(5354, 'https://ror.org/00dncgb07', 'en', 1, 'https://ror.org/00dncgb07 Notre Dame of Maryland University'),
(5355, 'https://ror.org/00dpysh46', 'en', 1, 'https://ror.org/00dpysh46 Conseil national d''éthique en recherche chez l''humain National Council on Ethics in Human Research'),
(5356, 'https://ror.org/00dqfzf20', 'en', 1, 'https://ror.org/00dqfzf20 Barnets borg Helsinki Children''s Hospital Lastenlinna'),
(5357, 'https://ror.org/00dqmaq38', 'it', 1, 'https://ror.org/00dqmaq38 Oasi Maria SS'),
(5358, 'https://ror.org/00dqq0p30', 'en', 1, 'https://ror.org/00dqq0p30 Texas State Technical College Harlingen'),
(5359, 'https://ror.org/00dsap877', 'en', 1, 'https://ror.org/00dsap877 Sustrans'),
(5360, 'https://ror.org/00dv9e751', 'no_lang_code', 1, 'https://ror.org/00dv9e751 Amplimmune (United States)'),
(5361, 'https://ror.org/00dxv3745', 'en', 1, 'https://ror.org/00dxv3745 Hernia Center'),
(5362, 'https://ror.org/00dym4p25', 'no_lang_code', 1, 'https://ror.org/00dym4p25 Hsiri Therapeutics (United States)'),
(5363, 'https://ror.org/00e2hg029', 'no_lang_code', 1, 'https://ror.org/00e2hg029 Sterling Research Group (United States)'),
(5364, 'https://ror.org/00e30t131', 'no_lang_code', 1, 'https://ror.org/00e30t131 Rowan Williams Davies & Irwin (Canada)'),
(5365, 'https://ror.org/00e476874', 'en', 1, 'https://ror.org/00e476874 Agile Mind'),
(5366, 'https://ror.org/00e4xmg89', 'en', 1, 'https://ror.org/00e4xmg89 Hipple Cancer Research Center'),
(5367, 'https://ror.org/00e6gd695', 'en', 1, 'https://ror.org/00e6gd695 Arapahoe House'),
(5368, 'https://ror.org/00e7hrn50', 'no_lang_code', 1, 'https://ror.org/00e7hrn50 LUSAS (United Kingdom)'),
(5369, 'https://ror.org/00e812q49', 'no_lang_code', 1, 'https://ror.org/00e812q49 Springboard (Canada)'),
(5370, 'https://ror.org/00e8ar137', 'da', 1, 'https://ror.org/00e8ar137 Vejle Hospital Vejle Sygehus'),
(5371, 'https://ror.org/00e8qrd29', 'en', 1, 'https://ror.org/00e8qrd29 Center for Clinical Studies'),
(5372, 'https://ror.org/00edt5124', 'it', 1, 'https://ror.org/00edt5124 Ospedale degli Infermi'),
(5373, 'https://ror.org/00edzwq44', 'en', 1, 'https://ror.org/00edzwq44 Academy of Radiology Research'),
(5374, 'https://ror.org/00efy1453', 'en', 1, 'https://ror.org/00efy1453 Chief Dull Knife College'),
(5375, 'https://ror.org/00eg81h43', 'en', 1, 'https://ror.org/00eg81h43 Institute of Physiology and Pathology of Hearing'),
(5376, 'https://ror.org/00ejq5880', 'no_lang_code', 1, 'https://ror.org/00ejq5880 BioMedomics (United States)'),
(5377, 'https://ror.org/00ek95971', 'no_lang_code', 1, 'https://ror.org/00ek95971 Cosytec (France)'),
(5378, 'https://ror.org/00eksk721', 'en', 1, 'https://ror.org/00eksk721 National Environmental Health Association'),
(5379, 'https://ror.org/00ekxed29', 'no_lang_code', 1, 'https://ror.org/00ekxed29 Horizon Research (United States)'),
(5380, 'https://ror.org/00em27a94', 'pt', 1, 'https://ror.org/00em27a94 Instituto de Infectologia Emílio Ribas'),
(5381, 'https://ror.org/00epxwq78', 'en', 1, 'https://ror.org/00epxwq78 Hamilton Regional Laboratory Medicine Program'),
(5382, 'https://ror.org/00eqjxv60', 'no_lang_code', 1, 'https://ror.org/00eqjxv60 Capital Consulting Corporation (United States)'),
(5383, 'https://ror.org/00er70d66', 'en', 1, 'https://ror.org/00er70d66 Center for Complex Infectious Diseases'),
(5384, 'https://ror.org/00es7k954', 'en', 1, 'https://ror.org/00es7k954 Columbia College - South Carolina'),
(5385, 'https://ror.org/00et2zw97', 'en', 1, 'https://ror.org/00et2zw97 Matsumoto Livestock Hygiene Service Center'),
(5386, 'https://ror.org/00evgsc59', 'no_lang_code', 1, 'https://ror.org/00evgsc59 Babcock & Wilcox (Denmark)'),
(5387, 'https://ror.org/00evjd729', 'en', 1, 'https://ror.org/00evjd729 Australian Red Cross Lifeblood'),
(5388, 'https://ror.org/00ew1b528', 'no_lang_code', 1, 'https://ror.org/00ew1b528 MycoLogic (Canada)'),
(5389, 'https://ror.org/00exr1241', 'en', 1, 'https://ror.org/00exr1241 Joint Center for Structural Genomics'),
(5390, 'https://ror.org/00f1vw968', 'en', 1, 'https://ror.org/00f1vw968 KentuckyOne Health'),
(5391, 'https://ror.org/00f419y92', 'en', 1, 'https://ror.org/00f419y92 St. Luke''s Cataract and Laser Institute'),
(5392, 'https://ror.org/00f4akz96', 'no_lang_code', 1, 'https://ror.org/00f4akz96 NVE Corporation (United States)'),
(5393, 'https://ror.org/00f8dwt44', 'en', 1, 'https://ror.org/00f8dwt44 Institute of Electrochemistry and Energy Systems Институт по електрохимия и енергийни системи'),
(5394, 'https://ror.org/00fby7m68', 'no_lang_code', 1, 'https://ror.org/00fby7m68 Air Canada'),
(5395, 'https://ror.org/00fcszb13', 'no_lang_code', 1, 'https://ror.org/00fcszb13 Pacific Biosciences (United States)'),
(5396, 'https://ror.org/00fd3za45', 'no_lang_code', 1, 'https://ror.org/00fd3za45 Adif (Spain)'),
(5397, 'https://ror.org/00fd7nh45', 'no_lang_code', 1, 'https://ror.org/00fd7nh45 Yecuris (United States)'),
(5398, 'https://ror.org/00fjz2j91', 'en', 1, 'https://ror.org/00fjz2j91 Christian Community Health Center'),
(5399, 'https://ror.org/00fm8vh73', 'no_lang_code', 1, 'https://ror.org/00fm8vh73 GigaGen (United States)'),
(5400, 'https://ror.org/00fnk0q46', 'en', 1, 'https://ror.org/00fnk0q46 Academy of Medicine'),
(5401, 'https://ror.org/00fq5cm18', 'en', 1, 'https://ror.org/00fq5cm18 National Institute on Drug Abuse'),
(5402, 'https://ror.org/00fre7r52', 'en', 1, 'https://ror.org/00fre7r52 Community Health Awareness Group'),
(5403, 'https://ror.org/00frfm169', 'no_lang_code', 1, 'https://ror.org/00frfm169 Woomera Therapeutics'),
(5404, 'https://ror.org/00fs7vk14', 'en', 1, 'https://ror.org/00fs7vk14 Consorzio TRAIN TRAIN Consortium'),
(5405, 'https://ror.org/00ftam505', 'en', 1, 'https://ror.org/00ftam505 Newcastle City Council'),
(5406, 'https://ror.org/00ftv8552', 'en', 1, 'https://ror.org/00ftv8552 Center for Research in Environmental Epidemiology Centro de Investigación en Epidemiología Ambiental'),
(5407, 'https://ror.org/00fyk6p56', 'no_lang_code', 1, 'https://ror.org/00fyk6p56 Moberg Research (United States)'),
(5408, 'https://ror.org/00fyk9n62', 'en', 1, 'https://ror.org/00fyk9n62 Foundation of the Hellenic World'),
(5409, 'https://ror.org/00g0avy67', 'no_lang_code', 1, 'https://ror.org/00g0avy67 WinProbe (United States)'),
(5410, 'https://ror.org/00g1g7t14', 'en', 1, 'https://ror.org/00g1g7t14 PHS Commissioned Officers Foundation'),
(5411, 'https://ror.org/00g2tkw06', 'no_lang_code', 1, 'https://ror.org/00g2tkw06 Ford Motor Company (United States)'),
(5412, 'https://ror.org/00g2vje79', 'no_lang_code', 1, 'https://ror.org/00g2vje79 Cornerstone Systems Northwest (United States)'),
(5413, 'https://ror.org/00g3gq507', 'no_lang_code', 1, 'https://ror.org/00g3gq507 Taiga Biotechnologies (United States)'),
(5414, 'https://ror.org/00g3wz802', 'no_lang_code', 1, 'https://ror.org/00g3wz802 Front Range Scientific Computations'),
(5415, 'https://ror.org/00g3zjf64', 'en', 1, 'https://ror.org/00g3zjf64 Texas Endosurgery Institute'),
(5416, 'https://ror.org/00g4tw789', 'en', 1, 'https://ror.org/00g4tw789 Hughston Clinic'),
(5417, 'https://ror.org/00g5b0g93', 'en', 1, 'https://ror.org/00g5b0g93 Zunyi Medical University 遵义医学院'),
(5418, 'https://ror.org/00g6vqe09', 'no_lang_code', 1, 'https://ror.org/00g6vqe09 Asuragen (United States)'),
(5419, 'https://ror.org/00g6ztp19', 'en', 1, 'https://ror.org/00g6ztp19 Calgary Laboratory Services'),
(5420, 'https://ror.org/00g741v42', 'en', 1, 'https://ror.org/00g741v42 Gansu University of Traditional Chinese Medicine 甘肃中医学院'),
(5421, 'https://ror.org/00g81mg52', 'no_lang_code', 1, 'https://ror.org/00g81mg52 Columbus Technologies and Services (United States)'),
(5422, 'https://ror.org/00gb8td65', 'no_lang_code', 1, 'https://ror.org/00gb8td65 Y Touring Theatre Company'),
(5423, 'https://ror.org/00gban551', 'en', 1, 'https://ror.org/00gban551 Biomedical Research Foundation of the Academy of Athens'),
(5424, 'https://ror.org/00gbb9377', 'en', 1, 'https://ror.org/00gbb9377 National Center on Institutions and Alternatives'),
(5425, 'https://ror.org/00geypp27', 'no_lang_code', 1, 'https://ror.org/00geypp27 Novartis (France)'),
(5426, 'https://ror.org/00gf2nq54', 'no_lang_code', 1, 'https://ror.org/00gf2nq54 Nordic Life Science Pipeline (Canada)'),
(5427, 'https://ror.org/00gft1871', 'no_lang_code', 1, 'https://ror.org/00gft1871 Therapyx (United States)'),
(5428, 'https://ror.org/00gfv6v51', 'sk', 1, 'https://ror.org/00gfv6v51 Národný Onkologický Ústav'),
(5429, 'https://ror.org/00gg4aq64', 'fr', 1, 'https://ror.org/00gg4aq64 Centre Hospitalier Frèderic-Henri Manhès'),
(5430, 'https://ror.org/00gmz2d02', 'en', 1, 'https://ror.org/00gmz2d02 Institute of Chemical Biology and Fundamental Medicine Федеральное государственное бюджетное учреждение науки Институт химической биологии и фундаментальной медицины Сибирского отделения Российской академии наук'),
(5431, 'https://ror.org/00gpcjc06', 'no_lang_code', 1, 'https://ror.org/00gpcjc06 Malesci (Italy)'),
(5432, 'https://ror.org/00gs35582', 'en', 1, 'https://ror.org/00gs35582 Valencian Infertility Institute'),
(5433, 'https://ror.org/00gwpva83', 'en', 1, 'https://ror.org/00gwpva83 Progress Educational Trust'),
(5434, 'https://ror.org/00gygcg63', 'en', 1, 'https://ror.org/00gygcg63 East Bay Community Recovery Project'),
(5435, 'https://ror.org/00gzhq402', 'no_lang_code', 1, 'https://ror.org/00gzhq402 Fugro (United States)'),
(5436, 'https://ror.org/00h0zmy35', 'en', 1, 'https://ror.org/00h0zmy35 Bienestar'),
(5437, 'https://ror.org/00h1gfz86', 'nl', 1, 'https://ror.org/00h1gfz86 AZ Klina'),
(5438, 'https://ror.org/00h2tq173', 'no_lang_code', 1, 'https://ror.org/00h2tq173 Swami Vivekananda Yoga Anusandhana Samsthana'),
(5439, 'https://ror.org/00h74hd82', 'en', 1, 'https://ror.org/00h74hd82 Denver Center for the Performing Arts'),
(5440, 'https://ror.org/00h7p4v21', 'en', 1, 'https://ror.org/00h7p4v21 Sri Jayadeva Institute of Cardiovascular Sciences and Research'),
(5441, 'https://ror.org/00h8z3z59', 'en', 1, 'https://ror.org/00h8z3z59 Hispanic Association of Colleges and Universities'),
(5442, 'https://ror.org/00h92yy88', 'no_lang_code', 1, 'https://ror.org/00h92yy88 Arrayomics (United States)'),
(5443, 'https://ror.org/00h9r4759', 'no_lang_code', 1, 'https://ror.org/00h9r4759 Flowtech International (Sweden)'),
(5444, 'https://ror.org/00hcz6468', 'en', 1, 'https://ror.org/00hcz6468 Toyota Memorial Hospital トヨタ記念病院'),
(5445, 'https://ror.org/00hef7f20', 'en', 1, 'https://ror.org/00hef7f20 Finnish Transport Agency'),
(5446, 'https://ror.org/00hezqs33', 'no_lang_code', 1, 'https://ror.org/00hezqs33 Film and Video Umbrella (United Kingdom)'),
(5447, 'https://ror.org/00hf0cm69', 'no_lang_code', 1, 'https://ror.org/00hf0cm69 Adherent Technologies (United States)'),
(5448, 'https://ror.org/00hh31m68', 'no_lang_code', 1, 'https://ror.org/00hh31m68 Advanced Mechanical Technology (United States)'),
(5449, 'https://ror.org/00hm3qq49', 'no_lang_code', 1, 'https://ror.org/00hm3qq49 Eolas (Ireland)'),
(5450, 'https://ror.org/00hnd8b56', 'no_lang_code', 1, 'https://ror.org/00hnd8b56 Applied Research Corporation (United States)'),
(5451, 'https://ror.org/00hntwx50', 'en', 1, 'https://ror.org/00hntwx50 Seattle Central College'),
(5452, 'https://ror.org/00hp40m78', 'no_lang_code', 1, 'https://ror.org/00hp40m78 AAC (United States)'),
(5453, 'https://ror.org/00hq8sy61', 'en', 1, 'https://ror.org/00hq8sy61 National Institute for Children’s Health Quality'),
(5454, 'https://ror.org/00hr6kp69', 'en', 1, 'https://ror.org/00hr6kp69 Emory Eye Center'),
(5455, 'https://ror.org/00hr74637', 'no_lang_code', 1, 'https://ror.org/00hr74637 Science Approach (United States)'),
(5456, 'https://ror.org/00hssfx27', 'no_lang_code', 1, 'https://ror.org/00hssfx27 Biothermal (United States)'),
(5457, 'https://ror.org/00ht01r58', 'no_lang_code', 1, 'https://ror.org/00ht01r58 Wave 80 Biosciences (United States)'),
(5458, 'https://ror.org/00ht2ab73', 'fr', 1, 'https://ror.org/00ht2ab73 Association Nationale de la Recherche et de la Technologie'),
(5459, 'https://ror.org/00hveka38', 'en', 1, 'https://ror.org/00hveka38 Paine College'),
(5460, 'https://ror.org/00hw1e768', 'no_lang_code', 1, 'https://ror.org/00hw1e768 Radex Heraklith Industriebeteiligungs (Germany)'),
(5461, 'https://ror.org/00hx3bk50', 'no_lang_code', 1, 'https://ror.org/00hx3bk50 Icogenex (United States)'),
(5462, 'https://ror.org/00hxj5n33', 'de', 1, 'https://ror.org/00hxj5n33 Deutsches Institut für Normung German Institute for Standardization'),
(5463, 'https://ror.org/00hy18g46', 'no_lang_code', 1, 'https://ror.org/00hy18g46 DEKK-TEC (United States)'),
(5464, 'https://ror.org/00hyyhz65', 'no_lang_code', 1, 'https://ror.org/00hyyhz65 Source Signal Imaging'),
(5465, 'https://ror.org/00j0kxp54', 'en', 1, 'https://ror.org/00j0kxp54 Russian Academy of Natural Sciences'),
(5466, 'https://ror.org/00j10x245', 'no_lang_code', 1, 'https://ror.org/00j10x245 Plastic Logic (United Kingdom)'),
(5467, 'https://ror.org/00j10yp83', 'en', 1, 'https://ror.org/00j10yp83 Rural Alaska Community Action Program'),
(5468, 'https://ror.org/00j161312', 'en', 1, 'https://ror.org/00j161312 Guy''s and St Thomas'' NHS Foundation Trust'),
(5469, 'https://ror.org/00j1c3r46', 'no_lang_code', 1, 'https://ror.org/00j1c3r46 Optym (United States)'),
(5470, 'https://ror.org/00j1e7h38', 'en', 1, 'https://ror.org/00j1e7h38 W. Alton Jones Cell Science Center'),
(5471, 'https://ror.org/00j1y9t40', 'fr', 1, 'https://ror.org/00j1y9t40 Laboratoire d''Enzymologie et Biochimie Structurales'),
(5472, 'https://ror.org/00j2t0g84', 'no_lang_code', 1, 'https://ror.org/00j2t0g84 TMD Technologies (United Kingdom)'),
(5473, 'https://ror.org/00j349n10', 'no_lang_code', 1, 'https://ror.org/00j349n10 GlySens (United States)'),
(5474, 'https://ror.org/00j39nx61', 'no_lang_code', 1, 'https://ror.org/00j39nx61 Collegium Budapest'),
(5475, 'https://ror.org/00j49rw24', 'en', 1, 'https://ror.org/00j49rw24 LRS Institute of Tuberculosis and Respiratory Diseases'),
(5476, 'https://ror.org/00j631389', 'en', 1, 'https://ror.org/00j631389 New World Laboratories'),
(5477, 'https://ror.org/00j6a4d92', 'en', 1, 'https://ror.org/00j6a4d92 Conseil Européen des Fédérations de l''Industrie Chimique European Chemical Industry Council'),
(5478, 'https://ror.org/00j707644', 'it', 1, 'https://ror.org/00j707644 Azienda Ospedaliera San Camillo-Forlanini, Ospedale Carlo Forlanini'),
(5479, 'https://ror.org/00j83wy46', 'no_lang_code', 1, 'https://ror.org/00j83wy46 Monsanto (United States)'),
(5480, 'https://ror.org/00j998b38', 'no_lang_code', 1, 'https://ror.org/00j998b38 GT Advanced Technologies (United States)'),
(5481, 'https://ror.org/00j99af28', 'no_lang_code', 1, 'https://ror.org/00j99af28 Metabolic Technologies (United States)'),
(5482, 'https://ror.org/00j9wfd65', 'no_lang_code', 1, 'https://ror.org/00j9wfd65 KGL Skin Study Center'),
(5483, 'https://ror.org/00ja2ye75', 'en', 1, 'https://ror.org/00ja2ye75 Salisbury NHS Foundation Trust'),
(5484, 'https://ror.org/00jb1kj74', 'no_lang_code', 1, 'https://ror.org/00jb1kj74 Sensonics International (United States)'),
(5485, 'https://ror.org/00jbe9340', 'nl', 1, 'https://ror.org/00jbe9340 Dienst voor Wetenschappelijke en Technische Informatie Scientific and Technical Information Service Service d''Information Scientifique et Technique'),
(5486, 'https://ror.org/00jbqdn84', 'en', 1, 'https://ror.org/00jbqdn84 Oglala Sioux Tribal Council'),
(5487, 'https://ror.org/00jc42j13', 'en', 1, 'https://ror.org/00jc42j13 Mississippi Sports Medicine and Orthopaedic Center'),
(5488, 'https://ror.org/00jeje538', 'no_lang_code', 1, 'https://ror.org/00jeje538 Comarch (Poland)'),
(5489, 'https://ror.org/00jg79r23', 'no_lang_code', 1, 'https://ror.org/00jg79r23 Information Ventures (United States)'),
(5490, 'https://ror.org/00jg7pf63', 'en', 1, 'https://ror.org/00jg7pf63 Iowa City VA Medical Research Foundation'),
(5491, 'https://ror.org/00jh0pg84', 'en', 1, 'https://ror.org/00jh0pg84 Algebra Project'),
(5492, 'https://ror.org/00jjs7680', 'en', 1, 'https://ror.org/00jjs7680 New Mexico Clinical Research & Osteoporosis Center'),
(5493, 'https://ror.org/00jm9xh53', 'no_lang_code', 1, 'https://ror.org/00jm9xh53 Otsu Municipal Hospital 大津市民病院'),
(5494, 'https://ror.org/00jse8x38', 'en', 1, 'https://ror.org/00jse8x38 National Quality Forum'),
(5495, 'https://ror.org/00jshg714', 'de', 1, 'https://ror.org/00jshg714 Klinikum Aschaffenburg'),
(5496, 'https://ror.org/00jtgnb29', 'en', 1, 'https://ror.org/00jtgnb29 American Board of Internal Medicine'),
(5497, 'https://ror.org/00jvgqq49', 'no_lang_code', 1, 'https://ror.org/00jvgqq49 Flexion Therapeutics (United States)'),
(5498, 'https://ror.org/00jx6qy10', 'en', 1, 'https://ror.org/00jx6qy10 Maulana Azad Institute of Dental Sciences'),
(5499, 'https://ror.org/00jz53350', 'no_lang_code', 1, 'https://ror.org/00jz53350 Centurion Biofuels (Canada)'),
(5500, 'https://ror.org/00k0t0t25', 'en', 1, 'https://ror.org/00k0t0t25 BC Centre for Aquatic Health Sciences'),
(5501, 'https://ror.org/00k0w7368', 'en', 1, 'https://ror.org/00k0w7368 Cooper Clinic'),
(5502, 'https://ror.org/00k1mwv09', 'en', 1, 'https://ror.org/00k1mwv09 United States Congress'),
(5503, 'https://ror.org/00k20np13', 'en', 1, 'https://ror.org/00k20np13 Austin Diagnostic Clinic'),
(5504, 'https://ror.org/00k59n723', 'en', 1, 'https://ror.org/00k59n723 South Dakota Academy of Science'),
(5505, 'https://ror.org/00k7h5c65', 'es', 1, 'https://ror.org/00k7h5c65 Instituto Nacional de Investigaciones Nucleares'),
(5506, 'https://ror.org/00k7znw93', 'no_lang_code', 1, 'https://ror.org/00k7znw93 5T Torino (Italy)'),
(5507, 'https://ror.org/00k8s2y27', 'en', 1, 'https://ror.org/00k8s2y27 Huntingdon College'),
(5508, 'https://ror.org/00kar4g50', 'fr', 1, 'https://ror.org/00kar4g50 Agence de Médecine Préventive'),
(5509, 'https://ror.org/00ke7zh37', 'en', 1, 'https://ror.org/00ke7zh37 American Federation of Mineralogical Societies'),
(5510, 'https://ror.org/00kftxm09', 'en', 1, 'https://ror.org/00kftxm09 Boreskov Institute of Catalysis, Institute of Catalysis Федеральное государственное бюджетное учреждение науки Институт катализа им. Г.К. Борескова Сибирского отделения Российской академии наук'),
(5511, 'https://ror.org/00kh6pc76', 'it', 1, 'https://ror.org/00kh6pc76 Consorzio Venezia Ricerche'),
(5512, 'https://ror.org/00kjr3917', 'en', 1, 'https://ror.org/00kjr3917 Ideon Science Park'),
(5513, 'https://ror.org/00kkwkq76', 'no_lang_code', 1, 'https://ror.org/00kkwkq76 Pfizer (Sweden)'),
(5514, 'https://ror.org/00kn43d12', 'en', 1, 'https://ror.org/00kn43d12 National Centre for Research'),
(5515, 'https://ror.org/00kpnax84', 'no_lang_code', 1, 'https://ror.org/00kpnax84 Heska (United States)'),
(5516, 'https://ror.org/00kq7a553', 'en', 1, 'https://ror.org/00kq7a553 Finlay Institute'),
(5517, 'https://ror.org/00ks5vt51', 'no_lang_code', 1, 'https://ror.org/00ks5vt51 ABB (Switzerland)'),
(5518, 'https://ror.org/00ktagp72', 'no_lang_code', 1, 'https://ror.org/00ktagp72 Seralogix (United States)'),
(5519, 'https://ror.org/00kv21794', 'en', 1, 'https://ror.org/00kv21794 Weil Institute of Critical Care Medicine'),
(5520, 'https://ror.org/00kv87w35', 'it', 1, 'https://ror.org/00kv87w35 Istituto Nazionale per le Malattie Infettive Lazzaro Spallanzani'),
(5521, 'https://ror.org/00kv9mr92', 'no_lang_code', 1, 'https://ror.org/00kv9mr92 Tri Y Environmental Research Institute (Canada)'),
(5522, 'https://ror.org/00kvx4h58', 'en', 1, 'https://ror.org/00kvx4h58 Council on Social Work Education'),
(5523, 'https://ror.org/00kx3fw88', 'es', 1, 'https://ror.org/00kx3fw88 Instituto Valenciano de Investigaciones Agrarias'),
(5524, 'https://ror.org/00ky71f04', 'en', 1, 'https://ror.org/00ky71f04 Clinical Orthopaedics and Related Research'),
(5525, 'https://ror.org/00kyj7k59', 'en', 1, 'https://ror.org/00kyj7k59 Fondation de recherches sur les blessures de la route Traffic Injury Research Foundation'),
(5526, 'https://ror.org/00kz7vp63', 'en', 1, 'https://ror.org/00kz7vp63 Cincinnati Museum Center'),
(5527, 'https://ror.org/00kzzgw26', 'en', 1, 'https://ror.org/00kzzgw26 Kennedy Center'),
(5528, 'https://ror.org/00m129932', 'en', 1, 'https://ror.org/00m129932 Center for Research and Technology Thessaly'),
(5529, 'https://ror.org/00m2wsh37', 'no_lang_code', 1, 'https://ror.org/00m2wsh37 PricewaterhouseCoopers (Canada)'),
(5530, 'https://ror.org/00m4h6p50', 'en', 1, 'https://ror.org/00m4h6p50 Mental Health Center of Denver'),
(5531, 'https://ror.org/00m6eb133', 'no_lang_code', 1, 'https://ror.org/00m6eb133 Custodix (Belgium)'),
(5532, 'https://ror.org/00m71bz66', 'it', 1, 'https://ror.org/00m71bz66 Fondazione Idis Città della Scienza'),
(5533, 'https://ror.org/00m79dm66', 'en', 1, 'https://ror.org/00m79dm66 Iona College'),
(5534, 'https://ror.org/00m7zwx79', 'en', 1, 'https://ror.org/00m7zwx79 Trinity Mother Frances Hospitals and Clinics'),
(5535, 'https://ror.org/00mamdf13', 'en', 1, 'https://ror.org/00mamdf13 Society for Advancement of Chicanos and Native Americans in Science'),
(5536, 'https://ror.org/00mgp8v69', 'en', 1, 'https://ror.org/00mgp8v69 Carter Center'),
(5537, 'https://ror.org/00mhxn926', 'en', 1, 'https://ror.org/00mhxn926 Comisión para la Seguridad de los Productos de Consumo de los Estados Unidos United States Consumer Product Safety Commission'),
(5538, 'https://ror.org/00mjs6x71', 'no_lang_code', 1, 'https://ror.org/00mjs6x71 Advanced Technology and Research Corporation (United States)'),
(5539, 'https://ror.org/00mkstx48', 'no_lang_code', 1, 'https://ror.org/00mkstx48 Grontmij (Denmark)'),
(5540, 'https://ror.org/00mktab21', 'no_lang_code', 1, 'https://ror.org/00mktab21 Virtalis (United Kingdom)'),
(5541, 'https://ror.org/00mmdnd52', 'en', 1, 'https://ror.org/00mmdnd52 Applied Computer Security Associates'),
(5542, 'https://ror.org/00mnwwq78', 'en', 1, 'https://ror.org/00mnwwq78 Wheelock College');
INSERT INTO `rors` VALUES
(5543, 'https://ror.org/00mp87510', 'no_lang_code', 1, 'https://ror.org/00mp87510 BPE Unternehmensbeteiligungen (Germany)'),
(5544, 'https://ror.org/00msez306', 'no_lang_code', 1, 'https://ror.org/00msez306 Superconductor Technologies (United States)'),
(5545, 'https://ror.org/00mv9dj85', 'en', 1, 'https://ror.org/00mv9dj85 American Academy of Neurology'),
(5546, 'https://ror.org/00mvwb842', 'en', 1, 'https://ror.org/00mvwb842 Neuropsychiatric Research Institute'),
(5547, 'https://ror.org/00mz09160', 'en', 1, 'https://ror.org/00mz09160 Itasca Community College'),
(5548, 'https://ror.org/00mzdcr22', 'no_lang_code', 1, 'https://ror.org/00mzdcr22 Giner (United States)'),
(5549, 'https://ror.org/00n158h85', 'en', 1, 'https://ror.org/00n158h85 American Aging Association'),
(5550, 'https://ror.org/00n208030', 'en', 1, 'https://ror.org/00n208030 St Mary''s University College'),
(5551, 'https://ror.org/00n2d9253', 'no_lang_code', 1, 'https://ror.org/00n2d9253 Veolia (Sweden)'),
(5552, 'https://ror.org/00n5vrh51', 'no_lang_code', 1, 'https://ror.org/00n5vrh51 Tioma Therapeutics (United States)'),
(5553, 'https://ror.org/00n6jcj93', 'it', 1, 'https://ror.org/00n6jcj93 Centro di Riferimento Oncologico della Basilicata'),
(5554, 'https://ror.org/00n6v1c97', 'no_lang_code', 1, 'https://ror.org/00n6v1c97 Bayer (Belgium)'),
(5555, 'https://ror.org/00n79r507', 'no_lang_code', 1, 'https://ror.org/00n79r507 Ambulatory Monitoring (United States)'),
(5556, 'https://ror.org/00n83m850', 'no_lang_code', 1, 'https://ror.org/00n83m850 EcoSynthetix (Canada)'),
(5557, 'https://ror.org/00n87rr37', 'en', 1, 'https://ror.org/00n87rr37 Danish Technological Institute'),
(5558, 'https://ror.org/00n8qbq54', 'no_lang_code', 1, 'https://ror.org/00n8qbq54 Meadowlark Optics (United States)'),
(5559, 'https://ror.org/00nahqd12', 'no_lang_code', 1, 'https://ror.org/00nahqd12 Continental (France)'),
(5560, 'https://ror.org/00nat9r59', 'no_lang_code', 1, 'https://ror.org/00nat9r59 Novozymes (United Kingdom)'),
(5561, 'https://ror.org/00nb5xj61', 'en', 1, 'https://ror.org/00nb5xj61 St. Andrews University'),
(5562, 'https://ror.org/00nb6mq69', 'en', 1, 'https://ror.org/00nb6mq69 Chulabhorn Research Institute สถาบันวิจัยจุฬาภรณ์'),
(5563, 'https://ror.org/00nbsvd35', 'no_lang_code', 1, 'https://ror.org/00nbsvd35 Vida Health Communications (United States)'),
(5564, 'https://ror.org/00nc89j94', 'en', 1, 'https://ror.org/00nc89j94 Australian Council of Learned Academies'),
(5565, 'https://ror.org/00ncer064', 'en', 1, 'https://ror.org/00ncer064 Women Medical College'),
(5566, 'https://ror.org/00new7409', 'en', 1, 'https://ror.org/00new7409 New York Structural Biology Center'),
(5567, 'https://ror.org/00nf8fy32', 'no_lang_code', 1, 'https://ror.org/00nf8fy32 Yamagata City Hospital Saiseikan 山形市立病院済生館'),
(5568, 'https://ror.org/00nfck739', 'no_lang_code', 1, 'https://ror.org/00nfck739 Thermo Fisher Scientific (Sweden)'),
(5569, 'https://ror.org/00ngjbr32', 'no_lang_code', 1, 'https://ror.org/00ngjbr32 Nokia (Spain)'),
(5570, 'https://ror.org/00nh64737', 'no_lang_code', 1, 'https://ror.org/00nh64737 PCAS (Canada)'),
(5571, 'https://ror.org/00nkkkz19', 'no_lang_code', 1, 'https://ror.org/00nkkkz19 CeramTec (Germany)'),
(5572, 'https://ror.org/00nkvag20', 'en', 1, 'https://ror.org/00nkvag20 Discovery Place'),
(5573, 'https://ror.org/00nm4jw86', 'en', 1, 'https://ror.org/00nm4jw86 Benjamin Rose Institute on Aging'),
(5574, 'https://ror.org/00nn73a81', 'es', 1, 'https://ror.org/00nn73a81 Centro Nacional de Información Geográfica'),
(5575, 'https://ror.org/00nnyvd56', 'en', 1, 'https://ror.org/00nnyvd56 National Research Institute of Chinese Medicine 國立中國醫藥研究所'),
(5576, 'https://ror.org/00np1gf38', 'en', 1, 'https://ror.org/00np1gf38 Philadelphia Fight'),
(5577, 'https://ror.org/00nqqvk19', 'en', 1, 'https://ror.org/00nqqvk19 COMSATS University Islamabad کومسٹس انسٹیٹیوٹ آف انفارمیشن ٹیکنالوجی'),
(5578, 'https://ror.org/00ns8qw04', 'en', 1, 'https://ror.org/00ns8qw04 Pushpawati Singhania Research Institute'),
(5579, 'https://ror.org/00nsrak45', 'no_lang_code', 1, 'https://ror.org/00nsrak45 Edge Enterprises (United States)'),
(5580, 'https://ror.org/00ntawd75', 'no_lang_code', 1, 'https://ror.org/00ntawd75 Aeiforia (Italy)'),
(5581, 'https://ror.org/00nv9r617', 'en', 1, 'https://ror.org/00nv9r617 College of Saint Rose'),
(5582, 'https://ror.org/00nvmqp29', 'no_lang_code', 1, 'https://ror.org/00nvmqp29 PlastiPure (United States)'),
(5583, 'https://ror.org/00nvy8497', 'en', 1, 'https://ror.org/00nvy8497 Australia and New Zealand Dialysis and Transplant Registry'),
(5584, 'https://ror.org/00nxp2634', 'fr', 1, 'https://ror.org/00nxp2634 Association de Coordination Technique Pour l''Industrie Agroalimentaire'),
(5585, 'https://ror.org/00nxxee52', 'no_lang_code', 1, 'https://ror.org/00nxxee52 HyperMed (United States)'),
(5586, 'https://ror.org/00p0qk069', 'en', 1, 'https://ror.org/00p0qk069 Center of Technology and Engineering for Nuclear Projects'),
(5587, 'https://ror.org/00p18zw56', 'en', 1, 'https://ror.org/00p18zw56 Alder Hey Children''s NHS Foundation Trust'),
(5588, 'https://ror.org/00p1cga29', 'en', 1, 'https://ror.org/00p1cga29 Austrian Society for Systems Engineering and Automation'),
(5589, 'https://ror.org/00p2bvc56', 'no_lang_code', 1, 'https://ror.org/00p2bvc56 Amphora NDT (United Kingdom)'),
(5590, 'https://ror.org/00p2bx870', 'en', 1, 'https://ror.org/00p2bx870 Environment Agency Abu Dhabi هيئة البيئة'),
(5591, 'https://ror.org/00p4dsm08', 'en', 1, 'https://ror.org/00p4dsm08 Virus Unit'),
(5592, 'https://ror.org/00p511b69', 'en', 1, 'https://ror.org/00p511b69 Education Connection'),
(5593, 'https://ror.org/00p66nq73', 'no_lang_code', 1, 'https://ror.org/00p66nq73 Amphos 21 (Spain)'),
(5594, 'https://ror.org/00p7hvr94', 'no_lang_code', 1, 'https://ror.org/00p7hvr94 Agriculture Environmental Renewal Canada (Canada)'),
(5595, 'https://ror.org/00p7krt52', 'it', 1, 'https://ror.org/00p7krt52 Ospedale Civile di Giaveno'),
(5596, 'https://ror.org/00p8tz706', 'en', 1, 'https://ror.org/00p8tz706 Desert Botanical Garden'),
(5597, 'https://ror.org/00p9rsf63', 'no_lang_code', 1, 'https://ror.org/00p9rsf63 Saaten Union (United Kingdom)'),
(5598, 'https://ror.org/00pbdx741', 'en', 1, 'https://ror.org/00pbdx741 Cape Shoulder Institute'),
(5599, 'https://ror.org/00pbjy126', 'no_lang_code', 1, 'https://ror.org/00pbjy126 EDJ Associates'),
(5600, 'https://ror.org/00pfggx80', 'no_lang_code', 1, 'https://ror.org/00pfggx80 Sainsbury''s (United Kingdom)'),
(5601, 'https://ror.org/00pfvfk73', 'en', 1, 'https://ror.org/00pfvfk73 Delaware Technical Community College'),
(5602, 'https://ror.org/00phd3t88', 'en', 1, 'https://ror.org/00phd3t88 Northwest Clinical Research Center'),
(5603, 'https://ror.org/00pke8311', 'en', 1, 'https://ror.org/00pke8311 Southern Arizona AIDS Foundation'),
(5604, 'https://ror.org/00pm9hx30', 'pt', 1, 'https://ror.org/00pm9hx30 Faculdade de Medicina de Marília Faculty of Medicine of Marília'),
(5605, 'https://ror.org/00pmfef67', 'en', 1, 'https://ror.org/00pmfef67 Camden County College'),
(5606, 'https://ror.org/00pmncr36', 'en', 1, 'https://ror.org/00pmncr36 Ohio Dominican University'),
(5607, 'https://ror.org/00pmt4r91', 'en', 1, 'https://ror.org/00pmt4r91 American Educational Research Association'),
(5608, 'https://ror.org/00ppb2x90', 'en', 1, 'https://ror.org/00ppb2x90 Concordia College - Minnesota'),
(5609, 'https://ror.org/00ppq4k21', 'en', 1, 'https://ror.org/00ppq4k21 Society of Toxicology'),
(5610, 'https://ror.org/00pq3bb48', 'no_lang_code', 1, 'https://ror.org/00pq3bb48 Grove Instruments (United States)'),
(5611, 'https://ror.org/00prce717', 'no_lang_code', 1, 'https://ror.org/00prce717 Daithi O’Murchu Marine Research Station'),
(5612, 'https://ror.org/00psab413', 'no_lang_code', 1, 'https://ror.org/00psab413 Eli Lilly (United Kingdom)'),
(5613, 'https://ror.org/00pvmkr98', 'en', 1, 'https://ror.org/00pvmkr98 Cornea Research Foundation of America'),
(5614, 'https://ror.org/00pwgnh47', 'en', 1, 'https://ror.org/00pwgnh47 Max Planck Institute of Colloids and Interfaces Max-Planck-Institut für Kolloid- und Grenzflächenforschung'),
(5615, 'https://ror.org/00pwjth19', 'en', 1, 'https://ror.org/00pwjth19 Yukon Kuskokwim Health Corporation'),
(5616, 'https://ror.org/00q0dz713', 'no_lang_code', 1, 'https://ror.org/00q0dz713 TeraView (United Kingdom)'),
(5617, 'https://ror.org/00q0yh079', 'pt', 1, 'https://ror.org/00q0yh079 Institute of Radiation Protection and Dosimetry Instituto de Radioproteção e Dosimetria'),
(5618, 'https://ror.org/00q1c3610', 'en', 1, 'https://ror.org/00q1c3610 Abisko Scientific Research Station'),
(5619, 'https://ror.org/00q2xhk98', 'no_lang_code', 1, 'https://ror.org/00q2xhk98 Murty Pharmaceuticals (United States)'),
(5620, 'https://ror.org/00q2yft10', 'no_lang_code', 1, 'https://ror.org/00q2yft10 Leap of Faith Technologies (United States)'),
(5621, 'https://ror.org/00q3rb237', 'no_lang_code', 1, 'https://ror.org/00q3rb237 Larus Technologies (Canada)'),
(5622, 'https://ror.org/00q545m27', 'no_lang_code', 1, 'https://ror.org/00q545m27 Campden BRI (United Kingdom)'),
(5623, 'https://ror.org/00q5a4y91', 'no_lang_code', 1, 'https://ror.org/00q5a4y91 Innovative Targeting Solutions (Canada)'),
(5624, 'https://ror.org/00q62jx03', 'no_lang_code', 1, 'https://ror.org/00q62jx03 23andMe (United States)'),
(5625, 'https://ror.org/00q67qp92', 'es', 1, 'https://ror.org/00q67qp92 Fundación Cardiovascular de Colombia'),
(5626, 'https://ror.org/00q6d2f90', 'pt', 1, 'https://ror.org/00q6d2f90 Agencia Regional da Energia e Ambiente da Regiao Autonoma da Madeira Regional Agency for Energy and Environment of the Autonomous Region of Madeira'),
(5627, 'https://ror.org/00q6hxz03', 'no_lang_code', 1, 'https://ror.org/00q6hxz03 AST Products (United States)'),
(5628, 'https://ror.org/00q72x252', 'en', 1, 'https://ror.org/00q72x252 Committee on Climate Change'),
(5629, 'https://ror.org/00q873a22', 'en', 1, 'https://ror.org/00q873a22 County of Mendocino'),
(5630, 'https://ror.org/00q9afj63', 'no_lang_code', 1, 'https://ror.org/00q9afj63 ARTSCO (United States)'),
(5631, 'https://ror.org/00q9fjw02', 'no_lang_code', 1, 'https://ror.org/00q9fjw02 ECI Biotech (United States)'),
(5632, 'https://ror.org/00qcr4910', 'no_lang_code', 1, 'https://ror.org/00qcr4910 Atkins (United Kingdom)'),
(5633, 'https://ror.org/00qd3cs31', 'no_lang_code', 1, 'https://ror.org/00qd3cs31 Dimos Athinaion Epicheirisi Michanografisis (Greece)'),
(5634, 'https://ror.org/00qd6sx31', 'no_lang_code', 1, 'https://ror.org/00qd6sx31 Orphagen Pharmaceuticals (United States)'),
(5635, 'https://ror.org/00qd89360', 'no_lang_code', 1, 'https://ror.org/00qd89360 PicoCal (United States)'),
(5636, 'https://ror.org/00qed5764', 'en', 1, 'https://ror.org/00qed5764 Plant Biotechnology Institute'),
(5637, 'https://ror.org/00qeks103', 'en', 1, 'https://ror.org/00qeks103 Chris O’Brien Lifehouse'),
(5638, 'https://ror.org/00qfg4234', 'no_lang_code', 1, 'https://ror.org/00qfg4234 Vcom3D (United States)'),
(5639, 'https://ror.org/00qfz3b98', 'no_lang_code', 1, 'https://ror.org/00qfz3b98 Elsoms (United Kingdom)'),
(5640, 'https://ror.org/00qjbvq93', 'no_lang_code', 1, 'https://ror.org/00qjbvq93 Actelion (United States)'),
(5641, 'https://ror.org/00qmxzv90', 'en', 1, 'https://ror.org/00qmxzv90 Nordic Folkecenter for Renewable Energy'),
(5642, 'https://ror.org/00qp2dq07', 'nl', 1, 'https://ror.org/00qp2dq07 Sticares InterACT'),
(5643, 'https://ror.org/00qprmt30', 'no_lang_code', 1, 'https://ror.org/00qprmt30 Atactic Technologies (United States)'),
(5644, 'https://ror.org/00qq2kd97', 'no_lang_code', 1, 'https://ror.org/00qq2kd97 Mikro Systems (United States)'),
(5645, 'https://ror.org/00qs2ka20', 'en', 1, 'https://ror.org/00qs2ka20 East Los Angeles College'),
(5646, 'https://ror.org/00qsgpr41', 'no_lang_code', 1, 'https://ror.org/00qsgpr41 ElectroChem (United States)'),
(5647, 'https://ror.org/00qsswh65', 'no_lang_code', 1, 'https://ror.org/00qsswh65 Edif Group (United Kingdom)'),
(5648, 'https://ror.org/00qszmz13', 'no_lang_code', 1, 'https://ror.org/00qszmz13 Ion Beam Applications (United States)'),
(5649, 'https://ror.org/00qt7y372', 'no_lang_code', 1, 'https://ror.org/00qt7y372 Biozoon (Germany)'),
(5650, 'https://ror.org/00qxhe741', 'no_lang_code', 1, 'https://ror.org/00qxhe741 Techshot (United States)'),
(5651, 'https://ror.org/00qxqw753', 'en', 1, 'https://ror.org/00qxqw753 San Mateo County Community College District'),
(5652, 'https://ror.org/00qytmr47', 'no_lang_code', 1, 'https://ror.org/00qytmr47 INC Research (United States)'),
(5653, 'https://ror.org/00r06ws05', 'en', 1, 'https://ror.org/00r06ws05 Club Young Scientists'),
(5654, 'https://ror.org/00r0jqe29', 'en', 1, 'https://ror.org/00r0jqe29 British Science Association'),
(5655, 'https://ror.org/00r1m3r97', 'no_lang_code', 1, 'https://ror.org/00r1m3r97 Contento Trade (Italy)'),
(5656, 'https://ror.org/00r2h0609', 'en', 1, 'https://ror.org/00r2h0609 Washington County Youth Service Bureau'),
(5657, 'https://ror.org/00r2t6515', 'en', 1, 'https://ror.org/00r2t6515 Baranov Central Institute of Aviation Motor Development Центральный институт авиационного моторостроения им. П.И. Баранова'),
(5658, 'https://ror.org/00r3xw008', 'en', 1, 'https://ror.org/00r3xw008 Michigan Headache and Neurological Institute'),
(5659, 'https://ror.org/00r5t2s16', 'en', 1, 'https://ror.org/00r5t2s16 Europdonor Foundation'),
(5660, 'https://ror.org/00r633h38', 'no_lang_code', 1, 'https://ror.org/00r633h38 Centro Radiológico Computarizado Corporació Sanitària (Spain)'),
(5661, 'https://ror.org/00r6a8318', 'en', 1, 'https://ror.org/00r6a8318 Center for Community Alternatives'),
(5662, 'https://ror.org/00r8j9489', 'no_lang_code', 1, 'https://ror.org/00r8j9489 Thales (United Kingdom)'),
(5663, 'https://ror.org/00raa0r66', 'en', 1, 'https://ror.org/00raa0r66 Women''s Hospital'),
(5664, 'https://ror.org/00rbdbh54', 'no_lang_code', 1, 'https://ror.org/00rbdbh54 Orbital Research (United States)'),
(5665, 'https://ror.org/00rbrz089', 'en', 1, 'https://ror.org/00rbrz089 Mental Health Association of Southeastern Pennsylvania'),
(5666, 'https://ror.org/00rch4x96', 'no_lang_code', 1, 'https://ror.org/00rch4x96 ImmunoPrecise (Canada)'),
(5667, 'https://ror.org/00reard48', 'en', 1, 'https://ror.org/00reard48 Agency for Science, Innovation and Technology'),
(5668, 'https://ror.org/00reyxa23', 'no_lang_code', 1, 'https://ror.org/00reyxa23 Cenix BioScience (Germany)'),
(5669, 'https://ror.org/00rgbr518', 'en', 1, 'https://ror.org/00rgbr518 Miami Dade College'),
(5670, 'https://ror.org/00rhaks72', 'no_lang_code', 1, 'https://ror.org/00rhaks72 Tracer Technologies (United States)'),
(5671, 'https://ror.org/00rk1k743', 'en', 1, 'https://ror.org/00rk1k743 Cuban Neuroscience Center'),
(5672, 'https://ror.org/00rkhrg48', 'no_lang_code', 1, 'https://ror.org/00rkhrg48 Synta Pharmaceuticals (United States)'),
(5673, 'https://ror.org/00rpbf348', 'no_lang_code', 1, 'https://ror.org/00rpbf348 Guru Nanak Eye Centre'),
(5674, 'https://ror.org/00rpwqe82', 'no_lang_code', 1, 'https://ror.org/00rpwqe82 NYSERNet (United States)'),
(5675, 'https://ror.org/00rqgsb54', 'no_lang_code', 1, 'https://ror.org/00rqgsb54 Cyberkinetics (United States)'),
(5676, 'https://ror.org/00rqtg495', 'en', 1, 'https://ror.org/00rqtg495 American Association for Dental Research'),
(5677, 'https://ror.org/00rrzkj76', 'no_lang_code', 1, 'https://ror.org/00rrzkj76 Sorbent Technologies (United States)'),
(5678, 'https://ror.org/00rsqd019', 'no_lang_code', 1, 'https://ror.org/00rsqd019 Toyokawa City Hospital 豊川市民病院'),
(5679, 'https://ror.org/00rt47041', 'no_lang_code', 1, 'https://ror.org/00rt47041 Vidasym (United States)'),
(5680, 'https://ror.org/00s2dqx11', 'en', 1, 'https://ror.org/00s2dqx11 Indian Institute of Horticultural Research'),
(5681, 'https://ror.org/00s3ndx20', 'no_lang_code', 1, 'https://ror.org/00s3ndx20 Innovative Surface Technologies (United States)'),
(5682, 'https://ror.org/00s5h6z84', 'no_lang_code', 1, 'https://ror.org/00s5h6z84 INVIDI Technologies (Canada)'),
(5683, 'https://ror.org/00s5kep86', 'en', 1, 'https://ror.org/00s5kep86 Society for Risk Analysis'),
(5684, 'https://ror.org/00s7dq077', 'en', 1, 'https://ror.org/00s7dq077 Arctic Research Consortium of the United States'),
(5685, 'https://ror.org/00s8fdk31', 'no_lang_code', 1, 'https://ror.org/00s8fdk31 Decom (Slovakia)'),
(5686, 'https://ror.org/00s9ea398', 'no_lang_code', 1, 'https://ror.org/00s9ea398 Asahi Chemical & Industry (Japan)'),
(5687, 'https://ror.org/00s9hg791', 'en', 1, 'https://ror.org/00s9hg791 Polisher Research Institute'),
(5688, 'https://ror.org/00s9v1h75', 'en', 1, 'https://ror.org/00s9v1h75 European Centre for Disease Prevention and Control Europeiskt centrum för förebyggande och kontroll av sjukdomar'),
(5689, 'https://ror.org/00sbyns81', 'en', 1, 'https://ror.org/00sbyns81 Miwa Hospital 三輪病院'),
(5690, 'https://ror.org/00scjnx30', 'en', 1, 'https://ror.org/00scjnx30 Theiss Research'),
(5691, 'https://ror.org/00sda2672', 'en', 1, 'https://ror.org/00sda2672 Edward Via College of Osteopathic Medicine'),
(5692, 'https://ror.org/00sdy7y63', 'en', 1, 'https://ror.org/00sdy7y63 Center for Innovative Public Health Research'),
(5693, 'https://ror.org/00sehw297', 'no_lang_code', 1, 'https://ror.org/00sehw297 Beactica (Sweden)'),
(5694, 'https://ror.org/00sf3p382', 'no_lang_code', 1, 'https://ror.org/00sf3p382 Turner Consulting Group (United States)'),
(5695, 'https://ror.org/00shfde47', 'no_lang_code', 1, 'https://ror.org/00shfde47 Orkla (Sweden)'),
(5696, 'https://ror.org/00shfq002', 'no_lang_code', 1, 'https://ror.org/00shfq002 Syngenta (United States)'),
(5697, 'https://ror.org/00shs7b79', 'en', 1, 'https://ror.org/00shs7b79 Northern Ohio Recovery Association'),
(5698, 'https://ror.org/00shv0x82', 'en', 1, 'https://ror.org/00shv0x82 Deutsches Rheuma-Forschungszentrum Berlin German Rheumatism Research Centre'),
(5699, 'https://ror.org/00shwmt46', 'no_lang_code', 1, 'https://ror.org/00shwmt46 Precision Therapeutics (United States)'),
(5700, 'https://ror.org/00sj7sn30', 'pt', 1, 'https://ror.org/00sj7sn30 Prefeitura da Cidade do Rio de Janeiro'),
(5701, 'https://ror.org/00skncc61', 'en', 1, 'https://ror.org/00skncc61 Institute For Ecology of Industrial Areas Instytut Ekologii Terenów Uprzemysłowionych'),
(5702, 'https://ror.org/00smdp487', 'no_lang_code', 1, 'https://ror.org/00smdp487 Munich Leukemia Laboratory (Germany) Münchner Leukämielabor'),
(5703, 'https://ror.org/00sn0hb87', 'no_lang_code', 1, 'https://ror.org/00sn0hb87 Wavetrend (United Kingdom)'),
(5704, 'https://ror.org/00sqdq844', 'en', 1, 'https://ror.org/00sqdq844 National Committee for Quality Assurance'),
(5705, 'https://ror.org/00ssxa384', 'no_lang_code', 1, 'https://ror.org/00ssxa384 Eclexys (Switzerland)'),
(5706, 'https://ror.org/00st10308', 'no_lang_code', 1, 'https://ror.org/00st10308 Behavioral Assessment Incorporation (United States)'),
(5707, 'https://ror.org/00stexf29', 'no_lang_code', 1, 'https://ror.org/00stexf29 Alstom (Germany)'),
(5708, 'https://ror.org/00sty4r04', 'no_lang_code', 1, 'https://ror.org/00sty4r04 Colibri Technologies (Canada)'),
(5709, 'https://ror.org/00svj4w50', 'no_lang_code', 1, 'https://ror.org/00svj4w50 ANA Aeroportos de Portugal (Portugal)'),
(5710, 'https://ror.org/00swfce58', 'it', 1, 'https://ror.org/00swfce58 Ospedale di Rivoli'),
(5711, 'https://ror.org/00t00te02', 'no_lang_code', 1, 'https://ror.org/00t00te02 Ford Motor Company (United Kingdom)'),
(5712, 'https://ror.org/00t0fph81', 'no_lang_code', 1, 'https://ror.org/00t0fph81 HealthSim (United States)'),
(5713, 'https://ror.org/00t0n1q40', 'en', 1, 'https://ror.org/00t0n1q40 National Network of Public Health Institutes'),
(5714, 'https://ror.org/00t0z3q71', 'es', 1, 'https://ror.org/00t0z3q71 Hospital del Tórax Instituto Nacional del Tórax'),
(5715, 'https://ror.org/00t3pr326', 'en', 1, 'https://ror.org/00t3pr326 British Council'),
(5716, 'https://ror.org/00t3x1b09', 'no_lang_code', 1, 'https://ror.org/00t3x1b09 Bioazul (Spain)'),
(5717, 'https://ror.org/00t6e2695', 'no_lang_code', 1, 'https://ror.org/00t6e2695 Emerson (United Kingdom)'),
(5718, 'https://ror.org/00t6yjn93', 'en', 1, 'https://ror.org/00t6yjn93 Africare'),
(5719, 'https://ror.org/00t7c0489', 'en', 1, 'https://ror.org/00t7c0489 Institute for Biological Sciences'),
(5720, 'https://ror.org/00t8xfq63', 'es', 1, 'https://ror.org/00t8xfq63 Center for Scientific Studies Centro de Estudios Científicos'),
(5721, 'https://ror.org/00tb5pg67', 'en', 1, 'https://ror.org/00tb5pg67 Emory Clinic'),
(5722, 'https://ror.org/00tbsgb37', 'no_lang_code', 1, 'https://ror.org/00tbsgb37 PAI Life Sciences (United States)'),
(5723, 'https://ror.org/00tcb9k97', 'en', 1, 'https://ror.org/00tcb9k97 New York Eye and Ear Infirmary'),
(5724, 'https://ror.org/00tdrjp82', 'en', 1, 'https://ror.org/00tdrjp82 Arizona Heart Institute'),
(5725, 'https://ror.org/00tg1mz65', 'en', 1, 'https://ror.org/00tg1mz65 Porter Brook Medical Centre'),
(5726, 'https://ror.org/00tgj2z09', 'en', 1, 'https://ror.org/00tgj2z09 Association of Information Technology Companies of Northern Greece'),
(5727, 'https://ror.org/00tgps059', 'no_lang_code', 1, 'https://ror.org/00tgps059 Novosibirsk Institute of Organic Chemistry Историческая справка НИОХ'),
(5728, 'https://ror.org/00tgygn49', 'en', 1, 'https://ror.org/00tgygn49 San Antonio Fighting Back'),
(5729, 'https://ror.org/00thykc36', 'en', 1, 'https://ror.org/00thykc36 American Nurses Credentialing Center'),
(5730, 'https://ror.org/00tjjak64', 'en', 1, 'https://ror.org/00tjjak64 Centexbel'),
(5731, 'https://ror.org/00tjkp068', 'no_lang_code', 1, 'https://ror.org/00tjkp068 SimBiotic Software (United States)'),
(5732, 'https://ror.org/00tm6q440', 'no_lang_code', 1, 'https://ror.org/00tm6q440 DeskArtes (Finland)'),
(5733, 'https://ror.org/00tq8h369', 'no_lang_code', 1, 'https://ror.org/00tq8h369 Elisa (Finland)'),
(5734, 'https://ror.org/00tqnwm57', 'en', 1, 'https://ror.org/00tqnwm57 Organisation mondiale de la santé World Health Organization - Denmark Всемирная организация здравоохранения'),
(5735, 'https://ror.org/00trk2663', 'no_lang_code', 1, 'https://ror.org/00trk2663 PTAC (United States)'),
(5736, 'https://ror.org/00trnhw76', 'en', 1, 'https://ror.org/00trnhw76 Tongde Hospital of Zhejiang Province 浙江省立同德医院'),
(5737, 'https://ror.org/00tvt5664', 'en', 1, 'https://ror.org/00tvt5664 Croatian Institute of Transfusion Medicine Hrvatski Zavod za Transfuzijsku Medicinu'),
(5738, 'https://ror.org/00twdh217', 'no_lang_code', 1, 'https://ror.org/00twdh217 Clarovita Nutrition (Canada)'),
(5739, 'https://ror.org/00txp6z67', 'en', 1, 'https://ror.org/00txp6z67 Prairie Agricultural Machinery Institute'),
(5740, 'https://ror.org/00tye4g05', 'en', 1, 'https://ror.org/00tye4g05 Richmond Community College'),
(5741, 'https://ror.org/00tyzcb87', 'no_lang_code', 1, 'https://ror.org/00tyzcb87 Bureau van Dijk (Belgium)'),
(5742, 'https://ror.org/00tz9e151', 'en', 1, 'https://ror.org/00tz9e151 Bakersfield College'),
(5743, 'https://ror.org/00tzw6r97', 'no_lang_code', 1, 'https://ror.org/00tzw6r97 RC Electronics (United States)'),
(5744, 'https://ror.org/00v1wt879', 'es', 1, 'https://ror.org/00v1wt879 National Transplant Organization Organización Nacional de Trasplantes'),
(5745, 'https://ror.org/00v315t24', 'no_lang_code', 1, 'https://ror.org/00v315t24 Biopsy Sciences (United States)'),
(5746, 'https://ror.org/00v47pv90', 'en', 1, 'https://ror.org/00v47pv90 Baptist Health South Florida'),
(5747, 'https://ror.org/00v6jq438', 'no_lang_code', 1, 'https://ror.org/00v6jq438 Cytograft Tissue Engineering (United States)'),
(5748, 'https://ror.org/00v97d044', 'pt', 1, 'https://ror.org/00v97d044 Centre of Studies on Geography and Spatial Planning Centro de Estudos em Geografia e Ordenamento do Territorio'),
(5749, 'https://ror.org/00vade776', 'en', 1, 'https://ror.org/00vade776 Public Health Management Corporation'),
(5750, 'https://ror.org/00vcg0k36', 'en', 1, 'https://ror.org/00vcg0k36 EASN Technology Innovation Services BVBA'),
(5751, 'https://ror.org/00vcszp55', 'en', 1, 'https://ror.org/00vcszp55 Arizona Geological Survey'),
(5752, 'https://ror.org/00vcvf072', 'en', 1, 'https://ror.org/00vcvf072 Foundation for Advancements in Science and Education'),
(5753, 'https://ror.org/00vcvx959', 'es', 1, 'https://ror.org/00vcvx959 Forem'),
(5754, 'https://ror.org/00vev3847', 'no_lang_code', 1, 'https://ror.org/00vev3847 Marker Gene Technologies (United States)'),
(5755, 'https://ror.org/00vfssf38', 'en', 1, 'https://ror.org/00vfssf38 Franklin County Genealogical & Historical Society'),
(5756, 'https://ror.org/00vfty314', 'en', 1, 'https://ror.org/00vfty314 National Institute of Pathology'),
(5757, 'https://ror.org/00vhf1v57', 'fr', 1, 'https://ror.org/00vhf1v57 Centre Hospitalier Universitaire de Tokoin'),
(5758, 'https://ror.org/00vhfbm88', 'en', 1, 'https://ror.org/00vhfbm88 Edmonds Community College'),
(5759, 'https://ror.org/00vhzxs21', 'no_lang_code', 1, 'https://ror.org/00vhzxs21 Immusoft (United States)'),
(5760, 'https://ror.org/00vj57q03', 'en', 1, 'https://ror.org/00vj57q03 California Western School of Law'),
(5761, 'https://ror.org/00vnwz606', 'en', 1, 'https://ror.org/00vnwz606 Dudley Observatory'),
(5762, 'https://ror.org/00vr3xw76', 'en', 1, 'https://ror.org/00vr3xw76 Laser and Skin Surgery Center of Indiana'),
(5763, 'https://ror.org/00vrz7m04', 'no_lang_code', 1, 'https://ror.org/00vrz7m04 Aronora (United States)'),
(5764, 'https://ror.org/00vvheq07', 'en', 1, 'https://ror.org/00vvheq07 Community Anti Drug Coalitions of America'),
(5765, 'https://ror.org/00vvr2385', 'no_lang_code', 1, 'https://ror.org/00vvr2385 Agora Systems (Spain)'),
(5766, 'https://ror.org/00vzqmg54', 'en', 1, 'https://ror.org/00vzqmg54 Elizabeth Glaser Pediatric AIDS Foundation'),
(5767, 'https://ror.org/00w0s7f65', 'no_lang_code', 1, 'https://ror.org/00w0s7f65 Apex Biomedical (United States)'),
(5768, 'https://ror.org/00w1epr46', 'en', 1, 'https://ror.org/00w1epr46 RG Stone Urology & Laparoscopy Hospital आरजी स्टोन यूरोलॉजी और लैप्रोस्कोपी अस्पताल'),
(5769, 'https://ror.org/00w230w05', 'no_lang_code', 1, 'https://ror.org/00w230w05 Vical (United States)'),
(5770, 'https://ror.org/00w2qec28', 'no_lang_code', 1, 'https://ror.org/00w2qec28 6WIND (France)'),
(5771, 'https://ror.org/00w2xsv89', 'no_lang_code', 1, 'https://ror.org/00w2xsv89 Advanced MRI Technologies (United States)'),
(5772, 'https://ror.org/00w3hap50', 'pl', 1, 'https://ror.org/00w3hap50 Institute of Nuclear Chemistry and Technology Instytut Chemii i Techniki Jądrowej'),
(5773, 'https://ror.org/00w3w6d37', 'en', 1, 'https://ror.org/00w3w6d37 Great Lakes Inter Tribal Council'),
(5774, 'https://ror.org/00w4g1w45', 'en', 1, 'https://ror.org/00w4g1w45 Coalition for a Drug Free Hawaii'),
(5775, 'https://ror.org/00w5rhv83', 'en', 1, 'https://ror.org/00w5rhv83 EdLab Group'),
(5776, 'https://ror.org/00w7yp275', 'en', 1, 'https://ror.org/00w7yp275 Mississippi School for Mathematics and Science'),
(5777, 'https://ror.org/00w8fet54', 'no_lang_code', 1, 'https://ror.org/00w8fet54 Kane Biotech (Canada)'),
(5778, 'https://ror.org/00w9zab79', 'en', 1, 'https://ror.org/00w9zab79 New Mexico Resonance'),
(5779, 'https://ror.org/00wbcgc67', 'no_lang_code', 1, 'https://ror.org/00wbcgc67 Johnson Matthey (United States)'),
(5780, 'https://ror.org/00wbv7962', 'no_lang_code', 1, 'https://ror.org/00wbv7962 Environmental Consultants and Contractors'),
(5781, 'https://ror.org/00wc5s136', 'en', 1, 'https://ror.org/00wc5s136 Mount Marty College'),
(5782, 'https://ror.org/00wc6ay63', 'no_lang_code', 1, 'https://ror.org/00wc6ay63 KCI (United States)'),
(5783, 'https://ror.org/00wcjep87', 'no_lang_code', 1, 'https://ror.org/00wcjep87 Genlantis (United States)'),
(5784, 'https://ror.org/00wg15m47', 'no_lang_code', 1, 'https://ror.org/00wg15m47 Menssana Research (United States)'),
(5785, 'https://ror.org/00wg9xe54', 'en', 1, 'https://ror.org/00wg9xe54 Chemical Diversity Research Institute Исследовательский Институт Химического Разнообразия'),
(5786, 'https://ror.org/00wkay776', 'en', 1, 'https://ror.org/00wkay776 Carthage College'),
(5787, 'https://ror.org/00wkf3d94', 'no_lang_code', 1, 'https://ror.org/00wkf3d94 Quintessence Biosciences (United States)'),
(5788, 'https://ror.org/00wph9g26', 'no_lang_code', 1, 'https://ror.org/00wph9g26 Electronic BioSciences (United States)'),
(5789, 'https://ror.org/00wqtx630', 'en', 1, 'https://ror.org/00wqtx630 South Carolina Technical College System'),
(5790, 'https://ror.org/00wrset74', 'no_lang_code', 1, 'https://ror.org/00wrset74 Tejas Networks (India)'),
(5791, 'https://ror.org/00wscys22', 'no_lang_code', 1, 'https://ror.org/00wscys22 Innovhub (Italy)'),
(5792, 'https://ror.org/00wxh7d23', 'no_lang_code', 1, 'https://ror.org/00wxh7d23 Catator (Sweden)'),
(5793, 'https://ror.org/00wydxq38', 'pt', 1, 'https://ror.org/00wydxq38 Associacao Protectora dos Diabeticos de Portugal'),
(5794, 'https://ror.org/00x0e3e82', 'fr', 1, 'https://ror.org/00x0e3e82 Institut Régional de Médecine Physique et de Réadaptation'),
(5795, 'https://ror.org/00x19de83', 'en', 1, 'https://ror.org/00x19de83 International Centers for Excellence in Research'),
(5796, 'https://ror.org/00x2ve368', 'en', 1, 'https://ror.org/00x2ve368 Tourette Association of America'),
(5797, 'https://ror.org/00x3r9n64', 'en', 1, 'https://ror.org/00x3r9n64 Nezhat Medical Center'),
(5798, 'https://ror.org/00x489z61', 'pt', 1, 'https://ror.org/00x489z61 Instituto Geográfico Português'),
(5799, 'https://ror.org/00x5dwt18', 'no_lang_code', 1, 'https://ror.org/00x5dwt18 CARSA (Spain)'),
(5800, 'https://ror.org/00x5q3m40', 'fr', 1, 'https://ror.org/00x5q3m40 Institut Calot'),
(5801, 'https://ror.org/00x8ee082', 'it', 1, 'https://ror.org/00x8ee082 Ospedale Civile Edoardo Agnelli'),
(5802, 'https://ror.org/00xa0jd95', 'no_lang_code', 1, 'https://ror.org/00xa0jd95 Oralys (Canada)'),
(5803, 'https://ror.org/00xbray82', 'no_lang_code', 1, 'https://ror.org/00xbray82 CSK Food Enrichment (Netherlands)'),
(5804, 'https://ror.org/00xdqtv86', 'en', 1, 'https://ror.org/00xdqtv86 Association of Health Care Journalists'),
(5805, 'https://ror.org/00xe5zs60', 'en', 1, 'https://ror.org/00xe5zs60 Birmingham Women''s Hospital'),
(5806, 'https://ror.org/00xgy0333', 'en', 1, 'https://ror.org/00xgy0333 Tanzania Food and Nutrition Center'),
(5807, 'https://ror.org/00xh1ah97', 'en', 1, 'https://ror.org/00xh1ah97 Child Trends'),
(5808, 'https://ror.org/00xh22n12', 'en', 1, 'https://ror.org/00xh22n12 Czech Environmental Information Agency'),
(5809, 'https://ror.org/00xhxz289', 'en', 1, 'https://ror.org/00xhxz289 American Society for Pharmacology and Experimental Therapeutics'),
(5810, 'https://ror.org/00xkqe770', 'en', 1, 'https://ror.org/00xkqe770 Epsom and St Helier University Hospitals NHS Trust'),
(5811, 'https://ror.org/00xkqq585', 'en', 1, 'https://ror.org/00xkqq585 Our Lady of Lourdes Regional Medical Center'),
(5812, 'https://ror.org/00xms2e58', 'en', 1, 'https://ror.org/00xms2e58 Hudson Valley Regional Emergency Medical Services Council'),
(5813, 'https://ror.org/00xmtrb24', 'no_lang_code', 1, 'https://ror.org/00xmtrb24 LC Resources (United States)'),
(5814, 'https://ror.org/00xpr6w96', 'en', 1, 'https://ror.org/00xpr6w96 Hough Ear Institute'),
(5815, 'https://ror.org/00xq5mb92', 'no_lang_code', 1, 'https://ror.org/00xq5mb92 Color Line (Norway)'),
(5816, 'https://ror.org/00xspzv28', 'en', 1, 'https://ror.org/00xspzv28 Ohio Department of Agriculture'),
(5817, 'https://ror.org/00xw3wc12', 'no_lang_code', 1, 'https://ror.org/00xw3wc12 RxBio (United States)'),
(5818, 'https://ror.org/00xwgwv92', 'no_lang_code', 1, 'https://ror.org/00xwgwv92 Kelly Services (United States)'),
(5819, 'https://ror.org/00xwww266', 'no_lang_code', 1, 'https://ror.org/00xwww266 Aeon Imaging (United States)'),
(5820, 'https://ror.org/00xx9yn39', 'en', 1, 'https://ror.org/00xx9yn39 Fatima Jinnah Dental College'),
(5821, 'https://ror.org/00xya3a34', 'en', 1, 'https://ror.org/00xya3a34 La Société royale du Canada Royal Society of Canada'),
(5822, 'https://ror.org/00y022594', 'en', 1, 'https://ror.org/00y022594 Eye and Ear Foundation'),
(5823, 'https://ror.org/00y112q62', 'en', 1, 'https://ror.org/00y112q62 Wrightington Hospital'),
(5824, 'https://ror.org/00y1ttm22', 'no_lang_code', 1, 'https://ror.org/00y1ttm22 Merck (France)'),
(5825, 'https://ror.org/00y93ak93', 'en', 1, 'https://ror.org/00y93ak93 Shepherd University'),
(5826, 'https://ror.org/00yascf89', 'no_lang_code', 1, 'https://ror.org/00yascf89 Intertek (Canada)'),
(5827, 'https://ror.org/00yb09x74', 'en', 1, 'https://ror.org/00yb09x74 Informed Families'),
(5828, 'https://ror.org/00ycg6x55', 'en', 1, 'https://ror.org/00ycg6x55 National Association for Biomedical Research'),
(5829, 'https://ror.org/00yd9m083', 'it', 1, 'https://ror.org/00yd9m083 Istituto Nazionale di Ricerca per gli Alimenti e la Nutrizione'),
(5830, 'https://ror.org/00yfcva70', 'en', 1, 'https://ror.org/00yfcva70 AeroSpace and Defence Industries Association of Europe'),
(5831, 'https://ror.org/00yn4km03', 'en', 1, 'https://ror.org/00yn4km03 Worthing Hospital'),
(5832, 'https://ror.org/00ys1w968', 'no_lang_code', 1, 'https://ror.org/00ys1w968 AccelLab (Canada)'),
(5833, 'https://ror.org/00ysjm146', 'en', 1, 'https://ror.org/00ysjm146 Mission to the Street for Christ'),
(5834, 'https://ror.org/00yt6w794', 'no_lang_code', 1, 'https://ror.org/00yt6w794 Sierra Nevada Corporation (United States)'),
(5835, 'https://ror.org/00ytr4473', 'no_lang_code', 1, 'https://ror.org/00ytr4473 Opmedic Group (Canada)'),
(5836, 'https://ror.org/00yy85n18', 'en', 1, 'https://ror.org/00yy85n18 College of St. Scholastica'),
(5837, 'https://ror.org/00yzb1d91', 'en', 1, 'https://ror.org/00yzb1d91 Wyckoff Heights Medical Center'),
(5838, 'https://ror.org/00z0d6447', 'no_lang_code', 1, 'https://ror.org/00z0d6447 Kikkoman (Japan) キッコーマン株式会社'),
(5839, 'https://ror.org/00z20c921', 'en', 1, 'https://ror.org/00z20c921 Harper Adams University'),
(5840, 'https://ror.org/00z21v095', 'no_lang_code', 1, 'https://ror.org/00z21v095 Abbott (Canada)'),
(5841, 'https://ror.org/00z7n1h55', 'en', 1, 'https://ror.org/00z7n1h55 State Research Center of Virology and Biotechnology VECTOR Федеральное бюджетное учреждение науки Государственный научный центр вирусологии и биотехнологии Вектор'),
(5842, 'https://ror.org/00z7pm351', 'no_lang_code', 1, 'https://ror.org/00z7pm351 Advanced Photonic Crystals (United States)'),
(5843, 'https://ror.org/00zbjch89', 'no_lang_code', 1, 'https://ror.org/00zbjch89 Beacon Tech (Israel)'),
(5844, 'https://ror.org/00zcam334', 'no_lang_code', 1, 'https://ror.org/00zcam334 Clancy Docwra (United Kingdom)'),
(5845, 'https://ror.org/00zdmbm57', 'no_lang_code', 1, 'https://ror.org/00zdmbm57 Premiere Global Services (United States)'),
(5846, 'https://ror.org/00zffgs92', 'no_lang_code', 1, 'https://ror.org/00zffgs92 Anotec Engineering (Spain)'),
(5847, 'https://ror.org/00zgt4y83', 'no_lang_code', 1, 'https://ror.org/00zgt4y83 MetaMedia Training International (United States)'),
(5848, 'https://ror.org/00zn54j08', 'no_lang_code', 1, 'https://ror.org/00zn54j08 Kryton International (Canada)'),
(5849, 'https://ror.org/00zpq6q43', 'no_lang_code', 1, 'https://ror.org/00zpq6q43 SWITCH Materials (Canada)'),
(5850, 'https://ror.org/00zqnhb80', 'no_lang_code', 1, 'https://ror.org/00zqnhb80 Avensys (Canada)'),
(5851, 'https://ror.org/00zvs5g09', 'no_lang_code', 1, 'https://ror.org/00zvs5g09 Flexiant (United Kingdom)'),
(5852, 'https://ror.org/00zw6et16', 'en', 1, 'https://ror.org/00zw6et16 Capital Institute of Pediatrics 首都儿科研究所'),
(5853, 'https://ror.org/00zwq4e04', 'en', 1, 'https://ror.org/00zwq4e04 Cope Community Services'),
(5854, 'https://ror.org/00zxfn928', 'no_lang_code', 1, 'https://ror.org/00zxfn928 Gratings Incorporated (United States)'),
(5855, 'https://ror.org/00zzc5439', 'no_lang_code', 1, 'https://ror.org/00zzc5439 Molecular LogiX (United States)'),
(5856, 'https://ror.org/0100f3q33', 'no_lang_code', 1, 'https://ror.org/0100f3q33 Biotest (Germany)'),
(5857, 'https://ror.org/0100fcb78', 'en', 1, 'https://ror.org/0100fcb78 Arapahoe Community College'),
(5858, 'https://ror.org/0100w6230', 'no_lang_code', 1, 'https://ror.org/0100w6230 Alacron (United States)'),
(5859, 'https://ror.org/0102yp030', 'en', 1, 'https://ror.org/0102yp030 College of DuPage'),
(5860, 'https://ror.org/0106nz743', 'no_lang_code', 1, 'https://ror.org/0106nz743 Cisco Systems (Netherlands)'),
(5861, 'https://ror.org/01070pt38', 'fr', 1, 'https://ror.org/01070pt38 City College La Cité Collégiale'),
(5862, 'https://ror.org/0107hzb54', 'en', 1, 'https://ror.org/0107hzb54 International Craniofacial Institute'),
(5863, 'https://ror.org/0108cpj15', 'en', 1, 'https://ror.org/0108cpj15 High Institute for Education and Research in Transfusion Medicine موسسه عالی آموزشی و پژوهشی طب انتقال خون'),
(5864, 'https://ror.org/0109e3y78', 'no_lang_code', 1, 'https://ror.org/0109e3y78 Bluegreen Strategy (Italy)'),
(5865, 'https://ror.org/010ab8p65', 'en', 1, 'https://ror.org/010ab8p65 Hopkins Architectes Hopkins Architects'),
(5866, 'https://ror.org/010azec62', 'en', 1, 'https://ror.org/010azec62 Deborah Heart and Lung Center'),
(5867, 'https://ror.org/010bfx043', 'no_lang_code', 1, 'https://ror.org/010bfx043 Conestoga Meat Packers (Canada)'),
(5868, 'https://ror.org/010eax918', 'no_lang_code', 1, 'https://ror.org/010eax918 Syandus (United States)'),
(5869, 'https://ror.org/010ehmn03', 'no_lang_code', 1, 'https://ror.org/010ehmn03 Viocare (United States)'),
(5870, 'https://ror.org/010fbpe82', 'en', 1, 'https://ror.org/010fbpe82 Tianjin Economic-Technological Development Area 天津经济技术开发区'),
(5871, 'https://ror.org/010g03x11', 'en', 1, 'https://ror.org/010g03x11 Toronto Public Health'),
(5872, 'https://ror.org/010h0ab29', 'no_lang_code', 1, 'https://ror.org/010h0ab29 Dynamis Pharmaceuticals (United States)'),
(5873, 'https://ror.org/010hx2v28', 'no_lang_code', 1, 'https://ror.org/010hx2v28 Inverness Research (United States)'),
(5874, 'https://ror.org/010k65h15', 'en', 1, 'https://ror.org/010k65h15 Society for Canadian Women in Science and Technology'),
(5875, 'https://ror.org/010pkhb41', 'es', 1, 'https://ror.org/010pkhb41 Association Instituto Tecnológico Metalmecánico'),
(5876, 'https://ror.org/010pvqx55', 'en', 1, 'https://ror.org/010pvqx55 Danish Institute against Torture'),
(5877, 'https://ror.org/010qwhr53', 'en', 1, 'https://ror.org/010qwhr53 Klinikum Nürnberg Nuremberg Hospital'),
(5878, 'https://ror.org/010r07h95', 'no_lang_code', 1, 'https://ror.org/010r07h95 Halma Water Management (United Kingdom)'),
(5879, 'https://ror.org/010s4nz55', 'en', 1, 'https://ror.org/010s4nz55 York General Hospital'),
(5880, 'https://ror.org/010s5ca44', 'en', 1, 'https://ror.org/010s5ca44 Memphis Fire Services'),
(5881, 'https://ror.org/010thz337', 'en', 1, 'https://ror.org/010thz337 Farmingdale State College'),
(5882, 'https://ror.org/010vbnw08', 'no_lang_code', 1, 'https://ror.org/010vbnw08 Apotex Pharmachem (Canada)'),
(5883, 'https://ror.org/0110df420', 'no_lang_code', 1, 'https://ror.org/0110df420 Aurora Flight Sciences (United States)'),
(5884, 'https://ror.org/0110tsr95', 'no_lang_code', 1, 'https://ror.org/0110tsr95 Energy and Environmental Consultancy'),
(5885, 'https://ror.org/0111bj510', 'no_lang_code', 1, 'https://ror.org/0111bj510 Industrial Tomography Systems (United Kingdom)'),
(5886, 'https://ror.org/0111gm575', 'en', 1, 'https://ror.org/0111gm575 Positive Living Society of British Columbia'),
(5887, 'https://ror.org/01132tb14', 'no_lang_code', 1, 'https://ror.org/01132tb14 Cryomagnetics (United States)'),
(5888, 'https://ror.org/0113kt106', 'en', 1, 'https://ror.org/0113kt106 Nine Circles Community Health Centre'),
(5889, 'https://ror.org/01144y654', 'no_lang_code', 1, 'https://ror.org/01144y654 MASSolutions (Canada)'),
(5890, 'https://ror.org/011471042', 'en', 1, 'https://ror.org/011471042 National Institute of Epidemiology'),
(5891, 'https://ror.org/0114c6692', 'no_lang_code', 1, 'https://ror.org/0114c6692 Prediction Sciences (United States)'),
(5892, 'https://ror.org/0115kp792', 'no_lang_code', 1, 'https://ror.org/0115kp792 Aptagen (United States)'),
(5893, 'https://ror.org/0115psh64', 'no_lang_code', 1, 'https://ror.org/0115psh64 MMTC (United States)'),
(5894, 'https://ror.org/0116mgp30', 'no_lang_code', 1, 'https://ror.org/0116mgp30 ALFA PI (Greece)'),
(5895, 'https://ror.org/0117yy678', 'no_lang_code', 1, 'https://ror.org/0117yy678 BIT-TECH (United States)'),
(5896, 'https://ror.org/011akkh38', 'en', 1, 'https://ror.org/011akkh38 Australian Academy of the Humanities'),
(5897, 'https://ror.org/011e44004', 'en', 1, 'https://ror.org/011e44004 American Planning Association'),
(5898, 'https://ror.org/011hsx378', 'no_lang_code', 1, 'https://ror.org/011hsx378 PortaScience (United States)'),
(5899, 'https://ror.org/011k0sc34', 'no_lang_code', 1, 'https://ror.org/011k0sc34 Atlantia (Italy)'),
(5900, 'https://ror.org/011krwa35', 'en', 1, 'https://ror.org/011krwa35 Urology Associates'),
(5901, 'https://ror.org/011mar637', 'en', 1, 'https://ror.org/011mar637 National Cancer Institute of Thailand สถาบันมะเร็งแห่งชาติ'),
(5902, 'https://ror.org/011ps1s60', 'en', 1, 'https://ror.org/011ps1s60 American College of Healthcare Executives'),
(5903, 'https://ror.org/011qnyz94', 'fr', 1, 'https://ror.org/011qnyz94 Cégep de la Gaspésie et des Îles'),
(5904, 'https://ror.org/011rkt464', 'no_lang_code', 1, 'https://ror.org/011rkt464 Greentech (France)'),
(5905, 'https://ror.org/011ssy811', 'en', 1, 'https://ror.org/011ssy811 International Prevention Research Institute'),
(5906, 'https://ror.org/011t2v902', 'en', 1, 'https://ror.org/011t2v902 Carlow University'),
(5907, 'https://ror.org/011tndv57', 'en', 1, 'https://ror.org/011tndv57 Kentucky Science Center'),
(5908, 'https://ror.org/011vw2696', 'no_lang_code', 1, 'https://ror.org/011vw2696 Geospace Research (United States)'),
(5909, 'https://ror.org/011yjrc39', 'no_lang_code', 1, 'https://ror.org/011yjrc39 Equipos Nucleares (Spain)'),
(5910, 'https://ror.org/011zg5725', 'pt', 1, 'https://ror.org/011zg5725 Centro Tecnológico das Indústrias Têxtil e do Vestuário de Portugal Technological Centre for the Portuguese Textile and Clothing Industry'),
(5911, 'https://ror.org/012057720', 'en', 1, 'https://ror.org/012057720 American Legacy Foundation'),
(5912, 'https://ror.org/01220jp31', 'it', 1, 'https://ror.org/01220jp31 IRCCS Policlinico San Donato'),
(5913, 'https://ror.org/012381002', 'en', 1, 'https://ror.org/012381002 Terasaki Foundation'),
(5914, 'https://ror.org/0123zff28', 'en', 1, 'https://ror.org/0123zff28 EMO GVM Centro Cuore Columbus'),
(5915, 'https://ror.org/0125b2w26', 'no_lang_code', 1, 'https://ror.org/0125b2w26 OmegaChem (Canada)'),
(5916, 'https://ror.org/0125vzh18', 'no_lang_code', 1, 'https://ror.org/0125vzh18 Noble (United States)'),
(5917, 'https://ror.org/0128ckf82', 'en', 1, 'https://ror.org/0128ckf82 Ferrum College'),
(5918, 'https://ror.org/012a41834', 'en', 1, 'https://ror.org/012a41834 National Institute of Biological Resources'),
(5919, 'https://ror.org/012bn4v93', 'no_lang_code', 1, 'https://ror.org/012bn4v93 Agilent Technologies (Belgium)'),
(5920, 'https://ror.org/012c7gx93', 'no_lang_code', 1, 'https://ror.org/012c7gx93 Cerner (United States)'),
(5921, 'https://ror.org/012e11c45', 'no_lang_code', 1, 'https://ror.org/012e11c45 JWK Corporation (United States)'),
(5922, 'https://ror.org/012es9h30', 'no_lang_code', 1, 'https://ror.org/012es9h30 Gradient Lens Corporation (United States)'),
(5923, 'https://ror.org/012fe8h22', 'en', 1, 'https://ror.org/012fe8h22 Neighborhood House'),
(5924, 'https://ror.org/012fsht65', 'no_lang_code', 1, 'https://ror.org/012fsht65 Architecture Technology Corporation (United States)'),
(5925, 'https://ror.org/012kdmp09', 'en', 1, 'https://ror.org/012kdmp09 Opća bolnica Zabok Zabok General Hospital'),
(5926, 'https://ror.org/012khpt30', 'it', 1, 'https://ror.org/012khpt30 Fondazione G.B. Bietti G. B. Bietti Foundation'),
(5927, 'https://ror.org/012mfbs12', 'en', 1, 'https://ror.org/012mfbs12 Bethel College'),
(5928, 'https://ror.org/012p5cj16', 'no_lang_code', 1, 'https://ror.org/012p5cj16 DIAD Group (Italy)'),
(5929, 'https://ror.org/012p9gs30', 'en', 1, 'https://ror.org/012p9gs30 Santa Fe College'),
(5930, 'https://ror.org/012thdv08', 'no_lang_code', 1, 'https://ror.org/012thdv08 Zueblin (Germany)'),
(5931, 'https://ror.org/012v3yp34', 'no_lang_code', 1, 'https://ror.org/012v3yp34 CINAR (Greece)'),
(5932, 'https://ror.org/012vsjx26', 'no_lang_code', 1, 'https://ror.org/012vsjx26 Seacoast Science (United States)'),
(5933, 'https://ror.org/012xcvh54', 'fr', 1, 'https://ror.org/012xcvh54 Cegep de Saint Jerome, Cégep de saint-jérôme Cegep of Saint Jérôme'),
(5934, 'https://ror.org/012xhfk02', 'en', 1, 'https://ror.org/012xhfk02 LAM Foundation'),
(5935, 'https://ror.org/012xttn04', 'no_lang_code', 1, 'https://ror.org/012xttn04 Centro Ricerche Produzioni Animali'),
(5936, 'https://ror.org/012y1mj37', 'en', 1, 'https://ror.org/012y1mj37 Oglala Lakota College'),
(5937, 'https://ror.org/012zm4p89', 'no_lang_code', 1, 'https://ror.org/012zm4p89 Energy Science Laboratories (United States)'),
(5938, 'https://ror.org/0130d0563', 'en', 1, 'https://ror.org/0130d0563 Vaccine Research Institute of San Diego'),
(5939, 'https://ror.org/0130wtk42', 'en', 1, 'https://ror.org/0130wtk42 Foundation for International Environmental Law and Development'),
(5940, 'https://ror.org/01327qs39', 'en', 1, 'https://ror.org/01327qs39 WestCare Foundation'),
(5941, 'https://ror.org/0132fct87', 'no_lang_code', 1, 'https://ror.org/0132fct87 Air Products (United Kingdom)'),
(5942, 'https://ror.org/0132nee26', 'fr', 1, 'https://ror.org/0132nee26 Institut National d''Oncologie'),
(5943, 'https://ror.org/0132qa516', 'en', 1, 'https://ror.org/0132qa516 Worcester Memorial Hospital'),
(5944, 'https://ror.org/0134j7f28', 'no_lang_code', 1, 'https://ror.org/0134j7f28 Orolia (United States)'),
(5945, 'https://ror.org/0135ay670', 'en', 1, 'https://ror.org/0135ay670 Montgomery County Community College'),
(5946, 'https://ror.org/0138w4412', 'en', 1, 'https://ror.org/0138w4412 Russian Research Center for Molecular Diagnostics and Therapy'),
(5947, 'https://ror.org/013aq5m10', 'en', 1, 'https://ror.org/013aq5m10 Dubai Pharmacy College كلية دبي للصيدلة'),
(5948, 'https://ror.org/013by2m91', 'no_lang_code', 1, 'https://ror.org/013by2m91 Synopsys (United States)'),
(5949, 'https://ror.org/013cpfz63', 'no_lang_code', 1, 'https://ror.org/013cpfz63 Cel-Sci (United States)'),
(5950, 'https://ror.org/013ed7841', 'en', 1, 'https://ror.org/013ed7841 American College of Physician Executives'),
(5951, 'https://ror.org/013gjg633', 'no_lang_code', 1, 'https://ror.org/013gjg633 E.ON (Germany)'),
(5952, 'https://ror.org/013hwwd10', 'no_lang_code', 1, 'https://ror.org/013hwwd10 Surgical Specialties (Canada)'),
(5953, 'https://ror.org/013phw743', 'en', 1, 'https://ror.org/013phw743 Council on Competitiveness'),
(5954, 'https://ror.org/013rrw978', 'no_lang_code', 1, 'https://ror.org/013rrw978 Plexon (United States)'),
(5955, 'https://ror.org/013s9ta35', 'en', 1, 'https://ror.org/013s9ta35 Wisconsin Heart Hospital'),
(5956, 'https://ror.org/013t2n957', 'no_lang_code', 1, 'https://ror.org/013t2n957 Perrigo (United States)'),
(5957, 'https://ror.org/013v2jk78', 'en', 1, 'https://ror.org/013v2jk78 American Association of Poison Control Centers'),
(5958, 'https://ror.org/013wkc921', 'it', 1, 'https://ror.org/013wkc921 Istituto Scientifico Romagnolo per lo Studio e la Cura dei Tumori'),
(5959, 'https://ror.org/013xmn143', 'no_lang_code', 1, 'https://ror.org/013xmn143 Baxter (Austria)'),
(5960, 'https://ror.org/013y4v758', 'en', 1, 'https://ror.org/013y4v758 Yokohama City Seibu Hospital'),
(5961, 'https://ror.org/013zb0q67', 'en', 1, 'https://ror.org/013zb0q67 Anixter Center'),
(5962, 'https://ror.org/014142c83', 'en', 1, 'https://ror.org/014142c83 National Institute for Food and Nutrition Science'),
(5963, 'https://ror.org/0141egq93', 'no_lang_code', 1, 'https://ror.org/0141egq93 TRS Technologies (United States)'),
(5964, 'https://ror.org/0141vav06', 'en', 1, 'https://ror.org/0141vav06 WAMC Northeast Public Radio'),
(5965, 'https://ror.org/0144s0951', 'en', 1, 'https://ror.org/0144s0951 Zhejiang Cancer Hospital 浙江省肿瘤医院'),
(5966, 'https://ror.org/0144z1077', 'no_lang_code', 1, 'https://ror.org/0144z1077 Iomai (United States)'),
(5967, 'https://ror.org/0145s0423', 'es', 1, 'https://ror.org/0145s0423 Foundation for the Fight against Pediatric Neurological Disease Fundación para la Lucha contra las Enfermedades Neurológicas de la Infancia'),
(5968, 'https://ror.org/01479r334', 'en', 1, 'https://ror.org/01479r334 Henan Provincial Center for Disease Control and Prevention 河南省疾病预防控制中心'),
(5969, 'https://ror.org/0149xpj56', 'en', 1, 'https://ror.org/0149xpj56 Midwest Cardiovascular Research Foundation'),
(5970, 'https://ror.org/014a5gx79', 'en', 1, 'https://ror.org/014a5gx79 Departamento de Vivienda y Desarrollo Urbano de los Estados Unidos Département du logement et du développement urbain des États-unis United States Department of Housing and Urban Development'),
(5971, 'https://ror.org/014aeyd41', 'no_lang_code', 1, 'https://ror.org/014aeyd41 Asahi Breweries (Japan) アサヒビール株式会社'),
(5972, 'https://ror.org/014bye436', 'no_lang_code', 1, 'https://ror.org/014bye436 Lucerna (United States)'),
(5973, 'https://ror.org/014c2qb55', 'de', 1, 'https://ror.org/014c2qb55 Klinik Hirslanden'),
(5974, 'https://ror.org/014dkew11', 'no_lang_code', 1, 'https://ror.org/014dkew11 Environment and Health Group (United States)'),
(5975, 'https://ror.org/014er3x17', 'en', 1, 'https://ror.org/014er3x17 Institute of Particle Physics'),
(5976, 'https://ror.org/014fc7457', 'no_lang_code', 1, 'https://ror.org/014fc7457 PerkinElmer (United Kingdom)'),
(5977, 'https://ror.org/014gfj521', 'no_lang_code', 1, 'https://ror.org/014gfj521 CyberColloids'),
(5978, 'https://ror.org/014hs3c68', 'no_lang_code', 1, 'https://ror.org/014hs3c68 Lend Lease (United Kingdom)');
INSERT INTO `rors` VALUES
(5979, 'https://ror.org/014jgh757', 'no_lang_code', 1, 'https://ror.org/014jgh757 LAC Group (United States)'),
(5980, 'https://ror.org/014jghh27', 'no_lang_code', 1, 'https://ror.org/014jghh27 Chelsea Technologies (United Kingdom)'),
(5981, 'https://ror.org/014pcm848', 'en', 1, 'https://ror.org/014pcm848 American Society of Nephrology'),
(5982, 'https://ror.org/014t21j89', 'en', 1, 'https://ror.org/014t21j89 Sarah Cannon'),
(5983, 'https://ror.org/014tb3433', 'en', 1, 'https://ror.org/014tb3433 Loma Linda Veterans Association for Research and Education'),
(5984, 'https://ror.org/014tted12', 'no_lang_code', 1, 'https://ror.org/014tted12 Systems Control (United States)'),
(5985, 'https://ror.org/014xba990', 'no_lang_code', 1, 'https://ror.org/014xba990 Ateliers Nic. Georges (Luxembourg)'),
(5986, 'https://ror.org/014y9yf82', 'no_lang_code', 1, 'https://ror.org/014y9yf82 Compuware (United States)'),
(5987, 'https://ror.org/014yznv62', 'no_lang_code', 1, 'https://ror.org/014yznv62 TiNi Alloy (United States)'),
(5988, 'https://ror.org/014ztwb11', 'fr', 1, 'https://ror.org/014ztwb11 Fédération des cégeps'),
(5989, 'https://ror.org/0150tj573', 'de', 1, 'https://ror.org/0150tj573 Deutsche Bundespost German Federal Post Office'),
(5990, 'https://ror.org/0153sam53', 'en', 1, 'https://ror.org/0153sam53 Centre d''Étude et de Recherches Vétérinaires et Agrochimiques Centrum voor Onderzoek in Diergeneeskunde en Agrochemie Veterinary and Agrochemical Research Centre'),
(5991, 'https://ror.org/0154zm466', 'da', 1, 'https://ror.org/0154zm466 Børneklinikken Randers'),
(5992, 'https://ror.org/0155k7414', 'en', 1, 'https://ror.org/0155k7414 Cleveland Clinic Florida'),
(5993, 'https://ror.org/0156f0c06', 'no_lang_code', 1, 'https://ror.org/0156f0c06 ICF International (United States)'),
(5994, 'https://ror.org/0156rhd17', 'en', 1, 'https://ror.org/0156rhd17 Second Affiliated Hospital & Yuying Children''s Hospital of Wenzhou Medical University 温州医科大学附属第二医院'),
(5995, 'https://ror.org/0157vkf66', 'en', 1, 'https://ror.org/0157vkf66 Rajiv Gandhi University of Health Sciences राजीव गांधी स्वास्थ्य विज्ञान विश्वविद्यालय'),
(5996, 'https://ror.org/01595ga64', 'no_lang_code', 1, 'https://ror.org/01595ga64 Cowi (Norway)'),
(5997, 'https://ror.org/015by2x28', 'en', 1, 'https://ror.org/015by2x28 North Dakota State College of Science'),
(5998, 'https://ror.org/015bz4634', 'no_lang_code', 1, 'https://ror.org/015bz4634 Agfa-Gevaert (Belgium)'),
(5999, 'https://ror.org/015er2861', 'en', 1, 'https://ror.org/015er2861 Vale of Leven District General Hospital'),
(6000, 'https://ror.org/015exsf29', 'no_lang_code', 1, 'https://ror.org/015exsf29 Upsight (Canada)'),
(6001, 'https://ror.org/015gdag92', 'en', 1, 'https://ror.org/015gdag92 Atlanta Allergy and Asthma Clinic'),
(6002, 'https://ror.org/015h4rf69', 'en', 1, 'https://ror.org/015h4rf69 Niagara College'),
(6003, 'https://ror.org/015jknj09', 'en', 1, 'https://ror.org/015jknj09 American Association of Physicists in Medicine'),
(6004, 'https://ror.org/015k31167', 'no_lang_code', 1, 'https://ror.org/015k31167 BLC Leather Technology Centre'),
(6005, 'https://ror.org/015m6xt73', 'no_lang_code', 1, 'https://ror.org/015m6xt73 Gruppo CLAS (Italy)'),
(6006, 'https://ror.org/015mh9580', 'en', 1, 'https://ror.org/015mh9580 Chippewa Valley Technical College'),
(6007, 'https://ror.org/015n0my11', 'en', 1, 'https://ror.org/015n0my11 Alabama Southern Community College'),
(6008, 'https://ror.org/015pg1163', 'no_lang_code', 1, 'https://ror.org/015pg1163 Orcca Technology (United States)'),
(6009, 'https://ror.org/015qy8r18', 'fr', 1, 'https://ror.org/015qy8r18 Centre Hospitalier Intercommunal de Poissy'),
(6010, 'https://ror.org/015w2wb33', 'no_lang_code', 1, 'https://ror.org/015w2wb33 Atos (France)'),
(6011, 'https://ror.org/015ygrv52', 'en', 1, 'https://ror.org/015ygrv52 Hong Kong Jockey Club 香港賽馬會'),
(6012, 'https://ror.org/015z80004', 'en', 1, 'https://ror.org/015z80004 Forensic Sciences Department'),
(6013, 'https://ror.org/01601en76', 'fr', 1, 'https://ror.org/01601en76 Cegep de Sept Iles, Cégep de sept-Îles'),
(6014, 'https://ror.org/0160cnc74', 'no_lang_code', 1, 'https://ror.org/0160cnc74 BioSci Research Canada (Canada)'),
(6015, 'https://ror.org/0160sy147', 'no_lang_code', 1, 'https://ror.org/0160sy147 Robotiq (Canada)'),
(6016, 'https://ror.org/0160vb289', 'no_lang_code', 1, 'https://ror.org/0160vb289 Tertl Studos (United States)'),
(6017, 'https://ror.org/01616eq90', 'en', 1, 'https://ror.org/01616eq90 Gamalei Institute of Epidemiology and Microbiology Национальный исследовательский центр эпидемиологии и микробиологии имени почётного академика Н. Ф. Гамалеи'),
(6018, 'https://ror.org/0162naz14', 'no_lang_code', 1, 'https://ror.org/0162naz14 EnviroSim (Canada)'),
(6019, 'https://ror.org/01647vc39', 'no_lang_code', 1, 'https://ror.org/01647vc39 Behringwerke (Germany)'),
(6020, 'https://ror.org/0165dap44', 'no_lang_code', 1, 'https://ror.org/0165dap44 CF consulting Finanziamenti Unione Europea'),
(6021, 'https://ror.org/0168zt961', 'en', 1, 'https://ror.org/0168zt961 Asian and Pacific Islander American Health Forum'),
(6022, 'https://ror.org/0169taq91', 'no_lang_code', 1, 'https://ror.org/0169taq91 Futures Group (United States)'),
(6023, 'https://ror.org/016a12m25', 'fr', 1, 'https://ror.org/016a12m25 Comité Scientifique et Technique des Industries Climatiques'),
(6024, 'https://ror.org/016brq605', 'de', 1, 'https://ror.org/016brq605 Apherese Forschungsinstitut'),
(6025, 'https://ror.org/016cdf784', 'no_lang_code', 1, 'https://ror.org/016cdf784 BioReliance (United States)'),
(6026, 'https://ror.org/016chgx50', 'no_lang_code', 1, 'https://ror.org/016chgx50 Sasaki Institute 佐々木研究所'),
(6027, 'https://ror.org/016cxc226', 'es', 1, 'https://ror.org/016cxc226 Complejo Hospitalario de Pontevedra'),
(6028, 'https://ror.org/016d8zs37', 'en', 1, 'https://ror.org/016d8zs37 Methodist Healthcare'),
(6029, 'https://ror.org/016hfp155', 'en', 1, 'https://ror.org/016hfp155 Institute of Biomedical Problems Федеральное государственное бюджетное учреждение науки Государственный научный центр Российской Федерации - Институт медико-биологических проблем Российской академии наук'),
(6030, 'https://ror.org/016hnw741', 'no_lang_code', 1, 'https://ror.org/016hnw741 Centre for Technology Research & Innovation (Cyprus)'),
(6031, 'https://ror.org/016jbz672', 'no_lang_code', 1, 'https://ror.org/016jbz672 MandalMed (United States)'),
(6032, 'https://ror.org/016jjjq38', 'no_lang_code', 1, 'https://ror.org/016jjjq38 Eltropuls (United Kingdom)'),
(6033, 'https://ror.org/016kk8e44', 'no_lang_code', 1, 'https://ror.org/016kk8e44 Ventria Bioscience (United States)'),
(6034, 'https://ror.org/016mnbp44', 'no_lang_code', 1, 'https://ror.org/016mnbp44 Vi Technology (United States)'),
(6035, 'https://ror.org/016n06b36', 'en', 1, 'https://ror.org/016n06b36 Franciscan Hammond Clinic'),
(6036, 'https://ror.org/016n3sp21', 'en', 1, 'https://ror.org/016n3sp21 Society of British Water and Wastewater Industries'),
(6037, 'https://ror.org/016p00020', 'no_lang_code', 1, 'https://ror.org/016p00020 Computerised Information Technology (United Kingdom)'),
(6038, 'https://ror.org/016p29p27', 'no_lang_code', 1, 'https://ror.org/016p29p27 TopoGEN (United States)'),
(6039, 'https://ror.org/016pn1y21', 'no_lang_code', 1, 'https://ror.org/016pn1y21 Axcelon Biopolymers (Canada)'),
(6040, 'https://ror.org/016pn2j58', 'en', 1, 'https://ror.org/016pn2j58 Amity Foundation'),
(6041, 'https://ror.org/016sds817', 'en', 1, 'https://ror.org/016sds817 Tiroler Krebsforschungsinstitut Tyrolean Cancer Research Institute'),
(6042, 'https://ror.org/016t25n48', 'no_lang_code', 1, 'https://ror.org/016t25n48 Quasars (United States)'),
(6043, 'https://ror.org/016t6qg15', 'no_lang_code', 1, 'https://ror.org/016t6qg15 PENTAX Medical Company (United States)'),
(6044, 'https://ror.org/016tybp74', 'en', 1, 'https://ror.org/016tybp74 North Riding Infirmary'),
(6045, 'https://ror.org/016tysf12', 'en', 1, 'https://ror.org/016tysf12 Western Technical College'),
(6046, 'https://ror.org/016v3mm55', 'no_lang_code', 1, 'https://ror.org/016v3mm55 CognIT (Norway)'),
(6047, 'https://ror.org/017136v53', 'en', 1, 'https://ror.org/017136v53 Genomics Institute of the Novartis Research Foundation'),
(6048, 'https://ror.org/0173mx324', 'en', 1, 'https://ror.org/0173mx324 Family Research Institute'),
(6049, 'https://ror.org/0173xeq43', 'en', 1, 'https://ror.org/0173xeq43 Nottingham City Council'),
(6050, 'https://ror.org/01743cc72', 'no_lang_code', 1, 'https://ror.org/01743cc72 Servelec Technologies (United Kingdom)'),
(6051, 'https://ror.org/0174vdd62', 'no_lang_code', 1, 'https://ror.org/0174vdd62 Pasadero (United States)'),
(6052, 'https://ror.org/0175ya539', 'en', 1, 'https://ror.org/0175ya539 Koninklijke Kentalis Royal Dutch Kentalis'),
(6053, 'https://ror.org/0178xk096', 'en', 1, 'https://ror.org/0178xk096 International Institute for Population Sciences'),
(6054, 'https://ror.org/017977v32', 'no_lang_code', 1, 'https://ror.org/017977v32 Alstom (Switzerland)'),
(6055, 'https://ror.org/0179z8203', 'no_lang_code', 1, 'https://ror.org/0179z8203 Flabeg (Germany)'),
(6056, 'https://ror.org/017arrg98', 'en', 1, 'https://ror.org/017arrg98 Department of Alcohol, Drug, and Mental Health Services'),
(6057, 'https://ror.org/017artp82', 'no_lang_code', 1, 'https://ror.org/017artp82 Electricity Authority of Cyprus (Cyprus)'),
(6058, 'https://ror.org/017bd5k63', 'en', 1, 'https://ror.org/017bd5k63 Zuoying Armed Forces General Hospital 國軍高雄總醫院'),
(6059, 'https://ror.org/017ctmv39', 'no_lang_code', 1, 'https://ror.org/017ctmv39 AkzoNobel (Netherlands)'),
(6060, 'https://ror.org/017fh2655', 'es', 1, 'https://ror.org/017fh2655 Instituto Nacional de Enfermedades Respiratorias, Instituto Nacional de Enfermedades Respiratorias Ismael Cosío Villegas'),
(6061, 'https://ror.org/017j6af40', 'it', 1, 'https://ror.org/017j6af40 Ospedale Humanitas Gradenigo'),
(6062, 'https://ror.org/017m4b809', 'no_lang_code', 1, 'https://ror.org/017m4b809 NXP (United Kingdom)'),
(6063, 'https://ror.org/017pcqs43', 'en', 1, 'https://ror.org/017pcqs43 D.I. Ivanovsky Institute of Virology Russian Academy of Medical Sciences НИИ вирусологии имени Д. И. Ивановского РАМН'),
(6064, 'https://ror.org/017pqj756', 'no_lang_code', 1, 'https://ror.org/017pqj756 Vega Wave Systems (United States)'),
(6065, 'https://ror.org/017qjec28', 'en', 1, 'https://ror.org/017qjec28 VATT Institute for Economic Research'),
(6066, 'https://ror.org/017shr829', 'no_lang_code', 1, 'https://ror.org/017shr829 LI-COR Biosciences (United States)'),
(6067, 'https://ror.org/017spz608', 'no_lang_code', 1, 'https://ror.org/017spz608 Aker Arctic (Canada)'),
(6068, 'https://ror.org/017tgty84', 'no_lang_code', 1, 'https://ror.org/017tgty84 SciAps (United States)'),
(6069, 'https://ror.org/017vd4789', 'no_lang_code', 1, 'https://ror.org/017vd4789 Compugen (Israel) קומפיוג''ן'),
(6070, 'https://ror.org/0183vre95', 'en', 1, 'https://ror.org/0183vre95 TiFN'),
(6071, 'https://ror.org/0185sft94', 'no_lang_code', 1, 'https://ror.org/0185sft94 CW Optics (United States)'),
(6072, 'https://ror.org/01864e038', 'en', 1, 'https://ror.org/01864e038 Montana Council of Teachers of Mathematics'),
(6073, 'https://ror.org/0186yvf62', 'en', 1, 'https://ror.org/0186yvf62 Australian Academy of Science'),
(6074, 'https://ror.org/0187fh156', 'de', 1, 'https://ror.org/0187fh156 Isar-Amper-Klinikum München-Ost'),
(6075, 'https://ror.org/018azgd14', 'en', 1, 'https://ror.org/018azgd14 National Institute of Cholera and Enteric Diseases'),
(6076, 'https://ror.org/018cxtf62', 'en', 1, 'https://ror.org/018cxtf62 Earlham Institute'),
(6077, 'https://ror.org/018f35e53', 'en', 1, 'https://ror.org/018f35e53 Health Media Lab'),
(6078, 'https://ror.org/018hk2b97', 'en', 1, 'https://ror.org/018hk2b97 Denver VA Medical Center'),
(6079, 'https://ror.org/018j3hx85', 'pt', 1, 'https://ror.org/018j3hx85 Escola Superior de Tecnologia da Saúde de Coimbra'),
(6080, 'https://ror.org/018m20m74', 'en', 1, 'https://ror.org/018m20m74 Human BioMolecular Research Institute'),
(6081, 'https://ror.org/018mrwd51', 'no_lang_code', 1, 'https://ror.org/018mrwd51 Advanced Computer System (Italy)'),
(6082, 'https://ror.org/018nkky79', 'no_lang_code', 1, 'https://ror.org/018nkky79 Tuen Mun Hospital 屯門醫院'),
(6083, 'https://ror.org/018pfsv20', 'en', 1, 'https://ror.org/018pfsv20 Lexington Richland Alcohol And Drug Abuse Council'),
(6084, 'https://ror.org/018qep702', 'no_lang_code', 1, 'https://ror.org/018qep702 General Motors (Germany)'),
(6085, 'https://ror.org/018r1es63', 'en', 1, 'https://ror.org/018r1es63 Massachusetts Bay Community College'),
(6086, 'https://ror.org/018v91w71', 'en', 1, 'https://ror.org/018v91w71 Missouri Bone and Joint Center'),
(6087, 'https://ror.org/018xkrg73', 'fr', 1, 'https://ror.org/018xkrg73 Collège d''Alma'),
(6088, 'https://ror.org/018zaej71', 'it', 1, 'https://ror.org/018zaej71 Ospedale di San Donà di Piave'),
(6089, 'https://ror.org/0190p7071', 'no_lang_code', 1, 'https://ror.org/0190p7071 General Electric (Sweden)'),
(6090, 'https://ror.org/01950ke92', 'no_lang_code', 1, 'https://ror.org/01950ke92 Concentration Heat and Momentum (United Kingdom)'),
(6091, 'https://ror.org/0195ge738', 'en', 1, 'https://ror.org/0195ge738 Access Community Health Network'),
(6092, 'https://ror.org/0199g0r92', 'en', 1, 'https://ror.org/0199g0r92 Max Planck Institute for Metabolism Research Max-Planck-Institut für Stoffwechselforschung'),
(6093, 'https://ror.org/019a0n503', 'no_lang_code', 1, 'https://ror.org/019a0n503 Cerestech (Canada)'),
(6094, 'https://ror.org/019bpax96', 'en', 1, 'https://ror.org/019bpax96 Southern Governors Association'),
(6095, 'https://ror.org/019ejf125', 'no_lang_code', 1, 'https://ror.org/019ejf125 Ormazabal (Switzerland)'),
(6096, 'https://ror.org/019fkcf66', 'en', 1, 'https://ror.org/019fkcf66 Guangzhou Blood Center'),
(6097, 'https://ror.org/019kwgw50', 'no_lang_code', 1, 'https://ror.org/019kwgw50 Ionwerks (United States)'),
(6098, 'https://ror.org/019m6fr90', 'no_lang_code', 1, 'https://ror.org/019m6fr90 New York Audio Productions (United States)'),
(6099, 'https://ror.org/019mfbd19', 'no_lang_code', 1, 'https://ror.org/019mfbd19 Quest Clinical Research (United States)'),
(6100, 'https://ror.org/019nmf858', 'en', 1, 'https://ror.org/019nmf858 Central Potato Research Institute'),
(6101, 'https://ror.org/019rsbe67', 'no_lang_code', 1, 'https://ror.org/019rsbe67 Jazz Pharmaceuticals (United States)'),
(6102, 'https://ror.org/019tbwb44', 'no_lang_code', 1, 'https://ror.org/019tbwb44 Faseroptische Systeme Messtechnik (Germany)'),
(6103, 'https://ror.org/019wssg97', 'no_lang_code', 1, 'https://ror.org/019wssg97 Altana (Germany)'),
(6104, 'https://ror.org/019xfaf13', 'en', 1, 'https://ror.org/019xfaf13 Astronomical Society of the Pacific'),
(6105, 'https://ror.org/019xgv883', 'en', 1, 'https://ror.org/019xgv883 Science East Association'),
(6106, 'https://ror.org/019y5r485', 'no_lang_code', 1, 'https://ror.org/019y5r485 Nesher Technologies (United States)'),
(6107, 'https://ror.org/01a079157', 'no_lang_code', 1, 'https://ror.org/01a079157 Siemens (Portugal)'),
(6108, 'https://ror.org/01a0veq54', 'no_lang_code', 1, 'https://ror.org/01a0veq54 Sri Gokulam Hospital'),
(6109, 'https://ror.org/01a0xxp39', 'en', 1, 'https://ror.org/01a0xxp39 Institute of Basic Biological Problems Федеральное государственное бюджетное учреждение науки Институт фундаментальных проблем биологии РАН'),
(6110, 'https://ror.org/01a3sz723', 'ro', 1, 'https://ror.org/01a3sz723 Center of International Projects Centrul de Proiecte Internaţionale'),
(6111, 'https://ror.org/01a4p1q97', 'no_lang_code', 1, 'https://ror.org/01a4p1q97 LNKChemsolutions'),
(6112, 'https://ror.org/01a4t3393', 'en', 1, 'https://ror.org/01a4t3393 Central Electricity Generating Board'),
(6113, 'https://ror.org/01a6cr462', 'de', 1, 'https://ror.org/01a6cr462 Forschungsinstitut für schnellwachsende Baumarten'),
(6114, 'https://ror.org/01a6nzt97', 'no_lang_code', 1, 'https://ror.org/01a6nzt97 Cytobank (United States)'),
(6115, 'https://ror.org/01a8ynn13', 'en', 1, 'https://ror.org/01a8ynn13 The Langton Grammar School for Boys'),
(6116, 'https://ror.org/01a92vw29', 'lv', 1, 'https://ror.org/01a92vw29 Latvian Institute of Organic Synthesis Latvijas Organiskās Sintēzes Institūts'),
(6117, 'https://ror.org/01ab3z839', 'en', 1, 'https://ror.org/01ab3z839 National Perinatal Information Center'),
(6118, 'https://ror.org/01ab8nr44', 'en', 1, 'https://ror.org/01ab8nr44 Council on Undergraduate Research'),
(6119, 'https://ror.org/01ac4hv54', 'it', 1, 'https://ror.org/01ac4hv54 Semeion Centro Ricerche di Scienze della Comunicazione'),
(6120, 'https://ror.org/01ada6a49', 'no_lang_code', 1, 'https://ror.org/01ada6a49 Reaction Biology Corporation (United States)'),
(6121, 'https://ror.org/01ae87070', 'it', 1, 'https://ror.org/01ae87070 Ospedale A. Perrino'),
(6122, 'https://ror.org/01aegrf07', 'en', 1, 'https://ror.org/01aegrf07 Canadian AIDS Society Société Canadienne du Sida'),
(6123, 'https://ror.org/01aetpp13', 'en', 1, 'https://ror.org/01aetpp13 Centre for Process Innovation'),
(6124, 'https://ror.org/01ag6an54', 'en', 1, 'https://ror.org/01ag6an54 Cook Inlet Tribal Council'),
(6125, 'https://ror.org/01ag7n936', 'es', 1, 'https://ror.org/01ag7n936 Centro Rosarino de Estudios Perinatales'),
(6126, 'https://ror.org/01ag8d960', 'no_lang_code', 1, 'https://ror.org/01ag8d960 Global Security Intelligence (United Kingdom)'),
(6127, 'https://ror.org/01ajqvg59', 'en', 1, 'https://ror.org/01ajqvg59 United States Army Aeromedical Research Lab'),
(6128, 'https://ror.org/01amarv06', 'en', 1, 'https://ror.org/01amarv06 v. Bodelschwing Foundation Bethel v. Bodelschwinghsche Stiftungen Bethel'),
(6129, 'https://ror.org/01aptcd74', 'no_lang_code', 1, 'https://ror.org/01aptcd74 Sanofi (Canada)'),
(6130, 'https://ror.org/01aq2db46', 'no_lang_code', 1, 'https://ror.org/01aq2db46 ImmuNext (United States)'),
(6131, 'https://ror.org/01ask7p77', 'no_lang_code', 1, 'https://ror.org/01ask7p77 Sparos (Portugal)'),
(6132, 'https://ror.org/01ass5t61', 'en', 1, 'https://ror.org/01ass5t61 Jean Hailes'),
(6133, 'https://ror.org/01astg473', 'en', 1, 'https://ror.org/01astg473 Japan Biological Informatics Consortium 般社団法人バイオ産業情報化コンソーシアム'),
(6134, 'https://ror.org/01ax1zp32', 'no_lang_code', 1, 'https://ror.org/01ax1zp32 CustomKYnetics (United States)'),
(6135, 'https://ror.org/01ayagd95', 'no_lang_code', 1, 'https://ror.org/01ayagd95 Alternative Futures Associates'),
(6136, 'https://ror.org/01azqfh67', 'en', 1, 'https://ror.org/01azqfh67 Together'),
(6137, 'https://ror.org/01b09k795', 'en', 1, 'https://ror.org/01b09k795 APT Foundation'),
(6138, 'https://ror.org/01b11x021', 'en', 1, 'https://ror.org/01b11x021 Hull and East Yorkshire Hospitals NHS Trust'),
(6139, 'https://ror.org/01b1g5g41', 'en', 1, 'https://ror.org/01b1g5g41 Greater Manchester STEM Centre'),
(6140, 'https://ror.org/01b4q9c55', 'hu', 1, 'https://ror.org/01b4q9c55 National Institute of Clinical Neurosciences Országos Idegsebészeti Tudományos Intézet'),
(6141, 'https://ror.org/01b5xma27', 'en', 1, 'https://ror.org/01b5xma27 Greenfield Community College'),
(6142, 'https://ror.org/01b7jd097', 'ga', 1, 'https://ror.org/01b7jd097 An Garda Síochána'),
(6143, 'https://ror.org/01b9fyy36', 'en', 1, 'https://ror.org/01b9fyy36 Visions of Science Network for Learning'),
(6144, 'https://ror.org/01b9qpe41', 'fr', 1, 'https://ror.org/01b9qpe41 Institut de Recherche en Opthalmologie'),
(6145, 'https://ror.org/01bawqf59', 'en', 1, 'https://ror.org/01bawqf59 Shonan Institute of Technology 湘南工科大学'),
(6146, 'https://ror.org/01bf9rw71', 'en', 1, 'https://ror.org/01bf9rw71 Max Planck Institute for the Physics of Complex Systems Max-Planck-Institut für Physik Komplexer Systeme'),
(6147, 'https://ror.org/01bh4p295', 'en', 1, 'https://ror.org/01bh4p295 Erskine College'),
(6148, 'https://ror.org/01bjkkp81', 'no_lang_code', 1, 'https://ror.org/01bjkkp81 GNS Healthcare (United States)'),
(6149, 'https://ror.org/01bjmbg26', 'en', 1, 'https://ror.org/01bjmbg26 Waterwise'),
(6150, 'https://ror.org/01bk7tw31', 'en', 1, 'https://ror.org/01bk7tw31 Wireless Innovation Forum'),
(6151, 'https://ror.org/01bkx5q50', 'en', 1, 'https://ror.org/01bkx5q50 Centre for Technological Research of Crete'),
(6152, 'https://ror.org/01bnjyq25', 'de', 1, 'https://ror.org/01bnjyq25 GP Forschungsgruppe, Instituts für Grundlagen und Programmforschung'),
(6153, 'https://ror.org/01bp1mp13', 'no_lang_code', 1, 'https://ror.org/01bp1mp13 Photodigm (United States)'),
(6154, 'https://ror.org/01bpck236', 'no_lang_code', 1, 'https://ror.org/01bpck236 Global Relay (Canada)'),
(6155, 'https://ror.org/01bqvsn34', 'en', 1, 'https://ror.org/01bqvsn34 Park Plaza Hospital'),
(6156, 'https://ror.org/01brzkg31', 'no_lang_code', 1, 'https://ror.org/01brzkg31 InstaRecon (United States)'),
(6157, 'https://ror.org/01bs8y378', 'no_lang_code', 1, 'https://ror.org/01bs8y378 Autoimmune Technologies (United States)'),
(6158, 'https://ror.org/01bt01h96', 'en', 1, 'https://ror.org/01bt01h96 Environmental Law Institute'),
(6159, 'https://ror.org/01btmdt42', 'no_lang_code', 1, 'https://ror.org/01btmdt42 Dynavax Technologies (United States)'),
(6160, 'https://ror.org/01btzz102', 'en', 1, 'https://ror.org/01btzz102 University of Health Sciences and Pharmacy'),
(6161, 'https://ror.org/01by6g473', 'en', 1, 'https://ror.org/01by6g473 Central Oregon Community College'),
(6162, 'https://ror.org/01bz6xa25', 'no_lang_code', 1, 'https://ror.org/01bz6xa25 Rigaku (United Kingdom)'),
(6163, 'https://ror.org/01bzgdw81', 'en', 1, 'https://ror.org/01bzgdw81 Indian Agricultural Research Institute भारतीय कृषि अनुसंधान संस्थान இந்திய வேளாண் ஆராய்ச்சிக் கழகம்'),
(6164, 'https://ror.org/01c0hdt76', 'no_lang_code', 1, 'https://ror.org/01c0hdt76 Acumen (United States)'),
(6165, 'https://ror.org/01c0hr456', 'no_lang_code', 1, 'https://ror.org/01c0hr456 Glötzl (Germany)'),
(6166, 'https://ror.org/01c0rkd54', 'no_lang_code', 1, 'https://ror.org/01c0rkd54 Maine Molecular Quality Controls (United States)'),
(6167, 'https://ror.org/01c20ew23', 'en', 1, 'https://ror.org/01c20ew23 Genetics and IVF Institute'),
(6168, 'https://ror.org/01c39ny75', 'no_lang_code', 1, 'https://ror.org/01c39ny75 OcuMetrics (United States)'),
(6169, 'https://ror.org/01c3pwn40', 'no_lang_code', 1, 'https://ror.org/01c3pwn40 Kent Displays (United States)'),
(6170, 'https://ror.org/01c44a921', 'en', 1, 'https://ror.org/01c44a921 Proteogenomics Research Institute for Systems Medicine'),
(6171, 'https://ror.org/01c55m435', 'no_lang_code', 1, 'https://ror.org/01c55m435 Castle Rock Geotech (United Kingdom)'),
(6172, 'https://ror.org/01c5aqt35', 'no_lang_code', 1, 'https://ror.org/01c5aqt35 Danone (Netherlands)'),
(6173, 'https://ror.org/01c5r7j06', 'es', 1, 'https://ror.org/01c5r7j06 Instituto de Neurologia Y Neurocirugia'),
(6174, 'https://ror.org/01c66cc89', 'en', 1, 'https://ror.org/01c66cc89 Prince Albert Grand Council'),
(6175, 'https://ror.org/01c6k3h93', 'no_lang_code', 1, 'https://ror.org/01c6k3h93 Teva Pharmaceuticals (Canada)'),
(6176, 'https://ror.org/01c7jsk34', 'en', 1, 'https://ror.org/01c7jsk34 National Institute for Pharmaceutical Research and Development'),
(6177, 'https://ror.org/01c8cwz57', 'fr', 1, 'https://ror.org/01c8cwz57 Institut pour la Recherche sur le Cancer de Lille'),
(6178, 'https://ror.org/01c997669', 'en', 1, 'https://ror.org/01c997669 Max Planck Institute for Chemical Physics of Solids Max-Planck-Institut für Chemische Physik Fester Stoffe'),
(6179, 'https://ror.org/01c9wxw51', 'no_lang_code', 1, 'https://ror.org/01c9wxw51 ImQuest BioSciences (United States)'),
(6180, 'https://ror.org/01cacm735', 'en', 1, 'https://ror.org/01cacm735 Fortis Escorts Heart Institute'),
(6181, 'https://ror.org/01cegnf65', 'en', 1, 'https://ror.org/01cegnf65 American Indian Science and Engineering Society'),
(6182, 'https://ror.org/01cf5z404', 'no_lang_code', 1, 'https://ror.org/01cf5z404 Robin Medical (United States)'),
(6183, 'https://ror.org/01cfdy756', 'en', 1, 'https://ror.org/01cfdy756 Marie Selby Botanical Gardens'),
(6184, 'https://ror.org/01cfgbq85', 'it', 1, 'https://ror.org/01cfgbq85 Azienda Sanitaria di Firenze'),
(6185, 'https://ror.org/01chs2347', 'no_lang_code', 1, 'https://ror.org/01chs2347 Ingegneria dei Sistemi (United Kingdom)'),
(6186, 'https://ror.org/01cj6ar20', 'no_lang_code', 1, 'https://ror.org/01cj6ar20 DiscoveryBioMed (United States)'),
(6187, 'https://ror.org/01ck0pr88', 'en', 1, 'https://ror.org/01ck0pr88 Bradford Royal Infirmary'),
(6188, 'https://ror.org/01cmq9k07', 'no_lang_code', 1, 'https://ror.org/01cmq9k07 Institute for Learning Innovation (United States)'),
(6189, 'https://ror.org/01cnxmm67', 'en', 1, 'https://ror.org/01cnxmm67 Morris Brown College'),
(6190, 'https://ror.org/01ctbbh52', 'en', 1, 'https://ror.org/01ctbbh52 Palmerston North Hospital'),
(6191, 'https://ror.org/01cx4xa29', 'de', 1, 'https://ror.org/01cx4xa29 Fondation pour la Sécurité des Patients Stiftung Patientensicherheit Schweiz'),
(6192, 'https://ror.org/01cyxs230', 'en', 1, 'https://ror.org/01cyxs230 Shanghai Blood Center'),
(6193, 'https://ror.org/01d1kad18', 'no_lang_code', 1, 'https://ror.org/01d1kad18 Otaru Municipal Hospital 小樽市立病院'),
(6194, 'https://ror.org/01d2yj180', 'no_lang_code', 1, 'https://ror.org/01d2yj180 Technology For Magnetic Resonance (United States)'),
(6195, 'https://ror.org/01d3e8y10', 'en', 1, 'https://ror.org/01d3e8y10 International Institute of Anthropology'),
(6196, 'https://ror.org/01d6tbx77', 'en', 1, 'https://ror.org/01d6tbx77 Worcestershire Royal Hospital'),
(6197, 'https://ror.org/01d71vb80', 'en', 1, 'https://ror.org/01d71vb80 Fernández-Vega Ophthalmological Institute'),
(6198, 'https://ror.org/01d9afc73', 'en', 1, 'https://ror.org/01d9afc73 Montrose Center'),
(6199, 'https://ror.org/01d9x6s51', 'fr', 1, 'https://ror.org/01d9x6s51 Centre Technique de l''Industrie du Bois'),
(6200, 'https://ror.org/01d9xyz57', 'en', 1, 'https://ror.org/01d9xyz57 Paul Smith''s College'),
(6201, 'https://ror.org/01dd0rh60', 'no_lang_code', 1, 'https://ror.org/01dd0rh60 NuvoGen Research (United States)'),
(6202, 'https://ror.org/01ddmwy83', 'fr', 1, 'https://ror.org/01ddmwy83 Centre Ophtalmologique d''Imagerie et de Laser'),
(6203, 'https://ror.org/01ddxdd19', 'no_lang_code', 1, 'https://ror.org/01ddxdd19 Constructions Industrielles de la Méditerranée (France)'),
(6204, 'https://ror.org/01decj058', 'no_lang_code', 1, 'https://ror.org/01decj058 Dianon (United States)'),
(6205, 'https://ror.org/01df0yh77', 'no_lang_code', 1, 'https://ror.org/01df0yh77 Condax (United States)'),
(6206, 'https://ror.org/01dg04253', 'en', 1, 'https://ror.org/01dg04253 Institute of Bioorganic Chemistry Федеральное государственное бюджетное учреждение науки Институт биоорганической химии им. академиков М.М. Шемякина и Ю.А. Овчинникова Российской академии наук'),
(6207, 'https://ror.org/01dhwg439', 'no_lang_code', 1, 'https://ror.org/01dhwg439 Hauser (United States)'),
(6208, 'https://ror.org/01dk0y732', 'no_lang_code', 1, 'https://ror.org/01dk0y732 Advanced Lightweight Engineering (Netherlands)'),
(6209, 'https://ror.org/01dk4b453', 'en', 1, 'https://ror.org/01dk4b453 Pasadena City College'),
(6210, 'https://ror.org/01dk89r22', 'en', 1, 'https://ror.org/01dk89r22 City Colleges of Chicago Colegios Comunitarios de Chicago'),
(6211, 'https://ror.org/01dm0m970', 'no_lang_code', 1, 'https://ror.org/01dm0m970 Alethia Biotherapeutics (Canada)'),
(6212, 'https://ror.org/01dmjt679', 'en', 1, 'https://ror.org/01dmjt679 Roessingh Research and Development'),
(6213, 'https://ror.org/01dp60j32', 'no_lang_code', 1, 'https://ror.org/01dp60j32 International Rectifier (United Kingdom)'),
(6214, 'https://ror.org/01dp84930', 'no_lang_code', 1, 'https://ror.org/01dp84930 Indium Corporation (United States)'),
(6215, 'https://ror.org/01dpfst30', 'no_lang_code', 1, 'https://ror.org/01dpfst30 MicroLink Devices (United States)'),
(6216, 'https://ror.org/01dq23791', 'it', 1, 'https://ror.org/01dq23791 Ospedale Civile di Vittorio Veneto'),
(6217, 'https://ror.org/01dqayp38', 'en', 1, 'https://ror.org/01dqayp38 College of Family Physicians of Canada Le Collège des Médecins de Famille du Canada'),
(6218, 'https://ror.org/01dswgm35', 'en', 1, 'https://ror.org/01dswgm35 Talladega College'),
(6219, 'https://ror.org/01dvp8b67', 'en', 1, 'https://ror.org/01dvp8b67 Combustion Institute'),
(6220, 'https://ror.org/01dwzs847', 'no_lang_code', 1, 'https://ror.org/01dwzs847 Cell Gate (United States)'),
(6221, 'https://ror.org/01dy2q607', 'it', 1, 'https://ror.org/01dy2q607 Istituto di Biomedicina e di Immunologia Molecolare Alberto Monroy'),
(6222, 'https://ror.org/01e17d143', 'en', 1, 'https://ror.org/01e17d143 Institute of Organic Chemistry Instytut Chemii Organicznej PAN'),
(6223, 'https://ror.org/01e2q0308', 'fr', 1, 'https://ror.org/01e2q0308 Hôpital de l''Antiquaille'),
(6224, 'https://ror.org/01e47qp55', 'no_lang_code', 1, 'https://ror.org/01e47qp55 Mapp Biopharmaceutical (United States)'),
(6225, 'https://ror.org/01e6deg73', 'en', 1, 'https://ror.org/01e6deg73 Baylor College of Medicine Children’s Foundation'),
(6226, 'https://ror.org/01e70mw69', 'en', 1, 'https://ror.org/01e70mw69 Indian Institute of Toxicology Research भारतीय विषविज्ञान अनुसंधान संस्थान'),
(6227, 'https://ror.org/01e8bdb34', 'no_lang_code', 1, 'https://ror.org/01e8bdb34 SRK Healthcare (United States)'),
(6228, 'https://ror.org/01e8tvg28', 'it', 1, 'https://ror.org/01e8tvg28 Fondazione Salvatore Maugeri'),
(6229, 'https://ror.org/01e94xy17', 'en', 1, 'https://ror.org/01e94xy17 Northern New Mexico College'),
(6230, 'https://ror.org/01eadrh05', 'en', 1, 'https://ror.org/01eadrh05 Oregon Clinic'),
(6231, 'https://ror.org/01ecs7r71', 'no_lang_code', 1, 'https://ror.org/01ecs7r71 LungLife AI (United States)'),
(6232, 'https://ror.org/01ef4m131', 'no_lang_code', 1, 'https://ror.org/01ef4m131 Sirnaomics (United States)'),
(6233, 'https://ror.org/01egexe84', 'no_lang_code', 1, 'https://ror.org/01egexe84 Kardium (Canada)'),
(6234, 'https://ror.org/01ek5c080', 'en', 1, 'https://ror.org/01ek5c080 Methodist Richardson Medical Center'),
(6235, 'https://ror.org/01em4t310', 'no_lang_code', 1, 'https://ror.org/01em4t310 Analogue Theatre (United Kingdom)'),
(6236, 'https://ror.org/01engnx74', 'en', 1, 'https://ror.org/01engnx74 Cystic Fibrosis Research Foundation'),
(6237, 'https://ror.org/01eqrs044', 'no_lang_code', 1, 'https://ror.org/01eqrs044 Sensei Biotherapeutics (United States)'),
(6238, 'https://ror.org/01ey27e46', 'no_lang_code', 1, 'https://ror.org/01ey27e46 Biopac (United Kingdom)'),
(6239, 'https://ror.org/01ez8ve21', 'en', 1, 'https://ror.org/01ez8ve21 Special Health Resources for Texas'),
(6240, 'https://ror.org/01ezk2d60', 'no_lang_code', 1, 'https://ror.org/01ezk2d60 Indian Drugs and Pharmaceuticals Limited'),
(6241, 'https://ror.org/01f02ys47', 'no_lang_code', 1, 'https://ror.org/01f02ys47 Gateway Community Services (United States)'),
(6242, 'https://ror.org/01f0wmg23', 'en', 1, 'https://ror.org/01f0wmg23 Stone Child College'),
(6243, 'https://ror.org/01f1j2n15', 'en', 1, 'https://ror.org/01f1j2n15 Educational Service District 112'),
(6244, 'https://ror.org/01f2jgq77', 'en', 1, 'https://ror.org/01f2jgq77 H2O 4 All'),
(6245, 'https://ror.org/01f3h2s79', 'no_lang_code', 1, 'https://ror.org/01f3h2s79 Agennix (United States)'),
(6246, 'https://ror.org/01f3njc68', 'en', 1, 'https://ror.org/01f3njc68 National Maritime Museum'),
(6247, 'https://ror.org/01f3qhk13', 'en', 1, 'https://ror.org/01f3qhk13 Riekes Center for Human Enhancement'),
(6248, 'https://ror.org/01f7dp456', 'en', 1, 'https://ror.org/01f7dp456 Ministry of Food and Drug Safety'),
(6249, 'https://ror.org/01f7q1k19', 'no_lang_code', 1, 'https://ror.org/01f7q1k19 DKI Plast (Denmark)'),
(6250, 'https://ror.org/01f8vhd41', 'pt', 1, 'https://ror.org/01f8vhd41 Instituto Nacional de Metrologia, Qualidade e Tecnologia National Institute of Metrology Quality and Technology'),
(6251, 'https://ror.org/01famp260', 'no_lang_code', 1, 'https://ror.org/01famp260 BOC (Austria)'),
(6252, 'https://ror.org/01faz8m53', 'no_lang_code', 1, 'https://ror.org/01faz8m53 MicroOptical Engineering (United States)'),
(6253, 'https://ror.org/01fbde567', 'en', 1, 'https://ror.org/01fbde567 Max Planck Institute of Molecular Plant Physiology Max-Planck-Institut für molekulare Pflanzenphysiologie'),
(6254, 'https://ror.org/01fbet514', 'no_lang_code', 1, 'https://ror.org/01fbet514 BioChem Technology (United States)'),
(6255, 'https://ror.org/01fbp1n03', 'no_lang_code', 1, 'https://ror.org/01fbp1n03 Synthecon (United States)'),
(6256, 'https://ror.org/01fdz0a43', 'no_lang_code', 1, 'https://ror.org/01fdz0a43 Ribonomics (United States)'),
(6257, 'https://ror.org/01fev7c67', 'en', 1, 'https://ror.org/01fev7c67 Confederation of European Forest Owners Confédération Européenne des Propriétaires Forestiers'),
(6258, 'https://ror.org/01fgq8278', 'no_lang_code', 1, 'https://ror.org/01fgq8278 DSM (Switzerland)'),
(6259, 'https://ror.org/01fh9k283', 'es', 1, 'https://ror.org/01fh9k283 Fundación Instituto Valenciano de Oncología'),
(6260, 'https://ror.org/01fk4js58', 'en', 1, 'https://ror.org/01fk4js58 Sacred Space Foundation'),
(6261, 'https://ror.org/01fptm710', 'pt', 1, 'https://ror.org/01fptm710 Instituto de Botânica'),
(6262, 'https://ror.org/01fqgdy56', 'en', 1, 'https://ror.org/01fqgdy56 Baikov Institute of Metallurgy and Materials Science Федеральное государственное бюджетное учреждение науки Институт металлургии и материаловедения им. А.А. Байкова Российской академии наук'),
(6263, 'https://ror.org/01fr3an09', 'no_lang_code', 1, 'https://ror.org/01fr3an09 BMT Group (Netherlands)'),
(6264, 'https://ror.org/01ftkxq60', 'no_lang_code', 1, 'https://ror.org/01ftkxq60 Cytel (United States)'),
(6265, 'https://ror.org/01fydjk85', 'no_lang_code', 1, 'https://ror.org/01fydjk85 Earth Images Foundation (United States)'),
(6266, 'https://ror.org/01fz8x241', 'en', 1, 'https://ror.org/01fz8x241 National Hemophilia Foundation'),
(6267, 'https://ror.org/01g0q1j14', 'en', 1, 'https://ror.org/01g0q1j14 Converse College'),
(6268, 'https://ror.org/01g19gh26', 'no_lang_code', 1, 'https://ror.org/01g19gh26 Carter Printing Company (United States)'),
(6269, 'https://ror.org/01g1che35', 'no_lang_code', 1, 'https://ror.org/01g1che35 Trudell Medical International (Canada)'),
(6270, 'https://ror.org/01g1mnc10', 'no_lang_code', 1, 'https://ror.org/01g1mnc10 Transfusion and Transplantation Technologies (United States)'),
(6271, 'https://ror.org/01g31bd79', 'en', 1, 'https://ror.org/01g31bd79 International Technology and Engineering Educators Association'),
(6272, 'https://ror.org/01g4j3g78', 'en', 1, 'https://ror.org/01g4j3g78 Vanha Vaasa hospital Vanhan Vaasan Sairaala'),
(6273, 'https://ror.org/01g7qth32', 'en', 1, 'https://ror.org/01g7qth32 Institute of Minerals and Materials Technology'),
(6274, 'https://ror.org/01g7ypx22', 'en', 1, 'https://ror.org/01g7ypx22 Washington Department of Social and Health Services'),
(6275, 'https://ror.org/01g8b9k67', 'en', 1, 'https://ror.org/01g8b9k67 Center for Image Processing in Education'),
(6276, 'https://ror.org/01g8hb609', 'it', 1, 'https://ror.org/01g8hb609 Consorzio Catania Ricerche'),
(6277, 'https://ror.org/01g9x3v85', 'en', 1, 'https://ror.org/01g9x3v85 Agencia Federal para el Manejo de Emergencias Federal Emergency Management Agency'),
(6278, 'https://ror.org/01ga31z69', 'no_lang_code', 1, 'https://ror.org/01ga31z69 Cochlear (United States)'),
(6279, 'https://ror.org/01gazqa80', 'pt', 1, 'https://ror.org/01gazqa80 Centro de Biotecnologia Agrícola e Agro Alimentar do Alentejo'),
(6280, 'https://ror.org/01gchcj93', 'no_lang_code', 1, 'https://ror.org/01gchcj93 South Carolina ETV (United States)'),
(6281, 'https://ror.org/01gckhp53', 'en', 1, 'https://ror.org/01gckhp53 Latvian Biomedical Research and Study Centre Latvijas Biomedicīnas Pētījumu un Studiju Centrs'),
(6282, 'https://ror.org/01gfdf281', 'no_lang_code', 1, 'https://ror.org/01gfdf281 Agave BioSystems (United States)'),
(6283, 'https://ror.org/01gh7yb82', 'no_lang_code', 1, 'https://ror.org/01gh7yb82 Center of Molecular Immunology (Cuba)'),
(6284, 'https://ror.org/01gkkh788', 'no_lang_code', 1, 'https://ror.org/01gkkh788 National One Call (United Kingdom)'),
(6285, 'https://ror.org/01gnjkm30', 'no_lang_code', 1, 'https://ror.org/01gnjkm30 Kapteyn Murnane Laboratories'),
(6286, 'https://ror.org/01gp1hk26', 'en', 1, 'https://ror.org/01gp1hk26 North American Association of Central Cancer Registries'),
(6287, 'https://ror.org/01gq2tr09', 'fr', 1, 'https://ror.org/01gq2tr09 Association pour le Développement de la Recherche et de l''Innovation du Québec'),
(6288, 'https://ror.org/01gq5z667', 'no_lang_code', 1, 'https://ror.org/01gq5z667 BYG Systems (United Kingdom)'),
(6289, 'https://ror.org/01gqzkt51', 'no_lang_code', 1, 'https://ror.org/01gqzkt51 Second Foundation (United States)'),
(6290, 'https://ror.org/01gswfc04', 'en', 1, 'https://ror.org/01gswfc04 El Paso Community College'),
(6291, 'https://ror.org/01gvaa828', 'fr', 1, 'https://ror.org/01gvaa828 Hôpital d''Enfants'),
(6292, 'https://ror.org/01gvm4v91', 'no_lang_code', 1, 'https://ror.org/01gvm4v91 Advanced Genetic Systems (United States)'),
(6293, 'https://ror.org/01gwh4g82', 'en', 1, 'https://ror.org/01gwh4g82 Energy Saving Trust'),
(6294, 'https://ror.org/01gxrtw55', 'en', 1, 'https://ror.org/01gxrtw55 E.O. Paton Electric Welding Institute Інститут електрозварювання ім.Є.О.Патона'),
(6295, 'https://ror.org/01h0ca774', 'en', 1, 'https://ror.org/01h0ca774 Research Institute of Ophthalmology'),
(6296, 'https://ror.org/01h0h7640', 'no_lang_code', 1, 'https://ror.org/01h0h7640 Tata Motors (United Kingdom)'),
(6297, 'https://ror.org/01h1sgg38', 'no_lang_code', 1, 'https://ror.org/01h1sgg38 Meridian Instrument (United States)'),
(6298, 'https://ror.org/01h42mb65', 'no_lang_code', 1, 'https://ror.org/01h42mb65 Medical Decision Modeling (United States)'),
(6299, 'https://ror.org/01h8ey223', 'it', 1, 'https://ror.org/01h8ey223 MultiMedica'),
(6300, 'https://ror.org/01h8my706', 'no_lang_code', 1, 'https://ror.org/01h8my706 Ascometal (France)'),
(6301, 'https://ror.org/01h8tw896', 'no_lang_code', 1, 'https://ror.org/01h8tw896 Touch of Life Technologies (United States)'),
(6302, 'https://ror.org/01h95gp06', 'no_lang_code', 1, 'https://ror.org/01h95gp06 FMC (United States)'),
(6303, 'https://ror.org/01h96am38', 'en', 1, 'https://ror.org/01h96am38 Zeynep Kamil Hospital Zeynep Kamil Kadın ve Çocuk Hastalıkları Eğitim Ve Araştırma Hastanesi'),
(6304, 'https://ror.org/01hbes477', 'en', 1, 'https://ror.org/01hbes477 Franciscan Health'),
(6305, 'https://ror.org/01hdk3d05', 'en', 1, 'https://ror.org/01hdk3d05 San Antonio College'),
(6306, 'https://ror.org/01heabd70', 'no_lang_code', 1, 'https://ror.org/01heabd70 Signum Biosciences (United States)'),
(6307, 'https://ror.org/01hmaf534', 'en', 1, 'https://ror.org/01hmaf534 Northland College'),
(6308, 'https://ror.org/01hnx4w34', 'en', 1, 'https://ror.org/01hnx4w34 Museu Nacional do Azulejo National Azulejo Museum'),
(6309, 'https://ror.org/01hny1h96', 'no_lang_code', 1, 'https://ror.org/01hny1h96 Efkon (Austria)'),
(6310, 'https://ror.org/01hpb1x88', 'no_lang_code', 1, 'https://ror.org/01hpb1x88 EKOS Corporation'),
(6311, 'https://ror.org/01hr7mm17', 'no_lang_code', 1, 'https://ror.org/01hr7mm17 Regis Technologies (United States)'),
(6312, 'https://ror.org/01hrt5088', 'en', 1, 'https://ror.org/01hrt5088 Catawba College'),
(6313, 'https://ror.org/01hs8x754', 'en', 1, 'https://ror.org/01hs8x754 Tygerberg Hospital'),
(6314, 'https://ror.org/01htjvr84', 'en', 1, 'https://ror.org/01htjvr84 Institute of Primate Research'),
(6315, 'https://ror.org/01hw8xc07', 'en', 1, 'https://ror.org/01hw8xc07 Northern Illinois Council on Alcohol and Substance Abuse'),
(6316, 'https://ror.org/01hwxey28', 'en', 1, 'https://ror.org/01hwxey28 Volunteers of America Los Angeles'),
(6317, 'https://ror.org/01hx92781', 'en', 1, 'https://ror.org/01hx92781 Children''s Tumor Foundation'),
(6318, 'https://ror.org/01hzacg10', 'no_lang_code', 1, 'https://ror.org/01hzacg10 Meticube (Portugal)'),
(6319, 'https://ror.org/01j1cwt71', 'en', 1, 'https://ror.org/01j1cwt71 Westminster College - Pennsylvania'),
(6320, 'https://ror.org/01j1pyg35', 'no_lang_code', 1, 'https://ror.org/01j1pyg35 OriGene (United States)'),
(6321, 'https://ror.org/01j39zs89', 'no_lang_code', 1, 'https://ror.org/01j39zs89 GVS (Italy)'),
(6322, 'https://ror.org/01j538c21', 'no_lang_code', 1, 'https://ror.org/01j538c21 Evotec (United States)'),
(6323, 'https://ror.org/01j8wfy63', 'no_lang_code', 1, 'https://ror.org/01j8wfy63 InnoSense (United States)'),
(6324, 'https://ror.org/01j9bf827', 'en', 1, 'https://ror.org/01j9bf827 Zane State College'),
(6325, 'https://ror.org/01jbsjf80', 'es', 1, 'https://ror.org/01jbsjf80 Instituto Costarricense de Investigación y Enseñanza en Nutrición y Salud'),
(6326, 'https://ror.org/01jgbgc06', 'en', 1, 'https://ror.org/01jgbgc06 A.V. Topchiev Institute of Petrochemical Synthesis Институт нефтехимического синтеза им. А.В.Топчиева'),
(6327, 'https://ror.org/01jgzbz02', 'no_lang_code', 1, 'https://ror.org/01jgzbz02 Advanticsys (Spain)'),
(6328, 'https://ror.org/01jj7aa83', 'no_lang_code', 1, 'https://ror.org/01jj7aa83 Environmental Protection Engineering (Greece)'),
(6329, 'https://ror.org/01jm0aq25', 'en', 1, 'https://ror.org/01jm0aq25 Alaska Federation of Natives'),
(6330, 'https://ror.org/01jnyam78', 'en', 1, 'https://ror.org/01jnyam78 Jarvis Christian College'),
(6331, 'https://ror.org/01jpszw66', 'no_lang_code', 1, 'https://ror.org/01jpszw66 Cirrascale (United States)'),
(6332, 'https://ror.org/01jq6tw89', 'no_lang_code', 1, 'https://ror.org/01jq6tw89 Argonon (United Kingdom)'),
(6333, 'https://ror.org/01jt2bg47', 'no_lang_code', 1, 'https://ror.org/01jt2bg47 QUAD Engineering (Canada)'),
(6334, 'https://ror.org/01jtghg16', 'no_lang_code', 1, 'https://ror.org/01jtghg16 DiscoveRx (United States)'),
(6335, 'https://ror.org/01jv71z12', 'en', 1, 'https://ror.org/01jv71z12 International Society for Computational Biology'),
(6336, 'https://ror.org/01jy3gh06', 'de', 1, 'https://ror.org/01jy3gh06 Hochrhein Institut für Rehabilitationsforschung'),
(6337, 'https://ror.org/01jy49h31', 'no_lang_code', 1, 'https://ror.org/01jy49h31 Autoliv (Sweden)'),
(6338, 'https://ror.org/01k1ftz35', 'no_lang_code', 1, 'https://ror.org/01k1ftz35 Novartis (Japan) ノバルティス ファーマ株式会社'),
(6339, 'https://ror.org/01k458340', 'no_lang_code', 1, 'https://ror.org/01k458340 Vancouver Biotech (Canada)'),
(6340, 'https://ror.org/01k57xn28', 'sr', 1, 'https://ror.org/01k57xn28 Institut za kardiovaskularne bolesti Dedinje'),
(6341, 'https://ror.org/01k6b9k02', 'en', 1, 'https://ror.org/01k6b9k02 Fuller Theological Seminary Seminario Teológico Fuller'),
(6342, 'https://ror.org/01k6bda33', 'no_lang_code', 1, 'https://ror.org/01k6bda33 Colibri (Netherlands)'),
(6343, 'https://ror.org/01k703c10', 'fr', 1, 'https://ror.org/01k703c10 Centre Hospitalier de l''Agglomération de Nevers'),
(6344, 'https://ror.org/01kfp4j62', 'no_lang_code', 1, 'https://ror.org/01kfp4j62 UNICOM Global (United States)'),
(6345, 'https://ror.org/01kmcf465', 'fr', 1, 'https://ror.org/01kmcf465 Belgian Centre for Corrosion Study Centre Belge d''Etude de la Corrosion'),
(6346, 'https://ror.org/01kn86d52', 'en', 1, 'https://ror.org/01kn86d52 Shelton State Community College'),
(6347, 'https://ror.org/01kngac24', 'no_lang_code', 1, 'https://ror.org/01kngac24 A Thinking Ape (Canada)'),
(6348, 'https://ror.org/01kpfrj42', 'no_lang_code', 1, 'https://ror.org/01kpfrj42 Potomac Photonics (United States)'),
(6349, 'https://ror.org/01ks7f963', 'en', 1, 'https://ror.org/01ks7f963 National Center for Disease Control राष्ट्रीय संसर्गजन्य रोग नियंत्रण संस्था'),
(6350, 'https://ror.org/01kys6733', 'en', 1, 'https://ror.org/01kys6733 Danish Emergency Management Agency'),
(6351, 'https://ror.org/01m108388', 'no_lang_code', 1, 'https://ror.org/01m108388 Dimension Technologies (United States)'),
(6352, 'https://ror.org/01m11yv70', 'no_lang_code', 1, 'https://ror.org/01m11yv70 Aktiv-Dry (United States)'),
(6353, 'https://ror.org/01m178w43', 'en', 1, 'https://ror.org/01m178w43 Lahey Medical Center'),
(6354, 'https://ror.org/01m260238', 'no_lang_code', 1, 'https://ror.org/01m260238 Ateknea Solutions (Spain)'),
(6355, 'https://ror.org/01m2bq033', 'no_lang_code', 1, 'https://ror.org/01m2bq033 BlueRISC (United States)'),
(6356, 'https://ror.org/01m30h796', 'no_lang_code', 1, 'https://ror.org/01m30h796 Sun Innovations (United States)'),
(6357, 'https://ror.org/01m7qnr31', 'es', 1, 'https://ror.org/01m7qnr31 Ente Vasco de la Energía'),
(6358, 'https://ror.org/01mb01m85', 'no_lang_code', 1, 'https://ror.org/01mb01m85 HEICO (United States)'),
(6359, 'https://ror.org/01mbxzz40', 'en', 1, 'https://ror.org/01mbxzz40 Arts Council England'),
(6360, 'https://ror.org/01mc1qv75', 'no_lang_code', 1, 'https://ror.org/01mc1qv75 Kestrel Labs (United States)'),
(6361, 'https://ror.org/01mdbyv68', 'en', 1, 'https://ror.org/01mdbyv68 Nuclear Decommissioning Authority'),
(6362, 'https://ror.org/01met4463', 'no_lang_code', 1, 'https://ror.org/01met4463 Limagrain (United Kingdom)'),
(6363, 'https://ror.org/01mhgyv56', 'es', 1, 'https://ror.org/01mhgyv56 Complejo Hospitalario de Cáceres'),
(6364, 'https://ror.org/01mkye871', 'en', 1, 'https://ror.org/01mkye871 UPMC Altoona'),
(6365, 'https://ror.org/01mmn7c12', 'no_lang_code', 1, 'https://ror.org/01mmn7c12 D-Wave Systems (Canada)'),
(6366, 'https://ror.org/01mntwa59', 'no_lang_code', 1, 'https://ror.org/01mntwa59 Palatin Technologies (United States)'),
(6367, 'https://ror.org/01mpm4k64', 'en', 1, 'https://ror.org/01mpm4k64 Central Research Institute of Epidemiology ФБУН Центральный НИИ эпидемиологии Роспотребнадзора'),
(6368, 'https://ror.org/01mq7rh19', 'no_lang_code', 1, 'https://ror.org/01mq7rh19 Biogate Laboratories (Canada)'),
(6369, 'https://ror.org/01mq8sh52', 'en', 1, 'https://ror.org/01mq8sh52 Institute of Biophysics Федеральное государственное бюджетное учреждение науки Институт биофизики клетки Российской академии наук'),
(6370, 'https://ror.org/01ms1q761', 'no_lang_code', 1, 'https://ror.org/01ms1q761 Bio Signal Group (United States)'),
(6371, 'https://ror.org/01mtp2k51', 'no_lang_code', 1, 'https://ror.org/01mtp2k51 Sunstar (Japan) サンスター'),
(6372, 'https://ror.org/01mv6bt66', 'no_lang_code', 1, 'https://ror.org/01mv6bt66 Chr. Hansen (Denmark)'),
(6373, 'https://ror.org/01mvmtd83', 'en', 1, 'https://ror.org/01mvmtd83 Cicatelli Associates'),
(6374, 'https://ror.org/01mvsby80', 'pt', 1, 'https://ror.org/01mvsby80 Agencia de Inovacao, Agência Nacional de Inovação'),
(6375, 'https://ror.org/01mw31v11', 'no_lang_code', 1, 'https://ror.org/01mw31v11 Simpleware (United Kingdom)'),
(6376, 'https://ror.org/01myrq118', 'en', 1, 'https://ror.org/01myrq118 Hastings College'),
(6377, 'https://ror.org/01n42m123', 'no_lang_code', 1, 'https://ror.org/01n42m123 Forschungsgesellschaft Kraftfahrwesen Aachen (Germany)'),
(6378, 'https://ror.org/01n45xa04', 'en', 1, 'https://ror.org/01n45xa04 National Kidney Foundation'),
(6379, 'https://ror.org/01n6e6j62', 'en', 1, 'https://ror.org/01n6e6j62 Agence des États-Unis pour le Développement International Agencia de los Estados Unidos para el Desarrollo Internacional United States Agency for International Development'),
(6380, 'https://ror.org/01n7gem85', 'de', 1, 'https://ror.org/01n7gem85 Deutsche Nationalbibliothek German National Library'),
(6381, 'https://ror.org/01naa4k48', 'no_lang_code', 1, 'https://ror.org/01naa4k48 Dunreidy Engneering (Ireland)'),
(6382, 'https://ror.org/01ncrbb53', 'no_lang_code', 1, 'https://ror.org/01ncrbb53 Gerber Technology (United States)'),
(6383, 'https://ror.org/01nd9hr79', 'en', 1, 'https://ror.org/01nd9hr79 Forth Valley Royal Hospital'),
(6384, 'https://ror.org/01nda5g26', 'no_lang_code', 1, 'https://ror.org/01nda5g26 KDH Research & Communication (United States)'),
(6385, 'https://ror.org/01ng18e06', 'no_lang_code', 1, 'https://ror.org/01ng18e06 A K Industries (United Kingdom)'),
(6386, 'https://ror.org/01njgag08', 'en', 1, 'https://ror.org/01njgag08 Japan Women''s College of Physical Education 日本女子体育大学'),
(6387, 'https://ror.org/01nk4hm61', 'en', 1, 'https://ror.org/01nk4hm61 Mesa Community College'),
(6388, 'https://ror.org/01nq1wn92', 'no_lang_code', 1, 'https://ror.org/01nq1wn92 VitaCyte (United States)'),
(6389, 'https://ror.org/01nqc4p29', 'no_lang_code', 1, 'https://ror.org/01nqc4p29 Workplace Technologies Research'),
(6390, 'https://ror.org/01nqsgv54', 'en', 1, 'https://ror.org/01nqsgv54 Headache & Pain Center of Palm Beach'),
(6391, 'https://ror.org/01nsxt963', 'it', 1, 'https://ror.org/01nsxt963 Ospedale Civile Di Ivrea'),
(6392, 'https://ror.org/01nzxq896', 'en', 1, 'https://ror.org/01nzxq896 VA North Texas Health Care System'),
(6393, 'https://ror.org/01nzyv932', 'no_lang_code', 1, 'https://ror.org/01nzyv932 CDM Group (United States)'),
(6394, 'https://ror.org/01p165j02', 'no_lang_code', 1, 'https://ror.org/01p165j02 Chemat Technology (United States)'),
(6395, 'https://ror.org/01p19k166', 'en', 1, 'https://ror.org/01p19k166 Royal Victoria Infirmary');
INSERT INTO `rors` VALUES
(6396, 'https://ror.org/01p3q4q56', 'en', 1, 'https://ror.org/01p3q4q56 Institute of Cytology Федеральное государственное бюджетное учреждение науки Институт цитологии Российской академии наук'),
(6397, 'https://ror.org/01p3rh655', 'en', 1, 'https://ror.org/01p3rh655 American Lung Association'),
(6398, 'https://ror.org/01p4ajf23', 'no_lang_code', 1, 'https://ror.org/01p4ajf23 ANDE (United States)'),
(6399, 'https://ror.org/01p4cne93', 'en', 1, 'https://ror.org/01p4cne93 National Center for Genome Resources'),
(6400, 'https://ror.org/01p5m7v59', 'en', 1, 'https://ror.org/01p5m7v59 National Vaccine and Serum Institute'),
(6401, 'https://ror.org/01p6fxr81', 'it', 1, 'https://ror.org/01p6fxr81 Cooperativa Sociale COOSS Marche Onlus'),
(6402, 'https://ror.org/01p7aam65', 'no_lang_code', 1, 'https://ror.org/01p7aam65 FuelCell Energy (Canada)'),
(6403, 'https://ror.org/01p7p3890', 'pt', 1, 'https://ror.org/01p7p3890 Faculdade de Ciências Médicas de Minas Gerais'),
(6404, 'https://ror.org/01p7ws813', 'no_lang_code', 1, 'https://ror.org/01p7ws813 Adamis Pharmaceuticals (United States)'),
(6405, 'https://ror.org/01p92hb48', 'en', 1, 'https://ror.org/01p92hb48 National Technical Information Service'),
(6406, 'https://ror.org/01p9xjz77', 'en', 1, 'https://ror.org/01p9xjz77 College of Exploration'),
(6407, 'https://ror.org/01pa88s49', 'no_lang_code', 1, 'https://ror.org/01pa88s49 Diamond Materials (United States)'),
(6408, 'https://ror.org/01pbz7c04', 'en', 1, 'https://ror.org/01pbz7c04 Mediterranean Agronomic Institute of Chania'),
(6409, 'https://ror.org/01pewsd85', 'en', 1, 'https://ror.org/01pewsd85 Estonian Academy of Sciences'),
(6410, 'https://ror.org/01pg2qx87', 'en', 1, 'https://ror.org/01pg2qx87 Cambridge City Council'),
(6411, 'https://ror.org/01phfda22', 'no_lang_code', 1, 'https://ror.org/01phfda22 Nutreco (Canada)'),
(6412, 'https://ror.org/01pj98103', 'no_lang_code', 1, 'https://ror.org/01pj98103 Vista Photonics (United States)'),
(6413, 'https://ror.org/01pphqm45', 'en', 1, 'https://ror.org/01pphqm45 Kazan Institute of Biochemistry and Biophysics Федеральное государственное бюджетное учреждение науки Казанский институт биохимии и биофизики Казанского научного центра Российской академии наук'),
(6414, 'https://ror.org/01pq15308', 'de', 1, 'https://ror.org/01pq15308 Biochemisches Institut für Umweltcarcinogene'),
(6415, 'https://ror.org/01pq38j30', 'en', 1, 'https://ror.org/01pq38j30 Bennington College'),
(6416, 'https://ror.org/01ptddh35', 'en', 1, 'https://ror.org/01ptddh35 Island Institute'),
(6417, 'https://ror.org/01ptsgx95', 'fr', 1, 'https://ror.org/01ptsgx95 Institut National d''Hygiène du Maroc'),
(6418, 'https://ror.org/01pv1vb28', 'pl', 1, 'https://ror.org/01pv1vb28 Samodzielny Publiczny Centralny Szpital Kliniczny'),
(6419, 'https://ror.org/01pv83h16', 'en', 1, 'https://ror.org/01pv83h16 Acadia Institute of Oceanography'),
(6420, 'https://ror.org/01pvjb298', 'fr', 1, 'https://ror.org/01pvjb298 Centre Interprofessionnel de Techniques d''Études de la Pollution Atmosphérique'),
(6421, 'https://ror.org/01pw42d50', 'en', 1, 'https://ror.org/01pw42d50 Boxer Wachler Vision Institute'),
(6422, 'https://ror.org/01pwbmp71', 'en', 1, 'https://ror.org/01pwbmp71 Schizophrenia Research Foundation'),
(6423, 'https://ror.org/01pxap840', 'en', 1, 'https://ror.org/01pxap840 Royal Armouries'),
(6424, 'https://ror.org/01pxz1r61', 'no_lang_code', 1, 'https://ror.org/01pxz1r61 Simonsen Laboratories'),
(6425, 'https://ror.org/01q1paq98', 'no_lang_code', 1, 'https://ror.org/01q1paq98 Avanti (United Kingdom)'),
(6426, 'https://ror.org/01q61vc37', 'no_lang_code', 1, 'https://ror.org/01q61vc37 Devan (Portugal)'),
(6427, 'https://ror.org/01qcf5s69', 'no_lang_code', 1, 'https://ror.org/01qcf5s69 STMicroelectronics (Canada)'),
(6428, 'https://ror.org/01qdw1m65', 'en', 1, 'https://ror.org/01qdw1m65 Passport to Knowledge'),
(6429, 'https://ror.org/01qe4kz15', 'no_lang_code', 1, 'https://ror.org/01qe4kz15 Goldwind (China)'),
(6430, 'https://ror.org/01qek3q18', 'en', 1, 'https://ror.org/01qek3q18 Central Electrochemical Research Institute'),
(6431, 'https://ror.org/01qgthm82', 'no_lang_code', 1, 'https://ror.org/01qgthm82 zuChem (United States)'),
(6432, 'https://ror.org/01qhm7e49', 'no_lang_code', 1, 'https://ror.org/01qhm7e49 Caterpillar (United States)'),
(6433, 'https://ror.org/01qjd9x30', 'en', 1, 'https://ror.org/01qjd9x30 Forestry Commission Scotland'),
(6434, 'https://ror.org/01qjmkr85', 'no_lang_code', 1, 'https://ror.org/01qjmkr85 Fonterra (New Zealand)'),
(6435, 'https://ror.org/01qjvcb50', 'no_lang_code', 1, 'https://ror.org/01qjvcb50 Lpath (United States)'),
(6436, 'https://ror.org/01qk1bx90', 'no_lang_code', 1, 'https://ror.org/01qk1bx90 Environics Oy (Finland)'),
(6437, 'https://ror.org/01qma4124', 'no_lang_code', 1, 'https://ror.org/01qma4124 JS Genetics (United States)'),
(6438, 'https://ror.org/01qmkwf03', 'en', 1, 'https://ror.org/01qmkwf03 San Diego Biomedical Research Institute'),
(6439, 'https://ror.org/01qnpp968', 'en', 1, 'https://ror.org/01qnpp968 New Mexico Consortium'),
(6440, 'https://ror.org/01qqd5n29', 'en', 1, 'https://ror.org/01qqd5n29 Foundation for Advanced Education in the Sciences'),
(6441, 'https://ror.org/01qr26m26', 'en', 1, 'https://ror.org/01qr26m26 Sirris'),
(6442, 'https://ror.org/01qt7mp11', 'en', 1, 'https://ror.org/01qt7mp11 Miyagi Prefectural Hospital Organization 宮城県立病院機構'),
(6443, 'https://ror.org/01qw0br74', 'en', 1, 'https://ror.org/01qw0br74 Agricultural Biotechnology Institute'),
(6444, 'https://ror.org/01qwbfa84', 'en', 1, 'https://ror.org/01qwbfa84 Collège holland Holland College'),
(6445, 'https://ror.org/01qz53q03', 'no_lang_code', 1, 'https://ror.org/01qz53q03 Mascoma (Canada)'),
(6446, 'https://ror.org/01r2apt44', 'no_lang_code', 1, 'https://ror.org/01r2apt44 Grace (Germany)'),
(6447, 'https://ror.org/01r6bzv07', 'en', 1, 'https://ror.org/01r6bzv07 Bogomoletz Institute of Physiology Інститут фізіології ім. О.О. Богомольця'),
(6448, 'https://ror.org/01rcr9030', 'no_lang_code', 1, 'https://ror.org/01rcr9030 Consorcio Regional de Transportes de Madrid'),
(6449, 'https://ror.org/01rde7a23', 'no_lang_code', 1, 'https://ror.org/01rde7a23 Fluxion Biosciences (United States)'),
(6450, 'https://ror.org/01rdex851', 'no_lang_code', 1, 'https://ror.org/01rdex851 Arkema (United States)'),
(6451, 'https://ror.org/01rdxvn05', 'no_lang_code', 1, 'https://ror.org/01rdxvn05 Galderma (United States)'),
(6452, 'https://ror.org/01rg6cx71', 'no_lang_code', 1, 'https://ror.org/01rg6cx71 Yao Tokushukai General Hospital 八尾徳洲会総合病院'),
(6453, 'https://ror.org/01rhc0n38', 'en', 1, 'https://ror.org/01rhc0n38 New Hampshire Hospital'),
(6454, 'https://ror.org/01rhvcq39', 'no_lang_code', 1, 'https://ror.org/01rhvcq39 Seashell Technology (United States)'),
(6455, 'https://ror.org/01rje3r53', 'fr', 1, 'https://ror.org/01rje3r53 Centre d''Étude du Polymorphisme Humain, Fondation Jean Dausset-CEPH'),
(6456, 'https://ror.org/01rm4gj66', 'no_lang_code', 1, 'https://ror.org/01rm4gj66 SimQuest (United States)'),
(6457, 'https://ror.org/01rm78x24', 'no_lang_code', 1, 'https://ror.org/01rm78x24 Applied Photonics (United Kingdom)'),
(6458, 'https://ror.org/01rmpb303', 'no_lang_code', 1, 'https://ror.org/01rmpb303 Nautilus Biosciences (Canada)'),
(6459, 'https://ror.org/01rnvev51', 'it', 1, 'https://ror.org/01rnvev51 Fondazione Politecnico di Milano'),
(6460, 'https://ror.org/01rqa9952', 'no_lang_code', 1, 'https://ror.org/01rqa9952 G & A Technical Software (United States)'),
(6461, 'https://ror.org/01rqavq28', 'no_lang_code', 1, 'https://ror.org/01rqavq28 Fluidity Software (United States)'),
(6462, 'https://ror.org/01rqyr540', 'en', 1, 'https://ror.org/01rqyr540 Institute of Molecular Biology and Genetics Інститут молекулярної біології і генетики'),
(6463, 'https://ror.org/01rsgws32', 'en', 1, 'https://ror.org/01rsgws32 Lycoming College'),
(6464, 'https://ror.org/01rtyyz33', 'pt', 1, 'https://ror.org/01rtyyz33 Instituto de Medicina Integral Professor Fernando Figueira'),
(6465, 'https://ror.org/01rvpy991', 'no_lang_code', 1, 'https://ror.org/01rvpy991 Hayashibara (Japan) 株式会社 林原'),
(6466, 'https://ror.org/01rwv9j63', 'en', 1, 'https://ror.org/01rwv9j63 Operation UNITE'),
(6467, 'https://ror.org/01rww7j93', 'en', 1, 'https://ror.org/01rww7j93 Tarzana Treatment Centers'),
(6468, 'https://ror.org/01rx46r39', 'no_lang_code', 1, 'https://ror.org/01rx46r39 Science Take-Out (United States)'),
(6469, 'https://ror.org/01rz37c55', 'en', 1, 'https://ror.org/01rz37c55 Bureau régional de l’OMS pour l’Europe Regionalbüro für Europa World Health Organization Regional Office for Europe'),
(6470, 'https://ror.org/01rz4nb07', 'en', 1, 'https://ror.org/01rz4nb07 Bureau fédéral du Plan Federal Planning Bureau Het Federaal Planbureau'),
(6471, 'https://ror.org/01rzx2627', 'en', 1, 'https://ror.org/01rzx2627 American College of Radiology'),
(6472, 'https://ror.org/01s2wsy11', 'en', 1, 'https://ror.org/01s2wsy11 Chicago Association for Research and Education in Science'),
(6473, 'https://ror.org/01s3wxs84', 'no_lang_code', 1, 'https://ror.org/01s3wxs84 Barrett Technology (United States)'),
(6474, 'https://ror.org/01s4hex50', 'en', 1, 'https://ror.org/01s4hex50 Society of Automotive Engineers International'),
(6475, 'https://ror.org/01s4ync39', 'no_lang_code', 1, 'https://ror.org/01s4ync39 AureoGen Biosciences (United States)'),
(6476, 'https://ror.org/01s6vf760', 'no_lang_code', 1, 'https://ror.org/01s6vf760 Tengion (United States)'),
(6477, 'https://ror.org/01s8dqw53', 'en', 1, 'https://ror.org/01s8dqw53 West Virginia School of Osteopathic Medicine'),
(6478, 'https://ror.org/01s8ppv52', 'no_lang_code', 1, 'https://ror.org/01s8ppv52 Incell Corporation (United States)'),
(6479, 'https://ror.org/01s8vy398', 'en', 1, 'https://ror.org/01s8vy398 Parker University'),
(6480, 'https://ror.org/01s9sxm36', 'en', 1, 'https://ror.org/01s9sxm36 Presbyterian College'),
(6481, 'https://ror.org/01sb2fs58', 'en', 1, 'https://ror.org/01sb2fs58 Institute of Cardiology Федеральное государственное бюджетное научное учреждение Научно-исследовательский институт кардиологии'),
(6482, 'https://ror.org/01sc2zj52', 'no_lang_code', 1, 'https://ror.org/01sc2zj52 Ardeje (France)'),
(6483, 'https://ror.org/01scjva02', 'no_lang_code', 1, 'https://ror.org/01scjva02 Jeremy Benn Associates (United Kingdom)'),
(6484, 'https://ror.org/01se4r077', 'en', 1, 'https://ror.org/01se4r077 Institute of Immunological Engineering'),
(6485, 'https://ror.org/01se61h67', 'no_lang_code', 1, 'https://ror.org/01se61h67 Feilden Clegg Bradley Studios (United Kingdom)'),
(6486, 'https://ror.org/01sgg2e20', 'en', 1, 'https://ror.org/01sgg2e20 Merit Network'),
(6487, 'https://ror.org/01sgx5h42', 'en', 1, 'https://ror.org/01sgx5h42 Cuyahoga Community College'),
(6488, 'https://ror.org/01shj3957', 'en', 1, 'https://ror.org/01shj3957 Red Deer College'),
(6489, 'https://ror.org/01shjyx24', 'no_lang_code', 1, 'https://ror.org/01shjyx24 Cambridge Environmental Research Consultants (United Kingdom)'),
(6490, 'https://ror.org/01sj8qf84', 'en', 1, 'https://ror.org/01sj8qf84 Secrétariat du Conseil du Trésor du Canada Treasury Board of Canada Secretariat'),
(6491, 'https://ror.org/01sjx9496', 'no_lang_code', 1, 'https://ror.org/01sjx9496 Pharmaceutical Product Development (United States)'),
(6492, 'https://ror.org/01skvfg56', 'en', 1, 'https://ror.org/01skvfg56 Tallahassee Community College'),
(6493, 'https://ror.org/01skwyh03', 'no_lang_code', 1, 'https://ror.org/01skwyh03 Nissan Chemical Corporation (Japan) 日産化学株式会社'),
(6494, 'https://ror.org/01spwt212', 'en', 1, 'https://ror.org/01spwt212 Swiss Paraplegic Center'),
(6495, 'https://ror.org/01srwdt35', 'en', 1, 'https://ror.org/01srwdt35 Center for Dermatology and Laser Surgery'),
(6496, 'https://ror.org/01ssv2r52', 'no_lang_code', 1, 'https://ror.org/01ssv2r52 ImageCat (United States)'),
(6497, 'https://ror.org/01st38774', 'no_lang_code', 1, 'https://ror.org/01st38774 Geninov (Canada)'),
(6498, 'https://ror.org/01stake94', 'no_lang_code', 1, 'https://ror.org/01stake94 D2S International (Belgium)'),
(6499, 'https://ror.org/01strh679', 'sr', 1, 'https://ror.org/01strh679 Klinički centar Niš, Клинички центар Ниш'),
(6500, 'https://ror.org/01svwyw14', 'en', 1, 'https://ror.org/01svwyw14 Croatian Veterinary Institute Hrvatski veterinarski institut Zagreb'),
(6501, 'https://ror.org/01sw9e110', 'en', 1, 'https://ror.org/01sw9e110 Howard Brown Health Center'),
(6502, 'https://ror.org/01syx9t96', 'en', 1, 'https://ror.org/01syx9t96 Fond du Lac Reservation'),
(6503, 'https://ror.org/01t05fr30', 'en', 1, 'https://ror.org/01t05fr30 National Conference on Interstate Milk Shipments'),
(6504, 'https://ror.org/01t0n2c80', 'de', 1, 'https://ror.org/01t0n2c80 Klinikum Oldenburg'),
(6505, 'https://ror.org/01t1ct488', 'no_lang_code', 1, 'https://ror.org/01t1ct488 Verafin (Canada)'),
(6506, 'https://ror.org/01t413275', 'en', 1, 'https://ror.org/01t413275 Sri Ramakrishna Institute of Paramedical Sciences'),
(6507, 'https://ror.org/01t44n583', 'no_lang_code', 1, 'https://ror.org/01t44n583 MBio Diagnostics (United States)'),
(6508, 'https://ror.org/01t4a3951', 'no_lang_code', 1, 'https://ror.org/01t4a3951 Treatment Innovations (United States)'),
(6509, 'https://ror.org/01t5jw607', 'en', 1, 'https://ror.org/01t5jw607 Houston Independent School District'),
(6510, 'https://ror.org/01t6qh616', 'en', 1, 'https://ror.org/01t6qh616 Shriners Hospitals for Children - Spokane'),
(6511, 'https://ror.org/01t77y753', 'en', 1, 'https://ror.org/01t77y753 Regis College'),
(6512, 'https://ror.org/01t8qhk85', 'en', 1, 'https://ror.org/01t8qhk85 Conestoga College'),
(6513, 'https://ror.org/01t8vn565', 'fr', 1, 'https://ror.org/01t8vn565 Clinique de l''Yvette Yvette clinic'),
(6514, 'https://ror.org/01ta8cw69', 'no_lang_code', 1, 'https://ror.org/01ta8cw69 White Point Systems (United States)'),
(6515, 'https://ror.org/01tam1k81', 'en', 1, 'https://ror.org/01tam1k81 Healthcare Education Associates'),
(6516, 'https://ror.org/01tay0360', 'en', 1, 'https://ror.org/01tay0360 Park Nicollet Health Services'),
(6517, 'https://ror.org/01tbdbg27', 'en', 1, 'https://ror.org/01tbdbg27 City of York Council'),
(6518, 'https://ror.org/01tbe3k42', 'no_lang_code', 1, 'https://ror.org/01tbe3k42 Alpha Genesis (United States)'),
(6519, 'https://ror.org/01tbvb523', 'en', 1, 'https://ror.org/01tbvb523 Florida Orthopaedic Institute'),
(6520, 'https://ror.org/01tbwpy88', 'en', 1, 'https://ror.org/01tbwpy88 Centre for European Security Strategies'),
(6521, 'https://ror.org/01tcbxg35', 'no_lang_code', 1, 'https://ror.org/01tcbxg35 Circle Solutions'),
(6522, 'https://ror.org/01teg2k73', 'en', 1, 'https://ror.org/01teg2k73 National Institute Of Hygiene And Epidemiology Viện Vệ sinh dịch tễ Trung ương'),
(6523, 'https://ror.org/01tfkms29', 'no_lang_code', 1, 'https://ror.org/01tfkms29 Alfamicro (Portugal)'),
(6524, 'https://ror.org/01th0ab46', 'en', 1, 'https://ror.org/01th0ab46 Institute for Family Health'),
(6525, 'https://ror.org/01thy5064', 'no_lang_code', 1, 'https://ror.org/01thy5064 Biosensor (Italy)'),
(6526, 'https://ror.org/01tqja591', 'no_lang_code', 1, 'https://ror.org/01tqja591 Morinaga (Japan) 森永製菓株式会社'),
(6527, 'https://ror.org/01tt80y42', 'fr', 1, 'https://ror.org/01tt80y42 Hôpital privé Clairval'),
(6528, 'https://ror.org/01ttkn505', 'en', 1, 'https://ror.org/01ttkn505 Biotechnical Services'),
(6529, 'https://ror.org/01tv6se08', 'no_lang_code', 1, 'https://ror.org/01tv6se08 Prism Clinical Imaging (United States)'),
(6530, 'https://ror.org/01tw7ew41', 'en', 1, 'https://ror.org/01tw7ew41 Surrey Place Centre'),
(6531, 'https://ror.org/01twtwf23', 'no_lang_code', 1, 'https://ror.org/01twtwf23 Alberti''s Window (United States)'),
(6532, 'https://ror.org/01twwfv38', 'en', 1, 'https://ror.org/01twwfv38 Valley Hospital'),
(6533, 'https://ror.org/01txpgc43', 'no_lang_code', 1, 'https://ror.org/01txpgc43 Operational Technologies Corporation (United States)'),
(6534, 'https://ror.org/01ty4bg86', 'en', 1, 'https://ror.org/01ty4bg86 Shanghai Cancer Institute'),
(6535, 'https://ror.org/01tyr1g37', 'en', 1, 'https://ror.org/01tyr1g37 Institute for Biological Instrumentation Институт биологического приборостроения РАН'),
(6536, 'https://ror.org/01v3bqg10', 'no_lang_code', 1, 'https://ror.org/01v3bqg10 Shionogi (Japan) 塩野義製薬'),
(6537, 'https://ror.org/01v4ea389', 'no_lang_code', 1, 'https://ror.org/01v4ea389 Sizewise (United States)'),
(6538, 'https://ror.org/01v4tsw25', 'en', 1, 'https://ror.org/01v4tsw25 Engineering Conferences International'),
(6539, 'https://ror.org/01v51gh79', 'no_lang_code', 1, 'https://ror.org/01v51gh79 NanoCellect Biomedical (United States)'),
(6540, 'https://ror.org/01v5pfj68', 'no_lang_code', 1, 'https://ror.org/01v5pfj68 Sarver and Associates (United States)'),
(6541, 'https://ror.org/01v66s741', 'no_lang_code', 1, 'https://ror.org/01v66s741 3D-Micromac (Germany)'),
(6542, 'https://ror.org/01v76qw30', 'en', 1, 'https://ror.org/01v76qw30 Northlake Medical Center'),
(6543, 'https://ror.org/01v791m31', 'no_lang_code', 1, 'https://ror.org/01v791m31 NEC (United States) NEC Corporation of America'),
(6544, 'https://ror.org/01v7p8902', 'no_lang_code', 1, 'https://ror.org/01v7p8902 Interklinik'),
(6545, 'https://ror.org/01v8a4s08', 'no_lang_code', 1, 'https://ror.org/01v8a4s08 RadioMedix (United States)'),
(6546, 'https://ror.org/01v9kvt79', 'no_lang_code', 1, 'https://ror.org/01v9kvt79 Bracco (Switzerland)'),
(6547, 'https://ror.org/01vfnp540', 'no_lang_code', 1, 'https://ror.org/01vfnp540 Immune Response BioPharma (United States)'),
(6548, 'https://ror.org/01vgd5418', 'en', 1, 'https://ror.org/01vgd5418 Mississippi Gulf Coast Community College'),
(6549, 'https://ror.org/01vj62p39', 'no_lang_code', 1, 'https://ror.org/01vj62p39 Cadence Biomedical (United States)'),
(6550, 'https://ror.org/01vjc3s29', 'no_lang_code', 1, 'https://ror.org/01vjc3s29 AOA Apparatebau Gauting (Germany)'),
(6551, 'https://ror.org/01vjhzs23', 'sk', 1, 'https://ror.org/01vjhzs23 Onkologický Ústav Svätej Alžbety'),
(6552, 'https://ror.org/01vjngb81', 'en', 1, 'https://ror.org/01vjngb81 Valley Medical Center'),
(6553, 'https://ror.org/01vmvt909', 'en', 1, 'https://ror.org/01vmvt909 National Migraine Centre'),
(6554, 'https://ror.org/01vp49361', 'no_lang_code', 1, 'https://ror.org/01vp49361 Merck Serono (Switzerland)'),
(6555, 'https://ror.org/01vqjmx11', 'en', 1, 'https://ror.org/01vqjmx11 Center for Economic and Policy Research'),
(6556, 'https://ror.org/01vsg6m68', 'en', 1, 'https://ror.org/01vsg6m68 State Science and Technology Institute'),
(6557, 'https://ror.org/01vt38y66', 'no_lang_code', 1, 'https://ror.org/01vt38y66 PhosphorTech (United States)'),
(6558, 'https://ror.org/01vv3y523', 'en', 1, 'https://ror.org/01vv3y523 Torbay Hospital'),
(6559, 'https://ror.org/01vv6sh78', 'no_lang_code', 1, 'https://ror.org/01vv6sh78 Cytex Therapeutics (United States)'),
(6560, 'https://ror.org/01vvexy08', 'no_lang_code', 1, 'https://ror.org/01vvexy08 CHI Associates (United States)'),
(6561, 'https://ror.org/01vwr6t80', 'en', 1, 'https://ror.org/01vwr6t80 Académie militaire de caroline du sud Citadel'),
(6562, 'https://ror.org/01vxknj13', 'no_lang_code', 1, 'https://ror.org/01vxknj13 ASML (Netherlands)'),
(6563, 'https://ror.org/01vyrje42', 'it', 1, 'https://ror.org/01vyrje42 Istituto Ortopedico Galeazzi'),
(6564, 'https://ror.org/01vzd5j10', 'en', 1, 'https://ror.org/01vzd5j10 National Tuberculosis Institute'),
(6565, 'https://ror.org/01w19ak89', 'en', 1, 'https://ror.org/01w19ak89 Max Planck Institute for Informatics Max-Planck-Institut für Informatik'),
(6566, 'https://ror.org/01w5zd681', 'no_lang_code', 1, 'https://ror.org/01w5zd681 Belgonucleaire (Belgium)'),
(6567, 'https://ror.org/01w7ahq52', 'no_lang_code', 1, 'https://ror.org/01w7ahq52 ACRI Group (France)'),
(6568, 'https://ror.org/01w7yjk26', 'no_lang_code', 1, 'https://ror.org/01w7yjk26 Phoenix Science and Technology (United States)'),
(6569, 'https://ror.org/01wakgv04', 'no_lang_code', 1, 'https://ror.org/01wakgv04 Naprogenix (United States)'),
(6570, 'https://ror.org/01wc2qb11', 'en', 1, 'https://ror.org/01wc2qb11 Tri-County Health Department'),
(6571, 'https://ror.org/01wen3r86', 'no_lang_code', 1, 'https://ror.org/01wen3r86 Boliden (Sweden)'),
(6572, 'https://ror.org/01wfg6h04', 'en', 1, 'https://ror.org/01wfg6h04 Pharmo Institute'),
(6573, 'https://ror.org/01wfk7k95', 'en', 1, 'https://ror.org/01wfk7k95 Area Cooperative Education Services'),
(6574, 'https://ror.org/01wj8vf34', 'en', 1, 'https://ror.org/01wj8vf34 Raghudeep Eye Hospital'),
(6575, 'https://ror.org/01wjn2x92', 'en', 1, 'https://ror.org/01wjn2x92 National Center for HIV/AIDS Viral Hepatitis STD and TB Prevention'),
(6576, 'https://ror.org/01wm02973', 'no_lang_code', 1, 'https://ror.org/01wm02973 Foster-Miller (United States)'),
(6577, 'https://ror.org/01wnfae18', 'en', 1, 'https://ror.org/01wnfae18 Central Research Institute केंद्रीय अनुसंधान संस्थान'),
(6578, 'https://ror.org/01wq93z70', 'en', 1, 'https://ror.org/01wq93z70 Chinese National Human Genome Center'),
(6579, 'https://ror.org/01wqae691', 'it', 1, 'https://ror.org/01wqae691 Institute for Animal Production System in Mediterranean Environment Istituto per il Sistema Produzione Animale in Ambiente Mediterraneo'),
(6580, 'https://ror.org/01wrh2n21', 'en', 1, 'https://ror.org/01wrh2n21 Hellenic Foundation for European and Foreign Policy'),
(6581, 'https://ror.org/01wwajd53', 'no_lang_code', 1, 'https://ror.org/01wwajd53 OHB (Italy)'),
(6582, 'https://ror.org/01wwwe276', 'en', 1, 'https://ror.org/01wwwe276 National Centre for Atmospheric Science'),
(6583, 'https://ror.org/01wx3gr42', 'en', 1, 'https://ror.org/01wx3gr42 Departamento de Educación de la Ciudad de Nueva York Département de l''Éducation de la ville de new york New York City Department of Education'),
(6584, 'https://ror.org/01wyqb997', 'fr', 1, 'https://ror.org/01wyqb997 Centre International de Recherches Médicales de Franceville'),
(6585, 'https://ror.org/01x00nv07', 'fr', 1, 'https://ror.org/01x00nv07 Coalition des Organismes Communautaires Québécois de Lutte Contre le Sida'),
(6586, 'https://ror.org/01x0vtk27', 'no_lang_code', 1, 'https://ror.org/01x0vtk27 Saneron CCEL Therapeutics (United States)'),
(6587, 'https://ror.org/01x59wb38', 'no_lang_code', 1, 'https://ror.org/01x59wb38 DesignMedix (United States)'),
(6588, 'https://ror.org/01x5py295', 'no_lang_code', 1, 'https://ror.org/01x5py295 SC Solutions (United States)'),
(6589, 'https://ror.org/01x5y8335', 'no_lang_code', 1, 'https://ror.org/01x5y8335 Granta Design (United Kingdom)'),
(6590, 'https://ror.org/01x63gj61', 'en', 1, 'https://ror.org/01x63gj61 Hillsborough Community College'),
(6591, 'https://ror.org/01x64pv72', 'en', 1, 'https://ror.org/01x64pv72 National Center for Environmental Assessment (EPA)'),
(6592, 'https://ror.org/01x653j15', 'no_lang_code', 1, 'https://ror.org/01x653j15 ManTech International (United States)'),
(6593, 'https://ror.org/01x693z07', 'no_lang_code', 1, 'https://ror.org/01x693z07 NovaSterilis (United States)'),
(6594, 'https://ror.org/01x6n0t15', 'en', 1, 'https://ror.org/01x6n0t15 Papua New Guinea Institute of Medical Research'),
(6595, 'https://ror.org/01x9bq055', 'no_lang_code', 1, 'https://ror.org/01x9bq055 Cairn Research (United Kingdom)'),
(6596, 'https://ror.org/01xd1rz53', 'en', 1, 'https://ror.org/01xd1rz53 National Association of State Mental Health Program Directors'),
(6597, 'https://ror.org/01xdq1k91', 'no_lang_code', 1, 'https://ror.org/01xdq1k91 Japan Tobacco (Japan) 日本たばこ産業株式会社'),
(6598, 'https://ror.org/01xgfaw76', 'en', 1, 'https://ror.org/01xgfaw76 Academy of Sciences Republic of Uzbekistan Oʻzbekiston Respublikasi Fanlar Akademiyasi Академия наук Узбекистана Академияи илмҳои Ӯзбакистон'),
(6599, 'https://ror.org/01xgjqy82', 'no_lang_code', 1, 'https://ror.org/01xgjqy82 Nicoya Lifesciences (Canada)'),
(6600, 'https://ror.org/01xh2bb57', 'no_lang_code', 1, 'https://ror.org/01xh2bb57 WisdomTools (United States)'),
(6601, 'https://ror.org/01xk5xs43', 'no_lang_code', 1, 'https://ror.org/01xk5xs43 Carl Zeiss (United States)'),
(6602, 'https://ror.org/01xpfz214', 'no_lang_code', 1, 'https://ror.org/01xpfz214 Team Industrial Services (United States)'),
(6603, 'https://ror.org/01xpm4m93', 'no_lang_code', 1, 'https://ror.org/01xpm4m93 Robert Olson Consulting (United States)'),
(6604, 'https://ror.org/01xqc9g05', 'en', 1, 'https://ror.org/01xqc9g05 University of Jamestown'),
(6605, 'https://ror.org/01xz1f624', 'no_lang_code', 1, 'https://ror.org/01xz1f624 OFM Research (United States)'),
(6606, 'https://ror.org/01xzapm83', 'no_lang_code', 1, 'https://ror.org/01xzapm83 Seamon (United States)'),
(6607, 'https://ror.org/01y0mgq54', 'en', 1, 'https://ror.org/01y0mgq54 Elizabethtown College'),
(6608, 'https://ror.org/01y2d1w05', 'en', 1, 'https://ror.org/01y2d1w05 St. Mary''s College of Maryland'),
(6609, 'https://ror.org/01y32sp40', 'no_lang_code', 1, 'https://ror.org/01y32sp40 Europäisches Centrum für Mechatronik (Germany)'),
(6610, 'https://ror.org/01y3v6r39', 'en', 1, 'https://ror.org/01y3v6r39 Spine Institute of Louisiana'),
(6611, 'https://ror.org/01y639h39', 'no_lang_code', 1, 'https://ror.org/01y639h39 Raptamer Discovery Group (United States)'),
(6612, 'https://ror.org/01y720297', 'en', 1, 'https://ror.org/01y720297 Regional Medical Research Centre আঞ্চলিক চিকিৎসা গৱেষণা কেন্দ্ৰ, ডিব্ৰুগড়'),
(6613, 'https://ror.org/01y7ahq16', 'no_lang_code', 1, 'https://ror.org/01y7ahq16 Technology Dynamics (United States)'),
(6614, 'https://ror.org/01y8myk27', 'en', 1, 'https://ror.org/01y8myk27 Dominican College of Blauvelt'),
(6615, 'https://ror.org/01y9arx16', 'en', 1, 'https://ror.org/01y9arx16 Max Planck Institut für Chemische Energiekonversion Max Planck Institute for Chemical Energy Conversion'),
(6616, 'https://ror.org/01ybxrm80', 'en', 1, 'https://ror.org/01ybxrm80 Yodogawa Christian Hospital 淀川キリスト教病院'),
(6617, 'https://ror.org/01yezas83', 'fr', 1, 'https://ror.org/01yezas83 Centre Eugène Marquis'),
(6618, 'https://ror.org/01yfkcs46', 'it', 1, 'https://ror.org/01yfkcs46 CSI Piemonte'),
(6619, 'https://ror.org/01ygdkx97', 'no_lang_code', 1, 'https://ror.org/01ygdkx97 American Life Science Pharmaceuticals (United States)'),
(6620, 'https://ror.org/01yjs2h26', 'en', 1, 'https://ror.org/01yjs2h26 Design Council'),
(6621, 'https://ror.org/01ynheb59', 'no_lang_code', 1, 'https://ror.org/01ynheb59 Sensor Electronics (United States)'),
(6622, 'https://ror.org/01ynxg963', 'en', 1, 'https://ror.org/01ynxg963 Pacific Medical Research Foundation'),
(6623, 'https://ror.org/01yq9ya27', 'en', 1, 'https://ror.org/01yq9ya27 Institute of Gene Biology Институт биологии гена'),
(6624, 'https://ror.org/01yrmk064', 'en', 1, 'https://ror.org/01yrmk064 Guttmacher Institute'),
(6625, 'https://ror.org/01yrmxe32', 'no_lang_code', 1, 'https://ror.org/01yrmxe32 NORAM (Canada)'),
(6626, 'https://ror.org/01yttm365', 'no_lang_code', 1, 'https://ror.org/01yttm365 Viasystems (United States)'),
(6627, 'https://ror.org/01yxr7f17', 'no_lang_code', 1, 'https://ror.org/01yxr7f17 Finovatis (France)'),
(6628, 'https://ror.org/01yxvb356', 'no_lang_code', 1, 'https://ror.org/01yxvb356 Anacomp (United States)'),
(6629, 'https://ror.org/01z142p52', 'es', 1, 'https://ror.org/01z142p52 Instituto Nacional de Rehabilitación Psicofísica'),
(6630, 'https://ror.org/01z1z7017', 'de', 1, 'https://ror.org/01z1z7017 Forschungsinstitut für Kinderernährung'),
(6631, 'https://ror.org/01z4haz29', 'no_lang_code', 1, 'https://ror.org/01z4haz29 Guild Associates (United States)'),
(6632, 'https://ror.org/01z4n2m85', 'it', 1, 'https://ror.org/01z4n2m85 Istituto Scientifico Italiano Colonna Vertebrale Italian Scientific Institute for the Spine'),
(6633, 'https://ror.org/01z5jvj74', 'en', 1, 'https://ror.org/01z5jvj74 ZNA Middelheim Hospital'),
(6634, 'https://ror.org/01z6qpb13', 'pt', 1, 'https://ror.org/01z6qpb13 Faculdade de Ciências Médicas da Santa Casa de São Paulo'),
(6635, 'https://ror.org/01z6vd941', 'no_lang_code', 1, 'https://ror.org/01z6vd941 Millar (United States)'),
(6636, 'https://ror.org/01z850041', 'no_lang_code', 1, 'https://ror.org/01z850041 Technology Assessment and Transfer (United States)'),
(6637, 'https://ror.org/01z89mt14', 'en', 1, 'https://ror.org/01z89mt14 Ottawa Regional Cancer Foundation'),
(6638, 'https://ror.org/01z8hbn82', 'en', 1, 'https://ror.org/01z8hbn82 Diabetes & Glandular Disease Clinic'),
(6639, 'https://ror.org/01zd81893', 'no_lang_code', 1, 'https://ror.org/01zd81893 Modulim (United States)'),
(6640, 'https://ror.org/01zdgf096', 'en', 1, 'https://ror.org/01zdgf096 Baptist Health Care'),
(6641, 'https://ror.org/01zj9wm95', 'en', 1, 'https://ror.org/01zj9wm95 Yuan''s General Hospital 阮綜合醫院'),
(6642, 'https://ror.org/01zpdb870', 'fr', 1, 'https://ror.org/01zpdb870 Centre Médical de Vidy'),
(6643, 'https://ror.org/01zpg3b52', 'no_lang_code', 1, 'https://ror.org/01zpg3b52 Theradex Oncology (United States)'),
(6644, 'https://ror.org/01zpyjx73', 'en', 1, 'https://ror.org/01zpyjx73 Renal Association'),
(6645, 'https://ror.org/01zq3h513', 'it', 1, 'https://ror.org/01zq3h513 Ospedale Psichiatrico Paolo Pini'),
(6646, 'https://ror.org/01zq90d67', 'en', 1, 'https://ror.org/01zq90d67 Institute for Marine Biosciences'),
(6647, 'https://ror.org/01zr7w027', 'no_lang_code', 1, 'https://ror.org/01zr7w027 INFICON (United States)'),
(6648, 'https://ror.org/01zt0tq34', 'no_lang_code', 1, 'https://ror.org/01zt0tq34 Alere (United States)'),
(6649, 'https://ror.org/01zw2nq07', 'en', 1, 'https://ror.org/01zw2nq07 Indian Institute of Integrative Medicine'),
(6650, 'https://ror.org/01zw4be88', 'no_lang_code', 1, 'https://ror.org/01zw4be88 Fincantieri (Italy)'),
(6651, 'https://ror.org/01zzhbb93', 'en', 1, 'https://ror.org/01zzhbb93 Linn Benton Community College'),
(6652, 'https://ror.org/01zzqep61', 'it', 1, 'https://ror.org/01zzqep61 Istituto di Tipizzazione Tissutale e Problemi della Dialisi'),
(6653, 'https://ror.org/0202zza47', 'en', 1, 'https://ror.org/0202zza47 Children’s Discovery Museum of San Jose'),
(6654, 'https://ror.org/0203rjz92', 'no_lang_code', 1, 'https://ror.org/0203rjz92 Insmed (United States)'),
(6655, 'https://ror.org/0204af661', 'no_lang_code', 1, 'https://ror.org/0204af661 EarthSky'),
(6656, 'https://ror.org/0207cws49', 'no_lang_code', 1, 'https://ror.org/0207cws49 Oncor (United States)'),
(6657, 'https://ror.org/0207yj108', 'en', 1, 'https://ror.org/0207yj108 Nashville State Community College'),
(6658, 'https://ror.org/0208r0146', 'en', 1, 'https://ror.org/0208r0146 Parkland Memorial Hospital'),
(6659, 'https://ror.org/0209tfn22', 'no_lang_code', 1, 'https://ror.org/0209tfn22 Airial Conseil (France)'),
(6660, 'https://ror.org/020as7681', 'en', 1, 'https://ror.org/020as7681 Max Planck Institute for the Science of Light Max-Planck-Institut für die Physik des Lichts'),
(6661, 'https://ror.org/020ave461', 'no_lang_code', 1, 'https://ror.org/020ave461 Proton (United Kingdom)'),
(6662, 'https://ror.org/020bcb226', 'en', 1, 'https://ror.org/020bcb226 Oakton Community College'),
(6663, 'https://ror.org/020cs8b78', 'en', 1, 'https://ror.org/020cs8b78 Global Hospitals'),
(6664, 'https://ror.org/020d9fy55', 'en', 1, 'https://ror.org/020d9fy55 Gimbel Eye Centre'),
(6665, 'https://ror.org/020gf7g55', 'no_lang_code', 1, 'https://ror.org/020gf7g55 Mosaiques Diagnostics and Therapeutics (Germany)'),
(6666, 'https://ror.org/020gftc86', 'en', 1, 'https://ror.org/020gftc86 Holy Names University'),
(6667, 'https://ror.org/020h1bf56', 'en', 1, 'https://ror.org/020h1bf56 United States Public Health Service Commissioned Officers Association'),
(6668, 'https://ror.org/020h1fj51', 'no_lang_code', 1, 'https://ror.org/020h1fj51 NDI Group (United States)'),
(6669, 'https://ror.org/020k5bb13', 'it', 1, 'https://ror.org/020k5bb13 Ospedale dei Pellegrini'),
(6670, 'https://ror.org/020mdmp08', 'en', 1, 'https://ror.org/020mdmp08 Student Assistance Services'),
(6671, 'https://ror.org/020nhee14', 'fr', 1, 'https://ror.org/020nhee14 Collège Mérici Merici College'),
(6672, 'https://ror.org/020nseq49', 'no_lang_code', 1, 'https://ror.org/020nseq49 DIApedia (United States)'),
(6673, 'https://ror.org/020nzw227', 'no_lang_code', 1, 'https://ror.org/020nzw227 Cybernet Systems Corporation (United States)'),
(6674, 'https://ror.org/020pekv35', 'en', 1, 'https://ror.org/020pekv35 Center for Applied Linguistics'),
(6675, 'https://ror.org/020ptwy31', 'it', 1, 'https://ror.org/020ptwy31 Agenzia per l''Italia Digitale'),
(6676, 'https://ror.org/020q1kr70', 'en', 1, 'https://ror.org/020q1kr70 Premier Community Health'),
(6677, 'https://ror.org/020wjcq07', 'en', 1, 'https://ror.org/020wjcq07 Shibaura Institute of Technology 芝浦工業大学'),
(6678, 'https://ror.org/020wnve48', 'no_lang_code', 1, 'https://ror.org/020wnve48 Spectris (United Kingdom)'),
(6679, 'https://ror.org/020wypw95', 'no_lang_code', 1, 'https://ror.org/020wypw95 Lord Corporation (United States)'),
(6680, 'https://ror.org/020xab067', 'en', 1, 'https://ror.org/020xab067 Alberta Community Council on HIV'),
(6681, 'https://ror.org/02112mb03', 'it', 1, 'https://ror.org/02112mb03 Filippo Del Ponte Hospital Ospedale Filippo Del Ponte Varese'),
(6682, 'https://ror.org/0211zmf46', 'en', 1, 'https://ror.org/0211zmf46 National Metallurgical Laboratory'),
(6683, 'https://ror.org/02120t614', 'en', 1, 'https://ror.org/02120t614 Chiba Cancer Center 千葉県がんセンター'),
(6684, 'https://ror.org/0212bzt20', 'no_lang_code', 1, 'https://ror.org/0212bzt20 DesignBuilder Software (United Kingdom)'),
(6685, 'https://ror.org/0212gej90', 'no_lang_code', 1, 'https://ror.org/0212gej90 ON Semiconductor (Belgium)'),
(6686, 'https://ror.org/0212h5y77', 'en', 1, 'https://ror.org/0212h5y77 Inova Fairfax Hospital'),
(6687, 'https://ror.org/0213kp011', 'no_lang_code', 1, 'https://ror.org/0213kp011 Empresa de Desenvolvimento Mineiro (Portugal)'),
(6688, 'https://ror.org/0215tke07', 'no_lang_code', 1, 'https://ror.org/0215tke07 Medical Imaging Applications (United States)'),
(6689, 'https://ror.org/0217xr937', 'en', 1, 'https://ror.org/0217xr937 Aspen Global Change Institute'),
(6690, 'https://ror.org/0219mbj11', 'no_lang_code', 1, 'https://ror.org/0219mbj11 Karo Pharma (Sweden)'),
(6691, 'https://ror.org/021a7d287', 'en', 1, 'https://ror.org/021a7d287 Royal College of Surgeons of Edinburgh'),
(6692, 'https://ror.org/021e69h28', 'en', 1, 'https://ror.org/021e69h28 Adelphi Research'),
(6693, 'https://ror.org/021g0dt18', 'no_lang_code', 1, 'https://ror.org/021g0dt18 International Trypanotolerance Centre'),
(6694, 'https://ror.org/021gsjb92', 'no_lang_code', 1, 'https://ror.org/021gsjb92 Diacon (Canada)'),
(6695, 'https://ror.org/021n8sy59', 'no_lang_code', 1, 'https://ror.org/021n8sy59 National Integrated Solutions (United Kingdom)'),
(6696, 'https://ror.org/021nkvj61', 'no_lang_code', 1, 'https://ror.org/021nkvj61 MGS Research (United States)'),
(6697, 'https://ror.org/021nxch78', 'no_lang_code', 1, 'https://ror.org/021nxch78 BCT (Germany)'),
(6698, 'https://ror.org/021q72e63', 'no_lang_code', 1, 'https://ror.org/021q72e63 Novus Biologicals (United States)'),
(6699, 'https://ror.org/021r5ns39', 'en', 1, 'https://ror.org/021r5ns39 National Environmental Engineering Research Institute'),
(6700, 'https://ror.org/021sagw45', 'no_lang_code', 1, 'https://ror.org/021sagw45 Nicolet Chartrand Knoll (Canada)'),
(6701, 'https://ror.org/021spd704', 'en', 1, 'https://ror.org/021spd704 El Camino College'),
(6702, 'https://ror.org/021vp7p61', 'no_lang_code', 1, 'https://ror.org/021vp7p61 GTD (Spain)'),
(6703, 'https://ror.org/021w7cz98', 'en', 1, 'https://ror.org/021w7cz98 Posnick Center for Facial Plastic Surgery'),
(6704, 'https://ror.org/021wvg932', 'no_lang_code', 1, 'https://ror.org/021wvg932 Center For Remote Sensing (United States)'),
(6705, 'https://ror.org/021z7gb33', 'no_lang_code', 1, 'https://ror.org/021z7gb33 Evolutionary Genomics (United States)'),
(6706, 'https://ror.org/0220wzg80', 'no_lang_code', 1, 'https://ror.org/0220wzg80 South Australian Water Corporation'),
(6707, 'https://ror.org/022194d90', 'no_lang_code', 1, 'https://ror.org/022194d90 Ajinomoto Althea (United States)'),
(6708, 'https://ror.org/0221y9f82', 'no_lang_code', 1, 'https://ror.org/0221y9f82 Beneficial Designs (United States)'),
(6709, 'https://ror.org/02237ny03', 'en', 1, 'https://ror.org/02237ny03 Taste and Smell Clinic'),
(6710, 'https://ror.org/02242hs05', 'pt', 1, 'https://ror.org/02242hs05 Centro Tecnológico das Indústrias do Couro Leather Technological Center'),
(6711, 'https://ror.org/0224bx186', 'en', 1, 'https://ror.org/0224bx186 Nazareth College'),
(6712, 'https://ror.org/022c1xk47', 'no_lang_code', 1, 'https://ror.org/022c1xk47 Honda (Germany)'),
(6713, 'https://ror.org/022c7bq15', 'no_lang_code', 1, 'https://ror.org/022c7bq15 AOS Products (United Kingdom)'),
(6714, 'https://ror.org/022cm1781', 'no_lang_code', 1, 'https://ror.org/022cm1781 Alpha Thames Subsea (United Kingdom)'),
(6715, 'https://ror.org/022e9hp02', 'en', 1, 'https://ror.org/022e9hp02 Family Health Centers of San Diego'),
(6716, 'https://ror.org/022fswr88', 'no_lang_code', 1, 'https://ror.org/022fswr88 New Span Opto-Technology (United States)'),
(6717, 'https://ror.org/022fxd079', 'no_lang_code', 1, 'https://ror.org/022fxd079 Hexcel (United Kingdom)'),
(6718, 'https://ror.org/022j4a796', 'en', 1, 'https://ror.org/022j4a796 Santa Barbara City College'),
(6719, 'https://ror.org/022jc0g24', 'en', 1, 'https://ror.org/022jc0g24 Max Planck Institute for Developmental Biology Max-Planck-Institut für Entwicklungsbiologie'),
(6720, 'https://ror.org/022jdjx35', 'no_lang_code', 1, 'https://ror.org/022jdjx35 Philip Morris International (Germany)'),
(6721, 'https://ror.org/022m8zh32', 'en', 1, 'https://ror.org/022m8zh32 Grewal Eye Institute'),
(6722, 'https://ror.org/022mrwt29', 'en', 1, 'https://ror.org/022mrwt29 Tzu Chi Foundation'),
(6723, 'https://ror.org/022mzwp71', 'pt', 1, 'https://ror.org/022mzwp71 Instituto de Engenharia de Sistemas e Computadores Microsistemas e Nanotecnologias'),
(6724, 'https://ror.org/022nh6s34', 'en', 1, 'https://ror.org/022nh6s34 Institute of Transplantation Sciences'),
(6725, 'https://ror.org/022q4qx22', 'en', 1, 'https://ror.org/022q4qx22 Chicago Public Schools'),
(6726, 'https://ror.org/022q5wf04', 'en', 1, 'https://ror.org/022q5wf04 County College of Morris'),
(6727, 'https://ror.org/022r50851', 'en', 1, 'https://ror.org/022r50851 Steadman Clinic'),
(6728, 'https://ror.org/022r8xe61', 'es', 1, 'https://ror.org/022r8xe61 Centro Español de Metrología'),
(6729, 'https://ror.org/022rrvm68', 'en', 1, 'https://ror.org/022rrvm68 Pavlov Institute of Physiology of the Russian Academy of Sciences Федеральное государственное бюджетное учреждение науки Институт физиологии им. И.П. Павлова Российской академии наук'),
(6730, 'https://ror.org/022weqt39', 'no_lang_code', 1, 'https://ror.org/022weqt39 Planet Biotechnology (United States)'),
(6731, 'https://ror.org/022xw8j65', 'en', 1, 'https://ror.org/022xw8j65 University of Mount Union Université de mount union'),
(6732, 'https://ror.org/022zv0672', 'it', 1, 'https://ror.org/022zv0672 Institute for Environmental Protection and Research Istituto Superiore per la Protezione e la Ricerca Ambientale'),
(6733, 'https://ror.org/0230sdc57', 'no_lang_code', 1, 'https://ror.org/0230sdc57 Tanner Research (United States)'),
(6734, 'https://ror.org/0232mk144', 'es', 1, 'https://ror.org/0232mk144 EsSALUD, Seguro Social de Salud del Perú'),
(6735, 'https://ror.org/0232wt504', 'no_lang_code', 1, 'https://ror.org/0232wt504 RAG Aktiengesellschaft (Germany)'),
(6736, 'https://ror.org/0234k0g56', 'no_lang_code', 1, 'https://ror.org/0234k0g56 HydraTek (Canada)'),
(6737, 'https://ror.org/02358mx30', 'en', 1, 'https://ror.org/02358mx30 Institute for Safe Medication Practices'),
(6738, 'https://ror.org/0235jet62', 'en', 1, 'https://ror.org/0235jet62 Akebono Clinic'),
(6739, 'https://ror.org/0235kyq22', 'no_lang_code', 1, 'https://ror.org/0235kyq22 Petrobras (Brazil)'),
(6740, 'https://ror.org/0235n3r56', 'en', 1, 'https://ror.org/0235n3r56 Let''s Talk Science'),
(6741, 'https://ror.org/02385fa51', 'en', 1, 'https://ror.org/02385fa51 Max Planck Institute for Marine Microbiology Max-Planck-Institut für Marine Mikrobiologie'),
(6742, 'https://ror.org/0238hgm18', 'no_lang_code', 1, 'https://ror.org/0238hgm18 GeneTrace Systems (United States)'),
(6743, 'https://ror.org/0239g9287', 'en', 1, 'https://ror.org/0239g9287 East Bay Institute for Research & Education'),
(6744, 'https://ror.org/0239skj46', 'en', 1, 'https://ror.org/0239skj46 Southeast Alaska Regional Health Consortium'),
(6745, 'https://ror.org/023apm738', 'fr', 1, 'https://ror.org/023apm738 Centre d''Exploration et de Recherche Médicale par Emission de Positons'),
(6746, 'https://ror.org/023bmvr81', 'no_lang_code', 1, 'https://ror.org/023bmvr81 Agenta Biotechnologies (United States)'),
(6747, 'https://ror.org/023bn8s91', 'no_lang_code', 1, 'https://ror.org/023bn8s91 QED Labs'),
(6748, 'https://ror.org/023cd6641', 'en', 1, 'https://ror.org/023cd6641 Michigan Department of Agriculture and Rural Development'),
(6749, 'https://ror.org/023dbpz69', 'en', 1, 'https://ror.org/023dbpz69 National Association for Public Health Statistics and Information Systems'),
(6750, 'https://ror.org/023edjq13', 'no_lang_code', 1, 'https://ror.org/023edjq13 Johnson & Johnson (Germany)'),
(6751, 'https://ror.org/023egfd39', 'no_lang_code', 1, 'https://ror.org/023egfd39 Onconova Therapeutics (United States)'),
(6752, 'https://ror.org/023fm1q80', 'no_lang_code', 1, 'https://ror.org/023fm1q80 ON Semiconductor (Canada)'),
(6753, 'https://ror.org/023h3sg77', 'no_lang_code', 1, 'https://ror.org/023h3sg77 Carnival Corporation (United Kingdom)'),
(6754, 'https://ror.org/023j1kv28', 'en', 1, 'https://ror.org/023j1kv28 International Hearing Foundation'),
(6755, 'https://ror.org/023k1pq97', 'no_lang_code', 1, 'https://ror.org/023k1pq97 Bombardier (Germany)'),
(6756, 'https://ror.org/023mkm794', 'en', 1, 'https://ror.org/023mkm794 Sisseton Wahpeton College'),
(6757, 'https://ror.org/023q7jh34', 'no_lang_code', 1, 'https://ror.org/023q7jh34 Hoare Lea (United Kingdom)'),
(6758, 'https://ror.org/023q9w935', 'no_lang_code', 1, 'https://ror.org/023q9w935 INRIX (United Kingdom)'),
(6759, 'https://ror.org/023sej223', 'en', 1, 'https://ror.org/023sej223 Nova Scotia Community College'),
(6760, 'https://ror.org/023t9va96', 'no_lang_code', 1, 'https://ror.org/023t9va96 EKF Diagnostics (United States)'),
(6761, 'https://ror.org/023xsn018', 'it', 1, 'https://ror.org/023xsn018 Casa di Cura Columbus'),
(6762, 'https://ror.org/023ymdw14', 'no_lang_code', 1, 'https://ror.org/023ymdw14 Canadian Electric Vehicles (Canada)'),
(6763, 'https://ror.org/023zey656', 'en', 1, 'https://ror.org/023zey656 Biophysical Society'),
(6764, 'https://ror.org/023zgnb96', 'no_lang_code', 1, 'https://ror.org/023zgnb96 Dyadic (Netherlands)'),
(6765, 'https://ror.org/0240rwx68', 'en', 1, 'https://ror.org/0240rwx68 Istituto di Neuroscienze Neuroscience Institute'),
(6766, 'https://ror.org/02419mc73', 'en', 1, 'https://ror.org/02419mc73 Boston VA Research Institute'),
(6767, 'https://ror.org/0241wfp64', 'en', 1, 'https://ror.org/0241wfp64 Orthopedic Foot & Ankle Center'),
(6768, 'https://ror.org/0243gzr89', 'en', 1, 'https://ror.org/0243gzr89 Max Planck Institut für Biologie Max Planck Institute for Biology'),
(6769, 'https://ror.org/0243qcr03', 'no_lang_code', 1, 'https://ror.org/0243qcr03 Archetypon'),
(6770, 'https://ror.org/024712k05', 'no_lang_code', 1, 'https://ror.org/024712k05 Molsoft (United States)'),
(6771, 'https://ror.org/0248cgv13', 'no_lang_code', 1, 'https://ror.org/0248cgv13 Optron Systems (United States)'),
(6772, 'https://ror.org/0248zc213', 'en', 1, 'https://ror.org/0248zc213 Christus Health'),
(6773, 'https://ror.org/0249jjk91', 'en', 1, 'https://ror.org/0249jjk91 Kuwait Cancer Control Center'),
(6774, 'https://ror.org/024a9q404', 'no_lang_code', 1, 'https://ror.org/024a9q404 ALD NanoSolutions (United States)'),
(6775, 'https://ror.org/024dad879', 'no_lang_code', 1, 'https://ror.org/024dad879 Provid Pharmaceuticals (United States)'),
(6776, 'https://ror.org/024es8b17', 'no_lang_code', 1, 'https://ror.org/024es8b17 Natural Selection (United States)'),
(6777, 'https://ror.org/024hqjk04', 'es', 1, 'https://ror.org/024hqjk04 Administración Nacional de Laboratorios e Institutos de Salud'),
(6778, 'https://ror.org/024kwpx52', 'no_lang_code', 1, 'https://ror.org/024kwpx52 Auritec Pharmaceuticals (United States)'),
(6779, 'https://ror.org/024sjxd14', 'pt', 1, 'https://ror.org/024sjxd14 Agencia para a Modernizacao Administrativa'),
(6780, 'https://ror.org/024sy5q53', 'en', 1, 'https://ror.org/024sy5q53 Nuffield Council on Bioethics'),
(6781, 'https://ror.org/024weye46', 'en', 1, 'https://ror.org/024weye46 Conservation International'),
(6782, 'https://ror.org/024xq8r45', 'no_lang_code', 1, 'https://ror.org/024xq8r45 Thermalin Diabetes (United States)'),
(6783, 'https://ror.org/0251x9332', 'en', 1, 'https://ror.org/0251x9332 John Wesley Community Health Institute'),
(6784, 'https://ror.org/0253ddj72', 'en', 1, 'https://ror.org/0253ddj72 Portland Cement Association'),
(6785, 'https://ror.org/0259axc43', 'no_lang_code', 1, 'https://ror.org/0259axc43 SeaWell Networks (Canada)'),
(6786, 'https://ror.org/025fs6666', 'no_lang_code', 1, 'https://ror.org/025fs6666 Antigen Discovery (United States)'),
(6787, 'https://ror.org/025h55v52', 'en', 1, 'https://ror.org/025h55v52 Collections Trust'),
(6788, 'https://ror.org/025jays06', 'no_lang_code', 1, 'https://ror.org/025jays06 Greenfield Research (Canada)'),
(6789, 'https://ror.org/025ngyw60', 'en', 1, 'https://ror.org/025ngyw60 Doane University'),
(6790, 'https://ror.org/025pdmt14', 'no_lang_code', 1, 'https://ror.org/025pdmt14 Severn Trent (United Kingdom)'),
(6791, 'https://ror.org/025qedy81', 'en', 1, 'https://ror.org/025qedy81 Children''s Health Ireland at Crumlin Sláinte Leanaí Éireann ag Cromghlinn'),
(6792, 'https://ror.org/025qsw441', 'en', 1, 'https://ror.org/025qsw441 Deep River Science Academy'),
(6793, 'https://ror.org/025rx1w27', 'no_lang_code', 1, 'https://ror.org/025rx1w27 IONICS Mass Spectrometry (Canada)'),
(6794, 'https://ror.org/025s1b152', 'fr', 1, 'https://ror.org/025s1b152 Lille Catholic University Université Catholique de Lille'),
(6795, 'https://ror.org/025tz0x98', 'en', 1, 'https://ror.org/025tz0x98 Heart Clinic of Louisiana'),
(6796, 'https://ror.org/025vn3989', 'no_lang_code', 1, 'https://ror.org/025vn3989 GlaxoSmithKline (United States)'),
(6797, 'https://ror.org/025w1ct43', 'en', 1, 'https://ror.org/025w1ct43 Tri-City Medical Center'),
(6798, 'https://ror.org/025y0hb72', 'en', 1, 'https://ror.org/025y0hb72 Royal Astronomical Society of Canada'),
(6799, 'https://ror.org/025yw0g63', 'en', 1, 'https://ror.org/025yw0g63 Clinical Immunology Society'),
(6800, 'https://ror.org/025zbvz40', 'en', 1, 'https://ror.org/025zbvz40 Arizona Academy of Science'),
(6801, 'https://ror.org/025zzpg41', 'no_lang_code', 1, 'https://ror.org/025zzpg41 BioFusionary Corporation (United States)'),
(6802, 'https://ror.org/0262pp157', 'en', 1, 'https://ror.org/0262pp157 Research Institute of the Finnish Economy'),
(6803, 'https://ror.org/026365h19', 'no_lang_code', 1, 'https://ror.org/026365h19 Anvik Corporation (United States)'),
(6804, 'https://ror.org/0263fes98', 'no_lang_code', 1, 'https://ror.org/0263fes98 Center for Value Based Medicine (United States)'),
(6805, 'https://ror.org/0263jp665', 'fr', 1, 'https://ror.org/0263jp665 Hôpital René Huguenin'),
(6806, 'https://ror.org/0265tbd09', 'no_lang_code', 1, 'https://ror.org/0265tbd09 Advanced Materials Technology (United States)'),
(6807, 'https://ror.org/0266h1q26', 'en', 1, 'https://ror.org/0266h1q26 Norton Healthcare'),
(6808, 'https://ror.org/026799x08', 'no_lang_code', 1, 'https://ror.org/026799x08 CyberFluor and Kronen Systems Incorporated'),
(6809, 'https://ror.org/0269j3194', 'en', 1, 'https://ror.org/0269j3194 Global HIV Vaccine Enterprise'),
(6810, 'https://ror.org/026atsz45', 'en', 1, 'https://ror.org/026atsz45 Montana Wyoming Tribal Leaders Council'),
(6811, 'https://ror.org/026b6f512', 'no_lang_code', 1, 'https://ror.org/026b6f512 Tinderbox Consultants (United Kingdom)'),
(6812, 'https://ror.org/026bd4t65', 'no_lang_code', 1, 'https://ror.org/026bd4t65 UT Dots (United States)'),
(6813, 'https://ror.org/026ejyb70', 'en', 1, 'https://ror.org/026ejyb70 Oxford Centre for Computational Neuroscience'),
(6814, 'https://ror.org/026gzzy53', 'no_lang_code', 1, 'https://ror.org/026gzzy53 Grado Zero Espace (Italy)'),
(6815, 'https://ror.org/026h6d543', 'es', 1, 'https://ror.org/026h6d543 Ayuntamiento de Madrid'),
(6816, 'https://ror.org/026jzqm86', 'en', 1, 'https://ror.org/026jzqm86 Productive Rehabilitation Institute of Dallas for Ergonomics'),
(6817, 'https://ror.org/026ms9533', 'en', 1, 'https://ror.org/026ms9533 Hazardous Materials Training and Research Institute'),
(6818, 'https://ror.org/026nmvv73', 'en', 1, 'https://ror.org/026nmvv73 Max Planck Institute for Biological Cybernetics Max-Planck-Institut für Biologische Kybernetik'),
(6819, 'https://ror.org/026prsd04', 'no_lang_code', 1, 'https://ror.org/026prsd04 CytoCure (United States)'),
(6820, 'https://ror.org/026vpvt76', 'no_lang_code', 1, 'https://ror.org/026vpvt76 Geron (United States)'),
(6821, 'https://ror.org/026x7hp94', 'no_lang_code', 1, 'https://ror.org/026x7hp94 Biopeptide (United States)'),
(6822, 'https://ror.org/026zvyv64', 'no_lang_code', 1, 'https://ror.org/026zvyv64 Assystem (Germany)'),
(6823, 'https://ror.org/0271yft62', 'no_lang_code', 1, 'https://ror.org/0271yft62 Harrington Software Associates'),
(6824, 'https://ror.org/0272c7580', 'no_lang_code', 1, 'https://ror.org/0272c7580 NeoClone (United States)');
INSERT INTO `rors` VALUES
(6825, 'https://ror.org/0273kmy05', 'no_lang_code', 1, 'https://ror.org/0273kmy05 Passat (Canada)'),
(6826, 'https://ror.org/0275fz765', 'en', 1, 'https://ror.org/0275fz765 National Aquarium'),
(6827, 'https://ror.org/0276e1563', 'en', 1, 'https://ror.org/0276e1563 South Dakota Department of Social Services'),
(6828, 'https://ror.org/0277xgb12', 'en', 1, 'https://ror.org/0277xgb12 Institute of Cytology and Genetics Федеральный исследовательский центр Институт цитологии и генетики Сибирского отделения Российской академии наук'),
(6829, 'https://ror.org/027892803', 'no_lang_code', 1, 'https://ror.org/027892803 Boston Medical Products (United States)'),
(6830, 'https://ror.org/027923343', 'en', 1, 'https://ror.org/027923343 Victorian Order of Nurses'),
(6831, 'https://ror.org/0279fsn39', 'no_lang_code', 1, 'https://ror.org/0279fsn39 Aedas (United Kingdom)'),
(6832, 'https://ror.org/027a0b050', 'no_lang_code', 1, 'https://ror.org/027a0b050 Integrated BioTherapeutics (United States)'),
(6833, 'https://ror.org/027ade760', 'en', 1, 'https://ror.org/027ade760 Tabba Heart Institute'),
(6834, 'https://ror.org/027akq961', 'fr', 1, 'https://ror.org/027akq961 Institut de la Main'),
(6835, 'https://ror.org/027as9m12', 'en', 1, 'https://ror.org/027as9m12 Canadian Obesity Network Réseau Canadien en l’Obésité'),
(6836, 'https://ror.org/027e41r21', 'no_lang_code', 1, 'https://ror.org/027e41r21 Chemica Technologies (United States)'),
(6837, 'https://ror.org/027g3rh44', 'en', 1, 'https://ror.org/027g3rh44 New Economics Foundation'),
(6838, 'https://ror.org/027h1w574', 'en', 1, 'https://ror.org/027h1w574 Kidwai Memorial Institute of Oncology'),
(6839, 'https://ror.org/027h69z40', 'no_lang_code', 1, 'https://ror.org/027h69z40 AlertMe (United Kingdom)'),
(6840, 'https://ror.org/027hwkg23', 'en', 1, 'https://ror.org/027hwkg23 Engelhardt Institute of Molecular Biology Федеральное государственное бюджетное учреждение науки Институт молекулярной биологии им. В.А. Энгельгардта Российской академии наук'),
(6841, 'https://ror.org/027j12e75', 'no_lang_code', 1, 'https://ror.org/027j12e75 Quantum Simulations (United States)'),
(6842, 'https://ror.org/027qenx56', 'no_lang_code', 1, 'https://ror.org/027qenx56 Capcom Vancouver (Canada)'),
(6843, 'https://ror.org/027tbp210', 'en', 1, 'https://ror.org/027tbp210 Centre for Life'),
(6844, 'https://ror.org/027tjex48', 'no_lang_code', 1, 'https://ror.org/027tjex48 Meiji (Japan) 明治'),
(6845, 'https://ror.org/027zey487', 'no_lang_code', 1, 'https://ror.org/027zey487 Celdara Medical (United States)'),
(6846, 'https://ror.org/0281e1q12', 'en', 1, 'https://ror.org/0281e1q12 Institute for Broadening Participation'),
(6847, 'https://ror.org/0281jqk77', 'en', 1, 'https://ror.org/0281jqk77 Nuffield Foundation'),
(6848, 'https://ror.org/0282bjj02', 'no_lang_code', 1, 'https://ror.org/0282bjj02 Promiliad Biopharma (United States)'),
(6849, 'https://ror.org/0284zjc89', 'no_lang_code', 1, 'https://ror.org/0284zjc89 Yokufukai Hospital 浴風会病院'),
(6850, 'https://ror.org/0285qgt37', 'no_lang_code', 1, 'https://ror.org/0285qgt37 Applied System Technologies (United States)'),
(6851, 'https://ror.org/0286eck14', 'it', 1, 'https://ror.org/0286eck14 Istituto Agronomico Mediterraneo di Bari Mediterranean Agronomic Institute of Bari'),
(6852, 'https://ror.org/0286exd49', 'no_lang_code', 1, 'https://ror.org/0286exd49 SaskTel (Canada)'),
(6853, 'https://ror.org/0286xn075', 'no_lang_code', 1, 'https://ror.org/0286xn075 21st Century Medicine (United States)'),
(6854, 'https://ror.org/028807987', 'en', 1, 'https://ror.org/028807987 Kyoto Research Park 京都リサーチパーク'),
(6855, 'https://ror.org/02882ey95', 'en', 1, 'https://ror.org/02882ey95 Society for Academic Emergency Medicine'),
(6856, 'https://ror.org/02889gd81', 'no_lang_code', 1, 'https://ror.org/02889gd81 Unicon Research (United States)'),
(6857, 'https://ror.org/0288qta63', 'en', 1, 'https://ror.org/0288qta63 Hartwick College'),
(6858, 'https://ror.org/0289bhn79', 'no_lang_code', 1, 'https://ror.org/0289bhn79 Telesensory (United States)'),
(6859, 'https://ror.org/0289e7d92', 'en', 1, 'https://ror.org/0289e7d92 Belgian Road Research Centre'),
(6860, 'https://ror.org/0289ggs32', 'es', 1, 'https://ror.org/0289ggs32 Administracion de los Servicios de Salud del Estado'),
(6861, 'https://ror.org/028a3y923', 'no_lang_code', 1, 'https://ror.org/028a3y923 VisionQuest Biomedical (United States)'),
(6862, 'https://ror.org/028ca6f22', 'en', 1, 'https://ror.org/028ca6f22 Clark Planetarium'),
(6863, 'https://ror.org/028chtg69', 'no_lang_code', 1, 'https://ror.org/028chtg69 SVT Associates (United States)'),
(6864, 'https://ror.org/028e1xc68', 'en', 1, 'https://ror.org/028e1xc68 Center for Clinical & Basic Research'),
(6865, 'https://ror.org/028fd8812', 'en', 1, 'https://ror.org/028fd8812 Santa Clara Valley Health and Hospital System'),
(6866, 'https://ror.org/028ffjf65', 'en', 1, 'https://ror.org/028ffjf65 Black Women’s Health Imperative'),
(6867, 'https://ror.org/028k36c88', 'en', 1, 'https://ror.org/028k36c88 Science North'),
(6868, 'https://ror.org/028mr0844', 'en', 1, 'https://ror.org/028mr0844 European Monitoring Centre for Drugs and Drug Addiction Observatório Europeu da Droga e da Toxicodependência'),
(6869, 'https://ror.org/028my8947', 'en', 1, 'https://ror.org/028my8947 Chabot Space and Science Center'),
(6870, 'https://ror.org/028p2na45', 'no_lang_code', 1, 'https://ror.org/028p2na45 MagneSensors (United States)'),
(6871, 'https://ror.org/028q4nk39', 'no_lang_code', 1, 'https://ror.org/028q4nk39 Pipehawk (United Kingdom)'),
(6872, 'https://ror.org/028qa3n13', 'en', 1, 'https://ror.org/028qa3n13 Indian Institute of Science Education and Research Pune भारतीय विज्ञान शिक्षा एवं अनुसंधान संस्थान, पुणे'),
(6873, 'https://ror.org/028qd3f30', 'en', 1, 'https://ror.org/028qd3f30 Government Dental College & Research Institute'),
(6874, 'https://ror.org/028rev379', 'en', 1, 'https://ror.org/028rev379 Policy Research Associates'),
(6875, 'https://ror.org/028t43p77', 'en', 1, 'https://ror.org/028t43p77 Departamento del Tesoro de los Estados Unidos Département du trésor des États-unis United States Department of the Treasury'),
(6876, 'https://ror.org/028tzq930', 'en', 1, 'https://ror.org/028tzq930 Kirkwood Community College'),
(6877, 'https://ror.org/028yyha11', 'no_lang_code', 1, 'https://ror.org/028yyha11 GMI Aero (France)'),
(6878, 'https://ror.org/028zpwn78', 'fr', 1, 'https://ror.org/028zpwn78 Centre de Recherche et d’Information sur la Démocratie et l''Autonomie'),
(6879, 'https://ror.org/0290kkw06', 'no_lang_code', 1, 'https://ror.org/0290kkw06 Applied Behavioral Research (United States)'),
(6880, 'https://ror.org/0290x3782', 'no_lang_code', 1, 'https://ror.org/0290x3782 PV Crystalox Solar (United Kingdom)'),
(6881, 'https://ror.org/0291gd333', 'no_lang_code', 1, 'https://ror.org/0291gd333 STATegics (United States)'),
(6882, 'https://ror.org/02927dx12', 'en', 1, 'https://ror.org/02927dx12 Institute of Life Sciences'),
(6883, 'https://ror.org/0292awh62', 'no_lang_code', 1, 'https://ror.org/0292awh62 Merck (Japan) メルク'),
(6884, 'https://ror.org/0293t9757', 'no_lang_code', 1, 'https://ror.org/0293t9757 Droplet Measurement Technologies (United States)'),
(6885, 'https://ror.org/0295s2632', 'en', 1, 'https://ror.org/0295s2632 La Comisión Latina sobre el SIDA Latino Commission on AIDS'),
(6886, 'https://ror.org/02966z980', 'en', 1, 'https://ror.org/02966z980 Seminole State College of Florida'),
(6887, 'https://ror.org/0296e0332', 'en', 1, 'https://ror.org/0296e0332 Iowa Department of Inspections and Appeals'),
(6888, 'https://ror.org/0296esg18', 'en', 1, 'https://ror.org/0296esg18 Valencia College'),
(6889, 'https://ror.org/0296s4x19', 'no_lang_code', 1, 'https://ror.org/0296s4x19 Orion Corporation (Finland) Orion Oyj'),
(6890, 'https://ror.org/02996zz79', 'en', 1, 'https://ror.org/02996zz79 Voorhees College'),
(6891, 'https://ror.org/029aeh759', 'no_lang_code', 1, 'https://ror.org/029aeh759 Kromek (United States)'),
(6892, 'https://ror.org/029benr66', 'en', 1, 'https://ror.org/029benr66 Austrian Energy Agency Österreichische Energieagentur'),
(6893, 'https://ror.org/029dkfk52', 'no_lang_code', 1, 'https://ror.org/029dkfk52 Interlab (United States)'),
(6894, 'https://ror.org/029fngx98', 'it', 1, 'https://ror.org/029fngx98 Servizio sanitario dell''Emilia-Romagna'),
(6895, 'https://ror.org/029g5f696', 'no_lang_code', 1, 'https://ror.org/029g5f696 Cook General BioTechnology (United States)'),
(6896, 'https://ror.org/029kax838', 'no_lang_code', 1, 'https://ror.org/029kax838 Muprime Technology (Canada)'),
(6897, 'https://ror.org/029ndp841', 'no_lang_code', 1, 'https://ror.org/029ndp841 Ash Stevens (United States)'),
(6898, 'https://ror.org/029nvrb94', 'en', 1, 'https://ror.org/029nvrb94 Singapore National Eye Center'),
(6899, 'https://ror.org/029p1pm63', 'en', 1, 'https://ror.org/029p1pm63 Williams LifeSkills'),
(6900, 'https://ror.org/029sr1j73', 'en', 1, 'https://ror.org/029sr1j73 Ospidéal Mhuire Lourdes Our Lady of Lourdes Hospital'),
(6901, 'https://ror.org/029w5ya68', 'en', 1, 'https://ror.org/029w5ya68 European Neuroscience Institute Göttingen'),
(6902, 'https://ror.org/029wcr898', 'it', 1, 'https://ror.org/029wcr898 Centro Tessile Cotoniero e Abbigliamento'),
(6903, 'https://ror.org/029xxx628', 'en', 1, 'https://ror.org/029xxx628 Aquinas Institute of Theology'),
(6904, 'https://ror.org/029ybkn33', 'no_lang_code', 1, 'https://ror.org/029ybkn33 Edenspace Systems (United States)'),
(6905, 'https://ror.org/029yxsv15', 'en', 1, 'https://ror.org/029yxsv15 Society of General Physiologists'),
(6906, 'https://ror.org/029z7h505', 'en', 1, 'https://ror.org/029z7h505 Salt Lake Community College'),
(6907, 'https://ror.org/029zamy29', 'no_lang_code', 1, 'https://ror.org/029zamy29 Springer Nature (New Zealand)'),
(6908, 'https://ror.org/029zb5621', 'en', 1, 'https://ror.org/029zb5621 Central Rice Research Institute'),
(6909, 'https://ror.org/02a0sqy81', 'en', 1, 'https://ror.org/02a0sqy81 Columbia Education'),
(6910, 'https://ror.org/02a33b393', 'en', 1, 'https://ror.org/02a33b393 Max Planck Institute for Evolutionary Anthropology Max-Planck-Institut für Evolutionäre Anthropologie'),
(6911, 'https://ror.org/02a4gss26', 'no_lang_code', 1, 'https://ror.org/02a4gss26 Sasol (South Africa)'),
(6912, 'https://ror.org/02aawcy27', 'no_lang_code', 1, 'https://ror.org/02aawcy27 Navigen (United States)'),
(6913, 'https://ror.org/02ab50f57', 'it', 1, 'https://ror.org/02ab50f57 Confederazione Italiana Sindacati Lavoratori Italian Confederation of Workers'' Trade Unions'),
(6914, 'https://ror.org/02acb4z65', 'en', 1, 'https://ror.org/02acb4z65 Sequoia Foundation'),
(6915, 'https://ror.org/02adgag39', 'no_lang_code', 1, 'https://ror.org/02adgag39 Aixtron (Germany)'),
(6916, 'https://ror.org/02afj1h05', 'en', 1, 'https://ror.org/02afj1h05 Research Institute for Olympic Sports'),
(6917, 'https://ror.org/02agkk742', 'en', 1, 'https://ror.org/02agkk742 National Institute of Indian Medical Heritage राष्ट्रीय भारतीय आयुर्विज्ञान संपदा संस्थान'),
(6918, 'https://ror.org/02ah36853', 'en', 1, 'https://ror.org/02ah36853 Midwest Eye Institute'),
(6919, 'https://ror.org/02aj0wy64', 'es', 1, 'https://ror.org/02aj0wy64 Centro Hospitalario Pereira Rossell, Hospital Pereira Rossell'),
(6920, 'https://ror.org/02aqv1x10', 'en', 1, 'https://ror.org/02aqv1x10 Marie Curie'),
(6921, 'https://ror.org/02arg8v16', 'no_lang_code', 1, 'https://ror.org/02arg8v16 Enapter (Italy)'),
(6922, 'https://ror.org/02as34v38', 'no_lang_code', 1, 'https://ror.org/02as34v38 Ørsted (Denmark)'),
(6923, 'https://ror.org/02av0ty63', 'no_lang_code', 1, 'https://ror.org/02av0ty63 Palladian Partners'),
(6924, 'https://ror.org/02avws951', 'no_lang_code', 1, 'https://ror.org/02avws951 Fresenius Medical Care (United States)'),
(6925, 'https://ror.org/02axars19', 'en', 1, 'https://ror.org/02axars19 Gansu Provincial Hospital 甘肃省人民医院'),
(6926, 'https://ror.org/02axsa366', 'en', 1, 'https://ror.org/02axsa366 Santa Fe Community College'),
(6927, 'https://ror.org/02aykj333', 'no_lang_code', 1, 'https://ror.org/02aykj333 Audi (Germany)'),
(6928, 'https://ror.org/02azqtm75', 'en', 1, 'https://ror.org/02azqtm75 National Sanitation Foundation International'),
(6929, 'https://ror.org/02azsay93', 'en', 1, 'https://ror.org/02azsay93 Pakistan Health Research Council مجلس البحوث الطبية في باكستان'),
(6930, 'https://ror.org/02b10nq15', 'en', 1, 'https://ror.org/02b10nq15 Roskamp Institute'),
(6931, 'https://ror.org/02b1qqv62', 'en', 1, 'https://ror.org/02b1qqv62 National Food Administration'),
(6932, 'https://ror.org/02b2x6q12', 'en', 1, 'https://ror.org/02b2x6q12 AID Atlanta'),
(6933, 'https://ror.org/02b5mfy68', 'it', 1, 'https://ror.org/02b5mfy68 Istituto Dermopatico dell''Immacolata'),
(6934, 'https://ror.org/02b9pea19', 'en', 1, 'https://ror.org/02b9pea19 Coastal Bend Wellness Foundation'),
(6935, 'https://ror.org/02bawng60', 'no_lang_code', 1, 'https://ror.org/02bawng60 Novasentis (United States)'),
(6936, 'https://ror.org/02bbrpp66', 'no_lang_code', 1, 'https://ror.org/02bbrpp66 Convergent Manufacturing Technologies (Canada)'),
(6937, 'https://ror.org/02be9aj39', 'en', 1, 'https://ror.org/02be9aj39 H. R. MacMillan Space Centre'),
(6938, 'https://ror.org/02bez8p50', 'no_lang_code', 1, 'https://ror.org/02bez8p50 ArcelorMittal (Luxembourg)'),
(6939, 'https://ror.org/02bf6t552', 'en', 1, 'https://ror.org/02bf6t552 American College of Chest Physicians'),
(6940, 'https://ror.org/02bfrb046', 'no_lang_code', 1, 'https://ror.org/02bfrb046 Polysciences (United States)'),
(6941, 'https://ror.org/02bhe9a93', 'en', 1, 'https://ror.org/02bhe9a93 British Hydromechanics Research Group'),
(6942, 'https://ror.org/02bkd7d61', 'en', 1, 'https://ror.org/02bkd7d61 Hokkaido Agricultural Research Center 北海道農業研究センター'),
(6943, 'https://ror.org/02bm24g42', 'es', 1, 'https://ror.org/02bm24g42 Asociación Civil Impacta Salud y Educación'),
(6944, 'https://ror.org/02bm6g618', 'en', 1, 'https://ror.org/02bm6g618 Russell Sage College'),
(6945, 'https://ror.org/02bmj6022', 'no_lang_code', 1, 'https://ror.org/02bmj6022 Omneuron (United States)'),
(6946, 'https://ror.org/02bpm1n29', 'no_lang_code', 1, 'https://ror.org/02bpm1n29 Southeast TechInventures (United States)'),
(6947, 'https://ror.org/02bpqmq41', 'en', 1, 'https://ror.org/02bpqmq41 China Rehabilitation Research Center'),
(6948, 'https://ror.org/02brfgh04', 'en', 1, 'https://ror.org/02brfgh04 Institute of Human Behaviour and Allied Sciences'),
(6949, 'https://ror.org/02brpaf34', 'it', 1, 'https://ror.org/02brpaf34 Istituto Ortopedico Gaetano Pini'),
(6950, 'https://ror.org/02bsaqx63', 'en', 1, 'https://ror.org/02bsaqx63 House Clinic'),
(6951, 'https://ror.org/02bt45m31', 'en', 1, 'https://ror.org/02bt45m31 American Medical Informatics Association'),
(6952, 'https://ror.org/02bwfhj24', 'en', 1, 'https://ror.org/02bwfhj24 Center for Telepsychology'),
(6953, 'https://ror.org/02bwppq44', 'no_lang_code', 1, 'https://ror.org/02bwppq44 Mo Sci Corporation (United States)'),
(6954, 'https://ror.org/02bwrq566', 'no_lang_code', 1, 'https://ror.org/02bwrq566 Carmeq (Germany)'),
(6955, 'https://ror.org/02bwz0282', 'no_lang_code', 1, 'https://ror.org/02bwz0282 GLC Biotechnology (United States)'),
(6956, 'https://ror.org/02bx0ak73', 'en', 1, 'https://ror.org/02bx0ak73 Woodland Hills Medical Center'),
(6957, 'https://ror.org/02bzq7389', 'en', 1, 'https://ror.org/02bzq7389 Howard Community College'),
(6958, 'https://ror.org/02c1at876', 'no_lang_code', 1, 'https://ror.org/02c1at876 Martec (Canada)'),
(6959, 'https://ror.org/02c22vc57', 'en', 1, 'https://ror.org/02c22vc57 Leibniz Institute for Prevention Research and Epidemiology - BIPS Leibniz-Institut für Präventionsforschung und Epidemiologie - BIPS'),
(6960, 'https://ror.org/02c235t25', 'en', 1, 'https://ror.org/02c235t25 Northwest Indian College'),
(6961, 'https://ror.org/02c241b98', 'en', 1, 'https://ror.org/02c241b98 Associated Skin Care Specialists'),
(6962, 'https://ror.org/02c27v641', 'en', 1, 'https://ror.org/02c27v641 Northeastern Oklahoma A&M College'),
(6963, 'https://ror.org/02c2e2v80', 'en', 1, 'https://ror.org/02c2e2v80 Institute of Biology and Immunology of Reproduction Институт по биология и имунология на размножаването'),
(6964, 'https://ror.org/02c3hd322', 'en', 1, 'https://ror.org/02c3hd322 National Public Radio'),
(6965, 'https://ror.org/02c5bjt68', 'en', 1, 'https://ror.org/02c5bjt68 Community Rehabilitation Center'),
(6966, 'https://ror.org/02c5sgb74', 'en', 1, 'https://ror.org/02c5sgb74 Collaborative Research Group'),
(6967, 'https://ror.org/02c761853', 'no_lang_code', 1, 'https://ror.org/02c761853 Proto Corporation (United States)'),
(6968, 'https://ror.org/02ca2n422', 'no_lang_code', 1, 'https://ror.org/02ca2n422 Attana (Sweden)'),
(6969, 'https://ror.org/02carhc19', 'fr', 1, 'https://ror.org/02carhc19 Centre Hospitalier de Tourcoing'),
(6970, 'https://ror.org/02caytj08', 'en', 1, 'https://ror.org/02caytj08 Defense Advanced Research Projects Agency'),
(6971, 'https://ror.org/02cbwht62', 'en', 1, 'https://ror.org/02cbwht62 Department of Services for Children Youth and their Families'),
(6972, 'https://ror.org/02cfbec64', 'fr', 1, 'https://ror.org/02cfbec64 Hôpital Militaire Avicenne'),
(6973, 'https://ror.org/02cfj6k65', 'no_lang_code', 1, 'https://ror.org/02cfj6k65 Watershed'),
(6974, 'https://ror.org/02cmjqw34', 'en', 1, 'https://ror.org/02cmjqw34 My Brother''s Keeper'),
(6975, 'https://ror.org/02cqwf592', 'no_lang_code', 1, 'https://ror.org/02cqwf592 Analysis and Monitoring of Environmental Risk'),
(6976, 'https://ror.org/02csvyc65', 'no_lang_code', 1, 'https://ror.org/02csvyc65 IMRIS (Canada)'),
(6977, 'https://ror.org/02cvrf195', 'no_lang_code', 1, 'https://ror.org/02cvrf195 Polestar Technologies (United States)'),
(6978, 'https://ror.org/02czfmn65', 'en', 1, 'https://ror.org/02czfmn65 Thames Valley Children''s Centre'),
(6979, 'https://ror.org/02d0e3p67', 'en', 1, 'https://ror.org/02d0e3p67 Wollongong Hospital'),
(6980, 'https://ror.org/02d33pz63', 'no_lang_code', 1, 'https://ror.org/02d33pz63 CCS Associates (United States)'),
(6981, 'https://ror.org/02d4g5x37', 'no_lang_code', 1, 'https://ror.org/02d4g5x37 Virginia Technologies (United States)'),
(6982, 'https://ror.org/02d4smc03', 'en', 1, 'https://ror.org/02d4smc03 GF Strong Rehabilitation Centre'),
(6983, 'https://ror.org/02d4twb46', 'en', 1, 'https://ror.org/02d4twb46 Sound Health Options'),
(6984, 'https://ror.org/02d6ew870', 'no_lang_code', 1, 'https://ror.org/02d6ew870 Baxter (United States)'),
(6985, 'https://ror.org/02d7h9t50', 'no_lang_code', 1, 'https://ror.org/02d7h9t50 Consad (United States)'),
(6986, 'https://ror.org/02d8ncy29', 'en', 1, 'https://ror.org/02d8ncy29 Yokkaichi Social Insurance Hospital 四日市羽津医療センター'),
(6987, 'https://ror.org/02d93ae38', 'en', 1, 'https://ror.org/02d93ae38 Institute for Social Security and Services for State Workers Instituto de Seguridad y Servicios Sociales de los Trabajadores del Estado'),
(6988, 'https://ror.org/02d9tbb08', 'en', 1, 'https://ror.org/02d9tbb08 Henry Ford College'),
(6989, 'https://ror.org/02davtb12', 'it', 1, 'https://ror.org/02davtb12 Centro San Giovanni di Dio Fatebenefratelli'),
(6990, 'https://ror.org/02dbn9a54', 'no_lang_code', 1, 'https://ror.org/02dbn9a54 DiaSorin (Ireland)'),
(6991, 'https://ror.org/02dc0q644', 'en', 1, 'https://ror.org/02dc0q644 Psychological Health Associates'),
(6992, 'https://ror.org/02dcdb854', 'no_lang_code', 1, 'https://ror.org/02dcdb854 SeraCare Life Sciences (United States)'),
(6993, 'https://ror.org/02dgnkc37', 'no_lang_code', 1, 'https://ror.org/02dgnkc37 TDIC (United States)'),
(6994, 'https://ror.org/02dk80w07', 'en', 1, 'https://ror.org/02dk80w07 Museu Nacional de Arte Antiga National Museum of Ancient Art'),
(6995, 'https://ror.org/02dphst03', 'en', 1, 'https://ror.org/02dphst03 National Council for Science and the Environment'),
(6996, 'https://ror.org/02dq1ca65', 'no_lang_code', 1, 'https://ror.org/02dq1ca65 Minerva Biotechnologies (United States)'),
(6997, 'https://ror.org/02dqztz06', 'en', 1, 'https://ror.org/02dqztz06 Electric Power Research Institute'),
(6998, 'https://ror.org/02dtzq355', 'no_lang_code', 1, 'https://ror.org/02dtzq355 Endesa (Spain)'),
(6999, 'https://ror.org/02dw7ch21', 'no_lang_code', 1, 'https://ror.org/02dw7ch21 Element Six (United Kingdom)'),
(7000, 'https://ror.org/02dw95q60', 'en', 1, 'https://ror.org/02dw95q60 New York Heart Research Foundation'),
(7001, 'https://ror.org/02dx8kd29', 'sr', 1, 'https://ror.org/02dx8kd29 Institut za Zdravstvenu Zastitu Majke i Deteta'),
(7002, 'https://ror.org/02dxbtx84', 'no_lang_code', 1, 'https://ror.org/02dxbtx84 Colorobbia (Italy)'),
(7003, 'https://ror.org/02dy9y553', 'en', 1, 'https://ror.org/02dy9y553 Amrith Educational and Cultural Society'),
(7004, 'https://ror.org/02dywg371', 'en', 1, 'https://ror.org/02dywg371 Del Mar College'),
(7005, 'https://ror.org/02e1bds08', 'no_lang_code', 1, 'https://ror.org/02e1bds08 Corning (France)'),
(7006, 'https://ror.org/02e1s7e95', 'en', 1, 'https://ror.org/02e1s7e95 Kettering Foundation'),
(7007, 'https://ror.org/02e1syn97', 'en', 1, 'https://ror.org/02e1syn97 Glendale Community College'),
(7008, 'https://ror.org/02e3ssq97', 'en', 1, 'https://ror.org/02e3ssq97 Don Carlo Gnocchi Foundation'),
(7009, 'https://ror.org/02e463172', 'en', 1, 'https://ror.org/02e463172 American Cancer Society'),
(7010, 'https://ror.org/02e71kh42', 'en', 1, 'https://ror.org/02e71kh42 Oncology Nursing Society'),
(7011, 'https://ror.org/02e891h43', 'en', 1, 'https://ror.org/02e891h43 Mount Mercy University'),
(7012, 'https://ror.org/02e9za279', 'no_lang_code', 1, 'https://ror.org/02e9za279 Galen Research (United Kingdom)'),
(7013, 'https://ror.org/02ebc4h13', 'no_lang_code', 1, 'https://ror.org/02ebc4h13 Inframat Corporation (United States)'),
(7014, 'https://ror.org/02ec4x178', 'no_lang_code', 1, 'https://ror.org/02ec4x178 Bombardier (Sweden)'),
(7015, 'https://ror.org/02ecczf03', 'en', 1, 'https://ror.org/02ecczf03 Ontario AIDS Network'),
(7016, 'https://ror.org/02ed5f444', 'no_lang_code', 1, 'https://ror.org/02ed5f444 Ligand Pharmaceuticals (United States)'),
(7017, 'https://ror.org/02edt9m80', 'no_lang_code', 1, 'https://ror.org/02edt9m80 GT Urological (United States)'),
(7018, 'https://ror.org/02edynn23', 'no_lang_code', 1, 'https://ror.org/02edynn23 BioFormatix (United States)'),
(7019, 'https://ror.org/02ee2kk58', 'en', 1, 'https://ror.org/02ee2kk58 MUJHU Research Collaboration'),
(7020, 'https://ror.org/02ega5r05', 'en', 1, 'https://ror.org/02ega5r05 Mendez National Institute of Transplantation'),
(7021, 'https://ror.org/02ehan050', 'en', 1, 'https://ror.org/02ehan050 North Central College'),
(7022, 'https://ror.org/02ehrn304', 'en', 1, 'https://ror.org/02ehrn304 Zayed Military Hospital مستشفى زايد العسكري'),
(7023, 'https://ror.org/02en7tm18', 'no_lang_code', 1, 'https://ror.org/02en7tm18 Cyntelix (Netherlands)'),
(7024, 'https://ror.org/02epq7t62', 'no_lang_code', 1, 'https://ror.org/02epq7t62 Amplitude Systèmes (France)'),
(7025, 'https://ror.org/02er0sb79', 'en', 1, 'https://ror.org/02er0sb79 EuroEspes Biomedical Research Center'),
(7026, 'https://ror.org/02es2jq57', 'fr', 1, 'https://ror.org/02es2jq57 Cegep Edouard Montpetit, Collège Édouard-Montpetit'),
(7027, 'https://ror.org/02ev1p206', 'en', 1, 'https://ror.org/02ev1p206 Center for Renewable Energy Sources and Saving'),
(7028, 'https://ror.org/02exhb815', 'no_lang_code', 1, 'https://ror.org/02exhb815 Royan Institute'),
(7029, 'https://ror.org/02exxw634', 'en', 1, 'https://ror.org/02exxw634 Wartburg College'),
(7030, 'https://ror.org/02ezy5072', 'no_lang_code', 1, 'https://ror.org/02ezy5072 Amgen (Germany)'),
(7031, 'https://ror.org/02f09jf04', 'en', 1, 'https://ror.org/02f09jf04 Fertility Medical Group'),
(7032, 'https://ror.org/02f0ewv41', 'no_lang_code', 1, 'https://ror.org/02f0ewv41 OG Technologies (United States)'),
(7033, 'https://ror.org/02f12sz84', 'no_lang_code', 1, 'https://ror.org/02f12sz84 3M (France)'),
(7034, 'https://ror.org/02f131c52', 'en', 1, 'https://ror.org/02f131c52 Adrian College'),
(7035, 'https://ror.org/02f1dqm79', 'no_lang_code', 1, 'https://ror.org/02f1dqm79 Luminex (Canada)'),
(7036, 'https://ror.org/02f23ya44', 'no_lang_code', 1, 'https://ror.org/02f23ya44 CleverSys (United States)'),
(7037, 'https://ror.org/02f29yc36', 'en', 1, 'https://ror.org/02f29yc36 Webb Institute'),
(7038, 'https://ror.org/02f2ddv05', 'no_lang_code', 1, 'https://ror.org/02f2ddv05 Blue Spurs (Canada)'),
(7039, 'https://ror.org/02f3vqc77', 'en', 1, 'https://ror.org/02f3vqc77 Coastline Community College'),
(7040, 'https://ror.org/02f51rf24', 'no_lang_code', 1, 'https://ror.org/02f51rf24 Regeneron (United States)'),
(7041, 'https://ror.org/02f67ap41', 'en', 1, 'https://ror.org/02f67ap41 Presentation College'),
(7042, 'https://ror.org/02f8ah997', 'en', 1, 'https://ror.org/02f8ah997 Transitional Learning Center'),
(7043, 'https://ror.org/02f99v835', 'en', 1, 'https://ror.org/02f99v835 Deutsches Primatenzentrum German Primate Center'),
(7044, 'https://ror.org/02fag2f73', 'en', 1, 'https://ror.org/02fag2f73 Randolph College'),
(7045, 'https://ror.org/02fc7xd23', 'en', 1, 'https://ror.org/02fc7xd23 Shanghai Research Center for Acupuncture and Meridians 上海市针灸经络研究中心'),
(7046, 'https://ror.org/02fd83219', 'no_lang_code', 1, 'https://ror.org/02fd83219 Fluorous Technologies (United States)'),
(7047, 'https://ror.org/02fdhvf98', 'no_lang_code', 1, 'https://ror.org/02fdhvf98 Degenkolb (United States)'),
(7048, 'https://ror.org/02fhhd636', 'no_lang_code', 1, 'https://ror.org/02fhhd636 Endres Machining Innovations (United States)'),
(7049, 'https://ror.org/02fjffw59', 'no_lang_code', 1, 'https://ror.org/02fjffw59 X-ray Instrumentation Associates (United States)'),
(7050, 'https://ror.org/02fm7xd67', 'no_lang_code', 1, 'https://ror.org/02fm7xd67 Delcam (United Kingdom)'),
(7051, 'https://ror.org/02fn1q641', 'no_lang_code', 1, 'https://ror.org/02fn1q641 Affinity Water (United Kingdom)'),
(7052, 'https://ror.org/02fncne76', 'en', 1, 'https://ror.org/02fncne76 Kentucky Wesleyan College'),
(7053, 'https://ror.org/02fprvw90', 'no_lang_code', 1, 'https://ror.org/02fprvw90 FoodChek Systems (Canada)'),
(7054, 'https://ror.org/02frwff62', 'it', 1, 'https://ror.org/02frwff62 CTO Andrea Alesini'),
(7055, 'https://ror.org/02frzq211', 'en', 1, 'https://ror.org/02frzq211 UK Biobank'),
(7056, 'https://ror.org/02ft67b52', 'no_lang_code', 1, 'https://ror.org/02ft67b52 NCC (Denmark)'),
(7057, 'https://ror.org/02fwe2f11', 'en', 1, 'https://ror.org/02fwe2f11 Tung Wah Eastern Hospital 東華東院'),
(7058, 'https://ror.org/02fwr8382', 'no_lang_code', 1, 'https://ror.org/02fwr8382 AITIA International (Hungary)'),
(7059, 'https://ror.org/02fyr1a65', 'no_lang_code', 1, 'https://ror.org/02fyr1a65 DunavNET (Serbia)'),
(7060, 'https://ror.org/02fywtq82', 'no_lang_code', 1, 'https://ror.org/02fywtq82 Organisation de Coordination pour la lutte contre les Endémies en Afrique Centrale'),
(7061, 'https://ror.org/02fz4s018', 'en', 1, 'https://ror.org/02fz4s018 Heritage Foundation'),
(7062, 'https://ror.org/02g5x8q86', 'en', 1, 'https://ror.org/02g5x8q86 Discovery Centre'),
(7063, 'https://ror.org/02g6ngv74', 'no_lang_code', 1, 'https://ror.org/02g6ngv74 Curis (United States)'),
(7064, 'https://ror.org/02g726t95', 'en', 1, 'https://ror.org/02g726t95 Global Neuroscience Initiative Foundation'),
(7065, 'https://ror.org/02g82g140', 'es', 1, 'https://ror.org/02g82g140 Instituto Zaldivar'),
(7066, 'https://ror.org/02g8p3m28', 'no_lang_code', 1, 'https://ror.org/02g8p3m28 Dr. Reddy''s Laboratories (United Kingdom)'),
(7067, 'https://ror.org/02g9d5535', 'en', 1, 'https://ror.org/02g9d5535 Community Based Research Centre'),
(7068, 'https://ror.org/02gan0k07', 'en', 1, 'https://ror.org/02gan0k07 Onassis Cardiac Surgery Center ΩΝΑΣΕΙΟ ΚΑΡΔΙΟΧΕΙΡΟΥΡΓΙΚΟ ΚΕΝΤΡΟ'),
(7069, 'https://ror.org/02gb7bb36', 'en', 1, 'https://ror.org/02gb7bb36 Saint Joseph''s College of Maine'),
(7070, 'https://ror.org/02gdqk794', 'en', 1, 'https://ror.org/02gdqk794 Royal Society of Medicine'),
(7071, 'https://ror.org/02gdz0643', 'no_lang_code', 1, 'https://ror.org/02gdz0643 DCS Corporation (United States)'),
(7072, 'https://ror.org/02gec1b57', 'no_lang_code', 1, 'https://ror.org/02gec1b57 Tsuyama Chuo Hospital 津山中央病院'),
(7073, 'https://ror.org/02gfbpn70', 'en', 1, 'https://ror.org/02gfbpn70 Ofwat'),
(7074, 'https://ror.org/02gffk937', 'en', 1, 'https://ror.org/02gffk937 Shriners Hospitals for Children - Erie'),
(7075, 'https://ror.org/02gge8657', 'no_lang_code', 1, 'https://ror.org/02gge8657 Optra (United States)'),
(7076, 'https://ror.org/02ggfyw45', 'en', 1, 'https://ror.org/02ggfyw45 Thai Red Cross Society'),
(7077, 'https://ror.org/02gkj6c36', 'no_lang_code', 1, 'https://ror.org/02gkj6c36 Medigen (United States)'),
(7078, 'https://ror.org/02gnvsm39', 'no_lang_code', 1, 'https://ror.org/02gnvsm39 Koester Performance Research (United States)'),
(7079, 'https://ror.org/02gp6f150', 'no_lang_code', 1, 'https://ror.org/02gp6f150 Tissue Genesis (United States)'),
(7080, 'https://ror.org/02gpxp602', 'no_lang_code', 1, 'https://ror.org/02gpxp602 M-Solv (United Kingdom)'),
(7081, 'https://ror.org/02gr2sm80', 'no_lang_code', 1, 'https://ror.org/02gr2sm80 Aecom (United States)'),
(7082, 'https://ror.org/02gv23t08', 'hu', 1, 'https://ror.org/02gv23t08 Toldy Ferenc Kórház'),
(7083, 'https://ror.org/02gv7n749', 'en', 1, 'https://ror.org/02gv7n749 American Dental Education Association'),
(7084, 'https://ror.org/02gv8a673', 'en', 1, 'https://ror.org/02gv8a673 Everett Community College'),
(7085, 'https://ror.org/02gwxj243', 'no_lang_code', 1, 'https://ror.org/02gwxj243 bioMérieux (United States)'),
(7086, 'https://ror.org/02gxffd98', 'no_lang_code', 1, 'https://ror.org/02gxffd98 Laing O''Rourke (United Kingdom)'),
(7087, 'https://ror.org/02gxky474', 'en', 1, 'https://ror.org/02gxky474 Association of State Supervisors of Mathematics'),
(7088, 'https://ror.org/02gxn3220', 'no_lang_code', 1, 'https://ror.org/02gxn3220 Mohawk Innovative Technology (United States)'),
(7089, 'https://ror.org/02gxtdy09', 'en', 1, 'https://ror.org/02gxtdy09 Brain Trauma Foundation'),
(7090, 'https://ror.org/02gy8fc28', 'fr', 1, 'https://ror.org/02gy8fc28 Centre National Hospitalier et Universitaire Hubert Koutoukou MAGA'),
(7091, 'https://ror.org/02h1dyg62', 'no_lang_code', 1, 'https://ror.org/02h1dyg62 Spencer Technologies (United States)'),
(7092, 'https://ror.org/02h1nk258', 'en', 1, 'https://ror.org/02h1nk258 Max Planck Institute for Brain Research Max-Planck-Institut für Hirnforschung'),
(7093, 'https://ror.org/02h1p2c43', 'en', 1, 'https://ror.org/02h1p2c43 Monterey County Health Department'),
(7094, 'https://ror.org/02h2t4g21', 'en', 1, 'https://ror.org/02h2t4g21 Contra Costa Health Services'),
(7095, 'https://ror.org/02h3se683', 'en', 1, 'https://ror.org/02h3se683 American College of Medical Genetics'),
(7096, 'https://ror.org/02h8qh795', 'no_lang_code', 1, 'https://ror.org/02h8qh795 Bioneer (Denmark)'),
(7097, 'https://ror.org/02h9xze43', 'no_lang_code', 1, 'https://ror.org/02h9xze43 Biotrend (Portugal)'),
(7098, 'https://ror.org/02ha0t079', 'no_lang_code', 1, 'https://ror.org/02ha0t079 Crinetics Pharmaceuticals (United States)'),
(7099, 'https://ror.org/02ha9tc40', 'en', 1, 'https://ror.org/02ha9tc40 Georgia Department of Community Health'),
(7100, 'https://ror.org/02harxg26', 'no_lang_code', 1, 'https://ror.org/02harxg26 Educational Film Center (United States)'),
(7101, 'https://ror.org/02hbfck57', 'en', 1, 'https://ror.org/02hbfck57 AARP'),
(7102, 'https://ror.org/02hddbs82', 'no_lang_code', 1, 'https://ror.org/02hddbs82 NewsHour Productions (United States)'),
(7103, 'https://ror.org/02hes1t22', 'no_lang_code', 1, 'https://ror.org/02hes1t22 Sapporo Holdings (Japan) サッポロホールディングス'),
(7104, 'https://ror.org/02hh2th82', 'en', 1, 'https://ror.org/02hh2th82 Dumfries and Galloway Royal Infirmary'),
(7105, 'https://ror.org/02hhsqf45', 'no_lang_code', 1, 'https://ror.org/02hhsqf45 Covance (United States)'),
(7106, 'https://ror.org/02hk0xz87', 'no_lang_code', 1, 'https://ror.org/02hk0xz87 American Superconductor (United States)'),
(7107, 'https://ror.org/02hmjce72', 'no_lang_code', 1, 'https://ror.org/02hmjce72 Medtronic (Netherlands)'),
(7108, 'https://ror.org/02hqx5v55', 'en', 1, 'https://ror.org/02hqx5v55 Center for Environment and Development for the Arab Region and Europe'),
(7109, 'https://ror.org/02hqxd823', 'no_lang_code', 1, 'https://ror.org/02hqxd823 MRF Geosystems (Canada)'),
(7110, 'https://ror.org/02ht85g63', 'no_lang_code', 1, 'https://ror.org/02ht85g63 A4F-Algafuel (Portugal)'),
(7111, 'https://ror.org/02htbg024', 'no_lang_code', 1, 'https://ror.org/02htbg024 Creatv MicroTech (United States)'),
(7112, 'https://ror.org/02hvk4n65', 'en', 1, 'https://ror.org/02hvk4n65 Princeton Baptist Medical Center'),
(7113, 'https://ror.org/02hy8r734', 'en', 1, 'https://ror.org/02hy8r734 Clinical Trial Investigators'),
(7114, 'https://ror.org/02j2j9d52', 'no_lang_code', 1, 'https://ror.org/02j2j9d52 Prentke Romich Company (United States)'),
(7115, 'https://ror.org/02j33yq05', 'en', 1, 'https://ror.org/02j33yq05 AIDS and Clinical Immunology Research Center'),
(7116, 'https://ror.org/02j3xat32', 'no_lang_code', 1, 'https://ror.org/02j3xat32 National Iranian Oil Company (Iran) پژوهشگاه صنعت نفت'),
(7117, 'https://ror.org/02j6cz137', 'en', 1, 'https://ror.org/02j6cz137 Institute of Dermatology สถาบันโรคผิวหนัง'),
(7118, 'https://ror.org/02j7krq48', 'no_lang_code', 1, 'https://ror.org/02j7krq48 FONA International (Canada)'),
(7119, 'https://ror.org/02j8r0p47', 'en', 1, 'https://ror.org/02j8r0p47 Woodend Hospital'),
(7120, 'https://ror.org/02j8tmw16', 'en', 1, 'https://ror.org/02j8tmw16 Immunization Action Coalition'),
(7121, 'https://ror.org/02jaztc47', 'en', 1, 'https://ror.org/02jaztc47 Institut für Textil- und Verfahrenstechnik Denkendorf Institute of Textile Technology and Process Engineering'),
(7122, 'https://ror.org/02jb8wy89', 'en', 1, 'https://ror.org/02jb8wy89 Connecticut Pre Engineering Program'),
(7123, 'https://ror.org/02jdkag88', 'en', 1, 'https://ror.org/02jdkag88 Corporation for National Research Initiatives'),
(7124, 'https://ror.org/02jf59571', 'en', 1, 'https://ror.org/02jf59571 Benaki Phytopathological Institute Μπενάκειο Φυτοπαθολογικό Ινστιτούτο'),
(7125, 'https://ror.org/02jf95y23', 'no_lang_code', 1, 'https://ror.org/02jf95y23 e GEOS (Italy)'),
(7126, 'https://ror.org/02jh73m95', 'it', 1, 'https://ror.org/02jh73m95 Felicita and Enrico Bignaschi and Sons Foundation Fondazione Bignaschi'),
(7127, 'https://ror.org/02jj1w915', 'en', 1, 'https://ror.org/02jj1w915 Broward College'),
(7128, 'https://ror.org/02jkm3388', 'it', 1, 'https://ror.org/02jkm3388 Ministero degli Affari Esteri Ministry of Foreign Affairs and International Cooperation'),
(7129, 'https://ror.org/02jq36h12', 'en', 1, 'https://ror.org/02jq36h12 Department of Agriculture and Food Western Australia'),
(7130, 'https://ror.org/02jqpaq24', 'en', 1, 'https://ror.org/02jqpaq24 Centre for Chronic Disease Control'),
(7131, 'https://ror.org/02jqwca63', 'fr', 1, 'https://ror.org/02jqwca63 Cegep regional de Lanaudiere, Cégep Régional de Lanaudière'),
(7132, 'https://ror.org/02jr44c14', 'no_lang_code', 1, 'https://ror.org/02jr44c14 Sinmat (United States)'),
(7133, 'https://ror.org/02js6ft04', 'no_lang_code', 1, 'https://ror.org/02js6ft04 Takara (United States)'),
(7134, 'https://ror.org/02jxrxr40', 'no_lang_code', 1, 'https://ror.org/02jxrxr40 Policy Analysis (United States)'),
(7135, 'https://ror.org/02jy1mq31', 'no_lang_code', 1, 'https://ror.org/02jy1mq31 Ondine Biopharma (United States)'),
(7136, 'https://ror.org/02jygec53', 'no_lang_code', 1, 'https://ror.org/02jygec53 Elecnor (Spain)'),
(7137, 'https://ror.org/02jzrsm59', 'en', 1, 'https://ror.org/02jzrsm59 National Institute on Alcohol Abuse and Alcoholism'),
(7138, 'https://ror.org/02jzt6t86', 'en', 1, 'https://ror.org/02jzt6t86 Institute of Human Genetics Instytutu Genetyki Człowieka PAN'),
(7139, 'https://ror.org/02k284p70', 'en', 1, 'https://ror.org/02k284p70 Academy of Scientific Research and Technology'),
(7140, 'https://ror.org/02k4agj72', 'en', 1, 'https://ror.org/02k4agj72 Matrix Institute on Addictions'),
(7141, 'https://ror.org/02k5g8c37', 'no_lang_code', 1, 'https://ror.org/02k5g8c37 BioDetection Instruments (United States)'),
(7142, 'https://ror.org/02k5t6c64', 'en', 1, 'https://ror.org/02k5t6c64 PRA Health Sciences'),
(7143, 'https://ror.org/02k7p6g32', 'no_lang_code', 1, 'https://ror.org/02k7p6g32 Analiza (United States)'),
(7144, 'https://ror.org/02k9hra16', 'en', 1, 'https://ror.org/02k9hra16 Saskatchewan Seniors Mechanism'),
(7145, 'https://ror.org/02kgm7r43', 'en', 1, 'https://ror.org/02kgm7r43 Blackfeet Community College'),
(7146, 'https://ror.org/02khxjf35', 'no_lang_code', 1, 'https://ror.org/02khxjf35 United Environment and Energy (United States)'),
(7147, 'https://ror.org/02kjgsq44', 'en', 1, 'https://ror.org/02kjgsq44 National Institute of Oncology'),
(7148, 'https://ror.org/02kk3dq58', 'en', 1, 'https://ror.org/02kk3dq58 United Tribes Technical College'),
(7149, 'https://ror.org/02kp7p620', 'en', 1, 'https://ror.org/02kp7p620 Central Leather Research Institute'),
(7150, 'https://ror.org/02krr1j33', 'no_lang_code', 1, 'https://ror.org/02krr1j33 Telesage (United States)'),
(7151, 'https://ror.org/02kspbq18', 'fr', 1, 'https://ror.org/02kspbq18 Château Gombert'),
(7152, 'https://ror.org/02kv35z70', 'en', 1, 'https://ror.org/02kv35z70 Computer History Museum'),
(7153, 'https://ror.org/02kvf6r88', 'no_lang_code', 1, 'https://ror.org/02kvf6r88 Hartley & Associates'),
(7154, 'https://ror.org/02kvgg008', 'no_lang_code', 1, 'https://ror.org/02kvgg008 Cepsa (Spain)'),
(7155, 'https://ror.org/02kvnjb40', 'en', 1, 'https://ror.org/02kvnjb40 European School of Oncology'),
(7156, 'https://ror.org/02kwk6c15', 'en', 1, 'https://ror.org/02kwk6c15 International Management Institute'),
(7157, 'https://ror.org/02kxjqp24', 'no_lang_code', 1, 'https://ror.org/02kxjqp24 Certara (United States)'),
(7158, 'https://ror.org/02kzr5g33', 'en', 1, 'https://ror.org/02kzr5g33 Zhejiang Hospital 浙江医院'),
(7159, 'https://ror.org/02m15g174', 'en', 1, 'https://ror.org/02m15g174 Diabetes Care Center'),
(7160, 'https://ror.org/02m1cy121', 'no_lang_code', 1, 'https://ror.org/02m1cy121 Prodrive (United Kingdom)'),
(7161, 'https://ror.org/02m40r087', 'no_lang_code', 1, 'https://ror.org/02m40r087 Concepts NREC (United States)'),
(7162, 'https://ror.org/02m444q29', 'no_lang_code', 1, 'https://ror.org/02m444q29 EEI Communications (United States)'),
(7163, 'https://ror.org/02m4tvc13', 'fr', 1, 'https://ror.org/02m4tvc13 Comité Européen des Instructeurs de Plongée Professionnels European Committee of Professional Diving Instructors'),
(7164, 'https://ror.org/02m5haa59', 'cs', 1, 'https://ror.org/02m5haa59 Czech Metrology Institute Český Metrologický Institut'),
(7165, 'https://ror.org/02m5vdb88', 'en', 1, 'https://ror.org/02m5vdb88 Navajo Nation Division of Health'),
(7166, 'https://ror.org/02m805769', 'fr', 1, 'https://ror.org/02m805769 Cegep de La Pocatiere, Cégep de la pocatière'),
(7167, 'https://ror.org/02m8d5f73', 'no_lang_code', 1, 'https://ror.org/02m8d5f73 CytRx (United States)'),
(7168, 'https://ror.org/02magnn81', 'no_lang_code', 1, 'https://ror.org/02magnn81 CESI (Italy)'),
(7169, 'https://ror.org/02mdxv534', 'fr', 1, 'https://ror.org/02mdxv534 Fondation Ophtalmologique Adolphe de Rothschild'),
(7170, 'https://ror.org/02meqm098', 'en', 1, 'https://ror.org/02meqm098 National Center for Biotechnology Information'),
(7171, 'https://ror.org/02mfa7r39', 'no_lang_code', 1, 'https://ror.org/02mfa7r39 Digital Payment Technologies (Canada)'),
(7172, 'https://ror.org/02mgtg880', 'en', 1, 'https://ror.org/02mgtg880 Critical Path Institute'),
(7173, 'https://ror.org/02mh82r78', 'no_lang_code', 1, 'https://ror.org/02mh82r78 Fermalogic (United States)'),
(7174, 'https://ror.org/02mhf1b49', 'en', 1, 'https://ror.org/02mhf1b49 Wiley College'),
(7175, 'https://ror.org/02mhxa927', 'en', 1, 'https://ror.org/02mhxa927 Zhujiang Hospital'),
(7176, 'https://ror.org/02mn8sh47', 'en', 1, 'https://ror.org/02mn8sh47 Turtle Mountain Community College'),
(7177, 'https://ror.org/02mnkv161', 'no_lang_code', 1, 'https://ror.org/02mnkv161 Applied Thin Films (United States)'),
(7178, 'https://ror.org/02mp2w060', 'en', 1, 'https://ror.org/02mp2w060 Framingham State University Université d''État de framingham'),
(7179, 'https://ror.org/02mqbx112', 'en', 1, 'https://ror.org/02mqbx112 Institut National de Neurologie Mongi-Ben Hamida National Institute of Neurology Mongi-Ben Hamida'),
(7180, 'https://ror.org/02ms6eb12', 'no_lang_code', 1, 'https://ror.org/02ms6eb12 Parirenyatwa Hospital'),
(7181, 'https://ror.org/02msvh720', 'no_lang_code', 1, 'https://ror.org/02msvh720 SoftBank Robotics (France)'),
(7182, 'https://ror.org/02mtwe318', 'no_lang_code', 1, 'https://ror.org/02mtwe318 Argus Umweltbiotechnologie (Germany)'),
(7183, 'https://ror.org/02mx39t82', 'en', 1, 'https://ror.org/02mx39t82 Association Vinçotte Nuclear, Nuclear Safety Institute'),
(7184, 'https://ror.org/02mx9d065', 'it', 1, 'https://ror.org/02mx9d065 Consorzio per la Ricerca e l''Educazione Permanente'),
(7185, 'https://ror.org/02mxbtp76', 'no_lang_code', 1, 'https://ror.org/02mxbtp76 Xemed (United States)'),
(7186, 'https://ror.org/02mznah18', 'no_lang_code', 1, 'https://ror.org/02mznah18 Bioanalytical Systems (United States)'),
(7187, 'https://ror.org/02n2p7c30', 'en', 1, 'https://ror.org/02n2p7c30 Canadian Association of Psychosocial Oncology'),
(7188, 'https://ror.org/02n4wd178', 'no_lang_code', 1, 'https://ror.org/02n4wd178 Junk King (United States)'),
(7189, 'https://ror.org/02n9cgn70', 'no_lang_code', 1, 'https://ror.org/02n9cgn70 SRA International (United States)'),
(7190, 'https://ror.org/02naadr48', 'no_lang_code', 1, 'https://ror.org/02naadr48 Pearson (United States)'),
(7191, 'https://ror.org/02navrb60', 'en', 1, 'https://ror.org/02navrb60 Lady of Mercy Medical Center'),
(7192, 'https://ror.org/02neqps07', 'no_lang_code', 1, 'https://ror.org/02neqps07 Innovative Chemical and Environmental Technologies (United States)'),
(7193, 'https://ror.org/02nfh0m56', 'en', 1, 'https://ror.org/02nfh0m56 Pittsburgh Public Schools'),
(7194, 'https://ror.org/02njbjk47', 'en', 1, 'https://ror.org/02njbjk47 DHHS Alliance'),
(7195, 'https://ror.org/02njpkz73', 'en', 1, 'https://ror.org/02njpkz73 Hull Royal Infirmary'),
(7196, 'https://ror.org/02nknzn40', 'en', 1, 'https://ror.org/02nknzn40 Institute of Problems of Chemical Physics Институт проблем химической физики'),
(7197, 'https://ror.org/02npvem89', 'en', 1, 'https://ror.org/02npvem89 Air & Waste Management Association'),
(7198, 'https://ror.org/02nrhnf93', 'en', 1, 'https://ror.org/02nrhnf93 City Eye Centre'),
(7199, 'https://ror.org/02ntheh91', 'es', 1, 'https://ror.org/02ntheh91 Instituto Venezolano de Investigaciones Científicas'),
(7200, 'https://ror.org/02nw0wb75', 'en', 1, 'https://ror.org/02nw0wb75 Wycombe General Hospital'),
(7201, 'https://ror.org/02nw48b86', 'en', 1, 'https://ror.org/02nw48b86 American Society of Hematology'),
(7202, 'https://ror.org/02p014d02', 'en', 1, 'https://ror.org/02p014d02 American International College'),
(7203, 'https://ror.org/02p1xqf92', 'no_lang_code', 1, 'https://ror.org/02p1xqf92 Centro Laser'),
(7204, 'https://ror.org/02p54vf94', 'en', 1, 'https://ror.org/02p54vf94 DGA Partners'),
(7205, 'https://ror.org/02p5qdz58', 'no_lang_code', 1, 'https://ror.org/02p5qdz58 Insilicos (United States)'),
(7206, 'https://ror.org/02p6vh725', 'en', 1, 'https://ror.org/02p6vh725 Mount Wachusett Community College'),
(7207, 'https://ror.org/02p7gn625', 'fr', 1, 'https://ror.org/02p7gn625 Cégep de l''Abitibi Témiscamingue, Cégep de l''abitibi-témiscamingue'),
(7208, 'https://ror.org/02p7sht55', 'en', 1, 'https://ror.org/02p7sht55 National Vital Statistics System'),
(7209, 'https://ror.org/02pbkp259', 'no_lang_code', 1, 'https://ror.org/02pbkp259 Actian (United States)'),
(7210, 'https://ror.org/02pdvpq69', 'no_lang_code', 1, 'https://ror.org/02pdvpq69 Affinergy (United States)'),
(7211, 'https://ror.org/02peeh644', 'no_lang_code', 1, 'https://ror.org/02peeh644 HBP (United States)'),
(7212, 'https://ror.org/02pf22978', 'no_lang_code', 1, 'https://ror.org/02pf22978 BioSense (United States)'),
(7213, 'https://ror.org/02pfhsd84', 'en', 1, 'https://ror.org/02pfhsd84 A.V. Luikov Heat and Mass Transfer Institute Институт тепло- и массообмена имени А.В. Лыкова Национальной академии наук Беларуси'),
(7214, 'https://ror.org/02pft9k47', 'es', 1, 'https://ror.org/02pft9k47 Centro Nacional de Sanidad Agropecuaria'),
(7215, 'https://ror.org/02phjfe17', 'no_lang_code', 1, 'https://ror.org/02phjfe17 Aridis Pharmaceuticals (United States)'),
(7216, 'https://ror.org/02pmr4c75', 'en', 1, 'https://ror.org/02pmr4c75 Hastings Center'),
(7217, 'https://ror.org/02pn0tx11', 'en', 1, 'https://ror.org/02pn0tx11 Aliviane'),
(7218, 'https://ror.org/02pnmd628', 'en', 1, 'https://ror.org/02pnmd628 American Foundation for Donation and Transplantation'),
(7219, 'https://ror.org/02pnxn245', 'en', 1, 'https://ror.org/02pnxn245 Texas State Technical College Waco'),
(7220, 'https://ror.org/02pp1v282', 'no_lang_code', 1, 'https://ror.org/02pp1v282 AntiCancer (United States)'),
(7221, 'https://ror.org/02prqh017', 'en', 1, 'https://ror.org/02prqh017 Holon Institute of Technology'),
(7222, 'https://ror.org/02pstqj22', 'en', 1, 'https://ror.org/02pstqj22 National Action Council for Minorities in Engineering'),
(7223, 'https://ror.org/02ptz5951', 'en', 1, 'https://ror.org/02ptz5951 Gemeinsame Forschungsstelle Joint Research Centre'),
(7224, 'https://ror.org/02pve7657', 'fr', 1, 'https://ror.org/02pve7657 Groupe Hospitalier du Havre'),
(7225, 'https://ror.org/02pwnhd33', 'fr', 1, 'https://ror.org/02pwnhd33 Centre Jean Perrin'),
(7226, 'https://ror.org/02py7c988', 'no_lang_code', 1, 'https://ror.org/02py7c988 DxRay (United States)'),
(7227, 'https://ror.org/02pyrw675', 'no_lang_code', 1, 'https://ror.org/02pyrw675 Sensor Research and Development Corporation (United States)'),
(7228, 'https://ror.org/02pyw0y06', 'en', 1, 'https://ror.org/02pyw0y06 Taos Orthopaedic Institute'),
(7229, 'https://ror.org/02q2kqs69', 'en', 1, 'https://ror.org/02q2kqs69 Environmental Mutagenesis and Genomics Society'),
(7230, 'https://ror.org/02q2pqb13', 'en', 1, 'https://ror.org/02q2pqb13 Cooperative Research Centre for Tissue Growth and Repair'),
(7231, 'https://ror.org/02q49af68', 'en', 1, 'https://ror.org/02q49af68 Aberdeen Royal Infirmary'),
(7232, 'https://ror.org/02q69x434', 'en', 1, 'https://ror.org/02q69x434 Peterborough City Hospital'),
(7233, 'https://ror.org/02q76t874', 'no_lang_code', 1, 'https://ror.org/02q76t874 Akina (United States)'),
(7234, 'https://ror.org/02q865m71', 'en', 1, 'https://ror.org/02q865m71 Diablo Valley College'),
(7235, 'https://ror.org/02q8vhr64', 'en', 1, 'https://ror.org/02q8vhr64 Kobe City College of Technology 神戸市立工業高等専門学校'),
(7236, 'https://ror.org/02q9ktd98', 'no_lang_code', 1, 'https://ror.org/02q9ktd98 Real Time Analyzers (United States)'),
(7237, 'https://ror.org/02q9tvn08', 'en', 1, 'https://ror.org/02q9tvn08 Royal Institution of Chartered Surveyors'),
(7238, 'https://ror.org/02qaw7v88', 'no_lang_code', 1, 'https://ror.org/02qaw7v88 Gold Standard Simulations (United Kingdom)'),
(7239, 'https://ror.org/02qb5bp07', 'no_lang_code', 1, 'https://ror.org/02qb5bp07 Tornado Spectral Systems (Canada)'),
(7240, 'https://ror.org/02qbhr955', 'ro', 1, 'https://ror.org/02qbhr955 Institutul Cantacuzino'),
(7241, 'https://ror.org/02qbj0866', 'no_lang_code', 1, 'https://ror.org/02qbj0866 AiCure (United States)'),
(7242, 'https://ror.org/02qdmsh42', 'en', 1, 'https://ror.org/02qdmsh42 Connecticut Department of Children and Families'),
(7243, 'https://ror.org/02qf7zp16', 'en', 1, 'https://ror.org/02qf7zp16 Iowa Lakes Community College'),
(7244, 'https://ror.org/02qgx4h83', 'no_lang_code', 1, 'https://ror.org/02qgx4h83 Immersion (United States)'),
(7245, 'https://ror.org/02qhjcg87', 'en', 1, 'https://ror.org/02qhjcg87 Mason Parks & Recreation Foundation'),
(7246, 'https://ror.org/02qjtm453', 'no_lang_code', 1, 'https://ror.org/02qjtm453 Natus (United States)'),
(7247, 'https://ror.org/02qs5ar77', 'no_lang_code', 1, 'https://ror.org/02qs5ar77 Azienda Trasporti Milanesi (Italy)'),
(7248, 'https://ror.org/02qsnn284', 'en', 1, 'https://ror.org/02qsnn284 North Jersey Community Research Initiative'),
(7249, 'https://ror.org/02qwdzc67', 'en', 1, 'https://ror.org/02qwdzc67 Confederation of European Forest Owners'),
(7250, 'https://ror.org/02qwvxs86', 'sv', 1, 'https://ror.org/02qwvxs86 Eastmaninstitutet The Eastman Institute'),
(7251, 'https://ror.org/02r06yv13', 'no_lang_code', 1, 'https://ror.org/02r06yv13 FJE Enterprises (United States)'),
(7252, 'https://ror.org/02r0rps05', 'it', 1, 'https://ror.org/02r0rps05 Ospedale Sant''Orsola di Brescia'),
(7253, 'https://ror.org/02r30yj10', 'en', 1, 'https://ror.org/02r30yj10 European Incoherent Scatter Scientific Association'),
(7254, 'https://ror.org/02r382680', 'bs', 1, 'https://ror.org/02r382680 Prona'),
(7255, 'https://ror.org/02r50zr04', 'no_lang_code', 1, 'https://ror.org/02r50zr04 Algoritmos Procesos y Disenos (Spain)'),
(7256, 'https://ror.org/02r5hv713', 'no_lang_code', 1, 'https://ror.org/02r5hv713 Vista Scientific (United States)'),
(7257, 'https://ror.org/02r5scg33', 'no_lang_code', 1, 'https://ror.org/02r5scg33 Intel (Ireland)'),
(7258, 'https://ror.org/02r96rf44', 'no_lang_code', 1, 'https://ror.org/02r96rf44 Qiagen (Germany)'),
(7259, 'https://ror.org/02r9beq73', 'no_lang_code', 1, 'https://ror.org/02r9beq73 Loccioni (Italy)'),
(7260, 'https://ror.org/02rb17w33', 'no_lang_code', 1, 'https://ror.org/02rb17w33 Wright Medical Technology (United States)');
INSERT INTO `rors` VALUES
(7261, 'https://ror.org/02rb8qp97', 'no_lang_code', 1, 'https://ror.org/02rb8qp97 CISSOID (Belgium)'),
(7262, 'https://ror.org/02rbfnr22', 'en', 1, 'https://ror.org/02rbfnr22 Max Planck Florida Institute for Neuroscience'),
(7263, 'https://ror.org/02rbnw681', 'no_lang_code', 1, 'https://ror.org/02rbnw681 Platypus Technologies (United States)'),
(7264, 'https://ror.org/02rchr797', 'no_lang_code', 1, 'https://ror.org/02rchr797 Alma Consulting Group'),
(7265, 'https://ror.org/02rdhhs90', 'en', 1, 'https://ror.org/02rdhhs90 Emmanuel College - Massachusetts'),
(7266, 'https://ror.org/02reezy47', 'de', 1, 'https://ror.org/02reezy47 Hahn-Schickard-Gesellschaft für angewandte Forschung'),
(7267, 'https://ror.org/02res4f29', 'en', 1, 'https://ror.org/02res4f29 Overseas Development Institute'),
(7268, 'https://ror.org/02revdf05', 'en', 1, 'https://ror.org/02revdf05 Moraine Valley Community College'),
(7269, 'https://ror.org/02rgsw982', 'no_lang_code', 1, 'https://ror.org/02rgsw982 Apath (United States)'),
(7270, 'https://ror.org/02rh7vj17', 'en', 1, 'https://ror.org/02rh7vj17 Alaska Department of Fish and Game'),
(7271, 'https://ror.org/02rnyzs79', 'en', 1, 'https://ror.org/02rnyzs79 NatureServe'),
(7272, 'https://ror.org/02rr12y45', 'en', 1, 'https://ror.org/02rr12y45 Press Ganey'),
(7273, 'https://ror.org/02rr5zn35', 'no_lang_code', 1, 'https://ror.org/02rr5zn35 Uken (Canada)'),
(7274, 'https://ror.org/02rthxz10', 'en', 1, 'https://ror.org/02rthxz10 St Vincent''s Clinic'),
(7275, 'https://ror.org/02rxmd442', 'no_lang_code', 1, 'https://ror.org/02rxmd442 Glyndwr Innovations (United Kingdom)'),
(7276, 'https://ror.org/02rxq9s71', 'no_lang_code', 1, 'https://ror.org/02rxq9s71 Wright Materials Research (United States)'),
(7277, 'https://ror.org/02s0pza74', 'en', 1, 'https://ror.org/02s0pza74 Hallands Sjukhus Varberg Varberg Hospital'),
(7278, 'https://ror.org/02s1t7068', 'en', 1, 'https://ror.org/02s1t7068 Eastern Oklahoma State College'),
(7279, 'https://ror.org/02s27py21', 'es', 1, 'https://ror.org/02s27py21 Centro de Estudios y Experimentación de Obras Públicas'),
(7280, 'https://ror.org/02s3g3z50', 'no_lang_code', 1, 'https://ror.org/02s3g3z50 Nokia (Portugal)'),
(7281, 'https://ror.org/02s3j1d69', 'no_lang_code', 1, 'https://ror.org/02s3j1d69 VenatoRx Pharmaceuticals (United States)'),
(7282, 'https://ror.org/02s4ke886', 'no_lang_code', 1, 'https://ror.org/02s4ke886 HemoShear (United States)'),
(7283, 'https://ror.org/02s5pwd41', 'no_lang_code', 1, 'https://ror.org/02s5pwd41 DeltaQuest Foundation (United States)'),
(7284, 'https://ror.org/02s5xnv22', 'en', 1, 'https://ror.org/02s5xnv22 Spinal Diagnostics and Treatment Center'),
(7285, 'https://ror.org/02s619e80', 'no_lang_code', 1, 'https://ror.org/02s619e80 Dawkins Productions (United States)'),
(7286, 'https://ror.org/02s61w335', 'it', 1, 'https://ror.org/02s61w335 Ospedale Regionale di Bellinzona e Valli Regional Hospital of Bellinzona and Valleys'),
(7287, 'https://ror.org/02s61y919', 'en', 1, 'https://ror.org/02s61y919 Valley Breast Care & Woman''s Health Center'),
(7288, 'https://ror.org/02s6bef14', 'no_lang_code', 1, 'https://ror.org/02s6bef14 Azienda Trasporti Consorziali di Bologna'),
(7289, 'https://ror.org/02sbj8547', 'en', 1, 'https://ror.org/02sbj8547 Waynesburg University'),
(7290, 'https://ror.org/02sdw5w15', 'no_lang_code', 1, 'https://ror.org/02sdw5w15 Active Motif (United States)'),
(7291, 'https://ror.org/02se3s925', 'en', 1, 'https://ror.org/02se3s925 Inova Children''s Hospital'),
(7292, 'https://ror.org/02segr176', 'no_lang_code', 1, 'https://ror.org/02segr176 Applied Human Factors (United States)'),
(7293, 'https://ror.org/02sepg748', 'en', 1, 'https://ror.org/02sepg748 Institute of Materials Research and Engineering'),
(7294, 'https://ror.org/02sfn4p13', 'no_lang_code', 1, 'https://ror.org/02sfn4p13 Enterprise Estonia (Estonia)'),
(7295, 'https://ror.org/02sftpz67', 'no_lang_code', 1, 'https://ror.org/02sftpz67 AFC Energy (United Kingdom)'),
(7296, 'https://ror.org/02sgk9b41', 'no_lang_code', 1, 'https://ror.org/02sgk9b41 SynZyme Technologies (United States)'),
(7297, 'https://ror.org/02sgyhv62', 'en', 1, 'https://ror.org/02sgyhv62 California Family Health Council'),
(7298, 'https://ror.org/02sh8ry89', 'no_lang_code', 1, 'https://ror.org/02sh8ry89 Wicab (United States)'),
(7299, 'https://ror.org/02sjy2915', 'en', 1, 'https://ror.org/02sjy2915 Podiatry Institute'),
(7300, 'https://ror.org/02skcpv41', 'es', 1, 'https://ror.org/02skcpv41 Asociación de Investigación y Cooperación Industrial de Andalucía'),
(7301, 'https://ror.org/02sn8xp43', 'no_lang_code', 1, 'https://ror.org/02sn8xp43 Oxonica (United Kingdom)'),
(7302, 'https://ror.org/02snwfx66', 'en', 1, 'https://ror.org/02snwfx66 Trafford General Hospital'),
(7303, 'https://ror.org/02sptv349', 'en', 1, 'https://ror.org/02sptv349 National Institute for Women in Trades, Technology & Sciences'),
(7304, 'https://ror.org/02srjnb65', 'no_lang_code', 1, 'https://ror.org/02srjnb65 Membrane Reactor Technologies (Canada)'),
(7305, 'https://ror.org/02svqt910', 'en', 1, 'https://ror.org/02svqt910 European Institute for Biomedical Imaging Research'),
(7306, 'https://ror.org/02swzn148', 'en', 1, 'https://ror.org/02swzn148 Pain Management Center of Paducah'),
(7307, 'https://ror.org/02symh967', 'no_lang_code', 1, 'https://ror.org/02symh967 Manhattan Scientifics (United States)'),
(7308, 'https://ror.org/02t0zgq96', 'no_lang_code', 1, 'https://ror.org/02t0zgq96 ArmaGen (United States)'),
(7309, 'https://ror.org/02t110213', 'en', 1, 'https://ror.org/02t110213 New England College of Optometry'),
(7310, 'https://ror.org/02t1t6n83', 'en', 1, 'https://ror.org/02t1t6n83 Burdenko Neurosurgery Institute Федеральное государственное автономное учреждение Научно-исследовательский институт нейрохирургии имени академика Н.Н. Бурденко Министерства здравоохранения Российской Федерации'),
(7311, 'https://ror.org/02t3wzq80', 'en', 1, 'https://ror.org/02t3wzq80 Palm Beach State College'),
(7312, 'https://ror.org/02t6r9161', 'en', 1, 'https://ror.org/02t6r9161 Rust College'),
(7313, 'https://ror.org/02t6xhx48', 'no_lang_code', 1, 'https://ror.org/02t6xhx48 Photozig (United States)'),
(7314, 'https://ror.org/02t7c5797', 'en', 1, 'https://ror.org/02t7c5797 Connecticut Agricultural Experiment Station'),
(7315, 'https://ror.org/02t7ex691', 'no_lang_code', 1, 'https://ror.org/02t7ex691 Minnetronix (United States)'),
(7316, 'https://ror.org/02t7v8j62', 'en', 1, 'https://ror.org/02t7v8j62 City of Edinburgh Council'),
(7317, 'https://ror.org/02tc4ww71', 'en', 1, 'https://ror.org/02tc4ww71 Peninsula Regional Medical Center'),
(7318, 'https://ror.org/02tcncc65', 'en', 1, 'https://ror.org/02tcncc65 Centerforce'),
(7319, 'https://ror.org/02td3ps96', 'en', 1, 'https://ror.org/02td3ps96 Dartmouth Psychiatric Research Center'),
(7320, 'https://ror.org/02tdag098', 'no_lang_code', 1, 'https://ror.org/02tdag098 Mirna Therapeutics (United States)'),
(7321, 'https://ror.org/02tfv4t78', 'no_lang_code', 1, 'https://ror.org/02tfv4t78 Corning (United States)'),
(7322, 'https://ror.org/02tj9h434', 'en', 1, 'https://ror.org/02tj9h434 Allegany College of Maryland'),
(7323, 'https://ror.org/02tmx5588', 'no_lang_code', 1, 'https://ror.org/02tmx5588 Danaher (United States)'),
(7324, 'https://ror.org/02tn1ck84', 'en', 1, 'https://ror.org/02tn1ck84 National Eisteddfod of Wales'),
(7325, 'https://ror.org/02tqrck55', 'no_lang_code', 1, 'https://ror.org/02tqrck55 En''Urga (United States)'),
(7326, 'https://ror.org/02tr01m06', 'no_lang_code', 1, 'https://ror.org/02tr01m06 International Severity Information Systems (United States)'),
(7327, 'https://ror.org/02tre1223', 'en', 1, 'https://ror.org/02tre1223 William Harvey Hospital'),
(7328, 'https://ror.org/02trgd202', 'ca', 1, 'https://ror.org/02trgd202 Institut Municipal d''Assistència Sanitària'),
(7329, 'https://ror.org/02tryst02', 'no_lang_code', 1, 'https://ror.org/02tryst02 Agilent Technologies (United States)'),
(7330, 'https://ror.org/02ts2hy13', 'en', 1, 'https://ror.org/02ts2hy13 National Association of Biology Teachers'),
(7331, 'https://ror.org/02ts3bw45', 'no_lang_code', 1, 'https://ror.org/02ts3bw45 Plantvax (United States)'),
(7332, 'https://ror.org/02ts3my48', 'no_lang_code', 1, 'https://ror.org/02ts3my48 Chem-Space Associates (United States)'),
(7333, 'https://ror.org/02ttgyc97', 'no_lang_code', 1, 'https://ror.org/02ttgyc97 dbaza health (United States)'),
(7334, 'https://ror.org/02ttqd922', 'en', 1, 'https://ror.org/02ttqd922 Electrical and Computer Engineering Department Heads Association'),
(7335, 'https://ror.org/02tw58061', 'en', 1, 'https://ror.org/02tw58061 Piedmont Virginia Community College'),
(7336, 'https://ror.org/02twc7963', 'en', 1, 'https://ror.org/02twc7963 Aerospace Valley'),
(7337, 'https://ror.org/02tyer376', 'en', 1, 'https://ror.org/02tyer376 Leibniz Institute DSMZ – German Collection of Microorganisms and Cell Cultures Leibniz-Institut DSMZ-Deutsche Sammlung von Mikroorganismen und Zellkulturen'),
(7338, 'https://ror.org/02v02q390', 'no_lang_code', 1, 'https://ror.org/02v02q390 Aston Martin Lagonda (United Kingdom)'),
(7339, 'https://ror.org/02v05yj51', 'en', 1, 'https://ror.org/02v05yj51 All Africa Leprosy Tuberculosis and Rehabilitation Training Centre'),
(7340, 'https://ror.org/02v0mj573', 'en', 1, 'https://ror.org/02v0mj573 Royal Albert Edward Infirmary'),
(7341, 'https://ror.org/02v4ner66', 'fr', 1, 'https://ror.org/02v4ner66 Centre hospitalier Etterbeek-Ixelles'),
(7342, 'https://ror.org/02v50dx14', 'no_lang_code', 1, 'https://ror.org/02v50dx14 Taiho Pharmaceutical (Japan) 大鵬薬品工業'),
(7343, 'https://ror.org/02v6vej93', 'en', 1, 'https://ror.org/02v6vej93 Institute of Liver and Biliary Sciences'),
(7344, 'https://ror.org/02v7j5a68', 'no_lang_code', 1, 'https://ror.org/02v7j5a68 Intelligent Fiber Optic Systems (United States)'),
(7345, 'https://ror.org/02v81r985', 'no_lang_code', 1, 'https://ror.org/02v81r985 Ametek (United States)'),
(7346, 'https://ror.org/02vaftm28', 'en', 1, 'https://ror.org/02vaftm28 Sea Education Association'),
(7347, 'https://ror.org/02vajn858', 'en', 1, 'https://ror.org/02vajn858 CGH Medical Center'),
(7348, 'https://ror.org/02vbwbd19', 'en', 1, 'https://ror.org/02vbwbd19 Campbell Clinic'),
(7349, 'https://ror.org/02vd9xc25', 'no_lang_code', 1, 'https://ror.org/02vd9xc25 Avacta (United Kingdom)'),
(7350, 'https://ror.org/02vdyxx64', 'no_lang_code', 1, 'https://ror.org/02vdyxx64 Verizon (United States)'),
(7351, 'https://ror.org/02vf4sk45', 'en', 1, 'https://ror.org/02vf4sk45 Institute of Evolutionary Physiology and Biochemistry Федеральное государственное бюджетное учреждение науки Институт эволюционной физиологии и биохимии им. И.М. Сеченова Российской академии наук'),
(7352, 'https://ror.org/02vfnsn98', 'en', 1, 'https://ror.org/02vfnsn98 Lynn Health Science Institute'),
(7353, 'https://ror.org/02vgejx91', 'no_lang_code', 1, 'https://ror.org/02vgejx91 Aircraft Research Association'),
(7354, 'https://ror.org/02vgfg208', 'en', 1, 'https://ror.org/02vgfg208 New Mexico Department of Human Services'),
(7355, 'https://ror.org/02vhff552', 'en', 1, 'https://ror.org/02vhff552 Freshwater Fisheries Society of BC'),
(7356, 'https://ror.org/02vjt9x89', 'no_lang_code', 1, 'https://ror.org/02vjt9x89 SciTech Development (United States)'),
(7357, 'https://ror.org/02vjx4k16', 'en', 1, 'https://ror.org/02vjx4k16 National Transport Hospital "Tzar Boris III" национална многопрофилна транспортна болница цар борис ііі'),
(7358, 'https://ror.org/02vpkdk18', 'no_lang_code', 1, 'https://ror.org/02vpkdk18 Synergy Enterprises (United States)'),
(7359, 'https://ror.org/02vpzy864', 'no_lang_code', 1, 'https://ror.org/02vpzy864 4D Soft (Hungary)'),
(7360, 'https://ror.org/02vrwn188', 'en', 1, 'https://ror.org/02vrwn188 International Society for Infectious Diseases'),
(7361, 'https://ror.org/02vsy6m37', 'en', 1, 'https://ror.org/02vsy6m37 Centre for Infectious Disease Research in Zambia'),
(7362, 'https://ror.org/02vtgg877', 'no_lang_code', 1, 'https://ror.org/02vtgg877 Fusion (United States)'),
(7363, 'https://ror.org/02vxngq63', 'en', 1, 'https://ror.org/02vxngq63 Latvian Academy of Sciences'),
(7364, 'https://ror.org/02vydqh80', 'en', 1, 'https://ror.org/02vydqh80 Interstate Shellfish Sanitation Conference'),
(7365, 'https://ror.org/02vz80y09', 'es', 1, 'https://ror.org/02vz80y09 Centro Medico Nacional Siglo XXI'),
(7366, 'https://ror.org/02vzt4388', 'no_lang_code', 1, 'https://ror.org/02vzt4388 Bruel & Kjaer Sound and Vibration Measurement (Denmark)'),
(7367, 'https://ror.org/02w335z67', 'no_lang_code', 1, 'https://ror.org/02w335z67 InterDigital (United States)'),
(7368, 'https://ror.org/02w368938', 'no_lang_code', 1, 'https://ror.org/02w368938 PhysioGenix (United States)'),
(7369, 'https://ror.org/02w38qn81', 'en', 1, 'https://ror.org/02w38qn81 Forum for the Future'),
(7370, 'https://ror.org/02w6r0892', 'fr', 1, 'https://ror.org/02w6r0892 Institut Philippe Pinel de Montréal Philippe Pinel Institute'),
(7371, 'https://ror.org/02w7azg93', 'no_lang_code', 1, 'https://ror.org/02w7azg93 Chiba Cerebral and Cardiovascular Center 千葉県脳血管センタ'),
(7372, 'https://ror.org/02wcc5n95', 'en', 1, 'https://ror.org/02wcc5n95 Association of Dutch Burn Centres Vereniging Samenwerkende Brandwondencentra'),
(7373, 'https://ror.org/02wcma710', 'no_lang_code', 1, 'https://ror.org/02wcma710 Schafer Corporation (United States)'),
(7374, 'https://ror.org/02wed1y10', 'no_lang_code', 1, 'https://ror.org/02wed1y10 Learning in Motion (United States)'),
(7375, 'https://ror.org/02weyc170', 'no_lang_code', 1, 'https://ror.org/02weyc170 AquaBioTech Group (Malta)'),
(7376, 'https://ror.org/02wfw7g10', 'no_lang_code', 1, 'https://ror.org/02wfw7g10 QM Power (United States)'),
(7377, 'https://ror.org/02whkqx98', 'no_lang_code', 1, 'https://ror.org/02whkqx98 Social Solutions International (United States)'),
(7378, 'https://ror.org/02wjx3n88', 'no_lang_code', 1, 'https://ror.org/02wjx3n88 Biomomentum (Canada)'),
(7379, 'https://ror.org/02wkp0463', 'fr', 1, 'https://ror.org/02wkp0463 Service Régional Vaudois de Transfusion Sanguine'),
(7380, 'https://ror.org/02wmjtd85', 'en', 1, 'https://ror.org/02wmjtd85 Notre Dame College'),
(7381, 'https://ror.org/02wna9e57', 'pt', 1, 'https://ror.org/02wna9e57 Instituto Adolfo Lutz'),
(7382, 'https://ror.org/02wnbr922', 'no_lang_code', 1, 'https://ror.org/02wnbr922 IBM (France)'),
(7383, 'https://ror.org/02wndzd81', 'en', 1, 'https://ror.org/02wndzd81 Heart and Diabetes Center North Rhine-Westphalia Herz- und Diabeteszentrum Nordrhein-Westfalen'),
(7384, 'https://ror.org/02wv0bc69', 'no_lang_code', 1, 'https://ror.org/02wv0bc69 DNA Polymerase Technology (United States)'),
(7385, 'https://ror.org/02wv25745', 'no_lang_code', 1, 'https://ror.org/02wv25745 ParaTechs (United States)'),
(7386, 'https://ror.org/02wvm8742', 'no_lang_code', 1, 'https://ror.org/02wvm8742 Montserrat Volcano Observatory'),
(7387, 'https://ror.org/02wvnxv35', 'no_lang_code', 1, 'https://ror.org/02wvnxv35 Inflazyme (Canada)'),
(7388, 'https://ror.org/02wxwab08', 'en', 1, 'https://ror.org/02wxwab08 Botanical Research Institute of Texas'),
(7389, 'https://ror.org/02wxws056', 'no_lang_code', 1, 'https://ror.org/02wxws056 Dynamic Graphics (United States)'),
(7390, 'https://ror.org/02wy9g851', 'no_lang_code', 1, 'https://ror.org/02wy9g851 Colibri Software (Canada)'),
(7391, 'https://ror.org/02wzb5b52', 'en', 1, 'https://ror.org/02wzb5b52 Grand Forks Human Nutrition Research Center'),
(7392, 'https://ror.org/02x1zab29', 'no_lang_code', 1, 'https://ror.org/02x1zab29 Chemring Technology Solutions (United Kingdom)'),
(7393, 'https://ror.org/02x4k7z35', 'no_lang_code', 1, 'https://ror.org/02x4k7z35 Carepayment (United States)'),
(7394, 'https://ror.org/02x4mx473', 'en', 1, 'https://ror.org/02x4mx473 Belgian Ceramic Research Centre'),
(7395, 'https://ror.org/02x6aye26', 'en', 1, 'https://ror.org/02x6aye26 National Association of State Boards of Education'),
(7396, 'https://ror.org/02x6fhe76', 'en', 1, 'https://ror.org/02x6fhe76 Transcultural Mental Health Institute'),
(7397, 'https://ror.org/02x6y0g48', 'en', 1, 'https://ror.org/02x6y0g48 Ann Becker and Associates'),
(7398, 'https://ror.org/02x79tw02', 'no_lang_code', 1, 'https://ror.org/02x79tw02 ALD Vacuum Technologies (Germany)'),
(7399, 'https://ror.org/02xbbj940', 'no_lang_code', 1, 'https://ror.org/02xbbj940 CASI Pharmaceuticals (United States)'),
(7400, 'https://ror.org/02xdxmh23', 'en', 1, 'https://ror.org/02xdxmh23 San Jacinto College'),
(7401, 'https://ror.org/02xe87f77', 'no_lang_code', 1, 'https://ror.org/02xe87f77 Yamagata Prefectural Central Hospital 山形県立中央病院'),
(7402, 'https://ror.org/02xf69211', 'no_lang_code', 1, 'https://ror.org/02xf69211 XRSciences (United States)'),
(7403, 'https://ror.org/02xfnnq52', 'no_lang_code', 1, 'https://ror.org/02xfnnq52 Bio Products Laboratory (United Kingdom)'),
(7404, 'https://ror.org/02xgttq77', 'no_lang_code', 1, 'https://ror.org/02xgttq77 Terma (Denmark)'),
(7405, 'https://ror.org/02xh63p53', 'en', 1, 'https://ror.org/02xh63p53 American Board of Emergency Medicine'),
(7406, 'https://ror.org/02xhxds14', 'no_lang_code', 1, 'https://ror.org/02xhxds14 Consarc Design Group (United Kingdom)'),
(7407, 'https://ror.org/02xm4cz36', 'en', 1, 'https://ror.org/02xm4cz36 LaserVision'),
(7408, 'https://ror.org/02xmjm585', 'no_lang_code', 1, 'https://ror.org/02xmjm585 Intelligent Mechatronic Systems (Canada)'),
(7409, 'https://ror.org/02xnj2427', 'fr', 1, 'https://ror.org/02xnj2427 Hôpital de Ville-Évrard'),
(7410, 'https://ror.org/02xrwdh93', 'en', 1, 'https://ror.org/02xrwdh93 Southern College of Optometry'),
(7411, 'https://ror.org/02xryym68', 'no_lang_code', 1, 'https://ror.org/02xryym68 Ashwin-Ushas (United States)'),
(7412, 'https://ror.org/02xst6m67', 'no_lang_code', 1, 'https://ror.org/02xst6m67 XL Sci-Tech (United States)'),
(7413, 'https://ror.org/02xvj0167', 'no_lang_code', 1, 'https://ror.org/02xvj0167 Lifepharms (United States)'),
(7414, 'https://ror.org/02xwa6p02', 'no_lang_code', 1, 'https://ror.org/02xwa6p02 Cubist Pharmaceuticals (United States)'),
(7415, 'https://ror.org/02xx54833', 'no_lang_code', 1, 'https://ror.org/02xx54833 HedgePath Pharmaceuticals (United States)'),
(7416, 'https://ror.org/02xxpjq61', 'en', 1, 'https://ror.org/02xxpjq61 Indian Institute of Management Bangalore भारतीय प्रबंध संस्थान बेंगलूर இந்திய மேலாண்மை கழகம் பெங்களூரு ఇండియన్ ఇన్‌స్టిట్యూట్ ఆఫ్ మేనేజ్‌మెంట్ బెంగుళూరు ಇಂಡಿಯನ್‌ ಇನ್‌ಸ್ಟಿಟ್ಯೂಟ್‌ ಆಫ್‌ ಮ್ಯಾನೇಜ್‌ಮೆಂಟ್‌ ಬೆಂಗಳೂರು ഇന്ത്യൻ ഇൻസ്റ്റിറ്റ്യൂട്ട് ഓഫ് മാനേജ്‌മെന്റ്, ബാംഗ്ലൂർ'),
(7417, 'https://ror.org/02xyffp85', 'en', 1, 'https://ror.org/02xyffp85 Fatima Mata National College ഫാത്തിമ മാതാ നാഷണൽ കോളേജ്'),
(7418, 'https://ror.org/02y0wmd59', 'en', 1, 'https://ror.org/02y0wmd59 Children''s Heart Center Nevada'),
(7419, 'https://ror.org/02y1jb308', 'en', 1, 'https://ror.org/02y1jb308 Telus World of Science'),
(7420, 'https://ror.org/02y239j20', 'en', 1, 'https://ror.org/02y239j20 MentorNet'),
(7421, 'https://ror.org/02y2p9e58', 'no_lang_code', 1, 'https://ror.org/02y2p9e58 Prognosys Biosciences (United States)'),
(7422, 'https://ror.org/02y2qcy45', 'en', 1, 'https://ror.org/02y2qcy45 Phoebe Putney Memorial Hospital'),
(7423, 'https://ror.org/02y41ps56', 'no_lang_code', 1, 'https://ror.org/02y41ps56 ImmuneXcite (United States)'),
(7424, 'https://ror.org/02y447018', 'en', 1, 'https://ror.org/02y447018 Canadian Council on Animal Care'),
(7425, 'https://ror.org/02y5b7h51', 'no_lang_code', 1, 'https://ror.org/02y5b7h51 Collagen Matrix (United States)'),
(7426, 'https://ror.org/02y85r186', 'en', 1, 'https://ror.org/02y85r186 Ohio County Behavioral Health Authorities'),
(7427, 'https://ror.org/02y8r3y04', 'no_lang_code', 1, 'https://ror.org/02y8r3y04 Life Prediction Technologies (Canada)'),
(7428, 'https://ror.org/02ybbzx72', 'en', 1, 'https://ror.org/02ybbzx72 Consortium de Recherche et Innovations en Bioprocédés Industriels au Québec Quebec Consortium for Industrial Bioprocess Research and Innovation'),
(7429, 'https://ror.org/02ycgwy86', 'es', 1, 'https://ror.org/02ycgwy86 Profamilia'),
(7430, 'https://ror.org/02ycq1t04', 'no_lang_code', 1, 'https://ror.org/02ycq1t04 ABS Materials (United States)'),
(7431, 'https://ror.org/02ydc1657', 'it', 1, 'https://ror.org/02ydc1657 Gruppo di Ricerca Geriatrica'),
(7432, 'https://ror.org/02yfw7119', 'fr', 1, 'https://ror.org/02yfw7119 Fondation de Rothschild'),
(7433, 'https://ror.org/02ygwnf45', 'no_lang_code', 1, 'https://ror.org/02ygwnf45 Public Data Queries (United States)'),
(7434, 'https://ror.org/02yh9se80', 'en', 1, 'https://ror.org/02yh9se80 Russell Sage Foundation'),
(7435, 'https://ror.org/02yj6hv88', 'no_lang_code', 1, 'https://ror.org/02yj6hv88 Pharis Biotec (Germany)'),
(7436, 'https://ror.org/02yk9rt54', 'en', 1, 'https://ror.org/02yk9rt54 Blast Theory'),
(7437, 'https://ror.org/02ym2t546', 'en', 1, 'https://ror.org/02ym2t546 Milwaukee Area Technical College'),
(7438, 'https://ror.org/02yp59539', 'en', 1, 'https://ror.org/02yp59539 Clinical Trials and Surveys Corporation'),
(7439, 'https://ror.org/02yqf2n67', 'en', 1, 'https://ror.org/02yqf2n67 American Indian Higher Education Consortium'),
(7440, 'https://ror.org/02yrkyr74', 'no_lang_code', 1, 'https://ror.org/02yrkyr74 Data Voice Exchange (United States)'),
(7441, 'https://ror.org/02yry4472', 'en', 1, 'https://ror.org/02yry4472 All-China Sports Federation'),
(7442, 'https://ror.org/02ys1c285', 'en', 1, 'https://ror.org/02ys1c285 Development Center for Biotechnology'),
(7443, 'https://ror.org/02ythcz79', 'en', 1, 'https://ror.org/02ythcz79 American Society for Cybernetics'),
(7444, 'https://ror.org/02yw59f42', 'en', 1, 'https://ror.org/02yw59f42 Central New Mexico Community College'),
(7445, 'https://ror.org/02yx0gd46', 'no_lang_code', 1, 'https://ror.org/02yx0gd46 Biomedical Frontiers (United States)'),
(7446, 'https://ror.org/02yx4yb97', 'no_lang_code', 1, 'https://ror.org/02yx4yb97 Epigen Biosciences (United States)'),
(7447, 'https://ror.org/02yxan022', 'no_lang_code', 1, 'https://ror.org/02yxan022 Quanser (Canada)'),
(7448, 'https://ror.org/02yz66a54', 'no_lang_code', 1, 'https://ror.org/02yz66a54 NovelMed Therapeutics (United States)'),
(7449, 'https://ror.org/02yzma536', 'no_lang_code', 1, 'https://ror.org/02yzma536 Infrared Fiber Systems (United States)'),
(7450, 'https://ror.org/02z0n2g81', 'no_lang_code', 1, 'https://ror.org/02z0n2g81 Arçelik (Turkey)'),
(7451, 'https://ror.org/02z2dfb58', 'en', 1, 'https://ror.org/02z2dfb58 CeMM Research Center for Molecular Medicine'),
(7452, 'https://ror.org/02z36x226', 'no_lang_code', 1, 'https://ror.org/02z36x226 Vancouver Enterprise Forum'),
(7453, 'https://ror.org/02z40ce29', 'en', 1, 'https://ror.org/02z40ce29 Red River College'),
(7454, 'https://ror.org/02z6ck570', 'no_lang_code', 1, 'https://ror.org/02z6ck570 IPL (Canada)'),
(7455, 'https://ror.org/02z8v3172', 'no_lang_code', 1, 'https://ror.org/02z8v3172 Systex (United States)'),
(7456, 'https://ror.org/02z95d405', 'de', 1, 'https://ror.org/02z95d405 Institut für Klinische Forschung und Entwicklung'),
(7457, 'https://ror.org/02z9mtw38', 'en', 1, 'https://ror.org/02z9mtw38 Tapestry Health'),
(7458, 'https://ror.org/02zan5e48', 'en', 1, 'https://ror.org/02zan5e48 Menorah Park Center for Senior Living'),
(7459, 'https://ror.org/02zdssw25', 'el', 1, 'https://ror.org/02zdssw25 Dimitra'),
(7460, 'https://ror.org/02zdz1m23', 'en', 1, 'https://ror.org/02zdz1m23 Ministry of Agriculture, Forestry and Fisheries 農林水産省'),
(7461, 'https://ror.org/02zdz9s16', 'en', 1, 'https://ror.org/02zdz9s16 Ackerman Institute for the Family'),
(7462, 'https://ror.org/02zepah98', 'en', 1, 'https://ror.org/02zepah98 Hand and Wrist Center of Houston'),
(7463, 'https://ror.org/02zeqvn38', 'no_lang_code', 1, 'https://ror.org/02zeqvn38 EMC Microcollections (Germany)'),
(7464, 'https://ror.org/02zhhtj16', 'en', 1, 'https://ror.org/02zhhtj16 West Virginia High Technology Consortium Foundation'),
(7465, 'https://ror.org/02zhjb475', 'en', 1, 'https://ror.org/02zhjb475 Thompson Cancer Survival Center'),
(7466, 'https://ror.org/02zhwmh74', 'en', 1, 'https://ror.org/02zhwmh74 Cincinnati Eye Institute'),
(7467, 'https://ror.org/02zksq237', 'es', 1, 'https://ror.org/02zksq237 Asociación de la Industria Navarra'),
(7468, 'https://ror.org/02zm13s10', 'en', 1, 'https://ror.org/02zm13s10 Applied Genetics Laboratories'),
(7469, 'https://ror.org/02zmajt19', 'it', 1, 'https://ror.org/02zmajt19 Casa di cura Pierangeli'),
(7470, 'https://ror.org/02zn7mc21', 'en', 1, 'https://ror.org/02zn7mc21 Medical Care Development'),
(7471, 'https://ror.org/02zq8st27', 'en', 1, 'https://ror.org/02zq8st27 Butte College'),
(7472, 'https://ror.org/02zv3n642', 'en', 1, 'https://ror.org/02zv3n642 Institute for Facial Esthetics'),
(7473, 'https://ror.org/02zz8mw60', 'no_lang_code', 1, 'https://ror.org/02zz8mw60 GlaxoSmithKline (Canada)'),
(7474, 'https://ror.org/02zzfj172', 'en', 1, 'https://ror.org/02zzfj172 Wuhan Asia Heart Hospital 武汉亚洲心脏病医院'),
(7475, 'https://ror.org/0304xwq55', 'en', 1, 'https://ror.org/0304xwq55 Education Training And Research'),
(7476, 'https://ror.org/0309ps652', 'no_lang_code', 1, 'https://ror.org/0309ps652 CyberLogic (United States)'),
(7477, 'https://ror.org/030anrr19', 'no_lang_code', 1, 'https://ror.org/030anrr19 Thermo Fisher Scientific (Lithuania)'),
(7478, 'https://ror.org/030cz2x22', 'no_lang_code', 1, 'https://ror.org/030cz2x22 Interactive Drama (United States)'),
(7479, 'https://ror.org/030gs7n75', 'no_lang_code', 1, 'https://ror.org/030gs7n75 Seccuris (Canada)'),
(7480, 'https://ror.org/030h0wa62', 'no_lang_code', 1, 'https://ror.org/030h0wa62 JBS International (United States)'),
(7481, 'https://ror.org/030h6t573', 'no_lang_code', 1, 'https://ror.org/030h6t573 DNAtrix (United States)'),
(7482, 'https://ror.org/030kh5t61', 'no_lang_code', 1, 'https://ror.org/030kh5t61 EDMA Innova'),
(7483, 'https://ror.org/030mbxz29', 'en', 1, 'https://ror.org/030mbxz29 Carter Center'),
(7484, 'https://ror.org/030mgn080', 'en', 1, 'https://ror.org/030mgn080 Anderson Orthopaedic Clinic'),
(7485, 'https://ror.org/030n06868', 'no_lang_code', 1, 'https://ror.org/030n06868 RiboMed Biotechnologies (United States)'),
(7486, 'https://ror.org/030n38z97', 'en', 1, 'https://ror.org/030n38z97 International Laser Center'),
(7487, 'https://ror.org/030p0vr95', 'no_lang_code', 1, 'https://ror.org/030p0vr95 Proton OnSite (United States)'),
(7488, 'https://ror.org/030p6ep86', 'no_lang_code', 1, 'https://ror.org/030p6ep86 Aecom (United Kingdom)'),
(7489, 'https://ror.org/030pv4h84', 'en', 1, 'https://ror.org/030pv4h84 Albertus Magnus College'),
(7490, 'https://ror.org/030qq9y73', 'en', 1, 'https://ror.org/030qq9y73 Hachinohe National College of Technology 八戸工業高等専門学校 庶務課'),
(7491, 'https://ror.org/030rk0759', 'no_lang_code', 1, 'https://ror.org/030rk0759 Electrovac (Austria)'),
(7492, 'https://ror.org/030wd1008', 'no_lang_code', 1, 'https://ror.org/030wd1008 Orbis Biosciences (United States)'),
(7493, 'https://ror.org/030x6kb17', 'no_lang_code', 1, 'https://ror.org/030x6kb17 Dune (Italy)'),
(7494, 'https://ror.org/030y83r80', 'en', 1, 'https://ror.org/030y83r80 Louisville Metabolic and Atherosclerosis Research Center'),
(7495, 'https://ror.org/030ygs139', 'no_lang_code', 1, 'https://ror.org/030ygs139 RAGT Seeds (United Kingdom)'),
(7496, 'https://ror.org/030yyf771', 'no_lang_code', 1, 'https://ror.org/030yyf771 Sun Pharma (India)'),
(7497, 'https://ror.org/030zc7t66', 'no_lang_code', 1, 'https://ror.org/030zc7t66 Sunovion (United States)'),
(7498, 'https://ror.org/031056b37', 'no_lang_code', 1, 'https://ror.org/031056b37 TomoWave Laboratories (United States)'),
(7499, 'https://ror.org/0310bxj37', 'no_lang_code', 1, 'https://ror.org/0310bxj37 Synageva BioPharma (United States)'),
(7500, 'https://ror.org/0311xw623', 'no_lang_code', 1, 'https://ror.org/0311xw623 PharmaSeq (United States)'),
(7501, 'https://ror.org/031432n58', 'de', 1, 'https://ror.org/031432n58 Deutsche Welle'),
(7502, 'https://ror.org/0315a7e71', 'en', 1, 'https://ror.org/0315a7e71 European Coordination Committee of the Radiological, Electromedical and Healthcare IT Industry'),
(7503, 'https://ror.org/0315pp027', 'en', 1, 'https://ror.org/0315pp027 Math Learning Center'),
(7504, 'https://ror.org/0315s4978', 'fr', 1, 'https://ror.org/0315s4978 Centre de Médecine Préventive'),
(7505, 'https://ror.org/0315wyw46', 'en', 1, 'https://ror.org/0315wyw46 Sheldon Jackson College'),
(7506, 'https://ror.org/0317zws63', 'en', 1, 'https://ror.org/0317zws63 Ministry of Public Order and Citizen Protection Υπουργείο Δημόσιας Τάξης και Προστασίας του Πολίτη'),
(7507, 'https://ror.org/0319xcm09', 'no_lang_code', 1, 'https://ror.org/0319xcm09 Peter Brett Associates'),
(7508, 'https://ror.org/031a6wg34', 'en', 1, 'https://ror.org/031a6wg34 Saskatchewan Health Quality Council'),
(7509, 'https://ror.org/031bpvz69', 'no_lang_code', 1, 'https://ror.org/031bpvz69 Gene Check (United States)'),
(7510, 'https://ror.org/031bsx066', 'en', 1, 'https://ror.org/031bsx066 DaVinci Institute'),
(7511, 'https://ror.org/031c2cm83', 'en', 1, 'https://ror.org/031c2cm83 Department of Justice'),
(7512, 'https://ror.org/031exby54', 'no_lang_code', 1, 'https://ror.org/031exby54 Sea Run Holdings (United States)'),
(7513, 'https://ror.org/031fnb427', 'no_lang_code', 1, 'https://ror.org/031fnb427 Biosensores (Spain)'),
(7514, 'https://ror.org/031gmvg29', 'no_lang_code', 1, 'https://ror.org/031gmvg29 Siemens (Denmark)'),
(7515, 'https://ror.org/031h48w98', 'no_lang_code', 1, 'https://ror.org/031h48w98 AMS (Germany)'),
(7516, 'https://ror.org/031m32a82', 'en', 1, 'https://ror.org/031m32a82 Athens International Airport Διεθνής Αερολιμένας Αθηνών «Ελευθέριος Βενιζέλος»'),
(7517, 'https://ror.org/031vg5s58', 'en', 1, 'https://ror.org/031vg5s58 Peru State College'),
(7518, 'https://ror.org/031vxrj29', 'en', 1, 'https://ror.org/031vxrj29 National Institute of Malaria Research राष्ट्रीय मलेरिया अनुसंधान संस्थान'),
(7519, 'https://ror.org/031x12x59', 'de', 1, 'https://ror.org/031x12x59 Katholisches Klinikum Koblenz'),
(7520, 'https://ror.org/031yk2194', 'en', 1, 'https://ror.org/031yk2194 Bangur Institute of Neurosciences'),
(7521, 'https://ror.org/031ywxc85', 'no_lang_code', 1, 'https://ror.org/031ywxc85 Alexion Pharmaceuticals (United States)'),
(7522, 'https://ror.org/031yz7195', 'en', 1, 'https://ror.org/031yz7195 Centre de Recherche Interdisciplinaire en Réadaptation Centre for Interdisciplinary Research in Rehabilitation'),
(7523, 'https://ror.org/03210bg97', 'no_lang_code', 1, 'https://ror.org/03210bg97 Dynex Semiconductor (United Kingdom)'),
(7524, 'https://ror.org/0322xet82', 'en', 1, 'https://ror.org/0322xet82 National Center for Healthy Housing'),
(7525, 'https://ror.org/0324dy645', 'no_lang_code', 1, 'https://ror.org/0324dy645 Radiant Creative Group'),
(7526, 'https://ror.org/03257r210', 'fi', 1, 'https://ror.org/03257r210 Kuopion Liikuntalääketieteen Tutkimuslaitos'),
(7527, 'https://ror.org/0325nt175', 'no_lang_code', 1, 'https://ror.org/0325nt175 Biobase (Germany)'),
(7528, 'https://ror.org/03294gc92', 'no_lang_code', 1, 'https://ror.org/03294gc92 Audiology (United States)'),
(7529, 'https://ror.org/032b4kq73', 'no_lang_code', 1, 'https://ror.org/032b4kq73 SoyMeds (United States)'),
(7530, 'https://ror.org/032bvxc76', 'no_lang_code', 1, 'https://ror.org/032bvxc76 Lakes Environmental (Canada)'),
(7531, 'https://ror.org/032h8td77', 'no_lang_code', 1, 'https://ror.org/032h8td77 InBios International (United States)'),
(7532, 'https://ror.org/032hhgs28', 'no_lang_code', 1, 'https://ror.org/032hhgs28 Caldic (Canada)'),
(7533, 'https://ror.org/032hvdr57', 'en', 1, 'https://ror.org/032hvdr57 Gordon-Conwell Theological Seminary'),
(7534, 'https://ror.org/032jtv165', 'no_lang_code', 1, 'https://ror.org/032jtv165 Hawaii Biotech (United States)'),
(7535, 'https://ror.org/032msy923', 'no_lang_code', 1, 'https://ror.org/032msy923 Santen (Japan) 参天製薬株式会社'),
(7536, 'https://ror.org/032mw2t40', 'no_lang_code', 1, 'https://ror.org/032mw2t40 Shifa Biomedical (United States)'),
(7537, 'https://ror.org/032s56e02', 'no_lang_code', 1, 'https://ror.org/032s56e02 Ceratizit (Luxembourg)'),
(7538, 'https://ror.org/032s9tg47', 'en', 1, 'https://ror.org/032s9tg47 Cooperative Research Centre for Beef Genetic Technologies'),
(7539, 'https://ror.org/032t9vq81', 'no_lang_code', 1, 'https://ror.org/032t9vq81 Shasta Crystals (United States)'),
(7540, 'https://ror.org/032v09t14', 'en', 1, 'https://ror.org/032v09t14 Bundesnetzagentur Federal Network Agency'),
(7541, 'https://ror.org/032w3wj13', 'en', 1, 'https://ror.org/032w3wj13 Research Institute for Production Development 般財団法人生産開発科学研究所'),
(7542, 'https://ror.org/032w6bp80', 'no_lang_code', 1, 'https://ror.org/032w6bp80 State Volunteer Mutual Insurance (United States)'),
(7543, 'https://ror.org/032y7r881', 'en', 1, 'https://ror.org/032y7r881 IntraHealth International'),
(7544, 'https://ror.org/032z49242', 'no_lang_code', 1, 'https://ror.org/032z49242 Senecio Software (United States)'),
(7545, 'https://ror.org/0331x8t04', 'nl', 1, 'https://ror.org/0331x8t04 Zaans Medisch Centrum'),
(7546, 'https://ror.org/03337hf32', 'no_lang_code', 1, 'https://ror.org/03337hf32 AugmenTech (United States)'),
(7547, 'https://ror.org/0333j1f77', 'no_lang_code', 1, 'https://ror.org/0333j1f77 Lentigen Technology (United States)'),
(7548, 'https://ror.org/033647p67', 'en', 1, 'https://ror.org/033647p67 Otsu Red Cross Hospital 大津赤十字病院'),
(7549, 'https://ror.org/0336jnw26', 'en', 1, 'https://ror.org/0336jnw26 Pittsburgh Tissue Engineering Initiative'),
(7550, 'https://ror.org/033c6ba10', 'en', 1, 'https://ror.org/033c6ba10 Southcentral Foundation'),
(7551, 'https://ror.org/033c74k08', 'no_lang_code', 1, 'https://ror.org/033c74k08 Intuitive Biosciences (United States)'),
(7552, 'https://ror.org/033cjdk78', 'en', 1, 'https://ror.org/033cjdk78 Green Valley High School'),
(7553, 'https://ror.org/033fn9j44', 'en', 1, 'https://ror.org/033fn9j44 Shriners Hospitals for Children - Chicago'),
(7554, 'https://ror.org/033fyh879', 'no_lang_code', 1, 'https://ror.org/033fyh879 Omicia (United States)'),
(7555, 'https://ror.org/033g0hw83', 'en', 1, 'https://ror.org/033g0hw83 Finnish Society of Automation'),
(7556, 'https://ror.org/033h8cb51', 'no_lang_code', 1, 'https://ror.org/033h8cb51 Cardiome (Canada)'),
(7557, 'https://ror.org/033jcqk26', 'en', 1, 'https://ror.org/033jcqk26 National Archives Yr Archifau Cenedlaethol'),
(7558, 'https://ror.org/033m8b439', 'en', 1, 'https://ror.org/033m8b439 California Institute for Regenerative Medicine'),
(7559, 'https://ror.org/033mjf763', 'it', 1, 'https://ror.org/033mjf763 Ospedale per gli Infermi'),
(7560, 'https://ror.org/033n9f723', 'no_lang_code', 1, 'https://ror.org/033n9f723 Polyglot Systems (United States)'),
(7561, 'https://ror.org/033nw2736', 'no_lang_code', 1, 'https://ror.org/033nw2736 Taisho Pharmaceutical (Japan) 大正製薬'),
(7562, 'https://ror.org/033q64q73', 'en', 1, 'https://ror.org/033q64q73 Cypress Health Region'),
(7563, 'https://ror.org/033r53w79', 'no_lang_code', 1, 'https://ror.org/033r53w79 Halsall (Canada)'),
(7564, 'https://ror.org/033rjjc73', 'en', 1, 'https://ror.org/033rjjc73 Park Nicollet Methodist Hospital'),
(7565, 'https://ror.org/033sk1c45', 'en', 1, 'https://ror.org/033sk1c45 Prestera Center'),
(7566, 'https://ror.org/033ssdc55', 'no_lang_code', 1, 'https://ror.org/033ssdc55 Unisys (United States)'),
(7567, 'https://ror.org/033w59g46', 'en', 1, 'https://ror.org/033w59g46 Ministry of Agriculture, Food and Rural Affairs Ministère de l''Agriculture, de l''Alimenntation et des Affaires Rurales'),
(7568, 'https://ror.org/0340d8j26', 'it', 1, 'https://ror.org/0340d8j26 Avantea'),
(7569, 'https://ror.org/0342mgc93', 'en', 1, 'https://ror.org/0342mgc93 Alaska Department of Environmental Conservation'),
(7570, 'https://ror.org/0343gdk92', 'en', 1, 'https://ror.org/0343gdk92 Dorn Research Institute'),
(7571, 'https://ror.org/0345rff82', 'no_lang_code', 1, 'https://ror.org/0345rff82 Evident Point (Canada)'),
(7572, 'https://ror.org/0347fy350', 'en', 1, 'https://ror.org/0347fy350 Rothamsted Research'),
(7573, 'https://ror.org/0348rpk45', 'no_lang_code', 1, 'https://ror.org/0348rpk45 InXsol (United States)'),
(7574, 'https://ror.org/034948b51', 'en', 1, 'https://ror.org/034948b51 Calhoun Community College'),
(7575, 'https://ror.org/034a7fc11', 'no_lang_code', 1, 'https://ror.org/034a7fc11 Copernicus Therapeutics (United States)'),
(7576, 'https://ror.org/034b18290', 'no_lang_code', 1, 'https://ror.org/034b18290 Precision Combustion (United States)'),
(7577, 'https://ror.org/034c0gr54', 'en', 1, 'https://ror.org/034c0gr54 Oklahoma Foundation for Digestive Research'),
(7578, 'https://ror.org/034dvzk32', 'en', 1, 'https://ror.org/034dvzk32 Marin Health and Human Services'),
(7579, 'https://ror.org/034fbm741', 'no_lang_code', 1, 'https://ror.org/034fbm741 eSpin Technologies (United States)'),
(7580, 'https://ror.org/034hh2e11', 'en', 1, 'https://ror.org/034hh2e11 Amgueddfa Victoria ac Albert Victoria and Albert Museum'),
(7581, 'https://ror.org/034ja4661', 'no_lang_code', 1, 'https://ror.org/034ja4661 Educational Service Incorporation'),
(7582, 'https://ror.org/034jwje45', 'no_lang_code', 1, 'https://ror.org/034jwje45 Yukioka Hospital 行岡病院'),
(7583, 'https://ror.org/034jwm186', 'en', 1, 'https://ror.org/034jwm186 Aletheia House'),
(7584, 'https://ror.org/034kxvk28', 'no_lang_code', 1, 'https://ror.org/034kxvk28 Galderma (France)'),
(7585, 'https://ror.org/034nvrd87', 'en', 1, 'https://ror.org/034nvrd87 Royal Berkshire NHS Foundation Trust'),
(7586, 'https://ror.org/034pcpg38', 'en', 1, 'https://ror.org/034pcpg38 Bard College at Simon''s Rock'),
(7587, 'https://ror.org/034pm2g80', 'en', 1, 'https://ror.org/034pm2g80 Colegios Comunitarios del Condado de Dallas Dallas County Community College District'),
(7588, 'https://ror.org/034s15752', 'en', 1, 'https://ror.org/034s15752 Academy for Educational Development'),
(7589, 'https://ror.org/034s1fw96', 'en', 1, 'https://ror.org/034s1fw96 Yokohama Municipal Citizen''s Hospital 横浜市営市民病院'),
(7590, 'https://ror.org/034thfr92', 'no_lang_code', 1, 'https://ror.org/034thfr92 Havstovan'),
(7591, 'https://ror.org/034vefz29', 'no_lang_code', 1, 'https://ror.org/034vefz29 Rehabtek (United States)'),
(7592, 'https://ror.org/034wxcc35', 'en', 1, 'https://ror.org/034wxcc35 European Organisation for Research and Treatment of Cancer Organisation européenne pour la recherche et le traitement du cancer'),
(7593, 'https://ror.org/034x2fx50', 'en', 1, 'https://ror.org/034x2fx50 Information and Communication Technologies Centre'),
(7594, 'https://ror.org/034xvzb47', 'en', 1, 'https://ror.org/034xvzb47 United States Food and Drug Administration'),
(7595, 'https://ror.org/034xych09', 'en', 1, 'https://ror.org/034xych09 Winchester Science Centre'),
(7596, 'https://ror.org/034y1g063', 'en', 1, 'https://ror.org/034y1g063 New York State Office of Alcoholism and Substance Abuse Services'),
(7597, 'https://ror.org/034y7by63', 'no_lang_code', 1, 'https://ror.org/034y7by63 Lineage Cell Therapeutics (United States)'),
(7598, 'https://ror.org/034zgem50', 'it', 1, 'https://ror.org/034zgem50 Agence spatiale italienne Agenzia Spaziale Italiana Agència Espacial Italiana Italian Space Agency'),
(7599, 'https://ror.org/0350vc126', 'en', 1, 'https://ror.org/0350vc126 River Region Human Services'),
(7600, 'https://ror.org/03535yg39', 'en', 1, 'https://ror.org/03535yg39 American Occupational Therapy Association'),
(7601, 'https://ror.org/0353yar19', 'en', 1, 'https://ror.org/0353yar19 Dr. Daneshbod Labratory'),
(7602, 'https://ror.org/03561g010', 'no_lang_code', 1, 'https://ror.org/03561g010 Canadian Green Tech (Canada)'),
(7603, 'https://ror.org/035756473', 'en', 1, 'https://ror.org/035756473 Trinity Washington University Universidad Trinity Washington'),
(7604, 'https://ror.org/0357g8536', 'no_lang_code', 1, 'https://ror.org/0357g8536 Clearpath Robotics (Canada)'),
(7605, 'https://ror.org/03583w097', 'no_lang_code', 1, 'https://ror.org/03583w097 System Biosciences (United States)'),
(7606, 'https://ror.org/0358b9334', 'en', 1, 'https://ror.org/0358b9334 Pakistan Institute of Medical Sciences پاکستان طبی سائنس انسٹی ٹیوٹ'),
(7607, 'https://ror.org/0359jxf05', 'no_lang_code', 1, 'https://ror.org/0359jxf05 ImmuRx (United States)'),
(7608, 'https://ror.org/0359s0245', 'no_lang_code', 1, 'https://ror.org/0359s0245 Continental (Germany)'),
(7609, 'https://ror.org/035aej353', 'en', 1, 'https://ror.org/035aej353 Lorain County Community College'),
(7610, 'https://ror.org/035cynm43', 'en', 1, 'https://ror.org/035cynm43 Foundation for Research into Traditional Chinese Medicine'),
(7611, 'https://ror.org/035djg835', 'no_lang_code', 1, 'https://ror.org/035djg835 National Recovery Technologies (United States)'),
(7612, 'https://ror.org/035dkke52', 'no_lang_code', 1, 'https://ror.org/035dkke52 Scisys (United Kingdom)'),
(7613, 'https://ror.org/035dpw102', 'en', 1, 'https://ror.org/035dpw102 Sage College of Albany'),
(7614, 'https://ror.org/035fp5e48', 'en', 1, 'https://ror.org/035fp5e48 Scientific Consulting Group'),
(7615, 'https://ror.org/035gyn125', 'en', 1, 'https://ror.org/035gyn125 Trenton Psychiatric Hospital'),
(7616, 'https://ror.org/035h6e956', 'en', 1, 'https://ror.org/035h6e956 College of American Pathologists'),
(7617, 'https://ror.org/035hvd463', 'en', 1, 'https://ror.org/035hvd463 Université adventiste de washington Washington Adventist University'),
(7618, 'https://ror.org/035qh5653', 'en', 1, 'https://ror.org/035qh5653 M.G. Kholodny Institute of Botany'),
(7619, 'https://ror.org/035vrxy57', 'en', 1, 'https://ror.org/035vrxy57 Micro and Nanotechnology Innovation Centre'),
(7620, 'https://ror.org/035wemy73', 'no_lang_code', 1, 'https://ror.org/035wemy73 Bellus Health (Canada)'),
(7621, 'https://ror.org/035wk0p43', 'no_lang_code', 1, 'https://ror.org/035wk0p43 E.ON (United States)'),
(7622, 'https://ror.org/035ytfy75', 'no_lang_code', 1, 'https://ror.org/035ytfy75 British Nuclear Fuel Limited (United Kingdom)'),
(7623, 'https://ror.org/035za2858', 'no_lang_code', 1, 'https://ror.org/035za2858 Biofaction (Austria)'),
(7624, 'https://ror.org/035zrdg08', 'no_lang_code', 1, 'https://ror.org/035zrdg08 MassTech (United States)'),
(7625, 'https://ror.org/0361tej78', 'no_lang_code', 1, 'https://ror.org/0361tej78 Urigen Pharmaceuticals (United States)'),
(7626, 'https://ror.org/0362v0107', 'en', 1, 'https://ror.org/0362v0107 Family and Medical Counseling Service'),
(7627, 'https://ror.org/036300c37', 'en', 1, 'https://ror.org/036300c37 Indiana Academy of Science'),
(7628, 'https://ror.org/036482385', 'en', 1, 'https://ror.org/036482385 United Engineering Foundation'),
(7629, 'https://ror.org/0364xxv33', 'no_lang_code', 1, 'https://ror.org/0364xxv33 Efacec (Portugal)'),
(7630, 'https://ror.org/0366e1296', 'en', 1, 'https://ror.org/0366e1296 Association of Chief Police Officers'),
(7631, 'https://ror.org/0366h3j49', 'no_lang_code', 1, 'https://ror.org/0366h3j49 Geotechnical Observations (United Kingdom)'),
(7632, 'https://ror.org/03671qm90', 'en', 1, 'https://ror.org/03671qm90 American College of Physicians'),
(7633, 'https://ror.org/03674y156', 'es', 1, 'https://ror.org/03674y156 Instituto Nacional de Enfermedades Neoplásicas'),
(7634, 'https://ror.org/0368qtc02', 'no_lang_code', 1, 'https://ror.org/0368qtc02 Nestlé (United States)'),
(7635, 'https://ror.org/036bdjm06', 'en', 1, 'https://ror.org/036bdjm06 Techniquest'),
(7636, 'https://ror.org/036bpjh12', 'en', 1, 'https://ror.org/036bpjh12 American Association of Blood Banks'),
(7637, 'https://ror.org/036d9xe15', 'no_lang_code', 1, 'https://ror.org/036d9xe15 Ceramics and Refractories Technological Development Company (Greece)'),
(7638, 'https://ror.org/036dfq243', 'no_lang_code', 1, 'https://ror.org/036dfq243 Vion Pharmaceuticals (United States)'),
(7639, 'https://ror.org/036dv6j71', 'no_lang_code', 1, 'https://ror.org/036dv6j71 Human Computer Interaction (Switzerland)'),
(7640, 'https://ror.org/036gc1b60', 'no_lang_code', 1, 'https://ror.org/036gc1b60 Renewable Energy Systems (United States)'),
(7641, 'https://ror.org/036gvnq39', 'en', 1, 'https://ror.org/036gvnq39 Ministry of Manpower 新加坡人力部'),
(7642, 'https://ror.org/036kqs922', 'en', 1, 'https://ror.org/036kqs922 Institute of Contemporary Psychoanalysis'),
(7643, 'https://ror.org/036mg3k91', 'no_lang_code', 1, 'https://ror.org/036mg3k91 Compound Semiconductor Technologies (United Kingdom)'),
(7644, 'https://ror.org/036p1cm16', 'en', 1, 'https://ror.org/036p1cm16 Karnataka Veterinary Animal and Fisheries Sciences University कर्नाटक वेटेरिनरी, मत्स्य पालन र पशु विज्ञान विश्वविद्यालय'),
(7645, 'https://ror.org/036qcfm37', 'en', 1, 'https://ror.org/036qcfm37 Academy for Science and Design'),
(7646, 'https://ror.org/036svm011', 'en', 1, 'https://ror.org/036svm011 Southern Nevada Health District'),
(7647, 'https://ror.org/036vj6108', 'no_lang_code', 1, 'https://ror.org/036vj6108 SFC Fluidics (United States)'),
(7648, 'https://ror.org/036vmnd51', 'en', 1, 'https://ror.org/036vmnd51 Bishop State Community College'),
(7649, 'https://ror.org/036w5wx69', 'en', 1, 'https://ror.org/036w5wx69 Bio Behavioral Institute'),
(7650, 'https://ror.org/036wqaf87', 'no_lang_code', 1, 'https://ror.org/036wqaf87 ProteinSimple (United States)'),
(7651, 'https://ror.org/036x02d82', 'en', 1, 'https://ror.org/036x02d82 Tyne and Wear Archives and Museums'),
(7652, 'https://ror.org/036x6dk73', 'en', 1, 'https://ror.org/036x6dk73 North American Primary Care Research Group'),
(7653, 'https://ror.org/036ygzs59', 'en', 1, 'https://ror.org/036ygzs59 Northwestern Medical Faculty Foundation'),
(7654, 'https://ror.org/036ypft38', 'pt', 1, 'https://ror.org/036ypft38 Centro Hospitalar de Lisboa Ocidental'),
(7655, 'https://ror.org/036z11b33', 'en', 1, 'https://ror.org/036z11b33 Shriners Hospitals for Children - Philadelphia'),
(7656, 'https://ror.org/036zx6482', 'en', 1, 'https://ror.org/036zx6482 United States Drug Testing Laboratories'),
(7657, 'https://ror.org/036zxgb71', 'en', 1, 'https://ror.org/036zxgb71 Institute for the Study of Learning and Expertise'),
(7658, 'https://ror.org/03700pg61', 'en', 1, 'https://ror.org/03700pg61 Yedikule Göğüs Hastalıkları ve Göğüs Cerrahisi Eğitim ve Araştırma Hastanesi Yedikule Teaching Hospital'),
(7659, 'https://ror.org/0370dwx56', 'it', 1, 'https://ror.org/0370dwx56 Istituto Zooprofilattico Sperimentale della Sardegna'),
(7660, 'https://ror.org/0370sjj75', 'no_lang_code', 1, 'https://ror.org/0370sjj75 Optum (United States)'),
(7661, 'https://ror.org/03734cd59', 'es', 1, 'https://ror.org/03734cd59 Instituto Nacional de Rehabilitación National Institute of Rehabilitation'),
(7662, 'https://ror.org/0373e3z25', 'en', 1, 'https://ror.org/0373e3z25 Virginia Museum of Natural History'),
(7663, 'https://ror.org/037403209', 'en', 1, 'https://ror.org/037403209 Gunma Prefectural Cardiovascular Center 群馬県立心臓血管センター'),
(7664, 'https://ror.org/0374p0y44', 'no_lang_code', 1, 'https://ror.org/0374p0y44 ReproCELL (United States)'),
(7665, 'https://ror.org/0374t0s90', 'no_lang_code', 1, 'https://ror.org/0374t0s90 Jim Metzner Productions (United States)'),
(7666, 'https://ror.org/0375f4d26', 'en', 1, 'https://ror.org/0375f4d26 Alzheimer''s Association'),
(7667, 'https://ror.org/0378g3743', 'en', 1, 'https://ror.org/0378g3743 Animal and Plant Health Agency'),
(7668, 'https://ror.org/03791d618', 'no_lang_code', 1, 'https://ror.org/03791d618 Kimberly-Clark (United States)'),
(7669, 'https://ror.org/0379zp714', 'en', 1, 'https://ror.org/0379zp714 Croatian Chamber of Economy'),
(7670, 'https://ror.org/037asfw97', 'en', 1, 'https://ror.org/037asfw97 Tri County Technical College'),
(7671, 'https://ror.org/037b79526', 'no_lang_code', 1, 'https://ror.org/037b79526 Synedgen (United States)'),
(7672, 'https://ror.org/037bj9005', 'no_lang_code', 1, 'https://ror.org/037bj9005 Global Convergence (United States)'),
(7673, 'https://ror.org/037bt1j05', 'fr', 1, 'https://ror.org/037bt1j05 Fondation de Coopération Scientifique Foundation for Scientific Cooperation'),
(7674, 'https://ror.org/037c0br92', 'en', 1, 'https://ror.org/037c0br92 Guangzhou Institute of Dermatology'),
(7675, 'https://ror.org/037dd8g98', 'no_lang_code', 1, 'https://ror.org/037dd8g98 Ecological Consultancy Services (Ireland)'),
(7676, 'https://ror.org/037egvh70', 'en', 1, 'https://ror.org/037egvh70 Wishaw General Hospital'),
(7677, 'https://ror.org/037j2jz78', 'de', 1, 'https://ror.org/037j2jz78 Deutsche Wissenschaftliche Gesellschaft für Erdöl Erdgas und Kohle German Society for Petroleum and Coal Science and Technology'),
(7678, 'https://ror.org/037jprb08', 'sv', 1, 'https://ror.org/037jprb08 Centrallasarettet Växjö'),
(7679, 'https://ror.org/037kgpk38', 'en', 1, 'https://ror.org/037kgpk38 William Jewell College'),
(7680, 'https://ror.org/037m83a38', 'en', 1, 'https://ror.org/037m83a38 Royal Institution of Great Britain'),
(7681, 'https://ror.org/037mmnn19', 'en', 1, 'https://ror.org/037mmnn19 American Sports Medicine Institute'),
(7682, 'https://ror.org/037ndkh53', 'no_lang_code', 1, 'https://ror.org/037ndkh53 Biomedical Research Models (United States)'),
(7683, 'https://ror.org/037sxey58', 'no_lang_code', 1, 'https://ror.org/037sxey58 Amunix (United States)'),
(7684, 'https://ror.org/037xafn82', 'en', 1, 'https://ror.org/037xafn82 William S. Middleton Memorial Veterans Hospital');
INSERT INTO `rors` VALUES
(7685, 'https://ror.org/037xccs34', 'en', 1, 'https://ror.org/037xccs34 Chitose Institute of Science and Technology 千歳科学技術大学'),
(7686, 'https://ror.org/037xte462', 'no_lang_code', 1, 'https://ror.org/037xte462 Talaris Therapeutics (United States)'),
(7687, 'https://ror.org/037ytpe94', 'no_lang_code', 1, 'https://ror.org/037ytpe94 OEpic Semiconductors (United States)'),
(7688, 'https://ror.org/03828wc37', 'no_lang_code', 1, 'https://ror.org/03828wc37 Public Health Television (United States)'),
(7689, 'https://ror.org/0383dsh39', 'en', 1, 'https://ror.org/0383dsh39 Center for Usability Research and Engineering Centrum für die Untersuchung und Realisierung Endbenutzerorientierter Interaktiver Systeme'),
(7690, 'https://ror.org/03847e911', 'no_lang_code', 1, 'https://ror.org/03847e911 International Chemical Investors (Germany)'),
(7691, 'https://ror.org/0384y3666', 'en', 1, 'https://ror.org/0384y3666 Police Forensic Science Laboratory Dundee'),
(7692, 'https://ror.org/0385es521', 'no_lang_code', 1, 'https://ror.org/0385es521 Boston Scientific (United States)'),
(7693, 'https://ror.org/0385nmy68', 'en', 1, 'https://ror.org/0385nmy68 Ministry of Industry and Information Technology 中华人民共和国工业和信息化部'),
(7694, 'https://ror.org/03865vt17', 'no_lang_code', 1, 'https://ror.org/03865vt17 Advaxis (United States)'),
(7695, 'https://ror.org/03868wc59', 'en', 1, 'https://ror.org/03868wc59 Middlesex County College'),
(7696, 'https://ror.org/0386f5975', 'no_lang_code', 1, 'https://ror.org/0386f5975 Finceramica (Italy)'),
(7697, 'https://ror.org/0387jng26', 'en', 1, 'https://ror.org/0387jng26 Max Planck Institute for Human Cognitive and Brain Sciences Max-Planck-Institut für Kognitions- und Neurowissenschaften'),
(7698, 'https://ror.org/0388bf577', 'en', 1, 'https://ror.org/0388bf577 Bulgarian Chamber of Commerce and Industry'),
(7699, 'https://ror.org/038aete71', 'no_lang_code', 1, 'https://ror.org/038aete71 Advanced Diamond Technologies (United States)'),
(7700, 'https://ror.org/038c39g95', 'en', 1, 'https://ror.org/038c39g95 Allegheny Valley Hospital'),
(7701, 'https://ror.org/038dgnc07', 'no_lang_code', 1, 'https://ror.org/038dgnc07 Cygnus (United States)'),
(7702, 'https://ror.org/038emx233', 'no_lang_code', 1, 'https://ror.org/038emx233 EMT Associates (United States)'),
(7703, 'https://ror.org/038eqqh78', 'no_lang_code', 1, 'https://ror.org/038eqqh78 Lockheed Martin Orincon (United States)'),
(7704, 'https://ror.org/038es7c44', 'no_lang_code', 1, 'https://ror.org/038es7c44 EnginSoft (Italy)'),
(7705, 'https://ror.org/038espn32', 'en', 1, 'https://ror.org/038espn32 CARE USA'),
(7706, 'https://ror.org/038gwk587', 'en', 1, 'https://ror.org/038gwk587 Centerstone'),
(7707, 'https://ror.org/038hqfn26', 'no_lang_code', 1, 'https://ror.org/038hqfn26 Alkermes (United States)'),
(7708, 'https://ror.org/038hwjs80', 'en', 1, 'https://ror.org/038hwjs80 Pacific Tower'),
(7709, 'https://ror.org/038jnd853', 'en', 1, 'https://ror.org/038jnd853 Sher Fertility'),
(7710, 'https://ror.org/038jzvs45', 'en', 1, 'https://ror.org/038jzvs45 Psychiatric Foundation of North Carolina'),
(7711, 'https://ror.org/038kja517', 'en', 1, 'https://ror.org/038kja517 Hydrologic Research Center'),
(7712, 'https://ror.org/038kxkq33', 'no_lang_code', 1, 'https://ror.org/038kxkq33 Teijin (Japan) 帝人株式会社'),
(7713, 'https://ror.org/038mdqs58', 'en', 1, 'https://ror.org/038mdqs58 D.F. Chebotarev Institute of Gerontology Інститут геронтології ім. Д.Ф.Чеботарьова'),
(7714, 'https://ror.org/038naac42', 'no_lang_code', 1, 'https://ror.org/038naac42 AdipoGenix (United States)'),
(7715, 'https://ror.org/038s2v152', 'no_lang_code', 1, 'https://ror.org/038s2v152 Ciencia (United States)'),
(7716, 'https://ror.org/038sjwf38', 'no_lang_code', 1, 'https://ror.org/038sjwf38 Takeda (Norway)'),
(7717, 'https://ror.org/038srm946', 'no_lang_code', 1, 'https://ror.org/038srm946 Mantech (Canada)'),
(7718, 'https://ror.org/038tp0t62', 'en', 1, 'https://ror.org/038tp0t62 Las Vegas Institute'),
(7719, 'https://ror.org/038vngd42', 'fr', 1, 'https://ror.org/038vngd42 Centre Hospitalier Universitaire de Kigali University Teaching Hospital of Kigali'),
(7720, 'https://ror.org/038wghp07', 'no_lang_code', 1, 'https://ror.org/038wghp07 Norgen Biotek Corporation (Canada)'),
(7721, 'https://ror.org/038x9td67', 'en', 1, 'https://ror.org/038x9td67 Institute for Atomic and Molecular Physics'),
(7722, 'https://ror.org/038xkzz47', 'no_lang_code', 1, 'https://ror.org/038xkzz47 Viro Dynamics (United States)'),
(7723, 'https://ror.org/038z5mp14', 'en', 1, 'https://ror.org/038z5mp14 Organisation des États Américains Organización de los Estados Americanos Organization of American States Organização dos Estados Americanos'),
(7724, 'https://ror.org/0390tt424', 'en', 1, 'https://ror.org/0390tt424 HealthCare Interactive'),
(7725, 'https://ror.org/0392txn84', 'no_lang_code', 1, 'https://ror.org/0392txn84 Stemmatters (Portugal)'),
(7726, 'https://ror.org/0393c0k55', 'no_lang_code', 1, 'https://ror.org/0393c0k55 Cooper and Company (United States)'),
(7727, 'https://ror.org/0393mwb72', 'no_lang_code', 1, 'https://ror.org/0393mwb72 United Utilities (United Kingdom)'),
(7728, 'https://ror.org/0396gxt62', 'no_lang_code', 1, 'https://ror.org/0396gxt62 Motorola (United Kingdom)'),
(7729, 'https://ror.org/039922k61', 'en', 1, 'https://ror.org/039922k61 Kenya Agricultural Research Institute'),
(7730, 'https://ror.org/0399pn486', 'en', 1, 'https://ror.org/0399pn486 McREL International'),
(7731, 'https://ror.org/039bbm920', 'en', 1, 'https://ror.org/039bbm920 National Audubon Society'),
(7732, 'https://ror.org/039cthy03', 'en', 1, 'https://ror.org/039cthy03 Bamfield Marine Sciences Centre'),
(7733, 'https://ror.org/039d1mp60', 'en', 1, 'https://ror.org/039d1mp60 Central Glass and Ceramic Research Institute'),
(7734, 'https://ror.org/039d42y17', 'no_lang_code', 1, 'https://ror.org/039d42y17 BioTalentum (Hungary)'),
(7735, 'https://ror.org/039ekp273', 'en', 1, 'https://ror.org/039ekp273 Institute of Cellular and Intracellular Symbiosis Федеральное государственное бюджетное учреждение науки Институт биофизики клетки Российской академии наук'),
(7736, 'https://ror.org/039fp5n52', 'en', 1, 'https://ror.org/039fp5n52 At Bristol'),
(7737, 'https://ror.org/039ft6244', 'no_lang_code', 1, 'https://ror.org/039ft6244 ArcelorMittal (Germany)'),
(7738, 'https://ror.org/039h53162', 'fr', 1, 'https://ror.org/039h53162 Centre hospitalier de Tulle'),
(7739, 'https://ror.org/039hmr469', 'en', 1, 'https://ror.org/039hmr469 Ono Clinic 小野クリニック'),
(7740, 'https://ror.org/039hqe943', 'no_lang_code', 1, 'https://ror.org/039hqe943 MedShape (United States)'),
(7741, 'https://ror.org/039k6f508', 'en', 1, 'https://ror.org/039k6f508 Korea Electronics Technology Institute'),
(7742, 'https://ror.org/039pgdx28', 'no_lang_code', 1, 'https://ror.org/039pgdx28 Danfoss (Denmark)'),
(7743, 'https://ror.org/039q6xk02', 'en', 1, 'https://ror.org/039q6xk02 Moss Rehabilitation Hospital'),
(7744, 'https://ror.org/039qtv212', 'en', 1, 'https://ror.org/039qtv212 Federal Correctional Institution Schuylkill'),
(7745, 'https://ror.org/039r8xz84', 'en', 1, 'https://ror.org/039r8xz84 Arcadia International'),
(7746, 'https://ror.org/039s6n838', 'no_lang_code', 1, 'https://ror.org/039s6n838 Novartis (United Kingdom)'),
(7747, 'https://ror.org/039sb8791', 'no_lang_code', 1, 'https://ror.org/039sb8791 Aptiv (Germany)'),
(7748, 'https://ror.org/039t93g49', 'de', 1, 'https://ror.org/039t93g49 Forschungsinstitut für Biologischen Landbau Research Institute of Organic Agriculture'),
(7749, 'https://ror.org/039y7c549', 'en', 1, 'https://ror.org/039y7c549 Piedmont Technical College'),
(7750, 'https://ror.org/039yn6r46', 'en', 1, 'https://ror.org/039yn6r46 Linguistic Society of America'),
(7751, 'https://ror.org/03a0ckw61', 'en', 1, 'https://ror.org/03a0ckw61 Long Island Association for AIDS Care'),
(7752, 'https://ror.org/03a1weg76', 'no_lang_code', 1, 'https://ror.org/03a1weg76 AdvR (United States)'),
(7753, 'https://ror.org/03a1yfb59', 'en', 1, 'https://ror.org/03a1yfb59 Lynchburg Family Medicine'),
(7754, 'https://ror.org/03a2tpf77', 'en', 1, 'https://ror.org/03a2tpf77 Pelosi Medical Center'),
(7755, 'https://ror.org/03a3t3y67', 'en', 1, 'https://ror.org/03a3t3y67 Houston Institute for Clinical Research'),
(7756, 'https://ror.org/03a654521', 'no_lang_code', 1, 'https://ror.org/03a654521 Faraday Technology (United States)'),
(7757, 'https://ror.org/03a71g847', 'en', 1, 'https://ror.org/03a71g847 Valley Hospital Medical Center'),
(7758, 'https://ror.org/03a7bpg58', 'en', 1, 'https://ror.org/03a7bpg58 Convención de la Farmacopea de Estados Unidos United States Pharmacopeial Convention'),
(7759, 'https://ror.org/03a8gee76', 'en', 1, 'https://ror.org/03a8gee76 National JALMA Institute for Leprosy & Other Mycobacterial Diseases'),
(7760, 'https://ror.org/03a9ezp59', 'no_lang_code', 1, 'https://ror.org/03a9ezp59 Adrianor'),
(7761, 'https://ror.org/03abz4556', 'no_lang_code', 1, 'https://ror.org/03abz4556 Cortex Pharmaceuticals (United States)'),
(7762, 'https://ror.org/03ac8kh32', 'no_lang_code', 1, 'https://ror.org/03ac8kh32 BioPAL (United States)'),
(7763, 'https://ror.org/03aes2233', 'en', 1, 'https://ror.org/03aes2233 Education Coordinating Council'),
(7764, 'https://ror.org/03af1ns45', 'it', 1, 'https://ror.org/03af1ns45 Ospedale di Circolo di Busto Arsizio'),
(7765, 'https://ror.org/03afd8w19', 'pt', 1, 'https://ror.org/03afd8w19 Secretaria da Saúde'),
(7766, 'https://ror.org/03ah8pc29', 'no_lang_code', 1, 'https://ror.org/03ah8pc29 Hyperion Technologies (Canada)'),
(7767, 'https://ror.org/03ahd9g67', 'en', 1, 'https://ror.org/03ahd9g67 Coker College'),
(7768, 'https://ror.org/03ahxgm89', 'no_lang_code', 1, 'https://ror.org/03ahxgm89 Sommer Materials Research (United States)'),
(7769, 'https://ror.org/03amxdk57', 'no_lang_code', 1, 'https://ror.org/03amxdk57 Capgemini (Netherlands)'),
(7770, 'https://ror.org/03ap5bg83', 'en', 1, 'https://ror.org/03ap5bg83 National Dairy Research Institute राष्ट्रीय डेरी अनुसंधान संस्थान'),
(7771, 'https://ror.org/03apz2q12', 'en', 1, 'https://ror.org/03apz2q12 Institute of Molecular Genetics Федеральное государственное бюджетное учреждение науки Институт молекулярной генетики Российской академии наук'),
(7772, 'https://ror.org/03ate3e03', 'en', 1, 'https://ror.org/03ate3e03 Max Planck Institute for Molecular Genetics Max-Planck-Institut für Molekulare Genetik'),
(7773, 'https://ror.org/03av0zr92', 'no_lang_code', 1, 'https://ror.org/03av0zr92 Germinal (United Kingdom)'),
(7774, 'https://ror.org/03awpb417', 'en', 1, 'https://ror.org/03awpb417 Entomological Society of America'),
(7775, 'https://ror.org/03ax7hn31', 'no_lang_code', 1, 'https://ror.org/03ax7hn31 BHP Laboratories'),
(7776, 'https://ror.org/03ax9j741', 'en', 1, 'https://ror.org/03ax9j741 Council of State and Territorial Epidemiologists'),
(7777, 'https://ror.org/03aygfv62', 'en', 1, 'https://ror.org/03aygfv62 Scotch Whisky Research Institute'),
(7778, 'https://ror.org/03aywkz50', 'en', 1, 'https://ror.org/03aywkz50 Bethel College - Kansas'),
(7779, 'https://ror.org/03az52a93', 'en', 1, 'https://ror.org/03az52a93 Family Medicine Residency of Idaho'),
(7780, 'https://ror.org/03az79194', 'fr', 1, 'https://ror.org/03az79194 Laboratoire National Henri Becquerel'),
(7781, 'https://ror.org/03azk3n24', 'en', 1, 'https://ror.org/03azk3n24 Headache Wellness Center'),
(7782, 'https://ror.org/03b082n16', 'no_lang_code', 1, 'https://ror.org/03b082n16 Genia Photonics (Canada)'),
(7783, 'https://ror.org/03b0k9c14', 'en', 1, 'https://ror.org/03b0k9c14 University Hospital Augsburg Universitätsklinikum Augsburg'),
(7784, 'https://ror.org/03b286288', 'en', 1, 'https://ror.org/03b286288 Baltimore City Community College'),
(7785, 'https://ror.org/03b2h3x98', 'de', 1, 'https://ror.org/03b2h3x98 Paul Gerhardt Diakonie'),
(7786, 'https://ror.org/03b2j2z26', 'no_lang_code', 1, 'https://ror.org/03b2j2z26 Dakota Technologies (United States)'),
(7787, 'https://ror.org/03b41zp34', 'en', 1, 'https://ror.org/03b41zp34 Liberty Science Center'),
(7788, 'https://ror.org/03b436430', 'en', 1, 'https://ror.org/03b436430 Hospital de la Universidad de Utah University of Utah Hospital'),
(7789, 'https://ror.org/03b68pn69', 'no_lang_code', 1, 'https://ror.org/03b68pn69 Epitope (United States)'),
(7790, 'https://ror.org/03b7x6y73', 'it', 1, 'https://ror.org/03b7x6y73 Autorità Portuale di Genova'),
(7791, 'https://ror.org/03bbd8g15', 'en', 1, 'https://ror.org/03bbd8g15 Society of General Internal Medicine'),
(7792, 'https://ror.org/03bcvkf46', 'en', 1, 'https://ror.org/03bcvkf46 Fleet Science Center'),
(7793, 'https://ror.org/03bdeb788', 'no_lang_code', 1, 'https://ror.org/03bdeb788 Community of European Shipyards Associations'),
(7794, 'https://ror.org/03be17v50', 'en', 1, 'https://ror.org/03be17v50 Southern California Alcohol and Drug Programs'),
(7795, 'https://ror.org/03be69002', 'en', 1, 'https://ror.org/03be69002 Finnish Brain Research and Rehabilitation Center Neuron'),
(7796, 'https://ror.org/03bhap014', 'it', 1, 'https://ror.org/03bhap014 Centro Diagnostico Italiano'),
(7797, 'https://ror.org/03bhj4j04', 'en', 1, 'https://ror.org/03bhj4j04 Lyndon State College'),
(7798, 'https://ror.org/03bj7kr91', 'en', 1, 'https://ror.org/03bj7kr91 Boston Public Schools'),
(7799, 'https://ror.org/03bndes49', 'no_lang_code', 1, 'https://ror.org/03bndes49 Thermo Fisher Scientific (United Kingdom)'),
(7800, 'https://ror.org/03bnt5240', 'en', 1, 'https://ror.org/03bnt5240 College of Menominee Nation'),
(7801, 'https://ror.org/03bs18y54', 'no_lang_code', 1, 'https://ror.org/03bs18y54 Infosys (India)'),
(7802, 'https://ror.org/03bs5zb68', 'no_lang_code', 1, 'https://ror.org/03bs5zb68 Tsubame Rosai Hospital'),
(7803, 'https://ror.org/03btasp49', 'en', 1, 'https://ror.org/03btasp49 National Space Centre'),
(7804, 'https://ror.org/03bvhwx18', 'en', 1, 'https://ror.org/03bvhwx18 Association for Women in Science'),
(7805, 'https://ror.org/03bvq6y88', 'en', 1, 'https://ror.org/03bvq6y88 Wagner College'),
(7806, 'https://ror.org/03by7ks57', 'fr', 1, 'https://ror.org/03by7ks57 Cégep André Laurendeau, Cégep andré-laurendeau'),
(7807, 'https://ror.org/03bygaq51', 'no_lang_code', 1, 'https://ror.org/03bygaq51 Takeda (United States) 武田薬品工業株式会社, Takeda Yakuhin Kōgyō kabushiki gaisha'),
(7808, 'https://ror.org/03bz9t645', 'en', 1, 'https://ror.org/03bz9t645 Bedford Institute of Oceanography'),
(7809, 'https://ror.org/03bzqy127', 'en', 1, 'https://ror.org/03bzqy127 Gwinnett Coalition for Health & Human Services'),
(7810, 'https://ror.org/03c09x508', 'es', 1, 'https://ror.org/03c09x508 Ministerio de Salud'),
(7811, 'https://ror.org/03c24n351', 'en', 1, 'https://ror.org/03c24n351 Armed Forces Institute of Pathology'),
(7812, 'https://ror.org/03c3s0k29', 'en', 1, 'https://ror.org/03c3s0k29 Yamaguchi Red Cross Hospital 山口赤十字病院'),
(7813, 'https://ror.org/03c5bjw68', 'no_lang_code', 1, 'https://ror.org/03c5bjw68 BoxModul (Sweden)'),
(7814, 'https://ror.org/03c69q147', 'en', 1, 'https://ror.org/03c69q147 Wake Technical Community College'),
(7815, 'https://ror.org/03cc62s85', 'no_lang_code', 1, 'https://ror.org/03cc62s85 Scottish Water (United Kingdom)'),
(7816, 'https://ror.org/03cd6bd87', 'en', 1, 'https://ror.org/03cd6bd87 South Carolina Research Authority'),
(7817, 'https://ror.org/03cegwq60', 'en', 1, 'https://ror.org/03cegwq60 McMaster Children''s Hospital'),
(7818, 'https://ror.org/03cfg5z67', 'en', 1, 'https://ror.org/03cfg5z67 Florida Department of Children and Families'),
(7819, 'https://ror.org/03cfgct89', 'en', 1, 'https://ror.org/03cfgct89 Women in Engineering ProActive Network'),
(7820, 'https://ror.org/03cfsae23', 'no_lang_code', 1, 'https://ror.org/03cfsae23 QR Pharma (United States)'),
(7821, 'https://ror.org/03ckh6215', 'en', 1, 'https://ror.org/03ckh6215 National Institute of Genetic Engineering and Biotechnology پژوهشگاه ملي مهندسي ژنتيك و زيست فناوري'),
(7822, 'https://ror.org/03cks4g33', 'en', 1, 'https://ror.org/03cks4g33 Haymarket Center'),
(7823, 'https://ror.org/03cmtga52', 'no_lang_code', 1, 'https://ror.org/03cmtga52 IB Innovation Consortium (Italy)'),
(7824, 'https://ror.org/03cpeth56', 'no_lang_code', 1, 'https://ror.org/03cpeth56 Costain (United Kingdom)'),
(7825, 'https://ror.org/03crdwy95', 'en', 1, 'https://ror.org/03crdwy95 Greater Manchester Police'),
(7826, 'https://ror.org/03csd5507', 'no_lang_code', 1, 'https://ror.org/03csd5507 Morgan Stanley (United Kingdom)'),
(7827, 'https://ror.org/03cth7012', 'en', 1, 'https://ror.org/03cth7012 Bronx Veterans Medical Research Foundation'),
(7828, 'https://ror.org/03cw63y62', 'en', 1, 'https://ror.org/03cw63y62 Women''s College Hospital'),
(7829, 'https://ror.org/03cy2tx68', 'en', 1, 'https://ror.org/03cy2tx68 Black Sea Regional Energy Centre'),
(7830, 'https://ror.org/03d0hdn85', 'en', 1, 'https://ror.org/03d0hdn85 Istanbul Eye Hospital İstanbul Göz Hastanesi'),
(7831, 'https://ror.org/03d33vh19', 'no_lang_code', 1, 'https://ror.org/03d33vh19 3E (Belgium)'),
(7832, 'https://ror.org/03d4tjj21', 'no_lang_code', 1, 'https://ror.org/03d4tjj21 Vivo Biosciences (United States)'),
(7833, 'https://ror.org/03d507062', 'no_lang_code', 1, 'https://ror.org/03d507062 Walsh Group'),
(7834, 'https://ror.org/03d587e82', 'en', 1, 'https://ror.org/03d587e82 Estonian E Health Foundation'),
(7835, 'https://ror.org/03d5v2a18', 'no_lang_code', 1, 'https://ror.org/03d5v2a18 CanAm Bioresearch (Canada)'),
(7836, 'https://ror.org/03da3g825', 'no_lang_code', 1, 'https://ror.org/03da3g825 Shiseido Group (Japan) 株式会社資生堂'),
(7837, 'https://ror.org/03dakdm13', 'en', 1, 'https://ror.org/03dakdm13 St. John''s College'),
(7838, 'https://ror.org/03dbbn946', 'no_lang_code', 1, 'https://ror.org/03dbbn946 HaCon (Germany)'),
(7839, 'https://ror.org/03dbjaj38', 'no_lang_code', 1, 'https://ror.org/03dbjaj38 ArchieMD (United States)'),
(7840, 'https://ror.org/03dc7cm27', 'no_lang_code', 1, 'https://ror.org/03dc7cm27 XOMA (United States)'),
(7841, 'https://ror.org/03dcs5c38', 'no_lang_code', 1, 'https://ror.org/03dcs5c38 TimeDomain CVD (United States)'),
(7842, 'https://ror.org/03ddan440', 'no_lang_code', 1, 'https://ror.org/03ddan440 Arthur D. Little (United States)'),
(7843, 'https://ror.org/03ddbnh33', 'no_lang_code', 1, 'https://ror.org/03ddbnh33 Qinetiq (United States)'),
(7844, 'https://ror.org/03dfzxf19', 'no_lang_code', 1, 'https://ror.org/03dfzxf19 Agilent Technologies (United Kingdom)'),
(7845, 'https://ror.org/03dnydg98', 'no_lang_code', 1, 'https://ror.org/03dnydg98 VirRx (United States)'),
(7846, 'https://ror.org/03dpjp116', 'en', 1, 'https://ror.org/03dpjp116 Nagano College of Nursing 長野県看護大学'),
(7847, 'https://ror.org/03dqpq202', 'no_lang_code', 1, 'https://ror.org/03dqpq202 MPI Research (United States)'),
(7848, 'https://ror.org/03drznb24', 'en', 1, 'https://ror.org/03drznb24 Winter Haven Hospital'),
(7849, 'https://ror.org/03dtejd64', 'en', 1, 'https://ror.org/03dtejd64 Fraunhofer USA Center for Molecular Biotechnology'),
(7850, 'https://ror.org/03dwhj404', 'no_lang_code', 1, 'https://ror.org/03dwhj404 Agenus (United States)'),
(7851, 'https://ror.org/03dx0rh63', 'no_lang_code', 1, 'https://ror.org/03dx0rh63 Brussels Intercommunal Transport Company Maatschappij voor het Intercommunaal Vervoer te Brussel Société des Transports Intercommunaux de Bruxelles'),
(7852, 'https://ror.org/03dy10t98', 'en', 1, 'https://ror.org/03dy10t98 National Geophysical Research Institute राष्ट्रीय भूभौतिकीय अनुसंधान संस्थान జాతీయ భూభౌతిక పరిశోధనా సంస్థ നാഷണൽ ജിയോഫിസിക്കൽ റിസർച്ച് ഇൻസ്റ്റിറ്റ്യൂട്ട്,ഹൈദരാബാദ്'),
(7853, 'https://ror.org/03dywwh47', 'es', 1, 'https://ror.org/03dywwh47 Instituto de la Visión'),
(7854, 'https://ror.org/03dzg6f89', 'en', 1, 'https://ror.org/03dzg6f89 Bevill State Community College'),
(7855, 'https://ror.org/03e04g978', 'en', 1, 'https://ror.org/03e04g978 Tanzania Commission for Science and Technology Tume ya Sayansi na Teknolojia Tanzania'),
(7856, 'https://ror.org/03e0mxz52', 'no_lang_code', 1, 'https://ror.org/03e0mxz52 Intelligent Energy (United Kingdom)'),
(7857, 'https://ror.org/03e0t3214', 'no_lang_code', 1, 'https://ror.org/03e0t3214 Materials and Systems Research (United States)'),
(7858, 'https://ror.org/03e17k064', 'en', 1, 'https://ror.org/03e17k064 Saint Louis Science Center'),
(7859, 'https://ror.org/03e278q38', 'no_lang_code', 1, 'https://ror.org/03e278q38 Vinci (France)'),
(7860, 'https://ror.org/03e59a529', 'en', 1, 'https://ror.org/03e59a529 Molecular Cardiology and Neuromuscular Institute'),
(7861, 'https://ror.org/03e5aen17', 'no_lang_code', 1, 'https://ror.org/03e5aen17 ProteoSys (Germany)'),
(7862, 'https://ror.org/03e5eem51', 'en', 1, 'https://ror.org/03e5eem51 Budker Institute of Nuclear Physics Институт ядерной физики'),
(7863, 'https://ror.org/03e7xy909', 'en', 1, 'https://ror.org/03e7xy909 People’s University'),
(7864, 'https://ror.org/03e8gpx64', 'no_lang_code', 1, 'https://ror.org/03e8gpx64 MetroLaser (United States)'),
(7865, 'https://ror.org/03e93v570', 'no_lang_code', 1, 'https://ror.org/03e93v570 BIO Intelligence Service (France)'),
(7866, 'https://ror.org/03ef7m045', 'no_lang_code', 1, 'https://ror.org/03ef7m045 Bergamo Technologies (Poland)'),
(7867, 'https://ror.org/03egepy41', 'no_lang_code', 1, 'https://ror.org/03egepy41 DMetrix (United States)'),
(7868, 'https://ror.org/03eh6tj73', 'en', 1, 'https://ror.org/03eh6tj73 Guangxi Veterinary Research Institute'),
(7869, 'https://ror.org/03ehegt04', 'en', 1, 'https://ror.org/03ehegt04 Wisconsin Department of Agriculture Trade and Consumer Protection'),
(7870, 'https://ror.org/03ehse820', 'da', 1, 'https://ror.org/03ehse820 Dansk Sundhedsinstitut, Dansk Sygehus Institut'),
(7871, 'https://ror.org/03ej8cj80', 'en', 1, 'https://ror.org/03ej8cj80 Quincy College'),
(7872, 'https://ror.org/03em9pc54', 'en', 1, 'https://ror.org/03em9pc54 Iowa Central Community College'),
(7873, 'https://ror.org/03end3932', 'no_lang_code', 1, 'https://ror.org/03end3932 GGG (France)'),
(7874, 'https://ror.org/03ep7eq57', 'no_lang_code', 1, 'https://ror.org/03ep7eq57 iQmetrix (Canada)'),
(7875, 'https://ror.org/03epbnb34', 'no_lang_code', 1, 'https://ror.org/03epbnb34 AquaTT (Ireland)'),
(7876, 'https://ror.org/03epr9q14', 'en', 1, 'https://ror.org/03epr9q14 Center for Culture and Experience Economy'),
(7877, 'https://ror.org/03eqc1p67', 'fr', 1, 'https://ror.org/03eqc1p67 Clinique de la Défense'),
(7878, 'https://ror.org/03eqttr49', 'en', 1, 'https://ror.org/03eqttr49 Research Triangle Park Foundation'),
(7879, 'https://ror.org/03er2hr05', 'no_lang_code', 1, 'https://ror.org/03er2hr05 Critical Software (Portugal)'),
(7880, 'https://ror.org/03erxwz83', 'no_lang_code', 1, 'https://ror.org/03erxwz83 Syncrotronics Corporation (United States)'),
(7881, 'https://ror.org/03et1ay56', 'en', 1, 'https://ror.org/03et1ay56 Fondazione Rosselli Rosselli Foundation'),
(7882, 'https://ror.org/03etema57', 'en', 1, 'https://ror.org/03etema57 Association for Institutional Research'),
(7883, 'https://ror.org/03etg4523', 'no_lang_code', 1, 'https://ror.org/03etg4523 Teva Pharmaceuticals (United States)'),
(7884, 'https://ror.org/03etmv771', 'no_lang_code', 1, 'https://ror.org/03etmv771 LightBridge Healthcare Research (United States)'),
(7885, 'https://ror.org/03evkbw14', 'es', 1, 'https://ror.org/03evkbw14 Corporación para Investigaciones Biológicas'),
(7886, 'https://ror.org/03exvmb50', 'no_lang_code', 1, 'https://ror.org/03exvmb50 Neocera (United States)'),
(7887, 'https://ror.org/03eykgw84', 'no_lang_code', 1, 'https://ror.org/03eykgw84 Fujirebio (Japan) 富士レビオ株式会社'),
(7888, 'https://ror.org/03ez2en98', 'en', 1, 'https://ror.org/03ez2en98 Vaccine & Gene Therapy Institute of Florida'),
(7889, 'https://ror.org/03ezapm74', 'es', 1, 'https://ror.org/03ezapm74 Fundación Santa Fe de Bogotá'),
(7890, 'https://ror.org/03f0b2d64', 'no_lang_code', 1, 'https://ror.org/03f0b2d64 Evans Analytical Group (United States)'),
(7891, 'https://ror.org/03f1nf684', 'no_lang_code', 1, 'https://ror.org/03f1nf684 Fillauer (United States)'),
(7892, 'https://ror.org/03f47x024', 'en', 1, 'https://ror.org/03f47x024 ECRI Institute'),
(7893, 'https://ror.org/03f61zm76', 'en', 1, 'https://ror.org/03f61zm76 Det Nationale Forskningscenter for Arbejdsmiljø National Research Centre for the Working Environment'),
(7894, 'https://ror.org/03f6d5g58', 'no_lang_code', 1, 'https://ror.org/03f6d5g58 Vita Group (United Kingdom)'),
(7895, 'https://ror.org/03f8h8g06', 'en', 1, 'https://ror.org/03f8h8g06 Basic NWFL'),
(7896, 'https://ror.org/03f98n803', 'en', 1, 'https://ror.org/03f98n803 Canadian Institute for Energy Training Institut Canadien de Formation en Energie'),
(7897, 'https://ror.org/03fa0tr49', 'no_lang_code', 1, 'https://ror.org/03fa0tr49 A&G Pharmaceutical (United States)'),
(7898, 'https://ror.org/03fag5224', 'en', 1, 'https://ror.org/03fag5224 West Bengal University of Health Sciences पश्चिम बंगाल स्वास्थ्य विज्ञान विश्वविद्यालय পশ্চিমবঙ্গ স্বাস্থ্যবিজ্ঞান বিশ্ববিদ্যালয়'),
(7899, 'https://ror.org/03fb4ef52', 'en', 1, 'https://ror.org/03fb4ef52 Gov2u'),
(7900, 'https://ror.org/03fbqtm75', 'no_lang_code', 1, 'https://ror.org/03fbqtm75 Dassault Systèmes (United States)'),
(7901, 'https://ror.org/03fd07264', 'no_lang_code', 1, 'https://ror.org/03fd07264 Lake Shore Cryotronics (United States)'),
(7902, 'https://ror.org/03fef0h61', 'no_lang_code', 1, 'https://ror.org/03fef0h61 Luminex (United States)'),
(7903, 'https://ror.org/03fftr154', 'es', 1, 'https://ror.org/03fftr154 Instituto Ramón y Cajal de Investigación Sanitaria'),
(7904, 'https://ror.org/03fkdmb14', 'no_lang_code', 1, 'https://ror.org/03fkdmb14 Beneq (Finland)'),
(7905, 'https://ror.org/03fmvqd28', 'no_lang_code', 1, 'https://ror.org/03fmvqd28 BioMarin (United States)'),
(7906, 'https://ror.org/03fwae819', 'en', 1, 'https://ror.org/03fwae819 Canadian AIDS Treatment Information Exchange'),
(7907, 'https://ror.org/03fz0tx04', 'no_lang_code', 1, 'https://ror.org/03fz0tx04 ProteoTech (United States)'),
(7908, 'https://ror.org/03g1zvc89', 'en', 1, 'https://ror.org/03g1zvc89 Valley Baptist Medical Center'),
(7909, 'https://ror.org/03g4bqt50', 'no_lang_code', 1, 'https://ror.org/03g4bqt50 Sigmovir Biosystems (United States)'),
(7910, 'https://ror.org/03g4qd502', 'en', 1, 'https://ror.org/03g4qd502 Brodarski Institute'),
(7911, 'https://ror.org/03g6g7j35', 'no_lang_code', 1, 'https://ror.org/03g6g7j35 Global Graphics (United Kingdom)'),
(7912, 'https://ror.org/03g75kz98', 'no_lang_code', 1, 'https://ror.org/03g75kz98 PricewaterhouseCoopers (United States)'),
(7913, 'https://ror.org/03g7c9017', 'no_lang_code', 1, 'https://ror.org/03g7c9017 Berliner Verkehrsbetriebe (Germany)'),
(7914, 'https://ror.org/03g7j7v29', 'no_lang_code', 1, 'https://ror.org/03g7j7v29 Tascon Industries (United States)'),
(7915, 'https://ror.org/03g7wzf21', 'no_lang_code', 1, 'https://ror.org/03g7wzf21 Emergent BioSolutions (Canada)'),
(7916, 'https://ror.org/03g99t434', 'en', 1, 'https://ror.org/03g99t434 Casa Esperanza'),
(7917, 'https://ror.org/03gam8m83', 'no_lang_code', 1, 'https://ror.org/03gam8m83 Engedi Science (United Kingdom)'),
(7918, 'https://ror.org/03gcet659', 'no_lang_code', 1, 'https://ror.org/03gcet659 Cambridge Econometrics (United Kingdom)'),
(7919, 'https://ror.org/03gcg7j68', 'en', 1, 'https://ror.org/03gcg7j68 Cincinnati Sportsmedicine and Orthopaedic Center'),
(7920, 'https://ror.org/03gdmdz23', 'no_lang_code', 1, 'https://ror.org/03gdmdz23 Optimum Technologies (United States)'),
(7921, 'https://ror.org/03gf87416', 'no_lang_code', 1, 'https://ror.org/03gf87416 Advanced MicroLabs (United States)'),
(7922, 'https://ror.org/03gk3wr33', 'no_lang_code', 1, 'https://ror.org/03gk3wr33 Biostruxs (United States)'),
(7923, 'https://ror.org/03gkbdq83', 'en', 1, 'https://ror.org/03gkbdq83 Education and Research Institute'),
(7924, 'https://ror.org/03gkzwc92', 'no_lang_code', 1, 'https://ror.org/03gkzwc92 Ancitel (Italy)'),
(7925, 'https://ror.org/03gm8jc79', 'no_lang_code', 1, 'https://ror.org/03gm8jc79 Mabvax Therapeutics (United States)'),
(7926, 'https://ror.org/03gmf8x48', 'en', 1, 'https://ror.org/03gmf8x48 National Conference of State Legislatures'),
(7927, 'https://ror.org/03gphk318', 'no_lang_code', 1, 'https://ror.org/03gphk318 Tetramer Technologies (United States)'),
(7928, 'https://ror.org/03gpw5a44', 'fr', 1, 'https://ror.org/03gpw5a44 Centre Orthopédique Santy'),
(7929, 'https://ror.org/03grsxg62', 'no_lang_code', 1, 'https://ror.org/03grsxg62 Computational Physics (United States)'),
(7930, 'https://ror.org/03gsa2724', 'en', 1, 'https://ror.org/03gsa2724 Texas Lutheran University'),
(7931, 'https://ror.org/03gsmwj46', 'no_lang_code', 1, 'https://ror.org/03gsmwj46 Market Intelligence Strategy Centre (Australia)'),
(7932, 'https://ror.org/03gt88b08', 'en', 1, 'https://ror.org/03gt88b08 Institute of Plant Physiology and Genetics Институт по физиология на растенията и генетика'),
(7933, 'https://ror.org/03gw72402', 'no_lang_code', 1, 'https://ror.org/03gw72402 Socratech (United States)'),
(7934, 'https://ror.org/03gx6zj11', 'es', 1, 'https://ror.org/03gx6zj11 Instituto Nacional de Salud'),
(7935, 'https://ror.org/03gzjnf17', 'no_lang_code', 1, 'https://ror.org/03gzjnf17 Zywie (United States)'),
(7936, 'https://ror.org/03gzw3461', 'en', 1, 'https://ror.org/03gzw3461 Illinois Department of Human Services'),
(7937, 'https://ror.org/03gzyhr79', 'no_lang_code', 1, 'https://ror.org/03gzyhr79 CNet (Sweden)'),
(7938, 'https://ror.org/03h7x4635', 'no_lang_code', 1, 'https://ror.org/03h7x4635 L3Harris (Canada)'),
(7939, 'https://ror.org/03h9w6s56', 'no_lang_code', 1, 'https://ror.org/03h9w6s56 OptoSonics (United States)'),
(7940, 'https://ror.org/03hdhbn34', 'no_lang_code', 1, 'https://ror.org/03hdhbn34 DNA Software (United States)'),
(7941, 'https://ror.org/03hdkx955', 'no_lang_code', 1, 'https://ror.org/03hdkx955 Medicago (Canada)'),
(7942, 'https://ror.org/03he51f03', 'no_lang_code', 1, 'https://ror.org/03he51f03 A2A (Italy)'),
(7943, 'https://ror.org/03heckw12', 'no_lang_code', 1, 'https://ror.org/03heckw12 Response Biomedical (Canada)'),
(7944, 'https://ror.org/03hgang94', 'en', 1, 'https://ror.org/03hgang94 Developmental Studies Center'),
(7945, 'https://ror.org/03hgf4f46', 'no_lang_code', 1, 'https://ror.org/03hgf4f46 Conecta'),
(7946, 'https://ror.org/03hggzq81', 'en', 1, 'https://ror.org/03hggzq81 Didi Hirsch Mental Health Services'),
(7947, 'https://ror.org/03hj3bw29', 'no_lang_code', 1, 'https://ror.org/03hj3bw29 H & N Instruments (United States)'),
(7948, 'https://ror.org/03hmdtw84', 'no_lang_code', 1, 'https://ror.org/03hmdtw84 CPS Research'),
(7949, 'https://ror.org/03hmj3984', 'no_lang_code', 1, 'https://ror.org/03hmj3984 Ambiente Risorse Sviluppo Environment, Resources and Development'),
(7950, 'https://ror.org/03hnz5h47', 'no_lang_code', 1, 'https://ror.org/03hnz5h47 Forecasting International (United States)'),
(7951, 'https://ror.org/03hp55s21', 'no_lang_code', 1, 'https://ror.org/03hp55s21 Mircom Technologies (Canada)'),
(7952, 'https://ror.org/03hp60511', 'en', 1, 'https://ror.org/03hp60511 New North Citizens Council'),
(7953, 'https://ror.org/03hp93w41', 'no_lang_code', 1, 'https://ror.org/03hp93w41 Aegera Therapeutics (Canada)'),
(7954, 'https://ror.org/03hpmwj60', 'en', 1, 'https://ror.org/03hpmwj60 Health and Hospital Corporation'),
(7955, 'https://ror.org/03hq46410', 'pt', 1, 'https://ror.org/03hq46410 Instituto Nacional de Saúde'),
(7956, 'https://ror.org/03hqq4p77', 'en', 1, 'https://ror.org/03hqq4p77 Society for Public Health Education'),
(7957, 'https://ror.org/03hs0j596', 'no_lang_code', 1, 'https://ror.org/03hs0j596 Bord Soláthair an Leictreacha Electricity Supply Board (Ireland)'),
(7958, 'https://ror.org/03hsbk852', 'no_lang_code', 1, 'https://ror.org/03hsbk852 ASCO Industries (Belgium)'),
(7959, 'https://ror.org/03hsk1q51', 'en', 1, 'https://ror.org/03hsk1q51 National Coalition of STD Directors'),
(7960, 'https://ror.org/03htsdy94', 'fr', 1, 'https://ror.org/03htsdy94 Centre Hospitalier de la Côte Basque'),
(7961, 'https://ror.org/03htten57', 'no_lang_code', 1, 'https://ror.org/03htten57 Westinghouse Electric (Sweden)'),
(7962, 'https://ror.org/03hvygv29', 'en', 1, 'https://ror.org/03hvygv29 Quality of Life Research Center'),
(7963, 'https://ror.org/03hw58c96', 'no_lang_code', 1, 'https://ror.org/03hw58c96 Scott Sabolich Prosthetics And Research (United States)'),
(7964, 'https://ror.org/03hwje554', 'en', 1, 'https://ror.org/03hwje554 Sheffield Kidney Institute'),
(7965, 'https://ror.org/03hxefz97', 'no_lang_code', 1, 'https://ror.org/03hxefz97 ViewPlus (United States)'),
(7966, 'https://ror.org/03hy0tb65', 'no_lang_code', 1, 'https://ror.org/03hy0tb65 ASSIST Software (Romania)'),
(7967, 