<?php

/**
 * This file is a part of horstoeko/orderx.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\orderx\codelists;

/**
 * Class representing the Charge codes
 *
 * @category Order-X
 * @package  Order-X
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/orderx
 */
class OrderChargeCodes
{
    /**
     * Advertising
     */
    const ADVERTISING = "AA";

    /**
     * Telecommunication
     */
    const TELECOMMUNICATION = "AAA";

    /**
     * Technical modification
     */
    const TECHNICAL_MODIFICATION = "AAC";

    /**
     * Job-order production
     */
    const JOBORDER_PRODUCTION = "AAD";

    /**
     * Outlays
     */
    const OUTLAYS = "AAE";

    /**
     * Off-premises
     */
    const OFFPREMISES = "AAF";

    /**
     * Additional processing
     */
    const ADDITIONAL_PROCESSING = "AAH";

    /**
     * Attesting
     */
    const ATTESTING = "AAI";

    /**
     * Acceptance
     */
    const ACCEPTANCE = "AAS";

    /**
     * Rush delivery
     */
    const RUSH_DELIVERY = "AAT";

    /**
     * Special construction
     */
    const SPECIAL_CONSTRUCTION = "AAV";

    /**
     * Airport facilities
     */
    const AIRPORT_FACILITIES = "AAY";

    /**
     * Concession
     */
    const CONCESSION = "AAZ";

    /**
     * Compulsory storage
     */
    const COMPULSORY_STORAGE = "ABA";

    /**
     * Fuel removal
     */
    const FUEL_REMOVAL = "ABB";

    /**
     * Into plane
     */
    const INTO_PLANE = "ABC";

    /**
     * Overtime
     */
    const OVERTIME = "ABD";

    /**
     * Tooling
     */
    const TOOLING = "ABF";

    /**
     * Miscellaneous
     */
    const MISCELLANEOUS = "ABK";

    /**
     * Additional packaging
     */
    const ADDITIONAL_PACKAGING = "ABL";

    /**
     * Dunnage
     */
    const DUNNAGE = "ABN";

    /**
     * Containerisation
     */
    const CONTAINERISATION = "ABR";

    /**
     * Carton packing
     */
    const CARTON_PACKING = "ABS";

    /**
     * Hessian wrapped
     */
    const HESSIAN_WRAPPED = "ABT";

    /**
     * Polyethylene wrap packing
     */
    const POLYETHYLENE_WRAP_PACKING = "ABU";

    /**
     * Miscellaneous treatment
     */
    const MISCELLANEOUS_TREATMENT = "ACF";

    /**
     * Enamelling treatment
     */
    const ENAMELLING_TREATMENT = "ACG";

    /**
     * Heat treatment
     */
    const HEAT_TREATMENT = "ACH";

    /**
     * Plating treatment
     */
    const PLATING_TREATMENT = "ACI";

    /**
     * Painting
     */
    const PAINTING = "ACJ";

    /**
     * Polishing
     */
    const POLISHING = "ACK";

    /**
     * Priming
     */
    const PRIMING = "ACL";

    /**
     * Preservation treatment
     */
    const PRESERVATION_TREATMENT = "ACM";

    /**
     * Fitting
     */
    const FITTING = "ACS";

    /**
     * Consolidation
     */
    const CONSOLIDATION = "ADC";

    /**
     * Bill of lading
     */
    const BILL_OF_LADING = "ADE";

    /**
     * Airbag
     */
    const AIRBAG = "ADJ";

    /**
     * Transfer
     */
    const TRANSFER = "ADK";

    /**
     * Slipsheet
     */
    const SLIPSHEET = "ADL";

    /**
     * Binding
     */
    const BINDING = "ADM";

    /**
     * Repair or replacement of broken returnable package
     */
    const REPAIR_OR_REPLACEMENT_OF_BROKEN_RETURNABLE_PACKAGE = "ADN";

    /**
     * Efficient logistics
     */
    const EFFICIENT_LOGISTICS = "ADO";

    /**
     * Merchandising
     */
    const MERCHANDISING = "ADP";

    /**
     * Product mix
     */
    const PRODUCT_MIX = "ADQ";

    /**
     * Other services
     */
    const OTHER_SERVICES = "ADR";

    /**
     * Pick-up
     */
    const PICKUP = "ADT";

    /**
     * Chronic illness
     */
    const CHRONIC_ILLNESS = "ADW";

    /**
     * New product introduction
     */
    const NEW_PRODUCT_INTRODUCTION = "ADY";

    /**
     * Direct delivery
     */
    const DIRECT_DELIVERY = "ADZ";

    /**
     * Diversion
     */
    const DIVERSION = "AEA";

    /**
     * Disconnect
     */
    const DISCONNECT = "AEB";

    /**
     * Distribution
     */
    const DISTRIBUTION = "AEC";

    /**
     * Handling of hazardous cargo
     */
    const HANDLING_OF_HAZARDOUS_CARGO = "AED";

    /**
     * Rents and leases
     */
    const RENTS_AND_LEASES = "AEF";

    /**
     * Location differential
     */
    const LOCATION_DIFFERENTIAL = "AEH";

    /**
     * Aircraft refueling
     */
    const AIRCRAFT_REFUELING = "AEI";

    /**
     * Fuel shipped into storage
     */
    const FUEL_SHIPPED_INTO_STORAGE = "AEJ";

    /**
     * Cash on delivery
     */
    const CASH_ON_DELIVERY = "AEK";

    /**
     * Small order processing service
     */
    const SMALL_ORDER_PROCESSING_SERVICE = "AEL";

    /**
     * Clerical or administrative services
     */
    const CLERICAL_OR_ADMINISTRATIVE_SERVICES = "AEM";

    /**
     * Guarantee
     */
    const GUARANTEE = "AEN";

    /**
     * Collection and recycling
     */
    const COLLECTION_AND_RECYCLING = "AEO";

    /**
     * Copyright fee collection
     */
    const COPYRIGHT_FEE_COLLECTION = "AEP";

    /**
     * Veterinary inspection service
     */
    const VETERINARY_INSPECTION_SERVICE = "AES";

    /**
     * Pensioner service
     */
    const PENSIONER_SERVICE = "AET";

    /**
     * Medicine free pass holder
     */
    const MEDICINE_FREE_PASS_HOLDER = "AEU";

    /**
     * Environmental protection service
     */
    const ENVIRONMENTAL_PROTECTION_SERVICE = "AEV";

    /**
     * Environmental clean-up service
     */
    const ENVIRONMENTAL_CLEANUP_SERVICE = "AEW";

    /**
     * National cheque processing service outside account area
     */
    const NATIONAL_CHEQUE_PROCESSING_SERVICE_OUTSIDE_ACCOUNT_AREA = "AEX";

    /**
     * National payment service outside account area
     */
    const NATIONAL_PAYMENT_SERVICE_OUTSIDE_ACCOUNT_AREA = "AEY";

    /**
     * National payment service within account area
     */
    const NATIONAL_PAYMENT_SERVICE_WITHIN_ACCOUNT_AREA = "AEZ";

    /**
     * Adjustments
     */
    const ADJUSTMENTS = "AJ";

    /**
     * Authentication
     */
    const AUTHENTICATION = "AU";

    /**
     * Cataloguing
     */
    const CATALOGUING = "CA";

    /**
     * Cartage
     */
    const CARTAGE = "CAB";

    /**
     * Certification
     */
    const CERTIFICATION = "CAD";

    /**
     * Certificate of conformance
     */
    const CERTIFICATE_OF_CONFORMANCE = "CAE";

    /**
     * Certificate of origin
     */
    const CERTIFICATE_OF_ORIGIN = "CAF";

    /**
     * Cutting
     */
    const CUTTING = "CAI";

    /**
     * Consular service
     */
    const CONSULAR_SERVICE = "CAJ";

    /**
     * Customer collection
     */
    const CUSTOMER_COLLECTION = "CAK";

    /**
     * Payroll payment service
     */
    const PAYROLL_PAYMENT_SERVICE = "CAL";

    /**
     * Cash transportation
     */
    const CASH_TRANSPORTATION = "CAM";

    /**
     * Home banking service
     */
    const HOME_BANKING_SERVICE = "CAN";

    /**
     * Bilateral agreement service
     */
    const BILATERAL_AGREEMENT_SERVICE = "CAO";

    /**
     * Insurance brokerage service
     */
    const INSURANCE_BROKERAGE_SERVICE = "CAP";

    /**
     * Cheque generation
     */
    const CHEQUE_GENERATION = "CAQ";

    /**
     * Preferential merchandising location
     */
    const PREFERENTIAL_MERCHANDISING_LOCATION = "CAR";

    /**
     * Crane
     */
    const CRANE = "CAS";

    /**
     * Special colour service
     */
    const SPECIAL_COLOUR_SERVICE = "CAT";

    /**
     * Sorting
     */
    const SORTING = "CAU";

    /**
     * Battery collection and recycling
     */
    const BATTERY_COLLECTION_AND_RECYCLING = "CAV";

    /**
     * Product take back fee
     */
    const PRODUCT_TAKE_BACK_FEE = "CAW";

    /**
     * Quality control released
     */
    const QUALITY_CONTROL_RELEASED = "CAX";

    /**
     * Quality control held
     */
    const QUALITY_CONTROL_HELD = "CAY";

    /**
     * Quality control embargo
     */
    const QUALITY_CONTROL_EMBARGO = "CAZ";

    /**
     * Car loading
     */
    const CAR_LOADING = "CD";

    /**
     * Cleaning
     */
    const CLEANING = "CG";

    /**
     * Cigarette stamping
     */
    const CIGARETTE_STAMPING = "CS";

    /**
     * Count and recount
     */
    const COUNT_AND_RECOUNT = "CT";

    /**
     * Layout/design
     */
    const LAYOUT_DESIGN = "DAB";

    /**
     * Assortment allowance
     */
    const ASSORTMENT_ALLOWANCE = "DAC";

    /**
     * Driver assigned unloading
     */
    const DRIVER_ASSIGNED_UNLOADING = "DAD";

    /**
     * Debtor bound
     */
    const DEBTOR_BOUND = "DAF";

    /**
     * Dealer allowance
     */
    const DEALER_ALLOWANCE = "DAG";

    /**
     * Allowance transferable to the consumer
     */
    const ALLOWANCE_TRANSFERABLE_TO_THE_CONSUMER = "DAH";

    /**
     * Growth of business
     */
    const GROWTH_OF_BUSINESS = "DAI";

    /**
     * Introduction allowance
     */
    const INTRODUCTION_ALLOWANCE = "DAJ";

    /**
     * Multi-buy promotion
     */
    const MULTIBUY_PROMOTION = "DAK";

    /**
     * Partnership
     */
    const PARTNERSHIP = "DAL";

    /**
     * Return handling
     */
    const RETURN_HANDLING = "DAM";

    /**
     * Minimum order not fulfilled charge
     */
    const MINIMUM_ORDER_NOT_FULFILLED_CHARGE = "DAN";

    /**
     * Point of sales threshold allowance
     */
    const POINT_OF_SALES_THRESHOLD_ALLOWANCE = "DAO";

    /**
     * Wholesaling discount
     */
    const WHOLESALING_DISCOUNT = "DAP";

    /**
     * Documentary credits transfer commission
     */
    const DOCUMENTARY_CREDITS_TRANSFER_COMMISSION = "DAQ";

    /**
     * Delivery
     */
    const DELIVERY = "DL";

    /**
     * Engraving
     */
    const ENGRAVING = "EG";

    /**
     * Expediting
     */
    const EXPEDITING = "EP";

    /**
     * Exchange rate guarantee
     */
    const EXCHANGE_RATE_GUARANTEE = "ER";

    /**
     * Fabrication
     */
    const FABRICATION = "FAA";

    /**
     * Freight equalization
     */
    const FREIGHT_EQUALIZATION = "FAB";

    /**
     * Freight extraordinary handling
     */
    const FREIGHT_EXTRAORDINARY_HANDLING = "FAC";

    /**
     * Freight service
     */
    const FREIGHT_SERVICE = "FC";

    /**
     * Filling/handling
     */
    const FILLING_HANDLING = "FH";

    /**
     * Financing
     */
    const FINANCING = "FI";

    /**
     * Grinding
     */
    const GRINDING = "GAA";

    /**
     * Hose
     */
    const HOSE = "HAA";

    /**
     * Handling
     */
    const HANDLING = "HD";

    /**
     * Hoisting and hauling
     */
    const HOISTING_AND_HAULING = "HH";

    /**
     * Installation
     */
    const INSTALLATION = "IAA";

    /**
     * Installation and warranty
     */
    const INSTALLATION_AND_WARRANTY = "IAB";

    /**
     * Inside delivery
     */
    const INSIDE_DELIVERY = "ID";

    /**
     * Inspection
     */
    const INSPECTION = "IF";

    /**
     * Installation and training
     */
    const INSTALLATION_AND_TRAINING = "IR";

    /**
     * Invoicing
     */
    const INVOICING = "IS";

    /**
     * Koshering
     */
    const KOSHERING = "KO";

    /**
     * Carrier count
     */
    const CARRIER_COUNT = "L1";

    /**
     * Labelling
     */
    const LABELLING = "LA";

    /**
     * Labour
     */
    const LABOUR = "LAA";

    /**
     * Repair and return
     */
    const REPAIR_AND_RETURN = "LAB";

    /**
     * Legalisation
     */
    const LEGALISATION = "LF";

    /**
     * Mounting
     */
    const MOUNTING = "MAE";

    /**
     * Mail invoice
     */
    const MAIL_INVOICE = "MI";

    /**
     * Mail invoice to each location
     */
    const MAIL_INVOICE_TO_EACH_LOCATION = "ML";

    /**
     * Non-returnable containers
     */
    const NONRETURNABLE_CONTAINERS = "NAA";

    /**
     * Outside cable connectors
     */
    const OUTSIDE_CABLE_CONNECTORS = "OA";

    /**
     * Invoice with shipment
     */
    const INVOICE_WITH_SHIPMENT = "PA";

    /**
     * Phosphatizing (steel treatment)
     */
    const PHOSPHATIZING_STEEL_TREATMENT = "PAA";

    /**
     * Packing
     */
    const PACKING = "PC";

    /**
     * Palletizing
     */
    const PALLETIZING = "PL";

    /**
     * Repacking
     */
    const REPACKING = "RAB";

    /**
     * Repair
     */
    const REPAIR = "RAC";

    /**
     * Returnable container
     */
    const RETURNABLE_CONTAINER = "RAD";

    /**
     * Restocking
     */
    const RESTOCKING = "RAF";

    /**
     * Re-delivery
     */
    const REDELIVERY = "RE";

    /**
     * Refurbishing
     */
    const REFURBISHING = "RF";

    /**
     * Rail wagon hire
     */
    const RAIL_WAGON_HIRE = "RH";

    /**
     * Loading
     */
    const LOADING = "RV";

    /**
     * Salvaging
     */
    const SALVAGING = "SA";

    /**
     * Shipping and handling
     */
    const SHIPPING_AND_HANDLING = "SAA";

    /**
     * Special packaging
     */
    const SPECIAL_PACKAGING = "SAD";

    /**
     * Stamping
     */
    const STAMPING = "SAE";

    /**
     * Consignee unload
     */
    const CONSIGNEE_UNLOAD = "SAI";

    /**
     * Shrink-wrap
     */
    const SHRINKWRAP = "SG";

    /**
     * Special handling
     */
    const SPECIAL_HANDLING = "SH";

    /**
     * Special finish
     */
    const SPECIAL_FINISH = "SM";

    /**
     * Set-up
     */
    const SETUP = "SU";

    /**
     * Tank renting
     */
    const TANK_RENTING = "TAB";

    /**
     * Testing
     */
    const TESTING = "TAC";

    /**
     * Transportation - third party billing
     */
    const TRANSPORTATION__THIRD_PARTY_BILLING = "TT";

    /**
     * Transportation by vendor
     */
    const TRANSPORTATION_BY_VENDOR = "TV";

    /**
     * Drop yard
     */
    const DROP_YARD = "V1";

    /**
     * Drop dock
     */
    const DROP_DOCK = "V2";

    /**
     * Warehousing
     */
    const WAREHOUSING = "WH";

    /**
     * Combine all same day shipment
     */
    const COMBINE_ALL_SAME_DAY_SHIPMENT = "XAA";

    /**
     * Split pick-up
     */
    const SPLIT_PICKUP = "YY";

    /**
     * Mutually defined
     */
    const MUTUALLY_DEFINED = "ZZZ";
}
