<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Walletobjects;

class Permissions extends \Google\Collection
{
  protected $collection_key = 'permissions';
  /**
   * ID of the issuer the list of permissions refer to.
   *
   * @var string
   */
  public $issuerId;
  protected $permissionsType = Permission::class;
  protected $permissionsDataType = 'array';

  /**
   * ID of the issuer the list of permissions refer to.
   *
   * @param string $issuerId
   */
  public function setIssuerId($issuerId)
  {
    $this->issuerId = $issuerId;
  }
  /**
   * @return string
   */
  public function getIssuerId()
  {
    return $this->issuerId;
  }
  /**
   * The complete list of permissions for the issuer account.
   *
   * @param Permission[] $permissions
   */
  public function setPermissions($permissions)
  {
    $this->permissions = $permissions;
  }
  /**
   * @return Permission[]
   */
  public function getPermissions()
  {
    return $this->permissions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Permissions::class, 'Google_Service_Walletobjects_Permissions');
