<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class PasswordStatus extends \Google\Model
{
  /**
   * If true, user does not have login privileges.
   *
   * @var bool
   */
  public $locked;
  /**
   * The expiration time of the current password.
   *
   * @var string
   */
  public $passwordExpirationTime;

  /**
   * If true, user does not have login privileges.
   *
   * @param bool $locked
   */
  public function setLocked($locked)
  {
    $this->locked = $locked;
  }
  /**
   * @return bool
   */
  public function getLocked()
  {
    return $this->locked;
  }
  /**
   * The expiration time of the current password.
   *
   * @param string $passwordExpirationTime
   */
  public function setPasswordExpirationTime($passwordExpirationTime)
  {
    $this->passwordExpirationTime = $passwordExpirationTime;
  }
  /**
   * @return string
   */
  public function getPasswordExpirationTime()
  {
    return $this->passwordExpirationTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PasswordStatus::class, 'Google_Service_SQLAdmin_PasswordStatus');
