<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Eventarc;

class FilteringAttribute extends \Google\Model
{
  /**
   * Output only. Attribute used for filtering the event type.
   *
   * @var string
   */
  public $attribute;
  /**
   * Output only. Description of the purpose of the attribute.
   *
   * @var string
   */
  public $description;
  /**
   * Output only. If true, the attribute accepts matching expressions in the
   * Eventarc PathPattern format.
   *
   * @var bool
   */
  public $pathPatternSupported;
  /**
   * Output only. If true, the triggers for this provider should always specify
   * a filter on these attributes. Trigger creation will fail otherwise.
   *
   * @var bool
   */
  public $required;

  /**
   * Output only. Attribute used for filtering the event type.
   *
   * @param string $attribute
   */
  public function setAttribute($attribute)
  {
    $this->attribute = $attribute;
  }
  /**
   * @return string
   */
  public function getAttribute()
  {
    return $this->attribute;
  }
  /**
   * Output only. Description of the purpose of the attribute.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Output only. If true, the attribute accepts matching expressions in the
   * Eventarc PathPattern format.
   *
   * @param bool $pathPatternSupported
   */
  public function setPathPatternSupported($pathPatternSupported)
  {
    $this->pathPatternSupported = $pathPatternSupported;
  }
  /**
   * @return bool
   */
  public function getPathPatternSupported()
  {
    return $this->pathPatternSupported;
  }
  /**
   * Output only. If true, the triggers for this provider should always specify
   * a filter on these attributes. Trigger creation will fail otherwise.
   *
   * @param bool $required
   */
  public function setRequired($required)
  {
    $this->required = $required;
  }
  /**
   * @return bool
   */
  public function getRequired()
  {
    return $this->required;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FilteringAttribute::class, 'Google_Service_Eventarc_FilteringAttribute');
