<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Document;

class GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse extends \Google\Model
{
  /**
   * The resource name of the created evaluation.
   *
   * @var string
   */
  public $evaluation;

  /**
   * The resource name of the created evaluation.
   *
   * @param string $evaluation
   */
  public function setEvaluation($evaluation)
  {
    $this->evaluation = $evaluation;
  }
  /**
   * @return string
   */
  public function getEvaluation()
  {
    return $this->evaluation;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse::class, 'Google_Service_Document_GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse');
