<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class VpnTunnel extends \Google\Collection
{
  /**
   * Cloud VPN is in the process of allocating all required resources
   * (specifically, a borg task).
   */
  public const STATUS_ALLOCATING_RESOURCES = 'ALLOCATING_RESOURCES';
  /**
   * Auth error (e.g. bad shared secret).
   */
  public const STATUS_AUTHORIZATION_ERROR = 'AUTHORIZATION_ERROR';
  /**
   * Resources is being deallocated for the VPN tunnel.
   */
  public const STATUS_DEPROVISIONING = 'DEPROVISIONING';
  /**
   * Secure session is successfully established with peer VPN.
   */
  public const STATUS_ESTABLISHED = 'ESTABLISHED';
  /**
   * Tunnel creation has failed and the tunnel is not ready to be used.
   */
  public const STATUS_FAILED = 'FAILED';
  /**
   * Successful first handshake with peer VPN.
   */
  public const STATUS_FIRST_HANDSHAKE = 'FIRST_HANDSHAKE';
  /**
   * Handshake failed.
   */
  public const STATUS_NEGOTIATION_FAILURE = 'NEGOTIATION_FAILURE';
  /**
   * Deprecated, replaced by NO_INCOMING_PACKETS
   */
  public const STATUS_NETWORK_ERROR = 'NETWORK_ERROR';
  /**
   * No incoming packets from peer
   */
  public const STATUS_NO_INCOMING_PACKETS = 'NO_INCOMING_PACKETS';
  /**
   * Resource is being allocated for the VPN tunnel.
   */
  public const STATUS_PROVISIONING = 'PROVISIONING';
  /**
   * Tunnel configuration was rejected, can be result of being denylisted.
   */
  public const STATUS_REJECTED = 'REJECTED';
  /**
   * Tunnel is stopped due to its Forwarding Rules being deleted.
   */
  public const STATUS_STOPPED = 'STOPPED';
  /**
   * Waiting to receive all VPN-related configs from user. Network,
   * TargetVpnGateway, VpnTunnel, ForwardingRule and Route resources are needed
   * to setup VPN tunnel.
   */
  public const STATUS_WAITING_FOR_FULL_CONFIG = 'WAITING_FOR_FULL_CONFIG';
  protected $collection_key = 'remoteTrafficSelector';
  protected $cipherSuiteType = VpnTunnelCipherSuite::class;
  protected $cipherSuiteDataType = '';
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * [Output Only] Detailed status message for the VPN tunnel.
   *
   * @var string
   */
  public $detailedStatus;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * IKE protocol version to use when establishing the VPN tunnel with the peer
   * VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
   *
   * @var int
   */
  public $ikeVersion;
  /**
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this VpnTunnel, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * VpnTunnel.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Local traffic selector to use when establishing the VPN tunnel with the
   * peer VPN gateway. The value should be a CIDR formatted string, for example:
   * 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for
   * Classic VPN tunnels. This field is output only for HA VPN tunnels.
   *
   * @var string[]
   */
  public $localTrafficSelector;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * URL of the peer side external VPN gateway to which this VPN tunnel is
   * connected. Provided by the client when the VPN tunnel is created. This
   * field is exclusive with the field peerGcpGateway.
   *
   * @var string
   */
  public $peerExternalGateway;
  /**
   * The interface ID of the external VPN gateway to which this VPN tunnel is
   * connected. Provided by the client when the VPN tunnel is created. Possible
   * values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the
   * external VPN gateway redundancy type.
   *
   * @var int
   */
  public $peerExternalGatewayInterface;
  /**
   * URL of the peer side HA VPN gateway to which this VPN tunnel is connected.
   * Provided by the client when the VPN tunnel is created. This field can be
   * used when creating highly available VPN from VPC network to VPC network,
   * the field is exclusive with the field peerExternalGateway. If provided, the
   * VPN tunnel will automatically use the same vpnGatewayInterface ID in the
   * peer Google Cloud VPN gateway.
   *
   * @var string
   */
  public $peerGcpGateway;
  /**
   * IP address of the peer VPN gateway. Only IPv4 is supported. This field can
   * be set only for Classic VPN tunnels.
   *
   * @var string
   */
  public $peerIp;
  /**
   * [Output Only] URL of the region where the VPN tunnel resides. You must
   * specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   *
   * @var string
   */
  public $region;
  /**
   * Remote traffic selectors to use when establishing the VPN tunnel with the
   * peer VPN gateway. The value should be a CIDR formatted string, for example:
   * 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for
   * Classic VPN tunnels. This field is output only for HA VPN tunnels.
   *
   * @var string[]
   */
  public $remoteTrafficSelector;
  /**
   * URL of the router resource to be used for dynamic routing.
   *
   * @var string
   */
  public $router;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * Shared secret used to set the secure session between the Cloud VPN gateway
   * and the peer VPN gateway.
   *
   * @var string
   */
  public $sharedSecret;
  /**
   * Hash of the shared secret.
   *
   * @var string
   */
  public $sharedSecretHash;
  /**
   * [Output Only] The status of the VPN tunnel, which can be one of the
   * following:        - PROVISIONING: Resource is being allocated for the VPN
   * tunnel.    - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related
   * configs    from      the user. Network, TargetVpnGateway, VpnTunnel,
   * ForwardingRule, and Route      resources are needed to setup the VPN
   * tunnel.    - FIRST_HANDSHAKE: Successful first handshake with the peer VPN.
   * - ESTABLISHED: Secure session is successfully established with the peer
   * VPN.     - NETWORK_ERROR: Deprecated, replaced by    NO_INCOMING_PACKETS
   * - AUTHORIZATION_ERROR: Auth error (for example,    bad shared secret).
   * - NEGOTIATION_FAILURE: Handshake failed.    - DEPROVISIONING: Resources are
   * being deallocated for the VPN    tunnel.     - FAILED: Tunnel creation has
   * failed and the tunnel is not    ready to be used.     -
   * NO_INCOMING_PACKETS: No incoming packets from    peer.     - REJECTED:
   * Tunnel configuration was rejected, can be result    of being denied access.
   * - ALLOCATING_RESOURCES: Cloud VPN is in the    process of allocating all
   * required resources.    - STOPPED: Tunnel is stopped due to its Forwarding
   * Rules being deleted    for Classic VPN tunnels or the project is in frozen
   * state.    - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP,
   * probably behind NAT.     - TS_NARROWING_NOT_ALLOWED: Traffic selector
   * narrowing not allowed for an HA-VPN tunnel.
   *
   * @var string
   */
  public $status;
  /**
   * URL of the Target VPN gateway with which this VPN tunnel is associated.
   * Provided by the client when the VPN tunnel is created. This field can be
   * set only for Classic VPN tunnels.
   *
   * @var string
   */
  public $targetVpnGateway;
  /**
   * URL of the VPN gateway with which this VPN tunnel is associated. Provided
   * by the client when the VPN tunnel is created. This must be used (instead of
   * target_vpn_gateway) if a High Availability VPN gateway resource is created.
   *
   * @var string
   */
  public $vpnGateway;
  /**
   * The interface ID of the VPN gateway with which this VPN tunnel is
   * associated. Possible values are: `0`, `1`.
   *
   * @var int
   */
  public $vpnGatewayInterface;

  /**
   * User specified list of ciphers to use for the phase 1 and phase 2 of the
   * IKE protocol.
   *
   * @param VpnTunnelCipherSuite $cipherSuite
   */
  public function setCipherSuite(VpnTunnelCipherSuite $cipherSuite)
  {
    $this->cipherSuite = $cipherSuite;
  }
  /**
   * @return VpnTunnelCipherSuite
   */
  public function getCipherSuite()
  {
    return $this->cipherSuite;
  }
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * [Output Only] Detailed status message for the VPN tunnel.
   *
   * @param string $detailedStatus
   */
  public function setDetailedStatus($detailedStatus)
  {
    $this->detailedStatus = $detailedStatus;
  }
  /**
   * @return string
   */
  public function getDetailedStatus()
  {
    return $this->detailedStatus;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * IKE protocol version to use when establishing the VPN tunnel with the peer
   * VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
   *
   * @param int $ikeVersion
   */
  public function setIkeVersion($ikeVersion)
  {
    $this->ikeVersion = $ikeVersion;
  }
  /**
   * @return int
   */
  public function getIkeVersion()
  {
    return $this->ikeVersion;
  }
  /**
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this VpnTunnel, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * VpnTunnel.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Local traffic selector to use when establishing the VPN tunnel with the
   * peer VPN gateway. The value should be a CIDR formatted string, for example:
   * 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for
   * Classic VPN tunnels. This field is output only for HA VPN tunnels.
   *
   * @param string[] $localTrafficSelector
   */
  public function setLocalTrafficSelector($localTrafficSelector)
  {
    $this->localTrafficSelector = $localTrafficSelector;
  }
  /**
   * @return string[]
   */
  public function getLocalTrafficSelector()
  {
    return $this->localTrafficSelector;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * URL of the peer side external VPN gateway to which this VPN tunnel is
   * connected. Provided by the client when the VPN tunnel is created. This
   * field is exclusive with the field peerGcpGateway.
   *
   * @param string $peerExternalGateway
   */
  public function setPeerExternalGateway($peerExternalGateway)
  {
    $this->peerExternalGateway = $peerExternalGateway;
  }
  /**
   * @return string
   */
  public function getPeerExternalGateway()
  {
    return $this->peerExternalGateway;
  }
  /**
   * The interface ID of the external VPN gateway to which this VPN tunnel is
   * connected. Provided by the client when the VPN tunnel is created. Possible
   * values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the
   * external VPN gateway redundancy type.
   *
   * @param int $peerExternalGatewayInterface
   */
  public function setPeerExternalGatewayInterface($peerExternalGatewayInterface)
  {
    $this->peerExternalGatewayInterface = $peerExternalGatewayInterface;
  }
  /**
   * @return int
   */
  public function getPeerExternalGatewayInterface()
  {
    return $this->peerExternalGatewayInterface;
  }
  /**
   * URL of the peer side HA VPN gateway to which this VPN tunnel is connected.
   * Provided by the client when the VPN tunnel is created. This field can be
   * used when creating highly available VPN from VPC network to VPC network,
   * the field is exclusive with the field peerExternalGateway. If provided, the
   * VPN tunnel will automatically use the same vpnGatewayInterface ID in the
   * peer Google Cloud VPN gateway.
   *
   * @param string $peerGcpGateway
   */
  public function setPeerGcpGateway($peerGcpGateway)
  {
    $this->peerGcpGateway = $peerGcpGateway;
  }
  /**
   * @return string
   */
  public function getPeerGcpGateway()
  {
    return $this->peerGcpGateway;
  }
  /**
   * IP address of the peer VPN gateway. Only IPv4 is supported. This field can
   * be set only for Classic VPN tunnels.
   *
   * @param string $peerIp
   */
  public function setPeerIp($peerIp)
  {
    $this->peerIp = $peerIp;
  }
  /**
   * @return string
   */
  public function getPeerIp()
  {
    return $this->peerIp;
  }
  /**
   * [Output Only] URL of the region where the VPN tunnel resides. You must
   * specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * Remote traffic selectors to use when establishing the VPN tunnel with the
   * peer VPN gateway. The value should be a CIDR formatted string, for example:
   * 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for
   * Classic VPN tunnels. This field is output only for HA VPN tunnels.
   *
   * @param string[] $remoteTrafficSelector
   */
  public function setRemoteTrafficSelector($remoteTrafficSelector)
  {
    $this->remoteTrafficSelector = $remoteTrafficSelector;
  }
  /**
   * @return string[]
   */
  public function getRemoteTrafficSelector()
  {
    return $this->remoteTrafficSelector;
  }
  /**
   * URL of the router resource to be used for dynamic routing.
   *
   * @param string $router
   */
  public function setRouter($router)
  {
    $this->router = $router;
  }
  /**
   * @return string
   */
  public function getRouter()
  {
    return $this->router;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Shared secret used to set the secure session between the Cloud VPN gateway
   * and the peer VPN gateway.
   *
   * @param string $sharedSecret
   */
  public function setSharedSecret($sharedSecret)
  {
    $this->sharedSecret = $sharedSecret;
  }
  /**
   * @return string
   */
  public function getSharedSecret()
  {
    return $this->sharedSecret;
  }
  /**
   * Hash of the shared secret.
   *
   * @param string $sharedSecretHash
   */
  public function setSharedSecretHash($sharedSecretHash)
  {
    $this->sharedSecretHash = $sharedSecretHash;
  }
  /**
   * @return string
   */
  public function getSharedSecretHash()
  {
    return $this->sharedSecretHash;
  }
  /**
   * [Output Only] The status of the VPN tunnel, which can be one of the
   * following:        - PROVISIONING: Resource is being allocated for the VPN
   * tunnel.    - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related
   * configs    from      the user. Network, TargetVpnGateway, VpnTunnel,
   * ForwardingRule, and Route      resources are needed to setup the VPN
   * tunnel.    - FIRST_HANDSHAKE: Successful first handshake with the peer VPN.
   * - ESTABLISHED: Secure session is successfully established with the peer
   * VPN.     - NETWORK_ERROR: Deprecated, replaced by    NO_INCOMING_PACKETS
   * - AUTHORIZATION_ERROR: Auth error (for example,    bad shared secret).
   * - NEGOTIATION_FAILURE: Handshake failed.    - DEPROVISIONING: Resources are
   * being deallocated for the VPN    tunnel.     - FAILED: Tunnel creation has
   * failed and the tunnel is not    ready to be used.     -
   * NO_INCOMING_PACKETS: No incoming packets from    peer.     - REJECTED:
   * Tunnel configuration was rejected, can be result    of being denied access.
   * - ALLOCATING_RESOURCES: Cloud VPN is in the    process of allocating all
   * required resources.    - STOPPED: Tunnel is stopped due to its Forwarding
   * Rules being deleted    for Classic VPN tunnels or the project is in frozen
   * state.    - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP,
   * probably behind NAT.     - TS_NARROWING_NOT_ALLOWED: Traffic selector
   * narrowing not allowed for an HA-VPN tunnel.
   *
   * Accepted values: ALLOCATING_RESOURCES, AUTHORIZATION_ERROR, DEPROVISIONING,
   * ESTABLISHED, FAILED, FIRST_HANDSHAKE, NEGOTIATION_FAILURE, NETWORK_ERROR,
   * NO_INCOMING_PACKETS, PROVISIONING, REJECTED, STOPPED,
   * WAITING_FOR_FULL_CONFIG
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * URL of the Target VPN gateway with which this VPN tunnel is associated.
   * Provided by the client when the VPN tunnel is created. This field can be
   * set only for Classic VPN tunnels.
   *
   * @param string $targetVpnGateway
   */
  public function setTargetVpnGateway($targetVpnGateway)
  {
    $this->targetVpnGateway = $targetVpnGateway;
  }
  /**
   * @return string
   */
  public function getTargetVpnGateway()
  {
    return $this->targetVpnGateway;
  }
  /**
   * URL of the VPN gateway with which this VPN tunnel is associated. Provided
   * by the client when the VPN tunnel is created. This must be used (instead of
   * target_vpn_gateway) if a High Availability VPN gateway resource is created.
   *
   * @param string $vpnGateway
   */
  public function setVpnGateway($vpnGateway)
  {
    $this->vpnGateway = $vpnGateway;
  }
  /**
   * @return string
   */
  public function getVpnGateway()
  {
    return $this->vpnGateway;
  }
  /**
   * The interface ID of the VPN gateway with which this VPN tunnel is
   * associated. Possible values are: `0`, `1`.
   *
   * @param int $vpnGatewayInterface
   */
  public function setVpnGatewayInterface($vpnGatewayInterface)
  {
    $this->vpnGatewayInterface = $vpnGatewayInterface;
  }
  /**
   * @return int
   */
  public function getVpnGatewayInterface()
  {
    return $this->vpnGatewayInterface;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VpnTunnel::class, 'Google_Service_Compute_VpnTunnel');
