<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class TargetSslProxiesSetCertificateMapRequest extends \Google\Model
{
  /**
   * URL of the Certificate Map to associate with this TargetSslProxy.
   *
   *  Accepted format is//certificatemanager.googleapis.com/projects/{project}/l
   * ocations/{location}/certificateMaps/{resourceName}.
   *
   * @var string
   */
  public $certificateMap;

  /**
   * URL of the Certificate Map to associate with this TargetSslProxy.
   *
   *  Accepted format is//certificatemanager.googleapis.com/projects/{project}/l
   * ocations/{location}/certificateMaps/{resourceName}.
   *
   * @param string $certificateMap
   */
  public function setCertificateMap($certificateMap)
  {
    $this->certificateMap = $certificateMap;
  }
  /**
   * @return string
   */
  public function getCertificateMap()
  {
    return $this->certificateMap;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TargetSslProxiesSetCertificateMapRequest::class, 'Google_Service_Compute_TargetSslProxiesSetCertificateMapRequest');
