<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class MachineImage extends \Google\Collection
{
  public const STATUS_CREATING = 'CREATING';
  public const STATUS_DELETING = 'DELETING';
  public const STATUS_INVALID = 'INVALID';
  public const STATUS_READY = 'READY';
  public const STATUS_UPLOADING = 'UPLOADING';
  protected $collection_key = 'storageLocations';
  /**
   * [Output Only] The creation timestamp for this machine image inRFC3339 text
   * format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * [Input Only] Whether to attempt an application consistent machine image by
   * informing the OS to prepare for the snapshot process.
   *
   * @var bool
   */
  public $guestFlush;
  /**
   * [Output Only] A unique identifier for this machine image. The server
   * defines this identifier.
   *
   * @var string
   */
  public $id;
  protected $instancePropertiesType = InstanceProperties::class;
  protected $instancePropertiesDataType = '';
  /**
   * [Output Only] The resource type, which is alwayscompute#machineImage for
   * machine image.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this machine image, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels.
   *
   * To see the latest fingerprint, make get() request to the machine image.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels to apply to this machine image. These can be later modified by the
   * setLabels method.
   *
   * @var string[]
   */
  public $labels;
  protected $machineImageEncryptionKeyType = CustomerEncryptionKey::class;
  protected $machineImageEncryptionKeyDataType = '';
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzi;
  /**
   * [Output Only] Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzs;
  protected $savedDisksType = SavedDisk::class;
  protected $savedDisksDataType = 'array';
  /**
   * [Output Only] The URL for this machine image. The server defines this URL.
   *
   * @var string
   */
  public $selfLink;
  protected $sourceDiskEncryptionKeysType = SourceDiskEncryptionKey::class;
  protected $sourceDiskEncryptionKeysDataType = 'array';
  /**
   * The source instance used to create the machine image. You can provide this
   * as a partial or full URL to the resource. For example, the following are
   * valid values:               - https://www.googleapis.com/compute/v1/project
   * s/project/zones/zone/instances/instance     -
   * projects/project/zones/zone/instances/instance
   *
   * @var string
   */
  public $sourceInstance;
  protected $sourceInstancePropertiesType = SourceInstanceProperties::class;
  protected $sourceInstancePropertiesDataType = '';
  /**
   * [Output Only] The status of the machine image. One of the following
   * values:INVALID, CREATING, READY,DELETING, and UPLOADING.
   *
   * @var string
   */
  public $status;
  /**
   * The regional or multi-regional Cloud Storage bucket location where
   * themachine image is stored.
   *
   * @var string[]
   */
  public $storageLocations;
  /**
   * [Output Only] Total size of the storage used by the machine image.
   *
   * @var string
   */
  public $totalStorageBytes;

  /**
   * [Output Only] The creation timestamp for this machine image inRFC3339 text
   * format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * [Input Only] Whether to attempt an application consistent machine image by
   * informing the OS to prepare for the snapshot process.
   *
   * @param bool $guestFlush
   */
  public function setGuestFlush($guestFlush)
  {
    $this->guestFlush = $guestFlush;
  }
  /**
   * @return bool
   */
  public function getGuestFlush()
  {
    return $this->guestFlush;
  }
  /**
   * [Output Only] A unique identifier for this machine image. The server
   * defines this identifier.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output Only] Properties of source instance
   *
   * @param InstanceProperties $instanceProperties
   */
  public function setInstanceProperties(InstanceProperties $instanceProperties)
  {
    $this->instanceProperties = $instanceProperties;
  }
  /**
   * @return InstanceProperties
   */
  public function getInstanceProperties()
  {
    return $this->instanceProperties;
  }
  /**
   * [Output Only] The resource type, which is alwayscompute#machineImage for
   * machine image.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this machine image, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels.
   *
   * To see the latest fingerprint, make get() request to the machine image.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels to apply to this machine image. These can be later modified by the
   * setLabels method.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Encrypts the machine image using acustomer-supplied encryption key.
   *
   * After you encrypt a machine image using a customer-supplied key, you must
   * provide the same key if you use the machine image later. For example, you
   * must provide the encryption key when you create an instance from the
   * encrypted machine image in a future request.
   *
   * Customer-supplied encryption keys do not protect access to metadata of the
   * machine image.
   *
   * If you do not provide an encryption key when creating the machine image,
   * then the machine image will be encrypted using an automatically generated
   * key and you do not need to provide a key to use the machine image later.
   *
   * @param CustomerEncryptionKey $machineImageEncryptionKey
   */
  public function setMachineImageEncryptionKey(CustomerEncryptionKey $machineImageEncryptionKey)
  {
    $this->machineImageEncryptionKey = $machineImageEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getMachineImageEncryptionKey()
  {
    return $this->machineImageEncryptionKey;
  }
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzi
   */
  public function setSatisfiesPzi($satisfiesPzi)
  {
    $this->satisfiesPzi = $satisfiesPzi;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzi()
  {
    return $this->satisfiesPzi;
  }
  /**
   * [Output Only] Reserved for future use.
   *
   * @param bool $satisfiesPzs
   */
  public function setSatisfiesPzs($satisfiesPzs)
  {
    $this->satisfiesPzs = $satisfiesPzs;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzs()
  {
    return $this->satisfiesPzs;
  }
  /**
   * An array of Machine Image specific properties for disks attached to the
   * source instance
   *
   * @param SavedDisk[] $savedDisks
   */
  public function setSavedDisks($savedDisks)
  {
    $this->savedDisks = $savedDisks;
  }
  /**
   * @return SavedDisk[]
   */
  public function getSavedDisks()
  {
    return $this->savedDisks;
  }
  /**
   * [Output Only] The URL for this machine image. The server defines this URL.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * [Input Only] Thecustomer-supplied encryption key of the disks attached to
   * the source instance. Required if the source disk is protected by a
   * customer-supplied encryption key.
   *
   * @param SourceDiskEncryptionKey[] $sourceDiskEncryptionKeys
   */
  public function setSourceDiskEncryptionKeys($sourceDiskEncryptionKeys)
  {
    $this->sourceDiskEncryptionKeys = $sourceDiskEncryptionKeys;
  }
  /**
   * @return SourceDiskEncryptionKey[]
   */
  public function getSourceDiskEncryptionKeys()
  {
    return $this->sourceDiskEncryptionKeys;
  }
  /**
   * The source instance used to create the machine image. You can provide this
   * as a partial or full URL to the resource. For example, the following are
   * valid values:               - https://www.googleapis.com/compute/v1/project
   * s/project/zones/zone/instances/instance     -
   * projects/project/zones/zone/instances/instance
   *
   * @param string $sourceInstance
   */
  public function setSourceInstance($sourceInstance)
  {
    $this->sourceInstance = $sourceInstance;
  }
  /**
   * @return string
   */
  public function getSourceInstance()
  {
    return $this->sourceInstance;
  }
  /**
   * [Output Only] DEPRECATED: Please use instance_properties instead for source
   * instance related properties. New properties will not be added to this
   * field.
   *
   * @param SourceInstanceProperties $sourceInstanceProperties
   */
  public function setSourceInstanceProperties(SourceInstanceProperties $sourceInstanceProperties)
  {
    $this->sourceInstanceProperties = $sourceInstanceProperties;
  }
  /**
   * @return SourceInstanceProperties
   */
  public function getSourceInstanceProperties()
  {
    return $this->sourceInstanceProperties;
  }
  /**
   * [Output Only] The status of the machine image. One of the following
   * values:INVALID, CREATING, READY,DELETING, and UPLOADING.
   *
   * Accepted values: CREATING, DELETING, INVALID, READY, UPLOADING
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * The regional or multi-regional Cloud Storage bucket location where
   * themachine image is stored.
   *
   * @param string[] $storageLocations
   */
  public function setStorageLocations($storageLocations)
  {
    $this->storageLocations = $storageLocations;
  }
  /**
   * @return string[]
   */
  public function getStorageLocations()
  {
    return $this->storageLocations;
  }
  /**
   * [Output Only] Total size of the storage used by the machine image.
   *
   * @param string $totalStorageBytes
   */
  public function setTotalStorageBytes($totalStorageBytes)
  {
    $this->totalStorageBytes = $totalStorageBytes;
  }
  /**
   * @return string
   */
  public function getTotalStorageBytes()
  {
    return $this->totalStorageBytes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MachineImage::class, 'Google_Service_Compute_MachineImage');
