<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class ConnectionDraining extends \Google\Model
{
  /**
   * Configures a duration timeout for existing requests on a removed backend
   * instance. For supported load balancers and protocols, as described
   * inEnabling connection draining.
   *
   * @var int
   */
  public $drainingTimeoutSec;

  /**
   * Configures a duration timeout for existing requests on a removed backend
   * instance. For supported load balancers and protocols, as described
   * inEnabling connection draining.
   *
   * @param int $drainingTimeoutSec
   */
  public function setDrainingTimeoutSec($drainingTimeoutSec)
  {
    $this->drainingTimeoutSec = $drainingTimeoutSec;
  }
  /**
   * @return int
   */
  public function getDrainingTimeoutSec()
  {
    return $this->drainingTimeoutSec;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ConnectionDraining::class, 'Google_Service_Compute_ConnectionDraining');
