<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class SigninDetail extends \Google\Model
{
  /**
   * Personal usage restriction is not specified
   */
  public const ALLOW_PERSONAL_USAGE_ALLOW_PERSONAL_USAGE_UNSPECIFIED = 'ALLOW_PERSONAL_USAGE_UNSPECIFIED';
  /**
   * Personal usage is allowed
   */
  public const ALLOW_PERSONAL_USAGE_PERSONAL_USAGE_ALLOWED = 'PERSONAL_USAGE_ALLOWED';
  /**
   * Personal usage is disallowed
   */
  public const ALLOW_PERSONAL_USAGE_PERSONAL_USAGE_DISALLOWED = 'PERSONAL_USAGE_DISALLOWED';
  /**
   * Device is not associated with a single user, and thus both personal usage
   * and corporate identity authentication are not expected. Important: This
   * setting is mandatory for dedicated device enrollment and it is a breaking
   * change. This change needs to be implemented before January 2025.For
   * additional details see the dedicated device provisioning guide
   * (https://developers.google.com/android/management/provision-device#company-
   * owned_devices_for_work_use_only).
   */
  public const ALLOW_PERSONAL_USAGE_PERSONAL_USAGE_DISALLOWED_USERLESS = 'PERSONAL_USAGE_DISALLOWED_USERLESS';
  /**
   * Equivalent to SIGNIN_DETAIL_IS_NOT_DEFAULT.
   */
  public const DEFAULT_STATUS_SIGNIN_DETAIL_DEFAULT_STATUS_UNSPECIFIED = 'SIGNIN_DETAIL_DEFAULT_STATUS_UNSPECIFIED';
  /**
   * The sign-in URL will be used by default for the enterprise.
   */
  public const DEFAULT_STATUS_SIGNIN_DETAIL_IS_DEFAULT = 'SIGNIN_DETAIL_IS_DEFAULT';
  /**
   * The sign-in URL will not be used by default for the enterprise.
   */
  public const DEFAULT_STATUS_SIGNIN_DETAIL_IS_NOT_DEFAULT = 'SIGNIN_DETAIL_IS_NOT_DEFAULT';
  /**
   * Controls whether personal usage is allowed on a device provisioned with
   * this enrollment token.For company-owned devices: Enabling personal usage
   * allows the user to set up a work profile on the device. Disabling personal
   * usage requires the user provision the device as a fully managed device.For
   * personally-owned devices: Enabling personal usage allows the user to set up
   * a work profile on the device. Disabling personal usage will prevent the
   * device from provisioning. Personal usage cannot be disabled on personally-
   * owned device.
   *
   * @var string
   */
  public $allowPersonalUsage;
  /**
   * Optional. Whether the sign-in URL should be used by default for the
   * enterprise. The SigninDetail with defaultStatus set to
   * SIGNIN_DETAIL_IS_DEFAULT is used for Google account enrollment method. Only
   * one of an enterprise's signinDetails can have defaultStatus set to
   * SIGNIN_DETAIL_IS_DEFAULT. If an Enterprise has at least one signinDetails
   * and none of them have defaultStatus set to SIGNIN_DETAIL_IS_DEFAULT then
   * the first one from the list is selected and has set defaultStatus to
   * SIGNIN_DETAIL_IS_DEFAULT. If no signinDetails specified for the Enterprise
   * then the Google Account device enrollment will fail.
   *
   * @var string
   */
  public $defaultStatus;
  /**
   * A JSON string whose UTF-8 representation can be used to generate a QR code
   * to enroll a device with this enrollment token. To enroll a device using
   * NFC, the NFC record must contain a serialized java.util.Properties
   * representation of the properties in the JSON. This is a read-only field
   * generated by the server.
   *
   * @var string
   */
  public $qrCode;
  /**
   * An enterprise wide enrollment token used to trigger custom sign-in flow.
   * This is a read-only field generated by the server.
   *
   * @var string
   */
  public $signinEnrollmentToken;
  /**
   * Sign-in URL for authentication when device is provisioned with a sign-in
   * enrollment token. The sign-in endpoint should finish authentication flow
   * with a URL in the form of https://enterprise.google.com/android/enroll?et=
   * for a successful login, or
   * https://enterprise.google.com/android/enroll/invalid for a failed login.
   *
   * @var string
   */
  public $signinUrl;
  /**
   * An EMM-specified metadata to distinguish between instances of SigninDetail.
   *
   * @var string
   */
  public $tokenTag;

  /**
   * Controls whether personal usage is allowed on a device provisioned with
   * this enrollment token.For company-owned devices: Enabling personal usage
   * allows the user to set up a work profile on the device. Disabling personal
   * usage requires the user provision the device as a fully managed device.For
   * personally-owned devices: Enabling personal usage allows the user to set up
   * a work profile on the device. Disabling personal usage will prevent the
   * device from provisioning. Personal usage cannot be disabled on personally-
   * owned device.
   *
   * Accepted values: ALLOW_PERSONAL_USAGE_UNSPECIFIED, PERSONAL_USAGE_ALLOWED,
   * PERSONAL_USAGE_DISALLOWED, PERSONAL_USAGE_DISALLOWED_USERLESS
   *
   * @param self::ALLOW_PERSONAL_USAGE_* $allowPersonalUsage
   */
  public function setAllowPersonalUsage($allowPersonalUsage)
  {
    $this->allowPersonalUsage = $allowPersonalUsage;
  }
  /**
   * @return self::ALLOW_PERSONAL_USAGE_*
   */
  public function getAllowPersonalUsage()
  {
    return $this->allowPersonalUsage;
  }
  /**
   * Optional. Whether the sign-in URL should be used by default for the
   * enterprise. The SigninDetail with defaultStatus set to
   * SIGNIN_DETAIL_IS_DEFAULT is used for Google account enrollment method. Only
   * one of an enterprise's signinDetails can have defaultStatus set to
   * SIGNIN_DETAIL_IS_DEFAULT. If an Enterprise has at least one signinDetails
   * and none of them have defaultStatus set to SIGNIN_DETAIL_IS_DEFAULT then
   * the first one from the list is selected and has set defaultStatus to
   * SIGNIN_DETAIL_IS_DEFAULT. If no signinDetails specified for the Enterprise
   * then the Google Account device enrollment will fail.
   *
   * Accepted values: SIGNIN_DETAIL_DEFAULT_STATUS_UNSPECIFIED,
   * SIGNIN_DETAIL_IS_DEFAULT, SIGNIN_DETAIL_IS_NOT_DEFAULT
   *
   * @param self::DEFAULT_STATUS_* $defaultStatus
   */
  public function setDefaultStatus($defaultStatus)
  {
    $this->defaultStatus = $defaultStatus;
  }
  /**
   * @return self::DEFAULT_STATUS_*
   */
  public function getDefaultStatus()
  {
    return $this->defaultStatus;
  }
  /**
   * A JSON string whose UTF-8 representation can be used to generate a QR code
   * to enroll a device with this enrollment token. To enroll a device using
   * NFC, the NFC record must contain a serialized java.util.Properties
   * representation of the properties in the JSON. This is a read-only field
   * generated by the server.
   *
   * @param string $qrCode
   */
  public function setQrCode($qrCode)
  {
    $this->qrCode = $qrCode;
  }
  /**
   * @return string
   */
  public function getQrCode()
  {
    return $this->qrCode;
  }
  /**
   * An enterprise wide enrollment token used to trigger custom sign-in flow.
   * This is a read-only field generated by the server.
   *
   * @param string $signinEnrollmentToken
   */
  public function setSigninEnrollmentToken($signinEnrollmentToken)
  {
    $this->signinEnrollmentToken = $signinEnrollmentToken;
  }
  /**
   * @return string
   */
  public function getSigninEnrollmentToken()
  {
    return $this->signinEnrollmentToken;
  }
  /**
   * Sign-in URL for authentication when device is provisioned with a sign-in
   * enrollment token. The sign-in endpoint should finish authentication flow
   * with a URL in the form of https://enterprise.google.com/android/enroll?et=
   * for a successful login, or
   * https://enterprise.google.com/android/enroll/invalid for a failed login.
   *
   * @param string $signinUrl
   */
  public function setSigninUrl($signinUrl)
  {
    $this->signinUrl = $signinUrl;
  }
  /**
   * @return string
   */
  public function getSigninUrl()
  {
    return $this->signinUrl;
  }
  /**
   * An EMM-specified metadata to distinguish between instances of SigninDetail.
   *
   * @param string $tokenTag
   */
  public function setTokenTag($tokenTag)
  {
    $this->tokenTag = $tokenTag;
  }
  /**
   * @return string
   */
  public function getTokenTag()
  {
    return $this->tokenTag;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SigninDetail::class, 'Google_Service_AndroidManagement_SigninDetail');
