---
title: Constantes
parent: Anexos
nav_order: 2
permalink: /anexos/constantes.html
---


# Constantes
## Formatos de FacturaE

|Constante|Descripción|
|--------:|:----------|
|`Facturae::SCHEMA_3_2`|Formato de Facturae 3.2|
|`Facturae::SCHEMA_3_2_1`|Formato de Facturae 3.2.1|
|`Facturae::SCHEMA_3_2_2`|Formato de Facturae 3.2.2|

---

## Tipos de documento

|Constante|Descripción|
|--------:|:----------|
|`Facturae::INVOICE_FULL`|Factura completa|
|`Facturae::INVOICE_SIMPLIFIED`|Factura simplificada|

---

## Tipos de emisor

|Constante|Descripción|
|--------:|:----------|
|`Facturae::ISSUER_SELLER`|Proveedor (emisor)|
|`Facturae::ISSUER_BUYER`|Destinatario (receptor)|
|`Facturae::ISSUER_THIRD_PARTY`|Tercero|

---

## Modos de precisión

|Constante|Descripción|
|--------:|:----------|
|`Facturae::PRECISION_LINE`|Precisión a nivel de línea|
|`Facturae::PRECISION_INVOICE`|Precisión a nivel de factura|

---

## Modos de rectificación

|Constante|Descripción|
|--------:|:----------|
|`CorrectiveDetails::METHOD_FULL`|Rectificación íntegra|
|`CorrectiveDetails::METHOD_DIFFERENCES`|Rectificación por diferencias|
|`CorrectiveDetails::METHOD_VOLUME_DISCOUNT`|Rectificación por descuento por volumen de operaciones durante un periodo|
|`CorrectiveDetails::METHOD_AEAT_AUTHORIZED`|Autorizadas por la Agencia Tributaria|

---

## Formas de pago

|Constante|Descripción|
|--------:|:----------|
|`FacturaePayment::TYPE_CASH`|Al contado|
|`FacturaePayment::TYPE_DEBIT`|Recibo Domiciliado|
|`FacturaePayment::TYPE_RECEIPT`|Recibo|
|`FacturaePayment::TYPE_TRANSFER`|Transferencia|
|`FacturaePayment::TYPE_ACCEPTED_BILL_OF_EXCHANGE`|Letra Aceptada|
|`FacturaePayment::TYPE_DOCUMENTARY_CREDIT`|Crédito Documentario|
|`FacturaePayment::TYPE_CONTRACT_AWARD`|Adjudicación de contrato|
|`FacturaePayment::TYPE_BILL_OF_EXCHANGE`|Letra de cambio|
|`FacturaePayment::TYPE_TRANSFERABLE_IOU`|Pagaré a la Orden|
|`FacturaePayment::TYPE_IOU`|Pagaré No a la Orden|
|`FacturaePayment::TYPE_CHEQUE`|Cheque|
|`FacturaePayment::TYPE_REIMBURSEMENT`|Reposición|
|`FacturaePayment::TYPE_SPECIAL`|Especiales|
|`FacturaePayment::TYPE_SETOFF`|Compensación|
|`FacturaePayment::TYPE_POSTGIRO`|Giro postal|
|`FacturaePayment::TYPE_CERTIFIED_CHEQUE`|Cheque conformado|
|`FacturaePayment::TYPE_BANKERS_DRAFT`|Cheque bancario|
|`FacturaePayment::TYPE_CASH_ON_DELIVERY`|Pago contra reembolso|
|`FacturaePayment::TYPE_CARD`|Pago mediante tarjeta|

---

## Tipos de impuestos

|Constante|Descripción|
|--------:|:----------|
|`Facturae::TAX_IVA`|Impuesto sobre el valor añadido|
|`Facturae::TAX_IPSI`|Impuesto sobre la producción, los servicios y la importación|
|`Facturae::TAX_IGIC`|Impuesto general indirecto de Canarias|
|`Facturae::TAX_IRPF`|Impuesto sobre la Renta de las personas físicas|
|`Facturae::TAX_OTHER`|Otro|
|`Facturae::TAX_ITPAJD`|Impuesto sobre transmisiones patrimoniales y actos jurídicos documentados|
|`Facturae::TAX_IE`|Impuestos especiales|
|`Facturae::TAX_RA`|Renta aduanas|
|`Facturae::TAX_IGTECM`|Impuesto general sobre el tráfico de empresas que se aplica en Ceuta y Melilla|
|`Facturae::TAX_IECDPCAC`|Impuesto especial sobre los combustibles derivados del petróleo en la Comunidad Autonoma Canaria|
|`Facturae::TAX_IIIMAB`|Impuesto sobre las instalaciones que inciden sobre el medio ambiente en la Baleares|
|`Facturae::TAX_ICIO`|Impuesto sobre las construcciones, instalaciones y obras|
|`Facturae::TAX_IMVDN`|Impuesto municipal sobre las viviendas desocupadas en Navarra|
|`Facturae::TAX_IMSN`|Impuesto municipal sobre solares en Navarra|
|`Facturae::TAX_IMGSN`|Impuesto municipal sobre gastos suntuarios en Navarra|
|`Facturae::TAX_IMPN`|Impuesto municipal sobre publicidad en Navarra|
|`Facturae::TAX_REIVA`|Régimen especial de IVA para agencias de viajes|
|`Facturae::TAX_REIGIC`|Régimen especial de IGIC: para agencias de viajes|
|`Facturae::TAX_REIPSI`|Régimen especial de IPSI para agencias de viajes|
|`Facturae::TAX_IPS`|Impuestos sobre las primas de seguros|
|`Facturae::TAX_RLEA`|Recargo destinado a financiar las funciones de liquidación de entidades aseguradoras|
|`Facturae::TAX_IVPEE`|Impuesto sobre el valor de la producción de la energía eléctrica|
|`Facturae::TAX_IPCNG`|Impuesto sobre la producción de combustible nuclear gastado y residuos radiactivos resultantes de la generación de energía nucleoeléctrica|
|`Facturae::TAX_IACNG`|Impuesto sobre el almacenamiento de combustible nuclear gastado y residuos radioactivos en instalaciones centralizadas|
|`Facturae::TAX_IDEC`|Impuesto sobre los Depósitos en las Entidades de Crédito|
|`Facturae::TAX_ILTCAC`|Impuesto sobre las labores del tabaco en la Comunidad Autónoma de Canarias|
|`Facturae::TAX_IGFEI`|Impuesto sobre los Gases Fluorados de Efecto Invernadero|
|`Facturae::TAX_IRNR`|Impuesto sobre la Renta de No Residentes|
|`Facturae::TAX_ISS`|Impuesto sobre Sociedades|

---

## Códigos de fiscalidad especial

|Constante|Descripción|
|--------:|:----------|
|`FacturaeItem::SPECIAL_TAXABLE_EVENT_EXEMPT`|Operación sujeta y exenta|
|`FacturaeItem::SPECIAL_TAXABLE_EVENT_NON_SUBJECT`|Operación no sujeta|

---

## Unidades de medida

|Constante|Descripción|
|--------:|:----------|
|`Facturae::UNIT_DEFAULT`|Unidades (por defecto)|
|`Facturae::UNIT_HOURS`|Horas|
|`Facturae::UNIT_KILOGRAMS`|Kilogramos|
|`Facturae::UNIT_LITERS`|Litros|
|`Facturae::UNIT_OTHER`|Otros|
|`Facturae::UNIT_BOXES`|Cajas|
|`Facturae::UNIT_TRAYS`|Bandejas|
|`Facturae::UNIT_BARRELS`|Barriles|
|`Facturae::UNIT_JERRICANS`|Bidones|
|`Facturae::UNIT_BAGS`|Bolsas|
|`Facturae::UNIT_CARBOYS`|Bombonas|
|`Facturae::UNIT_BOTTLES`|Botellas|
|`Facturae::UNIT_CANISTERS`|Botes|
|`Facturae::UNIT_TETRABRIKS`|Tetra Briks|
|`Facturae::UNIT_CENTILITERS`|Centilitros|
|`Facturae::UNIT_CENTIMITERS`|Centímetros|
|`Facturae::UNIT_BINS`|Cubos|
|`Facturae::UNIT_DOZENS`|Docenas|
|`Facturae::UNIT_CASES`|Estuches|
|`Facturae::UNIT_DEMIJOHNS`|Garrafas|
|`Facturae::UNIT_GRAMS`|Gramos|
|`Facturae::UNIT_KILOMETERS`|Kilómetros|
|`Facturae::UNIT_CANS`|Latas|
|`Facturae::UNIT_BUNCHES`|Manojos|
|`Facturae::UNIT_METERS`|Metros|
|`Facturae::UNIT_MILIMETERS`|Milímetros|
|`Facturae::UNIT_6PACKS`|6-Packs|
|`Facturae::UNIT_PACKAGES`|Paquetes|
|`Facturae::UNIT_PORTIONS`|Raciones|
|`Facturae::UNIT_ROLLS`|Rollos|
|`Facturae::UNIT_ENVELOPES`|Sobres|
|`Facturae::UNIT_TUBS`|Tarrinas|
|`Facturae::UNIT_CUBICMETERS`|Metros cúbicos|
|`Facturae::UNIT_SECONDS`|Segundos|
|`Facturae::UNIT_WATTS`|Vatios|
|`Facturae::UNIT_KWH`|Kilovatios por hora (KWh)|

---

## Tipos de centros

|Constante|Descripción|
|--------:|:----------|
|`FacturaeCentre::ROLE_CONTABLE`<br>o `FacturaeCentre::ROLE_FISCAL`|Oficina contable|
|`FacturaeCentre::ROLE_GESTOR`<br>o `FacturaeCentre::ROLE_RECEPTOR`|Órgano gestor|
|`FacturaeCentre::ROLE_TRAMITADOR`<br>o `FacturaeCentre::ROLE_PAGADOR`|Unidad tramitadora|
|`FacturaeCentre::ROLE_PROPONENTE`|Órgano proponente|
|`FacturaeCentre::ROLE_B2B_FISCAL`|Receptor fiscal en FACeB2B|
|`FacturaeCentre::ROLE_B2B_PAYER`|Pagador en FACeB2B|
|`FacturaeCentre::ROLE_B2B_BUYER`|Comprador en FACeB2B|
|`FacturaeCentre::ROLE_B2B_COLLECTOR`|Collector en FACeB2B|
|`FacturaeCentre::ROLE_B2B_SELLER`|Vendedor en FACeB2B|
|`FacturaeCentre::ROLE_B2B_PAYMENT_RECEIVER`|Receptor del pago en FACeB2B|
|`FacturaeCentre::ROLE_B2B_COLLECTION_RECEIVER`|Collection receiver en FACeB2B|
|`FacturaeCentre::ROLE_B2B_ISSUER`|Emisor en FACeB2B|
