<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class RotateEntraIdCertificateContext extends \Google\Model
{
  /**
   * Optional. This is always `sql#rotateEntraIdCertificateContext`.
   *
   * @var string
   */
  public $kind;
  /**
   * Optional. The fingerprint of the next version to be rotated to. If left
   * unspecified, will be rotated to the most recently added server certificate
   * version.
   *
   * @var string
   */
  public $nextVersion;

  /**
   * Optional. This is always `sql#rotateEntraIdCertificateContext`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Optional. The fingerprint of the next version to be rotated to. If left
   * unspecified, will be rotated to the most recently added server certificate
   * version.
   *
   * @param string $nextVersion
   */
  public function setNextVersion($nextVersion)
  {
    $this->nextVersion = $nextVersion;
  }
  /**
   * @return string
   */
  public function getNextVersion()
  {
    return $this->nextVersion;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RotateEntraIdCertificateContext::class, 'Google_Service_SQLAdmin_RotateEntraIdCertificateContext');
