<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DriveLabels;

class GoogleAppsDriveLabelsV2Field extends \Google\Model
{
  protected $appliedCapabilitiesType = GoogleAppsDriveLabelsV2FieldAppliedCapabilities::class;
  protected $appliedCapabilitiesDataType = '';
  /**
   * Output only. The time this field was created.
   *
   * @var string
   */
  public $createTime;
  protected $creatorType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $creatorDataType = '';
  protected $dateOptionsType = GoogleAppsDriveLabelsV2FieldDateOptions::class;
  protected $dateOptionsDataType = '';
  /**
   * Output only. The time this field was disabled. This value has no meaning
   * when the field is not disabled.
   *
   * @var string
   */
  public $disableTime;
  protected $disablerType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $disablerDataType = '';
  protected $displayHintsType = GoogleAppsDriveLabelsV2FieldDisplayHints::class;
  protected $displayHintsDataType = '';
  /**
   * Output only. The key of a field, unique within a label or library. This
   * value is autogenerated. Matches the regex: `([a-zA-Z0-9])+`.
   *
   * @var string
   */
  public $id;
  protected $integerOptionsType = GoogleAppsDriveLabelsV2FieldIntegerOptions::class;
  protected $integerOptionsDataType = '';
  protected $lifecycleType = GoogleAppsDriveLabelsV2Lifecycle::class;
  protected $lifecycleDataType = '';
  protected $lockStatusType = GoogleAppsDriveLabelsV2LockStatus::class;
  protected $lockStatusDataType = '';
  protected $propertiesType = GoogleAppsDriveLabelsV2FieldProperties::class;
  protected $propertiesDataType = '';
  protected $publisherType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $publisherDataType = '';
  /**
   * Output only. The key to use when constructing Drive search queries to find
   * files based on values defined for this field on files. For example,
   * "`{query_key}` > 2001-01-01".
   *
   * @var string
   */
  public $queryKey;
  protected $schemaCapabilitiesType = GoogleAppsDriveLabelsV2FieldSchemaCapabilities::class;
  protected $schemaCapabilitiesDataType = '';
  protected $selectionOptionsType = GoogleAppsDriveLabelsV2FieldSelectionOptions::class;
  protected $selectionOptionsDataType = '';
  protected $textOptionsType = GoogleAppsDriveLabelsV2FieldTextOptions::class;
  protected $textOptionsDataType = '';
  /**
   * Output only. The time this field was updated.
   *
   * @var string
   */
  public $updateTime;
  protected $updaterType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $updaterDataType = '';
  protected $userOptionsType = GoogleAppsDriveLabelsV2FieldUserOptions::class;
  protected $userOptionsDataType = '';

  /**
   * Output only. The capabilities this user has on this field and its value
   * when the label is applied on Drive items.
   *
   * @param GoogleAppsDriveLabelsV2FieldAppliedCapabilities $appliedCapabilities
   */
  public function setAppliedCapabilities(GoogleAppsDriveLabelsV2FieldAppliedCapabilities $appliedCapabilities)
  {
    $this->appliedCapabilities = $appliedCapabilities;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldAppliedCapabilities
   */
  public function getAppliedCapabilities()
  {
    return $this->appliedCapabilities;
  }
  /**
   * Output only. The time this field was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. The user who created this field.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $creator
   */
  public function setCreator(GoogleAppsDriveLabelsV2UserInfo $creator)
  {
    $this->creator = $creator;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getCreator()
  {
    return $this->creator;
  }
  /**
   * Date field options.
   *
   * @param GoogleAppsDriveLabelsV2FieldDateOptions $dateOptions
   */
  public function setDateOptions(GoogleAppsDriveLabelsV2FieldDateOptions $dateOptions)
  {
    $this->dateOptions = $dateOptions;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldDateOptions
   */
  public function getDateOptions()
  {
    return $this->dateOptions;
  }
  /**
   * Output only. The time this field was disabled. This value has no meaning
   * when the field is not disabled.
   *
   * @param string $disableTime
   */
  public function setDisableTime($disableTime)
  {
    $this->disableTime = $disableTime;
  }
  /**
   * @return string
   */
  public function getDisableTime()
  {
    return $this->disableTime;
  }
  /**
   * Output only. The user who disabled this field. This value has no meaning
   * when the field is not disabled.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $disabler
   */
  public function setDisabler(GoogleAppsDriveLabelsV2UserInfo $disabler)
  {
    $this->disabler = $disabler;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getDisabler()
  {
    return $this->disabler;
  }
  /**
   * Output only. UI display hints for rendering a field.
   *
   * @param GoogleAppsDriveLabelsV2FieldDisplayHints $displayHints
   */
  public function setDisplayHints(GoogleAppsDriveLabelsV2FieldDisplayHints $displayHints)
  {
    $this->displayHints = $displayHints;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldDisplayHints
   */
  public function getDisplayHints()
  {
    return $this->displayHints;
  }
  /**
   * Output only. The key of a field, unique within a label or library. This
   * value is autogenerated. Matches the regex: `([a-zA-Z0-9])+`.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Integer field options.
   *
   * @param GoogleAppsDriveLabelsV2FieldIntegerOptions $integerOptions
   */
  public function setIntegerOptions(GoogleAppsDriveLabelsV2FieldIntegerOptions $integerOptions)
  {
    $this->integerOptions = $integerOptions;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldIntegerOptions
   */
  public function getIntegerOptions()
  {
    return $this->integerOptions;
  }
  /**
   * Output only. The lifecycle of this field.
   *
   * @param GoogleAppsDriveLabelsV2Lifecycle $lifecycle
   */
  public function setLifecycle(GoogleAppsDriveLabelsV2Lifecycle $lifecycle)
  {
    $this->lifecycle = $lifecycle;
  }
  /**
   * @return GoogleAppsDriveLabelsV2Lifecycle
   */
  public function getLifecycle()
  {
    return $this->lifecycle;
  }
  /**
   * Output only. The `LockStatus` of this field.
   *
   * @param GoogleAppsDriveLabelsV2LockStatus $lockStatus
   */
  public function setLockStatus(GoogleAppsDriveLabelsV2LockStatus $lockStatus)
  {
    $this->lockStatus = $lockStatus;
  }
  /**
   * @return GoogleAppsDriveLabelsV2LockStatus
   */
  public function getLockStatus()
  {
    return $this->lockStatus;
  }
  /**
   * The basic properties of the field.
   *
   * @param GoogleAppsDriveLabelsV2FieldProperties $properties
   */
  public function setProperties(GoogleAppsDriveLabelsV2FieldProperties $properties)
  {
    $this->properties = $properties;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldProperties
   */
  public function getProperties()
  {
    return $this->properties;
  }
  /**
   * Output only. The user who published this field. This value has no meaning
   * when the field is not published.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $publisher
   */
  public function setPublisher(GoogleAppsDriveLabelsV2UserInfo $publisher)
  {
    $this->publisher = $publisher;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getPublisher()
  {
    return $this->publisher;
  }
  /**
   * Output only. The key to use when constructing Drive search queries to find
   * files based on values defined for this field on files. For example,
   * "`{query_key}` > 2001-01-01".
   *
   * @param string $queryKey
   */
  public function setQueryKey($queryKey)
  {
    $this->queryKey = $queryKey;
  }
  /**
   * @return string
   */
  public function getQueryKey()
  {
    return $this->queryKey;
  }
  /**
   * Output only. The capabilities this user has when editing this field.
   *
   * @param GoogleAppsDriveLabelsV2FieldSchemaCapabilities $schemaCapabilities
   */
  public function setSchemaCapabilities(GoogleAppsDriveLabelsV2FieldSchemaCapabilities $schemaCapabilities)
  {
    $this->schemaCapabilities = $schemaCapabilities;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldSchemaCapabilities
   */
  public function getSchemaCapabilities()
  {
    return $this->schemaCapabilities;
  }
  /**
   * Selection field options.
   *
   * @param GoogleAppsDriveLabelsV2FieldSelectionOptions $selectionOptions
   */
  public function setSelectionOptions(GoogleAppsDriveLabelsV2FieldSelectionOptions $selectionOptions)
  {
    $this->selectionOptions = $selectionOptions;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldSelectionOptions
   */
  public function getSelectionOptions()
  {
    return $this->selectionOptions;
  }
  /**
   * Text field options.
   *
   * @param GoogleAppsDriveLabelsV2FieldTextOptions $textOptions
   */
  public function setTextOptions(GoogleAppsDriveLabelsV2FieldTextOptions $textOptions)
  {
    $this->textOptions = $textOptions;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldTextOptions
   */
  public function getTextOptions()
  {
    return $this->textOptions;
  }
  /**
   * Output only. The time this field was updated.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Output only. The user who modified this field.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $updater
   */
  public function setUpdater(GoogleAppsDriveLabelsV2UserInfo $updater)
  {
    $this->updater = $updater;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getUpdater()
  {
    return $this->updater;
  }
  /**
   * User field options.
   *
   * @param GoogleAppsDriveLabelsV2FieldUserOptions $userOptions
   */
  public function setUserOptions(GoogleAppsDriveLabelsV2FieldUserOptions $userOptions)
  {
    $this->userOptions = $userOptions;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldUserOptions
   */
  public function getUserOptions()
  {
    return $this->userOptions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsDriveLabelsV2Field::class, 'Google_Service_DriveLabels_GoogleAppsDriveLabelsV2Field');
