<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class AdvertiserTargetingConfig extends \Google\Model
{
  /**
   * Whether or not connected TV devices are exempt from viewability targeting
   * for all video line items under the advertiser.
   *
   * @var bool
   */
  public $exemptTvFromViewabilityTargeting;

  /**
   * Whether or not connected TV devices are exempt from viewability targeting
   * for all video line items under the advertiser.
   *
   * @param bool $exemptTvFromViewabilityTargeting
   */
  public function setExemptTvFromViewabilityTargeting($exemptTvFromViewabilityTargeting)
  {
    $this->exemptTvFromViewabilityTargeting = $exemptTvFromViewabilityTargeting;
  }
  /**
   * @return bool
   */
  public function getExemptTvFromViewabilityTargeting()
  {
    return $this->exemptTvFromViewabilityTargeting;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AdvertiserTargetingConfig::class, 'Google_Service_DisplayVideo_AdvertiserTargetingConfig');
