<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ContainerAnalysis;

class VulnerabilityNote extends \Google\Collection
{
  public const CVSS_VERSION_CVSS_VERSION_UNSPECIFIED = 'CVSS_VERSION_UNSPECIFIED';
  public const CVSS_VERSION_CVSS_VERSION_2 = 'CVSS_VERSION_2';
  public const CVSS_VERSION_CVSS_VERSION_3 = 'CVSS_VERSION_3';
  /**
   * Unknown.
   */
  public const SEVERITY_SEVERITY_UNSPECIFIED = 'SEVERITY_UNSPECIFIED';
  /**
   * Minimal severity.
   */
  public const SEVERITY_MINIMAL = 'MINIMAL';
  /**
   * Low severity.
   */
  public const SEVERITY_LOW = 'LOW';
  /**
   * Medium severity.
   */
  public const SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * High severity.
   */
  public const SEVERITY_HIGH = 'HIGH';
  /**
   * Critical severity.
   */
  public const SEVERITY_CRITICAL = 'CRITICAL';
  protected $collection_key = 'windowsDetails';
  /**
   * The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10
   * where 0 indicates low severity and 10 indicates high severity.
   *
   * @var float
   */
  public $cvssScore;
  protected $cvssV2Type = CVSS::class;
  protected $cvssV2DataType = '';
  protected $cvssV3Type = CVSSv3::class;
  protected $cvssV3DataType = '';
  /**
   * CVSS version used to populate cvss_score and severity.
   *
   * @var string
   */
  public $cvssVersion;
  protected $detailsType = Detail::class;
  protected $detailsDataType = 'array';
  /**
   * The note provider assigned severity of this vulnerability.
   *
   * @var string
   */
  public $severity;
  /**
   * The time this information was last changed at the source. This is an
   * upstream timestamp from the underlying information source - e.g. Ubuntu
   * security tracker.
   *
   * @var string
   */
  public $sourceUpdateTime;
  protected $windowsDetailsType = WindowsDetail::class;
  protected $windowsDetailsDataType = 'array';

  /**
   * The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10
   * where 0 indicates low severity and 10 indicates high severity.
   *
   * @param float $cvssScore
   */
  public function setCvssScore($cvssScore)
  {
    $this->cvssScore = $cvssScore;
  }
  /**
   * @return float
   */
  public function getCvssScore()
  {
    return $this->cvssScore;
  }
  /**
   * The full description of the v2 CVSS for this vulnerability.
   *
   * @param CVSS $cvssV2
   */
  public function setCvssV2(CVSS $cvssV2)
  {
    $this->cvssV2 = $cvssV2;
  }
  /**
   * @return CVSS
   */
  public function getCvssV2()
  {
    return $this->cvssV2;
  }
  /**
   * The full description of the CVSSv3 for this vulnerability.
   *
   * @param CVSSv3 $cvssV3
   */
  public function setCvssV3(CVSSv3 $cvssV3)
  {
    $this->cvssV3 = $cvssV3;
  }
  /**
   * @return CVSSv3
   */
  public function getCvssV3()
  {
    return $this->cvssV3;
  }
  /**
   * CVSS version used to populate cvss_score and severity.
   *
   * Accepted values: CVSS_VERSION_UNSPECIFIED, CVSS_VERSION_2, CVSS_VERSION_3
   *
   * @param self::CVSS_VERSION_* $cvssVersion
   */
  public function setCvssVersion($cvssVersion)
  {
    $this->cvssVersion = $cvssVersion;
  }
  /**
   * @return self::CVSS_VERSION_*
   */
  public function getCvssVersion()
  {
    return $this->cvssVersion;
  }
  /**
   * Details of all known distros and packages affected by this vulnerability.
   *
   * @param Detail[] $details
   */
  public function setDetails($details)
  {
    $this->details = $details;
  }
  /**
   * @return Detail[]
   */
  public function getDetails()
  {
    return $this->details;
  }
  /**
   * The note provider assigned severity of this vulnerability.
   *
   * Accepted values: SEVERITY_UNSPECIFIED, MINIMAL, LOW, MEDIUM, HIGH, CRITICAL
   *
   * @param self::SEVERITY_* $severity
   */
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  /**
   * @return self::SEVERITY_*
   */
  public function getSeverity()
  {
    return $this->severity;
  }
  /**
   * The time this information was last changed at the source. This is an
   * upstream timestamp from the underlying information source - e.g. Ubuntu
   * security tracker.
   *
   * @param string $sourceUpdateTime
   */
  public function setSourceUpdateTime($sourceUpdateTime)
  {
    $this->sourceUpdateTime = $sourceUpdateTime;
  }
  /**
   * @return string
   */
  public function getSourceUpdateTime()
  {
    return $this->sourceUpdateTime;
  }
  /**
   * Windows details get their own format because the information format and
   * model don't match a normal detail. Specifically Windows updates are done as
   * patches, thus Windows vulnerabilities really are a missing package, rather
   * than a package being at an incorrect version.
   *
   * @param WindowsDetail[] $windowsDetails
   */
  public function setWindowsDetails($windowsDetails)
  {
    $this->windowsDetails = $windowsDetails;
  }
  /**
   * @return WindowsDetail[]
   */
  public function getWindowsDetails()
  {
    return $this->windowsDetails;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityNote::class, 'Google_Service_ContainerAnalysis_VulnerabilityNote');
