<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Metadata extends \Google\Collection
{
  protected $collection_key = 'items';
  /**
   * Specifies a fingerprint for this request, which is essentially a hash of
   * the metadata's contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve the
   * resource.
   *
   * @var string
   */
  public $fingerprint;
  protected $itemsType = MetadataItems::class;
  protected $itemsDataType = 'array';
  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   *
   * @var string
   */
  public $kind;

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of
   * the metadata's contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve the
   * resource.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * Array of key/value pairs. The total size of all keys and values must be
   * less than 512 KB.
   *
   * @param MetadataItems[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return MetadataItems[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Metadata::class, 'Google_Service_Compute_Metadata');
