<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRun;

class GoogleDevtoolsCloudbuildV1Build extends \Google\Collection
{
  /**
   * Status of the build is unknown.
   */
  public const STATUS_STATUS_UNKNOWN = 'STATUS_UNKNOWN';
  /**
   * Build has been created and is pending execution and queuing. It has not
   * been queued.
   */
  public const STATUS_PENDING = 'PENDING';
  /**
   * Build or step is queued; work has not yet begun.
   */
  public const STATUS_QUEUED = 'QUEUED';
  /**
   * Build or step is being executed.
   */
  public const STATUS_WORKING = 'WORKING';
  /**
   * Build or step finished successfully.
   */
  public const STATUS_SUCCESS = 'SUCCESS';
  /**
   * Build or step failed to complete successfully.
   */
  public const STATUS_FAILURE = 'FAILURE';
  /**
   * Build or step failed due to an internal cause.
   */
  public const STATUS_INTERNAL_ERROR = 'INTERNAL_ERROR';
  /**
   * Build or step took longer than was allowed.
   */
  public const STATUS_TIMEOUT = 'TIMEOUT';
  /**
   * Build or step was canceled by a user.
   */
  public const STATUS_CANCELLED = 'CANCELLED';
  /**
   * Build was enqueued for longer than the value of `queue_ttl`.
   */
  public const STATUS_EXPIRED = 'EXPIRED';
  protected $collection_key = 'warnings';
  protected $approvalType = GoogleDevtoolsCloudbuildV1BuildApproval::class;
  protected $approvalDataType = '';
  protected $artifactsType = GoogleDevtoolsCloudbuildV1Artifacts::class;
  protected $artifactsDataType = '';
  protected $availableSecretsType = GoogleDevtoolsCloudbuildV1Secrets::class;
  protected $availableSecretsDataType = '';
  /**
   * Output only. The ID of the `BuildTrigger` that triggered this build, if it
   * was triggered automatically.
   *
   * @var string
   */
  public $buildTriggerId;
  /**
   * Output only. Time at which the request to create the build was received.
   *
   * @var string
   */
  public $createTime;
  protected $dependenciesType = GoogleDevtoolsCloudbuildV1Dependency::class;
  protected $dependenciesDataType = 'array';
  protected $failureInfoType = GoogleDevtoolsCloudbuildV1FailureInfo::class;
  protected $failureInfoDataType = '';
  /**
   * Output only. Time at which execution of the build was finished. The
   * difference between finish_time and start_time is the duration of the
   * build's execution.
   *
   * @var string
   */
  public $finishTime;
  protected $gitConfigType = GoogleDevtoolsCloudbuildV1GitConfig::class;
  protected $gitConfigDataType = '';
  /**
   * Output only. Unique identifier of the build.
   *
   * @var string
   */
  public $id;
  /**
   * A list of images to be pushed upon the successful completion of all build
   * steps. The images are pushed using the builder service account's
   * credentials. The digests of the pushed images will be stored in the `Build`
   * resource's results field. If any of the images fail to be pushed, the build
   * status is marked `FAILURE`.
   *
   * @var string[]
   */
  public $images;
  /**
   * Output only. URL to logs for this build in Google Cloud Console.
   *
   * @var string
   */
  public $logUrl;
  /**
   * Cloud Storage bucket where logs should be written (see [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-
   * naming#requirements)). Logs file names will be of the format
   * `${logs_bucket}/log-${build_id}.txt`.
   *
   * @var string
   */
  public $logsBucket;
  /**
   * Output only. The 'Build' name with format:
   * `projects/{project}/locations/{location}/builds/{build}`, where {build} is
   * a unique identifier generated by the service.
   *
   * @var string
   */
  public $name;
  protected $optionsType = GoogleDevtoolsCloudbuildV1BuildOptions::class;
  protected $optionsDataType = '';
  /**
   * Output only. ID of the project.
   *
   * @var string
   */
  public $projectId;
  /**
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`. The TTL starts ticking from create_time.
   *
   * @var string
   */
  public $queueTtl;
  protected $resultsType = GoogleDevtoolsCloudbuildV1Results::class;
  protected $resultsDataType = '';
  protected $secretsType = GoogleDevtoolsCloudbuildV1Secret::class;
  protected $secretsDataType = 'array';
  /**
   * IAM service account whose credentials will be used at build runtime. Must
   * be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT
   * can be email address or uniqueId of the service account.
   *
   * @var string
   */
  public $serviceAccount;
  protected $sourceType = GoogleDevtoolsCloudbuildV1Source::class;
  protected $sourceDataType = '';
  protected $sourceProvenanceType = GoogleDevtoolsCloudbuildV1SourceProvenance::class;
  protected $sourceProvenanceDataType = '';
  /**
   * Output only. Time at which execution of the build was started.
   *
   * @var string
   */
  public $startTime;
  /**
   * Output only. Status of the build.
   *
   * @var string
   */
  public $status;
  /**
   * Output only. Customer-readable message about the current status.
   *
   * @var string
   */
  public $statusDetail;
  protected $stepsType = GoogleDevtoolsCloudbuildV1BuildStep::class;
  protected $stepsDataType = 'array';
  /**
   * Substitutions data for `Build` resource.
   *
   * @var string[]
   */
  public $substitutions;
  /**
   * Tags for annotation of a `Build`. These are not docker tags.
   *
   * @var string[]
   */
  public $tags;
  /**
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`. `timeout` starts ticking from
   * `startTime`. Default time is 60 minutes.
   *
   * @var string
   */
  public $timeout;
  protected $timingType = GoogleDevtoolsCloudbuildV1TimeSpan::class;
  protected $timingDataType = 'map';
  protected $warningsType = GoogleDevtoolsCloudbuildV1Warning::class;
  protected $warningsDataType = 'array';

  /**
   * Output only. Describes this build's approval configuration, status, and
   * result.
   *
   * @param GoogleDevtoolsCloudbuildV1BuildApproval $approval
   */
  public function setApproval(GoogleDevtoolsCloudbuildV1BuildApproval $approval)
  {
    $this->approval = $approval;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1BuildApproval
   */
  public function getApproval()
  {
    return $this->approval;
  }
  /**
   * Artifacts produced by the build that should be uploaded upon successful
   * completion of all build steps.
   *
   * @param GoogleDevtoolsCloudbuildV1Artifacts $artifacts
   */
  public function setArtifacts(GoogleDevtoolsCloudbuildV1Artifacts $artifacts)
  {
    $this->artifacts = $artifacts;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Artifacts
   */
  public function getArtifacts()
  {
    return $this->artifacts;
  }
  /**
   * Secrets and secret environment variables.
   *
   * @param GoogleDevtoolsCloudbuildV1Secrets $availableSecrets
   */
  public function setAvailableSecrets(GoogleDevtoolsCloudbuildV1Secrets $availableSecrets)
  {
    $this->availableSecrets = $availableSecrets;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Secrets
   */
  public function getAvailableSecrets()
  {
    return $this->availableSecrets;
  }
  /**
   * Output only. The ID of the `BuildTrigger` that triggered this build, if it
   * was triggered automatically.
   *
   * @param string $buildTriggerId
   */
  public function setBuildTriggerId($buildTriggerId)
  {
    $this->buildTriggerId = $buildTriggerId;
  }
  /**
   * @return string
   */
  public function getBuildTriggerId()
  {
    return $this->buildTriggerId;
  }
  /**
   * Output only. Time at which the request to create the build was received.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. Dependencies that the Cloud Build worker will fetch before
   * executing user steps.
   *
   * @param GoogleDevtoolsCloudbuildV1Dependency[] $dependencies
   */
  public function setDependencies($dependencies)
  {
    $this->dependencies = $dependencies;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Dependency[]
   */
  public function getDependencies()
  {
    return $this->dependencies;
  }
  /**
   * Output only. Contains information about the build when status=FAILURE.
   *
   * @param GoogleDevtoolsCloudbuildV1FailureInfo $failureInfo
   */
  public function setFailureInfo(GoogleDevtoolsCloudbuildV1FailureInfo $failureInfo)
  {
    $this->failureInfo = $failureInfo;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1FailureInfo
   */
  public function getFailureInfo()
  {
    return $this->failureInfo;
  }
  /**
   * Output only. Time at which execution of the build was finished. The
   * difference between finish_time and start_time is the duration of the
   * build's execution.
   *
   * @param string $finishTime
   */
  public function setFinishTime($finishTime)
  {
    $this->finishTime = $finishTime;
  }
  /**
   * @return string
   */
  public function getFinishTime()
  {
    return $this->finishTime;
  }
  /**
   * Optional. Configuration for git operations.
   *
   * @param GoogleDevtoolsCloudbuildV1GitConfig $gitConfig
   */
  public function setGitConfig(GoogleDevtoolsCloudbuildV1GitConfig $gitConfig)
  {
    $this->gitConfig = $gitConfig;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1GitConfig
   */
  public function getGitConfig()
  {
    return $this->gitConfig;
  }
  /**
   * Output only. Unique identifier of the build.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * A list of images to be pushed upon the successful completion of all build
   * steps. The images are pushed using the builder service account's
   * credentials. The digests of the pushed images will be stored in the `Build`
   * resource's results field. If any of the images fail to be pushed, the build
   * status is marked `FAILURE`.
   *
   * @param string[] $images
   */
  public function setImages($images)
  {
    $this->images = $images;
  }
  /**
   * @return string[]
   */
  public function getImages()
  {
    return $this->images;
  }
  /**
   * Output only. URL to logs for this build in Google Cloud Console.
   *
   * @param string $logUrl
   */
  public function setLogUrl($logUrl)
  {
    $this->logUrl = $logUrl;
  }
  /**
   * @return string
   */
  public function getLogUrl()
  {
    return $this->logUrl;
  }
  /**
   * Cloud Storage bucket where logs should be written (see [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-
   * naming#requirements)). Logs file names will be of the format
   * `${logs_bucket}/log-${build_id}.txt`.
   *
   * @param string $logsBucket
   */
  public function setLogsBucket($logsBucket)
  {
    $this->logsBucket = $logsBucket;
  }
  /**
   * @return string
   */
  public function getLogsBucket()
  {
    return $this->logsBucket;
  }
  /**
   * Output only. The 'Build' name with format:
   * `projects/{project}/locations/{location}/builds/{build}`, where {build} is
   * a unique identifier generated by the service.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Special options for this build.
   *
   * @param GoogleDevtoolsCloudbuildV1BuildOptions $options
   */
  public function setOptions(GoogleDevtoolsCloudbuildV1BuildOptions $options)
  {
    $this->options = $options;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1BuildOptions
   */
  public function getOptions()
  {
    return $this->options;
  }
  /**
   * Output only. ID of the project.
   *
   * @param string $projectId
   */
  public function setProjectId($projectId)
  {
    $this->projectId = $projectId;
  }
  /**
   * @return string
   */
  public function getProjectId()
  {
    return $this->projectId;
  }
  /**
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`. The TTL starts ticking from create_time.
   *
   * @param string $queueTtl
   */
  public function setQueueTtl($queueTtl)
  {
    $this->queueTtl = $queueTtl;
  }
  /**
   * @return string
   */
  public function getQueueTtl()
  {
    return $this->queueTtl;
  }
  /**
   * Output only. Results of the build.
   *
   * @param GoogleDevtoolsCloudbuildV1Results $results
   */
  public function setResults(GoogleDevtoolsCloudbuildV1Results $results)
  {
    $this->results = $results;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Results
   */
  public function getResults()
  {
    return $this->results;
  }
  /**
   * Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager
   * is the recommended technique for managing sensitive data with Cloud Build.
   * Use `available_secrets` to configure builds to access secrets from Secret
   * Manager. For instructions, see: https://cloud.google.com/cloud-
   * build/docs/securing-builds/use-secrets
   *
   * @param GoogleDevtoolsCloudbuildV1Secret[] $secrets
   */
  public function setSecrets($secrets)
  {
    $this->secrets = $secrets;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Secret[]
   */
  public function getSecrets()
  {
    return $this->secrets;
  }
  /**
   * IAM service account whose credentials will be used at build runtime. Must
   * be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT
   * can be email address or uniqueId of the service account.
   *
   * @param string $serviceAccount
   */
  public function setServiceAccount($serviceAccount)
  {
    $this->serviceAccount = $serviceAccount;
  }
  /**
   * @return string
   */
  public function getServiceAccount()
  {
    return $this->serviceAccount;
  }
  /**
   * Optional. The location of the source files to build.
   *
   * @param GoogleDevtoolsCloudbuildV1Source $source
   */
  public function setSource(GoogleDevtoolsCloudbuildV1Source $source)
  {
    $this->source = $source;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Source
   */
  public function getSource()
  {
    return $this->source;
  }
  /**
   * Output only. A permanent fixed identifier for source.
   *
   * @param GoogleDevtoolsCloudbuildV1SourceProvenance $sourceProvenance
   */
  public function setSourceProvenance(GoogleDevtoolsCloudbuildV1SourceProvenance $sourceProvenance)
  {
    $this->sourceProvenance = $sourceProvenance;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1SourceProvenance
   */
  public function getSourceProvenance()
  {
    return $this->sourceProvenance;
  }
  /**
   * Output only. Time at which execution of the build was started.
   *
   * @param string $startTime
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
  /**
   * Output only. Status of the build.
   *
   * Accepted values: STATUS_UNKNOWN, PENDING, QUEUED, WORKING, SUCCESS,
   * FAILURE, INTERNAL_ERROR, TIMEOUT, CANCELLED, EXPIRED
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * Output only. Customer-readable message about the current status.
   *
   * @param string $statusDetail
   */
  public function setStatusDetail($statusDetail)
  {
    $this->statusDetail = $statusDetail;
  }
  /**
   * @return string
   */
  public function getStatusDetail()
  {
    return $this->statusDetail;
  }
  /**
   * Required. The operations to be performed on the workspace.
   *
   * @param GoogleDevtoolsCloudbuildV1BuildStep[] $steps
   */
  public function setSteps($steps)
  {
    $this->steps = $steps;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1BuildStep[]
   */
  public function getSteps()
  {
    return $this->steps;
  }
  /**
   * Substitutions data for `Build` resource.
   *
   * @param string[] $substitutions
   */
  public function setSubstitutions($substitutions)
  {
    $this->substitutions = $substitutions;
  }
  /**
   * @return string[]
   */
  public function getSubstitutions()
  {
    return $this->substitutions;
  }
  /**
   * Tags for annotation of a `Build`. These are not docker tags.
   *
   * @param string[] $tags
   */
  public function setTags($tags)
  {
    $this->tags = $tags;
  }
  /**
   * @return string[]
   */
  public function getTags()
  {
    return $this->tags;
  }
  /**
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`. `timeout` starts ticking from
   * `startTime`. Default time is 60 minutes.
   *
   * @param string $timeout
   */
  public function setTimeout($timeout)
  {
    $this->timeout = $timeout;
  }
  /**
   * @return string
   */
  public function getTimeout()
  {
    return $this->timeout;
  }
  /**
   * Output only. Stores timing information for phases of the build. Valid keys
   * are: * BUILD: time to execute all build steps. * PUSH: time to push all
   * artifacts including docker images and non docker artifacts. * FETCHSOURCE:
   * time to fetch source. * SETUPBUILD: time to set up build. If the build does
   * not specify source or images, these keys will not be included.
   *
   * @param GoogleDevtoolsCloudbuildV1TimeSpan[] $timing
   */
  public function setTiming($timing)
  {
    $this->timing = $timing;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1TimeSpan[]
   */
  public function getTiming()
  {
    return $this->timing;
  }
  /**
   * Output only. Non-fatal problems encountered during the execution of the
   * build.
   *
   * @param GoogleDevtoolsCloudbuildV1Warning[] $warnings
   */
  public function setWarnings($warnings)
  {
    $this->warnings = $warnings;
  }
  /**
   * @return GoogleDevtoolsCloudbuildV1Warning[]
   */
  public function getWarnings()
  {
    return $this->warnings;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleDevtoolsCloudbuildV1Build::class, 'Google_Service_CloudRun_GoogleDevtoolsCloudbuildV1Build');
