<?php
/**
 * WARNING: Do not edit by hand, this file was generated by Crank:
 *
 * https://github.com/gocardless/crank
 */

namespace GoCardlessPro\Services;

use \GoCardlessPro\Core\Paginator;
use \GoCardlessPro\Core\Util;
use \GoCardlessPro\Core\ListResponse;
use \GoCardlessPro\Resources\PayerAuthorisation;
use \GoCardlessPro\Core\Exception\InvalidStateException;


/**
 * Service that provides access to the PayerAuthorisation
 * endpoints of the API
 *
 * @method get()
 * @method create()
 * @method update()
 * @method submit()
 * @method confirm()
 */
class PayerAuthorisationsService extends BaseService
{

    protected $envelope_key   = 'payer_authorisations';
    protected $resource_class = '\GoCardlessPro\Resources\PayerAuthorisation';


    /**
     * Get a single Payer Authorisation
     *
     * Example URL: /payer_authorisations/:identity
     *
     * @param  string        $identity Unique identifier, beginning with "PA".
     * @param  string[mixed] $params   An associative array for any params
     * @return PayerAuthorisation
     **/
    public function get($identity, $params = array())
    {
        $path = Util::subUrl(
            '/payer_authorisations/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Create a Payer Authorisation
     *
     * Example URL: /payer_authorisations
     *
     * @param  string[mixed] $params An associative array for any params
     * @return PayerAuthorisation
     **/
    public function create($params = array())
    {
        $path = "/payer_authorisations";
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Update a Payer Authorisation
     *
     * Example URL: /payer_authorisations/:identity
     *
     * @param  string        $identity Unique identifier, beginning with "PA".
     * @param  string[mixed] $params   An associative array for any params
     * @return PayerAuthorisation
     **/
    public function update($identity, $params = array())
    {
        $path = Util::subUrl(
            '/payer_authorisations/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        $response = $this->api_client->put($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Submit a Payer Authorisation
     *
     * Example URL: /payer_authorisations/:identity/actions/submit
     *
     * @param  string        $identity Unique identifier, beginning with "PA".
     * @param  string[mixed] $params   An associative array for any params
     * @return PayerAuthorisation
     **/
    public function submit($identity, $params = array())
    {
        $path = Util::subUrl(
            '/payer_authorisations/:identity/actions/submit',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Confirm a Payer Authorisation
     *
     * Example URL: /payer_authorisations/:identity/actions/confirm
     *
     * @param  string        $identity Unique identifier, beginning with "PA".
     * @param  string[mixed] $params   An associative array for any params
     * @return PayerAuthorisation
     **/
    public function confirm($identity, $params = array())
    {
        $path = Util::subUrl(
            '/payer_authorisations/:identity/actions/confirm',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

}
