<?php

/**
 * The Farsi language file
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Mehdi Hakimi <mehdi@doxdo.com>
 * @author Ali Yousefi Sabzevar <aysabzevar@gmail.com>
 * @copyright 2006-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2006-11-24
 * @codingStandardsIgnoreFile
 */

$PMF_LANG['metaCharset'] = 'UTF-8';
$PMF_LANG['metaLanguage'] = 'fa';
$PMF_LANG['language'] = 'Farsi';
$PMF_LANG['direction']= 'rtl';
$PMF_LANG['nplurals'] = '2';

$PMF_LANG['msgCategory'] = 'موضوع';
$PMF_LANG['msgShowAllCategories'] = 'نمایش همه موضوعات';
$PMF_LANG['msgSearch'] = 'جستجو';
$PMF_LANG['msgAddContent'] = 'افزودن محتوا';
$PMF_LANG['msgQuestion'] = 'پرسش';
$PMF_LANG['msgOpenQuestions'] = 'پرسش‌های باز';
$PMF_LANG['msgHelp'] = 'کمک';
$PMF_LANG['msgContact'] = 'تماس';
$PMF_LANG['msgHome'] = 'خانه';
$PMF_LANG['msgNews'] = 'خبر';
$PMF_LANG['msgUserOnline'] = ' کاربر آنلاین';
$PMF_LANG['msgXMLExport'] = 'فایل اکس‌ام‌ال';
$PMF_LANG['msgBack2Home'] = 'بازگشت به خانه';
$PMF_LANG['msgFullCategories'] = 'موضوعات دارای محتوا';
$PMF_LANG['msgFullCategoriesIn'] = 'موضوعات دارای محتوای اضافه شده';
$PMF_LANG['msgSubCategories'] = 'موضوعات زیرشاخه';
$PMF_LANG['msgEntries'] = 'ورودی';
$PMF_LANG['msgEntriesIn'] = 'ورودی در';
$PMF_LANG['msgViews'] = 'نمایش';
$PMF_LANG['msgPage'] = 'صفحه ';
$PMF_LANG['msgPages'] = ' صفحه‌ها';
$PMF_LANG['msgPrevious'] = 'قبلی';
$PMF_LANG['msgNext'] = 'بعدی';
$PMF_LANG['msgCategoryUp'] = 'یک موضوع بالاتر';
$PMF_LANG['msgLastUpdateArticle'] = 'آخرین تغییر:';
$PMF_LANG['msgAuthor'] = 'نویسنده ';
$PMF_LANG['msgPrinterFriendly'] = 'نسخه قابل چاپ';
$PMF_LANG['msgPrintArticle'] = 'چاپ مقاله';
$PMF_LANG['msgMakeXMLExport'] = 'به صورت فایل اکس‌ام‌ال';
$PMF_LANG['msgAverageVote'] = 'امتیاز متوسط';
$PMF_LANG['msgVoteUsability'] = 'لطفا به این مطلب امتیاز بدهید';
$PMF_LANG['msgVoteFrom'] = 'از';
$PMF_LANG['msgVoteBad '] = 'بی‌فایده';
$PMF_LANG['msgVoteGood'] = 'بسیار مفید';
$PMF_LANG['msgVotings'] = 'امتیازها ';
$PMF_LANG['msgVoteSubmit'] = 'امتیاز بدهید';
$PMF_LANG['msgVoteThanks'] = 'بسیار متشکریم که امتیاز دادید';
$PMF_LANG['msgYouCan'] = 'شما میتوانید ';
$PMF_LANG['msgWriteComment '] = 'نظر بدهید';
$PMF_LANG['msgShowCategory '] = 'نمایش کلی موضوع';
$PMF_LANG['msgCommentBy'] = 'نظر توسط ';
$PMF_LANG['msgCommentHeader'] = 'نظر در مورد';
$PMF_LANG['msgYourComment'] = 'نظر شما';
$PMF_LANG['msgCommentThanks'] = 'از درج نظرتان بسیار متشکریم';
$PMF_LANG['msgSend2Friend'] = 'ارسال به یک دوست';
$PMF_LANG['msgS2FButton'] = 'ارسال کن';
$PMF_LANG['msgSearchWord'] = 'کلیدواژه';
$PMF_LANG['msgSearchFind'] = 'نتایج جستجو برای ';
$PMF_LANG['msgSearchAmount'] = ' نتیجه جستجو';
$PMF_LANG['msgSearchAmounts'] = ' نتایج جستجو';
$PMF_LANG['msgSearchCategory'] = 'موضوع  ';
$PMF_LANG['msgSearchContent'] = 'محتوا:  ';
$PMF_LANG['msgNewContentHeader'] = 'پیشنهاد پرسش‌های متداول';
$PMF_LANG['msgNewContentAddon'] = 'پیشنهاد شما بلافاصله ظاهر نمی شود، اما قبل از انتشار توسط ما بررسی می شود. فیلدهای اجباری فیلدهایی هستند که با * علامت گذاری شده اند.';
$PMF_LANG['msgNewContentName'] = 'نام شما:';
$PMF_LANG['msgNewContentMail'] = 'آدرس ایمیل شما:';
$PMF_LANG['msgNewContentCategory'] = 'کدام موضوع را انتخاب میکنید?';
$PMF_LANG['msgNewContentTheme'] = 'سرتیتر:';
$PMF_LANG['msgNewContentArticle'] = 'متن پرسش‌های متداول شما:';
$PMF_LANG['msgNewContentKeywords'] = 'کلیدواژه‌ها:';
$PMF_LANG['msgNewContentLink'] = 'پیوند برای این پرسش';
$PMF_LANG['msgNewContentSubmit'] = 'ثبت شود';
$PMF_LANG['msgInfo'] = 'اطلاعات بیشتر: ';
$PMF_LANG['msgNewContentThanks'] = 'از بابت این پیشنهاد بسیار متشکریم';
$PMF_LANG['msgNoQuestionsAvailable'] = 'در حال حاضر پرسش مطرح شده‌ای وجود ندارد.';
$PMF_LANG['msgNewQuestion'] = 'پرسش خود را در فرم زیر مطرح کنید:';
$PMF_LANG['msgAskCategory'] = 'پرسش شما در مورد موضوع ';
$PMF_LANG['msgAskYourQuestion'] = 'پرسش شما:';
$PMF_LANG['msgAskThx4Mail'] = '<h2>از بابت طرح پرسشتان متشکریم</h2>';
$PMF_LANG['msgDate_User'] = ' تاریخ / کاربر';
$PMF_LANG['msgQuestion2'] = 'پرسش';
$PMF_LANG['msg2answer'] = 'جواب';
$PMF_LANG['msgQuestionText'] = 'شما در اینجا میتوانید پرسش‌هایی را که توسط کاربران دیگر مطرح شده مشاهده فرمایید. اگر شما به این پرسش‌ها جوابی بنویسید احتمال دارد جواب شما وارد پرسش‌های متداول شود.';
$PMF_LANG['msgHelpText'] = 'چهار چوب <strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions یعنی پرسش‌های متداول، بسیار ساده است. شما میتوانید در <strong><a href=\"?action=show\">موضوعات </a></strong>جستجو کنید یا میتوانید به <strong><a href=\"?action=search\">موتور جستجوی پرسش‌های متداول </a></strong> اجازه بدهید که به دنبال کلیدواژه‌ها جستجو کند.';
$PMF_LANG['msgContactEMail'] = 'ایمیل به وب‌مستر:';
$PMF_LANG['msgMessage'] = 'پیام شما:';
$PMF_LANG['msgTopTen'] = '10 آموزش برتر';
$PMF_LANG['msgHomeThereAre'] = ' تعداد';
$PMF_LANG['msgHomeArticlesOnline'] = ' مطلب وجود دارد';
$PMF_LANG['msgNoNews'] = 'بیخبری خوش خبری است.';
$PMF_LANG['msgLatestArticles'] = ' پنج مطلب اخیر';
$PMF_LANG['msgMailThanks'] = 'بسیار ممنون بابت پیشنهاد به پرسش‌های متداول.';
$PMF_LANG['msgMailCheck'] = 'مطلب جدید در پرسش‌های متداول وجود دارد! لطفا به بخش مدیریت مراجعه کنید';
$PMF_LANG['msgMailContact'] = 'پیام شما به مدیر سایت ارسال شد.';
$PMF_LANG['err_noDatabase'] = 'ارتباط با پایگاه داده وجود ندارد.';
$PMF_LANG['err_noHeaders'] = 'موضوعی یافت نشد.';
$PMF_LANG['msgErrorNoRecords'] = 'مطلبی در دسترس نیست.';
$PMF_LANG['err_badID'] = 'شناسه اشتباه.';
$PMF_LANG['err_noTopTen'] = 'هنوز مطالب برتر ایجاد نشده.';
$PMF_LANG['err_nothingFound'] = 'مطلبی پیدا نشد.';
$PMF_LANG['err_SaveEntries'] = 'کادرهای اجباری <strong>نام شما</strong>, <strong>ایمیل شما </strong>, <strong>موضوع </strong>, <strong>headline</strong>, <strong>your Record</strong> and, when requested, the <strong><a href="https://en.wikipedia.org/wiki/Captcha" title="Read more >Captcha</a> کد </strong> هستند!<br><br><a href="javascript:history.back();">یک صفحه برگرد </a><br><br>';
$PMF_LANG['err_SaveComment'] = 'کادرهای اجباری <strong>نام شما </strong>, <strong>ایمیل شما </strong>, <strong>نظر شما </strong> و, اگر خواسته شده باشه, <strong><a href="https://en.wikipedia.org/wiki/Captcha" title="Read more >Captcha</a> کد </strong>هستند!<br><br><a href="javascript:history.back();">یک صفحه برگرد</a><br><br>';
$PMF_LANG['err_VoteTooMuch'] = 'امتیازات تکراری حساب نمیشوند. کلیک کنید , برای برگشت.';
$PMF_LANG['err_noVote'] = '<strong>امتیاز ثبت نشد!</strong> <a href="javascript:history.back();">کلید کنید </a>, برای امتیاز دادن.';
$PMF_LANG['err_noMailAdress'] = 'ایمیل شما صحیح به نظر نمیرسد.<br><a href="javascript:history.back();">برگشت</a>';
$PMF_LANG['err_sendMail'] = 'کادرهای اجباری <strong>نام شما</strong>, <strong>ایمیل شما</strong>, <strong>پرسش شما</strong> و, اگر تقاضا شده باشد, <strong><a href="https://en.wikipedia.org/wiki/Captcha" title="Read more >Captcha</a> کد </strong>!';
$PMF_LANG['help_search'] = 'شما متوانید به دنبال مطلبی با کلماتی مانند <strong style="color: Red;">word1 و word2</strong> جستجو کنید، همچنین شما میتوانید برای عباراتی با دو کلمه یا بیشتر جستجو کنید.<strong>توجه:</strong>هر کلمه در جستجوی شما حداقل باید دارای چهار حرف باشد.';
$PMF_LANG['ad'] = 'بخش مدیریت';
$PMF_LANG['ad_menu_user_administration'] = 'مدیریت کاربران';
$PMF_LANG['ad_menu_entry_aprove'] = 'رکوردهای تایید شده';
$PMF_LANG['ad_menu_entry_edit'] = 'اصلاح رکورد';
$PMF_LANG['ad_menu_categ_add'] = 'موضوع اضافه کنید';
$PMF_LANG['msgHeaderCategoryOverview'] = 'مدیریت موضوعات';
$PMF_LANG['ad_menu_news_add'] = 'افزودن خبر';
$PMF_LANG['ad_menu_news_edit'] = 'اصلاح خبرها';
$PMF_LANG['ad_menu_open'] = 'اصلاح پرسش‌های باز';
$PMF_LANG['ad_menu_stat'] = 'آمار امتیازها';
$PMF_LANG['ad_menu_cookie'] = 'کوکی‌ها';
$PMF_LANG['ad_menu_session'] = 'مشاهده بخشها';
$PMF_LANG['ad_menu_adminlog'] = 'مشاهده سیاهه مدیر';
$PMF_LANG['ad_menu_passwd'] = 'تعویض پسورد';
$PMF_LANG['ad_menu_logout'] = 'خروج';
$PMF_LANG['ad_menu_startpage'] = 'صفحه شروع';
$PMF_LANG['ad_msg_identify'] = 'لطفاً مشخصات شناسایی.';
$PMF_LANG['ad_msg_passmatch'] = 'هر دو پسورد باید <strong> یکسان باشند</strong>!';
$PMF_LANG['ad_msg_savedsuc_1'] = 'نمایه';
$PMF_LANG['ad_msg_savedsuc_2'] = 'با موفقیت ثبت شد.';
$PMF_LANG['ad_msg_mysqlerr'] = 'به دلیل <strong>اشکال در پایگاه داده</strong>, نمایه ثبت نشد.';
$PMF_LANG['ad_msg_noauth'] = 'شما مجاز به ورود نیستید.';
$PMF_LANG['ad_gen_page'] = 'صفحه';
$PMF_LANG['ad_gen_of'] = 'از';
$PMF_LANG['ad_gen_lastpage'] = 'صفحه قبل ';
$PMF_LANG['ad_gen_nextpage'] = 'صفحه بعد';
$PMF_LANG['ad_gen_save'] = 'ذخیره';
$PMF_LANG['ad_gen_reset'] = 'پاک شود';
$PMF_LANG['ad_gen_yes'] = 'بله';
$PMF_LANG['ad_gen_no'] = 'نخیر';
$PMF_LANG['ad_gen_top'] = 'بالای صفحه';
$PMF_LANG['ad_gen_ncf'] = 'موضوعی پیدا نشد!';
$PMF_LANG['ad_gen_delete'] = 'پاک کن';
$PMF_LANG['ad_user'] = 'مدیریت کاربران';
$PMF_LANG['ad_user_username'] = 'کاربران ثبت شده';
$PMF_LANG['ad_user_rights'] = 'سطح دسترسی';
$PMF_LANG['ad_user_edit'] = 'اصلاح';
$PMF_LANG['ad_user_delete'] = 'پاک کن';
$PMF_LANG['ad_user_add'] = 'افزودن کاربر';
$PMF_LANG['ad_user_profou'] = 'نمایه کاربر';
$PMF_LANG['ad_user_name'] = 'نام';
$PMF_LANG['ad_user_password'] = 'پسورد';
$PMF_LANG['ad_user_confirm'] = 'تایید';
$PMF_LANG['ad_user_del_1'] = 'افزودن کاربر';
$PMF_LANG['ad_user_del_2'] = 'پاک شود?';
$PMF_LANG['ad_user_del_3'] = 'مطمئن هستید?';
$PMF_LANG['ad_user_deleted'] = 'کاربر پاک شد.';
$PMF_LANG['ad_user_checkall'] = 'انتخاب همه';
$PMF_LANG['msgHeaderFAQOverview'] = 'مدیریت مطالب';
$PMF_LANG['ad_entry_id'] = 'شناسه';
$PMF_LANG['ad_entry_topic'] = 'موضوع';
$PMF_LANG['ad_entry_action'] = 'عمل';
$PMF_LANG['ad_entry_edit_1'] = 'اصلاح رکورد';
$PMF_LANG['ad_entry_edit_2'] = 'ویرایش رکورد';
$PMF_LANG['ad_entry_theme'] = 'تیتر مطلب:';
$PMF_LANG['ad_entry_content'] = 'محتوا:';
$PMF_LANG['ad_entry_keywords'] = 'کلیدواژه:';
$PMF_LANG['ad_entry_author'] = 'نویسنده:';
$PMF_LANG['ad_entry_category'] = 'موضوع:';
$PMF_LANG['ad_entry_active'] = 'قابل مشاهده';
$PMF_LANG['ad_entry_date'] = 'تاریخ';
$PMF_LANG['ad_entry_status'] = 'Status der FAQ';
$PMF_LANG['ad_entry_changed'] = 'تغییر یافته?';
$PMF_LANG['ad_entry_changelog'] = 'سیاهه تغییرات';
$PMF_LANG['ad_entry_commentby'] = 'نظر توسط';
$PMF_LANG['ad_entry_comment'] = 'نظرات:';
$PMF_LANG['ad_entry_save'] = 'ذخیره';
$PMF_LANG['msgDelete'] = 'پاک کن';
$PMF_LANG['ad_entry_delcom_1'] = 'آیا مطمئن هستید؟ ';
$PMF_LANG['ad_entry_delcom_2'] = 'باید پاک شود?';
$PMF_LANG['ad_entry_commentdelsuc'] = 'نظر با <strong>موفقیت</strong> پاک شد.';
$PMF_LANG['ad_entry_back'] = 'برگرد';
$PMF_LANG['ad_entry_commentdelfail'] = 'نظر <strong>پاک نشد</strong>.';
$PMF_LANG['ad_entry_savedsuc'] = 'تغییرات با <strong>موفقیت</strong> ثبت شد.';
$PMF_LANG['ad_entry_savedfail'] = 'متاسفانه, یک <strong>اشکال در پایگاه داده</strong> رخ داد.';
$PMF_LANG['ad_entry_del_1'] = 'آیا مطمئنید؟';
$PMF_LANG['ad_entry_del_2'] = 'از';
$PMF_LANG['ad_entry_del_3'] = 'باید پاک شود?';
$PMF_LANG['ad_entry_delsuc'] = 'مورد با <strong>موفقیت</strong> پاک شد.';
$PMF_LANG['ad_entry_delfail'] = 'مورد <strong>پاک نشد</strong>!';
$PMF_LANG['ad_news_header'] = 'سرتیتر مطلب';
$PMF_LANG['ad_news_text'] = 'متن مطلب';
$PMF_LANG['ad_news_link_url'] = 'پیوند: (<strong>با https://</strong>)!';
$PMF_LANG['ad_news_link_title'] = 'تیتر پیوند:';
$PMF_LANG['ad_news_link_target'] = 'هدف پیوند';
$PMF_LANG['ad_news_link_window'] = 'پیوند در صفحه جدید';
$PMF_LANG['ad_news_link_پرسش‌های متداول'] = 'پیوند در داخل پرسش‌های متداول';
$PMF_LANG['ad_news_add'] = 'افزودن خبر';
$PMF_LANG['ad_news_id'] = '#';
$PMF_LANG['ad_news_headline'] = 'عنوان';
$PMF_LANG['ad_news_date'] = 'تاریخ';
$PMF_LANG['ad_news_action'] = 'عمل';
$PMF_LANG['ad_news_update'] = 'به روز';
$PMF_LANG['ad_news_delete'] = 'پاک کن';
$PMF_LANG['ad_news_nodata'] = 'اطلاعاتی در پایگاه داده پیدا نشد';
$PMF_LANG['ad_news_updatesuc'] = 'خبر به روز شد';
$PMF_LANG['ad_news_del'] = 'برای پاک کردن خبرها مطمئن هستید؟';
$PMF_LANG['ad_news_yesdelete'] = 'بله, پاک شود!';
$PMF_LANG['ad_news_nodelete'] = 'نخیر!';
$PMF_LANG['ad_news_delsuc'] = 'خبرها پاک شد.';
$PMF_LANG['ad_news_updatenews'] = 'به روز کردن خبرها';
$PMF_LANG['ad_categ_new'] = 'افزودن موضوع';
$PMF_LANG['ad_categ_catnum'] = 'تعداد موضوع:';
$PMF_LANG['ad_categ_subcatnum'] = 'تعداد زیرشاخه:';
$PMF_LANG['ad_categ_nya'] = '<em>هنوز آماده نیست!</em>';
$PMF_LANG['ad_categ_titel'] = 'تیتر موضوع';
$PMF_LANG['ad_categ_add'] = 'افزودن موضوع';
$PMF_LANG['ad_categ_existing'] = 'موضوعات موجود';
$PMF_LANG['ad_categ_id'] = '#';
$PMF_LANG['ad_categ_categ'] = 'موضوع';
$PMF_LANG['ad_categ_subcateg'] = 'زیرشاخه';
$PMF_LANG['ad_categ_action'] = 'عمل';
$PMF_LANG['ad_categ_update'] = 'به روز';
$PMF_LANG['ad_categ_delete'] = 'پاک کن';
$PMF_LANG['ad_categ_updatecateg'] = 'به روز کردن موضوع';
$PMF_LANG['ad_categ_nodata'] = 'اطلاعاتی در پایگاه داده موجود نیست';
$PMF_LANG['msgCategoryRemark'] = 'اگر شما موضوع را حذف کنید، توجه کنید که مطالب فعلی دیگر در دسترس نخواهند بود. شما باید به مطالب یک موضوع دیگر اختصاص دهید یا مطالب را پاک کنید.';
$PMF_LANG['ad_categ_edit_1'] = 'اصلاح';
$PMF_LANG['ad_categ_edit_2'] = 'موضوع';
$PMF_LANG['ad_categ_added'] = 'موضوع اضافه شد.';
$PMF_LANG['ad_categ_updated'] = 'موضوع به روز شد.';
$PMF_LANG['ad_categ_del_yes'] = 'بله, پاک شود!';
$PMF_LANG['ad_categ_del_no'] = 'نخیر!';
$PMF_LANG['ad_categ_deletesure'] = 'مطمئن هستید که موضوع پاک شود?';
$PMF_LANG['ad_categ_deleted'] = 'موضوع پاک شد.';
$PMF_LANG['ad_cookie_cookiesuc 	'] = 'کوکی با <strong>موفقیت</strong> تنظیم شد.';
$PMF_LANG['ad_cookie_already'] = 'یک کوکی الان تنظیم شده‌است. اکنون امکانهای زیر موجود است:';
$PMF_LANG['ad_cookie_again'] = 'یک کوکی دیگر تنظیم کنید';
$PMF_LANG['ad_cookie_delete'] = 'کوکی را پاک کنید';
$PMF_LANG['ad_cookie_no'] = 'هنوز هیچ کوکی ذخیره نشده‌است. با کوکی شما میتوانید اطلاعات ورودتان را ذخیره کنید, بنابر این دیگر نیازی به ازبر کردن اطلاعات خود نخواهید داشت. اکنون امکانهای زیر موجود است:';
$PMF_LANG['ad_cookie_set'] = 'تنظیم کوکی';
$PMF_LANG['ad_cookie_deleted'] = 'کوکی با موفقیت پاک شد.';
$PMF_LANG['ad_adminlog'] = 'سیاهه مدیر';
$PMF_LANG['ad_passwd_cop'] = 'تغییر رمز عبور';
$PMF_LANG['ad_passwd_old'] = 'رمز عبور قدیم:';
$PMF_LANG['ad_passwd_new'] = 'رمز عبور جدید:';
$PMF_LANG['ad_passwd_con'] = 'دوباره وارد کنید:';
$PMF_LANG['ad_passwd_change'] = 'تغییر رمز عبور';
$PMF_LANG['ad_passwd_suc'] = 'رمز عبور با موفقیت تغییر یافت.';
$PMF_LANG['ad_passwd_remark'] = '<strong>توجه:</strong><br>کوکی باید مجدداً تنظیم شود!';
$PMF_LANG['ad_passwd_fail'] = 'رمز عبور قدیم <strong>باید</strong> صحیح وارد شود و <strong>تطابق کند</strong>.';
$PMF_LANG['ad_adus_adduser'] = 'افزودن کابر';
$PMF_LANG['ad_adus_name'] = 'نام:';
$PMF_LANG['ad_adus_password'] = 'رمز عبور:';
$PMF_LANG['ad_adus_add'] = 'افزودن کاربر';
$PMF_LANG['ad_adus_suc'] = 'کاربر با <strong>موفقیت</strong> اضافه شد.';
$PMF_LANG['ad_adus_edit'] = 'اصلاح نمایه';
$PMF_LANG['ad_adus_dberr'] = '<strong>اشکال در پایگاه داده!</strong>';
$PMF_LANG['ad_adus_exerr'] = 'نام کاربری <strong>موجود</strong> است.';
$PMF_LANG['ad_sess_id'] = 'شماره ';
$PMF_LANG['ad_sess_sid'] = 'شماره دوره';
$PMF_LANG['ad_sess_ip'] = 'آدرس آی‌پی';
$PMF_LANG['ad_sess_time'] = 'زمان';
$PMF_LANG['ad_sess_pageviews'] = 'بازید صفحات';
$PMF_LANG['ad_sess_search'] = 'جستجو';
$PMF_LANG['ad_sess_sfs'] = 'جستجو برای دوره';
$PMF_LANG['ad_sess_s_ip'] = 'آی‌پی:';
$PMF_LANG['ad_sess_s_minct'] = 'دقیقه اعمال:';
$PMF_LANG['ad_sess_s_date'] = 'تاریخ';
$PMF_LANG['ad_sess_s_after'] = 'بعد از';
$PMF_LANG['ad_sess_s_before'] = 'قبل از';
$PMF_LANG['ad_sess_s_search'] = 'جستجو';
$PMF_LANG['ad_sess_session'] = 'دوره';
$PMF_LANG['ad_sess_r'] = 'نتایج جستجو برای';
$PMF_LANG['ad_sess_referer'] = 'ارجاع دهنده:';
$PMF_LANG['ad_sess_browser'] = 'کاوشگر:';
$PMF_LANG['ad_sess_ai_rubrik'] = 'موضوع:';
$PMF_LANG['ad_sess_ai_artikel'] = 'مطلب:';
$PMF_LANG['ad_sess_ai_sb'] = 'کلمات جستجو شده:';
$PMF_LANG['ad_sess_ai_sid'] = 'شماره دوره:';
$PMF_LANG['ad_sess_back'] = 'برگرد';
$PMF_LANG['ad_rs'] = 'آمار امتیازها';
$PMF_LANG['ad_rs_rating_1'] = 'امتیاز بندی ';
$PMF_LANG['ad_rs_rating_2'] = 'کاربران نشان میدهند:';
$PMF_LANG['ad_rs_red'] = 'قرمز';
$PMF_LANG['ad_rs_green'] = 'سبز';
$PMF_LANG['ad_rs_altt'] = 'با متوسط کمتر از ۲';
$PMF_LANG['ad_rs_ahtf'] = 'با متوسط بالاتر از ۴';
$PMF_LANG['ad_rs_no'] = 'امتیاز دهی موجود نیست';
$PMF_LANG['ad_auth_insert'] = 'لطفاً نام کاربری و رمز عبور خود را وارد کنید.';
$PMF_LANG['ad_auth_user'] = 'نام کاربری:';
$PMF_LANG['ad_auth_passwd'] = 'رمز عبور:';
$PMF_LANG['ad_auth_ok'] = 'OK';
$PMF_LANG['ad_auth_reset'] = 'پاک شود';
$PMF_LANG['ad_auth_fail'] = 'نام کابری یا رمز عبور صحیح نیست.';
$PMF_LANG['ad_auth_sess'] = 'شماره دوره سپری شده‌است.';
$PMF_LANG['ad_config_edit'] = 'اصلاح تنظیمات';
$PMF_LANG['ad_config_save'] = 'ذخیره تنظیمات';
$PMF_LANG['ad_config_reset'] = 'پاک شود';
$PMF_LANG['ad_config_saved'] = 'تنظیمات با موفقیت ذخیره شدند.';
$PMF_LANG['ad_menu_editconfig'] = 'اصلاح تنظیمات';
$PMF_LANG['ad_att_none'] = 'الصاقی موجود نیست';
$PMF_LANG['ad_att_att'] = 'فایل';
$PMF_LANG['ad_att_add'] = 'الصاق فایل';
$PMF_LANG['ad_entryins_suc'] = 'مطلب با موفقیت ثبت شد.';
$PMF_LANG['ad_entryins_fail'] = 'اشکالی به وجود آمد.';
$PMF_LANG['ad_att_del'] = 'پاک کن';
$PMF_LANG['ad_att_nope'] = 'الصاقیها فقط در زمان اصلاح میتوانند اضافه شوند.';
$PMF_LANG['ad_att_delsuc'] = 'الصاقی با موفقیت اضافه شد.';
$PMF_LANG['ad_att_delfail'] = 'هنگام افزودن الصاقی مشکلی رخ داد.';
$PMF_LANG['ad_entry_add'] = 'ایجاد مطلب';
$PMF_LANG['ad_csv_make'] = '> یک پشتیبان تصویر کاملی از محتویات پایگاه داده است. فرمت پشتیبان SQL transaction است, که با ابزاری مثل phpMyAdmin یا خط فرمان sql متواند دوباره به پایگاه داده وارد شود. ایجاد حداقل یک پشتیبان در ماه توصیه میشود.';
$PMF_LANG['ad_csv_link'] = 'دانلود پشتیبان';
$PMF_LANG['ad_csv_head'] = 'ساخت پشتیبان';
$PMF_LANG['ad_att_addto'] = 'افزودن یک الصاقی به این موضوع';
$PMF_LANG['ad_att_addto_2'] = '';
$PMF_LANG['ad_att_butt'] = 'OK';
$PMF_LANG['ad_att_suc'] = 'فایل با موفقیت اضافه شد.';
$PMF_LANG['ad_att_fail'] = 'مشکلی در هنگام افزودن الصاقی رخ داد.';
$PMF_LANG['ad_att_close'] = 'بستن پنجره';
$PMF_LANG['ad_csv_restore'] = 'با استفاده از این فرم می‌توانید محتوای پایگاه داده‌ای را که توسط phpMyFAQ پشتیبان گرفته شده است بازگردانی کنید. توجه داشته باشید که داده‌های کنونی از بین خواهند رفت.';
$PMF_LANG['ad_csv_file'] = 'پرونده';
$PMF_LANG['ad_csv_ok'] = 'OK';
$PMF_LANG['ad_csv_linklog'] = 'پشتیبان‌گیری از لاگ‌ها';
$PMF_LANG['ad_csv_linkdat'] = 'پشتیبان‌گیری از داده‌ها';
$PMF_LANG['ad_csv_head2'] = 'برگردان';
$PMF_LANG['ad_csv_no'] = 'به نظر نمی‌رسد این پرونده یک پشتیبان از phpMyFAQ باشد. ';
$PMF_LANG['ad_csv_prepare'] = 'آماده‌سازی برای پرس و جوی پایگاه داده...';
$PMF_LANG['ad_csv_process'] = 'پرس و جو';
$PMF_LANG['ad_csv_of'] = 'از';
$PMF_LANG['ad_csv_suc'] = 'موفقیت‌آمیز بود.';
$PMF_LANG['ad_csv_backup'] = 'پشتیبان‌گیری';
$PMF_LANG['ad_csv_rest'] = 'برگرداندن یک پشتیبان';
$PMF_LANG['ad_menu_backup'] = 'پشتیبان';
$PMF_LANG['ad_logout'] = 'دوره بسته شد.';
$PMF_LANG['ad_news_edit'] = 'اصلاح خبرها';
$PMF_LANG['ad_cookie'] = 'کوکی‌ها';
$PMF_LANG['ad_sess_head'] = 'مشاهده دوره‌ها';
$PMF_LANG['msgAddCategory'] = 'افزودن موضوع';
$PMF_LANG['ad_kateg_rename'] = 'تغییر نام';
$PMF_LANG['ad_adminlog_date'] = 'تاریخ';
$PMF_LANG['ad_adminlog_user'] = 'کاربر';
$PMF_LANG['ad_adminlog_ip'] = 'آدرس آی‌پی';
$PMF_LANG['ad_stat_sess'] = 'دوره‌ها';
$PMF_LANG['ad_stat_days'] = 'روزها';
$PMF_LANG['ad_stat_vis'] = 'دوره‌ها (مشاهدات)';
$PMF_LANG['ad_stat_vpd'] = 'مشاهدات در روز';
$PMF_LANG['ad_stat_fien'] = 'اولین سیاهه';
$PMF_LANG['ad_stat_laen'] = 'آخرین سیاهه';
$PMF_LANG['ad_stat_browse'] = 'گردش در دوره‌ها';
$PMF_LANG['ad_stat_ok'] = 'OK';
$PMF_LANG['ad_ques_take'] = 'گذاشتن پرسش و اصلاح';
$PMF_LANG['no_cats'] = 'موضوعی پیدا نشد.';
$PMF_LANG['ad_log_lger'] = 'رمز عبور اشتباه یا نام کاربری اشتباه.';
$PMF_LANG['ad_log_sess'] = 'دوره تمام شده.';
$PMF_LANG['ad_log_edit'] = 'فرم \"اصلاح کاربر\"-برای کاربر ذیل: ';
$PMF_LANG['ad_log_crea'] = 'فرم \"کاربر جدید\".';
$PMF_LANG['ad_log_crsa'] = 'مطلب جدید ایجاد شد.';
$PMF_LANG['ad_log_ussa'] = 'به روز کردن اطلاعات برای کاربر ذیل: ';
$PMF_LANG['ad_log_usde'] = 'کاربرهای زیر پاک شدند: ';
$PMF_LANG['ad_log_beed'] = 'فرم اصلاح برای کاربران زیر: ';
$PMF_LANG['ad_log_bede'] = 'مطالب زیر پاک شدند: ';
$PMF_LANG['msgVisits'] = 'مشاهدات';
$PMF_LANG['ad_start_articles'] = 'مطالب';
$PMF_LANG['ad_start_comments'] = 'نظرات';
$PMF_LANG['ad_categ_paste'] = 'الصاق';
$PMF_LANG['ad_categ_cut'] = 'برش';
$PMF_LANG['msgCopy'] = 'رونوشت';
$PMF_LANG['ad_categ_process'] = 'پردازش موضوعات...';
$PMF_LANG['err_NotAuth'] = '<strong>شما شناسایی نشدید.</strong>';
$PMF_LANG['msgPreviusPage'] = 'صفحه قبل';
$PMF_LANG['msgNextPage'] = 'صفحه بعد';
$PMF_LANG['msgPageDoublePoint'] = 'صفحه: ';
$PMF_LANG['msgMainCategory'] = 'موضوع اصلی';
$PMF_LANG['ad_passwdsuc'] = 'رمز عبور شما عوض شد.';
$PMF_LANG['msgPDF'] = 'نمایش به صورت فایل پی‌دی‌اف';
$PMF_LANG['ad_xml_head'] = 'پشتیبان اکس‌ام‌ال';
$PMF_LANG['ad_xml_hint'] = 'ذخیره تمام پرسش‌های متداول در یک فایل XML.';
$PMF_LANG['ad_xml_gen'] = 'ساخت فایل XML';
$PMF_LANG['ad_entry_locale'] = 'زبان';
$PMF_LANG['msgLanguageSubmit'] = 'تغییر زبان';
$PMF_LANG['ad_entry_preview'] = 'پیش‌نمایش';
$PMF_LANG['ad_attach_1'] = 'لطفا در تنظیمات یک شاخه برای الصاقی‌ها انتخاب کنید.';
$PMF_LANG['ad_attach_2'] = 'لطفا در تنظیمات یک پیوند برای الصاقی‌ها انتخاب کنید.';
$PMF_LANG['ad_attach_3'] = 'فایل attachment.php بدون مجوزهای لازم اجرا نمیشود.';
$PMF_LANG['ad_attach_4'] = 'فایل الصاقی باید از %s بایت کوچکتر باشد.';
$PMF_LANG['ad_menu_export'] = 'استخراج پرسش‌های متداول';
$PMF_LANG['ad_export_file'] = 'اشتباه: فایل نوشته نشد.';
$PMF_LANG['ad_export_pdf'] = 'خروجی PDF برای تمام مطالب';
$PMF_LANG['permission::0'] = 'افزودن کاربر';
$PMF_LANG['permission::1'] = 'اصلاح کاربر';
$PMF_LANG['permission::2'] = 'حذف کاربر';
$PMF_LANG['permission::3'] = 'افزودن مطلب';
$PMF_LANG['permission::4'] = 'اصلاح مطلب';
$PMF_LANG['permission::5'] = 'حذف مطلب';
$PMF_LANG['permission::6'] = 'مشاهده سیاهه';
$PMF_LANG['permission::7'] = 'مشاهده سیاهه مدیر';
$PMF_LANG['permission::8'] = 'حذف نظر';
$PMF_LANG['permission::9'] = 'افزودن خبر';
$PMF_LANG['permission::10'] = 'اصلاح خبر';
$PMF_LANG['permission::11'] = 'حذف خبر';
$PMF_LANG['permission::12'] = 'افزودن موضوع';
$PMF_LANG['permission::13'] = 'اصلاح موضوع';
$PMF_LANG['permission::14'] = 'حذف موضوع';
$PMF_LANG['permission::15'] = 'تغییر رمز عبور';
$PMF_LANG['permission::16'] = 'اصلاح تنظیمات';
$PMF_LANG['permission::17'] = 'افزودن الصاقی';
$PMF_LANG['permission::18'] = 'حذف الصاقی';
$PMF_LANG['permission::19'] = 'ساخت پشتیبان';
$PMF_LANG['permission::20'] = 'برگرداندن پشتیبان';
$PMF_LANG['permission::21'] = 'حذف پرسش‌های باز';
$PMF_LANG['permission::22'] = 'اصلاح تجدیدنظرها';
$PMF_LANG['msgAttachedFiles'] = 'فایلهای الصاق شده:';
$PMF_LANG['ad_user_action'] = 'عمل';
$PMF_LANG['msgEmail'] = 'ایمیل:';
$PMF_LANG['ad_entry_allowComments'] = 'اجازه به نظرها';
$PMF_LANG['msgWriteNoComment'] = 'شما میتوانید نظر دهید';
$PMF_LANG['msgRealname'] = 'نام واقعی:';
$PMF_LANG['ad_export_generate_pdf'] = 'تولید فایل PDF';
$PMF_LANG['ad_export_full_پرسش‌های متداول'] = 'پرسش‌های متداول شما بصورت فایل PDF: ';
$PMF_LANG['err_bannedIP'] = 'آی‌پی شما مسدود شده است.';
$PMF_LANG['err_SaveQuestion'] = 'کادرهای اجباری <strong>نام شما</strong>, <strong>ایمیل شما</strong>, <strong>پرسش شما</strong> و, اگر درخواست شده باشد <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"درباره کپچا در ویکی‌پدیا بیشتر بخوانید\" target=\"_blank\">Captcha</a> کد</strong> هستند.<br><br><a href=\"javascript:history.back();\">یک صفحه برگرد</a><br><br>';
$PMF_LANG['ad_entry_fontcolor'] = 'رنگ قلم: ';
$PMF_LANG['ad_entry_fontsize'] = 'اندازه قلم: ';
$LANG_CONF['main.language'] = array("select", "پرونده زبان");
$LANG_CONF['main.languageDetection'] = array("checkbox", "فعال سازی مذاکره متنی خودکار");
$LANG_CONF['main.titleFAQ'] = array("input", "عنوان پرسش‌های متداول");
$LANG_CONF['main.currentVersion'] = array("print", "نسخه پرسش‌های متداول");
$LANG_CONF['main.metaDescription'] = array("input", "شرح صفحه");
$LANG_CONF['main.metaPublisher'] = array("input", "نام ناشر");
$LANG_CONF['main.administrationMail'] = array("input", "آدرس ایمیل مدیر");
$LANG_CONF['main.contactInformation'] = array("area", "اطلاعات تماس");
$LANG_CONF['main.send2friendText'] = array("area", "متن برای صفحه ارسال به دوست");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "حداکثر حجم برای الصاق‌ها بر حسب بایت (حداکثر %بایت)");
$LANG_CONF['records.disableAttachments'] = array("checkbox", "الصاق‌ها در پایین ورودی پیوند داده شوند؟");
$LANG_CONF['main.enableUserTracking'] = array("checkbox", "ردیابی فعالیت‌های کاربر؟");
$LANG_CONF['main.enableAdminLog'] = array("checkbox", "از لاگ‌های مدیر سیستم استفاده شود؟");
$LANG_CONF['security.ipCheck'] = array("checkbox", "آیا مایلید هنگام بررسی شماره‌های شناسه یکتا در پرونده admin.php، آی‌پی بررسی شود؟");
$LANG_CONF['records.numberOfRecordsPerPage'] = array("input", "تعداد عناوین نمایش داده شده در صفحه");
$LANG_CONF['records.numberOfShownNewsEntries'] = array("input", "تعداد مقالات جدید");
$LANG_CONF['security.bannedIPs'] = array("area", "قدغن کردن این آی‌پی‌ها");
$LANG_CONF['ldap.ldapSupport'] = array("checkbox", "پشتیبانی از LDAP فعال شود؟ (پیش‌فرض: غیرفعال)");
$PMF_LANG['ad_categ_new_main_cat'] = 'به عنوان موضوع اصلی';
$PMF_LANG['ad_categ_paste_error'] = 'انتقال این موضوع ممکن نیست.';
$PMF_LANG['ad_categ_move'] = 'انتقال موضوع';
$PMF_LANG['ad_categ_lang'] = 'زبان';
$PMF_LANG['ad_categ_desc'] = 'توضیحات';
$PMF_LANG['ad_categ_change'] = 'تغییر توسط';
$PMF_LANG['lostPassword'] = 'رمز عبور را فراموش کردید? اینجا را کلیک کنید.';
$PMF_LANG['lostpwd_err_1'] = 'خطا: نام کاربری و ایمیل پیدا نشد.';
$PMF_LANG['lostpwd_err_2'] = 'خطا: مطالب اشتباه!';
$PMF_LANG['lostpwd_text_1'] = 'از بابت درخواست مشخصات خودتان ممنون.';
$PMF_LANG['lostpwd_text_2'] = 'لطفا برای پرسش‌های متداول یک رمز عبور جدید در بخش مدیریت تعیین کنید.';
$PMF_LANG['lostpwd_mail_okay'] = 'ایمیل ارسال شد.';
$PMF_LANG['msgButtonFetchLatestVersion'] = 'آخرین ورژن را دریافت كنید';
$PMF_LANG['ad_xmlrpc_latest'] = 'آخرین ورژن موجود است';
$PMF_LANG['ad_categ_select'] = 'انتخاب زبان موضوع';
$PMF_LANG['msgSitemap'] = 'نقشه سایت';
$PMF_LANG['err_inactiveArticle'] = 'این مطلب در دست تجدیدنظر است و نمیتوانید مشاهده کنید.';
$PMF_LANG['msgArticleCategories'] = 'موضوعات مربوط به این مطلب';
$PMF_LANG['ad_menu_searchplugin'] = 'جستجو در افزونه‌ها';
$PMF_LANG['ad_search_plugin_install'] = 'نصب افزونه فایرفاکس';
$PMF_LANG['ad_search_plugin_title'] = 'ایجاد افزونه جستجو';
$PMF_LANG['ad_search_plugin_ttitle'] = 'عنوان در کادر جستجوی افزونه فایرفاکس:';
$PMF_LANG['ad_search_plugin_tdesc'] = 'توضیحات:';
$PMF_LANG['ad_search_plugin_create'] = 'ایجاد افزونه جستجو برای فایرفاکس';
$PMF_LANG['ad_search_plugin_success'] = 'افزونه جستجو در موزیلا فایرفاکس با موفقیت ایجاد شد!';
$PMF_LANG['ad_entry_solution_id'] = 'شماره اختصاصی راه حل';
$PMF_LANG['ad_entry_FAQ_record'] = 'مطلب پرسش‌های متداول';
$PMF_LANG['ad_entry_new_revision'] = 'ایجاد تجدیدنظر جدید?';
$PMF_LANG['ad_entry_record_administration'] = 'مدیریت مطالب';
$PMF_LANG['ad_entry_revision'] = 'تجدید نظر';
$PMF_LANG['ad_changerev'] = 'انتخاب تجدید نظر';
$PMF_LANG['msgCaptcha'] = 'حروف داخل تصویر را تایپ کنید';
$PMF_LANG['msgSelectCategories'] = 'جستجو در ...';
$PMF_LANG['msgAllCategories'] = '... تمام موضوعات';
$PMF_LANG['ad_you_should_update'] = 'phpMyFAQ شما قدیمی شده‌است. باید برنامه را به جدیدترین نسخه در دسترسی به‌روز کنید';
$PMF_LANG['msgAdvancedSearch'] = 'جستجوی پیشرفته';
$PMF_LANG['spamControlCenter'] = 'مرکز کنترل هرزنامه';
$LANG_CONF['spam.enableSafeEmail'] = array("checkbox", "چاپ ایمیل کاربر به شیوه امن (پیش‌فرض: فعال).");
$LANG_CONF['spam.checkBannedWords'] = array("checkbox", "بررسی محتوای فرما عمومی برای لغات ممنوعه (پیش‌فرض: فعال).");
$LANG_CONF['spam.enableCaptchaCode'] = array("checkbox", "استفاده از کپچا جهت اعطای مجوز ارسال فرم به عموم (پیش‌فرض: فعال).");
$PMF_LANG['ad_firefoxsearch_plugin_title'] = 'ساخت افزونه جستجوی فایرفاکس';
$PMF_LANG['ad_msiesearch_plugin_install'] = 'افزونه جستجو اینترنت اكسپلورر را دریافت كنید';
$PMF_LANG['ad_msiesearch_plugin_title'] = 'ساخت افزونه جستجو برای IE7';
$PMF_LANG['ad_msiesearch_plugin_ttitle'] = 'عنوان برای کادر جستجوی IE7';
$PMF_LANG['ad_msiesearch_plugin_create'] = 'ساخت افزونه جستجو برای IE7.';
$PMF_LANG['ad_msiesearch_plugin_success'] = 'افزونه جستجو برای IE7 با موفقیت ساخته شد.';
$PMF_LANG['ad_session_expiring'] = 'نشست شما در %d دقیقه دیگر منقضی می‌شود؛ آیا مایل به ادامه کار هستید؟';
$PMF_LANG['ad_stat_management'] = 'مدیریت دوره‌ها';
$PMF_LANG['ad_stat_choose'] = 'انتخاب ماه';
$PMF_LANG['ad_stat_delete'] = 'حذف سریع دوره‌های انتخاب شده';
$PMF_LANG['msgVoteBad'] = 'کاملا بی فایده';
$PMF_LANG['msgWriteComment'] = 'نظرات این آموزش';
$PMF_LANG['msgShowCategory'] = 'بررسی اجمالی مطالب:';
$PMF_LANG['msgTransToolNoteFileSaving'] = 'لطفا توجه داشته باشید تا زمانی که دگمه ذخیره را کلیک نکنید هیچ پرونده‌ای نوشته نخواهد شد.';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'صفحه %d با موفقیت در میانگیر قرار گرفت.';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'خطای قرار گرفتن صفحه %d در میانگیر';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'در حال قرار دادن صفحه % در میانگیر';
$PMF_LANG['ad_record_active'] = 'فعال';
$PMF_LANG['msgAttachmentInvalid'] = 'پیوست معتبر نمی باشد لطفا به مدیر سیستم اطلاع دهید';
$PMF_LANG['list_all_users'] = 'لیست تمام كاربران';
$PMF_LANG['records.orderingPopularپFAQs.visits'] = 'لیست بیشترین ورودیهای مشاهده شده';
$PMF_LANG['records.orderingPopularFAQs.voting'] = 'لیست بیشترین امتیازات ';
$PMF_LANG['msgShowHelp'] = 'لطفاكلمات را با كاما جدا كنید..';
$PMF_LANG['msgUpdateFAQDate'] = 'به روز رسانی';
$PMF_LANG['msgKeepFAQDate'] = 'نگه داشتن';
$PMF_LANG['msgEditFAQDat'] = 'ویرایش';
$PMF_LANG['searchControlCenter'] = 'جستجو';
$PMF_LANG['search.relevance.thema-content-keywords'] = 'پرسش - پاسخ -كلمه كلیدی';
$PMF_LANG['search.relevance.thema-keywords-content'] = 'پرسش -كلمه كلیدی - پاسخ';
$PMF_LANG['search.relevance.content-thema-keywords'] = 'پاسخ - پرسش -كلمه كلیدی';
$PMF_LANG['search.relevance.content-keywords-thema'] = 'پاسخ -كلمه كلیدی - پرسش';
$PMF_LANG['search.relevance.keywords-content-thema'] = 'كلمه كلیدی- پاسخ - پرسش';
$PMF_LANG['search.relevance.keywords-thema-content'] = 'كلمه كلیدی- پرسش - پاسخ';
$PMF_LANG['msgLoginUser'] = 'ورود';
$LANG_CONF['search.numberSearchTerms'] = array('input', ' تعداد کلمات کلیدی فهرست شده');
$LANG_CONF['records.orderingPopularFAQs'] = array('select', 'مرتب‌ کردن پرسش‌های متداول برتر\'s');
$LANG_CONF['search.useAjaxSearchOnStartpage'] = array('checkbox', 'پاسخ سریع در صفحه آغازین (پیش‌فرض: غیرفعال)');
$LANG_CONF['search.relevance'] = array('select', 'مرتب کردن بر اساس رابطه');
$LANG_CONF['search.enableRelevance'] = array('checkbox', 'پشتیبانی از رابطه فعال شود؟ (پیش‌فرض: غبرفعال)');
$PMF_LANG['ad_menu_attachments'] = 'پیوست های آموزش';
$PMF_LANG['ad_menu_attachment_admin'] = 'مدیریت ضمیمه';
$PMF_LANG['msgAttachmentsFilename'] = 'نام فایل';
$PMF_LANG['msgAttachmentsFilesize'] = 'سایز فایل';
$PMF_LANG['msgAttachmentsMimeType'] = 'MIME Type';
$PMF_LANG['msgAttachmentsWannaDelete'] = 'برای پاك كردن ضمیمه مطمئن هستید?';
$PMF_LANG['msgAttachmentsDeleted'] = 'پاك شد<strong>موفقیت</strong>پیوست با';
$PMF_LANG['ad_menu_reports'] = 'گزارش';
$PMF_LANG['ad_stat_report_fields'] = 'فیلد';
$PMF_LANG['ad_stat_report_category'] = 'موضوع';
$PMF_LANG['ad_stat_report_sub_category'] = 'زیرشاخه';
$PMF_LANG['ad_stat_report_translations'] = 'ترجمه ها';
$PMF_LANG['ad_stat_report_language'] = 'زبان';
$PMF_LANG['ad_stat_report_id'] = ' ID آموزش';
$PMF_LANG['ad_stat_report_sticky'] = 'آموزش مهم';
$PMF_LANG['ad_stat_report_title'] = 'پرسش';
$PMF_LANG['ad_stat_report_creation_date'] = 'تاریخ';
$PMF_LANG['ad_stat_report_owner'] = 'نویسنده اصلی';
$PMF_LANG['ad_stat_report_last_modified_person'] = 'آخرین نگارنده';
$PMF_LANG['ad_stat_report_url'] = 'آدرس';
$PMF_LANG['ad_stat_report_visits'] = 'بازدید';
$PMF_LANG['ad_stat_report_make_report'] = 'تولید گزارش';
$PMF_LANG['ad_stat_report_make_csv'] = 'CSV خروجی ';
$PMF_LANG['msgRegistration'] = 'ثبت نام';
$PMF_LANG['msgRegistrationCredentials'] = 'برای ثبت نام لطفا نام و كلمه عبور خود را به همراه ایمیل وارد كنید';
$PMF_LANG['msgRegistrationNote'] = 'بعد از اتمام ثبت نام توسط مدیر سیستم اعتبار سنجی خواهید شد.';
$PMF_LANG['ad_entry_changelog_history'] = 'تاریخچه تغییرات';
$LANG_CONF['security.ssoSupport'] = array('checkbox', 'پشتیبانی از SSO (پیش‌فرض: غیرفعال)');
$LANG_CONF['security.ssoLogoutRedirect'] = array('input', 'URL تغییر مسیر خروج از SSO');
$LANG_CONF['main.dateFormat'] = array('input', 'فرمت تاریخ (پیش‌فرض: Y-m-d H:i)');
$PMF_LANG['securityControlCenter'] = 'تنظیمات امنیتی';
$PMF_LANG['ad_search_delsuc'] = 'جستجوی عبارت با موفقیت حذف شد.';
$PMF_LANG['ad_search_delfail'] = 'واژه جستجو حذف نمی شد.';
$PMF_LANG['msg_about_FAQ'] = 'در مورد این آموزش';
$PMF_LANG['msgTableOfContent'] = 'جدول محتوا';
$PMF_LANG['msgExportAllFAQs'] = 'چاپ همه به صورت PDF';
$PMF_LANG['msgOnlineVerificationCheck'] = 'اعتبار سنجی بر خط';
$PMF_LANG['msgOnlineVerificationCheckButton'] = 'بررسی نگارش جدید';
$PMF_LANG['ad_verification_notokay'] = 'نسخه phpMyFAQ شما تغییرات محلی دارد';
$PMF_LANG['ad_verification_okay'] = 'نسخه phpMyFAQ شما با موفقیت شناسایی گردید.';
$PMF_LANG['cacheControlCenter'] = 'پیکربندی حافظه نهان';
$PMF_LANG['msgAdminSearchFaqs'] = 'جستجو برای آموزش';
$PMF_LANG['msg2answerپرسش‌های متداول'] = 'پاسخ داده شده';
$PMF_LANG['headerUserControlPanel'] = 'تنظیمات كاربران';
$PMF_LANG['rememberMe'] = 'مرا به خاطر بسپار';
$PMF_LANG['ad_menu_instances'] = 'پرسش‌های متداول چند-سایتی';
$PMF_LANG['ad_record_inactive'] = 'غیرفعال سازی پرسش‌های متداول';
$PMF_LANG['msgMode'] = 'Modus';
$PMF_LANG['msgMaintenanceMode'] = 'پرسش‌های متداول در حالت نگهداری است';
$PMF_LANG['msgOnlineMode'] = ' فعال سازی پرسش‌های متداول ';
$LANG_CONF['security.enableLoginOnly'] = array('checkbox', 'پرسش‌های متداول کاملا امن شود(پیش‌فرض: غیرفعال)');
$LANG_CONF['security.useSslOnly'] = array('checkbox', 'پرسش‌های متداول فقط با SSL (پیش‌فرض: غیرفعال)');
$LANG_CONF['records.enableCloseQuestion'] = array('checkbox', 'بستن پرسش پس از پاسخ؟');
$LANG_CONF['records.enableDeleteQuestion'] = array('checkbox', 'حذف پرسش پس از پاسخ?');
$LANG_CONF['main.maintenanceMode'] = array('checkbox', 'قرار دادن در حالت پشتیبانی');
$PMF_LANG['msgShowMore'] = 'نمایش بیشتر';
$PMF_LANG['msgQuestionAnswered'] = 'پرسش پاسخ داده شد';
$PMF_LANG['msgMessageQuestionAnswered'] = 'پرسش شما در %s پاسخ داده شد.لطفا در اینجا مشاهده کنید:';
$PMF_LANG['ad_stopwords_desc'] = 'لطفا زبانی را جهت افزودن یا ویرایش لغات پایانی انتخاب کنید';
$PMF_LANG['ad_visits_per_day'] = 'مشاهده روزانه';
$PMF_LANG['ad_instance_add'] = 'یک نمونه جدید چند سایتی phpMyFAQ ایجاد کن';
$PMF_LANG['ad_instance_error_notwritable'] = 'پوشه /چندسایتی قابل نوشتن نیست.';
$PMF_LANG['ad_instance_url'] = 'آدرس اینترنتی نمونه';
$PMF_LANG['ad_instance_path'] = 'مسیر نمونه';
$PMF_LANG['ad_instance_name'] = 'نام نمونه';
$PMF_LANG['ad_instance_email'] = 'ایمیل مدیر سیستم';
$PMF_LANG['ad_instance_admin'] = 'نام كاربری مدیر';
$PMF_LANG['ad_instance_password'] = 'كلمه عبور مدیر';
$PMF_LANG['ad_instance_hint'] = 'هشدار: ساخت یک نمونه جدید از phpMyFAQ زمان‌بر است!';
$PMF_LANG['ad_instance_button'] = 'ذخیره نمونه';
$PMF_LANG['ad_instance_error_cannotdelete'] = 'امكان حذف نمونه وجود ندارد ';
$PMF_LANG['ad_instance_config'] = 'پیكره بندی نمونه';
$PMF_LANG['msgAboutThisNews'] = 'درباره این خبر';
$PMF_LANG['msgAccessDenied'] = 'امكان دسترسی موجود نیست';
$LANG_CONF['records.randomSort'] = array('checkbox', 'مرتب سازی پرسش‌های متداول به صورت تصادفی (پیش‌فرض: غیرفعال)');
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array('checkbox', ' فعال سازی ویرایشگر تعبیه شده WYSIWYG در (پیش‌فرض: غیرفعال)');
$LANG_CONF['main.enableGravatarSupport'] = array('checkbox', 'پشتیبانی از Gravatar (پیش‌فرض: غیرفعال)');

return $PMF_LANG;
