<?php

/**
 * The Italian language file.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Stefano Bramato <stefano@pubblideaweb.it>
 * @auhtor Rudy <webmaster@queenarena.com>
 * @author Matteo Scaramuccia <matteo@phpmyfaq.de>
 * @author Amedeo Fragai <amedeo.fragai@scasrl.it>
 * @copyright 2004-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2004-06-24
 * @codingStandardsIgnoreFile
 */

$PMF_LANG['metaCharset'] = 'UTF-8';
$PMF_LANG['metaLanguage'] = 'it';
$PMF_LANG['language'] = 'Italian';
$PMF_LANG['direction']= 'ltr';
$PMF_LANG['nplurals'] = '2';
$PMF_LANG['msgCategory'] = 'Categorie';
$PMF_LANG['msgShowAllCategories'] = 'Tutte le categorie';
$PMF_LANG['msgSearch'] = 'Cerca';
$PMF_LANG['msgAddContent'] = 'Aggiungi FAQ';
$PMF_LANG['msgQuestion'] = 'Fai una domanda';
$PMF_LANG['msgOpenQuestions'] = 'Domande aperte';
$PMF_LANG['msgHelp'] = 'Aiuto';
$PMF_LANG['msgContact'] = 'Contatto';
$PMF_LANG['msgHome'] = 'Home FAQ';
$PMF_LANG['msgNews'] = ' News FAQ';
$PMF_LANG['msgUserOnline'] = ' Utenti Online';
$PMF_LANG['msgXMLExport'] = 'XML-File';
$PMF_LANG['msgBack2Home'] = 'Torna alla pagina principale';
$PMF_LANG['msgFullCategories'] = 'Categorie con FAQ';
$PMF_LANG['msgFullCategoriesIn'] = 'Categorie con FAQ in ';
$PMF_LANG['msgSubCategories'] = 'Sottocategorie';
$PMF_LANG['msgEntries'] = 'FAQ';
$PMF_LANG['msgEntriesIn'] = 'Domande in ';
$PMF_LANG['msgViews'] = 'visite';
$PMF_LANG['msgPage'] = 'Pagina ';
$PMF_LANG['msgPages'] = ' Pagine';
$PMF_LANG['msgPrevious'] = 'Precedente';
$PMF_LANG['msgNext'] = 'Successiva';
$PMF_LANG['msgCategoryUp'] = 'Una categoria sopra';
$PMF_LANG['msgLastUpdateArticle'] = 'Ultimo aggiornamento: ';
$PMF_LANG['msgAuthor'] = 'Autore: ';
$PMF_LANG['msgPrinterFriendly'] = 'Versione stampabile';
$PMF_LANG['msgPrintArticle'] = 'Stampa questa voce';
$PMF_LANG['msgMakeXMLExport'] = 'Esporta come file XML';
$PMF_LANG['msgAverageVote'] = 'Valutazione media:';
$PMF_LANG['msgVoteUsability'] = 'Valuta questa FAQ:';
$PMF_LANG['msgVoteFrom'] = 'su';
$PMF_LANG['msgVoteBad'] = '<em>completamente inutile</em>';
$PMF_LANG['msgVoteGood'] = '<em>molto utile</em>';
$PMF_LANG['msgVotings'] = 'Voti';
$PMF_LANG['msgVoteSubmit'] = 'Vota';
$PMF_LANG['msgVoteThanks'] = 'Grazie per aver votato!';
$PMF_LANG['msgYouCan'] = 'Tu puoi: ';
$PMF_LANG['msgWriteComment'] = 'commenta questa FAQ';
$PMF_LANG['msgShowCategory'] = 'Descrizione del contenuto: ';
$PMF_LANG['msgCommentBy'] = 'Commento di ';
$PMF_LANG['msgCommentHeader'] = 'Commenta questa FAQ';
$PMF_LANG['msgYourComment'] = 'Il tuo commento:';
$PMF_LANG['msgCommentThanks'] = 'Grazie per aver inviato il tuo commento!';
$PMF_LANG['msgSeeXMLFile'] = 'Apri il file XML';
$PMF_LANG['msgSend2Friend'] = 'Invia ad un amico';
$PMF_LANG['msgS2FButton'] = 'Invia e-mail';
$PMF_LANG['msgSearchWord'] = 'Parola chiave';
$PMF_LANG['msgSearchFind'] = 'Cerca risultati per ';
$PMF_LANG['msgSearchAmount'] = ' risultato di ricerca';
$PMF_LANG['msgSearchAmounts'] = ' risultati di ricerca';
$PMF_LANG['msgSearchCategory'] = 'Categoria: ';
$PMF_LANG['msgSearchContent'] = 'Contenuto: ';
$PMF_LANG['msgNewContentHeader'] = 'Proposta per una FAQ';
$PMF_LANG['msgNewContentAddon'] = "Il tuo suggerimento non apparirà immediatamente, ma verrà controllato da noi prima della pubblicazione. I campi obbligatori sono campi contrassegnati con *.";
$PMF_LANG['msgNewContentName'] = 'Il tuo Nome:';
$PMF_LANG['msgNewContentMail'] = 'Il tuo indirizzo email:';
$PMF_LANG['msgNewContentCategory'] = 'Quale categoria vuoi scegliere?';
$PMF_LANG['msgNewContentTheme'] = 'Titolo:';
$PMF_LANG['msgNewContentArticle'] = 'La tua FAQ:';
$PMF_LANG['msgNewContentKeywords'] = 'Parole chiave:';
$PMF_LANG['msgNewContentLink'] = 'Link per questa FAQ:';
$PMF_LANG['msgNewContentSubmit'] = 'Invia';
$PMF_LANG['msgInfo'] = 'Altre informazioni: ';
$PMF_LANG['msgNewContentThanks'] = 'Grazie per aver inviato la tua proposta!';
$PMF_LANG['msgNoQuestionsAvailable'] = 'Al momento non ci sono domande.';
$PMF_LANG['msgNewQuestion'] = 'Scrivi la tua domanda qui sotto';
$PMF_LANG['msgAskCategory'] = 'La tua domanda &egrave; sulla categoria:';
$PMF_LANG['msgAskYourQuestion'] = 'La tua domanda:';
$PMF_LANG['msgAskThx4Mail'] = '<h2>Grazie per aver inviato la tua domanda!</h2>';
$PMF_LANG['msgDate_User'] = 'Data / Utente';
$PMF_LANG['msgQuestion2'] = 'Domanda';
$PMF_LANG['msg2answer'] = 'Rispondi';
$PMF_LANG['msgQuestionText'] = 'Qui puoi vedere le domande fatte da altri utenti. Puoi rispondere a queste domande perché la risposta potrebbe essere inserita nelle FAQ.';
$PMF_LANG['msgHelpText'] = 'L\'accesso alle FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions, in italiano le <em>Domande Pi&ugrave; frequenti</em>) &egrave; semplice. Puoi effettuare ricerche tramite:<ul><li>le <strong><a href=\"?action=show\">categorie</a></strong>;</li><li>il <strong><a href=\"?action=search\">motore di ricerca</a></strong>, usando opportune parole chiave.</li></ul>';
$PMF_LANG['msgContactEMail'] = 'Spedisci una email al webmaster:';
$PMF_LANG['msgMessage'] = 'Il tuo messaggio:';
$PMF_LANG['msgTopTen'] = 'TOP 10';
$PMF_LANG['msgHomeThereAre'] = 'Ci sono ';
$PMF_LANG['msgHomeArticlesOnline'] = ' FAQ disponibili';
$PMF_LANG['msgNoNews'] = 'Non ci sono news disponibili.';
$PMF_LANG['msgLatestArticles'] = 'Le ultime 5 FAQ pubblicate';
$PMF_LANG['msgMailThanks'] = 'Grazie per la tua proposta per una nuova FAQ.';
$PMF_LANG['msgMailCheck'] = 'C\'&egrave; una nuova proposta per una FAQ!Per cortesia controlla la sezione \'Amministrazione\'.';
$PMF_LANG['msgMailContact'] = 'Il tuo messaggio &egrave; stato spedito all\'amministratore.';
$PMF_LANG['err_noDatabase'] = 'Nessuna connessione al database disponibile.';
$PMF_LANG['err_noHeaders'] = 'Nessuna categoria trovata.';
$PMF_LANG['msgErrorNoRecords'] = 'Nessuna FAQ trovata.';
$PMF_LANG['err_badID'] = 'ID sbagliato.';
$PMF_LANG['err_noTopTen'] = 'Nessuna FAQ ancora disponibile.';
$PMF_LANG['err_nothingFound'] = 'Nessun informazione trovata.';
$PMF_LANG['err_SaveEntries'] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>categoria</strong>, il <strong>titolo</strong>, il <strong>testo</strong> e, quando richiesto, il <strong>codice <a href=\"https://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br>Per favore controlla i dati immessi.<br><br><a href=\"javascript:history.back();\">Una pagina indietro</a><br><br>';
$PMF_LANG['err_SaveComment'] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, il <strong>tuo commento</strong> e, quando richiesto, il <strong>codice <a href=\"https://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br>Per favore controlla i dati immessi.<br><br><a href=\"javascript:history.back();\">Una pagina indietro</a><br><br>';
$PMF_LANG['err_VoteTooMuch'] = 'Attenzione, hai gi&agrave votato: non registriamo votazioni multiple nella stessa sessione. Riprova pi&ugrave tardi.';
$PMF_LANG['err_noVote'] = '<strong>Non hai votato!</strong> <a href=\"javascript:history.back();\">Per cortesia clicca qui</a>, per votare.';
$PMF_LANG['err_noMailAdress'] = 'Il tuo indirizzo email non &egrave; corretto.<br><a href=\"javascript:history.back();\">indietro</a>';
$PMF_LANG['err_sendMail'] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, gli <strong>indirizzi dei destinatari</strong> e, quando richiesto, il <strong>codice <a href=\"https://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br>Per favore controlla i dati immessi.';
$PMF_LANG['help_search'] = '<strong>Cerca nelle FAQ</strong>: usando un criterio come \"<strong style=\"font-style: italic; color: Red;\">parola1 parola2</strong>\" puoi fare una ricerca ordinata per importanza per due (o piu\') chiavi di ricerca.<strong>Nota:</strong> la tua chiave deve essere composta da almeno 4 caratteri altrimenti potrebbe non essere accettata.';
$PMF_LANG['ad'] = 'SEZIONE AMMINISTRAZIONE';
$PMF_LANG['ad_menu_user_administration'] = 'Amministrazione <em>Utenti</em>';
$PMF_LANG['ad_menu_entry_aprove'] = 'Approva <em>FAQ</em>';
$PMF_LANG['ad_menu_entry_edit'] = 'Modifica <em>FAQ</em>';
$PMF_LANG['ad_menu_categ_add'] = 'Aggiungi <em>Categoria</em>';
$PMF_LANG['msgHeaderCategoryOverview'] = 'Amministrazione delle <em>Categorie</em>';
$PMF_LANG['ad_menu_news_add'] = 'Aggiungi <em>News</em>';
$PMF_LANG['ad_menu_news_edit'] = 'Modifica <em>News</em>';
$PMF_LANG['ad_menu_open'] = 'Modifica <em>Domande aperte</em>';
$PMF_LANG['ad_menu_stat'] = 'Statistica delle <em>Valutazioni</em>';
$PMF_LANG['ad_menu_cookie'] = 'Gestione del <em>Cookie</em>';
$PMF_LANG['ad_menu_session'] = 'Vedi <em>Sessioni</em>';
$PMF_LANG['ad_menu_adminlog'] = 'Vedi <em>Log Amministrazione</em>';
$PMF_LANG['ad_menu_passwd'] = 'Cambia la <em>tua password</em>';
$PMF_LANG['ad_menu_logout'] = 'Esci';
$PMF_LANG['ad_menu_startpage'] = 'Pagina iniziale';
$PMF_LANG['ad_msg_identify'] = 'Per cortesia identificati.';
$PMF_LANG['ad_msg_passmatch'] = 'Entrambe le password devono <strong>corrispondere</strong>!';
$PMF_LANG['ad_msg_savedsuc_1'] = 'Il profilo di';
$PMF_LANG['ad_msg_savedsuc_2'] = '&egrave; stato salvato con successo.';
$PMF_LANG['ad_msg_mysqlerr'] = 'A causa di un <strong>errore del database</strong> il profilo potrebbe non essere stato salvato.';
$PMF_LANG['ad_msg_noauth'] = 'Non sei autorizzato.';
$PMF_LANG['ad_gen_page'] = 'Pagina';
$PMF_LANG['ad_gen_of'] = 'di';
$PMF_LANG['ad_gen_lastpage'] = 'Pagina precedente';
$PMF_LANG['ad_gen_nextpage'] = 'Pagina successiva';
$PMF_LANG['ad_gen_save'] = 'Salva';
$PMF_LANG['ad_gen_reset'] = 'Reimposta';
$PMF_LANG['ad_gen_yes'] = 'Si';
$PMF_LANG['ad_gen_no'] = 'No';
$PMF_LANG['ad_gen_top'] = 'Inizio della pagina';
$PMF_LANG['ad_gen_ncf'] = 'Nessuna categoria trovata!';
$PMF_LANG['ad_gen_delete'] = 'Cancella';
$PMF_LANG['ad_user'] = 'Amministrazione utenti';
$PMF_LANG['ad_user_username'] = 'Utenti registrati';
$PMF_LANG['ad_user_rights'] = 'Diritti';
$PMF_LANG['ad_user_edit'] = 'Modifica';
$PMF_LANG['ad_user_delete'] = 'Cancella';
$PMF_LANG['ad_user_add'] = 'Aggiungi utente';
$PMF_LANG['ad_user_profou'] = 'Profilo dell\'utente';
$PMF_LANG['ad_user_name'] = 'Nome (<em>username</em>)';
$PMF_LANG['ad_user_password'] = 'Password';
$PMF_LANG['ad_user_confirm'] = 'Conferma password';
$PMF_LANG['ad_user_del_1'] = 'L\'utente';
$PMF_LANG['ad_user_del_2'] = 'sta per essere cancellato?';
$PMF_LANG['ad_user_del_3'] = 'Sei sicuro?';
$PMF_LANG['ad_user_deleted'] = 'Utente cancellato con successo.';
$PMF_LANG['ad_user_checkall'] = 'Seleziona tutto';
$PMF_LANG['msgHeaderFAQOverview'] = 'Gestione delle FAQ';
$PMF_LANG['ad_entry_id'] = 'ID';
$PMF_LANG['ad_entry_topic'] = 'Titolo';
$PMF_LANG['ad_entry_action'] = 'Azione';
$PMF_LANG['ad_entry_edit_1'] = 'Modifica FAQ';
$PMF_LANG['ad_entry_edit_2'] = '';
$PMF_LANG['ad_entry_theme'] = 'Tema:';
$PMF_LANG['ad_entry_content'] = 'Contenuto:';
$PMF_LANG['ad_entry_keywords'] = 'Parole chiave:';
$PMF_LANG['ad_entry_author'] = 'Autore:';
$PMF_LANG['ad_entry_category'] = 'Categoria:';
$PMF_LANG['ad_entry_active'] = 'Attivo?';
$PMF_LANG['ad_entry_date'] = 'Data';
$PMF_LANG['ad_entry_status'] = 'Status der FAQ';
$PMF_LANG['ad_entry_changed'] = 'Motivo della modifica:';
$PMF_LANG['ad_entry_changelog'] = 'Diario delle variazioni';
$PMF_LANG['ad_entry_commentby'] = 'Commentato da';
$PMF_LANG['ad_entry_comment'] = 'Commenti:';
$PMF_LANG['ad_entry_save'] = 'Salva';
$PMF_LANG['msgDelete'] = 'Cancella';
$PMF_LANG['ad_entry_delcom_1'] = 'Sei sicuro che il commento dell\'utente';
$PMF_LANG['ad_entry_delcom_2'] = 'debba essere cancellato?';
$PMF_LANG['ad_entry_commentdelsuc'] = 'Il commento &egrave; stato cancellato <strong>con successo</strong>.';
$PMF_LANG['ad_entry_back'] = 'Indietro';
$PMF_LANG['ad_entry_commentdelfail'] = 'Il commento <strong>non</strong> &egrave; stato cancellato.';
$PMF_LANG['ad_entry_savedsuc'] = 'Le modifiche sono state salvate con <strong>successo</strong>.';
$PMF_LANG['ad_entry_savedfail'] = 'Purtroppo c\'&egrave; stato un <strong>errore con il database</strong>.';
$PMF_LANG['ad_entry_del_1'] = 'Vuoi veramente che la FAQ';
$PMF_LANG['ad_entry_del_2'] = 'di ';
$PMF_LANG['ad_entry_del_3'] = ' venga cancellata?';
$PMF_LANG['ad_entry_delsuc'] = 'Pubblicazione cancellata con <strong>successo</strong>.';
$PMF_LANG['ad_entry_delfail'] = 'La publicazione <strong>non</strong> &egrave; stata cancellata!';
$PMF_LANG['ad_news_header'] = 'Titolo:';
$PMF_LANG['ad_news_text'] = 'Testo:';
$PMF_LANG['ad_news_link_url'] = 'Link (<strong>senza <em>https://</em></strong>):';
$PMF_LANG['ad_news_link_title'] = 'Titolo del link:';
$PMF_LANG['ad_news_link_target'] = 'Target del link:';
$PMF_LANG['ad_news_link_window'] = 'Il link apre una nuova finestra';
$PMF_LANG['ad_news_link_faq'] = 'Il link si apre nella stessa finestra';
$PMF_LANG['ad_news_add'] = 'Aggiungi news';
$PMF_LANG['ad_news_id'] = '#';
$PMF_LANG['ad_news_headline'] = 'Titolo';
$PMF_LANG['ad_news_date'] = 'Data';
$PMF_LANG['ad_news_action'] = 'Azione';
$PMF_LANG['ad_news_update'] = 'Aggiorna';
$PMF_LANG['ad_news_delete'] = 'Cancella';
$PMF_LANG['ad_news_nodata'] = 'Nessuna informazione trovata nel database';
$PMF_LANG['ad_news_updatesuc'] = 'Le News sono state aggiornate.';
$PMF_LANG['ad_news_del'] = 'Sei sicuro di voler cancellare questa news?';
$PMF_LANG['ad_news_yesdelete'] = 'Si, cancella!';
$PMF_LANG['ad_news_nodelete'] = 'No, non cancellare!';
$PMF_LANG['ad_news_delsuc'] = 'News cancellata.';
$PMF_LANG['ad_news_updatenews'] = 'Aggiorna news';
$PMF_LANG['ad_categ_new'] = 'Aggiungi una nuova categoria';
$PMF_LANG['ad_categ_catnum'] = 'Numero della categoria:';
$PMF_LANG['ad_categ_subcatnum'] = 'Numero Sottocategoria:';
$PMF_LANG['ad_categ_nya'] = '<em>non ancora disponibile!</em>';
$PMF_LANG['ad_categ_titel'] = 'Titolo della categoria';
$PMF_LANG['ad_categ_add'] = 'Aggiungi una nuova categoria';
$PMF_LANG['ad_categ_existing'] = 'Categorie esistenti';
$PMF_LANG['ad_categ_id'] = '#';
$PMF_LANG['ad_categ_categ'] = 'Categoria';
$PMF_LANG['ad_categ_subcateg'] = 'Sottocategoria';
$PMF_LANG['ad_categ_action'] = 'Azione';
$PMF_LANG['ad_categ_update'] = 'Aggiorna';
$PMF_LANG['ad_categ_delete'] = 'Cancella';
$PMF_LANG['ad_categ_updatecateg'] = 'Aggiorna questa categoria';
$PMF_LANG['ad_categ_nodata'] = 'Nessuna informazione trovata nel database';
$PMF_LANG['msgCategoryRemark'] = 'Ricorda che se cancelli una categoria, tutte le FAQ appartenenti a quella categoria <strong>non saranno pi&ugrave; visibili</strong>. Per renderle nuovamente visibili, devi riassegnarle ad una nuova categoria.';
$PMF_LANG['ad_categ_edit_1'] = 'Modifica';
$PMF_LANG['ad_categ_edit_2'] = 'Categoria';
$PMF_LANG['ad_categ_added'] = 'La categoria &egrave; stata aggiunta.';
$PMF_LANG['ad_categ_updated'] = 'La categoria &egrave; stata aggiornata.';
$PMF_LANG['ad_categ_del_yes'] = 'Si, cancella!';
$PMF_LANG['ad_categ_del_no'] = 'No, non cancellare!';
$PMF_LANG['ad_categ_deletesure'] = 'Sei sicuro di voler cancellare questa categoria?';
$PMF_LANG['ad_categ_deleted'] = 'Categoria cancellata.';
$PMF_LANG['ad_cookie_cookiesuc'] = 'Il cookie &egrave; stato registrato con <strong>successo</strong>.';
$PMF_LANG['ad_cookie_already'] = 'Il cookie esiste gi&agrave;. Hai le seguenti opzioni:';
$PMF_LANG['ad_cookie_again'] = 'Registra il cookie nuovamente';
$PMF_LANG['ad_cookie_delete'] = 'Cancella il cookie';
$PMF_LANG['ad_cookie_no'] = 'Il cookie con le tue attuali credenziali non &egrave; stato ancora registrato. Con questo cookie puoi salvare i tuoi dati di accesso, in modo da non doverli ricordare per il prossimo accesso. Hai le seguenti opzioni:';
$PMF_LANG['ad_cookie_set'] = 'Registra il cookie';
$PMF_LANG['ad_cookie_deleted'] = 'Cookie rimosso con successo.';
$PMF_LANG['ad_adminlog'] = '<em>Log</em> Amministrazione';
$PMF_LANG['ad_passwd_cop'] = 'Cambia la tua password';
$PMF_LANG['ad_passwd_old'] = 'Vecchia password:';
$PMF_LANG['ad_passwd_new'] = 'Nuova password:';
$PMF_LANG['ad_passwd_con'] = 'Conferma la nuova password:';
$PMF_LANG['ad_passwd_change'] = 'Modifica la tua password';
$PMF_LANG['ad_passwd_suc'] = 'Password modificata con successo.';
$PMF_LANG['ad_passwd_remark'] = '<strong>ATTENZIONE:</strong><br>Il cookie deve essere nuovamente registrato!';
$PMF_LANG['ad_passwd_fail'] = 'La vecchia password <strong>deve essere inserita correttamente</strong> e la nuova password <strong>deve corrispondere</strong> con quella digitata per conferma.';
$PMF_LANG['ad_adus_adduser'] = 'Aggiungi utente';
$PMF_LANG['ad_adus_name'] = 'Nome:';
$PMF_LANG['ad_adus_password'] = 'Password:';
$PMF_LANG['ad_adus_add'] = 'Aggiungi user';
$PMF_LANG['ad_adus_suc'] = 'Utente aggiunto con <strong>successo</strong>.';
$PMF_LANG['ad_adus_edit'] = 'Modifica profilo';
$PMF_LANG['ad_adus_dberr'] = '<strong>errore con il database!</strong>';
$PMF_LANG['ad_adus_exerr'] = 'Username <strong>gi&agrave; esistente</strong>.';
$PMF_LANG['ad_sess_id'] = 'ID';
$PMF_LANG['ad_sess_sid'] = 'ID Sessione';
$PMF_LANG['ad_sess_ip'] = 'Indirizzo IP';
$PMF_LANG['ad_sess_time'] = 'Tempo';
$PMF_LANG['ad_sess_pageviews'] = 'VistaPagine';
$PMF_LANG['ad_sess_search'] = 'Cerca';
$PMF_LANG['ad_sess_sfs'] = 'Cerca per sessioni';
$PMF_LANG['ad_sess_s_ip'] = 'IP:';
$PMF_LANG['ad_sess_s_minct'] = 'min. azioni:';
$PMF_LANG['ad_sess_s_date'] = 'Data';
$PMF_LANG['ad_sess_s_after'] = 'dopo';
$PMF_LANG['ad_sess_s_before'] = 'prima';
$PMF_LANG['ad_sess_s_search'] = 'Cerca';
$PMF_LANG['ad_sess_session'] = 'Sessione';
$PMF_LANG['ad_sess_r'] = 'Cerca risultati per';
$PMF_LANG['ad_sess_referer'] = 'Referer:';
$PMF_LANG['ad_sess_browser'] = 'Browser:';
$PMF_LANG['ad_sess_ai_rubrik'] = 'Categoria:';
$PMF_LANG['ad_sess_ai_artikel'] = 'FAQ:';
$PMF_LANG['ad_sess_ai_sb'] = 'Stringhe di ricerca:';
$PMF_LANG['ad_sess_ai_sid'] = 'ID di sessione:';
$PMF_LANG['ad_sess_back'] = 'Indietro';
$PMF_LANG['ad_rs'] = 'Statistica delle Valutazioni';
$PMF_LANG['ad_rs_rating_1'] = 'La classifica di';
$PMF_LANG['ad_rs_rating_2'] = 'Mostra utenti:';
$PMF_LANG['ad_rs_red'] = 'Rosso';
$PMF_LANG['ad_rs_green'] = 'Verde';
$PMF_LANG['ad_rs_altt'] = 'con una media piu bassa di 20%';
$PMF_LANG['ad_rs_ahtf'] = 'con una media piu alta di 80%';
$PMF_LANG['ad_rs_no'] = 'Nessuna statistica disponibile';
$PMF_LANG['ad_auth_insert'] = 'Inserisci le tue credenziali: <em>username</em> e <em>password</em>.';
$PMF_LANG['ad_auth_user'] = 'Pseudonimo:';
$PMF_LANG['ad_auth_passwd'] = 'Password:';
$PMF_LANG['ad_auth_ok'] = 'OK';
$PMF_LANG['ad_auth_reset'] = 'Reimposta';
$PMF_LANG['ad_auth_fail'] = 'Credenziali non valide.';
$PMF_LANG['ad_auth_sess'] = 'Sessione scaduta.';
$PMF_LANG['ad_config_edit'] = 'Modifica la configurazione';
$PMF_LANG['ad_config_save'] = 'Salva la configurazione';
$PMF_LANG['ad_config_reset'] = 'Reimposta';
$PMF_LANG['ad_config_saved'] = 'La configurazione &egrave; stata salvata con successo.';
$PMF_LANG['ad_menu_editconfig'] = 'Modifica la <em>configurazione</em>';
$PMF_LANG['ad_att_none'] = 'Nessun allegato disponibile';
$PMF_LANG['ad_att_att'] = 'File';
$PMF_LANG['ad_att_add'] = 'Allega file';
$PMF_LANG['ad_entryins_suc'] = 'FAQ salvata con successo.';
$PMF_LANG['ad_entryins_fail'] = 'FAQ non salvata: si &egrave; verificato un errore.';
$PMF_LANG['ad_att_del'] = 'Cancella';
$PMF_LANG['ad_att_nope'] = 'Si possono aggiungere allegati solo durante la modifica.';
$PMF_LANG['ad_att_delsuc'] = 'L\'allegato &egrave; stato cancellato con successo.';
$PMF_LANG['ad_att_delfail'] = 'C\'&egrave; stato un errore durante la cancellazione dell\'allegato.';
$PMF_LANG['ad_entry_add'] = 'Crea <em>FAQ</em>';
$PMF_LANG['ad_csv_make'] = 'Un backup &egrave; una immagine completa del contenuto del database. Il formato del backup &egrave; un file di transazione SQL, che pu&ograve; essere importato tramite programmi come phpMyAdmin o client SQL a linea di comando.<br><em>Suggerimento:</em> un backup dovrebbe essere fatto <strong>almeno</strong> una volta al mese (la decisione dipende anche dalla dinamicit&agrave; delle FAQ).';
$PMF_LANG['ad_csv_link'] = 'Scarica il backup';
$PMF_LANG['ad_csv_head'] = 'Crea un backup';
$PMF_LANG['ad_att_addto'] = 'Aggiungi un allegato al documento corrente';
$PMF_LANG['ad_att_addto_2'] = '';
$PMF_LANG['ad_att_butt'] = 'OK';
$PMF_LANG['ad_att_suc'] = 'Il file &egrave; stato allegato con successo';
$PMF_LANG['ad_att_fail'] = 'C\'&egrave; stato un errore nell\'allegare il file.';
$PMF_LANG['ad_att_close'] = 'Chiudi questa finestra';
$PMF_LANG['ad_csv_restore'] = 'Usando questo modulo puoi ripristinare il contenuto del database, usando un backup <strong>creato da phpMyFAQ</strong>. Attenzione: il database esistente verr&agrave; <strong>SOVRASCRITTO</strong>, con la conseguente perdit&agrave; totale dei dati attuali!';
$PMF_LANG['ad_csv_file'] = 'File';
$PMF_LANG['ad_csv_ok'] = 'OK';
$PMF_LANG['ad_csv_linklog'] = 'Crea un backup dei <em>LOG</em>';
$PMF_LANG['ad_csv_linkdat'] = 'Crea un backup delle <em>FAQ</em>';
$PMF_LANG['ad_csv_head2'] = 'Ripristina un precedente backup';
$PMF_LANG['ad_csv_no'] = 'Questo file non sembra essere un backup di phpMyFAQ.';
$PMF_LANG['ad_csv_prepare'] = 'Sto preparando le queries al database...';
$PMF_LANG['ad_csv_process'] = 'Querying...';
$PMF_LANG['ad_csv_of'] = 'di';
$PMF_LANG['ad_csv_suc'] = 'sono andate a buon fine.';
$PMF_LANG['ad_csv_backup'] = 'Backup';
$PMF_LANG['ad_csv_rest'] = 'Ripristina un precedente backup';
$PMF_LANG['ad_menu_backup'] = 'Gestione del <em>Backup</em>';
$PMF_LANG['ad_logout'] = 'Sessione terminata con successo.';
$PMF_LANG['ad_news_edit'] = 'Modifica news';
$PMF_LANG['ad_cookie'] = 'Memorizza le tue credenziali di accesso in un cookie';
$PMF_LANG['ad_sess_head'] = 'Visualizza le Sessioni';
$PMF_LANG['msgAddCategory'] = 'Aggiungi una nuova categoria';
$PMF_LANG['ad_kateg_rename'] = 'Rinomina';
$PMF_LANG['ad_adminlog_date'] = 'Data';
$PMF_LANG['ad_adminlog_user'] = 'Utente';
$PMF_LANG['ad_adminlog_ip'] = 'Indirizzo IP';
$PMF_LANG['ad_stat_sess'] = 'Sessioni';
$PMF_LANG['ad_stat_days'] = 'Giorni';
$PMF_LANG['ad_stat_vis'] = 'Sessioni (Accessi)';
$PMF_LANG['ad_stat_vpd'] = 'Accessi per Giorno';
$PMF_LANG['ad_stat_fien'] = 'Primo Log';
$PMF_LANG['ad_stat_laen'] = 'Ultimo Log';
$PMF_LANG['ad_stat_browse'] = 'Naviga Sessioni';
$PMF_LANG['ad_stat_ok'] = 'OK';
$PMF_LANG['ad_ques_take'] = 'Apri la domanda e modificala';
$PMF_LANG['no_cats'] = 'Nessuna categoria trovata!';
$PMF_LANG['ad_log_lger'] = 'Credenziali non valide.';
$PMF_LANG['ad_log_sess'] = 'Sessione scaduta.';
$PMF_LANG['ad_log_edit'] = 'Form \"Modifica Utente\", per il seguente utente: ';
$PMF_LANG['ad_log_crea'] = 'Form \"Nuova FAQ\".';
$PMF_LANG['ad_log_crsa'] = 'Creato un nuovo elemento.';
$PMF_LANG['ad_log_ussa'] = 'Aggiornati i dati per il seguente utente: ';
$PMF_LANG['ad_log_usde'] = 'Cancellato il seguente utente: ';
$PMF_LANG['ad_log_beed'] = 'Form di modifica per il seguente utente: ';
$PMF_LANG['ad_log_bede'] = 'Cancella il seguente elemento: ';
$PMF_LANG['msgVisits'] = 'Accessi';
$PMF_LANG['ad_start_articles'] = 'FAQ';
$PMF_LANG['ad_start_comments'] = 'Commenti';
$PMF_LANG['ad_categ_paste'] = 'Incolla';
$PMF_LANG['ad_categ_cut'] = 'Taglia';
$PMF_LANG['msgCopy'] = 'Copia';
$PMF_LANG['ad_categ_process'] = 'Sto processando le categorie...';
$PMF_LANG['err_NotAuth'] = '<strong>Non sei autorizzato.</strong>';
$PMF_LANG['msgPreviusPage'] = 'Pagina precedente';
$PMF_LANG['msgNextPage'] = 'Pagina successiva';
$PMF_LANG['msgPageDoublePoint'] = 'Pagina: ';
$PMF_LANG['msgMainCategory'] = 'Categoria principale';
$PMF_LANG['ad_passwdsuc'] = 'La tua password &egrave; stata cambiata.';
$PMF_LANG['msgPDF'] = 'Mostra come file PDF';
$PMF_LANG['ad_xml_head'] = 'XML-Backup';
$PMF_LANG['ad_xml_hint'] = 'Salva tutti i <em>record</em> delle tue FAQ in un unico file XML.';
$PMF_LANG['ad_xml_gen'] = 'Crea il file XML';
$PMF_LANG['ad_entry_locale'] = 'Lingua';
$PMF_LANG['msgLanguageSubmit'] = 'Cambia lingua';
$PMF_LANG['ad_entry_preview'] = 'Anteprima';
$PMF_LANG['ad_attach_1'] = 'Scegli una cartella per gli allegati innanzitutto nella configurazione.';
$PMF_LANG['ad_attach_2'] = 'Scegli un link per gli allegati innanzitutto nella configurazione.';
$PMF_LANG['ad_attach_3'] = 'Il file <em>attachment.php</em> non pu&ograve; essere aperto senza una autenticazione.';
$PMF_LANG['ad_attach_4'] = 'Il file in allegato non deve essere pi&ugrave; grande di %s Bytes.';
$PMF_LANG['ad_menu_export'] = 'Esporta';
$PMF_LANG['ad_export_file'] = 'Errore: non posso scrivere il file.';
$PMF_LANG['ad_export_pdf'] = 'Esporta tutte le FAQ in un unico file PDF';
$PMF_LANG['permission::add_user'] = 'Aggiunge utenti';
$PMF_LANG['permission::edit_user'] = 'Modifica utenti';
$PMF_LANG['permission::delete_user'] = 'Cancella utenti';
$PMF_LANG['permission::add_faq'] = 'Aggiunge FAQ';
$PMF_LANG['permission::edit_faq'] = 'Modifica FAQ';
$PMF_LANG['permission::delete_faq'] = 'Cancella FAQ';
$PMF_LANG['permission::viewlog'] = 'Vede il diario delle sessioni utente';
$PMF_LANG['permission::adminlog'] = 'Vede il diario delle sessioni amministrative';
$PMF_LANG['permission::delcomment'] = 'Cancella commenti';
$PMF_LANG['permission::addnews'] = 'Aggiunge news';
$PMF_LANG['permission::editnews'] = 'Modifica news';
$PMF_LANG['permission::delnews'] = 'Cancella news';
$PMF_LANG['permission::addcateg'] = 'Aggiunge categorie';
$PMF_LANG['permission::editcateg'] = 'Modifica categorie';
$PMF_LANG['permission::delcateg'] = 'Cancella categorie';
$PMF_LANG['permission::passwd'] = 'Cambia password';
$PMF_LANG['permission::editconfig'] = 'Modifica la configurazione';
$PMF_LANG['permission::addatt'] = 'Aggiunge allegati';
$PMF_LANG['permission::delatt'] = 'Cancella allegati';
$PMF_LANG['permission::backup'] = 'Crea backup';
$PMF_LANG['permission::restore'] = 'Ripristina backup';
$PMF_LANG['permission::delquestion'] = 'Cancella domande aperte';
$PMF_LANG['permission::changebtrevs'] = 'Modifica revisioni';
$PMF_LANG['msgAttachedFiles'] = 'Files allegati:';
$PMF_LANG['ad_user_action'] = 'Azione';
$PMF_LANG['msgEmail'] = 'Indirizzo email:';
$PMF_LANG['ad_entry_allowComments'] = 'Permetti commenti:';
$PMF_LANG['msgWriteNoComment'] = 'Non puoi commentare questa FAQ';
$PMF_LANG['msgRealname'] = 'Vero nome:';
$PMF_LANG['ad_export_generate_pdf'] = 'Crea il file PDF';
$PMF_LANG['ad_export_full_faq'] = 'Ecco le tue FAQ in un unico file PDF: ';
$PMF_LANG['err_bannedIP'] = '&Egrave; stato vietato l\'accesso al tuo indirizzo IP.';
$PMF_LANG['err_SaveQuestion'] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>tua domanda</strong> e, quando richiesto, il <strong>codice <a href=\"https://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br>Per favore controlla i dati immessi.<br><br><a href=\"javascript:history.back();\">Una pagina indietro</a><br><br>';
$PMF_LANG['ad_entry_fontcolor'] = 'Colore del carattere: ';
$PMF_LANG['ad_entry_fontsize'] = 'Dimensione del carattere: ';
$LANG_CONF['main.language'] = array("select", "File di lingua");
$LANG_CONF['main.languageDetection'] = array("checkbox", "Abilita la <em>automatic content negotiation</em>");
$LANG_CONF['main.titleFAQ'] = array("input", "Titolo del sistema");
$LANG_CONF['main.currentVersion'] = array("print", "Versione di phpMyFAQ");
$LANG_CONF['main.metaDescription'] = array("input", "Descrizione della pagina");
$LANG_CONF['main.metaPublisher'] = array("input", "Nome dell'Editore");
$LANG_CONF['main.administrationMail'] = array("input", "Indirizzo email dell'Amministratore");
$LANG_CONF['main.contactInformation'] = array("area", "Testo per la pagina dei <em>Contatti</em>");
$LANG_CONF['main.send2friendText'] = array("area", "Testo per la pagina <em>Invia ad un amico</em>");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "Massima dimensione per gli allegati, in Bytes (max. %sByte)");
$LANG_CONF['records.disableAttachments'] = array("checkbox", "Mostra il link agli allegati");
$LANG_CONF['main.enableUserTracking'] = array("checkbox", "Abilito il tracciamento per le attivit&agrave; dell'Utente?");
$LANG_CONF['main.enableAdminLog'] = array("checkbox", "Abilito il tracciamento per le attivit&agrave; di Amministrazione?");
$LANG_CONF['security.ipCheck'] = array("checkbox", "Vuoi controllare l'IP quando verifico l'<em>UIN</em> in <em>admin.php</em>?");
$LANG_CONF['records.numberOfRecordsPerPage'] = array("input", "Numero di elementi visualizzati per pagina");
$LANG_CONF['records.numberOfShownNewsEntries'] = array("input", "Numero di elementi visualizzati per la sezione News");
$LANG_CONF['security.bannedIPs'] = array("area", "Vieta l'accesso a questi indirizzi IP");
$LANG_CONF['ldap.ldapSupport'] = array("checkbox", "Attivare il supporto LDAP? (predefinito: disabilitato)");
$LANG_CONF['main.referenceURL'] = array("input", "<em>Base URL</em> dell'installazione di phpMyFAQ, es: https://www.example.org/faq/ (&egrave; necessaria per la verifica dei links)");
$LANG_CONF['records.enableVisibilityQuestions'] = array("checkbox", "Disabilitare la visibilit&agrave; delle domande appena inserite?");
$LANG_CONF['security.permLevel'] = array("select", "Configurazione della Permessistica");
$PMF_LANG['ad_categ_new_main_cat'] = 'come nuova categoria principale';
$PMF_LANG['ad_categ_paste_error'] = 'Non &egrave; possibile spostare questa categoria.';
$PMF_LANG['ad_categ_move'] = 'Sposta';
$PMF_LANG['ad_categ_lang'] = 'Lingua';
$PMF_LANG['ad_categ_desc'] = 'Descrizione';
$PMF_LANG['ad_categ_change'] = 'Cambia con';
$PMF_LANG['lostPassword'] = 'Hai dimenticato la password? Clicca qui.';
$PMF_LANG['lostpwd_err_1'] = 'Errore: <em>Utente</em> e <em>Indirizzo e-mail</em> non trovati.';
$PMF_LANG['lostpwd_err_2'] = 'Errore: i dati inseriti sono sbagliati!';
$PMF_LANG['lostpwd_text_1'] = 'Grazie per aver richiesto i tuoi dati.';
$PMF_LANG['lostpwd_text_2'] = 'Per cortesia crea una nuova password personale nella sezione amministrativa delle FAQ.';
$PMF_LANG['lostpwd_mail_okay'] = 'L\'e-mail &egrave; stata inviata.';
$PMF_LANG['msgButtonFetchLatestVersion'] = 'Controlla quale sia l\'ultima versione stabile di phpMyFAQ';
$PMF_LANG['ad_xmlrpc_latest'] = 'Questa &egrave; l\'ultima versione disponibile presso';
$PMF_LANG['ad_categ_select'] = 'Selezione la lingua della categoria';
$PMF_LANG['msgSitemap'] = 'Mappa sito';
$PMF_LANG['err_inactiveArticle'] = 'Questa FAQ &egrave; in revisione e non pu&ograve; essere visualizzata.';
$PMF_LANG['msgArticleCategories'] = 'Categorie per questa FAQ';
$PMF_LANG['ad_entry_solution_id'] = 'ID univoco';
$PMF_LANG['ad_entry_faq_record'] = 'Dati della FAQ';
$PMF_LANG['ad_entry_new_revision'] = 'Vuoi creare una nuova versione?';
$PMF_LANG['ad_entry_record_administration'] = 'Gestione della FAQ';
$PMF_LANG['ad_entry_revision'] = 'Versione';
$PMF_LANG['ad_changerev'] = 'Seleziona la versione';
$PMF_LANG['msgCaptcha'] = 'Scrivi le lettere e i numeri che leggi nella immagine';
$PMF_LANG['msgSelectCategories'] = 'Cerca in: ';
$PMF_LANG['msgAllCategories'] = 'Tutte le categorie';
$PMF_LANG['ad_you_should_update'] = 'La tua installazione di phpMyFAQ non &egrave; aggiornata. Dovresti aggiornarla all\'ultima versione disponibile.';
$PMF_LANG['msgAdvancedSearch'] = 'Ricerca avanzata';
$PMF_LANG['spamControlCenter'] = 'Centro di controllo contro lo Spam';
$LANG_CONF['spam.enableSafeEmail'] = array('checkbox', 'Stampa l\'email dell\'utente in maniera sicura (predefinito: abilitato).');
$LANG_CONF['spam.checkBannedWords'] = array('checkbox', 'Controlla se il testo delle form pubbliche contenga parole vietate (predefinito: abilitato).');
$LANG_CONF['spam.enableCaptchaCode'] = array('checkbox', 'Usa un codice <a href="https://it.wikipedia.org/wiki/Captcha" title="Vai alla definizione di Wikipedia" target="_blank">captcha</a> per permettere la sottomissione delle form pubbliche (predefinito: abilitato).');
$PMF_LANG['ad_session_expiring'] = 'Questa sessione scadrà tra %d minuti: vuoi continuare a lavorare?';
$PMF_LANG['ad_stat_management'] = 'Gestione delle sessioni';
$PMF_LANG['ad_stat_choose'] = 'Scegli il mese';
$PMF_LANG['ad_stat_delete'] = 'Cancella immediatamente le sessioni selezionate';
$PMF_LANG['ad_menu_glossary'] = 'Glossario';
$PMF_LANG['ad_glossary_add'] = 'Aggiungi una voce al Glossario';
$PMF_LANG['ad_glossary_edit'] = 'Modifica una voce del Glossario';
$PMF_LANG['ad_glossary_item'] = 'Voce';
$PMF_LANG['ad_glossary_definition'] = 'Definizione';
$PMF_LANG['ad_glossary_save'] = 'Salva la voce';
$PMF_LANG['ad_glossary_save_success'] = 'La voce &egrave; stata salvata con successo!';
$PMF_LANG['ad_glossary_save_error'] = 'Si &egrave; verificato un errore: la voce non &egrave; stata salvata.';
$PMF_LANG['ad_glossary_update_success'] = 'La voce &egrave; stata aggiornata con successo!';
$PMF_LANG['ad_glossary_update_error'] = 'Si &egrave; verificato un errore: la voce non &egrave; stata aggiornata.';
$PMF_LANG['ad_glossary_delete'] = 'Cancella la voce';
$PMF_LANG['ad_glossary_delete_success'] = 'La voce &egrave; stata cancellata!';
$PMF_LANG['ad_glossary_delete_error'] = 'Si &egrave; verificato un errore: la voce non pu&ograve; essere cancellata.';
$PMF_LANG['msgNewQuestionVisible'] = 'La domanda deve essere verificata prima di essere pubblicata.';
$PMF_LANG['msgQuestionsWaiting'] = 'In attesa di essere pubblicate dagli amministratori: ';
$PMF_LANG['ad_entry_visibility'] = 'Pubblica';
$PMF_LANG['ad_user_error_password'] = 'Per cortesia inserisci una password.';
$PMF_LANG['ad_user_error_passwordsDontMatch'] = 'Le password non corrispondono ';
$PMF_LANG['ad_user_error_loginInvalid'] = 'Lo pseudonimo fornito non &egrave; valido.';
$PMF_LANG['ad_user_error_noEmail'] = 'Per cortesia inserisci un indirizzo email valido. ';
$PMF_LANG['ad_user_error_noRealName'] = 'Per cortesia inserisci il vero nome. ';
$PMF_LANG['ad_user_error_delete'] = 'Questo account non pu&ograve; essere cancellato. ';
$PMF_LANG['ad_user_error_noId'] = 'Nessun ID specificato. ';
$PMF_LANG['ad_user_error_protectedAccount'] = 'Questo account &egrave; \'protetto\'. ';
$PMF_LANG['ad_user_deleteUser'] = 'Cancella Utenti';
$PMF_LANG['ad_user_status'] = 'Stato:';
$PMF_LANG['ad_user_lastModified'] = 'Ultima modifica:';
$PMF_LANG['ad_gen_cancel'] = 'Torna indietro';
$PMF_LANG['permission::addglossary'] = 'Aggiunge voci al Glossario';
$PMF_LANG['permission::editglossary'] = 'Modifica voci del Glossario';
$PMF_LANG['permission::delglossary'] = 'Cancella voci del Glossario';
$PMF_LANG['ad_menu_group_administration'] = 'Amministrazione dei Gruppi';
$PMF_LANG['ad_user_loggedin'] = 'Sei autenticato come ';
$PMF_LANG['ad_group_details'] = 'Dettagli del Gruppo';
$PMF_LANG['ad_group_add'] = 'Aggiungi Gruppo';
$PMF_LANG['ad_group_add_link'] = 'Aggiungi il gruppo';
$PMF_LANG['ad_group_name'] = 'Nome:';
$PMF_LANG['ad_group_description'] = 'Descrizione:';
$PMF_LANG['ad_group_autoJoin'] = 'Autoiscrizione:';
$PMF_LANG['ad_group_suc'] = 'Il Gruppo &egrave; stato aggiunto con <strong>successo</strong>.';
$PMF_LANG['ad_group_error_noName'] = 'Per cortesia inserisci il nome del gruppo. ';
$PMF_LANG['ad_group_error_delete'] = 'Questo gruppo non pu&ograve; essere cancellato. ';
$PMF_LANG['ad_group_deleted'] = 'Il Gruppo &egrave; stato cancellato con <strong>successo</strong>.';
$PMF_LANG['ad_group_deleteGroup'] = 'Cancella Gruppi';
$PMF_LANG['ad_group_deleteQuestion'] = 'Sei sicuro che questo gruppo debba essere cancellato?';
$PMF_LANG['ad_user_uncheckall'] = 'Deseleziona tutto';
$PMF_LANG['ad_group_membership'] = 'Membri del Gruppo';
$PMF_LANG['ad_group_members'] = 'Membri';
$PMF_LANG['ad_group_addMember'] = '+';
$PMF_LANG['ad_group_removeMember'] = '-';
$PMF_LANG['ad_export_which_cat'] = 'Limita le FAQ da esportare (opzionale)';
$PMF_LANG['ad_export_cat_downwards'] = 'Anche le sottocategorie?';
$PMF_LANG['ad_export_type'] = 'Formato dell\'esportazione';
$PMF_LANG['ad_export_type_choose'] = 'Scegli tra i formati supportati:';
$PMF_LANG['ad_export_download_view'] = 'Scarichi il file o lo guardi subito?';
$PMF_LANG['ad_export_download'] = 'scarico';
$PMF_LANG['ad_export_view'] = 'guardo';
$PMF_LANG['ad_export_gen_xhtml'] = 'Crea il file XHTML';
$PMF_LANG['ad_export_gen_docbook'] = 'Crea il file Docbook';
$PMF_LANG['ad_news_data'] = 'Dati della notizia';
$PMF_LANG['ad_news_author_name'] = 'Nome dell\'autore:';
$PMF_LANG['ad_news_author_email'] = 'Email dell\'autore:';
$PMF_LANG['ad_news_set_active'] = 'Attiva:';
$PMF_LANG['ad_news_allowComments'] = 'Permetti commenti:';
$PMF_LANG['ad_news_expiration_window'] = 'Validit&agrave; della notizia (opzionale)';
$PMF_LANG['ad_news_from'] = 'Dal:';
$PMF_LANG['ad_news_to'] = 'Al:';
$PMF_LANG['ad_news_insertfail'] = 'Inserimento della notizia fallito.';
$PMF_LANG['ad_news_updatefail'] = 'Aggiornamento della notizia fallito.';
$PMF_LANG['newsShowCurrent'] = 'Mostra le notizie attuali.';
$PMF_LANG['newsShowArchive'] = 'Mostra le notizie archiviate.';
$PMF_LANG['newsArchive'] = ' News - Archvio';
$PMF_LANG['newsWriteComment'] = 'Commenta questa notizia';
$PMF_LANG['newsCommentDate'] = 'Inserito il: ';
$PMF_LANG['ad_record_expiration_window'] = 'Validit&agrave; della faq (opzionale)';
$PMF_LANG['adminHeaderDashboard'] = 'Home';
$PMF_LANG['admin_mainmenu_users'] = 'Utenti';
$PMF_LANG['admin_mainmenu_content'] = 'Contenuti';
$PMF_LANG['admin_mainmenu_statistics'] = 'Statistiche';
$PMF_LANG['admin_mainmenu_backup'] = 'Backup';
$PMF_LANG['admin_mainmenu_configuration'] = 'Configurazione';
$PMF_LANG['admin_mainmenu_logout'] = 'Logout';
$PMF_LANG['ad_categ_owner'] = 'Responsabile della categoria';
$PMF_LANG['adminSection'] = 'Amministrazione';
$PMF_LANG['err_expiredArticle'] = 'Questa FAQ è in scaduta e non può essere visualizzata.';
$PMF_LANG['err_expiredNews'] = 'Questa notizia è in scaduta e non può essere visualizzata.';
$PMF_LANG['err_inactiveNews'] = 'Questa notizia è in revisione e non può essere visualizzata.';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Cerca in tutte le lingue:';
$PMF_LANG['ad_entry_tags'] = '<a href="https://en.wikipedia.org/wiki/Tags" title="Vai alla definizione in inglese di Wikipedia" target="_blank">Tags</a>';
$PMF_LANG['msg_tags'] = '<a href="https://en.wikipedia.org/wiki/Tags" title="Vai alla definizione in inglese di Wikipedia" target="_blank">Tags</a>';
$PMF_LANG['msg_related_articles'] = 'FAQ correlate';
$LANG_CONF['records.numberOfRelatedArticles'] = array('input', 'Numero di FAQ correlate');
$PMF_LANG['ad_categ_trans_1'] = 'Traduci la categoria ';
$PMF_LANG['ad_categ_trans_2'] = 'Categoria';
$PMF_LANG['ad_categ_translatecateg'] = 'Traduci questa categoria';
$PMF_LANG['ad_categ_translate'] = 'Traduci';
$PMF_LANG['ad_categ_transalready'] = 'Già tradotta in: ';
$PMF_LANG['ad_categ_deletealllang'] = 'Cancellare in tutte le lingue?';
$PMF_LANG['ad_categ_deletethislang'] = 'Cancellare solo questa lingua?';
$PMF_LANG['ad_categ_translated'] = 'La categoria è stata tradotta.';
$PMF_LANG['msgCategoryMatrix'] = 'Sommario';
$PMF_LANG['ad_menu_categ_structure'] = 'Sommario delle Categorie e delle lingue presenti';
$PMF_LANG['ad_entry_userpermission'] = 'Permessi dell\'utente:';
$PMF_LANG['ad_entry_grouppermission'] = 'Permessi del gruppo:';
$PMF_LANG['ad_entry_all_users'] = 'Accesso per tutti gli utenti';
$PMF_LANG['ad_entry_restricted_users'] = 'Accesso ristretto a';
$PMF_LANG['ad_entry_all_groups'] = 'Accesso per tutti i gruppi';
$PMF_LANG['ad_entry_restricted_groups'] = 'Accesso ristretto a';
$PMF_LANG['ad_session_expiration'] = 'La sessione scadrà entro';
$PMF_LANG['ad_user_active'] = 'attivo';
$PMF_LANG['ad_user_blocked'] = 'bloccato';
$PMF_LANG['ad_user_protected'] = 'protetto';
$PMF_LANG['ad_entry_intlink'] = 'Seleziona una FAQ per aggiungerla come link...';
$PMF_LANG['ad_categ_paste2'] = 'Incolla dopo';
$PMF_LANG['msgCategoryRemark_overview'] = 'Viene mostrato l\'ordine corretto delle categorie se sono state definite tutte le categorie per la lingua corrente (vedi prima colonna).';
$PMF_LANG['msgUsersOnline'] = '%d Ospiti e %d Registrati';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Cancella immediatamente i dati più vecchi di 30 giorni';
$PMF_LANG['ad_adminlog_delete_success'] = 'I dati sono stati cancellati.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'I dati non sono stati cancellati: si è verificato un errore.';
$PMF_LANG['ad_quicklinks'] = 'Links veloci';
$PMF_LANG['ad_quick_category'] = 'Aggiungi una nuova categoria';
$PMF_LANG['ad_quick_record'] = 'Aggiungi una nuova FAQ';
$PMF_LANG['ad_quick_user'] = 'Aggiungi un nuovo utente';
$PMF_LANG['ad_quick_group'] = 'Aggiungi un nuovo gruppo';
$PMF_LANG['msgNewTranslationHeader'] = 'Proposta per una traduzione';
$PMF_LANG['msgNewTranslationAddon'] = 'La tua proposta non sarà pubblicata immediatamente ma sarà pubblicata dall\'amministratore dopo la sua validazione.<br>I campi richiesti sono il <strong>tuo Nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>categoria</strong>, la <strong>traduzione del titolo</strong> e la <strong>traduzione del testo</strong> della faq.<br>Ricordati di separare le parole chiave con lo spazio.';
$PMF_LANG['msgNewTransSourcePane'] = 'FaqHelper originale';
$PMF_LANG['msgNewTranslationPane'] = 'La tua traduzione';
$PMF_LANG['msgNewTranslationName'] = 'Il tuo nome:';
$PMF_LANG['msgNewTranslationMail'] = 'Il tuo indirizzo email:';
$PMF_LANG['msgNewTranslationKeywords'] = 'Parole chiave:';
$PMF_LANG['msgNewTranslationSubmit'] = 'Invia la tua proposta';
$PMF_LANG['msgTranslate'] = 'Proponi una traduzione per';
$PMF_LANG['msgTranslateSubmit'] = 'Inizia a tradurre...';
$PMF_LANG['msgNewTranslationThanks'] = 'Grazie per aver proposto la tua traduzione!';
$PMF_LANG['permission::addgroup'] = 'Aggiunge gruppi';
$PMF_LANG['permission::editgroup'] = 'Modifica gruppi';
$PMF_LANG['permission::delgroup'] = 'Cancella gruppi';
$PMF_LANG['ad_news_link_parent'] = 'Il link si apre nella finestra padre';
$PMF_LANG['ad_menu_comments'] = 'Commenti';
$PMF_LANG['adminHeaderComments'] = 'Amministrazione dei commenti';
$PMF_LANG['msgAdminCommentFaqs'] = 'Commenti introdotti nelle FAQ:';
$PMF_LANG['msgAdminCommentNews'] = 'Commenti introdotti nelle Notizie:';
$PMF_LANG['ad_groups'] = 'Gruppi';
$LANG_CONF['records.orderby'] = array('select', 'Ordinamento delle FAQ (voce)');
$LANG_CONF['records.sortby'] = array('select', 'Ordinamento delle FAQ (decrescente o crescente)');
$PMF_LANG['ad_conf_order_id'] = 'Identificativo (predefinito)';
$PMF_LANG['ad_conf_order_thema'] = 'Titolo';
$PMF_LANG['ad_conf_order_visits'] = 'Numero di visitatori';
$PMF_LANG['ad_conf_order_updated'] = 'Data';
$PMF_LANG['ad_conf_order_author'] = 'Autore';
$PMF_LANG['ad_conf_desc'] = 'Decrescente';
$PMF_LANG['ad_conf_asc'] = 'Crescente';
$PMF_LANG['mainControlCenter'] = 'Configurazione principale';
$PMF_LANG['recordsControlCenter'] = 'Configurazione delle FAQ';
$LANG_CONF['records.defaultActivation'] = array("checkbox", "Attiva le nuove faq (predefinito: disattivato)");
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", "Permetti i commenti per le nuove faq (predefinito: non permesso)");
$PMF_LANG['msgAllCatArticles'] = 'FAQ in questa categoria';
$PMF_LANG['msgTagSearch'] = 'Ricerca tramite Tags';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Info';
$PMF_LANG['msgOnlineVersionCheck'] = 'Verifica della versione (richiede la connessione alla rete)';
$PMF_LANG['ad_system_info'] = 'Informazioni di sistema';
$PMF_LANG['msgRegisterUser'] = 'Vuoi registrarti?';
$PMF_LANG['msgUsername'] = 'Pseudonimo:';
$PMF_LANG['errorRegistration'] = 'Questo campo è necessario!';
$PMF_LANG['submitRegister'] = 'Registrati';
$PMF_LANG['msgUserData'] = 'Informazioni richieste per la registrazione';
$PMF_LANG['captchaError'] = 'Inserisci il <strong>codice <a href="https://it.wikipedia.org/wiki/Captcha" title="Vai alla definizione di Wikipedia" target="_blank">captcha</a> corretto</strong>!';
$PMF_LANG['msgRegError'] = 'Questi gli errori trovati, correggili:';
$PMF_LANG['successMessage'] = 'La tua registrazione è stata effettuata! Riceverai una email di conferma con i tuoi dati di accesso dopo l\'approvazione!';
$PMF_LANG['msgRegThankYou'] = 'Grazie per esserti registrato';
$PMF_LANG['emailRegSubject'] = '[%sitename%] Registrazione nuovo utente';
$PMF_LANG['msgMostPopularSearches'] = 'Le ricerche più popolari sono:';
$LANG_CONF['main.enableWysiwygEditor'] = array('checkbox', 'Abilita l\'editor WYSIWYG preinstallato (predefinito: abilitato)');
$PMF_LANG['ad_menu_searchstats'] = 'Statistiche sulla ricerca';
$PMF_LANG['ad_searchstats_search_term'] = 'Chiave';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Incidenza';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Lingua';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Percentuale';
$PMF_LANG['ad_record_sticky'] = 'Sticky';
$PMF_LANG['ad_entry_sticky'] = 'Sticky';
$PMF_LANG['stickyRecordsHeader'] = 'Sticky FAQs';
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Parole comuni (stop words)';
$PMF_LANG['ad_config_stopword_input'] = 'Aggiungi una nuova parola comune (stop word)';
$PMF_LANG['msgSendMailDespiteEverything'] = 'Non c\'&grave; ancora una risposta adeguata (sar&grave; inviata una email)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'La risposta desiderata &grave; indicata nella lista di cui sopra?';
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Scegli la lingua da tradurre';
$PMF_LANG['ad_menu_translations'] = 'Interfaccia per le traduzioni';
$PMF_LANG['ad_start_notactive'] = 'In attesa di attivazione';
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Aggiungi nuova traduzione';
$PMF_LANG['msgTransToolLanguage'] = 'Lingua';
$PMF_LANG['msgTransToolActions'] = 'Azioni';
$PMF_LANG['msgTransToolWritable'] = 'Modificabile';
$PMF_LANG['msgEdit'] = 'Modifica';
$PMF_LANG['msgDelete'] = 'Elimina';
$PMF_LANG['msgYes'] = 'si';
$PMF_LANG['msgNo'] = 'no';
$PMF_LANG['msgVariable'] = 'Variabile';
$PMF_LANG['msgCancel'] = 'Annulla';
$PMF_LANG['msgSave'] = 'Salva';
$PMF_LANG['msgSaving3Dots'] = 'salvataggio in corso ...';
$PMF_LANG['msgRemoving3Dots'] = 'rimozione in corso ...';
$PMF_LANG['msgLanguage'] = 'Lingua';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Set Caratteri Lingua';
$PMF_LANG['msgTransToolLanguageDir'] = 'Direzione Lingua';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Descrizione Lingua';
$PMF_LANG['msgTransToolAddAuthor'] = 'Aggiungi autore';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Crea Traduzione';
$PMF_LANG['msgTransToolTransCreated'] = 'Nuova traduzione creata con successo';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Impossibile creare nuova traduzione';
$PMF_LANG['msgAdding3Dots'] = 'aggiunta in corso ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'Invia al team phpMyFAQ';
$PMF_LANG['msgSending3Dots'] = 'invio in corso ...';
$PMF_LANG['msgTransToolFileSent'] = 'File della lingua inviato con successo al team phpMyFAQ. Grazie mille per aver condiviso.';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'Errore inviando il file della lingua';
$PMF_LANG['msgTransToolPercent'] = 'Percentuale';
$PMF_LANG['msgAttachmentNotFound'] = 'The file you\'re trying to download was not found on this server';
$PMF_LANG['ad_sess_noentry'] = 'No entry';
$PMF_LANG['plmsgUserOnline']['0'] = '%d Utente online';
$PMF_LANG['plmsgUserOnline']['1'] = '%d Utenti online';
$LANG_CONF['records.attachmentsPath'] = array('input', 'Percorso dove verranno salvati gli allegati.<br><small>Il percorso relativo deve essere una cartella all\'interno della root</small>');
$PMF_LANG['securityControlCenter'] = 'Configurazione di sicurezza';
$PMF_LANG['ad_search_delsuc'] = 'Il termine cercato è stato eliminato correttamente.';
$PMF_LANG['ad_search_delfail'] = 'Il termine cercato non è stato eliminato.';
$PMF_LANG['msg_about_faq'] = 'Riguardo questa FAQ';
$PMF_LANG['msgTableOfContent'] = 'Tabella del Contenuto';
$PMF_LANG['msgExportAllFaqs'] = 'Stampa tutto come PDF';
$PMF_LANG['msgOnlineVerificationCheck'] = 'Verifica di controllo Online';
$PMF_LANG['msgOnlineVerificationCheckButton'] = 'Clicca per verificare la tua installazione di phpMyFAQ';
$PMF_LANG['ad_verification_notokay'] = 'La tua versione di phpMyFAQ ha modifiche locali:';
$PMF_LANG['ad_verification_okay'] = 'La tua versione di phpMyFAQ è stata verificata correttamente.';
$PMF_LANG['cacheControlCenter'] = 'Configurazione della cache';
$PMF_LANG['msgAdminSearchFaqs'] = 'Cerca per FAQ';
$PMF_LANG['msg2answerFAQ'] = 'Risposto';
$PMF_LANG['headerUserControlPanel'] = 'Pannello di controllo dell\'utente';
$PMF_LANG['rememberMe'] = 'Ricordami';
$PMF_LANG['ad_menu_instances'] = 'FAQ Multi-sito';
$PMF_LANG['ad_record_inactive'] = 'FAQ inattiva';
$PMF_LANG['msgMode'] = 'Modi';
$PMF_LANG['msgMaintenanceMode'] = 'FAQ in manutenzione';
$PMF_LANG['msgOnlineMode'] = 'FAQ online';
$LANG_CONF['security.enableLoginOnly'] = array('checkbox', 'Complete secured FAQ (default: deactivated)');
$LANG_CONF['security.useSslOnly'] = array('checkbox', 'FAQ solo con SSL (default: disattivato)');
$LANG_CONF['cache.varnishEnable'] = array('checkbox', 'Abilita Varnish >=3.0 supporto<br><small>Devi avere l\'estensione varnish PECL </small>');
$LANG_CONF['cache.varnishHost'] = array('input', 'Varnish host');
$LANG_CONF['cache.varnishPort'] = array('input', 'Varnish port');
$LANG_CONF['cache.varnishSecret'] = array('input', 'Varnish secret');
$LANG_CONF['cache.varnishTimeout'] = array('input', 'Varnish timeout');
$LANG_CONF['records.enableCloseQuestion'] = array('checkbox', 'Chiudi le domande aperte dopo aver risposto?');
$LANG_CONF['records.enableDeleteQuestion'] = array('checkbox', 'Elimino le domande aperte dopo aver risposto?');
$LANG_CONF['main.maintenanceMode'] = array('checkbox', 'Imposta FAQ in modalità manutenzione');
$PMF_LANG['msgShowMore'] = 'vedi altro';
$PMF_LANG['msgQuestionAnswered'] = 'Domanda con risposta';
$PMF_LANG['msgMessageQuestionAnswered'] = 'La tua domanda su %s ha ricevuto una risposta. Controlla qui:';
$PMF_LANG['ad_stopwords_desc'] = 'Seleziona una lingua a cui aggiungere o modificare parole da bloccare.';
$PMF_LANG['ad_visits_per_day'] = 'Visite per giorno';
$PMF_LANG['ad_instance_add'] = 'Aggiungi una nuova istanza multi sito di phpMyFAQ';
$PMF_LANG['ad_instance_error_notwritable'] = 'La cartella /multisite non è scrivibile.';
$PMF_LANG['ad_instance_url'] = 'Esempio URL';
$PMF_LANG['ad_instance_path'] = 'Esempio path';
$PMF_LANG['ad_instance_name'] = 'Esempio nome';
$PMF_LANG['ad_instance_email'] = 'Tua email admin';
$PMF_LANG['ad_instance_admin'] = 'Nome Login Admin';
$PMF_LANG['ad_instance_password'] = 'Password Admin';
$PMF_LANG['ad_instance_hint'] = 'Attenzione: Ci vorranno alcuni secondi per creare una nuova istanza phpMyFAQ!';
$PMF_LANG['ad_instance_button'] = 'Save istanza';
$PMF_LANG['ad_instance_error_cannotdelete'] = 'Impossibile eliminare istanza';
$PMF_LANG['ad_instance_config'] = 'Configurazione istanza';
$PMF_LANG['msgAboutThisNews'] = 'Riguardo questa news';
$PMF_LANG['msgAccessDenied'] = 'Accesso negato.';
$PMF_LANG['msgSeeFAQinFrontend'] = 'Vedi FAQ in lato pubblico';
$LANG_CONF['records.randomSort'] = array('checkbox');
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array('checkbox', 'Abilita forzatamente WYSIWYG editor in lato pubblico (default: disattivato)');
$LANG_CONF['main.enableGravatarSupport'] = array('checkbox', 'Supporto Gravatar (default: disattivato)');
$PMF_LANG['plmsgHomeArticlesOnline']['0'] = 'C\'è %d FAQ online';
$PMF_LANG['plmsgHomeArticlesOnline']['1'] = 'Ci sono %d FAQ online';
$PMF_LANG['plmsgViews']['0'] = '%d visita';
$PMF_LANG['plmsgViews']['1'] = '%d visite';
$PMF_LANG['plmsgGuestOnline']['0'] = '%d Ospite';
$PMF_LANG['plmsgGuestOnline']['1'] = '%d Ospiti';
$PMF_LANG['plmsgRegisteredOnline']['0'] = ' e %d Registrato';
$PMF_LANG['plmsgRegisteredOnline']['1'] = ' e %d Registrati';
$PMF_LANG['plmsgSearchAmount']['0'] = '%d risultato di ricerca';
$PMF_LANG['plmsgSearchAmount']['1'] = '%d risultati di ricerca';
$PMF_LANG['plmsgPagesTotal']['0'] = ' %d Pagina';
$PMF_LANG['plmsgPagesTotal']['1'] = ' %d Pagine';
$PMF_LANG['plmsgVotes']['0'] = '%d Voto';
$PMF_LANG['plmsgVotes']['1'] = '%d Voti';
$PMF_LANG['plmsgEntries']['0'] = '%d FAQ';
$PMF_LANG['plmsgEntries']['1'] = '%d FAQ';
$PMF_LANG['permission::addtranslation'] = 'aggiungi traduzione';
$PMF_LANG['permission::edittranslation'] = 'modifica traduzione';
$PMF_LANG['permission::deltranslation'] = 'elimina traduzione';
$PMF_LANG['permission::approverec'] = 'approva records';
$PMF_LANG['ad_menu_upgrade'] = 'phpMyFAQ Aggiorna';
$PMF_LANG['ad_you_shouldnt_update'] = 'Hai l\'ultima versione di phpMyFAQ. Non hai bisogno di aggiornare.';
$PMF_LANG['msgSecureSwitch'] = 'Passa al login in modo sicuro!';
$LANG_CONF['layout.templateSet'] = array('select', 'Template impostato per essere usato');
$LANG_CONF['records.enableAttachmentEncryption'] = array('checkbox', 'Enable attachment encryption <br><small>Ignored when attachments is disabled</small>');
$LANG_CONF['records.defaultAttachmentEncKey'] = array('input', 'Default attachment encryption key <br><small>Ignored if attachment encryption is disabled</small><br><small><font color="red">WARNING: Do not change this once set and enabled file encryption!!!</font></small>');
$LANG_CONF['security.useSslForLogins'] = array('checkbox', 'Only allow logins over SSL connection? (default: disabled)');
$PMF_LANG['ad_menu_attachments'] = 'Allegati FAQ';
$PMF_LANG['ad_menu_attachment_admin'] = 'Amministrazione Allegati';
$PMF_LANG['msgAttachmentsFilename'] = 'Nome del file';
$PMF_LANG['msgAttachmentsFilesize'] = 'Dimensione del file';
$PMF_LANG['msgAttachmentsMimeType'] = 'Tipo MIME';
$PMF_LANG['msgAttachmentsWannaDelete'] = 'Sicuro di voler eliminare questo allegato?';
$PMF_LANG['msgAttachmentsDeleted'] = 'Allegato <strong>correttamente</strong> eliminato.';
$PMF_LANG['ad_menu_reports'] = 'Segnalazione';
$PMF_LANG['ad_stat_report_fields'] = 'Campi';
$PMF_LANG['ad_stat_report_category'] = 'Categoria';
$PMF_LANG['ad_stat_report_sub_category'] = 'Sottocategoria';
$PMF_LANG['ad_stat_report_translations'] = 'Traduzioni';
$PMF_LANG['ad_stat_report_language'] = 'Lingue';
$PMF_LANG['ad_stat_report_id'] = 'ID FAQ';
$PMF_LANG['ad_stat_report_sticky'] = 'FAQ Adesiva';
$PMF_LANG['ad_stat_report_title'] = 'Domanda';
$PMF_LANG['ad_stat_report_creation_date'] = 'Data';
$PMF_LANG['ad_stat_report_owner'] = 'Autore originale';
$PMF_LANG['ad_stat_report_last_modified_person'] = 'Ultimo autore';
$PMF_LANG['ad_stat_report_url'] = 'URL';
$PMF_LANG['ad_stat_report_visits'] = 'Visite';
$PMF_LANG['ad_stat_report_make_report'] = 'Genera Report';
$PMF_LANG['ad_stat_report_make_csv'] = 'Esporta in CSV';
$PMF_LANG['msgRegistration'] = 'Registrazione';
$PMF_LANG['msgRegistrationCredentials'] = 'Per registrarti inserisci il tuo nome, il tuo username e un indirizzo email!';
$PMF_LANG['msgRegistrationNote'] = 'Dopo la registrazione riceverete una risposta appena un amministratore la renderà attiva.';
$PMF_LANG['ad_entry_changelog_history'] = 'Storico Changelog';
$LANG_CONF['security.ssoSupport'] = array('checkbox', 'Supporto Single Sign On (default: disattivato)');
$LANG_CONF['security.ssoLogoutRedirect'] = array('input', 'Single Sign On logout redirect service URL');
$LANG_CONF['main.dateFormat'] = array('input', 'Formato Data (default: Y-m-d H:i)');
$PMF_LANG['msgTransToolNoteFileSaving'] = 'Nota che nessun file verrà scritto finche non cliccherai sul bottone per salvare';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'Buffer pagina %d registrato correttamente';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'Errore nel registrare il buffer della pagina %d';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'Registrazione buffer pagina %d';
$PMF_LANG['ad_record_active'] = 'Attivo';
$PMF_LANG['msgAttachmentInvalid'] = 'Allegato non valido, informa un amministratore';
$PMF_LANG['list_all_users'] = 'Elenca tutti gli utenti';
$PMF_LANG['records.orderingPopularFaqs.visits'] = 'ordina le più viste';
$PMF_LANG['records.orderingPopularFaqs.voting'] = 'ordina le più votate';
$PMF_LANG['msgShowHelp'] = 'Separa le parole con la virgola.';
$PMF_LANG['msgUpdateFaqDate'] = 'aggiorna';
$PMF_LANG['msgKeepFaqDate'] = 'tieni';
$PMF_LANG['msgEditFaqDat'] = 'modifica';
$PMF_LANG['searchControlCenter'] = 'Cerca';
$PMF_LANG['search.relevance.thema-content-keywords'] = 'Domanda - Risposta - Keywords';
$PMF_LANG['search.relevance.thema-keywords-content'] = 'Domanda - Keywords - Risposta';
$PMF_LANG['search.relevance.content-thema-keywords'] = 'Risposta - Domanda - Keywords';
$PMF_LANG['search.relevance.content-keywords-thema'] = 'Risposta - Keywords - Domanda';
$PMF_LANG['search.relevance.keywords-content-thema'] = 'Keywords - Risposta - Domanda';
$PMF_LANG['search.relevance.keywords-thema-content'] = 'Keywords - Domanda - Risposta';
$PMF_LANG['msgLoginUser'] = 'Accedi';
$LANG_CONF['search.numberSearchTerms'] = array('input', 'Numero di termini di ricerca inseriti');
$LANG_CONF['records.orderingPopularFaqs'] = array('select', 'Sorting of the top FAQ');
$LANG_CONF['search.useAjaxSearchOnStartpage'] = array('checkbox', 'Risposta Istantanea su pagina iniziale (default: disattivato)');
$LANG_CONF['search.relevance'] = array('select', 'Ordina per importanza');
$LANG_CONF['search.enableRelevance'] = array('checkbox', 'Attivare supporto importanza? (default: disattivo)');

return $PMF_LANG;
